#!/usr/bin/false
# $Header: /code/convert/cvsroot/infrastructure/diradm/src/diradm.user.sh.in,v 1.28 2007/03/30 10:44:10 robbat2 Exp $
# vim: ts=4 sts=4 noexpandtab sw=4 ft=sh syntax=sh:
# This contains all of the functions specific to the user sub-system.

useradd() {
	[ -z "${modulename}" ] && modulename="useradd"
	unset OPTION OPTARG OPTIND
	while getopts "u:og:G:h:d:s:rRc:mk:f:e:E:p:Si" OPTION; do
		case "${OPTION}" in
			u) UIDNUMBER="${OPTARG}";;
			o) DUPLICATES="yes";;
			g) GID="${OPTARG}";;
			G) OTHERGROUPS="${OPTARG}";;
			h) HOSTLIST="${OPTARG}";;
			d) HOMEDIRECTORY="${OPTARG}";;
			s) LOGINSHELL="${OPTARG}";;
			r) USERGROUPS="yes";;
			R) USERGROUPS="no";;
			c) COMMENT="${OPTARG}";;
			m) CREATEHOMEDIR="yes";;
			k) SKEL="${OPTARG}";;
			f) SHADOWINACTIVE="${OPTARG}";;
			e) SHADOWEXPIRE="${OPTARG}";;
			E) EMAIL="${OPTARG}";;
			p) userPassword_Plain="${OPTARG}";;
			S) [ "x$ENABLE_SAMBA" == "xyes" ] && SAMBA="yes";;
			i) [ "x$ENABLE_IRIXPASSWD" == "xyes" ] && IRIX="yes";;
			*) print_usage ${modulename} ; exit 1;;
		esac
	done
	shift $((${OPTIND} - 1))
	if [ "${#}" -ne 1 ]; then
		print_usage ${modulename}
		exit 2
	else
		LOGIN="${1}"
	fi
	echo "${LOGIN}" | ${GREP} -qs "^[[:alnum:]\._\-]*$"
	if [ "$?" -ne 0 ]; then
		echo "${modulename}: Invalid user name \"${LOGIN}\""
		exit 3
	else
		search_user "uid" "${LOGIN}"
		if [ "$?" -eq 0 ]; then
			echo "${modulename}: User \"${LOGIN}\" exists"
			exit 9
		fi
	fi
	if [ -n "${UIDNUMBER}" ]; then
		echo "${UIDNUMBER}" | ${GREP} -qs "^[[:digit:]]*$"
		if [ "$?" -ne 0 ]; then
			echo "${modulename}: Invalid numeric argument \"${UIDNUMBER}\""
			exit 3
		fi
		search_user "uidNumber" "${UIDNUMBER}"
		if [ "$?" -eq 0 -a "${DUPLICATES}" != "yes" ]; then
			echo "${modulename}: uid ${UIDNUMBER} is not unique"
			exit 4
		fi
	else
		UIDNUMBER="$(usernextfreeuid)"
		[ -z "${UIDNUMBER}" ] && UIDNUMBER="${UIDNUMBERMIN}"
		if [ "${UIDNUMBER}" -gt "${UIDNUMBERMAX}" ]; then
			echo "${modulename}: Can't get unique uid"
			exit 4
		fi
	fi
	if [ -n "${GID}" ]; then
		echo "${GID}" | ${GREP} -qs "^[[:digit:]]*$"
		if [ "$?" -eq 0 ]; then
			GIDNUMBER="${GID}"
		else
			GIDNUMBER="$(ldap_search_getattr "${GROUP_BASEDN}" "cn=${GID}" gidNumber)"
			if [ -z "${GIDNUMBER}" ]; then
				echo "${modulename}: Unknown group \"${GID}\""
				exit 6
			fi
		fi
		if [ "$USERGROUPS" == "yes" ]; then
			echo "${modulename}: Warning! Group ${GID} specified AND in RedHat User-Group mode!. Using GID instead."
		fi
	else
		if [ "$USERGROUPS" == "no" ]; then
			GIDNUMBER="${DEFAULT_GIDNUMBER}"
		else
			# that evil redhat thing of a group for every user
			## TODO: TEST THIS
			search_group "cn" "${LOGIN}"
			rc1=$?
			search_group_files "cn" "${LOGIN}"
			rc2=$?
			if [ "$rc1" -eq 0 -o "$rc2" -eq 0 ]; then
				echo "${modulename}: Group '${LOGIN}' already exists!"
				echo "Pass -R to useradd to disable USERGROUPS usage."
				echo "And add the user to a group afterwards."
				exit 9
			fi
			# recursive, but bring in the code first
			source ${libexecdir}/diradm.group.sh
			groupadd -- "${LOGIN}"
			if [ "$?" -ne 0 ]; then
				echo "${modulename}: Failed to add group '${LOGIN}'."
				exit 9
			fi
			GIDNUMBER="$(ldap_search_getattr "${GROUP_BASEDN}" "cn=${LOGIN}" gidNumber)"
		fi
	fi
	search_group "gidNumber" "${GIDNUMBER}"
	rc1=$?
	search_group_files "gidNumber" "${GIDNUMBER}"
	rc2=$?
	if [ "$rc1" -ne 0 -a "$rc2" -ne 0 ]; then
		echo "${modulename}: Warning! Group ${GIDNUMBER} not found. Adding user anyway."
	fi
	if [ -n "${OTHERGROUPS}" ]; then
		OTHERGROUPS="${OTHERGROUPS//,/ }"
		for POSIXGROUP in ${OTHERGROUPS}; do
			echo "${POSIXGROUP}" | ${GREP} -qs "^[[:digit:]]*$"
			if [ "$?" -eq 0 ]; then
				search_group "gidNumber" "${POSIXGROUP}"
				rc1=$?
				search_group_files "gidNumber" "${POSIXGROUP}"
				rc2=$?
				if [ "$rc1" -ne 0 -a "$rc2" -ne 0 ]; then
					echo "${modulename}: Unknown group \"${POSIXGROUP}\""
					exit 6
				fi
				if [ "$rc1" -ne 0 -a "$rc2" -eq 0 ]; then
					echo "${modulename}: Group \"${POSIXGROUP}\" is not LDAP based, you must add the user elsewhere."
					continue
				fi
				POSIXGROUP="$(ldap_search_getattr "${GROUP_BASEDN}" "gidNumber=${POSIXGROUP}" cn)"
				ADDTOGROUPS="${ADDTOGROUPS} ${POSIXGROUP}"
			else
				search_group "cn" "${POSIXGROUP}"
				rc1=$?
				search_group_files "cn" "${POSIXGROUP}"
				rc2=$?
				if [ "$rc1" -ne 0 -a "$rc2" -ne 0 ]; then
					echo "${modulename}: Unknown group \"${POSIXGROUP}\""
					exit 6
				fi
				if [ "$rc1" -ne 0 -a "$rc2" -eq 0 ]; then
					echo "${modulename}: Group \"${POSIXGROUP}\" is not LDAP based, you must add the user elsewhere."
					continue
				fi
				ADDTOGROUPS="${ADDTOGROUPS} ${POSIXGROUP}"
			fi
		done
	fi
	if [ -n "${HOSTLIST}" ]; then
		HOSTLIST="${HOSTLIST//,/ }"
		for HOST in ${HOSTLIST}; do
			HOSTS="${HOSTS}host: ${HOST}\n"
		done
		HOSTS="$(echo -e "${HOSTS}")"
	fi
	[ -z "${HOMEDIRECTORY}" ] && HOMEDIRECTORY="${HOMEBASE}/${LOGIN}"
	echo "${HOMEDIRECTORY}" | ${GREP} -qs "^/"
	if [ "$?" -ne 0 ]; then
		echo "${modulename}: Invalid home directory \"${HOMEDIRECTORY}\""
		exit 3
	fi
	[ -z "${LOGINSHELL}" ] && LOGINSHELL="${DEFAULT_LOGINSHELL}"
	echo "${LOGINSHELL}" | ${GREP} -qs "^/"
	if [ "$?" -ne 0 ]; then
		echo "${modulename}: Invalid shell \"${LOGINSHELL}\""
		exit 3
	fi
	[ -z "${COMMENT}" ] && COMMENT="${LOGIN},,,"
	if [ -n "${HOMEDIRECTORY}" -a "${CREATEHOMEDIR}" == "yes" ]; then
		if [ "${UID}" -ne "0" ]; then
			echo "${modulename}: Only root may create home directories"
			exit 12
		fi
		PARENTDIR="$(dirname "${HOMEDIRECTORY}")"
		if [ ! -w "${PARENTDIR}" ]; then
			echo "${modulename}: Cannot create directory \"${HOMEDIRECTORY}\""
			exit 12
		fi
	fi
	[ -z "${SHADOWINACTIVE}" ] && SHADOWINACTIVE="${DEFAULT_SHADOWINACTIVE}"
	if [ "${SHADOWINACTIVE}" != "-1" ]; then
		echo "${SHADOWINACTIVE}" | ${GREP} -qs "^[[:digit:]]*$"
		if [ "$?" -ne 0 ]; then
			echo "${modulename}: Invalid numeric argument \"${SHADOWINACTIVE}\""
			exit 3
		fi
	fi
	[ -z "${SHADOWEXPIRE}" ] && SHADOWEXPIRE="${DEFAULT_SHADOWEXPIRE}"
	if [ "${SHADOWEXPIRE}" != "-1" ]; then
		echo "${SHADOWEXPIRE}" | ${GREP} -qs "^[[:digit:]]\{4\}-[[:digit:]]\{2\}-[[:digit:]]\{2\}$"
		if [ "$?" -ne 0 ]; then
			echo "${modulename}: Invalid date \"${SHADOWEXPIRE}\""
			exit 3
		else
			SHADOWEXPIRE="$(date_to_days "${SHADOWEXPIRE}")"
		fi
	fi
	# Set this to today's date
	# This is N days since Jan 1, 1970
	SHADOWLASTCHANGE="$(daysnow)"

	# Users Full Name
	FULLNAME="$(echo ${COMMENT} | ${CUT} -d, -f1)"
	ROOMNUMBER="$(echo ${COMMENT} | ${CUT} -d, -f2)"
	WORKPHONE="$(echo ${COMMENT} | ${CUT} -d, -f3)"
	HOMEPHONE="$(echo ${COMMENT} | ${CUT} -d, -f4)"
	FIRSTNAME="${FULLNAME// *}"
	SURNAME="${FULLNAME##* }"
	CN="${FIRSTNAME}"

	# Setup the commands
	append "dn: uid=${LOGIN},${USER_BASEDN}"
	append "changetype: add"
	append "objectClass: top"
	#append "objectClass: account"
	append "objectClass: posixAccount"
	append "objectClass: shadowAccount"
	append "objectClass: organizationalPerson"
	append "objectClass: inetOrgperson"
	append "uid: ${LOGIN}"
	# impossible passwords
	userPassword_Crypt='$1$i4iLNNDN$2hEIZ6f5qgBBQfTuxtI4P1' 
	userPassword_SambaNT='00000000000000000000000000000000'
	userPassword_SambaLM='00000000000000000000000000000000'
	userPassword_Irix='KeZ0hbbaVDnSU'
	# now set the real password
	if [ -n "${userPassword_Plain}" ]; then
		userPassword_Crypt="$(${MKPASSWD} -m ${userPassword_Plain})"
		userPassword_Irix="$(${MKPASSWD} -i ${userPassword_Plain})"
		if [ "x${SAMBA}" == "xyes" ]; then
			userPassword_SambaNT="$(${MKPASSWD} -n ${userPassword_Plain})"
			userPassword_SambaLM="$(${MKPASSWD} -l ${userPassword_Plain})"
		fi
	fi
	append "userPassword:: $(ldap_base64_encode "{CRYPT}${userPassword_Crypt}")"
	append "uidNumber: ${UIDNUMBER}"
	append "gidNumber: ${GIDNUMBER}"
	append "cn: ${CN}"
	append "homeDirectory: ${HOMEDIRECTORY}"
	append "loginShell: ${LOGINSHELL}"
	append "shadowLastChange: ${SHADOWLASTCHANGE}"
	append "shadowInactive: ${SHADOWINACTIVE}"
	append "shadowExpire: ${SHADOWEXPIRE}"
	append "shadowMin: ${SHADOWMIN}"
	append "shadowMax: ${SHADOWMAX}"
	append "shadowWarning: ${SHADOWWARNING}"
	append "shadowFlag: ${SHADOWFLAG}"
	[ -n "${HOSTS}" ] && append "${HOSTS}"
	[ -n "${SURNAME}" ] && append "sn: ${SURNAME}"
	[ -n "${FIRSTNAME}" ] && append "givenName: ${FIRSTNAME}"
	[ -n "${FULLNAME}" ] && append "displayName: ${FULLNAME}"
	[ -n "${ROOMNUMBER}" ] && append "roomNumber: ${ROOMNUMBER}"
	[ -n "${HOMEPHONE}" ] && append "homePhone: ${HOMEPHONE}"
	[ -n "${WORKPHONE}" ] && append "telephoneNumber: ${WORKPHONE}"
	if [ -n "${EMAIL}" ]; then
		# this is a custom objectclass!
		#append "objectClass: userInformation"
		#append "email: ${EMAIL}"
		
		# alternative approach
		append "mail: ${EMAIL}"
	fi
	append "gecos: ${COMMENT}"

	if [ "x${SAMBA}" == "xyes" -a -n "${SAMBADOMAINSID}" ]; then
		append "objectClass: sambaSamAccount"

		let RID="2*${UIDNUMBER}+1000"
		SID="${SAMBADOMAINSID}-${RID}" 

		append "sambaSID: ${SID}"
		append "sambaPrimaryGroupSID: ${SAMBADOMAINSID}-${DEFAULT_SAMBAGID}"
		append "sambaAcctFlags: [UX         ]"
		append "sambaPwdCanChange: 0"
		append "sambaNTPassword:: $(ldap_base64_encode "${userPassword_SambaNT}")"
		append "sambaLMPassword:: $(ldap_base64_encode "${userPassword_SambaLM}")"
		append "sambaPwdLastSet: $(${DATE} -u +%s)";
		[ -n "${SAMBADRIVE}" ] && append "sambaHomeDrive: ${SAMBADRIVE}"
		[ -n "${SAMBAPATHPREPEND}" ] && append "sambaHomePath: ${SAMBAPATHPREPEND}\\\\${LOGIN}"
		[ -n "${SAMBAPROFILEPREPEND}" ] && append "sambaProfilePath: ${SAMBAPROFILEPREPEND}\\\\${LOGIN}"
		[ -n "${SAMBALOGONSCRIPT}" ] && append "sambaLogonScript: ${SAMBALOGONSCRIPT}"
	fi
	if [ "x${IRIX}" == "xyes" ]; then
		# this is a custom objectclass!
		append "objectClass: irixAccount"
		append "irixPassword:: $(ldap_base64_encode "{CRYPT}${userPassword_Irix}")"
	fi
	append "\n\n"
	
	# group stuff	
	if [ -n "${ADDTOGROUPS}" ]; then
		DELETEFROMGROUPS="$(ldap_search_getattr "${GROUP_BASEDN}" "memberUid=${LOGIN}" cn)"
		for POSIXGROUP in ${DELETEFROMGROUPS}; do
			append "dn: cn=${POSIXGROUP},${GROUP_BASEDN}"
			append "delete: memberUid"
			append "memberUid: ${LOGIN}\n"
		done
		for POSIXGROUP in ${ADDTOGROUPS}; do
			append "dn: cn=${POSIXGROUP},${GROUP_BASEDN}"
			append "add: memberUid"
			append "memberUid: ${LOGIN}\n"
		done
	fi

	# add user
	#echo -e "${COMMAND}"
	runmodify
	
	if [ "${CREATEHOMEDIR}" == "yes" ]; then
		# Create Homedir
		# make sure the functions are defined
		if [ "$ENABLE_AUTOMOUNT" == "yes" -a "${USER_AUTOMOUNTHOME}" == "yes" ]; then
			# add automount entry first
			# create hashed dir path
			source ${libexecdir}/diradm.automount.sh
			targetdir="$(amhash "${AUTOMOUNT_USERDIRBASE}" "${LOGIN}")"
			amadd -d "${AUTOMOUNT_USERDESC}" -o "${AUTOMOUNT_OPTIONS_USERS}" -- "${AUTOMOUNT_USERMAP}" "${LOGIN}" "${targetdir}"
		else
			targetdir="${HOMEDIRECTORY}"
		fi
		# strip NFS host to make local path
		targetdir_no_nfs="${targetdir/*:}"
		if [ ! -d "${HOMEDIRECTORY}" -a ! -d "${targetdir_no_nfs}" ]; then
			echo "Making Homedir stored in ${targetdir}, available as ${HOMEDIRECTORY}"
			cp -ra "${SKEL}" "${targetdir_no_nfs}" >/dev/null
			${CHMOD} "${HOMEPERM}" "${targetdir_no_nfs}"
			${CHOWN} -R "${UIDNUMBER}":"${GIDNUMBER}" "${targetdir_no_nfs}"
		else
			echo "Homedir of ${HOMEDIRECTORY} already exists from ${targetdir}!"
		fi
	fi
}

usermod() {
	[ -z "${modulename}" ] && modulename="usermod"
	if [ "${#}" -le 1 ]; then
		print_usage ${modulename}
		echo "${modulename}: No flags given"
		exit 2
	fi
	unset OPTION OPTARG OPTIND
	while getopts "u:og:G:h:d:s:c:l:mf:e:p:LUSirR" OPTION; do
		case "${OPTION}" in
			u) UIDNUMBER="${OPTARG}";;
			o) DUPLICATES="yes";;
			g) GID="${OPTARG}";;
			G) OTHERGROUPS="${OPTARG}";;
			h) HOSTLIST="${OPTARG}";;
			d) HOMEDIRECTORY="${OPTARG}";;
			s) LOGINSHELL="${OPTARG}";;
			c) COMMENT="${OPTARG}";;
			l) NEWLOGIN="${OPTARG}";;
			m) MOVEHOMEDIR="yes";;
			f) SHADOWINACTIVE="${OPTARG}";;
			e) SHADOWEXPIRE="${OPTARG}";;
			E) EMAIL="${OPTARG}";;
			r) USERGROUPS="yes";;
			R) USERGROUPS="no";;
			p) if [ -n "${LOCKED}" ]; then print_usage ${modulename} ; exit 1; fi; userPassword_Plain="${2}";;
			L) if [ -n "${LOCKED}" -o -n "${userPassword_Plain}" ]; then print_usage ${modulename}; exit 1; fi; LOCKED="yes";;
			U) if [ -n "${LOCKED}" -o -n "${userPassword_Plain}" ]; then print_usage ${modulename}; exit 1; fi; LOCKED="no";;
			S) [ "x$ENABLE_SAMBA" == "xyes" ] && SAMBA="yes";;
			i) [ "x$ENABLE_IRIXPASSWD" == "xyes" ] && IRIX="yes";;
			*) print_usage ${modulename} ; exit 1;;
		esac
	done
	shift $((${OPTIND} - 1))

	if [ "${#}" -ne 1 ]; then
		print_usage ${modulename}
		exit 2
	else
		LOGIN="${1}"
	fi

	# check that the damn user exists
	search_user "uid" "${LOGIN}"
	if [ "$?" -ne 0 ]; then
		echo "${modulename}: User \"${LOGIN}\" does not exist"
		exit 6
	fi

	# new uid number
	if [ -n "${UIDNUMBER}" ]; then
		echo "${UIDNUMBER}" | ${GREP} -qs "^[[:digit:]]*$"
		if [ "$?" -ne 0 ]; then
			echo "${modulename}: Invalid numeric argument \"${UIDNUMBER}\""
			exit 3
		fi
		search_user "uidNumber" "${UIDNUMBER}"
		if [ "$?" -eq 0 -a "${DUPLICATES}" != "yes" ]; then
			echo "${modulename}: uid ${UIDNUMBER} is not unique"
			exit 4
		fi
	fi

	# new gid
	if [ -n "${GID}" ]; then
		echo "${GID}" | ${GREP} -qs "^[[:digit:]]*$"
		if [ "$?" -eq 0 ]; then
			GIDNUMBER="${GID}"
		else
			GIDNUMBER="$(ldap_search_getattr "${GROUP_BASEDN}" "cn=${GID}" gidNumber)"
			[ -z "${GIDNUMBER}" ] && GIDNUMBER="$(getent_group_getattr "cn=${GID}" gidNumber)"
			if [ -z "${GIDNUMBER}" ]; then
				echo "${modulename}: Unknown group \"${GID}\""
				exit 6
			fi
		fi
		search_group "gidNumber" "${GIDNUMBER}"
		rc1=$?
		search_group_files "gidNumber" "${GIDNUMBER}"
		rc2=$?
		if [ "$rc1" -ne 0 -a "$rc2" -ne 0 ]; then
			echo "${modulename}: Warning! Group ${GIDNUMBER} not found. Modifying user anyway."
		fi
	fi

	# alternative groups
	if [ -n "${OTHERGROUPS}" ]; then
		OTHERGROUPS="${OTHERGROUPS//,/ }"
		for POSIXGROUP in ${OTHERGROUPS}; do
			echo "${POSIXGROUP}" | ${GREP} -qs "^[[:digit:]]*$"
			if [ "$?" -eq 0 ]; then
				search_group "gidNumber" "${POSIXGROUP}"
				rc1=$?
				search_group_files "gidNumber" "${POSIXGROUP}"
				rc2=$?
				if [ "$rc1" -ne 0 -a "$rc2" -ne 0 ]; then
					echo "${modulename}: Unknown other group number \"${POSIXGROUP}\""
					exit 6
				fi
				if [ "$rc1" -ne 0 -a "$rc2" -eq 0 ]; then
					echo "${modulename}: Group \"${POSIXGROUP}\" is not LDAP based, you must add the user elsewhere."
					continue
				fi
				POSIXGROUP="$(ldap_search_getattr "${GROUP_BASEDN}" "gidNumber=${POSIXGROUP}" cn)"
				ADDTOGROUPS="${ADDTOGROUPS} ${POSIXGROUP}"
			else
				search_group "cn" "${POSIXGROUP}"
				rc1=$?
				search_group_files "cn" "${POSIXGROUP}"
				rc2=$?
				if [ "$rc1" -ne 0 -a "$rc2" -ne 0 ]; then
					echo "${modulename}: Unknown other group \"${POSIXGROUP}\""
					exit 6
				fi
				if [ "$rc1" -ne 0 -a "$rc2" -eq 0 ]; then
					echo "${modulename}: Group \"${POSIXGROUP}\" is not LDAP based, you must add the user elsewhere."
					continue
				fi
				ADDTOGROUPS="${ADDTOGROUPS} ${POSIXGROUP}"
			fi
		done
	fi

	# statute of limitations, based on hosts
	if [ -n "${HOSTLIST}" ]; then
		HOSTLIST="${HOSTLIST//,/ }"
		for HOST in ${HOSTLIST}; do
			HOSTS="${HOSTS}host: ${HOST}\n"
		done
		HOSTS="$(echo -e "${HOSTS}")"
	fi

	# new home directory
	if [ -n "${HOMEDIRECTORY}" ]; then
		echo "${HOMEDIRECTORY}" | ${GREP} -qs "^/"
		if [ "$?" -ne 0 ]; then
			echo "${modulename}: Invalid home directory \"${HOMEDIRECTORY}\""
			exit 3
		fi
	fi

	# change of login shell
	if [ -n "${LOGINSHELL}" ]; then
		echo "${LOGINSHELL}" | ${GREP} -qs "^/"
		if [ "$?" -ne 0 ]; then
			echo "${modulename}: Invalid shell \"${LOGINSHELL}\""
			exit 3
		fi
	fi

	# if we have a new username, we must update all groups
	if [ -n "${NEWLOGIN}" ]; then
		echo "${NEWLOGIN}" | ${GREP} -qs "^[[:alnum:]\._\-]*$"
		if [ "$?" -ne 0 ]; then
			echo "${modulename}: Invalid user name \"${NEWLOGIN}\""
			exit 3
		else
			search_user "uid" "${NEWLOGIN}"
			if [ "$?" -eq 0 ]; then
				echo "${modulename}: User \"${NEWLOGIN}\" exists"
				exit 9
			fi
		fi
		if [ "${USERGROUPS}" == "yes" ]; then
			search_group "cn" "${LOGIN}"
			if [ "$?" -eq 0 ]; then
				append "dn: cn=${LOGIN},${GROUP_BASEDN}\nchangetype: modrdn\nnewrdn: cn=${NEWLOGIN}\n"
			fi
		fi
		if [ -z "${ADDTOGROUPS}" ]; then
			ADDTOGROUPS="$(ldap_search_getattr "${GROUP_BASEDN}" "memberUid=${LOGIN}" cn)"
		fi
	fi

	# moving home directory
	if [ -n "${HOMEDIRECTORY}" -a "${MOVEHOMEDIR}" == "yes" ]; then
		if [ "${UID}" -ne 0 ]; then
			echo "${modulename}: Only root may move home directories"
			exit 12
		fi
		PARENTDIR="$(dirname "${HOMEDIRECTORY}")"
		if [ ! -w "${PARENTDIR}" ]; then
			echo "${modulename}: Cannot create directory \"${HOMEDIRECTORY}\""
			exit 12
		fi
		OLDHOMEDIRECTORY="$(ldap_search_getattr "${USER_BASEDN}" "uid=${LOGIN}" homeDirectory)"
	fi

	if [ -n "${SHADOWINACTIVE}" ]; then
		if [ "${SHADOWINACTIVE}" != "-1" ]; then
			echo "${SHADOWINACTIVE}" | ${GREP} -qs "^[[:digit:]]*$"
			if [ "$?" -ne 0 ]; then
				echo "${modulename}: Invalid numeric argument \"${SHADOWINACTIVE}\""
				exit 3
			fi
		fi
	fi

	# calculate expiry time
	if [ -n "${SHADOWEXPIRE}" ]; then
		if [ "${SHADOWEXPIRE}" != "-1" ]; then
			echo "${SHADOWEXPIRE}" | ${GREP} -qs "^[[:digit:]]\{4\}-[[:digit:]]\{2\}-[[:digit:]]\{2\}$"
			if [ "$?" -ne 0 ]; then
				echo "${modulename}: Invalid date \"${SHADOWEXPIRE}\" - format is YYYY-MM-DD"
				exit 3
			else
				let SHADOWEXPIRE="$(${DATE} -d "${SHADOWEXPIRE}" +%s) / 86400"
			fi
		fi
	fi

	# password locking is happening
	if [ -n "${LOCKED}" ]; then
		# grab data
		OLDPASSWORD="$(ldap_search_getattr "${USER_BASEDN}" "uid=${LOGIN}" userPassword)"
		userPassword_SambaNT="$(ldap_search_getattr "${USER_BASEDN}" "uid=${LOGIN}" userPassword_SambaNT)"
		userPassword_SambaLM="$(ldap_search_getattr "${USER_BASEDN}" "uid=${LOGIN}" userPassword_SambaLM)"
		userPassword_Irix="$(ldap_search_getattr "${USER_BASEDN}" "uid=${LOGIN}" userPassword_Irix)"
		# add lock
		if [ "${LOCKED}" == "yes" ]; then
			userPassword_Crypt="$(echo "${OLDPASSWORD}" | ${SEDEXT} -e 's/}[!]?/}!/')"
			[ -n "${userPassword_SambaNT}" ] && userPassword_SambaNT="$(echo "${userPassword_SambaNT}" | ${SEDEXT} -e 's/^[!]?/!/')"
			[ -n "${userPassword_SambaLM}" ] && userPassword_SambaLM="$(echo "${userPassword_SambaLM}" | ${SEDEXT} -e 's/^[!]?/!/')"
			[ -n "${userPassword_Irix}" ] && userPassword_Irix="$(echo "${userPassword_Irix}" | ${SEDEXT} -e 's/}[!]?/}!/')"
		# remove lock
		elif [ "${LOCKED}" == "no" ]; then
			userPassword_Crypt="$(echo "${OLDPASSWORD}" | ${SEDEXT} -e 's/}!/}/')"
			[ -n "${userPassword_SambaNT}" ] && userPassword_SambaNT="$(echo "${userPassword_SambaNT}" | ${SEDEXT} -e 's/^[!]//')"
			[ -n "${userPassword_SambaLM}" ] && userPassword_SambaLM="$(echo "${userPassword_SambaLM}" | ${SEDEXT} -e 's/^[!]//')"
			[ -n "${userPassword_Irix}" ] && userPassword_Irix="$(echo "${userPassword_Irix}" | ${SEDEXT} -e 's/}!/}/')"
		fi
	fi
	if [ -n "${userPassword_Plain}" ]; then
		userPassword_Crypt="$(${MKPASSWD} -m ${userPassword_Plain})"
		userPassword_Irix="$(${MKPASSWD} -i ${userPassword_Plain})"
		if [ "x${SAMBA}" == "xyes" ]; then
			userPassword_SambaNT="$(${MKPASSWD} -n ${userPassword_Plain})"
			userPassword_SambaLM="$(${MKPASSWD} -l ${userPassword_Plain})"
		fi
	fi

	COMMAND_DN="dn: uid=${LOGIN},${USER_BASEDN}"
	append "${COMMAND_DN}"
	[ -n "${UIDNUMBER}" ] && append_attrib_replace "uidNumber" "${UIDNUMBER}"
	[ -n "${GIDNUMBER}" ] && append_attrib_replace "gidNumber" "${GIDNUMBER}"
	#[ -n "${EMAIL}" ] && append_attrib_replace "email" "${EMAIL}"
	[ -n "${EMAIL}" ] && append_attrib_replace "mail" "${EMAIL}"
	[ -n "${HOSTS}" ] && append "replace: host\n${HOSTS}"
	[ -n "${HOMEDIRECTORY}" ] && append_attrib_replace "homeDirectory" "${HOMEDIRECTORY}"
	[ -n "${LOGINSHELL}" ] && append_attrib_replace "loginShell" "${LOGINSHELL}"
	[ -n "${COMMENT}" ] && FULLNAME=${COMMENT//,*}
	[ -n "${COMMENT}" ] && append_attrib_replace "cn" "${FULLNAME}" 
	[ -n "${COMMENT}" ] && append_attrib_replace "gecos" "${COMMENT}"
	[ -n "${SHADOWINACTIVE}" ] && append_attrib_replace "shadowInactive" "${SHADOWINACTIVE}"
	[ -n "${SHADOWEXPIRE}" ] && append_attrib_replace "shadowExpire" "${SHADOWEXPIRE}"
	[ -n "${userPassword_Crypt}" ] && append_attrib_replace_base64 "userPassword" "{CRYPT}${userPassword_Crypt}"
	if [ "x${SAMBA}" == "xyes" ]; then
		[ -n "${userPassword_SambaNT}" ] && append_attrib_replace_base64 "sambaNTPassword" "${userPassword_SambaNT}"
		[ -n "${userPassword_SambaLM}" ] && append_attrib_replace_base64 "sambaLMPassword" "${userPassword_SambaLM}"
	fi
	if [ "x${IRIX}" == "xyes" ]; then
		search_attr "${OBJECT_DN}" "(objectClass=irixAccount)" "objectClass: irixAccount" \
			|| append_attrib_add objectClass "irixAccount"
		[ -n "${userPassword_Irix}" ] && append_attrib_replace_base64 "irixPassword" "{CRYPT}${userPassword_Irix}"
	fi
	# if we haven't set anything so far, all of our changes are in other DNs
	[ "${COMMAND}" == "${COMMAND_DN}" ] && unset COMMAND
	append "\n\n"	
	# redo groups
	if [ -n "${ADDTOGROUPS}" ]; then
		DELETEFROMGROUPS="$(ldap_search_getattr "${GROUP_BASEDN}" "memberUid=${LOGIN}" cn)"
		for POSIXGROUP in ${DELETEFROMGROUPS}; do
			append "dn: cn=${POSIXGROUP},${GROUP_BASEDN}"
			append "delete: memberUid"
			append "memberUid: ${LOGIN}\n"
		done
		activelogin="${LOGIN}"
		[ -n "${NEWLOGIN}" ] && activelogin="${NEWLOGIN}"
		for POSIXGROUP in ${ADDTOGROUPS}; do
			append "dn: cn=${POSIXGROUP},${GROUP_BASEDN}"
			append "add: memberUid"
			append "memberUid: ${activelogin}\n"
		done
	fi

	# new username
	[ -n "${NEWLOGIN}" ] && append "\ndn: uid=${LOGIN},${USER_BASEDN}\nchangetype: modrdn\nnewrdn: uid=${NEWLOGIN}\n"

	#echo -e ">>>${LINENO}\n${COMMAND}<<<${LINENO}"
	runmodify
	if [ "${MOVEHOMEDIR}" == "yes" ]; then
		mv ${OLDHOMEDIRECTORY} ${HOMEDIRECTORY} > /dev/null 2>&1
		${CHMOD} "${HOMEPERM}" "${HOMEDIRECTORY}"
		${CHOWN} -R "${UIDNUMBER}":"${GIDNUMBER}" "${HOMEDIRECTORY}"
	fi
}

userdel() {
	[ -z "${modulename}" ] && modulename="userdel"
	unset OPTION OPTARG OPTIND
	while getopts "r" OPTION; do
		case "${OPTION}" in
			r) REMOVEHOMEDIR="yes";;
			*) print_usage ${modulename} ; exit 1;;
		esac
	done
	shift $((${OPTIND} - 1))
	if [ "${#}" -ne 1 ]; then
		print_usage ${modulename}
		exit 2
	else
		LOGIN="${1}"
	fi
	search_user "uid" "${LOGIN}"
	if [ "$?" -ne 0 ]; then
		echo "${modulename}: User \"${LOGIN}\" does not exist"
		exit 6
	fi
	if [ "${REMOVEHOMEDIR}" == "yes" ]; then
		if [ "${UID}" -ne 0 ]; then
			echo "${modulename}: Only root may remove home directories"
			exit 12
		fi
		HOMEDIRECTORY="$(ldap_search_getattr "${USER_BASEDN}" "uid=${LOGIN}" homeDirectory)"
		UIDNUMBER="$(ldap_search_getattr "${USER_BASEDN}" "uid=${LOGIN}" uidNumber)"
	fi
	append_dn_delete "uid=${LOGIN},${USER_BASEDN}"
	DELETEFROMGROUPS="$(ldap_search_getattr "${GROUP_BASEDN}" "memberUid=${LOGIN}" cn)"
	for POSIXGROUP in ${DELETEFROMGROUPS}; do
		append "dn: cn=${POSIXGROUP},${GROUP_BASEDN}\ndelete: memberUid\nmemberUid: ${LOGIN}\n"
	done
	runmodify
	if [ "${REMOVEHOMEDIR}" == "yes" -a -d "${HOMEDIRECTORY}" ]; then
		OWNER_UIDNUMBER="$(${STAT} "${HOMEDIRECTORY}" |
			${GREP} "Uid:" |
			${SED} "s/^.*Uid:.*(\(.*\)\/.*Gid:.*$/\1/" | tr -d " ")"
		if [ "${UIDNUMBER}" -eq "${OWNER_UIDNUMBER}" ]; then
			rm -rf "${HOMEDIRECTORY}"
		else
			echo "${modulename}: ${HOMEDIRECTORY} not owned by user \"${LOGIN}\", not removing"
			exit 12
		fi
	fi
}

chsh() {
	[ -z "${modulename}" ] && modulename="chsh"
	unset OPTION OPTARG OPTIND
	while getopts "s:" OPTION; do
		case "${OPTION}" in
			s) LOGINSHELL="${OPTARG}";;
		esac
	done
	shift $((${OPTIND} - 1))
	if [ "${#}" -ne 1 ]; then
		print_usage ${modulename}
		exit 2
	else
		LOGIN="${1}"
	fi
	OLDLOGINSHELL="`ldap_search_getattr "${USER_BASEDN}" "uid=${LOGIN}" "loginShell"`"
	if [ -z "${LOGINSHELL}" ]; then
		msg="Changing the login shell for ${LOGIN}\nEnter the new value, or press return for the default\n\tLogin Shell [${OLDLOGINSHELL}]: "
		grabinteractiveinput "${msg}" LOGINSHELL
		[ -z "${LOGINSHELL}" ] && LOGINSHELL="${OLDLOGINSHELL}"
	fi

	# recursive behaviour is nice...
	# But we only do the call if they are changing the shell
	[ "${OLDLOGINSHELL}" != "${LOGINSHELL}" ] && usermod -s "${LOGINSHELL}" -- "${LOGIN}"
}

chfn() {
	[ -z "${modulename}" ] && modulename="chfn"
	unset OPTION OPTARG OPTIND
	while getopts "f:h:o:r:w:" OPTION; do
		case "${OPTION}" in
			f) FULLNAME="${OPTARG}" ;;
			h) HOMEPHONE="${OPTARG}" ;;
			o) OTHER="${OPTARG}" ;;
			r) ROOMNUMBER="${OPTARG}" ;;
			w) WORKPHONE="${OPTARG}" ;;
		esac
	done
	shift $((${OPTIND} - 1))
	if [ "${#}" -ne 1 ]; then
		print_usage ${modulename}
		exit 2
	else
		LOGIN="${1}"
	fi
	
	OLD_FULLNAME="`ldap_search_getattr "${USER_BASEDN}" "uid=${LOGIN}" "displayName"`"
	OLD_GIVENNAME="`ldap_search_getattr "${USER_BASEDN}" "uid=${LOGIN}" "givenName"`"
	OLD_SN="`ldap_search_getattr "${USER_BASEDN}" "uid=${LOGIN}" "sn"`"
	OLD_CN="`ldap_search_getattr "${USER_BASEDN}" "uid=${LOGIN}" "cn"`"
	OLD_ROOMNUMBER="`ldap_search_getattr "${USER_BASEDN}" "uid=${LOGIN}" "roomNumber"`"
	OLD_WORKPHONE="`ldap_search_getattr "${USER_BASEDN}" "uid=${LOGIN}" "telephoneNumber"`"
	OLD_HOMEPHONE="`ldap_search_getattr "${USER_BASEDN}" "uid=${LOGIN}" "homePhone"`"
	OLD_GECOS="`ldap_search_getattr "${USER_BASEDN}" "uid=${LOGIN}" "gecos"`"

	# interactive time
	delstr="field-delete-$RANDOM$RANDOM$RANDOM$RANDOM$RANDOM$RANDOM$RANDOM$RANDOM"
	if [ -z "${FULLNAME}${HOMEPHONE}${OTHER}${ROOMNUMBER}${WORKPHONE}" ]; then
		echo "Changing user information for ${LOGIN}"
		echo "Enter the new value, or press return for the default."
		echo "Enter a single - to delete the current contents."
		msg="\tFull Name [${OLD_FULLNAME}]: "
		grabinteractiveinput "${msg}" FULLNAME
		msg="\tRoom Number [${OLD_ROOMNUMBER}]: "
		grabinteractiveinput "${msg}" ROOMNUMBER
		msg="\tWork Phone [${OLD_WORKPHONE}]: "
		grabinteractiveinput "${msg}" WORKPHONE
		msg="\tHome Phone [${OLD_HOMEPHONE}]: "
		grabinteractiveinput "${msg}" HOMEPHONE
		if [ "${UID}" -eq 0 ]; then
			msg="\tOther [${OLD_OTHER}]: "
			grabinteractiveinput "${msg}" OTHER
			[ -z "${OTHER}" ] && OTHER="${OLD_OTHER}"
			[ "${OTHER}" == "-" ] && OTHER="${delstr}"
		fi
		[ -z "${FULLNAME}" ] && FULLNAME="${OLD_FULLNAME}"
		[ "${FULLNAME}" == "-" ] && FULLNAME="${delstr}"
		[ -z "${ROOMNUMBER}" ] && ROOMNUMBER="${OLD_ROOMNUMBER}"
		[ "${ROOMNUMBER}" == "-" ] && ROOMNUMBER="${delstr}"
		[ -z "${WORKPHONE}" ] && WORKPHONE="${OLD_WORKPHONE}"
		[ "${WORKPHONE}" == "-" ] && WORKPHONE="${delstr}"
		[ -z "${HOMEPHONE}" ] && HOMEPHONE="${OLD_HOMEPHONE}"
		[ "${HOMEPHONE}" == "-" ] && HOMEPHONE="${delstr}"
	fi
	
	COMMAND_DN="dn: uid=${LOGIN},${USER_BASEDN}"
	COMMAND=""
	append "${COMMAND_DN}"

	if [ "${FULLNAME}" == "${delstr}" ]; then
		append_attrib_delete displayName "${OLD_FULLNAME}"
		append_attrib_delete cn "${OLD_CN}"
		append_attrib_delete sn "${OLD_SN}"
		append_attrib_delete givenName "${OLD_GIVENNAME}"
		unset FULLNAME
	fi
	[ "${ROOMNUMBER}" == "${delstr}" ] && unset ROOMNUMBER && append_attrib_delete roomNumber "${OLD_ROOMNUMBER}"
	[ "${WORKPHONE}" == "${delstr}" ] && unset WORKPHONE && append_attrib_delete workPhone "${OLD_WORKPHONE}"
	[ "${HOMEPHONE}" == "${delstr}" ] && unset HOMEPHONE && append_attrib_delete homePhone "${OLD_HOMEPHONE}"
	[ "${OTHER}" == "${delstr}" ] && unset OTHER && append_attrib_delete other "${OLD_OTHER}"

	if [ -n "${FULLNAME}" ]; then
		GIVENNAME="${FULLNAME// *}"
		CN="${GIVENNAME}"
		SN="${FULLNAME##* }"
		[ "${OLD_SN}" != "${SN}" ] && append_attrib_replace sn "${SN}"
		[ "${OLD_GIVENNAME}" != "${GIVENNAME}" ] && append_attrib_replace givenName "${GIVENNAME}"
		[ "${OLD_FULLNAME}" != "${FULLNAME}" ] && append_attrib_replace displayName "${FULLNAME}"
		[ "${OLD_CN}" != "${CN}" ] && append_attrib_replace cn "${CN}"
	fi
	
	GECOS="${FULLNAME},${ROOMNUMBER},${WORKPHONE},${HOMEPHONE},${OTHER}"
	[ -n "${ROOMNUMBER}" -a "${OLD_ROOMNUMBER}" != "${ROOMNUMBER}" ] && append_attrib_replace roomNumber "${ROOMNUMBER}"
	[ -n "${HOMEPHONE}" -a "${OLD_HOMEPHONE}" != "${HOMEPHONE}" ] && append_attrib_replace homePhone "${HOMEPHONE}"
	[ -n "${WORKPHONE}" -a "${OLD_WORKPHONE}" != "${WORKPHONE}" ] && append_attrib_replace telephoneNumber "${WORKPHONE}"
	[ -n "${GECOS}" -a "${OLD_GECOS}" != "${GECOS}" ] && append_attrib_replace gecos "${GECOS}"

	[ "${COMMAND}" == "${COMMAND_DN}" ] && unset COMMAND
	runmodify
}
