# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

package Amanda::Application;
use base qw(Exporter);
use base qw(DynaLoader);
package Amanda::Applicationc;
bootstrap Amanda::Application;
package Amanda::Application;
@EXPORT = qw();

# ---------- BASE METHODS -------------

package Amanda::Application;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    $self->$member_func();
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    $self->$member_func($newval);
}

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package Amanda::Application;

*run_calcsize_C = *Amanda::Applicationc::run_calcsize_C;

# ------- VARIABLE STUBS --------

package Amanda::Application;


@EXPORT_OK = ();
%EXPORT_TAGS = ();


=head1 NAME

Amanda::Application - perl utility functions for Applications.

=head1 SYNOPSIS

  package Amanda::Application::my_application;
  use base qw(Amanda::Application);

  sub new {
    my ($class, $config, $foo) = @_;
    my $self = $class->SUPER::new($config);

    $self->{'foo'} = $foo;
    $self->{'bar'} = $bar;

    return $self;
  }

  # Define all command_* subs that you need, e.g.,
  sub command_support {
    my $self = shift;
    # ...
  }

  package main;

  # .. parse arguments ..

  my $application = Amanda::Application::my_application->new($opt_foo, $opt_bar);
  $application->do($cmd);

=head1 INTERFACE

=head2 write_magic_block

  $self->write_magic_block($type)

Write a 512 bytes magic block to STDOUT.

=head2 read_magic_bloc

  $type = $self->read_magic_block()

Read the 512 bytes magic block from STDIN and return the type.

=cut


push @ISA, qw(Amanda::Script_App);
require Amanda::Script_App;

use strict;
use warnings;
use IO::Handle;
use Amanda::Config qw( :init :getconf config_dir_relative );


sub new {
    my $class = shift @_;
    my $config_name = shift @_;

    my $self = Amanda::Script_App::new($class, "client", "application", $config_name);

    $self->{known_commands} = {
        support   => 1,
        discover  => 1,
        selfcheck => 1,
        estimate  => 1,
        backup    => 1,
        restore   => 1,
        validate  => 1,
        index     => 1,
    };
    return $self;
}

sub run_calcsize {
    my $self = shift;
    my $program = shift;

    run_calcsize_C($self->{config}, $program, $self->{disk}, $self->{device}, $self->{level}, undef, undef);

}

sub default_validate {
    my $self = shift;
    my $buffer;

    do {
	sysread STDIN, $buffer, 1048576;
    } while (defined $buffer and length($buffer) > 0);
}

sub write_magic_block {
    my $self = shift;
    my $type = shift;

    my $dump_str = pack("a512", $type);
    print STDOUT $dump_str;
}

sub read_magic_block {
    my $self = shift;

    my $magic_block = Amanda::Util::full_read(0, 512);
    #remove '\0' bytes
    $magic_block =~ /^([^\0]*)/;
    my $type = $1;

    return $type;
}

sub _set_mesgout {
    my $self = shift;

    my $mesgout = IO::Handle->new();
    $mesgout->fdopen(3,"a") || die("Can't open mesgout_fd: $!");
    $mesgout->autoflush(1);
    $self->{mesgout} = $mesgout;
}

1;
