/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.IOException;
import org.python.compiler.ClassConstants;
import org.python.compiler.Code;
import org.python.compiler.Constant;
import org.python.core.Py;
import org.python.core.PyFloat;
import org.python.objectweb.asm.Opcodes;
import org.python.util.CodegenUtils;

class PyFloatConstant
extends Constant
implements ClassConstants,
Opcodes {
    final double value;

    PyFloatConstant(double value) {
        this.value = value;
    }

    void get(Code c) throws IOException {
        c.getstatic(this.module.classfile.name, this.name, CodegenUtils.ci(PyFloat.class));
    }

    void put(Code c) throws IOException {
        this.module.classfile.addField(this.name, CodegenUtils.ci(PyFloat.class), access);
        c.ldc(new Double(this.value));
        c.invokestatic(CodegenUtils.p(Py.class), "newFloat", CodegenUtils.sig(PyFloat.class, Double.TYPE));
        c.putstatic(this.module.classfile.name, this.name, CodegenUtils.ci(PyFloat.class));
    }

    public int hashCode() {
        return (int)this.value;
    }

    public boolean equals(Object o) {
        if (o instanceof PyFloatConstant) {
            return ((PyFloatConstant)o).value == this.value;
        }
        return false;
    }
}

