/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.style.XSLStringConstructor;
import com.icl.saxon.tree.AttributeCollection;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public final class XSLComment
extends XSLStringConstructor {
    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            this.checkUnknownAttribute(n2);
            ++n;
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.optimize();
    }

    public void process(Context context) throws TransformerException {
        int n;
        String string = this.expandChildren(context);
        while ((n = string.indexOf("--")) >= 0) {
            context.getController().reportRecoverableError("Invalid characters (--) in comment", this);
            string = string.substring(0, n + 1) + " " + string.substring(n + 1);
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == '-') {
            context.getController().reportRecoverableError("Invalid character (-) at end of comment", this);
            string = string + " ";
        }
        context.getOutputter().writeComment(string);
    }
}

