/*
 * The authors hereby grant permission to use, copy, modify, distribute,
 * and license this software and its documentation for any purpose, provided
 * that existing copyright notices are retained in all copies and that this
 * notice is included verbatim in any distributions. No written agreement,
 * license, or royalty fee is required for any of the authorized uses.
 * Modifications to this software may be copyrighted by their authors
 * and need not follow the licensing terms described here, provided that
 * the new terms are clearly indicated on the first page of each file where
 * they apply.
 */

/*
** cdefBF544.h
**
** Copyright (C) 2006-2007 Analog Devices Inc., All Rights Reserved.
**
************************************************************************************
**
** This include file contains a list of macro "defines" to enable the programmer
** to use symbolic names for the ADSP-BF544 peripherals.
**
************************************************************************************
** System MMR Register Map
************************************************************************************/

#ifndef _CDEF_BF544_H
#define _CDEF_BF544_H

/* include all Core registers and bit definitions */
#include <defBF544.h>

/* include core specific register pointer definitions */
#include <cdef_LPBlackfin.h>

/* SYSTEM & MMR ADDRESS DEFINITIONS FOR ADSP-BF544 */

/* include cdefBF54x_base.h for the set of #defines that are common to all ADSP-BF54x processors */
#include <cdefBF54x_base.h>

#ifdef _MISRA_RULES
#pragma diag(push)
#pragma diag(suppress:misra_rule_19_4:"some macro definitions not MISRA compliant")
#endif /* _MISRA_RULES */

/* The following are the #defines needed by ADSP-BF544 that are not in the common header */

/* Timer Registers */

#define                    pTIMER8_CONFIG ((volatile unsigned short *)TIMER8_CONFIG)
#define                   pTIMER8_COUNTER ((volatile unsigned long *)TIMER8_COUNTER)
#define                    pTIMER8_PERIOD ((volatile unsigned long *)TIMER8_PERIOD)
#define                     pTIMER8_WIDTH ((volatile unsigned long *)TIMER8_WIDTH)
#define                    pTIMER9_CONFIG ((volatile unsigned short *)TIMER9_CONFIG)
#define                   pTIMER9_COUNTER ((volatile unsigned long *)TIMER9_COUNTER)
#define                    pTIMER9_PERIOD ((volatile unsigned long *)TIMER9_PERIOD)
#define                     pTIMER9_WIDTH ((volatile unsigned long *)TIMER9_WIDTH)
#define                   pTIMER10_CONFIG ((volatile unsigned short *)TIMER10_CONFIG)
#define                  pTIMER10_COUNTER ((volatile unsigned long *)TIMER10_COUNTER)
#define                   pTIMER10_PERIOD ((volatile unsigned long *)TIMER10_PERIOD)
#define                    pTIMER10_WIDTH ((volatile unsigned long *)TIMER10_WIDTH)

/* Timer Group of 3 */

#define                    pTIMER_ENABLE1 ((volatile unsigned short *)TIMER_ENABLE1)
#define                   pTIMER_DISABLE1 ((volatile unsigned short *)TIMER_DISABLE1)
#define                    pTIMER_STATUS1 ((volatile unsigned long *)TIMER_STATUS1)

/* EPPI0 Registers */

#define                     pEPPI0_STATUS ((volatile unsigned short *)EPPI0_STATUS)
#define                     pEPPI0_HCOUNT ((volatile unsigned short *)EPPI0_HCOUNT)
#define                     pEPPI0_HDELAY ((volatile unsigned short *)EPPI0_HDELAY)
#define                     pEPPI0_VCOUNT ((volatile unsigned short *)EPPI0_VCOUNT)
#define                     pEPPI0_VDELAY ((volatile unsigned short *)EPPI0_VDELAY)
#define                      pEPPI0_FRAME ((volatile unsigned short *)EPPI0_FRAME)
#define                       pEPPI0_LINE ((volatile unsigned short *)EPPI0_LINE)
#define                     pEPPI0_CLKDIV ((volatile unsigned short *)EPPI0_CLKDIV)
#define                    pEPPI0_CONTROL ((volatile unsigned long *)EPPI0_CONTROL)
#define                   pEPPI0_FS1W_HBL ((volatile unsigned long *)EPPI0_FS1W_HBL)
#define                  pEPPI0_FS1P_AVPL ((volatile unsigned long *)EPPI0_FS1P_AVPL)
#define                   pEPPI0_FS2W_LVB ((volatile unsigned long *)EPPI0_FS2W_LVB)
#define                  pEPPI0_FS2P_LAVF ((volatile unsigned long *)EPPI0_FS2P_LAVF)
#define                       pEPPI0_CLIP ((volatile unsigned long *)EPPI0_CLIP)

/* Two Wire Interface Registers (TWI1) */

#define                      pTWI1_CLKDIV ((volatile unsigned short *)TWI1_CLKDIV)
#define                     pTWI1_CONTROL ((volatile unsigned short *)TWI1_CONTROL)
#define                   pTWI1_SLAVE_CTL ((volatile unsigned short *)TWI1_SLAVE_CTL)
#define                  pTWI1_SLAVE_STAT ((volatile unsigned short *)TWI1_SLAVE_STAT)
#define                  pTWI1_SLAVE_ADDR ((volatile unsigned short *)TWI1_SLAVE_ADDR)
#define                  pTWI1_MASTER_CTL ((volatile unsigned short *)TWI1_MASTER_CTL)
#define                 pTWI1_MASTER_STAT ((volatile unsigned short *)TWI1_MASTER_STAT)
#define                 pTWI1_MASTER_ADDR ((volatile unsigned short *)TWI1_MASTER_ADDR)
#define                    pTWI1_INT_STAT ((volatile unsigned short *)TWI1_INT_STAT)
#define                    pTWI1_INT_MASK ((volatile unsigned short *)TWI1_INT_MASK)
#define                    pTWI1_FIFO_CTL ((volatile unsigned short *)TWI1_FIFO_CTL)
#define                   pTWI1_FIFO_STAT ((volatile unsigned short *)TWI1_FIFO_STAT)
#define                   pTWI1_XMT_DATA8 ((volatile unsigned short *)TWI1_XMT_DATA8)
#define                  pTWI1_XMT_DATA16 ((volatile unsigned short *)TWI1_XMT_DATA16)
#define                   pTWI1_RCV_DATA8 ((volatile unsigned short *)TWI1_RCV_DATA8)
#define                  pTWI1_RCV_DATA16 ((volatile unsigned short *)TWI1_RCV_DATA16)

/* CAN Controller 1 Config 1 Registers */

#define                         pCAN1_MC1 ((volatile unsigned short *)CAN1_MC1)
#define                         pCAN1_MD1 ((volatile unsigned short *)CAN1_MD1)
#define                        pCAN1_TRS1 ((volatile unsigned short *)CAN1_TRS1)
#define                        pCAN1_TRR1 ((volatile unsigned short *)CAN1_TRR1)
#define                         pCAN1_TA1 ((volatile unsigned short *)CAN1_TA1)
#define                         pCAN1_AA1 ((volatile unsigned short *)CAN1_AA1)
#define                        pCAN1_RMP1 ((volatile unsigned short *)CAN1_RMP1)
#define                        pCAN1_RML1 ((volatile unsigned short *)CAN1_RML1)
#define                      pCAN1_MBTIF1 ((volatile unsigned short *)CAN1_MBTIF1)
#define                      pCAN1_MBRIF1 ((volatile unsigned short *)CAN1_MBRIF1)
#define                       pCAN1_MBIM1 ((volatile unsigned short *)CAN1_MBIM1)
#define                        pCAN1_RFH1 ((volatile unsigned short *)CAN1_RFH1)
#define                       pCAN1_OPSS1 ((volatile unsigned short *)CAN1_OPSS1)

/* CAN Controller 1 Config 2 Registers */

#define                         pCAN1_MC2 ((volatile unsigned short *)CAN1_MC2)
#define                         pCAN1_MD2 ((volatile unsigned short *)CAN1_MD2)
#define                        pCAN1_TRS2 ((volatile unsigned short *)CAN1_TRS2)
#define                        pCAN1_TRR2 ((volatile unsigned short *)CAN1_TRR2)
#define                         pCAN1_TA2 ((volatile unsigned short *)CAN1_TA2)
#define                         pCAN1_AA2 ((volatile unsigned short *)CAN1_AA2)
#define                        pCAN1_RMP2 ((volatile unsigned short *)CAN1_RMP2)
#define                        pCAN1_RML2 ((volatile unsigned short *)CAN1_RML2)
#define                      pCAN1_MBTIF2 ((volatile unsigned short *)CAN1_MBTIF2)
#define                      pCAN1_MBRIF2 ((volatile unsigned short *)CAN1_MBRIF2)
#define                       pCAN1_MBIM2 ((volatile unsigned short *)CAN1_MBIM2)
#define                        pCAN1_RFH2 ((volatile unsigned short *)CAN1_RFH2)
#define                       pCAN1_OPSS2 ((volatile unsigned short *)CAN1_OPSS2)

/* CAN Controller 1 Clock/Interrupt/Counter Registers */

#define                       pCAN1_CLOCK ((volatile unsigned short *)CAN1_CLOCK)
#define                      pCAN1_TIMING ((volatile unsigned short *)CAN1_TIMING)
#define                       pCAN1_DEBUG ((volatile unsigned short *)CAN1_DEBUG)
#define                      pCAN1_STATUS ((volatile unsigned short *)CAN1_STATUS)
#define                         pCAN1_CEC ((volatile unsigned short *)CAN1_CEC)
#define                         pCAN1_GIS ((volatile unsigned short *)CAN1_GIS)
#define                         pCAN1_GIM ((volatile unsigned short *)CAN1_GIM)
#define                         pCAN1_GIF ((volatile unsigned short *)CAN1_GIF)
#define                     pCAN1_CONTROL ((volatile unsigned short *)CAN1_CONTROL)
#define                        pCAN1_INTR ((volatile unsigned short *)CAN1_INTR)
#define                        pCAN1_MBTD ((volatile unsigned short *)CAN1_MBTD)
#define                         pCAN1_EWR ((volatile unsigned short *)CAN1_EWR)
#define                         pCAN1_ESR ((volatile unsigned short *)CAN1_ESR)
#define                       pCAN1_UCCNT ((volatile unsigned short *)CAN1_UCCNT)
#define                        pCAN1_UCRC ((volatile unsigned short *)CAN1_UCRC)
#define                       pCAN1_UCCNF ((volatile unsigned short *)CAN1_UCCNF)

/* CAN Controller 1 Mailbox Acceptance Registers */

#define                       pCAN1_AM00L ((volatile unsigned short *)CAN1_AM00L)
#define                       pCAN1_AM00H ((volatile unsigned short *)CAN1_AM00H)
#define                       pCAN1_AM01L ((volatile unsigned short *)CAN1_AM01L)
#define                       pCAN1_AM01H ((volatile unsigned short *)CAN1_AM01H)
#define                       pCAN1_AM02L ((volatile unsigned short *)CAN1_AM02L)
#define                       pCAN1_AM02H ((volatile unsigned short *)CAN1_AM02H)
#define                       pCAN1_AM03L ((volatile unsigned short *)CAN1_AM03L)
#define                       pCAN1_AM03H ((volatile unsigned short *)CAN1_AM03H)
#define                       pCAN1_AM04L ((volatile unsigned short *)CAN1_AM04L)
#define                       pCAN1_AM04H ((volatile unsigned short *)CAN1_AM04H)
#define                       pCAN1_AM05L ((volatile unsigned short *)CAN1_AM05L)
#define                       pCAN1_AM05H ((volatile unsigned short *)CAN1_AM05H)
#define                       pCAN1_AM06L ((volatile unsigned short *)CAN1_AM06L)
#define                       pCAN1_AM06H ((volatile unsigned short *)CAN1_AM06H)
#define                       pCAN1_AM07L ((volatile unsigned short *)CAN1_AM07L)
#define                       pCAN1_AM07H ((volatile unsigned short *)CAN1_AM07H)
#define                       pCAN1_AM08L ((volatile unsigned short *)CAN1_AM08L)
#define                       pCAN1_AM08H ((volatile unsigned short *)CAN1_AM08H)
#define                       pCAN1_AM09L ((volatile unsigned short *)CAN1_AM09L)
#define                       pCAN1_AM09H ((volatile unsigned short *)CAN1_AM09H)
#define                       pCAN1_AM10L ((volatile unsigned short *)CAN1_AM10L)
#define                       pCAN1_AM10H ((volatile unsigned short *)CAN1_AM10H)
#define                       pCAN1_AM11L ((volatile unsigned short *)CAN1_AM11L)
#define                       pCAN1_AM11H ((volatile unsigned short *)CAN1_AM11H)
#define                       pCAN1_AM12L ((volatile unsigned short *)CAN1_AM12L)
#define                       pCAN1_AM12H ((volatile unsigned short *)CAN1_AM12H)
#define                       pCAN1_AM13L ((volatile unsigned short *)CAN1_AM13L)
#define                       pCAN1_AM13H ((volatile unsigned short *)CAN1_AM13H)
#define                       pCAN1_AM14L ((volatile unsigned short *)CAN1_AM14L)
#define                       pCAN1_AM14H ((volatile unsigned short *)CAN1_AM14H)
#define                       pCAN1_AM15L ((volatile unsigned short *)CAN1_AM15L)
#define                       pCAN1_AM15H ((volatile unsigned short *)CAN1_AM15H)

/* CAN Controller 1 Mailbox Acceptance Registers */

#define                       pCAN1_AM16L ((volatile unsigned short *)CAN1_AM16L)
#define                       pCAN1_AM16H ((volatile unsigned short *)CAN1_AM16H)
#define                       pCAN1_AM17L ((volatile unsigned short *)CAN1_AM17L)
#define                       pCAN1_AM17H ((volatile unsigned short *)CAN1_AM17H)
#define                       pCAN1_AM18L ((volatile unsigned short *)CAN1_AM18L)
#define                       pCAN1_AM18H ((volatile unsigned short *)CAN1_AM18H)
#define                       pCAN1_AM19L ((volatile unsigned short *)CAN1_AM19L)
#define                       pCAN1_AM19H ((volatile unsigned short *)CAN1_AM19H)
#define                       pCAN1_AM20L ((volatile unsigned short *)CAN1_AM20L)
#define                       pCAN1_AM20H ((volatile unsigned short *)CAN1_AM20H)
#define                       pCAN1_AM21L ((volatile unsigned short *)CAN1_AM21L)
#define                       pCAN1_AM21H ((volatile unsigned short *)CAN1_AM21H)
#define                       pCAN1_AM22L ((volatile unsigned short *)CAN1_AM22L)
#define                       pCAN1_AM22H ((volatile unsigned short *)CAN1_AM22H)
#define                       pCAN1_AM23L ((volatile unsigned short *)CAN1_AM23L)
#define                       pCAN1_AM23H ((volatile unsigned short *)CAN1_AM23H)
#define                       pCAN1_AM24L ((volatile unsigned short *)CAN1_AM24L)
#define                       pCAN1_AM24H ((volatile unsigned short *)CAN1_AM24H)
#define                       pCAN1_AM25L ((volatile unsigned short *)CAN1_AM25L)
#define                       pCAN1_AM25H ((volatile unsigned short *)CAN1_AM25H)
#define                       pCAN1_AM26L ((volatile unsigned short *)CAN1_AM26L)
#define                       pCAN1_AM26H ((volatile unsigned short *)CAN1_AM26H)
#define                       pCAN1_AM27L ((volatile unsigned short *)CAN1_AM27L)
#define                       pCAN1_AM27H ((volatile unsigned short *)CAN1_AM27H)
#define                       pCAN1_AM28L ((volatile unsigned short *)CAN1_AM28L)
#define                       pCAN1_AM28H ((volatile unsigned short *)CAN1_AM28H)
#define                       pCAN1_AM29L ((volatile unsigned short *)CAN1_AM29L)
#define                       pCAN1_AM29H ((volatile unsigned short *)CAN1_AM29H)
#define                       pCAN1_AM30L ((volatile unsigned short *)CAN1_AM30L)
#define                       pCAN1_AM30H ((volatile unsigned short *)CAN1_AM30H)
#define                       pCAN1_AM31L ((volatile unsigned short *)CAN1_AM31L)
#define                       pCAN1_AM31H ((volatile unsigned short *)CAN1_AM31H)

/* CAN Controller 1 Mailbox Data Registers */

#define                  pCAN1_MB00_DATA0 ((volatile unsigned short *)CAN1_MB00_DATA0)
#define                  pCAN1_MB00_DATA1 ((volatile unsigned short *)CAN1_MB00_DATA1)
#define                  pCAN1_MB00_DATA2 ((volatile unsigned short *)CAN1_MB00_DATA2)
#define                  pCAN1_MB00_DATA3 ((volatile unsigned short *)CAN1_MB00_DATA3)
#define                 pCAN1_MB00_LENGTH ((volatile unsigned short *)CAN1_MB00_LENGTH)
#define              pCAN1_MB00_TIMESTAMP ((volatile unsigned short *)CAN1_MB00_TIMESTAMP)
#define                    pCAN1_MB00_ID0 ((volatile unsigned short *)CAN1_MB00_ID0)
#define                    pCAN1_MB00_ID1 ((volatile unsigned short *)CAN1_MB00_ID1)
#define                  pCAN1_MB01_DATA0 ((volatile unsigned short *)CAN1_MB01_DATA0)
#define                  pCAN1_MB01_DATA1 ((volatile unsigned short *)CAN1_MB01_DATA1)
#define                  pCAN1_MB01_DATA2 ((volatile unsigned short *)CAN1_MB01_DATA2)
#define                  pCAN1_MB01_DATA3 ((volatile unsigned short *)CAN1_MB01_DATA3)
#define                 pCAN1_MB01_LENGTH ((volatile unsigned short *)CAN1_MB01_LENGTH)
#define              pCAN1_MB01_TIMESTAMP ((volatile unsigned short *)CAN1_MB01_TIMESTAMP)
#define                    pCAN1_MB01_ID0 ((volatile unsigned short *)CAN1_MB01_ID0)
#define                    pCAN1_MB01_ID1 ((volatile unsigned short *)CAN1_MB01_ID1)
#define                  pCAN1_MB02_DATA0 ((volatile unsigned short *)CAN1_MB02_DATA0)
#define                  pCAN1_MB02_DATA1 ((volatile unsigned short *)CAN1_MB02_DATA1)
#define                  pCAN1_MB02_DATA2 ((volatile unsigned short *)CAN1_MB02_DATA2)
#define                  pCAN1_MB02_DATA3 ((volatile unsigned short *)CAN1_MB02_DATA3)
#define                 pCAN1_MB02_LENGTH ((volatile unsigned short *)CAN1_MB02_LENGTH)
#define              pCAN1_MB02_TIMESTAMP ((volatile unsigned short *)CAN1_MB02_TIMESTAMP)
#define                    pCAN1_MB02_ID0 ((volatile unsigned short *)CAN1_MB02_ID0)
#define                    pCAN1_MB02_ID1 ((volatile unsigned short *)CAN1_MB02_ID1)
#define                  pCAN1_MB03_DATA0 ((volatile unsigned short *)CAN1_MB03_DATA0)
#define                  pCAN1_MB03_DATA1 ((volatile unsigned short *)CAN1_MB03_DATA1)
#define                  pCAN1_MB03_DATA2 ((volatile unsigned short *)CAN1_MB03_DATA2)
#define                  pCAN1_MB03_DATA3 ((volatile unsigned short *)CAN1_MB03_DATA3)
#define                 pCAN1_MB03_LENGTH ((volatile unsigned short *)CAN1_MB03_LENGTH)
#define              pCAN1_MB03_TIMESTAMP ((volatile unsigned short *)CAN1_MB03_TIMESTAMP)
#define                    pCAN1_MB03_ID0 ((volatile unsigned short *)CAN1_MB03_ID0)
#define                    pCAN1_MB03_ID1 ((volatile unsigned short *)CAN1_MB03_ID1)
#define                  pCAN1_MB04_DATA0 ((volatile unsigned short *)CAN1_MB04_DATA0)
#define                  pCAN1_MB04_DATA1 ((volatile unsigned short *)CAN1_MB04_DATA1)
#define                  pCAN1_MB04_DATA2 ((volatile unsigned short *)CAN1_MB04_DATA2)
#define                  pCAN1_MB04_DATA3 ((volatile unsigned short *)CAN1_MB04_DATA3)
#define                 pCAN1_MB04_LENGTH ((volatile unsigned short *)CAN1_MB04_LENGTH)
#define              pCAN1_MB04_TIMESTAMP ((volatile unsigned short *)CAN1_MB04_TIMESTAMP)
#define                    pCAN1_MB04_ID0 ((volatile unsigned short *)CAN1_MB04_ID0)
#define                    pCAN1_MB04_ID1 ((volatile unsigned short *)CAN1_MB04_ID1)
#define                  pCAN1_MB05_DATA0 ((volatile unsigned short *)CAN1_MB05_DATA0)
#define                  pCAN1_MB05_DATA1 ((volatile unsigned short *)CAN1_MB05_DATA1)
#define                  pCAN1_MB05_DATA2 ((volatile unsigned short *)CAN1_MB05_DATA2)
#define                  pCAN1_MB05_DATA3 ((volatile unsigned short *)CAN1_MB05_DATA3)
#define                 pCAN1_MB05_LENGTH ((volatile unsigned short *)CAN1_MB05_LENGTH)
#define              pCAN1_MB05_TIMESTAMP ((volatile unsigned short *)CAN1_MB05_TIMESTAMP)
#define                    pCAN1_MB05_ID0 ((volatile unsigned short *)CAN1_MB05_ID0)
#define                    pCAN1_MB05_ID1 ((volatile unsigned short *)CAN1_MB05_ID1)
#define                  pCAN1_MB06_DATA0 ((volatile unsigned short *)CAN1_MB06_DATA0)
#define                  pCAN1_MB06_DATA1 ((volatile unsigned short *)CAN1_MB06_DATA1)
#define                  pCAN1_MB06_DATA2 ((volatile unsigned short *)CAN1_MB06_DATA2)
#define                  pCAN1_MB06_DATA3 ((volatile unsigned short *)CAN1_MB06_DATA3)
#define                 pCAN1_MB06_LENGTH ((volatile unsigned short *)CAN1_MB06_LENGTH)
#define              pCAN1_MB06_TIMESTAMP ((volatile unsigned short *)CAN1_MB06_TIMESTAMP)
#define                    pCAN1_MB06_ID0 ((volatile unsigned short *)CAN1_MB06_ID0)
#define                    pCAN1_MB06_ID1 ((volatile unsigned short *)CAN1_MB06_ID1)
#define                  pCAN1_MB07_DATA0 ((volatile unsigned short *)CAN1_MB07_DATA0)
#define                  pCAN1_MB07_DATA1 ((volatile unsigned short *)CAN1_MB07_DATA1)
#define                  pCAN1_MB07_DATA2 ((volatile unsigned short *)CAN1_MB07_DATA2)
#define                  pCAN1_MB07_DATA3 ((volatile unsigned short *)CAN1_MB07_DATA3)
#define                 pCAN1_MB07_LENGTH ((volatile unsigned short *)CAN1_MB07_LENGTH)
#define              pCAN1_MB07_TIMESTAMP ((volatile unsigned short *)CAN1_MB07_TIMESTAMP)
#define                    pCAN1_MB07_ID0 ((volatile unsigned short *)CAN1_MB07_ID0)
#define                    pCAN1_MB07_ID1 ((volatile unsigned short *)CAN1_MB07_ID1)
#define                  pCAN1_MB08_DATA0 ((volatile unsigned short *)CAN1_MB08_DATA0)
#define                  pCAN1_MB08_DATA1 ((volatile unsigned short *)CAN1_MB08_DATA1)
#define                  pCAN1_MB08_DATA2 ((volatile unsigned short *)CAN1_MB08_DATA2)
#define                  pCAN1_MB08_DATA3 ((volatile unsigned short *)CAN1_MB08_DATA3)
#define                 pCAN1_MB08_LENGTH ((volatile unsigned short *)CAN1_MB08_LENGTH)
#define              pCAN1_MB08_TIMESTAMP ((volatile unsigned short *)CAN1_MB08_TIMESTAMP)
#define                    pCAN1_MB08_ID0 ((volatile unsigned short *)CAN1_MB08_ID0)
#define                    pCAN1_MB08_ID1 ((volatile unsigned short *)CAN1_MB08_ID1)
#define                  pCAN1_MB09_DATA0 ((volatile unsigned short *)CAN1_MB09_DATA0)
#define                  pCAN1_MB09_DATA1 ((volatile unsigned short *)CAN1_MB09_DATA1)
#define                  pCAN1_MB09_DATA2 ((volatile unsigned short *)CAN1_MB09_DATA2)
#define                  pCAN1_MB09_DATA3 ((volatile unsigned short *)CAN1_MB09_DATA3)
#define                 pCAN1_MB09_LENGTH ((volatile unsigned short *)CAN1_MB09_LENGTH)
#define              pCAN1_MB09_TIMESTAMP ((volatile unsigned short *)CAN1_MB09_TIMESTAMP)
#define                    pCAN1_MB09_ID0 ((volatile unsigned short *)CAN1_MB09_ID0)
#define                    pCAN1_MB09_ID1 ((volatile unsigned short *)CAN1_MB09_ID1)
#define                  pCAN1_MB10_DATA0 ((volatile unsigned short *)CAN1_MB10_DATA0)
#define                  pCAN1_MB10_DATA1 ((volatile unsigned short *)CAN1_MB10_DATA1)
#define                  pCAN1_MB10_DATA2 ((volatile unsigned short *)CAN1_MB10_DATA2)
#define                  pCAN1_MB10_DATA3 ((volatile unsigned short *)CAN1_MB10_DATA3)
#define                 pCAN1_MB10_LENGTH ((volatile unsigned short *)CAN1_MB10_LENGTH)
#define              pCAN1_MB10_TIMESTAMP ((volatile unsigned short *)CAN1_MB10_TIMESTAMP)
#define                    pCAN1_MB10_ID0 ((volatile unsigned short *)CAN1_MB10_ID0)
#define                    pCAN1_MB10_ID1 ((volatile unsigned short *)CAN1_MB10_ID1)
#define                  pCAN1_MB11_DATA0 ((volatile unsigned short *)CAN1_MB11_DATA0)
#define                  pCAN1_MB11_DATA1 ((volatile unsigned short *)CAN1_MB11_DATA1)
#define                  pCAN1_MB11_DATA2 ((volatile unsigned short *)CAN1_MB11_DATA2)
#define                  pCAN1_MB11_DATA3 ((volatile unsigned short *)CAN1_MB11_DATA3)
#define                 pCAN1_MB11_LENGTH ((volatile unsigned short *)CAN1_MB11_LENGTH)
#define              pCAN1_MB11_TIMESTAMP ((volatile unsigned short *)CAN1_MB11_TIMESTAMP)
#define                    pCAN1_MB11_ID0 ((volatile unsigned short *)CAN1_MB11_ID0)
#define                    pCAN1_MB11_ID1 ((volatile unsigned short *)CAN1_MB11_ID1)
#define                  pCAN1_MB12_DATA0 ((volatile unsigned short *)CAN1_MB12_DATA0)
#define                  pCAN1_MB12_DATA1 ((volatile unsigned short *)CAN1_MB12_DATA1)
#define                  pCAN1_MB12_DATA2 ((volatile unsigned short *)CAN1_MB12_DATA2)
#define                  pCAN1_MB12_DATA3 ((volatile unsigned short *)CAN1_MB12_DATA3)
#define                 pCAN1_MB12_LENGTH ((volatile unsigned short *)CAN1_MB12_LENGTH)
#define              pCAN1_MB12_TIMESTAMP ((volatile unsigned short *)CAN1_MB12_TIMESTAMP)
#define                    pCAN1_MB12_ID0 ((volatile unsigned short *)CAN1_MB12_ID0)
#define                    pCAN1_MB12_ID1 ((volatile unsigned short *)CAN1_MB12_ID1)
#define                  pCAN1_MB13_DATA0 ((volatile unsigned short *)CAN1_MB13_DATA0)
#define                  pCAN1_MB13_DATA1 ((volatile unsigned short *)CAN1_MB13_DATA1)
#define                  pCAN1_MB13_DATA2 ((volatile unsigned short *)CAN1_MB13_DATA2)
#define                  pCAN1_MB13_DATA3 ((volatile unsigned short *)CAN1_MB13_DATA3)
#define                 pCAN1_MB13_LENGTH ((volatile unsigned short *)CAN1_MB13_LENGTH)
#define              pCAN1_MB13_TIMESTAMP ((volatile unsigned short *)CAN1_MB13_TIMESTAMP)
#define                    pCAN1_MB13_ID0 ((volatile unsigned short *)CAN1_MB13_ID0)
#define                    pCAN1_MB13_ID1 ((volatile unsigned short *)CAN1_MB13_ID1)
#define                  pCAN1_MB14_DATA0 ((volatile unsigned short *)CAN1_MB14_DATA0)
#define                  pCAN1_MB14_DATA1 ((volatile unsigned short *)CAN1_MB14_DATA1)
#define                  pCAN1_MB14_DATA2 ((volatile unsigned short *)CAN1_MB14_DATA2)
#define                  pCAN1_MB14_DATA3 ((volatile unsigned short *)CAN1_MB14_DATA3)
#define                 pCAN1_MB14_LENGTH ((volatile unsigned short *)CAN1_MB14_LENGTH)
#define              pCAN1_MB14_TIMESTAMP ((volatile unsigned short *)CAN1_MB14_TIMESTAMP)
#define                    pCAN1_MB14_ID0 ((volatile unsigned short *)CAN1_MB14_ID0)
#define                    pCAN1_MB14_ID1 ((volatile unsigned short *)CAN1_MB14_ID1)
#define                  pCAN1_MB15_DATA0 ((volatile unsigned short *)CAN1_MB15_DATA0)
#define                  pCAN1_MB15_DATA1 ((volatile unsigned short *)CAN1_MB15_DATA1)
#define                  pCAN1_MB15_DATA2 ((volatile unsigned short *)CAN1_MB15_DATA2)
#define                  pCAN1_MB15_DATA3 ((volatile unsigned short *)CAN1_MB15_DATA3)
#define                 pCAN1_MB15_LENGTH ((volatile unsigned short *)CAN1_MB15_LENGTH)
#define              pCAN1_MB15_TIMESTAMP ((volatile unsigned short *)CAN1_MB15_TIMESTAMP)
#define                    pCAN1_MB15_ID0 ((volatile unsigned short *)CAN1_MB15_ID0)
#define                    pCAN1_MB15_ID1 ((volatile unsigned short *)CAN1_MB15_ID1)

/* CAN Controller 1 Mailbox Data Registers */

#define                  pCAN1_MB16_DATA0 ((volatile unsigned short *)CAN1_MB16_DATA0)
#define                  pCAN1_MB16_DATA1 ((volatile unsigned short *)CAN1_MB16_DATA1)
#define                  pCAN1_MB16_DATA2 ((volatile unsigned short *)CAN1_MB16_DATA2)
#define                  pCAN1_MB16_DATA3 ((volatile unsigned short *)CAN1_MB16_DATA3)
#define                 pCAN1_MB16_LENGTH ((volatile unsigned short *)CAN1_MB16_LENGTH)
#define              pCAN1_MB16_TIMESTAMP ((volatile unsigned short *)CAN1_MB16_TIMESTAMP)
#define                    pCAN1_MB16_ID0 ((volatile unsigned short *)CAN1_MB16_ID0)
#define                    pCAN1_MB16_ID1 ((volatile unsigned short *)CAN1_MB16_ID1)
#define                  pCAN1_MB17_DATA0 ((volatile unsigned short *)CAN1_MB17_DATA0)
#define                  pCAN1_MB17_DATA1 ((volatile unsigned short *)CAN1_MB17_DATA1)
#define                  pCAN1_MB17_DATA2 ((volatile unsigned short *)CAN1_MB17_DATA2)
#define                  pCAN1_MB17_DATA3 ((volatile unsigned short *)CAN1_MB17_DATA3)
#define                 pCAN1_MB17_LENGTH ((volatile unsigned short *)CAN1_MB17_LENGTH)
#define              pCAN1_MB17_TIMESTAMP ((volatile unsigned short *)CAN1_MB17_TIMESTAMP)
#define                    pCAN1_MB17_ID0 ((volatile unsigned short *)CAN1_MB17_ID0)
#define                    pCAN1_MB17_ID1 ((volatile unsigned short *)CAN1_MB17_ID1)
#define                  pCAN1_MB18_DATA0 ((volatile unsigned short *)CAN1_MB18_DATA0)
#define                  pCAN1_MB18_DATA1 ((volatile unsigned short *)CAN1_MB18_DATA1)
#define                  pCAN1_MB18_DATA2 ((volatile unsigned short *)CAN1_MB18_DATA2)
#define                  pCAN1_MB18_DATA3 ((volatile unsigned short *)CAN1_MB18_DATA3)
#define                 pCAN1_MB18_LENGTH ((volatile unsigned short *)CAN1_MB18_LENGTH)
#define              pCAN1_MB18_TIMESTAMP ((volatile unsigned short *)CAN1_MB18_TIMESTAMP)
#define                    pCAN1_MB18_ID0 ((volatile unsigned short *)CAN1_MB18_ID0)
#define                    pCAN1_MB18_ID1 ((volatile unsigned short *)CAN1_MB18_ID1)
#define                  pCAN1_MB19_DATA0 ((volatile unsigned short *)CAN1_MB19_DATA0)
#define                  pCAN1_MB19_DATA1 ((volatile unsigned short *)CAN1_MB19_DATA1)
#define                  pCAN1_MB19_DATA2 ((volatile unsigned short *)CAN1_MB19_DATA2)
#define                  pCAN1_MB19_DATA3 ((volatile unsigned short *)CAN1_MB19_DATA3)
#define                 pCAN1_MB19_LENGTH ((volatile unsigned short *)CAN1_MB19_LENGTH)
#define              pCAN1_MB19_TIMESTAMP ((volatile unsigned short *)CAN1_MB19_TIMESTAMP)
#define                    pCAN1_MB19_ID0 ((volatile unsigned short *)CAN1_MB19_ID0)
#define                    pCAN1_MB19_ID1 ((volatile unsigned short *)CAN1_MB19_ID1)
#define                  pCAN1_MB20_DATA0 ((volatile unsigned short *)CAN1_MB20_DATA0)
#define                  pCAN1_MB20_DATA1 ((volatile unsigned short *)CAN1_MB20_DATA1)
#define                  pCAN1_MB20_DATA2 ((volatile unsigned short *)CAN1_MB20_DATA2)
#define                  pCAN1_MB20_DATA3 ((volatile unsigned short *)CAN1_MB20_DATA3)
#define                 pCAN1_MB20_LENGTH ((volatile unsigned short *)CAN1_MB20_LENGTH)
#define              pCAN1_MB20_TIMESTAMP ((volatile unsigned short *)CAN1_MB20_TIMESTAMP)
#define                    pCAN1_MB20_ID0 ((volatile unsigned short *)CAN1_MB20_ID0)
#define                    pCAN1_MB20_ID1 ((volatile unsigned short *)CAN1_MB20_ID1)
#define                  pCAN1_MB21_DATA0 ((volatile unsigned short *)CAN1_MB21_DATA0)
#define                  pCAN1_MB21_DATA1 ((volatile unsigned short *)CAN1_MB21_DATA1)
#define                  pCAN1_MB21_DATA2 ((volatile unsigned short *)CAN1_MB21_DATA2)
#define                  pCAN1_MB21_DATA3 ((volatile unsigned short *)CAN1_MB21_DATA3)
#define                 pCAN1_MB21_LENGTH ((volatile unsigned short *)CAN1_MB21_LENGTH)
#define              pCAN1_MB21_TIMESTAMP ((volatile unsigned short *)CAN1_MB21_TIMESTAMP)
#define                    pCAN1_MB21_ID0 ((volatile unsigned short *)CAN1_MB21_ID0)
#define                    pCAN1_MB21_ID1 ((volatile unsigned short *)CAN1_MB21_ID1)
#define                  pCAN1_MB22_DATA0 ((volatile unsigned short *)CAN1_MB22_DATA0)
#define                  pCAN1_MB22_DATA1 ((volatile unsigned short *)CAN1_MB22_DATA1)
#define                  pCAN1_MB22_DATA2 ((volatile unsigned short *)CAN1_MB22_DATA2)
#define                  pCAN1_MB22_DATA3 ((volatile unsigned short *)CAN1_MB22_DATA3)
#define                 pCAN1_MB22_LENGTH ((volatile unsigned short *)CAN1_MB22_LENGTH)
#define              pCAN1_MB22_TIMESTAMP ((volatile unsigned short *)CAN1_MB22_TIMESTAMP)
#define                    pCAN1_MB22_ID0 ((volatile unsigned short *)CAN1_MB22_ID0)
#define                    pCAN1_MB22_ID1 ((volatile unsigned short *)CAN1_MB22_ID1)
#define                  pCAN1_MB23_DATA0 ((volatile unsigned short *)CAN1_MB23_DATA0)
#define                  pCAN1_MB23_DATA1 ((volatile unsigned short *)CAN1_MB23_DATA1)
#define                  pCAN1_MB23_DATA2 ((volatile unsigned short *)CAN1_MB23_DATA2)
#define                  pCAN1_MB23_DATA3 ((volatile unsigned short *)CAN1_MB23_DATA3)
#define                 pCAN1_MB23_LENGTH ((volatile unsigned short *)CAN1_MB23_LENGTH)
#define              pCAN1_MB23_TIMESTAMP ((volatile unsigned short *)CAN1_MB23_TIMESTAMP)
#define                    pCAN1_MB23_ID0 ((volatile unsigned short *)CAN1_MB23_ID0)
#define                    pCAN1_MB23_ID1 ((volatile unsigned short *)CAN1_MB23_ID1)
#define                  pCAN1_MB24_DATA0 ((volatile unsigned short *)CAN1_MB24_DATA0)
#define                  pCAN1_MB24_DATA1 ((volatile unsigned short *)CAN1_MB24_DATA1)
#define                  pCAN1_MB24_DATA2 ((volatile unsigned short *)CAN1_MB24_DATA2)
#define                  pCAN1_MB24_DATA3 ((volatile unsigned short *)CAN1_MB24_DATA3)
#define                 pCAN1_MB24_LENGTH ((volatile unsigned short *)CAN1_MB24_LENGTH)
#define              pCAN1_MB24_TIMESTAMP ((volatile unsigned short *)CAN1_MB24_TIMESTAMP)
#define                    pCAN1_MB24_ID0 ((volatile unsigned short *)CAN1_MB24_ID0)
#define                    pCAN1_MB24_ID1 ((volatile unsigned short *)CAN1_MB24_ID1)
#define                  pCAN1_MB25_DATA0 ((volatile unsigned short *)CAN1_MB25_DATA0)
#define                  pCAN1_MB25_DATA1 ((volatile unsigned short *)CAN1_MB25_DATA1)
#define                  pCAN1_MB25_DATA2 ((volatile unsigned short *)CAN1_MB25_DATA2)
#define                  pCAN1_MB25_DATA3 ((volatile unsigned short *)CAN1_MB25_DATA3)
#define                 pCAN1_MB25_LENGTH ((volatile unsigned short *)CAN1_MB25_LENGTH)
#define              pCAN1_MB25_TIMESTAMP ((volatile unsigned short *)CAN1_MB25_TIMESTAMP)
#define                    pCAN1_MB25_ID0 ((volatile unsigned short *)CAN1_MB25_ID0)
#define                    pCAN1_MB25_ID1 ((volatile unsigned short *)CAN1_MB25_ID1)
#define                  pCAN1_MB26_DATA0 ((volatile unsigned short *)CAN1_MB26_DATA0)
#define                  pCAN1_MB26_DATA1 ((volatile unsigned short *)CAN1_MB26_DATA1)
#define                  pCAN1_MB26_DATA2 ((volatile unsigned short *)CAN1_MB26_DATA2)
#define                  pCAN1_MB26_DATA3 ((volatile unsigned short *)CAN1_MB26_DATA3)
#define                 pCAN1_MB26_LENGTH ((volatile unsigned short *)CAN1_MB26_LENGTH)
#define              pCAN1_MB26_TIMESTAMP ((volatile unsigned short *)CAN1_MB26_TIMESTAMP)
#define                    pCAN1_MB26_ID0 ((volatile unsigned short *)CAN1_MB26_ID0)
#define                    pCAN1_MB26_ID1 ((volatile unsigned short *)CAN1_MB26_ID1)
#define                  pCAN1_MB27_DATA0 ((volatile unsigned short *)CAN1_MB27_DATA0)
#define                  pCAN1_MB27_DATA1 ((volatile unsigned short *)CAN1_MB27_DATA1)
#define                  pCAN1_MB27_DATA2 ((volatile unsigned short *)CAN1_MB27_DATA2)
#define                  pCAN1_MB27_DATA3 ((volatile unsigned short *)CAN1_MB27_DATA3)
#define                 pCAN1_MB27_LENGTH ((volatile unsigned short *)CAN1_MB27_LENGTH)
#define              pCAN1_MB27_TIMESTAMP ((volatile unsigned short *)CAN1_MB27_TIMESTAMP)
#define                    pCAN1_MB27_ID0 ((volatile unsigned short *)CAN1_MB27_ID0)
#define                    pCAN1_MB27_ID1 ((volatile unsigned short *)CAN1_MB27_ID1)
#define                  pCAN1_MB28_DATA0 ((volatile unsigned short *)CAN1_MB28_DATA0)
#define                  pCAN1_MB28_DATA1 ((volatile unsigned short *)CAN1_MB28_DATA1)
#define                  pCAN1_MB28_DATA2 ((volatile unsigned short *)CAN1_MB28_DATA2)
#define                  pCAN1_MB28_DATA3 ((volatile unsigned short *)CAN1_MB28_DATA3)
#define                 pCAN1_MB28_LENGTH ((volatile unsigned short *)CAN1_MB28_LENGTH)
#define              pCAN1_MB28_TIMESTAMP ((volatile unsigned short *)CAN1_MB28_TIMESTAMP)
#define                    pCAN1_MB28_ID0 ((volatile unsigned short *)CAN1_MB28_ID0)
#define                    pCAN1_MB28_ID1 ((volatile unsigned short *)CAN1_MB28_ID1)
#define                  pCAN1_MB29_DATA0 ((volatile unsigned short *)CAN1_MB29_DATA0)
#define                  pCAN1_MB29_DATA1 ((volatile unsigned short *)CAN1_MB29_DATA1)
#define                  pCAN1_MB29_DATA2 ((volatile unsigned short *)CAN1_MB29_DATA2)
#define                  pCAN1_MB29_DATA3 ((volatile unsigned short *)CAN1_MB29_DATA3)
#define                 pCAN1_MB29_LENGTH ((volatile unsigned short *)CAN1_MB29_LENGTH)
#define              pCAN1_MB29_TIMESTAMP ((volatile unsigned short *)CAN1_MB29_TIMESTAMP)
#define                    pCAN1_MB29_ID0 ((volatile unsigned short *)CAN1_MB29_ID0)
#define                    pCAN1_MB29_ID1 ((volatile unsigned short *)CAN1_MB29_ID1)
#define                  pCAN1_MB30_DATA0 ((volatile unsigned short *)CAN1_MB30_DATA0)
#define                  pCAN1_MB30_DATA1 ((volatile unsigned short *)CAN1_MB30_DATA1)
#define                  pCAN1_MB30_DATA2 ((volatile unsigned short *)CAN1_MB30_DATA2)
#define                  pCAN1_MB30_DATA3 ((volatile unsigned short *)CAN1_MB30_DATA3)
#define                 pCAN1_MB30_LENGTH ((volatile unsigned short *)CAN1_MB30_LENGTH)
#define              pCAN1_MB30_TIMESTAMP ((volatile unsigned short *)CAN1_MB30_TIMESTAMP)
#define                    pCAN1_MB30_ID0 ((volatile unsigned short *)CAN1_MB30_ID0)
#define                    pCAN1_MB30_ID1 ((volatile unsigned short *)CAN1_MB30_ID1)
#define                  pCAN1_MB31_DATA0 ((volatile unsigned short *)CAN1_MB31_DATA0)
#define                  pCAN1_MB31_DATA1 ((volatile unsigned short *)CAN1_MB31_DATA1)
#define                  pCAN1_MB31_DATA2 ((volatile unsigned short *)CAN1_MB31_DATA2)
#define                  pCAN1_MB31_DATA3 ((volatile unsigned short *)CAN1_MB31_DATA3)
#define                 pCAN1_MB31_LENGTH ((volatile unsigned short *)CAN1_MB31_LENGTH)
#define              pCAN1_MB31_TIMESTAMP ((volatile unsigned short *)CAN1_MB31_TIMESTAMP)
#define                    pCAN1_MB31_ID0 ((volatile unsigned short *)CAN1_MB31_ID0)
#define                    pCAN1_MB31_ID1 ((volatile unsigned short *)CAN1_MB31_ID1)

/* HOST Port Registers */

#define                     pHOST_CONTROL ((volatile unsigned short *)HOST_CONTROL)
#define                      pHOST_STATUS ((volatile unsigned short *)HOST_STATUS)
#define                     pHOST_TIMEOUT ((volatile unsigned short *)HOST_TIMEOUT)

/* Pixel Compositor (PIXC) Registers */

#define                         pPIXC_CTL ((volatile unsigned short *)PIXC_CTL)
#define                         pPIXC_PPL ((volatile unsigned short *)PIXC_PPL)
#define                         pPIXC_LPF ((volatile unsigned short *)PIXC_LPF)
#define                     pPIXC_AHSTART ((volatile unsigned short *)PIXC_AHSTART)
#define                       pPIXC_AHEND ((volatile unsigned short *)PIXC_AHEND)
#define                     pPIXC_AVSTART ((volatile unsigned short *)PIXC_AVSTART)
#define                       pPIXC_AVEND ((volatile unsigned short *)PIXC_AVEND)
#define                     pPIXC_ATRANSP ((volatile unsigned short *)PIXC_ATRANSP)
#define                     pPIXC_BHSTART ((volatile unsigned short *)PIXC_BHSTART)
#define                       pPIXC_BHEND ((volatile unsigned short *)PIXC_BHEND)
#define                     pPIXC_BVSTART ((volatile unsigned short *)PIXC_BVSTART)
#define                       pPIXC_BVEND ((volatile unsigned short *)PIXC_BVEND)
#define                     pPIXC_BTRANSP ((volatile unsigned short *)PIXC_BTRANSP)
#define                    pPIXC_INTRSTAT ((volatile unsigned short *)PIXC_INTRSTAT)
#define                       pPIXC_RYCON ((volatile unsigned long *)PIXC_RYCON)
#define                       pPIXC_GUCON ((volatile unsigned long *)PIXC_GUCON)
#define                       pPIXC_BVCON ((volatile unsigned long *)PIXC_BVCON)
#define                      pPIXC_CCBIAS ((volatile unsigned long *)PIXC_CCBIAS)
#define                          pPIXC_TC ((volatile unsigned long *)PIXC_TC)

#ifdef _MISRA_RULES
#pragma diag(pop)
#endif /* _MISRA_RULES */

#endif /* _CDEF_BF544_H */
