; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -simplifycfg -S -phi-node-folding-threshold=1 | FileCheck %s --check-prefix=ALL --check-prefix=CHECK-ONE
; RUN: opt < %s -simplifycfg -S -phi-node-folding-threshold=2 | FileCheck %s --check-prefix=ALL --check-prefix=CHECK-TWO
; RUN: opt < %s -simplifycfg -S -phi-node-folding-threshold=7 | FileCheck %s --check-prefix=ALL --check-prefix=CHECK-SEVEN

; Test merging of blocks containing complex expressions,
; with various folding thresholds

define i32 @test(i1 %a, i1 %b, i32 %i, i32 %j, i32 %k) {
; ALL-LABEL: @test(
; ALL-NEXT:  entry:
; ALL-NEXT:    br i1 [[A:%.*]], label [[M:%.*]], label [[O:%.*]]
; ALL:       O:
; ALL-NEXT:    [[IAJ:%.*]] = add i32 [[I:%.*]], [[J:%.*]]
; ALL-NEXT:    [[IAJAK:%.*]] = add i32 [[IAJ]], [[K:%.*]]
; ALL-NEXT:    [[IXJ:%.*]] = xor i32 [[I]], [[J]]
; ALL-NEXT:    [[IXJXK:%.*]] = xor i32 [[IXJ]], [[K]]
; ALL-NEXT:    [[WP:%.*]] = select i1 [[B:%.*]], i32 [[IAJAK]], i32 [[IXJXK]]
; ALL-NEXT:    [[WP2:%.*]] = add i32 [[WP]], [[WP]]
; ALL-NEXT:    br label [[M]]
; ALL:       M:
; ALL-NEXT:    [[W:%.*]] = phi i32 [ [[WP2]], [[O]] ], [ 2, [[ENTRY:%.*]] ]
; ALL-NEXT:    [[R:%.*]] = add i32 [[W]], 1
; ALL-NEXT:    ret i32 [[R]]
;
entry:
  br i1 %a, label %M, label %O
O:
  br i1 %b, label %P, label %Q
P:
  %iaj = add i32 %i, %j
  %iajak = add i32 %iaj, %k
  br label %N
Q:
  %ixj = xor i32 %i, %j
  %ixjxk = xor i32 %ixj, %k
  br label %N
N:
  ; This phi should be foldable if threshold >= 2
  %Wp = phi i32 [ %iajak, %P ], [ %ixjxk, %Q ]
  %Wp2 = add i32 %Wp, %Wp
  br label %M
M:
  ; This phi should be foldable if threshold >= 7
  %W = phi i32 [ %Wp2, %N ], [ 2, %entry ]
  %R = add i32 %W, 1
  ret i32 %R
}

