// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple riscv64-none-linux-gnu -target-feature +f -target-feature +d -target-feature +zve64d -mvscale-min=1 -mvscale-max=1 -O1 -emit-llvm -o - %s | FileCheck %s --check-prefix=CHECK-64
// RUN: %clang_cc1 -triple riscv64-none-linux-gnu -target-feature +f -target-feature +d -target-feature +zve64d -mvscale-min=2 -mvscale-max=2 -O1 -emit-llvm -o - %s | FileCheck %s --check-prefix=CHECK-128

// REQUIRES: riscv-registered-target

#include <stdint.h>

typedef __rvv_bool8_t vbool8_t;
typedef __rvv_bool16_t vbool16_t;
typedef __rvv_bool32_t vbool32_t;
typedef __rvv_bool64_t vbool64_t;
typedef vbool8_t fixed_bool8_t __attribute__((riscv_rvv_vector_bits(__riscv_v_fixed_vlen/8)));
typedef vbool16_t fixed_bool16_t __attribute__((riscv_rvv_vector_bits(__riscv_v_fixed_vlen/16)));
typedef vbool32_t fixed_bool32_t __attribute__((riscv_rvv_vector_bits(__riscv_v_fixed_vlen/32)));
typedef vbool64_t fixed_bool64_t __attribute__((riscv_rvv_vector_bits(__riscv_v_fixed_vlen/64)));

// CHECK-64-LABEL: @from_vbool8_t(
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    ret <vscale x 8 x i1> [[TYPE:%.*]]
//
// CHECK-128-LABEL: @from_vbool8_t(
// CHECK-128-NEXT:  entry:
// CHECK-128-NEXT:    ret <vscale x 8 x i1> [[TYPE:%.*]]
//
fixed_bool8_t from_vbool8_t(vbool8_t type) {
  return type;
}

// CHECK-64-LABEL: @from_vbool16_t(
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    [[SAVED_VALUE:%.*]] = alloca <vscale x 4 x i1>, align 1
// CHECK-64-NEXT:    [[RETVAL_COERCE:%.*]] = alloca <vscale x 4 x i1>, align 1
// CHECK-64-NEXT:    store <vscale x 4 x i1> [[TYPE:%.*]], ptr [[SAVED_VALUE]], align 1, !tbaa [[TBAA6:![0-9]+]]
// CHECK-64-NEXT:    [[TMP0:%.*]] = load <1 x i8>, ptr [[SAVED_VALUE]], align 1, !tbaa [[TBAA10:![0-9]+]]
// CHECK-64-NEXT:    store <1 x i8> [[TMP0]], ptr [[RETVAL_COERCE]], align 1
// CHECK-64-NEXT:    [[TMP1:%.*]] = load <vscale x 4 x i1>, ptr [[RETVAL_COERCE]], align 1
// CHECK-64-NEXT:    ret <vscale x 4 x i1> [[TMP1]]
//
// CHECK-128-LABEL: @from_vbool16_t(
// CHECK-128-NEXT:  entry:
// CHECK-128-NEXT:    [[SAVED_VALUE:%.*]] = alloca <vscale x 4 x i1>, align 1
// CHECK-128-NEXT:    [[RETVAL_COERCE:%.*]] = alloca <vscale x 4 x i1>, align 1
// CHECK-128-NEXT:    store <vscale x 4 x i1> [[TYPE:%.*]], ptr [[SAVED_VALUE]], align 1, !tbaa [[TBAA6:![0-9]+]]
// CHECK-128-NEXT:    [[TMP0:%.*]] = load <1 x i8>, ptr [[SAVED_VALUE]], align 1, !tbaa [[TBAA10:![0-9]+]]
// CHECK-128-NEXT:    store <1 x i8> [[TMP0]], ptr [[RETVAL_COERCE]], align 1
// CHECK-128-NEXT:    [[TMP1:%.*]] = load <vscale x 4 x i1>, ptr [[RETVAL_COERCE]], align 1
// CHECK-128-NEXT:    ret <vscale x 4 x i1> [[TMP1]]
//
fixed_bool16_t from_vbool16_t(vbool16_t type) {
  return type;
}
// CHECK-64-LABEL: @from_vbool32_t(
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    [[SAVED_VALUE:%.*]] = alloca <vscale x 2 x i1>, align 1
// CHECK-64-NEXT:    [[RETVAL_COERCE:%.*]] = alloca <vscale x 2 x i1>, align 1
// CHECK-64-NEXT:    store <vscale x 2 x i1> [[TYPE:%.*]], ptr [[SAVED_VALUE]], align 1, !tbaa [[TBAA11:![0-9]+]]
// CHECK-64-NEXT:    [[TMP0:%.*]] = load <1 x i8>, ptr [[SAVED_VALUE]], align 1, !tbaa [[TBAA10]]
// CHECK-64-NEXT:    store <1 x i8> [[TMP0]], ptr [[RETVAL_COERCE]], align 1
// CHECK-64-NEXT:    [[TMP1:%.*]] = load <vscale x 2 x i1>, ptr [[RETVAL_COERCE]], align 1
// CHECK-64-NEXT:    ret <vscale x 2 x i1> [[TMP1]]
//
// CHECK-128-LABEL: @from_vbool32_t(
// CHECK-128-NEXT:  entry:
// CHECK-128-NEXT:    [[SAVED_VALUE:%.*]] = alloca <vscale x 2 x i1>, align 1
// CHECK-128-NEXT:    [[RETVAL_COERCE:%.*]] = alloca <vscale x 2 x i1>, align 1
// CHECK-128-NEXT:    store <vscale x 2 x i1> [[TYPE:%.*]], ptr [[SAVED_VALUE]], align 1, !tbaa [[TBAA11:![0-9]+]]
// CHECK-128-NEXT:    [[TMP0:%.*]] = load <1 x i8>, ptr [[SAVED_VALUE]], align 1, !tbaa [[TBAA10]]
// CHECK-128-NEXT:    store <1 x i8> [[TMP0]], ptr [[RETVAL_COERCE]], align 1
// CHECK-128-NEXT:    [[TMP1:%.*]] = load <vscale x 2 x i1>, ptr [[RETVAL_COERCE]], align 1
// CHECK-128-NEXT:    ret <vscale x 2 x i1> [[TMP1]]
//
fixed_bool32_t from_vbool32_t(vbool32_t type) {
  return type;
}

// CHECK-64-LABEL: @to_vbool32_t(
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    ret <vscale x 2 x i1> [[TYPE_COERCE:%.*]]
//
// CHECK-128-LABEL: @to_vbool32_t(
// CHECK-128-NEXT:  entry:
// CHECK-128-NEXT:    ret <vscale x 2 x i1> [[TYPE_COERCE:%.*]]
//
vbool32_t to_vbool32_t(fixed_bool32_t type) {
  return type;
}

// CHECK-64-LABEL: @from_vbool64_t(
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    [[SAVED_VALUE:%.*]] = alloca <vscale x 1 x i1>, align 1
// CHECK-64-NEXT:    [[RETVAL_COERCE:%.*]] = alloca <vscale x 1 x i1>, align 1
// CHECK-64-NEXT:    store <vscale x 1 x i1> [[TYPE:%.*]], ptr [[SAVED_VALUE]], align 1, !tbaa [[TBAA13:![0-9]+]]
// CHECK-64-NEXT:    [[TMP0:%.*]] = load <1 x i8>, ptr [[SAVED_VALUE]], align 1, !tbaa [[TBAA10]]
// CHECK-64-NEXT:    store <1 x i8> [[TMP0]], ptr [[RETVAL_COERCE]], align 1
// CHECK-64-NEXT:    [[TMP1:%.*]] = load <vscale x 1 x i1>, ptr [[RETVAL_COERCE]], align 1
// CHECK-64-NEXT:    ret <vscale x 1 x i1> [[TMP1]]
//
// CHECK-128-LABEL: @from_vbool64_t(
// CHECK-128-NEXT:  entry:
// CHECK-128-NEXT:    [[SAVED_VALUE:%.*]] = alloca <vscale x 1 x i1>, align 1
// CHECK-128-NEXT:    [[RETVAL_COERCE:%.*]] = alloca <vscale x 1 x i1>, align 1
// CHECK-128-NEXT:    store <vscale x 1 x i1> [[TYPE:%.*]], ptr [[SAVED_VALUE]], align 1, !tbaa [[TBAA13:![0-9]+]]
// CHECK-128-NEXT:    [[TMP0:%.*]] = load <1 x i8>, ptr [[SAVED_VALUE]], align 1, !tbaa [[TBAA10]]
// CHECK-128-NEXT:    store <1 x i8> [[TMP0]], ptr [[RETVAL_COERCE]], align 1
// CHECK-128-NEXT:    [[TMP1:%.*]] = load <vscale x 1 x i1>, ptr [[RETVAL_COERCE]], align 1
// CHECK-128-NEXT:    ret <vscale x 1 x i1> [[TMP1]]
//
fixed_bool64_t from_vbool64_t(vbool64_t type) {
  return type;
}

// CHECK-64-LABEL: @to_vbool64_t(
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    ret <vscale x 1 x i1> [[TYPE_COERCE:%.*]]
//
// CHECK-128-LABEL: @to_vbool64_t(
// CHECK-128-NEXT:  entry:
// CHECK-128-NEXT:    ret <vscale x 1 x i1> [[TYPE_COERCE:%.*]]
//
vbool64_t to_vbool64_t(fixed_bool64_t type) {
  return type;
}
