/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.builtins;

import org.apache.jena.graph.Node;
import org.apache.jena.reasoner.rulesys.BindingEnvironment;
import org.apache.jena.reasoner.rulesys.RuleContext;
import org.apache.jena.reasoner.rulesys.Util;
import org.apache.jena.reasoner.rulesys.builtins.BaseBuiltin;

public class AddOne
extends BaseBuiltin {
    @Override
    public String getName() {
        return "addOne";
    }

    @Override
    public int getArgLength() {
        return 2;
    }

    @Override
    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        this.checkArgs(length, context);
        BindingEnvironment env = context.getEnv();
        boolean ok = false;
        Node a0 = this.getArg(0, args, context);
        Node a1 = this.getArg(1, args, context);
        if (Util.isNumeric(a0)) {
            Node newVal = Util.makeIntNode(Util.getIntValue(a0) + 1);
            ok = env.bind(args[1], newVal);
        } else if (Util.isNumeric(a1)) {
            Node newVal = Util.makeIntNode(Util.getIntValue(a1) - 1);
            ok = env.bind(args[0], newVal);
        }
        return ok;
    }
}

