/*
 * Copyright 2013 Vadim Girlin <vadimgirlin@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Authors:
 *      Vadim Girlin
 */

// TODO add all formats

// CF

BC_FORMAT_BEGIN_HW(CF_WORD0, R6R7)
BC_FIELD(CF_WORD0,      ADDR,               ADDR,       31, 0)
BC_FORMAT_END(CF_WORD0)

BC_FORMAT_BEGIN_HW(CF_WORD0, EGCM)
BC_FIELD(CF_WORD0,      ADDR,               ADDR,       23, 0)
BC_FIELD(CF_WORD0,      JUMPTABLE_SEL,      JTS,        26, 24)
BC_RSRVD(CF_WORD0,                                      31, 27)
BC_FORMAT_END(CF_WORD0)


BC_FORMAT_BEGIN_HW(CF_GWS_WORD0, EGCM)
BC_FIELD(CF_GWS_WORD0,  VALUE,              VAL,        9,  0)
BC_RSRVD(CF_GWS_WORD0,                                  15, 10)
BC_FIELD(CF_GWS_WORD0,  RESOURCE,           RSRC,       20, 16)
BC_RSRVD(CF_GWS_WORD0,                                  24, 21)
BC_FIELD(CF_GWS_WORD0,  SIGN,               SIGN,       25, 25)
BC_FIELD(CF_GWS_WORD0,  VAL_INDEX_MODE,     VIM,        27, 26)
BC_FIELD(CF_GWS_WORD0,  RSRC_INDEX_MODE,    RIM,        29, 28)
BC_FIELD(CF_GWS_WORD0,  GWS_OPCODE,         GWS_OP,     31, 30)
BC_FORMAT_END(CF_GWS_WORD0)


BC_FORMAT_BEGIN_HW(CF_WORD1, R6R7)
BC_FIELD(CF_WORD1,      POP_COUNT,          PC,         2,  0)
BC_FIELD(CF_WORD1,      CF_CONST,           CF_CONST,   7,  3)
BC_FIELD(CF_WORD1,      COND,               COND,       9,  8)
BC_FIELD(CF_WORD1,      COUNT,              COUNT,      12, 10)
BC_FIELD(CF_WORD1,      CALL_COUNT,         CALL_CNT,   18, 13)
BC_FIELD(CF_WORD1,      COUNT_3,            COUNT_3,    19, 19)
BC_RSRVD(CF_WORD1,                                      20, 20)
BC_FIELD(CF_WORD1,      END_OF_PROGRAM,     EOP,        21, 21)
BC_FIELD(CF_WORD1,      VALID_PIXEL_MODE,   VPM,        22, 22)
BC_FIELD(CF_WORD1,      CF_INST,            CF_INST,    29, 23)
BC_FIELD(CF_WORD1,      WHOLE_QUAD_MODE,    WQM,        30, 30)
BC_FIELD(CF_WORD1,      BARRIER,            B,          31, 31)
BC_FORMAT_END(CF_WORD1)

BC_FORMAT_BEGIN_HW(CF_WORD1, EG)
BC_FIELD(CF_WORD1,      POP_COUNT,          PC,         2,  0)
BC_FIELD(CF_WORD1,      CF_CONST,           CF_CONST,   7,  3)
BC_FIELD(CF_WORD1,      COND,               COND,       9,  8)
BC_FIELD(CF_WORD1,      COUNT,              COUNT,      15, 10)
BC_RSRVD(CF_WORD1,                                      19, 16)
BC_FIELD(CF_WORD1,      VALID_PIXEL_MODE,   VPM,        20, 20)
BC_FIELD(CF_WORD1,      END_OF_PROGRAM,     EOP,        21, 21)
BC_FIELD(CF_WORD1,      CF_INST,            CF_INST,    29, 22)
BC_FIELD(CF_WORD1,      WHOLE_QUAD_MODE,    WQM,        30, 30)
BC_FIELD(CF_WORD1,      BARRIER,            B,          31, 31)
BC_FORMAT_END(CF_WORD1)

BC_FORMAT_BEGIN_HW(CF_WORD1, CM)
BC_FIELD(CF_WORD1,      POP_COUNT,          PC,         2,  0)
BC_FIELD(CF_WORD1,      CF_CONST,           CF_CONST,   7,  3)
BC_FIELD(CF_WORD1,      COND,               COND,       9,  8)
BC_FIELD(CF_WORD1,      COUNT,              COUNT,      15, 10)
BC_RSRVD(CF_WORD1,                                      19, 16)
BC_FIELD(CF_WORD1,      VALID_PIXEL_MODE,   VPM,        20, 20)
BC_RSRVD(CF_WORD1,                                      21, 21)
BC_FIELD(CF_WORD1,      CF_INST,            CF_INST,    29, 22)
BC_RSRVD(CF_WORD1,                                      30, 30)
BC_FIELD(CF_WORD1,      BARRIER,            B,          31, 31)
BC_FORMAT_END(CF_WORD1)


BC_FORMAT_BEGIN(CF_ALU_WORD0)
BC_FIELD(CF_ALU_WORD0,  ADDR,               ADDR,       21, 0)
BC_FIELD(CF_ALU_WORD0,  KCACHE_BANK0,       KB0,        25, 22)
BC_FIELD(CF_ALU_WORD0,  KCACHE_BANK1,       KB1,        29, 26)
BC_FIELD(CF_ALU_WORD0,  KCACHE_MODE0,       KM0,        31, 30)
BC_FORMAT_END(CF_ALU_WORD0)

BC_FORMAT_BEGIN_HW(CF_ALU_WORD1, R6)
BC_FIELD(CF_ALU_WORD1,  KCACHE_MODE1,       KM1,        1,  0)
BC_FIELD(CF_ALU_WORD1,  KCACHE_ADDR0,       KA0,        9,  2)
BC_FIELD(CF_ALU_WORD1,  KCACHE_ADDR1,       KA1,        17, 10)
BC_FIELD(CF_ALU_WORD1,  COUNT,              COUNT,      24, 18)
BC_FIELD(CF_ALU_WORD1,  USES_WATERFALL,     UW,         25, 25)
BC_FIELD(CF_ALU_WORD1,  CF_INST,            CF_INST,    29, 26)
BC_FIELD(CF_ALU_WORD1,  WHOLE_QUAD_MODE,    WQM,        30, 30)
BC_FIELD(CF_ALU_WORD1,  BARRIER,            B,          31, 31)
BC_FORMAT_END(CF_ALU_WORD1)

BC_FORMAT_BEGIN_HW(CF_ALU_WORD1, R7EGCM)
BC_FIELD(CF_ALU_WORD1,  KCACHE_MODE1,       KM1,        1,  0)
BC_FIELD(CF_ALU_WORD1,  KCACHE_ADDR0,       KA0,        9,  2)
BC_FIELD(CF_ALU_WORD1,  KCACHE_ADDR1,       KA1,        17, 10)
BC_FIELD(CF_ALU_WORD1,  COUNT,              COUNT,      24, 18)
BC_FIELD(CF_ALU_WORD1,  ALT_CONST,          ALT_C,      25, 25)
BC_FIELD(CF_ALU_WORD1,  CF_INST,            CF_INST,    29, 26)
BC_FIELD(CF_ALU_WORD1,  WHOLE_QUAD_MODE,    WQM,        30, 30)
BC_FIELD(CF_ALU_WORD1,  BARRIER,            B,          31, 31)
BC_FORMAT_END(CF_ALU_WORD1)


BC_FORMAT_BEGIN_HW(CF_ALU_WORD0_EXT, EGCM)
BC_RSRVD(CF_ALU_WORD0_EXT,                                          3,  0)
BC_FIELD(CF_ALU_WORD0_EXT,  KCACHE_BANK_INDEX_MODE0,    KBIM0,      5,  4)
BC_FIELD(CF_ALU_WORD0_EXT,  KCACHE_BANK_INDEX_MODE1,    KBIM1,      7,  6)
BC_FIELD(CF_ALU_WORD0_EXT,  KCACHE_BANK_INDEX_MODE2,    KBIM2,      9,  8)
BC_FIELD(CF_ALU_WORD0_EXT,  KCACHE_BANK_INDEX_MODE3,    KBIM3,      11, 10)
BC_RSRVD(CF_ALU_WORD0_EXT,                                          21, 12)
BC_FIELD(CF_ALU_WORD0_EXT,  KCACHE_BANK2,               KB2,        25, 22)
BC_FIELD(CF_ALU_WORD0_EXT,  KCACHE_BANK3,               KB3,        29, 26)
BC_FIELD(CF_ALU_WORD0_EXT,  KCACHE_MODE2,               KM2,        31, 30)
BC_FORMAT_END(CF_ALU_WORD0_EXT)

BC_FORMAT_BEGIN_HW(CF_ALU_WORD1_EXT, EGCM)
BC_FIELD(CF_ALU_WORD1_EXT,  KCACHE_MODE3,       KM3,        1,  0)
BC_FIELD(CF_ALU_WORD1_EXT,  KCACHE_ADDR2,       KA2,        9,  2)
BC_FIELD(CF_ALU_WORD1_EXT,  KCACHE_ADDR3,       KA3,        17, 10)
BC_RSRVD(CF_ALU_WORD1_EXT,                                  25, 18)
BC_FIELD(CF_ALU_WORD1_EXT,  CF_INST,            CF_INST,    29, 26)
BC_RSRVD(CF_ALU_WORD1_EXT,                                  30, 30)
BC_FIELD(CF_ALU_WORD1_EXT,  BARRIER,            B,          31, 31)
BC_FORMAT_END(CF_ALU_WORD1_EXT)


BC_FORMAT_BEGIN(CF_ALLOC_EXPORT_WORD0)
BC_FIELD(CF_ALLOC_EXPORT_WORD0, ARRAY_BASE,     ARR_BS,     12, 0)
BC_FIELD(CF_ALLOC_EXPORT_WORD0, TYPE,           TYPE,       14, 13)
BC_FIELD(CF_ALLOC_EXPORT_WORD0, RW_GPR,         RW_GPR,     21, 15)
BC_FIELD(CF_ALLOC_EXPORT_WORD0, RW_REL,         RW_REL,     22, 22)
BC_FIELD(CF_ALLOC_EXPORT_WORD0, INDEX_GPR,      IND_GPR,    29, 23)
BC_FIELD(CF_ALLOC_EXPORT_WORD0, ELEM_SIZE,      ES,         31, 30)
BC_FORMAT_END(CF_ALLOC_EXPORT_WORD0)

BC_FORMAT_BEGIN_HW(CF_ALLOC_EXPORT_WORD0_RAT, EGCM)
BC_FIELD(CF_ALLOC_EXPORT_WORD0_RAT, RAT_ID,         R_ID,       3,  0)
BC_FIELD(CF_ALLOC_EXPORT_WORD0_RAT, RAT_INST,       R_INST,     9,  4)
BC_RSRVD(CF_ALLOC_EXPORT_WORD0_RAT,                             10, 10)
BC_FIELD(CF_ALLOC_EXPORT_WORD0_RAT, RAT_INDEX_MODE, RIM,        12, 11)
BC_FIELD(CF_ALLOC_EXPORT_WORD0_RAT, TYPE,           TYPE,       14, 13)
BC_FIELD(CF_ALLOC_EXPORT_WORD0_RAT, RW_GPR,         RW_GPR,     21, 15)
BC_FIELD(CF_ALLOC_EXPORT_WORD0_RAT, RW_REL,         RW_REL,     22, 22)
BC_FIELD(CF_ALLOC_EXPORT_WORD0_RAT, INDEX_GPR,      IND_GPR,    29, 23)
BC_FIELD(CF_ALLOC_EXPORT_WORD0_RAT, ELEM_SIZE,      ES,         31, 30)
BC_FORMAT_END(CF_ALLOC_EXPORT_WORD0_RAT)

BC_FORMAT_BEGIN_HW(CF_ALLOC_EXPORT_WORD1_BUF, R6R7)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_BUF, ARRAY_SIZE,         ARR_SZ,     11, 0)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_BUF, COMP_MASK,          MASK,       15, 12)
BC_RSRVD(CF_ALLOC_EXPORT_WORD1_BUF,                                 16, 16)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_BUF, BURST_COUNT,        BURST,      20, 17)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_BUF, END_OF_PROGRAM,     EOP,        21, 21)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_BUF, VALID_PIXEL_MODE,   VPM,        22, 22)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_BUF, CF_INST,            CF_INST,    29, 23)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_BUF, WHOLE_QUAD_MODE,    WQM,        30, 30)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_BUF, BARRIER,            B,          31, 31)
BC_FORMAT_END(CF_ALLOC_EXPORT_WORD1_BUF)

BC_FORMAT_BEGIN_HW(CF_ALLOC_EXPORT_WORD1_BUF, EG)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_BUF, ARRAY_SIZE,         ARR_SZ,     11, 0)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_BUF, COMP_MASK,          MASK,       15, 12)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_BUF, BURST_COUNT,        BURST,      19, 16)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_BUF, VALID_PIXEL_MODE,   VPM,        20, 20)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_BUF, END_OF_PROGRAM,     EOP,        21, 21)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_BUF, CF_INST,            CF_INST,    29, 22)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_BUF, MARK,               MARK,       30, 30)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_BUF, BARRIER,            B,          31, 31)
BC_FORMAT_END(CF_ALLOC_EXPORT_WORD1_BUF)

BC_FORMAT_BEGIN_HW(CF_ALLOC_EXPORT_WORD1_BUF, CM)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_BUF, ARRAY_SIZE,         ARR_SZ,     11, 0)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_BUF, COMP_MASK,          MASK,       15, 12)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_BUF, BURST_COUNT,        BURST,      19, 16)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_BUF, VALID_PIXEL_MODE,   VPM,        20, 20)
BC_RSRVD(CF_ALLOC_EXPORT_WORD1_BUF,                                 21, 21)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_BUF, CF_INST,            CF_INST,    29, 22)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_BUF, MARK,               MARK,       30, 30)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_BUF, BARRIER,            B,          31, 31)
BC_FORMAT_END(CF_ALLOC_EXPORT_WORD1_BUF)

BC_FORMAT_BEGIN_HW(CF_ALLOC_EXPORT_WORD1_SWIZ, R6R7)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    SEL_X,              SEL_X,      2,  0)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    SEL_Y,              SEL_Y,      5,  3)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    SEL_Z,              SEL_Z,      8,  6)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    SEL_W,              SEL_W,      11, 9)
BC_RSRVD(CF_ALLOC_EXPORT_WORD1_SWIZ,                                    16, 12)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    BURST_COUNT,        BURST,      20, 17)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    END_OF_PROGRAM,     EOP,        21, 21)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    VALID_PIXEL_MODE,   VPM,        22, 22)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    CF_INST,            CF_INST,    29, 23)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    WHOLE_QUAD_MODE,    WQM,        30, 30)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    BARRIER,            B,          31, 31)
BC_FORMAT_END(CF_ALLOC_EXPORT_WORD1_SWIZ)

BC_FORMAT_BEGIN_HW(CF_ALLOC_EXPORT_WORD1_SWIZ, EG)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    SEL_X,              SEL_X,      2,  0)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    SEL_Y,              SEL_Y,      5,  3)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    SEL_Z,              SEL_Z,      8,  6)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    SEL_W,              SEL_W,      11, 9)
BC_RSRVD(CF_ALLOC_EXPORT_WORD1_SWIZ,                                    15, 12)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    BURST_COUNT,        BURST,      19, 16)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    VALID_PIXEL_MODE,   VPM,        20, 20)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    END_OF_PROGRAM,     EOP,        21, 21)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    CF_INST,            CF_INST,    29, 22)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    MARK,               M,          30, 30)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    BARRIER,            B,          31, 31)
BC_FORMAT_END(CF_ALLOC_EXPORT_WORD1_SWIZ)

BC_FORMAT_BEGIN_HW(CF_ALLOC_EXPORT_WORD1_SWIZ, CM)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    SEL_X,              SEL_X,      2,  0)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    SEL_Y,              SEL_Y,      5,  3)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    SEL_Z,              SEL_Z,      8,  6)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    SEL_W,              SEL_W,      11, 9)
BC_RSRVD(CF_ALLOC_EXPORT_WORD1_SWIZ,                                    15, 12)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    BURST_COUNT,        BURST,      19, 16)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    VALID_PIXEL_MODE,   VPM,        20, 20)
BC_RSRVD(CF_ALLOC_EXPORT_WORD1_SWIZ,                                    21, 21)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    CF_INST,            CF_INST,    29, 22)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    MARK,               M,          30, 30)
BC_FIELD(CF_ALLOC_EXPORT_WORD1_SWIZ,    BARRIER,            B,          31, 31)
BC_FORMAT_END(CF_ALLOC_EXPORT_WORD1_SWIZ)

// ALU

BC_FORMAT_BEGIN(ALU_WORD0)
BC_FIELD(ALU_WORD0,     SRC0_SEL,               S0S,        8,  0)
BC_FIELD(ALU_WORD0,     SRC0_REL,               S0R,        9,  9)
BC_FIELD(ALU_WORD0,     SRC0_CHAN,              S0C,        11, 10)
BC_FIELD(ALU_WORD0,     SRC0_NEG,               S0N,        12, 12)
BC_FIELD(ALU_WORD0,     SRC1_SEL,               S1S,        21, 13)
BC_FIELD(ALU_WORD0,     SRC1_REL,               S1R,        22, 22)
BC_FIELD(ALU_WORD0,     SRC1_CHAN,              S1C,        24, 23)
BC_FIELD(ALU_WORD0,     SRC1_NEG,               S1N,        25, 25)
BC_FIELD(ALU_WORD0,     INDEX_MODE,             IM,         28, 26)
BC_FIELD(ALU_WORD0,     PRED_SEL,               PS,         30, 29)
BC_FIELD(ALU_WORD0,     LAST,                   L,          31, 31)
BC_FORMAT_END(ALU_WORD0)

BC_FORMAT_BEGIN_HW(ALU_WORD1_OP2, R6)
BC_FIELD(ALU_WORD1_OP2,     SRC0_ABS,               S0A,        0,  0)
BC_FIELD(ALU_WORD1_OP2,     SRC1_ABS,               S1A,        1,  1)
BC_FIELD(ALU_WORD1_OP2,     UPDATE_EXEC_MASK,       UEM,        2,  2)
BC_FIELD(ALU_WORD1_OP2,     UPDATE_PRED,            UP,         3,  3)
BC_FIELD(ALU_WORD1_OP2,     WRITE_MASK,             WM,         4,  4)
BC_FIELD(ALU_WORD1_OP2,     FOG_MERGE,              FM,         5,  5)
BC_FIELD(ALU_WORD1_OP2,     OMOD,                   OMOD,       7,  6)
BC_FIELD(ALU_WORD1_OP2,     ALU_INST,               INST,       17, 8)
BC_FIELD(ALU_WORD1_OP2,     BANK_SWIZZLE,           BS,         20, 18)
BC_FIELD(ALU_WORD1_OP2,     DST_GPR,                DGPR,       27, 21)
BC_FIELD(ALU_WORD1_OP2,     DST_REL,                DR,         28, 28)
BC_FIELD(ALU_WORD1_OP2,     DST_CHAN,               DC,         30, 29)
BC_FIELD(ALU_WORD1_OP2,     CLAMP,                  C,          31, 31)
BC_FORMAT_END(ALU_WORD1_OP2)

BC_FORMAT_BEGIN_HW(ALU_WORD1_OP2, R7EGCM)
BC_FIELD(ALU_WORD1_OP2,     SRC0_ABS,               S0A,        0,  0)
BC_FIELD(ALU_WORD1_OP2,     SRC1_ABS,               S1A,        1,  1)
BC_FIELD(ALU_WORD1_OP2,     UPDATE_EXEC_MASK,       UEM,        2,  2)
BC_FIELD(ALU_WORD1_OP2,     UPDATE_PRED,            UP,         3,  3)
BC_FIELD(ALU_WORD1_OP2,     WRITE_MASK,             WM,         4,  4)
BC_FIELD(ALU_WORD1_OP2,     OMOD,                   OMOD,       6,  5)
BC_FIELD(ALU_WORD1_OP2,     ALU_INST,               INST,       17, 7)
BC_FIELD(ALU_WORD1_OP2,     BANK_SWIZZLE,           BS,         20, 18)
BC_FIELD(ALU_WORD1_OP2,     DST_GPR,                DGPR,       27, 21)
BC_FIELD(ALU_WORD1_OP2,     DST_REL,                DR,         28, 28)
BC_FIELD(ALU_WORD1_OP2,     DST_CHAN,               DC,         30, 29)
BC_FIELD(ALU_WORD1_OP2,     CLAMP,                  C,          31, 31)
BC_FORMAT_END(ALU_WORD1_OP2)

BC_FORMAT_BEGIN_HW(ALU_WORD1_OP2_MOVA, CM)
BC_FIELD(ALU_WORD1_OP2_MOVA,     SRC0_ABS,               S0A,        0,  0)
BC_FIELD(ALU_WORD1_OP2_MOVA,     SRC1_ABS,               S1A,        1,  1)
BC_FIELD(ALU_WORD1_OP2_MOVA,     UPDATE_EXEC_MASK,       UEM,        2,  2)
BC_FIELD(ALU_WORD1_OP2_MOVA,     UPDATE_PRED,            UP,         3,  3)
BC_FIELD(ALU_WORD1_OP2_MOVA,     WRITE_MASK,             WM,         4,  4)
BC_FIELD(ALU_WORD1_OP2_MOVA,     OMOD,                   OMOD,       6,  5)
BC_FIELD(ALU_WORD1_OP2_MOVA,     ALU_INST,               INST,       17, 7)
BC_FIELD(ALU_WORD1_OP2_MOVA,     BANK_SWIZZLE,           BS,         20, 18)
BC_FIELD(ALU_WORD1_OP2_MOVA,     MOVA_DST,               MOVA_DST,   27, 21)
BC_FIELD(ALU_WORD1_OP2_MOVA,     DST_REL,                DR,         28, 28)
BC_FIELD(ALU_WORD1_OP2_MOVA,     DST_CHAN,               DC,         30, 29)
BC_FIELD(ALU_WORD1_OP2_MOVA,     CLAMP,                  C,          31, 31)
BC_FORMAT_END(ALU_WORD1_OP2_MOVA)

BC_FORMAT_BEGIN_HW(ALU_WORD1_OP2_EXEC_MASK, CM)
BC_FIELD(ALU_WORD1_OP2_EXEC_MASK,     SRC0_ABS,               S0A,        0,  0)
BC_FIELD(ALU_WORD1_OP2_EXEC_MASK,     SRC1_ABS,               S1A,        1,  1)
BC_FIELD(ALU_WORD1_OP2_EXEC_MASK,     UPDATE_EXEC_MASK,       UEM,        2,  2)
BC_FIELD(ALU_WORD1_OP2_EXEC_MASK,     UPDATE_PRED,            UP,         3,  3)
BC_FIELD(ALU_WORD1_OP2_EXEC_MASK,     WRITE_MASK,             WM,         4,  4)
BC_FIELD(ALU_WORD1_OP2_EXEC_MASK,     EXECUTE_MASK_OP,        EMO,        6,  5)
BC_FIELD(ALU_WORD1_OP2_EXEC_MASK,     ALU_INST,               INST,       17, 7)
BC_FIELD(ALU_WORD1_OP2_EXEC_MASK,     BANK_SWIZZLE,           BS,         20, 18)
BC_FIELD(ALU_WORD1_OP2_EXEC_MASK,     DST_GPR,                DGPR,       27, 21)
BC_FIELD(ALU_WORD1_OP2_EXEC_MASK,     DST_REL,                DR,         28, 28)
BC_FIELD(ALU_WORD1_OP2_EXEC_MASK,     DST_CHAN,               DC,         30, 29)
BC_FIELD(ALU_WORD1_OP2_EXEC_MASK,     CLAMP,                  C,          31, 31)
BC_FORMAT_END(ALU_WORD1_OP2_EXEC_MASK)

BC_FORMAT_BEGIN(ALU_WORD1_OP3)
BC_FIELD(ALU_WORD1_OP3,     SRC2_SEL,               S2S,        8,  0)
BC_FIELD(ALU_WORD1_OP3,     SRC2_REL,               S2R,        9,  9)
BC_FIELD(ALU_WORD1_OP3,     SRC2_CHAN,              S2C,        11, 10)
BC_FIELD(ALU_WORD1_OP3,     SRC2_NEG,               S2N,        12, 12)
BC_FIELD(ALU_WORD1_OP3,     ALU_INST,               INST,       17, 13)
BC_FIELD(ALU_WORD1_OP3,     BANK_SWIZZLE,           BS,         20, 18)
BC_FIELD(ALU_WORD1_OP3,     DST_GPR,                DGPR,       27, 21)
BC_FIELD(ALU_WORD1_OP3,     DST_REL,                DR,         28, 28)
BC_FIELD(ALU_WORD1_OP3,     DST_CHAN,               DC,         30, 29)
BC_FIELD(ALU_WORD1_OP3,     CLAMP,                  C,          31, 31)
BC_FORMAT_END(ALU_WORD1_OP3)


BC_FORMAT_BEGIN_HW(ALU_WORD0_LDS_IDX_OP, EGCM)
BC_FIELD(ALU_WORD0_LDS_IDX_OP,      SRC0_SEL,               S0S,        8,  0)
BC_FIELD(ALU_WORD0_LDS_IDX_OP,      SRC0_REL,               S0R,        9,  9)
BC_FIELD(ALU_WORD0_LDS_IDX_OP,      SRC0_CHAN,              S0C,        11, 10)
BC_FIELD(ALU_WORD0_LDS_IDX_OP,      IDX_OFFSET_4,           IO4,        12, 12)
BC_FIELD(ALU_WORD0_LDS_IDX_OP,      SRC1_SEL,               S1S,        21, 13)
BC_FIELD(ALU_WORD0_LDS_IDX_OP,      SRC1_REL,               S1R,        22, 22)
BC_FIELD(ALU_WORD0_LDS_IDX_OP,      SRC1_CHAN,              S1C,        24, 23)
BC_FIELD(ALU_WORD0_LDS_IDX_OP,      IDX_OFFSET_5,           IO5,        25, 25)
BC_FIELD(ALU_WORD0_LDS_IDX_OP,      INDEX_MODE,             IM,         28, 26)
BC_FIELD(ALU_WORD0_LDS_IDX_OP,      PRED_SEL,               PS,         30, 29)
BC_FIELD(ALU_WORD0_LDS_IDX_OP,      LAST,                   L,          31, 31)
BC_FORMAT_END(ALU_WORD0_LDS_IDX_OP)

BC_FORMAT_BEGIN_HW(ALU_WORD1_LDS_IDX_OP, EGCM)
BC_FIELD(ALU_WORD1_LDS_IDX_OP,      SRC2_SEL,               S2S,        8,  0)
BC_FIELD(ALU_WORD1_LDS_IDX_OP,      SRC2_REL,               S2R,        9,  9)
BC_FIELD(ALU_WORD1_LDS_IDX_OP,      SRC2_CHAN,              S2C,        11, 10)
BC_FIELD(ALU_WORD1_LDS_IDX_OP,      IDX_OFFSET_1,           IO1,        12, 12)
BC_FIELD(ALU_WORD1_LDS_IDX_OP,      ALU_INST,               INST,       17, 13)
BC_FIELD(ALU_WORD1_LDS_IDX_OP,      BANK_SWIZZLE,           BS,         20, 18)
BC_FIELD(ALU_WORD1_LDS_IDX_OP,      LDS_OP,                 LDS_OP,     26, 21)
BC_FIELD(ALU_WORD1_LDS_IDX_OP,      IDX_OFFSET_0,           IO0,        27, 27)
BC_FIELD(ALU_WORD1_LDS_IDX_OP,      IDX_OFFSET_2,           IO2,        28, 28)
BC_FIELD(ALU_WORD1_LDS_IDX_OP,      DST_CHAN,               DC,         30, 29)
BC_FIELD(ALU_WORD1_LDS_IDX_OP,      IDX_OFFSET_3,           IO3,        31, 31)
BC_FORMAT_END(ALU_WORD1_LDS_IDX_OP)


BC_FORMAT_BEGIN_HW(ALU_WORD1_LDS_DIRECT_LITERAL_LO, EGCM)
BC_FIELD(ALU_WORD1_LDS_DIRECT_LITERAL_LO,       OFFSET_A,       OFS_A,  12, 0)
BC_FIELD(ALU_WORD1_LDS_DIRECT_LITERAL_LO,       STRIDE_A,       STR_A,  19, 13)
BC_RSRVD(ALU_WORD1_LDS_DIRECT_LITERAL_LO,                               21, 20)
BC_FIELD(ALU_WORD1_LDS_DIRECT_LITERAL_LO,       THREAD_REL_A,   THR_A,  22, 22)
BC_RSRVD(ALU_WORD1_LDS_DIRECT_LITERAL_LO,                               31, 22)
BC_FORMAT_END(ALU_WORD1_LDS_DIRECT_LITERAL_LO)

BC_FORMAT_BEGIN_HW(ALU_WORD1_LDS_DIRECT_LITERAL_HI, EGCM)
BC_FIELD(ALU_WORD1_LDS_DIRECT_LITERAL_HI,       OFFSET_B,       OFS_B,  12, 0)
BC_FIELD(ALU_WORD1_LDS_DIRECT_LITERAL_HI,       STRIDE_B,       STR_B,  19, 13)
BC_RSRVD(ALU_WORD1_LDS_DIRECT_LITERAL_HI,                               21, 20)
BC_FIELD(ALU_WORD1_LDS_DIRECT_LITERAL_HI,       THREAD_REL_B,   THR_B,  22, 22)
BC_RSRVD(ALU_WORD1_LDS_DIRECT_LITERAL_HI,                               30, 22)
BC_FIELD(ALU_WORD1_LDS_DIRECT_LITERAL_HI,       DIRECT_READ_32, DR32,   31, 31)
BC_FORMAT_END(ALU_WORD1_LDS_DIRECT_LITERAL_HI)


// VTX

BC_FORMAT_BEGIN_HW(VTX_WORD0, R6R7EG)
BC_FIELD(VTX_WORD0,     VC_INST,                INST,       4,  0)
BC_FIELD(VTX_WORD0,     FETCH_TYPE,             FT,         6,  5)
BC_FIELD(VTX_WORD0,     FETCH_WHOLE_QUAD,       FWQ,        7,  7)
BC_FIELD(VTX_WORD0,     BUFFER_ID,              BUF_ID,     15, 8)
BC_FIELD(VTX_WORD0,     SRC_GPR,                S_GPR,      22, 16)
BC_FIELD(VTX_WORD0,     SRC_REL,                SR,         23, 23)
BC_FIELD(VTX_WORD0,     SRC_SEL_X,              SSX,        25, 24)
BC_FIELD(VTX_WORD0,     MEGA_FETCH_COUNT,       MFC,        31, 26)
BC_FORMAT_END(VTX_WORD0)

BC_FORMAT_BEGIN_HW(VTX_WORD0, CM)
BC_FIELD(VTX_WORD0,     VC_INST,                INST,       4,  0)
BC_FIELD(VTX_WORD0,     FETCH_TYPE,             FT,         6,  5)
BC_FIELD(VTX_WORD0,     FETCH_WHOLE_QUAD,       FWQ,        7,  7)
BC_FIELD(VTX_WORD0,     BUFFER_ID,              BUF_ID,     15, 8)
BC_FIELD(VTX_WORD0,     SRC_GPR,                S_GPR,      22, 16)
BC_FIELD(VTX_WORD0,     SRC_REL,                SR,         23, 23)
BC_FIELD(VTX_WORD0,     SRC_SEL_X,              SSX,        25, 24)
BC_FIELD(VTX_WORD0,     SRC_SEL_Y,              SSY,        27, 26)
BC_FIELD(VTX_WORD0,     STRUCTURED_READ,        SR,         29, 28)
BC_FIELD(VTX_WORD0,     LDS_REQ,                LR,         30, 30)
BC_FIELD(VTX_WORD0,     COALESCED_READ,         CR,         31, 31)
BC_FORMAT_END(VTX_WORD0)


BC_FORMAT_BEGIN(VTX_WORD1_GPR)
BC_FIELD(VTX_WORD1_GPR,     DST_GPR,                D_GPR,      6,  0)
BC_FIELD(VTX_WORD1_GPR,     DST_REL,                DR,         7,  7)
BC_RSRVD(VTX_WORD1_GPR,                                         8,  8)
BC_FIELD(VTX_WORD1_GPR,     DST_SEL_X,              DSX,        11, 9)
BC_FIELD(VTX_WORD1_GPR,     DST_SEL_Y,              DSY,        14, 12)
BC_FIELD(VTX_WORD1_GPR,     DST_SEL_Z,              DSZ,        17, 15)
BC_FIELD(VTX_WORD1_GPR,     DST_SEL_W,              DSW,        20, 18)
BC_FIELD(VTX_WORD1_GPR,     USE_CONST_FIELDS,       UCF,        21, 21)
BC_FIELD(VTX_WORD1_GPR,     DATA_FORMAT,            DFMT,       27, 22)
BC_FIELD(VTX_WORD1_GPR,     NUM_FORMAT_ALL,         NFA,        29, 28)
BC_FIELD(VTX_WORD1_GPR,     FORMAT_COMP_ALL,        FCA,        30, 30)
BC_FIELD(VTX_WORD1_GPR,     SRF_MODE_ALL,           SMA,        31, 31)
BC_FORMAT_END(VTX_WORD1_GPR)

BC_FORMAT_BEGIN(VTX_WORD1_SEM)
BC_FIELD(VTX_WORD1_SEM,     SEMANTIC_ID,            SID,        7,  0)
BC_RSRVD(VTX_WORD1_SEM,                                         8,  8)
BC_FIELD(VTX_WORD1_SEM,     DST_SEL_X,              DSX,        11, 9)
BC_FIELD(VTX_WORD1_SEM,     DST_SEL_Y,              DSY,        14, 12)
BC_FIELD(VTX_WORD1_SEM,     DST_SEL_Z,              DSZ,        17, 15)
BC_FIELD(VTX_WORD1_SEM,     DST_SEL_W,              DSW,        20, 18)
BC_FIELD(VTX_WORD1_SEM,     USE_CONST_FIELDS,       UCF,        21, 21)
BC_FIELD(VTX_WORD1_SEM,     DATA_FORMAT,            DFMT,       27, 22)
BC_FIELD(VTX_WORD1_SEM,     NUM_FORMAT_ALL,         NFA,        29, 28)
BC_FIELD(VTX_WORD1_SEM,     FORMAT_COMP_ALL,        FCA,        30, 30)
BC_FIELD(VTX_WORD1_SEM,     SRF_MODE_ALL,           SMA,        31, 31)
BC_FORMAT_END(VTX_WORD1_SEM)


BC_FORMAT_BEGIN_HW(VTX_WORD2, R6)
BC_FIELD(VTX_WORD2,     OFFSET,                 OFS,        15, 0)
BC_FIELD(VTX_WORD2,     ENDIAN_SWAP,            ES,         17, 16)
BC_FIELD(VTX_WORD2,     CONST_BUF_NO_STRIDE,    CBNS,       18, 18)
BC_FIELD(VTX_WORD2,     MEGA_FETCH,             MF,         19, 19)
BC_RSRVD(VTX_WORD2,                                         31, 20)
BC_FORMAT_END(VTX_WORD2)

BC_FORMAT_BEGIN_HW(VTX_WORD2, R7)
BC_FIELD(VTX_WORD2,     OFFSET,                 OFS,        15, 0)
BC_FIELD(VTX_WORD2,     ENDIAN_SWAP,            ES,         17, 16)
BC_FIELD(VTX_WORD2,     CONST_BUF_NO_STRIDE,    CBNS,       18, 18)
BC_FIELD(VTX_WORD2,     MEGA_FETCH,             MF,         19, 19)
BC_FIELD(VTX_WORD2,     ALT_CONST,              ALT_C,      20, 20)
BC_RSRVD(VTX_WORD2,                                         31, 21)
BC_FORMAT_END(VTX_WORD2)

BC_FORMAT_BEGIN_HW(VTX_WORD2, EG)
BC_FIELD(VTX_WORD2,     OFFSET,                 OFS,        15, 0)
BC_FIELD(VTX_WORD2,     ENDIAN_SWAP,            ES,         17, 16)
BC_FIELD(VTX_WORD2,     CONST_BUF_NO_STRIDE,    CBNS,       18, 18)
BC_FIELD(VTX_WORD2,     MEGA_FETCH,             MF,         19, 19)
BC_FIELD(VTX_WORD2,     ALT_CONST,              ALT_C,      20, 20)
BC_FIELD(VTX_WORD2,     BUFFER_INDEX_MODE,      BIM,        22, 21)
BC_RSRVD(VTX_WORD2,                                         31, 23)
BC_FORMAT_END(VTX_WORD2)

BC_FORMAT_BEGIN_HW(VTX_WORD2, CM)
BC_FIELD(VTX_WORD2,     OFFSET,                 OFS,        15, 0)
BC_FIELD(VTX_WORD2,     ENDIAN_SWAP,            ES,         17, 16)
BC_FIELD(VTX_WORD2,     CONST_BUF_NO_STRIDE,    CBNS,       18, 18)
BC_RSRVD(VTX_WORD2,                                         19, 19)
BC_FIELD(VTX_WORD2,     ALT_CONST,              ALT_C,      20, 20)
BC_FIELD(VTX_WORD2,     BUFFER_INDEX_MODE,      BIM,        22, 21)
BC_RSRVD(VTX_WORD2,                                         31, 23)
BC_FORMAT_END(VTX_WORD2)

// TEX

BC_FORMAT_BEGIN_HW(TEX_WORD0, R6)
BC_FIELD(TEX_WORD0,     TEX_INST,               T_INST,     4,  0)
BC_FIELD(TEX_WORD0,     BC_FRAC_MODE,           BFM,        5,  5)
BC_RSRVD(TEX_WORD0,                                         6,  6)
BC_FIELD(TEX_WORD0,     FETCH_WHOLE_QUAD,       FWQ,        7,  7)
BC_FIELD(TEX_WORD0,     RESOURCE_ID,            RSRC_ID,    15, 8)
BC_FIELD(TEX_WORD0,     SRC_GPR,                S_GPR,      22, 16)
BC_FIELD(TEX_WORD0,     SRC_REL,                SR,         23, 23)
BC_RSRVD(TEX_WORD0,                                         31, 24)
BC_FORMAT_END(TEX_WORD0)

BC_FORMAT_BEGIN_HW(TEX_WORD0, R7)
BC_FIELD(TEX_WORD0,     TEX_INST,               T_INST,     4,  0)
BC_FIELD(TEX_WORD0,     BC_FRAC_MODE,           BFM,        5,  5)
BC_RSRVD(TEX_WORD0,                                         6,  6)
BC_FIELD(TEX_WORD0,     FETCH_WHOLE_QUAD,       FWQ,        7,  7)
BC_FIELD(TEX_WORD0,     RESOURCE_ID,            RSRC_ID,    15, 8)
BC_FIELD(TEX_WORD0,     SRC_GPR,                S_GPR,      22, 16)
BC_FIELD(TEX_WORD0,     SRC_REL,                SR,         23, 23)
BC_FIELD(TEX_WORD0,     ALT_CONST,              ALT_C,      24, 24)
BC_RSRVD(TEX_WORD0,                                         31, 25)
BC_FORMAT_END(TEX_WORD0)

BC_FORMAT_BEGIN_HW(TEX_WORD0, EGCM)
BC_FIELD(TEX_WORD0,     TEX_INST,               T_INST,     4,  0)
BC_FIELD(TEX_WORD0,     INST_MOD,               IMOD,       6,  5)
BC_FIELD(TEX_WORD0,     FETCH_WHOLE_QUAD,       FWQ,        7,  7)
BC_FIELD(TEX_WORD0,     RESOURCE_ID,            RSRC_ID,    15, 8)
BC_FIELD(TEX_WORD0,     SRC_GPR,                S_GPR,      22, 16)
BC_FIELD(TEX_WORD0,     SRC_REL,                SR,         23, 23)
BC_FIELD(TEX_WORD0,     ALT_CONST,              ALT_C,      24, 24)
BC_FIELD(TEX_WORD0,     RESOURCE_INDEX_MODE,    RIM,        26, 25)
BC_FIELD(TEX_WORD0,     SAMPLER_INDEX_MODE,     SIM,        28, 27)
BC_RSRVD(TEX_WORD0,                                         31, 29)
BC_FORMAT_END(TEX_WORD0)


BC_FORMAT_BEGIN(TEX_WORD1)
BC_FIELD(TEX_WORD1,     DST_GPR,                D_GPR,      6,  0)
BC_FIELD(TEX_WORD1,     DST_REL,                DR,         7,  7)
BC_RSRVD(TEX_WORD1,                                         8,  8)
BC_FIELD(TEX_WORD1,     DST_SEL_X,              DSX,        11, 9)
BC_FIELD(TEX_WORD1,     DST_SEL_Y,              DSY,        14, 12)
BC_FIELD(TEX_WORD1,     DST_SEL_Z,              DSZ,        17, 15)
BC_FIELD(TEX_WORD1,     DST_SEL_W,              DSW,        20, 18)
BC_FIELD(TEX_WORD1,     LOD_BIAS,               LBIAS,      27, 21)
BC_FIELD(TEX_WORD1,     COORD_TYPE_X,           CTX,        28, 28)
BC_FIELD(TEX_WORD1,     COORD_TYPE_Y,           CTY,        29, 29)
BC_FIELD(TEX_WORD1,     COORD_TYPE_Z,           CTZ,        30, 30)
BC_FIELD(TEX_WORD1,     COORD_TYPE_W,           CTW,        31, 31)
BC_FORMAT_END(TEX_WORD1)


BC_FORMAT_BEGIN(TEX_WORD2)
BC_FIELD(TEX_WORD2,     OFFSET_X,               OFS_X,      4,  0)
BC_FIELD(TEX_WORD2,     OFFSET_Y,               OFS_Y,      9,  5)
BC_FIELD(TEX_WORD2,     OFFSET_Z,               OFS_Z,      14, 10)
BC_FIELD(TEX_WORD2,     SAMPLER_ID,             SAMP_ID,    19, 15)
BC_FIELD(TEX_WORD2,     SRC_SEL_X,              SSX,        22, 20)
BC_FIELD(TEX_WORD2,     SRC_SEL_Y,              SSY,        25, 23)
BC_FIELD(TEX_WORD2,     SRC_SEL_Z,              SSZ,        28, 26)
BC_FIELD(TEX_WORD2,     SRC_SEL_W,              SSW,        31, 29)
BC_FORMAT_END(TEX_WORD2)
