# PySNMP SMI module. Autogenerated from smidump -f python TE-LINK-STD-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:39:44 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( InterfaceIndexOrZero, ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndexOrZero", "ifIndex")
( InetAddress, InetAddressType, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressType")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Integer32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, transmission, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "transmission")
( RowStatus, StorageType, TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "StorageType", "TextualConvention")

# Types

class TeLinkBandwidth(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(4,4)
    fixedLength = 4
    
class TeLinkEncodingType(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(9,3,5,1,11,7,2,8,)
    namedValues = NamedValues(("packet", 1), ("fiberChannel", 11), ("ethernet", 2), ("ansiEtsiPdh", 3), ("sdhItuSonetAnsi", 5), ("digitalWrapper", 7), ("lambda", 8), ("fiber", 9), )
    
class TeLinkPriority(TextualConvention, Unsigned32):
    displayHint = "d"
    subtypeSpec = Unsigned32.subtypeSpec+ValueRangeConstraint(0,7)
    
class TeLinkProtection(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(2,1,)
    namedValues = NamedValues(("primary", 1), ("secondary", 2), )
    
class TeLinkSonetSdhIndication(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(0,1,)
    namedValues = NamedValues(("standard", 0), ("arbitrary", 1), )
    
class TeLinkSwitchingCapability(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(100,200,1,3,2,4,150,51,)
    namedValues = NamedValues(("packetSwitch1", 1), ("tdm", 100), ("lambdaSwitch", 150), ("packetSwitch2", 2), ("fiberSwitch", 200), ("packetSwitch3", 3), ("packetSwitch4", 4), ("layer2Switch", 51), )
    

# Objects

teLinkStdMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 200)).setRevisions(("2005-10-11 00:00",))
if mibBuilder.loadTexts: teLinkStdMIB.setOrganization("Multiprotocol Label Switching (MPLS) Working Group")
if mibBuilder.loadTexts: teLinkStdMIB.setContactInfo("        Martin Dubuc\nEmail:  mdubuc@ncf.ca\n\n        Thomas D. Nadeau\nEmail:  tnadeau@cisco.com\n\n\n\n\n        Jonathan P. Lang\nEmail:  jplang@ieee.org\n\nComments about this document should be emailed directly to\nthe MPLS working group mailing list at mpls@uu.net.")
if mibBuilder.loadTexts: teLinkStdMIB.setDescription("Copyright (C) 2005 The Internet Society.  This version of\nthis MIB module is part of RFC 4220; see the RFC\nitself for full legal notices.\n\nThis MIB module contains managed object definitions for\nMPLS traffic engineering links as defined in\n'Link Bundling in MPLS Traffic Engineering (TE)'.")
teLinkNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 200, 0))
teLinkObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 200, 1))
teLinkTable = MibTable((1, 3, 6, 1, 2, 1, 10, 200, 1, 1))
if mibBuilder.loadTexts: teLinkTable.setDescription("This table specifies the grouping of component links into\nTE links and the grouping of TE links into bundled links.")
teLinkEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: teLinkEntry.setDescription("An entry in this table exists for each ifEntry with an\nifType of teLink(200), i.e., for every TE link.  An ifEntry\nin the ifTable must exist before a teLinkEntry is created\nwith the corresponding ifIndex.  If a TE link entry in the\nifTable is destroyed, then so is the corresponding entry\nin the teLinkTable.  The administrative and operational\nstatus values are controlled from the ifEntry.")
teLinkAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 1), InetAddressType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkAddressType.setDescription("The type of Internet address for the TE link.")
teLinkLocalIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 2), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkLocalIpAddr.setDescription("The local Internet address for numbered links.  The type of\nthis address is determined by the value of the\nteLinkAddressType object.\n\nFor IPv4 and IPv6 numbered links, this object represents the\nlocal IP address associated with the TE link.  For an\nunnumbered link, the local address is of type unknown, this\nobject is set to the zero length string, and the\nteLinkOutgoingIfId object then identifies the unnumbered\naddress.\n\nIf the TE link is a Forwarding Adjacency (FA), the local\nIP address is set to the head-end address of the FA-LSP.\n\nIf ipAddrTable is implemented, this object must have the\nsame value as the ipAdEntAddr object that belongs to the\nrow in ipAddrTable where ipAdEntIfIndex is equal to\n\n\n\nifIndex.")
teLinkRemoteIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 3), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkRemoteIpAddr.setDescription("The remote Internet address for numbered links.  The type of\nthis address is determined by the value of the\nteLinkAddressType object.\n\nThe remote IP address associated with the TE link (IPv4 and\nIPv6 numbered links).  For an unnumbered link, the remote\naddress is of type unknown, this object is set to the\nzero length string, and the teLinkIncomingIfId object then\nidentifies the unnumbered address.\n\nIf the TE link is a Forwarding Adjacency, the remote IP\naddress is set to the tail-end address of the FA-LSP.")
teLinkMetric = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 4), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkMetric.setDescription("The traffic engineering metric for the TE link is\nderived from its component links.  All component links\nwithin the TE link must have the same traffic\nengineering metric.")
teLinkMaximumReservableBandwidth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 5), TeLinkBandwidth()).setMaxAccess("readonly")
if mibBuilder.loadTexts: teLinkMaximumReservableBandwidth.setDescription("This attribute specifies the maximum reservable bandwidth on\nthe TE link.  This is the union of the maximum reservable\nbandwidth of all the component links within the\nTE link that can be used to carry live traffic.")
teLinkProtectionType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(4,2,6,3,1,5,)).subtype(namedValues=NamedValues(("extraTraffic", 1), ("unprotected", 2), ("shared", 3), ("dedicated1For1", 4), ("dedicated1Plus1", 5), ("enhanced", 6), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkProtectionType.setDescription("This attribute specifies the link protection type of the\nTE link.  Descriptions of the different protection types can\nbe found in the 'Routing Extensions in Support of\nGeneralized Multi-Protocol Label Switching (GMPLS)'\ndocument.")
teLinkWorkingPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 7), TeLinkPriority()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkWorkingPriority.setDescription("This object represents a priority value such that a new\nconnection with a higher priority, i.e., numerically lower\nthan this value, is guaranteed to be setup on a primary\nlink and not on a secondary link.")
teLinkResourceClass = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 8), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkResourceClass.setDescription("This attribute specifies the TE link resource class.\nThe resource class is a 32 bit bitfield.  The resource class\nfor a link bundle is derived from the resource class of its\n\n\n\nTE links.  All TE links within a link bundle must have the\nsame resource class.  Encoding of the resource class is\ndescribed in the 'Traffic Engineering (TE) Extensions to\nOSPF Version 2' document.")
teLinkIncomingIfId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkIncomingIfId.setDescription("For unnumbered links, the incoming interface is set to the\noutgoing interface identifier chosen by the neighboring LSR\nfor the reverse link corresponding to this TE link.  If the\nlink is numbered, the value of this object is 0 and the\naddress is stored in the teLinkRemoteIpAddr instead.")
teLinkOutgoingIfId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 10), InterfaceIndexOrZero()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkOutgoingIfId.setDescription("If the link is unnumbered, the outgoing interface identifier\nis set to the outgoing interface identifier chosen for the\nTE link by the advertising LSR.  If the link is numbered, the\nvalue of this object is 0 and the address is stored in the\nteLinkLocalIpAddr instead.")
teLinkRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 11), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkRowStatus.setDescription("This variable is used to create, modify, and/or\ndelete a row in this table.  None of the writable objects in\na row can be changed if status is active(1).")
teLinkStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 1, 1, 12), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkStorageType.setDescription("The storage type for this conceptual row in the\nteLinkTable.  Conceptual rows having the value\n'permanent' need not allow write-access to any\ncolumnar object in the row.")
teLinkDescriptorTable = MibTable((1, 3, 6, 1, 2, 1, 10, 200, 1, 2))
if mibBuilder.loadTexts: teLinkDescriptorTable.setDescription("This table specifies the interface switching capability\ndescriptors associated with the TE links.")
teLinkDescriptorEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "TE-LINK-STD-MIB", "teLinkDescriptorId"))
if mibBuilder.loadTexts: teLinkDescriptorEntry.setDescription("An entry in this table is created for every TE link interface\nswitching capability descriptor.  An ifEntry in the ifTable\nmust exist before a teLinkDescriptorEntry using the same\nifIndex is created.  ifType of ifEntry must be teLink(200).\nIf a TE link entry in the ifTable is destroyed, then so are\nall of the entries in the teLinkDescriptorTable that use the\nifIndex of this TE link.")
teLinkDescriptorId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: teLinkDescriptorId.setDescription("This object specifies the link descriptor identifier.")
teLinkDescrSwitchingCapability = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 2), TeLinkSwitchingCapability()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrSwitchingCapability.setDescription("This attribute specifies interface switching capability of\nthe TE link, which is derived from its component links.")
teLinkDescrEncodingType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 3), TeLinkEncodingType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrEncodingType.setDescription("This attribute specifies the TE link encoding type.")
teLinkDescrMinLspBandwidth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 4), TeLinkBandwidth()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrMinLspBandwidth.setDescription("This attribute specifies the minimum LSP bandwidth on\nthe TE link.  This is derived from the union of the\nminimum LSP bandwidth of all the component links\nassociated with the TE link that can be used to carry\nlive traffic.")
teLinkDescrMaxLspBandwidthPrio0 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 5), TeLinkBandwidth()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrMaxLspBandwidthPrio0.setDescription("This attribute specifies the maximum LSP bandwidth at\npriority 0 on the TE link.  This is the union of the maximum\nLSP bandwidth at priority 0 of all the component links within\nthe TE link that can be used to carry live traffic.")
teLinkDescrMaxLspBandwidthPrio1 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 6), TeLinkBandwidth()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrMaxLspBandwidthPrio1.setDescription("This attribute specifies the maximum LSP bandwidth at\npriority 1 on the TE link.  This is the union of the maximum\nLSP bandwidth at priority 1 of all the component links within\nthe TE link that can be used to carry live traffic.")
teLinkDescrMaxLspBandwidthPrio2 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 7), TeLinkBandwidth()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrMaxLspBandwidthPrio2.setDescription("This attribute specifies the maximum LSP bandwidth at\npriority 2 on the TE link.  This is the union of the maximum\n\n\n\nLSP bandwidth at priority 2 of all the component links within\nthe TE link that can be used to carry live traffic.")
teLinkDescrMaxLspBandwidthPrio3 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 8), TeLinkBandwidth()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrMaxLspBandwidthPrio3.setDescription("This attribute specifies the maximum LSP bandwidth at\npriority 3 on the TE link.  This is the union of the maximum\nLSP bandwidth at priority 3 of all the component links within\nthe TE link that can be used to carry live traffic.")
teLinkDescrMaxLspBandwidthPrio4 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 9), TeLinkBandwidth()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrMaxLspBandwidthPrio4.setDescription("This attribute specifies the maximum LSP bandwidth at\npriority 4 on the TE link.  This is the union of the maximum\nLSP bandwidth at priority 4 of all the component links within\nthe TE link that can be used to carry live traffic.")
teLinkDescrMaxLspBandwidthPrio5 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 10), TeLinkBandwidth()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrMaxLspBandwidthPrio5.setDescription("This attribute specifies the maximum LSP bandwidth at\npriority 5 on the TE link.  This is the union of the maximum\nLSP bandwidth at priority 5 of all the component links within\nthe TE link that can be used to carry live traffic.")
teLinkDescrMaxLspBandwidthPrio6 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 11), TeLinkBandwidth()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrMaxLspBandwidthPrio6.setDescription("This attribute specifies the maximum LSP bandwidth at\npriority 6 on the TE link.  This is the union of the maximum\nLSP bandwidth at priority 6 of all the component links within\nthe TE link that can be used to carry live traffic.")
teLinkDescrMaxLspBandwidthPrio7 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 12), TeLinkBandwidth()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrMaxLspBandwidthPrio7.setDescription("This attribute specifies the maximum LSP bandwidth at\npriority 7 on the TE link.  This is the union of the maximum\nLSP bandwidth at priority 7 of all the component links within\nthe TE link that can be used to carry live traffic.")
teLinkDescrInterfaceMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 13), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrInterfaceMtu.setDescription("This attribute specifies the interface MTU for the TE\nlink descriptor.")
teLinkDescrIndication = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 14), TeLinkSonetSdhIndication()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrIndication.setDescription("This attribute specifies whether this interface supports\nStandard or Arbitrary SONET/SDH.")
teLinkDescrRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 15), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrRowStatus.setDescription("This variable is used to create, modify, and/or\ndelete a row in this table.  No read-create object\ncan be changed if teLinkDescrRowStatus is in the active(1)\nstate.")
teLinkDescrStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 2, 1, 16), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkDescrStorageType.setDescription("The storage type for this conceptual row in the\nteLinkDescriptorTable.  Conceptual rows having the value\n'permanent' need not allow write-access to any\ncolumnar object in the row.")
teLinkSrlgTable = MibTable((1, 3, 6, 1, 2, 1, 10, 200, 1, 3))
if mibBuilder.loadTexts: teLinkSrlgTable.setDescription("This table specifies the SRLGs associated with TE links.")
teLinkSrlgEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 200, 1, 3, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "TE-LINK-STD-MIB", "teLinkSrlg"))
if mibBuilder.loadTexts: teLinkSrlgEntry.setDescription("An entry in this table contains information about an\nSRLG associated with a TE link.\nAn ifEntry in the ifTable must exist before a\nteLinkSrlgEntry using the same ifIndex is created.\nThe ifType of ifEntry must be teLink(200).\nIf a TE link entry in the ifTable is destroyed, then so\nare all of the entries in the teLinkSrlgTable that use the\nifIndex of this TE link.")
teLinkSrlg = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 3, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: teLinkSrlg.setDescription("This identifies an SRLG supported by the TE link.  An SRLG is\nidentified with a 32-bit number that is unique within an IGP\ndomain.  Zero is a valid SRLG number.")
teLinkSrlgRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 3, 1, 2), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkSrlgRowStatus.setDescription("This variable is used to create, modify, and/or\ndelete a row in this table.  No read-create object can\nbe modified if teLinkSrlgRowStatus is active(1).")
teLinkSrlgStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 3, 1, 3), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkSrlgStorageType.setDescription("The storage type for this conceptual row in the\n\n\n\nteLinkSrlgTable.  Conceptual rows having the value\n'permanent' need not allow write-access to any\ncolumnar object in the row.")
teLinkBandwidthTable = MibTable((1, 3, 6, 1, 2, 1, 10, 200, 1, 4))
if mibBuilder.loadTexts: teLinkBandwidthTable.setDescription("This table specifies the priority-based bandwidth table\nfor TE links.")
teLinkBandwidthEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 200, 1, 4, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "TE-LINK-STD-MIB", "teLinkBandwidthPriority"))
if mibBuilder.loadTexts: teLinkBandwidthEntry.setDescription("An entry in this table contains information about\nthe priority-based bandwidth of TE links.  An ifEntry in the\nifTable must exist before a teLinkBandwidthEntry using the\nsame ifIndex is created.  The ifType of ifEntry must be\nteLink(200).  If a TE link entry in the ifTable is destroyed,\nthen so are all of the entries in the teLinkBandwidthTable\nthat use the ifIndex of this TE link.")
teLinkBandwidthPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 4, 1, 1), TeLinkPriority()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: teLinkBandwidthPriority.setDescription("This attribute specifies the priority.  A value of 0 is valid\nas specified in the 'Traffic Engineering (TE) Extensions to\n\n\n\nOSPF Version 2' document.")
teLinkBandwidthUnreserved = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 4, 1, 2), TeLinkBandwidth()).setMaxAccess("readonly")
if mibBuilder.loadTexts: teLinkBandwidthUnreserved.setDescription("This attribute specifies the TE link unreserved\nbandwidth at priority p.  It is the sum of the unreserved\nbandwidths at priority p of all component links associated\nwith the TE link (excluding all links that are strictly\nused as protecting links).")
teLinkBandwidthRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 4, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkBandwidthRowStatus.setDescription("This variable is used to create, modify, and/or\ndelete a row in this table.  No read-create object\ncan be modified when teLinkBandwidthRowStatus is active(1).")
teLinkBandwidthStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 4, 1, 4), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teLinkBandwidthStorageType.setDescription("The storage type for this conceptual row in the\nteLinkBandwidthTable.  Conceptual rows having the value\n'permanent' need not allow write-access to any\ncolumnar object in the row.")
componentLinkTable = MibTable((1, 3, 6, 1, 2, 1, 10, 200, 1, 5))
if mibBuilder.loadTexts: componentLinkTable.setDescription("This table specifies the component link parameters.")
componentLinkEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 200, 1, 5, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: componentLinkEntry.setDescription("An entry in this table exists for each ifEntry that\nrepresents a component link.  An ifEntry must exist in\nthe ifTable before a componentLinkEntry is created with\nthe corresponding ifIndex.  ifEntry's ifType can be\nof any interface type that has been defined for TE Link\ninterworking.  Examples include ATM, Frame Relay, Ethernet,\netc.  If an entry representing a component link is destroyed\nin the ifTable, then so is the corresponding entry in the\ncomponentLinkTable.  The administrative and operational\nstatus values are controlled from the ifEntry.")
componentLinkMaxResBandwidth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 5, 1, 1), TeLinkBandwidth()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkMaxResBandwidth.setDescription("This attribute specifies the maximum reservable bandwidth on\nthe component link.")
componentLinkPreferredProtection = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 5, 1, 2), TeLinkProtection()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkPreferredProtection.setDescription("This attribute specifies whether this component link is\na primary or secondary entity.")
componentLinkCurrentProtection = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 5, 1, 3), TeLinkProtection()).setMaxAccess("readonly")
if mibBuilder.loadTexts: componentLinkCurrentProtection.setDescription("This attribute specifies whether this component link is\ncurrently used as primary or secondary link.")
componentLinkRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 5, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkRowStatus.setDescription("This variable is used to create, modify, and/or\ndelete a row in this table.  No read-create object\ncan be modified when componentLinkRowStatus is active(1).")
componentLinkStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 5, 1, 5), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkStorageType.setDescription("The storage type for this conceptual row in the\ncomponentLinkTable.  Conceptual rows having the value\n'permanent' need not allow write-access to any\ncolumnar object in the row.")
componentLinkDescriptorTable = MibTable((1, 3, 6, 1, 2, 1, 10, 200, 1, 6))
if mibBuilder.loadTexts: componentLinkDescriptorTable.setDescription("This table specifies the interface switching capability\ndescriptors associated with the component links.")
componentLinkDescriptorEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "TE-LINK-STD-MIB", "componentLinkDescrId"))
if mibBuilder.loadTexts: componentLinkDescriptorEntry.setDescription("An entry in this table is created for every component link\ndescriptor.  An ifEntry in the ifTable must exist before a\ncomponentLinkDescriptorEntry using the same ifIndex is\ncreated.  ifEntry's ifType can be of any interface type that\nhas been defined for TE Link interworking.  Examples include\nATM, Frame Relay, Ethernet, etc.  If a component link entry\nin the ifTable is destroyed, then so are all entries in the\ncomponentLinkDescriptorTable that use the ifIndex of this\ncomponent link.")
componentLinkDescrId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: componentLinkDescrId.setDescription("This object specifies the link descriptor identifier.")
componentLinkDescrSwitchingCapability = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 2), TeLinkSwitchingCapability()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrSwitchingCapability.setDescription("This attribute specifies link multiplexing capabilities of\nthe component link.")
componentLinkDescrEncodingType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 3), TeLinkEncodingType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrEncodingType.setDescription("This attribute specifies the component link encoding type.")
componentLinkDescrMinLspBandwidth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 4), TeLinkBandwidth()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrMinLspBandwidth.setDescription("This attribute specifies the minimum LSP bandwidth on\nthe component link.")
componentLinkDescrMaxLspBandwidthPrio0 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 5), TeLinkBandwidth()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrMaxLspBandwidthPrio0.setDescription("This attribute specifies the maximum LSP bandwidth at\npriority 0 on the component link.")
componentLinkDescrMaxLspBandwidthPrio1 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 6), TeLinkBandwidth()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrMaxLspBandwidthPrio1.setDescription("This attribute specifies the maximum LSP bandwidth at\npriority 1 on the component link.")
componentLinkDescrMaxLspBandwidthPrio2 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 7), TeLinkBandwidth()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrMaxLspBandwidthPrio2.setDescription("This attribute specifies the maximum LSP bandwidth at\npriority 2 on the component link.")
componentLinkDescrMaxLspBandwidthPrio3 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 8), TeLinkBandwidth()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrMaxLspBandwidthPrio3.setDescription("This attribute specifies the maximum LSP bandwidth at\npriority 3 on the component link.")
componentLinkDescrMaxLspBandwidthPrio4 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 9), TeLinkBandwidth()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrMaxLspBandwidthPrio4.setDescription("This attribute specifies the maximum LSP bandwidth at\npriority 4 on the component link.")
componentLinkDescrMaxLspBandwidthPrio5 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 10), TeLinkBandwidth()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrMaxLspBandwidthPrio5.setDescription("This attribute specifies the maximum LSP bandwidth at\npriority 5 on the component link.")
componentLinkDescrMaxLspBandwidthPrio6 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 11), TeLinkBandwidth()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrMaxLspBandwidthPrio6.setDescription("This attribute specifies the maximum LSP bandwidth at\npriority 6 on the component link.")
componentLinkDescrMaxLspBandwidthPrio7 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 12), TeLinkBandwidth()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrMaxLspBandwidthPrio7.setDescription("This attribute specifies the maximum LSP bandwidth at\npriority 7 on the component link.")
componentLinkDescrInterfaceMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 13), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrInterfaceMtu.setDescription("This attribute specifies the interface MTU for the component\nlink descriptor.")
componentLinkDescrIndication = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 14), TeLinkSonetSdhIndication()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrIndication.setDescription("This attribute specifies whether this interface supports\nStandard or Arbitrary SONET/SDH.")
componentLinkDescrRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 15), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrRowStatus.setDescription("This variable is used to create, modify, and/or\ndelete a row in this table.  No read-create object\ncan be modified when componentLinkDescrRowStatus\nis active(1).")
componentLinkDescrStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 6, 1, 16), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkDescrStorageType.setDescription("The storage type for this conceptual row in the\ncomponentLinkDescriptorTable.  Conceptual rows\nhaving the value 'permanent' need not allow write-access\nto any columnar object in the row.")
componentLinkBandwidthTable = MibTable((1, 3, 6, 1, 2, 1, 10, 200, 1, 7))
if mibBuilder.loadTexts: componentLinkBandwidthTable.setDescription("This table specifies the priority-based bandwidth\nfor component links.")
componentLinkBandwidthEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 200, 1, 7, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "TE-LINK-STD-MIB", "componentLinkBandwidthPriority"))
if mibBuilder.loadTexts: componentLinkBandwidthEntry.setDescription("An entry in this table contains information about\nthe priority-based bandwidth on component links.\nAn ifEntry in the ifTable must exist before a\ncomponentLinkBandwidthEntry using the same ifIndex is\ncreated.  ifEntry's ifType can be of any interface type that\nhas been defined for TE Link interworking.  Examples\ninclude ATM, Frame Relay, Ethernet, etc.  If a component link\nentry in the ifTable is destroyed, then so are all entries\nin the componentLinkBandwidthTable that use the ifIndex of\nthis component link.")
componentLinkBandwidthPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 7, 1, 1), TeLinkPriority()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: componentLinkBandwidthPriority.setDescription("This attribute specifies the priority.  A value of 0 is valid\nas specified in the 'Traffic Engineering (TE) Extensions to\n OSPF Version 2' document.")
componentLinkBandwidthUnreserved = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 7, 1, 2), TeLinkBandwidth()).setMaxAccess("readonly")
if mibBuilder.loadTexts: componentLinkBandwidthUnreserved.setDescription("This attribute specifies the component link unreserved\nbandwidth at priority p.")
componentLinkBandwidthRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 7, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkBandwidthRowStatus.setDescription("This variable is used to create, modify, and/or\ndelete a row in this table.  No read-create object can\nbe modified when componentLinkBandwidthRowStatus is\nactive(1).")
componentLinkBandwidthStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 200, 1, 7, 1, 4), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: componentLinkBandwidthStorageType.setDescription("The storage type for this conceptual row in the\ncomponentLinkBandwidthTable.  Conceptual rows\nhaving the value 'permanent' need not allow write-access\nto any columnar object in the row.")
teLinkConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 200, 2))
teLinkCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 200, 2, 1))
teLinkGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 200, 2, 2))

# Augmentions

# Groups

teLinkGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 200, 2, 2, 1)).setObjects(*(("TE-LINK-STD-MIB", "teLinkAddressType"), ("TE-LINK-STD-MIB", "teLinkProtectionType"), ("TE-LINK-STD-MIB", "teLinkIncomingIfId"), ("TE-LINK-STD-MIB", "teLinkStorageType"), ("TE-LINK-STD-MIB", "teLinkWorkingPriority"), ("TE-LINK-STD-MIB", "componentLinkCurrentProtection"), ("TE-LINK-STD-MIB", "teLinkDescrRowStatus"), ("TE-LINK-STD-MIB", "componentLinkDescrEncodingType"), ("TE-LINK-STD-MIB", "componentLinkRowStatus"), ("TE-LINK-STD-MIB", "componentLinkStorageType"), ("TE-LINK-STD-MIB", "teLinkDescrSwitchingCapability"), ("TE-LINK-STD-MIB", "teLinkDescrStorageType"), ("TE-LINK-STD-MIB", "componentLinkPreferredProtection"), ("TE-LINK-STD-MIB", "teLinkRowStatus"), ("TE-LINK-STD-MIB", "teLinkDescrEncodingType"), ("TE-LINK-STD-MIB", "teLinkResourceClass"), ("TE-LINK-STD-MIB", "teLinkRemoteIpAddr"), ("TE-LINK-STD-MIB", "teLinkLocalIpAddr"), ("TE-LINK-STD-MIB", "componentLinkDescrRowStatus"), ("TE-LINK-STD-MIB", "componentLinkDescrSwitchingCapability"), ("TE-LINK-STD-MIB", "componentLinkDescrStorageType"), ("TE-LINK-STD-MIB", "teLinkOutgoingIfId"), ("TE-LINK-STD-MIB", "teLinkMetric"), ) )
if mibBuilder.loadTexts: teLinkGroup.setDescription("Collection of objects needed for the management of\nresources associated with TE links.")
teLinkSrlgGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 200, 2, 2, 2)).setObjects(*(("TE-LINK-STD-MIB", "teLinkSrlgStorageType"), ("TE-LINK-STD-MIB", "teLinkSrlgRowStatus"), ) )
if mibBuilder.loadTexts: teLinkSrlgGroup.setDescription("Collection of objects needed for the management of\nSRLG resources associated with TE links.")
teLinkBandwidthGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 200, 2, 2, 3)).setObjects(*(("TE-LINK-STD-MIB", "teLinkBandwidthUnreserved"), ("TE-LINK-STD-MIB", "teLinkBandwidthRowStatus"), ("TE-LINK-STD-MIB", "teLinkMaximumReservableBandwidth"), ("TE-LINK-STD-MIB", "teLinkBandwidthStorageType"), ("TE-LINK-STD-MIB", "teLinkDescrMaxLspBandwidthPrio7"), ("TE-LINK-STD-MIB", "teLinkDescrMaxLspBandwidthPrio6"), ("TE-LINK-STD-MIB", "teLinkDescrMaxLspBandwidthPrio5"), ("TE-LINK-STD-MIB", "teLinkDescrMaxLspBandwidthPrio4"), ("TE-LINK-STD-MIB", "teLinkDescrMaxLspBandwidthPrio3"), ("TE-LINK-STD-MIB", "teLinkDescrMaxLspBandwidthPrio2"), ("TE-LINK-STD-MIB", "teLinkDescrMaxLspBandwidthPrio1"), ("TE-LINK-STD-MIB", "teLinkDescrMaxLspBandwidthPrio0"), ) )
if mibBuilder.loadTexts: teLinkBandwidthGroup.setDescription("Collection of objects needed for the management of\nthe bandwidth resources associated with TE links and\ncomponent links.")
componentLinkBandwidthGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 200, 2, 2, 4)).setObjects(*(("TE-LINK-STD-MIB", "componentLinkBandwidthStorageType"), ("TE-LINK-STD-MIB", "componentLinkBandwidthUnreserved"), ("TE-LINK-STD-MIB", "componentLinkDescrMaxLspBandwidthPrio6"), ("TE-LINK-STD-MIB", "componentLinkBandwidthRowStatus"), ("TE-LINK-STD-MIB", "componentLinkDescrMaxLspBandwidthPrio2"), ("TE-LINK-STD-MIB", "componentLinkDescrMaxLspBandwidthPrio3"), ("TE-LINK-STD-MIB", "componentLinkDescrMaxLspBandwidthPrio0"), ("TE-LINK-STD-MIB", "componentLinkDescrMaxLspBandwidthPrio1"), ("TE-LINK-STD-MIB", "componentLinkMaxResBandwidth"), ("TE-LINK-STD-MIB", "componentLinkDescrMaxLspBandwidthPrio7"), ("TE-LINK-STD-MIB", "componentLinkDescrMaxLspBandwidthPrio4"), ("TE-LINK-STD-MIB", "componentLinkDescrMaxLspBandwidthPrio5"), ) )
if mibBuilder.loadTexts: componentLinkBandwidthGroup.setDescription("Collection of objects needed for the management of the\nbandwidth parameters associated with component links.")
teLinkPscGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 200, 2, 2, 5)).setObjects(*(("TE-LINK-STD-MIB", "teLinkDescrInterfaceMtu"), ("TE-LINK-STD-MIB", "teLinkDescrMinLspBandwidth"), ("TE-LINK-STD-MIB", "componentLinkDescrMinLspBandwidth"), ("TE-LINK-STD-MIB", "componentLinkDescrInterfaceMtu"), ) )
if mibBuilder.loadTexts: teLinkPscGroup.setDescription("Collection of objects needed for devices that are\npacket switch capable.")
teLinkTdmGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 200, 2, 2, 6)).setObjects(*(("TE-LINK-STD-MIB", "teLinkDescrMinLspBandwidth"), ("TE-LINK-STD-MIB", "teLinkDescrIndication"), ("TE-LINK-STD-MIB", "componentLinkDescrMinLspBandwidth"), ("TE-LINK-STD-MIB", "componentLinkDescrIndication"), ) )
if mibBuilder.loadTexts: teLinkTdmGroup.setDescription("Collection of objects needed for devices that are\nTDM switching capable.")

# Compliances

teLinkModuleFullCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 200, 2, 1, 1)).setObjects(*(("TE-LINK-STD-MIB", "teLinkBandwidthGroup"), ("TE-LINK-STD-MIB", "teLinkGroup"), ("TE-LINK-STD-MIB", "teLinkTdmGroup"), ("TE-LINK-STD-MIB", "teLinkSrlgGroup"), ("TE-LINK-STD-MIB", "teLinkPscGroup"), ("TE-LINK-STD-MIB", "componentLinkBandwidthGroup"), ) )
if mibBuilder.loadTexts: teLinkModuleFullCompliance.setDescription("Compliance statement for agents that support read-create\nso that both configuration and monitoring of TE links can\nbe accomplished via this MIB module.")
teLinkModuleReadOnlyCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 200, 2, 1, 2)).setObjects(*(("TE-LINK-STD-MIB", "teLinkBandwidthGroup"), ("TE-LINK-STD-MIB", "teLinkGroup"), ("TE-LINK-STD-MIB", "teLinkTdmGroup"), ("TE-LINK-STD-MIB", "teLinkSrlgGroup"), ("TE-LINK-STD-MIB", "teLinkPscGroup"), ("TE-LINK-STD-MIB", "componentLinkBandwidthGroup"), ) )
if mibBuilder.loadTexts: teLinkModuleReadOnlyCompliance.setDescription("Compliance statement for agents that support the\nmonitoring of the TE link MIB module.")

# Exports

# Module identity
mibBuilder.exportSymbols("TE-LINK-STD-MIB", PYSNMP_MODULE_ID=teLinkStdMIB)

# Types
mibBuilder.exportSymbols("TE-LINK-STD-MIB", TeLinkBandwidth=TeLinkBandwidth, TeLinkEncodingType=TeLinkEncodingType, TeLinkPriority=TeLinkPriority, TeLinkProtection=TeLinkProtection, TeLinkSonetSdhIndication=TeLinkSonetSdhIndication, TeLinkSwitchingCapability=TeLinkSwitchingCapability)

# Objects
mibBuilder.exportSymbols("TE-LINK-STD-MIB", teLinkStdMIB=teLinkStdMIB, teLinkNotifications=teLinkNotifications, teLinkObjects=teLinkObjects, teLinkTable=teLinkTable, teLinkEntry=teLinkEntry, teLinkAddressType=teLinkAddressType, teLinkLocalIpAddr=teLinkLocalIpAddr, teLinkRemoteIpAddr=teLinkRemoteIpAddr, teLinkMetric=teLinkMetric, teLinkMaximumReservableBandwidth=teLinkMaximumReservableBandwidth, teLinkProtectionType=teLinkProtectionType, teLinkWorkingPriority=teLinkWorkingPriority, teLinkResourceClass=teLinkResourceClass, teLinkIncomingIfId=teLinkIncomingIfId, teLinkOutgoingIfId=teLinkOutgoingIfId, teLinkRowStatus=teLinkRowStatus, teLinkStorageType=teLinkStorageType, teLinkDescriptorTable=teLinkDescriptorTable, teLinkDescriptorEntry=teLinkDescriptorEntry, teLinkDescriptorId=teLinkDescriptorId, teLinkDescrSwitchingCapability=teLinkDescrSwitchingCapability, teLinkDescrEncodingType=teLinkDescrEncodingType, teLinkDescrMinLspBandwidth=teLinkDescrMinLspBandwidth, teLinkDescrMaxLspBandwidthPrio0=teLinkDescrMaxLspBandwidthPrio0, teLinkDescrMaxLspBandwidthPrio1=teLinkDescrMaxLspBandwidthPrio1, teLinkDescrMaxLspBandwidthPrio2=teLinkDescrMaxLspBandwidthPrio2, teLinkDescrMaxLspBandwidthPrio3=teLinkDescrMaxLspBandwidthPrio3, teLinkDescrMaxLspBandwidthPrio4=teLinkDescrMaxLspBandwidthPrio4, teLinkDescrMaxLspBandwidthPrio5=teLinkDescrMaxLspBandwidthPrio5, teLinkDescrMaxLspBandwidthPrio6=teLinkDescrMaxLspBandwidthPrio6, teLinkDescrMaxLspBandwidthPrio7=teLinkDescrMaxLspBandwidthPrio7, teLinkDescrInterfaceMtu=teLinkDescrInterfaceMtu, teLinkDescrIndication=teLinkDescrIndication, teLinkDescrRowStatus=teLinkDescrRowStatus, teLinkDescrStorageType=teLinkDescrStorageType, teLinkSrlgTable=teLinkSrlgTable, teLinkSrlgEntry=teLinkSrlgEntry, teLinkSrlg=teLinkSrlg, teLinkSrlgRowStatus=teLinkSrlgRowStatus, teLinkSrlgStorageType=teLinkSrlgStorageType, teLinkBandwidthTable=teLinkBandwidthTable, teLinkBandwidthEntry=teLinkBandwidthEntry, teLinkBandwidthPriority=teLinkBandwidthPriority, teLinkBandwidthUnreserved=teLinkBandwidthUnreserved, teLinkBandwidthRowStatus=teLinkBandwidthRowStatus, teLinkBandwidthStorageType=teLinkBandwidthStorageType, componentLinkTable=componentLinkTable, componentLinkEntry=componentLinkEntry, componentLinkMaxResBandwidth=componentLinkMaxResBandwidth, componentLinkPreferredProtection=componentLinkPreferredProtection, componentLinkCurrentProtection=componentLinkCurrentProtection, componentLinkRowStatus=componentLinkRowStatus, componentLinkStorageType=componentLinkStorageType, componentLinkDescriptorTable=componentLinkDescriptorTable, componentLinkDescriptorEntry=componentLinkDescriptorEntry, componentLinkDescrId=componentLinkDescrId, componentLinkDescrSwitchingCapability=componentLinkDescrSwitchingCapability, componentLinkDescrEncodingType=componentLinkDescrEncodingType, componentLinkDescrMinLspBandwidth=componentLinkDescrMinLspBandwidth, componentLinkDescrMaxLspBandwidthPrio0=componentLinkDescrMaxLspBandwidthPrio0, componentLinkDescrMaxLspBandwidthPrio1=componentLinkDescrMaxLspBandwidthPrio1, componentLinkDescrMaxLspBandwidthPrio2=componentLinkDescrMaxLspBandwidthPrio2, componentLinkDescrMaxLspBandwidthPrio3=componentLinkDescrMaxLspBandwidthPrio3, componentLinkDescrMaxLspBandwidthPrio4=componentLinkDescrMaxLspBandwidthPrio4, componentLinkDescrMaxLspBandwidthPrio5=componentLinkDescrMaxLspBandwidthPrio5, componentLinkDescrMaxLspBandwidthPrio6=componentLinkDescrMaxLspBandwidthPrio6, componentLinkDescrMaxLspBandwidthPrio7=componentLinkDescrMaxLspBandwidthPrio7, componentLinkDescrInterfaceMtu=componentLinkDescrInterfaceMtu, componentLinkDescrIndication=componentLinkDescrIndication, componentLinkDescrRowStatus=componentLinkDescrRowStatus, componentLinkDescrStorageType=componentLinkDescrStorageType, componentLinkBandwidthTable=componentLinkBandwidthTable, componentLinkBandwidthEntry=componentLinkBandwidthEntry, componentLinkBandwidthPriority=componentLinkBandwidthPriority, componentLinkBandwidthUnreserved=componentLinkBandwidthUnreserved, componentLinkBandwidthRowStatus=componentLinkBandwidthRowStatus, componentLinkBandwidthStorageType=componentLinkBandwidthStorageType, teLinkConformance=teLinkConformance, teLinkCompliances=teLinkCompliances, teLinkGroups=teLinkGroups)

# Groups
mibBuilder.exportSymbols("TE-LINK-STD-MIB", teLinkGroup=teLinkGroup, teLinkSrlgGroup=teLinkSrlgGroup, teLinkBandwidthGroup=teLinkBandwidthGroup, componentLinkBandwidthGroup=componentLinkBandwidthGroup, teLinkPscGroup=teLinkPscGroup, teLinkTdmGroup=teLinkTdmGroup)

# Compliances
mibBuilder.exportSymbols("TE-LINK-STD-MIB", teLinkModuleFullCompliance=teLinkModuleFullCompliance, teLinkModuleReadOnlyCompliance=teLinkModuleReadOnlyCompliance)
