/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "sr" locale.
 */
public class LocalizedNamesImpl_sr extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AZ",
        "AX",
        "AL",
        "DZ",
        "AS",
        "AI",
        "AO",
        "AD",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "BD",
        "BB",
        "BS",
        "BH",
        "BE",
        "BZ",
        "BY",
        "BJ",
        "BM",
        "CX",
        "BO",
        "BA",
        "BW",
        "BR",
        "VG",
        "IO",
        "BN",
        "BV",
        "BG",
        "BF",
        "BI",
        "BT",
        "WF",
        "VU",
        "VA",
        "GB",
        "VE",
        "VN",
        "GA",
        "GM",
        "GH",
        "GP",
        "GY",
        "GT",
        "GN",
        "GW",
        "GI",
        "GD",
        "GL",
        "GE",
        "GR",
        "GU",
        "GG",
        "DK",
        "DG",
        "DM",
        "DO",
        "EU",
        "EG",
        "EC",
        "GQ",
        "ER",
        "EE",
        "ET",
        "ZM",
        "EH",
        "ZW",
        "IL",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "TL",
        "IT",
        "JM",
        "JP",
        "YE",
        "JO",
        "KR",
        "GS",
        "ZA",
        "KZ",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "CV",
        "QA",
        "KE",
        "CN",
        "CY",
        "KG",
        "KI",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "CR",
        "CU",
        "KW",
        "CK",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LT",
        "LI",
        "LU",
        "MG",
        "HU",
        "YT",
        "MO",
        "MK",
        "MW",
        "MV",
        "MY",
        "ML",
        "MT",
        "UM",
        "MA",
        "MQ",
        "MH",
        "MR",
        "MU",
        "MX",
        "MM",
        "FM",
        "MZ",
        "MD",
        "MC",
        "MN",
        "MS",
        "NA",
        "NR",
        "DE",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NC",
        "NZ",
        "NO",
        "NF",
        "CI",
        "OM",
        "QO",
        "AC",
        "CP",
        "IM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PR",
        "PT",
        "RE",
        "RW",
        "RO",
        "RU",
        "VI",
        "SV",
        "WS",
        "SM",
        "ST",
        "SA",
        "SZ",
        "SJ",
        "SH",
        "BL",
        "KP",
        "MP",
        "SC",
        "SN",
        "PM",
        "VC",
        "KN",
        "LC",
        "MF",
        "EA",
        "SL",
        "SG",
        "SY",
        "US",
        "SK",
        "SI",
        "SB",
        "SO",
        "RS",
        "CS",
        "SD",
        "SR",
        "TW",
        "TH",
        "TZ",
        "TJ",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TV",
        "TN",
        "TM",
        "TC",
        "TR",
        "UG",
        "UZ",
        "AE",
        "UA",
        "UY",
        "FO",
        "PH",
        "FI",
        "FJ",
        "FK",
        "FR",
        "GF",
        "PF",
        "TF",
        "HT",
        "HM",
        "NL",
        "AN",
        "HK",
        "HN",
        "HR",
        "CF",
        "ME",
        "TD",
        "CZ",
        "CL",
        "JE",
        "DJ",
        "CH",
        "SE",
        "ES",
        "LK",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Свет");
    namesMap.put("002", "Африка");
    namesMap.put("003", "Северноамерички континент");
    namesMap.put("005", "Јужна Америка");
    namesMap.put("009", "Океанија");
    namesMap.put("011", "Западна Африка");
    namesMap.put("013", "Централна Америка");
    namesMap.put("014", "Источна Африка");
    namesMap.put("015", "Северна Африка");
    namesMap.put("017", "Централна Африка");
    namesMap.put("018", "Јужна Африка");
    namesMap.put("019", "Америке");
    namesMap.put("021", "Северна Америка");
    namesMap.put("029", "Кариби");
    namesMap.put("030", "Источна Азија");
    namesMap.put("034", "Јужна Азија");
    namesMap.put("035", "Југоисточна Азија");
    namesMap.put("039", "Јужна Европа");
    namesMap.put("053", "Аустралија и Нови Зеланд");
    namesMap.put("054", "Меланезија");
    namesMap.put("057", "Микронезијски регион");
    namesMap.put("061", "Полинезија");
    namesMap.put("062", "Јужно-централна Азија");
    namesMap.put("142", "Азија");
    namesMap.put("143", "Централна Азија");
    namesMap.put("145", "Западна Азија");
    namesMap.put("150", "Европа");
    namesMap.put("151", "Источна Европа");
    namesMap.put("154", "Северна Европа");
    namesMap.put("155", "Западна Европа");
    namesMap.put("172", "Комонвелт независних држава");
    namesMap.put("419", "Латинска Америка и Кариби");
    namesMap.put("830", "Каналска острва");
    namesMap.put("AC", "Острво Асенсион");
    namesMap.put("AD", "Андора");
    namesMap.put("AE", "Уједињени Арапски Емирати");
    namesMap.put("AF", "Авганистан");
    namesMap.put("AG", "Антигве и Барбуда");
    namesMap.put("AI", "Ангвила");
    namesMap.put("AL", "Албанија");
    namesMap.put("AM", "Арменија");
    namesMap.put("AN", "Холандски Антили");
    namesMap.put("AO", "Ангола");
    namesMap.put("AQ", "Антарктик");
    namesMap.put("AR", "Аргентина");
    namesMap.put("AS", "Америчка Самоа");
    namesMap.put("AT", "Аустрија");
    namesMap.put("AU", "Аустралија");
    namesMap.put("AW", "Аруба");
    namesMap.put("AX", "Аландска острва");
    namesMap.put("AZ", "Азербејџан");
    namesMap.put("BA", "Босна и Херцеговина");
    namesMap.put("BB", "Барбадос");
    namesMap.put("BD", "Бангладеш");
    namesMap.put("BE", "Белгија");
    namesMap.put("BF", "Буркина Фасо");
    namesMap.put("BG", "Бугарска");
    namesMap.put("BH", "Бахреин");
    namesMap.put("BI", "Бурунди");
    namesMap.put("BJ", "Бенин");
    namesMap.put("BL", "Свети Бартоломеј");
    namesMap.put("BM", "Бермуда");
    namesMap.put("BN", "Брунеј");
    namesMap.put("BO", "Боливија");
    namesMap.put("BR", "Бразил");
    namesMap.put("BS", "Бахами");
    namesMap.put("BT", "Бутан");
    namesMap.put("BV", "Буве Острва");
    namesMap.put("BW", "Боцвана");
    namesMap.put("BY", "Белорусија");
    namesMap.put("BZ", "Белизе");
    namesMap.put("CA", "Канада");
    namesMap.put("CC", "Кокос (Келинг) Острва");
    namesMap.put("CD", "Конго - Киншаса");
    namesMap.put("CF", "Централно Афричка Република");
    namesMap.put("CG", "Конго - Бразавил");
    namesMap.put("CH", "Швајцарска");
    namesMap.put("CI", "Обала Слоноваче");
    namesMap.put("CK", "Кукова Острва");
    namesMap.put("CL", "Чиле");
    namesMap.put("CM", "Камерун");
    namesMap.put("CN", "Кина");
    namesMap.put("CO", "Колумбија");
    namesMap.put("CP", "Острво Клипертон");
    namesMap.put("CR", "Костарика");
    namesMap.put("CS", "Србија и Црна Гора");
    namesMap.put("CU", "Куба");
    namesMap.put("CV", "Капе Верде");
    namesMap.put("CX", "Божићна острва");
    namesMap.put("CY", "Кипар");
    namesMap.put("CZ", "Чешка");
    namesMap.put("DE", "Немачка");
    namesMap.put("DG", "Дијего Гарсија");
    namesMap.put("DJ", "Џибути");
    namesMap.put("DK", "Данска");
    namesMap.put("DM", "Доминика");
    namesMap.put("DO", "Доминиканска Република");
    namesMap.put("DZ", "Алжир");
    namesMap.put("EA", "Сеута и Мелиља");
    namesMap.put("EC", "Еквадор");
    namesMap.put("EE", "Естонија");
    namesMap.put("EG", "Египат");
    namesMap.put("EH", "Западна Сахара");
    namesMap.put("ER", "Еритреја");
    namesMap.put("ES", "Шпанија");
    namesMap.put("ET", "Етиопија");
    namesMap.put("EU", "Европска Унија");
    namesMap.put("FI", "Финска");
    namesMap.put("FJ", "Фиџи");
    namesMap.put("FK", "Фолкландска Острва");
    namesMap.put("FM", "Микронезија");
    namesMap.put("FO", "Фарска Острва");
    namesMap.put("FR", "Француска");
    namesMap.put("GA", "Габон");
    namesMap.put("GB", "Велика Британија");
    namesMap.put("GD", "Гренада");
    namesMap.put("GE", "Грузија");
    namesMap.put("GF", "Француска Гвајана");
    namesMap.put("GG", "Гурнси");
    namesMap.put("GH", "Гана");
    namesMap.put("GI", "Гибралтар");
    namesMap.put("GL", "Гренланд");
    namesMap.put("GM", "Гамбија");
    namesMap.put("GN", "Гвинеја");
    namesMap.put("GP", "Гваделупе");
    namesMap.put("GQ", "Екваторијална Гвинеја");
    namesMap.put("GR", "Грчка");
    namesMap.put("GS", "Јужна Џорџија и Јужна Сендвич Острва");
    namesMap.put("GT", "Гватемала");
    namesMap.put("GU", "Гуам");
    namesMap.put("GW", "Гвинеја-Бисао");
    namesMap.put("GY", "Гвајана");
    namesMap.put("HK", "Хонг Конг");
    namesMap.put("HM", "Херд и Мекдоналд Острва");
    namesMap.put("HN", "Хондурас");
    namesMap.put("HR", "Хрватска");
    namesMap.put("HT", "Хаити");
    namesMap.put("HU", "Мађарска");
    namesMap.put("IC", "Канарска острва");
    namesMap.put("ID", "Индонезија");
    namesMap.put("IE", "Ирска");
    namesMap.put("IL", "Израел");
    namesMap.put("IM", "Острво Ман");
    namesMap.put("IN", "Индија");
    namesMap.put("IO", "Британска територија у Индијском океану");
    namesMap.put("IQ", "Ирак");
    namesMap.put("IR", "Иран");
    namesMap.put("IS", "Исланд");
    namesMap.put("IT", "Италија");
    namesMap.put("JE", "Џерси");
    namesMap.put("JM", "Јамајка");
    namesMap.put("JO", "Јордан");
    namesMap.put("JP", "Јапан");
    namesMap.put("KE", "Кенија");
    namesMap.put("KG", "Киргизстан");
    namesMap.put("KH", "Камбоџа");
    namesMap.put("KI", "Кирибати");
    namesMap.put("KM", "Коморска Острва");
    namesMap.put("KN", "Сент Китс и Невис");
    namesMap.put("KP", "Северна Кореја");
    namesMap.put("KR", "Јужна Кореја");
    namesMap.put("KW", "Кувајт");
    namesMap.put("KY", "Кајманска Острва");
    namesMap.put("KZ", "Казахстан");
    namesMap.put("LA", "Лаос");
    namesMap.put("LB", "Либан");
    namesMap.put("LC", "Сент Луција");
    namesMap.put("LI", "Лихтенштајн");
    namesMap.put("LK", "Шри Ланка");
    namesMap.put("LR", "Либерија");
    namesMap.put("LS", "Лесото");
    namesMap.put("LT", "Литванија");
    namesMap.put("LU", "Луксембург");
    namesMap.put("LV", "Летонија");
    namesMap.put("LY", "Либија");
    namesMap.put("MA", "Мароко");
    namesMap.put("MC", "Монако");
    namesMap.put("MD", "Молдавија");
    namesMap.put("ME", "Црна Гора");
    namesMap.put("MF", "Сент Мартин");
    namesMap.put("MG", "Мадагаскар");
    namesMap.put("MH", "Маршалска Острва");
    namesMap.put("MK", "Македонија");
    namesMap.put("ML", "Мали");
    namesMap.put("MM", "Мијанмар [Бурма]");
    namesMap.put("MN", "Монголија");
    namesMap.put("MO", "Макао");
    namesMap.put("MP", "Северна Маријанска Острва");
    namesMap.put("MQ", "Мартиник");
    namesMap.put("MR", "Мауританија");
    namesMap.put("MS", "Монсерат");
    namesMap.put("MT", "Малта");
    namesMap.put("MU", "Маурицијус");
    namesMap.put("MV", "Малдиви");
    namesMap.put("MW", "Малави");
    namesMap.put("MX", "Мексико");
    namesMap.put("MY", "Малезија");
    namesMap.put("MZ", "Мозамбик");
    namesMap.put("NA", "Намибија");
    namesMap.put("NC", "Нова Каледонија");
    namesMap.put("NE", "Нигер");
    namesMap.put("NF", "Норфолк Острво");
    namesMap.put("NG", "Нигерија");
    namesMap.put("NI", "Никарагва");
    namesMap.put("NL", "Холандија");
    namesMap.put("NO", "Норвешка");
    namesMap.put("NP", "Непал");
    namesMap.put("NR", "Науру");
    namesMap.put("NU", "Ниуе");
    namesMap.put("NZ", "Нови Зеланд");
    namesMap.put("OM", "Оман");
    namesMap.put("PA", "Панама");
    namesMap.put("PE", "Перу");
    namesMap.put("PF", "Француска Полинезија");
    namesMap.put("PG", "Папуа Нова Гвинеја");
    namesMap.put("PH", "Филипини");
    namesMap.put("PK", "Пакистан");
    namesMap.put("PL", "Пољска");
    namesMap.put("PM", "Сен Пјер и Микелон");
    namesMap.put("PN", "Питкерн");
    namesMap.put("PR", "Порто Рико");
    namesMap.put("PS", "Палестинске територије");
    namesMap.put("PT", "Португал");
    namesMap.put("PW", "Палау");
    namesMap.put("PY", "Парагвај");
    namesMap.put("QA", "Катар");
    namesMap.put("QO", "Остала океанија");
    namesMap.put("RE", "Реинион");
    namesMap.put("RO", "Румунија");
    namesMap.put("RS", "Србија");
    namesMap.put("RU", "Русија");
    namesMap.put("RW", "Руанда");
    namesMap.put("SA", "Саудијска Арабија");
    namesMap.put("SB", "Соломонска Острва");
    namesMap.put("SC", "Сејшели");
    namesMap.put("SD", "Судан");
    namesMap.put("SE", "Шведска");
    namesMap.put("SG", "Сингапур");
    namesMap.put("SH", "Света Јелена");
    namesMap.put("SI", "Словенија");
    namesMap.put("SJ", "Свалбард и Јанмајен Острва");
    namesMap.put("SK", "Словачка");
    namesMap.put("SL", "Сијера Леоне");
    namesMap.put("SM", "Сан Марино");
    namesMap.put("SN", "Сенегал");
    namesMap.put("SO", "Сомалија");
    namesMap.put("SR", "Суринам");
    namesMap.put("ST", "Сао Томе и Принципе");
    namesMap.put("SV", "Салвадор");
    namesMap.put("SY", "Сирија");
    namesMap.put("SZ", "Свазиленд");
    namesMap.put("TA", "Тристан да Куња");
    namesMap.put("TC", "Туркс и Кајкос Острва");
    namesMap.put("TD", "Чад");
    namesMap.put("TF", "Француске Јужне Територије");
    namesMap.put("TG", "Того");
    namesMap.put("TH", "Тајланд");
    namesMap.put("TJ", "Таџикистан");
    namesMap.put("TK", "Токелау");
    namesMap.put("TL", "Источни Тимор");
    namesMap.put("TM", "Туркменистан");
    namesMap.put("TN", "Тунис");
    namesMap.put("TO", "Тонга");
    namesMap.put("TR", "Турска");
    namesMap.put("TT", "Тринидад и Тобаго");
    namesMap.put("TV", "Тувалу");
    namesMap.put("TW", "Тајван");
    namesMap.put("TZ", "Танзанија");
    namesMap.put("UA", "Украјина");
    namesMap.put("UG", "Уганда");
    namesMap.put("UM", "Мања удаљена острва САД");
    namesMap.put("US", "Сједињене Америчке Државе");
    namesMap.put("UY", "Уругвај");
    namesMap.put("UZ", "Узбекистан");
    namesMap.put("VA", "Ватикан");
    namesMap.put("VC", "Сент Винсент и Гренадини");
    namesMap.put("VE", "Венецуела");
    namesMap.put("VG", "Британска Девичанска Острва");
    namesMap.put("VI", "С.А.Д. Девичанска Острва");
    namesMap.put("VN", "Вијетнам");
    namesMap.put("VU", "Вануату");
    namesMap.put("WF", "Валис и Футуна Острва");
    namesMap.put("WS", "Самоа");
    namesMap.put("YE", "Јемен");
    namesMap.put("YT", "Мајоте");
    namesMap.put("ZA", "Јужноафричка Република");
    namesMap.put("ZM", "Замбија");
    namesMap.put("ZW", "Зимбабве");
    namesMap.put("ZZ", "Непозната или неважећа област");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Свет",
        "002": "Африка",
        "003": "Северноамерички континент",
        "005": "Јужна Америка",
        "009": "Океанија",
        "011": "Западна Африка",
        "013": "Централна Америка",
        "014": "Источна Африка",
        "015": "Северна Африка",
        "017": "Централна Африка",
        "018": "Јужна Африка",
        "019": "Америке",
        "021": "Северна Америка",
        "029": "Кариби",
        "030": "Источна Азија",
        "034": "Јужна Азија",
        "035": "Југоисточна Азија",
        "039": "Јужна Европа",
        "053": "Аустралија и Нови Зеланд",
        "054": "Меланезија",
        "057": "Микронезијски регион",
        "061": "Полинезија",
        "062": "Јужно-централна Азија",
        "142": "Азија",
        "143": "Централна Азија",
        "145": "Западна Азија",
        "150": "Европа",
        "151": "Источна Европа",
        "154": "Северна Европа",
        "155": "Западна Европа",
        "172": "Комонвелт независних држава",
        "419": "Латинска Америка и Кариби",
        "830": "Каналска острва",
        "AC": "Острво Асенсион",
        "AD": "Андора",
        "AE": "Уједињени Арапски Емирати",
        "AF": "Авганистан",
        "AG": "Антигве и Барбуда",
        "AI": "Ангвила",
        "AL": "Албанија",
        "AM": "Арменија",
        "AN": "Холандски Антили",
        "AO": "Ангола",
        "AQ": "Антарктик",
        "AR": "Аргентина",
        "AS": "Америчка Самоа",
        "AT": "Аустрија",
        "AU": "Аустралија",
        "AW": "Аруба",
        "AX": "Аландска острва",
        "AZ": "Азербејџан",
        "BA": "Босна и Херцеговина",
        "BB": "Барбадос",
        "BD": "Бангладеш",
        "BE": "Белгија",
        "BF": "Буркина Фасо",
        "BG": "Бугарска",
        "BH": "Бахреин",
        "BI": "Бурунди",
        "BJ": "Бенин",
        "BL": "Свети Бартоломеј",
        "BM": "Бермуда",
        "BN": "Брунеј",
        "BO": "Боливија",
        "BR": "Бразил",
        "BS": "Бахами",
        "BT": "Бутан",
        "BV": "Буве Острва",
        "BW": "Боцвана",
        "BY": "Белорусија",
        "BZ": "Белизе",
        "CA": "Канада",
        "CC": "Кокос (Келинг) Острва",
        "CD": "Конго - Киншаса",
        "CF": "Централно Афричка Република",
        "CG": "Конго - Бразавил",
        "CH": "Швајцарска",
        "CI": "Обала Слоноваче",
        "CK": "Кукова Острва",
        "CL": "Чиле",
        "CM": "Камерун",
        "CN": "Кина",
        "CO": "Колумбија",
        "CP": "Острво Клипертон",
        "CR": "Костарика",
        "CS": "Србија и Црна Гора",
        "CU": "Куба",
        "CV": "Капе Верде",
        "CX": "Божићна острва",
        "CY": "Кипар",
        "CZ": "Чешка",
        "DE": "Немачка",
        "DG": "Дијего Гарсија",
        "DJ": "Џибути",
        "DK": "Данска",
        "DM": "Доминика",
        "DO": "Доминиканска Република",
        "DZ": "Алжир",
        "EA": "Сеута и Мелиља",
        "EC": "Еквадор",
        "EE": "Естонија",
        "EG": "Египат",
        "EH": "Западна Сахара",
        "ER": "Еритреја",
        "ES": "Шпанија",
        "ET": "Етиопија",
        "EU": "Европска Унија",
        "FI": "Финска",
        "FJ": "Фиџи",
        "FK": "Фолкландска Острва",
        "FM": "Микронезија",
        "FO": "Фарска Острва",
        "FR": "Француска",
        "GA": "Габон",
        "GB": "Велика Британија",
        "GD": "Гренада",
        "GE": "Грузија",
        "GF": "Француска Гвајана",
        "GG": "Гурнси",
        "GH": "Гана",
        "GI": "Гибралтар",
        "GL": "Гренланд",
        "GM": "Гамбија",
        "GN": "Гвинеја",
        "GP": "Гваделупе",
        "GQ": "Екваторијална Гвинеја",
        "GR": "Грчка",
        "GS": "Јужна Џорџија и Јужна Сендвич Острва",
        "GT": "Гватемала",
        "GU": "Гуам",
        "GW": "Гвинеја-Бисао",
        "GY": "Гвајана",
        "HK": "Хонг Конг",
        "HM": "Херд и Мекдоналд Острва",
        "HN": "Хондурас",
        "HR": "Хрватска",
        "HT": "Хаити",
        "HU": "Мађарска",
        "IC": "Канарска острва",
        "ID": "Индонезија",
        "IE": "Ирска",
        "IL": "Израел",
        "IM": "Острво Ман",
        "IN": "Индија",
        "IO": "Британска територија у Индијском океану",
        "IQ": "Ирак",
        "IR": "Иран",
        "IS": "Исланд",
        "IT": "Италија",
        "JE": "Џерси",
        "JM": "Јамајка",
        "JO": "Јордан",
        "JP": "Јапан",
        "KE": "Кенија",
        "KG": "Киргизстан",
        "KH": "Камбоџа",
        "KI": "Кирибати",
        "KM": "Коморска Острва",
        "KN": "Сент Китс и Невис",
        "KP": "Северна Кореја",
        "KR": "Јужна Кореја",
        "KW": "Кувајт",
        "KY": "Кајманска Острва",
        "KZ": "Казахстан",
        "LA": "Лаос",
        "LB": "Либан",
        "LC": "Сент Луција",
        "LI": "Лихтенштајн",
        "LK": "Шри Ланка",
        "LR": "Либерија",
        "LS": "Лесото",
        "LT": "Литванија",
        "LU": "Луксембург",
        "LV": "Летонија",
        "LY": "Либија",
        "MA": "Мароко",
        "MC": "Монако",
        "MD": "Молдавија",
        "ME": "Црна Гора",
        "MF": "Сент Мартин",
        "MG": "Мадагаскар",
        "MH": "Маршалска Острва",
        "MK": "Македонија",
        "ML": "Мали",
        "MM": "Мијанмар [Бурма]",
        "MN": "Монголија",
        "MO": "Макао",
        "MP": "Северна Маријанска Острва",
        "MQ": "Мартиник",
        "MR": "Мауританија",
        "MS": "Монсерат",
        "MT": "Малта",
        "MU": "Маурицијус",
        "MV": "Малдиви",
        "MW": "Малави",
        "MX": "Мексико",
        "MY": "Малезија",
        "MZ": "Мозамбик",
        "NA": "Намибија",
        "NC": "Нова Каледонија",
        "NE": "Нигер",
        "NF": "Норфолк Острво",
        "NG": "Нигерија",
        "NI": "Никарагва",
        "NL": "Холандија",
        "NO": "Норвешка",
        "NP": "Непал",
        "NR": "Науру",
        "NU": "Ниуе",
        "NZ": "Нови Зеланд",
        "OM": "Оман",
        "PA": "Панама",
        "PE": "Перу",
        "PF": "Француска Полинезија",
        "PG": "Папуа Нова Гвинеја",
        "PH": "Филипини",
        "PK": "Пакистан",
        "PL": "Пољска",
        "PM": "Сен Пјер и Микелон",
        "PN": "Питкерн",
        "PR": "Порто Рико",
        "PS": "Палестинске територије",
        "PT": "Португал",
        "PW": "Палау",
        "PY": "Парагвај",
        "QA": "Катар",
        "QO": "Остала океанија",
        "RE": "Реинион",
        "RO": "Румунија",
        "RS": "Србија",
        "RU": "Русија",
        "RW": "Руанда",
        "SA": "Саудијска Арабија",
        "SB": "Соломонска Острва",
        "SC": "Сејшели",
        "SD": "Судан",
        "SE": "Шведска",
        "SG": "Сингапур",
        "SH": "Света Јелена",
        "SI": "Словенија",
        "SJ": "Свалбард и Јанмајен Острва",
        "SK": "Словачка",
        "SL": "Сијера Леоне",
        "SM": "Сан Марино",
        "SN": "Сенегал",
        "SO": "Сомалија",
        "SR": "Суринам",
        "ST": "Сао Томе и Принципе",
        "SV": "Салвадор",
        "SY": "Сирија",
        "SZ": "Свазиленд",
        "TA": "Тристан да Куња",
        "TC": "Туркс и Кајкос Острва",
        "TD": "Чад",
        "TF": "Француске Јужне Територије",
        "TG": "Того",
        "TH": "Тајланд",
        "TJ": "Таџикистан",
        "TK": "Токелау",
        "TL": "Источни Тимор",
        "TM": "Туркменистан",
        "TN": "Тунис",
        "TO": "Тонга",
        "TR": "Турска",
        "TT": "Тринидад и Тобаго",
        "TV": "Тувалу",
        "TW": "Тајван",
        "TZ": "Танзанија",
        "UA": "Украјина",
        "UG": "Уганда",
        "UM": "Мања удаљена острва САД",
        "US": "Сједињене Америчке Државе",
        "UY": "Уругвај",
        "UZ": "Узбекистан",
        "VA": "Ватикан",
        "VC": "Сент Винсент и Гренадини",
        "VE": "Венецуела",
        "VG": "Британска Девичанска Острва",
        "VI": "С.А.Д. Девичанска Острва",
        "VN": "Вијетнам",
        "VU": "Вануату",
        "WF": "Валис и Футуна Острва",
        "WS": "Самоа",
        "YE": "Јемен",
        "YT": "Мајоте",
        "ZA": "Јужноафричка Република",
        "ZM": "Замбија",
        "ZW": "Зимбабве",
        "ZZ": "Непозната или неважећа област"
    };
  }-*/;
}
