/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StackTraceDeobfuscator {
    private static Pattern JsniRefPattern = Pattern.compile("@?([^:]+)::([^(]+)(\\((.*)\\))?");
    private File symbolMapsDirectory;
    private Map<String, SymbolMap> symbolMaps = new HashMap<String, SymbolMap>();

    public StackTraceDeobfuscator(String symbolMapsDirectory) {
        this.setSymbolMapsDirectory(symbolMapsDirectory);
    }

    public LogRecord deobfuscateLogRecord(LogRecord lr, String strongName) {
        if (lr.getThrown() != null && strongName != null) {
            lr.setThrown(this.deobfuscateThrowable(lr.getThrown(), strongName));
        }
        return lr;
    }

    public StackTraceElement[] deobfuscateStackTrace(StackTraceElement[] st, String strongName) {
        StackTraceElement[] newSt = new StackTraceElement[st.length];
        for (int i = 0; i < st.length; ++i) {
            newSt[i] = this.resymbolize(st[i], strongName);
        }
        return newSt;
    }

    public StackTraceElement resymbolize(StackTraceElement ste, String strongName) {
        String[] parts;
        String symbolData;
        SymbolMap map = this.loadSymbolMap(strongName);
        String string = symbolData = map == null ? null : (String)map.get(ste.getMethodName());
        if (symbolData != null && (parts = symbolData.split(",")).length == 5) {
            String methodName;
            String declaringClass;
            String[] ref = this.parse(parts[0].substring(0, parts[0].lastIndexOf(41) + 1));
            if (ref != null) {
                declaringClass = ref[0];
                methodName = ref[1];
            } else {
                declaringClass = ste.getClassName();
                methodName = ste.getMethodName();
            }
            String filename = "Unknown".equals(parts[3]) ? null : parts[3].substring(parts[3].lastIndexOf(47) + 1);
            int lineNumber = ste.getLineNumber();
            if (lineNumber == 0) {
                lineNumber = Integer.parseInt(parts[4]);
            }
            return new StackTraceElement(declaringClass, methodName, filename, lineNumber);
        }
        return ste;
    }

    public void setSymbolMapsDirectory(String symbolMapsDirectory) {
        this.symbolMapsDirectory = new File(symbolMapsDirectory);
    }

    protected InputStream getSymbolMapInputStream(String permutationStrongName) throws IOException {
        String filename = this.symbolMapsDirectory.getCanonicalPath() + File.separatorChar + permutationStrongName + ".symbolMap";
        return new FileInputStream(filename);
    }

    private Throwable deobfuscateThrowable(Throwable old, String strongName) {
        Throwable t = new Throwable(old.getMessage());
        if (old.getStackTrace() != null) {
            t.setStackTrace(this.deobfuscateStackTrace(old.getStackTrace(), strongName));
        } else {
            t.setStackTrace(new StackTraceElement[0]);
        }
        if (old.getCause() != null) {
            t.initCause(this.deobfuscateThrowable(old.getCause(), strongName));
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SymbolMap loadSymbolMap(String strongName) {
        SymbolMap toReturn = this.symbolMaps.get(strongName);
        if (toReturn != null) {
            return toReturn;
        }
        toReturn = new SymbolMap();
        try {
            BufferedReader bin = new BufferedReader(new InputStreamReader(this.getSymbolMapInputStream(strongName)));
            try {
                String line;
                while ((line = bin.readLine()) != null) {
                    if (line.charAt(0) == '#') continue;
                    int idx = line.indexOf(44);
                    toReturn.put(new String(line.substring(0, idx)), line.substring(idx + 1));
                }
            }
            finally {
                bin.close();
            }
        }
        catch (IOException e) {
            toReturn = new SymbolMap();
        }
        this.symbolMaps.put(strongName, toReturn);
        return toReturn;
    }

    private String[] parse(String refString) {
        Matcher matcher = JsniRefPattern.matcher(refString);
        if (!matcher.matches()) {
            return null;
        }
        String className = matcher.group(1);
        String memberName = matcher.group(2);
        String[] toReturn = new String[]{className, memberName};
        return toReturn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SymbolMap
    extends HashMap<String, String> {
        private SymbolMap() {
        }
    }
}

