#!/bin/csh
# map.csh  <mapfile1 [... mapfileN]>
# views one or more block maps - blockmkr version (see MAP_VIEW)
#  Requires programs block_vis & htmlize-map.pl in same directory
#  Assumes blocks corresponding to mapfile are in mapfile:r (but they aren't)
#
# Written by Ross Morgan-Linial


# content type for the WWW browser 
echo Content-type: text/html
echo ""

# No arguments
if ($#argv <= 0) then
    echo "Error: no arguments"
    exit 1
endif

# One argument
if ($#argv <= 1) then
    # get blocks file name - the map structure file name without its suffix
    set blocks_file = "$1:r"

    if (-f "$1") then           # file exists
        if (-z "$1") then       # file is empty, for cases like PRINTS where we 
                                # currently have no map files and create an
                                # empty file
            echo "Sorry, block map not available."
            exit 0 
        endif
        # Draw map (first argument is map structure) and 
        # pipe through HTMLIZE_MAP (argument is the name of blocks file)
	./block_vis $1 -c10 | ./bm_htmlize-map.pl $blocks_file 
    else
        echo "Error: input file not found."
    endif

    # done
    exit 0
endif

# Two or more arguments
set MAP_VIEW=/blocks-bin/map.csh

# HTML header tags
echo '<HTML>'
echo '<TITLE>Block maps</TITLE>'
echo ''

# Calculate the <FRAMESET> parameters
@ width = 100 / $#argv
@ leftover = $width + 100 - $width * $#argv

# print the frameset commands
printf '<FRAMESET ROWS="%i%%' $leftover
foreach input ($argv[2-])
    printf ",$width%%"
end
printf '">\n'

# print the frames
foreach input ($argv[1-])
    echo \<FRAME SRC=\"$MAP_VIEW\?$input\"\>
end

# close the HTML tags
echo '</FRAMESET>'
echo ''
echo '</HTML>'

# done
exit 0
