/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.NTFJMSEvent;
import oracle.jdbc.driver.NTFJMSPerDatabaseManager;
import oracle.jdbc.driver.NTFJMSRegistration;
import oracle.jdbc.driver.NTFManager;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIkpdnrmp;
import oracle.jdbc.driver.T4CTTIkpdnrnf;
import oracle.jdbc.driver.T4CTTIkpdnrpay;
import oracle.jdbc.driver.T4CTTIkpdnrreq;

final class T4CTTIoaqnfy
extends T4CTTIfun {
    byte[] clientId = null;
    boolean isMarshalOver = false;
    boolean needToBeClosed = false;
    OracleConnection conn = null;
    T4CTTIkpdnrnf notificationHeader = null;
    T4CTTIkpdnrmp messageProperties = null;
    T4CTTIkpdnrpay payload = null;
    NTFManager ntfManager = null;
    T4CMAREngine mar;
    String databaseUniqueIdentifier;
    NTFJMSPerDatabaseManager jmsPerDatabaseManager = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
    public static final boolean TRACE = false;

    T4CTTIoaqnfy(T4CConnection t4CConnection, String string, NTFJMSPerDatabaseManager nTFJMSPerDatabaseManager) throws SQLException {
        super(t4CConnection, (byte)3);
        assert (t4CConnection != null && string != null) : "_connection is " + t4CConnection + ", _clientId is " + string;
        this.setFunCode((short)187);
        this.conn = t4CConnection;
        this.mar = t4CConnection.mare;
        this.clientId = this.mar.conv.StringToCharBytes(string);
        this.jmsPerDatabaseManager = nTFJMSPerDatabaseManager;
        this.databaseUniqueIdentifier = t4CConnection.databaseUniqueIdentifier;
    }

    @Override
    void marshal() throws IOException {
        T4CTTIkpdnrreq t4CTTIkpdnrreq = new T4CTTIkpdnrreq((T4CConnection)this.conn);
        t4CTTIkpdnrreq.send(this.clientId, T4CTTIkpdnrreq.OpCode.INIT_KPDNRREQ);
        this.isMarshalOver = true;
    }

    @Override
    void readOAC() {
        try {
            while (true) {
                this.notificationHeader = new T4CTTIkpdnrnf((T4CConnection)this.conn);
                this.notificationHeader.receive();
                this.messageProperties = new T4CTTIkpdnrmp((T4CConnection)this.conn);
                this.messageProperties.receive();
                this.payload = new T4CTTIkpdnrpay((T4CConnection)this.conn);
                this.payload.receive();
                this.createAndGenerateEvent();
            }
        }
        catch (Exception exception) {
            if (this.needToBeClosed) {
                // empty if block
            }
            return;
        }
    }

    public void createAndGenerateEvent() throws SQLException {
        NTFJMSEvent nTFJMSEvent = new NTFJMSEvent(this);
        nTFJMSEvent.setAqMessageProperites(this.messageProperties.getAqMessageProperties());
        nTFJMSEvent.setJmsMessageProperties(this.messageProperties.getJmsMessageProperties());
        nTFJMSEvent.setMessageId(this.messageProperties.getMessageId());
        nTFJMSEvent.setPayload(this.payload.getRawPayload());
        nTFJMSEvent.setConsumerName(this.notificationHeader.getConsumerName());
        nTFJMSEvent.setQueueName(this.notificationHeader.getNotificationQueue());
        nTFJMSEvent.setRegistration(this.notificationHeader.getNotificationQueue());
        int n2 = this.jmsPerDatabaseManager.getJDBCRegId(this.notificationHeader.getRegistrationId());
        NTFJMSRegistration nTFJMSRegistration = (NTFJMSRegistration)PhysicalConnection.ntfManager.getRegistration(n2);
        nTFJMSRegistration.notify(nTFJMSEvent);
    }

    public void stopListening() {
        while (!this.isMarshalOver) {
        }
        this.needToBeClosed = true;
    }
}

