/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import javax.swing.JScrollBar;
import org.fest.assertions.Assertions;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JScrollBarLocation;
import org.fest.swing.driver.JScrollBarSetValueTask;
import org.fest.swing.driver.JScrollBarValueQuery;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.util.GenericRange;
import org.fest.swing.util.Pair;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JScrollBarDriver
extends JComponentDriver {
    private static final String VALUE_PROPERTY = "value";
    private final JScrollBarLocation location = new JScrollBarLocation();

    public JScrollBarDriver(Robot robot) {
        super(robot);
    }

    public void scrollUnitUp(JScrollBar scrollBar) {
        this.scrollUnitUp(scrollBar, 1);
    }

    public void scrollUnitUp(JScrollBar scrollBar, int times) {
        this.validateTimes(times, "scroll up one unit");
        Pair<Point, Integer> scrollInfo = JScrollBarDriver.validateAndFindScrollUnitInfo(scrollBar, this.location, times * -1);
        this.scroll(scrollBar, scrollInfo);
    }

    public void scrollUnitDown(JScrollBar scrollBar) {
        this.scrollUnitDown(scrollBar, 1);
    }

    public void scrollUnitDown(JScrollBar scrollBar, int times) {
        this.validateTimes(times, "scroll down one unit");
        Pair<Point, Integer> scrollInfo = JScrollBarDriver.validateAndFindScrollUnitInfo(scrollBar, this.location, times);
        this.scroll(scrollBar, scrollInfo);
    }

    @RunsInEDT
    private static Pair<Point, Integer> validateAndFindScrollUnitInfo(final JScrollBar scrollBar, final JScrollBarLocation location, final int times) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Point, Integer>>(){

            @Override
            protected Pair<Point, Integer> executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(scrollBar);
                return JScrollBarDriver.scrollUnitInfo(scrollBar, location, times);
            }
        });
    }

    @RunsInCurrentThread
    private static Pair<Point, Integer> scrollUnitInfo(JScrollBar scrollBar, JScrollBarLocation location, int times) {
        Point where = JScrollBarDriver.blockLocation(scrollBar, location, times);
        int count = times * scrollBar.getUnitIncrement();
        return new Pair<Point, Integer>(where, scrollBar.getValue() + count);
    }

    @RunsInEDT
    public void scrollBlockUp(JScrollBar scrollBar) {
        this.scrollBlockUp(scrollBar, 1);
    }

    @RunsInEDT
    public void scrollBlockUp(JScrollBar scrollBar, int times) {
        this.validateTimes(times, "scroll up one block");
        Pair<Point, Integer> scrollInfo = JScrollBarDriver.validateAndFindScrollBlockInfo(scrollBar, this.location, times * -1);
        this.scroll(scrollBar, scrollInfo);
    }

    @RunsInEDT
    public void scrollBlockDown(JScrollBar scrollBar) {
        this.scrollBlockDown(scrollBar, 1);
    }

    @RunsInEDT
    public void scrollBlockDown(JScrollBar scrollBar, int times) {
        this.validateTimes(times, "scroll down one block");
        Pair<Point, Integer> scrollInfo = JScrollBarDriver.validateAndFindScrollBlockInfo(scrollBar, this.location, times);
        this.scroll(scrollBar, scrollInfo);
    }

    private void validateTimes(int times, String action) {
        if (times > 0) {
            return;
        }
        String message = Strings.concat((Object[])new Object[]{"The number of times to ", action, " should be greater than zero, but was <", times, ">"});
        throw new IllegalArgumentException(message);
    }

    @RunsInEDT
    private static Pair<Point, Integer> validateAndFindScrollBlockInfo(final JScrollBar scrollBar, final JScrollBarLocation location, final int times) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Point, Integer>>(){

            @Override
            protected Pair<Point, Integer> executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(scrollBar);
                return JScrollBarDriver.scrollBlockInfo(scrollBar, location, times);
            }
        });
    }

    @RunsInCurrentThread
    private static Pair<Point, Integer> scrollBlockInfo(JScrollBar scrollBar, JScrollBarLocation location, int times) {
        Point where = JScrollBarDriver.blockLocation(scrollBar, location, times);
        int count = times * scrollBar.getBlockIncrement();
        return new Pair<Point, Integer>(where, scrollBar.getValue() + count);
    }

    @RunsInCurrentThread
    private static Point blockLocation(JScrollBar scrollBar, JScrollBarLocation location, int times) {
        if (times > 0) {
            return location.blockLocationToScrollDown(scrollBar);
        }
        return location.blockLocationToScrollUp(scrollBar);
    }

    @RunsInEDT
    private void scroll(JScrollBar scrollBar, Pair<Point, Integer> scrollInfo) {
        this.robot.moveMouse(scrollBar, (Point)scrollInfo.i);
        this.setValueProperty(scrollBar, (Integer)scrollInfo.ii);
    }

    @RunsInEDT
    public void scrollToMaximum(JScrollBar scrollBar) {
        Pair<Integer, GenericRange<Point>> scrollInfo = JScrollBarDriver.validateAndFindScrollToMaximumInfo(scrollBar, this.location);
        this.scroll(scrollBar, (Integer)scrollInfo.i, (GenericRange)scrollInfo.ii);
    }

    @RunsInEDT
    private static Pair<Integer, GenericRange<Point>> validateAndFindScrollToMaximumInfo(final JScrollBar scrollBar, final JScrollBarLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Integer, GenericRange<Point>>>(){

            @Override
            protected Pair<Integer, GenericRange<Point>> executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(scrollBar);
                int position = scrollBar.getMaximum();
                GenericRange scrollInfo = JScrollBarDriver.scrollInfo(scrollBar, location, position);
                return new Pair<Integer, GenericRange<Point>>(position, scrollInfo);
            }
        });
    }

    @RunsInEDT
    public void scrollToMinimum(JScrollBar scrollBar) {
        Pair<Integer, GenericRange<Point>> scrollInfo = JScrollBarDriver.validateAndFindScrollToMinimumInfo(scrollBar, this.location);
        this.scroll(scrollBar, (Integer)scrollInfo.i, (GenericRange)scrollInfo.ii);
    }

    @RunsInEDT
    private static Pair<Integer, GenericRange<Point>> validateAndFindScrollToMinimumInfo(final JScrollBar scrollBar, final JScrollBarLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Integer, GenericRange<Point>>>(){

            @Override
            protected Pair<Integer, GenericRange<Point>> executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(scrollBar);
                int position = scrollBar.getMinimum();
                GenericRange scrollInfo = JScrollBarDriver.scrollInfo(scrollBar, location, position);
                return new Pair<Integer, GenericRange<Point>>(position, scrollInfo);
            }
        });
    }

    @RunsInEDT
    public void scrollTo(JScrollBar scrollBar, int position) {
        GenericRange<Point> scrollInfo = JScrollBarDriver.validateAndFindScrollInfo(scrollBar, this.location, position);
        this.scroll(scrollBar, position, scrollInfo);
    }

    @RunsInEDT
    private static GenericRange<Point> validateAndFindScrollInfo(final JScrollBar scrollBar, final JScrollBarLocation location, final int position) {
        return GuiActionRunner.execute(new GuiQuery<GenericRange<Point>>(){

            @Override
            protected GenericRange<Point> executeInEDT() {
                JScrollBarDriver.validatePosition(scrollBar, position);
                ComponentStateValidator.validateIsEnabledAndShowing(scrollBar);
                return JScrollBarDriver.scrollInfo(scrollBar, location, position);
            }
        });
    }

    @RunsInCurrentThread
    private static void validatePosition(JScrollBar scrollBar, int position) {
        int min = scrollBar.getMinimum();
        int max = scrollBar.getMaximum();
        if (position >= min && position <= max) {
            return;
        }
        throw new IllegalArgumentException(Strings.concat((Object[])new Object[]{"Position <", position, "> is not within the JScrollBar bounds of <", min, "> and <", max, ">"}));
    }

    @RunsInCurrentThread
    private static GenericRange<Point> scrollInfo(JScrollBar scrollBar, JScrollBarLocation location, int position) {
        Point from = location.thumbLocation(scrollBar, scrollBar.getValue());
        Point to = location.thumbLocation(scrollBar, position);
        return new GenericRange<Point>(from, to);
    }

    private void scroll(JScrollBar scrollBar, int position, GenericRange<Point> points) {
        this.simulateScrolling(scrollBar, points);
        this.setValueProperty(scrollBar, position);
    }

    @RunsInEDT
    private void simulateScrolling(JScrollBar scrollBar, GenericRange<Point> points) {
        this.robot.moveMouse(scrollBar, (Point)points.from);
        this.robot.moveMouse(scrollBar, (Point)points.to);
    }

    @RunsInEDT
    private void setValueProperty(JScrollBar scrollBar, int value) {
        JScrollBarSetValueTask.setValue(scrollBar, value);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public void requireValue(JScrollBar scrollBar, int value) {
        Assertions.assertThat((int)JScrollBarValueQuery.valueOf(scrollBar)).as(JScrollBarDriver.propertyName(scrollBar, VALUE_PROPERTY)).isEqualTo(value);
    }
}

