/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.ColorUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;

public abstract class NavigationComponentHelper {
    private int _rolloverRow = -1;
    private Point _mousePosition = null;

    protected abstract Rectangle getRowBounds(int var1);

    protected abstract int rowAtPoint(Point var1);

    protected abstract int[] getSelectedRows();

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int[] nArray;
        if (this._rolloverRow != -1) {
            this.paintRolloverRow(graphics, jComponent, this._rolloverRow);
        }
        if ((nArray = this.getSelectedRows()) != null) {
            for (int n : nArray) {
                this.paintSelectedRow(graphics, jComponent, n);
            }
        }
    }

    protected void paintSelectedRow(Graphics graphics, JComponent jComponent, int n) {
        Color color = this.getSelectionColor(jComponent);
        Rectangle rectangle = this.getRowBounds(n);
        if (rectangle != null) {
            --rectangle.width;
            --rectangle.height;
            this.paintRow(graphics, n, rectangle, color, 30, 70, 50, 128);
        }
    }

    protected Color getSelectionColor(JComponent jComponent) {
        Color color = UIManager.getColor("NavigationComponent.selectionBackground");
        if (color == null) {
            color = UIManager.getColor("Tree.selectionBackground");
        }
        if (!jComponent.hasFocus() && Color.WHITE.equals(color = ColorUtils.toGrayscale(color).brighter())) {
            color = new Color(202, 202, 202);
        }
        return color;
    }

    protected void paintRolloverRow(Graphics graphics, JComponent jComponent, int n) {
        Color color = UIManager.getColor("Tree.selectionBackground");
        Rectangle rectangle = this.getRowBounds(n);
        if (rectangle != null) {
            --rectangle.width;
            --rectangle.height;
            this.paintRow(graphics, n, rectangle, color, 10, 40, 20, 100);
        }
    }

    private void paintRow(Graphics graphics, int n, Rectangle rectangle, Color color, int n2, int n3, int n4, int n5) {
        Object object = JideSwingUtilities.setupShapeAntialiasing(graphics);
        ((Graphics2D)graphics).setPaint(new LinearGradientPaint(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height, new float[]{0.5f, 0.95f, 1.0f}, new Color[]{new Color(color.getRed(), color.getGreen(), color.getBlue(), n2), new Color(color.getRed(), color.getGreen(), color.getBlue(), n3), new Color(color.getRed(), color.getGreen(), color.getBlue(), n4)}, MultipleGradientPaint.CycleMethod.NO_CYCLE));
        int n6 = 5;
        graphics.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n6, n6);
        graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), n5));
        graphics.drawRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n6, n6);
        JideSwingUtilities.restoreShapeAntialiasing(graphics, object);
    }

    public void setup(final JComponent jComponent) {
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (jComponent != null) {
                    Rectangle rectangle;
                    NavigationComponentHelper.this._mousePosition = null;
                    int n = NavigationComponentHelper.this._rolloverRow;
                    NavigationComponentHelper.this._rolloverRow = -1;
                    if (n != -1 && (rectangle = NavigationComponentHelper.this.getRowBounds(n)) != null) {
                        jComponent.repaint(rectangle);
                    }
                }
                NavigationComponentHelper.this.mouseExited(mouseEvent);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                NavigationComponentHelper.this.mouseEntered(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                NavigationComponentHelper.this.mousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                NavigationComponentHelper.this.mouseReleased(mouseEvent);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                NavigationComponentHelper.this.mouseClicked(mouseEvent);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (jComponent != null) {
                    int n = NavigationComponentHelper.this.rowAtPoint(mouseEvent.getPoint());
                    if (n != -1) {
                        int n2;
                        Rectangle rectangle = NavigationComponentHelper.this.getRowBounds(n);
                        if (jComponent instanceof JTree) {
                            int n3 = n2 = rectangle != null ? rectangle.height : ((JTree)jComponent).getRowHeight();
                            if (NavigationComponentHelper.this._mousePosition != null) {
                                jComponent.repaint(new Rectangle(((NavigationComponentHelper)NavigationComponentHelper.this)._mousePosition.x - n2, ((NavigationComponentHelper)NavigationComponentHelper.this)._mousePosition.y - n2, 2 * n2, 2 * n2));
                            }
                            NavigationComponentHelper.this._mousePosition = mouseEvent.getPoint();
                            if (NavigationComponentHelper.this._mousePosition != null) {
                                jComponent.repaint(new Rectangle(((NavigationComponentHelper)NavigationComponentHelper.this)._mousePosition.x - n2, ((NavigationComponentHelper)NavigationComponentHelper.this)._mousePosition.y - n2, 2 * n2, 2 * n2));
                            }
                        }
                        if (NavigationComponentHelper.this._rolloverRow != n) {
                            Rectangle rectangle2;
                            n2 = NavigationComponentHelper.this._rolloverRow;
                            NavigationComponentHelper.this._rolloverRow = n;
                            if (n2 != -1 && (rectangle2 = NavigationComponentHelper.this.getRowBounds(n2)) != null) {
                                jComponent.repaint(rectangle2);
                            }
                            if (rectangle != null) {
                                jComponent.repaint(rectangle);
                            }
                        }
                    } else {
                        Rectangle rectangle;
                        int n4 = NavigationComponentHelper.this._rolloverRow;
                        NavigationComponentHelper.this._rolloverRow = -1;
                        if (n4 != -1 && (rectangle = NavigationComponentHelper.this.getRowBounds(n4)) != null) {
                            jComponent.repaint(rectangle);
                        }
                    }
                }
                NavigationComponentHelper.this.mouseMoved(mouseEvent);
            }
        };
        jComponent.addMouseMotionListener(mouseInputAdapter);
        jComponent.addMouseListener(mouseInputAdapter);
        jComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                NavigationComponentHelper.this.repaintSelections(jComponent);
                NavigationComponentHelper.this.focusGained(focusEvent);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                NavigationComponentHelper.this.repaintSelections(jComponent);
                NavigationComponentHelper.this.focusLost(focusEvent);
            }
        });
    }

    public void repaintSelections(JComponent jComponent) {
        Object object;
        int[] nArray = this.getSelectedRows();
        if (nArray != null) {
            object = nArray;
            int n = ((int[])object).length;
            for (int i = 0; i < n; ++i) {
                int n2 = object[i];
                Rectangle rectangle = this.getRowBounds(n2);
                if (rectangle == null) continue;
                rectangle.x = 0;
                rectangle.width = jComponent.getWidth();
                jComponent.repaint(rectangle);
            }
        }
        if (this._rolloverRow != -1 && (object = (Object)this.getRowBounds(this._rolloverRow)) != null) {
            jComponent.repaint((Rectangle)object);
        }
    }

    public int getRolloverRow() {
        return this._rolloverRow;
    }

    public void setRolloverRow(int n) {
        this._rolloverRow = n;
    }

    public Point getMousePosition() {
        return this._mousePosition;
    }
}

