/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TracedReferenceValue;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.evaluation.ReferenceTracingInvocationUnit;
import proguard.optimize.evaluation.ReferenceTracingValueFactory;
import proguard.util.ArrayUtil;

public class InitializationFinder
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor {
    private static final boolean DEBUG = false;
    public static final int NONE = -1;
    private final PartialEvaluator partialEvaluator;
    private final boolean runPartialEvaluator;
    private int superInitializationOffset;
    private int[] initializationOffsets = new int[8096];
    private InstructionOffsetValue[] uninitializedOffsets = new InstructionOffsetValue[8096];

    public InitializationFinder() {
        this(new ReferenceTracingValueFactory(new BasicValueFactory()));
    }

    private InitializationFinder(ReferenceTracingValueFactory referenceTracingValueFactory) {
        this(new PartialEvaluator(referenceTracingValueFactory, new ReferenceTracingInvocationUnit(new BasicInvocationUnit(referenceTracingValueFactory)), true, referenceTracingValueFactory), true);
    }

    public InitializationFinder(PartialEvaluator partialEvaluator, boolean bl) {
        this.partialEvaluator = partialEvaluator;
        this.runPartialEvaluator = bl;
    }

    public boolean isInitializer() {
        return this.superInitializationOffset != -1;
    }

    public int superInitializationOffset() {
        return this.superInitializationOffset;
    }

    public int creationOffset(int n) {
        return this.creationOffsetValue(n).instructionOffset(0);
    }

    public boolean isInitializedBefore(int n, int n2) {
        InstructionOffsetValue instructionOffsetValue = this.creationOffsetValue(n, n2);
        return this.isInitializedBefore(n, instructionOffsetValue);
    }

    public boolean isInitializedBefore(int n, InstructionOffsetValue instructionOffsetValue) {
        return !this.uninitializedOffsets[n].contains(instructionOffsetValue.instructionOffset(0));
    }

    public boolean isInitializer(int n) {
        return this.partialEvaluator.isInitializer(n);
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int n = codeAttribute.u4codeLength;
        this.superInitializationOffset = -1;
        this.initializationOffsets = ArrayUtil.ensureArraySize(this.initializationOffsets, n, -1);
        this.uninitializedOffsets = ArrayUtil.ensureArraySize(this.uninitializedOffsets, n, null);
        if (this.runPartialEvaluator) {
            this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        }
        InstructionOffsetValue instructionOffsetValue = method.getName(clazz).equals("<init>") ? new InstructionOffsetValue(0x1000000) : InstructionOffsetValue.EMPTY_VALUE;
        for (int i = 0; i < n; ++i) {
            int n2;
            InstructionOffsetValue instructionOffsetValue2;
            if (!this.partialEvaluator.isTraced(i)) continue;
            if (this.partialEvaluator.isExceptionHandler(i)) {
                instructionOffsetValue = InstructionOffsetValue.EMPTY_VALUE;
            }
            if (this.uninitializedOffsets[i] != null) {
                instructionOffsetValue = this.uninitializedOffsets[i];
            } else {
                this.uninitializedOffsets[i] = instructionOffsetValue;
            }
            if (this.partialEvaluator.isCreation(i)) {
                instructionOffsetValue = instructionOffsetValue.add(i);
            } else if (this.partialEvaluator.isInitializer(i)) {
                instructionOffsetValue2 = this.creationOffsetValue(i);
                n2 = instructionOffsetValue2.instructionOffset(0);
                if (instructionOffsetValue2.isMethodParameter(0)) {
                    this.superInitializationOffset = i;
                } else {
                    this.initializationOffsets[n2] = i;
                }
                instructionOffsetValue = instructionOffsetValue.remove(n2);
            }
            instructionOffsetValue2 = this.partialEvaluator.branchTargets(i);
            if (instructionOffsetValue2 == null) continue;
            for (n2 = 0; n2 < instructionOffsetValue2.instructionOffsetCount(); ++n2) {
                int n3 = instructionOffsetValue2.instructionOffset(n2);
                if (n3 <= i) continue;
                this.uninitializedOffsets[n3] = instructionOffsetValue;
            }
            instructionOffsetValue = InstructionOffsetValue.EMPTY_VALUE;
        }
    }

    private InstructionOffsetValue creationOffsetValue(int n) {
        int n2 = this.partialEvaluator.getStackAfter(n).size();
        return this.creationOffsetValue(n, n2);
    }

    private InstructionOffsetValue creationOffsetValue(int n, int n2) {
        ReferenceValue referenceValue = this.partialEvaluator.getStackBefore(n).getBottom(n2).referenceValue();
        TracedReferenceValue tracedReferenceValue = (TracedReferenceValue)referenceValue;
        return tracedReferenceValue.getTraceValue().instructionOffsetValue();
    }
}

