/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalClassTemplate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalClassTypeMixinHost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;

public class CPPClassTemplate
extends CPPTemplateDefinition
implements ICPPClassTemplate,
ICPPInternalClassTemplate,
ICPPInternalClassTypeMixinHost {
    private ICPPClassTemplatePartialSpecialization[] partialSpecializations;
    private ICPPDeferredClassInstance fDeferredInstance;
    private boolean addedPartialSpecializationsOfIndex;
    private ICPPBase[] bases;

    public CPPClassTemplate(IASTName name) {
        super(name);
    }

    @Override
    public void checkForDefinition() {
    }

    @Override
    public void addPartialSpecialization(ICPPClassTemplatePartialSpecialization spec) {
        this.partialSpecializations = ArrayUtil.append(ICPPClassTemplatePartialSpecialization.class, this.partialSpecializations, spec);
    }

    @Override
    public ICPPASTCompositeTypeSpecifier getCompositeTypeSpecifier() {
        if (this.definition != null) {
            IASTNode node = this.definition.getParent();
            if (node instanceof ICPPASTQualifiedName) {
                node = node.getParent();
            }
            if (node instanceof ICPPASTCompositeTypeSpecifier) {
                return (ICPPASTCompositeTypeSpecifier)node;
            }
        }
        return null;
    }

    @Override
    public ICPPClassScope getCompositeScope() {
        IScope scope;
        ICPPClassTemplate ib;
        if (this.definition == null) {
            this.checkForDefinition();
        }
        if (this.definition != null) {
            IASTNode parent = this.definition.getParent();
            while (parent instanceof IASTName) {
                parent = parent.getParent();
            }
            if (parent instanceof ICPPASTCompositeTypeSpecifier) {
                ICPPASTCompositeTypeSpecifier compSpec = (ICPPASTCompositeTypeSpecifier)parent;
                return compSpec.getScope();
            }
        }
        if ((ib = this.getIndexBinding()) != null && (scope = ib.getCompositeScope()) instanceof ICPPClassScope) {
            return (ICPPClassScope)scope;
        }
        return null;
    }

    @Override
    public int getKey() {
        IASTNode n;
        if (this.definition != null) {
            ICPPASTCompositeTypeSpecifier cts = this.getCompositeTypeSpecifier();
            if (cts != null) {
                return cts.getKey();
            }
            IASTNode n2 = this.definition.getParent();
            if (n2 instanceof ICPPASTElaboratedTypeSpecifier) {
                return ((ICPPASTElaboratedTypeSpecifier)n2).getKind();
            }
        }
        if (this.declarations != null && this.declarations.length > 0 && (n = this.declarations[0].getParent()) instanceof ICPPASTElaboratedTypeSpecifier) {
            return ((ICPPASTElaboratedTypeSpecifier)n).getKind();
        }
        return 3;
    }

    @Override
    public ICPPClassTemplatePartialSpecialization[] getPartialSpecializations() {
        if (!this.addedPartialSpecializationsOfIndex) {
            this.addedPartialSpecializationsOfIndex = true;
            ICPPClassTemplate ib = this.getIndexBinding();
            if (ib != null) {
                IIndexFileSet fs = this.getTemplateName().getTranslationUnit().getIndexFileSet();
                ICPPClassTemplatePartialSpecialization[] iCPPClassTemplatePartialSpecializationArray = ib.getPartialSpecializations();
                int n = iCPPClassTemplatePartialSpecializationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPClassTemplatePartialSpecialization spec = iCPPClassTemplatePartialSpecializationArray[n2];
                    if (spec instanceof IIndexBinding && fs.containsDeclaration((IIndexBinding)((Object)spec))) {
                        this.addPartialSpecialization(spec);
                    }
                    ++n2;
                }
            }
        }
        this.partialSpecializations = ArrayUtil.trim(ICPPClassTemplatePartialSpecialization.class, this.partialSpecializations);
        return this.partialSpecializations;
    }

    @Override
    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef || type instanceof IIndexBinding) {
            return type.isSameType(this);
        }
        return false;
    }

    @Override
    public ICPPBase[] getBases() {
        if (this.bases == null) {
            this.bases = ClassTypeHelper.getBases(this);
        }
        return this.bases;
    }

    @Override
    public IField[] getFields() {
        return ClassTypeHelper.getFields(this, null);
    }

    @Override
    public ICPPField[] getDeclaredFields() {
        return ClassTypeHelper.getDeclaredFields(this);
    }

    @Override
    public ICPPMethod[] getMethods() {
        return ClassTypeHelper.getMethods(this, null);
    }

    @Override
    public ICPPMethod[] getAllDeclaredMethods() {
        return ClassTypeHelper.getAllDeclaredMethods(this, null);
    }

    @Override
    public ICPPMethod[] getDeclaredMethods() {
        return ClassTypeHelper.getDeclaredMethods(this);
    }

    @Override
    public ICPPConstructor[] getConstructors() {
        return ClassTypeHelper.getConstructors(this);
    }

    @Override
    public IBinding[] getFriends() {
        return ClassTypeHelper.getFriends(this);
    }

    @Override
    public ICPPClassType[] getNestedClasses() {
        return ClassTypeHelper.getNestedClasses(this);
    }

    @Override
    public IField findField(String name) {
        return ClassTypeHelper.findField(this, name);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public final ICPPDeferredClassInstance asDeferredInstance() {
        if (this.fDeferredInstance == null) {
            this.fDeferredInstance = CPPTemplates.createDeferredInstance(this);
        }
        return this.fDeferredInstance;
    }

    @Override
    public ICPPTemplateArgument getDefaultArgFromIndex(int paramPos) throws DOMException {
        ICPPTemplateParameter[] params;
        ICPPClassTemplate ib = this.getIndexBinding();
        if (ib != null && paramPos < (params = ib.getTemplateParameters()).length) {
            ICPPTemplateParameter param = params[paramPos];
            return param.getDefaultValue();
        }
        return null;
    }

    @Override
    public boolean isFinal() {
        ICPPASTCompositeTypeSpecifier typeSpecifier = this.getCompositeTypeSpecifier();
        if (typeSpecifier != null) {
            return typeSpecifier.isFinal();
        }
        return false;
    }

    @Override
    public int getVisibility(IBinding member) {
        return ClassTypeHelper.getVisibility(this, member);
    }
}

