/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.model.ASTStringUtil;
import org.eclipse.cdt.internal.core.model.ext.ICElementHandle;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.text.ICReconcilingListener;
import org.eclipse.cdt.internal.ui.viewsupport.IndexUI;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;

public class OverrideIndicatorManager
implements ICReconcilingListener {
    static final String ANNOTATION_TYPE = "org.eclipse.cdt.ui.overrideIndicator";
    private static final String MESSAGE_SEPARATOR = ";\n";
    public static final int RESULT_OVERRIDES = 0;
    public static final int RESULT_IMPLEMENTS = 1;
    public static final int RESULT_SHADOWS = 2;
    private IAnnotationModel fAnnotationModel;
    private Vector<OverrideIndicator> fOverrideAnnotations = new Vector();
    private Object fAnnotationModelLockObject;

    public OverrideIndicatorManager(IAnnotationModel annotationModel) {
        this.fAnnotationModel = annotationModel;
        this.fAnnotationModelLockObject = this.getLockObject(this.fAnnotationModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResult(OverrideInfo info, IIndex index) {
        Position position = new Position(info.nodeOffset, info.nodeLength);
        OverrideIndicator indicator = new OverrideIndicator(info.resultType, info.message, info.binding, index);
        Object object = this.fAnnotationModelLockObject;
        synchronized (object) {
            this.fAnnotationModel.addAnnotation((Annotation)indicator, position);
        }
        this.fOverrideAnnotations.add(indicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotations() {
        if (this.fOverrideAnnotations == null) {
            return;
        }
        Object object = this.fAnnotationModelLockObject;
        synchronized (object) {
            for (Annotation annotation : this.fOverrideAnnotations) {
                this.fAnnotationModel.removeAnnotation(annotation);
            }
            this.fOverrideAnnotations.clear();
        }
    }

    public void generateAnnotations(IASTTranslationUnit ast, IIndex index) {
        class CompositeTypeFinder
        extends ASTVisitor {
            private final /* synthetic */ IIndex val$index;

            CompositeTypeFinder(IIndex iIndex) {
                this.val$index = iIndex;
                this.shouldVisitDeclSpecifiers = true;
            }

            public int visit(IASTDeclSpecifier declSpec) {
                if (declSpec instanceof ICPPASTCompositeTypeSpecifier) {
                    class MethodDeclarationFinder
                    extends ASTVisitor {
                        private final /* synthetic */ IIndex val$index;

                        MethodDeclarationFinder(IIndex iIndex) {
                            this.val$index = iIndex;
                            this.shouldVisitDeclarations = true;
                        }

                        public int visit(IASTDeclaration declaration) {
                            try {
                                OverrideInfo overrideInfo;
                                IBinding binding = null;
                                ICPPMethod method = null;
                                if (OverrideIndicatorManager.isFunctionDeclaration(declaration)) {
                                    binding = OverrideIndicatorManager.getDeclarationBinding(declaration);
                                } else if (declaration instanceof IASTFunctionDefinition) {
                                    binding = OverrideIndicatorManager.getDefinitionBinding((IASTFunctionDefinition)declaration);
                                }
                                if (binding instanceof ICPPMethod && (overrideInfo = OverrideIndicatorManager.checkForOverride(method = (ICPPMethod)binding, (IASTNode)declaration)) != null) {
                                    OverrideIndicatorManager.this.handleResult(overrideInfo, this.val$index);
                                }
                            }
                            catch (DOMException dOMException) {}
                            return 1;
                        }
                    }
                    declSpec.accept((ASTVisitor)new MethodDeclarationFinder(this.val$index));
                }
                return 3;
            }
        }
        ast.accept((ASTVisitor)new CompositeTypeFinder(index));
        class MethodDefinitionFinder
        extends ASTVisitor {
            private final /* synthetic */ IIndex val$index;

            MethodDefinitionFinder(IIndex iIndex) {
                this.val$index = iIndex;
                this.shouldVisitDeclarations = true;
            }

            public int visit(IASTDeclaration declaration) {
                IBinding definitionBinding;
                IASTFunctionDefinition definition;
                block6: {
                    block5: {
                        try {
                            if (declaration instanceof IASTFunctionDefinition) break block5;
                            return 1;
                        }
                        catch (DOMException dOMException) {}
                    }
                    definition = (IASTFunctionDefinition)declaration;
                    definitionBinding = OverrideIndicatorManager.getDefinitionBinding(definition);
                    if (definitionBinding instanceof ICPPMethod) break block6;
                    return 1;
                }
                ICPPMethod method = (ICPPMethod)definitionBinding;
                OverrideInfo overrideInfo = OverrideIndicatorManager.checkForOverride(method, (IASTNode)definition);
                if (overrideInfo != null) {
                    OverrideIndicatorManager.this.handleResult(overrideInfo, this.val$index);
                }
                return 1;
            }
        }
        ast.accept((ASTVisitor)new MethodDefinitionFinder(index));
    }

    private static OverrideInfo checkForOverride(ICPPMethod testedOverride, IASTNode node) throws DOMException {
        IASTFileLocation location = node.getFileLocation();
        boolean onlyPureVirtual = true;
        StringBuilder sb = new StringBuilder();
        HashSet<ICPPMethod> overridenMethods = new HashSet<ICPPMethod>();
        HashSet<ICPPMethod> shadowedMethods = new HashSet<ICPPMethod>();
        HashSet<ICPPClassType> alreadyTestedBases = new HashSet<ICPPClassType>();
        ICPPBase[] bases = ClassTypeHelper.getBases((ICPPClassType)testedOverride.getClassOwner(), (IASTNode)node);
        alreadyTestedBases.add(testedOverride.getClassOwner());
        ICPPBase[] iCPPBaseArray = bases;
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPBase base = iCPPBaseArray[n2];
            if (base.getBaseClass() instanceof ICPPClassType) {
                ICPPClassType testedClass = (ICPPClassType)base.getBaseClass();
                overridenMethods.clear();
                shadowedMethods.clear();
                OverrideIndicatorManager.handleBaseClass(testedClass, testedOverride, overridenMethods, shadowedMethods, alreadyTestedBases, node);
                for (ICPPMethod overriddenMethod : overridenMethods) {
                    if (sb.length() > 0) {
                        sb.append(MESSAGE_SEPARATOR);
                    }
                    if (overriddenMethod.isPureVirtual()) {
                        sb.append(CEditorMessages.OverrideIndicatorManager_implements);
                    } else {
                        sb.append(CEditorMessages.OverrideIndicatorManager_overrides);
                        onlyPureVirtual = false;
                    }
                    sb.append(' ');
                    sb.append(OverrideIndicatorManager.getQualifiedNameString((ICPPBinding)overriddenMethod));
                    if (bases.length <= 1 || overriddenMethod.getClassOwner() == testedClass) continue;
                    sb.append(' ');
                    sb.append(CEditorMessages.OverrideIndicatorManager_via);
                    sb.append(' ');
                    sb.append(OverrideIndicatorManager.getQualifiedNameString((ICPPBinding)testedClass));
                }
                for (ICPPMethod shadowedMethod : shadowedMethods) {
                    if (sb.length() > 0) {
                        sb.append(MESSAGE_SEPARATOR);
                    }
                    sb.append(CEditorMessages.OverrideIndicatorManager_shadows);
                    sb.append(' ');
                    sb.append(OverrideIndicatorManager.getQualifiedNameString((ICPPBinding)shadowedMethod));
                }
            }
            ++n2;
        }
        int markerType = overridenMethods.size() > 0 ? (onlyPureVirtual ? 1 : 0) : 2;
        IBinding bindingToOpen = null;
        if (overridenMethods.size() > 0) {
            bindingToOpen = (IBinding)overridenMethods.iterator().next();
        } else if (shadowedMethods.size() > 0) {
            bindingToOpen = (IBinding)shadowedMethods.iterator().next();
        }
        if (sb.length() > 0) {
            OverrideInfo info = new OverrideInfo(location.getNodeOffset(), location.getNodeLength(), markerType, sb.toString(), bindingToOpen);
            return info;
        }
        return null;
    }

    private static void handleBaseClass(ICPPClassType classType, ICPPMethod testedOverride, Set<ICPPMethod> foundMethods, Set<ICPPMethod> shadowedMethods, Set<ICPPClassType> alreadyTestedBases, IASTNode point) throws DOMException {
        if (alreadyTestedBases.contains(classType)) {
            return;
        }
        alreadyTestedBases.add(classType);
        Vector<ICPPMethod> validOverrides = new Vector<ICPPMethod>();
        ICPPMethod[] iCPPMethodArray = ClassTypeHelper.getDeclaredMethods((ICPPClassType)classType, (IASTNode)point);
        int n = iCPPMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod method = iCPPMethodArray[n2];
            if (testedOverride.getName().equals(method.getName())) {
                if (ClassTypeHelper.isOverrider((ICPPMethod)testedOverride, (ICPPMethod)method)) {
                    validOverrides.add(method);
                } else if (OverrideIndicatorManager.sameParameters(testedOverride, method)) {
                    shadowedMethods.add(method);
                }
            }
            ++n2;
        }
        validOverrides.size();
        if (validOverrides.size() >= 1) {
            foundMethods.addAll(validOverrides);
            return;
        }
        iCPPMethodArray = ClassTypeHelper.getBases((ICPPClassType)classType, (IASTNode)point);
        n = iCPPMethodArray.length;
        n2 = 0;
        while (n2 < n) {
            ICPPMethod b = iCPPMethodArray[n2];
            if (b.getBaseClass() instanceof ICPPClassType) {
                ICPPClassType baseClass = (ICPPClassType)b.getBaseClass();
                OverrideIndicatorManager.handleBaseClass(baseClass, testedOverride, foundMethods, shadowedMethods, alreadyTestedBases, point);
            }
            ++n2;
        }
    }

    private static boolean sameParameters(ICPPMethod a, ICPPMethod b) throws DOMException {
        ICPPFunctionType aType = a.getType();
        ICPPFunctionType bType = b.getType();
        if (aType.getParameterTypes().length != bType.getParameterTypes().length) {
            return false;
        }
        int i = 0;
        while (i < aType.getParameterTypes().length) {
            IType methodParamType;
            IType overrideParamType = aType.getParameterTypes()[i];
            if (!overrideParamType.isSameType(methodParamType = bType.getParameterTypes()[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String getQualifiedNameString(ICPPBinding binding) throws DOMException {
        String methodQualifiedName = ASTStringUtil.join((String[])binding.getQualifiedName(), (CharSequence)"::");
        return methodQualifiedName;
    }

    private static boolean isFunctionDeclaration(IASTDeclaration declaration) {
        if (!(declaration instanceof IASTSimpleDeclaration)) {
            return false;
        }
        IASTSimpleDeclaration simpleDecl = (IASTSimpleDeclaration)declaration;
        IASTDeclarator[] declarators = simpleDecl.getDeclarators();
        if (declarators.length < 1) {
            return false;
        }
        IASTDeclarator declarator = ASTQueries.findInnermostDeclarator((IASTDeclarator)declarators[0]);
        return declarator instanceof IASTFunctionDeclarator;
    }

    private static IBinding getDefinitionBinding(IASTFunctionDefinition definition) {
        IASTDeclarator declarator = ASTQueries.findInnermostDeclarator((IASTDeclarator)definition.getDeclarator());
        return declarator.getName().resolveBinding();
    }

    private static IBinding getDeclarationBinding(IASTDeclaration declaration) {
        IASTNode[] iASTNodeArray = declaration.getChildren();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode node = iASTNodeArray[n2];
            if (node instanceof IASTDeclarator) {
                IASTDeclarator decl = ASTQueries.findInnermostDeclarator((IASTDeclarator)((IASTDeclarator)node));
                return decl.getName().resolveBinding();
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void aboutToBeReconciled() {
    }

    @Override
    public void reconciled(IASTTranslationUnit ast, boolean force, IProgressMonitor progressMonitor) {
        if (ast == null) {
            return;
        }
        IIndex index = ast.getIndex();
        this.removeAnnotations();
        this.generateAnnotations(ast, index);
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    public class OverrideIndicator
    extends Annotation {
        public static final String ANNOTATION_TYPE_ID = "org.eclipse.cdt.ui.overrideIndicator";
        private int type;
        private ICElementHandle declaration;

        public OverrideIndicator(int resultType, String message, IBinding binding, IIndex index) {
            super("org.eclipse.cdt.ui.overrideIndicator", false, message);
            this.type = resultType;
            try {
                ICElementHandle[] allDefinitions;
                this.declaration = IndexUI.findAnyDeclaration(index, null, binding);
                if (this.declaration == null && (allDefinitions = IndexUI.findAllDefinitions(index, binding)).length > 0) {
                    this.declaration = allDefinitions[0];
                }
            }
            catch (CoreException coreException) {}
        }

        public int getIndicationType() {
            return this.type;
        }

        public void open() {
            try {
                CDTUITools.openInEditor((ICElement)this.declaration, true, true);
            }
            catch (CoreException coreException) {}
        }
    }

    public static class OverrideInfo {
        public int nodeOffset;
        public int resultType;
        public String message;
        public int nodeLength;
        public IBinding binding;

        public OverrideInfo(int nodeOffset, int nodeLength, int markerType, String message, IBinding binding) {
            this.nodeOffset = nodeOffset;
            this.resultType = markerType;
            this.message = message;
            this.binding = binding;
        }
    }
}

