/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.internal.core.pdom.dom.NamedNodeCollector;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

public final class BindingCollector
extends NamedNodeCollector {
    private IndexFilter filter;
    private boolean fSkipGlobalEnumerators;

    public BindingCollector(PDOMLinkage linkage, char[] name) {
        this(linkage, name, null, false, false, true);
    }

    public BindingCollector(PDOMLinkage linkage, char[] name, IndexFilter filter, boolean prefixLookup, boolean contentAssistLookup, boolean caseSensitive) {
        super(linkage, name, prefixLookup, contentAssistLookup, caseSensitive);
        this.filter = filter;
    }

    @Override
    public boolean addNode(PDOMNamedNode tBinding) throws CoreException {
        if (tBinding instanceof PDOMBinding) {
            PDOMNode parent;
            if (this.fSkipGlobalEnumerators && tBinding instanceof IEnumerator && (parent = tBinding.getParentNode()) instanceof ICPPEnumeration) {
                ICPPEnumeration enumType = (ICPPEnumeration)((Object)parent);
                if (parent.getParentNode() == null && !enumType.isScoped()) {
                    return true;
                }
            }
            if (this.filter == null || this.filter.acceptBinding((IBinding)((Object)tBinding))) {
                return super.addNode(tBinding);
            }
        }
        return true;
    }

    public PDOMBinding[] getBindings() {
        List<PDOMNamedNode> bindings = this.getNodeList();
        return bindings.toArray(new PDOMBinding[bindings.size()]);
    }

    public void setSkipGlobalEnumerators(boolean b) {
        this.fSkipGlobalEnumerators = b;
    }
}

