/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.concurrent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ICache;
import org.eclipse.cdt.dsf.concurrent.ImmediateInDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestCache;
import org.eclipse.cdt.dsf.concurrent.Transaction;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public abstract class RangeCache<V> {
    private final ImmediateInDsfExecutor fExecutor;
    private SortedSet<Request> fRequests = new TreeSet<Request>();

    public RangeCache(ImmediateInDsfExecutor executor) {
        this.fExecutor = executor;
    }

    protected abstract void retrieve(long var1, int var3, DataRequestMonitor<List<V>> var4);

    public ICache<List<V>> getRange(final long offset, final int count) {
        assert (this.fExecutor.getDsfExecutor().isInExecutorThread());
        List<Request> requests = this.getRequests(offset, count);
        RequestCache range = new RequestCache<List<V>>(this.fExecutor){

            @Override
            protected void retrieve(DataRequestMonitor<List<V>> rm) {
                new RangeTransaction(offset, count).request(rm);
            }
        };
        boolean valid = true;
        MultiStatus status = new MultiStatus("org.eclipse.cdt.dsf", 0, "", null);
        for (ICache iCache : requests) {
            if (iCache.isValid()) {
                if (iCache.getStatus().isOK()) continue;
                status.add(iCache.getStatus());
                continue;
            }
            valid = false;
            break;
        }
        if (valid) {
            if (status.isOK()) {
                range.set(this.makeElementsListFromRequests(requests, offset, count), Status.OK_STATUS);
            } else if (status.getChildren().length == 1) {
                range.set(null, status.getChildren()[0]);
            } else {
                range.set(null, (IStatus)status);
            }
        }
        return range;
    }

    protected void set(long offset, int count, List<V> data, IStatus status) {
        Request request2;
        for (Request request2 : this.fRequests) {
            if (request2.isValid()) continue;
            request2.set(null, Status.OK_STATUS);
        }
        this.fRequests.clear();
        request2 = new Request(offset, count);
        request2.set(data, status);
        this.fRequests.add(request2);
    }

    protected void reset() {
        Iterator itr = this.fRequests.iterator();
        while (itr.hasNext()) {
            Request request = (Request)itr.next();
            if (!request.isValid()) continue;
            request.reset();
            itr.remove();
        }
    }

    private List<Request> getRequests(long fOffset, int fCount) {
        ArrayList<Request> requests = new ArrayList<Request>(1);
        Request current = new Request(fOffset, fCount);
        if ((current = this.adjustRequestHead(current, requests, fOffset, fCount)) != null) {
            current = this.adjustRequestTail(current, requests, fOffset, fCount);
        }
        if (current != null) {
            requests.add(current);
            this.fRequests.add(current);
        }
        return requests;
    }

    private Request adjustRequestHead(Request request, List<Request> transactionRequests, long offset, int count) {
        SortedSet<Request> headRequests = this.fRequests.headSet(request);
        if (!headRequests.isEmpty()) {
            Request headRequest = headRequests.last();
            long headEndOffset = headRequest.fOffset + (long)headRequest.fCount;
            if (headEndOffset > offset) {
                transactionRequests.add(headRequest);
                request.fCount = (int)((long)request.fCount - (headEndOffset - offset));
                request.fOffset = headEndOffset;
            }
        }
        if (request.fCount > 0) {
            return request;
        }
        return null;
    }

    private Request adjustRequestTail(Request current, List<Request> transactionRequests, long offset, int count) {
        ArrayList<Request> tailSet = new ArrayList<Request>(this.fRequests.tailSet(current));
        for (Request tailRequest : tailSet) {
            if (tailRequest.fOffset >= current.fOffset + (long)count) break;
            if (tailRequest.fOffset <= current.fOffset) {
                transactionRequests.add(tailRequest);
                current.fOffset = tailRequest.fOffset + (long)tailRequest.fCount;
                current.fCount = (int)(offset - current.fOffset) + count;
                if (current.fCount > 0) continue;
                return null;
            }
            current.fCount = (int)(tailRequest.fOffset - current.fOffset);
            transactionRequests.add(current);
            this.fRequests.add(current);
            current = null;
            transactionRequests.add(tailRequest);
            long tailEndOffset = tailRequest.fOffset + (long)tailRequest.fCount;
            long rangeEndOffset = offset + (long)count;
            if (tailEndOffset >= rangeEndOffset) {
                return null;
            }
            current = new Request(tailEndOffset, (int)(rangeEndOffset - tailEndOffset));
        }
        return current;
    }

    private List<V> makeElementsListFromRequests(List<Request> requests, long offset, int count) {
        ArrayList retVal = new ArrayList(count);
        long index = offset;
        long end = offset + (long)count;
        int requestIdx = 0;
        while (index < end) {
            Request request = requests.get(requestIdx);
            if (index < request.fOffset + (long)request.fCount) {
                retVal.add(((List)request.getData()).get((int)(index - request.fOffset)));
                ++index;
                continue;
            }
            ++requestIdx;
        }
        return retVal;
    }

    private class RangeTransaction
    extends Transaction<List<V>> {
        long fOffset;
        int fCount;

        RangeTransaction(long offset, int count) {
            this.fOffset = offset;
            this.fCount = count;
        }

        @Override
        protected List<V> process() throws Transaction.InvalidCacheException, CoreException {
            this.clearCanceledRequests();
            List transactionRequests = RangeCache.this.getRequests(this.fOffset, this.fCount);
            this.validate(transactionRequests);
            return RangeCache.this.makeElementsListFromRequests(transactionRequests, this.fOffset, this.fCount);
        }

        private void clearCanceledRequests() {
            Iterator itr = RangeCache.this.fRequests.iterator();
            while (itr.hasNext()) {
                Request request = (Request)itr.next();
                if (request.isValid() || !request.isCanceled()) continue;
                itr.remove();
            }
        }
    }

    private class Request
    extends RequestCache<List<V>>
    implements Comparable<Request> {
        long fOffset;
        int fCount;

        @Override
        protected void retrieve(DataRequestMonitor<List<V>> rm) {
            RangeCache.this.retrieve(this.fOffset, this.fCount, rm);
        }

        Request(long offset, int count) {
            super(RangeCache.this.fExecutor);
            this.fOffset = offset;
            this.fCount = count;
        }

        @Override
        public int compareTo(Request o) {
            if (this.fOffset > o.fOffset) {
                return 1;
            }
            if (this.fOffset == o.fOffset) {
                return 0;
            }
            return -1;
        }

        public boolean equals(Object _o) {
            if (_o instanceof Request) {
                Request o = (Request)_o;
                return this.fOffset == o.fOffset && this.fCount == o.fCount;
            }
            return false;
        }

        public int hashCode() {
            return (int)this.fOffset ^ this.fCount;
        }

        public String toString() {
            return this.fOffset + "(" + this.fCount + ") -> " + (this.fOffset + (long)this.fCount);
        }
    }
}

