/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.sourcelookup;

import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.internal.ui.disassembly.editor.DisassemblyEditorManager;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.progress.UIJob;

public class SourceDisplayAdapter
implements ISourceDisplay {
    public void displaySource(Object element, IWorkbenchPage page, boolean forceSourceLookup) {
        if (element instanceof ICStackFrame) {
            ICStackFrame frame = (ICStackFrame)element;
            if (this.isDisplayDisassembly(frame, page)) {
                this.displayDisassembly(page, frame);
            } else {
                DelegatingStackFrame delegatingFrame = new DelegatingStackFrame((ICStackFrame)element);
                ISourceDisplay sd = (ISourceDisplay)Platform.getAdapterManager().getAdapter((Object)delegatingFrame, ISourceDisplay.class);
                if (sd != null) {
                    sd.displaySource(element, page, forceSourceLookup);
                }
            }
        }
    }

    private boolean isDisplayDisassembly(ICStackFrame frame, IWorkbenchPage page) {
        IEditorPart editor = this.getDisassemblyEditorManager().findEditor(page, frame);
        return editor != null;
    }

    protected DisassemblyEditorManager getDisassemblyEditorManager() {
        return CDebugUIPlugin.getDefault().getDisassemblyEditorManager();
    }

    private void displayDisassembly(final IWorkbenchPage page, final Object debugContext) {
        UIJob uijob = new UIJob("Display Disassembly Job"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    SourceDisplayAdapter.this.getDisassemblyEditorManager().openEditor(page, debugContext);
                }
                catch (DebugException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        uijob.setSystem(true);
        uijob.schedule();
    }

    class DelegatingStackFrame
    implements IStackFrame {
        private ICStackFrame fDelegate;

        DelegatingStackFrame(ICStackFrame delegate) {
            this.fDelegate = delegate;
        }

        public int getCharEnd() throws DebugException {
            return this.fDelegate.getCharEnd();
        }

        public int getCharStart() throws DebugException {
            return this.fDelegate.getCharStart();
        }

        public int getLineNumber() throws DebugException {
            return this.fDelegate.getLineNumber();
        }

        public String getName() throws DebugException {
            return this.fDelegate.getName();
        }

        public IRegisterGroup[] getRegisterGroups() throws DebugException {
            return this.fDelegate.getRegisterGroups();
        }

        public IThread getThread() {
            return this.fDelegate.getThread();
        }

        public IVariable[] getVariables() throws DebugException {
            return this.fDelegate.getVariables();
        }

        public boolean hasRegisterGroups() throws DebugException {
            return this.fDelegate.hasRegisterGroups();
        }

        public boolean hasVariables() throws DebugException {
            return this.fDelegate.hasVariables();
        }

        public IDebugTarget getDebugTarget() {
            return this.fDelegate.getDebugTarget();
        }

        public ILaunch getLaunch() {
            return this.fDelegate.getLaunch();
        }

        public String getModelIdentifier() {
            return this.fDelegate.getModelIdentifier();
        }

        public Object getAdapter(Class adapter) {
            if (ICStackFrame.class.equals((Object)adapter)) {
                return this.fDelegate;
            }
            return this.fDelegate.getAdapter(adapter);
        }

        public boolean canStepInto() {
            return this.fDelegate.canStepInto();
        }

        public boolean canStepOver() {
            return this.fDelegate.canStepOver();
        }

        public boolean canStepReturn() {
            return this.fDelegate.canStepReturn();
        }

        public boolean isStepping() {
            return this.fDelegate.isStepping();
        }

        public void stepInto() throws DebugException {
            this.fDelegate.stepInto();
        }

        public void stepOver() throws DebugException {
            this.fDelegate.stepOver();
        }

        public void stepReturn() throws DebugException {
            this.fDelegate.stepReturn();
        }

        public boolean canResume() {
            return this.fDelegate.canResume();
        }

        public boolean canSuspend() {
            return this.fDelegate.canSuspend();
        }

        public boolean isSuspended() {
            return this.fDelegate.isSuspended();
        }

        public void resume() throws DebugException {
            this.fDelegate.resume();
        }

        public void suspend() throws DebugException {
            this.fDelegate.suspend();
        }

        public boolean canTerminate() {
            return this.fDelegate.canTerminate();
        }

        public boolean isTerminated() {
            return this.fDelegate.isTerminated();
        }

        public void terminate() throws DebugException {
            this.fDelegate.terminate();
        }
    }
}

