/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.dialogs.TypedViewerFilter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementAttribute;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementLabelProvider;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementSorter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathBasePage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.ExclusionPatternDialog;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.MultipleFolderSelectionDialog;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.NewSourceFolderDialog;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

@Deprecated
public class CPathOutputEntryPage
extends CPathBasePage {
    private ListDialogField<CPElement> fCPathList;
    private ICProject fCurrCProject;
    private IPath fProjPath;
    private IWorkspaceRoot fWorkspaceRoot;
    private TreeListDialogField<CPElement> fOutputList;
    private final int IDX_ADD = 0;
    private final int IDX_EDIT = 2;
    private final int IDX_REMOVE = 3;

    public CPathOutputEntryPage(ListDialogField<CPElement> cPathList) {
        super(CPathEntryMessages.OutputPathEntryPage_title);
        this.setDescription(CPathEntryMessages.OutputPathEntryPage_description);
        this.fWorkspaceRoot = CUIPlugin.getWorkspace().getRoot();
        this.fCPathList = cPathList;
        OutputContainerAdapter adapter = new OutputContainerAdapter();
        String[] stringArray = new String[4];
        stringArray[0] = CPathEntryMessages.OutputPathEntryPage_folders_add_button;
        stringArray[2] = CPathEntryMessages.OutputPathEntryPage_folders_edit_button;
        stringArray[3] = CPathEntryMessages.OutputPathEntryPage_folders_remove_button;
        String[] buttonLabels = stringArray;
        this.fOutputList = new TreeListDialogField<CPElement>(adapter, buttonLabels, (ILabelProvider)new CPElementLabelProvider());
        this.fOutputList.setDialogFieldListener(adapter);
        this.fOutputList.setLabelText(CPathEntryMessages.OutputPathEntryPage_folders_label);
        this.fOutputList.setViewerComparator((ViewerComparator)new CPElementSorter());
        this.fOutputList.enableButton(2, false);
        this.fOutputList.enableButton(3, false);
        this.fOutputList.setTreeExpansionLevel(2);
    }

    public Image getImage() {
        return CDTSharedImages.getImage("icons/obj16/container_obj.gif");
    }

    public void init(ICProject cproject) {
        this.fCurrCProject = cproject;
        this.fProjPath = this.fCurrCProject.getProject().getFullPath();
        this.updateFoldersList();
    }

    private void updateFoldersList() {
        List<CPElement> folders = this.filterList(this.fCPathList.getElements());
        this.fOutputList.setElements(folders);
        int i = 0;
        while (i < folders.size()) {
            CPElement cpe = folders.get(i);
            IPath[] patterns = (IPath[])cpe.getAttribute("exclusion");
            if (patterns.length > 0) {
                this.fOutputList.expandElement(cpe, 3);
            }
            ++i;
        }
    }

    @Override
    public void createControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fOutputList}, true);
        LayoutUtil.setHorizontalGrabbing(this.fOutputList.getTreeControl(null), true);
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fOutputList.setButtonsMinWidth(buttonBarWidth);
        List<CPElement> elements = this.fOutputList.getElements();
        int i = 0;
        while (i < elements.size()) {
            CPElement elem = elements.get(i);
            IPath[] patterns = (IPath[])elem.getAttribute("exclusion");
            if (patterns.length > 0) {
                this.fOutputList.expandElement(elem, 3);
            }
            ++i;
        }
        this.setControl((Control)composite);
        CUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.cdt.ui.std_prop_output");
    }

    protected void outputPageKeyPressed(TreeListDialogField<CPElement> field, KeyEvent event) {
        List<Object> selection;
        if (field == this.fOutputList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    protected void outputPageDoubleClicked(TreeListDialogField<CPElement> field) {
        List<Object> selection;
        if (field == this.fOutputList && this.canEdit(selection = field.getSelectedElements())) {
            this.editEntry();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasFolders(IContainer container) {
        try {
            IResource[] members;
            IResource[] iResourceArray = members = container.members();
            int n = members.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource member = iResourceArray[n2];
                if (member instanceof IContainer) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    protected void outputPageCustomButtonPressed(DialogField field, int index) {
        if (field == this.fOutputList) {
            if (index == 0) {
                CPElement entry;
                ArrayList<CPElement> elementsToAdd = new ArrayList<CPElement>(10);
                IProject project = this.fCurrCProject.getProject();
                if (project.exists()) {
                    if (this.hasFolders((IContainer)project)) {
                        CPElement[] srcentries = this.openOutputContainerDialog(null);
                        if (srcentries != null) {
                            CPElement[] cPElementArray = srcentries;
                            int n = srcentries.length;
                            int n2 = 0;
                            while (n2 < n) {
                                CPElement srcentrie = cPElementArray[n2];
                                elementsToAdd.add(srcentrie);
                                ++n2;
                            }
                        }
                    } else {
                        entry = this.openNewOutputContainerDialog(null, true);
                        if (entry != null) {
                            elementsToAdd.add(entry);
                        }
                    }
                } else {
                    entry = this.openNewOutputContainerDialog(null, false);
                    if (entry != null) {
                        elementsToAdd.add(entry);
                    }
                }
                if (!elementsToAdd.isEmpty()) {
                    HashSet<CPElement> modifiedElements = new HashSet<CPElement>();
                    this.askForAddingExclusionPatternsDialog(elementsToAdd, modifiedElements);
                    this.fOutputList.addElements(elementsToAdd);
                    this.fOutputList.postSetSelection((ISelection)new StructuredSelection(elementsToAdd));
                    if (!modifiedElements.isEmpty()) {
                        for (CPElement elem : modifiedElements) {
                            this.fOutputList.refresh(elem);
                            this.fOutputList.expandElement(elem, 3);
                        }
                    }
                }
            } else if (index == 2) {
                this.editEntry();
            } else if (index == 3) {
                this.removeEntry();
            }
        }
    }

    private void editEntry() {
        List<Object> selElements = this.fOutputList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fOutputList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((CPElement)elem);
        } else if (elem instanceof CPElementAttribute) {
            this.editAttributeEntry((CPElementAttribute)elem);
        }
    }

    private void editElementEntry(CPElement elem) {
        CPElement res = null;
        res = this.openNewOutputContainerDialog(elem, true);
        if (res != null) {
            this.fOutputList.replaceElement(elem, res);
        }
    }

    private void editAttributeEntry(CPElementAttribute elem) {
        String key = elem.getKey();
        if (key.equals("exclusion")) {
            CPElement selElement = elem.getParent();
            ExclusionPatternDialog dialog = new ExclusionPatternDialog(this.getShell(), selElement);
            if (dialog.open() == 0) {
                selElement.setAttribute("exclusion", dialog.getExclusionPattern());
                this.fOutputList.refresh();
                this.fCPathList.dialogFieldChanged();
            }
        }
    }

    protected void outputPageSelectionChanged(DialogField field) {
        List<Object> selected = this.fOutputList.getSelectedElements();
        this.fOutputList.enableButton(2, this.canEdit(selected));
        this.fOutputList.enableButton(3, this.canRemove(selected));
    }

    private void removeEntry() {
        List<Object> selElements = this.fOutputList.getSelectedElements();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof CPElementAttribute) {
                CPElementAttribute attrib = (CPElementAttribute)elem;
                String key = attrib.getKey();
                Path[] value = key.equals("exclusion") ? new Path[]{} : null;
                attrib.getParent().setAttribute(key, value);
                selElements.remove(i);
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fOutputList.refresh();
            this.fCPathList.dialogFieldChanged();
        } else {
            this.fOutputList.removeElements(selElements);
        }
    }

    private boolean canRemove(List<?> selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            CPElement curr;
            CPElementAttribute attrib;
            Object elem = selElements.get(i);
            if (elem instanceof CPElementAttribute ? ((attrib = (CPElementAttribute)elem).getKey().equals("exclusion") ? ((IPath[])attrib.getValue()).length == 0 : attrib.getValue() == null) : elem instanceof CPElement && (curr = (CPElement)elem).getParentContainer() != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean canEdit(List<?> selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (elem instanceof CPElement) {
            return false;
        }
        return elem instanceof CPElementAttribute;
    }

    protected void outputPageDialogFieldChanged(DialogField field) {
        if (this.fCurrCProject == null) {
            return;
        }
        if (field == this.fOutputList) {
            this.updateCPathList();
        }
    }

    private void updateCPathList() {
        int nEntries;
        List<CPElement> srcelements = this.fOutputList.getElements();
        List<CPElement> cpelements = this.fCPathList.getElements();
        int lastRemovePos = nEntries = cpelements.size();
        int afterLastSourcePos = 0;
        int i = nEntries - 1;
        while (i >= 0) {
            CPElement cpe = cpelements.get(i);
            int kind = cpe.getEntryKind();
            if (this.isEntryKind(kind)) {
                if (!srcelements.remove(cpe)) {
                    cpelements.remove(i);
                    lastRemovePos = i;
                } else if (lastRemovePos == nEntries) {
                    afterLastSourcePos = i + 1;
                }
            }
            --i;
        }
        if (!srcelements.isEmpty()) {
            int insertPos = Math.min(afterLastSourcePos, lastRemovePos);
            cpelements.addAll(insertPos, srcelements);
        }
        if (lastRemovePos != nEntries || !srcelements.isEmpty()) {
            this.fCPathList.setElements(cpelements);
        }
    }

    private CPElement openNewOutputContainerDialog(CPElement existing, boolean includeLinked) {
        if (includeLinked) {
            NewFolderDialog dialog = new NewFolderDialog(this.getShell(), (IContainer)this.fCurrCProject.getProject());
            if (dialog.open() == 0) {
                IResource createdFolder = (IResource)dialog.getResult()[0];
                return this.newCPOutputElement(createdFolder);
            }
            return null;
        }
        String title = existing == null ? CPathEntryMessages.SourcePathEntryPage_NewSourceFolderDialog_new_title : CPathEntryMessages.SourcePathEntryPage_NewSourceFolderDialog_edit_title;
        IProject proj = this.fCurrCProject.getProject();
        NewSourceFolderDialog dialog = new NewSourceFolderDialog(this.getShell(), title, proj, this.getExistingContainers(existing), existing);
        dialog.setMessage(NLS.bind((String)CPathEntryMessages.SourcePathEntryPage_NewSourceFolderDialog_description, (Object)this.fProjPath.toString()));
        if (dialog.open() == 0) {
            IContainer folder = dialog.getSourceFolder();
            return this.newCPOutputElement((IResource)folder);
        }
        return null;
    }

    private void askForAddingExclusionPatternsDialog(List<CPElement> newEntries, Set<CPElement> modifiedEntries) {
        this.fixNestingConflicts(newEntries, this.fOutputList.getElements(), modifiedEntries);
        if (!modifiedEntries.isEmpty()) {
            String title = CPathEntryMessages.OutputPathEntryPage_exclusion_added_title;
            String message = CPathEntryMessages.OutputPathEntryPage_exclusion_added_message;
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    private CPElement[] openOutputContainerDialog(CPElement existing) {
        Class[] acceptedClasses = new Class[]{IProject.class, IFolder.class};
        List<IContainer> existingContainers = this.getExistingContainers(null);
        IProject[] allProjects = this.fWorkspaceRoot.getProjects();
        ArrayList<IProject> rejectedElements = new ArrayList<IProject>(allProjects.length);
        IProject currProject = this.fCurrCProject.getProject();
        int i = 0;
        while (i < allProjects.length) {
            if (!allProjects[i].equals((Object)currProject)) {
                rejectedElements.add(allProjects[i]);
            }
            ++i;
        }
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedElements.toArray());
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        BaseWorkbenchContentProvider cp = new BaseWorkbenchContentProvider();
        String title = existing == null ? CPathEntryMessages.OutputPathEntryPage_ExistingOutputFolderDialog_new_title : CPathEntryMessages.OutputPathEntryPage_ExistingOutputFolderDialog_edit_title;
        String message = existing == null ? CPathEntryMessages.OutputPathEntryPage_ExistingOutputFolderDialog_new_description : CPathEntryMessages.OutputPathEntryPage_ExistingOutputFolderDialog_edit_description;
        MultipleFolderSelectionDialog dialog = new MultipleFolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setExisting(existingContainers.toArray());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter(filter);
        dialog.setInput(this.fCurrCProject.getProject().getParent());
        if (existing == null) {
            dialog.setInitialFocus(this.fCurrCProject.getProject());
        } else {
            dialog.setInitialFocus(existing.getResource());
        }
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            CPElement[] res = new CPElement[elements.length];
            int i2 = 0;
            while (i2 < res.length) {
                IResource elem = (IResource)elements[i2];
                res[i2] = this.newCPOutputElement(elem);
                ++i2;
            }
            return res;
        }
        return null;
    }

    private List<IContainer> getExistingContainers(CPElement existing) {
        ArrayList<IContainer> res = new ArrayList<IContainer>();
        List<CPElement> cplist = this.fOutputList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            CPElement elem = cplist.get(i);
            if (elem != existing && (resource = elem.getResource()) instanceof IContainer) {
                res.add((IContainer)resource);
            }
            ++i;
        }
        return res;
    }

    private CPElement newCPOutputElement(IResource res) {
        Assert.isNotNull((Object)res);
        return new CPElement(this.fCurrCProject, 128, res.getFullPath(), res);
    }

    public List<Object> getSelection() {
        return this.fOutputList.getSelectedElements();
    }

    @Override
    public void setSelection(List<?> selElements) {
        this.fOutputList.selectElements((ISelection)new StructuredSelection(selElements));
    }

    @Override
    public boolean isEntryKind(int kind) {
        return kind == 128;
    }

    @Override
    public void performApply(IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void performDefaults() {
    }

    private class OutputContainerAdapter
    implements ITreeListAdapter<CPElement>,
    IDialogFieldListener {
        private final Object[] EMPTY_ARR = new Object[0];

        private OutputContainerAdapter() {
        }

        @Override
        public void customButtonPressed(TreeListDialogField<CPElement> field, int index) {
            CPathOutputEntryPage.this.outputPageCustomButtonPressed(field, index);
        }

        @Override
        public void selectionChanged(TreeListDialogField<CPElement> field) {
            CPathOutputEntryPage.this.outputPageSelectionChanged(field);
        }

        @Override
        public void doubleClicked(TreeListDialogField<CPElement> field) {
            CPathOutputEntryPage.this.outputPageDoubleClicked(field);
        }

        @Override
        public void keyPressed(TreeListDialogField<CPElement> field, KeyEvent event) {
            CPathOutputEntryPage.this.outputPageKeyPressed(field, event);
        }

        @Override
        public Object[] getChildren(TreeListDialogField<CPElement> field, Object element) {
            if (element instanceof CPElement) {
                return ((CPElement)element).getChildren();
            }
            return this.EMPTY_ARR;
        }

        @Override
        public Object getParent(TreeListDialogField<CPElement> field, Object element) {
            if (element instanceof CPElementAttribute) {
                return ((CPElementAttribute)element).getParent();
            }
            return null;
        }

        @Override
        public boolean hasChildren(TreeListDialogField<CPElement> field, Object element) {
            return element instanceof CPElement;
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            CPathOutputEntryPage.this.outputPageDialogFieldChanged(field);
        }
    }
}

