/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.templateengine.TemplateEngineUtil;
import org.eclipse.cdt.ui.templateengine.SimpleElementException;
import org.eclipse.cdt.ui.templateengine.pages.UIWizardPage;
import org.eclipse.cdt.ui.templateengine.uitree.InputUIElement;
import org.eclipse.cdt.ui.templateengine.uitree.SimpleUIElementGroup;
import org.eclipse.cdt.ui.templateengine.uitree.UIElement;

public class UIPagesProvider {
    private List<String> orderVector = new ArrayList<String>();

    public List<String> getOrderVector() {
        return this.orderVector;
    }

    public void clearOrderVector() {
        this.orderVector = new ArrayList<String>();
    }

    public Map<String, UIWizardPage> getWizardUIPages(UIElement uiElement, Map<String, String> valueStore) {
        int childCount = 0;
        try {
            childCount = uiElement.getChildCount();
        }
        catch (SimpleElementException e) {
            TemplateEngineUtil.log((Throwable)e);
        }
        HashMap<String, UIWizardPage> pageMap = new HashMap<String, UIWizardPage>();
        if (this.hasChildUIGroupElement(uiElement)) {
            int i = 0;
            while (i < childCount) {
                try {
                    pageMap.putAll(this.getWizardUIPages(uiElement.getChild(i), valueStore));
                }
                catch (SimpleElementException e) {
                    TemplateEngineUtil.log((Throwable)e);
                }
                ++i;
            }
        } else if (this.hasChildUIElement(uiElement)) {
            String label = (String)uiElement.getAttributes().get("label");
            String description = (String)uiElement.getAttributes().get("description");
            UIWizardPage uiPage = new UIWizardPage(label, description, uiElement, valueStore);
            pageMap.put((String)uiElement.getAttributes().get("id"), uiPage);
            this.addToOrderVector((String)uiElement.getAttributes().get("id"));
        }
        return pageMap;
    }

    public boolean hasChildUIGroupElement(UIElement parent) {
        boolean retVal;
        block4: {
            retVal = false;
            try {
                if (parent.getChildCount() <= 0) break block4;
                int i = 0;
                while (i < parent.getChildCount()) {
                    if (parent.getChild(i) instanceof SimpleUIElementGroup) {
                        retVal = true;
                        break;
                    }
                    ++i;
                }
            }
            catch (SimpleElementException simpleElementException) {
                retVal = false;
            }
        }
        return retVal;
    }

    public boolean hasChildUIElement(UIElement parent) {
        boolean retVal;
        block4: {
            retVal = false;
            try {
                if (parent.getChildCount() <= 0) break block4;
                int i = 0;
                while (i < parent.getChildCount()) {
                    if (parent.getChild(i) instanceof InputUIElement) {
                        retVal = true;
                        break;
                    }
                    ++i;
                }
            }
            catch (SimpleElementException simpleElementException) {
                retVal = false;
            }
        }
        return retVal;
    }

    private void addToOrderVector(String pageId) {
        for (String id : this.orderVector) {
            if (!id.equalsIgnoreCase(pageId)) continue;
            return;
        }
        this.orderVector.add(pageId);
    }
}

