/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model;

import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.launch.CudaFocus;
import com.nvidia.cuda.ide.debug.mi.DeviceInfo;
import com.nvidia.cuda.ide.debug.mi.vo.SMInfo;
import com.nvidia.cuda.ide.debug.mi.vo.UncoalescedWarpInfo;
import com.nvidia.cuda.ide.debug.model.Block;
import com.nvidia.cuda.ide.debug.model.CudaException;
import com.nvidia.cuda.ide.debug.model.CudaRuntimeInformation;
import com.nvidia.cuda.ide.debug.model.CudaThreadState;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.ElementType;
import com.nvidia.cuda.ide.debug.model.ICoordSorter;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.ICudaVisitor;
import com.nvidia.cuda.ide.debug.model.IFocusDMContext;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.Lane;
import com.nvidia.cuda.ide.debug.model.RangeContext;
import com.nvidia.cuda.ide.debug.model.StreamingMultiprocessor;
import com.nvidia.cuda.ide.debug.model.Warp;
import com.nvidia.cuda.ide.debug.model.query.IElementQuery;
import com.nvidia.cuda.ide.debug.model.state.BlocksStateManager;
import com.nvidia.cuda.ide.debug.model.state.HardwareStateManager;
import com.nvidia.cuda.ide.debug.model.state.ICudaQueries;
import com.nvidia.cuda.ide.debug.model.state.KernelsStateManager;
import com.nvidia.cuda.ide.debug.model.state.QueryProcessor;
import com.nvidia.cuda.ide.debug.model.state.SourceLocation;
import com.nvidia.cuda.ide.debug.model.state.ThreadsStateManager;
import com.nvidia.cuda.ide.debug.service.ICudaExpressions;
import com.nvidia.cuda.ide.debug.service.ICudaProcesses;
import com.nvidia.cuda.ide.debug.service.ICudaRegisters;
import com.nvidia.cuda.ide.debug.service.ICudaStack;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateInDsfExecutor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class CudaApplicationState
extends AbstractDMContext
implements ICudaApplication {
    private final BlocksStateManager blocks;
    private final HardwareStateManager hardware;
    private final KernelsStateManager kernels;
    private final QueryProcessor queryProcessor;
    private final ICudaQueries queries;
    private final ThreadsStateManager threads;
    private final IRunControl.IContainerDMContext containerDMContext;

    private static IRunControl.IContainerDMContext getContainerContext(IDMContext dmc) {
        IRunControl.IContainerDMContext containerDMC = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRunControl.IContainerDMContext.class);
        if (containerDMC == null) {
            DsfServicesTracker tracker = new DsfServicesTracker(Activator.getBundleContext(), dmc.getSessionId());
            try {
                IMIContainerDMContext container;
                ICudaProcesses service = (ICudaProcesses)tracker.getService(ICudaProcesses.class);
                IMIContainerDMContext iMIContainerDMContext = container = service.createContainerContextFromGroupId((ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class), "i1");
                return iMIContainerDMContext;
            }
            finally {
                tracker.dispose();
            }
        }
        return containerDMC;
    }

    public CudaApplicationState(DsfSession dsfSession, IDMContext parent, ICudaQueries queries) {
        super(dsfSession, new IDMContext[]{parent});
        this.queries = queries;
        this.blocks = new BlocksStateManager(this, queries);
        this.kernels = new KernelsStateManager(this, queries);
        this.threads = new ThreadsStateManager(this, queries);
        this.hardware = new HardwareStateManager(this, queries);
        this.queryProcessor = new QueryProcessor(this, this.threads, this.hardware);
        this.containerDMContext = CudaApplicationState.getContainerContext(parent);
    }

    @Override
    public void accept(ICudaVisitor visitor) {
        visitor.visitApplication(this);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public void getActiveBlocks(Kernel kernel, boolean fillGaps, ICoordSorter sorter, DataRequestMonitor<IDMContext[]> rm) {
        this.blocks.getActiveBlocks(kernel, fillGaps, sorter, rm);
    }

    @Override
    public void getActiveLanes(final Warp warp, final boolean fillGaps, final DataRequestMonitor<IDMContext[]> rm) {
        this.queries.queryWarps(warp, warp.getDeviceId(), warp.getSMId(), new DataRequestMonitor<UncoalescedWarpInfo[]>(this.getExecutor(), rm){

            protected void handleSuccess() {
                UncoalescedWarpInfo[] infos;
                UncoalescedWarpInfo[] uncoalescedWarpInfoArray = infos = (UncoalescedWarpInfo[])this.getData();
                int n = infos.length;
                int n2 = 0;
                while (n2 < n) {
                    UncoalescedWarpInfo info = uncoalescedWarpInfoArray[n2];
                    if (info.getWarp() == warp.getId()) {
                        try {
                            IDMContext[] contexts = CudaApplicationState.this.getActiveLanes(warp, fillGaps, info.getActiveLanesMask() | info.getDivergentLanesMask(), ((Device)DMContexts.getAncestorOfType((IDMContext)warp, Device.class)).getLaneCount());
                            rm.setData((Object)contexts);
                        }
                        catch (CudaException e) {
                            rm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
                        }
                        rm.done();
                        return;
                    }
                    ++n2;
                }
                rm.setData((Object)new IDMContext[0]);
                rm.done();
            }
        });
    }

    protected IDMContext[] getActiveLanes(Warp warp, boolean fillGaps, long runningLanes, short laneCount) throws CudaException {
        ArrayList<AbstractDMContext> collection = new ArrayList<AbstractDMContext>(laneCount);
        int rangeStart = -1;
        short i = 0;
        while (i < laneCount) {
            if ((runningLanes & 1L) != 0L) {
                if (rangeStart >= 0 && fillGaps) {
                    collection.add(new RangeContext(warp, rangeStart, i - 1));
                }
                rangeStart = -1;
                collection.add(warp.getLane(i));
            } else if (rangeStart < 0) {
                rangeStart = i;
            }
            runningLanes >>= 1;
            i = (short)(i + 1);
        }
        if (rangeStart >= 0) {
            collection.add(new RangeContext(warp, rangeStart, laneCount - 1));
        }
        return collection.toArray(new IDMContext[collection.size()]);
    }

    @Override
    public void getActiveSMs(final Device device, final boolean fillGaps, final DataRequestMonitor<IDMContext[]> rm) {
        if (DsfSession.isSessionActive((String)this.getSessionId())) {
            this.queries.queryDevices(device, new DataRequestMonitor<DeviceInfo[]>(this.getExecutor(), rm){

                protected void handleSuccess() {
                    DeviceInfo[] deviceInfoArray = (DeviceInfo[])this.getData();
                    int n = deviceInfoArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DeviceInfo info = deviceInfoArray[n2];
                        if (info.getId() == device.getId()) {
                            try {
                                rm.setData((Object)CudaApplicationState.this.getActiveSMs(device, fillGaps, info.getActiveSMsMask(), device.getSmCount()));
                            }
                            catch (CudaException e) {
                                rm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
                            }
                            rm.done();
                            return;
                        }
                        ++n2;
                    }
                    rm.setData((Object)new IDMContext[0]);
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", "Session was shut down"));
            rm.done();
        }
    }

    protected IDMContext[] getActiveSMs(Device device, boolean fillGaps, long activeSMsMask, short smCount) throws CudaException {
        ArrayList<AbstractDMContext> contexts = new ArrayList<AbstractDMContext>(smCount);
        int rangeStart = -1;
        short i = 0;
        while (i < smCount) {
            if ((activeSMsMask & 1L) != 0L) {
                if (rangeStart >= 0 && fillGaps) {
                    contexts.add(new RangeContext(device, rangeStart, i - 1));
                }
                rangeStart = -1;
                contexts.add(device.getSm(i));
            } else if (rangeStart < 0) {
                rangeStart = i;
            }
            activeSMsMask >>= 1;
            i = (short)(i + 1);
        }
        if (rangeStart >= 0) {
            contexts.add(new RangeContext(device, rangeStart, smCount - 1));
        }
        return contexts.toArray(new IDMContext[contexts.size()]);
    }

    @Override
    public void getActiveThreads(Block block, boolean fillGaps, ICoordSorter sorter, DataRequestMonitor<IDMContext[]> rm) {
        this.threads.getActiveThreads(block, fillGaps, sorter, rm);
    }

    @Override
    public void getActiveWarps(final StreamingMultiprocessor sm, final boolean fillGaps, final DataRequestMonitor<IDMContext[]> rm) {
        this.queries.querySMs(sm, sm.getDeviceId(), new DataRequestMonitor<SMInfo[]>(this.getExecutor(), rm){

            protected void handleSuccess() {
                SMInfo[] sMInfoArray = (SMInfo[])this.getData();
                int n = sMInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SMInfo smInfo = sMInfoArray[n2];
                    if (smInfo.getSM() == sm.getId()) {
                        try {
                            rm.setData((Object)CudaApplicationState.this.getActiveWarps(sm, fillGaps, smInfo.activeWarpsMask(), ((Device)DMContexts.getAncestorOfType((IDMContext)sm, Device.class)).getWarpCount()));
                        }
                        catch (CudaException e) {
                            rm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
                        }
                        rm.done();
                        return;
                    }
                    ++n2;
                }
                rm.setData((Object)new IDMContext[0]);
                rm.done();
            }
        });
    }

    protected IDMContext[] getActiveWarps(StreamingMultiprocessor sm, boolean fillGaps, long activeWarpsMask, short warpCount) throws CudaException {
        ArrayList<AbstractDMContext> collection = new ArrayList<AbstractDMContext>(warpCount);
        int rangeStart = -1;
        short i = 0;
        while (i < warpCount) {
            if (activeWarpsMask == 0L) {
                if (rangeStart >= 0) break;
                rangeStart = i;
                break;
            }
            if ((activeWarpsMask & 1L) != 0L) {
                if (rangeStart >= 0 && fillGaps) {
                    collection.add(new RangeContext(sm, rangeStart, i - 1));
                }
                rangeStart = -1;
                collection.add(sm.getWarp(i));
            } else if (rangeStart < 0) {
                rangeStart = i;
            }
            activeWarpsMask >>= 1;
            i = (short)(i + 1);
        }
        if (rangeStart >= 0) {
            collection.add(new RangeContext(sm, rangeStart, warpCount - 1));
        }
        return collection.toArray(new IDMContext[collection.size()]);
    }

    public int getBlocksCount(Kernel kernel) {
        return kernel.getGridDim().elementCount();
    }

    @Override
    public void getBlockState(Block cudaBlock, DataRequestMonitor<CudaRuntimeInformation> rm) {
        this.blocks.getBlockState(cudaBlock, rm);
    }

    @Override
    public void getDevices(DataRequestMonitor<Device[]> rm) {
        this.hardware.getDevices(rm);
    }

    @Override
    public Executor getExecutor() {
        return new ImmediateInDsfExecutor(this.queries.getExecutor());
    }

    @Override
    public Kernel getKernel(long id) {
        return this.kernels.get(id);
    }

    @Override
    public void getKernels(DataRequestMonitor<? super Kernel[]> rm) {
        IRunControl service = this.queries.getService(IRunControl.class);
        if (service != null && (service.isSuspended(null) || service.isStepping(null))) {
            this.kernels.getKernels(this.containerDMContext, rm);
        } else {
            rm.setData((Object)new Kernel[0]);
            rm.done();
        }
    }

    @Override
    public void getLaneState(Lane lane, DataRequestMonitor<CudaRuntimeInformation> rm) {
        this.threads.getLaneState(lane, rm);
    }

    @Override
    public short getSM(Block block) {
        return this.blocks.getSM(block);
    }

    @Override
    public void getSMState(StreamingMultiprocessor sm, DataRequestMonitor<CudaRuntimeInformation> rm) {
        this.hardware.getSMState(sm, rm);
    }

    @Override
    public void getSourceLocation(IDMContext dmc, short device, short sm, short warp, short lane, DataRequestMonitor<SourceLocation> rm) {
        this.threads.getSourceLocation(dmc, device, sm, warp, lane, rm);
    }

    @Override
    public void getState(DataRequestMonitor<CudaRuntimeInformation> rm) {
        rm.setData((Object)new CudaRuntimeInformation(-1, -1, -1, -1, CudaThreadState.RUNNING));
        rm.done();
    }

    @Override
    public void getThreadState(IFocusDMContext cudaThread, DataRequestMonitor<CudaRuntimeInformation> rm) {
        try {
            if (cudaThread.getKernel().getName() == null) {
                Kernel kernel = this.getKernel(cudaThread.getKernelId());
                Block block = kernel.getBlock(cudaThread.getBlockIdx());
                cudaThread = block.getThread(cudaThread.getThreadIdx());
            }
            this.threads.getThreadState(cudaThread, rm);
        }
        catch (CudaException e) {
            rm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
        }
    }

    @Override
    public void getWarpState(final Warp warp, final DataRequestMonitor<CudaRuntimeInformation> rm) {
        this.hardware.getWarpActiveBit(warp, new DataRequestMonitor<Boolean>(this.getExecutor(), rm){

            protected void handleSuccess() {
                if (((Boolean)this.getData()).booleanValue()) {
                    CudaApplicationState.this.threads.getWarpState(warp, (DataRequestMonitor<CudaRuntimeInformation>)rm);
                } else {
                    rm.setData((Object)CudaRuntimeInformation.INACTIVE);
                    rm.done();
                }
            }

            @ConfinedToDsfExecutor(value="fExecutor")
            protected void handleFailure() {
                rm.cancel();
                rm.done();
            }
        });
    }

    @Override
    public boolean hasExpandedThreads(Block cudaBlock) {
        return false;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean hasKernels() {
        return !this.kernels.isEmpty();
    }

    @Override
    public synchronized void invalidate() {
        this.kernels.invalidate();
        this.blocks.clear();
        this.threads.invalidate();
        this.hardware.invalidate();
        this.queryProcessor.invalidate();
    }

    @Override
    public void prepareQuery(IElementQuery query, boolean logicalElements, DataRequestMonitor<IElementQuery> rm) {
        this.queryProcessor.prepareQuery(query, logicalElements, rm);
    }

    @Override
    public IRunControl.IExecutionDMContext getExecutionContext(IMIContainerDMContext containerDmc, CudaFocus focus) throws CudaException {
        Kernel kernel = this.getKernel(focus.getKernelId());
        if (kernel == null) {
            kernel = this.kernels.addKernel(new Kernel((IRunControl.IContainerDMContext)containerDmc, this, focus.getKernelId(), focus.getDevice(), Kernel.KernelState.Running));
        }
        Block block = kernel.getBlock(focus.getBlockIdx());
        return block.getThread(focus.getThreadIdx());
    }

    @Override
    public ElementType getType() {
        return ElementType.application;
    }

    @Override
    public void getExpressions(final IFocusDMContext focus, final IDMContext[] contexts, final DataRequestMonitor<IDMContext[]> rm) {
        focus.getState((DataRequestMonitor)new DataRequestMonitor<CudaRuntimeInformation>(this.getExecutor(), rm){

            protected void handleSuccess() {
                if (((CudaRuntimeInformation)this.getData()).getState().isActive()) {
                    CudaApplicationState.this.checkStackFrame(focus, contexts, (DataRequestMonitor<IDMContext[]>)rm);
                } else {
                    rm.setStatus((IStatus)new Status(1, "com.nvidia.cuda.ide.debug", "Inactive"));
                    rm.done();
                }
            }
        });
    }

    protected void checkStackFrame(IFocusDMContext focus, final IDMContext[] contexts, final DataRequestMonitor<IDMContext[]> rm) {
        IDMContext expressionCtx = contexts[0];
        if (expressionCtx instanceof IExpressions.IExpressionDMContext) {
            ICudaStack stack = this.queries.getService(ICudaStack.class);
            stack.getCorrespondingStackFrame(expressionCtx, focus, new DataRequestMonitor<IStack.IFrameDMContext>(this.getExecutor(), rm){

                protected void handleSuccess() {
                    if (this.getData() != null) {
                        CudaApplicationState.this.createExpressions((IStack.IFrameDMContext)this.getData(), contexts, (DataRequestMonitor<IDMContext[]>)rm);
                    } else {
                        rm.setStatus(this.getStatus());
                        rm.done();
                    }
                }
            });
        } else if (expressionCtx instanceof IRegisters.IRegisterDMContext) {
            rm.setData((Object)this.adoptRegisters(focus, contexts));
            rm.done();
        } else {
            rm.done();
        }
    }

    protected void createExpressions(IStack.IFrameDMContext stackFrame, IDMContext[] expressions, DataRequestMonitor<IDMContext[]> rm) {
        ICudaExpressions service = this.queries.getService(ICudaExpressions.class);
        if (service != null) {
            service.createExpressions(stackFrame, expressions, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", "Not ready"));
            rm.done();
        }
    }

    private IDMContext[] adoptRegisters(IFocusDMContext focus, IDMContext[] expressions) {
        ICudaRegisters service = this.queries.getService(ICudaRegisters.class);
        if (service != null) {
            return service.adopt(focus, expressions);
        }
        return null;
    }

    @Override
    public void toHardwareElement(DataRequestMonitor<ICudaRuntimeObject> drm) {
        drm.setData((Object)this);
        drm.done();
    }

    @Override
    public void toLogicalElement(DataRequestMonitor<ICudaRuntimeObject> drm) {
        drm.setData((Object)this);
        drm.done();
    }

    @Override
    public void getKernelState(Kernel kernel, DataRequestMonitor<CudaRuntimeInformation> rm) {
        this.kernels.getState(kernel, rm);
    }
}

