/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model.query;

import com.nvidia.cuda.ide.debug.model.query.Dim3Filter;
import com.nvidia.cuda.ide.debug.model.query.ElementQuery;
import com.nvidia.cuda.ide.debug.model.query.HardwareVerticalCondition;
import com.nvidia.cuda.ide.debug.model.query.IElementQuery;
import com.nvidia.cuda.ide.debug.model.query.LogicalWildcardCondition;
import java.util.Collection;
import java.util.HashSet;

public class FilterFactory {
    private final Collection<Integer> device = new HashSet<Integer>();
    private final Collection<Integer> sm = new HashSet<Integer>();
    private final Collection<Integer> warp = new HashSet<Integer>();
    private final Collection<Integer> lane = new HashSet<Integer>();
    private final Collection<Integer> kernel = new HashSet<Integer>();
    private final Collection<Dim3Filter> blockFilters = new HashSet<Dim3Filter>();
    private final Collection<Dim3Filter> threadFilters = new HashSet<Dim3Filter>();

    public IElementQuery getQuery() {
        return ElementQuery.and(this.getLogicalConditions(), this.getHardwareQuery());
    }

    private IElementQuery getLogicalConditions() {
        this.kernel.remove(-1);
        if (this.kernel.size() == 0) {
            return this.buildKernelConditions(-1);
        }
        HashSet<IElementQuery> res = new HashSet<IElementQuery>();
        for (Integer kernelId : this.kernel) {
            res.add(this.buildKernelConditions(kernelId));
        }
        return ElementQuery.or(res.toArray(new IElementQuery[res.size()]));
    }

    private IElementQuery buildKernelConditions(int kernelId) {
        if (this.blockFilters.size() == 0) {
            return this.buildBlockConditions(kernelId, null);
        }
        HashSet<IElementQuery> conditions = new HashSet<IElementQuery>();
        for (Dim3Filter dim3 : this.blockFilters) {
            conditions.add(this.buildBlockConditions(kernelId, dim3));
        }
        return ElementQuery.or(conditions.toArray(new IElementQuery[conditions.size()]));
    }

    private IElementQuery buildBlockConditions(int kernelId, Dim3Filter dim3Filter) {
        if (this.threadFilters.size() == 0) {
            if (kernelId < 0 && (dim3Filter == null || dim3Filter.isAllElements())) {
                return ElementQuery.ALL_ELEMENTS;
            }
            return new ElementQuery(new LogicalWildcardCondition(kernelId, dim3Filter, null));
        }
        IElementQuery[] conditions = new IElementQuery[this.threadFilters.size()];
        int i = 0;
        for (Dim3Filter filter : this.threadFilters) {
            conditions[i++] = new ElementQuery(new LogicalWildcardCondition(kernelId, dim3Filter, filter));
        }
        return ElementQuery.or(conditions);
    }

    private IElementQuery getHardwareQuery() {
        this.device.remove(-1);
        this.sm.remove(-1);
        this.warp.remove(-1);
        this.lane.remove(-1);
        if (this.device.size() == 0) {
            return this.getSMQuery((short)-1);
        }
        IElementQuery[] devices = new IElementQuery[this.device.size()];
        int i = 0;
        for (Integer deviceId : this.device) {
            devices[i++] = this.getSMQuery(deviceId.shortValue());
        }
        return ElementQuery.or(devices);
    }

    private IElementQuery getSMQuery(short deviceId) {
        if (this.sm.size() == 0) {
            return this.getWarpQuery(deviceId, (short)-1);
        }
        IElementQuery[] sms = new IElementQuery[this.sm.size()];
        int i = 0;
        for (Integer id : this.sm) {
            sms[i++] = this.getWarpQuery(deviceId, id.shortValue());
        }
        return ElementQuery.or(sms);
    }

    private IElementQuery getWarpQuery(short deviceId, short sm) {
        if (this.warp.size() == 0) {
            return this.getLaneQuery(deviceId, sm, (short)-1);
        }
        IElementQuery[] queries = new IElementQuery[this.warp.size()];
        int i = 0;
        for (Integer warp : this.warp) {
            queries[i++] = this.getLaneQuery(deviceId, sm, warp.shortValue());
        }
        return ElementQuery.or(queries);
    }

    private IElementQuery getLaneQuery(short deviceId, short sm, short warp) {
        if (this.lane.size() == 0) {
            if (warp < 0 && sm < 0 && deviceId < 0) {
                return ElementQuery.ALL_ELEMENTS;
            }
            return new ElementQuery(new HardwareVerticalCondition(deviceId, sm, warp, -1));
        }
        IElementQuery[] queries = new IElementQuery[this.lane.size()];
        int i = 0;
        for (Integer laneId : this.lane) {
            queries[i++] = new ElementQuery(new HardwareVerticalCondition(deviceId, sm, warp, laneId.shortValue()));
        }
        return ElementQuery.or(queries);
    }

    public void createBlockFilter(Dim3Filter filter) {
        this.blockFilters.add(filter);
    }

    public void createDeviceFilter(int filter) {
        this.device.add(filter);
    }

    public void createKernelFilter(int filter) {
        this.kernel.add(filter);
    }

    public void createLaneFilter(int filter) {
        this.lane.add(filter);
    }

    public void createSMFilter(int filter) {
        this.sm.add(filter);
    }

    public void createThreadFilter(Dim3Filter filter) {
        this.threadFilters.add(filter);
    }

    public void createWarpFilter(int filter) {
        this.warp.add(filter);
    }
}

