/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model.query;

import com.nvidia.cuda.ide.debug.model.Block;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.ElementType;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.StreamingMultiprocessor;
import com.nvidia.cuda.ide.debug.model.Warp;
import com.nvidia.cuda.ide.debug.model.query.IElementQuery;
import java.util.Arrays;
import java.util.TreeSet;

public class OrQuery
implements IElementQuery {
    private final IElementQuery q1;
    private final IElementQuery q2;

    public OrQuery(IElementQuery q1, IElementQuery q2) {
        this.q1 = q1;
        this.q2 = q2;
    }

    @Override
    public IElementQuery getHardwareQuery() {
        return new OrQuery(this.q1.getHardwareQuery(), this.q2.getHardwareQuery());
    }

    @Override
    public IElementQuery getLogicalQuery() {
        return new OrQuery(this.q1.getLogicalQuery(), this.q2.getLogicalQuery());
    }

    @Override
    public boolean hasHardwareFilters() {
        return this.q1.hasHardwareFilters() || this.q2.hasHardwareFilters();
    }

    @Override
    public boolean hasLogicalFilters() {
        return this.q1.hasLogicalFilters() || this.q2.hasLogicalFilters();
    }

    @Override
    public boolean hasNoFilters() {
        return this.q1.hasNoFilters() && this.q2.hasNoFilters();
    }

    @Override
    public boolean match(ICudaRuntimeObject object) {
        return this.q1.match(object) || this.q2.match(object);
    }

    @Override
    public CudaCoord[] filterBlocks(Kernel kernel) {
        return this.join(this.q1.filterBlocks(kernel), this.q2.filterBlocks(kernel));
    }

    private CudaCoord[] join(CudaCoord[] ar1, CudaCoord[] ar2) {
        if (ar1 == null || ar2 == null) {
            return null;
        }
        TreeSet<CudaCoord> set = new TreeSet<CudaCoord>();
        set.addAll(Arrays.asList(ar2));
        set.addAll(Arrays.asList(ar1));
        return set.toArray(new CudaCoord[set.size()]);
    }

    @Override
    public CudaCoord[] filterThreads(Block block) {
        return this.join(this.q1.filterThreads(block), this.q2.filterThreads(block));
    }

    public String toString() {
        return String.format("(%s or %s)", this.q1, this.q2);
    }

    @Override
    public byte[] filterLanes(Warp warp) {
        return this.join(this.q1.filterLanes(warp), this.q2.filterLanes(warp));
    }

    private byte[] join(byte[] ar1, byte[] ar2) {
        if (ar1 == null || ar2 == null) {
            return null;
        }
        byte[] res = new byte[ar1.length + ar2.length];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < ar1.length && j < ar2.length) {
            byte b;
            if (ar1[i] < ar2[j]) {
                b = ar1[i++];
            } else if (ar1[i] > ar2[j]) {
                b = ar2[j++];
            } else {
                b = ar1[i++];
                ++j;
            }
            res[k++] = b;
        }
        while (i < ar1.length) {
            res[k++] = ar1[i++];
        }
        while (j < ar2.length) {
            res[k++] = ar2[j++];
        }
        if (k < res.length) {
            byte[] res2 = new byte[k];
            System.arraycopy(res, 0, res2, 0, k);
            return res2;
        }
        return res;
    }

    @Override
    public byte[] filterSMs(Device device) {
        return this.join(this.q1.filterSMs(device), this.q2.filterSMs(device));
    }

    @Override
    public byte[] filterWarps(StreamingMultiprocessor sm) {
        return this.join(this.q1.filterWarps(sm), this.q2.filterWarps(sm));
    }

    @Override
    public ElementType getElementType() {
        ElementType type1 = this.q1.getElementType();
        ElementType type2 = this.q2.getElementType();
        if (type1.ordinal() > type2.ordinal()) {
            return type1;
        }
        return type2;
    }
}

