/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.activity;

import com.nvidia.viper.activity.CuptiActivityBase;
import com.nvidia.viper.activity.CuptiActivityEnvironmentKind;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.CuptiEnvironmentClocksThrottleReason;
import com.nvidia.viper.activity.ICuptiActivity;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.NativeCupti;

public class CuptiActivityEnvironment
extends CuptiActivityBase
implements ICuptiActivity {
    public int deviceId;
    public long timestamp;
    public int environmentKind;
    public int smClock = -1;
    public int memoryClock = -1;
    public int pcieLinkGen = -1;
    public int pcieLinkWidth = -1;
    public int clocksThrottleReasons = -1;
    public int gpuTemperature = -1;
    public int power = -1;
    public int powerLimit = -1;
    public int fanSpeed = -1;

    public CuptiActivityEnvironment() {
        this.kind = CuptiActivityKind.CUPTI_ACTIVITY_KIND_INVALID.getCode();
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        return this.timestamp > 0L;
    }

    @Override
    public void appendToPDM(long hPdm) throws CuptiException {
        NativeCupti.cuptiPDMAppendActivity(hPdm, this);
    }

    public CuptiActivityEnvironmentKind getEnvironmentKind() {
        return CuptiActivityEnvironmentKind.valueOf(this.environmentKind);
    }

    public CuptiEnvironmentClocksThrottleReason[] getClocksThrottleReasons() {
        return CuptiEnvironmentClocksThrottleReason.getReasons(this.clocksThrottleReasons);
    }
}

