/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.editor;

import com.nvidia.viper.editor.ISourceMappingRule;
import com.nvidia.viper.editor.LocalFileMapping;
import com.nvidia.viper.editor.PrefixMapping;
import com.nvidia.viper.editor.RelativeMapping;
import com.nvidia.viper.model.Executable;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;

public final class RulesConfiguration
implements ISourceMappingRule {
    private final Executable executable;
    private final File location;
    private Map<String, URI> prefixMatches;

    private static Map<String, URI> loadMap(File file) {
        Map<String, URI> rules = new HashMap<String, URI>();
        if (file.exists()) {
            try {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                if (is.available() > 0) {
                    XMLDecoder decoder = new XMLDecoder(is);
                    rules = (Map)decoder.readObject();
                    decoder.close();
                } else {
                    is.close();
                }
            }
            catch (IOException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "com.nvidia.viper", null, (Throwable)e), 1);
            }
        }
        return rules;
    }

    public static RulesConfiguration read(Executable executable, File file) {
        Map<String, URI> rules = RulesConfiguration.loadMap(file);
        return new RulesConfiguration(executable, rules, file);
    }

    public RulesConfiguration(Executable executable, Map<String, URI> prefixMatches, File file) {
        this.executable = executable;
        this.prefixMatches = prefixMatches;
        this.location = file;
        this.buildRules();
    }

    public void addMapping(String path, URI uri) {
        if (uri == null) {
            this.prefixMatches.remove(RulesConfiguration.normalize(path));
        } else {
            this.prefixMatches.put(RulesConfiguration.normalize(path), uri);
        }
    }

    private static String normalize(String path) {
        return new Path(path).makeRelative().removeTrailingSeparator().toString();
    }

    private Collection<ISourceMappingRule> buildRules() {
        LinkedList<ISourceMappingRule> rules = new LinkedList<ISourceMappingRule>();
        if (this.executable != null) {
            String workingDir;
            String filename = this.executable.getFilename();
            if (filename != null && filename.trim().length() > 0) {
                rules.add(new RelativeMapping(new Path(filename).removeLastSegments(1)));
            }
            if ((workingDir = this.executable.getWorkingDir()) != null && workingDir.trim().length() > 0) {
                rules.add(new RelativeMapping((IPath)new Path(workingDir)));
            }
        }
        rules.add(new LocalFileMapping());
        rules.addAll(Arrays.asList(this.getRules()));
        return rules;
    }

    public ISourceMappingRule[] getRules() {
        ISourceMappingRule[] rules = new ISourceMappingRule[this.prefixMatches.size()];
        int i = 0;
        for (Map.Entry<String, URI> entry : this.prefixMatches.entrySet()) {
            rules[i++] = new PrefixMapping((IPath)new Path(entry.getKey()), entry.getValue());
        }
        return rules;
    }

    @Override
    public ISourceMappingRule.SourceMapping map(URI sourceFile) {
        ISourceMappingRule.SourceMapping candidate = null;
        for (ISourceMappingRule rule : this.buildRules()) {
            ISourceMappingRule.SourceMapping resolved = rule.map(sourceFile);
            if (resolved == null || candidate != null && candidate.weight >= resolved.weight) continue;
            candidate = resolved;
        }
        return candidate;
    }

    public void revert() {
        this.prefixMatches.clear();
        this.prefixMatches.putAll(RulesConfiguration.loadMap(this.location));
    }

    public void save() {
        try {
            XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(this.location)));
            encoder.writeObject(this.prefixMatches);
            encoder.close();
        }
        catch (FileNotFoundException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "com.nvidia.viper", null, (Throwable)e), 3);
        }
    }

    public void setPrefixMatches(Map<String, URI> prefixMatches) {
        this.prefixMatches = prefixMatches;
    }

    public void removeMapping(URI uri) {
        String key = RulesConfiguration.normalize(uri.getPath());
        this.prefixMatches.put(key, null);
    }
}

