/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.FileUtils;
import com.nvidia.viper.Viper;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.jni.CUptiResult;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.Expert;
import com.nvidia.viper.model.ExpertSystem;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.SessionFilter;
import com.nvidia.viper.ui.CpuTreeView;
import com.nvidia.viper.ui.ImportNvprofMultiProcessPage;
import com.nvidia.viper.ui.ImportNvprofOptionsPage;
import com.nvidia.viper.ui.ImportNvprofSingleProcessPage;
import com.nvidia.viper.ui.LargeDataMessageDialog;
import com.nvidia.viper.ui.SessionEditor;
import com.nvidia.viper.ui.SessionEditorInput;
import com.nvidia.viper.ui.ViperMessageDialog;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ImportNvprofWizard
extends Wizard
implements IImportWizard {
    private ImportNvprofSingleProcessPage singleProcessPage;
    private ImportNvprofOptionsPage primaryPage;
    private ImportNvprofMultiProcessPage multiProcessPage;

    public ImportNvprofWizard() {
        this.setWindowTitle(ViperMessages.ImportNvprof_Wizard_Title);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        try {
            PdmImportRunnable runnable = null;
            if (this.primaryPage.importSingleProcess()) {
                String timelineFilename = this.singleProcessPage.getTimelineFilePath();
                String[] filenames = this.singleProcessPage.getAdditionalFilePaths();
                TreeMap<String, List<SessionFilter>> filenameSessionFilterMap = new TreeMap<String, List<SessionFilter>>();
                if (filenames != null) {
                    String[] stringArray = filenames;
                    int n = filenames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String filename = stringArray[n2];
                        List<SessionFilter> sessionFilters = this.singleProcessPage.getScopes(filename);
                        if (sessionFilters != null) {
                            filenameSessionFilterMap.put(filename, sessionFilters);
                        }
                        ++n2;
                    }
                }
                Session session = this.singleProcessPage.getUpdatedSession();
                runnable = new SingleProcessPdmRunnable(timelineFilename, filenames, filenameSessionFilterMap, session);
            } else {
                Session session = this.multiProcessPage.getUpdatedSession();
                runnable = new MultiProcessPdmRunnable(this.multiProcessPage.getFilePaths(), session);
            }
            this.getContainer().run(true, true, (IRunnableWithProgress)runnable);
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                ViperException ex = this.checkForIncompatible(e);
                ViperExceptionHandler.handle(ViperMessages.ImportNvprof_Fail_Title, ViperMessages.ImportNvprof_Fail_Message, ex);
            }
        }
        catch (OutOfMemoryError e) {
            ViperExceptionHandler.logError("Out of memory error", e);
            LargeDataMessageDialog.show();
        }
        Viper.setWelcomePageStandby(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        return true;
    }

    private ViperException checkForIncompatible(Exception e) {
        Throwable cause = e.getCause();
        while (cause != null) {
            if (cause instanceof CuptiException && CUptiResult.CUPTI_ERROR_NOT_COMPATIBLE.equals((Object)((CuptiException)cause).getCuptiResult())) {
                return new ViperException("\n" + ViperMessages.ImportNvprof_Incompatible_Message);
            }
            cause = cause.getCause();
        }
        return (ViperException)e;
    }

    public static void importNvprofFilesIntoSession(String[] filenames, Map<String, List<SessionFilter>> filenameSessionFilterMap, Session session) {
        if (session != null && filenames != null) {
            boolean completeProfileData = true;
            boolean completeMerge = true;
            String[] stringArray = filenames;
            int n = filenames.length;
            int n2 = 0;
            while (n2 < n) {
                block20: {
                    String filename = stringArray[n2];
                    File file = new File(filename);
                    ProfileDataModel pdm = null;
                    try {
                        pdm = new ProfileDataModel();
                        try {
                            pdm.read(file);
                        }
                        catch (ViperException e) {
                            completeProfileData = false;
                            Throwable cause = e.getCause();
                            if (!(cause instanceof CuptiException) || !CUptiResult.CUPTI_ERROR_NOT_COMPATIBLE.equals((Object)((CuptiException)cause).getCuptiResult())) break block20;
                        }
                        if (filenameSessionFilterMap != null) {
                            List<SessionFilter> scopes = filenameSessionFilterMap.get(filename);
                            if (scopes != null && !scopes.isEmpty()) {
                                pdm.setScopes(scopes);
                                for (SessionFilter scope : scopes) {
                                    if (session.mergeTimelines(pdm, scope, true, true, true)) continue;
                                    completeMerge = false;
                                }
                            } else if (!session.mergeTimelines(pdm, null, true, true, true)) {
                                completeMerge = false;
                            }
                        } else if (!session.mergeTimelines(pdm, null, true, true, true)) {
                            completeMerge = false;
                        }
                        {
                        }
                    }
                    catch (ViperException e) {
                        if (!(e instanceof ViperException)) {
                            e = new ViperException(e);
                        }
                        ViperExceptionHandler.handle(ViperMessages.ImportMultipleNvprof_Fail_Title, ViperMessages.ImportMultipleNvprof_Fail_Message, e);
                    }
                    catch (OutOfMemoryError e) {
                        ViperExceptionHandler.logError("Out of memory error", e);
                        LargeDataMessageDialog.show();
                    }
                }
                ++n2;
            }
            if (!completeProfileData || !completeMerge) {
                String msg = "";
                if (!completeProfileData) {
                    msg = String.valueOf(msg) + "One or more sets of profile data are incomplete.\n";
                }
                if (!completeMerge) {
                    msg = String.valueOf(msg) + "Some collected events or source-level results could not be associated with the session timeline.";
                }
                if (!msg.isEmpty()) {
                    final String message = msg;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ViperMessageDialog.openWarning(PlatformUI.getWorkbench().getDisplay().getActiveShell(), "Import " + Viper.COMMANDLINE_PRODUCT_NAME + " data files", message);
                        }
                    });
                }
            }
        }
    }

    public static Session importNvprofTimelineFiles(String[] filePaths, Session session) throws ViperException {
        if (filePaths != null && filePaths.length > 0) {
            ProfileDataModel[] pdms = new ProfileDataModel[filePaths.length];
            try {
                File[] files = new File[filePaths.length];
                int i = 0;
                while (i < filePaths.length) {
                    File file;
                    files[i] = file = new File(filePaths[i]);
                    ProfileDataModel pdm = new ProfileDataModel();
                    pdm.read(file);
                    pdms[i] = pdm;
                    ++i;
                }
                if (!FileUtils.canLoad(files)) {
                    LargeDataMessageDialog.show();
                    throw new ViperException("LoadPdmCancel");
                }
                if (pdms.length == 1) {
                    session.setTimelines(pdms[0]);
                } else {
                    session.setTimelinesMultiplePdms(pdms);
                }
                Display.getDefault().syncExec((Runnable)new UpdateSessionRunnable(session, new File(filePaths[0]).getName()));
            }
            catch (Exception e) {
                if (e instanceof ViperException) {
                    throw (ViperException)e;
                }
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            return session;
        }
        return null;
    }

    public static Session importNvprofTimelineFile(String filename, Session session) throws Exception {
        try {
            session = ImportNvprofWizard.importNvprofTimelineFileThrowsException(filename, session);
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw e;
            }
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        return session;
    }

    public static Session importNvprofTimelineFileThrowsException(String filename, Session session) throws ViperException, CoreException {
        if (filename != null) {
            File file = new File(filename);
            ProfileDataModel pdm = null;
            try {
                pdm = new ProfileDataModel();
                pdm.read(file);
                session.setTimelines(pdm);
                Display.getDefault().syncExec((Runnable)new UpdateSessionRunnable(session, file.getName()));
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ViperException e) {
                if (e.getMessage().compareTo("\nCUPTI_ERROR_PDM_EMPTY") != 0) {
                    throw e;
                }
                Display.getDefault().syncExec((Runnable)new UpdateSessionRunnable(session, file.getName()));
            }
            return session;
        }
        return null;
    }

    private static void updateSessionSettings(Session session, String sessionName) throws PartInitException {
        SessionEditor editor;
        IWorkbenchPage activePage;
        IWorkbenchWindow workbenchWindow;
        session.setExpert(new Expert());
        session.setAnalysis(new Analysis());
        session.setExpertSystem(new ExpertSystem(session));
        session.setName(sessionName);
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (activePage = workbenchWindow.getActivePage()) != null && (editor = (SessionEditor)activePage.openEditor((IEditorInput)new SessionEditorInput(session), "com.nvidia.viper.sessioneditor")) != null) {
            editor.scaleToFit();
            editor.setDirty(true);
            session.setDirty(true);
        }
    }

    public void addPages() {
        this.primaryPage = new ImportNvprofOptionsPage("Import " + Viper.COMMANDLINE_PRODUCT_NAME);
        this.addPage((IWizardPage)this.primaryPage);
        this.singleProcessPage = new ImportNvprofSingleProcessPage("Import " + Viper.COMMANDLINE_PRODUCT_NAME);
        this.addPage((IWizardPage)this.singleProcessPage);
        this.multiProcessPage = new ImportNvprofMultiProcessPage("Import " + Viper.COMMANDLINE_PRODUCT_NAME);
        this.addPage((IWizardPage)this.multiProcessPage);
        super.addPages();
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        if (currentPage instanceof ImportNvprofOptionsPage) {
            if (this.primaryPage.importSingleProcess()) {
                return this.singleProcessPage;
            }
            return this.multiProcessPage;
        }
        return super.getNextPage(currentPage);
    }

    public boolean canFinish() {
        if (this.primaryPage.isCurrent()) {
            return false;
        }
        if (this.singleProcessPage.isCurrent() && this.singleProcessPage.isPageComplete()) {
            return true;
        }
        if (this.multiProcessPage.isCurrent() && this.multiProcessPage.isPageComplete()) {
            return true;
        }
        return super.canFinish();
    }

    private class MultiProcessPdmRunnable
    extends PdmImportRunnable {
        public MultiProcessPdmRunnable(String[] filenames, Session session) {
            super(filenames, session);
        }

        @Override
        protected void performImport() throws Exception {
            ImportNvprofWizard.importNvprofTimelineFiles(this.filenames, this.session);
        }
    }

    private abstract class PdmImportRunnable
    implements IRunnableWithProgress {
        protected String[] filenames;
        protected Session session;

        public PdmImportRunnable(String[] filenames, Session session) {
            this.filenames = filenames;
            this.session = session;
        }

        protected abstract void performImport() throws Exception;

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("Import " + Viper.COMMANDLINE_PRODUCT_NAME + " profile data...", -1);
            Thread thread = new Thread("LoadPdm"){

                @Override
                public void run() {
                    try {
                        PdmImportRunnable.this.performImport();
                    }
                    catch (Exception e) {
                        ViperException ex;
                        if (e instanceof ViperException && !(ex = (ViperException)e).getMessage().endsWith("LoadPdmCancel")) {
                            ex = ImportNvprofWizard.this.checkForIncompatible(ex);
                            ViperExceptionHandler.handle(ViperMessages.ImportNvprof_Fail_Title, ViperMessages.ImportNvprof_Fail_Message, ex);
                        }
                    }
                    catch (OutOfMemoryError e) {
                        ViperExceptionHandler.logError("Out of memory error", e);
                        LargeDataMessageDialog.show();
                    }
                }
            };
            thread.start();
            while (thread != null && thread.isAlive()) {
                if (!monitor.isCanceled()) continue;
                thread.interrupt();
            }
        }
    }

    private class SingleProcessPdmRunnable
    extends PdmImportRunnable {
        private String timelineFile;
        private Map<String, List<SessionFilter>> filenameSessionFilterMap;

        SingleProcessPdmRunnable(String timelineFile, String[] otherFiles, Map<String, List<SessionFilter>> filenameSessionFilterMap, Session session) {
            super(otherFiles, session);
            this.timelineFile = timelineFile;
            this.filenameSessionFilterMap = filenameSessionFilterMap;
        }

        @Override
        protected void performImport() throws Exception {
            this.session = ImportNvprofWizard.importNvprofTimelineFile(this.timelineFile, this.session);
            if (this.session != null) {
                this.session.importNvprofCpuData(this.timelineFile);
                CpuTreeView.newSession = this.session;
                ImportNvprofWizard.importNvprofFilesIntoSession(this.filenames, this.filenameSessionFilterMap, this.session);
            }
        }
    }

    private static class UpdateSessionRunnable
    implements Runnable {
        private Session session;
        private String name;

        public UpdateSessionRunnable(Session session, String name) {
            this.session = session;
            this.name = name;
        }

        @Override
        public void run() {
            try {
                ImportNvprofWizard.updateSessionSettings(this.session, this.name);
            }
            catch (PartInitException partInitException) {
                ViperExceptionHandler.handle(ViperMessages.ImportMultipleNvprof_Fail_Title, ViperMessages.ImportMultipleNvprof_Fail_Message, null);
            }
        }
    }
}

