/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.value.IValue;
import com.nvidia.viper.value.ValuePercent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;

public class AnalysisResultLocalMemoryOverhead
extends AnalysisResult {
    private TimelineIntervalKernel kernel;
    private double overhead;
    private static NumberFormat percentFormatter = NumberFormat.getPercentInstance();

    static {
        percentFormatter.setMaximumFractionDigits(0);
        percentFormatter.setGroupingUsed(false);
    }

    public AnalysisResultLocalMemoryOverhead(TimelineIntervalKernel kernel, double overhead) {
        super(AnalysisDescriptor.KERNEL_MEMORY_LMEM_OVERHEAD);
        this.kernel = kernel;
        this.overhead = overhead;
    }

    public TimelineIntervalKernel getKernel() {
        return this.kernel;
    }

    public IValue getOverheadValue() {
        return new ValuePercent(this.overhead);
    }

    public String getOverheadValueDescription() {
        return "Percentage of memory traffic caused by local memory accesses";
    }

    @Override
    public String getDescription(ResultOutput otpt) {
        String desc = super.getDescription(otpt);
        desc = desc.replace("%OVERHEAD%", percentFormatter.format(this.overhead / 100.0));
        return desc;
    }

    @Override
    public List<TimelineIntervalPair> getAssociatedIntervals() {
        ArrayList<TimelineIntervalPair> pairs = new ArrayList<TimelineIntervalPair>(1);
        TimelineIntervalPair pair = new TimelineIntervalPair(this.kernel.getPrimaryTimeline(), this.kernel);
        pairs.add(pair);
        return pairs;
    }

    @Override
    public Action getMoreAction() {
        return new Action(){

            public void run() {
                ViperHelp.displayHelp(ViperHelp.REGISTER_PRESSURE);
            }
        };
    }
}

