#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
# Request base classes

from albatross.common import *

class FileField:

    def __init__(self, field):
        self.filename = field.filename
        self.file = field.file
        self.type = field.type

    def __repr__(self):
        return 'FileField(%s, %s, %s)' % (self.filename, self.file, self.type)

class RequestFields:
    def __init__(self, fields):
        # Fields is a cgi.FieldStorage() work-alike
        self.__fields = fields

    def has_field(self, name):
        return name in self.__fields

    def field_value(self, name):
        field = self.__fields[name]
        if isinstance(field, list):
            if isinstance(field[0], str):
                # For checkboxes, this is a vec of strings in mod_python 2
                return field
            # But a vec of utils.FieldStorage objects in mod_python 3
            return [f.value for f in field]
        elif isinstance(field, str):
            return field                # Weird - blame mod_apache?
        else:
            return field.value

    def field_file(self, name):
        field = self.__fields[name]
        if isinstance(field, list):
            return [FileField(f) for f in field]
        if field.type.startswith('multipart'):
            return [FileField(f) for f in field.value]
        else:
            return [FileField(field)]

    def field_names(self):
        return self.__fields.keys()

class RequestStatus:
    def __init__(self):
        self.__status = HTTP_OK

    def set_status(self, status):
        self.__status = status

    def status(self):
        return self.__status

class RequestBase(RequestFields, RequestStatus):
    def __init__(self, fields):
        RequestFields.__init__(self, fields)
        RequestStatus.__init__(self)

    def return_code(self):
        pass
