# Copyright 2019 Fortinet, Inc.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Ansible.  If not, see <https://www.gnu.org/licenses/>.

# Make coding more python3-ish
from __future__ import (absolute_import, division, print_function)
__metaclass__ = type

import os
import json
import pytest
from mock import ANY
from ansible.module_utils.network.fortios.fortios import FortiOSHandler

try:
    from ansible.modules.network.fortios import fortios_system_global
except ImportError:
    pytest.skip("Could not load required modules for testing", allow_module_level=True)


@pytest.fixture(autouse=True)
def connection_mock(mocker):
    connection_class_mock = mocker.patch('ansible.modules.network.fortios.fortios_system_global.Connection')
    return connection_class_mock


fos_instance = FortiOSHandler(connection_mock)


def test_system_global_creation(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'success', 'http_method': 'POST', 'http_status': 200}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'system_global': {
            'admin_concurrent': 'enable',
            'admin_console_timeout': '4',
            'admin_https_pki_required': 'enable',
            'admin_lockout_duration': '6',
            'admin_lockout_threshold': '7',
            'admin_login_max': '8',
            'admin_maintainer': 'enable',
            'admin_port': '10',
            'admin_restrict_local': 'enable',
            'admin_scp': 'enable',
            'admin_server_cert': 'test_value_13',
            'admin_sport': '14',
            'admin_ssh_grace_time': '15',
            'admin_ssh_password': 'enable',
            'admin_ssh_port': '17',
            'admin_ssh_v1': 'enable',
            'admin_telnet_port': '19',
            'admintimeout': '20',
            'alias': 'test_value_21',
            'allow_traffic_redirect': 'enable',
            'anti_replay': 'disable',
            'arp_max_entry': '24',
            'asymroute': 'enable',
            'auth_cert': 'test_value_26',
            'auth_http_port': '27',
            'auth_https_port': '28',
            'auth_keepalive': 'enable',
            'auth_session_limit': 'block-new',
            'auto_auth_extension_device': 'enable',
            'av_affinity': 'test_value_32',
            'av_failopen': 'pass',
            'av_failopen_session': 'enable',
            'batch_cmdb': 'enable',
            'block_session_timer': '36',
            'br_fdb_max_entry': '37',
            'cert_chain_max': '38',
            'cfg_revert_timeout': '39',
            'cfg_save': 'automatic',
            'check_protocol_header': 'loose',
            'check_reset_range': 'strict',
            'cli_audit_log': 'enable',
            'clt_cert_req': 'enable',
            'compliance_check': 'enable',
            'compliance_check_time': 'test_value_46',
            'cpu_use_threshold': '47',
            'csr_ca_attribute': 'enable',
            'daily_restart': 'enable',
            'device_identification_active_scan_delay': '50',
            'device_idle_timeout': '51',
            'dh_params': '1024',
            'dnsproxy_worker_count': '53',
            'dst': 'enable',
            'endpoint_control_fds_access': 'enable',
            'endpoint_control_portal_port': '56',
            'failtime': '57',
            'fds_statistics': 'enable',
            'fds_statistics_period': '59',
            'fgd_alert_subscription': 'advisory',
            'fortiextender': 'enable',
            'fortiextender_data_port': '62',
            'fortiextender_vlan_mode': 'enable',
            'fortiservice_port': '64',
            'gui_certificates': 'enable',
            'gui_custom_language': 'enable',
            'gui_date_format': 'yyyy/MM/dd',
            'gui_device_latitude': 'test_value_68',
            'gui_device_longitude': 'test_value_69',
            'gui_display_hostname': 'enable',
            'gui_ipv6': 'enable',
            'gui_lines_per_page': '72',
            'gui_theme': 'green',
            'gui_wireless_opensecurity': 'enable',
            'honor_df': 'enable',
            'hostname': 'myhostname76',
            'igmp_state_limit': '77',
            'interval': '78',
            'ip_src_port_range': 'test_value_79',
            'ips_affinity': 'test_value_80',
            'ipsec_asic_offload': 'enable',
            'ipsec_hmac_offload': 'enable',
            'ipsec_soft_dec_async': 'enable',
            'ipv6_accept_dad': '84',
            'ipv6_allow_anycast_probe': 'enable',
            'language': 'english',
            'ldapconntimeout': '87',
            'lldp_transmission': 'enable',
            'log_ssl_connection': 'enable',
            'log_uuid': 'disable',
            'login_timestamp': 'enable',
            'long_vdom_name': 'enable',
            'management_vdom': 'test_value_93',
            'max_dlpstat_memory': '94',
            'max_route_cache_size': '95',
            'mc_ttl_notchange': 'enable',
            'memory_use_threshold_extreme': '97',
            'memory_use_threshold_green': '98',
            'memory_use_threshold_red': '99',
            'miglog_affinity': 'test_value_100',
            'miglogd_children': '101',
            'multi_factor_authentication': 'optional',
            'multicast_forward': 'enable',
            'ndp_max_entry': '104',
            'per_user_bwl': 'enable',
            'policy_auth_concurrent': '106',
            'post_login_banner': 'disable',
            'pre_login_banner': 'enable',
            'private_data_encryption': 'disable',
            'proxy_auth_lifetime': 'enable',
            'proxy_auth_lifetime_timeout': '111',
            'proxy_auth_timeout': '112',
            'proxy_cipher_hardware_acceleration': 'disable',
            'proxy_kxp_hardware_acceleration': 'disable',
            'proxy_re_authentication_mode': 'session',
            'proxy_worker_count': '116',
            'radius_port': '117',
            'reboot_upon_config_restore': 'enable',
            'refresh': '119',
            'remoteauthtimeout': '120',
            'reset_sessionless_tcp': 'enable',
            'restart_time': 'test_value_122',
            'revision_backup_on_logout': 'enable',
            'revision_image_auto_backup': 'enable',
            'scanunit_count': '125',
            'security_rating_result_submission': 'enable',
            'security_rating_run_on_schedule': 'enable',
            'send_pmtu_icmp': 'enable',
            'snat_route_change': 'enable',
            'special_file_23_support': 'disable',
            'ssd_trim_date': '131',
            'ssd_trim_freq': 'never',
            'ssd_trim_hour': '133',
            'ssd_trim_min': '134',
            'ssd_trim_weekday': 'sunday',
            'ssh_cbc_cipher': 'enable',
            'ssh_hmac_md5': 'enable',
            'ssh_kex_sha1': 'enable',
            'ssl_min_proto_version': 'SSLv3',
            'ssl_static_key_ciphers': 'enable',
            'sslvpn_cipher_hardware_acceleration': 'enable',
            'sslvpn_kxp_hardware_acceleration': 'enable',
            'sslvpn_max_worker_count': '143',
            'sslvpn_plugin_version_check': 'enable',
            'strict_dirty_session_check': 'enable',
            'strong_crypto': 'enable',
            'switch_controller': 'disable',
            'switch_controller_reserved_network': 'test_value_148',
            'sys_perf_log_interval': '149',
            'tcp_halfclose_timer': '150',
            'tcp_halfopen_timer': '151',
            'tcp_option': 'enable',
            'tcp_timewait_timer': '153',
            'tftp': 'enable',
            'timezone': '01',
            'tp_mc_skip_policy': 'enable',
            'traffic_priority': 'tos',
            'traffic_priority_level': 'low',
            'two_factor_email_expiry': '159',
            'two_factor_fac_expiry': '160',
            'two_factor_ftk_expiry': '161',
            'two_factor_ftm_expiry': '162',
            'two_factor_sms_expiry': '163',
            'udp_idle_timer': '164',
            'user_server_cert': 'test_value_165',
            'vdom_admin': 'enable',
            'vip_arp_range': 'unlimited',
            'virtual_server_count': '168',
            'virtual_server_hardware_acceleration': 'disable',
            'wad_affinity': 'test_value_170',
            'wad_csvc_cs_count': '171',
            'wad_csvc_db_count': '172',
            'wad_source_affinity': 'disable',
            'wad_worker_count': '174',
            'wifi_ca_certificate': 'test_value_175',
            'wifi_certificate': 'test_value_176',
            'wimax_4g_usb': 'enable',
            'wireless_controller': 'enable',
            'wireless_controller_port': '179'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_system_global.fortios_system(input_data, fos_instance)

    expected_data = {
        'admin-concurrent': 'enable',
        'admin-console-timeout': '4',
        'admin-https-pki-required': 'enable',
        'admin-lockout-duration': '6',
        'admin-lockout-threshold': '7',
        'admin-login-max': '8',
        'admin-maintainer': 'enable',
        'admin-port': '10',
        'admin-restrict-local': 'enable',
        'admin-scp': 'enable',
        'admin-server-cert': 'test_value_13',
        'admin-sport': '14',
        'admin-ssh-grace-time': '15',
        'admin-ssh-password': 'enable',
        'admin-ssh-port': '17',
        'admin-ssh-v1': 'enable',
        'admin-telnet-port': '19',
        'admintimeout': '20',
        'alias': 'test_value_21',
        'allow-traffic-redirect': 'enable',
        'anti-replay': 'disable',
        'arp-max-entry': '24',
        'asymroute': 'enable',
        'auth-cert': 'test_value_26',
        'auth-http-port': '27',
        'auth-https-port': '28',
        'auth-keepalive': 'enable',
        'auth-session-limit': 'block-new',
        'auto-auth-extension-device': 'enable',
        'av-affinity': 'test_value_32',
        'av-failopen': 'pass',
        'av-failopen-session': 'enable',
        'batch-cmdb': 'enable',
        'block-session-timer': '36',
        'br-fdb-max-entry': '37',
        'cert-chain-max': '38',
        'cfg-revert-timeout': '39',
        'cfg-save': 'automatic',
        'check-protocol-header': 'loose',
        'check-reset-range': 'strict',
        'cli-audit-log': 'enable',
        'clt-cert-req': 'enable',
        'compliance-check': 'enable',
        'compliance-check-time': 'test_value_46',
        'cpu-use-threshold': '47',
        'csr-ca-attribute': 'enable',
        'daily-restart': 'enable',
        'device-identification-active-scan-delay': '50',
        'device-idle-timeout': '51',
        'dh-params': '1024',
        'dnsproxy-worker-count': '53',
        'dst': 'enable',
        'endpoint-control-fds-access': 'enable',
        'endpoint-control-portal-port': '56',
        'failtime': '57',
        'fds-statistics': 'enable',
        'fds-statistics-period': '59',
        'fgd-alert-subscription': 'advisory',
        'fortiextender': 'enable',
        'fortiextender-data-port': '62',
        'fortiextender-vlan-mode': 'enable',
        'fortiservice-port': '64',
        'gui-certificates': 'enable',
        'gui-custom-language': 'enable',
        'gui-date-format': 'yyyy/MM/dd',
        'gui-device-latitude': 'test_value_68',
        'gui-device-longitude': 'test_value_69',
        'gui-display-hostname': 'enable',
        'gui-ipv6': 'enable',
        'gui-lines-per-page': '72',
        'gui-theme': 'green',
        'gui-wireless-opensecurity': 'enable',
        'honor-df': 'enable',
        'hostname': 'myhostname76',
        'igmp-state-limit': '77',
        'interval': '78',
        'ip-src-port-range': 'test_value_79',
        'ips-affinity': 'test_value_80',
        'ipsec-asic-offload': 'enable',
        'ipsec-hmac-offload': 'enable',
        'ipsec-soft-dec-async': 'enable',
        'ipv6-accept-dad': '84',
        'ipv6-allow-anycast-probe': 'enable',
        'language': 'english',
        'ldapconntimeout': '87',
        'lldp-transmission': 'enable',
        'log-ssl-connection': 'enable',
        'log-uuid': 'disable',
        'login-timestamp': 'enable',
        'long-vdom-name': 'enable',
        'management-vdom': 'test_value_93',
        'max-dlpstat-memory': '94',
        'max-route-cache-size': '95',
        'mc-ttl-notchange': 'enable',
        'memory-use-threshold-extreme': '97',
        'memory-use-threshold-green': '98',
        'memory-use-threshold-red': '99',
        'miglog-affinity': 'test_value_100',
        'miglogd-children': '101',
        'multi-factor-authentication': 'optional',
        'multicast-forward': 'enable',
        'ndp-max-entry': '104',
        'per-user-bwl': 'enable',
        'policy-auth-concurrent': '106',
        'post-login-banner': 'disable',
        'pre-login-banner': 'enable',
        'private-data-encryption': 'disable',
        'proxy-auth-lifetime': 'enable',
        'proxy-auth-lifetime-timeout': '111',
        'proxy-auth-timeout': '112',
        'proxy-cipher-hardware-acceleration': 'disable',
        'proxy-kxp-hardware-acceleration': 'disable',
        'proxy-re-authentication-mode': 'session',
        'proxy-worker-count': '116',
        'radius-port': '117',
        'reboot-upon-config-restore': 'enable',
        'refresh': '119',
        'remoteauthtimeout': '120',
        'reset-sessionless-tcp': 'enable',
        'restart-time': 'test_value_122',
        'revision-backup-on-logout': 'enable',
        'revision-image-auto-backup': 'enable',
        'scanunit-count': '125',
        'security-rating-result-submission': 'enable',
        'security-rating-run-on-schedule': 'enable',
        'send-pmtu-icmp': 'enable',
        'snat-route-change': 'enable',
        'special-file-23-support': 'disable',
        'ssd-trim-date': '131',
        'ssd-trim-freq': 'never',
        'ssd-trim-hour': '133',
        'ssd-trim-min': '134',
        'ssd-trim-weekday': 'sunday',
        'ssh-cbc-cipher': 'enable',
        'ssh-hmac-md5': 'enable',
        'ssh-kex-sha1': 'enable',
        'ssl-min-proto-version': 'SSLv3',
        'ssl-static-key-ciphers': 'enable',
        'sslvpn-cipher-hardware-acceleration': 'enable',
        'sslvpn-kxp-hardware-acceleration': 'enable',
        'sslvpn-max-worker-count': '143',
        'sslvpn-plugin-version-check': 'enable',
        'strict-dirty-session-check': 'enable',
        'strong-crypto': 'enable',
        'switch-controller': 'disable',
        'switch-controller-reserved-network': 'test_value_148',
        'sys-perf-log-interval': '149',
        'tcp-halfclose-timer': '150',
        'tcp-halfopen-timer': '151',
        'tcp-option': 'enable',
        'tcp-timewait-timer': '153',
        'tftp': 'enable',
                'timezone': '01',
                'tp-mc-skip-policy': 'enable',
                'traffic-priority': 'tos',
                'traffic-priority-level': 'low',
                'two-factor-email-expiry': '159',
                'two-factor-fac-expiry': '160',
                'two-factor-ftk-expiry': '161',
                'two-factor-ftm-expiry': '162',
                'two-factor-sms-expiry': '163',
                'udp-idle-timer': '164',
                'user-server-cert': 'test_value_165',
                'vdom-admin': 'enable',
                'vip-arp-range': 'unlimited',
                'virtual-server-count': '168',
                'virtual-server-hardware-acceleration': 'disable',
                'wad-affinity': 'test_value_170',
                'wad-csvc-cs-count': '171',
                'wad-csvc-db-count': '172',
                'wad-source-affinity': 'disable',
                'wad-worker-count': '174',
                'wifi-ca-certificate': 'test_value_175',
                'wifi-certificate': 'test_value_176',
                'wimax-4g-usb': 'enable',
                'wireless-controller': 'enable',
                'wireless-controller-port': '179'
    }

    set_method_mock.assert_called_with('system', 'global', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert changed
    assert response['status'] == 'success'
    assert response['http_status'] == 200


def test_system_global_creation_fails(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'error', 'http_method': 'POST', 'http_status': 500}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'system_global': {
            'admin_concurrent': 'enable',
            'admin_console_timeout': '4',
            'admin_https_pki_required': 'enable',
            'admin_lockout_duration': '6',
            'admin_lockout_threshold': '7',
            'admin_login_max': '8',
            'admin_maintainer': 'enable',
            'admin_port': '10',
            'admin_restrict_local': 'enable',
            'admin_scp': 'enable',
            'admin_server_cert': 'test_value_13',
            'admin_sport': '14',
            'admin_ssh_grace_time': '15',
            'admin_ssh_password': 'enable',
            'admin_ssh_port': '17',
            'admin_ssh_v1': 'enable',
            'admin_telnet_port': '19',
            'admintimeout': '20',
            'alias': 'test_value_21',
            'allow_traffic_redirect': 'enable',
            'anti_replay': 'disable',
            'arp_max_entry': '24',
            'asymroute': 'enable',
            'auth_cert': 'test_value_26',
            'auth_http_port': '27',
            'auth_https_port': '28',
            'auth_keepalive': 'enable',
            'auth_session_limit': 'block-new',
            'auto_auth_extension_device': 'enable',
            'av_affinity': 'test_value_32',
            'av_failopen': 'pass',
            'av_failopen_session': 'enable',
            'batch_cmdb': 'enable',
            'block_session_timer': '36',
            'br_fdb_max_entry': '37',
            'cert_chain_max': '38',
            'cfg_revert_timeout': '39',
            'cfg_save': 'automatic',
            'check_protocol_header': 'loose',
            'check_reset_range': 'strict',
            'cli_audit_log': 'enable',
            'clt_cert_req': 'enable',
            'compliance_check': 'enable',
            'compliance_check_time': 'test_value_46',
            'cpu_use_threshold': '47',
            'csr_ca_attribute': 'enable',
            'daily_restart': 'enable',
            'device_identification_active_scan_delay': '50',
            'device_idle_timeout': '51',
            'dh_params': '1024',
            'dnsproxy_worker_count': '53',
            'dst': 'enable',
            'endpoint_control_fds_access': 'enable',
            'endpoint_control_portal_port': '56',
            'failtime': '57',
            'fds_statistics': 'enable',
            'fds_statistics_period': '59',
            'fgd_alert_subscription': 'advisory',
            'fortiextender': 'enable',
            'fortiextender_data_port': '62',
            'fortiextender_vlan_mode': 'enable',
            'fortiservice_port': '64',
            'gui_certificates': 'enable',
            'gui_custom_language': 'enable',
            'gui_date_format': 'yyyy/MM/dd',
            'gui_device_latitude': 'test_value_68',
            'gui_device_longitude': 'test_value_69',
            'gui_display_hostname': 'enable',
            'gui_ipv6': 'enable',
            'gui_lines_per_page': '72',
            'gui_theme': 'green',
            'gui_wireless_opensecurity': 'enable',
            'honor_df': 'enable',
            'hostname': 'myhostname76',
            'igmp_state_limit': '77',
            'interval': '78',
            'ip_src_port_range': 'test_value_79',
            'ips_affinity': 'test_value_80',
            'ipsec_asic_offload': 'enable',
            'ipsec_hmac_offload': 'enable',
            'ipsec_soft_dec_async': 'enable',
            'ipv6_accept_dad': '84',
            'ipv6_allow_anycast_probe': 'enable',
            'language': 'english',
            'ldapconntimeout': '87',
            'lldp_transmission': 'enable',
            'log_ssl_connection': 'enable',
            'log_uuid': 'disable',
            'login_timestamp': 'enable',
            'long_vdom_name': 'enable',
            'management_vdom': 'test_value_93',
            'max_dlpstat_memory': '94',
            'max_route_cache_size': '95',
            'mc_ttl_notchange': 'enable',
            'memory_use_threshold_extreme': '97',
            'memory_use_threshold_green': '98',
            'memory_use_threshold_red': '99',
            'miglog_affinity': 'test_value_100',
            'miglogd_children': '101',
            'multi_factor_authentication': 'optional',
            'multicast_forward': 'enable',
            'ndp_max_entry': '104',
            'per_user_bwl': 'enable',
            'policy_auth_concurrent': '106',
            'post_login_banner': 'disable',
            'pre_login_banner': 'enable',
            'private_data_encryption': 'disable',
            'proxy_auth_lifetime': 'enable',
            'proxy_auth_lifetime_timeout': '111',
            'proxy_auth_timeout': '112',
            'proxy_cipher_hardware_acceleration': 'disable',
            'proxy_kxp_hardware_acceleration': 'disable',
            'proxy_re_authentication_mode': 'session',
            'proxy_worker_count': '116',
            'radius_port': '117',
            'reboot_upon_config_restore': 'enable',
            'refresh': '119',
            'remoteauthtimeout': '120',
            'reset_sessionless_tcp': 'enable',
            'restart_time': 'test_value_122',
            'revision_backup_on_logout': 'enable',
            'revision_image_auto_backup': 'enable',
            'scanunit_count': '125',
            'security_rating_result_submission': 'enable',
            'security_rating_run_on_schedule': 'enable',
            'send_pmtu_icmp': 'enable',
            'snat_route_change': 'enable',
            'special_file_23_support': 'disable',
            'ssd_trim_date': '131',
            'ssd_trim_freq': 'never',
            'ssd_trim_hour': '133',
            'ssd_trim_min': '134',
            'ssd_trim_weekday': 'sunday',
            'ssh_cbc_cipher': 'enable',
            'ssh_hmac_md5': 'enable',
            'ssh_kex_sha1': 'enable',
            'ssl_min_proto_version': 'SSLv3',
            'ssl_static_key_ciphers': 'enable',
            'sslvpn_cipher_hardware_acceleration': 'enable',
            'sslvpn_kxp_hardware_acceleration': 'enable',
            'sslvpn_max_worker_count': '143',
            'sslvpn_plugin_version_check': 'enable',
            'strict_dirty_session_check': 'enable',
            'strong_crypto': 'enable',
            'switch_controller': 'disable',
            'switch_controller_reserved_network': 'test_value_148',
            'sys_perf_log_interval': '149',
            'tcp_halfclose_timer': '150',
            'tcp_halfopen_timer': '151',
            'tcp_option': 'enable',
            'tcp_timewait_timer': '153',
            'tftp': 'enable',
            'timezone': '01',
            'tp_mc_skip_policy': 'enable',
            'traffic_priority': 'tos',
            'traffic_priority_level': 'low',
            'two_factor_email_expiry': '159',
            'two_factor_fac_expiry': '160',
            'two_factor_ftk_expiry': '161',
            'two_factor_ftm_expiry': '162',
            'two_factor_sms_expiry': '163',
            'udp_idle_timer': '164',
            'user_server_cert': 'test_value_165',
            'vdom_admin': 'enable',
            'vip_arp_range': 'unlimited',
            'virtual_server_count': '168',
            'virtual_server_hardware_acceleration': 'disable',
            'wad_affinity': 'test_value_170',
            'wad_csvc_cs_count': '171',
            'wad_csvc_db_count': '172',
            'wad_source_affinity': 'disable',
            'wad_worker_count': '174',
            'wifi_ca_certificate': 'test_value_175',
            'wifi_certificate': 'test_value_176',
            'wimax_4g_usb': 'enable',
            'wireless_controller': 'enable',
            'wireless_controller_port': '179'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_system_global.fortios_system(input_data, fos_instance)

    expected_data = {
        'admin-concurrent': 'enable',
        'admin-console-timeout': '4',
        'admin-https-pki-required': 'enable',
        'admin-lockout-duration': '6',
        'admin-lockout-threshold': '7',
        'admin-login-max': '8',
        'admin-maintainer': 'enable',
        'admin-port': '10',
        'admin-restrict-local': 'enable',
        'admin-scp': 'enable',
        'admin-server-cert': 'test_value_13',
        'admin-sport': '14',
        'admin-ssh-grace-time': '15',
        'admin-ssh-password': 'enable',
        'admin-ssh-port': '17',
        'admin-ssh-v1': 'enable',
        'admin-telnet-port': '19',
        'admintimeout': '20',
        'alias': 'test_value_21',
        'allow-traffic-redirect': 'enable',
        'anti-replay': 'disable',
        'arp-max-entry': '24',
        'asymroute': 'enable',
        'auth-cert': 'test_value_26',
        'auth-http-port': '27',
        'auth-https-port': '28',
        'auth-keepalive': 'enable',
        'auth-session-limit': 'block-new',
        'auto-auth-extension-device': 'enable',
        'av-affinity': 'test_value_32',
        'av-failopen': 'pass',
        'av-failopen-session': 'enable',
        'batch-cmdb': 'enable',
        'block-session-timer': '36',
        'br-fdb-max-entry': '37',
        'cert-chain-max': '38',
        'cfg-revert-timeout': '39',
        'cfg-save': 'automatic',
        'check-protocol-header': 'loose',
        'check-reset-range': 'strict',
        'cli-audit-log': 'enable',
        'clt-cert-req': 'enable',
        'compliance-check': 'enable',
        'compliance-check-time': 'test_value_46',
        'cpu-use-threshold': '47',
        'csr-ca-attribute': 'enable',
        'daily-restart': 'enable',
        'device-identification-active-scan-delay': '50',
        'device-idle-timeout': '51',
        'dh-params': '1024',
        'dnsproxy-worker-count': '53',
        'dst': 'enable',
        'endpoint-control-fds-access': 'enable',
        'endpoint-control-portal-port': '56',
        'failtime': '57',
        'fds-statistics': 'enable',
        'fds-statistics-period': '59',
        'fgd-alert-subscription': 'advisory',
        'fortiextender': 'enable',
        'fortiextender-data-port': '62',
        'fortiextender-vlan-mode': 'enable',
        'fortiservice-port': '64',
        'gui-certificates': 'enable',
        'gui-custom-language': 'enable',
        'gui-date-format': 'yyyy/MM/dd',
        'gui-device-latitude': 'test_value_68',
        'gui-device-longitude': 'test_value_69',
        'gui-display-hostname': 'enable',
        'gui-ipv6': 'enable',
        'gui-lines-per-page': '72',
        'gui-theme': 'green',
        'gui-wireless-opensecurity': 'enable',
        'honor-df': 'enable',
        'hostname': 'myhostname76',
        'igmp-state-limit': '77',
        'interval': '78',
        'ip-src-port-range': 'test_value_79',
        'ips-affinity': 'test_value_80',
        'ipsec-asic-offload': 'enable',
        'ipsec-hmac-offload': 'enable',
        'ipsec-soft-dec-async': 'enable',
        'ipv6-accept-dad': '84',
        'ipv6-allow-anycast-probe': 'enable',
        'language': 'english',
        'ldapconntimeout': '87',
        'lldp-transmission': 'enable',
        'log-ssl-connection': 'enable',
        'log-uuid': 'disable',
        'login-timestamp': 'enable',
        'long-vdom-name': 'enable',
        'management-vdom': 'test_value_93',
        'max-dlpstat-memory': '94',
        'max-route-cache-size': '95',
        'mc-ttl-notchange': 'enable',
        'memory-use-threshold-extreme': '97',
        'memory-use-threshold-green': '98',
        'memory-use-threshold-red': '99',
        'miglog-affinity': 'test_value_100',
        'miglogd-children': '101',
        'multi-factor-authentication': 'optional',
        'multicast-forward': 'enable',
        'ndp-max-entry': '104',
        'per-user-bwl': 'enable',
        'policy-auth-concurrent': '106',
        'post-login-banner': 'disable',
        'pre-login-banner': 'enable',
        'private-data-encryption': 'disable',
        'proxy-auth-lifetime': 'enable',
        'proxy-auth-lifetime-timeout': '111',
        'proxy-auth-timeout': '112',
        'proxy-cipher-hardware-acceleration': 'disable',
        'proxy-kxp-hardware-acceleration': 'disable',
        'proxy-re-authentication-mode': 'session',
        'proxy-worker-count': '116',
        'radius-port': '117',
        'reboot-upon-config-restore': 'enable',
        'refresh': '119',
        'remoteauthtimeout': '120',
        'reset-sessionless-tcp': 'enable',
        'restart-time': 'test_value_122',
        'revision-backup-on-logout': 'enable',
        'revision-image-auto-backup': 'enable',
        'scanunit-count': '125',
        'security-rating-result-submission': 'enable',
        'security-rating-run-on-schedule': 'enable',
        'send-pmtu-icmp': 'enable',
        'snat-route-change': 'enable',
        'special-file-23-support': 'disable',
        'ssd-trim-date': '131',
        'ssd-trim-freq': 'never',
        'ssd-trim-hour': '133',
        'ssd-trim-min': '134',
        'ssd-trim-weekday': 'sunday',
        'ssh-cbc-cipher': 'enable',
        'ssh-hmac-md5': 'enable',
        'ssh-kex-sha1': 'enable',
        'ssl-min-proto-version': 'SSLv3',
        'ssl-static-key-ciphers': 'enable',
        'sslvpn-cipher-hardware-acceleration': 'enable',
        'sslvpn-kxp-hardware-acceleration': 'enable',
        'sslvpn-max-worker-count': '143',
        'sslvpn-plugin-version-check': 'enable',
        'strict-dirty-session-check': 'enable',
        'strong-crypto': 'enable',
        'switch-controller': 'disable',
        'switch-controller-reserved-network': 'test_value_148',
        'sys-perf-log-interval': '149',
        'tcp-halfclose-timer': '150',
        'tcp-halfopen-timer': '151',
        'tcp-option': 'enable',
        'tcp-timewait-timer': '153',
        'tftp': 'enable',
                'timezone': '01',
                'tp-mc-skip-policy': 'enable',
                'traffic-priority': 'tos',
                'traffic-priority-level': 'low',
                'two-factor-email-expiry': '159',
                'two-factor-fac-expiry': '160',
                'two-factor-ftk-expiry': '161',
                'two-factor-ftm-expiry': '162',
                'two-factor-sms-expiry': '163',
                'udp-idle-timer': '164',
                'user-server-cert': 'test_value_165',
                'vdom-admin': 'enable',
                'vip-arp-range': 'unlimited',
                'virtual-server-count': '168',
                'virtual-server-hardware-acceleration': 'disable',
                'wad-affinity': 'test_value_170',
                'wad-csvc-cs-count': '171',
                'wad-csvc-db-count': '172',
                'wad-source-affinity': 'disable',
                'wad-worker-count': '174',
                'wifi-ca-certificate': 'test_value_175',
                'wifi-certificate': 'test_value_176',
                'wimax-4g-usb': 'enable',
                'wireless-controller': 'enable',
                'wireless-controller-port': '179'
    }

    set_method_mock.assert_called_with('system', 'global', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert is_error
    assert not changed
    assert response['status'] == 'error'
    assert response['http_status'] == 500


def test_system_global_idempotent(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'error', 'http_method': 'DELETE', 'http_status': 404}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'system_global': {
            'admin_concurrent': 'enable',
            'admin_console_timeout': '4',
            'admin_https_pki_required': 'enable',
            'admin_lockout_duration': '6',
            'admin_lockout_threshold': '7',
            'admin_login_max': '8',
            'admin_maintainer': 'enable',
            'admin_port': '10',
            'admin_restrict_local': 'enable',
            'admin_scp': 'enable',
            'admin_server_cert': 'test_value_13',
            'admin_sport': '14',
            'admin_ssh_grace_time': '15',
            'admin_ssh_password': 'enable',
            'admin_ssh_port': '17',
            'admin_ssh_v1': 'enable',
            'admin_telnet_port': '19',
            'admintimeout': '20',
            'alias': 'test_value_21',
            'allow_traffic_redirect': 'enable',
            'anti_replay': 'disable',
            'arp_max_entry': '24',
            'asymroute': 'enable',
            'auth_cert': 'test_value_26',
            'auth_http_port': '27',
            'auth_https_port': '28',
            'auth_keepalive': 'enable',
            'auth_session_limit': 'block-new',
            'auto_auth_extension_device': 'enable',
            'av_affinity': 'test_value_32',
            'av_failopen': 'pass',
            'av_failopen_session': 'enable',
            'batch_cmdb': 'enable',
            'block_session_timer': '36',
            'br_fdb_max_entry': '37',
            'cert_chain_max': '38',
            'cfg_revert_timeout': '39',
            'cfg_save': 'automatic',
            'check_protocol_header': 'loose',
            'check_reset_range': 'strict',
            'cli_audit_log': 'enable',
            'clt_cert_req': 'enable',
            'compliance_check': 'enable',
            'compliance_check_time': 'test_value_46',
            'cpu_use_threshold': '47',
            'csr_ca_attribute': 'enable',
            'daily_restart': 'enable',
            'device_identification_active_scan_delay': '50',
            'device_idle_timeout': '51',
            'dh_params': '1024',
            'dnsproxy_worker_count': '53',
            'dst': 'enable',
            'endpoint_control_fds_access': 'enable',
            'endpoint_control_portal_port': '56',
            'failtime': '57',
            'fds_statistics': 'enable',
            'fds_statistics_period': '59',
            'fgd_alert_subscription': 'advisory',
            'fortiextender': 'enable',
            'fortiextender_data_port': '62',
            'fortiextender_vlan_mode': 'enable',
            'fortiservice_port': '64',
            'gui_certificates': 'enable',
            'gui_custom_language': 'enable',
            'gui_date_format': 'yyyy/MM/dd',
            'gui_device_latitude': 'test_value_68',
            'gui_device_longitude': 'test_value_69',
            'gui_display_hostname': 'enable',
            'gui_ipv6': 'enable',
            'gui_lines_per_page': '72',
            'gui_theme': 'green',
            'gui_wireless_opensecurity': 'enable',
            'honor_df': 'enable',
            'hostname': 'myhostname76',
            'igmp_state_limit': '77',
            'interval': '78',
            'ip_src_port_range': 'test_value_79',
            'ips_affinity': 'test_value_80',
            'ipsec_asic_offload': 'enable',
            'ipsec_hmac_offload': 'enable',
            'ipsec_soft_dec_async': 'enable',
            'ipv6_accept_dad': '84',
            'ipv6_allow_anycast_probe': 'enable',
            'language': 'english',
            'ldapconntimeout': '87',
            'lldp_transmission': 'enable',
            'log_ssl_connection': 'enable',
            'log_uuid': 'disable',
            'login_timestamp': 'enable',
            'long_vdom_name': 'enable',
            'management_vdom': 'test_value_93',
            'max_dlpstat_memory': '94',
            'max_route_cache_size': '95',
            'mc_ttl_notchange': 'enable',
            'memory_use_threshold_extreme': '97',
            'memory_use_threshold_green': '98',
            'memory_use_threshold_red': '99',
            'miglog_affinity': 'test_value_100',
            'miglogd_children': '101',
            'multi_factor_authentication': 'optional',
            'multicast_forward': 'enable',
            'ndp_max_entry': '104',
            'per_user_bwl': 'enable',
            'policy_auth_concurrent': '106',
            'post_login_banner': 'disable',
            'pre_login_banner': 'enable',
            'private_data_encryption': 'disable',
            'proxy_auth_lifetime': 'enable',
            'proxy_auth_lifetime_timeout': '111',
            'proxy_auth_timeout': '112',
            'proxy_cipher_hardware_acceleration': 'disable',
            'proxy_kxp_hardware_acceleration': 'disable',
            'proxy_re_authentication_mode': 'session',
            'proxy_worker_count': '116',
            'radius_port': '117',
            'reboot_upon_config_restore': 'enable',
            'refresh': '119',
            'remoteauthtimeout': '120',
            'reset_sessionless_tcp': 'enable',
            'restart_time': 'test_value_122',
            'revision_backup_on_logout': 'enable',
            'revision_image_auto_backup': 'enable',
            'scanunit_count': '125',
            'security_rating_result_submission': 'enable',
            'security_rating_run_on_schedule': 'enable',
            'send_pmtu_icmp': 'enable',
            'snat_route_change': 'enable',
            'special_file_23_support': 'disable',
            'ssd_trim_date': '131',
            'ssd_trim_freq': 'never',
            'ssd_trim_hour': '133',
            'ssd_trim_min': '134',
            'ssd_trim_weekday': 'sunday',
            'ssh_cbc_cipher': 'enable',
            'ssh_hmac_md5': 'enable',
            'ssh_kex_sha1': 'enable',
            'ssl_min_proto_version': 'SSLv3',
            'ssl_static_key_ciphers': 'enable',
            'sslvpn_cipher_hardware_acceleration': 'enable',
            'sslvpn_kxp_hardware_acceleration': 'enable',
            'sslvpn_max_worker_count': '143',
            'sslvpn_plugin_version_check': 'enable',
            'strict_dirty_session_check': 'enable',
            'strong_crypto': 'enable',
            'switch_controller': 'disable',
            'switch_controller_reserved_network': 'test_value_148',
            'sys_perf_log_interval': '149',
            'tcp_halfclose_timer': '150',
            'tcp_halfopen_timer': '151',
            'tcp_option': 'enable',
            'tcp_timewait_timer': '153',
            'tftp': 'enable',
            'timezone': '01',
            'tp_mc_skip_policy': 'enable',
            'traffic_priority': 'tos',
            'traffic_priority_level': 'low',
            'two_factor_email_expiry': '159',
            'two_factor_fac_expiry': '160',
            'two_factor_ftk_expiry': '161',
            'two_factor_ftm_expiry': '162',
            'two_factor_sms_expiry': '163',
            'udp_idle_timer': '164',
            'user_server_cert': 'test_value_165',
            'vdom_admin': 'enable',
            'vip_arp_range': 'unlimited',
            'virtual_server_count': '168',
            'virtual_server_hardware_acceleration': 'disable',
            'wad_affinity': 'test_value_170',
            'wad_csvc_cs_count': '171',
            'wad_csvc_db_count': '172',
            'wad_source_affinity': 'disable',
            'wad_worker_count': '174',
            'wifi_ca_certificate': 'test_value_175',
            'wifi_certificate': 'test_value_176',
            'wimax_4g_usb': 'enable',
            'wireless_controller': 'enable',
            'wireless_controller_port': '179'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_system_global.fortios_system(input_data, fos_instance)

    expected_data = {
        'admin-concurrent': 'enable',
        'admin-console-timeout': '4',
        'admin-https-pki-required': 'enable',
        'admin-lockout-duration': '6',
        'admin-lockout-threshold': '7',
        'admin-login-max': '8',
        'admin-maintainer': 'enable',
        'admin-port': '10',
        'admin-restrict-local': 'enable',
        'admin-scp': 'enable',
        'admin-server-cert': 'test_value_13',
        'admin-sport': '14',
        'admin-ssh-grace-time': '15',
        'admin-ssh-password': 'enable',
        'admin-ssh-port': '17',
        'admin-ssh-v1': 'enable',
        'admin-telnet-port': '19',
        'admintimeout': '20',
        'alias': 'test_value_21',
        'allow-traffic-redirect': 'enable',
        'anti-replay': 'disable',
        'arp-max-entry': '24',
        'asymroute': 'enable',
        'auth-cert': 'test_value_26',
        'auth-http-port': '27',
        'auth-https-port': '28',
        'auth-keepalive': 'enable',
        'auth-session-limit': 'block-new',
        'auto-auth-extension-device': 'enable',
        'av-affinity': 'test_value_32',
        'av-failopen': 'pass',
        'av-failopen-session': 'enable',
        'batch-cmdb': 'enable',
        'block-session-timer': '36',
        'br-fdb-max-entry': '37',
        'cert-chain-max': '38',
        'cfg-revert-timeout': '39',
        'cfg-save': 'automatic',
        'check-protocol-header': 'loose',
        'check-reset-range': 'strict',
        'cli-audit-log': 'enable',
        'clt-cert-req': 'enable',
        'compliance-check': 'enable',
        'compliance-check-time': 'test_value_46',
        'cpu-use-threshold': '47',
        'csr-ca-attribute': 'enable',
        'daily-restart': 'enable',
        'device-identification-active-scan-delay': '50',
        'device-idle-timeout': '51',
        'dh-params': '1024',
        'dnsproxy-worker-count': '53',
        'dst': 'enable',
        'endpoint-control-fds-access': 'enable',
        'endpoint-control-portal-port': '56',
        'failtime': '57',
        'fds-statistics': 'enable',
        'fds-statistics-period': '59',
        'fgd-alert-subscription': 'advisory',
        'fortiextender': 'enable',
        'fortiextender-data-port': '62',
        'fortiextender-vlan-mode': 'enable',
        'fortiservice-port': '64',
        'gui-certificates': 'enable',
        'gui-custom-language': 'enable',
        'gui-date-format': 'yyyy/MM/dd',
        'gui-device-latitude': 'test_value_68',
        'gui-device-longitude': 'test_value_69',
        'gui-display-hostname': 'enable',
        'gui-ipv6': 'enable',
        'gui-lines-per-page': '72',
        'gui-theme': 'green',
        'gui-wireless-opensecurity': 'enable',
        'honor-df': 'enable',
        'hostname': 'myhostname76',
        'igmp-state-limit': '77',
        'interval': '78',
        'ip-src-port-range': 'test_value_79',
        'ips-affinity': 'test_value_80',
        'ipsec-asic-offload': 'enable',
        'ipsec-hmac-offload': 'enable',
        'ipsec-soft-dec-async': 'enable',
        'ipv6-accept-dad': '84',
        'ipv6-allow-anycast-probe': 'enable',
        'language': 'english',
        'ldapconntimeout': '87',
        'lldp-transmission': 'enable',
        'log-ssl-connection': 'enable',
        'log-uuid': 'disable',
        'login-timestamp': 'enable',
        'long-vdom-name': 'enable',
        'management-vdom': 'test_value_93',
        'max-dlpstat-memory': '94',
        'max-route-cache-size': '95',
        'mc-ttl-notchange': 'enable',
        'memory-use-threshold-extreme': '97',
        'memory-use-threshold-green': '98',
        'memory-use-threshold-red': '99',
        'miglog-affinity': 'test_value_100',
        'miglogd-children': '101',
        'multi-factor-authentication': 'optional',
        'multicast-forward': 'enable',
        'ndp-max-entry': '104',
        'per-user-bwl': 'enable',
        'policy-auth-concurrent': '106',
        'post-login-banner': 'disable',
        'pre-login-banner': 'enable',
        'private-data-encryption': 'disable',
        'proxy-auth-lifetime': 'enable',
        'proxy-auth-lifetime-timeout': '111',
        'proxy-auth-timeout': '112',
        'proxy-cipher-hardware-acceleration': 'disable',
        'proxy-kxp-hardware-acceleration': 'disable',
        'proxy-re-authentication-mode': 'session',
        'proxy-worker-count': '116',
        'radius-port': '117',
        'reboot-upon-config-restore': 'enable',
        'refresh': '119',
        'remoteauthtimeout': '120',
        'reset-sessionless-tcp': 'enable',
        'restart-time': 'test_value_122',
        'revision-backup-on-logout': 'enable',
        'revision-image-auto-backup': 'enable',
        'scanunit-count': '125',
        'security-rating-result-submission': 'enable',
        'security-rating-run-on-schedule': 'enable',
        'send-pmtu-icmp': 'enable',
        'snat-route-change': 'enable',
        'special-file-23-support': 'disable',
        'ssd-trim-date': '131',
        'ssd-trim-freq': 'never',
        'ssd-trim-hour': '133',
        'ssd-trim-min': '134',
        'ssd-trim-weekday': 'sunday',
        'ssh-cbc-cipher': 'enable',
        'ssh-hmac-md5': 'enable',
        'ssh-kex-sha1': 'enable',
        'ssl-min-proto-version': 'SSLv3',
        'ssl-static-key-ciphers': 'enable',
        'sslvpn-cipher-hardware-acceleration': 'enable',
        'sslvpn-kxp-hardware-acceleration': 'enable',
        'sslvpn-max-worker-count': '143',
        'sslvpn-plugin-version-check': 'enable',
        'strict-dirty-session-check': 'enable',
        'strong-crypto': 'enable',
        'switch-controller': 'disable',
        'switch-controller-reserved-network': 'test_value_148',
        'sys-perf-log-interval': '149',
        'tcp-halfclose-timer': '150',
        'tcp-halfopen-timer': '151',
        'tcp-option': 'enable',
        'tcp-timewait-timer': '153',
        'tftp': 'enable',
                'timezone': '01',
                'tp-mc-skip-policy': 'enable',
                'traffic-priority': 'tos',
                'traffic-priority-level': 'low',
                'two-factor-email-expiry': '159',
                'two-factor-fac-expiry': '160',
                'two-factor-ftk-expiry': '161',
                'two-factor-ftm-expiry': '162',
                'two-factor-sms-expiry': '163',
                'udp-idle-timer': '164',
                'user-server-cert': 'test_value_165',
                'vdom-admin': 'enable',
                'vip-arp-range': 'unlimited',
                'virtual-server-count': '168',
                'virtual-server-hardware-acceleration': 'disable',
                'wad-affinity': 'test_value_170',
                'wad-csvc-cs-count': '171',
                'wad-csvc-db-count': '172',
                'wad-source-affinity': 'disable',
                'wad-worker-count': '174',
                'wifi-ca-certificate': 'test_value_175',
                'wifi-certificate': 'test_value_176',
                'wimax-4g-usb': 'enable',
                'wireless-controller': 'enable',
                'wireless-controller-port': '179'
    }

    set_method_mock.assert_called_with('system', 'global', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert not changed
    assert response['status'] == 'error'
    assert response['http_status'] == 404


def test_system_global_filter_foreign_attributes(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'success', 'http_method': 'POST', 'http_status': 200}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'system_global': {
            'random_attribute_not_valid': 'tag',
            'admin_concurrent': 'enable',
            'admin_console_timeout': '4',
            'admin_https_pki_required': 'enable',
            'admin_lockout_duration': '6',
            'admin_lockout_threshold': '7',
            'admin_login_max': '8',
            'admin_maintainer': 'enable',
            'admin_port': '10',
            'admin_restrict_local': 'enable',
            'admin_scp': 'enable',
            'admin_server_cert': 'test_value_13',
            'admin_sport': '14',
            'admin_ssh_grace_time': '15',
            'admin_ssh_password': 'enable',
            'admin_ssh_port': '17',
            'admin_ssh_v1': 'enable',
            'admin_telnet_port': '19',
            'admintimeout': '20',
            'alias': 'test_value_21',
            'allow_traffic_redirect': 'enable',
            'anti_replay': 'disable',
            'arp_max_entry': '24',
            'asymroute': 'enable',
            'auth_cert': 'test_value_26',
            'auth_http_port': '27',
            'auth_https_port': '28',
            'auth_keepalive': 'enable',
            'auth_session_limit': 'block-new',
            'auto_auth_extension_device': 'enable',
            'av_affinity': 'test_value_32',
            'av_failopen': 'pass',
            'av_failopen_session': 'enable',
            'batch_cmdb': 'enable',
            'block_session_timer': '36',
            'br_fdb_max_entry': '37',
            'cert_chain_max': '38',
            'cfg_revert_timeout': '39',
            'cfg_save': 'automatic',
            'check_protocol_header': 'loose',
            'check_reset_range': 'strict',
            'cli_audit_log': 'enable',
            'clt_cert_req': 'enable',
            'compliance_check': 'enable',
            'compliance_check_time': 'test_value_46',
            'cpu_use_threshold': '47',
            'csr_ca_attribute': 'enable',
            'daily_restart': 'enable',
            'device_identification_active_scan_delay': '50',
            'device_idle_timeout': '51',
            'dh_params': '1024',
            'dnsproxy_worker_count': '53',
            'dst': 'enable',
            'endpoint_control_fds_access': 'enable',
            'endpoint_control_portal_port': '56',
            'failtime': '57',
            'fds_statistics': 'enable',
            'fds_statistics_period': '59',
            'fgd_alert_subscription': 'advisory',
            'fortiextender': 'enable',
            'fortiextender_data_port': '62',
            'fortiextender_vlan_mode': 'enable',
            'fortiservice_port': '64',
            'gui_certificates': 'enable',
            'gui_custom_language': 'enable',
            'gui_date_format': 'yyyy/MM/dd',
            'gui_device_latitude': 'test_value_68',
            'gui_device_longitude': 'test_value_69',
            'gui_display_hostname': 'enable',
            'gui_ipv6': 'enable',
            'gui_lines_per_page': '72',
            'gui_theme': 'green',
            'gui_wireless_opensecurity': 'enable',
            'honor_df': 'enable',
            'hostname': 'myhostname76',
            'igmp_state_limit': '77',
            'interval': '78',
            'ip_src_port_range': 'test_value_79',
            'ips_affinity': 'test_value_80',
            'ipsec_asic_offload': 'enable',
            'ipsec_hmac_offload': 'enable',
            'ipsec_soft_dec_async': 'enable',
            'ipv6_accept_dad': '84',
            'ipv6_allow_anycast_probe': 'enable',
            'language': 'english',
            'ldapconntimeout': '87',
            'lldp_transmission': 'enable',
            'log_ssl_connection': 'enable',
            'log_uuid': 'disable',
            'login_timestamp': 'enable',
            'long_vdom_name': 'enable',
            'management_vdom': 'test_value_93',
            'max_dlpstat_memory': '94',
            'max_route_cache_size': '95',
            'mc_ttl_notchange': 'enable',
            'memory_use_threshold_extreme': '97',
            'memory_use_threshold_green': '98',
            'memory_use_threshold_red': '99',
            'miglog_affinity': 'test_value_100',
            'miglogd_children': '101',
            'multi_factor_authentication': 'optional',
            'multicast_forward': 'enable',
            'ndp_max_entry': '104',
            'per_user_bwl': 'enable',
            'policy_auth_concurrent': '106',
            'post_login_banner': 'disable',
            'pre_login_banner': 'enable',
            'private_data_encryption': 'disable',
            'proxy_auth_lifetime': 'enable',
            'proxy_auth_lifetime_timeout': '111',
            'proxy_auth_timeout': '112',
            'proxy_cipher_hardware_acceleration': 'disable',
            'proxy_kxp_hardware_acceleration': 'disable',
            'proxy_re_authentication_mode': 'session',
            'proxy_worker_count': '116',
            'radius_port': '117',
            'reboot_upon_config_restore': 'enable',
            'refresh': '119',
            'remoteauthtimeout': '120',
            'reset_sessionless_tcp': 'enable',
            'restart_time': 'test_value_122',
            'revision_backup_on_logout': 'enable',
            'revision_image_auto_backup': 'enable',
            'scanunit_count': '125',
            'security_rating_result_submission': 'enable',
            'security_rating_run_on_schedule': 'enable',
            'send_pmtu_icmp': 'enable',
            'snat_route_change': 'enable',
            'special_file_23_support': 'disable',
            'ssd_trim_date': '131',
            'ssd_trim_freq': 'never',
            'ssd_trim_hour': '133',
            'ssd_trim_min': '134',
            'ssd_trim_weekday': 'sunday',
            'ssh_cbc_cipher': 'enable',
            'ssh_hmac_md5': 'enable',
            'ssh_kex_sha1': 'enable',
            'ssl_min_proto_version': 'SSLv3',
            'ssl_static_key_ciphers': 'enable',
            'sslvpn_cipher_hardware_acceleration': 'enable',
            'sslvpn_kxp_hardware_acceleration': 'enable',
            'sslvpn_max_worker_count': '143',
            'sslvpn_plugin_version_check': 'enable',
            'strict_dirty_session_check': 'enable',
            'strong_crypto': 'enable',
            'switch_controller': 'disable',
            'switch_controller_reserved_network': 'test_value_148',
            'sys_perf_log_interval': '149',
            'tcp_halfclose_timer': '150',
            'tcp_halfopen_timer': '151',
            'tcp_option': 'enable',
            'tcp_timewait_timer': '153',
            'tftp': 'enable',
            'timezone': '01',
            'tp_mc_skip_policy': 'enable',
            'traffic_priority': 'tos',
            'traffic_priority_level': 'low',
            'two_factor_email_expiry': '159',
            'two_factor_fac_expiry': '160',
            'two_factor_ftk_expiry': '161',
            'two_factor_ftm_expiry': '162',
            'two_factor_sms_expiry': '163',
            'udp_idle_timer': '164',
            'user_server_cert': 'test_value_165',
            'vdom_admin': 'enable',
            'vip_arp_range': 'unlimited',
            'virtual_server_count': '168',
            'virtual_server_hardware_acceleration': 'disable',
            'wad_affinity': 'test_value_170',
            'wad_csvc_cs_count': '171',
            'wad_csvc_db_count': '172',
            'wad_source_affinity': 'disable',
            'wad_worker_count': '174',
            'wifi_ca_certificate': 'test_value_175',
            'wifi_certificate': 'test_value_176',
            'wimax_4g_usb': 'enable',
            'wireless_controller': 'enable',
            'wireless_controller_port': '179'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_system_global.fortios_system(input_data, fos_instance)

    expected_data = {
        'admin-concurrent': 'enable',
        'admin-console-timeout': '4',
        'admin-https-pki-required': 'enable',
        'admin-lockout-duration': '6',
        'admin-lockout-threshold': '7',
        'admin-login-max': '8',
        'admin-maintainer': 'enable',
        'admin-port': '10',
        'admin-restrict-local': 'enable',
        'admin-scp': 'enable',
        'admin-server-cert': 'test_value_13',
        'admin-sport': '14',
        'admin-ssh-grace-time': '15',
        'admin-ssh-password': 'enable',
        'admin-ssh-port': '17',
        'admin-ssh-v1': 'enable',
        'admin-telnet-port': '19',
        'admintimeout': '20',
        'alias': 'test_value_21',
        'allow-traffic-redirect': 'enable',
        'anti-replay': 'disable',
        'arp-max-entry': '24',
        'asymroute': 'enable',
        'auth-cert': 'test_value_26',
        'auth-http-port': '27',
        'auth-https-port': '28',
        'auth-keepalive': 'enable',
        'auth-session-limit': 'block-new',
        'auto-auth-extension-device': 'enable',
        'av-affinity': 'test_value_32',
        'av-failopen': 'pass',
        'av-failopen-session': 'enable',
        'batch-cmdb': 'enable',
        'block-session-timer': '36',
        'br-fdb-max-entry': '37',
        'cert-chain-max': '38',
        'cfg-revert-timeout': '39',
        'cfg-save': 'automatic',
        'check-protocol-header': 'loose',
        'check-reset-range': 'strict',
        'cli-audit-log': 'enable',
        'clt-cert-req': 'enable',
        'compliance-check': 'enable',
        'compliance-check-time': 'test_value_46',
        'cpu-use-threshold': '47',
        'csr-ca-attribute': 'enable',
        'daily-restart': 'enable',
        'device-identification-active-scan-delay': '50',
        'device-idle-timeout': '51',
        'dh-params': '1024',
        'dnsproxy-worker-count': '53',
        'dst': 'enable',
        'endpoint-control-fds-access': 'enable',
        'endpoint-control-portal-port': '56',
        'failtime': '57',
        'fds-statistics': 'enable',
        'fds-statistics-period': '59',
        'fgd-alert-subscription': 'advisory',
        'fortiextender': 'enable',
        'fortiextender-data-port': '62',
        'fortiextender-vlan-mode': 'enable',
        'fortiservice-port': '64',
        'gui-certificates': 'enable',
        'gui-custom-language': 'enable',
        'gui-date-format': 'yyyy/MM/dd',
        'gui-device-latitude': 'test_value_68',
        'gui-device-longitude': 'test_value_69',
        'gui-display-hostname': 'enable',
        'gui-ipv6': 'enable',
        'gui-lines-per-page': '72',
        'gui-theme': 'green',
        'gui-wireless-opensecurity': 'enable',
        'honor-df': 'enable',
        'hostname': 'myhostname76',
        'igmp-state-limit': '77',
        'interval': '78',
        'ip-src-port-range': 'test_value_79',
        'ips-affinity': 'test_value_80',
        'ipsec-asic-offload': 'enable',
        'ipsec-hmac-offload': 'enable',
        'ipsec-soft-dec-async': 'enable',
        'ipv6-accept-dad': '84',
        'ipv6-allow-anycast-probe': 'enable',
        'language': 'english',
        'ldapconntimeout': '87',
        'lldp-transmission': 'enable',
        'log-ssl-connection': 'enable',
        'log-uuid': 'disable',
        'login-timestamp': 'enable',
        'long-vdom-name': 'enable',
        'management-vdom': 'test_value_93',
        'max-dlpstat-memory': '94',
        'max-route-cache-size': '95',
        'mc-ttl-notchange': 'enable',
        'memory-use-threshold-extreme': '97',
        'memory-use-threshold-green': '98',
        'memory-use-threshold-red': '99',
        'miglog-affinity': 'test_value_100',
        'miglogd-children': '101',
        'multi-factor-authentication': 'optional',
        'multicast-forward': 'enable',
        'ndp-max-entry': '104',
        'per-user-bwl': 'enable',
        'policy-auth-concurrent': '106',
        'post-login-banner': 'disable',
        'pre-login-banner': 'enable',
        'private-data-encryption': 'disable',
        'proxy-auth-lifetime': 'enable',
        'proxy-auth-lifetime-timeout': '111',
        'proxy-auth-timeout': '112',
        'proxy-cipher-hardware-acceleration': 'disable',
        'proxy-kxp-hardware-acceleration': 'disable',
        'proxy-re-authentication-mode': 'session',
        'proxy-worker-count': '116',
        'radius-port': '117',
        'reboot-upon-config-restore': 'enable',
        'refresh': '119',
        'remoteauthtimeout': '120',
        'reset-sessionless-tcp': 'enable',
        'restart-time': 'test_value_122',
        'revision-backup-on-logout': 'enable',
        'revision-image-auto-backup': 'enable',
        'scanunit-count': '125',
        'security-rating-result-submission': 'enable',
        'security-rating-run-on-schedule': 'enable',
        'send-pmtu-icmp': 'enable',
        'snat-route-change': 'enable',
        'special-file-23-support': 'disable',
        'ssd-trim-date': '131',
        'ssd-trim-freq': 'never',
        'ssd-trim-hour': '133',
        'ssd-trim-min': '134',
        'ssd-trim-weekday': 'sunday',
        'ssh-cbc-cipher': 'enable',
        'ssh-hmac-md5': 'enable',
        'ssh-kex-sha1': 'enable',
        'ssl-min-proto-version': 'SSLv3',
        'ssl-static-key-ciphers': 'enable',
        'sslvpn-cipher-hardware-acceleration': 'enable',
        'sslvpn-kxp-hardware-acceleration': 'enable',
        'sslvpn-max-worker-count': '143',
        'sslvpn-plugin-version-check': 'enable',
        'strict-dirty-session-check': 'enable',
        'strong-crypto': 'enable',
        'switch-controller': 'disable',
        'switch-controller-reserved-network': 'test_value_148',
        'sys-perf-log-interval': '149',
        'tcp-halfclose-timer': '150',
        'tcp-halfopen-timer': '151',
        'tcp-option': 'enable',
        'tcp-timewait-timer': '153',
        'tftp': 'enable',
                'timezone': '01',
                'tp-mc-skip-policy': 'enable',
                'traffic-priority': 'tos',
                'traffic-priority-level': 'low',
                'two-factor-email-expiry': '159',
                'two-factor-fac-expiry': '160',
                'two-factor-ftk-expiry': '161',
                'two-factor-ftm-expiry': '162',
                'two-factor-sms-expiry': '163',
                'udp-idle-timer': '164',
                'user-server-cert': 'test_value_165',
                'vdom-admin': 'enable',
                'vip-arp-range': 'unlimited',
                'virtual-server-count': '168',
                'virtual-server-hardware-acceleration': 'disable',
                'wad-affinity': 'test_value_170',
                'wad-csvc-cs-count': '171',
                'wad-csvc-db-count': '172',
                'wad-source-affinity': 'disable',
                'wad-worker-count': '174',
                'wifi-ca-certificate': 'test_value_175',
                'wifi-certificate': 'test_value_176',
                'wimax-4g-usb': 'enable',
                'wireless-controller': 'enable',
                'wireless-controller-port': '179'
    }

    set_method_mock.assert_called_with('system', 'global', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert changed
    assert response['status'] == 'success'
    assert response['http_status'] == 200
