/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 21:05:08 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.awt.datatransfer.Clipboard;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.ExternalProgram;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.components.LogViewer;
import uk.ac.sanger.artemis.components.filetree.RemoteFileNode;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class ExternalProgram_ESTest extends ExternalProgram_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("", "MSpnC/", 5);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("WRITTEN ");
      FeatureVector featureVector0 = entry0.checkForOverlappingCDSs();
      LogViewer logViewer0 = new LogViewer();
      // Undeclared exception!
      try { 
        externalProgram0.run(featureVector0, logViewer0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unknown program type
         //
         verifyException("uk.ac.sanger.artemis.ExternalProgram", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("", "", (-11));
      MockFile mockFile0 = new MockFile("", "");
      externalProgram0.makeDirectory(mockFile0);
      assertEquals((-11), externalProgram0.getType());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("% '1blg", ":)^c|C[*dl@i/O;", 0);
      externalProgram0.setFileNumber((File) null, 0, (RemoteFileNode) null);
      assertEquals(0, externalProgram0.getType());
      assertEquals("% '1blg", externalProgram0.getName());
      assertEquals(":)^c|C[*dl@i/O;", externalProgram0.getProgramOptions());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram(": ", "22)hxh|Y4W>p2", 21);
      MockFile mockFile0 = new MockFile("22)hxh|Y4W>p2", ": ");
      externalProgram0.setFileNumber(mockFile0, 201L, (RemoteFileNode) null);
      assertEquals(": ", externalProgram0.getName());
      assertEquals("22)hxh|Y4W>p2", externalProgram0.getProgramOptions());
      assertEquals(21, externalProgram0.getType());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("", "", 0);
      int int0 = externalProgram0.getType();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("I.Y`FlZ{O}Iuwlev/", "I.Y`FlZ{O}Iuwlev/", (-832));
      int int0 = externalProgram0.getType();
      assertEquals((-832), int0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("1e=", "1e=", (-3025));
      String string0 = externalProgram0.getProgramOptions();
      assertEquals((-3025), externalProgram0.getType());
      assertEquals("1e=", string0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram((String) null, (String) null, 4);
      externalProgram0.getName();
      assertEquals(4, externalProgram0.getType());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("", "/etc/", 47);
      String string0 = externalProgram0.getName();
      assertEquals("", string0);
      assertEquals("/etc/", externalProgram0.getProgramOptions());
      assertEquals(47, externalProgram0.getType());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      String[] stringArray0 = new String[7];
      // Undeclared exception!
      try { 
        ExternalProgram.startProgram((String) null, stringArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("_A<>ey){&7(5F", "OHv]&!SSYUJ", 0);
      MockFile mockFile0 = new MockFile("org.biojava.utils.ChangeListener");
      File file0 = MockFile.createTempFile("tD#vk>OG", "", (File) mockFile0);
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(false);
      try { 
        externalProgram0.setFileNumber(file0, 2962L, remoteFileNode0);
        fail("Expecting exception: FileNotFoundException");
      
      } catch(FileNotFoundException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileOutputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("", "-wdir", 37);
      // Undeclared exception!
      try { 
        externalProgram0.makeDirectory((File) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.ExternalProgram", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram((String) null, (String) null, 1750);
      // Undeclared exception!
      try { 
        externalProgram0.getProgramOptions();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("_A<>ey){&7(5F", "OHv]&!SSYUJ", 0);
      String string0 = externalProgram0.getName();
      assertEquals("_A<>ey){&7(5F", string0);
      assertEquals(0, externalProgram0.getType());
      assertEquals("OHv]&!SSYUJ", externalProgram0.getProgramOptions());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("", "", 8832);
      int int0 = externalProgram0.getType();
      assertEquals(8832, int0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("", "", 8832);
      externalProgram0.getProgramOptions();
      assertEquals(8832, externalProgram0.getType());
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("", "", (-11));
      MockFile mockFile0 = new MockFile("", "");
      mockFile0.setReadOnly();
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(true);
      try { 
        externalProgram0.setFileNumber(mockFile0, (-11), remoteFileNode0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Cannot write to: /
         //
         verifyException("uk.ac.sanger.artemis.ExternalProgram", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("Features have been added or removed", " as a qualifier", (-4304));
      File file0 = MockFile.createTempFile("&er~j!", ".W_-Zo^:e");
      try { 
        externalProgram0.makeDirectory(file0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // /var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/&er~j!0.W_-Zo^:e is not a directory
         //
         verifyException("uk.ac.sanger.artemis.ExternalProgram", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("e=", "e=", (-3055));
      MockFile mockFile0 = new MockFile("e=");
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(false);
      // Undeclared exception!
      try { 
        externalProgram0.setFileNumber(mockFile0, (-3055), remoteFileNode0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("", "", (-11));
      MockFile mockFile0 = new MockFile("", "");
      externalProgram0.setFileNumber(mockFile0, (-11), (RemoteFileNode) null);
      assertEquals((-11), externalProgram0.getType());
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      String[] stringArray0 = new String[5];
      try { 
        ExternalProgram.startProgram("", stringArray0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Cannot start processes in a unit test
         //
         verifyException("org.evosuite.runtime.mock.java.lang.MockRuntime", e);
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      try { 
        ExternalProgram.startProgram("exon-model", (String[]) null);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Cannot start processes in a unit test
         //
         verifyException("org.evosuite.runtime.mock.java.lang.MockRuntime", e);
      }
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      String[] stringArray0 = new String[9];
      try { 
        ExternalProgram.startProgram("-f", stringArray0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Cannot start processes in a unit test
         //
         verifyException("org.evosuite.runtime.mock.java.lang.MockRuntime", e);
      }
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      try { 
        ExternalProgram.startProgram("/", (String[]) null);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Cannot start processes in a unit test
         //
         verifyException("org.evosuite.runtime.mock.java.lang.MockRuntime", e);
      }
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("getDbs", "getDbs", (-1968));
      FeatureVector featureVector0 = new FeatureVector();
      LogViewer logViewer0 = new LogViewer();
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("org.biojava.bio.symbol.SimpleAtomicSymbol", "}IUHdd_");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(fastaStreamSequence0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry();
      Feature feature0 = entry0.createFeature();
      featureVector0.addElementAtEnd(feature0);
      try { 
        externalProgram0.run(featureVector0, logViewer0);
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // misc_feature cannot have getDbs_file as a qualifier
         //
         verifyException("uk.ac.sanger.artemis.ExternalProgram", e);
      }
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("-", " g", 2);
      FeatureVector featureVector0 = new FeatureVector();
      LogViewer logViewer0 = new LogViewer();
      // Undeclared exception!
      try { 
        externalProgram0.run(featureVector0, logViewer0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.ExternalProgram", e);
      }
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("-", " g", 1);
      FeatureVector featureVector0 = new FeatureVector();
      LogViewer logViewer0 = new LogViewer();
      // Undeclared exception!
      try { 
        externalProgram0.run(featureVector0, logViewer0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.ExternalProgram", e);
      }
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("Cannot write to: ", (String) null, 0);
      Selection selection0 = new Selection((Clipboard) null);
      FeatureVector featureVector0 = selection0.getAllFeatures();
      LogViewer logViewer0 = new LogViewer();
      // Undeclared exception!
      try { 
        externalProgram0.run(featureVector0, logViewer0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.ExternalProgram", e);
      }
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("getDbs", "getDbs", (-1968));
      externalProgram0.setProgramOptions((String) null);
      assertEquals((-1968), externalProgram0.getType());
  }
}
