//
// BAGEL - Parallel electron correlation program.
// Filename: _complex_eriroot_7.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Ryan D. Reynolds <RyanDReynolds@u.northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <complex>
#include "comperirootlist.h"

using namespace std;
using namespace bagel;

void ComplexERIRootList::complex_eriroot7(const complex<double>* ta, complex<double>* rr, complex<double>* ww, const int n) {

  static constexpr double ax[7] = {8.511544299759415e-02,7.721379200427774e-01,2.180591888450458e+00,4.389792886731011e+00,7.554091326101782e+00,
    1.198999303982387e+01,1.852827749585251e+01};
  static constexpr double aw[7] = {5.364059097120906e-01,2.731056090642467e-01,6.850553422346542e-02,7.850054726457971e-03,3.550926135519249e-04,
    4.716484355018926e-06,8.628591168125084e-09};
  static constexpr double xr[24780] = {   2.505069162320974e-02,  -8.818460060206567e-04,   2.296465613317430e-05,  -5.219840623095208e-07,   1.085653128038866e-08,
  -2.100880436791046e-10,   3.790501047955420e-12,  -6.321060560611155e-14,   9.492843846249918e-16,  -1.199888714386180e-17,   9.818837069086227e-20,   6.783388341072976e-22,
  -5.845804316706211e-23,   1.826921498924221e-24,   2.505285687603322e-02,  -8.819935114367843e-04,   2.297079319132643e-05,  -5.221820718093905e-07,   1.086189124119046e-08,
  -2.102131315049801e-10,   3.793001178668766e-12,  -6.325099443048617e-14,   9.496863497541830e-16,  -1.199485160695714e-17,   9.780954508858425e-20,   6.920995006485878e-22,
  -5.882653321508671e-23,   1.834186687211282e-24,   2.505667797014201e-02,  -8.822538325276015e-04,   2.298162458530951e-05,  -5.225315582308484e-07,   1.087135183809129e-08,
  -2.104339155374095e-10,   3.797413549072011e-12,  -6.332224967750471e-14,   9.503943091595372e-16,  -1.198767274145766e-17,   9.713924076691208e-20,   7.164236785080967e-22,
  -5.947736349445192e-23,   1.847011612158214e-24,   2.506129928193726e-02,  -8.825686931062203e-04,   2.299472621519415e-05,  -5.229543238898402e-07,   1.088279657312111e-08,
  -2.107010000767887e-10,   3.802750482622890e-12,  -6.340839261830585e-14,   9.512481357142757e-16,  -1.197889279579321e-17,   9.632552701169661e-20,   7.459105271407532e-22,
  -6.026541851716777e-23,   1.862528839120511e-24,   2.506578641351103e-02,  -8.828744355179664e-04,   2.300744944224374e-05,  -5.233649081499998e-07,   1.089391203509563e-08,
  -2.109603964332579e-10,   3.807932999309480e-12,  -6.349199796077512e-14,   9.520746586713717e-16,  -1.197026535245232e-17,   9.553226061786617e-20,   7.746131526326191e-22,
  -6.103156360852985e-23,   1.877602327970301e-24,   2.506940179181771e-02,  -8.831207958307502e-04,   2.301770225583530e-05,  -5.236957918100824e-07,   1.090287016954813e-08,
  -2.111694453714845e-10,   3.812109050369775e-12,  -6.355933438321052e-14,   9.527388020301787e-16,  -1.196324055147693e-17,   9.489082968627264e-20,   7.977910218001639e-22,
  -6.164955939102146e-23,   1.889752243280577e-24,   2.507179106491668e-02,  -8.832836148393864e-04,   2.302447867375831e-05,  -5.239144937413741e-07,   1.090879133887403e-08,
  -2.113076216275535e-10,   3.814869040083160e-12,  -6.360382172967847e-14,   9.531768257034194e-16,  -1.195856209485509e-17,   9.446581459966048e-20,   8.131336817565382e-22,
  -6.205831150554888e-23,   1.897784076086435e-24,   2.507301816237776e-02,  -8.833672390068148e-04,   2.302795916534756e-05,  -5.240268261758226e-07,   1.091183269739841e-08,
  -2.113785942525125e-10,   3.816286590484242e-12,  -6.362666582546758e-14,   9.534015146612866e-16,  -1.195614815707978e-17,   9.424718733988462e-20,   8.210212658099825e-22,
  -6.226834638919181e-23,   1.901909853980352e-24,   2.507344527943876e-02,  -8.833963465677004e-04,   2.302917065822339e-05,  -5.240659274582927e-07,   1.091289135840750e-08,
  -2.114032989154551e-10,   3.816780007918383e-12,  -6.363461655763096e-14,   9.534796787407156e-16,  -1.195530615988809e-17,   9.417103452573924e-20,   8.237679481675787e-22,
  -6.234147023875993e-23,   1.903346035559672e-24,   2.507351305772485e-02,  -8.834009656033727e-04,   2.302936290906139e-05,  -5.240721324333573e-07,   1.091305935752258e-08,
  -2.114072192997374e-10,   3.816858307705441e-12,  -6.363587821200299e-14,   9.534920803580358e-16,  -1.195517246086879e-17,   9.415894738844059e-20,   8.242038722806698e-22,
  -6.235307490218935e-23,   1.903573945716399e-24,   2.169593182815332e-01,  -6.850736049252016e-03,   1.416849573915327e-04,  -2.034503183066425e-06,   1.301603314760979e-08,
   3.046945688163764e-10,  -1.280176153553576e-11,   2.373526096157351e-13,  -1.521931891789703e-15,  -5.682703890029816e-17,   2.328667153185785e-18,  -4.326309119941575e-20,
   2.166273046830395e-22,   1.376540275445282e-23,   2.169726157107232e-01,  -6.851307231406013e-03,   1.416921770030805e-04,  -2.034213633300673e-06,   1.299798618756867e-08,
   3.051587019076133e-10,  -1.280555286279542e-11,   2.371551269334852e-13,  -1.512072195288252e-15,  -5.704601157413834e-17,   2.329807117943903e-18,  -4.315830172566746e-20,
   2.122990526889782e-22,   1.384082996401788e-23,   2.169960797721768e-01,  -6.852315024432966e-03,   1.417049078579158e-04,  -2.033702365395078e-06,   1.296613778783196e-08,
   3.059773531729950e-10,  -1.281222165647483e-11,   2.368060678238880e-13,  -1.494670871658762e-15,  -5.743194882034016e-17,   2.331796854314855e-18,  -4.297295599735627e-20,
   2.046638910615817e-22,   1.397352476495182e-23,   2.170244536836729e-01,  -6.853533544456168e-03,   1.417202880526631e-04,  -2.033083533414528e-06,   1.292761912423870e-08,
   3.069667306677268e-10,  -1.282024971374437e-11,   2.363829633415481e-13,  -1.473622689397411e-15,  -5.789787082553119e-17,   2.334165787876797e-18,  -4.274808014432675e-20,
   1.954350196067325e-22,   1.413330186499353e-23,   2.170519995462406e-01,  -6.854716343076181e-03,   1.417352041219388e-04,  -2.032482152509124e-06,   1.289021831351775e-08,
   3.079266303301446e-10,  -1.282800559173850e-11,   2.359711553656252e-13,  -1.453182929696537e-15,  -5.834938505314731e-17,   2.336426690769778e-18,  -4.252898724332974e-20,
   1.864796805039034e-22,   1.428769882894484e-23,   2.170741908226740e-01,  -6.855669104573704e-03,   1.417472097384717e-04,  -2.031997236966999e-06,   1.286008330572448e-08,
   3.086995033928927e-10,  -1.283422666615722e-11,   2.356386455672896e-13,  -1.436712278877716e-15,  -5.871254844616334e-17,   2.338220239611813e-18,  -4.235192620706496e-20,
   1.792682118536721e-22,   1.441156827427884e-23,   2.170888547594139e-01,  -6.856298630422978e-03,   1.417551376577839e-04,  -2.031676592701020e-06,   1.284016799090228e-08,
   3.092100033460356e-10,  -1.283832423907975e-11,   2.354185559087322e-13,  -1.425826509851808e-15,  -5.895224051074690e-17,   2.339391773454092e-18,  -4.223465253450430e-20,
   1.745044103104936e-22,   1.449316865053501e-23,   2.170963854966356e-01,  -6.856621909082747e-03,   1.417592074221751e-04,  -2.031511858283302e-06,   1.282993970912310e-08,
   3.094721073493087e-10,  -1.284042445552686e-11,   2.353054140164973e-13,  -1.420235452735459e-15,  -5.907524721570057e-17,   2.339989203335241e-18,  -4.217434200497456e-20,
   1.720584100925632e-22,   1.453499686792868e-23,   2.170990066552538e-01,  -6.856734427113082e-03,   1.417606236859694e-04,  -2.031454510097108e-06,   1.282637953239370e-08,
   3.095633251492025e-10,  -1.284115480499055e-11,   2.352660155912260e-13,  -1.418289323993358e-15,  -5.911804702412305e-17,   2.340196474284141e-18,  -4.215333686992308e-20,
   1.712071277123648e-22,   1.454954322190865e-23,   2.170994225978136e-01,  -6.856752282076704e-03,   1.417608484154239e-04,  -2.031445409214069e-06,   1.282581457522864e-08,
   3.095777996877575e-10,  -1.284127067052862e-11,   2.352597627325538e-13,  -1.417980494944282e-15,  -5.912483810888434e-17,   2.340229333523528e-18,  -4.215000300347637e-20,
   1.710720442721978e-22,   1.455185094201838e-23,   5.586696205210251e-01,  -1.409478194899310e-02,   1.599169277858465e-04,   7.470170229809683e-07,  -5.673697080868307e-08,
   5.448058360334525e-10,   1.444325786286978e-11,  -4.547605284163429e-13,   4.986146626611195e-16,   2.092530293433729e-16,  -3.627440235956951e-18,  -4.744042645454577e-20,
   2.681223278797215e-21,  -1.974191258988288e-23,   5.586845488701937e-01,  -1.409457007959343e-02,   1.598851280198150e-04,   7.475203543756510e-07,  -5.671664860151902e-08,
   5.439216429729063e-10,   1.444426292619492e-11,  -4.540608264518722e-13,   4.838289352342586e-16,   2.090034421381858e-16,  -3.611278612673812e-18,  -4.757045590677054e-20,
   2.671960019958227e-21,  -1.947987438317565e-23,   5.587108877674912e-01,  -1.409419611889554e-02,   1.598290261276949e-04,   7.484078200490959e-07,  -5.668078871654597e-08,
   5.423625871029378e-10,   1.444600513432482e-11,  -4.528268797539270e-13,   4.577943421065886e-16,   2.085625110699466e-16,  -3.582807638251097e-18,  -4.779835834696830e-20,
   2.655626902173470e-21,  -1.901908315110240e-23,   5.587427329353429e-01,  -1.409374372767401e-02,   1.597612029698605e-04,   7.494798103623329e-07,  -5.663742482725638e-08,
   5.404792633877179e-10,   1.444805864102160e-11,  -4.513359530251890e-13,   4.264067992278596e-16,   2.080284323111261e-16,  -3.548459414888806e-18,  -4.807132682154146e-20,
   2.635897358984634e-21,  -1.846457761362870e-23,   5.587736433716305e-01,  -1.409330435113708e-02,   1.596953780200785e-04,   7.505192841600378e-07,  -5.659532613004590e-08,
   5.386529574755535e-10,   1.444999655185062e-11,  -4.498898186517614e-13,   3.960343670458380e-16,   2.075090207930048e-16,  -3.515197620131493e-18,  -4.833359111503463e-20,
   2.616765990927550e-21,  -1.792908223111457e-23,   5.587985413356187e-01,  -1.409295024977889e-02,   1.596423621890651e-04,   7.513558144394866e-07,  -5.656141071048701e-08,
   5.371831358689015e-10,   1.445151794380544e-11,  -4.487257148368786e-13,   3.716368860163228e-16,   2.070899221202238e-16,  -3.488461685853987e-18,  -4.854291839784294e-20,
   2.601369663755366e-21,  -1.749970251839923e-23,   5.588149919580713e-01,  -1.409271619478782e-02,   1.596073360953527e-04,   7.519081596924645e-07,  -5.653899939895058e-08,
   5.362126022027283e-10,   1.445250381209364e-11,  -4.479569285781669e-13,   3.555497755876239e-16,   2.068126639340940e-16,  -3.470824093334365e-18,  -4.868028596174741e-20,
   2.591203743471437e-21,  -1.721695771322417e-23,   5.588234396733204e-01,  -1.409259597436378e-02,   1.595893503211241e-04,   7.521916858574039e-07,  -5.652748993244581e-08,
   5.357144026137348e-10,   1.445300409668201e-11,  -4.475622539727258e-13,   3.472988770342789e-16,   2.066701783393432e-16,  -3.461775322176027e-18,  -4.875053680199730e-20,
   2.585985444965924e-21,  -1.707205795032974e-23,   5.588263799037084e-01,  -1.409255412704460e-02,   1.595830904943914e-04,   7.522903491148341e-07,  -5.652348392783263e-08,
   5.355410340486690e-10,   1.445317726970874e-11,  -4.474249051894195e-13,   3.444287633992454e-16,   2.066205689932514e-16,  -3.458627243289631e-18,  -4.877494149261286e-20,
   2.584169549189951e-21,  -1.702167250208518e-23,   5.588268464742520e-01,  -1.409254748628526e-02,   1.595820971597112e-04,   7.523060046361221e-07,  -5.652284822868000e-08,
   5.355135244763433e-10,   1.445320470452848e-11,  -4.474031108417256e-13,   3.439733959733828e-16,   2.066126959176135e-16,  -3.458127754349415e-18,  -4.877881196205194e-20,
   2.583881409630234e-21,  -1.701367931488092e-23,   9.791950866681609e-01,  -1.724548110643937e-02,   4.003220377988272e-06,   3.423743745729217e-06,  -1.011605238678835e-09,
  -1.228067986848130e-09,   1.940288462730750e-13,   5.368601008019116e-13,   1.882521889638293e-17,  -2.609832362485200e-16,  -7.516407507256700e-20,   1.354398702686374e-19,
   7.414229529426204e-23,  -7.395451957368754e-23,   9.791954608301825e-01,  -1.724452220293088e-02,   4.002652894406868e-06,   3.422601192120255e-06,  -1.011331884789241e-09,
  -1.227024736876046e-09,   1.940720519910935e-13,   5.359968853036168e-13,   1.852241616095233e-17,  -2.603049888037574e-16,  -7.471757789335212e-20,   1.349197459611947e-19,
   7.387701134611851e-23,  -7.357709953985832e-23,   9.791961210018968e-01,  -1.724283046231445e-02,   4.001651685808131e-06,   3.420585929223930e-06,  -1.010849500572542e-09,
  -1.225185278887703e-09,   1.941476515786323e-13,   5.344755742724726e-13,   1.798963663009975e-17,  -2.591103698457005e-16,  -7.393105534354480e-20,   1.340041954389731e-19,
   7.340943359830416e-23,  -7.291312691202569e-23,   9.791969192151753e-01,  -1.724078523418900e-02,   4.000441227006476e-06,   3.418150399671358e-06,  -1.010266116815233e-09,
  -1.222963325701130e-09,   1.942379824895135e-13,   5.326391327741665e-13,   1.734798366683723e-17,  -2.576694993491949e-16,  -7.298224771353710e-20,   1.329008740952993e-19,
   7.284491883134185e-23,  -7.211363004117695e-23,   9.791976940299407e-01,  -1.723880022556576e-02,   3.999266357972856e-06,   3.415787440312726e-06,  -1.009699695225447e-09,
  -1.220808738892708e-09,   1.943245408783484e-13,   5.308596344409606e-13,   1.672778605515097e-17,  -2.562745681164496e-16,  -7.206353008877324e-20,   1.318337287299270e-19,
   7.229782300770894e-23,  -7.134102678914708e-23,   9.791983181555700e-01,  -1.723720146037397e-02,   3.998320058848132e-06,   3.413884881012230e-06,  -1.009243334520576e-09,
  -1.219074783156031e-09,   1.943934611741201e-13,   5.294284454351934e-13,   1.623010038431837e-17,  -2.551535759806890e-16,  -7.132511846629978e-20,   1.309768660193536e-19,
   7.185775155515000e-23,  -7.072115219241566e-23,   9.791987305397064e-01,  -1.723614518729867e-02,   3.997694839633416e-06,   3.412628197998412e-06,  -1.008941750866093e-09,
  -1.217929872886684e-09,   1.944386066730524e-13,   5.284838912369896e-13,   1.590218606233542e-17,  -2.544141867359605e-16,  -7.083801866272263e-20,   1.304120421526859e-19,
   7.156728375572617e-23,  -7.031278300000858e-23,   9.791989423103549e-01,  -1.723560279077340e-02,   3.997373783894636e-06,   3.411982983946126e-06,  -1.008786864412984e-09,
  -1.217342171497195e-09,   1.944616688111993e-13,   5.279991727988743e-13,   1.573407915164371e-17,  -2.540348896401054e-16,  -7.058812598194144e-20,   1.301224029164648e-19,
   7.141821461131113e-23,  -7.010344648842070e-23,   9.791990160177411e-01,  -1.723541401269305e-02,   3.997262041364324e-06,   3.411758435608469e-06,  -1.008732953364385e-09,
  -1.217137658791806e-09,   1.944696763546673e-13,   5.278305186502286e-13,   1.567561459208371e-17,  -2.539029377835427e-16,  -7.050118934900455e-20,   1.300216589088656e-19,
   7.136634563676622e-23,  -7.003064553173712e-23,   9.791990277140251e-01,  -1.723538405659123e-02,   3.997244309546942e-06,   3.411722804034358e-06,  -1.008724398357044e-09,
  -1.217105207442551e-09,   1.944709461187270e-13,   5.278037582432896e-13,   1.566633928302522e-17,  -2.538820019721702e-16,  -7.048739563947662e-20,   1.300056754295113e-19,
   7.135811549980229e-23,  -7.001909589503788e-23,   1.397594230903450e+00,  -1.431683315023107e-02,  -1.489867578190033e-04,   9.019708647259558e-07,   5.305631340085566e-08,
   4.263555128719741e-10,  -1.393441461283510e-11,  -3.811793707194517e-13,   2.531974147903006e-16,   1.768518121066073e-16,   2.661882309157719e-18,  -4.329534184696597e-20,
  -2.022687674751474e-21,  -1.132503177027345e-23,   1.397580323108058e+00,  -1.431657808679674e-02,  -1.489570242420224e-04,   9.023643508883487e-07,   5.303672900691352e-08,
   4.256144543485496e-10,  -1.393352727487504e-11,  -3.805883995229986e-13,   2.640374686485512e-16,   1.766257978393154e-16,   2.649707976251654e-18,  -4.336816011057089e-20,
  -2.015307929586160e-21,  -1.114220293732681e-23,   1.397555784837002e+00,  -1.431612793445255e-02,  -1.489045678304319e-04,   9.030581014822611e-07,   5.300217313680240e-08,
   4.243077879014501e-10,  -1.393193865444325e-11,  -3.795462436950555e-13,   2.831234575067672e-16,   1.762266970083099e-16,   2.628263144983168e-18,  -4.349557774827710e-20,
  -2.002300015992859e-21,  -1.082075729782625e-23,   1.397526116738044e+00,  -1.431558345393056e-02,  -1.488411522418651e-04,   9.038960344664031e-07,   5.296038970467542e-08,
   4.227293600406085e-10,  -1.392997869383904e-11,  -3.782871190844162e-13,   3.061318386454340e-16,   1.757435998989580e-16,   2.602394816275856e-18,  -4.364783049323519e-20,
  -1.986594218422994e-21,  -1.043403372681150e-23,   1.397497319482353e+00,  -1.431505472312895e-02,  -1.487796054708658e-04,   9.047084830907852e-07,   5.291982907934628e-08,
   4.211987317338466e-10,  -1.392803525141664e-11,  -3.770658948335139e-13,   3.283941550924580e-16,   1.752740977527749e-16,   2.577348192546493e-18,  -4.379373279307453e-20,
  -1.971371977498419e-21,  -1.006066935593435e-23,   1.397474123668427e+00,  -1.431462867095891e-02,  -1.487300356451254e-04,   9.053622634969083e-07,   5.288715542121980e-08,
   4.199668821052456e-10,  -1.392644049881097e-11,  -3.760828897754959e-13,   3.462755725667200e-16,   1.748955032033378e-16,   2.557218133727038e-18,  -4.390991119724507e-20,
  -1.959126856939890e-21,  -9.761364596298043e-24,   1.397458797698130e+00,  -1.431434708772778e-02,  -1.486972863946768e-04,   9.057939187449554e-07,   5.286556596841505e-08,
   4.191534873855956e-10,  -1.392537246848569e-11,  -3.754337281264063e-13,   3.580654663922294e-16,   1.746451547431247e-16,   2.543939630471878e-18,  -4.398601631022925e-20,
  -1.951044190595226e-21,  -9.564309060074669e-24,   1.397450927515182e+00,  -1.431420246409363e-02,  -1.486804698216704e-04,   9.060154857955875e-07,   5.285447897493100e-08,
   4.187359525546235e-10,  -1.392481958268690e-11,  -3.751004733905556e-13,   3.641121600481911e-16,   1.745165334205759e-16,   2.537127618002779e-18,  -4.402489509258695e-20,
  -1.946896045824069e-21,  -9.463333901406160e-24,   1.397448188295361e+00,  -1.431415212378018e-02,  -1.486746169355013e-04,   9.060925869549865e-07,   5.285062008102831e-08,
   4.185906547470763e-10,  -1.392462644547031e-11,  -3.749845002681991e-13,   3.662154971664383e-16,   1.744717567909599e-16,   2.534757770141078e-18,  -4.403839463097780e-20,
  -1.945452674775506e-21,  -9.428223935360228e-24,   1.397447753622197e+00,  -1.431414413533600e-02,  -1.486736881761794e-04,   9.061048210267810e-07,   5.285000772940932e-08,
   4.185675993633900e-10,  -1.392459576401911e-11,  -3.749660978443644e-13,   3.665492075212532e-16,   1.744646509391502e-16,   2.534381761820877e-18,  -4.404053527587323e-20,
  -1.945223652027526e-21,  -9.422654145547518e-24,   1.739645979297740e+00,  -7.610962865160220e-03,  -1.430182413399460e-04,  -1.764289592874547e-06,  -5.513484705159525e-09,
   3.820486808631960e-10,   1.131327638510824e-11,   1.549461840504266e-13,  -1.744283128042202e-16,  -6.542113013201446e-17,  -1.708172336359635e-18,  -1.975615651823915e-20,
   1.787002000541641e-22,   1.346549478926799e-23,   1.739632565320514e+00,  -7.611457799573453e-03,  -1.430212529127692e-04,  -1.763928891610326e-06,  -5.497582835272228e-09,
   3.823501724826156e-10,   1.131267063015588e-11,   1.547228493322611e-13,  -1.815946526970335e-16,  -6.551911494643244e-17,  -1.706946914033501e-18,  -1.965654424380978e-20,
   1.812943899268933e-22,   1.348672369205927e-23,   1.739608895927484e+00,  -7.612331036229058e-03,  -1.430265596101449e-04,  -1.763292199850109e-06,  -5.469524485962457e-09,
   3.828818004824951e-10,   1.131158649664136e-11,   1.543285057026914e-13,  -1.942354643983689e-16,  -6.569159196345378e-17,  -1.704771667112291e-18,  -1.948065487722183e-20,
   1.858646532720427e-22,   1.352386574655868e-23,   1.739580274271179e+00,  -7.613386821931755e-03,  -1.430329641291922e-04,  -1.762521915597544e-06,  -5.435597321394032e-09,
   3.835240388281763e-10,   1.131024952166441e-11,   1.538512083983524e-13,  -2.095134934993829e-16,  -6.589943870330182e-17,  -1.702119245461120e-18,  -1.926776094291395e-20,
   1.913787245531034e-22,   1.356823865001274e-23,   1.739552488472181e+00,  -7.614411612307407e-03,  -1.430391685446576e-04,  -1.761773729051695e-06,  -5.402662784680319e-09,
   3.841468715402061e-10,   1.130892436022414e-11,   1.533873833029586e-13,  -2.243373774685810e-16,  -6.610046426386590e-17,  -1.699521220134424e-18,  -1.906087245463724e-20,
   1.967187418368305e-22,   1.361075034560525e-23,   1.739530104314393e+00,  -7.615237063955978e-03,  -1.430441574406350e-04,  -1.761170707590755e-06,  -5.376132140645940e-09,
   3.846481578273740e-10,   1.130783730918338e-11,   1.530133935483509e-13,  -2.362737167589968e-16,  -6.626187126877070e-17,  -1.697411755988130e-18,  -1.889405307399029e-20,
   2.010112955325889e-22,   1.364459284328755e-23,   1.739515313124992e+00,  -7.615782455713267e-03,  -1.430474494605778e-04,  -1.760772098795490e-06,  -5.358601652972307e-09,
   3.849791737163788e-10,   1.130710945092871e-11,   1.527661024318527e-13,  -2.441582896782219e-16,  -6.636826329925390e-17,  -1.696009775870444e-18,  -1.878374749745762e-20,
   2.038431803949978e-22,   1.366675748173928e-23,   1.739507717099257e+00,  -7.616062524396414e-03,  -1.430491386620994e-04,  -1.760567349910385e-06,  -5.349599060985834e-09,
   3.851490965589945e-10,   1.130673270663634e-11,   1.526390555364617e-13,  -2.482065431206877e-16,  -6.642281938486202e-17,  -1.695287293956382e-18,  -1.872707742700029e-20,
   2.052960775954187e-22,   1.367807891107135e-23,   1.739505073226215e+00,  -7.616160002306132e-03,  -1.430497263799669e-04,  -1.760496078151123e-06,  -5.346465650720226e-09,
   3.852082286693346e-10,   1.130660110705904e-11,   1.525948275753505e-13,  -2.496154389539222e-16,  -6.644179518265613e-17,  -1.695035429991564e-18,  -1.870734925649607e-20,
   2.058015469742052e-22,   1.368200970149520e-23,   1.739504653679656e+00,  -7.616175470586368e-03,  -1.430498196320553e-04,  -1.760484767970562e-06,  -5.345968422821271e-09,
   3.852176115942917e-10,   1.130658020169390e-11,   1.525878088213958e-13,  -2.498390048655509e-16,  -6.644480576572418e-17,  -1.694995443781082e-18,  -1.870421849522219e-20,
   2.058817473285825e-22,   1.368263300160756e-23,   1.948955399081231e+00,  -1.659584306494419e-03,  -3.947036058947585e-05,  -8.055206902531633e-07,  -1.467696964092900e-08,
  -2.393659163930463e-10,  -3.400138187455421e-12,  -3.832825928441653e-14,  -2.105428662453375e-16,   4.917659709604094e-18,   2.241381635074178e-19,   5.709977112235546e-21,
   1.137349684459219e-22,   1.820931247748955e-24,   1.948951682114265e+00,  -1.659811651536927e-03,  -3.947864339701750e-05,  -8.057457271793717e-07,  -1.468175734294072e-08,
  -2.394410967894128e-10,  -3.400670788101168e-12,  -3.831087911125882e-14,  -2.095743208389110e-16,   4.947621502306911e-18,   2.248509771635110e-19,   5.723330315544329e-21,
   1.139319870878046e-22,   1.821653287870241e-24,   1.948945122832944e+00,  -1.660212857013151e-03,  -3.949326073239949e-05,  -8.061428655972759e-07,  -1.469020591957301e-08,
  -2.395737255779322e-10,  -3.401608489373000e-12,  -3.828012892768554e-14,  -2.078628544048549e-16,   5.000545571701795e-18,   2.261097311298883e-19,   5.746896180454530e-21,
   1.142789021948489e-22,   1.822900265207049e-24,   1.948937190197668e+00,  -1.660698086905572e-03,  -3.951093990684078e-05,  -8.066231871678171e-07,  -1.470042305201751e-08,
  -2.397340535457847e-10,  -3.402738815990130e-12,  -3.824280454114840e-14,  -2.057891463335073e-16,   5.064637442523166e-18,   2.276335035522337e-19,   5.775398862623175e-21,
   1.146971536539559e-22,   1.824361942417571e-24,   1.948929488199219e+00,  -1.661169231791235e-03,  -3.952810645623560e-05,  -8.070895771710013e-07,  -1.471034273684602e-08,
  -2.398896465917450e-10,  -3.403832393527391e-12,  -3.820642295155000e-14,  -2.037716414602071e-16,   5.126956763055851e-18,   2.291145048871144e-19,   5.803075529549835e-21,
   1.151018821007236e-22,   1.825732529898473e-24,   1.948923282757220e+00,  -1.661548845985513e-03,  -3.954193840891705e-05,  -8.074653680597700e-07,  -1.471833467076926e-08,
  -2.400149540111511e-10,  -3.404710693917809e-12,  -3.817700847955316e-14,  -2.021432218893298e-16,   5.177232086213010e-18,   2.303088315047814e-19,   5.825376234130892e-21,
   1.154269910307689e-22,   1.826801974464337e-24,   1.948919181913971e+00,  -1.661799720601849e-03,  -3.955107968969222e-05,  -8.077137198039001e-07,  -1.472361597221828e-08,
  -2.400977371077873e-10,  -3.405289749848713e-12,  -3.815752001284347e-14,  -2.010656510861909e-16,   5.210488228695368e-18,   2.310986329626492e-19,   5.840114423953319e-21,
   1.156413587634477e-22,   1.827491656115272e-24,   1.948917075811737e+00,  -1.661928566716998e-03,  -3.955577459934568e-05,  -8.078412713839997e-07,  -1.472632828871319e-08,
  -2.401402446727938e-10,  -3.405586717577882e-12,  -3.814749569163349e-14,  -2.005117904330818e-16,   5.227577706305720e-18,   2.315044227817577e-19,   5.847683886647770e-21,
   1.157513049339514e-22,   1.827840585453453e-24,   1.948916342743983e+00,  -1.661973414378712e-03,  -3.955740877324042e-05,  -8.078856686427929e-07,  -1.472727235368429e-08,
  -2.401550389412620e-10,  -3.405690015382665e-12,  -3.814400407716704e-14,  -2.003189382877210e-16,   5.233527584038799e-18,   2.316456917128448e-19,   5.850318617663364e-21,
   1.157895500999615e-22,   1.827961196745894e-24,   1.948916226415297e+00,  -1.661980531160524e-03,  -3.955766809734028e-05,  -8.078927139600195e-07,  -1.472742216466548e-08,
  -2.401573865461853e-10,  -3.405706404257554e-12,  -3.814344988460293e-14,  -2.002883317060013e-16,   5.234471829753272e-18,   2.316681105737146e-19,   5.850736718405844e-21,
   1.157956180076855e-22,   1.827980296370677e-24,   2.185485628826804e-02,  -7.205209898320876e-04,   1.761892118137938e-05,  -3.774956828215869e-07,   7.437276680541085e-09,
  -1.372934945534856e-10,   2.386495374660875e-12,  -3.896640460606780e-14,   5.897068071471739e-16,  -8.036983707606827e-18,   9.089394167047394e-20,  -6.150660329607488e-22,
  -7.373494660690386e-24,   4.198631624285429e-25,   2.185651649566862e-02,  -7.206276160813888e-04,   1.762312369877275e-05,  -3.776250442906625e-07,   7.440651094805893e-09,
  -1.373706423963788e-10,   2.388051232305913e-12,  -3.899360822291468e-14,   5.900886150424101e-16,  -8.040027990054253e-18,   9.084339022970734e-20,  -6.118250011450548e-22,
  -7.479218943914320e-24,   4.229533285098415e-25,   2.185944628038005e-02,  -7.208157894710502e-04,   1.763054065445050e-05,  -3.778533635762396e-07,   7.446607083841333e-09,
  -1.375068145616422e-10,   2.390797381453729e-12,  -3.904161769257132e-14,   5.907621433527067e-16,  -8.045385912588791e-18,   9.075365483519473e-20,  -6.060877324754055e-22,
  -7.666199659833642e-24,   4.284093547481536e-25,   2.186298955755840e-02,  -7.210433813867262e-04,   1.763951195589168e-05,  -3.781295502133866e-07,   7.453812168481499e-09,
  -1.376715497201327e-10,   2.394119441774495e-12,  -3.909968531376965e-14,   5.915762766748422e-16,  -8.051841251913181e-18,   9.064422944458582e-20,  -5.991187494939733e-22,
  -7.893029344984136e-24,   4.350126093537186e-25,   2.186642988597960e-02,  -7.212643767228831e-04,   1.764822390469501e-05,  -3.783977727100277e-07,   7.460809923219016e-09,
  -1.378315496004493e-10,   2.397345892994300e-12,  -3.915607104286163e-14,   5.923663029248307e-16,  -8.058083288326750e-18,   9.053703964870180e-20,  -5.923204648485044e-22,
  -8.113996612600594e-24,   4.414289850996331e-25,   2.186920178278622e-02,  -7.214424457060294e-04,   1.765524411872995e-05,  -3.786139247257793e-07,   7.466449504823424e-09,
  -1.379604992035196e-10,   2.399946120658294e-12,  -3.920150515302531e-14,   5.930025071708689e-16,  -8.063094049945711e-18,   9.044999868916049e-20,  -5.868202580602188e-22,
  -8.292552940406230e-24,   4.466022753306795e-25,   2.187103360504776e-02,  -7.215601291341029e-04,   1.765988392144122e-05,  -3.787567910829833e-07,   7.470177157143449e-09,
  -1.380457341188138e-10,   2.401664814146944e-12,  -3.923153233524541e-14,   5.934227862200338e-16,  -8.066396365881204e-18,   9.039214507115151e-20,  -5.831742606035544e-22,
  -8.410808040504086e-24,   4.500228215193077e-25,   2.187197439597678e-02,  -7.216205709633148e-04,   1.766226698226916e-05,  -3.788301712240025e-07,   7.472091830544134e-09,
  -1.380895147741870e-10,   2.402547602996448e-12,  -3.924695431502797e-14,   5.936385844580807e-16,  -8.068089566584490e-18,   9.036232967087703e-20,  -5.812982907178719e-22,
  -8.471620645657031e-24,   4.517800943432647e-25,   2.187230185683346e-02,  -7.216416092122189e-04,   1.766309647619859e-05,  -3.788557136740178e-07,   7.472758305175326e-09,
  -1.381047543772199e-10,   2.402854890813275e-12,  -3.925232232846903e-14,   5.937136894042280e-16,  -8.068678470936997e-18,   9.035193545342671e-20,  -5.806447728617819e-22,
  -8.492800235227746e-24,   4.523918341540302e-25,   2.187235382083431e-02,  -7.216449477360983e-04,   1.766322810772978e-05,  -3.788597669954603e-07,   7.472864068132523e-09,
  -1.381071727561907e-10,   2.402903654348046e-12,  -3.925317417023921e-14,   5.937256072584669e-16,  -8.068771901542546e-18,   9.035028524152829e-20,  -5.805410415472101e-22,
  -8.496161771292220e-24,   4.524889138184431e-25,   1.916741964266636e-01,  -5.811006753291462e-03,   1.186733763929997e-04,  -1.792047032003793e-06,   1.654141093412892e-08,
   7.036425886299300e-11,  -7.037418754676508e-12,   1.704316178324366e-13,  -2.308922409761659e-15,   2.957428226435921e-18,   7.995056852115786e-19,  -2.482915632125305e-20,
   4.142202047611796e-22,  -2.357019074420831e-24,   1.916853405977894e-01,  -5.811510522614788e-03,   1.186826246193159e-04,  -1.791978243622442e-06,   1.653144386605597e-08,
   7.069989333691028e-11,  -7.043408090666749e-12,   1.704382450150465e-13,  -2.305468736025218e-15,   2.828842956388640e-18,   8.020245227623269e-19,  -2.484393688103759e-20,
   4.132764401892321e-22,  -2.312532280046090e-24,   1.917050053615104e-01,  -5.812399415304513e-03,   1.186989386856792e-04,  -1.791856609594756e-06,   1.651384999811941e-08,
   7.129213460880515e-11,  -7.053968948924207e-12,   1.704495855566771e-13,  -2.299366074133658e-15,   2.601892776349943e-18,   8.064642362840206e-19,  -2.486975288163407e-20,
   4.116050428829944e-22,  -2.234030441823218e-24,   1.917287853945915e-01,  -5.813474246169070e-03,   1.187186580270734e-04,  -1.791709092185247e-06,   1.649256368301351e-08,
   7.200829397707918e-11,  -7.066726588480531e-12,   1.704626962718018e-13,  -2.291972017430905e-15,   2.327361589181915e-18,   8.118245544466820e-19,  -2.490051880708743e-20,
   4.095735697607400e-22,  -2.139098557249812e-24,   1.917518718856377e-01,  -5.814517644336854e-03,   1.187377930495111e-04,  -1.791565428002768e-06,   1.647188713377284e-08,
   7.270354419786245e-11,  -7.079098207485273e-12,   1.704747929733249e-13,  -2.284778665552470e-15,   2.060747081945303e-18,   8.170196125421034e-19,  -2.492991347544779e-20,
   4.075905790201462e-22,  -2.046934056227656e-24,   1.917704709555430e-01,  -5.815358171496116e-03,   1.187532021170239e-04,  -1.791449366681717e-06,   1.645522166510187e-08,
   7.326363920684569e-11,  -7.089055098943165e-12,   1.704840857459356e-13,  -2.278972821504005e-15,   1.845891795439561e-18,   8.211984701582823e-19,  -2.495325498393260e-20,
   4.059853324732100e-22,  -1.972683508654625e-24,   1.917827613267314e-01,  -5.815913566653296e-03,   1.187633812854688e-04,  -1.791372515160513e-06,   1.644420515801420e-08,
   7.363374499793981e-11,  -7.095629767734216e-12,   1.704900048099214e-13,  -2.275131054520263e-15,   1.703883240864882e-18,   8.239567348889580e-19,  -2.496851291706590e-20,
   4.049208132134199e-22,  -1.923618288573479e-24,   1.917890731555759e-01,  -5.816198785478640e-03,   1.187686078881334e-04,  -1.791332998662590e-06,   1.643854633680966e-08,
   7.382381354281155e-11,  -7.099004730244973e-12,   1.704929760435685e-13,  -2.273156463932726e-15,   1.630943975985121e-18,   8.253722909700680e-19,  -2.497629734465574e-20,
   4.043729574229522e-22,  -1.898420439963599e-24,   1.917912700669243e-01,  -5.816298057998998e-03,   1.187704269137667e-04,  -1.791319236692835e-06,   1.643657652252913e-08,
   7.388996887852703e-11,  -7.100179186801369e-12,   1.704939993043893e-13,  -2.272468925493376e-15,   1.605555038607120e-18,   8.258648376645399e-19,  -2.497899862665253e-20,
   4.041820843735430e-22,  -1.889650020335218e-24,   1.917916186875203e-01,  -5.816313811156854e-03,   1.187707155613750e-04,  -1.791317052483167e-06,   1.643626393017540e-08,
   7.390046683044672e-11,  -7.100365545958897e-12,   1.704941611641133e-13,  -2.272359810075777e-15,   1.601526080542120e-18,   8.259429908908719e-19,  -2.497942689555218e-20,
   4.041517865824520e-22,  -1.888258271914109e-24,   5.048853700709389e-01,  -1.279409278146246e-02,   1.638433855530929e-04,  -5.898967722743831e-08,  -4.337087124834150e-08,
   7.463447804526942e-10,   2.852800234131770e-12,  -3.482994970214086e-13,   5.223841145985605e-15,   5.492492185762991e-17,  -3.441671363841483e-18,   4.077193740988688e-20,
   8.508806616360395e-22,  -3.726331599257819e-23,   5.049006814325546e-01,  -1.279410692918162e-02,   1.638190131094860e-04,  -5.829571706134045e-08,  -4.336670129973594e-08,
   7.456621094918159e-10,   2.866217030564389e-12,  -3.481089539778865e-13,   5.209494962198103e-15,   5.512487589067874e-17,  -3.436297085921509e-18,   4.050670691870760e-20,
   8.532857792889244e-22,  -3.713178525772847e-23,   5.049276967166211e-01,  -1.279413173537265e-02,   1.637760094927603e-04,  -5.707173279611312e-08,  -4.335932813663354e-08,
   7.444578333364095e-10,   2.889860668042084e-12,  -3.477721966538754e-13,   5.184199422769322e-15,   5.547659350905773e-17,  -3.426802312574211e-18,   4.003948534234947e-20,
   8.575003223140725e-22,  -3.689970725850898e-23,   5.049603607250028e-01,  -1.279416146250406e-02,   1.637240123783813e-04,  -5.559256334350463e-08,  -4.335038649604528e-08,
   7.430021346328304e-10,   2.918398810659203e-12,  -3.473640655007141e-13,   5.153643404438166e-15,   5.590001332973508e-17,  -3.415301153536772e-18,   3.947584899082533e-20,
   8.625466973426812e-22,  -3.661909573703045e-23,   5.049920670681057e-01,  -1.279419003972844e-02,   1.636735379608653e-04,  -5.415753821732165e-08,  -4.334167897975332e-08,
   7.415895179375203e-10,   2.946048730051147e-12,  -3.469668974344026e-13,   5.124013295632204e-15,   5.630909518541461e-17,  -3.404115234940628e-18,   3.893007636916026e-20,
   8.673935160366334e-22,  -3.634670675973333e-23,   5.050176069136980e-01,  -1.279421285964803e-02,   1.636328789249000e-04,  -5.300216466497916e-08,  -4.333464490330761e-08,
   7.404519271893933e-10,   2.968284181530246e-12,  -3.466462570153190e-13,   5.100167437753624e-15,   5.663723903846755e-17,  -3.395089196660782e-18,   3.849140906034041e-20,
   8.712608052789678e-22,  -3.612729308403192e-23,   5.050344820272961e-01,  -1.279422784000387e-02,   1.636060133832326e-04,  -5.223903947029754e-08,  -4.332998741365365e-08,
   7.397004210496042e-10,   2.982957903832414e-12,  -3.464340479181814e-13,   5.084422169048479e-15,   5.685338247798444e-17,  -3.389117737381592e-18,   3.820203512566679e-20,
   8.737980434578272e-22,  -3.598231881902112e-23,   5.050431478464101e-01,  -1.279423550263417e-02,   1.635922170213190e-04,  -5.184723868586681e-08,  -4.332759263459303e-08,
   7.393145465942638e-10,   2.990487667522917e-12,  -3.463249647586981e-13,   5.076339824938279e-15,   5.696416982610689e-17,  -3.386048884051867e-18,   3.805357917412386e-20,
   8.750954170550839e-22,  -3.590787100237725e-23,   5.050461640069335e-01,  -1.279423816482786e-02,   1.635874151316136e-04,  -5.171088483620486e-08,  -4.332675864267500e-08,
   7.391802489974321e-10,   2.993107532454714e-12,  -3.462869808815502e-13,   5.073527265120743e-15,   5.700269653844622e-17,  -3.384980388286627e-18,   3.800193182479154e-20,
   8.755460858953016e-22,  -3.588195931738640e-23,   5.050466426273548e-01,  -1.279423858705086e-02,   1.635866531407182e-04,  -5.168924811777487e-08,  -4.332662627747041e-08,
   7.391589382714201e-10,   2.993523224398755e-12,  -3.462809525810812e-13,   5.073080977869436e-15,   5.700880859097260e-17,  -3.384810815967720e-18,   3.799373724604209e-20,
   8.756175584108766e-22,  -3.587784751674345e-23,   9.105346013585621e-01,  -1.705123082143082e-02,   4.419505490170478e-05,   3.216323197083874e-06,  -2.434445056677046e-08,
  -1.051378493400696e-09,   1.388344157514469e-11,   3.977323889591137e-13,  -8.081631083795933e-15,  -1.566880042967814e-16,   4.717368006556638e-18,   5.915666252308177e-20,
  -2.766692850572236e-21,  -1.968093249760376e-23,   9.105387173682168e-01,  -1.705032967980091e-02,   4.418146985961780e-05,   3.215344037526733e-06,  -2.432517256276900e-08,
  -1.050603729609037e-09,   1.386262584738243e-11,   3.972113545706802e-13,  -8.062257877570630e-15,  -1.563884674796668e-16,   4.700849079882304e-18,   5.901520335646984e-20,
  -2.753653226033808e-21,  -1.963648398709970e-23,   9.105459791095822e-01,  -1.704873982395789e-02,   4.415750759725477e-05,   3.213616883034099e-06,  -2.429117986310875e-08,
  -1.049237476830909e-09,   1.382593719395558e-11,   3.962927990492759e-13,  -8.028129682794148e-15,  -1.558605205273929e-16,   4.671766071853026e-18,   5.876586146782297e-20,
  -2.730707774900429e-21,  -1.955799431032806e-23,   9.105547583419628e-01,  -1.704681773298335e-02,   4.412854709955101e-05,   3.211529391439606e-06,  -2.425011580659875e-08,
  -1.047586803905274e-09,   1.378164275291152e-11,   3.951834653005595e-13,  -7.986957063960739e-15,  -1.552231274765831e-16,   4.636709028069581e-18,   5.846480673104981e-20,
  -2.703069353734174e-21,  -1.946298382634420e-23,   9.105632792442472e-01,  -1.704495219783572e-02,   4.410044837065263e-05,   3.209503939543760e-06,  -2.421029367056954e-08,
  -1.045985839346563e-09,   1.373871554028078e-11,   3.941080010456230e-13,  -7.947087273690467e-15,  -1.546054098834252e-16,   4.602791633397127e-18,   5.817302176955413e-20,
  -2.676350670308680e-21,  -1.937064676056817e-23,   9.105701422654429e-01,  -1.704344963170528e-02,   4.407782358582802e-05,   3.207873012916886e-06,  -2.417824363959176e-08,
  -1.044697182833326e-09,   1.370418621298120e-11,   3.932426645030533e-13,  -7.915040113676777e-15,  -1.541085380837349e-16,   4.575550694501237e-18,   5.793830325212047e-20,
  -2.654906626611840e-21,  -1.929618923790025e-23,   9.105746765878714e-01,  -1.704245690214870e-02,   4.406287900524630e-05,   3.206795693248111e-06,  -2.415708030758006e-08,
  -1.043846180106961e-09,   1.368139541530808e-11,   3.926713760431779e-13,  -7.893898837841732e-15,  -1.537805826869869e-16,   4.557590670339064e-18,   5.778337182058786e-20,
  -2.640775953003220e-21,  -1.924695438348785e-23,   9.105770049815938e-01,  -1.704194713111701e-02,   4.405520594042071e-05,   3.206242551698344e-06,  -2.414621648539805e-08,
  -1.043409309782607e-09,   1.366969915065808e-11,   3.923781498789897e-13,  -7.883052567753927e-15,  -1.536122758440033e-16,   4.548379786027240e-18,   5.770385858984936e-20,
  -2.633531270052695e-21,  -1.922165934054558e-23,   9.105778153688641e-01,  -1.704176970750140e-02,   4.405253552931832e-05,   3.206050043806382e-06,  -2.414243595856729e-08,
  -1.043257278578462e-09,   1.366562941584001e-11,   3.922761149408515e-13,  -7.879279140331649e-15,  -1.535537132409888e-16,   4.545175833565077e-18,   5.767619147772790e-20,
  -2.631011615499183e-21,  -1.921285349458064e-23,   9.105779439646683e-01,  -1.704174155314279e-02,   4.405211178464114e-05,   3.206019496313921e-06,  -2.414183607548517e-08,
  -1.043233154531234e-09,   1.366498366464604e-11,   3.922599245934885e-13,  -7.878680430821362e-15,  -1.535444210232494e-16,   4.544667504410359e-18,   5.767180147719311e-20,
  -2.630611872312410e-21,  -1.921145604882889e-23,   1.338032717737043e+00,  -1.545048895375769e-02,  -1.328568640599803e-04,   1.797387536774557e-06,   5.740662981797811e-08,
  -2.873797790815051e-11,  -2.342048297544371e-11,  -2.561182899190839e-13,   7.815243531358685e-15,   2.167786269418965e-16,  -1.306927186779807e-18,  -1.284428275951908e-19,
  -9.147240545686345e-22,   5.746134033274200e-23,   1.338020326878505e+00,  -1.544998354985952e-02,  -1.328247573088765e-04,   1.797356461982628e-06,   5.737393585936455e-08,
  -2.923087682058737e-11,  -2.340008578257240e-11,  -2.554034487438802e-13,   7.809564662414929e-15,   2.161323021577093e-16,  -1.312137085965035e-18,  -1.280313531425593e-19,
  -9.049254055402384e-22,   5.730356872772426e-23,   1.337998465438557e+00,  -1.544909176453689e-02,  -1.327681193352948e-04,   1.797301257817586e-06,   5.731627012746066e-08,
  -3.009946878517199e-11,  -2.336410683287251e-11,  -2.541438619649493e-13,   7.799526732352041e-15,   2.149935678821179e-16,  -1.321281412419574e-18,  -1.273062387770367e-19,
  -8.876961709585848e-22,   5.702511454898299e-23,   1.337972034485629e+00,  -1.544801342156445e-02,  -1.326996574804403e-04,   1.797233870297991e-06,   5.724657978005262e-08,
  -3.114784455157143e-11,  -2.332062156033208e-11,  -2.526237568398646e-13,   7.787359074482184e-15,   2.136195214111315e-16,  -1.332256131554066e-18,  -1.264310236640594e-19,
  -8.669655490249979e-22,   5.668830033412053e-23,   1.337946380101979e+00,  -1.544696659894472e-02,  -1.326332224735562e-04,   1.797167788436400e-06,   5.717896712868144e-08,
  -3.216356582129968e-11,  -2.327842868461745e-11,  -2.511512032672890e-13,   7.775515980648501e-15,   2.122886785680418e-16,  -1.342823862598977e-18,  -1.255830567378012e-19,
  -8.469483392322681e-22,   5.636122284442024e-23,   1.337925716364385e+00,  -1.544612330238927e-02,  -1.325797223315503e-04,   1.797114079078920e-06,   5.712452900452386e-08,
  -3.298036936383734e-11,  -2.324445434786055e-11,  -2.499671788596862e-13,   7.765953269778784e-15,   2.112187572757356e-16,  -1.351275415625780e-18,  -1.249011471903063e-19,
  -8.308997036983714e-22,   5.609766261542194e-23,   1.337912063652378e+00,  -1.544556607203053e-02,  -1.325443797084670e-04,   1.797078356694881e-06,   5.708857182401176e-08,
  -3.351939016215511e-11,  -2.322201240520671e-11,  -2.491858949648559e-13,   7.759623636358430e-15,   2.105128428625665e-16,  -1.356829929188123e-18,  -1.244511419096189e-19,
  -8.203326515343812e-22,   5.592347351186834e-23,   1.337905052800803e+00,  -1.544527990912406e-02,  -1.325262324614484e-04,   1.797059939777646e-06,   5.707011059406227e-08,
  -3.379598419247313e-11,  -2.321048977516334e-11,  -2.487850077258475e-13,   7.756369746437646e-15,   2.101506528930760e-16,  -1.359673138085873e-18,  -1.242202246497818e-19,
  -8.149175746824542e-22,   5.583400912274147e-23,   1.337902612684417e+00,  -1.544518030775027e-02,  -1.325199166045480e-04,   1.797053518180096e-06,   5.706368571068987e-08,
  -3.389222043521155e-11,  -2.320647959753564e-11,  -2.486455292657928e-13,   7.755236672430437e-15,   2.100246420118874e-16,  -1.360661263891386e-18,  -1.241398807562309e-19,
  -8.130346543120760e-22,   5.580286866698495e-23,   1.337902225475099e+00,  -1.544516450239568e-02,  -1.325189143868121e-04,   1.797052498618902e-06,   5.706266620420993e-08,
  -3.390749014772595e-11,  -2.320584325558433e-11,  -2.486233985189203e-13,   7.755056844148645e-15,   2.100046483198012e-16,  -1.360817995659508e-18,  -1.241271326623288e-19,
  -8.127359484183579e-22,   5.579792703223890e-23,   1.706778527893352e+00,  -8.840610638740219e-03,  -1.644151391795325e-04,  -1.775194110356234e-06,   5.179758893235550e-09,
   7.023132743757941e-10,   1.511696112000875e-11,   9.706830611541354e-14,  -3.923359227038384e-15,  -1.454265470009349e-16,  -2.057294139168977e-18,   1.318551999780037e-20,
   1.340162272130664e-21,   2.968627021663472e-23,   1.706763120095372e+00,  -8.841107586210168e-03,  -1.644121063443172e-04,  -1.774534159240379e-06,   5.200892972932948e-09,
   7.024966069017135e-10,   1.510648942554690e-11,   9.657950983419618e-14,  -3.931770360494847e-15,  -1.453503953620196e-16,  -2.048962994185317e-18,   1.339632274607618e-20,
   1.341039736325195e-21,   2.957289017959750e-23,   1.706735933038389e+00,  -8.841984306685563e-03,  -1.644067452232113e-04,  -1.773369527755221e-06,   5.238172349758112e-09,
   7.028193186741875e-10,   1.508799416786502e-11,   9.571723602556934e-14,  -3.946583330340207e-15,  -1.452151473507953e-16,  -2.034258429436654e-18,   1.376760987488598e-20,
   1.342562152180267e-21,   2.937256159598129e-23,   1.706703058576750e+00,  -8.843044188702338e-03,  -1.644002460724884e-04,  -1.771961009118296e-06,   5.283230428747752e-09,
   7.032082131650843e-10,   1.506559921636977e-11,   9.467493341878261e-14,  -3.964446544358711e-15,  -1.450501101834681e-16,  -2.016470562299698e-18,   1.421541774131870e-20,
   1.344358990695915e-21,   2.912986839052715e-23,   1.706671145056957e+00,  -8.844072833878525e-03,  -1.643939196133762e-04,  -1.770593399291932e-06,   5.326950503111247e-09,
   7.035843506217318e-10,   1.504382692091498e-11,   9.366347164813634e-14,  -3.981736741900750e-15,  -1.448883331286148e-16,  -1.999195243790076e-18,   1.464892943563307e-20,
   1.346057231796897e-21,   2.889379438336040e-23,   1.706645436255061e+00,  -8.844901303626534e-03,  -1.643888107826651e-04,  -1.769491495915953e-06,   5.362155388780102e-09,
   7.038863630690811e-10,   1.502626479319474e-11,   9.284893035585931e-14,  -3.995628878019933e-15,  -1.447568903492701e-16,  -1.985273417964285e-18,   1.499729116348623e-20,
   1.347392328934914e-21,   2.870328077478512e-23,   1.706628448490983e+00,  -8.845448646962004e-03,  -1.643854289287352e-04,  -1.768763292412109e-06,   5.385410586381059e-09,
   7.040854384672696e-10,   1.501464897738964e-11,   9.231083325686809e-14,  -4.004790619630484e-15,  -1.446694889584848e-16,  -1.976071681134889e-18,   1.522705619810166e-20,
   1.348258406079756e-21,   2.857722952469776e-23,   1.706619724509028e+00,  -8.845729704660986e-03,  -1.643836903205092e-04,  -1.768389298695737e-06,   5.397350902861329e-09,
   7.041875219862379e-10,   1.500868027847512e-11,   9.203453723004289e-14,  -4.009490065232441e-15,  -1.446244353518763e-16,  -1.971345400528289e-18,   1.534491965293555e-20,
   1.348698193340313e-21,   2.851244590207886e-23,   1.706616688054820e+00,  -8.845827524703306e-03,  -1.643830848852029e-04,  -1.768259122561869e-06,   5.401506466699303e-09,
   7.042230290165764e-10,   1.500660227370707e-11,   9.193837665779351e-14,  -4.011124867145210e-15,  -1.446087271701398e-16,  -1.969700256735674e-18,   1.538592210437290e-20,
   1.348850472089677e-21,   2.848988938413137e-23,   1.706616206211717e+00,  -8.845843047175421e-03,  -1.643829887968688e-04,  -1.768238465203101e-06,   5.402165879755735e-09,
   7.042286623504761e-10,   1.500627249712810e-11,   9.192311762190044e-14,  -4.011384245765915e-15,  -1.446062332231105e-16,  -1.969439189457673e-18,   1.539242763147578e-20,
   1.348874598979678e-21,   2.848630959670346e-23,   1.941618162317463e+00,  -2.018398819980320e-03,  -5.071896561038651e-05,  -1.083460301685324e-06,  -2.037021983541025e-08,
  -3.343692441421430e-10,  -4.525317561283429e-12,  -3.989978664949327e-14,   2.058481002272116e-16,   2.090241787436319e-17,   6.349909700559911e-19,   1.397746691296583e-20,
   2.399073552519544e-22,   2.813829294413513e-24,   1.941613384349142e+00,  -2.018704649168625e-03,  -5.073045971321020e-05,  -1.083774421808236e-06,  -2.037657640467868e-08,
  -3.344466400501371e-10,  -4.524720755612237e-12,  -3.982733929280744e-14,   2.085746193928664e-16,   2.097525831650854e-17,   6.364734637709491e-19,   1.399734709540059e-20,
   2.398698730622259e-22,   2.801304897130159e-24,   1.941604952668396e+00,  -2.019244361529162e-03,  -5.075074414400588e-05,  -1.084328750347478e-06,  -2.038779196672438e-08,
  -3.345830894515010e-10,  -4.523661834938834e-12,  -3.969930436115145e-14,   2.133906883429689e-16,   2.110386904597046e-17,   6.390891272111808e-19,   1.403235072472456e-20,
   2.398008872211066e-22,   2.779145613561969e-24,   1.941594755488511e+00,  -2.019897110166128e-03,  -5.077527724841711e-05,  -1.084999150265741e-06,  -2.040135273847781e-08,
  -3.347478859881900e-10,  -4.522371398541457e-12,  -3.954414124773763e-14,   2.192229967338862e-16,   2.125952717660478e-17,   6.422516303627785e-19,   1.407454890956898e-20,
   2.397126083805162e-22,   2.752248340464296e-24,   1.941584854670305e+00,  -2.020530915728992e-03,  -5.079909874896260e-05,  -1.085650067464659e-06,  -2.041451603248577e-08,
  -3.349076583787287e-10,  -4.521108206666060e-12,  -3.939315334557050e-14,   2.248939753598541e-16,   2.141078441792558e-17,   6.453213179183561e-19,   1.411537921990842e-20,
   2.396218133132389e-22,   2.726029975824148e-24,   1.941576877573093e+00,  -2.021041593315634e-03,  -5.081829275660497e-05,  -1.086174512758934e-06,  -2.042511929796091e-08,
  -3.350362188246556e-10,  -4.520083095514318e-12,  -3.927126264050783e-14,   2.294689433875103e-16,   2.153274042955146e-17,   6.477939115382369e-19,   1.414817467076569e-20,
   2.395450150559850e-22,   2.704832088724430e-24,   1.941571605897585e+00,  -2.021379085049577e-03,  -5.083097763458617e-05,  -1.086521093499662e-06,  -2.043212529819809e-08,
  -3.351210956971884e-10,  -4.519402045329867e-12,  -3.919059363484977e-14,   2.324951838011048e-16,   2.161337819200078e-17,   6.494276035785554e-19,   1.416979777889716e-20,
   2.394924769582117e-22,   2.690787309828010e-24,   1.941568898469317e+00,  -2.021552417146101e-03,  -5.083749248910760e-05,  -1.086699090617606e-06,  -2.043572307542391e-08,
  -3.351646612601069e-10,  -4.519051156371330e-12,  -3.914912732412068e-14,   2.340502873921506e-16,   2.165480542118502e-17,   6.502665342902650e-19,   1.418088755793857e-20,
   2.394649418463580e-22,   2.683563011189750e-24,   1.941567956096945e+00,  -2.021612749189392e-03,  -5.083976013347063e-05,  -1.086761045946973e-06,  -2.043697529255482e-08,
  -3.351798210263356e-10,  -4.518928845176652e-12,  -3.913468839832379e-14,   2.345917121420469e-16,   2.166922707425894e-17,   6.505585240465204e-19,   1.418474511170383e-20,
   2.394552697247741e-22,   2.681046675354885e-24,   1.941567806554139e+00,  -2.021622323159136e-03,  -5.084011998165341e-05,  -1.086770877490038e-06,  -2.043717400111407e-08,
  -3.351822265002404e-10,  -4.518909427477093e-12,  -3.913239684546127e-14,   2.346776362323867e-16,   2.167151571189782e-17,   6.506048584296890e-19,   1.418535714098194e-20,
   2.394537307010179e-22,   2.680647279555375e-24,   1.922858956948161e-02,  -5.958566386896752e-04,   1.372149016204606e-05,  -2.776900096750159e-07,   5.185762759253101e-09,
  -9.122157967437749e-11,   1.520805365588484e-12,  -2.407999378169946e-14,   3.587961813122392e-16,  -4.988308155813804e-18,   6.146874821394682e-20,  -6.370696888767651e-22,
   3.808087638201584e-24,   9.816673413992215e-26,   1.922988183701328e-02,  -5.959350415828291e-04,   1.372441928910019e-05,  -2.777759308602432e-07,   5.187912597627195e-09,
  -9.126925639764036e-11,   1.521752576493959e-12,  -2.409691404366017e-14,   3.590562229249660e-16,  -4.991563920306981e-18,   6.149132278737024e-20,  -6.363254696830149e-22,
   3.787063881002341e-24,   9.863722954635994e-26,   1.923216228814406e-02,  -5.960734044396843e-04,   1.372958876574281e-05,  -2.779275765674002e-07,   5.191707106364878e-09,
  -9.135340985144506e-11,   1.523424500461615e-12,  -2.412677902446551e-14,   3.595151469980333e-16,  -4.997305620869625e-18,   6.153104797766098e-20,  -6.350094163916956e-22,
   3.749764460704951e-24,   9.947259492740895e-26,   1.923492021727234e-02,  -5.962407479119248e-04,   1.373584143347368e-05,  -2.781110102971483e-07,   5.196297317504826e-09,
  -9.145521536804792e-11,   1.525447155941943e-12,  -2.416290726877470e-14,   3.600702131689747e-16,  -5.004243172122874e-18,   6.157889925592198e-20,  -6.334131215397172e-22,
   3.704316090306827e-24,   1.004915336012577e-25,   1.923759796853822e-02,  -5.964032372796648e-04,   1.374191317619288e-05,  -2.782891496567428e-07,   5.200755353542559e-09,
  -9.155409485796377e-11,   1.527411706863183e-12,  -2.419799584264162e-14,   3.606091978970685e-16,  -5.010972388077718e-18,   6.162515798875650e-20,  -6.318582985425150e-22,
   3.659833852893235e-24,   1.014899137312969e-25,   1.923975541779006e-02,  -5.965341618425820e-04,   1.374680575531212e-05,  -2.784327030434607e-07,   5.204348078735626e-09,
  -9.163378561698394e-11,   1.528995034397123e-12,  -2.422627412814541e-14,   3.610434942658438e-16,  -5.016389309268888e-18,   6.166228346482412e-20,  -6.306020319361658e-22,
   3.623740401183686e-24,   1.023007896218062e-25,   1.924118116268477e-02,  -5.966206868223637e-04,   1.375003930254016e-05,  -2.785275834031246e-07,   5.206722767955487e-09,
  -9.168646085812246e-11,   1.530041617121844e-12,  -2.424496548851763e-14,   3.613305171069498e-16,  -5.019966729386313e-18,   6.168674653773337e-20,  -6.297700836272215e-22,
   3.599763629722913e-24,   1.028398278260257e-25,   1.924191339447473e-02,  -5.966651253627312e-04,   1.375170007494221e-05,  -2.785763160719530e-07,   5.207942494952786e-09,
  -9.171351737525942e-11,   1.530579195088685e-12,  -2.425456611947910e-14,   3.614779317506542e-16,  -5.021803291285417e-18,   6.169928817123936e-20,  -6.293422708860336e-22,
   3.587411181501506e-24,   1.031176467973198e-25,   1.924216826139111e-02,  -5.966805932123571e-04,   1.375227815242424e-05,  -2.785932790483601e-07,   5.208367065612347e-09,
  -9.172293548135412e-11,   1.530766321163501e-12,  -2.425790798127770e-14,   3.615292431028621e-16,  -5.022442425584898e-18,   6.170365000186708e-20,  -6.291932762562894e-22,
   3.583105553874743e-24,   1.032145029176668e-25,   1.924220870558995e-02,  -5.966830477759634e-04,   1.375236988680429e-05,  -2.785959708924950e-07,   5.208434440719539e-09,
  -9.172443004484459e-11,   1.530796016308159e-12,  -2.425843830174003e-14,   3.615373856186224e-16,  -5.022543842747665e-18,   6.170434200282033e-20,  -6.291696285618900e-22,
   3.582422013610155e-24,   1.032298801822350e-25,   1.701991747771292e-01,  -4.943083948070017e-03,   9.877757988626278e-05,  -1.523827621719133e-06,   1.660417403256385e-08,
  -4.934554640980833e-11,  -3.250470632893421e-12,   1.026126686104570e-13,  -1.840936212540652e-15,   1.836599878197229e-17,   8.583417191783433e-20,  -9.076576747262348e-21,
   2.360639112008287e-22,  -3.287801244418707e-24,   1.702084538531074e-01,  -4.943512680304827e-03,   9.878689356130063e-05,  -1.523872175506809e-06,   1.659954603446024e-08,
  -4.914256481652157e-11,  -3.255294480395284e-12,   1.026734059929491e-13,  -1.840526765020104e-15,   1.831827407011571e-17,   8.730482746945537e-20,  -9.100358277371110e-21,
   2.362845297568128e-22,  -3.283198108404913e-24,   1.702248276356386e-01,  -4.944269194979433e-03,   9.880332555778735e-05,  -1.523950636360740e-06,   1.659137434728279e-08,
  -4.878430399677369e-11,  -3.263805332772462e-12,   1.027804464319381e-13,  -1.839799235613127e-15,   1.823396364311386e-17,   8.990089793435774e-20,  -9.142292708380488e-21,
   2.366707184540579e-22,  -3.274995069666234e-24,   1.702446281937904e-01,  -4.945183997465766e-03,   9.882319167057543e-05,  -1.524045247716551e-06,   1.658148365862501e-08,
  -4.835092661066728e-11,  -3.274095200295403e-12,   1.029096562513943e-13,  -1.838910881331806e-15,   1.813184513432555e-17,   9.304191741290339e-20,  -9.192951428232518e-21,
   2.371324225694821e-22,  -3.264938378745927e-24,   1.702638514950043e-01,  -4.946072089507633e-03,   9.884247354241744e-05,  -1.524136817897462e-06,   1.657187210954310e-08,
  -4.793003918957216e-11,  -3.284082797064682e-12,   1.030348554465117e-13,  -1.838039454592321e-15,   1.803253292507547e-17,   9.609306051627527e-20,  -9.242078471989498e-21,
   2.375751083224263e-22,  -3.255031754102499e-24,   1.702793384406714e-01,  -4.946787537512757e-03,   9.885800403868063e-05,  -1.524210387211793e-06,   1.656412212111044e-08,
  -4.759085453745954e-11,  -3.292127501667572e-12,   1.031355454153060e-13,  -1.837330973960675e-15,   1.795240132126978e-17,   9.855237043376611e-20,  -9.281617339686598e-21,
   2.379277689204164e-22,  -3.246948251161645e-24,   1.702895723811589e-01,  -4.947260298972486e-03,   9.886826497715894e-05,  -1.524258903328084e-06,   1.655899761546462e-08,
  -4.736666708300413e-11,  -3.297442721909383e-12,   1.032019967997946e-13,  -1.836859653523307e-15,   1.789938964315161e-17,   1.001780951074831e-19,  -9.307725566879318e-21,
   2.381588611887433e-22,  -3.241556516855683e-24,   1.702948281361699e-01,  -4.947503086507005e-03,   9.887353404648846e-05,  -1.524283788618756e-06,   1.655636486931163e-08,
  -4.725151746765721e-11,  -3.300172162735285e-12,   1.032360971587140e-13,  -1.836616627678134e-15,   1.787214639857033e-17,   1.010131847157384e-19,  -9.321127689923326e-21,
   2.382769382912158e-22,  -3.238772060701317e-24,   1.702966574716251e-01,  -4.947587591234751e-03,   9.887536792847214e-05,  -1.524292445386694e-06,   1.655544834799176e-08,
  -4.721143562452601e-11,  -3.301122141047484e-12,   1.032479620230295e-13,  -1.836531884233492e-15,   1.786266107992161e-17,   1.013038774184609e-19,  -9.325791511751218e-21,
   2.383179406132267e-22,  -3.237800431991869e-24,   1.702969477630024e-01,  -4.947601000985605e-03,   9.887565893715999e-05,  -1.524293818869358e-06,   1.655530290061469e-08,
  -4.720507504729945e-11,  -3.301272888165312e-12,   1.032498446199741e-13,  -1.836518429206268e-15,   1.786115574533009e-17,   1.013500078701111e-19,  -9.326531552806016e-21,
   2.383244425835780e-22,  -3.237646130507520e-24,   4.563108632387238e-01,  -1.149683049251596e-02,   1.594683353645234e-04,  -6.327495433180010e-07,  -2.844702192208325e-08,
   7.176462216638167e-10,  -4.428739367088457e-12,  -1.720982893851653e-13,   5.219423017989505e-15,  -4.087348098764758e-17,  -1.322761024072172e-18,   4.543538134789409e-20,
  -4.137131410545094e-22,  -1.014679203262999e-23,   4.563257811745638e-01,  -1.149700609391839e-02,   1.594522997847401e-04,  -6.320796195800996e-07,  -2.845308936516409e-08,
   7.173053187536795e-10,  -4.415155450390005e-12,  -1.722302203936855e-13,   5.213766937570722e-15,  -4.064221199583868e-17,  -1.325142789176986e-18,   4.535851676969675e-20,
  -4.098538721032848e-22,  -1.019580748893814e-23,   4.563521028811828e-01,  -1.149731579267694e-02,   1.594240020145327e-04,  -6.308977890581206e-07,  -2.846377997994104e-08,
   7.167035819870505e-10,  -4.391198531597928e-12,  -1.724623823818302e-13,   5.203778681513956e-15,  -4.023445913463652e-17,  -1.329326159409370e-18,   4.522260306683442e-20,
  -4.030551621505940e-22,  -1.028181645867719e-23,   4.563839292797437e-01,  -1.149769002343617e-02,   1.593897793857593e-04,  -6.294691511639322e-07,  -2.847668079357885e-08,
   7.159756011205346e-10,  -4.362250239629501e-12,  -1.727420375396459e-13,   5.191687157572827e-15,  -3.974195482994585e-17,  -1.334351879390527e-18,   4.505777085238659e-20,
  -3.948529081712518e-22,  -1.038500301030481e-23,   4.564148236074207e-01,  -1.149805304765990e-02,   1.593565517735759e-04,  -6.280827195245805e-07,  -2.848917705487680e-08,
   7.152685197180536e-10,  -4.334169399223125e-12,  -1.730123942592335e-13,   5.179934712356519e-15,  -3.926442219750678e-17,  -1.339196403463602e-18,   4.489725031964987e-20,
  -3.869100217751614e-22,  -1.048432144802667e-23,   4.564397101074125e-01,  -1.149834530003133e-02,   1.593297805516030e-04,  -6.269661617063773e-07,  -2.849922409563152e-08,
   7.146986395249391e-10,  -4.311563369263839e-12,  -1.732293827007870e-13,   5.170456959401825e-15,  -3.888014585728262e-17,  -1.343074506019900e-18,   4.476757750021717e-20,
  -3.805254740181602e-22,  -1.056372088809443e-23,   4.564561538951866e-01,  -1.149853831962098e-02,   1.593120888981311e-04,  -6.262285235104183e-07,  -2.850585331745858e-08,
   7.143219435356703e-10,  -4.296633315388845e-12,  -1.733723696888368e-13,   5.164189282619734e-15,  -3.862642772372607e-17,  -1.345625064435726e-18,   4.468171666118477e-20,
  -3.763136046812372e-22,  -1.061588832542338e-23,   4.564645983294677e-01,  -1.149863741486285e-02,   1.593030028600560e-04,  -6.258497615184185e-07,  -2.850925474602057e-08,
   7.141284521841314e-10,  -4.288968372080226e-12,  -1.734456782055921e-13,   5.160969004435479e-15,  -3.849619472844234e-17,  -1.346931183051786e-18,   4.463756893313598e-20,
  -3.741527509706199e-22,  -1.064258664993391e-23,   4.564675374543322e-01,  -1.149867190116466e-02,   1.592998402973507e-04,  -6.257179379815052e-07,  -2.851043816779091e-08,
   7.140610993940480e-10,  -4.286300893164465e-12,  -1.734711744650599e-13,   5.159847914450288e-15,  -3.845087604165158e-17,  -1.347385198399742e-18,   4.462219431597459e-20,
  -3.734009872409143e-22,  -1.065186458473687e-23,   4.564680038511745e-01,  -1.149867737344247e-02,   1.592993384382204e-04,  -6.256970197835439e-07,  -2.851062593790354e-08,
   7.140504111323470e-10,  -4.285877618792067e-12,  -1.734752194474489e-13,   5.159670001395341e-15,  -3.844368506978152e-17,  -1.347457216321891e-18,   4.461975416815695e-20,
  -3.732817088893874e-22,  -1.065333616936241e-23,   8.432699526033313e-01,  -1.655137256178160e-02,   7.982756152130938e-05,   2.679902830471430e-06,  -4.130606496490219e-08,
  -6.175891292316925e-10,   2.082876159033644e-11,   8.798880860081338e-14,  -1.006073116173589e-14,   4.462503069977391e-17,   4.436827275503692e-18,  -6.302628098165781e-20,
  -1.704383337195099e-21,   5.018113279642806e-23,   8.432773901123608e-01,  -1.655062087444430e-02,   7.980449033827856e-05,   2.679325319368634e-06,  -4.127708182452504e-08,
  -6.174136522013754e-10,   2.080273094920832e-11,   8.813135316415966e-14,  -1.004234470318571e-14,   4.431361190544645e-17,   4.426489024353306e-18,  -6.267530611736186e-20,
  -1.699893929474227e-21,   4.988943785252230e-23,   8.432905119752072e-01,  -1.654929464208649e-02,   7.976379405448265e-05,   2.678306426360362e-06,  -4.122597022846757e-08,
  -6.171037960081450e-10,   2.075683851145410e-11,   8.838203070833008e-14,  -1.000993678381147e-14,   4.376556357581408e-17,   4.408269531433479e-18,  -6.205771907824219e-20,
  -1.691978570657484e-21,   4.937626194569718e-23,   8.433063761077708e-01,  -1.654769117241379e-02,   7.971460613982071e-05,   2.677074599356775e-06,  -4.116421599935226e-08,
  -6.167287332048045e-10,   2.070141139708322e-11,   8.868371530789957e-14,  -9.970808877150276e-15,   4.310533374338675e-17,   4.386276692117697e-18,  -6.131384195142860e-20,
  -1.682417966921066e-21,   4.875831750930931e-23,   8.433217736298459e-01,  -1.654613478705084e-02,   7.966687887867884e-05,   2.675879003300465e-06,  -4.110431886398890e-08,
  -6.163642305154644e-10,   2.064767329878059e-11,   8.897508375924763e-14,  -9.932887046976221e-15,   4.246698073277905e-17,   4.364966573162624e-18,  -6.059474437480813e-20,
  -1.673147986853166e-21,   4.816113597322455e-23,   8.433341754505643e-01,  -1.654488115177107e-02,   7.962844725787478e-05,   2.674916018925183e-06,  -4.105610431526446e-08,
  -6.160703073943432e-10,   2.060443239679280e-11,   8.920873284063411e-14,  -9.902382708353214e-15,   4.195458081530110e-17,   4.347828165146297e-18,  -6.001762525663890e-20,
  -1.665688334235699e-21,   4.768198944588750e-23,   8.433423692646556e-01,  -1.654405285441908e-02,   7.960306056949777e-05,   2.674279780389178e-06,  -4.102426349947514e-08,
  -6.158759492674574e-10,   2.057588394931724e-11,   8.936259933206554e-14,  -9.882247996217737e-15,   4.161689961478396e-17,   4.336517477582967e-18,  -5.963733868894094e-20,
  -1.660763119675304e-21,   4.736632332959665e-23,   8.433465768437954e-01,  -1.654362750961103e-02,   7.959002583851510e-05,   2.673953067563474e-06,  -4.100791743570658e-08,
  -6.157760941641763e-10,   2.056123048830395e-11,   8.944145509084239e-14,  -9.871914661279216e-15,   4.144376321202367e-17,   4.330713247009229e-18,  -5.944237175276930e-20,
  -1.658235023533452e-21,   4.720450558718859e-23,   8.433480412766874e-01,  -1.654347946851724e-02,   7.958548938664287e-05,   2.673839356329348e-06,  -4.100222894872955e-08,
  -6.157413318567131e-10,   2.055613141587843e-11,   8.946887578033102e-14,  -9.868319132132393e-15,   4.138354589339371e-17,   4.328693723569105e-18,  -5.937456396673857e-20,
  -1.657355293744514e-21,   4.714822987261993e-23,   8.433482736594763e-01,  -1.654345597662734e-02,   7.958476953346239e-05,   2.673821312119903e-06,  -4.100132630739591e-08,
  -6.157358152334274e-10,   2.055532232021739e-11,   8.947322584264727e-14,  -9.867748622567630e-15,   4.137399234100657e-17,   4.328373285868745e-18,  -5.936380628418636e-20,
  -1.657215702111035e-21,   4.713930189525165e-23,   1.274263378213844e+00,  -1.641170649748385e-02,  -1.059003203770584e-04,   2.678911992551303e-06,   5.080451073232108e-08,
  -6.420560648761157e-10,  -2.605499113694834e-11,   9.741802770637392e-14,   1.329018233382796e-14,   5.124523783548969e-17,  -6.633345880066054e-18,  -8.154713217674500e-20,
   3.011705639673274e-21,   7.211200768239449e-23,   1.274253507030929e+00,  -1.641095516901791e-02,  -1.058719472085577e-04,   2.678311702758707e-06,   5.076827599309320e-08,
  -6.418617106513528e-10,  -2.602066859520076e-11,   9.758060128311190e-14,   1.326278214491953e-14,   5.084416408838794e-17,  -6.615114389012398e-18,  -8.104462057613230e-20,
   3.002980711104906e-21,   7.165873282066604e-23,   1.274236091311420e+00,  -1.640962957507502e-02,  -1.058218987811778e-04,   2.677252630875957e-06,   5.070437824397530e-08,
  -6.415185144221491e-10,  -2.596016405181047e-11,   9.786637859894427e-14,   1.321449625711940e-14,   5.013854445256948e-17,  -6.582988381211946e-18,  -8.016059111963946e-20,
   2.987598500963894e-21,   7.086149257980373e-23,   1.274215035681992e+00,  -1.640802688621176e-02,  -1.057614077668107e-04,   2.675972243856656e-06,   5.062717888717028e-08,
  -6.411030840153034e-10,  -2.588710032291293e-11,   9.821009520076658e-14,   1.315621435937543e-14,   4.928884285754975e-17,  -6.544215812756794e-18,  -7.909613868042559e-20,
   2.969020508376082e-21,   6.990183280489408e-23,   1.274194599057014e+00,  -1.640647126809023e-02,  -1.057027135254937e-04,   2.674729532472031e-06,   5.055230465171929e-08,
  -6.406993385360289e-10,  -2.581627488800804e-11,   9.854183866486945e-14,   1.309974608288838e-14,   4.846766591547535e-17,  -6.506654077546672e-18,  -7.806751243366085e-20,
   2.951008792704666e-21,   6.897477554389540e-23,   1.274178138310800e+00,  -1.640521825751220e-02,  -1.056554512537015e-04,   2.673728611168059e-06,   5.049203674289365e-08,
  -6.403737630333242e-10,  -2.575929296376266e-11,   9.880770705124121e-14,   1.305433525571015e-14,   4.780877972836896e-17,  -6.476450680048908e-18,  -7.724224118961460e-20,
   2.936515669085008e-21,   6.823121032305250e-23,   1.274167262680830e+00,  -1.640439037619350e-02,  -1.056242314865895e-04,   2.673067313681913e-06,   5.045223715012776e-08,
  -6.401584706242202e-10,  -2.572167658411674e-11,   9.898271394344679e-14,   1.302436737146758e-14,   4.737469095384841e-17,  -6.456520141061341e-18,  -7.669856621873414e-20,
   2.926947159660195e-21,   6.774146788344353e-23,   1.274161677938150e+00,  -1.640396524604073e-02,  -1.056082018268430e-04,   2.672727734700651e-06,   5.043180568735960e-08,
  -6.400478589242343e-10,  -2.570236998029167e-11,   9.907238015189482e-14,   1.300898941457918e-14,   4.715216441695450e-17,  -6.446293303550931e-18,  -7.641987245292537e-20,
   2.922035840494159e-21,   6.749045326336284e-23,   1.274159734183171e+00,  -1.640381727981922e-02,  -1.056026230638627e-04,   2.672609545731415e-06,   5.042469552850405e-08,
  -6.400093517566526e-10,  -2.569565192357398e-11,   9.910355617699500e-14,   1.300363888327281e-14,   4.707477545866534e-17,  -6.442735103702479e-18,  -7.632295155311493e-20,
   2.920326820193522e-21,   6.740316350689192e-23,   1.274159425739152e+00,  -1.640379379981809e-02,  -1.056017378150718e-04,   2.672590790988354e-06,   5.042356730112428e-08,
  -6.400032408316159e-10,  -2.569458594515383e-11,   9.910850181104179e-14,   1.300278991818026e-14,   4.706249790749435e-17,  -6.442170530217141e-18,  -7.630757538586868e-20,
   2.920055641649100e-21,   6.738931553468437e-23,   1.668654090241172e+00,  -1.023853326820491e-02,  -1.846910660844735e-04,  -1.559633620734255e-06,   2.297849069708679e-08,
   1.078195440386733e-09,   1.519004360656324e-11,  -1.256329274503866e-13,  -1.028723814546816e-14,  -1.917235835474673e-16,   4.686404346946501e-19,   1.119584678119638e-19,
   2.572900385350149e-21,   4.984776170340640e-24,   1.668636801675501e+00,  -1.023896836205362e-02,  -1.846780221058913e-04,  -1.558624988182984e-06,   2.299953301358797e-08,
   1.077938082115338e-09,   1.516309218186681e-11,  -1.262649250497338e-13,  -1.028476745778383e-14,  -1.911456334361879e-16,   4.840689601241584e-19,   1.119781687728346e-19,
   2.562308152639734e-21,   4.679254704735657e-24,   1.668606296737208e+00,  -1.023973586175680e-02,  -1.846549962522319e-04,  -1.556845439382549e-06,   2.303663172075060e-08,
   1.077482965240336e-09,   1.511554153918481e-11,  -1.273785085142525e-13,  -1.028035540506384e-14,  -1.901257658404110e-16,   5.112394791095545e-19,   1.120111333496607e-19,
   2.543611210393144e-21,   4.141510942554992e-24,   1.668569411558775e+00,  -1.024066353805613e-02,  -1.846271368730410e-04,  -1.554693930138397e-06,   2.308143937661118e-08,
   1.076930922621043e-09,   1.505805236789310e-11,  -1.287223607607495e-13,  -1.027493093717228e-14,  -1.888924244418562e-16,   5.440033610307552e-19,   1.120479341181109e-19,
   2.520991324164480e-21,   3.493575207500626e-24,   1.668533605866648e+00,  -1.024156369912418e-02,  -1.846000744435047e-04,  -1.552605639102083e-06,   2.312488290457725e-08,
   1.076393220274432e-09,   1.500225299846016e-11,  -1.300241167181432e-13,  -1.026957153390831e-14,  -1.876950128676143e-16,   5.757146484660634e-19,   1.120804619512423e-19,
   2.499020729041797e-21,   2.866991256781427e-24,   1.668504762557265e+00,  -1.024228856270538e-02,  -1.845782611114598e-04,  -1.550923595181413e-06,   2.315984106500533e-08,
   1.075958774060516e-09,   1.495730907357973e-11,  -1.310707647984778e-13,  -1.026518724343863e-14,  -1.867303229806915e-16,   6.011925321300527e-19,   1.121043797730964e-19,
   2.481313386855181e-21,   2.363959349081773e-24,   1.668485704044314e+00,  -1.024276739547874e-02,  -1.845638412848170e-04,  -1.549812256144439e-06,   2.318292151449132e-08,
   1.075671073555261e-09,   1.492761454106592e-11,  -1.317613774308724e-13,  -1.026225750873030e-14,  -1.860928403311072e-16,   6.179944062726539e-19,   1.121190668796771e-19,
   2.469608795406301e-21,   2.032415382572722e-24,   1.668475916781506e+00,  -1.024301325443635e-02,  -1.845564341697573e-04,  -1.549241569263005e-06,   2.319476846745221e-08,
   1.075523132060509e-09,   1.491236610083630e-11,  -1.321157327218305e-13,  -1.026074285485628e-14,  -1.857654527527537e-16,   6.266126239318140e-19,   1.121262642849328e-19,
   2.463596739821295e-21,   1.862414856575663e-24,   1.668472510266186e+00,  -1.024309882080063e-02,  -1.845538557620091e-04,  -1.549042942662590e-06,   2.319889095876178e-08,
   1.075471608871895e-09,   1.490705892088712e-11,  -1.322390203963521e-13,  -1.026021405944476e-14,  -1.856515009932541e-16,   6.296106258496598e-19,   1.121287145012442e-19,
   2.461504001206709e-21,   1.803286523642334e-24,   1.668471969700598e+00,  -1.024311239866726e-02,  -1.845534465902769e-04,  -1.549011423650799e-06,   2.319954509629764e-08,
   1.075463431389680e-09,   1.490621675304409e-11,  -1.322585821294930e-13,  -1.026013007065871e-14,  -1.856334183471930e-16,   6.300862892420882e-19,   1.121291007110077e-19,
   2.461171903533894e-21,   1.793905661213038e-24,   1.932642177878658e+00,  -2.482245713363731e-03,  -6.591681121298795e-05,  -1.469139478755723e-06,  -2.822663028566863e-08,
  -4.547344542419639e-10,  -5.394164695726963e-12,  -1.494442799539702e-14,   1.598243528050861e-15,   6.247531312940460e-17,   1.549340808365231e-18,   2.834504070469998e-20,
   3.276097641130571e-22,  -1.007496712493837e-24,   1.932635966230328e+00,  -2.482660410447371e-03,  -6.593273116039366e-05,  -1.469566006652842e-06,  -2.823416437363910e-08,
  -4.547604532101760e-10,  -5.389832842907908e-12,  -1.472977690601391e-14,   1.604842266911657e-15,   6.262104940308277e-17,   1.551295103125635e-18,   2.833476488655484e-20,
   3.260503075660539e-22,  -1.060013215455257e-24,   1.932625004460500e+00,  -2.483392247551228e-03,  -6.596082559170981e-05,  -1.470318640606703e-06,  -2.824745338425465e-08,
  -4.548059833581034e-10,  -5.382175100047921e-12,  -1.435062211000116e-14,   1.616492484211236e-15,   6.287815728815446e-17,   1.554735556510104e-18,   2.831631904113625e-20,
   3.232908736476375e-22,  -1.152812029161113e-24,   1.932611747293262e+00,  -2.484277359174298e-03,  -6.599480353134234e-05,  -1.471228765447409e-06,  -2.826351405092555e-08,
  -4.548604494569175e-10,  -5.372891189443133e-12,  -1.389146286623094e-14,   1.630591352353715e-15,   6.318897544517602e-17,   1.558882240673474e-18,   2.829347818870460e-20,
   3.199409196364174e-22,  -1.265251262538308e-24,   1.932598875288458e+00,  -2.485136784449295e-03,  -6.602779485427136e-05,  -1.472112331980918e-06,  -2.827909650368844e-08,
  -4.549127063857430e-10,  -5.363853294696881e-12,  -1.344500577644350e-14,   1.644290099729896e-15,   6.349062798309855e-17,   1.562893547558140e-18,   2.827074276769798e-20,
   3.166749945196787e-22,  -1.374641633086774e-24,   1.932588504209284e+00,  -2.485829251114080e-03,  -6.605437662374666e-05,  -1.472824145237472e-06,  -2.829164309203458e-08,
  -4.549543608304086e-10,  -5.356554394753921e-12,  -1.308483479640965e-14,   1.655334077544097e-15,   6.373357409443306e-17,   1.566114789911820e-18,   2.825202431297166e-20,
   3.140340809518334e-22,  -1.462934216904831e-24,   1.932581650421283e+00,  -2.486286881876183e-03,  -6.607194353175717e-05,  -1.473294510220527e-06,  -2.829993050033007e-08,
  -4.549816682536526e-10,  -5.351722551123395e-12,  -1.284659008566460e-14,   1.662635869434903e-15,   6.389407823787678e-17,   1.568238318561605e-18,   2.823945793026933e-20,
   3.122841499395904e-22,  -1.521359113319389e-24,   1.932578130437028e+00,  -2.486521916073297e-03,  -6.608096564381800e-05,  -1.473536068676635e-06,  -2.830418550483509e-08,
  -4.549956247505946e-10,  -5.349238427266986e-12,  -1.272416267516226e-14,   1.666386964139750e-15,   6.397649534873715e-17,   1.569327300387606e-18,   2.823294335225408e-20,
   3.113839724835654e-22,  -1.551388661490569e-24,   1.932576905236671e+00,  -2.486603724887533e-03,  -6.608410597828156e-05,  -1.473620145870324e-06,  -2.830566634263156e-08,
  -4.550004717403551e-10,  -5.348373368779739e-12,  -1.268153837989025e-14,   1.667692769885354e-15,   6.400517986875565e-17,   1.569706083260771e-18,   2.823066615657242e-20,
   3.110704179767583e-22,  -1.561844789758791e-24,   1.932576710812464e+00,  -2.486616706962535e-03,  -6.608460431113104e-05,  -1.473633487789635e-06,  -2.830590132381236e-08,
  -4.550012403830026e-10,  -5.348236075191499e-12,  -1.267477390669464e-14,   1.667899992902168e-15,   6.400973163521361e-17,   1.569766179145797e-18,   2.823030433465091e-20,
   3.110206498242953e-22,  -1.563504226450512e-24,   1.704542588851505e-02,  -4.981301331427335e-04,   1.083268641063141e-05,  -2.075379965353820e-07,   3.677769693844851e-09,
  -6.166597593347102e-11,   9.833937074588223e-13,  -1.504823620571508e-14,   2.173163498179083e-16,  -3.022426288522098e-18,   3.874379116646470e-20,  -3.781894805500701e-22,
   6.009085882641307e-24,  -1.727983720499680e-26,   1.704644561970060e-02,  -4.981887076597691e-04,   1.083476300003979e-05,  -2.075960588981462e-07,   3.679159380240739e-09,
  -6.169576527072301e-11,   9.839675649490900e-13,  -1.505848786404348e-14,   2.174809602054756e-16,  -3.024381520889320e-18,   3.878002601737103e-20,  -3.783220999356225e-22,
   5.988606400742645e-24,  -1.739811199313515e-26,   1.704824511066083e-02,  -4.982920766381581e-04,   1.083842781190091e-05,  -2.076985336077106e-07,   3.681612161209704e-09,
  -6.174834545968701e-11,   9.849804975358334e-13,  -1.507658244549439e-14,   2.177715412784300e-16,  -3.027832121345846e-18,   3.884386039762920e-20,  -3.785567674067841e-22,
   5.952509685491189e-24,  -1.760349375545995e-26,   1.705042134591003e-02,  -4.984170942293111e-04,   1.084286042821513e-05,  -2.078224859326778e-07,   3.684579211466897e-09,
  -6.181195401448379e-11,   9.862059468411768e-13,  -1.509847176246830e-14,   2.181231252764531e-16,  -3.032005584679375e-18,   3.892087483217538e-20,  -3.788416391245574e-22,
   5.908928406925985e-24,  -1.784619546568116e-26,   1.705253428183040e-02,  -4.985384829374352e-04,   1.084716467360291e-05,  -2.079428573579053e-07,   3.687460747067037e-09,
  -6.187373345712017e-11,   9.873962207751624e-13,  -1.511973112165847e-14,   2.184646568114094e-16,  -3.036058118656778e-18,   3.899545625503716e-20,  -3.791193321488488e-22,
   5.866690431114143e-24,  -1.807589893325069e-26,   1.705423663934050e-02,  -4.986362891541661e-04,   1.085063293341513e-05,  -2.080398561487487e-07,   3.689782916498401e-09,
  -6.192352321342554e-11,   9.883555407874335e-13,  -1.513686425653261e-14,   2.187399474987564e-16,  -3.039323511173825e-18,   3.905540718291452e-20,  -3.793438459747861e-22,
   5.832713884224978e-24,  -1.825671788311199e-26,   1.705536162666018e-02,  -4.987009261102876e-04,   1.085292509717939e-05,  -2.081039654906903e-07,   3.691317776971254e-09,
  -6.195643370166772e-11,   9.889896631556438e-13,  -1.514818889173988e-14,   2.189219316238698e-16,  -3.041481579434657e-18,   3.909495764590356e-20,  -3.794925914231364e-22,
   5.810287050156956e-24,  -1.837413221389086e-26,   1.705593939234526e-02,  -4.987341228627562e-04,   1.085410235650268e-05,  -2.081368931187602e-07,   3.692106128787445e-09,
  -6.197333799922993e-11,   9.893153836297482e-13,  -1.515400567449166e-14,   2.190154129565240e-16,  -3.042589960686624e-18,   3.911524890568373e-20,  -3.795690991207351e-22,
   5.798777273822951e-24,  -1.843379111639712e-26,   1.705614049389738e-02,  -4.987456777076593e-04,   1.085451213206261e-05,  -2.081483545839407e-07,   3.692380542160318e-09,
  -6.197922220223907e-11,   9.894287644977285e-13,  -1.515603042468655e-14,   2.190479537740755e-16,  -3.042975760446279e-18,   3.912230831392992e-20,  -3.795957473042731e-22,
   5.794772378519555e-24,  -1.845445425846835e-26,   1.705617240617740e-02,  -4.987475113219309e-04,   1.085457715873435e-05,  -2.081501733939749e-07,   3.692424088747231e-09,
  -6.198015596830857e-11,   9.894467569962239e-13,  -1.515635173252313e-14,   2.190531177332498e-16,  -3.043036982386532e-18,   3.912342839524661e-20,  -3.795999769031116e-22,
   5.794136913128395e-24,  -1.845772838801858e-26,   1.518977171558859e-01,  -4.221588851698241e-03,   8.204174923423411e-05,  -1.269429703919338e-06,   1.503809852965672e-08,
  -9.891718831920565e-11,  -1.101577358454967e-12,   5.433961522786652e-14,  -1.187928134211486e-15,   1.660123316813254e-17,  -1.168876307232449e-19,  -1.167326605572771e-21,
   1.055595111436375e-22,  -1.936464896785978e-24,   1.519054255173406e-01,  -4.221946201346261e-03,   8.205019917490152e-05,  -1.269521530784824e-06,   1.503651243323246e-08,
  -9.880931935755504e-11,  -1.104705346567569e-12,   5.439547046172931e-14,  -1.188400097365713e-15,   1.659465115728386e-17,  -1.162303184224543e-19,  -1.181754706430334e-21,
   1.056488161670802e-22,  -1.941380104909906e-24,   1.519190276855655e-01,  -4.222576771270074e-03,   8.206510849429519e-05,  -1.269683478245739e-06,   1.503371016112801e-08,
  -9.861889355964629e-11,  -1.110225725273100e-12,   5.449400942679355e-14,  -1.189230625620768e-15,   1.658297634076446e-17,  -1.150700270242122e-19,  -1.207241951406520e-21,
   1.058067828907509e-22,  -1.950009474318154e-24,   1.519354766693403e-01,  -4.223339298694248e-03,   8.208313575021605e-05,  -1.269879166150639e-06,   1.503031551876964e-08,
  -9.838847637595326e-11,  -1.116902718541125e-12,   5.461313218236963e-14,  -1.190231057846491e-15,   1.656875535456279e-17,  -1.136662157062399e-19,  -1.238110046554970e-21,
   1.059984520487712e-22,  -1.960369907816988e-24,   1.519514462063823e-01,  -4.224079584313629e-03,   8.210063498529124e-05,  -1.270068989187319e-06,   1.502701366466274e-08,
  -9.816463192875992e-11,  -1.123386396027222e-12,   5.472874123958204e-14,  -1.191198225601354e-15,   1.655484119817651e-17,  -1.123026072133482e-19,  -1.268126974756672e-21,
   1.061851996400014e-22,  -1.970349886368512e-24,   1.519643118804869e-01,  -4.224675975420390e-03,   8.211473119978961e-05,  -1.270221802507929e-06,   1.502434915191438e-08,
  -9.798419153789380e-11,  -1.128610826086761e-12,   5.482185046465671e-14,  -1.191974471672047e-15,   1.654355420095366e-17,  -1.112035184440121e-19,  -1.292344400122857e-21,
   1.063361226392271e-22,  -1.978333952231765e-24,   1.519728136915641e-01,  -4.225070073077859e-03,   8.212404526572327e-05,  -1.270322727082371e-06,   1.502258624559958e-08,
  -9.786490382675506e-11,  -1.132063653987226e-12,   5.488336362448276e-14,  -1.192485985005786e-15,   1.653605776653476e-17,  -1.104769740032237e-19,  -1.308364492992627e-21,
   1.064360838147648e-22,  -1.983582434137340e-24,   1.519771799029226e-01,  -4.225272465113109e-03,   8.212882834143448e-05,  -1.270374540674019e-06,   1.502168021489294e-08,
  -9.780362658866750e-11,  -1.133837037064423e-12,   5.491494993037561e-14,  -1.192748233508555e-15,   1.653219617263749e-17,  -1.101037700724431e-19,  -1.316597021820638e-21,
   1.064874906189656e-22,  -1.986269357326445e-24,   1.519786996226025e-01,  -4.225342910156121e-03,   8.213049311199496e-05,  -1.270392572320526e-06,   1.502136475212335e-08,
  -9.778229573223014e-11,  -1.134454309627642e-12,   5.492594325232442e-14,  -1.192839441752921e-15,   1.653085022782066e-17,  -1.099738589132099e-19,  -1.319463294440139e-21,
   1.065053946487678e-22,  -1.987203224786251e-24,   1.519789407821272e-01,  -4.225354088844722e-03,   8.213075728707547e-05,  -1.270395433573496e-06,   1.502131468728125e-08,
  -9.777891068841687e-11,  -1.134552263722227e-12,   5.492768771351354e-14,  -1.192853911933815e-15,   1.653063655557337e-17,  -1.099532431312194e-19,  -1.319918173496668e-21,
   1.065082363131974e-22,  -1.987351353045452e-24,   4.128174045544353e-01,  -1.025814690013329e-02,   1.495956631674606e-04,  -9.801726725765071e-07,  -1.545658152650846e-08,
   5.707697431492350e-10,  -7.182501427425576e-12,  -3.532173450061688e-14,   3.215667931813585e-15,  -6.068523860818779e-17,   1.530916326298778e-19,   2.144097572384712e-20,
  -4.602553314848138e-22,   4.442240598517571e-24,   4.128314115524860e-01,  -1.025842069067868e-02,   1.495869124631484e-04,  -9.796381917782488e-07,  -1.546658192619248e-08,
   5.706969987478574e-10,  -7.174049124075970e-12,  -3.552363103232965e-14,   3.216223167256161e-15,  -6.057355574629828e-17,   1.502692643453872e-19,   2.147043752255879e-20,
  -4.597153430511083e-22,   4.387250784836580e-24,   4.128561264475991e-01,  -1.025890367630575e-02,   1.495714671577299e-04,  -9.786951484174435e-07,  -1.548421812133377e-08,
   5.705683183884020e-10,  -7.159133771574776e-12,  -3.587957338030737e-14,   3.217193231296761e-15,  -6.037636915732654e-17,   1.452919383240046e-19,   2.152209848667476e-20,
  -4.587560939538506e-22,   4.290374134012362e-24,   4.128860108145723e-01,  -1.025948749950934e-02,   1.495527827742968e-04,  -9.775549066706107e-07,  -1.550552751232400e-08,
   5.704121685029242e-10,  -7.141096054849158e-12,  -3.630945854688846e-14,   3.218349782679550e-15,  -6.013772462649096e-17,   1.392780769230340e-19,   2.158401421910508e-20,
  -4.575852259816151e-22,   4.173492180648620e-24,   4.129150208379852e-01,  -1.026005404698004e-02,   1.495346361810905e-04,  -9.764480808418334e-07,  -1.552619703663483e-08,
   5.702600072372712e-10,  -7.123583366263655e-12,  -3.672623448506075e-14,   3.219455314063343e-15,  -5.990583978552337e-17,   1.334449520581755e-19,   2.164354237570579e-20,
  -4.564371583600348e-22,   4.060300148874117e-24,   4.129383900736197e-01,  -1.026051029407447e-02,   1.495200117083681e-04,  -9.755565089510473e-07,  -1.554283576656503e-08,
   5.701370173789299e-10,  -7.109473962201406e-12,  -3.706159010508518e-14,   3.220333577503342e-15,  -5.971888469327725e-17,   1.287494845137900e-19,   2.169108350995350e-20,
  -4.555041437861951e-22,   3.969311284344655e-24,   4.129538316260963e-01,  -1.026081169756008e-02,   1.495103452721082e-04,  -9.749674097373310e-07,  -1.555382428588474e-08,
   5.700555468940006e-10,  -7.100150034142584e-12,  -3.728299430037290e-14,   3.220907879635381e-15,  -5.959527416887169e-17,   1.256485845531646e-19,   2.172229537979834e-20,
  -4.548836472502713e-22,   3.909284067444436e-24,   4.129617614715810e-01,  -1.026096645902426e-02,   1.495053802148934e-04,  -9.746648901290259e-07,  -1.555946554308629e-08,
   5.700136457737640e-10,  -7.095361540134387e-12,  -3.739663629876695e-14,   3.221200944256009e-15,  -5.953177145822213e-17,   1.240566766344554e-19,   2.173826160296007e-20,
  -4.545637650723136e-22,   3.878487109234633e-24,   4.129645215061339e-01,  -1.026102032140451e-02,   1.495036519412369e-04,  -9.745595971653570e-07,  -1.556142873608665e-08,
   5.699990518166121e-10,  -7.093694827477837e-12,  -3.743618093918832e-14,   3.221302650898013e-15,  -5.950966513613024e-17,   1.235026866270673e-19,   2.174380883697558e-20,
  -4.544522319461305e-22,   3.867772705669497e-24,   4.129649594846187e-01,  -1.026102886844373e-02,   1.495033776813628e-04,  -9.745428887055468e-07,  -1.556174025362019e-08,
   5.699967354872093e-10,  -7.093430341546849e-12,  -3.744245567808200e-14,   3.221318776234062e-15,  -5.950615699544317e-17,   1.234147802290411e-19,   2.174468863405164e-20,
  -4.544345239124553e-22,   3.866072703372315e-24,   7.785285010862638e-01,  -1.579611265756369e-02,   1.077021617640443e-04,   1.947565203021276e-06,  -4.863713691967293e-08,
  -1.219603671095358e-10,   1.923416369704423e-11,  -1.804652823629430e-13,  -6.075499470137033e-15,   1.523155643121936e-16,   8.272174222887593e-19,  -8.031022813647018e-20,
   8.315531633888489e-22,   3.370590592890281e-23,   7.785385435316302e-01,  -1.579556531955040e-02,   1.076749549436828e-04,   1.947447953237777e-06,  -4.861027651754586e-08,
  -1.223076713174622e-10,   1.921829123616119e-11,  -1.799617325375184e-13,  -6.071856709156236e-15,   1.519108090761967e-16,   8.320261770466669e-19,  -8.006923592796239e-20,
   8.242339697689378e-22,   3.360648560461616e-23,   7.785562615290861e-01,  -1.579459956031431e-02,   1.076269603199103e-04,   1.947240801887082e-06,  -4.856289903150277e-08,
  -1.229196942467840e-10,   1.919029189484255e-11,  -1.790743146870493e-13,  -6.065412800719676e-15,   1.511976167218220e-16,   8.404749193512940e-19,  -7.964459171808778e-20,
   8.113587980865194e-22,   3.343110932964370e-23,   7.785776828169614e-01,  -1.579343180051446e-02,   1.075689455704896e-04,   1.946989865495185e-06,  -4.850564055235415e-08,
  -1.236583946698649e-10,   1.915644822705550e-11,  -1.780031196250066e-13,  -6.057593221328600e-15,   1.503369281858377e-16,   8.506293318034659e-19,  -7.913211374252291e-20,
   7.958574896235903e-22,   3.321913373397902e-23,   7.785984745639255e-01,  -1.579229820835166e-02,   1.075126476957084e-04,   1.946745793470899e-06,  -4.845008734455500e-08,
  -1.243740851680778e-10,   1.912360747885727e-11,  -1.769651884084530e-13,  -6.049973381181965e-15,   1.495031765273770e-16,   8.604224147504134e-19,  -7.863566253032935e-20,
   7.808795833274356e-22,   3.301344940496277e-23,   7.786152214969964e-01,  -1.579138503627461e-02,   1.074673105028910e-04,   1.946548837762881e-06,  -4.840535756337772e-08,
  -1.249496147060242e-10,   1.909716152174828e-11,  -1.761304517524392e-13,  -6.043814429713759e-15,   1.488327979489916e-16,   8.682653989739397e-19,  -7.823648253382249e-20,
   7.688639629360329e-22,   3.284782457339270e-23,   7.786262862855767e-01,  -1.579078164559855e-02,   1.074373601506885e-04,   1.946418529329959e-06,  -4.837581225857241e-08,
  -1.253294146938480e-10,   1.907969146910992e-11,  -1.755795609781337e-13,  -6.039734694012600e-15,   1.483904502820829e-16,   8.734253335088188e-19,  -7.797308091078598e-20,
   7.609488755453656e-22,   3.273841844292632e-23,   7.786319681861437e-01,  -1.579047178092672e-02,   1.074219815793695e-04,   1.946351559148868e-06,  -4.836064283668830e-08,
  -1.255243057231998e-10,   1.907072129834184e-11,  -1.752968649359884e-13,  -6.037636465271788e-15,   1.481634772265896e-16,   8.760682373410868e-19,  -7.783792579817841e-20,
   7.568917029486765e-22,   3.268224437366740e-23,   7.786339457603434e-01,  -1.579036393053592e-02,   1.074166293036768e-04,   1.946328241516760e-06,  -4.835536353857308e-08,
  -1.255921147523869e-10,   1.906759939313914e-11,  -1.751985038435949e-13,  -6.036905666310967e-15,   1.480845079916868e-16,   8.769870156071533e-19,  -7.779090200649469e-20,
   7.554807764150978e-22,   3.266269427207144e-23,   7.786342595711270e-01,  -1.579034681620440e-02,   1.074157799891284e-04,   1.946324540947707e-06,  -4.835452581316335e-08,
  -1.256028739447901e-10,   1.906710400140753e-11,  -1.751828968997796e-13,  -6.036789675271924e-15,   1.480719781243730e-16,   8.771327604535116e-19,  -7.778344084154857e-20,
   7.552569392077132e-22,   3.265959202578700e-23,   1.207143698416044e+00,  -1.711769098730719e-02,  -6.940533194563285e-05,   3.356874342117292e-06,   3.217966413450536e-08,
  -1.186832176442678e-09,  -1.748716306300778e-11,   4.969977419018689e-13,   9.961126092677659e-15,  -2.330969041215415e-16,  -6.124601791599851e-18,   1.137978246793883e-19,
   4.081369050759003e-21,  -4.573029233525411e-23,   1.207137227737561e+00,  -1.711675075703092e-02,  -6.938736785882690e-05,   3.355769800778285e-06,   3.215537519146021e-08,
  -1.185865956985423e-09,  -1.746153039928619e-11,   4.962259557731195e-13,   9.936064563996713e-15,  -2.325228415378244e-16,  -6.100301667829533e-18,   1.134702053550582e-19,
   4.060644320196535e-21,  -4.560718228223119e-23,   1.207125811476350e+00,  -1.711509195704706e-02,  -6.935568098131180e-05,   3.353821552863389e-06,   3.211254607241249e-08,
  -1.184162275522777e-09,  -1.741635417632708e-11,   4.948656928305758e-13,   9.891925614162824e-15,  -2.315112655177104e-16,  -6.057526823768902e-18,   1.128928460328825e-19,
   4.024179252928410e-21,  -4.539008237711654e-23,   1.207112009117335e+00,  -1.711308654646684e-02,  -6.931738367916491e-05,   3.351466959267484e-06,   3.206080622599572e-08,
  -1.182104257777309e-09,  -1.736181688079188e-11,   4.932235156460459e-13,   9.838692773323816e-15,  -2.302903847862365e-16,  -6.005978474788571e-18,   1.121959413646247e-19,
   3.980262275821900e-21,  -4.512778547164180e-23,   1.207098612440241e+00,  -1.711114017672920e-02,  -6.928022500593446e-05,   3.349182467270518e-06,   3.201062994792016e-08,
  -1.180108558403379e-09,  -1.730896740179632e-11,   4.916321083673136e-13,   9.787162023099427e-15,  -2.291076098847212e-16,  -5.956119505577055e-18,   1.115207008013857e-19,
   3.937813204004345e-21,  -4.487338712231241e-23,   1.207087821980591e+00,  -1.710957252756826e-02,  -6.925030455795366e-05,   3.347343045905272e-06,   3.197024571793771e-08,
  -1.178502415550812e-09,  -1.726646006677609e-11,   4.903520880175204e-13,   9.745754465463465e-15,  -2.281565245774951e-16,  -5.916084765834964e-18,   1.109776684784098e-19,
   3.903748780926742e-21,  -4.466861673397477e-23,   1.207080692683534e+00,  -1.710853681005225e-02,  -6.923054055741220e-05,   3.346128046937310e-06,   3.194357870169013e-08,
  -1.177441871400852e-09,  -1.723840499231230e-11,   4.895072500625774e-13,   9.718444385748303e-15,  -2.275289168974506e-16,  -5.889694534345141e-18,   1.106192988661636e-19,
   3.881304089456980e-21,  -4.453339166827236e-23,   1.207077031710102e+00,  -1.710800496813342e-02,  -6.922039293017958e-05,   3.345504228392942e-06,   3.192988952693283e-08,
  -1.176897468129774e-09,  -1.722400757024559e-11,   4.890736872013642e-13,   9.704435198550887e-15,  -2.272068738203484e-16,  -5.876161656498640e-18,   1.104354000489486e-19,
   3.869797571783563e-21,  -4.446397307672900e-23,   1.207075757516437e+00,  -1.710781986341679e-02,  -6.921686129506166e-05,   3.345287125168183e-06,   3.192512577777962e-08,
  -1.176708021288070e-09,  -1.721899803884935e-11,   4.889228297148445e-13,   9.699561693629606e-15,  -2.270948257127856e-16,  -5.871454559213715e-18,   1.103714148451896e-19,
   3.865795788923545e-21,  -4.443981544113105e-23,   1.207075555321428e+00,  -1.710779049021470e-02,  -6.921630088932143e-05,   3.345252674946007e-06,   3.192436987880731e-08,
  -1.176677960473011e-09,  -1.721820317225132e-11,   4.888988929895333e-13,   9.698788455163317e-15,  -2.270770472117498e-16,  -5.870707756945697e-18,   1.103612623409193e-19,
   3.865160911337106e-21,  -4.443598215384298e-23,   1.624637503713942e+00,  -1.178291544419168e-02,  -2.004300133467364e-04,  -1.001602203496956e-06,   4.768511914240471e-08,
   1.357375232653974e-09,   6.118129897065834e-12,  -5.498851720465087e-13,  -1.534685012954515e-14,  -4.048466842534115e-17,   7.782616405727969e-18,   2.017341399295808e-19,
   1.435527832248668e-22,  -1.117805980612244e-22,   1.624618767374985e+00,  -1.178319269609244e-02,  -2.004031448469992e-04,  -1.000338784689224e-06,   4.769325540713576e-08,
   1.356290949584544e-09,   6.078522408430804e-12,  -5.499956399842916e-13,  -1.531402414070529e-14,  -3.947604833759104e-17,   7.782550456027963e-18,   2.009219356982474e-19,
   1.227851415406234e-22,  -1.116906366493583e-22,   1.624585708862866e+00,  -1.178368162413713e-02,  -2.003557313447138e-04,  -9.981102892251049e-07,   4.770756695852537e-08,
   1.354377551042943e-09,   6.008704418994549e-12,  -5.501878180573524e-13,  -1.525610322588893e-14,  -3.769972158643450e-17,   7.782330943544526e-18,   1.994893613427446e-19,
   8.626045054805098e-23,  -1.115290707226522e-22,   1.624545737657028e+00,  -1.178427235141906e-02,  -2.002983922867027e-04,  -9.954169787076270e-07,   4.772479593865789e-08,
   1.352063572423956e-09,   5.924399194366165e-12,  -5.504155288875234e-13,  -1.518606668271644e-14,  -3.555756261863202e-17,   7.781890051907174e-18,   1.977580651489622e-19,
   4.229909299987212e-23,  -1.113289010933705e-22,   1.624506937967923e+00,  -1.178484530656000e-02,  -2.002427221051488e-04,  -9.928038361247813e-07,   4.774144128407204e-08,
   1.349816916131481e-09,   5.842682208670426e-12,  -5.506317012942164e-13,  -1.511807886758122e-14,  -3.348405733494599e-17,   7.781278834072988e-18,   1.960784018907713e-19,
  -1.636872517228084e-25,  -1.111295749779508e-22,   1.624475684069496e+00,  -1.178530650455463e-02,  -2.001978703459557e-04,  -9.906997805237196e-07,   4.775479310816893e-08,
   1.348006836872207e-09,   5.776941675340313e-12,  -5.508023523926756e-13,  -1.506331073774161e-14,  -3.181801283701006e-17,   7.780655548185197e-18,   1.947260488694706e-19,
  -3.421786133531410e-23,  -1.109654314284430e-22,   1.624455033336267e+00,  -1.178561107622198e-02,  -2.001682308626648e-04,  -9.893099761571515e-07,   4.776358764668978e-08,
   1.346810670838629e-09,   5.733545375285396e-12,  -5.509134068743010e-13,  -1.502712198452126e-14,  -3.071924680788465e-17,   7.780179751139970e-18,   1.938328152010690e-19,
  -5.664525693514960e-23,  -1.108552276506860e-22,   1.624444428594398e+00,  -1.178576743276659e-02,  -2.001530088781924e-04,  -9.885964053459125e-07,   4.776809537430323e-08,
   1.346196352298502e-09,   5.711272866745644e-12,  -5.509699107190889e-13,  -1.500853767178231e-14,  -3.015563538013994e-17,   7.779915664188097e-18,   1.933742144696030e-19,
  -6.813961703249002e-23,  -1.107980958849190e-22,   1.624440737580199e+00,  -1.178582184524632e-02,  -2.001477106170898e-04,  -9.883480659998435e-07,   4.776966294730132e-08,
   1.345982528341757e-09,   5.703522876201898e-12,  -5.509894933940249e-13,  -1.500206928788959e-14,  -2.995956992439289e-17,   7.779820606126369e-18,   1.932146130682709e-19,
  -7.213664505452812e-23,  -1.107781253126052e-22,   1.624440151870085e+00,  -1.178583047933748e-02,  -2.001468698508012e-04,  -9.883086591768379e-07,   4.776991163390502e-08,
   1.345948597198950e-09,   5.702293161980020e-12,  -5.509925969077028e-13,  -1.500104284715804e-14,  -2.992846200527728e-17,   7.779805372703880e-18,   1.931892874171992e-19,
  -7.277074323447066e-23,  -1.107749522091625e-22,   1.921535063330615e+00,  -3.088513614462272e-03,  -8.657922207254953e-05,  -2.000564038302216e-06,  -3.860935991647848e-08,
  -5.808654307944513e-10,  -4.657798631380019e-12,   8.684079298381708e-14,   5.301214192519290e-15,   1.533300583701686e-16,   3.058423869065533e-18,   3.636996425098064e-20,
  -1.865588346983764e-22,  -2.393017180819324e-23,   1.921526902874423e+00,  -3.089078184435259e-03,  -8.660097572632358e-05,  -2.001107082933261e-06,  -3.861574181644182e-08,
  -5.806861472606756e-10,  -4.643617640985986e-12,   8.736295420205682e-14,   5.314068695240716e-15,   1.535104282625878e-16,   3.056971382195421e-18,   3.618711296769857e-20,
  -1.929741260672973e-22,  -2.407272369414641e-23,   1.921512501958587e+00,  -3.090074500953568e-03,  -8.663936326997382e-05,  -2.002065154527013e-06,  -3.862698646221171e-08,
  -5.803689605788804e-10,  -4.618567656755374e-12,   8.828480551905830e-14,   5.336745423243638e-15,   1.538279192049482e-16,   3.054376029294631e-18,   3.586362215356117e-20,
  -2.043071639668951e-22,  -2.432421323286715e-23,   1.921495085382434e+00,  -3.091279468803063e-03,  -8.668578680228270e-05,  -2.003223427147324e-06,  -3.864055576454876e-08,
  -5.799839855496085e-10,  -4.588230230703644e-12,   8.940035138086219e-14,   5.364157346764759e-15,   1.542105095076561e-16,   3.051182382247057e-18,   3.547100986648691e-20,
  -2.180335642961636e-22,  -2.462823635016554e-23,   1.921478174702965e+00,  -3.092449451944977e-03,  -8.673085909309472e-05,  -2.004347608588857e-06,  -3.865369942360671e-08,
  -5.796087608132529e-10,  -4.558730270732550e-12,   9.048417484896095e-14,   5.390758826272561e-15,   1.545805328735507e-16,   3.048024058626352e-18,   3.508835705893824e-20,
  -2.313822632517427e-22,  -2.492328820335720e-23,   1.921464549552218e+00,  -3.093392133626405e-03,  -8.676717241488198e-05,  -2.005253055329059e-06,  -3.866426685435205e-08,
  -5.793054111122468e-10,  -4.534930448622587e-12,   9.135791158341095e-14,   5.412181727104319e-15,   1.548776217166460e-16,   3.045438166892842e-18,   3.477901407865503e-20,
  -2.421524742402645e-22,  -2.516091188779406e-23,   1.921455545253700e+00,  -3.094015118474878e-03,  -8.679116940630205e-05,  -2.005851270499866e-06,  -3.867123936863832e-08,
  -5.791044372108819e-10,  -4.519186797551325e-12,   9.193556558077747e-14,   5.426334189626836e-15,   1.550734436091891e-16,   3.043709077230220e-18,   3.457407563562323e-20,
  -2.492773787437956e-22,  -2.531789580575039e-23,   1.921450920793427e+00,  -3.094335074995947e-03,  -8.680349356441821e-05,  -2.006158455394145e-06,  -3.867481691501869e-08,
  -5.790010648396799e-10,  -4.511096375448594e-12,   9.223231255046555e-14,   5.433601096202407e-15,   1.551738560670350e-16,   3.042814801271648e-18,   3.446866601486102e-20,
  -2.529388709851114e-22,  -2.539850393071929e-23,   1.921449311156393e+00,  -3.094446442612684e-03,  -8.680778318880236e-05,  -2.006265369573309e-06,  -3.867606160745277e-08,
  -5.789650592404291e-10,  -4.508279585602560e-12,   9.233561300593003e-14,   5.436130240287452e-15,   1.552087814141656e-16,   3.042502536154529e-18,   3.443195113567701e-20,
  -2.542136865142326e-22,  -2.542655861307090e-23,   1.921449055726729e+00,  -3.094464115301001e-03,  -8.680846389730514e-05,  -2.006282335175172e-06,  -3.867625909900646e-08,
  -5.789593444181311e-10,  -4.507832559764872e-12,   9.235200607529830e-14,   5.436531572574044e-15,   1.552143224399641e-16,   3.042452936303106e-18,   3.442612375119663e-20,
  -2.544160011444316e-22,  -2.543101042298942e-23,   1.521175382674778e-02,  -4.205161712952168e-04,   8.658390643403959e-06,  -1.574082020145354e-07,   2.650006451887728e-09,
  -4.242547868823082e-11,   6.450111848730862e-13,  -9.563686202580102e-15,   1.331106884216334e-16,  -1.729098831226577e-18,   2.748095295838689e-20,  -1.696292097515642e-22,
   1.551713587765951e-24,  -1.438741423125703e-25,   1.521256855208002e-02,  -4.205605829574159e-04,   8.659886414850044e-06,  -1.574481350047986e-07,   2.650917661383321e-09,
  -4.244440041858167e-11,   6.453630010272875e-13,  -9.569545886370981e-15,   1.332269147160253e-16,  -1.730013005107672e-18,   2.749008368088774e-20,  -1.706499122670457e-22,
   1.541437178813413e-24,  -1.433031256033589e-25,   1.521400626238898e-02,  -4.206389571939164e-04,   8.662526144829735e-06,  -1.575186118461318e-07,   2.652525908069455e-09,
  -4.247779750087097e-11,   6.459840343934345e-13,  -9.579887928101677e-15,   1.334320287512268e-16,  -1.731630326127317e-18,   2.750614421916108e-20,  -1.724475857210577e-22,
   1.523388594126856e-24,  -1.422972309052573e-25,   1.521574495255422e-02,  -4.207337437787246e-04,   8.665718846920421e-06,  -1.576038578421249e-07,   2.654471304823643e-09,
  -4.251819762556133e-11,   6.467354178684608e-13,  -9.592397970052337e-15,   1.336801074209027e-16,  -1.733593239529203e-18,   2.752547852282392e-20,  -1.746156085747893e-22,
   1.501707401945579e-24,  -1.410837401031725e-25,   1.521743304762217e-02,  -4.208257773151920e-04,   8.668819013019507e-06,  -1.576866389952156e-07,   2.656360582695906e-09,
  -4.255743414262656e-11,   6.474652912652555e-13,  -9.604547051496242e-15,   1.339209928174485e-16,  -1.735506362386262e-18,   2.754415795511200e-20,  -1.767142821528398e-22,
   1.480809292432708e-24,  -1.399086797409178e-25,   1.521879310178060e-02,  -4.208999300597687e-04,   8.671317001259614e-06,  -1.577533449169832e-07,   2.657883076704690e-09,
  -4.258905459254133e-11,   6.480535854637680e-13,  -9.614337460182525e-15,   1.341150862035987e-16,  -1.737052957695121e-18,   2.755914165413522e-20,  -1.784006494658244e-22,
   1.464080896756801e-24,  -1.389641936049188e-25,   1.521969187318842e-02,  -4.209489346138403e-04,   8.672967889261305e-06,  -1.577974320623191e-07,   2.658889366500313e-09,
  -4.260995470987569e-11,   6.484424753517462e-13,  -9.620808390156963e-15,   1.342433588276152e-16,  -1.738077564934047e-18,   2.756901128119958e-20,  -1.795128695522447e-22,
   1.453079246118659e-24,  -1.383411336214271e-25,   1.522015345753248e-02,  -4.209741025729079e-04,   8.673815780238659e-06,  -1.578200757233831e-07,   2.659406222679156e-09,
  -4.262068974109046e-11,   6.486422370292630e-13,  -9.624132018467603e-15,   1.343092388777798e-16,  -1.738604566903089e-18,   2.757407013863508e-20,  -1.800833984308159e-22,
   1.447445477714846e-24,  -1.380214836156121e-25,   1.522031411972834e-02,  -4.209828627942632e-04,   8.674110909353689e-06,  -1.578279575031672e-07,   2.659586131659435e-09,
  -4.262442645692714e-11,   6.487117735703413e-13,  -9.625288916779605e-15,   1.343321699742374e-16,  -1.738788124785955e-18,   2.757582938305268e-20,  -1.802818729001560e-22,
   1.445487154390281e-24,  -1.379102775884137e-25,   1.522033961477410e-02,  -4.209842529341665e-04,   8.674157742891871e-06,  -1.578292082542518e-07,   2.659614681328116e-09,
  -4.262501943603106e-11,   6.487228084253816e-13,  -9.625472504362112e-15,   1.343358088681215e-16,  -1.738817259065168e-18,   2.757610847797494e-20,  -1.803133631604519e-22,
   1.445176516991309e-24,  -1.378926331478727e-25,   1.362331205086764e-01,  -3.622254529495349e-03,   6.818355405722774e-05,  -1.045636557744911e-06,   1.289864054089388e-08,
  -1.108735682754249e-10,  -2.905224836541256e-14,   2.496036614726353e-14,  -6.758059654661603e-16,   1.204227708387320e-17,  -9.110312386701355e-20,   1.572285826729223e-21,
   8.675765684368244e-24,  -1.876022337514149e-24,   1.362395272685391e-01,  -3.622548978754993e-03,   6.819080916716462e-05,  -1.045740082237935e-06,   1.289857860154299e-08,
  -1.108237776342707e-10,  -3.083413145258849e-14,   2.500120428996720e-14,  -6.761885422581802e-16,   1.204985804912851e-17,  -9.104843507941243e-20,   1.558737791195643e-21,
   8.695998011944991e-24,  -1.872910665677997e-24,   1.362508326502064e-01,  -3.623068562712129e-03,   6.820361088967794e-05,  -1.045922714686784e-06,   1.289846726827460e-08,
  -1.107358558023847e-10,  -3.397910763716723e-14,   2.507328425134327e-14,  -6.768634165282675e-16,   1.206317816113725e-17,  -9.095182263573616e-20,   1.534850340579550e-21,
   8.732735187200896e-24,  -1.867436987590857e-24,   1.362645041815925e-01,  -3.623696889429370e-03,   6.821909081223531e-05,  -1.046143490716058e-06,   1.289832916336178e-08,
  -1.106294281431601e-10,  -3.778343656810442e-14,   2.516047881578980e-14,  -6.776791600193867e-16,   1.207918849242083e-17,  -9.083480124393843e-20,   1.505996465653079e-21,
   8.778921963824408e-24,  -1.860846931152101e-24,   1.362777772551916e-01,  -3.624306900266417e-03,   6.823411839250081e-05,  -1.046357748069662e-06,   1.289819144895363e-08,
  -1.105259930766881e-10,  -4.147806861503990e-14,   2.524516199691032e-14,  -6.784707324476599e-16,   1.209463006737604e-17,  -9.072098851376481e-20,   1.478018088776744e-21,
   8.825600913753986e-24,  -1.854479461399387e-24,   1.362884705782748e-01,  -3.624798347249089e-03,   6.824622437174747e-05,  -1.046530302115908e-06,   1.289807789613621e-08,
  -1.104425833274023e-10,  -4.445545866742340e-14,   2.531340751332618e-14,  -6.791081710152562e-16,   1.210699729600980e-17,  -9.062914853637289e-20,   1.455502272317956e-21,
   8.864520585972961e-24,  -1.849371373872950e-24,   1.362955368821345e-01,  -3.625123101437800e-03,   6.825422376540435e-05,  -1.046644298804735e-06,   1.289800158337918e-08,
  -1.103874266099088e-10,  -4.642337532020885e-14,   2.535851555167924e-14,  -6.795292605244472e-16,   1.211513395755987e-17,  -9.056838567000877e-20,   1.440635556609116e-21,
   8.890880688905418e-24,  -1.846006524447103e-24,   1.362991658744230e-01,  -3.625289882822198e-03,   6.825833183002235e-05,  -1.046702834149273e-06,   1.289796199751088e-08,
  -1.103590883023039e-10,  -4.743415249071185e-14,   2.538168458138686e-14,  -6.797454734530414e-16,   1.211930158413359e-17,  -9.053715705479253e-20,   1.433004286854059e-21,
   8.904616290253614e-24,  -1.844281750111595e-24,   1.363004289954801e-01,  -3.625347933337817e-03,   6.825976167844907e-05,  -1.046723206732117e-06,   1.289794815629989e-08,
  -1.103492228737720e-10,  -4.778598786265105e-14,   2.538974939349983e-14,  -6.798207225008535e-16,   1.212075042366758e-17,  -9.052628380803600e-20,   1.430348710285478e-21,
   8.909428652919080e-24,  -1.843681941441510e-24,   1.363006294362056e-01,  -3.625357145189694e-03,   6.825998857565063e-05,  -1.046726439524421e-06,   1.289794595690005e-08,
  -1.103476572701837e-10,  -4.784182048317235e-14,   2.539102919748989e-14,  -6.798326632110131e-16,   1.212098025190121e-17,  -9.052455819067812e-20,   1.429927333278792e-21,
   8.910193806305885e-24,  -1.843586784497388e-24,   3.740989851580440e-01,  -9.111828260873690e-03,   1.366956582477704e-04,  -1.145672984191633e-06,  -5.793286872390696e-09,
   3.962120921068963e-10,  -7.041968658053523e-12,   3.529760813132971e-14,   1.315594885300087e-15,  -4.135846475745416e-17,   6.918690757094117e-19,   4.640663306336338e-21,
  -2.670404351928919e-22,   1.646888550381235e-24,   3.741117936961619e-01,  -9.112149170299941e-03,   1.366923438904998e-04,  -1.145300972570895e-06,  -5.803147992151317e-09,
   3.962793754544605e-10,  -7.038456234224245e-12,   3.515866190879260e-14,   1.318459382090157e-15,  -4.133405188481375e-17,   6.901846018601426e-19,   4.653061282970912e-21,
  -2.677437256791535e-22,   1.653503050857975e-24,   3.741343943042665e-01,  -9.112715334879239e-03,   1.366864911550779e-04,  -1.144644501601169e-06,  -5.820544054512331e-09,
   3.963978758995141e-10,  -7.032252426840470e-12,   3.491355645328054e-14,   1.323508026310141e-15,  -4.129092265799970e-17,   6.872088525573377e-19,   4.674975372533972e-21,
  -2.689784252210487e-22,   1.665051159067722e-24,   3.741617227593798e-01,  -9.113399801939216e-03,   1.366794062934791e-04,  -1.143850603707525e-06,  -5.841572668122018e-09,
   3.965407893126826e-10,  -7.024740357794735e-12,   3.461728723669684e-14,   1.329602994054474e-15,  -4.123868100531691e-17,   6.836046518025820e-19,   4.701537846490766e-21,
  -2.704607637708136e-22,   1.678805468708998e-24,   3.741882522877264e-01,  -9.114064118652647e-03,   1.366725204006958e-04,  -1.143079811272406e-06,  -5.861979660119454e-09,
   3.966791308180678e-10,  -7.017436934358642e-12,   3.432979467790592e-14,   1.335509498700463e-15,  -4.118787203297977e-17,   6.800996125359035e-19,   4.727390330586704e-21,
  -2.718886325010495e-22,   1.691938764141042e-24,   3.742096237989460e-01,  -9.114599174600434e-03,   1.366669674614179e-04,  -1.142458806456334e-06,  -5.878414088634505e-09,
   3.967902930103000e-10,  -7.011545634523458e-12,   3.409828081528495e-14,   1.340260254348773e-15,  -4.114687377029593e-17,   6.772716159577237e-19,   4.748263664473359e-21,
  -2.730309210443008e-22,   1.702362133476273e-24,   3.742237455502942e-01,  -9.114952676687863e-03,   1.366632953614124e-04,  -1.142048426020156e-06,  -5.889271128807717e-09,
   3.968636080161696e-10,  -7.007648973657776e-12,   3.394534292079062e-14,   1.343395819567945e-15,  -4.111974990064739e-17,   6.754007881859810e-19,   4.762079179197237e-21,
  -2.737818206900516e-22,   1.709173166332767e-24,   3.742309976950258e-01,  -9.115134200424271e-03,   1.366614086913788e-04,  -1.141837666292368e-06,  -5.894845953340333e-09,
   3.969012158013382e-10,  -7.005646678912234e-12,   3.386681509637621e-14,   1.345004953086980e-15,  -4.110581029829285e-17,   6.744393690685324e-19,   4.769181115927218e-21,
  -2.741662371929485e-22,   1.712647318194111e-24,   3.742335218624054e-01,  -9.115197378796206e-03,   1.366607518799440e-04,  -1.141764307889554e-06,  -5.896786197052188e-09,
   3.969142986936697e-10,  -7.004949575214336e-12,   3.383948485452677e-14,   1.345564846910994e-15,  -4.110095686788085e-17,   6.741046334881003e-19,   4.771654122451548e-21,
  -2.742998449099637e-22,   1.713852768032695e-24,   3.742339224126250e-01,  -9.115207404209019e-03,   1.366606476464330e-04,  -1.141752666847794e-06,  -5.897094081072032e-09,
   3.969163744437146e-10,  -7.004838945597257e-12,   3.383514802061403e-14,   1.345653685811496e-15,  -4.110018661819868e-17,   6.740515105868480e-19,   4.772046607268796e-21,
  -2.743210375031344e-22,   1.714043877854068e-24,   7.171965721548895e-01,  -1.485427386877422e-02,   1.263990283357337e-04,   1.172891301508523e-06,  -4.696115279349813e-08,
   2.621939996614574e-10,   1.229346421483486e-11,  -2.867747756236183e-13,  -7.076875076119844e-16,   1.307125881960744e-16,  -1.457080444420726e-18,  -2.059681643398081e-20,
   1.214458801522677e-21,  -1.610996934453068e-23,   7.172083692107263e-01,  -1.485394314544570e-02,   1.263727101756141e-04,   1.173132426449539e-06,  -4.694388873600156e-08,
   2.616363774662622e-10,   1.229148509863782e-11,  -2.863365166525877e-13,  -7.136017359855341e-16,   1.306021622391162e-16,  -1.449802804566720e-18,  -2.070661353927183e-20,
   1.209328291856424e-21,  -1.596375302011326e-23,   7.172291833073278e-01,  -1.485335952459753e-02,   1.263262792568263e-04,   1.173557472336953e-06,  -4.691342834468327e-08,
   2.606531443588848e-10,   1.228798043576352e-11,  -2.855635078655613e-13,  -7.240127314863728e-16,   1.304068617747418e-16,  -1.436986952287525e-18,  -2.089949333413483e-20,
   1.200289070400350e-21,  -1.570652005683238e-23,   7.172543485357876e-01,  -1.485265371145686e-02,   1.262701479440006e-04,   1.174070721711248e-06,  -4.687659926199694e-08,
   2.594654016485716e-10,   1.228372131443553e-11,  -2.846293000817504e-13,  -7.365596717481699e-16,   1.301699339034077e-16,  -1.421533588344511e-18,  -2.113126421554993e-20,
   1.189382010974364e-21,  -1.539677859098100e-23,   7.172787749445280e-01,  -1.485196842341714e-02,   1.262156707211754e-04,   1.174568221122676e-06,  -4.684085037262349e-08,
   2.583136107324075e-10,   1.227956443091021e-11,  -2.837229357724969e-13,  -7.486959650923746e-16,   1.299391268211742e-16,  -1.406577433990913e-18,  -2.135473694768761e-20,
   1.178817988349200e-21,  -1.509745321769952e-23,   7.172984499918059e-01,  -1.485141629494283e-02,   1.261717946693946e-04,   1.174968460127354e-06,  -4.681205451193083e-08,
   2.573866376533782e-10,   1.227619982403794e-11,  -2.829931741758972e-13,  -7.584412909448862e-16,   1.297526194857018e-16,  -1.394561654911386e-18,  -2.153367278568611e-20,
   1.170325204416187e-21,  -1.485729755335305e-23,   7.173114496641774e-01,  -1.485105142435518e-02,   1.261428070962910e-04,   1.175232666640471e-06,  -4.679302818259715e-08,
   2.567745483040128e-10,   1.227396879167566e-11,  -2.825111537837197e-13,  -7.648654202068974e-16,   1.296290995054847e-16,  -1.386637838006330e-18,  -2.165137739693003e-20,
   1.164721870688083e-21,  -1.469908452058808e-23,   7.173181252319132e-01,  -1.485086403536262e-02,   1.261279221182698e-04,   1.175368267620485e-06,  -4.678325770512373e-08,
   2.564603465488391e-10,   1.227282065270276e-11,  -2.822636730217751e-13,  -7.681597573928611e-16,   1.295655799115321e-16,  -1.382573522113145e-18,  -2.171165975030159e-20,
   1.161846933822433e-21,  -1.461798207594049e-23,   7.173204486629416e-01,  -1.485079881123856e-02,   1.261227415085752e-04,   1.175415451778133e-06,  -4.677985707315083e-08,
   2.563510073061910e-10,   1.227242065104335e-11,  -2.821775445979302e-13,  -7.693056241415751e-16,   1.295434576329188e-16,  -1.381159686391448e-18,  -2.173261539277453e-20,
   1.160846706505207e-21,  -1.458977709733370e-23,   7.173208173565296e-01,  -1.485078846098912e-02,   1.261219194287115e-04,   1.175422938636770e-06,  -4.677931744311931e-08,
   2.563336576974964e-10,   1.227235715818876e-11,  -2.821638776553891e-13,  -7.694874214618482e-16,   1.295399464818244e-16,  -1.380935367472146e-18,  -2.173593952208278e-20,
   1.160688004181437e-21,  -1.458530246956561e-23,   1.137827394880222e+00,  -1.750497720963218e-02,  -2.687652507029226e-05,   3.664318420138303e-06,   5.521335309442130e-09,
  -1.412658195231665e-09,  -6.356425702149931e-13,   6.469570790538495e-13,  -1.201136472874814e-15,  -3.335591912568583e-16,   1.781190101611354e-18,   2.038036914632918e-19,
  -1.022672884265463e-21,  -1.228116476304524e-22,   1.137824881434839e+00,  -1.750395124749275e-02,  -2.687342458891793e-05,   3.663004600861692e-06,   5.520406164938905e-09,
  -1.411401929003718e-09,  -6.386450568430271e-13,   6.458577100261838e-13,  -1.193820621394435e-15,  -3.325417422139811e-16,   1.774995036016672e-18,   2.029397027368036e-19,
  -1.019793593995371e-21,  -1.221895372615502e-22,   1.137820446656530e+00,  -1.750214121971697e-02,  -2.686795417381100e-05,   3.660687298210992e-06,   5.518763301085935e-09,
  -1.409186974155884e-09,  -6.439274988791182e-13,   6.439206233708590e-13,  -1.180932818151021e-15,  -3.307500245394100e-16,   1.764078113686020e-18,   2.014188359915132e-19,
  -1.014723533834332e-21,  -1.210950495083223e-22,   1.137815084476929e+00,  -1.749995302371195e-02,  -2.686134002883995e-05,   3.657886813644790e-06,   5.516770992068923e-09,
  -1.406511602300459e-09,  -6.502886983926018e-13,   6.415829892493685e-13,  -1.165384746633932e-15,  -3.285895663785380e-16,   1.750901718040669e-18,   1.995860066087221e-19,
  -1.008610592934973e-21,  -1.197770859383097e-22,   1.137809879386430e+00,  -1.749782929365638e-02,  -2.685491990702709e-05,   3.655169849677515e-06,   5.514830896937314e-09,
  -1.403917509386127e-09,  -6.564364490136564e-13,   6.393185800787520e-13,  -1.150328601741392e-15,  -3.264986118490461e-16,   1.738135873595376e-18,   1.978132233367694e-19,
  -1.002694849470301e-21,  -1.185033735768147e-22,   1.137805686534577e+00,  -1.749611882592093e-02,  -2.684974849704895e-05,   3.652982314616871e-06,   5.513263696217904e-09,
  -1.401829968738244e-09,  -6.613692552085394e-13,   6.374979246416137e-13,  -1.138226515883246e-15,  -3.248187285850740e-16,   1.727870165810348e-18,   1.963897346749490e-19,
  -9.979424712983119e-22,  -1.174813898895202e-22,   1.137802916120311e+00,  -1.749498876608983e-02,  -2.684633159439069e-05,   3.651537425367771e-06,   5.512226024062548e-09,
  -1.400451648309782e-09,  -6.646191107278749e-13,   6.362965905638623e-13,  -1.130242855767676e-15,  -3.237109218105533e-16,   1.721095711597782e-18,   1.954513870951471e-19,
  -9.948086588240501e-22,  -1.168080846869602e-22,   1.137801493425655e+00,  -1.749440848404647e-02,  -2.684457693586840e-05,   3.650795589526716e-06,   5.511692483150504e-09,
  -1.399744151445908e-09,  -6.662850835326758e-13,   6.356801802476497e-13,  -1.126146938555408e-15,  -3.231426989209389e-16,   1.717619468057764e-18,   1.949702012252455e-19,
  -9.932012937692138e-22,  -1.164629287069167e-22,   1.137800998251015e+00,  -1.749420652076028e-02,  -2.684396622435831e-05,   3.650537416043412e-06,   5.511506676491637e-09,
  -1.399497954254089e-09,  -6.668644658572968e-13,   6.354657176755467e-13,  -1.124721965458046e-15,  -3.229450333423900e-16,   1.716409969263910e-18,   1.948028315096636e-19,
  -9.926421532486546e-22,  -1.163428923673839e-22,   1.137800919673964e+00,  -1.749417447240465e-02,  -2.684386931349153e-05,   3.650496448856877e-06,   5.511477186652492e-09,
  -1.399458888693192e-09,  -6.669563833183717e-13,   6.354316894382518e-13,  -1.124495872629461e-15,  -3.229136717390861e-16,   1.716218059327375e-18,   1.947762775291420e-19,
  -9.925534404181241e-22,  -1.163238489209438e-22,   1.574243900016207e+00,  -1.341937709188155e-02,  -2.069664535061297e-04,  -1.970834533244132e-08,   7.477049593269434e-08,
   1.265174119129300e-09,  -1.584786862255732e-11,  -9.877381166771719e-13,  -9.226620287524376e-15,   4.247655190052421e-16,   1.417892625327639e-17,   2.014642932790319e-20,
  -8.310022705332342e-21,  -1.737898452268859e-22,   1.574224581119851e+00,  -1.341937851738068e-02,  -2.069245226530839e-04,  -1.853838211792128e-08,   7.474793949842418e-08,
   1.263252339985099e-09,  -1.587089158161979e-11,  -9.863032147477205e-13,  -9.168429101181422e-15,   4.248231705887883e-16,   1.412823963333955e-17,   1.894721018987497e-20,
  -8.294383468873274e-21,  -1.724837913873794e-22,   1.574190495803447e+00,  -1.341938076797358e-02,  -2.068505453805390e-04,  -1.647542131602409e-08,   7.470811246177520e-08,
   1.259863627672001e-09,  -1.591139275227064e-11,  -9.837711832285018e-13,  -9.065923035925828e-15,   4.249199435271753e-16,   1.403888208757611e-17,   1.683885770766903e-20,
  -8.266685684470136e-21,  -1.701848743488376e-22,   1.574149284896508e+00,  -1.341938303826653e-02,  -2.067611089742205e-04,  -1.398335136540496e-08,   7.465990919689945e-08,
   1.255769877594981e-09,  -1.596015738199591e-11,  -9.807092206148398e-13,  -8.942266735416743e-15,   4.250285370486031e-16,   1.393096638639707e-17,   1.430250203178800e-20,
  -8.233020261978974e-21,  -1.674146090219968e-22,   1.574109283738401e+00,  -1.341938477007838e-02,  -2.066743042065989e-04,  -1.156669299155613e-08,   7.461306836152965e-08,
   1.251799837921285e-09,  -1.600727784251177e-11,  -9.777365194279081e-13,  -8.822532153736369e-15,   4.251251627943335e-16,   1.382634696442378e-17,   1.185392679216906e-20,
  -8.200158766665708e-21,  -1.647353473830114e-22,   1.574077063392663e+00,  -1.341938582711353e-02,  -2.066043887109370e-04,  -9.621726242065850e-09,   7.457530116369238e-08,
   1.248604564773300e-09,  -1.604508050179583e-11,  -9.753416143386703e-13,  -8.726296625520881e-15,   4.251967213716542e-16,   1.374216988018851e-17,   9.891163824297928e-21,
  -8.173558242669215e-21,  -1.625841803185575e-22,   1.574055774753307e+00,  -1.341938636012776e-02,  -2.065581963099641e-04,  -8.337438017752917e-09,   7.455032923240360e-08,
   1.246494624335901e-09,  -1.606998306003471e-11,  -9.737590406191835e-13,  -8.662814087154016e-15,   4.252409381755540e-16,   1.368659769858815e-17,   8.598983961019158e-21,
  -8.155918957996913e-21,  -1.611662584232007e-22,   1.574044842634104e+00,  -1.341938658270483e-02,  -2.065344763166712e-04,  -7.678176254023714e-09,   7.453749999776959e-08,
   1.245411514037847e-09,  -1.608274799427261e-11,  -9.729462944848513e-13,  -8.630246208434460e-15,   4.252626985560301e-16,   1.365807437925581e-17,   7.936863927552472e-21,
  -8.146841213119627e-21,  -1.604391796990939e-22,   1.574041037707923e+00,  -1.341938665203302e-02,  -2.065262206766025e-04,  -7.448758997051145e-09,   7.453303387729309e-08,
   1.245034598436704e-09,  -1.608718717185831e-11,  -9.726634078189356e-13,  -8.618915982738815e-15,   4.252701218322200e-16,   1.364814907136842e-17,   7.706641834111767e-21,
  -8.143678583364741e-21,  -1.601862871429376e-22,   1.574040433923194e+00,  -1.341938666264797e-02,  -2.065249106354536e-04,  -7.412355766360501e-09,   7.453232512809217e-08,
   1.244974790485594e-09,  -1.608789142904275e-11,  -9.726185174631662e-13,  -8.617118284624778e-15,   4.252712926563637e-16,   1.364657418017483e-17,   7.670119904348248e-21,
  -8.143176573533996e-21,  -1.601461648305388e-22,   1.907627665663197e+00,  -3.888592827885215e-03,  -1.146922853207424e-04,  -2.716080252220825e-06,  -5.102356580802427e-08,
  -6.382890537316867e-10,   1.163211997530280e-12,   3.711448832205622e-13,   1.334065289300051e-14,   2.986939531612647e-16,   3.779514732734632e-18,  -2.557841024331124e-20,
  -3.004797435865131e-21,  -9.493002177401790e-23,   1.907616855691652e+00,  -3.889358808134760e-03,  -1.147209741967332e-04,  -2.716672353585082e-06,  -5.102151170523902e-08,
  -6.375424063004565e-10,   1.198545644510780e-12,   3.721487132730659e-13,   1.335597350543684e-14,   2.985347013808335e-16,   3.760212111126748e-18,  -2.628046706303260e-20,
  -3.020179350773836e-21,  -9.507639737801887e-23,   1.907597779141392e+00,  -3.890710526643124e-03,  -1.147715951323712e-04,  -2.717716551770921e-06,  -5.101784668906987e-08,
  -6.362233305611122e-10,   1.260924737150250e-12,   3.739195300999666e-13,   1.338294013901235e-14,   2.982507481383640e-16,   3.726075324930330e-18,  -2.752009488143619e-20,
  -3.047287612926825e-21,  -9.533226002897981e-23,   1.907574707846753e+00,  -3.892345268020918e-03,  -1.148328047270668e-04,  -2.718978227843555e-06,  -5.101334579820955e-08,
  -6.346255546230078e-10,   1.336409206801295e-12,   3.760600357917392e-13,   1.341543435266272e-14,   2.979023548405431e-16,   3.684665572847210e-18,  -2.902048419330970e-20,
  -3.080009909742203e-21,  -9.563751660201909e-23,   1.907552306731289e+00,  -3.893932486254259e-03,  -1.148922240601913e-04,  -2.720202014313277e-06,  -5.100890400368545e-08,
  -6.330715975165195e-10,   1.409745697711014e-12,   3.781371725966441e-13,   1.344685942927901e-14,   2.975588661123502e-16,   3.644328476754847e-18,  -3.047850850636935e-20,
  -3.111715621884913e-21,  -9.592951125092440e-23,   1.907534257888282e+00,  -3.895211300213639e-03,  -1.149400901424319e-04,  -2.721187144312049e-06,  -5.100527384951725e-08,
  -6.318176983879570e-10,   1.468865712653257e-12,   3.798098879687977e-13,   1.347208910448567e-14,   2.972783747732041e-16,   3.611735221819184e-18,  -3.165411989609513e-20,
  -3.137213597342598e-21,  -9.616161754129994e-23,   1.907522330165523e+00,  -3.896056401679526e-03,  -1.149717185264520e-04,  -2.721837739768657e-06,  -5.100284968652311e-08,
  -6.309881399070596e-10,   1.507951249041482e-12,   3.809148931699687e-13,   1.348871827180300e-14,   2.970911788343403e-16,   3.590150134290071e-18,  -3.243145146671803e-20,
  -3.154040644054433e-21,  -9.631345761006037e-23,   1.907516204285849e+00,  -3.896490427684261e-03,  -1.149879610066883e-04,  -2.722171739989993e-06,  -5.100159689898148e-08,
  -6.305618113940135e-10,   1.528029745576614e-12,   3.814822744528033e-13,   1.349724509488899e-14,   2.969944717562860e-16,   3.579050309856212e-18,  -3.283080490900752e-20,
  -3.162675438132816e-21,  -9.639096031168759e-23,   1.907514072049937e+00,  -3.896641498542992e-03,  -1.149936143174258e-04,  -2.722287974041062e-06,  -5.100115960269744e-08,
  -6.304133744160795e-10,   1.535019237081870e-12,   3.816797420574818e-13,   1.350021085493250e-14,   2.969607207329230e-16,   3.575184551131006e-18,  -3.296982837575205e-20,
  -3.165679787901353e-21,  -9.641786023719239e-23,   1.907513733690264e+00,  -3.896665471603888e-03,  -1.149945114184008e-04,  -2.722306417939753e-06,  -5.100109015035460e-08,
  -6.303898171652334e-10,   1.536128419961070e-12,   3.817110767506711e-13,   1.350068138149294e-14,   2.969553605785978e-16,   3.574570996290216e-18,  -3.299189066329221e-20,
  -3.166156486009021e-21,  -9.642212529456168e-23,   1.365719932186103e-02,  -3.581432794689774e-04,   6.998387162963688e-06,  -1.210381323589153e-07,   1.936879107915000e-09,
  -2.972756605544322e-11,   4.289332367266407e-13,  -6.102377570054823e-15,   8.884510952722916e-17,  -7.851131556104825e-19,   1.890028027210495e-20,  -2.798044822345395e-22,
  -5.685495786622134e-24,  -9.018828578544604e-26,   1.365785761341754e-02,  -3.581774199221708e-04,   6.999480077313634e-06,  -1.210661033114097e-07,   1.937485073804889e-09,
  -2.973962293136771e-11,   4.291680757864623e-13,  -6.105065651549293e-15,   8.892376143469281e-17,  -7.865799136456323e-19,   1.886638347825068e-20,  -2.804274552777760e-22,
  -5.657714422410972e-24,  -8.952158723722042e-26,   1.365901926295262e-02,  -3.582376677032481e-04,   7.001408819679713e-06,  -1.211154677007424e-07,   1.938554579291509e-09,
  -2.976090180041192e-11,   4.295826202080978e-13,  -6.109812855856210e-15,   8.906242882758970e-17,  -7.891706056410354e-19,   1.880671096022620e-20,  -2.815227814121466e-22,
  -5.608770248973425e-24,  -8.834845807188161e-26,   1.366042408475939e-02,  -3.583105309022670e-04,   7.003741549317197e-06,  -1.211751753429799e-07,   1.939848295791611e-09,
  -2.978663980969300e-11,   4.300841766853085e-13,  -6.115560123143957e-15,   8.922991093075531e-17,  -7.923076764101480e-19,   1.873479090148919e-20,  -2.828405914116441e-22,
  -5.549716595040735e-24,  -8.693545647299200e-26,   1.366178801098570e-02,  -3.583812766910729e-04,   7.006006619095516e-06,  -1.212331549273081e-07,   1.941104694242948e-09,
  -2.981163355069225e-11,   4.305713771979149e-13,  -6.121146699442313e-15,   8.939229483318671e-17,  -7.953576611012901e-19,   1.866521957172492e-20,  -2.841129304988642e-22,
  -5.492524326175088e-24,  -8.556953650599463e-26,   1.366288687937040e-02,  -3.584382767883555e-04,   7.007831685473644e-06,  -1.212798743068363e-07,   1.942117177153912e-09,
  -2.983177372387221e-11,   4.309640730805007e-13,  -6.125652356293359e-15,   8.952296272941338e-17,  -7.978179539598431e-19,   1.860935085252771e-20,  -2.851329295337540e-22,
  -5.446548200238720e-24,  -8.447330650355444e-26,   1.366361304449428e-02,  -3.584759454575067e-04,   7.009037830976355e-06,  -1.213107514093764e-07,   1.942786376625670e-09,
  -2.984508470590343e-11,   4.312236639918371e-13,  -6.128632153852200e-15,   8.960923415265129e-17,  -7.994452661694310e-19,   1.857252038655600e-20,  -2.858044927487547e-22,
  -5.416215509422357e-24,  -8.375095633881367e-26,   1.366398598125937e-02,  -3.584952913649191e-04,   7.009657298268764e-06,  -1.213266100631842e-07,   1.943130094787781e-09,
  -2.985192137187524e-11,   4.313570086405265e-13,  -6.130163208294605e-15,   8.965351654014147e-17,  -8.002814611115825e-19,   1.855363293810089e-20,  -2.861486208732779e-22,
  -5.400652896671155e-24,  -8.338061796931006e-26,   1.366411578789938e-02,  -3.585020250831232e-04,   7.009872918108733e-06,  -1.213321300969400e-07,   1.943249737355113e-09,
  -2.985430106980169e-11,   4.314034256068590e-13,  -6.130696230950272e-15,   8.966892591192320e-17,  -8.005725847105088e-19,   1.854706324683095e-20,  -2.862682782334891e-22,
  -5.395238521442198e-24,  -8.325181736505913e-26,   1.366413638654807e-02,  -3.585030936408620e-04,   7.009907134414909e-06,  -1.213330060637598e-07,   1.943268723377482e-09,
  -2.985467870143793e-11,   4.314107915841507e-13,  -6.130780820246092e-15,   8.967137100000392e-17,  -8.006187857314515e-19,   1.854602092941688e-20,  -2.862872605333304e-22,
  -5.394379445461281e-24,  -8.323138318303153e-26,   1.227603027005023e-01,  -3.123635977228611e-03,   5.680143976423904e-05,  -8.568373972705014e-07,   1.071979619122693e-08,
  -1.052491416705502e-10,   4.279951515089312e-13,   9.696339313077765e-15,  -2.925803262700389e-16,   9.569012612162369e-18,  -4.541494596973612e-20,  -1.538423816801967e-22,
  -7.231093784037886e-23,  -9.003431461185111e-25,   1.227656399364494e-01,  -3.123877309206123e-03,   5.680747297852005e-05,  -8.569359028224314e-07,   1.072038891821616e-08,
  -1.052295388506188e-10,   4.272228443418178e-13,   9.728606704742168e-15,  -2.927857850000689e-16,   9.567976609083466e-18,  -4.584833622664677e-20,  -1.601275945900603e-22,
  -7.200719100471199e-23,  -8.948839064002485e-25,   1.227750580336268e-01,  -3.124303165778504e-03,   5.681811894909889e-05,  -8.571097023218759e-07,   1.072143390965667e-08,
  -1.051948977329512e-10,   4.258596493251807e-13,   9.785540005699056e-15,  -2.931497943228728e-16,   9.566122520975993e-18,  -4.661153903814140e-20,  -1.711859521954980e-22,
  -7.147184671736519e-23,  -8.852849144279056e-25,   1.227864472823713e-01,  -3.124818154460483e-03,   5.683099262897586e-05,  -8.573198367656974e-07,   1.072269601570316e-08,
  -1.051529212873560e-10,   4.242104952521715e-13,   9.854379164872758e-15,  -2.935924682901657e-16,   9.563836221146968e-18,  -4.753182053289809e-20,  -1.845034114126252e-22,
  -7.082556048752405e-23,  -8.737353707896922e-25,   1.227975045899776e-01,  -3.125318136730483e-03,   5.684349065434661e-05,  -8.575238046280994e-07,   1.072391966598352e-08,
  -1.051120790945879e-10,   4.226087221423360e-13,   9.921201525223807e-15,  -2.940248324231815e-16,   9.561570428959091e-18,  -4.842250279596018e-20,  -1.973749511512605e-22,
  -7.019926167187430e-23,  -8.625834247486648e-25,   1.228064128022182e-01,  -3.125720944726227e-03,   5.685355924457553e-05,  -8.576880991028878e-07,   1.072490429004797e-08,
  -1.050791111074124e-10,   4.213177773692805e-13,   9.975028762755741e-15,  -2.943750161659342e-16,   9.559712049936916e-18,  -4.913808427085308e-20,  -2.077035078968811e-22,
  -6.969551282916573e-23,  -8.536424981387049e-25,   1.228122994785826e-01,  -3.125987127165202e-03,   5.686021255773083e-05,  -8.577966524649985e-07,   1.072555435736503e-08,
  -1.050572941112978e-10,   4.204644606793509e-13,   1.001059487274091e-14,  -2.946073289942685e-16,   9.558467899160524e-18,  -4.960997837422310e-20,  -2.145086104048424e-22,
  -6.936303017908767e-23,  -8.477554505110952e-25,   1.228153226577574e-01,  -3.126123828941614e-03,   5.686362940434973e-05,  -8.578523968704741e-07,   1.072588802645555e-08,
  -1.050460800394930e-10,   4.200261539259486e-13,   1.002885915911595e-14,  -2.947269162638023e-16,   9.557823975408404e-18,  -4.985202513231377e-20,  -2.179972359533863e-22,
  -6.919240349788320e-23,  -8.447386372467654e-25,   1.228163749171547e-01,  -3.126171409940497e-03,   5.686481867737683e-05,  -8.578717987530453e-07,   1.072600413571970e-08,
  -1.050421752870539e-10,   4.198735832534218e-13,   1.003521611334460e-14,  -2.947685848198272e-16,   9.557599057612169e-18,  -4.993622502104255e-20,  -2.192105106115617e-22,
  -6.913303425825794e-23,  -8.436896361426537e-25,   1.228165418969032e-01,  -3.126178960422656e-03,   5.686500739901990e-05,  -8.578748775423691e-07,   1.072602255936389e-08,
  -1.050415555810396e-10,   4.198493717243347e-13,   1.003622486977672e-14,  -2.947751991869053e-16,   9.557563328563059e-18,  -4.994958416695943e-20,  -2.194029943981045e-22,
  -6.912361407635390e-23,  -8.435232229101007e-25,   3.397502281177147e-01,  -8.074286528756048e-03,   1.226242712296299e-04,  -1.183748438442441e-06,   5.404008250200610e-10,
   2.426430860095812e-10,  -5.648762959286591e-12,   5.909648808754397e-14,   3.409348190946439e-16,  -1.322400594097556e-17,   6.260536086622141e-19,  -7.623232952438640e-21,
  -2.587581706352760e-22,   3.404703437558378e-26,   3.397617246398648e-01,  -8.074618652467036e-03,   1.226245304358952e-04,  -1.183519989637964e-06,   5.324685649816688e-10,
   2.427587035228848e-10,  -5.647814662656912e-12,   5.905083466625828e-14,   3.435252061032609e-16,  -1.326324195786697e-17,   6.244716055765616e-19,  -7.621615132998532e-21,
  -2.583440710061517e-22,   5.906070618507813e-26,   3.397820104487823e-01,  -8.075204637583645e-03,   1.226249841845900e-04,  -1.183116800225254e-06,   5.184730722460855e-10,
   2.429626388704272e-10,  -5.646135880823487e-12,   5.897017088306257e-14,   3.480905754264628e-16,  -1.333246635313210e-17,   6.216821983638498e-19,  -7.618613677244372e-21,
  -2.576152872073354e-22,   1.030549888961200e-25,   3.398065402905890e-01,  -8.075913127693950e-03,   1.226255266820640e-04,  -1.182629109435644e-06,   5.015514611061878e-10,
   2.432091141047414e-10,  -5.644096514066506e-12,   5.887244791929991e-14,   3.536018502904829e-16,  -1.341615887613875e-17,   6.183127269606802e-19,  -7.614734576319234e-21,
  -2.567372648695864e-22,   1.560105238678166e-25,   3.398303534622606e-01,  -8.076600824041356e-03,   1.226260468577281e-04,  -1.182155510793308e-06,   4.851262367029289e-10,
   2.434482563528643e-10,  -5.642106934380903e-12,   5.877738806726903e-14,   3.589424531393994e-16,  -1.349739056291978e-17,   6.150453694173559e-19,  -7.610708055055048e-21,
  -2.558882646909948e-22,   2.071652647077935e-25,   3.398495370620435e-01,  -8.077154756208245e-03,   1.226264612679955e-04,  -1.181773873526927e-06,   4.718957140241985e-10,
   2.436408118103552e-10,  -5.640497141903801e-12,   5.870067147052152e-14,   3.632378653405769e-16,  -1.356281822550872e-17,   6.124158502413219e-19,  -7.607278027487879e-21,
  -2.552067245792977e-22,   2.481936686586442e-25,   3.398622132519618e-01,  -8.077520751873287e-03,   1.226267328329016e-04,  -1.181521639419969e-06,   4.631539193546316e-10,
   2.437680027493264e-10,  -5.639429988843821e-12,   5.864991113608062e-14,   3.660728166026803e-16,  -1.360604586390206e-17,   6.106795920685015e-19,  -7.604920510332408e-21,
  -2.547575476296692e-22,   2.752159917147647e-25,   3.398687230847640e-01,  -8.077708698001514e-03,   1.226268715924789e-04,  -1.181392088130839e-06,   4.586648060223639e-10,
   2.438333070616108e-10,  -5.638880894267982e-12,   5.862382244095152e-14,   3.675276546118672e-16,  -1.362824350010545e-17,   6.097883361633703e-19,  -7.603681709284558e-21,
  -2.545272355312092e-22,   2.890659159808029e-25,   3.398709888921219e-01,  -8.077774112755336e-03,   1.226269197772642e-04,  -1.181346993911112e-06,   4.571023635151436e-10,
   2.438560345448467e-10,  -5.638689608106656e-12,   5.861473871492990e-14,   3.680338579537841e-16,  -1.363596929734576e-17,   6.094781893424824e-19,  -7.603246063115544e-21,
  -2.544471308097542e-22,   2.938821615185194e-25,   3.398713484445650e-01,  -8.077784493099082e-03,   1.226269274182206e-04,  -1.181339837950978e-06,   4.568544270459035e-10,
   2.438596409751396e-10,  -5.638659245616524e-12,   5.861329709525818e-14,   3.681141775560743e-16,  -1.363719526098365e-17,   6.094289763013889e-19,  -7.603176719936846e-21,
  -2.544344220224448e-22,   2.946462270444336e-25,   6.598736078845144e-01,  -1.379906716843370e-02,   1.361829716051747e-04,   4.767699400718707e-07,  -3.941357751209058e-08,
   4.622405937785133e-10,   4.568079818678385e-12,  -2.462774694712792e-13,   2.858598012255987e-15,   6.753789293399255e-17,  -1.483429021052768e-18,   9.109216226127982e-21,
  -3.188078394863499e-23,  -2.273811461059303e-23,   6.598863305826693e-01,  -1.379893156587619e-02,   1.361608383100466e-04,   4.771992474741186e-07,  -3.940706665348786e-08,
   4.617593804275132e-10,   4.575454335716685e-12,  -2.460484909023492e-13,   2.852338106608104e-15,   6.757867243360212e-17,  -1.483501246051788e-18,   8.949165653592251e-21,
  -2.915677534105834e-23,  -2.262490282375457e-23,   6.599087783014864e-01,  -1.379869219556405e-02,   1.361217867599476e-04,   4.779564014981791e-07,  -3.939556976057698e-08,
   4.609106388901863e-10,   4.588453427055890e-12,  -2.456443472441138e-13,   2.841292265877041e-15,   6.764996391668332e-17,  -1.483615178807580e-18,   8.667422658161516e-21,
  -2.436776512121392e-23,  -2.242545740389497e-23,   6.599359194547496e-01,  -1.379840258029406e-02,   1.360745703216485e-04,   4.788713369775822e-07,  -3.938165331587389e-08,
   4.598849574185460e-10,   4.604149287208684e-12,  -2.451554705788546e-13,   2.827935312142971e-15,   6.773503907928792e-17,  -1.483729972961544e-18,   8.327875012475088e-21,
  -1.860669887751387e-23,  -2.218482847667711e-23,   6.599622646132074e-01,  -1.379812125290503e-02,   1.360287387786089e-04,   4.797588880803859e-07,  -3.936812853281379e-08,
   4.588898991433506e-10,   4.619362701480453e-12,  -2.446806887400612e-13,   2.814968437949582e-15,   6.781644636904144e-17,  -1.483817430973851e-18,   7.999439131183375e-21,
  -1.304514265553976e-23,  -2.195179756947679e-23,   6.599834857785397e-01,  -1.379789449467263e-02,   1.359918213248304e-04,   4.804734204205599e-07,  -3.935722244881603e-08,
   4.580887629325054e-10,   4.631601338056628e-12,  -2.442980764792177e-13,   2.804522395723305e-15,   6.788118169499332e-17,  -1.483870756753489e-18,   7.735707711037124e-21,
  -8.587115925224842e-24,  -2.176447699656643e-23,   6.599975072930740e-01,  -1.379774459591163e-02,   1.359674288107650e-04,   4.809453419360950e-07,  -3.935001067020844e-08,
   4.575596164610386e-10,   4.639680042317179e-12,  -2.440451878612227e-13,   2.797619800966911e-15,   6.792354444305591e-17,  -1.483897628255044e-18,   7.561855504986945e-21,
  -5.652223227467871e-24,  -2.164089752827949e-23,   6.600047076859077e-01,  -1.379766759687725e-02,   1.359549026697970e-04,   4.811876254941914e-07,  -3.934630545940620e-08,
   4.572879455875543e-10,   4.643826255387508e-12,  -2.439152973714105e-13,   2.794074979521186e-15,   6.794517210219502e-17,  -1.483908845657090e-18,   7.472702883770325e-21,
  -4.148379115664759e-24,  -2.157749494228078e-23,   6.600072137967083e-01,  -1.379764079365793e-02,   1.359505429244181e-04,   4.812719432478357e-07,  -3.934501556943239e-08,
   4.571933993814235e-10,   4.645268970784367e-12,  -2.438700846080025e-13,   2.792841170774552e-15,   6.795267949985222e-17,  -1.483912339266207e-18,   7.441692994593779e-21,
  -3.625487489352524e-24,  -2.155543686010918e-23,   6.600076114795156e-01,  -1.379763654021374e-02,   1.359498510972708e-04,   4.812853227796909e-07,  -3.934481086943897e-08,
   4.571783967384759e-10,   4.645497890287921e-12,  -2.438629098139134e-13,   2.792645382267087e-15,   6.795386985668453e-17,  -1.483912874164401e-18,   7.436773125140643e-21,
  -3.542537183561670e-24,  -2.155193700992157e-23,   1.067655268638772e+00,  -1.754472315799820e-02,   1.670665116644084e-05,   3.531752477816167e-06,  -2.148350644892325e-08,
  -1.225077810656000e-09,   1.532739921175084e-11,   4.459401632847387e-13,  -1.005274138701968e-14,  -1.180839653865594e-16,   7.698285352556640e-18,   3.068001179277002e-20,
  -5.233406654195145e-21,  -1.547280114765727e-23,   1.067656810868707e+00,  -1.754373387258418e-02,   1.669468650636757e-05,   3.530611292258957e-06,  -2.146225574944965e-08,
  -1.224206134413324e-09,   1.530165784076382e-11,   4.455456245909765e-13,  -1.002126591775486e-14,  -1.179300972424247e-16,   7.666969224703452e-18,   3.056857584342936e-20,
  -5.210264318209815e-21,  -1.544235706944026e-23,   1.067659531260013e+00,  -1.754198852255066e-02,   1.667358432225195e-05,   3.528598314815900e-06,  -2.142478773177459e-08,
  -1.222668677485858e-09,   1.525630335413218e-11,   4.448498738709289e-13,  -9.965833433788613e-15,  -1.176590598467133e-16,   7.611826723499112e-18,   3.037213119234352e-20,
  -5.169530506599176e-21,  -1.538827618712218e-23,   1.067662819256125e+00,  -1.753987846925080e-02,   1.664808377532507e-05,   3.526165330146723e-06,  -2.137953070002034e-08,
  -1.220810641061970e-09,   1.520157357263538e-11,   4.440092782441881e-13,  -9.898985164328477e-15,  -1.173321114772803e-16,   7.545344069862663e-18,   3.013490652649063e-20,
  -5.120446940580152e-21,  -1.532226830759144e-23,   1.067666009584134e+00,  -1.753783052939626e-02,   1.662334548961967e-05,   3.523804612774967e-06,  -2.133564793175632e-08,
  -1.219008014433100e-09,   1.514856134822015e-11,   4.431939886993760e-13,  -9.834279515528213e-15,  -1.170155453315697e-16,   7.481008928049803e-18,   2.990494808355503e-20,
  -5.072977316082189e-21,  -1.525755277865033e-23,   1.067668578523718e+00,  -1.753618106758727e-02,   1.660342896673360e-05,   3.521903696185751e-06,  -2.130033373762431e-08,
  -1.217556646056045e-09,   1.510594015569577e-11,   4.425377358663700e-13,  -9.782289016598293e-15,  -1.167611177281750e-16,   7.429327993953709e-18,   2.971993797358340e-20,
  -5.034864937476932e-21,  -1.520496671606703e-23,   1.067670275471723e+00,  -1.753509129508004e-02,   1.659027451133576e-05,   3.520648018778495e-06,  -2.127701693934985e-08,
  -1.216598001276372e-09,   1.507781827868200e-11,   4.421043567420522e-13,  -9.748000882931948e-15,  -1.165932871237055e-16,   7.395249816965224e-18,   2.959780531007077e-20,
  -5.009743757259477e-21,  -1.516999895138759e-23,   1.067671146762107e+00,  -1.753453169499185e-02,   1.658352093262747e-05,   3.520003296483101e-06,  -2.126504826985882e-08,
  -1.216105812998256e-09,   1.506338915542803e-11,   4.418818764921901e-13,  -9.730412757024137e-15,  -1.165071879134585e-16,   7.377771178479576e-18,   2.953512116853076e-20,
  -4.996862222607938e-21,  -1.515197366797768e-23,   1.067671449995068e+00,  -1.753433692905374e-02,   1.658117058432927e-05,   3.519778915381044e-06,  -2.126088335952653e-08,
  -1.215934521730132e-09,   1.505836900464161e-11,   4.418044530400978e-13,  -9.724294305958451e-15,  -1.164772345930184e-16,   7.371691099997762e-18,   2.951330925132092e-20,
  -4.992381771446850e-21,  -1.514568905951741e-23,   1.067671498112650e+00,  -1.753430602276137e-02,   1.658079763050410e-05,   3.519743310158645e-06,  -2.126022248808360e-08,
  -1.215907341084409e-09,   1.505757247256535e-11,   4.417921676138038e-13,  -9.723323546632867e-15,  -1.164724820922925e-16,   7.370726442418052e-18,   2.950984827943163e-20,
  -4.991670931954782e-21,  -1.514469126925526e-23,   1.517284449755341e+00,  -1.505397672110641e-02,  -1.992835791533456e-04,   1.348597065426437e-06,   9.393179780664242e-08,
   5.375208280984619e-10,  -4.458829889637570e-11,  -9.352908152523005e-13,   1.522116927481637e-14,   8.668624753817900e-16,   4.010647759668969e-18,  -5.035414537447452e-19,
  -1.058881813819181e-20,   1.594691408086852e-22,   1.517265872309766e+00,  -1.505359571024322e-02,  -1.992310936023075e-04,   1.349085934481867e-06,   9.386957218198961e-08,
   5.357248113127978e-10,  -4.454804083086598e-11,  -9.324314647787086e-13,   1.523610921901285e-14,   8.643119557426747e-16,   3.948541887415057e-18,  -5.023643960319116e-19,
  -1.051457199162940e-20,   1.596807827493902e-22,   1.517233096072936e+00,  -1.505292330138901e-02,  -1.991385103646227e-04,   1.349947196639727e-06,   9.375982022975678e-08,
   5.325602554833124e-10,  -4.447697414808500e-11,  -9.273930603855237e-13,   1.526226095330298e-14,   8.598164685095175e-16,   3.839324010255529e-18,  -5.002863249314480e-19,
  -1.038397840375884e-20,   1.600449812569958e-22,   1.517193469444661e+00,  -1.505211003144452e-02,  -1.990266060367458e-04,   1.350986336042077e-06,   9.362718569458080e-08,
   5.287413811282944e-10,  -4.439098752601371e-11,  -9.213124337076811e-13,   1.529352664731715e-14,   8.543889116628439e-16,   3.707884189708424e-18,  -4.977716021817759e-19,
  -1.022676932578317e-20,   1.604696921847002e-22,   1.517155007663919e+00,  -1.505132032857577e-02,  -1.989180218260059e-04,   1.351992700672696e-06,   9.349850882513594e-08,
   5.250421799439661e-10,  -4.430745910368535e-11,  -9.154218804023237e-13,   1.532350581569045e-14,   8.491287696429780e-16,   3.580940096181266e-18,  -4.953284134225902e-19,
  -1.007489113618571e-20,   1.608656806989113e-22,   1.517124028413575e+00,  -1.505068401505385e-02,  -1.988305840207270e-04,   1.352801687486136e-06,   9.339490750214594e-08,
   5.220679454508106e-10,  -4.424013120423680e-11,  -9.106854133448669e-13,   1.534739014284926e-14,   8.448976014224055e-16,   3.479143908814918e-18,  -4.933588557417642e-19,
  -9.953067345917051e-21,   1.611730714272757e-22,   1.517103560353822e+00,  -1.505026348235271e-02,  -1.987728244070184e-04,   1.353335406610715e-06,   9.332647853367897e-08,
   5.201054583595069e-10,  -4.419562339236808e-11,  -9.075599877701033e-13,   1.536304230544053e-14,   8.421048230869397e-16,   3.412107591455357e-18,  -4.920567561628386e-19,
  -9.872826041906576e-21,   1.613705345921726e-22,   1.517093049791700e+00,  -1.505004749765638e-02,  -1.987431675638407e-04,   1.353609235791787e-06,   9.329134593594800e-08,
   5.190985032139154e-10,  -4.417276073064499e-11,  -9.059562759687092e-13,   1.537104024806875e-14,   8.406715574044963e-16,   3.377751880896835e-18,  -4.913878672333393e-19,
  -9.831697879127829e-21,   1.614701989778126e-22,   1.517089391616226e+00,  -1.504997231885791e-02,  -1.987328461006505e-04,   1.353704502990319e-06,   9.327911913886604e-08,
   5.187481626426760e-10,  -4.416480225523533e-11,  -9.053983032568941e-13,   1.537381761253649e-14,   8.401728489511532e-16,   3.365805298422830e-18,  -4.911550229660895e-19,
  -9.817395506264678e-21,   1.615046112663670e-22,   1.517088811119948e+00,  -1.504996038885911e-02,  -1.987312082680182e-04,   1.353719618610230e-06,   9.327717898222592e-08,
   5.186925750351690e-10,  -4.416353931132049e-11,  -9.053097708237288e-13,   1.537425803866311e-14,   8.400937180419114e-16,   3.363910073585674e-18,  -4.911180723044402e-19,
  -9.815126517527950e-21,   1.615100588930656e-22,   1.890010962052768e+00,  -4.951320178843587e-03,  -1.525878276857033e-04,  -3.628528861662630e-06,  -6.237349147301214e-08,
  -4.265618592458465e-10,   1.932763428846537e-11,   9.936861737472644e-13,   2.600213224740238e-14,   3.631926166381420e-16,  -2.769867663738848e-18,  -3.340906932053007e-19,
  -1.075150942783133e-20,  -1.936471159890039e-22,   1.889996586862806e+00,  -4.952342046940138e-03,  -1.526227543156535e-04,  -3.628912139222037e-06,  -6.234550877999252e-08,
  -4.245868900559495e-10,   1.939559766354821e-11,   9.948654664518208e-13,   2.598830534974846e-14,   3.614175127334454e-16,  -2.836464048378323e-18,  -3.354480269426549e-19,
  -1.075353395134160e-20,  -1.925965083735226e-22,   1.889971218970618e+00,  -4.954145234039995e-03,  -1.526843699185742e-04,  -3.629586927503795e-06,  -6.229605529329385e-08,
  -4.211001612226430e-10,   1.951548930221149e-11,   9.969414379713601e-13,   2.596367910685663e-14,   3.582796847052065e-16,  -2.953980971987375e-18,  -3.378366941196683e-19,
  -1.075677823556538e-20,  -1.907335111212531e-22,   1.889940539337907e+00,  -4.956325811445476e-03,  -1.527588539990725e-04,  -3.630400311359765e-06,  -6.223612334549571e-08,
  -4.168807975297821e-10,   1.966041069219544e-11,   9.994433441393047e-13,   2.593351122971165e-14,   3.544758096457496e-16,  -3.096093736265193e-18,  -3.407141981883437e-19,
  -1.076014152782474e-20,  -1.884651243548850e-22,   1.889910751363348e+00,  -4.958442829048608e-03,  -1.528311386133087e-04,  -3.631187230132913e-06,  -6.217780397520384e-08,
  -4.127813954959365e-10,   1.980104208783648e-11,   1.001863361688332e-12,   2.590381682066698e-14,   3.507730652703880e-16,  -3.234063420221840e-18,  -3.434961698696010e-19,
  -1.076281986511611e-20,  -1.862466817651228e-22,   1.889886751178490e+00,  -4.960148378735338e-03,  -1.528893534840529e-04,  -3.631819226120700e-06,  -6.213072345631940e-08,
  -4.094765989324071e-10,   1.991429264386931e-11,   1.003806589178891e-12,   2.587960308478274e-14,   3.477830283479943e-16,  -3.345215483496384e-18,  -3.457290460605330e-19,
  -1.076455675934815e-20,  -1.844478571587355e-22,   1.889870890629234e+00,  -4.961275428298286e-03,  -1.529278126605258e-04,  -3.632235889770203e-06,  -6.209956493001867e-08,
  -4.072916890108800e-10,   1.998910675651358e-11,   1.005087547328898e-12,   2.586345995623483e-14,   3.458037690906829e-16,  -3.418665057945718e-18,  -3.472004409349372e-19,
  -1.076549831147312e-20,  -1.832535194124493e-22,   1.889862744966631e+00,  -4.961854238459811e-03,  -1.529475607583802e-04,  -3.632449573226492e-06,  -6.208354852080029e-08,
  -4.061692751414820e-10,   2.002752122236084e-11,   1.005744423605323e-12,   2.585512542468876e-14,   3.447862449939049e-16,  -3.456385543361673e-18,  -3.479548172640860e-19,
  -1.076591805568794e-20,  -1.826384072836143e-22,   1.889859909712714e+00,  -4.962055701227842e-03,  -1.529544338618242e-04,  -3.632523901015640e-06,  -6.207797147265224e-08,
  -4.057785517460165e-10,   2.004089074589200e-11,   1.005972902977208e-12,   2.585221746795578e-14,   3.444319146426779e-16,  -3.469514593751032e-18,  -3.482171847469798e-19,
  -1.076605399356001e-20,  -1.824240314735782e-22,   1.889859459793098e+00,  -4.962087670717493e-03,  -1.529555245095543e-04,  -3.632535693595236e-06,  -6.207708635845032e-08,
  -4.057165466205198e-10,   2.004301225843090e-11,   1.006009152268975e-12,   2.585175568074060e-14,   3.443756791439246e-16,  -3.471597997346218e-18,  -3.482588093482571e-19,
  -1.076607508274008e-20,  -1.823899996774686e-22,   1.232808994071319e-02,  -3.074809993468982e-04,   5.713916131585503e-06,  -9.429775158690045e-08,   1.432997884759853e-09,
  -2.118389481129625e-11,   2.944953946773475e-13,  -3.594978613700787e-15,   7.041861527404776e-17,  -3.640518678199295e-19,  -2.751048374677372e-23,  -5.685070157378455e-22,
  -4.108369123021777e-24,   1.630546531049768e-25,   1.232862724219619e-02,  -3.075075907139268e-04,   5.714724542485035e-06,  -9.431767115289163e-08,   1.433414203826182e-09,
  -2.119099331666914e-11,   2.946802230189019e-13,  -3.596282326644596e-15,   7.041774844980288e-17,  -3.669374631315390e-19,  -5.113839529670891e-23,  -5.673287210298881e-22,
  -4.069565126514001e-24,   1.627941316086768e-25,   1.232957538102743e-02,  -3.075545161652332e-04,   5.716151187160357e-06,  -9.435282495790778e-08,   1.434149016682080e-09,
  -2.120352086487807e-11,   2.950063532395716e-13,  -3.598590632823371e-15,   7.041613945697279e-17,  -3.720242161582326e-19,  -9.263591414929573e-23,  -5.652510938069619e-22,
  -4.001176557346550e-24,   1.623386352492269e-25,   1.233072198620758e-02,  -3.076112667083524e-04,   5.717876626754911e-06,  -9.439534255288240e-08,   1.435037920544460e-09,
  -2.121867293990701e-11,   2.954007093581474e-13,  -3.601395295262981e-15,   7.041405880154155e-17,  -3.781667784241780e-19,  -1.424841321503533e-22,  -5.627413323575539e-22,
  -3.918618953714832e-24,   1.617949832802306e-25,   1.233183520123878e-02,  -3.076663673077996e-04,   5.719551994706350e-06,  -9.443662757385877e-08,   1.435901230333343e-09,
  -2.123338612423133e-11,   2.957835390870550e-13,  -3.604132069122339e-15,   7.041189810086392e-17,  -3.841210869199680e-19,  -1.905296254107987e-22,  -5.603075246596106e-22,
  -3.838617686295264e-24,   1.612746673619281e-25,   1.233273207202354e-02,  -3.077107614776377e-04,   5.720901893769317e-06,  -9.446989318354160e-08,   1.436596971809252e-09,
  -2.124524161333724e-11,   2.960919385084531e-13,  -3.606346841405242e-15,   7.041005696863834e-17,  -3.889115099931037e-19,  -2.289865789841695e-22,  -5.583487466399971e-22,
  -3.774272411867132e-24,   1.608608299581631e-25,   1.233332474705901e-02,  -3.077400992156517e-04,   5.721794002725541e-06,  -9.449187790114379e-08,   1.437056837745792e-09,
  -2.125307685362763e-11,   2.962957217296027e-13,  -3.607815247164459e-15,   7.040879133883383e-17,  -3.920738577653455e-19,  -2.542769840733458e-22,  -5.570553284515300e-22,
  -3.731804235303690e-24,   1.605899726345971e-25,   1.233362912604765e-02,  -3.077551664328739e-04,   5.722252180384806e-06,  -9.450316915568796e-08,   1.437293041842439e-09,
  -2.125710104081811e-11,   2.964003736537611e-13,  -3.608570865764940e-15,   7.040812624569230e-17,  -3.936969229364310e-19,  -2.672273360830011e-22,  -5.563913756539311e-22,
  -3.710010214505051e-24,   1.604516767473467e-25,   1.233373506985246e-02,  -3.077604108567074e-04,   5.722411659209768e-06,  -9.450709934742347e-08,   1.437375261358174e-09,
  -2.125850176237263e-11,   2.964367986322737e-13,  -3.608834107976718e-15,   7.040789234807710e-17,  -3.942616941455074e-19,  -2.717288595307240e-22,  -5.561603251563839e-22,
  -3.702427056080389e-24,   1.604036691943031e-25,   1.233375188176590e-02,  -3.077612430812313e-04,   5.722436966582765e-06,  -9.450772302266156e-08,   1.437388308772349e-09,
  -2.125872404074334e-11,   2.964425787707988e-13,  -3.608875892388847e-15,   7.040785511759618e-17,  -3.943513083671994e-19,  -2.724429061578566e-22,  -5.561236627277929e-22,
  -3.701223829493293e-24,   1.603960571115893e-25,   1.111133727185207e-01,  -2.707592827596077e-03,   4.748104987896955e-05,  -7.015251973340025e-07,   8.735356287674560e-09,
  -9.247301558974518e-11,   6.173077371069987e-13,   5.416261633134258e-15,   7.577275372946421e-18,   6.515530842824682e-18,  -1.342199011698851e-19,  -3.748679731345587e-21,
  -5.502739203418157e-23,   1.647518391720532e-24,   1.111178339320023e-01,  -2.707790436185339e-03,   4.748596840774445e-05,  -7.016117977596004e-07,   8.736224450344672e-09,
  -9.246201145698199e-11,   6.173156890897508e-13,   5.437761494233207e-15,   7.000733798442534e-18,   6.496663246419613e-18,  -1.345430162362204e-19,  -3.736794119439782e-21,
  -5.465149298147888e-23,   1.644528476604815e-24,   1.111257061889625e-01,  -2.708139139440621e-03,   4.749464762631005e-05,  -7.017645970833691e-07,   8.737756341437147e-09,
  -9.244256031922483e-11,   6.173284838676480e-13,   5.475646906183664e-15,   5.982324101989672e-18,   6.463420737189099e-18,  -1.351112753959322e-19,  -3.715839016546158e-21,
  -5.398898426636650e-23,   1.639292028063670e-24,   1.111352260466238e-01,  -2.708560828886305e-03,   4.750514330733390e-05,  -7.019493491651464e-07,   8.739608727049632e-09,
  -9.241898158495441e-11,   6.173418453263474e-13,   5.521370749773696e-15,   4.748992938252937e-18,   6.423308168061392e-18,  -1.357952133106305e-19,  -3.690529129855250e-21,
  -5.318917935783202e-23,   1.633026902492946e-24,   1.111444684303359e-01,  -2.708970233035080e-03,   4.751533304195008e-05,  -7.021286880884630e-07,   8.741406996540225e-09,
  -9.239603087175109e-11,   6.173526046829131e-13,   5.565667049189429e-15,   3.549755000268354e-18,   6.384456140274489e-18,  -1.364558132442292e-19,  -3.665989155609084e-21,
  -5.241410307484802e-23,   1.627014604552912e-24,   1.111519144550250e-01,  -2.709300069009058e-03,   4.752354226775599e-05,  -7.022731502865374e-07,   8.742855662195134e-09,
  -9.237749850133134e-11,   6.173596861753449e-13,   5.601286012781633e-15,   2.582277473358897e-18,   6.353220861437438e-18,  -1.369855823352022e-19,  -3.646241729124355e-21,
  -5.179068020915974e-23,   1.622221014334338e-24,   1.111568348907987e-01,  -2.709518031139703e-03,   4.752896702671226e-05,  -7.023686029870949e-07,   8.743812915836142e-09,
  -9.236523132626814e-11,   6.173635883285992e-13,   5.624790323662723e-15,   1.942308025474169e-18,   6.332612175139684e-18,  -1.373344693513014e-19,  -3.633203528348395e-21,
  -5.137920517500056e-23,   1.619077834217327e-24,   1.111593618427746e-01,  -2.709629968956015e-03,   4.753175297694082e-05,  -7.024176208612769e-07,   8.744304511674220e-09,
  -9.235892495742943e-11,   6.173653518021240e-13,   5.636851002512716e-15,   1.613443899731974e-18,   6.322038221095244e-18,  -1.375132763591232e-19,  -3.626511037915334e-21,
  -5.116803839645260e-23,   1.617471174275763e-24,   1.111602413831365e-01,  -2.709668930548307e-03,   4.753272266467966e-05,  -7.024346817177102e-07,   8.744475616147096e-09,
  -9.235672891965231e-11,   6.173659273014460e-13,   5.641047255280902e-15,   1.498946455638699e-18,   6.318359386359937e-18,  -1.375754539764238e-19,  -3.624182171576089e-21,
  -5.109456295622104e-23,   1.616913156507897e-24,   1.111603809546288e-01,  -2.709675113245385e-03,   4.753287654135054e-05,  -7.024373890281453e-07,   8.744502768072192e-09,
  -9.235638038894057e-11,   6.173660168071123e-13,   5.641713067953223e-15,   1.480775709157845e-18,   6.317775678428910e-18,  -1.375853179644030e-19,  -3.623812637047627e-21,
  -5.108290451101738e-23,   1.616824663476372e-24,   3.093257424435462e-01,  -7.149641465347095e-03,   1.086090339584807e-04,  -1.143064432195275e-06,   4.176660351486617e-09,
   1.278746971181765e-10,  -3.883290429766881e-12,   6.635230324567518e-14,   2.024930120404475e-16,   1.617370842271122e-18,   3.821837660064949e-20,  -1.806172258423161e-20,
  -1.254177975474626e-22,   5.720203769815173e-24,   3.093359291741923e-01,  -7.149962525211839e-03,   1.086113525397624e-04,  -1.142943451187725e-06,   4.171205808054115e-09,
   1.280053716194346e-10,  -3.882756108150576e-12,   6.635538259673010e-14,   2.026309480394522e-16,   1.525853873382259e-18,   3.748689492114076e-20,  -1.802020457516566e-20,
  -1.244519676157042e-22,   5.714387185127959e-24,   3.093539039939918e-01,  -7.150529012548246e-03,   1.086154412200204e-04,  -1.142729878683129e-06,   4.161581792158996e-09,
   1.282359525954856e-10,  -3.881813008879384e-12,   6.636056623345665e-14,   2.028718684259200e-16,   1.364544475297592e-18,   3.620100749946385e-20,  -1.794697828091634e-20,
  -1.227509295744186e-22,   5.704249589607594e-24,   3.093756396335435e-01,  -7.151213967593236e-03,   1.086203810454838e-04,  -1.142471454677901e-06,   4.149945372690515e-09,
   1.285147797184119e-10,  -3.880672128674140e-12,   6.636640852271395e-14,   2.031589919054203e-16,   1.169783565483732e-18,   3.465431235308283e-20,  -1.785848782829137e-20,
  -1.206994203658348e-22,   5.692205161479409e-24,   3.093967405253502e-01,  -7.151878860338352e-03,   1.086251720918134e-04,  -1.142220403259228e-06,   4.138650030979790e-09,
   1.287854663476390e-10,  -3.879564089585223e-12,   6.637163461785120e-14,   2.034333425646932e-16,   9.810230419719160e-19,   3.316139498390599e-20,  -1.777264036795728e-20,
  -1.187134782448518e-22,   5.680736108009181e-24,   3.094137393507938e-01,  -7.152414453623354e-03,   1.086290285076780e-04,  -1.142018032058367e-06,   4.129551433818637e-09,
   1.290035320905027e-10,  -3.878671118146937e-12,   6.637552578746151e-14,   2.036512250062353e-16,   8.291820489933768e-19,   3.196486341939650e-20,  -1.770352354146737e-20,
  -1.171176389591652e-22,   5.671656410764521e-24,   3.094249719801876e-01,  -7.152768346657267e-03,   1.086315751973535e-04,  -1.141884246374126e-06,   4.123539626464424e-09,
   1.291476279643258e-10,  -3.878080888663772e-12,   6.637794097715208e-14,   2.037936689634651e-16,   7.289569049836849e-19,   3.117722068950818e-20,  -1.765787215289970e-20,
  -1.160650911888150e-22,   5.665734664821530e-24,   3.094307405063456e-01,  -7.152950082260132e-03,   1.086328825615470e-04,  -1.141815521726046e-06,   4.120452394370206e-09,
   1.292216286616167e-10,  -3.877777725324737e-12,   6.637913306539603e-14,   2.038663488011681e-16,   6.775201010780657e-19,   3.077365665267539e-20,  -1.763443405834594e-20,
  -1.155251600651208e-22,   5.662717630945665e-24,   3.094327483000343e-01,  -7.153013336140687e-03,   1.086333375247645e-04,  -1.141791598410675e-06,   4.119377873856316e-09,
   1.292473853710700e-10,  -3.877672198253138e-12,   6.637954030703090e-14,   2.038915706265616e-16,   6.596223994878315e-19,   3.063334018997915e-20,  -1.762627717902054e-20,
  -1.153373278462962e-22,   5.661671352209166e-24,   3.094330669094940e-01,  -7.153023373619540e-03,   1.086334097175123e-04,  -1.141787801964154e-06,   4.119207363146036e-09,
   1.292514726103241e-10,  -3.877655452166912e-12,   6.637960456632945e-14,   2.038955694212199e-16,   6.567825346614805e-19,   3.061108090995254e-20,  -1.762498284030998e-20,
  -1.153075260023586e-22,   5.661505503811713e-24,   6.068783283479989e-01,  -1.269670842177739e-02,   1.384389782563496e-04,  -7.606573251050403e-08,  -2.956946491240957e-08,
   5.013158323529432e-10,  -7.594025548518347e-13,  -1.267414536572222e-13,   4.288943848425987e-15,   1.246976224417660e-17,  -1.417680391767182e-18,  -9.927227749626752e-21,
  -5.013121905751710e-22,   6.466628974149883e-24,   6.068912735768334e-01,  -1.269672816761786e-02,   1.384223402504747e-04,  -7.559784168820418e-08,  -2.957040136157309e-08,
   5.010669567742380e-10,  -7.482698005912053e-13,  -1.267006504649290e-13,   4.282870888253818e-15,   1.242031378703792e-17,  -1.420577566221325e-18,  -9.882195246779414e-21,
  -4.968756879452829e-22,   6.425045027610100e-24,   6.069141143683846e-01,  -1.269676290284152e-02,   1.383929818295743e-04,  -7.477243045173497e-08,  -2.957204106253614e-08,
   5.006278765747537e-10,  -7.286388961266171e-13,  -1.266287869995760e-13,   4.272145296827108e-15,   1.233324770784674e-17,  -1.425667503359164e-18,  -9.802975178129383e-21,
  -4.890605410441837e-22,   6.352169264527587e-24,   6.069417315348707e-01,  -1.269680472327447e-02,   1.383574806390219e-04,  -7.377465741144019e-08,  -2.957400219910047e-08,
   5.000970462350329e-10,  -7.049232034007250e-13,  -1.265421177608455e-13,   4.259159211319120e-15,   1.222828379509200e-17,  -1.431784548201719e-18,  -9.707589458785907e-21,
  -4.796327119071856e-22,   6.264897694431542e-24,   6.069685395372660e-01,  -1.269684513151624e-02,   1.383230159966561e-04,  -7.280637486328592e-08,  -2.957588342257150e-08,
   4.995818404692676e-10,  -6.819236919855114e-13,  -1.264582199510919e-13,   4.246535241997579e-15,   1.212671807609520e-17,  -1.437683383101734e-18,  -9.615415364551521e-21,
  -4.705036450501487e-22,   6.181064685918933e-24,   6.069901340926597e-01,  -1.269687754754003e-02,   1.382952512301663e-04,  -7.202658135776763e-08,  -2.957738271812189e-08,
   4.991668797699083e-10,  -6.634122719993980e-13,  -1.263908040314411e-13,   4.236353186023642e-15,   1.204513491576357e-17,  -1.442407156157199e-18,  -9.541463602008918e-21,
  -4.631660322607591e-22,   6.114165253331739e-24,   6.070044025956457e-01,  -1.269689890073089e-02,   1.382769045242870e-04,  -7.151142633654328e-08,  -2.957836550080835e-08,
   4.988927214073988e-10,  -6.511884310676882e-13,  -1.263463404249380e-13,   4.229619036497257e-15,   1.199134194673146e-17,  -1.445514724688288e-18,  -9.492744969864210e-21,
  -4.583255963389524e-22,   6.070269809195639e-24,   6.070117299089367e-01,  -1.269690984597839e-02,   1.382674825381790e-04,  -7.124690627048729e-08,  -2.957886775662354e-08,
   4.987519404145082e-10,  -6.449134333277241e-13,  -1.263235320727850e-13,   4.226158868184392e-15,   1.196375242194385e-17,  -1.447106340370265e-18,  -9.467771042532047e-21,
  -4.558423098768687e-22,   6.047823303240701e-24,   6.070142802083108e-01,  -1.269691365228666e-02,   1.382642031177521e-04,  -7.115484347942340e-08,  -2.957904218136792e-08,
   4.987029422808387e-10,  -6.427297656903517e-13,  -1.263155975278986e-13,   4.224954229107368e-15,   1.195415532022920e-17,  -1.447659637388079e-18,  -9.459085855711731e-21,
  -4.549783783052560e-22,   6.040025848515010e-24,   6.070146849038411e-01,  -1.269691425613940e-02,   1.382636827183320e-04,  -7.114023465964662e-08,  -2.957906984165988e-08,
   4.986951670458225e-10,  -6.423832668340130e-13,  -1.263143386200139e-13,   4.224763055440612e-15,   1.195263266215528e-17,  -1.447747405757715e-18,  -9.457707978526305e-21,
  -4.548413031977071e-22,   6.038789223927185e-24,   9.980015768733220e-01,  -1.724910329805208e-02,   5.629141364151859e-05,   3.015552746111109e-06,  -4.149191683024318e-08,
  -7.455541401318158e-10,   2.308845448728186e-11,   1.139398518228933e-13,  -9.094008413133005e-15,   1.457872844938624e-16,   3.933089699976613e-18,  -1.787211535457298e-19,
  -2.424766149145991e-21,   1.051864846161891e-22,   9.980068076997711e-01,  -1.724825763013083e-02,   5.626825603572518e-05,   3.014855746026584e-06,  -4.145972662486954e-08,
  -7.453224151370844e-10,   2.306491434497450e-11,   1.144087234897067e-13,  -9.077884475707734e-15,   1.448945056453093e-16,   3.918453813503456e-18,  -1.779781866766939e-19,
  -2.416832983659023e-21,   1.047077394613194e-22,   9.980160358320134e-01,  -1.724676559478859e-02,   5.622740873113581e-05,   3.013626057274981e-06,  -4.140295328346201e-08,
  -7.449127936150083e-10,   2.302341152019797e-11,   1.152336262976876e-13,  -9.049483410237717e-15,   1.433222711776181e-16,   3.892668423431601e-18,  -1.766700208513033e-19,
  -2.402838875765236e-21,   1.038656046619223e-22,   9.980271916163725e-01,  -1.724496168080508e-02,   5.617804071388768e-05,   3.012139409853008e-06,  -4.133434799208893e-08,
  -7.444162172714001e-10,   2.297328397724879e-11,   1.162269723505513e-13,  -9.015225487195491e-15,   1.414263654969436e-16,   3.861556407938986e-18,  -1.750929549745711e-19,
  -2.385924022805374e-21,   1.028517438472564e-22,   9.980380183477000e-01,  -1.724321075618590e-02,   5.613014124537048e-05,   3.010696518518289e-06,  -4.126779492235442e-08,
  -7.439328359541083e-10,   2.292468179245320e-11,   1.171869724801809e-13,  -8.982057326649097e-15,   1.395913479867750e-16,   3.831424544294093e-18,  -1.735669610907522e-19,
  -2.369510680362066e-21,   1.018721639491907e-22,   9.980467379933048e-01,  -1.724180043743408e-02,   5.609157278393920e-05,   3.009534373820388e-06,  -4.121421483060234e-08,
  -7.435424914359735e-10,   2.288557197801374e-11,   1.179572438475780e-13,  -8.955401055911320e-15,   1.381170116405841e-16,   3.807201667418999e-18,  -1.723412091934184e-19,
  -2.356293540726162e-21,   1.010863584392789e-22,   9.980524986889975e-01,  -1.724086862348247e-02,   5.606609659815060e-05,   3.008766561958813e-06,  -4.117882679399682e-08,
  -7.432841000205511e-10,   2.285975016888039e-11,   1.184647134842804e-13,  -8.937818157718841e-15,   1.371447177336628e-16,   3.791220568448527e-18,  -1.715329977814758e-19,
  -2.347562454733641e-21,   1.005687405981741e-22,   9.980554567445968e-01,  -1.724039012321894e-02,   5.605301619192337e-05,   3.008372288697306e-06,  -4.116065851689699e-08,
  -7.431512620082271e-10,   2.284649600346984e-11,   1.187248562810009e-13,  -8.928798106017811e-15,   1.366459918491370e-16,   3.783021223320018e-18,  -1.711184809590692e-19,
  -2.343079417584772e-21,   1.003034221122726e-22,   9.980564862692474e-01,  -1.724022358172126e-02,   5.604846388789501e-05,   3.008235063831603e-06,  -4.115433570503140e-08,
  -7.431050039877050e-10,   2.284188381513345e-11,   1.188153270334289e-13,  -8.925660123355762e-15,   1.364725001784614e-16,   3.780168594120545e-18,  -1.709742902257827e-19,
  -2.341519181759519e-21,   1.002111556180076e-22,   9.980566496380818e-01,  -1.724019715411189e-02,   5.604774152135730e-05,   3.008213288399009e-06,  -4.115333240095144e-08,
  -7.430976624075357e-10,   2.284115197397895e-11,   1.188296799679522e-13,  -8.925162241294880e-15,   1.364449739219911e-16,   3.779715979446970e-18,  -1.709514132065129e-19,
  -2.341271599818647e-21,   1.001965179945580e-22,   1.454019122530297e+00,  -1.655756285960208e-02,  -1.739376740195275e-04,   2.871822966050069e-06,   9.226675601976092e-08,
  -7.630880347601788e-10,  -5.933275911302778e-11,   3.155136809475561e-14,   4.294883425118637e-14,   4.827887682789675e-16,  -2.415412916364173e-17,  -6.178798676046759e-19,
   8.854898958190613e-21,   4.881344427132634e-22,   1.454002919151374e+00,  -1.655675767799153e-02,  -1.738862369632584e-04,   2.871108324533305e-06,   9.218462514498509e-08,
  -7.630014349699757e-10,  -5.922208200098187e-11,   3.310165468628629e-14,   4.284867177413148e-14,   4.797337632779782e-16,  -2.409998714576191e-17,  -6.144874340780836e-19,
   8.841111998420446e-21,   4.848932334568353e-22,   1.453974331899501e+00,  -1.655533708561914e-02,  -1.737955127200621e-04,   2.869847401797797e-06,   9.203982964808277e-08,
  -7.628461856328532e-10,  -5.902700320062637e-11,   3.582887286462942e-14,   4.267211862915827e-14,   4.743572002030730e-16,  -2.400452348093765e-17,  -6.085203965662384e-19,
   8.816654479969166e-21,   4.791966988269976e-22,   1.453939770477595e+00,  -1.655361956847884e-02,  -1.736858714741738e-04,   2.868322807069037e-06,   9.186495558968223e-08,
  -7.626543005665946e-10,  -5.879147424062927e-11,   3.911255053725815e-14,   4.245894415919707e-14,   4.678796903203354e-16,  -2.388920891406526e-17,  -6.013372362745331e-19,
   8.786860437631249e-21,   4.723468703015922e-22,   1.453906225744464e+00,  -1.655195252402104e-02,  -1.735795000746335e-04,   2.866842890980933e-06,   9.169541498118467e-08,
  -7.624636813130324e-10,  -5.856320597079270e-11,   4.228555207586288e-14,   4.225232822539674e-14,   4.616163820227984e-16,  -2.377739091172426e-17,  -5.943975991268770e-19,
   8.757709661975803e-21,   4.657373405571356e-22,   1.453879207483656e+00,  -1.655060978349632e-02,  -1.734938562159843e-04,   2.865650787020915e-06,   9.155899568983907e-08,
  -7.623070190069073e-10,  -5.837958745063803e-11,   4.483114608551176e-14,   4.208611751630544e-14,   4.565885678188054e-16,  -2.368740343771727e-17,  -5.888311463251734e-19,
   8.734065386207265e-21,   4.604414741265359e-22,   1.453861356716277e+00,  -1.654972262671202e-02,  -1.734372875511362e-04,   2.864863114003061e-06,   9.146893073715851e-08,
  -7.622019838218807e-10,  -5.825838840473178e-11,   4.650808061072284e-14,   4.197640412690298e-14,   4.532749861333848e-16,  -2.362798634863144e-17,  -5.851646655658046e-19,
   8.718363755787155e-21,   4.569560670848370e-22,   1.453852190240759e+00,  -1.654926706087023e-02,  -1.734082440288606e-04,   2.864458621173644e-06,   9.142270233385470e-08,
  -7.621475752319988e-10,  -5.819618794462152e-11,   4.736767647291682e-14,   4.192009681573186e-14,   4.515759923910368e-16,  -2.359748678918932e-17,  -5.832853735022742e-19,
   8.710276294202774e-21,   4.551704676181568e-22,   1.453848999884026e+00,  -1.654910850204024e-02,  -1.733981363099600e-04,   2.864317836129413e-06,   9.140661597571933e-08,
  -7.621285633799888e-10,  -5.817454503808524e-11,   4.766661369290372e-14,   4.190050423291786e-14,   4.509850697845641e-16,  -2.358687336337473e-17,  -5.826318445722043e-19,
   8.707457585878134e-21,   4.545496610162406e-22,   1.453848493624001e+00,  -1.654908334117657e-02,  -1.733965324085279e-04,   2.864295495595419e-06,   9.140406347549871e-08,
  -7.621255429280540e-10,  -5.817111091700488e-11,   4.771403890594984e-14,   4.189739543007612e-14,   4.508913188032796e-16,  -2.358518926456234e-17,  -5.825281658579871e-19,
   8.707010115918031e-21,   4.544511801887261e-22,   1.867463973933100e+00,  -6.363588073762740e-03,  -2.022876905785666e-04,  -4.658259563955642e-06,  -6.348084496727151e-08,
   4.756194869029949e-10,   6.039551073595465e-11,   1.974288573161074e-12,   3.190161871785358e-14,  -2.274642194527510e-16,  -3.204321250789221e-17,  -1.046699294467596e-18,
  -1.622462222790162e-20,   1.469597811057663e-22,   1.867444938803915e+00,  -6.364896514349782e-03,  -2.023229131901942e-04,  -4.657781130692369e-06,  -6.339496194991046e-08,
   4.794916261217279e-10,   6.047639037447205e-11,   1.973381856289109e-12,   3.176347587323278e-14,  -2.328061088708473e-16,  -3.213641998747707e-17,  -1.045328208620842e-18,
  -1.607044604340723e-20,   1.523509651823434e-22,   1.867411348392020e+00,  -6.367205163332761e-03,  -2.023850245452335e-04,  -4.656933981012311e-06,  -6.324332867381892e-08,
   4.863225570961505e-10,   6.061880717882060e-11,   1.971767324163321e-12,   3.151940729990087e-14,  -2.422259063958603e-16,  -3.230010425970897e-17,  -1.042877030014569e-18,
  -1.579783356314647e-20,   1.618509813279420e-22,   1.867370726029915e+00,  -6.369996609776787e-03,  -2.024600628850717e-04,  -4.655904575095928e-06,  -6.305981658584065e-08,
   4.945799847993280e-10,   6.079051293783684e-11,   1.969790105006391e-12,   3.122374452924061e-14,  -2.536060185617213e-16,  -3.249669809748461e-17,  -1.039858741429522e-18,
  -1.546722858925992e-20,   1.733163931739806e-22,   1.867331285858210e+00,  -6.372706291228569e-03,  -2.025328382168775e-04,  -4.654899986183728e-06,  -6.288150367651564e-08,
   5.025934022419181e-10,   6.095667129336727e-11,   1.967844584795936e-12,   3.093616501653190e-14,  -2.646426193366293e-16,  -3.268614763422986e-17,  -1.036871849255537e-18,
  -1.514528678497799e-20,   1.844233301096337e-22,   1.867299510013346e+00,  -6.374889027044162e-03,  -2.025914144753195e-04,  -4.654086934782562e-06,  -6.273774085870943e-08,
   5.090469220756434e-10,   6.109014571019571e-11,   1.966258630594391e-12,   3.070409855655533e-14,  -2.735255871501213e-16,  -3.283776066290935e-17,  -1.034425007597972e-18,
  -1.488522657893627e-20,   1.933538711017522e-22,   1.867278511458972e+00,  -6.376331267197037e-03,  -2.026300958369120e-04,  -4.653547840470259e-06,  -6.264268811218710e-08,
   5.133103152859023e-10,   6.117815671571104e-11,   1.965201524103082e-12,   3.055055988342500e-14,  -2.793913565812592e-16,  -3.293745106618727e-17,  -1.032788299898578e-18,
  -1.471303904417416e-20,   1.992465642802038e-22,   1.867267727188869e+00,  -6.377071903977632e-03,  -2.026499528993054e-04,  -4.653270419404310e-06,  -6.259385641931349e-08,
   5.154994680873616e-10,   6.122329686325928e-11,   1.964655824813638e-12,   3.047165079476626e-14,  -2.824024851155657e-16,  -3.298849431474521e-17,  -1.031941628957437e-18,
  -1.462450649514272e-20,   2.022701110142118e-22,   1.867263973544090e+00,  -6.377329685799053e-03,  -2.026568631108285e-04,  -4.653173769668388e-06,  -6.257685730754992e-08,
   5.162613743228094e-10,   6.123899911362038e-11,   1.964465439593455e-12,   3.044417628287739e-14,  -2.834503403710531e-16,  -3.300623608682187e-17,  -1.031645959760334e-18,
  -1.459367509747618e-20,   2.033220631459459e-22,   1.867263377888523e+00,  -6.377370592053264e-03,  -2.026579596082647e-04,  -4.653158428376239e-06,  -6.257415965002714e-08,
   5.163822760471711e-10,   6.124149040809091e-11,   1.964435206739447e-12,   3.043981600639236e-14,  -2.836166112700760e-16,  -3.300905030793972e-17,  -1.031598994727683e-18,
  -1.458878178104315e-20,   2.034889734391251e-22,   1.118293274813312e-02,  -2.659360433743056e-04,   4.707090645639800e-06,  -7.440499471656528e-08,   1.073106005436487e-09,
  -1.508265626117860e-11,   2.231176871537172e-13,  -1.602379667970421e-15,   5.101472219114948e-17,  -8.842912677088388e-19,  -2.530510833511235e-20,  -4.672256796827746e-22,
   1.003601312862095e-23,   3.639055464081761e-25,   1.118337525236845e-02,  -2.659570196446338e-04,   4.707696047263846e-06,  -7.441916165950168e-08,   1.073421318869539e-09,
  -1.508585949406102e-11,   2.232494441762055e-13,  -1.605423827127510e-15,   5.091000994014805e-17,  -8.865965517394887e-19,  -2.524175105783603e-20,  -4.645578259157380e-22,
   1.006304199384873e-23,   3.640354195525402e-25,   1.118415610442089e-02,  -2.659940358482666e-04,   4.708764432532205e-06,  -7.444416191005167e-08,   1.073977844181064e-09,
  -1.509151655066038e-11,   2.234817092915474e-13,  -1.610801542982787e-15,   5.072546194211252e-17,  -8.906530713131358e-19,  -2.512981901004110e-20,  -4.598496452931363e-22,
   1.011084221282965e-23,   3.642600874110711e-25,   1.118510039813453e-02,  -2.660388017699868e-04,   4.710056581979411e-06,  -7.447439667187601e-08,   1.074651055779796e-09,
  -1.509836548868360e-11,   2.237621881613138e-13,  -1.617314968709813e-15,   5.050267727253142e-17,  -8.955391756805806e-19,  -2.499423540288904e-20,  -4.541552702685943e-22,
   1.016882276961428e-23,   3.645239911534064e-25,   1.118601718493588e-02,  -2.660822655462768e-04,   4.711311236556205e-06,  -7.450375244813471e-08,   1.075304865016745e-09,
  -1.510502308728460e-11,   2.240340761470457e-13,  -1.623649198900387e-15,   5.028679251654482e-17,  -9.002625358286059e-19,  -2.486236751091361e-20,  -4.486260451268281e-22,
   1.022529393261483e-23,   3.647719210930724e-25,   1.118675579580078e-02,  -2.661172835512480e-04,   4.712322155052119e-06,  -7.452740422951563e-08,   1.075831756435061e-09,
  -1.511039265055762e-11,   2.242528220956968e-13,  -1.628759913175175e-15,   5.011315882385299e-17,  -9.040532921744407e-19,  -2.475596012025041e-20,  -4.441709134440597e-22,
   1.027091593367584e-23,   3.649656386842904e-25,   1.118724388575979e-02,  -2.661404248581946e-04,   4.712990242624945e-06,  -7.454303444846934e-08,   1.076180010451737e-09,
  -1.511394384374442e-11,   2.243972268405358e-13,  -1.632140862513181e-15,   4.999856211324641e-17,  -9.065511437384394e-19,  -2.468556155278752e-20,  -4.412266279330514e-22,
   1.030112447779118e-23,   3.650906638614527e-25,   1.118749455229485e-02,  -2.661523096553634e-04,   4.713333365595150e-06,  -7.455106179121663e-08,   1.076358884471623e-09,
  -1.511576850484769e-11,   2.244713427229399e-13,  -1.633878340188238e-15,   4.993975371803986e-17,  -9.078317411494962e-19,  -2.464938175576945e-20,  -4.397144699841946e-22,
   1.031665705494473e-23,   3.651539409326685e-25,   1.118758180050868e-02,  -2.661564463679612e-04,   4.713452797150644e-06,  -7.455385585739826e-08,   1.076421147815074e-09,
  -1.511640374669674e-11,   2.244971326128162e-13,  -1.634483275849091e-15,   4.991929168566773e-17,  -9.082771195037432e-19,  -2.463678478291553e-20,  -4.391881295663814e-22,
   1.032206632169005e-23,   3.651758164555975e-25,   1.118759564566654e-02,  -2.661571028120311e-04,   4.713471749505565e-06,  -7.455429924083032e-08,   1.076431028368658e-09,
  -1.511650455803887e-11,   2.245012247893502e-13,  -1.634579279854751e-15,   4.991604496428879e-17,  -9.083477785218357e-19,  -2.463478561437908e-20,  -4.391046056444644e-22,
   1.032292484034644e-23,   3.651792807294154e-25,   1.009925582642775e-01,  -2.359176683938816e-03,   3.984306430205099e-05,  -5.756958100830965e-07,   7.047232632183558e-09,
  -7.563931441306700e-11,   7.981988694154058e-13,   8.021478266762724e-15,   1.014555509220513e-16,  -2.538315837099372e-18,  -3.166942514088253e-19,  -3.430079054037185e-21,
   8.418655656601339e-23,   3.517101280617877e-24,   1.009963015147644e-01,  -2.359338847350549e-03,   3.984703471575318e-05,  -5.757665903798226e-07,   7.048357882861453e-09,
  -7.562366623544735e-11,   7.984380034297686e-13,   8.012480543391211e-15,   1.001366644469103e-16,  -2.554999277412240e-18,  -3.161621574724777e-19,  -3.404311654526962e-21,
   8.442646129929944e-23,   3.518039969486823e-24,   1.010029068426164e-01,  -2.359625003407613e-03,   3.985404108853221e-05,  -5.758914714466549e-07,   7.050343668137100e-09,
  -7.559606939169274e-11,   7.988571549271820e-13,   7.996558878889988e-15,   9.781130337581225e-17,  -2.584329405406084e-18,  -3.152220503797711e-19,  -3.358839619490856e-21,
   8.485089153164872e-23,   3.519657769474137e-24,   1.010108945931165e-01,  -2.359971053931749e-03,   3.986251414813331e-05,  -5.760424587179295e-07,   7.052745346736046e-09,
  -7.556272395649690e-11,   7.993592186375500e-13,   7.977229638124436e-15,   9.500258339663642e-17,  -2.619611436264686e-18,  -3.140831807204256e-19,  -3.303845896860518e-21,
   8.536598897986135e-23,   3.521547347294380e-24,   1.010186495049764e-01,  -2.360307022651297e-03,   3.987074056807203e-05,  -5.761890133526054e-07,   7.055077318820344e-09,
  -7.553037898845711e-11,   7.998416125648025e-13,   7.958385196596567e-15,   9.227920958864581e-17,  -2.653669634749027e-18,  -3.129754007662541e-19,  -3.250450303778862e-21,
   8.586796048737047e-23,   3.523310636406040e-24,   1.010248971494482e-01,  -2.360577695359788e-03,   3.987736832449115e-05,  -5.763070606815285e-07,   7.056956255745717e-09,
  -7.550434112103533e-11,   8.002266421854866e-13,   7.943147259015511e-15,   9.008764987021022e-17,  -2.680968190612895e-18,  -3.120814188740443e-19,  -3.207429469521228e-21,
   8.627369498457170e-23,   3.524679313307350e-24,   1.010290256717630e-01,  -2.360756561187142e-03,   3.988174815079994e-05,  -5.763850568243894e-07,   7.058197984841801e-09,
  -7.548714499357459e-11,   8.004793106961113e-13,   7.933050417150278e-15,   8.864066027473868e-17,  -2.698938876841591e-18,  -3.114899221711502e-19,  -3.178999173451920e-21,
   8.654244912957627e-23,   3.525557992657274e-24,   1.010311459243206e-01,  -2.360848420478532e-03,   3.988399750105354e-05,  -5.764251092787956e-07,   7.058835721783619e-09,
  -7.547831681798485e-11,   8.006085263897867e-13,   7.927856598026997e-15,   8.789791899859364e-17,  -2.708146742166946e-18,  -3.111859220988169e-19,  -3.164397973955443e-21,
   8.668066668240467e-23,   3.526001208179502e-24,   1.010318839070022e-01,  -2.360880393444510e-03,   3.988478042390932e-05,  -5.764390495367201e-07,   7.059057699853572e-09,
  -7.547524454606127e-11,   8.006534148782955e-13,   7.926047472758425e-15,   8.763945796908719e-17,  -2.711348289947118e-18,  -3.110800741418391e-19,  -3.159315753505681e-21,
   8.672880612258715e-23,   3.526154188627438e-24,   1.010320010151346e-01,  -2.360885467137532e-03,   3.988490466373882e-05,  -5.764412616463081e-07,   7.059092925090264e-09,
  -7.547475704044683e-11,   8.006605339705801e-13,   7.925760324533324e-15,   8.759844646366360e-17,  -2.711856173206418e-18,  -3.110632757268376e-19,  -3.158509268527119e-21,
   8.673644668282294e-23,   3.526178403391043e-24,   2.823798707742212e-01,  -6.334335573083786e-03,   9.536297323409077e-05,  -1.060196399870471e-06,   5.956574708037126e-09,
   5.772692827171755e-11,  -1.933163772951290e-12,   7.244848285130531e-14,   8.978751783070113e-17,  -1.323577735525838e-17,  -7.569768448569836e-19,  -1.458899546438779e-20,
   3.109259627791198e-22,   1.051773240808850e-23,   2.823888177303528e-01,  -6.334633557651122e-03,   9.536630846755575e-05,  -1.060141088765409e-06,   5.953858126677105e-09,
   5.786881647424666e-11,  -1.932992544564776e-12,   7.240194135645848e-14,   8.665693368283194e-17,  -1.330800159435509e-17,  -7.550248208543632e-19,  -1.451191543932851e-20,
   3.115285690499090e-22,   1.052092623349636e-23,   2.824046050278159e-01,  -6.335159343261564e-03,   9.537219229764658e-05,  -1.060043383534066e-06,   5.949064846534706e-09,
   5.811910503286150e-11,  -1.932697052232599e-12,   7.231962218703074e-14,   8.113968873161157e-17,  -1.343511911168625e-17,  -7.515773714169360e-19,  -1.437588870088325e-20,
   3.125956343745090e-22,   1.052647718722161e-23,   2.824236956272602e-01,  -6.335795106918499e-03,   9.537930497048387e-05,  -1.059925053357907e-06,   5.943269046349354e-09,
   5.842162784419806e-11,  -1.932351056511746e-12,   7.221974743103311e-14,   7.447964266642980e-17,  -1.358827968835515e-17,  -7.474034276398589e-19,  -1.421137369603357e-20,
   3.138922599039397e-22,   1.053304202627666e-23,   2.824422289016574e-01,  -6.336412272294725e-03,   9.538620761291468e-05,  -1.059809987874168e-06,   5.937642876097618e-09,
   5.871517661588963e-11,  -1.932027008087899e-12,   7.212244224586181e-14,   6.802620106914330e-17,  -1.373638796406472e-17,  -7.433459207022981e-19,  -1.405163441810343e-20,
   3.151575069769157e-22,   1.053925662508548e-23,   2.824571593895213e-01,  -6.336909436218060e-03,   9.539176670328622e-05,  -1.059717154657631e-06,   5.933110711248222e-09,
   5.895155867281037e-11,  -1.931774432076996e-12,   7.204380530119680e-14,   6.283600831605078e-17,  -1.385528834442068e-17,  -7.400732837813764e-19,  -1.392292869298820e-20,
   3.161813561725914e-22,   1.054414667166819e-23,   2.824670253480652e-01,  -6.337237945207926e-03,   9.539543927336432e-05,  -1.059655744587918e-06,   5.930116035823029e-09,
   5.910770814638315e-11,  -1.931611679463850e-12,   7.199172163788204e-14,   5.941064262140241e-17,  -1.393365301175161e-17,  -7.379088392929661e-19,  -1.383787168918810e-20,
   3.168601095692563e-22,   1.054731981752430e-23,   2.824720920387479e-01,  -6.337406647794538e-03,   9.539732507328435e-05,  -1.059624186696342e-06,   5.928578156724336e-09,
   5.918788364200905e-11,  -1.931529379361195e-12,   7.196493657285700e-14,   5.765285945662544e-17,  -1.397383436281839e-17,  -7.367966912654541e-19,  -1.379418761435111e-20,
   3.172093592753873e-22,   1.054893116656836e-23,   2.824738555546241e-01,  -6.337465365876897e-03,   9.539798140492196e-05,  -1.059613199358948e-06,   5.928042888564570e-09,
   5.921578711090749e-11,  -1.931500937949875e-12,   7.195560780202326e-14,   5.704125489903899e-17,  -1.398780987490653e-17,  -7.364095020042721e-19,  -1.377898245997821e-20,
   3.173310260700558e-22,   1.054948909028729e-23,   2.824741354006757e-01,  -6.337474683608999e-03,   9.539808555389575e-05,  -1.059611455662017e-06,   5.927957949103948e-09,
   5.922021489569934e-11,  -1.931496434367698e-12,   7.195412717059062e-14,   5.694421155295832e-17,  -1.399002712264275e-17,  -7.363480558440192e-19,  -1.377656958713303e-20,
   3.173503379934587e-22,   1.054957748599045e-23,   5.582903732271656e-01,  -1.160013992991279e-02,   1.350125598913770e-04,  -4.708831991357832e-07,  -1.993245569951906e-08,
   4.560094686186297e-10,  -2.403960342139774e-12,   5.544527169278295e-15,   3.562496792336338e-15,  -5.785913541565408e-17,  -2.145842600036546e-18,  -1.561002191749901e-20,
   4.305811422244375e-22,   2.585961623015407e-23,   5.583030080850448e-01,  -1.160027085949936e-02,   1.350013294938153e-04,  -4.704556288444326e-07,  -1.993572814532781e-08,
   4.560172442689878e-10,  -2.394793670240449e-12,   5.347373980300147e-15,   3.553532647168488e-15,  -5.793232532937143e-17,  -2.143099154997164e-18,  -1.542222560894594e-20,
   4.322715999923558e-22,   2.583607488609679e-23,   5.583253016327371e-01,  -1.160050178904141e-02,   1.349815118091788e-04,  -4.697011693703507e-07,  -1.994149202002824e-08,
   4.560306480506567e-10,  -2.378638009951469e-12,   4.999298609538511e-15,   3.537724751666613e-15,  -5.806068417040015e-17,  -2.138249652403724e-18,  -1.509099646547552e-20,
   4.352678501764654e-22,   2.579450764604469e-23,   5.583522577661069e-01,  -1.160078086479915e-02,   1.349575455474294e-04,  -4.687888606069613e-07,  -1.994844402829955e-08,
   4.560463162194502e-10,  -2.359134925980164e-12,   4.578070339416327e-15,   3.518625859673445e-15,  -5.821455740911064e-17,  -2.132370787024486e-18,  -1.469071020882441e-20,
   4.389135997616908e-22,   2.574418812557897e-23,   5.583784247819613e-01,  -1.160105161213429e-02,   1.349342768955053e-04,  -4.679031985646802e-07,  -1.995517436928618e-08,
   4.560609610378690e-10,  -2.340235699233990e-12,   4.168803637363817e-15,   3.500101960064607e-15,  -5.836253254014363e-17,  -2.126648136149079e-18,  -1.430237034724243e-20,
   4.424762771501304e-22,   2.569527010058026e-23,   5.583995034920495e-01,  -1.160126959758043e-02,   1.349155300978779e-04,  -4.671897148091404e-07,  -1.996058296806062e-08,
   4.560723532977347e-10,  -2.325035097457941e-12,   3.838857417776419e-15,   3.485191527895808e-15,  -5.848073496951566e-17,  -2.122026861607458e-18,  -1.398970890551776e-20,
   4.453629302012482e-22,   2.565580606236927e-23,   5.584134313907372e-01,  -1.160141357723434e-02,   1.349031416314609e-04,  -4.667182546094538e-07,  -1.996415037870777e-08,
   4.560796825225471e-10,  -2.315002737481818e-12,   3.620714780478687e-15,   3.475344951321752e-15,  -5.855834938941313e-17,  -2.118967715048794e-18,  -1.378319605576085e-20,
   4.472784321814745e-22,   2.562969850714030e-23,   5.584205838669267e-01,  -1.160148749873498e-02,   1.348967792780003e-04,  -4.664761363715845e-07,  -1.996598040726009e-08,
   4.560833850022045e-10,  -2.309854328021786e-12,   3.508651085022353e-15,   3.470290111417788e-15,  -5.859805609496346e-17,  -2.117394995497551e-18,  -1.367716913938803e-20,
   4.482646079883166e-22,   2.561628101467484e-23,   5.584230733253032e-01,  -1.160151322477483e-02,   1.348945647575518e-04,  -4.663918647647916e-07,  -1.996661704596091e-08,
   4.560846639033148e-10,  -2.308062963907196e-12,   3.469640407131304e-15,   3.468531022494384e-15,  -5.861185217960409e-17,  -2.116847324887456e-18,  -1.364026985011175e-20,
   4.486082478780083e-22,   2.561160928558200e-23,   5.584234683668059e-01,  -1.160151730699990e-02,   1.348942133415167e-04,  -4.663784920149281e-07,  -1.996671805658936e-08,
   4.560848663829504e-10,  -2.307778726955580e-12,   3.463449670760735e-15,   3.468251893287653e-15,  -5.861404027953898e-17,  -2.116760404225015e-18,  -1.363441464762812e-20,
   4.486627973929971e-22,   2.561086786719470e-23,   9.301178317082965e-01,  -1.666624567327533e-02,   8.810197308740700e-05,   2.263063408986520e-06,  -5.075007667541663e-08,
  -1.805030463257941e-10,   2.311453248026441e-11,  -7.933219913207280e-14,  -3.071108261235052e-15,   1.319689469359299e-16,  -4.472941724417106e-18,  -1.589399782850286e-19,
   3.055364579534415e-21,   8.539811855858877e-23,   9.301260343173741e-01,  -1.666560978866504e-02,   8.807360908134228e-05,   2.262892937547710e-06,  -5.071767228884276e-08,
  -1.806525210250149e-10,   2.310609514744716e-11,  -7.890744218945570e-14,  -3.089386018579447e-15,   1.311735934658325e-16,  -4.454452534935956e-18,  -1.583181392343357e-19,
   3.046266916262950e-21,   8.535089677058766e-23,   9.301405058102674e-01,  -1.666448779944410e-02,   8.802357514079960e-05,   2.262592026129415e-06,  -5.066050403146336e-08,
  -1.809156017455332e-10,   2.309116869181793e-11,  -7.816011645981533e-14,  -3.121574355941529e-15,   1.297727837920021e-16,  -4.421872900252490e-18,  -1.572211798054150e-19,
   3.030298764310426e-21,   8.526723930372983e-23,   9.301580012462176e-01,  -1.666313114490782e-02,   8.796309878781037e-05,   2.262227970402139e-06,  -5.059139229087377e-08,
  -1.812325821629091e-10,   2.307305365397572e-11,  -7.726012809791366e-14,  -3.160389430741390e-15,   1.280833490391619e-16,  -4.382553409808150e-18,  -1.558952127805388e-19,
   3.011133936409334e-21,   8.516549464769496e-23,   9.301749816935513e-01,  -1.666181419815991e-02,   8.790441579993584e-05,   2.261874352431048e-06,  -5.052431736410190e-08,
  -1.815391108923737e-10,   2.305539909214408e-11,  -7.639028856878935e-14,  -3.197958090576236e-15,   1.264479227294937e-16,  -4.344462107347372e-18,  -1.546084999343277e-19,
   2.992679129660233e-21,   8.506608976198034e-23,   9.301886581854663e-01,  -1.666075333315007e-02,   8.785716046700123e-05,   2.261589340137347e-06,  -5.047029528016309e-08,
  -1.817851956694204e-10,   2.304112759659600e-11,  -7.569231384444132e-14,  -3.228142514066279e-15,   1.251337738786004e-16,  -4.313832865631059e-18,  -1.535723097357852e-19,
   2.977919176136337e-21,   8.498554282297229e-23,   9.301976940285269e-01,  -1.666005235701783e-02,   8.782594424689859e-05,   2.261400939563590e-06,  -5.043460463196645e-08,
  -1.819473883948294e-10,   2.303167318524749e-11,  -7.523245255334196e-14,  -3.248048514689386e-15,   1.242670375477754e-16,  -4.293621225297080e-18,  -1.528877949215200e-19,
   2.968218237139718e-21,   8.493208416917378e-23,   9.302023339522000e-01,  -1.665969237983250e-02,   8.780991608837409e-05,   2.261304165378819e-06,  -5.041627769069225e-08,
  -1.820305537391629e-10,   2.302681045853986e-11,  -7.499670827154090e-14,  -3.258259043670222e-15,   1.238224309421157e-16,  -4.283250099614688e-18,  -1.525363199752531e-19,
   2.963252430873268e-21,   8.490455680802845e-23,   9.302039488542075e-01,  -1.665956708768648e-02,   8.780433779697147e-05,   2.261270478821002e-06,  -5.040989913591529e-08,
  -1.820594797766387e-10,   2.302511675908886e-11,  -7.491472158823613e-14,  -3.261810977432873e-15,   1.236677617687057e-16,  -4.279641688575087e-18,  -1.524139948538657e-19,
   2.961526594028489e-21,   8.489496380378743e-23,   9.302042051137860e-01,  -1.665954720560589e-02,   8.780345262059655e-05,   2.261265133066068e-06,  -5.040888696160104e-08,
  -1.820640689712269e-10,   2.302484793616913e-11,  -7.490171457624423e-14,  -3.262374528587103e-15,   1.236432217095603e-16,  -4.279069147689087e-18,  -1.523945839670140e-19,
   2.961252848820736e-21,   8.489344096120698e-23,   1.385257410753716e+00,  -1.778776942527979e-02,  -1.313646035282299e-04,   4.151852499660655e-06,   6.367948556666549e-08,
  -2.012904966561371e-09,  -3.818111667641297e-11,   1.455268636730644e-12,   3.813040947212514e-14,  -8.222399434569421e-16,  -3.450312008768398e-17,   2.623777221499647e-19,
   2.258874135528514e-20,  -9.414989581534274e-23,   1.385245166651077e+00,  -1.778660827743693e-02,  -1.313290798801088e-04,   4.149989084724777e-06,   6.362693830954314e-08,
  -2.010083426542588e-09,  -3.808392911396174e-11,   1.452528105735027e-12,   3.798914273550800e-14,  -8.209118486201690e-16,  -3.436876780866426e-17,   2.617337115864271e-19,
   2.247051956828022e-20,  -9.334508456821183e-23,   1.385223564411569e+00,  -1.778455983575152e-02,  -1.312664216057235e-04,   4.146703196877689e-06,   6.353432782198528e-08,
  -2.005109144246434e-09,  -3.791273902077604e-11,   1.447696021683139e-12,   3.774033144238034e-14,  -8.185710584763744e-16,  -3.413228555201437e-17,   2.606021379244011e-19,
   2.226284620976254e-20,  -9.192429879369666e-23,   1.385197447307909e+00,  -1.778208355730791e-02,  -1.311906950323279e-04,   4.142733507883537e-06,   6.342252951397027e-08,
  -1.999101635269711e-09,  -3.770624310096210e-11,   1.441859191723680e-12,   3.744024247462235e-14,  -8.157450616951218e-16,  -3.384732205042158e-17,   2.592420017176760e-19,
   2.201330658520919e-20,  -9.020519510063344e-23,   1.385172098044359e+00,  -1.777968038170194e-02,  -1.311172233341630e-04,   4.138883613176554e-06,   6.331419347661263e-08,
  -1.993277442212265e-09,  -3.750631258131809e-11,   1.436199361187055e-12,   3.714973251047587e-14,  -8.130063399375874e-16,  -3.357172062696548e-17,   2.579301680360061e-19,
   2.177270610260346e-20,  -8.853530999553283e-23,   1.385151680422904e+00,  -1.777774495365389e-02,  -1.310580658015793e-04,   4.135784916343679e-06,   6.322705947303437e-08,
  -1.988591127886307e-09,  -3.734563184084592e-11,   1.431644501576874e-12,   3.691628147550143e-14,  -8.108034214599981e-16,  -3.335043930960929e-17,   2.568795088314833e-19,
   2.158005713517450e-20,  -8.718943073158461e-23,   1.385138190494310e+00,  -1.777646632105098e-02,  -1.310189903871463e-04,   4.133738687690479e-06,   6.316955138792131e-08,
  -1.985497225475600e-09,  -3.723964302464029e-11,   1.428636994852984e-12,   3.676230469113457e-14,  -8.093494123905581e-16,  -3.320458154581447e-17,   2.561882573410918e-19,
   2.145333161620850e-20,  -8.629981628406321e-23,   1.385131263287476e+00,  -1.777580976357767e-02,  -1.309989278756046e-04,   4.132688264058043e-06,   6.314003940467959e-08,
  -1.983909202711189e-09,  -3.718527021522620e-11,   1.427093195834479e-12,   3.668331781592141e-14,  -8.086032153472679e-16,  -3.312978800137583e-17,   2.558341961860236e-19,
   2.138842889863556e-20,  -8.584287661792881e-23,   1.385128852291995e+00,  -1.777558125571689e-02,  -1.309919456641954e-04,   4.132322720178381e-06,   6.312977085736896e-08,
  -1.983356611209779e-09,  -3.716635441356168e-11,   1.426555973790156e-12,   3.665583964283904e-14,  -8.083435751233867e-16,  -3.310377313616002e-17,   2.557111099554847e-19,
   2.136586703560050e-20,  -8.568382245045890e-23,   1.385128469704123e+00,  -1.777554499528262e-02,  -1.309908377180306e-04,   4.132264716517004e-06,   6.312814154022351e-08,
  -1.983268928927093e-09,  -3.716335317076182e-11,   1.426470729335547e-12,   3.665147989642559e-14,  -8.083023776149106e-16,  -3.309964577578483e-17,   2.556915848919546e-19,
   2.136228811289680e-20,  -8.565858218111410e-23,   1.838396334943499e+00,  -8.221417149106675e-03,  -2.636560186263169e-04,  -5.498430516280734e-06,  -3.447182716608021e-08,
   2.684966965697438e-09,   1.263937741771703e-10,   2.515479486601069e-12,  -1.204259898963370e-14,  -2.581850518654979e-15,  -8.601538493412159e-17,  -1.008926844031767e-18,
   3.562021394680049e-20,   2.196561374811412e-21,   1.838371580347426e+00,  -8.222954562672033e-03,  -2.636744086387324e-04,  -5.495873049807285e-06,  -3.429455789218357e-08,
   2.689778587686364e-09,   1.263548528530284e-10,   2.506648849240928e-12,  -1.239768725421187e-14,  -2.586430001241234e-15,  -8.577606772440021e-17,  -9.929115731241036e-19,
   3.603354066281349e-20,   2.195939602312965e-21,   1.838327899190144e+00,  -8.225666761393684e-03,  -2.637067771529977e-04,  -5.491356736005996e-06,  -3.398181082949054e-08,
   2.698254579732748e-09,   1.262854225311188e-10,   2.491054942647188e-12,  -1.302340879173163e-14,  -2.594443492836445e-15,  -8.535174781568566e-17,  -9.646582154551723e-19,
   3.675940663717862e-20,   2.194683209111380e-21,   1.838275077284486e+00,  -8.228945371613162e-03,  -2.637457794924695e-04,  -5.485889389358767e-06,  -3.360371507849559e-08,
   2.708479630753228e-09,   1.262001839001518e-10,   2.472178104910130e-12,  -1.377860556998344e-14,  -2.604019139959174e-15,  -8.483518767409957e-17,  -9.305045552576396e-19,
   3.763122737804060e-20,   2.192892941902769e-21,   1.838223796411576e+00,  -8.232127131864452e-03,  -2.637834977822729e-04,  -5.480575330377001e-06,  -3.323675219313842e-08,
   2.718380565358772e-09,   1.261160940226123e-10,   2.453831470747910e-12,  -1.451023151273699e-14,  -2.613195290316751e-15,  -8.433010370963205e-17,  -8.973606963770163e-19,
   3.847137765298772e-20,   2.190871861062110e-21,   1.838182483576507e+00,  -8.234689558140123e-03,  -2.638137796223516e-04,  -5.476289776354555e-06,  -3.294119375636265e-08,
   2.726338442006297e-09,   1.260473921161096e-10,   2.439036493536601e-12,  -1.509853656190287e-14,  -2.620501716892111e-15,  -8.392063436473895e-17,  -8.706695555583357e-19,
   3.914374001347518e-20,   2.189041341930476e-21,   1.838155183994124e+00,  -8.236382392238933e-03,  -2.638337386407745e-04,  -5.473455700593821e-06,  -3.274592462059345e-08,
   2.731587955428418e-09,   1.260015254371888e-10,   2.429252855561290e-12,  -1.548674594074409e-14,  -2.625287690870550e-15,  -8.364880531678056e-17,  -8.530372239371119e-19,
   3.958584106326263e-20,   2.187732885482555e-21,   1.838141164106199e+00,  -8.237251628604024e-03,  -2.638439728791073e-04,  -5.471999569352027e-06,  -3.264565408902945e-08,
   2.734281075363533e-09,   1.259778255460411e-10,   2.424226216558221e-12,  -1.568594510663932e-14,  -2.627732535823696e-15,  -8.350881966950678e-17,  -8.439836806888610e-19,
   3.981220476478399e-20,   2.187030393213506e-21,   1.838136284316661e+00,  -8.237554155978105e-03,  -2.638475325044897e-04,  -5.471492638509740e-06,  -3.261075553076830e-08,
   2.735218001512263e-09,   1.259695534813553e-10,   2.422476287859432e-12,  -1.575525191194133e-14,  -2.628581419960432e-15,  -8.346003462836745e-17,  -8.408327556956122e-19,
   3.989088496874690e-20,   2.186781026603068e-21,   1.838135509959409e+00,  -8.237602162036914e-03,  -2.638480972495707e-04,  -5.471412190296779e-06,  -3.260521768237285e-08,
   2.735366657950367e-09,   1.259682397221312e-10,   2.422198581156881e-12,  -1.576624869877554e-14,  -2.628716028079892e-15,  -8.345229018420183e-17,  -8.403327589501523e-19,
   3.990336531638454e-20,   2.186741225020998e-21,   1.018923139544658e-02,  -2.315799723005170e-04,   3.908202116583745e-06,  -5.936996589627122e-08,   8.221673932672567e-10,
  -1.011895811720758e-11,   1.947485331887031e-13,  -7.033736934960306e-16,  -2.163248359995052e-18,  -2.091344595602074e-18,  -2.770058410229865e-20,   5.502828213573671e-22,
   3.417449146771704e-23,   5.616978911402489e-25,   1.018959872019454e-02,  -2.315967035328290e-04,   3.908666130100445e-06,  -5.937946508532626e-08,   8.224411605972594e-10,
  -1.012045372563068e-11,   1.947406022287250e-13,  -7.103534404285258e-16,  -2.273312925641269e-18,  -2.088355167253504e-18,  -2.748916974229151e-20,   5.542177478342158e-22,
   3.417553318195267e-23,   5.586347465512956e-25,   1.019024690605181e-02,  -2.316262282302087e-04,   3.909485014436337e-06,  -5.939622772813671e-08,   8.229242174201771e-10,
  -1.012310388307296e-11,   1.947263771550544e-13,  -7.226610000594205e-16,  -2.466798559332625e-18,  -2.083063958143748e-18,  -2.711613491597784e-20,   5.611421951312556e-22,
   3.417606994417846e-23,   5.531863731627353e-25,   1.019103075995686e-02,  -2.316619335180729e-04,   3.910475431573823e-06,  -5.941649930296942e-08,   8.235083177692632e-10,
  -1.012632745500088e-11,   1.947087836213931e-13,  -7.375292267889917e-16,  -2.699527270865463e-18,  -2.076638006682721e-18,  -2.666507727485355e-20,   5.694830947361119e-22,
   3.417450132094686e-23,   5.465245662244540e-25,   1.019179177527030e-02,  -2.316965994770567e-04,   3.911437134904287e-06,  -5.943618070711054e-08,   8.240753341204484e-10,
  -1.012947669964719e-11,   1.946912945344526e-13,  -7.519481288867253e-16,  -2.924161815217926e-18,  -2.070370799424930e-18,  -2.622722503723080e-20,   5.775463389578204e-22,
   3.417065782852494e-23,   5.399809086226537e-25,   1.019240488482164e-02,  -2.317245287055594e-04,   3.912212030747474e-06,  -5.945203730749763e-08,   8.245321019506114e-10,
  -1.013202790921425e-11,   1.946769130374912e-13,  -7.635530950334669e-16,  -3.104197053181081e-18,  -2.065301286678534e-18,  -2.587452013111709e-20,   5.840174991667520e-22,
   3.416589997653388e-23,   5.346550106158567e-25,   1.019281003897708e-02,  -2.317429852048004e-04,   3.912724146527271e-06,  -5.946251581150205e-08,   8.248339194839420e-10,
  -1.013372066170633e-11,   1.946672671616534e-13,  -7.712161931298041e-16,  -3.222707057493869e-18,  -2.061941312156395e-18,  -2.564147197652798e-20,   5.882814761848074e-22,
   3.416194301034922e-23,   5.311092688999752e-25,   1.019301811191451e-02,  -2.317524639216801e-04,   3.912987166733065e-06,  -5.946789725551486e-08,   8.249889152012517e-10,
  -1.013459212241880e-11,   1.946622694506427e-13,  -7.751499326122649e-16,  -3.283427193360026e-18,  -2.060212675735894e-18,  -2.552179495333287e-20,   5.904674925275300e-22,
   3.415965957927190e-23,   5.292802045223318e-25,   1.019309053470322e-02,  -2.317557631429837e-04,   3.913078717184812e-06,  -5.946977035317333e-08,   8.250428625560747e-10,
  -1.013489578472838e-11,   1.946605229393136e-13,  -7.765188472662180e-16,  -3.304539037788841e-18,  -2.059610510285150e-18,  -2.548014099355873e-20,   5.912277589692001e-22,
   3.415882480626092e-23,   5.286422864248499e-25,   1.019310202725447e-02,  -2.317562866871519e-04,   3.913093245163918e-06,  -5.947006758972225e-08,   8.250514232429041e-10,
  -1.013494398800969e-11,   1.946602454592724e-13,  -7.767360628501541e-16,  -3.307888135490200e-18,  -2.059514931300939e-18,  -2.547353111880891e-20,   5.913483744383651e-22,
   3.415869044036136e-23,   5.285409961680251e-25,   9.215215123690212e-02,  -2.066256531138188e-03,   3.356491891986890e-05,  -4.739205485591135e-07,   5.745407514666442e-09,
  -5.359789336012936e-11,   1.035845778005578e-12,   7.165585305570207e-15,  -2.383079624724922e-16,  -1.632090164046759e-17,  -3.063430561701012e-19,   5.722916674981875e-21,
   3.134553328707485e-22,   5.293431769578264e-24,   9.215530444611060e-02,  -2.066389997607944e-03,   3.356815887964737e-05,  -4.739706859698492e-07,   5.746856435072122e-09,
  -5.358464754919573e-11,   1.035195007086335e-12,   7.111314680893406e-15,  -2.395379942081013e-16,  -1.628995737538558e-17,  -3.044037409965167e-19,   5.760060090770645e-21,
   3.134690329627162e-22,   5.265674845861941e-24,   9.216086858136877e-02,  -2.066625512742435e-03,   3.357387650050808e-05,  -4.740591443901013e-07,   5.749412324101052e-09,
  -5.356136156973417e-11,   1.034044124310448e-12,   7.015639265867926e-15,  -2.417017537290225e-16,  -1.623520165693562e-17,  -3.009818537943930e-19,   5.825429644986426e-21,
   3.134810937495341e-22,   5.216281764091025e-24,   9.216759721607633e-02,  -2.066910319679420e-03,   3.358079143532768e-05,  -4.741660925414126e-07,   5.752501645096217e-09,
  -5.353335124490644e-11,   1.032648062801718e-12,   6.900094381396299e-15,  -2.443068549910829e-16,  -1.616872824331976e-17,  -2.968442236129961e-19,   5.904182681205958e-21,
   3.134750333266397e-22,   5.155850638700172e-24,   9.217412970108216e-02,  -2.067186825763146e-03,   3.358750551379565e-05,  -4.742698985083281e-07,   5.755499353817762e-09,
  -5.350631346777739e-11,   1.031288193378474e-12,   6.788079553532056e-15,  -2.468239676958573e-16,  -1.610392305504850e-17,  -2.928276965947661e-19,   5.980326322699267e-21,
   3.134475440442833e-22,   5.096452616906998e-24,   9.217939250342308e-02,  -2.067409590111827e-03,   3.359291513294815e-05,  -4.743535107849332e-07,   5.757913299469894e-09,
  -5.348464255639710e-11,   1.030189415209427e-12,   6.697952567784275e-15,  -2.488432133058987e-16,  -1.605152100700255e-17,  -2.895922245515408e-19,   6.041444170749791e-21,
   3.134099277964780e-22,   5.048081152416393e-24,   9.218287022486345e-02,  -2.067556795994363e-03,   3.359649012649058e-05,  -4.744087542031727e-07,   5.759507916333632e-09,
  -5.347037680973198e-11,   1.029461757252719e-12,   6.638452568173606e-15,  -2.501733294352141e-16,  -1.601679896640292e-17,  -2.874543903547961e-19,   6.081720228992368e-21,
   3.133775004168604e-22,   5.015864442094441e-24,   9.218465624928968e-02,  -2.067632395475661e-03,   3.359832618461517e-05,  -4.744371224634781e-07,   5.760326681210854e-09,
  -5.346306736053288e-11,   1.029087574491724e-12,   6.607913288480592e-15,  -2.508551195630850e-16,  -1.599893798003163e-17,  -2.863565468524244e-19,   6.102369913397269e-21,
   3.133585067838791e-22,   4.999241473866977e-24,   9.218527789909919e-02,  -2.067658708920396e-03,   3.359896526181709e-05,  -4.744469959975532e-07,   5.760611636379151e-09,
  -5.346052589689775e-11,   1.028957257924555e-12,   6.597286491783053e-15,  -2.510922177894688e-16,  -1.599271659812050e-17,  -2.859744384889182e-19,   6.109551801303080e-21,
   3.133515233228557e-22,   4.993443284707363e-24,   9.218537654672572e-02,  -2.067662884518436e-03,   3.359906667553392e-05,  -4.744485627772556e-07,   5.760656853726592e-09,
  -5.346012272774822e-11,   1.028936574739105e-12,   6.595600292735359e-15,  -2.511298322772954e-16,  -1.599172912734313e-17,  -2.859138034505042e-19,   6.110691210288265e-21,
   3.133503974590236e-22,   4.992522603231836e-24,   2.584901476784802e-01,  -5.620626237464388e-03,   8.324426344606312e-05,  -9.574880877443247e-07,   6.810433062081063e-09,
   3.532412825960987e-11,   1.670276931824314e-14,   6.094572062421229e-14,  -1.031114625789102e-15,  -4.985179836785903e-17,  -8.573922443070633e-19,   1.534324602604855e-20,
   9.810648622474310e-22,   1.542688629976954e-23,   2.584979595029579e-01,  -5.620895410134216e-03,   8.324809423565988e-05,  -9.574539873952323e-07,   6.810423604741107e-09,
   3.544147844307660e-11,   1.392602214738889e-14,   6.077965927590009e-14,  -1.034536494322829e-15,  -4.976849239938576e-17,  -8.513197976889392e-19,   1.545169299633579e-20,
   9.811636631652219e-22,   1.534973930524564e-23,   2.585117438823129e-01,  -5.621370361584404e-03,   8.325485371214114e-05,  -9.573937281592475e-07,   6.810403715172818e-09,
   3.564827997914304e-11,   9.019223716912588e-15,   6.048687305899565e-14,  -1.040553607434395e-15,  -4.962104765043976e-17,  -8.406047740061590e-19,   1.564257307697000e-20,
   9.813017238035932e-22,   1.521229518961714e-23,   2.585284125992842e-01,  -5.621944664366109e-03,   8.326302732180414e-05,  -9.573207110572395e-07,   6.810374199369784e-09,
   3.589789551213140e-11,   3.073651127109915e-15,   6.013322865066059e-14,  -1.047794052203906e-15,  -4.944198989490244e-17,  -8.276480139104597e-19,   1.587256989976255e-20,
   9.814068313618409e-22,   1.504386288395978e-23,   2.585445948228682e-01,  -5.622502173320412e-03,   8.327096209675035e-05,  -9.572496693787635e-07,   6.810339815850673e-09,
   3.613974589731304e-11,  -2.710965121490566e-15,   5.979033234323881e-14,  -1.054785762716562e-15,  -4.926736337713354e-17,  -8.150699340148886e-19,   1.609498415106021e-20,
   9.814441339575512e-22,   1.487802853366621e-23,   2.585576313855326e-01,  -5.622951285065260e-03,   8.327735423027397e-05,  -9.571923260867847e-07,   6.810308006376855e-09,
   3.633423942938609e-11,  -7.380089920605476e-15,   5.951439803991743e-14,  -1.060391549311799e-15,  -4.912611434621134e-17,  -8.049373936435787e-19,   1.627353536935653e-20,
   9.814278186119171e-22,   1.474278100825785e-23,   2.585662458969204e-01,  -5.623248045097434e-03,   8.328157802906047e-05,  -9.571543793636439e-07,   6.810284972602599e-09,
   3.646259189382239e-11,  -1.046981540961187e-14,   5.933221202651152e-14,  -1.064082707662757e-15,  -4.903249986281897e-17,  -7.982421333566392e-19,   1.639121199975417e-20,
   9.813943425851406e-22,   1.465260669398649e-23,   2.585706699173070e-01,  -5.623400444023526e-03,   8.328374714892286e-05,  -9.571348748150456e-07,   6.810272520185057e-09,
   3.652845589524189e-11,  -1.205791144276058e-14,   5.923869614971057e-14,  -1.065974259695006e-15,  -4.898433797502319e-17,  -7.948038503803780e-19,   1.645154928748858e-20,
   9.813701338804074e-22,   1.460604981577414e-23,   2.585722097471273e-01,  -5.623453487618543e-03,   8.328450213048395e-05,  -9.571280833583911e-07,   6.810268086711566e-09,
   3.655137232583312e-11,  -1.261088136832940e-14,   5.920615431926316e-14,  -1.066631989427091e-15,  -4.896756104830884e-17,  -7.936071338864220e-19,   1.647253502667871e-20,
   9.813605908161073e-22,   1.458980586211539e-23,   2.585724540973406e-01,  -5.623461904894824e-03,   8.328462193563739e-05,  -9.571270055186503e-07,   6.810267378465734e-09,
   3.655500846144333e-11,  -1.269864045130595e-14,   5.920099072214404e-14,  -1.066736331586399e-15,  -4.896489812898169e-17,  -7.934172319230953e-19,   1.647586445185228e-20,
   9.813590234382973e-22,   1.458722630137063e-23,   5.140074627858497e-01,  -1.054738960498553e-02,   1.277398938984142e-04,  -7.197218587650962e-07,  -1.132046969472707e-08,
   4.105189068036571e-10,  -1.089061987619522e-12,   6.887955254336784e-14,  -1.379939133289298e-16,  -1.461787287536932e-16,  -1.856886272523094e-18,   4.157650442927716e-20,
   2.045953491856475e-21,   3.641461160534517e-23,   5.140194255768845e-01,  -1.054759066676796e-02,   1.277335174625603e-04,  -7.193359306382875e-07,  -1.132200750251841e-08,
   4.106467727097560e-10,  -1.089576355578598e-12,   6.839208780134794e-14,  -1.454202781140826e-16,  -1.459543848965811e-16,  -1.844217651980351e-18,   4.183402871196454e-20,
   2.046269471260058e-21,   3.626066648269709e-23,   5.140405336231354e-01,  -1.054794535502348e-02,   1.277222654361754e-04,  -7.186548592990280e-07,  -1.132472163601394e-08,
   4.108716167992224e-10,  -1.090499567693297e-12,   6.753257145228014e-14,  -1.584807596402583e-16,  -1.455574562707054e-16,  -1.821862951912065e-18,   4.228747499837932e-20,
   2.046748368515413e-21,   3.598573731883303e-23,   5.140660568682510e-01,  -1.054837409706967e-02,   1.277086581633214e-04,  -7.178311388294439e-07,  -1.132800471124971e-08,
   4.111421759793719e-10,  -1.091642464430101e-12,   6.649429912217024e-14,  -1.741995369636706e-16,  -1.450756637043841e-16,  -1.794830453482291e-18,   4.283413810989235e-20,
   2.047193322263958e-21,   3.564770707551753e-23,   5.140908335236513e-01,  -1.054879015451101e-02,   1.276954471990194e-04,  -7.170313164104242e-07,  -1.133119304788534e-08,
   4.114034438204946e-10,  -1.092779678897161e-12,   6.548747910014568e-14,  -1.893814605761252e-16,  -1.446060432226825e-16,  -1.768587116572484e-18,   4.336308562632039e-20,
   2.047484785537646e-21,   3.531374218563148e-23,   5.141107926522631e-01,  -1.054912521181653e-02,   1.276848037154439e-04,  -7.163868692566729e-07,  -1.133376238956637e-08,
   4.116129251182441e-10,  -1.093715601131001e-12,   6.467719994988923e-14,  -2.015562255920571e-16,  -1.442263610031631e-16,  -1.747445600025926e-18,   4.378793783216755e-20,
   2.047618907939148e-21,   3.504056588021202e-23,   5.141239809839551e-01,  -1.054934655630463e-02,   1.276777702491129e-04,  -7.159609711484374e-07,  -1.133546058979202e-08,
   4.117508608380273e-10,  -1.094343711964841e-12,   6.414217530961239e-14,  -2.095738726922781e-16,  -1.439748078962957e-16,  -1.733475650533195e-18,   4.406805043110313e-20,
   2.047658234233361e-21,   3.485803961666996e-23,   5.141307537290106e-01,  -1.054946021015291e-02,   1.276741580909048e-04,  -7.157422339043215e-07,  -1.133633282922934e-08,
   4.118215472486774e-10,  -1.094669262581783e-12,   6.386753636969200e-14,  -2.136828998945825e-16,  -1.438454176397153e-16,  -1.726301430318333e-18,   4.421170823567227e-20,
   2.047663182872952e-21,   3.476368226609906e-23,   5.141331110299361e-01,  -1.054949976568723e-02,   1.276729008243957e-04,  -7.156660975107470e-07,  -1.133663644130834e-08,
   4.118461263969163e-10,  -1.094783048337212e-12,   6.377196517806410e-14,  -2.151117442560792e-16,  -1.438003494482549e-16,  -1.723804381893720e-18,   4.426167876837957e-20,
   2.047662477822871e-21,   3.473074159351184e-23,   5.141334851004149e-01,  -1.054950604247623e-02,   1.276727013124827e-04,  -7.156540155763887e-07,  -1.133668462136983e-08,
   4.118500256345126e-10,  -1.094801127104867e-12,   6.375680026774755e-14,  -2.153384185549946e-16,  -1.437931961936709e-16,  -1.723408134955800e-18,   4.426960693585191e-20,
   2.047662250699707e-21,   3.472550967916105e-23,   8.650148649651153e-01,  -1.586668981344879e-02,   1.103627796618378e-04,   1.451409788695322e-06,  -4.903676535132303e-08,
   3.393577669200148e-10,   1.992137633152904e-11,  -1.466439346000586e-13,  -2.731219149908287e-15,  -1.301340184276636e-16,  -6.948608530700781e-18,   7.052481955514101e-20,
   6.151270782602239e-21,   4.541539474140705e-23,   8.650251564039659e-01,  -1.586628049395638e-02,   1.103353540932418e-04,   1.451725444670177e-06,  -4.900884346475704e-08,
   3.390622553337567e-10,   1.991363036274371e-11,  -1.470732719698640e-13,  -2.759314287149635e-15,  -1.297575655759409e-16,  -6.910668187447977e-18,   7.085452156317954e-20,
   6.148910733719755e-21,   4.538475499021113e-23,   8.650433137384206e-01,  -1.586555817152073e-02,   1.102869739922265e-04,   1.452282197286629e-06,  -4.895958393707968e-08,
   3.385401381698930e-10,   1.989990325920537e-11,  -1.478298021713400e-13,  -2.808758583115758e-15,  -1.290919295261963e-16,  -6.843735554758095e-18,   7.143598485489113e-20,
   6.144581157885993e-21,   4.532183489214872e-23,   8.650652662501719e-01,  -1.586468460920682e-02,   1.102284939875911e-04,   1.452955040551235e-06,  -4.890003431864078e-08,
   3.379076262530206e-10,   1.988320351421888e-11,  -1.487428267075255e-13,  -2.868325501336378e-15,  -1.282846849231620e-16,  -6.762823829881181e-18,   7.213854749345303e-20,
   6.139063864834223e-21,   4.523071196877183e-23,   8.650865736717216e-01,  -1.586383644200124e-02,   1.101717453635184e-04,   1.453607818439579e-06,  -4.884224089985946e-08,
   3.372923789913618e-10,   1.986688639240180e-11,  -1.496273079631927e-13,  -2.925919967015217e-15,  -1.274985659397290e-16,  -6.684301915143600e-18,   7.281996294825924e-20,
   6.133412311838066e-21,   4.512657985770827e-23,   8.651037360052418e-01,  -1.586315307782786e-02,   1.101260457091177e-04,   1.454133396096465e-06,  -4.879569500761291e-08,
   3.367958738325930e-10,   1.985366625608058e-11,  -1.503384944212830e-13,  -2.972151076504670e-15,  -1.268635172327790e-16,  -6.621064671834150e-18,   7.336842618416467e-20,
   6.128647640052960e-21,   4.503151844554002e-23,   8.651150752731152e-01,  -1.586270147806884e-02,   1.100958561710256e-04,   1.454480545486953e-06,  -4.876494407322863e-08,
   3.364673665293782e-10,   1.984489383771589e-11,  -1.508077766571795e-13,  -3.002618386361139e-15,  -1.264430263264677e-16,  -6.579288133457466e-18,   7.373059495586628e-20,
   6.125395438950692e-21,   4.496325460805638e-23,   8.651208981288658e-01,  -1.586246954610544e-02,   1.100803548661809e-04,   1.454658779069741e-06,  -4.874915378253463e-08,
   3.362985307981656e-10,   1.984037741886841e-11,  -1.510485721234754e-13,  -3.018239641985510e-15,  -1.262268176292602e-16,  -6.557836865949728e-18,   7.391650715952711e-20,
   6.123693167073444e-21,   4.492651744084981e-23,   8.651229247633200e-01,  -1.586238881785231e-02,   1.100749598878791e-04,   1.454720807854994e-06,  -4.874365811182202e-08,
   3.362397450467599e-10,   1.983880363034692e-11,  -1.511323507887324e-13,  -3.023672756889898e-15,  -1.261515217941227e-16,  -6.550371034824528e-18,   7.398120281912394e-20,
   6.123095562533340e-21,   4.491346362842365e-23,   8.651232463592672e-01,  -1.586237600728547e-02,   1.100741037977709e-04,   1.454730650634419e-06,  -4.874278603808324e-08,
   3.362304155642155e-10,   1.983855380599776e-11,  -1.511456437705042e-13,  -3.024534727218289e-15,  -1.261395713685278e-16,  -6.549186333064272e-18,   7.399146851744472e-20,
   6.123000488159476e-21,   4.491137949632454e-23,   1.312340145898785e+00,  -1.862538222899234e-02,  -7.687605198102934e-05,   4.814768957318855e-06,   1.812307691838543e-08,
  -2.338384961259519e-09,   1.351809495264310e-11,   1.975584210621075e-12,  -1.092536746694168e-14,  -1.696798259043861e-15,  -3.999198722430535e-18,   9.660586319683352e-19,
   3.889564379880390e-21,  -4.019916493322635e-22,   1.312332959460929e+00,  -1.862403568045138e-02,  -7.686575259375789e-05,   4.812608592861477e-06,   1.814174316517309e-08,
  -2.334584329626613e-09,   1.348908817977290e-11,   1.969984208976815e-12,  -1.094136702690367e-14,  -1.691922688271950e-15,  -3.972482957338781e-18,   9.633133666292740e-19,
   3.947849589039989e-21,  -3.983952346577278e-22,   1.312320279675560e+00,  -1.862166016280543e-02,  -7.684757070741552e-05,   4.808799465285119e-06,   1.817464676089507e-08,
  -2.327886956355623e-09,   1.343787166259793e-11,   1.960116218837779e-12,  -1.096950457661225e-14,  -1.683330979594847e-15,  -3.925057794455167e-18,   9.584899837195799e-19,
   4.049932211192373e-21,  -3.921014042497009e-22,   1.312304948503471e+00,  -1.861878849387235e-02,  -7.682557056937117e-05,   4.804198315635261e-06,   1.821437735157686e-08,
  -2.319803583528369e-09,   1.337588293432828e-11,   1.948206397775541e-12,  -1.100336799463166e-14,  -1.672961024398582e-15,  -3.867227837078109e-18,   9.526925506795044e-19,
   4.172072325965476e-21,  -3.845793404986217e-22,   1.312290066691562e+00,  -1.861600159848353e-02,  -7.680419814287754e-05,   4.799736712103599e-06,   1.825288761951823e-08,
  -2.311972244610742e-09,   1.331564566234488e-11,   1.936668250166234e-12,  -1.103607278358840e-14,  -1.662914115602612e-15,  -3.810585125355873e-18,   9.471009435036765e-19,
   4.289284429887088e-21,  -3.773693083703165e-22,   1.312278079118499e+00,  -1.861375713554535e-02,  -7.678697000348916e-05,   4.796146161551738e-06,   1.828386833451362e-08,
  -2.305674770056894e-09,   1.326707665978709e-11,   1.927390231014799e-12,  -1.106229749695805e-14,  -1.654834780534334e-15,  -3.764596888448577e-18,   9.426223394434754e-19,
   4.382735817511641e-21,  -3.716268045579910e-22,   1.312270158443872e+00,  -1.861227433966123e-02,  -7.677558067635903e-05,   4.793775379695895e-06,   1.830431894417799e-08,
  -2.301519063173341e-09,   1.323496230179825e-11,   1.921267778957616e-12,  -1.107956642913005e-14,  -1.649503092395175e-15,  -3.734034538314872e-18,   9.396755742745768e-19,
   4.444010692282377e-21,  -3.678643598317369e-22,   1.312266090953154e+00,  -1.861151294739028e-02,  -7.676973007998662e-05,   4.792558422988643e-06,   1.831481484683050e-08,
  -2.299386624768038e-09,   1.321846361255232e-11,   1.918126171410107e-12,  -1.108841628014020e-14,  -1.646767173501779e-15,  -3.718285656499730e-18,   9.381661551162304e-19,
   4.475331097117884e-21,  -3.659420659339682e-22,   1.312264675250391e+00,  -1.861124795285772e-02,  -7.676769346660759e-05,   4.792134938102787e-06,   1.831846701262259e-08,
  -2.298644683130310e-09,   1.321272007001087e-11,   1.917033114266870e-12,  -1.109149359070629e-14,  -1.645815255051586e-15,  -3.712795590400731e-18,   9.376414051460731e-19,
   4.486209027025514e-21,  -3.652745679956095e-22,   1.312264450599030e+00,  -1.861120590258796e-02,  -7.676737027178412e-05,   4.792067741062672e-06,   1.831904651217012e-08,
  -2.298526960172464e-09,   1.321180860038169e-11,   1.916859680524619e-12,  -1.109198177684779e-14,  -1.645664214987299e-15,  -3.711923988244212e-18,   9.375581638240384e-19,
   4.487934092818562e-21,  -3.651687199453697e-22,   1.800867917549157e+00,  -1.059870320451352e-02,  -3.305798617286889e-04,  -5.433748356406455e-06,   5.458660126174789e-08,
   6.409134412701298e-09,   1.724537215629841e-10,  -5.798895898107546e-14,  -1.694039710295302e-13,  -5.900024204046733e-15,  -4.076728140930381e-17,   4.401827096633605e-18,
   1.967162386155359e-19,   2.636089744102122e-21,   1.800836990099419e+00,  -1.060021029375259e-02,  -3.305478207028495e-04,  -5.427743635537800e-06,   5.482381960818520e-08,
   6.408714584285597e-09,   1.720063728460407e-10,  -7.729179910813144e-14,  -1.695384642622381e-13,  -5.876724175723333e-15,  -3.959425102020328e-17,   4.417835910294008e-18,
   1.957747177162071e-19,   2.576513668327331e-21,   1.800782420727229e+00,  -1.060286820422458e-02,  -3.304911765735435e-04,  -5.417148624597397e-06,   5.524188267050555e-08,
   6.407943195826316e-09,   1.712167545842477e-10,  -1.112876003098178e-13,  -1.697717955361472e-13,  -5.835547129970422e-15,  -3.752924190609990e-17,   4.445732866313660e-18,
   1.941056126084512e-19,   2.471635881560065e-21,   1.800716439296914e+00,  -1.060607983834337e-02,  -3.304224992031694e-04,  -5.404337745018508e-06,   5.574653504460915e-08,
   6.406958329199444e-09,   1.702614946816552e-10,  -1.522858247835860e-13,  -1.700471603416608e-13,  -5.785647659265466e-15,  -3.504045793270201e-17,   4.478868964252363e-18,
   1.920741665344461e-19,   2.345238142436266e-21,   1.800652390320344e+00,  -1.060919518724082e-02,  -3.303556373012298e-04,  -5.391901939902044e-06,   5.623552740221107e-08,
   6.405947774427488e-09,   1.693336862079077e-10,  -1.919709987155136e-13,  -1.703073924670996e-13,  -5.737094562136403e-15,  -3.263305893745619e-17,   4.510412849444591e-18,
   1.900884518633809e-19,   2.222979496471526e-21,   1.800600796637017e+00,  -1.061170311653060e-02,  -3.303016374450866e-04,  -5.381884386510914e-06,   5.662879721406570e-08,
   6.405094725773036e-09,   1.685859323016350e-10,  -2.238582209441983e-13,  -1.705119644324185e-13,  -5.697901788780420e-15,  -3.069992438400759e-17,   4.535377986899396e-18,
   1.884791277632859e-19,   2.124812359917455e-21,   1.800566706087120e+00,  -1.061335945213672e-02,  -3.302658883906838e-04,  -5.375265250244682e-06,   5.688834160206406e-08,
   6.404511996931107e-09,   1.680916735555178e-10,  -2.448882265520932e-13,  -1.706446648729126e-13,  -5.671965569646718e-15,  -2.942560550819032e-17,   4.551656410013287e-18,
   1.874110272640151e-19,   2.060104624910150e-21,   1.800549199465227e+00,  -1.061420979395587e-02,  -3.302475088601964e-04,  -5.371866096278874e-06,   5.702153068547382e-08,
   6.404206852062911e-09,   1.678378001525916e-10,  -2.556756061025261e-13,  -1.707120477357658e-13,  -5.658634302531144e-15,  -2.877213071294255e-17,   4.559948792549215e-18,
   1.868610655576184e-19,   2.026923663856884e-21,   1.800543106205853e+00,  -1.061450572090336e-02,  -3.302411084050375e-04,  -5.370683003925078e-06,   5.706787254319872e-08,
   6.404099707071812e-09,   1.677494296056814e-10,  -2.594282560482074e-13,  -1.707353792229551e-13,  -5.653992364781914e-15,  -2.854483407040314e-17,   4.562824314626864e-18,
   1.866694177198959e-19,   2.015382640303148e-21,   1.800542139293340e+00,  -1.061455267842578e-02,  -3.302400925847280e-04,  -5.370495264144007e-06,   5.707522560661919e-08,
   6.404082660187339e-09,   1.677354060577042e-10,  -2.600236551259810e-13,  -1.707390758310835e-13,  -5.653255664642648e-15,  -2.850877240720144e-17,   4.563280111725414e-18,
   1.866389950094182e-19,   2.013551614994472e-21,   9.321228089891991e-03,  -2.029542522137094e-04,   3.268813994834278e-06,  -4.758815845505685e-08,   6.645746455661554e-10,
  -5.764594219314799e-12,   1.616762045423037e-13,  -2.110664698162944e-15,  -8.643102038537043e-17,  -2.135199562304852e-18,   4.170926718414770e-20,   2.730881102466485e-21,
   4.704664201242507e-23,  -6.472538276441501e-25,   9.321535293603973e-03,  -2.029676555273747e-04,   3.269189084406670e-06,  -4.759359870351821e-08,   6.647993705814049e-10,
  -5.768857669247607e-12,   1.614531579589376e-13,  -2.117510607501091e-15,  -8.624659136514807e-17,  -2.121340591330640e-18,   4.197637583680372e-20,   2.725302741229466e-21,
   4.652852282102466e-23,  -6.628286811667644e-25,   9.322077388134327e-03,  -2.029913071357992e-04,   3.269851038020052e-06,  -4.760320139021829e-08,   6.651956479256690e-10,
  -5.776391374245252e-12,   1.610599874175295e-13,  -2.129552461311782e-15,  -8.592026839385288e-17,  -2.096910457468318e-18,   4.244508951257912e-20,   2.715369412055560e-21,
   4.561450882117437e-23,  -6.901350460253743e-25,   9.322732943655024e-03,  -2.030199090463250e-04,   3.270651653518233e-06,  -4.761481866439694e-08,   6.656743988347164e-10,
  -5.785519551147839e-12,   1.605852424397518e-13,  -2.144049090166074e-15,  -8.552415512370449e-17,  -2.067410862416408e-18,   4.300742444509919e-20,   2.703204802746370e-21,
   4.450967543869386e-23,  -7.228544820189674e-25,   9.323369396949535e-03,  -2.030476775202012e-04,   3.271429059417645e-06,  -4.762610238734416e-08,   6.661387100626710e-10,
  -5.794400180333279e-12,   1.601250830505189e-13,  -2.158054672576477e-15,  -8.513803123788881e-17,  -2.038817036981367e-18,   4.354868262725970e-20,   2.691236177471159e-21,
   4.343758754977852e-23,  -7.543039533143144e-25,   9.323882152238559e-03,  -2.030700490429427e-04,   3.272055457998779e-06,  -4.763519662166859e-08,   6.665124296731709e-10,
  -5.801567985651990e-12,   1.597548979450187e-13,  -2.169289070751850e-15,  -8.482584543696273e-17,  -2.015813884276841e-18,   4.398138468997613e-20,   2.681480819993136e-21,
   4.257429181518444e-23,  -7.794141771115283e-25,   9.324220989815316e-03,  -2.030848325308698e-04,   3.272469434889307e-06,  -4.764120799491914e-08,   6.667592186666048e-10,
  -5.806311029720778e-12,   1.595105380170880e-13,  -2.176688920856059e-15,  -8.461900784535300e-17,  -2.000629404608548e-18,   4.426567719097023e-20,   2.674979297853795e-21,
   4.200403221644705e-23,  -7.958963368577073e-25,   9.324395004695844e-03,  -2.030924248018569e-04,   3.272682051576046e-06,  -4.764429576182993e-08,   6.668859077019903e-10,
  -5.808748874310490e-12,   1.593851254703044e-13,  -2.180481790710372e-15,  -8.451261698548113e-17,  -1.992836289776840e-18,   4.441117120193188e-20,   2.671623391373989e-21,
   4.171123829418115e-23,  -8.043266186959138e-25,   9.324455573055709e-03,  -2.030950673999233e-04,   3.272756057903901e-06,  -4.764537058916564e-08,   6.669299951948110e-10,
  -5.809597716834226e-12,   1.593414869063245e-13,  -2.181800770801280e-15,  -8.447555967257156e-17,  -1.990124597381156e-18,   4.446173152871655e-20,   2.670452625754442e-21,
   4.160933874094211e-23,  -8.072554268313387e-25,   9.324465184462373e-03,  -2.030954867456755e-04,   3.272767801838094e-06,  -4.764554115429390e-08,   6.669369909031497e-10,
  -5.809732432036250e-12,   1.593345626570835e-13,  -2.182010019571804e-15,  -8.446967790645473e-17,  -1.989694325856297e-18,   4.446975094924214e-20,   2.670266712744258e-21,
   4.159316916721247e-23,  -8.077199306189176e-25,   8.439025604152216e-02,  -1.818995059024962e-03,   2.839856472990619e-05,  -3.891738857436692e-07,   4.931294040377419e-09,
  -2.780146765390146e-11,   1.028855141838425e-12,  -1.142939599138171e-14,  -9.384853796671191e-16,  -1.819134768833445e-17,   3.628192012473085e-19,   2.591422698803392e-20,
   4.390850731799208e-22,  -5.869714857953679e-24,   8.439292398630961e-02,  -1.819104606511976e-03,   2.840134656669523e-05,  -3.892001473399107e-07,   4.932712180330883e-09,
  -2.782488372326265e-11,   1.026425104075302e-12,  -1.148736961032631e-14,  -9.368757066465244e-16,  -1.805975739448225e-17,   3.653120501171740e-19,   2.586329454661235e-20,
   4.342490626850699e-22,  -6.017261331243145e-24,   8.439763182990483e-02,  -1.819297910818760e-03,   2.840625580334265e-05,  -3.892465044666924e-07,   4.935211745673341e-09,
  -2.786629285682292e-11,   1.022140746755990e-12,  -1.158930542683873e-14,  -9.340270600071444e-16,  -1.782778585341171e-17,   3.696864102550664e-19,   2.577256837629037e-20,
   4.257171170522488e-22,  -6.275971712147629e-24,   8.440332496797615e-02,  -1.819531666757935e-03,   2.841219319833184e-05,  -3.893025909545394e-07,   4.938229535140321e-09,
  -2.791652018224106e-11,   1.016966006141724e-12,  -1.171195467536979e-14,  -9.305682601050902e-16,  -1.754766365812535e-17,   3.749344874854648e-19,   2.566141002378106e-20,
   4.154026953596668e-22,  -6.586013251943092e-24,   8.440885214834822e-02,  -1.819758603773512e-03,   2.841795826270266e-05,  -3.893570712211307e-07,   4.941154222446748e-09,
  -2.796544177049637e-11,   1.011948703622280e-12,  -1.183037944910019e-14,  -9.271957344729716e-16,  -1.727612717298776e-17,   3.799858371240304e-19,   2.555198815971819e-20,
   4.053926701860496e-22,  -6.884068838631310e-24,   8.441330504562131e-02,  -1.819941429020148e-03,   2.842260334255382e-05,  -3.894009831254942e-07,   4.943506782331702e-09,
  -2.800496792056457e-11,   1.007911315998514e-12,  -1.192532202416947e-14,  -9.244683313625696e-16,  -1.705767059792966e-17,   3.840240544945927e-19,   2.546276252907169e-20,
   3.973311954240340e-22,  -7.122079950825247e-24,   8.441624757431977e-02,  -1.820062240476074e-03,   2.842567312924644e-05,  -3.894300107597259e-07,   4.945059584533425e-09,
  -2.803114253266545e-11,   1.005245682983113e-12,  -1.198783386233449e-14,  -9.226609718723264e-16,  -1.691346109208056e-17,   3.866772198068223e-19,   2.540327901973220e-20,
   3.920056453468980e-22,  -7.278325492845654e-24,   8.441775874489175e-02,  -1.820124284111588e-03,   2.842724973544334e-05,  -3.894449213772719e-07,   4.945856488744361e-09,
  -2.804460187148313e-11,   1.003877434420947e-12,  -1.201986727974499e-14,  -9.217312210865792e-16,  -1.683944692896054e-17,   3.880350418525743e-19,   2.537256960917542e-20,
   3.892711567637744e-22,  -7.358247060005427e-24,   8.441828472822194e-02,  -1.820145879153756e-03,   2.842779850737889e-05,  -3.894501117179004e-07,   4.946133773555461e-09,
  -2.804928928869577e-11,   1.003401311562097e-12,  -1.203100575804098e-14,  -9.214073608368300e-16,  -1.681369269363453e-17,   3.885068952201854e-19,   2.536185520771089e-20,
   3.883194646568546e-22,  -7.386013860544698e-24,   8.441836819484456e-02,  -1.820149305998397e-03,   2.842788559086285e-05,  -3.894509353802400e-07,   4.946177770801436e-09,
  -2.805003324874890e-11,   1.003325762578123e-12,  -1.203277275681631e-14,  -9.213559567213692e-16,  -1.680960618724172e-17,   3.885817362934530e-19,   2.536015376015845e-20,
   3.881684476748743e-22,  -7.390417665522834e-24,   2.372694711179993e-01,  -4.998722757981534e-03,   7.243296593715880e-05,  -8.423575844898024e-07,   7.632135451546577e-09,
   5.062902358402501e-11,   9.564763726061366e-13,  -5.118975629583599e-15,  -3.133850991559235e-15,  -5.408495777341409e-17,   1.108145020375306e-18,   7.767098193287765e-20,
   1.359615487701756e-21,  -1.702442623986165e-23,   2.372762703275246e-01,  -4.998959503816635e-03,   7.243726600372340e-05,  -8.423102301112602e-07,   7.633384581317399e-09,
   5.061622830205614e-11,   9.483523901932561e-13,  -5.291251625648413e-15,  -3.128930461294239e-15,  -5.369042815547494e-17,   1.115886453526373e-18,   7.752161715924888e-20,
   1.345131631048958e-21,  -1.748234028330986e-23,   2.372882679684347e-01,  -4.999377234765692e-03,   7.244485408764147e-05,  -8.422266831450585e-07,   7.635579443036721e-09,
   5.059338012500915e-11,   9.340281434538372e-13,  -5.594157263059690e-15,  -3.120222146291211e-15,  -5.299492572059651e-17,   1.129473467903840e-18,   7.725540456887702e-20,
   1.319573439108945e-21,  -1.828542969728429e-23,   2.373027762045671e-01,  -4.999882341077228e-03,   7.245403061269132e-05,  -8.421256754387358e-07,   7.638217734106993e-09,
   5.056529147584589e-11,   9.167253043724618e-13,  -5.958597054942427e-15,  -3.109647862617289e-15,  -5.215503475673004e-17,   1.145778789951673e-18,   7.692898862061300e-20,
   1.288667197084961e-21,  -1.924816030155138e-23,   2.373168611361071e-01,  -5.000372670259200e-03,   7.246293999761638e-05,  -8.420276381181081e-07,   7.640762449339600e-09,
   5.053754288866451e-11,   8.999471068832109e-13,  -6.310466877856356e-15,  -3.099336572440868e-15,  -5.134086348336935e-17,   1.161477615098039e-18,   7.660741362918596e-20,
   1.258664225668136e-21,  -2.017398545634601e-23,   2.373282081944263e-01,  -5.000767659258156e-03,   7.247011797699561e-05,  -8.419486744172031e-07,   7.642800629940274e-09,
   5.051484568884348e-11,   8.864445270602908e-13,  -6.592552651617554e-15,  -3.090997155933121e-15,  -5.068583011781023e-17,   1.174031173625749e-18,   7.634501034155601e-20,
   1.234495347549167e-21,  -2.091352387556576e-23,   2.373357063343892e-01,  -5.001028654189461e-03,   7.247486139702089e-05,  -8.418965034611071e-07,   7.644141644499754e-09,
   5.049968012238071e-11,   8.775289929295483e-13,  -6.778276651955120e-15,  -3.085470632587049e-15,  -5.025341581092928e-17,   1.182280705470483e-18,   7.616998759745488e-20,
   1.218525908393609e-21,  -2.139911367634989e-23,   2.373395570517319e-01,  -5.001162685483552e-03,   7.247729747482250e-05,  -8.418697133081762e-07,   7.644828533128210e-09,
   5.049184011858485e-11,   8.729525237565640e-13,  -6.873446701671447e-15,  -3.082627568002823e-15,  -5.003148085972148e-17,   1.186503122075088e-18,   7.607960209463116e-20,
   1.210325202790314e-21,  -2.164753306681676e-23,   2.373408973393080e-01,  -5.001209335969960e-03,   7.247814539065158e-05,  -8.418603890900480e-07,   7.645067326648882e-09,
   5.048910310133799e-11,   8.713599738116195e-13,  -6.906538386286180e-15,  -3.081637229588997e-15,  -4.995425519206755e-17,   1.187970526138984e-18,   7.604806266076143e-20,
   1.207470937354864e-21,  -2.173384576054180e-23,   2.373411100249690e-01,  -5.001216738743867e-03,   7.247827994400558e-05,  -8.418589094812034e-07,   7.645105206393728e-09,
   5.048866838375329e-11,   8.711072738374659e-13,  -6.911788008622395e-15,  -3.081480039338581e-15,  -4.994200153182039e-17,   1.188203276297448e-18,   7.604305399514275e-20,
   1.207018007980048e-21,  -2.174753518196828e-23,   4.738035114625687e-01,  -9.562478518843528e-03,   1.182844345592801e-04,  -8.360060963977006e-07,  -3.239937803528960e-09,
   4.017754886973276e-10,  -8.517232390540947e-14,  -2.848958564571041e-14,  -5.984823737297479e-15,  -1.485016453377995e-16,   2.746322034317357e-18,   1.771878329767751e-19,
   3.059735388536685e-21,  -3.331955555565429e-23,   4.738145969443695e-01,  -9.562712320400407e-03,   1.182826102931412e-04,  -8.356299750480878e-07,  -3.240239982465889e-09,
   4.017118533176536e-10,  -1.006300965674890e-13,  -2.896732711380539e-14,  -5.972685015033521e-15,  -1.476001535031168e-16,   2.763746448766321e-18,   1.768851452411822e-19,
   3.027229676612196e-21,  -3.440542711989961e-23,   4.738341573123910e-01,  -9.563124781026206e-03,   1.182793911657634e-04,  -8.349663538073041e-07,  -3.240790754612054e-09,
   4.015988145467464e-10,  -1.278793430801622e-13,  -2.980784500329271e-14,  -5.951207611756292e-15,  -1.460107855753000e-16,   2.794328346752008e-18,   1.763447402885188e-19,
   2.969849778720752e-21,  -3.631051300599835e-23,   4.738578096813590e-01,  -9.563623386364892e-03,   1.182754982483289e-04,  -8.341639829135460e-07,  -3.241486696256850e-09,
   4.014608453803224e-10,  -1.607846035918675e-13,  -3.082000869771185e-14,  -5.925137651430607e-15,  -1.440911881370598e-16,   2.831029023493947e-18,   1.756805664946174e-19,
   2.900428612588748e-21,  -3.859546514691211e-23,   4.738807707434882e-01,  -9.564107270439564e-03,   1.182717187354592e-04,  -8.333851467386047e-07,  -3.242193632879019e-09,
   4.013255687876248e-10,  -1.926814193890212e-13,  -3.179820529409818e-14,  -5.899725937886665e-15,  -1.422300898989434e-16,   2.866364867489092e-18,   1.750246394880081e-19,
   2.833000454461448e-21,  -4.079404584513142e-23,   4.738992676986677e-01,  -9.564496971285398e-03,   1.182686737633812e-04,  -8.327577924221031e-07,  -3.242785559871609e-09,
   4.012156351038591e-10,  -2.183432991563937e-13,  -3.258308151920934e-14,  -5.879180818692986e-15,  -1.407325587609453e-16,   2.894621310937005e-18,   1.744882784933093e-19,
   2.778658185619813e-21,  -4.255112123450130e-23,   4.739114900700432e-01,  -9.564754424868985e-03,   1.182666615778130e-04,  -8.323432803098434e-07,  -3.243187668477088e-09,
   4.011425254742728e-10,  -2.352836422097156e-13,  -3.310017421734111e-14,  -5.865568988454702e-15,  -1.397438778837288e-16,   2.913189994672121e-18,   1.741299821632352e-19,
   2.742739421692451e-21,  -4.370526665457055e-23,   4.739177668156271e-01,  -9.564886622967530e-03,   1.182656281860111e-04,  -8.321304185699448e-07,  -3.243397562617525e-09,
   4.011048358386416e-10,  -2.439781880920866e-13,  -3.336525014936329e-14,  -5.858567564535247e-15,  -1.392364105918189e-16,   2.922694146544482e-18,   1.739447838576594e-19,
   2.724290407314051e-21,  -4.429584031656177e-23,   4.739199514901199e-01,  -9.564932633078055e-03,   1.182652684984066e-04,  -8.320563316968024e-07,  -3.243471158083245e-09,
   4.010916946547792e-10,  -2.470035870001971e-13,  -3.345743650754807e-14,  -5.856128890693544e-15,  -1.390598246845206e-16,   2.925997097760999e-18,   1.738801337968942e-19,
   2.717868596852185e-21,  -4.450105480180438e-23,   4.739202981676705e-01,  -9.564939934123211e-03,   1.182652114206460e-04,  -8.320445752066130e-07,  -3.243482862297421e-09,
   4.010896082402228e-10,  -2.474836373238127e-13,  -3.347206161736795e-14,  -5.855741823045499e-15,  -1.390318049640425e-16,   2.926520990604431e-18,   1.738698657044800e-19,
   2.716849522386851e-21,  -4.453360336626009e-23,   8.034062702907524e-01,  -1.492678120687015e-02,   1.233758939010117e-04,   7.454501183048897e-07,  -3.787668614214495e-08,
   7.523268760710888e-10,   1.356717302357936e-11,  -3.510423178345910e-13,  -1.082147545453245e-14,  -2.513949433097642e-16,   3.369746963622105e-18,   4.074313034456289e-19,
   6.941275114842489e-21,  -8.059330528888017e-23,   8.034177942029193e-01,  -1.492656908731623e-02,   1.233546939481132e-04,   7.461494951862121e-07,  -3.785793893327632e-08,
   7.516232449003270e-10,   1.353909036718287e-11,  -3.518368809729794e-13,  -1.080598903551362e-14,  -2.493230229401879e-16,   3.409720060668685e-18,   4.067091922012150e-19,
   6.877257956413146e-21,  -8.303298533688053e-23,   8.034381267242175e-01,  -1.492619464013900e-02,   1.233172947925672e-04,   7.473830166020665e-07,  -3.782489116533639e-08,
   7.503804313351501e-10,   1.348957189021495e-11,  -3.532332367595024e-13,  -1.077852852639267e-14,  -2.456702483832250e-16,   3.479929614430460e-18,   4.054208221705638e-19,
   6.764152821063760e-21,  -8.731485500284699e-23,   8.034627102933802e-01,  -1.492574158378098e-02,   1.232720858085560e-04,   7.488736823373955e-07,  -3.778498394775875e-08,
   7.488754907507159e-10,   1.342975146497987e-11,  -3.549120746799954e-13,  -1.074509444949486e-14,  -2.412587052865306e-16,   3.564275517572600e-18,   4.038388046879158e-19,
   6.627142305943173e-21,  -9.245326100771365e-23,   8.034865727355340e-01,  -1.492530148100922e-02,   1.232282128542550e-04,   7.503198289921634e-07,  -3.774629974542204e-08,
   7.474123113257206e-10,   1.337173965441502e-11,  -3.565317634819373e-13,  -1.071239887924086e-14,  -2.369817940434470e-16,   3.645578177404945e-18,   4.022778856597496e-19,
   6.493888624724919e-21,  -9.740029771680441e-23,   8.035057939589315e-01,  -1.492494673688854e-02,   1.231928802150546e-04,   7.514841333423276e-07,  -3.771517709512314e-08,
   7.462320157184725e-10,   1.332504984702117e-11,  -3.578293340954917e-13,  -1.068588966477736e-14,  -2.335405175197091e-16,   3.710659373302999e-18,   4.010025134950052e-19,
   6.386370225565177e-21,  -1.013559431778063e-22,   8.035184939975184e-01,  -1.492471222890503e-02,   1.231695383415292e-04,   7.522531455766299e-07,  -3.769463178872410e-08,
   7.454513273683470e-10,   1.329421954641870e-11,  -3.586832080802482e-13,  -1.066828984571726e-14,  -2.312686285332844e-16,   3.753460431238278e-18,   4.001510324785118e-19,
   6.315242473571199e-21,  -1.039552290563343e-22,   8.035250157647235e-01,  -1.492459176710465e-02,   1.231575528124657e-04,   7.526479651623288e-07,  -3.768408696972888e-08,
   7.450501688824706e-10,   1.327839337345767e-11,  -3.591206196866198e-13,  -1.065922588639421e-14,  -2.301025404208314e-16,   3.775377874383765e-18,   3.997110613240326e-19,
   6.278690230073599e-21,  -1.052855855882719e-22,   8.035272856761292e-01,  -1.492454983438020e-02,   1.231533814003143e-04,   7.527853690154926e-07,  -3.768041773241201e-08,
   7.449105042039599e-10,   1.327288599087930e-11,  -3.592726907517236e-13,  -1.065606702044696e-14,  -2.296967742347410e-16,   3.782996416835786e-18,   3.995574969547822e-19,
   6.265963990015536e-21,  -1.057479112179608e-22,   8.035276458774626e-01,  -1.492454318000212e-02,   1.231527194670447e-04,   7.528071723208249e-07,  -3.767983552166963e-08,
   7.448883395496392e-10,   1.327201209554936e-11,  -3.592968140735367e-13,  -1.065556555872582e-14,  -2.296323895514892e-16,   3.784204898651001e-18,   3.995331080809338e-19,
   6.263944326825102e-21,  -1.058212418717376e-22,   1.236977047490561e+00,  -1.900770409035877e-02,  -1.879713300150174e-05,   4.765603818993917e-06,  -2.136065174582256e-08,
  -1.445124003169518e-09,   5.502375872918681e-11,   7.017700142776876e-13,  -6.455838028048743e-14,  -1.004041818508885e-15,   3.800408545484782e-17,   9.033082999224130e-19,
  -1.692679624677080e-21,   7.323519427020434e-23,   1.236975262004922e+00,  -1.900636849735373e-02,  -1.880872370370188e-05,   4.764260148600816e-06,  -2.128523464509108e-08,
  -1.443794093979724e-09,   5.485759410394591e-11,   6.985027510061131e-13,  -6.439849061630280e-14,  -9.993852706423628e-16,   3.799084887638783e-17,   9.033548113363546e-19,
  -1.750636009958231e-21,   6.426017837148463e-23,   1.236972110654122e+00,  -1.900401212777322e-02,  -1.882914165099352e-05,   4.761890218836080e-06,  -2.115234865779921e-08,
  -1.441452618039602e-09,   5.456473495603285e-11,   6.927503879343268e-13,  -6.411641066592097e-14,  -9.911690193058818e-16,   3.796718849044063e-17,   9.033845707617463e-19,
  -1.854061192036576e-21,   4.850107966746245e-23,   1.236968298587912e+00,  -1.900116330088923e-02,  -1.885377328716372e-05,   4.759026173077699e-06,  -2.099198293920011e-08,
  -1.438630081164753e-09,   5.421118781639737e-11,   6.858163492485901e-13,  -6.377539894338583e-14,  -9.812345015195034e-16,   3.793805547756727e-17,   9.033316789988973e-19,
  -1.981081762564301e-21,   2.957729123510998e-23,   1.236964596416058e+00,  -1.899839825381654e-02,  -1.887762462869681e-05,   4.756247582426728e-06,  -2.083663894086261e-08,
  -1.435899209523739e-09,   5.386857898135365e-11,   6.791077108952747e-13,  -6.344443786013817e-14,  -9.715911249572377e-16,   3.790922146321248e-17,   9.031876661905288e-19,
  -2.106415088411056e-21,   1.134519265931104e-23,   1.236961612932824e+00,  -1.899617115802972e-02,  -1.889679557464669e-05,   4.754010455603102e-06,  -2.071173652896812e-08,
  -1.433705832799238e-09,   5.359301375876604e-11,   6.737196584909323e-13,  -6.317788305607431e-14,  -9.638233105367685e-16,   3.788559408660675e-17,   9.030055419962829e-19,
  -2.208813742622879e-21,  -3.242725918471509e-24,   1.236959640981012e+00,  -1.899469972379382e-02,  -1.890944217318044e-05,   4.752532822750454e-06,  -2.062932099307312e-08,
  -1.432259704191951e-09,   5.341113861871404e-11,   6.701673290959657e-13,  -6.300177957578836e-14,  -9.586909048647701e-16,   3.786978476972175e-17,   9.028529441805712e-19,
  -2.277170565315744e-21,  -1.283331238658603e-23,   1.236958628128953e+00,  -1.899394413096055e-02,  -1.891593024836685e-05,   4.751774179330068e-06,  -2.058703306746244e-08,
  -1.431518041346188e-09,   5.331780303752166e-11,   6.683455118175992e-13,  -6.291135171477186e-14,  -9.560553126261868e-16,   3.786160478633832e-17,   9.027646278799981e-19,
  -2.312487995253329e-21,  -1.774341485632180e-23,   1.236958275570987e+00,  -1.899368114935560e-02,  -1.891818743866705e-05,   4.751510157048995e-06,  -2.057232016007010e-08,
  -1.431260056853197e-09,   5.328532724141785e-11,   6.677118054569274e-13,  -6.287987901942452e-14,  -9.551379944918962e-16,   3.785874790845255e-17,   9.027323067202959e-19,
  -2.324814308883240e-21,  -1.945001211288420e-23,   1.236958219623681e+00,  -1.899363941824298e-02,  -1.891854557414216e-05,   4.751468261797150e-06,  -2.056998569924251e-08,
  -1.431219125768498e-09,   5.328017427866356e-11,   6.676112636810447e-13,  -6.287488480980047e-14,  -9.549924298916055e-16,   3.785829409743043e-17,   9.027271027455652e-19,
  -2.326771924900658e-21,  -1.972071120980075e-23,   1.752806440766388e+00,  -1.347816786696809e-02,  -3.856196223794355e-04,  -3.324122416366494e-06,   2.200267074983701e-07,
   9.721093412327077e-09,   6.382261532354588e-11,  -8.636928764047712e-12,  -3.377472889346670e-13,  -7.595456847641022e-16,   3.598774877065195e-16,   1.219450853697915e-17,
  -2.573856549859684e-20,  -1.479838550830468e-20,   1.752770538348579e+00,  -1.347907120929417e-02,  -3.854954132541125e-04,  -3.315151993486545e-06,   2.201063893394116e-07,
   9.704076185759811e-09,   6.296712775948107e-11,  -8.637976435466051e-12,  -3.362398639672157e-13,  -7.007751419922982e-16,   3.595648922907105e-16,   1.208857723550189e-17,
  -2.911246282453572e-20,  -1.475893548020067e-20,   1.752707197484193e+00,  -1.348066314480370e-02,  -3.852762102101273e-04,  -3.299336514124820e-06,   2.202460233590068e-07,
   9.674048083731372e-09,   6.146081656583752e-11,  -8.639666820179688e-12,  -3.335811938308737e-13,  -5.975152340496087e-16,   3.589968299629952e-16,   1.190191197739732e-17,
  -3.502140463304414e-20,  -1.468800373455848e-20,   1.752630621262235e+00,  -1.348258467736184e-02,  -3.850110897213305e-04,  -3.280234387522003e-06,   2.204132259740457e-07,
   9.637736353425928e-09,   5.964484052067560e-11,  -8.641441852315772e-12,  -3.303683940243395e-13,  -4.734045305561313e-16,   3.582819702837860e-16,   1.167662959109863e-17,
  -4.209108561640226e-20,  -1.459999878131432e-20,   1.752556299387048e+00,  -1.348444645468952e-02,  -3.847536551645568e-04,  -3.261713537621495e-06,   2.205738246488575e-07,
   9.602484275940745e-09,   5.788764970987474e-11,  -8.642884383961008e-12,  -3.272517031788723e-13,  -3.537068214729998e-16,   3.575589187028225e-16,   1.145839176094603e-17,
  -4.887536757866929e-20,  -1.451225140105611e-20,   1.752496438829370e+00,  -1.348594369126296e-02,  -3.845462263848806e-04,  -3.246809978697577e-06,   2.207019716443511e-07,
   9.574084897919283e-09,   5.647618148398389e-11,  -8.643846134643798e-12,  -3.247425761318806e-13,  -2.578429644640303e-16,   3.569557395557723e-16,   1.128291816017478e-17,
  -5.428434495219586e-20,  -1.443992323601094e-20,   1.752456890002608e+00,  -1.348693177257750e-02,  -3.844091402703355e-04,  -3.236970098733046e-06,   2.207860479531725e-07,
   9.555318782964397e-09,   5.554551607920681e-11,  -8.644383853054768e-12,  -3.230854055933506e-13,  -1.947732448151885e-16,   3.565470900343369e-16,   1.116713468492234e-17,
  -5.783096554815735e-20,  -1.439133421843946e-20,   1.752436581632056e+00,  -1.348743880826380e-02,  -3.843387335592093e-04,  -3.231919362671995e-06,   2.208290395074452e-07,
   9.545681401671314e-09,   5.506819559496055e-11,  -8.644629818751167e-12,  -3.222346244541428e-13,  -1.624690387577690e-16,   3.563341234647405e-16,   1.110772617135916e-17,
  -5.964382140441750e-20,  -1.436613682650976e-20,   1.752429513411336e+00,  -1.348761522438878e-02,  -3.843142268366967e-04,  -3.230161807824611e-06,   2.208439735726321e-07,
   9.542327010753936e-09,   5.490215863681434e-11,  -8.644710630593565e-12,  -3.219385431767698e-13,  -1.512388086995071e-16,   3.562595051415284e-16,   1.108705678231084e-17,
  -6.027344978906478e-20,  -1.435732783681538e-20,   1.752428391795993e+00,  -1.348764321624140e-02,  -3.843103379088726e-04,  -3.229882927069447e-06,   2.208463420011385e-07,
   9.541794714561836e-09,   5.487581554869524e-11,  -8.644723226621383e-12,  -3.218915611020952e-13,  -1.494573687566556e-16,   3.562476408409615e-16,   1.108377722910374e-17,
  -6.037329894708140e-20,  -1.435592813191732e-20,   8.558340622798765e-03,  -1.789147252911306e-04,   2.758363446979252e-06,  -3.769293606918473e-08,   5.814439330684404e-10,
  -2.959167935168244e-12,   5.611434312497535e-14,  -5.519140285666616e-15,  -1.001302865702315e-16,   2.317700677273802e-18,   1.789991391139189e-19,   2.245574245332673e-21,
  -1.125950218277387e-22,  -5.581960131322717e-24,   8.558599876289954e-03,  -1.789253365175465e-04,   2.758690936008043e-06,  -3.769580042628951e-08,   5.815199366749650e-10,
  -2.969904642808430e-12,   5.586655315556674e-14,  -5.511060697913863e-15,  -9.939810153716023e-17,   2.327796979962330e-18,   1.782871281448762e-19,   2.207107318209978e-21,
  -1.129456666073472e-22,  -5.539424696747276e-24,   8.559057358171774e-03,  -1.789440608643592e-04,   2.759268829641254e-06,  -3.770086277296026e-08,   5.816537688349606e-10,
  -2.988836676353086e-12,   5.543087246146931e-14,  -5.496777516460680e-15,  -9.810860446792453e-17,   2.345453222442819e-18,   1.770291594616036e-19,   2.139485369147672e-21,
  -1.135507708222787e-22,  -5.464317159503532e-24,   8.559610592810954e-03,  -1.789667036897402e-04,   2.759967682838836e-06,  -3.770699809510689e-08,   5.818151283267404e-10,
  -3.011707203761588e-12,   5.490667961111126e-14,  -5.479461044074883e-15,  -9.655352029012404e-17,   2.366533228739854e-18,   1.755053043191351e-19,   2.058148686263103e-21,
  -1.142593658982926e-22,  -5.373410907552288e-24,   8.560147708097179e-03,  -1.789886861534816e-04,   2.760646178099123e-06,  -3.771296868424962e-08,   5.819712808121892e-10,
  -3.033886138275109e-12,   5.440055900388857e-14,  -5.462603663945992e-15,  -9.504826315259330e-17,   2.386715406997437e-18,   1.740231972720126e-19,   1.979641568576310e-21,
  -1.149232038728910e-22,  -5.285077733827964e-24,   8.560580433197962e-03,  -1.790063958019177e-04,   2.761192808453934e-06,  -3.771778891384931e-08,   5.820967234177233e-10,
  -3.051736424347500e-12,   5.399480677439680e-14,  -5.448990275710244e-15,  -9.383879731931725e-17,   2.402772563735785e-18,   1.728272842321682e-19,   1.916722062042308e-21,
  -1.154408470830342e-22,  -5.213862783407008e-24,   8.560866385910002e-03,  -1.790180984444010e-04,   2.761554033272240e-06,  -3.772097912562046e-08,   5.821794418386866e-10,
  -3.063523351726352e-12,   5.372765713831471e-14,  -5.439978592371726e-15,  -9.304114728578358e-17,   2.413284528589069e-18,   1.720361095661481e-19,   1.875305061429121e-21,
  -1.157745459624599e-22,  -5.166780158783328e-24,   8.561013241157482e-03,  -1.790241084419599e-04,   2.761739546055702e-06,  -3.772261902558181e-08,   5.822218686621935e-10,
  -3.069573957527850e-12,   5.359076092871759e-14,  -5.435345674817836e-15,  -9.263199341424032e-17,   2.418652576159133e-18,   1.716295173861421e-19,   1.854084660532046e-21,
  -1.159433422861676e-22,  -5.142593616946002e-24,   8.561064356242969e-03,  -1.790262002974632e-04,   2.761804116521894e-06,  -3.772319005824814e-08,   5.822366272702874e-10,
  -3.071679520866519e-12,   5.354316035230004e-14,  -5.433732353522320e-15,  -9.248965971802299e-17,   2.420516147642623e-18,   1.714879540153242e-19,   1.846706541025967e-21,
  -1.160016843581413e-22,  -5.134174131975862e-24,   8.561072467539704e-03,  -1.790265322471104e-04,   2.761814363015104e-06,  -3.772328068515742e-08,   5.822389688577980e-10,
  -3.072013625519580e-12,   5.353560904626105e-14,  -5.433476304097783e-15,  -9.246707693176640e-17,   2.420811641737104e-18,   1.714654877167040e-19,   1.845536107062530e-21,
  -1.160109230384824e-22,  -5.132838022354072e-24,   7.754092352833379e-02,  -1.609179928264099e-03,   2.418742093999141e-05,  -3.135559401986501e-07,   4.576721421105335e-09,
  -1.078683587938300e-11,   2.242929049617921e-13,  -4.662516936098679e-14,  -1.018140531455370e-15,   2.271145313843936e-17,   1.665212827329485e-18,   2.149255043636851e-20,
  -1.051675733297980e-21,  -5.254553292872097e-23,   7.754319626579909e-02,  -1.609268154162113e-03,   2.418999693734770e-05,  -3.135668127217690e-07,   4.577007098650179e-09,
  -1.087736508162163e-11,   2.217602868226451e-13,  -4.654604836973424e-14,  -1.011330230625054e-15,   2.280831055547521e-17,   1.658554558892294e-18,   2.113025012167818e-20,
  -1.055123499567380e-21,  -5.214878298408040e-23,   7.754720674339455e-02,  -1.609423832767228e-03,   2.419454244899504e-05,  -3.135860660690547e-07,   4.577508340486294e-09,
  -1.103697745307956e-11,   2.173058456260539e-13,  -4.640618255641405e-14,  -9.993363113455362e-16,   2.297772073229410e-17,   1.646790019860624e-18,   2.049333192092061e-20,
  -1.061077691402499e-21,  -5.144810984761273e-23,   7.755205659095085e-02,  -1.609612085478071e-03,   2.420003914044646e-05,  -3.136094643393594e-07,   4.578109615052502e-09,
  -1.122976420546842e-11,   2.119440129653779e-13,  -4.623662232039654e-14,  -9.848723263483743e-16,   2.318002888604479e-17,   1.632537509124623e-18,   1.972720062799574e-20,
  -1.068057876592716e-21,  -5.059987184730307e-23,   7.755676509003066e-02,  -1.609794842654193e-03,   2.420537545237525e-05,  -3.136323013235296e-07,   4.578688275796442e-09,
  -1.141668937155103e-11,   2.067644781926868e-13,  -4.607156629085721e-14,  -9.708720243933117e-16,   2.337377031171386e-17,   1.618674013115774e-18,   1.898768368643460e-20,
  -1.074605377677982e-21,  -4.977545693221093e-23,   7.756055844717040e-02,  -1.609942072837962e-03,   2.420967447201654e-05,  -3.136507861024982e-07,   4.579150831827803e-09,
  -1.156710962375511e-11,   2.026102526455778e-13,  -4.593827945130388e-14,  -9.596230309366485e-16,   2.352794911941722e-17,   1.607486517977553e-18,   1.839497098583637e-20,
  -1.079716991239104e-21,  -4.911067483388177e-23,   7.756306515314190e-02,  -1.610039361579083e-03,   2.421251526375247e-05,  -3.136630433826517e-07,   4.579454719295725e-09,
  -1.166642413790080e-11,   1.998741820527792e-13,  -4.585005028052662e-14,  -9.522043369739388e-16,   2.362890149607103e-17,   1.600084756556783e-18,   1.800480245816882e-20,
  -1.083015233870122e-21,  -4.867110083591916e-23,   7.756435250468539e-02,  -1.610089324516473e-03,   2.421397416971650e-05,  -3.136693513344420e-07,   4.579610236209812e-09,
  -1.171740197419988e-11,   1.984718495999404e-13,  -4.580469247229863e-14,  -9.483989511190100e-16,   2.368045945319495e-17,   1.596280766525282e-18,   1.780489177960180e-20,
  -1.084684557196933e-21,  -4.844527017630628e-23,   7.756480058524264e-02,  -1.610106714656238e-03,   2.421448195902977e-05,  -3.136715489840905e-07,   4.579664278792419e-09,
  -1.173514130803611e-11,   1.979841958160431e-13,  -4.578889766385522e-14,  -9.470751633394773e-16,   2.369835920063298e-17,   1.594956305182263e-18,   1.773538420660877e-20,
  -1.085261689957896e-21,  -4.836665400792940e-23,   7.756487168974385e-02,  -1.610109474235805e-03,   2.421456253837746e-05,  -3.136718978209473e-07,   4.579672850500937e-09,
  -1.173795610755069e-11,   1.979068328013847e-13,  -4.578639088449649e-14,  -9.468651302377511e-16,   2.370119748629098e-17,   1.594746110210735e-18,   1.772435778587446e-20,
  -1.085353088426303e-21,  -4.835417805916049e-23,   2.183725294141637e-01,  -4.457532331205445e-03,   6.309414978033080e-05,  -7.111667398062240e-07,   8.798160787319049e-09,
   5.922259271641451e-11,  -7.792250568537777e-13,  -1.204276915425822e-13,  -3.335692557802391e-15,   7.002397069546573e-17,   5.062505772923885e-18,   6.651121193762683e-20,
  -3.144527804132048e-21,  -1.611070007195474e-22,   2.183784544000332e-01,  -4.457732158215045e-03,   6.309909194584800e-05,  -7.111131754767007e-07,   8.796967149558065e-09,
   5.898939877911250e-11,  -7.875554168836307e-13,  -1.201837073578184e-13,  -3.314979393406660e-15,   7.032404447690633e-17,   5.042544054906385e-18,   6.539900265811751e-20,
  -3.156014915317720e-21,  -1.599165259688411e-22,   2.183889095068206e-01,  -4.458084744213419e-03,   6.310781190610215e-05,  -7.110188369037564e-07,   8.794851599668389e-09,
   5.857831861565773e-11,  -8.022106558187355e-13,  -1.197524013387296e-13,  -3.278499579961936e-15,   7.084893463288076e-17,   5.007267960013179e-18,   6.344360195853451e-20,
  -3.175879156653768e-21,  -1.578133971645199e-22,   2.184015525747533e-01,  -4.458511074700441e-03,   6.311835520292351e-05,  -7.109050624825922e-07,   8.792277533228931e-09,
   5.808190908847015e-11,  -8.198573246598944e-13,  -1.192295194699482e-13,  -3.234505383573472e-15,   7.147582344234903e-17,   4.964522174561056e-18,   6.109124287982341e-20,
  -3.199211873669064e-21,  -1.552661372807088e-22,   2.184138269175599e-01,  -4.458924927766368e-03,   6.312858943115660e-05,  -7.107949269621840e-07,   8.789762045257883e-09,
   5.760070913949517e-11,  -8.369104112486590e-13,  -1.187205203422060e-13,  -3.191919861839467e-15,   7.207623965232369e-17,   4.922933275851415e-18,   5.882032949654156e-20,
  -3.221147096520748e-21,  -1.527891732085112e-22,   2.184237154494667e-01,  -4.459258307255612e-03,   6.313683325763708e-05,  -7.107064285265007e-07,   8.787723716917225e-09,
   5.721356719097327e-11,  -8.505923646655100e-13,  -1.183094857995019e-13,  -3.157701955200224e-15,   7.255410139787239e-17,   4.889365090004465e-18,   5.700002987654604e-20,
  -3.238307792782492e-21,  -1.507909460269188e-22,   2.184302498506745e-01,  -4.459478591071000e-03,   6.314228027055809e-05,  -7.106480605775429e-07,   8.786371019487521e-09,
   5.695799897172735e-11,  -8.596058756110312e-13,  -1.180373991350489e-13,  -3.135134714209963e-15,   7.286701892901907e-17,   4.867152641629038e-18,   5.580167603771864e-20,
  -3.249398685361420e-21,  -1.494692302589726e-22,   2.184336056511768e-01,  -4.459591715060226e-03,   6.314507746053483e-05,  -7.106181199198029e-07,   8.785674551582469e-09,
   5.682682931062641e-11,  -8.642263159756577e-13,  -1.178975210962346e-13,  -3.123558768899451e-15,   7.302683879884382e-17,   4.855735946137866e-18,   5.518764630515906e-20,
  -3.255017752821894e-21,  -1.487900688591232e-22,   2.184347736798662e-01,  -4.459631088536224e-03,   6.314605103030571e-05,  -7.106077042233331e-07,   8.785431854327391e-09,
   5.678118674884473e-11,  -8.658331613818007e-13,  -1.178488116780369e-13,  -3.119531791228018e-15,   7.308232589001048e-17,   4.851760751211859e-18,   5.497414775216553e-20,
  -3.256961341612539e-21,  -1.485536183578635e-22,   2.184349590304832e-01,  -4.459637336547309e-03,   6.314620552157392e-05,  -7.106060516531999e-07,   8.785393328079756e-09,
   5.677394448407653e-11,  -8.660880819620446e-13,  -1.178410810456902e-13,  -3.118892866755495e-15,   7.309112429907648e-17,   4.851129871051677e-18,   5.494027892298726e-20,
  -3.257269184640002e-21,  -1.485160939904744e-22,   4.373821682464133e-01,  -8.656605736800660e-03,   1.082043442130140e-04,  -8.243852057226392e-07,   4.581807833556444e-09,
   3.647542151989334e-10,  -4.117796818786349e-12,  -2.670556935144207e-13,  -7.189894510895889e-15,   1.438184640083830e-16,   1.182337055847547e-17,   1.558353272779901e-19,
  -7.054156123074381e-21,  -3.732852846547092e-22,   4.373923174884054e-01,  -8.656836406455863e-03,   1.082068874914631e-04,  -8.240475941242327e-07,   4.575807314957242e-09,
   3.642364959778399e-10,  -4.135674552521287e-12,  -2.665523472916718e-13,  -7.141467826536094e-15,   1.445224444118472e-16,   1.177837891090949e-17,   1.532537562065148e-19,
  -7.084582901038321e-21,  -3.706138471152018e-22,   4.374102261755747e-01,  -8.657243350252740e-03,   1.082113723533574e-04,  -8.234522652446520e-07,   4.565199255915615e-09,
   3.633237865764351e-10,  -4.167117631193307e-12,  -2.656623259685329e-13,  -7.056173631493552e-15,   1.457539591524039e-16,   1.169884811579953e-17,   1.487145271426045e-19,
  -7.137296043473956e-21,  -3.658915131832083e-22,   4.374318818752757e-01,  -8.657735300766564e-03,   1.082167907279629e-04,  -8.227330553310447e-07,   4.552337771007378e-09,
   3.622215190578052e-10,  -4.204964456974706e-12,  -2.645829527987896e-13,  -6.953300356051957e-15,   1.472249731941948e-16,   1.160243926978918e-17,   1.432529452743324e-19,
  -7.199381442942412e-21,  -3.601670530849478e-22,   4.374529051926019e-01,  -8.658212741466160e-03,   1.082220457911049e-04,  -8.220355579051473e-07,   4.539816449531712e-09,
   3.611529153987371e-10,  -4.241523077246571e-12,  -2.635318427914289e-13,  -6.853711063509987e-15,   1.486340639315505e-16,   1.150860079636853e-17,   1.379795666572085e-19,
  -7.257928049699606e-21,  -3.545955205195509e-22,   4.374698415463409e-01,  -8.658597263849826e-03,   1.082262756128511e-04,  -8.214741635709849e-07,   4.529703989556782e-09,
   3.602931090070898e-10,  -4.270843726601147e-12,  -2.626827547878821e-13,  -6.773682907922221e-15,   1.497556771596797e-16,   1.143283213681908e-17,   1.337519423753999e-19,
  -7.303863099707485e-21,  -3.500972566605487e-22,   4.374810329059596e-01,  -8.658851301608272e-03,   1.082290688443358e-04,  -8.211034491079297e-07,   4.523009425828442e-09,
   3.597254775182520e-10,  -4.290154476382214e-12,  -2.621205601500916e-13,  -6.720899610665688e-15,   1.504902103782031e-16,   1.138268174678205e-17,   1.309684717166348e-19,
  -7.333616869587227e-21,  -3.471201744244958e-22,   4.374867802413321e-01,  -8.658981747379954e-03,   1.082305027577812e-04,  -8.209131452010537e-07,   4.519567608977564e-09,
   3.594341304684852e-10,  -4.300051753357394e-12,  -2.618314976210531e-13,  -6.693823156615677e-15,   1.508653880711112e-16,   1.135690145648191e-17,   1.295421422693267e-19,
  -7.348712076143606e-21,  -3.455898739904913e-22,   4.374887806598860e-01,  -8.659027147873984e-03,   1.082310017577486e-04,  -8.208469202333491e-07,   4.518369042626300e-09,
   3.593327497669716e-10,  -4.303493453847317e-12,  -2.617308313856340e-13,  -6.684403773873957e-15,   1.509956476092146e-16,   1.134792432690897e-17,   1.290461914998134e-19,
  -7.353936733871807e-21,  -3.450570145319584e-22,   4.374890980990377e-01,  -8.659034352195501e-03,   1.082310809380525e-04,  -8.208364118150249e-07,   4.518178817682979e-09,
   3.593166632475665e-10,  -4.304039455404548e-12,  -2.617148544143795e-13,  -6.682909276661880e-15,   1.510163026056117e-16,   1.134649958763071e-17,   1.289675145059375e-19,
  -7.354764421948935e-21,  -3.449724464767526e-22,   7.457168977685635e-01,  -1.391305620511415e-02,   1.292279497670271e-04,   2.733506611624490e-07,  -2.060144938081222e-08,
   9.143868418543851e-10,  -2.058079910037207e-12,  -7.764014150883283e-13,  -1.247060415479568e-14,   3.036361764092924e-16,   2.439575561550419e-17,   3.766307250235521e-19,
  -1.500882934728679e-20,  -8.260760766826375e-22,   7.457289895644769e-01,  -1.391297635340453e-02,   1.292163429153840e-04,   2.741952064443411e-07,  -2.060470323315005e-08,
   9.128754009876081e-10,  -2.088763426236465e-12,  -7.753326555878427e-13,  -1.237079759658490e-14,   3.053570434172913e-16,   2.429945615490830e-17,   3.708989278096296e-19,
  -1.508623798252100e-20,  -8.205192899455857e-22,   7.457503248419449e-01,  -1.391283526289401e-02,   1.291958608711470e-04,   2.756842732028583e-07,  -2.061047898353320e-08,
   9.102101716857931e-10,  -2.142693870441585e-12,  -7.734422522263852e-13,  -1.219502055965373e-14,   3.083698308287752e-16,   2.412917004805954e-17,   3.608184963192804e-19,
  -1.522053713414488e-20,  -8.106854958721507e-22,   7.457761221755185e-01,  -1.391266432939715e-02,   1.291710910737497e-04,   2.774829143719397e-07,  -2.061752136331766e-08,
   9.069903058096507e-10,  -2.207547681766694e-12,  -7.711486245703064e-13,  -1.198303805064732e-14,   3.119725953941027e-16,   2.392264508082101e-17,   3.486862156235650e-19,
  -1.537904511116924e-20,  -7.987463386437196e-22,   7.458011641970337e-01,  -1.391249804964721e-02,   1.291470421523022e-04,   2.792269587661943e-07,  -2.062441880563053e-08,
   9.038676193885869e-10,  -2.270130844061967e-12,  -7.689139702293983e-13,  -1.177784594765352e-14,   3.154279868444713e-16,   2.372152200803971e-17,   3.369683237780513e-19,
  -1.552887084394539e-20,  -7.871069915605687e-22,   7.458213365893497e-01,  -1.391236385305739e-02,   1.291276666162673e-04,   2.806304736120035e-07,  -2.063001872694027e-08,
   9.013542518966630e-10,  -2.320278211529616e-12,  -7.671080404761238e-13,  -1.161297421915565e-14,   3.181815206462881e-16,   2.355905386527157e-17,   3.275715675357057e-19,
  -1.564668032365320e-20,  -7.776962563712061e-22,   7.458346655912920e-01,  -1.391227505904208e-02,   1.291148626057661e-04,   2.815571744275235e-07,  -2.063374026102526e-08,
   8.996945561015935e-10,  -2.353283258507432e-12,  -7.659119289256990e-13,  -1.150423994370951e-14,   3.199863116995995e-16,   2.345148223470854e-17,   3.213834624175426e-19,
  -1.572311841311028e-20,  -7.714614101586374e-22,   7.458415104997449e-01,  -1.391222942218589e-02,   1.291082868232165e-04,   2.820328580339500e-07,  -2.063565799230680e-08,
   8.988425611856089e-10,  -2.370192318368990e-12,  -7.652968104146415e-13,  -1.144846470393435e-14,   3.209086211970924e-16,   2.339617298228706e-17,   3.182121089102918e-19,
  -1.576193873477832e-20,  -7.682545226985876e-22,   7.458438929054619e-01,  -1.391221353198994e-02,   1.291059980123766e-04,   2.821983887961284e-07,  -2.063632651716280e-08,
   8.985460704415983e-10,  -2.376071209567163e-12,  -7.650825764911634e-13,  -1.142906197658392e-14,   3.212289178259855e-16,   2.337691162451325e-17,   3.171093312921392e-19,
  -1.577538147334938e-20,  -7.671375476145403e-22,   7.458442709591396e-01,  -1.391221101015603e-02,   1.291056348072668e-04,   2.822246545739511e-07,  -2.063643265224358e-08,
   8.984990240028062e-10,  -2.377003801934194e-12,  -7.650485740538288e-13,  -1.142598352269679e-14,   3.212797102448004e-16,   2.337385461652252e-17,   3.169343851062307e-19,
  -1.577751137598167e-20,  -7.669602617542698e-22,   1.160997170408198e+00,  -1.893685771364320e-02,   3.562557580556019e-05,   4.266535813429131e-06,  -3.676968408784862e-08,
  -1.432142144938348e-10,   4.285140425511434e-11,  -1.573066430699585e-12,  -6.407923083018366e-14,   1.265583238435910e-15,   7.247174818035524e-17,   4.081177572424645e-19,
  -3.604651993515672e-20,  -1.802904491540624e-21,   1.161000469446259e+00,  -1.893565832068816e-02,   3.560522125011709e-05,   4.266376157453225e-06,  -3.671133159052442e-08,
  -1.462425133166204e-10,   4.268932968904920e-11,  -1.568754683998368e-12,  -6.378113350488842e-14,   1.267206123401296e-15,   7.223598074714905e-17,   3.956331987777925e-19,
  -3.633167205702861e-20,  -1.790397015891746e-21,   1.161006289138203e+00,  -1.893354201381549e-02,   3.556933155584543e-05,   4.266092155022539e-06,  -3.660855058349626e-08,
  -1.515790739009967e-10,   4.240397807462232e-11,  -1.561142437471778e-12,  -6.325595559423024e-14,   1.270018117769332e-15,   7.181860983699335e-17,   3.736798734381124e-19,
  -3.682766386487658e-20,  -1.768212892116985e-21,   1.161013323794042e+00,  -1.893098302296322e-02,   3.552597803746469e-05,   4.265744840431406e-06,  -3.648457804727056e-08,
  -1.580202960391736e-10,   4.206000341723777e-11,  -1.551930730096535e-12,  -6.262230525703595e-14,   1.273330629318416e-15,   7.131163351413971e-17,   3.472634921035844e-19,
  -3.741525620832218e-20,  -1.741195668294661e-21,   1.161020150218318e+00,  -1.892849887272329e-02,   3.548393791250796e-05,   4.265403598399467e-06,  -3.636455307725031e-08,
  -1.642609567185294e-10,   4.172720354900578e-11,  -1.542981063397420e-12,  -6.200863885542617e-14,   1.276454715277194e-15,   7.081710583001380e-17,   3.217554230981495e-19,
  -3.797300200791261e-20,  -1.714770959925250e-21,   1.161025647565106e+00,  -1.892649772677626e-02,   3.545010435890067e-05,   4.265125781764830e-06,  -3.626809524494565e-08,
  -1.692794877183894e-10,   4.145990910947168e-11,  -1.535766326818571e-12,  -6.151533341909749e-14,   1.278905975541064e-15,   7.041704887721410e-17,   3.013046404527407e-19,
  -3.841327410766967e-20,  -1.693345421536868e-21,   1.161029279168521e+00,  -1.892517543134975e-02,   3.542776409447032e-05,   4.264940778806313e-06,  -3.620447139695919e-08,
  -1.725913020346378e-10,   4.128367931903311e-11,  -1.530996543250966e-12,  -6.118988422337355e-14,   1.280493752904830e-15,   7.015188854716401e-17,   2.878393560288232e-19,
  -3.869978912861400e-20,  -1.679121340871762e-21,   1.161031143878364e+00,  -1.892449637749801e-02,   3.541629635026831e-05,   4.264845330003076e-06,  -3.617183265302659e-08,
  -1.742907341694506e-10,   4.119329852385553e-11,  -1.528546291944297e-12,  -6.102291099263061e-14,   1.281299282195286e-15,   7.001546745103885e-17,   2.809392357379768e-19,
  -3.884556855298183e-20,  -1.671796287710925e-21,   1.161031792861180e+00,  -1.892426002788135e-02,   3.541230570054496e-05,   4.264812038001027e-06,  -3.616047803127079e-08,
  -1.748820232549263e-10,   4.116186001640470e-11,  -1.527693342510123e-12,  -6.096482000334539e-14,   1.281578084200115e-15,   6.996794543089650e-17,   2.785399682209595e-19,
  -3.889609227752597e-20,  -1.669243524998301e-21,   1.161031895843606e+00,  -1.892422252251377e-02,   3.541167247753881e-05,   4.264806751688018e-06,  -3.615867647457745e-08,
  -1.749758425375609e-10,   4.115687207697349e-11,  -1.527557985639492e-12,  -6.095560297782310e-14,   1.281622251744046e-15,   6.996040247329110e-17,   2.781593506740215e-19,
  -3.890409944272245e-20,  -1.668838284727214e-21,   1.692575273312539e+00,  -1.664801374031779e-02,  -3.979769482710553e-04,   1.731552547246940e-06,   4.041976114654490e-07,
   7.227259329229973e-09,  -3.082300897200357e-10,  -1.621253094304819e-11,  -4.941672183230284e-15,   2.053234615495093e-14,   5.164941889727244e-16,  -1.352835767709654e-17,
  -1.011297535384212e-18,  -8.308689946915463e-21,   1.692538414494710e+00,  -1.664750384228946e-02,  -3.977520317376261e-04,   1.738069763828363e-06,   4.037645526591911e-07,
   7.196409365614353e-09,  -3.082024555648493e-10,  -1.614509902255685e-11,  -2.948467438262354e-15,   2.046103816518987e-14,   5.106527486344938e-16,  -1.357102055472605e-17,
  -1.002262406330910e-18,  -7.972739218039950e-21,   1.692473393381199e+00,  -1.664660267349906e-02,  -3.973553608992247e-04,   1.749546309258332e-06,   4.030004609079307e-07,
   7.142081128709940e-09,  -3.081495524767662e-10,  -1.602631107478227e-11,   5.489023615883920e-16,   2.033505340776857e-14,   5.003904439698137e-16,  -1.364437729719012e-17,
  -9.863594698669351e-19,  -7.385514008350836e-21,   1.692394797877047e+00,  -1.664551050907116e-02,  -3.968760397375118e-04,   1.763384392334902e-06,   4.020765968597384e-07,
   7.076569087282432e-09,  -3.080785471063861e-10,  -1.588300715188556e-11,   4.744523117835703e-15,   2.018244270991635e-14,   4.880577598230322e-16,  -1.372982521937819e-17,
  -9.671975784446605e-19,  -6.684878196306494e-21,   1.692318528785329e+00,  -1.664444768160254e-02,  -3.964110764021814e-04,   1.776776893168388e-06,   4.011798174834765e-07,
   7.013161698213614e-09,  -3.080022861105215e-10,  -1.574424211214022e-11,   8.782679002190164e-15,   2.003401648760090e-14,   4.761654442254417e-16,  -1.380939548150064e-17,
  -9.486674144820289e-19,  -6.014543449841251e-21,   1.692257108927795e+00,  -1.664358964113913e-02,  -3.960367611410731e-04,   1.787536197091581e-06,   4.004574523219585e-07,
   6.962217875536307e-09,  -3.079356245794493e-10,  -1.563270719964260e-11,   1.201086764380809e-14,   1.991425445517561e-14,   4.666423717893103e-16,  -1.387109362528644e-17,
  -9.337916275666988e-19,  -5.481532767925950e-21,   1.692216534318451e+00,  -1.664302176342049e-02,  -3.957895442280704e-04,   1.794631319440628e-06,   3.999801610401733e-07,
   6.928621784587440e-09,  -3.078890269446344e-10,  -1.555913059441147e-11,   1.413184484352778e-14,   1.983502585876453e-14,   4.603776614536856e-16,  -1.391069428297619e-17,
  -9.239875213377224e-19,  -5.132740706725167e-21,   1.692195700573416e+00,  -1.664272985302086e-02,  -3.956626248432164e-04,   1.798270544674186e-06,   3.997350601180419e-07,
   6.911389188840345e-09,  -3.078643107406505e-10,  -1.552138375605364e-11,   1.521731798463845e-14,   1.979431014802548e-14,   4.571690708002354e-16,  -1.393067148700629e-17,
  -9.189605766590015e-19,  -4.954670921928379e-21,   1.692188449716320e+00,  -1.664262820669626e-02,  -3.956184554908752e-04,   1.799536500752166e-06,   3.996497522684656e-07,
   6.905394504843248e-09,  -3.078555830865897e-10,  -1.550825171755277e-11,   1.559453054463103e-14,   1.978013424512032e-14,   4.560536656200655e-16,  -1.393756763373440e-17,
  -9.172121682786820e-19,  -4.892859208740538e-21,   1.692187299129780e+00,  -1.664261207472487e-02,  -3.956114467126409e-04,   1.799737356867743e-06,   3.996362151721246e-07,
   6.904443386676519e-09,  -3.078541922000745e-10,  -1.550616813325104e-11,   1.565436068872565e-14,   1.977788451513707e-14,   4.558767313966133e-16,  -1.393865924947700e-17,
  -9.169347800941128e-19,  -4.883058467862981e-21,   7.884184678439533e-03,  -1.585038243679853e-04,   2.360016117991933e-06,  -2.884794832576472e-08,   5.218429611243508e-10,
  -3.700847978095772e-12,  -1.203962867056866e-13,  -5.949219885615895e-15,   1.138811573576995e-16,   8.848896939159268e-18,   7.884521419219024e-03,  -1.585161593348548e-04,
   2.360460268182948e-06,  -2.885335855121679e-08,   5.215914377357303e-10,  -3.717935778078855e-12,  -1.199360631737687e-13,  -5.905735999265132e-15,   1.142021721350054e-16,
   8.779741790604793e-18,   7.885074279181706e-03,  -1.585364108826620e-04,   2.361189259146177e-06,  -2.886225760250989e-08,   5.211792347386732e-10,  -3.745895441207814e-12,
  -1.191796682913833e-13,  -5.834604108174556e-15,   1.147185018486454e-16,   8.666493213187481e-18,   7.885660968129843e-03,  -1.585579016580783e-04,   2.361962566585270e-06,
  -2.887172363152139e-08,   5.207428256955989e-10,  -3.775437081584534e-12,  -1.183759179023209e-13,  -5.759472230749881e-15,   1.152519550990432e-16,   8.546710746183662e-18,
   7.886122740152790e-03,  -1.585748166918064e-04,   2.362571012969012e-06,  -2.887919038245307e-08,   5.204000724696931e-10,  -3.798595715594611e-12,  -1.177425374145257e-13,
  -5.700592062565979e-15,   1.156614180684434e-16,   8.452719727204475e-18,   7.886389255748021e-03,  -1.585845793629176e-04,   2.362922098956078e-06,  -2.888350636604424e-08,
   5.202025448463430e-10,  -3.811924699326700e-12,  -1.173766748150100e-13,  -5.666710833440638e-15,   1.158935934739545e-16,   8.398587627629539e-18,   7.886489338393157e-03,
  -1.585882454705521e-04,   2.363053923841993e-06,  -2.888512833988075e-08,   5.201284245746862e-10,  -3.816923010187293e-12,  -1.172392285944857e-13,  -5.654006915275713e-15,
   1.159799989684244e-16,   8.378281688430351e-18,   7.886505928702924e-03,  -1.585888531870995e-04,   2.363075775102876e-06,  -2.888539727269933e-08,   5.201161408918298e-10,
  -3.817751190345386e-12,  -1.172164417010204e-13,  -5.651902051416168e-15,   1.159942809012027e-16,   8.374916807890866e-18,   7.146925077551800e-02,  -1.429508281252230e-03,
   2.085677715906203e-05,  -2.422591836593505e-07,   4.294872589391826e-09,  -2.352018538709261e-11,  -1.317980465955486e-12,  -5.269356109390140e-14,   1.018917287647162e-15,
   8.378462708765830e-17,   7.147222619094332e-02,  -1.429611830015517e-03,   2.086042867298164e-05,  -2.422939229481221e-07,   4.292108244197626e-09,  -2.367111064428563e-11,
  -1.313859980885846e-12,  -5.228168537946396e-14,   1.021928519719135e-15,   8.313562798390140e-17,   7.147711119014960e-02,  -1.429781833087642e-03,   2.086642153387122e-05,
  -2.423511056457261e-07,   4.287576512339464e-09,  -2.391800048225976e-11,  -1.307087444188511e-12,  -5.160790810902553e-14,   1.026770815472892e-15,   8.207280298390514e-17,
   7.148229505905712e-02,  -1.429962234487633e-03,   2.087277812756099e-05,  -2.424119877233089e-07,   4.282776683094023e-09,  -2.417877867529803e-11,  -1.299890416547411e-12,
  -5.089621218329228e-14,   1.031772239138987e-15,   8.094862732698670e-17,   7.148637515828629e-02,  -1.430104222218569e-03,   2.087777914034770e-05,  -2.424600515949650e-07,
   4.279005487992783e-09,  -2.438315236589231e-11,  -1.294218590388758e-12,  -5.033844090433207e-14,   1.035610103703756e-15,   8.006648616524142e-17,   7.148873001048794e-02,
  -1.430186170482775e-03,   2.088066465783213e-05,  -2.424878499385896e-07,   4.276831582835723e-09,  -2.450075636599625e-11,  -1.290942211286458e-12,  -5.001747564390669e-14,
   1.037785823731737e-15,   7.955842731977387e-17,   7.148961430871673e-02,  -1.430216943697275e-03,   2.088174807275628e-05,  -2.424982997701798e-07,   4.276015737329656e-09,
  -2.454485289403315e-11,  -1.289711325269943e-12,  -4.989712664061882e-14,   1.038595446453535e-15,   7.936784354242303e-17,   7.148976089527286e-02,  -1.430222044841675e-03,
   2.088192765766420e-05,  -2.425000325738960e-07,   4.275880524454018e-09,  -2.455215910078840e-11,  -1.289507258177814e-12,  -4.987718638535040e-14,   1.038729264193169e-15,
   7.933626197549557e-17,   2.015017192957740e-01,  -3.984456620643834e-03,   5.543739355265828e-05,  -5.632566255301580e-07,   9.474864757599771e-09,  -8.223460870002782e-12,
  -4.972727402493672e-12,  -1.458788737411317e-13,   2.908066104605608e-15,   2.569400701110618e-16,   2.015096245927577e-01,  -3.984697141676573e-03,   5.544542433274346e-05,
  -5.632718211324786e-07,   9.464390078425553e-09,  -8.639330792963063e-12,  -4.960950480056894e-12,  -1.446155187104656e-13,   2.917491170900735e-15,   2.549599437922151e-16,
   2.015226032341100e-01,  -3.985092001387416e-03,   5.545860173869978e-05,  -5.632971866236695e-07,   9.447212463940423e-09,  -9.319354070071523e-12,  -4.941591406346133e-12,
  -1.425487900627020e-13,   2.932650362662049e-15,   2.517170397226662e-16,   2.015363756856934e-01,  -3.985510985616724e-03,   5.547257526682118e-05,  -5.633246699378086e-07,
   9.429010533417208e-09,  -1.003725783838679e-11,  -4.921015967902373e-12,  -1.403656999371421e-13,   2.948311787747188e-15,   2.482867060220109e-16,   2.015472154808807e-01,
  -3.985840733933392e-03,   5.548356619966567e-05,  -5.633467099315539e-07,   9.414703523414679e-09,  -1.059961337826221e-11,  -4.904798779138523e-12,  -1.386547291083323e-13,
   2.960332660468221e-15,   2.455947531874093e-16,   2.015534716606106e-01,  -3.986031040368007e-03,   5.548990675529730e-05,  -5.633595937971041e-07,   9.406453890586563e-09,
  -1.092310432766971e-11,  -4.895429942488280e-12,  -1.376701493017313e-13,   2.967148632270551e-15,   2.440442878023971e-16,   2.015558209791535e-01,  -3.986102502750765e-03,
   5.549228721961828e-05,  -5.633644627975729e-07,   9.403357437142790e-09,  -1.104437917186825e-11,  -4.891910055288131e-12,  -1.373009689049487e-13,   2.969685208258430e-15,
   2.434626624270192e-16,   2.015562104155391e-01,  -3.986114348686032e-03,   5.549268179047427e-05,  -5.633652715373501e-07,   9.402844227724919e-09,  -1.106447170965175e-11,
  -4.891326489222491e-12,  -1.372398003981785e-13,   2.970104476411106e-15,   2.433662808430871e-16,   4.044274692940216e-01,  -7.828804252867971e-03,   9.896745931891774e-05,
  -7.009898759209752e-07,   1.018003798373752e-08,   1.583806467881837e-10,  -1.335029047323889e-11,  -3.183648968296378e-13,   6.722088518682528e-15,   5.843167952800799e-16,
   4.044415702467307e-01,  -7.829102752975700e-03,   9.897599202308329e-05,  -7.007720948969651e-07,   1.015186476333049e-08,   1.574748590744487e-10,  -1.332303224559264e-11,
  -3.154940170962629e-13,   6.745601410398848e-15,   5.797334746842906e-16,   4.044647200955758e-01,  -7.829592723784973e-03,   9.898998255494363e-05,  -7.004154848953158e-07,
   1.010565615956131e-08,   1.559939835406859e-10,  -1.327821998280891e-11,  -3.107978427953257e-13,   6.783459624879474e-15,   5.722266304441855e-16,   4.044892850326677e-01,
  -7.830112531912440e-03,   9.900480411596759e-05,  -7.000383312754193e-07,   1.005668279566538e-08,   1.544309600479262e-10,  -1.323058559928165e-11,  -3.058376891280415e-13,
   6.822627683546788e-15,   5.642850814150771e-16,   4.045086186051319e-01,  -7.830521559485428e-03,   9.901645177745451e-05,  -6.997424024530979e-07,   1.001818219816729e-08,
   1.532068461261877e-10,  -1.319303636918516e-11,  -3.019505379895193e-13,   6.852732068122749e-15,   5.580523603663169e-16,   4.045197767234821e-01,  -7.830757591618056e-03,
   9.902316706598946e-05,  -6.995719732460897e-07,   9.995979477705577e-09,   1.525027835273110e-10,  -1.317134193020861e-11,  -2.997137980774749e-13,   6.869818395151359e-15,
   5.544623080532268e-16,   4.045239667712854e-01,  -7.830846219182083e-03,   9.902568743790007e-05,  -6.995080427758200e-07,   9.987645298532632e-09,   1.522388535602007e-10,
  -1.316319094314854e-11,  -2.988751284342381e-13,   6.876180323355704e-15,   5.531155292277469e-16,   4.045246613350285e-01,  -7.830860910213728e-03,   9.902610515780416e-05,
  -6.994974489379507e-07,   9.986263955948059e-09,   1.521951272489591e-10,  -1.316183956333017e-11,  -2.987361727696212e-13,   6.877232051437056e-15,   5.528923511625013e-16,
   6.921478438796226e-01,  -1.287038049946880e-02,   1.311032865635758e-04,   7.938127890880254e-08,  -4.735214279503305e-09,   5.762242137505556e-10,  -2.629781753629896e-11,
  -7.988039389073075e-13,   1.690999149678967e-14,   1.240898405870956e-15,   6.921664920748213e-01,  -1.287034378460368e-02,   1.310989303960293e-04,   8.018203815856632e-08,
  -4.790535922349993e-09,   5.739338298154006e-10,  -2.622941473105898e-11,  -7.927127224174448e-13,   1.696089316625104e-14,   1.230956396964912e-15,   6.921971056081513e-01,
  -1.287028326857818e-02,   1.310917451600030e-04,   8.149429828375515e-08,  -4.881249295193792e-09,   5.701867784236447e-10,  -2.611698351306099e-11,  -7.827495375837336e-13,
   1.704276953742703e-14,   1.214672045899537e-15,   6.922295882557014e-01,  -1.287021872701911e-02,   1.310840750567639e-04,   8.288356759560363e-08,  -4.977358944946180e-09,
   5.662284712594606e-10,  -2.599750180441441e-11,  -7.722274029085262e-13,   1.712736777570556e-14,   1.197443774175057e-15,   6.922551517781450e-01,  -1.287016769429117e-02,
   1.310780053592368e-04,   8.397466199455404e-08,  -5.052893218426976e-09,   5.631259746762272e-10,  -2.590333826428328e-11,  -7.639822603894622e-13,   1.719230783404386e-14,
   1.183921968982674e-15,   6.922699047891846e-01,  -1.287013814692873e-02,   1.310744890847715e-04,   8.460344670482969e-08,  -5.096443597804613e-09,   5.613405476982925e-10,
  -2.584894288152900e-11,  -7.592381709616827e-13,   1.722913248305579e-14,   1.176133154014375e-15,   6.922754446541191e-01,  -1.287012703358466e-02,   1.310731661697166e-04,
   8.483939036682539e-08,  -5.112789270428796e-09,   5.606710618094536e-10,  -2.582850717048728e-11,  -7.574594268998231e-13,   1.724283740214316e-14,   1.173211198803363e-15,
   6.922763629640533e-01,  -1.287012519043868e-02,   1.310729467447475e-04,   8.487849237728364e-08,  -5.115498381323231e-09,   5.605601355364880e-10,  -2.582511914888686e-11,
  -7.571647174483258e-13,   1.724510270468498e-14,   1.172726992012534e-15,   1.086130516241525e+00,  -1.845692828192574e-02,   8.332982011496475e-05,   3.692788077163530e-06,
  -3.386467902526685e-08,   1.868231752572074e-10,  -1.906955262479139e-11,  -2.344904437957282e-12,   3.060212726848069e-14,   3.643236702761749e-15,   1.086142316090328e+00,
  -1.845535102069521e-02,   8.330068337903116e-05,   3.692997438138445e-06,  -3.390391745727048e-08,   1.801004459274593e-10,  -1.894616417852912e-11,  -2.326982259783064e-12,
   3.067586332257754e-14,   3.615490229454506e-15,   1.086161684420408e+00,  -1.845276163953405e-02,   8.325282696222450e-05,   3.693334341051412e-06,  -3.396814260211826e-08,
   1.691022281139117e-10,  -1.874341277139961e-11,  -2.297662071474869e-12,   3.079288275018249e-14,   3.570041892518252e-15,   1.086182231594417e+00,  -1.845001403698922e-02,
   8.320201539279908e-05,   3.693682604674308e-06,  -3.403603059044558e-08,   1.574841070495179e-10,  -1.852802682285655e-11,  -2.266689456693555e-12,   3.091160965620135e-14,
   3.521957245235580e-15,   1.086198399343543e+00,  -1.844785161025945e-02,   8.316200314896286e-05,   3.693950033751029e-06,  -3.408927054103758e-08,   1.483780225654202e-10,
  -1.835834007297119e-11,  -2.242413863678573e-12,   3.100113931526805e-14,   3.484216141586471e-15,   1.086207728870940e+00,  -1.844660361211871e-02,   8.313890198899089e-05,
   3.694101709647109e-06,  -3.411992086049811e-08,   1.431376990674912e-10,  -1.826034122928416e-11,  -2.228443981074080e-12,   3.105125136852108e-14,   3.462476042346874e-15,
   1.086211231975008e+00,  -1.844613497277614e-02,   8.313022551571072e-05,   3.694158162837957e-06,  -3.413141608627194e-08,   1.411727324003218e-10,  -1.822352877980632e-11,
  -2.223205712028181e-12,   3.106977575235791e-14,   3.454320201855242e-15,   1.086211812652714e+00,  -1.844605728890641e-02,   8.312878717337819e-05,   3.694167494263060e-06,
  -3.413332083136621e-08,   1.408471600915698e-10,  -1.821742591298128e-11,  -2.222337792658614e-12,   3.107283099501047e-14,   3.452968665815916e-15,   1.619910433474645e+00,
  -1.963095291698359e-02,  -3.353107448285053e-04,   8.807956856980278e-06,   4.411202957031038e-07,  -4.854838335261571e-09,  -6.355798104424776e-10,  -2.549015772158657e-12,
   8.390630919110908e-13,   1.645815690667432e-14,   1.619863458607250e+00,  -1.962721721088720e-02,  -3.349415487720901e-04,   8.800995114693779e-06,   4.398017238041882e-07,
  -4.861238836984660e-09,  -6.323545865858371e-10,  -2.471952888134764e-12,   8.333426740302645e-13,   1.618452420560634e-14,   1.619786378548282e+00,  -1.962108660452996e-02,
  -3.343362553881506e-04,   8.789560202817875e-06,   4.376419881199865e-07,  -4.871584485589754e-09,  -6.270761609220938e-10,  -2.346427227203129e-12,   8.239818907834835e-13,
   1.573899044746424e-14,   1.619704640603574e+00,  -1.961458449356318e-02,  -3.336950802568024e-04,   8.777418695961359e-06,   4.353570057982613e-07,  -4.882343250432235e-09,
  -6.214974504075041e-10,  -2.214566884499101e-12,   8.140904231613288e-13,   1.527121415503548e-14,   1.619640348546796e+00,  -1.960946942464077e-02,  -3.331912584671683e-04,
   8.767857412049545e-06,   4.335635270131723e-07,  -4.890652957982917e-09,  -6.171229445750059e-10,  -2.111750828033069e-12,   8.063354973918029e-13,   1.490664626474191e-14,
   1.619603258817343e+00,  -1.960651827100532e-02,  -3.329008078697352e-04,   8.762337084267363e-06,   4.325304016240481e-07,  -4.895385814319680e-09,  -6.146047204154568e-10,
  -2.052796094582691e-12,   8.018718849983844e-13,   1.469767213986720e-14,   1.619589333989481e+00,  -1.960541024465786e-02,  -3.327918002342522e-04,   8.760263709761421e-06,
   4.321428164364795e-07,  -4.897151206752298e-09,  -6.136603082652200e-10,  -2.030730064587302e-12,   8.001980043326096e-13,   1.461946872847234e-14,   1.619587025894164e+00,
  -1.960522658193480e-02,  -3.327737337934983e-04,   8.759919995296248e-06,   4.320785878187918e-07,  -4.897443221940090e-09,  -6.135038220225924e-10,  -2.027076100243742e-12,
   7.999206533504021e-13,   1.460651953333664e-14,   7.285928589386073e-03,  -1.408733389235058e-04,   2.060857854670469e-06,  -2.129306555761113e-08,   4.088034091514032e-10,
  -7.889253242682489e-12,  -1.901415795766619e-13,   2.308360653478529e-15,   3.561658765401382e-16,   1.103217016134859e-18,   7.286222562075503e-03,  -1.408824688467397e-04,
   2.061204708682997e-06,  -2.130423370135814e-08,   4.084136456921129e-10,  -7.882290231152357e-12,  -1.887782884987272e-13,   2.312578815951575e-15,   3.534546792423497e-16,
   1.048941903949690e-18,   7.286705201165560e-03,  -1.408974605261437e-04,   2.061773890237801e-06,  -2.132256083013338e-08,   4.077758597171103e-10,  -7.870851123125675e-12,
  -1.865479253953333e-13,   2.319309613595379e-15,   3.490227114511574e-16,   9.607676670063106e-19,   7.287217366567148e-03,  -1.409133725210171e-04,   2.062377516564955e-06,
  -2.134199755890193e-08,   4.071019315616760e-10,  -7.858702428572658e-12,  -1.841917728659619e-13,   2.326189694174232e-15,   3.443456645200468e-16,   8.684593156666824e-19,
   7.287620478191748e-03,  -1.409258987207759e-04,   2.062852343020546e-06,  -2.135728728868383e-08,   4.065735775189892e-10,  -7.849133613521752e-12,  -1.823450005298513e-13,
   2.331416233478961e-15,   3.406832899111947e-16,   7.967113286208064e-19,   7.287853135724257e-03,  -1.409331291886270e-04,   2.063126282380588e-06,  -2.136610845251648e-08,
   4.062694665184694e-10,  -7.843608222726454e-12,  -1.812822037084919e-13,   2.334357635890580e-15,   3.385770525952698e-16,   7.556623589482944e-19,   7.287940503574038e-03,
  -1.409358445569034e-04,   2.063229131915001e-06,  -2.136942035067988e-08,   4.061554231778821e-10,  -7.841532815669203e-12,  -1.808836812521702e-13,   2.335448054159047e-15,
   3.377875341502716e-16,   7.403155004316226e-19,   7.287954986184586e-03,  -1.409362946815507e-04,   2.063246179779065e-06,  -2.136996931689668e-08,   4.061365269476250e-10,
  -7.841188757450944e-12,  -1.808176504099078e-13,   2.335628063721150e-15,   3.376567336827653e-16,   7.377750901506033e-19,   6.606809984693768e-02,  -1.273163313173394e-03,
   1.833975101027494e-05,  -1.794228925492979e-07,   3.419400558542360e-09,  -6.644272262325127e-11,  -1.903020135305474e-12,   2.361936091196852e-14,   3.316805850793241e-15,
   1.079271624930877e-17,   6.607071555474364e-02,  -1.273240244560408e-03,   1.834264855340283e-05,  -1.795168435250303e-07,   3.415488331615164e-09,  -6.637149707141303e-11,
  -1.890331161176478e-12,   2.366109339435646e-14,   3.291231745480606e-15,   1.027935922006705e-17,   6.607500995710529e-02,  -1.273366568736015e-03,   1.834740297240711e-05,
  -1.796710057498297e-07,   3.409085076574183e-09,  -6.625448729725074e-11,  -1.869572786327634e-12,   2.372776943496110e-14,   3.249426185611119e-15,   9.445415072105310e-18,
   6.607956705029323e-02,  -1.273500647651731e-03,   1.835244456793838e-05,  -1.798344838422175e-07,   3.402316895752016e-09,  -6.613022223614439e-11,  -1.847644976508397e-12,
   2.379604205029655e-14,   3.205309106599906e-15,   8.572432126043063e-18,   6.608315379636981e-02,  -1.273606196836688e-03,   1.835641001066530e-05,  -1.799630695665672e-07,
   3.397009200359851e-09,  -6.603234797569705e-11,  -1.830458721957544e-12,   2.384799410246664e-14,   3.170763284345444e-15,   7.893938020692639e-18,   6.608522389379862e-02,
  -1.273667122705677e-03,   1.835869761710908e-05,  -1.800372498732665e-07,   3.393953585358462e-09,  -6.597583250249815e-11,  -1.820568605533279e-12,   2.387726808416992e-14,
   3.150896000504849e-15,   7.505770955203342e-18,   6.608600125791426e-02,  -1.273690003124066e-03,   1.835955646085333e-05,  -1.800650998280208e-07,   3.392807598561234e-09,
  -6.595460471332529e-11,  -1.816860129155967e-12,   2.388812736210129e-14,   3.143448806333007e-15,   7.360651440779785e-18,   6.608613011830113e-02,  -1.273693795994265e-03,
   1.835969881725823e-05,  -1.800697160671104e-07,   3.392617710082547e-09,  -6.595108560603035e-11,  -1.816245678705576e-12,   2.388992041873206e-14,   3.142215021466366e-15,
   7.336629562209702e-18,   1.864116453583876e-01,  -3.565477000949565e-03,   4.955836856452188e-05,  -4.205493973293918e-07,   7.876397202439858e-09,  -1.576870279605567e-10,
  -6.421744256715206e-12,   8.150884204129160e-14,   9.980385617064160e-15,   3.417290353542865e-17,   1.864187112506603e-01,  -3.565657327793387e-03,   4.956501889055320e-05,
  -4.207717219588951e-07,   7.863140156978866e-09,  -1.574413975263051e-10,  -6.383594083864757e-12,   8.164198168515389e-14,   9.901906339106194e-15,   3.258515300720544e-17,
   1.864303117288955e-01,  -3.565953431616567e-03,   4.957592843796286e-05,  -4.211364503781721e-07,   7.841434576475056e-09,  -1.570378945400583e-10,  -6.321187263116517e-12,
   8.185487986397939e-14,   9.773620522895699e-15,   3.000613889476780e-17,   1.864426216465181e-01,  -3.566267713203978e-03,   4.958749340448900e-05,  -4.215231108402046e-07,
   7.818481925373920e-09,  -1.566093986960206e-10,  -6.255270828586319e-12,   8.207312720208065e-14,   9.638245509588651e-15,   2.730676545520017e-17,   1.864523102775508e-01,
  -3.566515121436986e-03,   4.959658721246784e-05,  -4.218271650674823e-07,   7.800474865067012e-09,  -1.562719233893269e-10,  -6.203612246731965e-12,   8.223939003754538e-14,
   9.532243182405407e-15,   2.520904369078131e-17,   1.864579020409000e-01,  -3.566657932400890e-03,   4.960183227256967e-05,  -4.220025406269206e-07,   7.790105357370990e-09,
  -1.560770625306000e-10,  -6.173886231410696e-12,   8.233315333376747e-14,   9.471282467731134e-15,   2.400904257295944e-17,   1.864600018537022e-01,  -3.566711564408656e-03,
   4.960380124918806e-05,  -4.220683769731639e-07,   7.786215792523906e-09,  -1.560038721565682e-10,  -6.162740265261716e-12,   8.236795006937966e-14,   9.448431740220876e-15,
   2.356043239289949e-17,   1.864603499303710e-01,  -3.566720454949091e-03,   4.960412760383956e-05,  -4.220792892916975e-07,   7.785571267569562e-09,  -1.559917388500116e-10,
  -6.160893528903626e-12,   8.237369641544656e-14,   9.444646046676078e-15,   2.348617426354376e-17,   3.746465252374859e-01,  -7.067827889144857e-03,   9.157432038987621e-05,
  -5.325217005896985e-07,   9.629192401528914e-09,  -2.255637260303995e-10,  -1.621055337078815e-11,   2.035061593751609e-13,   2.286747818406014e-14,   7.428978519070321e-17,
   3.746595730851897e-01,  -7.068056349120081e-03,   9.158235252330356e-05,  -5.328375195240859e-07,   9.595621633063631e-09,  -2.249512442177751e-10,  -1.612318879320507e-11,
   2.037881985155536e-13,   2.268537796504535e-14,   7.055683758700702e-17,   3.746809940355788e-01,  -7.068431499392747e-03,   9.159551817801262e-05,  -5.333553557675161e-07,
   9.540642590722042e-09,  -2.239452097357849e-10,  -1.598028270212993e-11,   2.042378846492241e-13,   2.238772931872754e-14,   6.449452017892487e-17,   3.747037244013249e-01,
  -7.068829693531910e-03,   9.160946028458434e-05,  -5.339039613050049e-07,   9.482485641197263e-09,  -2.228770021183403e-10,  -1.582934890932105e-11,   2.046970552662468e-13,
   2.207366046127194e-14,   5.815088248167911e-17,   3.747216141010333e-01,  -7.069143168962224e-03,   9.162041279602578e-05,  -5.343350947824275e-07,   9.436845848345932e-09,
  -2.220358025836288e-10,  -1.571106889093557e-11,   2.050455085384777e-13,   2.182775637657286e-14,   5.322230714542877e-17,   3.747319389099140e-01,  -7.069324119635671e-03,
   9.162672569904934e-05,  -5.345836609601648e-07,   9.410558243351635e-09,  -2.215501275796645e-10,  -1.564300935303952e-11,   2.052414637421178e-13,   2.168634796355921e-14,
   5.040338049437300e-17,   3.747358160375120e-01,  -7.069392075567961e-03,   9.162909474513834e-05,  -5.346769528875864e-07,   9.400696803833223e-09,  -2.213677140165939e-10,
  -1.561749047043502e-11,   2.053140785802586e-13,   2.163334348883529e-14,   4.934963646779285e-17,   3.747364587300297e-01,  -7.069403340613825e-03,   9.162948736871787e-05,
  -5.346924148726613e-07,   9.399062646675935e-09,  -2.213374743763653e-10,  -1.561326236147098e-11,   2.053260645443656e-13,   2.162456228794789e-14,   4.917521558329346e-17,
   6.427690246626563e-01,  -1.181841025903601e-02,   1.318535344019983e-04,   5.554556418228258e-08,  -8.436898837059860e-10,  -2.215820538868931e-10,  -3.463692811966777e-11,
   3.914041043948124e-13,   5.079842995312600e-14,   1.148215549998093e-16,   6.427877861197657e-01,  -1.181838762237982e-02,   1.318524092456020e-04,   5.524016361097711e-08,
  -9.153319692595382e-10,  -2.204068113533943e-10,  -3.444279759660802e-11,   3.917777715429033e-13,   5.039656362372014e-14,   1.066868152120214e-16,   6.428185859089623e-01,
  -1.181835055255193e-02,   1.318505186287839e-04,   5.474001001859388e-08,  -1.032648907467667e-09,  -2.184767898618224e-10,  -3.412524135296854e-11,   3.923622219849826e-13,
   4.973978995297243e-14,   9.348353361863666e-17,   6.428512666202669e-01,  -1.181831134330297e-02,   1.318484535289683e-04,   5.421095438335764e-08,  -1.156731079978461e-09,
  -2.164280098665466e-10,  -3.378983494349158e-11,   3.929432768569764e-13,   4.904690612926668e-14,   7.967780883994399e-17,   6.428769863322663e-01,  -1.181828057554530e-02,
   1.318467856371136e-04,   5.379577678736424e-08,  -1.254095417893350e-09,  -2.148149996790705e-10,  -3.352698355441944e-11,   3.933725009156903e-13,   4.850449219062210e-14,
   6.895912125662673e-17,   6.428918296084374e-01,  -1.181826285494504e-02,   1.318458059941659e-04,   5.355664755261210e-08,  -1.310170687663059e-09,  -2.138838641769897e-10,
  -3.337573272064948e-11,   3.936090398449992e-13,   4.819260950842953e-14,   6.283148646494831e-17,   6.428974033924546e-01,  -1.181825620749553e-02,   1.318454349051042e-04,
   5.346694247898119e-08,  -1.331205689865145e-09,  -2.135341699871164e-10,  -3.331902065582949e-11,   3.936957595503654e-13,   4.807571239319425e-14,   6.054147715377341e-17,
   6.428983273262084e-01,  -1.181825510594484e-02,   1.318453732218054e-04,   5.345207734462728e-08,  -1.334691392221472e-09,  -2.134762008969781e-10,  -3.330962425395846e-11,
   3.937100238612899e-13,   4.805634651090071e-14,   6.016245336690205e-17,   1.013903779686799e+00,  -1.762222208857514e-02,   1.243821560926787e-04,   3.137168572215169e-06,
  -3.895045441579402e-08,  -8.317016149750912e-10,  -5.259972499134739e-11,   4.746664357417378e-13,   1.254322748506300e-13,   2.586993676963476e-16,   1.013921412082213e+00,
  -1.762088689847265e-02,   1.243482970461459e-04,   3.135997094599503e-06,  -3.905709655740745e-08,  -8.302702904501746e-10,  -5.212242422879685e-11,   4.755249577543476e-13,
   1.243400710968206e-13,   2.409483079161524e-16,   1.013950354936477e+00,  -1.761869532640781e-02,   1.242926479014103e-04,   3.134075401456848e-06,  -3.923144236259433e-08,
  -8.279189808773131e-10,  -5.134195451035694e-11,   4.768715303191546e-13,   1.225555561114571e-13,   2.121928204778887e-16,   1.013981060677920e+00,  -1.761637038614102e-02,
   1.242335130620348e-04,   3.132038344530246e-06,  -3.941545462799651e-08,  -8.254220134839605e-10,  -5.051801121124832e-11,   4.782157202060406e-13,   1.206735795609790e-13,
   1.822008812077703e-16,   1.014005222733664e+00,  -1.761454099839152e-02,   1.241869109785121e-04,   3.130436624435244e-06,  -3.955956420180535e-08,  -8.234554618750337e-10,
  -4.987259064672184e-11,   4.792129283439877e-13,   1.192007722343052e-13,   1.589700142032731e-16,   1.014019165715020e+00,  -1.761348536416602e-02,   1.241599909518342e-04,
   3.129512823623027e-06,  -3.964244910008625e-08,  -8.223199736546834e-10,  -4.950131581852414e-11,   4.797643097492391e-13,   1.183541103768657e-13,   1.457113958014275e-16,
   1.014024401175903e+00,  -1.761308898970102e-02,   1.241498774862079e-04,   3.129166037478538e-06,  -3.967351968794537e-08,  -8.218934842307843e-10,  -4.936212672395389e-11,
   4.799668218485151e-13,   1.180368074904872e-13,   1.407605625967391e-16,   1.014025269014382e+00,  -1.761302328636734e-02,   1.241482007852791e-04,   3.129108558527768e-06,
  -3.967866726136095e-08,  -8.218227821601733e-10,  -4.933906617287620e-11,   4.800001523384366e-13,   1.179842430457421e-13,   1.399413602487987e-16,   1.536844067489010e+00,
  -2.178331988675022e-02,  -1.930823187992479e-04,   1.429458361010573e-05,   2.025586010151935e-07,  -1.770419869711608e-08,  -3.072845125924046e-10,   2.437180814265805e-11,
   5.283214497743812e-13,  -3.406196605521479e-14,   1.536816931018361e+00,  -2.177730402189553e-02,  -1.929129370572102e-04,   1.426997963890893e-05,   2.019261621088390e-07,
  -1.763398991469229e-08,  -3.052931685745787e-10,   2.420639552275167e-11,   5.227775469076951e-13,  -3.372013349157845e-14,   1.536772398965136e+00,  -2.176743546090125e-02,
  -1.926352524308996e-04,   1.422965936911039e-05,   2.008909238064248e-07,  -1.751908228001289e-08,  -3.020396611674313e-10,   2.393608336341462e-11,   5.137392798713111e-13,
  -3.316245646969562e-14,   1.536725169902052e+00,  -2.175697427489449e-02,  -1.923411270004979e-04,   1.418697292422057e-05,   1.997965372571354e-07,  -1.739763259240925e-08,
  -2.986085506349490e-10,   2.365093876365260e-11,   5.042339984644117e-13,  -3.257544490481302e-14,   1.536688016936292e+00,  -2.174874858445315e-02,  -1.921100240357516e-04,
   1.415344816733969e-05,   1.989381941193129e-07,  -1.730239469313390e-08,  -2.959234581028936e-10,   2.342773754558484e-11,   4.968144327135535e-13,  -3.211686645354894e-14,
   1.536666581864124e+00,  -2.174400430801521e-02,  -1.919768001762972e-04,   1.413412826339646e-05,   1.984440046131879e-07,  -1.724756841598252e-08,  -2.943799103754522e-10,
   2.329940662303165e-11,   4.925568285654678e-13,  -3.185356940981808e-14,   1.536658534034061e+00,  -2.174222333854654e-02,  -1.919268016475710e-04,   1.412687871265683e-05,
   1.982586536287882e-07,  -1.722700652515112e-08,  -2.938014374941528e-10,   2.325130813898028e-11,   4.909626463854506e-13,  -3.175495457850474e-14,   1.536657200057103e+00,
  -2.174192814655610e-02,  -1.919185151708918e-04,   1.412567727347618e-05,   1.982279407566190e-07,  -1.722359946382058e-08,  -2.937056076464115e-10,   2.324333992506534e-11,
   4.906986296483461e-13,  -3.173862123606656e-14,   6.753930070029637e-03,  -1.253107503303631e-04,   1.838690397204407e-06,  -1.621810056634711e-08,   2.169559037373111e-10,
  -1.048308411179023e-11,   1.402583799777722e-14,   1.072668431453688e-14,   6.890936641628326e-17,  -1.508183722219762e-17,   6.754192102089028e-03,  -1.253177259309792e-04,
   1.838875831969004e-06,  -1.623275900212549e-08,   2.169888677145485e-10,  -1.045219288358519e-11,   1.428255630815422e-14,   1.065329992806178e-14,   6.803843111056360e-17,
  -1.493591307846565e-17,   6.754622289239952e-03,  -1.253291819715906e-04,   1.839180274446770e-06,  -1.625679190431528e-08,   2.170433701273234e-10,  -1.040163594603177e-11,
   1.470155533078424e-14,   1.053335692631433e-14,   6.661959733722434e-17,  -1.469781453291675e-17,   6.755078777041641e-03,  -1.253413437769551e-04,   1.839503340523525e-06,
  -1.628225022861134e-08,   2.171017249436219e-10,  -1.034820254376756e-11,   1.514283883698066e-14,   1.040680463796320e-14,   6.512888768753051e-17,  -1.444714660115333e-17,
   6.755438054156681e-03,  -1.253509195658932e-04,   1.839757616376867e-06,  -1.630225540209386e-08,   2.171480279648203e-10,  -1.030630276170793e-11,   1.548775030555630e-14,
   1.030772380945005e-14,   6.396631950046545e-17,  -1.425128984078424e-17,   6.755645407548189e-03,  -1.253564476970215e-04,   1.839904372456078e-06,  -1.631378851056006e-08,
   2.171749011338098e-10,  -1.028218258322040e-11,   1.568585539807755e-14,   1.025074861082095e-14,   6.329961443190545e-17,  -1.413882364706180e-17,   6.755723272234352e-03,
  -1.253585238969919e-04,   1.839959482435904e-06,  -1.631811699128143e-08,   2.171850207150967e-10,  -1.027313672804382e-11,   1.576006677507775e-14,   1.022939275829424e-14,
   6.305005774570617e-17,  -1.409669823820132e-17,   6.755736179495837e-03,  -1.253588680743532e-04,   1.839968617789067e-06,  -1.631883437679311e-08,   2.171866996793291e-10,
  -1.027163785490062e-11,   1.577235893967086e-14,   1.022585477009686e-14,   6.300873216416704e-17,  -1.408972097318939e-17,   6.125640844008079e-02,  -1.134242670623320e-03,
   1.646416769583963e-05,  -1.373917094153573e-07,   1.746410586409879e-09,  -9.305914578014821e-11,   5.733825047982283e-14,   1.018697302209768e-13,   6.204478815799121e-16,
  -1.418499157698729e-16,   6.125875441253367e-02,  -1.134301784832719e-03,   1.646565971873820e-05,  -1.375216714509845e-07,   1.746560125732693e-09,  -9.276566579727404e-11,
   5.964325655827694e-14,   1.011797457047486e-13,   6.122914615201577e-16,  -1.404690710772251e-16,   6.126260585972165e-02,  -1.134398869907463e-03,   1.646810921666079e-05,
  -1.377347278255386e-07,   1.746809087276946e-09,  -9.228533764626921e-11,   6.340439680943096e-14,   1.000520330219894e-13,   5.990044962795103e-16,  -1.382160687041913e-16,
   6.126669275181891e-02,  -1.134501938355410e-03,   1.647070846150651e-05,  -1.379603938105953e-07,   1.747077949786478e-09,  -9.177765991933746e-11,   6.736429381268961e-14,
   9.886222202986640e-14,   5.850452352607542e-16,  -1.358442183453936e-16,   6.126990930867843e-02,  -1.134583092593195e-03,   1.647275418183772e-05,  -1.381377027685468e-07,
   1.747292930503335e-09,  -9.137954934691867e-11,   7.045846014786528e-14,   9.793072123754708e-14,   5.741593232122555e-16,  -1.339910624601174e-16,   6.127176570719232e-02,
  -1.134629943842192e-03,   1.647393484781430e-05,  -1.382399146543454e-07,   1.747418351886425e-09,  -9.115036545086517e-11,   7.223526870502412e-14,   9.739508563259645e-14,
   5.679167426853286e-16,  -1.329269565330868e-16,   6.127246281475837e-02,  -1.134647539889963e-03,   1.647437820736982e-05,  -1.382782742237538e-07,   1.747465703790271e-09,
  -9.106441283761280e-11,   7.290080153550007e-14,   9.719431718642568e-14,   5.655801040662104e-16,  -1.325283892070592e-16,   6.127257837092048e-02,  -1.134650456841696e-03,
   1.647445170097151e-05,  -1.382846317109307e-07,   1.747473566480580e-09,  -9.105017066632165e-11,   7.301103480653054e-14,   9.716105633840024e-14,   5.651931684122682e-16,
  -1.324623744400040e-16,   1.729133572593835e-01,  -3.187341706378572e-03,   4.514035120581785e-05,  -3.267282284101449e-07,   3.543855384829508e-09,  -2.509818873305659e-10,
  -2.367936095582170e-13,   3.158298878245030e-13,   1.739421078693359e-15,  -4.339181806893934e-16,   1.729197871431304e-01,  -3.187482427146072e-03,   4.514337470752788e-05,
  -3.270777381102525e-07,   3.543425575419690e-09,  -2.500715261544727e-10,  -2.303651723078414e-13,   3.137205280562692e-13,   1.714909488250601e-15,  -4.296448622465948e-16,
   1.729303431488754e-01,  -3.187713549139343e-03,   4.514833803347226e-05,  -3.276505923047243e-07,   3.542729628234614e-09,  -2.485815040615336e-10,  -2.198806425730030e-13,
   3.102731690763818e-13,   1.674984770601841e-15,  -4.226729488065650e-16,   1.729415443094781e-01,  -3.187958931456802e-03,   4.515360418095129e-05,  -3.282571835566266e-07,
   3.542004238805026e-09,  -2.470065502717031e-10,  -2.088487498020195e-13,   3.066362289497279e-13,   1.633046876479788e-15,  -4.153339132049705e-16,   1.729503599877508e-01,
  -3.188152152785418e-03,   4.515774843389417e-05,  -3.287336700182833e-07,   3.541442767847458e-09,  -2.457714375097143e-10,  -2.002335476533786e-13,   3.037890559394503e-13,
   1.600347266033864e-15,  -4.096003047402619e-16,   1.729554478107342e-01,  -3.188263706303990e-03,   4.516014007080270e-05,  -3.290082979292099e-07,   3.541122491083939e-09,
  -2.450603825102999e-10,  -1.952882599939396e-13,   3.021519344855762e-13,   1.581597511262366e-15,  -4.063081810413073e-16,   1.729573583620425e-01,  -3.188305603638747e-03,
   4.516103813685651e-05,  -3.291113551435234e-07,   3.541002932747881e-09,  -2.447937050180393e-10,  -1.934362896789126e-13,   3.015383176569571e-13,   1.574579733304246e-15,
  -4.050751316275126e-16,   1.729576750644922e-01,  -3.188312549137245e-03,   4.516118700324473e-05,  -3.291284347508134e-07,   3.540983151591003e-09,  -2.447495168405763e-10,
  -1.931295643149255e-13,   3.014366618839812e-13,   1.573417644332193e-15,  -4.048709033354786e-16,   3.478030224802423e-01,  -6.358639913561333e-03,   8.589988704566531e-05,
  -4.323129284364545e-07,   2.094746389404672e-09,  -4.698752827941627e-10,  -1.616095588656421e-12,   7.348269172168503e-13,   3.567634731276807e-15,  -1.008123291111863e-15,
   3.478152502243312e-01,  -6.358826773390276e-03,   8.590165703599288e-05,  -4.329637809215956e-07,   2.091450880580392e-09,  -4.677569982019581e-10,  -1.602981509326991e-12,
   7.299305174509630e-13,   3.513873124248879e-15,  -9.980319562819714e-16,   3.478353242249426e-01,  -6.359133730750212e-03,   8.590456077602889e-05,  -4.340301138855952e-07,
   2.086060424910934e-09,  -4.642898948894761e-10,  -1.581603348256808e-12,   7.219288627078390e-13,   3.426333098065071e-15,  -9.815701688849590e-16,   3.478566245353398e-01,
  -6.359459703225558e-03,   8.590763917653320e-05,  -4.351586637724827e-07,   2.080367323421591e-09,  -4.606251270302610e-10,  -1.559123198840944e-12,   7.134879917323869e-13,
   3.334416019025018e-15,  -9.642445381151546e-16,   3.478733881683496e-01,  -6.359716438309428e-03,   8.591005994977516e-05,  -4.360447347650843e-07,   2.075905975896179e-09,
  -4.577511084133087e-10,  -1.541577840694444e-12,   7.068806598090579e-13,   3.262773662030040e-15,  -9.507110745450490e-16,   3.478830628596085e-01,  -6.359864682432648e-03,
   8.591145624769307e-05,  -4.365552618817195e-07,   2.073338890566073e-09,  -4.560965229056585e-10,  -1.531510566035896e-12,   7.030816871253668e-13,   3.221705097463001e-15,
  -9.429412904813310e-16,   3.478866958157682e-01,  -6.359920364172068e-03,   8.591198042465627e-05,  -4.367468109622107e-07,   2.072376365789128e-09,  -4.554759769640207e-10,
  -1.527741226576482e-12,   7.016578217095114e-13,   3.206335718735764e-15,  -9.400313169764831e-16,   3.478872980309592e-01,  -6.359929594987187e-03,   8.591206730675183e-05,
  -4.367785545842164e-07,   2.072216889471959e-09,  -4.553731530422070e-10,  -1.527116985258949e-12,   7.014219372110035e-13,   3.203790777092090e-15,  -9.395493506034229e-16,
   5.976081620210760e-01,  -1.076174402042782e-02,   1.321643963506704e-04,  -3.168348370370392e-08,  -1.180554464479935e-08,  -7.532263937750479e-10,  -4.150526140934366e-12,
   1.548757557815247e-12,   6.833003521789972e-15,  -2.229957631747002e-15,   5.976269496167733e-01,  -1.076176119399094e-02,   1.321542678814751e-04,  -3.271790670499635e-08,
  -1.181410819273293e-08,  -7.487696468238224e-10,  -4.125347462740792e-12,   1.537940948913351e-12,   6.732932078577099e-15,  -2.207093784515780e-15,   5.976577914471997e-01,
  -1.076178969767456e-02,   1.321376351672049e-04,  -3.441156621477668e-08,  -1.182812886835189e-08,  -7.414761487085223e-10,  -4.084292484758181e-12,   1.520266539846484e-12,
   6.570100777986615e-15,  -2.169805692317319e-15,   5.976905155878250e-01,  -1.076182036353987e-02,   1.321199795265412e-04,  -3.620254870553289e-08,  -1.184295478166617e-08,
  -7.337683094357492e-10,  -4.041108137069820e-12,   1.501624672487015e-12,   6.399283531692272e-15,  -2.130573353137172e-15,   5.977162686264138e-01,  -1.076184480215415e-02,
   1.321060793531995e-04,  -3.760763944766789e-08,  -1.185458603120289e-08,  -7.277246597402865e-10,  -4.007393868977572e-12,   1.487034164748620e-12,   6.266256945434074e-15,
  -2.099937017260251e-15,   5.977311307948079e-01,  -1.076185902799037e-02,   1.320980552536506e-04,  -3.841677556000565e-08,  -1.186128395189420e-08,  -7.242457296806285e-10,
  -3.988045177857397e-12,   1.478645935710045e-12,   6.190045246608321e-15,  -2.082351779533283e-15,   5.977367116086145e-01,  -1.076186439293846e-02,   1.320950417397080e-04,
  -3.872028020314545e-08,  -1.186379631613798e-08,  -7.229410509012805e-10,  -3.980799986122876e-12,   1.475502150682805e-12,   6.161532512922840e-15,  -2.075766356098057e-15,
   5.977376367042592e-01,  -1.076186528346847e-02,   1.320945421863480e-04,  -3.877057283087392e-08,  -1.186421263043101e-08,  -7.227248710156184e-10,  -3.979600068220564e-12,
   1.474981343612264e-12,   6.156811675176731e-15,  -2.074675676466672e-15,   9.456263110351085e-01,  -1.648883068102709e-02,   1.575490381321556e-04,   2.324580962200777e-06,
  -6.493916058890356e-08,  -1.523851375908915e-09,   8.113309227557431e-12,   3.237698522480667e-12,   1.056732840538822e-14,  -5.577277744036976e-15,   9.456486201216167e-01,
  -1.648784563781133e-02,   1.574936911939156e-04,   2.322490110949956e-06,  -6.492137812791895e-08,  -1.514602759547597e-09,   8.152670571018266e-12,   3.210767859566408e-12,
   1.043297565572639e-14,  -5.515442343626442e-15,   9.456852384222909e-01,  -1.648622915709054e-02,   1.574028413543081e-04,   2.319066977036644e-06,  -6.489212604491336e-08,
  -1.499476774773813e-09,   8.216914118124822e-12,   3.166780412531809e-12,   1.021459451848175e-14,  -5.414643481619405e-15,   9.457240855569737e-01,  -1.648451479691086e-02,
   1.573064577808466e-04,   2.315447425227926e-06,  -6.486100704478171e-08,  -1.483504300187662e-09,   8.284575911584864e-12,   3.120408792576696e-12,   9.985813143674904e-15,
  -5.308652232658219e-15,   9.457546528725885e-01,  -1.648316620124403e-02,   1.572306143703230e-04,   2.312607958757611e-06,  -6.483645834479305e-08,  -1.470989688466337e-09,
   8.337462669882366e-12,   3.084131961674193e-12,   9.807868004508209e-15,  -5.225929788705175e-15,   9.457722916301772e-01,  -1.648238814636350e-02,   1.571868480566701e-04,
   2.310972902682329e-06,  -6.482226768646047e-08,  -1.463789565626966e-09,   8.367839829877080e-12,   3.063282864766999e-12,   9.706010404405084e-15,  -5.178465345960280e-15,
   9.457789147360687e-01,  -1.648209602547813e-02,   1.571704142032359e-04,   2.310359612836110e-06,  -6.481693459192861e-08,  -1.461090055692298e-09,   8.379219484252282e-12,
   3.055470216829636e-12,   9.667919478711729e-15,  -5.160694011247112e-15,   9.457800125883582e-01,  -1.648204760470982e-02,   1.571676901007339e-04,   2.310257987640950e-06,
  -6.481605032532775e-08,  -1.460642795066218e-09,   8.381104388643832e-12,   3.054176022475746e-12,   9.661613658567124e-15,  -5.157750898684845e-15,   1.447748388847715e+00,
  -2.261502030714736e-02,  -1.440275145959755e-05,   1.455242784649895e-05,  -1.654934570454029e-07,  -1.625248948158586e-08,   4.038462895740202e-10,   1.928086840071147e-11,
  -7.715931370059925e-13,  -2.216788019247717e-14,   1.447746064543240e+00,  -2.260888751187136e-02,  -1.453938427608191e-05,   1.452976966044496e-05,  -1.646657396732657e-07,
  -1.619660095303159e-08,   4.009360875874253e-10,   1.917193812981745e-11,  -7.635948709122531e-13,  -2.199402761668782e-14,   1.447742235506283e+00,  -2.259882641793184e-02,
  -1.476318913289713e-05,   1.449262934962054e-05,  -1.633113112263194e-07,  -1.610508318136543e-08,   3.961810640942575e-10,   1.899374615072611e-11,  -7.505501601928054e-13,
  -2.170982143718119e-14,   1.447738154532082e+00,  -2.258816016351587e-02,  -1.499998526339355e-05,   1.445329763315534e-05,  -1.618801240502672e-07,  -1.600829071288101e-08,
   3.911661226945384e-10,   1.880553086080786e-11,  -7.368245661227216e-13,  -2.140988541580545e-14,   1.447734929721250e+00,  -2.257977252307919e-02,  -1.518585522487162e-05,
   1.442239903149936e-05,  -1.607580771566227e-07,  -1.593234198752840e-08,   3.872413204516273e-10,   1.865802532520786e-11,  -7.261058063923065e-13,  -2.117501064870873e-14,
   1.447733063390433e+00,  -2.257493455822190e-02,  -1.529292843750944e-05,   1.440458912457576e-05,  -1.601122427675899e-07,  -1.588860147673022e-08,   3.849850180326308e-10,
   1.857314525334388e-11,  -7.199530413133755e-13,  -2.103993049555650e-14,   1.447732361577040e+00,  -2.257311836556979e-02,  -1.533309849644207e-05,   1.439790553466957e-05,
  -1.598700502120856e-07,  -1.587219365403931e-08,   3.841394090593239e-10,   1.854131879118462e-11,  -7.176488792919200e-13,  -2.098929540666727e-14,   1.447732245189343e+00,
  -2.257281733260535e-02,  -1.533975530801604e-05,   1.439679785582941e-05,  -1.598299204436815e-07,  -1.586947472802291e-08,   3.839993244791192e-10,   1.853604556919941e-11,
  -7.172672613309888e-13,  -2.098090660056417e-14,   6.280936605541284e-03,  -1.113359968071068e-04,   1.658317028340131e-06,  -1.430567791754289e-08,   3.414299586446897e-11,
  -6.791146570287637e-12,   2.657940873346248e-13,   4.859333104139764e-15,  -3.695227109902783e-16,  -4.480368713916832e-18,   6.281172661174509e-03,  -1.113421379145403e-04,
   1.658349293484121e-06,  -1.431522295122757e-08,   3.469376249855596e-11,  -6.776982006229048e-12,   2.643886291811254e-13,   4.836905691196970e-15,  -3.662686736927368e-16,
  -4.460842936268878e-18,   6.281560188524837e-03,  -1.113522224541514e-04,   1.658402596617857e-06,  -1.433087824818755e-08,   3.559580194489222e-11,  -6.753776680831852e-12,
   2.620905440860203e-13,   4.800160223924687e-15,  -3.609562661684905e-16,  -4.428726237794582e-18,   6.281971390212816e-03,  -1.113629268933911e-04,   1.658459609511637e-06,
  -1.434747015639684e-08,   3.655004409799352e-11,  -6.729219320963465e-12,   2.596645582263525e-13,   4.761269445698118e-15,  -3.553594509979064e-16,  -4.394566210241751e-18,
   6.282295011894545e-03,  -1.113713542109953e-04,   1.658504807220963e-06,  -1.436051392595138e-08,   3.729895023195525e-11,  -6.709939748979627e-12,   2.577642799009185e-13,
   4.730733967408707e-15,  -3.509835775611741e-16,  -4.367624860930280e-18,   6.282481781820212e-03,  -1.113762189296661e-04,   1.658531023104507e-06,  -1.436803607560063e-08,
   3.773032382423621e-11,  -6.698832028383607e-12,   2.566711820226305e-13,   4.713140142498105e-15,  -3.484696889840400e-16,  -4.352054176160183e-18,   6.282551916073301e-03,
  -1.113780458969802e-04,   1.658540892244103e-06,  -1.437085964770977e-08,   3.789215134962809e-11,  -6.694664537981636e-12,   2.562613900215720e-13,   4.706538932489251e-15,
  -3.475278689827598e-16,  -4.346203088311925e-18,   6.282563541844885e-03,  -1.113783487544135e-04,   1.658542529503810e-06,  -1.437132763878188e-08,   3.791896827267673e-11,
  -6.693973905017692e-12,   2.561934968186466e-13,   4.705444974833346e-15,  -3.473718631753258e-16,  -4.345232970123576e-18,   5.697291323174040e-02,  -1.008785304990470e-03,
   1.492455971750693e-05,  -1.233144802383011e-07,   1.215728518993645e-10,  -5.989150772400056e-11,   2.441224457917140e-12,   4.592892859661253e-14,  -3.489504166218313e-15,
  -4.127265383646404e-17,   5.697503737289635e-02,  -1.008838247562156e-03,   1.492469208111642e-05,  -1.233985821985082e-07,   1.266271502418524e-10,  -5.975754495120023e-11,
   2.427951984867075e-12,   4.572221592605504e-14,  -3.458791235569514e-15,  -4.109714868570490e-17,   5.697852451263281e-02,  -1.008925187053386e-03,   1.492491244728810e-05,
  -1.235365127572111e-07,   1.349044545870949e-10,  -5.953806677787555e-11,   2.406249917709792e-12,   4.538351870856851e-14,  -3.408651640486485e-15,  -4.080832692629503e-17,
   5.698222466239845e-02,  -1.009017471467710e-03,   1.492515043838656e-05,  -1.236826825827700e-07,   1.436600087454857e-10,  -5.930578530883371e-11,   2.383339940109123e-12,
   4.502502641294962e-14,  -3.355829199536330e-15,  -4.050093598378279e-17,   5.698513671793441e-02,  -1.009090125033820e-03,   1.492534074937660e-05,  -1.237975851393837e-07,
   1.505309626691794e-10,  -5.912341370444898e-11,   2.365394465708519e-12,   4.474353766778998e-14,  -3.314530988681348e-15,  -4.025836462011149e-17,   5.698681732947683e-02,
  -1.009132064941982e-03,   1.492545178670603e-05,  -1.238638440563702e-07,   1.544884411275531e-10,  -5.901833770590899e-11,   2.355071660646870e-12,   4.458134451455280e-14,
  -3.290806064165935e-15,  -4.011811647070534e-17,   5.698744841721699e-02,  -1.009147815705588e-03,   1.492549370990611e-05,  -1.238887148161288e-07,   1.559730258076710e-10,
  -5.897891352901694e-11,   2.351201734875749e-12,   4.452048846033162e-14,  -3.281917679162144e-15,  -4.006540435571221e-17,   5.698755302911684e-02,  -1.009150426720908e-03,
   1.492550067127741e-05,  -1.238928369667352e-07,   1.562190385324686e-10,  -5.897238014270876e-11,   2.350560576071601e-12,   4.451040328878440e-14,  -3.280445385361706e-15,
  -4.005666407832637e-17,   1.608622780442381e-01,  -2.841306682670118e-03,   4.140125570453320e-05,  -3.075582795926078e-07,  -8.450274578141009e-10,  -1.585406193499423e-10,
   7.109218366957464e-12,   1.406553445793945e-13,  -1.073031743508084e-14,  -1.202232044969857e-16,   1.608681684644612e-01,  -2.841438770252601e-03,   4.140061719490618e-05,
  -3.077804354747272e-07,  -8.303340789395045e-10,  -1.581298884405601e-10,   7.068406923757355e-12,   1.400522710248086e-13,  -1.063578240403250e-14,  -1.197478969523235e-16,
   1.608778384903602e-01,  -2.841655681148482e-03,   4.139957789416347e-05,  -3.081447218410533e-07,  -8.062744604965597e-10,  -1.574569013773653e-10,   7.001675608739090e-12,
   1.390640106906393e-13,  -1.048145833805807e-14,  -1.189645840013755e-16,   1.608880990647786e-01,  -2.841885932385919e-03,   4.139848721301530e-05,  -3.085306898236685e-07,
  -7.808293059715209e-10,  -1.567445668825905e-10,   6.931230417811516e-12,   1.380178184168392e-13,  -1.031888575201883e-14,  -1.181294116575422e-16,   1.608961741401474e-01,
  -2.842067207884842e-03,   4.139763758387624e-05,  -3.088340379708432e-07,  -7.608644505937707e-10,  -1.561852261834225e-10,   6.876050640840471e-12,   1.371962222136140e-13,
  -1.019178797491472e-14,  -1.174692852395017e-16,   1.609008344038806e-01,  -2.842171852184703e-03,   4.139715074548616e-05,  -3.090089416833717e-07,  -7.493665823256057e-10,
  -1.558629283718974e-10,   6.844309569504805e-12,   1.367227709623194e-13,  -1.011877565434674e-14,  -1.170871962170873e-16,   1.609025843754570e-01,  -2.842211152197649e-03,
   4.139696859358610e-05,  -3.090745887089920e-07,  -7.450535932940737e-10,  -1.557419984119081e-10,   6.832410145903804e-12,   1.365451192953390e-13,  -1.009142256356311e-14,
  -1.169435094151575e-16,   1.609028744580945e-01,  -2.842217667003039e-03,   4.139693843414391e-05,  -3.090854690052584e-07,  -7.443388948040639e-10,  -1.557219576067559e-10,
   6.830438682489544e-12,   1.365156780611319e-13,  -1.008689175658831e-14,  -1.169196803305066e-16,   3.237098924578012e-01,  -5.692315795555620e-03,   8.061501582296958e-05,
  -4.692865150285815e-07,  -6.098951752725467e-09,  -2.818641872359384e-10,   1.530536320935475e-11,   3.179902657318395e-13,  -2.490232332234869e-14,  -2.528632739955804e-16,
   3.237213544559518e-01,  -5.692517532188527e-03,   8.060998648944882e-05,  -4.696797950366236e-07,  -6.067398983905226e-09,  -2.809341966968901e-10,   1.521068460830075e-11,
   3.167165974419445e-13,  -2.468124094885569e-14,  -2.520631221047288e-16,   3.237401706924554e-01,  -5.692848835060575e-03,   8.060174914486044e-05,  -4.703244797069341e-07,
  -6.015743685890019e-09,  -2.794102033877169e-10,   1.505587928363908e-11,   3.146287114973541e-13,  -2.432035745601314e-14,  -2.507383354394308e-16,   3.237601355108635e-01,
  -5.693200535322174e-03,   8.059303462410867e-05,  -4.710072529418604e-07,  -5.961128172688888e-09,  -2.777968443899758e-10,   1.489246498422479e-11,   3.124174654998460e-13,
  -2.394021643080239e-14,  -2.493176479626604e-16,   3.237758474487965e-01,  -5.693477442668640e-03,   8.058619499333244e-05,  -4.715436684282443e-07,  -5.918286073428026e-09,
  -2.765298097462946e-10,   1.476446717267102e-11,   3.106802337541624e-13,  -2.364304829370949e-14,  -2.481889003481184e-16,   3.237849149236462e-01,  -5.693637298329091e-03,
   8.058225520945945e-05,  -4.718528716456120e-07,  -5.893617284340004e-09,  -2.757996555501434e-10,   1.469084086812861e-11,   3.096788635788920e-13,  -2.347234677884951e-14,
  -2.475332678296432e-16,   3.237883198144032e-01,  -5.693697334600863e-03,   8.058077719770786e-05,  -4.719689101410128e-07,  -5.884364519769028e-09,  -2.755256787015894e-10,
   1.466323942942986e-11,   3.093030704037399e-13,  -2.340839744737462e-14,  -2.472862829216321e-16,   3.237888842218733e-01,  -5.693707286940686e-03,   8.058053227078309e-05,
  -4.719881414704749e-07,  -5.882831300991003e-09,  -2.754802738401617e-10,   1.465866651866763e-11,   3.092407895228410e-13,  -2.339780487445368e-14,  -2.472453002271242e-16,
   5.566674088038981e-01,  -9.710269116725777e-03,   1.301754953177487e-04,  -3.322532915806322e-07,  -2.453565339896248e-08,  -3.798020585714173e-10,   3.084864253280768e-11,
   6.193028970106541e-13,  -5.376242714210635e-14,  -4.462521381602959e-16,   5.566858923305679e-01,  -9.710412815445447e-03,   1.301549039402640e-04,  -3.327784920696105e-07,
  -2.447221431582080e-08,  -3.779876662202530e-10,   3.064449432058963e-11,   6.170258544408919e-13,  -5.327259241329912e-14,  -4.459544982532512e-16,   5.567162339706595e-01,
  -9.710648878655343e-03,   1.301211382529189e-04,  -3.336388425951861e-07,  -2.436837845626583e-08,  -3.750139589552626e-10,   3.031073619663268e-11,   6.132891616244234e-13,
  -5.247307866382008e-14,  -4.454206644491702e-16,   5.567484259978348e-01,  -9.710899575080414e-03,   1.300853623232953e-04,  -3.345492279963788e-07,  -2.425862028787105e-08,
  -3.718652987798221e-10,   2.995846707599339e-11,   6.093262886843879e-13,  -5.163099210197760e-14,  -4.447935476888738e-16,   5.567737592681663e-01,  -9.711097029991185e-03,
   1.300572441014810e-04,  -3.352638887808828e-07,  -2.417254300630672e-08,  -3.693921165717071e-10,   2.968258064618162e-11,   6.062090377019902e-13,  -5.097277230098766e-14,
  -4.442566676534491e-16,   5.567883787829702e-01,  -9.711211047336528e-03,   1.300410315804873e-04,  -3.356756057411743e-07,  -2.412298727420452e-08,  -3.679667302840264e-10,
   2.952390097818846e-11,   6.044106553132728e-13,  -5.059469906212455e-14,  -4.439296473213872e-16,   5.567938684029512e-01,  -9.711253873740892e-03,   1.300349464599826e-04,
  -3.358300720859427e-07,  -2.410440146744951e-08,  -3.674318493289355e-10,   2.946441699035761e-11,   6.037354692426807e-13,  -5.045306771625293e-14,  -4.438036244727334e-16,
   5.567947783779597e-01,  -9.711260973450446e-03,   1.300339379140277e-04,  -3.358556698436147e-07,  -2.410132180923575e-08,  -3.673432044488567e-10,   2.945456203327113e-11,
   6.036235541141951e-13,  -5.042960814883231e-14,  -4.437825648901061e-16,   8.823407177284757e-01,  -1.513662168545366e-02,   1.783192171110788e-04,   1.081534466773302e-06,
  -8.668060900820566e-08,  -3.770857781247152e-10,   7.615292339298202e-11,   8.747227549823810e-13,  -1.258392039317685e-13,  -4.229794131073253e-16,   8.823659468251270e-01,
  -1.513616176939862e-02,   1.782460917662403e-04,   1.081019553385728e-06,  -8.652367631138905e-08,  -3.745104509180672e-10,   7.567648292126814e-11,   8.723262264120999e-13,
  -1.246244231158038e-13,  -4.317722957538964e-16,   8.824073570906075e-01,  -1.513540689655724e-02,   1.781261397556480e-04,   1.080176872213082e-06,  -8.626676780892397e-08,
  -3.702879549391262e-10,   7.489776046485104e-11,   8.683613045480224e-13,  -1.226418395960814e-13,  -4.459507032508201e-16,   8.824512865582560e-01,  -1.513460612670804e-02,
   1.779989903807990e-04,   1.079286297052454e-06,  -8.599514631941681e-08,  -3.658148260785835e-10,   7.407612152001718e-11,   8.641130896559696e-13,  -1.205539530404899e-13,
  -4.606499004413822e-16,   8.824858520260677e-01,  -1.513397606729851e-02,   1.778990163518611e-04,   1.078587995471399e-06,  -8.578208484785856e-08,  -3.622997378521941e-10,
   7.343283678781031e-11,   8.607403399002370e-13,  -1.189221431296699e-13,  -4.719710159114521e-16,   8.825057975269590e-01,  -1.513361250797481e-02,   1.778413566813722e-04,
   1.078186027669976e-06,  -8.565940519829591e-08,  -3.602732401189583e-10,   7.306292254196640e-11,   8.587822110856401e-13,  -1.179849298380678e-13,  -4.784064318884247e-16,
   8.825132867116772e-01,  -1.513347599921394e-02,   1.778197119438658e-04,   1.078035280425204e-06,  -8.561339103876327e-08,  -3.595126734088594e-10,   7.292426839698141e-11,
   8.580447277345371e-13,  -1.176338518502269e-13,  -4.808045340398901e-16,   8.825145281222736e-01,  -1.513345337153291e-02,   1.778161243901314e-04,   1.078010302231320e-06,
  -8.560576634122250e-08,  -3.593866198935150e-10,   7.290129778596133e-11,   8.579223643362064e-13,  -1.175757006897958e-13,  -4.812010824573783e-16,   1.358072882183242e+00,
  -2.209733609751350e-02,   1.356859996353554e-04,   9.958476417936945e-06,  -3.660269813281867e-07,  -3.222492497258273e-09,   5.546579855837007e-10,  -7.612774159143792e-12,
  -6.253932430564081e-13,   2.368338509688889e-14,   1.358091576054799e+00,  -2.209310145894149e-02,   1.353800002689562e-04,   9.953715206115803e-06,  -3.648718203709887e-07,
  -3.243453776461871e-09,   5.522248805737745e-10,  -7.499777372507364e-12,  -6.225614424966171e-13,   2.336969911730437e-14,   1.358122234636111e+00,  -2.208615112352751e-02,
   1.348783565532924e-04,   9.945878081403004e-06,  -3.629791592092846e-07,  -3.277626390503541e-09,   5.482387228633198e-10,  -7.315410487102571e-12,  -6.179085869863145e-13,
   2.285817215537336e-14,   1.358154724435705e+00,  -2.207877833480774e-02,   1.343470290314862e-04,   9.937534115263402e-06,  -3.609759516906012e-07,  -3.313563062961907e-09,
   5.440202214499653e-10,  -7.121319494410260e-12,  -6.129663583310250e-13,   2.232005497684711e-14,   1.358180264188271e+00,  -2.207297740132148e-02,   1.339295621154423e-04,
   9.930947076618540e-06,  -3.594030693678840e-07,  -3.341612509003268e-09,   5.407082940191492e-10,  -6.969675953307024e-12,  -6.090732299460266e-13,   2.189990529554676e-14,
   1.358194991707115e+00,  -2.206963016727966e-02,   1.336889103141851e-04,   9.927137467071544e-06,  -3.584967905397152e-07,  -3.357707373992915e-09,   5.388001462414062e-10,
  -6.882601507092724e-12,  -6.068250606506444e-13,   2.165876646358814e-14,   1.358200519775264e+00,  -2.206837336076179e-02,   1.335985953965685e-04,   9.925705393705045e-06,
  -3.581567500073452e-07,  -3.363733614779537e-09,   5.380842284911071e-10,  -6.849987520349575e-12,  -6.059805993061402e-13,   2.156846861709888e-14,   1.358201436012405e+00,
  -2.206816503306340e-02,   1.335836271604883e-04,   9.925467926582961e-06,  -3.581003979863324e-07,  -3.364731626064795e-09,   5.379655870981132e-10,  -6.844585676319036e-12,
  -6.058406046647671e-13,   2.155351374400855e-14,   5.861040958466603e-03,  -9.875478713415911e-05,   1.486634448274157e-06,  -1.447763161113381e-08,  -3.387794102033879e-11,
  -1.209731194567506e-13,   2.401888616879686e-13,  -5.730010116726163e-15,  -1.991214667483121e-16,   1.069933030591026e-17,   5.861252465076589e-03,  -9.876096907268242e-05,
   1.486608369588638e-06,  -1.447794066410969e-08,  -3.337449846575910e-11,  -1.372753988357337e-13,   2.394072796187216e-13,  -5.678219962115951e-15,  -1.985557736711406e-16,
   1.058575978156948e-17,   5.861599685189890e-03,  -9.877111785260076e-05,   1.486565864963549e-06,  -1.447846445402045e-08,  -3.254921551487544e-11,  -1.639283095567714e-13,
   2.381258443662941e-13,  -5.593610856166736e-15,  -1.976220063695520e-16,   1.040033978068734e-17,   5.861968109570764e-03,  -9.878188666826961e-05,   1.486521182137221e-06,
  -1.447904250363927e-08,  -3.167515528929406e-11,  -1.920602015689714e-13,   2.367684039064998e-13,  -5.504393046939618e-15,  -1.966243787533826e-16,   1.020498184188360e-17,
   5.862258059339408e-03,  -9.879036191218428e-05,   1.486486318748318e-06,  -1.447951350663628e-08,  -3.098844345252284e-11,  -2.140927148063406e-13,   2.357017344584019e-13,
  -5.434581275165282e-15,  -1.958343670351571e-16,   1.005223425524710e-17,   5.862425394161213e-03,  -9.879525319373631e-05,   1.486466319449640e-06,  -1.447979175960729e-08,
  -3.059260051615705e-11,  -2.267651686245503e-13,   2.350867993534353e-13,  -5.394452594829688e-15,  -1.953765052867825e-16,   9.964480194303220e-18,   5.862488229888834e-03,
  -9.879708992861430e-05,   1.486458832380464e-06,  -1.447989745944625e-08,  -3.044404670595443e-11,  -2.315156996333739e-13,   2.348560102166178e-13,  -5.379414255127561e-15,
  -1.952042114835491e-16,   9.931603032359089e-18,   5.862498645801574e-03,  -9.879739439424137e-05,   1.486457592497580e-06,  -1.447991504465753e-08,  -3.041942648745954e-11,
  -2.323027411204040e-13,   2.348177602194812e-13,  -5.376923036150853e-15,  -1.951756322801143e-16,   9.926157143872529e-18,   5.316714730736179e-02,  -8.953439781416803e-04,
   1.342787751037778e-05,  -1.275624379144083e-07,  -4.522540096701907e-10,   1.491979509613764e-12,   2.205452161395360e-12,  -5.359379360202958e-14,  -1.857255674933458e-15,
   1.010072144682854e-16,   5.316905746945953e-02,  -8.953984346271726e-04,   1.342751749627740e-05,  -1.275615944846670e-07,  -4.476327121947699e-10,   1.339573840292028e-12,
   2.198158596035046e-12,  -5.310483088639271e-14,  -1.852153312028744e-15,   9.993645092139030e-17,   5.317219327692113e-02,  -8.954878337998479e-04,   1.342692929943806e-05,
  -1.275603634210456e-07,  -4.400572996680893e-10,   1.090413066330034e-12,   2.186200009997773e-12,  -5.230601167505292e-14,  -1.843726590467751e-15,   9.818826010757040e-17,
   5.317552056663707e-02,  -8.955826933092623e-04,   1.342630901220042e-05,  -1.275592652967375e-07,  -4.320344038121488e-10,   8.274401255035263e-13,   2.173531464282113e-12,
  -5.146367323446750e-14,  -1.834717604566522e-15,   9.634634848437755e-17,   5.317813912913349e-02,  -8.956573483176527e-04,   1.342582361662797e-05,  -1.275585513075137e-07,
  -4.257313393773342e-10,   6.214933780258520e-13,   2.163576109813514e-12,  -5.080454925378518e-14,  -1.827579232359739e-15,   9.490616753058473e-17,   5.317965033997001e-02,
  -8.957004332197668e-04,   1.342554459623364e-05,  -1.275581993260250e-07,  -4.220981223421018e-10,   5.030429080794523e-13,   2.157836655201078e-12,  -5.042567448156546e-14,
  -1.823440418139573e-15,   9.407877163786554e-17,   5.318021781225482e-02,  -8.957166120366930e-04,   1.342544003115375e-05,  -1.275580784907955e-07,  -4.207346453530482e-10,
   4.586400690746755e-13,   2.155682564584565e-12,  -5.028368966985840e-14,  -1.821882664684259e-15,   9.376878556919541e-17,   5.318031187878159e-02,  -8.957192939076061e-04,
   1.342542270906289e-05,  -1.275580590582917e-07,  -4.205086734147594e-10,   4.512836947486979e-13,   2.155325552987948e-12,  -5.026016875115631e-14,  -1.821624256132547e-15,
   9.371743832441783e-17,   1.501355353111068e-01,  -2.525266271634843e-03,   3.755677673949611e-05,  -3.365435958516753e-07,  -2.192849058410413e-09,   2.068672482888988e-11,
   6.400711945244170e-12,  -1.621663642760196e-13,  -5.551445308080617e-15,   3.106792034497844e-16,   1.501408763048964e-01,  -2.525409859929294e-03,   3.755498020497742e-05,
  -3.365180258331296e-07,  -2.179444857098282e-09,   2.022596103440147e-11,   6.378886933148554e-12,  -1.606621778968451e-13,  -5.537375913756274e-15,   3.073944804094698e-16,
   1.501496442381660e-01,  -2.525645576364589e-03,   3.755203909297235e-05,  -3.364765126003545e-07,  -2.157473204206730e-09,   1.947273540521426e-11,   6.343099139645421e-12,
  -1.582047535934492e-13,  -5.514107541037158e-15,   3.020315001741710e-16,   1.501589474591634e-01,  -2.525895680299235e-03,   3.754892946566912e-05,  -3.364330928199949e-07,
  -2.134205093391427e-09,   1.867782997761499e-11,   6.305182182434034e-12,  -1.556134062632176e-13,  -5.489188152513976e-15,   2.963808079907765e-16,   1.501662689740152e-01,
  -2.526092506648358e-03,   3.754649021487037e-05,  -3.363993752273088e-07,  -2.115925890969893e-09,   1.805535582632598e-11,   6.275382562859961e-12,  -1.535856633365008e-13,
  -5.469412239042573e-15,   2.919624176907529e-16,   1.501704942957932e-01,  -2.526206096292360e-03,   3.754508569635010e-05,  -3.363800976762258e-07,  -2.105389793701423e-09,
   1.769736111538070e-11,   6.258201211067959e-12,  -1.524200723522662e-13,  -5.457934060681198e-15,   2.894239587574630e-16,   1.501720809333718e-01,  -2.526248749826918e-03,
   3.754455889410050e-05,  -3.363728930211821e-07,  -2.101435875945731e-09,   1.756316586579831e-11,   6.251752586414804e-12,  -1.519832601599761e-13,  -5.453611668700317e-15,
   2.884729076545679e-16,   1.501723439405881e-01,  -2.526255820234153e-03,   3.754447160117558e-05,  -3.363717005523763e-07,  -2.100780588894897e-09,   1.754093348632847e-11,
   6.250683800614418e-12,  -1.519108986039138e-13,  -5.452894527669542e-15,   2.883153714503403e-16,   3.021920706409471e-01,  -5.071870730356642e-03,   7.428102945029207e-05,
  -5.906140807745207e-07,  -7.807385982108079e-09,   1.034587989119401e-10,   1.356042280462290e-11,  -3.712547876233606e-13,  -1.218943110463133e-14,   7.230900615738385e-16,
   3.022026282969801e-01,  -5.072122389356665e-03,   7.427452365199999e-05,  -5.904756994684965e-07,  -7.779009437753709e-09,   1.024048766547912e-10,   1.351239815417384e-11,
  -3.677529847112875e-13,  -1.216359144809129e-14,   7.154791462870449e-16,   3.022199597549665e-01,  -5.072535487691082e-03,   7.426386066255779e-05,  -5.902495852851451e-07,
  -7.732498545357677e-09,   1.006821260368154e-10,   1.343363502344353e-11,  -3.620318834223373e-13,  -1.212070054862131e-14,   7.030518818172392e-16,   3.022383488984602e-01,
  -5.072973761889003e-03,   7.425256993655084e-05,  -5.900110986973188e-07,  -7.683247123854287e-09,   9.886422460264924e-11,   1.335016676717375e-11,  -3.559988300172343e-13,
  -1.207455708117991e-14,   6.899567225099122e-16,   3.022528206197441e-01,  -5.073318646254964e-03,   7.424370109265197e-05,  -5.898244464465033e-07,  -7.644558512720896e-09,
   9.744079227677856e-11,   1.328455376634606e-11,  -3.512778138187698e-13,  -1.203778923947284e-14,   6.797164944098376e-16,   3.022611722802819e-01,  -5.073517669885037e-03,
   7.423858952417251e-05,  -5.897171407820187e-07,  -7.622259609372918e-09,   9.662220574549910e-11,   1.324671825142973e-11,  -3.485640226159141e-13,  -1.201639015517897e-14,
   6.738329250225274e-16,   3.022643083641090e-01,  -5.073592402240721e-03,   7.423667136667674e-05,  -5.896769247510401e-07,  -7.613891638218714e-09,   9.631536627734868e-11,
   1.323251652620720e-11,  -3.475470041263293e-13,  -1.200832084700871e-14,   6.716285411218293e-16,   3.022648282123741e-01,  -5.073604790040429e-03,   7.423635347250780e-05,
  -5.896702624965516e-07,  -7.612504816729815e-09,   9.626453212425146e-11,   1.323016269805715e-11,  -3.473785261192020e-13,  -1.200698146902286e-14,   6.712633940934875e-16,
   5.198740541787731e-01,  -8.691787904916733e-03,   1.237203691823064e-04,  -7.429474524536218e-07,  -2.431399255854135e-08,   3.802754684091322e-10,   2.574975272481071e-11,
  -8.130235386684536e-13,  -2.337527026646284e-14,   1.576349412039564e-15,   5.198916193657276e-01,  -8.692103245931459e-03,   1.236999134778071e-04,  -7.424256738771210e-07,
  -2.426012513177520e-08,   3.779669701386596e-10,   2.565721935595513e-11,  -8.053854628194478e-13,  -2.334724054598907e-14,   1.559915893194453e-15,   5.199204534083014e-01,
  -8.692620772731403e-03,   1.236663650224500e-04,  -7.415714143678970e-07,  -2.417183545587518e-08,   3.741934127533190e-10,   2.550539922340228e-11,  -7.929061211278218e-13,
  -2.329988699603386e-14,   1.533077530390426e-15,   5.199510457655638e-01,  -8.693169696333910e-03,   1.236308121761981e-04,  -7.406681291558173e-07,  -2.407834677086774e-08,
   3.702113457542198e-10,   2.534442848316823e-11,  -7.797455610487677e-13,  -2.324784035823082e-14,   1.504789541481833e-15,   5.199751200925666e-01,  -8.693601548657292e-03,
   1.236028641950914e-04,  -7.399595126930901e-07,  -2.400491070935016e-08,   3.670932894037992e-10,   2.521783371024124e-11,  -7.694465463322025e-13,  -2.320558948455994e-14,
   1.482663563021122e-15,   5.199890130486214e-01,  -8.693850717670390e-03,   1.235867478019964e-04,  -7.395514653901522e-07,  -2.396258543002868e-08,   3.653001340763629e-10,
   2.514481000989451e-11,  -7.635261267210172e-13,  -2.318069319930974e-14,   1.469948923252036e-15,   5.199942298389504e-01,  -8.693944271517481e-03,   1.235806983791822e-04,
  -7.393984111271744e-07,  -2.394670246918894e-08,   3.646279818414392e-10,   2.511739586762655e-11,  -7.613073537655538e-13,  -2.317124807485911e-14,   1.465184769873688e-15,
   5.199950945885589e-01,  -8.693959778795337e-03,   1.235796957296065e-04,  -7.393730492359824e-07,  -2.394407020034776e-08,   3.645166259990776e-10,   2.511285195105842e-11,
  -7.609397924822253e-13,  -2.316967734208055e-14,   1.464395587268658e-15,   8.246963186530841e-01,  -1.368165040495463e-02,   1.830527534643602e-04,  -2.659260388108633e-07,
  -7.619047771871328e-08,   1.324503676504994e-09,   5.144714126169380e-11,  -2.144431713645269e-12,  -3.744329962702889e-14,   3.759535338990753e-15,   8.247222388212124e-01,
  -1.368175746718897e-02,   1.829883098133591e-04,  -2.640925715568180e-07,  -7.608245445263547e-08,   1.318384961236028e-09,   5.129612368666466e-11,  -2.126170593749593e-12,
  -3.753568842880439e-14,   3.722058902135652e-15,   8.247647844424748e-01,  -1.368193267331821e-02,   1.828825812205990e-04,  -2.610888122398004e-07,  -7.590535068078815e-08,
   1.308378898798309e-09,   5.104796593138783e-11,  -2.096328710379580e-12,  -3.768244198622379e-14,   3.660809448883428e-15,   8.248099197643211e-01,  -1.368211782883513e-02,
   1.827704847541175e-04,  -2.579099607669400e-07,  -7.571774796527785e-08,   1.297814263797286e-09,   5.078433554737117e-11,  -2.064849397637829e-12,  -3.783152991998395e-14,
   3.596191243107410e-15,   8.248454350801199e-01,  -1.368226300371924e-02,   1.826823291590881e-04,  -2.554142306866181e-07,  -7.557033407751164e-08,   1.289537777368547e-09,
   5.057663430862188e-11,  -2.040208690348877e-12,  -3.794410596740875e-14,   3.545605504896283e-15,   8.248659290909630e-01,  -1.368234656938955e-02,   1.826314788411924e-04,
  -2.539763127360758e-07,  -7.548535105558001e-08,   1.284776420871415e-09,   5.045667851611647e-11,  -2.026041497492833e-12,  -3.800718293594243e-14,   3.516519248470489e-15,
   8.248736243097287e-01,  -1.368237790803305e-02,   1.826123889529613e-04,  -2.534368163659896e-07,  -7.545345655857971e-08,   1.282991345719741e-09,   5.041161764381316e-11,
  -2.020731659584169e-12,  -3.803051284682096e-14,   3.505617423900150e-15,   8.248748998767456e-01,  -1.368238310069451e-02,   1.826092247897976e-04,  -2.533474111666553e-07,
  -7.544817051106869e-08,   1.282695594802549e-09,   5.040414730602406e-11,  -2.019852009501116e-12,  -3.803436136694131e-14,   3.503811363842693e-15,   1.272469672647072e+00,
  -2.063408800276684e-02,   2.199922746496404e-04,   4.207140431880696e-06,  -3.228080062674632e-07,   6.093561097176419e-09,   1.941904293673721e-10,  -1.383414018500786e-11,
   1.671134519166007e-13,   1.331790704711591e-14,   1.272500429738447e+00,  -2.063226250989615e-02,   2.197190379695252e-04,   4.215473113303418e-06,  -3.223865835596967e-07,
   6.053303608769198e-09,   1.947805080083752e-10,  -1.376619015000467e-11,   1.634280388293836e-13,   1.330872158720075e-14,   1.272550894765224e+00,  -2.062926317546168e-02,
   2.192707379383159e-04,   4.229111602712534e-06,  -3.216938794925620e-07,   5.987360988596277e-09,   1.957388003161809e-10,  -1.365468260559756e-11,   1.574121374596274e-13,
   1.329238800466939e-14,   1.272604404405266e+00,  -2.062607726914817e-02,   2.187954135861926e-04,   4.243527514381769e-06,  -3.209576925541199e-07,   5.917589903825416e-09,
   1.967415183988356e-10,  -1.353642599657547e-11,   1.510753050284717e-13,   1.327336718371818e-14,   1.272646489522769e+00,  -2.062356750177144e-02,   2.184215892500868e-04,
   4.254832736233839e-06,  -3.203774660797910e-07,   5.862823823088452e-09,   1.975204932416498e-10,  -1.344340389855475e-11,   1.461217652262561e-13,   1.325718600238095e-14,
   1.272670766747643e+00,  -2.062211808867266e-02,   2.182059515772988e-04,   4.261341117483614e-06,  -3.200422701580955e-07,   5.831275005327635e-09,   1.979659922654517e-10,
  -1.338973828990049e-11,   1.432764117952291e-13,   1.324736563483392e-14,   1.272679881023582e+00,  -2.062157363513580e-02,   2.181249970884449e-04,   4.263782041980523e-06,
  -3.199163375373824e-07,   5.819439025542106e-09,   1.981325153562995e-10,  -1.336959003624296e-11,   1.422104884135322e-13,   1.324358735958256e-14,   1.272681391736436e+00,
  -2.062148337444048e-02,   2.181115787574285e-04,   4.264186499981276e-06,  -3.198954590743132e-07,   5.817477618242646e-09,   1.981600785607352e-10,  -1.336625037266704e-11,
   1.420339300088042e-13,   1.324295628629424e-14,   5.488696598535223e-03,  -8.756430925349848e-05,   1.310415005291714e-06,  -1.478879189533854e-08,   6.127557920328198e-12,
   3.347517867131054e-12,   4.630239684627201e-14,  -6.409457852061302e-15,   1.178063358855364e-16,   4.647612832753474e-18,   5.488883091940694e-03,  -8.757060667469887e-05,
   1.310420828947162e-06,  -1.478418627776973e-08,   6.231542317846942e-12,   3.328745471572400e-12,   4.673953961291667e-14,  -6.385563507742883e-15,   1.162398951402818e-16,
   4.651178432924668e-18,   5.489189251753296e-03,  -8.758094352680610e-05,   1.310430455205278e-06,  -1.477664456053358e-08,   6.402906956240581e-12,   3.297979202469287e-12,
   4.745273789876830e-14,  -6.346327247589009e-15,   1.136803638539104e-16,   4.656582936319087e-18,   5.489514111940836e-03,  -8.759190984810733e-05,   1.310440759032698e-06,
  -1.476866821211769e-08,   6.585627860005757e-12,   3.265404027444782e-12,   4.820347783167253e-14,  -6.304682080009878e-15,   1.109808250584336e-16,   4.661711751662982e-18,
   5.489769779316877e-03,  -8.760053904360779e-05,   1.310448933257947e-06,  -1.476240958324689e-08,   6.730071485314305e-12,   3.239818037349744e-12,   4.878997132145505e-14,
  -6.271898788014880e-15,   1.088680640819992e-16,   4.665313041764275e-18,   5.489917330241247e-03,  -8.760551857794708e-05,   1.310453676897479e-06,  -1.475880513427198e-08,
   6.813688840540503e-12,   3.225072244943517e-12,   4.912671225437423e-14,  -6.252975799945107e-15,   1.076534655699384e-16,   4.667218144899264e-18,   5.489972737134054e-03,
  -8.760738834004979e-05,   1.310455463127538e-06,  -1.475745304983734e-08,   6.845136283622651e-12,   3.219538906060889e-12,   4.925283429417630e-14,  -6.245869469172667e-15,
   1.071982622760838e-16,   4.667900915673671e-18,   5.489981921622442e-03,  -8.760769827447369e-05,   1.310455759481835e-06,  -1.475722899748370e-08,   6.850351692437334e-12,
   3.218621879195919e-12,   4.927372356307064e-14,  -6.244691464214890e-15,   1.071228527675623e-16,   4.668012377455306e-18,   4.979077205263841e-02,  -7.941488902630235e-04,
   1.186242106673154e-05,  -1.322721534644393e-07,  -3.527357229942869e-11,   3.298701175443669e-11,   3.973082610883802e-13,  -5.953402527175217e-14,   1.114213250388666e-15,
   4.305511401543203e-17,   4.979246011210771e-02,  -7.942051997952960e-04,   1.186239605349854e-05,  -1.322266795082067e-07,  -3.437678085480832e-11,   3.281263973193182e-11,
   4.014438479984645e-13,  -5.931244198153699e-14,   1.099451342873285e-15,   4.309677285043600e-17,   4.979523133327301e-02,  -7.942976273190655e-04,   1.186235555892392e-05,
  -1.321522045250856e-07,  -3.289833243127559e-11,   3.252685901461315e-11,   4.081912151491902e-13,  -5.894855524703675e-14,   1.075329932268725e-15,   4.316085971692502e-17,
   4.979817181091552e-02,  -7.943956814940780e-04,   1.186231336599819e-05,  -1.320734222892258e-07,  -3.132116570016165e-11,   3.222427494899134e-11,   4.152939679659372e-13,
  -5.856228617681755e-14,   1.049888037383160e-15,   4.322305515901540e-17,   4.980048598071228e-02,  -7.944728372223444e-04,   1.186228072262627e-05,  -1.320115948792672e-07,
  -3.007385926174650e-11,   3.198661139397291e-11,   4.208429399582961e-13,  -5.825818331345916e-14,   1.029975506206512e-15,   4.326783289862125e-17,   4.980182153273857e-02,
  -7.945173599290381e-04,   1.186226210957371e-05,  -1.319759829998287e-07,  -2.935159100707101e-11,   3.184964021593817e-11,   4.240289983405640e-13,  -5.808263887271132e-14,
   1.018527756688460e-15,   4.329201415066739e-17,   4.980232304568979e-02,  -7.945340776335233e-04,   1.186225516298040e-05,  -1.319626235937431e-07,  -2.907991513364981e-11,
   3.179824192300928e-11,   4.252223078089864e-13,  -5.801671275056966e-14,   1.014237350170630e-15,   4.330078181969165e-17,   4.980240617863396e-02,  -7.945368487788324e-04,
   1.186225401374217e-05,  -1.319604097775789e-07,  -2.903485688826246e-11,   3.178972380611565e-11,   4.254199532062638e-13,  -5.800578416605261e-14,   1.013526593468177e-15,
   4.330221872499107e-17,   1.406090584930095e-01,  -2.241485608957889e-03,   3.334362878541863e-05,  -3.617469053376924e-07,  -6.713867857556792e-10,   1.097872656360995e-10,
   9.735560770753936e-13,  -1.769758008944368e-13,   3.448040078929364e-15,   1.268190794294057e-16,   1.406138024093504e-01,  -2.241639511011604e-03,   3.334306822859199e-05,
  -3.615950374498449e-07,  -6.691578138210698e-10,   1.092688449741327e-10,   9.863633482277148e-13,  -1.763215433949409e-13,   3.402814419314805e-15,   1.270016748683468e-16,
   1.406215902604585e-01,  -2.241892120304340e-03,   3.334214940663804e-05,  -3.613462505966708e-07,  -6.654793276994259e-10,   1.084191894056338e-10,   1.007260256007859e-12,
  -1.752469004863455e-13,   3.328908965609372e-15,   1.272877664869044e-16,   1.406298536973237e-01,  -2.242160096081735e-03,   3.334117640555780e-05,  -3.610829864864398e-07,
  -6.615500901081623e-10,   1.075195640383367e-10,   1.029259653102603e-12,  -1.741058692784015e-13,   3.250950475713424e-15,   1.275728864823117e-16,   1.406363570112863e-01,
  -2.242370949457398e-03,   3.334041205818061e-05,  -3.608763154492725e-07,  -6.584389612620548e-10,   1.068129482569428e-10,   1.046447850272266e-12,  -1.732073484825694e-13,
   3.189929744199582e-15,   1.277840250954762e-16,   1.406401101792116e-01,  -2.242492619060477e-03,   3.333997150502047e-05,  -3.607572494669661e-07,  -6.566359603294250e-10,
   1.064057054474826e-10,   1.056317348528613e-12,  -1.726885917809447e-13,   3.154846742197814e-15,   1.279005987851076e-16,   1.406415195269841e-01,  -2.242538303806235e-03,
   3.333980618022540e-05,  -3.607125782800223e-07,  -6.559574998108249e-10,   1.062528873923003e-10,   1.060013981443882e-12,  -1.724937559790249e-13,   3.141697885128155e-15,
   1.279433796631552e-16,   1.406417531463341e-01,  -2.242545876527463e-03,   3.333977878093931e-05,  -3.607051754626188e-07,  -6.558449606619770e-10,   1.062275611871942e-10,
   1.060626252508446e-12,  -1.724614571977250e-13,   3.139519600436238e-15,   1.279504188812094e-16,   2.830455275382429e-01,  -4.507843151104466e-03,   6.655880845877067e-05,
  -6.853217274107670e-07,  -3.454260264727575e-09,   2.831873380090846e-10,   1.375044406259036e-12,  -3.895334983583785e-13,   8.160541267040003e-15,   2.714041223140272e-16,
   2.830549934528077e-01,  -4.508134342183081e-03,   6.655587789074572e-05,  -6.849283488156976e-07,  -3.450967463466039e-09,   2.820457525249649e-10,   1.405407897992446e-12,
  -3.881263721915547e-13,   8.056064888563831e-15,   2.720581227141665e-16,   2.830705329857331e-01,  -4.508612260337028e-03,   6.655106903306897e-05,  -6.842837189746633e-07,
  -3.445516087589531e-09,   2.801747047053388e-10,   1.454957959719318e-12,  -3.858141779109891e-13,   7.885311268868190e-15,   2.730981704060291e-16,   2.830870212266545e-01,
  -4.509119206726587e-03,   6.654596939231263e-05,  -6.836012982088272e-07,  -3.439669881125788e-09,   2.781935252722798e-10,   1.507132601307068e-12,  -3.833578801926958e-13,
   7.705161378542702e-15,   2.741563847856910e-16,   2.830999972661375e-01,  -4.509518059270100e-03,   6.654195808060327e-05,  -6.830653730417195e-07,  -3.435024280865576e-09,
   2.766373309623743e-10,   1.547904341050076e-12,  -3.814227274350686e-13,   7.564128952719945e-15,   2.749566070047138e-16,   2.831074858749465e-01,  -4.509748198051561e-03,
   6.653964393279318e-05,  -6.827565380977897e-07,  -3.432325398057340e-09,   2.757404256679827e-10,   1.571318580913710e-12,  -3.803051149244522e-13,   7.483035159545453e-15,
   2.754054431702232e-16,   2.831102978998510e-01,  -4.509834608608842e-03,   6.653877511002484e-05,  -6.826406540094412e-07,  -3.431308580895828e-09,   2.754038566145203e-10,
   1.580088985872169e-12,  -3.798852915130379e-13,   7.452640052085619e-15,   2.755715402030282e-16,   2.831107640320602e-01,  -4.509848931929177e-03,   6.653863109881160e-05,
  -6.826214491252401e-07,  -3.431139851835857e-09,   2.753480774956696e-10,   1.581541652926943e-12,  -3.798156919729554e-13,   7.447604602954932e-15,   2.755989443865261e-16,
   4.870216132028303e-01,  -7.743546004249956e-03,   1.128072132947967e-04,  -1.046164358883415e-06,  -1.259724575078420e-08,   6.897662516299045e-10,   2.928461880807752e-13,
  -7.798153722907929e-13,   1.858003998469648e-14,   4.967498398901628e-16,   4.870376448854636e-01,  -7.743989238954978e-03,   1.127964657884301e-04,  -1.045202055940935e-06,
  -1.259580271142815e-08,   6.874775599352768e-10,   3.622565683904156e-13,  -7.772100011666478e-13,   1.835577139039862e-14,   4.990783856542031e-16,   4.870639623840938e-01,
  -7.744716588037911e-03,   1.127788231638385e-04,  -1.043624616501842e-06,  -1.259332908144680e-08,   6.837259673106651e-10,   4.755678317959999e-13,  -7.729248412391891e-13,
   1.798912866533272e-14,   5.028212341127822e-16,   4.870918857853298e-01,  -7.745487964601071e-03,   1.127601045681281e-04,  -1.041954003730882e-06,  -1.259056267758901e-08,
   6.797529461043281e-10,   5.949363663622966e-13,  -7.683672126084306e-13,   1.760217015697669e-14,   5.066848539805059e-16,   4.871138605637493e-01,  -7.746094754856287e-03,
   1.127453741149408e-04,  -1.040641517071589e-06,  -1.258828333289030e-08,   6.766317457491176e-10,   6.882567444050939e-13,  -7.647726813883462e-13,   1.729913432447172e-14,
   5.096479967971604e-16,   4.871265422031559e-01,  -7.746444830373421e-03,   1.127368733642154e-04,  -1.039884974220160e-06,  -1.258692706091334e-08,   6.748326823131582e-10,
   7.418645380414176e-13,  -7.626951800253201e-13,   1.712484811309032e-14,   5.113271729582517e-16,   4.871313042026569e-01,  -7.746576265486138e-03,   1.127336813399148e-04,
  -1.039601058432284e-06,  -1.258641006867887e-08,   6.741575401961450e-10,   7.619477662518618e-13,  -7.619144902933556e-13,   1.705951556167375e-14,   5.119518982506442e-16,
   4.871320935678999e-01,  -7.746598051591601e-03,   1.127331522210829e-04,  -1.039554004481016e-06,  -1.258632396407736e-08,   6.740456481057834e-10,   7.652743694864204e-13,
  -7.617850499853932e-13,   1.704869175010736e-14,   5.120551487713545e-16,   7.728521676415633e-01,  -1.224837358108583e-02,   1.735804445741819e-04,  -1.227340612666024e-06,
  -4.243403923719428e-08,   1.814375302524043e-09,  -8.017317017263228e-12,  -1.636372513629810e-12,   4.989427625025268e-14,   7.003147871584864e-16,   7.728767963839959e-01,
  -1.224888858978969e-02,   1.735441292350262e-04,  -1.224799330056586e-06,  -4.244893195391099e-08,   1.809547133842025e-09,  -7.829066288719088e-12,  -1.632521519653613e-12,
   4.938276483757729e-14,   7.103229036735444e-16,   7.729172247039536e-01,  -1.224973328529245e-02,   1.734845032337530e-04,  -1.220632343219313e-06,  -4.247309590191420e-08,
   1.801629398332142e-09,  -7.521478997414759e-12,  -1.626164050963433e-12,   4.854589164157923e-14,   7.265377236829044e-16,   7.729601171838089e-01,  -1.225062852054239e-02,
   1.734212239868422e-04,  -1.216217556913106e-06,  -4.249834979591830e-08,   1.793239641285981e-09,  -7.197080425278239e-12,  -1.619370551652182e-12,   4.766178835284963e-14,
   7.434519905314220e-16,   7.729938701036830e-01,  -1.225133231438779e-02,   1.733714146697427e-04,  -1.212747950397437e-06,  -4.251794628292931e-08,   1.786645268857383e-09,
  -6.943203673085015e-12,  -1.613989808556147e-12,   4.696880862576086e-14,   7.565541253638159e-16,   7.730133480956773e-01,  -1.225173818274518e-02,   1.733426654691902e-04,
  -1.210747516890531e-06,  -4.252914449301407e-08,   1.782842909311234e-09,  -6.797257127764495e-12,  -1.610870868612397e-12,   4.657000524421961e-14,   7.640320292303789e-16,
   7.730206619959750e-01,  -1.225189053275808e-02,   1.733318692433825e-04,  -1.209996701550929e-06,  -4.253332853174867e-08,   1.781415725907014e-09,  -6.742560476196632e-12,
  -1.609697116745849e-12,   4.642046403875061e-14,   7.668243010605644e-16,   7.730218743648999e-01,  -1.225191578391585e-02,   1.733300795820399e-04,  -1.209872262536227e-06,
  -4.253402098910091e-08,   1.781179183644172e-09,  -6.733499402986715e-12,  -1.609502415899450e-12,   4.639568670476546e-14,   7.672863300069157e-16,   1.193662537983465e+00,
  -1.874969835151867e-02,   2.440058733445001e-04,   1.536582026454843e-07,  -1.812904351037513e-07,   6.993968193488412e-09,  -7.737204043467023e-11,  -5.042726081180755e-12,
   2.771740461799224e-13,  -4.118475229218856e-15,   1.193696948790279e+00,  -1.874959807407402e-02,   2.438502226046420e-04,   1.634811333590243e-07,  -1.814428106497588e-07,
   6.978602065984889e-09,  -7.629280080305819e-11,  -5.061545543104191e-12,   2.759662389269202e-13,  -4.033109100849489e-15,   1.193753423557357e+00,  -1.874943045196151e-02,
   2.435946067251890e-04,   1.795911384446704e-07,  -1.816913081551108e-07,   6.953336904509829e-09,  -7.452456943414496e-11,  -5.092128264094082e-12,   2.739770007166373e-13,
  -3.893446265920630e-15,   1.193813325708414e+00,  -1.874924851679189e-02,   2.433232567570340e-04,   1.966634336457135e-07,  -1.819527415315574e-07,   6.926475739172243e-09,
  -7.265312651393323e-11,  -5.124155203906674e-12,   2.718576271184650e-13,  -3.745906976888008e-15,   1.193860453126365e+00,  -1.874910238447652e-02,   2.431096151799737e-04,
   2.100837167347261e-07,  -1.821568702926535e-07,   6.905297865271391e-09,  -7.118376484987011e-11,  -5.149054584831096e-12,   2.701834906318854e-13,  -3.630267773857588e-15,
   1.193887644910322e+00,  -1.874901686750850e-02,   2.429862834260606e-04,   2.178225245508963e-07,  -1.822740281213949e-07,   6.893060564334481e-09,  -7.033716245488694e-11,
  -5.163302104484809e-12,   2.692148620688601e-13,  -3.563721063385723e-15,   1.193897854491368e+00,  -1.874898453187076e-02,   2.429399645235119e-04,   2.207273324297208e-07,
  -1.823178995004150e-07,   6.888462486590410e-09,  -7.001951879421555e-11,  -5.168629085392688e-12,   2.688506719833169e-13,  -3.538768263572230e-15,   1.193899546812033e+00,
  -1.874897916000502e-02,   2.429322861545164e-04,   2.212087830464223e-07,  -1.823251653466202e-07,   6.887700139336394e-09,  -6.996687874290481e-11,  -5.169510890611480e-12,
   2.687902780462322e-13,  -3.534633888527499e-15,   5.158291282325284e-03,  -7.778397099281527e-05,   1.135797401270763e-06,  -1.414680328738288e-08,   7.226884850442355e-11,
   2.820025674140742e-12,  -6.807509189916662e-14,  -1.700526272187612e-15,   1.339548390875302e-16,  -2.422389498900908e-18,   5.158453037137706e-03,  -7.778999656359484e-05,
   1.135858322569025e-06,  -1.414283478192338e-08,   7.212974694013657e-11,   2.814762649557831e-12,  -6.755095236087399e-14,  -1.711977953721594e-15,   1.334938181808818e-16,
  -2.386515119907080e-18,   5.158718589991281e-03,  -7.779988729949742e-05,   1.135958250865328e-06,  -1.413632532547696e-08,   7.190219272372320e-11,   2.806098427133930e-12,
  -6.669183501392241e-14,  -1.730646331916733e-15,   1.327343859612636e-16,  -2.327810312636839e-18,   5.159000370448785e-03,  -7.781038048617454e-05,   1.136064168788950e-06,
  -1.412942576037429e-08,   7.166183100950232e-11,   2.796872396748963e-12,  -6.578207370818412e-14,  -1.750276712301128e-15,   1.319250812196023e-16,  -2.265777079105833e-18,
   5.159222139196255e-03,  -7.781863748638941e-05,   1.136147444625481e-06,  -1.412400118620021e-08,   7.147345401495447e-11,   2.789587965331697e-12,  -6.506741384387936e-14,
  -1.765597198284396e-15,   1.312856550225823e-16,  -2.217143151542838e-18,   5.159350128699720e-03,  -7.782340228477236e-05,   1.136195471888703e-06,  -1.412087273431349e-08,
   7.136505391587434e-11,   2.785374598616915e-12,  -6.465550263058281e-14,  -1.774387450442353e-15,   1.309156366347886e-16,  -2.189150471416904e-18,   5.159398190488781e-03,
  -7.782519142364687e-05,   1.136213500402836e-06,  -1.411969838120235e-08,   7.132440828281896e-11,   2.783790669549390e-12,  -6.450092673109998e-14,  -1.777678555447595e-15,
   1.307765043972270e-16,  -2.178653115935574e-18,   5.159406157442411e-03,  -7.782548799426168e-05,   1.136216488560192e-06,  -1.411950373709266e-08,   7.131767383497856e-11,
   2.783528017481809e-12,  -6.447530888678782e-14,  -1.778223590617901e-15,   1.307534314158534e-16,  -2.176913777136813e-18,   4.679397631778908e-02,  -7.055571480867392e-04,
   1.029387197585403e-05,  -1.275226502038608e-07,   6.094184784537453e-10,   2.736263767848638e-11,  -6.580091604979585e-13,  -1.537972232128116e-14,   1.248188926825780e-15,
  -2.298577233568170e-17,   4.679544224238954e-02,  -7.056114542582159e-04,   1.029438472294843e-05,  -1.274841152812216e-07,   6.080717875268112e-10,   2.731495596196163e-11,
  -6.531239750715629e-13,  -1.548849047792468e-14,   1.243954894286681e-15,  -2.264930842067842e-17,   4.679784884648079e-02,  -7.057005948352307e-04,   1.029522566755753e-05,
  -1.274209037175415e-07,   6.058684661519523e-10,   2.723644958299228e-11,  -6.451164900661154e-13,  -1.566581825906233e-14,   1.236978909188747e-15,  -2.209868453967625e-17,
   4.680040250953817e-02,  -7.057951638590348e-04,   1.029611687273364e-05,  -1.273538991013130e-07,   6.035407405202249e-10,   2.715283829884688e-11,  -6.366367359567301e-13,
  -1.585230487984514e-14,   1.229543009537497e-15,  -2.151679478154199e-17,   4.680241230651791e-02,  -7.058695785871689e-04,   1.029681745995202e-05,  -1.273012152594832e-07,
   6.017161622996191e-10,   2.708681250574584e-11,  -6.299753233538694e-13,  -1.599786315186618e-14,   1.223666667480298e-15,  -2.106056068178082e-17,   4.680357221998172e-02,
  -7.059125201380930e-04,   1.029722146413349e-05,  -1.272708301156360e-07,   6.006661076779024e-10,   2.704861860461570e-11,  -6.261357914862846e-13,  -1.608138450073785e-14,
   1.220265677507822e-15,  -2.079794831844642e-17,   4.680400778286208e-02,  -7.059286442400087e-04,   1.029737311161704e-05,  -1.272594239252814e-07,   6.002723580638270e-10,
   2.703425961390898e-11,  -6.246949363356324e-13,  -1.611265638219626e-14,   1.218986760065063e-15,  -2.069946519700407e-17,   4.680407998384663e-02,  -7.059313169944144e-04,
   1.029739824618922e-05,  -1.272575333830070e-07,   6.002071177706133e-10,   2.703187852042314e-11,  -6.244561429151190e-13,  -1.611783533481832e-14,   1.218774665846542e-15,
  -2.068314709462484e-17,   1.321490849811034e-01,  -1.992115246845243e-03,   2.901080082414337e-05,  -3.550789377679591e-07,   1.432036931949560e-09,   8.849828848231012e-11,
  -2.116730935818365e-12,  -4.300257341915138e-14,   3.733473224075054e-15,  -7.153622293397886e-17,   1.321532158403355e-01,  -1.992266397177486e-03,   2.901199902828276e-05,
  -3.549541333505278e-07,   1.427691847588819e-09,   8.836441086786405e-11,  -2.102109819729246e-12,  -4.334180728357300e-14,   3.721247646512529e-15,  -7.051648326490918e-17,
   1.321599974338794e-01,  -1.992514496675541e-03,   2.901396344773463e-05,  -3.547493866014489e-07,   1.420581109560455e-09,   8.814391398438737e-11,  -2.078142567961982e-12,
  -4.389497662073763e-14,   3.701095614020951e-15,  -6.884743957848920e-17,   1.321671933911669e-01,  -1.992777697479329e-03,   2.901604428642122e-05,  -3.545323250067240e-07,
   1.413066508673753e-09,   8.790898225219427e-11,  -2.052760074933782e-12,  -4.447686214191085e-14,   3.679602605441994e-15,  -6.708330166964324e-17,   1.321728567648480e-01,
  -1.992984800309225e-03,   2.901767934420171e-05,  -3.543616346490348e-07,   1.407174494937624e-09,   8.772339270221408e-11,  -2.032819215373731e-12,  -4.493114645901786e-14,
   3.662608519047373e-15,  -6.569988713574866e-17,   1.321761252556017e-01,  -1.993104308342228e-03,   2.901862193849854e-05,  -3.542631814278057e-07,   1.403782916044162e-09,
   8.761600706959934e-11,  -2.021325135878009e-12,  -4.519185732293082e-14,   3.652769495599969e-15,  -6.490348892687045e-17,   1.321773526152717e-01,  -1.993149181951270e-03,
   2.901897569767133e-05,  -3.542262217704855e-07,   1.402511010090564e-09,   8.757563023495135e-11,  -2.017011678804220e-12,  -4.528948016865352e-14,   3.649068938920168e-15,
  -6.460481155146217e-17,   1.321775560681741e-01,  -1.993156620244173e-03,   2.901903432807021e-05,  -3.542200957327979e-07,   1.402300261320230e-09,   8.756893443236209e-11,
  -2.016296803241987e-12,  -4.530564796455576e-14,   3.648455207872357e-15,  -6.455532145952676e-17,   2.660262475968886e-01,  -4.008781577162362e-03,   5.818736099901099e-05,
  -6.965917327434277e-07,   1.831045154487338e-09,   2.195678386603830e-10,  -5.238875107876720e-12,  -8.399983390412785e-14,   8.287346811869564e-15,  -1.702430296742111e-16,
   2.660345311061773e-01,  -4.009077871996562e-03,   5.818886344020206e-05,  -6.962815108550269e-07,   1.820247442666695e-09,   2.193039815518105e-10,  -5.206379480596082e-12,
  -8.481028937986163e-14,   8.262187396599647e-15,  -1.679347571361655e-16,   2.660481299725775e-01,  -4.009564192740241e-03,   5.819132339901780e-05,  -6.957725080713638e-07,
   1.802571104105408e-09,   2.188691067748311e-10,  -5.153106298356463e-12,  -8.613231436154443e-14,   8.220675871948018e-15,  -1.641557086649187e-16,   2.660625596180370e-01,
  -4.010080087329619e-03,   5.819392473168447e-05,  -6.952327937154479e-07,   1.783882833870664e-09,   2.184053561123800e-10,  -5.096679751585867e-12,  -8.752359644789660e-14,
   8.176348154170098e-15,  -1.601599707130403e-16,   2.660739159673450e-01,  -4.010486005499390e-03,   5.819596558246957e-05,  -6.948083093335108e-07,   1.769224027548405e-09,
   2.180387136703529e-10,  -5.052344718637278e-12,  -8.861024145789341e-14,   8.141260498948108e-15,  -1.570255708986850e-16,   2.660804699956340e-01,  -4.010720231312531e-03,
   5.819714083156831e-05,  -6.945634410322081e-07,   1.760783753198415e-09,   2.178264510101336e-10,  -5.026787430736967e-12,  -8.923404349745287e-14,   8.120930538819866e-15,
  -1.552207761402511e-16,   2.660829311091992e-01,  -4.010808178348067e-03,   5.819758166484391e-05,  -6.944715113580164e-07,   1.757618050681965e-09,   2.177466186696377e-10,
  -5.017195967767091e-12,  -8.946766012464835e-14,   8.113281349923405e-15,  -1.545438396783492e-16,   2.660833390745684e-01,  -4.010822756454257e-03,   5.819765471372513e-05,
  -6.944562737970704e-07,   1.757093485554267e-09,   2.177333786979558e-10,  -5.015606338660826e-12,  -8.950635235084840e-14,   8.112012593182699e-15,  -1.544316690576573e-16,
   4.577693456196955e-01,  -6.893711204713205e-03,   9.948329173250471e-05,  -1.143069540122948e-06,  -1.160075638435974e-10,   5.095597655276566e-10,  -1.226036462106389e-11,
  -1.306649232938857e-13,   1.671773268159730e-14,  -3.868072870980569e-16,   4.577835023328184e-01,  -6.894196657788013e-03,   9.948304920453140e-05,  -1.142347970475444e-06,
  -1.413991999204116e-10,   5.091399045178633e-10,  -1.219463758708686e-11,  -1.325191407271866e-13,   1.667550195263719e-14,  -3.820450469518539e-16,   4.578067428215351e-01,
  -6.894993385797018e-03,   9.948263563250709e-05,  -1.141163841029671e-06,  -1.829827520861375e-10,   5.084467122006387e-10,  -1.208686061465664e-11,  -1.355456354083912e-13,
   1.660565452181028e-14,  -3.742442877379754e-16,   4.578314027116632e-01,  -6.895838474456602e-03,   9.948217587327003e-05,  -1.139907993646390e-06,  -2.269690528733843e-10,
   5.077058711885076e-10,  -1.197267105110474e-11,  -1.387332273648649e-13,   1.653084067169876e-14,  -3.659906414426402e-16,   4.578508101273744e-01,  -6.896503345559673e-03,
   9.948179891500870e-05,  -1.138920075238117e-06,  -2.614873507651935e-10,   5.071189967523006e-10,  -1.188292707485956e-11,  -1.412247094401487e-13,   1.647145851626579e-14,
  -3.595121525068035e-16,   4.578620105072717e-01,  -6.896886968264447e-03,   9.948157531081519e-05,  -1.138350105170995e-06,  -2.813688183994103e-10,   5.067787706471711e-10,
  -1.183118390650572e-11,  -1.426557193633647e-13,   1.643698742749306e-14,  -3.557802114574539e-16,   4.578662163576426e-01,  -6.897031005885831e-03,   9.948149020195183e-05,
  -1.138136109257498e-06,  -2.888270035909331e-10,   5.066507239241998e-10,  -1.181176327606811e-11,  -1.431917798420667e-13,   1.642400544523353e-14,  -3.543801431627513e-16,
   4.578669135373497e-01,  -6.897054881311909e-03,   9.948147603365261e-05,  -1.138100638141398e-06,  -2.900629087740625e-10,   5.066294831461349e-10,  -1.180854452738845e-11,
  -1.432805710925130e-13,   1.642185150821575e-14,  -3.541481311599476e-16,   7.265298602150643e-01,  -1.092755823375045e-02,   1.559078142035017e-04,  -1.638668804141609e-06,
  -1.082194605774316e-08,   1.256745335678420e-09,  -3.136537935917425e-11,  -1.209810311213960e-13,   3.477690910080443e-14,  -1.002779088921442e-15,   7.265520277116045e-01,
  -1.092825151333107e-02,   1.558982046822917e-04,  -1.636884138506437e-06,  -1.088726469773498e-08,   1.256306456078739e-09,  -3.122769279331827e-11,  -1.258537028784675e-13,
   3.473564390613061e-14,  -9.929090870889904e-16,   7.265884181987334e-01,  -1.092938909422520e-02,   1.558823893055659e-04,  -1.633954804270838e-06,  -1.099428387872197e-08,
   1.255575611214919e-09,  -3.100178541305562e-11,  -1.338165450229603e-13,   3.466640543595726e-14,  -9.767202516839569e-16,   7.266270298944638e-01,  -1.093059540842857e-02,
   1.558655539586355e-04,  -1.630847216745516e-06,  -1.110755157345088e-08,   1.254786100870495e-09,  -3.076225570069793e-11,  -1.422162461937347e-13,   3.459091650318749e-14,
  -9.595626575045857e-16,   7.266574164694801e-01,  -1.093154424323535e-02,   1.558522654036181e-04,  -1.628402013208287e-06,  -1.119648546690724e-08,   1.254154629658081e-09,
  -3.057387343249295e-11,  -1.487910482311732e-13,   3.453005068014231e-14,  -9.460744056439448e-16,   7.266749527417184e-01,  -1.093209161759640e-02,   1.558445806845632e-04,
  -1.626991033994278e-06,  -1.124772745772292e-08,   1.253786148840277e-09,  -3.046520659897418e-11,  -1.525711502313972e-13,   3.449434297481032e-14,  -9.382961535247488e-16,
   7.266815377079324e-01,  -1.093229712114495e-02,   1.558416920433319e-04,  -1.626461234408013e-06,  -1.126695355637531e-08,   1.253647017136198e-09,  -3.042441107058252e-11,
  -1.539879058072744e-13,   3.448082490439498e-14,  -9.353765066403505e-16,   7.266826292562011e-01,  -1.093233118413853e-02,   1.558412130539803e-04,  -1.626373414506708e-06,
  -1.127013972512922e-08,   1.253623913819419e-09,  -3.041764915435401e-11,  -1.542226103666500e-13,   3.447857832326428e-14,  -9.348925951470358e-16,   1.122522879483648e+00,
  -1.682978365275788e-02,   2.326428377190137e-04,  -1.760894025175519e-06,  -6.693152987598480e-08,   4.279026000022560e-09,  -1.218622306025197e-10,   8.507745787777729e-13,
   9.050691191279353e-14,  -4.520950588936911e-15,   1.122555868409169e+00,  -1.683051383692762e-02,   2.325842420688148e-04,  -1.754786597094398e-06,  -6.718723744225891e-08,
   4.281204324928616e-09,  -1.214912988242630e-10,   8.279428272493735e-13,   9.100890127048089e-14,  -4.508903335989531e-15,   1.122610018813169e+00,  -1.683171066382473e-02,
   2.324878914287836e-04,  -1.744758175924988e-06,  -6.760644510276794e-08,   4.284731300658391e-09,  -1.208809433440301e-10,   7.905071680982210e-13,   9.182693424504475e-14,
  -4.488893815067634e-15,   1.122667468065937e+00,  -1.683297802259751e-02,   2.323854435932835e-04,  -1.734114433690770e-06,  -6.805047052464165e-08,   4.288407023583936e-09,
  -1.202314010120297e-10,   7.508485075386353e-13,   9.268669013829455e-14,  -4.467348304656778e-15,   1.122712674760834e+00,  -1.683397358174189e-02,   2.323046630094557e-04,
  -1.725735738102758e-06,  -6.839935064077114e-08,   4.291251609683995e-09,  -1.197188338714624e-10,   7.196832494579957e-13,   9.335735712357910e-14,  -4.450165772628964e-15,
   1.122738761953435e+00,  -1.683454739318510e-02,   2.322579814360467e-04,  -1.720899428647181e-06,  -6.860046730296578e-08,   4.292873958807771e-09,  -1.194224730975769e-10,
   7.017158549251324e-13,   9.374202120957687e-14,  -4.440159141158789e-15,   1.122748557485599e+00,  -1.683476272422668e-02,   2.322404404194267e-04,  -1.719083195920783e-06,
  -6.867594531401155e-08,   4.293479517650887e-09,  -1.193110833492345e-10,   6.949724655274263e-13,   9.388601452228319e-14,  -4.436384537058105e-15,   1.122750181210567e+00,
  -1.683479841099773e-02,   2.322375321319009e-04,  -1.718782121433859e-06,  -6.868845458981648e-08,   4.293579705218516e-09,  -1.192926134600770e-10,   6.938548396201297e-13,
   9.390985963738118e-14,  -4.435757945905979e-15,   4.864285615297922e-03,  -6.935332044063523e-05,   9.745214938383545e-07,  -1.263668774055518e-08,   1.105958936041501e-10,
   1.008514282248416e-12,  -7.055810204530137e-14,   9.948019876148133e-16,   3.615139597097923e-17,  -2.266000885008740e-18,   4.864424485056211e-03,  -6.935871016359583e-05,
   9.746150831527318e-07,  -1.263522916162536e-08,   1.104470644937054e-10,   1.011304258014473e-12,  -7.040850284139299e-14,   9.833354571562367e-16,   3.642142883325929e-17,
  -2.260787067746723e-18,   4.864652471737952e-03,  -6.936755781092094e-05,   9.747686338866572e-07,  -1.263283187453026e-08,   1.102029711484250e-10,   1.015859781791375e-12,
  -7.016214939165193e-14,   9.645312924812244e-16,   3.686202106226369e-17,  -2.252135433200753e-18,   4.864894396133461e-03,  -6.937694522949207e-05,   9.749314391171571e-07,
  -1.263028438460121e-08,   1.099442875319155e-10,   1.020660036169018e-12,  -6.989971779955340e-14,   9.446059881857141e-16,   3.732584179836786e-17,  -2.242830536955929e-18,
   4.865084801244268e-03,  -6.938433272867724e-05,   9.750594779976365e-07,  -1.262827676850771e-08,   1.097409331133062e-10,   1.024413619672378e-12,  -6.969243925217774e-14,
   9.289446287765880e-16,   3.768820713475691e-17,  -2.235417626532165e-18,   4.865194691499757e-03,  -6.938859601899557e-05,   9.751333358073356e-07,  -1.262711704401560e-08,
   1.096236660400961e-10,   1.026570175071045e-12,  -6.957251782086051e-14,   9.199142003685231e-16,   3.789626792454255e-17,  -2.231103609936792e-18,   4.865235957090706e-03,
  -6.939019689288349e-05,   9.751610633602784e-07,  -1.262668135034428e-08,   1.095796486359108e-10,   1.027378148334693e-12,  -6.952743013990379e-14,   9.165247115665676e-16,
   3.797419514825358e-17,  -2.229476890803155e-18,   4.865242797490381e-03,  -6.939046225884990e-05,   9.751656592409733e-07,  -1.262660911704633e-08,   1.095723530473145e-10,
   1.027511984696378e-12,  -6.951995326084405e-14,   9.159629359675115e-16,   3.798710206352769e-17,  -2.229206882504475e-18,   4.412703924729964e-02,  -6.291259155760080e-04,
   8.837156157728470e-06,  -1.143280105199551e-07,   9.835877186246417e-10,   1.006045137886557e-11,  -6.697071980351238e-13,   9.585773484144791e-15,   3.300690959121708e-16,
  -2.111106975172941e-17,   4.412829851218981e-02,  -6.291746733018244e-04,   8.837987989380238e-06,  -1.143134678465534e-07,   9.821744771514539e-10,   1.008739279825002e-11,
  -6.683394081954067e-13,   9.478899779387308e-15,   3.326275875337004e-16,  -2.106423992026098e-17,   4.413036588365220e-02,  -6.292547124626717e-04,   8.839352708762112e-06,
  -1.142895666914664e-07,   9.798565504945112e-10,   1.013139150390473e-11,  -6.660867362220711e-13,   9.303629297098024e-15,   3.368025144101703e-16,  -2.098648485152289e-17,
   4.413255963914983e-02,  -6.293396340281059e-04,   8.840799604053199e-06,  -1.142641691484286e-07,   9.773999628242351e-10,   1.017776516747603e-11,  -6.636866995515795e-13,
   9.117900161462054e-15,   3.411981326156656e-16,  -2.090279541206781e-17,   4.413428621918749e-02,  -6.294064632755449e-04,   8.841937466323236e-06,  -1.142441547722977e-07,
   9.754687282571938e-10,   1.021403549674458e-11,  -6.617908101300506e-13,   8.971910125444860e-15,   3.446326850645495e-16,  -2.083607766459402e-17,   4.413528269552122e-02,
  -6.294450299478161e-04,   8.842593807585406e-06,  -1.142325935449486e-07,   9.743550235028056e-10,   1.023487728294603e-11,  -6.606938404050555e-13,   8.887728932555741e-15,
   3.466048869608454e-16,  -2.079723280759689e-17,   4.413565688857311e-02,  -6.294595117776849e-04,   8.842840205768603e-06,  -1.142282502010136e-07,   9.739369768481909e-10,
   1.024268647659207e-11,  -6.602813865519714e-13,   8.856131816562905e-15,   3.473435891247018e-16,  -2.078258194938895e-17,   4.413571891675883e-02,  -6.294619123303845e-04,
   8.842881046392915e-06,  -1.142275301248025e-07,   9.738676881058508e-10,   1.024398006005502e-11,  -6.602129884491959e-13,   8.850894869468380e-15,   3.474659404559408e-16,
  -2.078014997588977e-17,   1.246185140317856e-01,  -1.776567691973558e-03,   2.493619052878196e-05,  -3.209666728925135e-07,   2.655129842292020e-09,   3.411783491465711e-11,
  -2.078377842873640e-12,   3.068132828050531e-14,   9.426725485915410e-16,  -6.309511253872172e-17,   1.246220671434858e-01,  -1.776704545482664e-03,   2.493843274794828e-05,
  -3.209173942994614e-07,   2.650740103732003e-09,   3.420442253352334e-11,  -2.074458558525795e-12,   3.036159649066617e-14,   9.506041456894766e-16,  -6.296702301106067e-17,
   1.246279003782140e-01,  -1.776929197299620e-03,   2.494211101961349e-05,  -3.208364085707780e-07,   2.643539770084600e-09,   3.434588184790781e-11,  -2.068002008503306e-12,
   2.983719982864941e-14,   9.635497595866486e-16,  -6.275401775094245e-17,   1.246340901992635e-01,  -1.777167549342454e-03,   2.494601029091291e-05,  -3.207503586775920e-07,
   2.635908013037198e-09,   3.449504629089894e-11,  -2.061120771258056e-12,   2.928145240492288e-14,   9.771836350843517e-16,  -6.252431526156657e-17,   1.246389618439641e-01,
  -1.777355118511200e-03,   2.494907639019831e-05,  -3.206825519904922e-07,   2.629907842907027e-09,   3.461176312929138e-11,  -2.055683328864730e-12,   2.884457140671636e-14,
   9.878394392721328e-16,  -6.234088161211190e-17,   1.246417734547384e-01,  -1.777463362273239e-03,   2.495084483526267e-05,  -3.206433854656917e-07,   2.626447462460170e-09,
   3.467885173692905e-11,  -2.052536537714262e-12,   2.859263872251474e-14,   9.939594079062811e-16,  -6.223395793236638e-17,   1.246428292594271e-01,  -1.777504007733951e-03,
   2.495150870353457e-05,  -3.206286716393171e-07,   2.625148516016595e-09,   3.470399298034515e-11,  -2.051353238658546e-12,   2.849807344114710e-14,   9.962519037267233e-16,
  -6.219360709427478e-17,   1.246430042750575e-01,  -1.777510745240266e-03,   2.495161873863085e-05,  -3.206262322742859e-07,   2.624933221375184e-09,   3.470815780095616e-11,
  -2.051157003069081e-12,   2.848239989809897e-14,   9.966316216277102e-16,  -6.218690783058658e-17,   2.508702627683362e-01,  -3.575933738924735e-03,   5.012576951197098e-05,
  -6.393341135359307e-07,   4.903532013019069e-09,   8.945439008899815e-11,  -4.875989434585386e-12,   7.558706603526853e-14,   1.916345085525879e-15,  -1.396618643982101e-16,
   2.508774043347792e-01,  -3.576206228294651e-03,   5.012989798363174e-05,  -6.392050120666223e-07,   4.893219501951561e-09,   8.966896107354485e-11,  -4.867968541693697e-12,
   7.487800723182821e-14,   1.935056309168078e-15,  -1.394282006660453e-16,   2.508891287875537e-01,  -3.576653523455495e-03,   5.013666920469962e-05,  -6.389928551093280e-07,
   4.876302423680023e-09,   9.001968684009994e-11,  -4.854748011738858e-12,   7.371488621333157e-14,   1.965607883765949e-15,  -1.390381581034766e-16,   2.509015699027268e-01,
  -3.577128083469056e-03,   5.014384539042732e-05,  -6.387674474749139e-07,   4.858369234374688e-09,   9.038975946867438e-11,  -4.840648325198919e-12,   7.248197974111166e-14,
   1.997799973405347e-15,  -1.386155687671956e-16,   2.509113615342813e-01,  -3.577501525045549e-03,   5.014948686079470e-05,  -6.385898392300843e-07,   4.844268163328152e-09,
   9.067950745018263e-11,  -4.829500103715485e-12,   7.151259453251456e-14,   2.022972069807382e-15,  -1.382767008061292e-16,   2.509170126399943e-01,  -3.577717029579915e-03,
   5.015274016929164e-05,  -6.384872535807545e-07,   4.836135158698546e-09,   9.084612524558780e-11,  -4.823045593354917e-12,   7.095351494589942e-14,   2.037433946945761e-15,
  -1.380786223562011e-16,   2.509191347173090e-01,  -3.577797950668833e-03,   5.015396134765532e-05,  -6.384487157122781e-07,   4.833082080840359e-09,   9.090857824303476e-11,
  -4.820617964829960e-12,   7.074364562814663e-14,   2.042852159035891e-15,  -1.380037684189455e-16,   2.509194864836300e-01,  -3.577811364338965e-03,   5.015416375058742e-05,
  -6.384423266688498e-07,   4.832576039436353e-09,   9.091892472705892e-11,  -4.820215345334719e-12,   7.070886052020052e-14,   2.043749652871143e-15,  -1.379913353549675e-16,
   4.317002029811667e-01,  -6.152075456820351e-03,   8.603868673857792e-05,  -1.079711759076356e-06,   7.091830046614643e-09,   2.184534116132156e-10,  -1.060027995821194e-11,
   1.768087386730100e-13,   3.240022669119847e-15,  -2.792602493602753e-16,   4.317124588373910e-01,  -6.152535295434086e-03,   8.604461487025614e-05,  -1.079396635262196e-06,
   7.069367357501644e-09,   2.189590732737701e-10,  -1.058651131675432e-11,   1.753857543422244e-13,   3.281698231685332e-15,  -2.789876170691183e-16,   4.317325793988805e-01,
  -6.153290096739652e-03,   8.605433304847699e-05,  -1.078878797851925e-06,   7.032512913141007e-09,   2.197861304039612e-10,  -1.056378970030972e-11,   1.730508123523372e-13,
   3.349790942819043e-15,  -2.785257682784884e-16,   4.317539296708784e-01,  -6.154090865719682e-03,   8.606462602614104e-05,  -1.078328640020708e-06,   6.993437083626432e-09,
   2.206595332358230e-10,  -1.053952022903279e-11,   1.705748053856856e-13,   3.421601390724939e-15,  -2.780163720127016e-16,   4.317707330266266e-01,  -6.154720978361527e-03,
   8.607271307643048e-05,  -1.077895163017634e-06,   6.962705697796074e-09,   2.213438887137210e-10,  -1.052030452877213e-11,   1.686273174376625e-13,   3.477797010779464e-15,
  -2.776015252608006e-16,   4.317804308039033e-01,  -6.155084589883579e-03,   8.607737483081927e-05,  -1.077644795025244e-06,   6.944978656734704e-09,   2.217376345949086e-10,
  -1.050916860763386e-11,   1.675038494424870e-13,   3.510100449843977e-15,  -2.773565349498701e-16,   4.317840724595494e-01,  -6.155221122288708e-03,   8.607912433787511e-05,
  -1.077550741617363e-06,   6.938323613112566e-09,   2.218852616107691e-10,  -1.050497824871333e-11,   1.670820648792179e-13,   3.522206484664681e-15,  -2.772634871557028e-16,
   4.317846761184110e-01,  -6.155243754102025e-03,   8.607941428948188e-05,  -1.077535148929244e-06,   6.937220530783612e-09,   2.219097208496138e-10,  -1.050428317764779e-11,
   1.670121527586795e-13,   3.524211954959454e-15,  -2.772480077314819e-16,   6.851876438778450e-01,  -9.760248868842390e-03,   1.359032220585170e-04,  -1.650952458691728e-06,
   7.021648217933991e-09,   5.565750022441899e-10,  -2.437558656255672e-11,   4.567118312243864e-13,   4.159930704697396e-15,  -5.638635927359191e-16,   6.852069953659754e-01,
  -9.760950857248837e-03,   1.359089240373040e-04,  -1.650149321521415e-06,   6.969840946324235e-09,   5.578935397473814e-10,  -2.435689114481889e-11,   4.538139615758106e-13,
   4.262643113873482e-15,  -5.642366793265985e-16,   6.852387645060154e-01,  -9.762103034461695e-03,   1.359182528592618e-04,  -1.648829504930307e-06,   6.884820889014743e-09,
   5.600518678469232e-10,  -2.432590718307907e-11,   4.490555113476062e-13,   4.430669533265553e-15,  -5.648155651841997e-16,   6.852724747517913e-01,  -9.763325243047755e-03,
   1.359281081174344e-04,  -1.647427264031063e-06,   6.794649005370215e-09,   5.623335054970475e-10,  -2.429263433963107e-11,   4.440049624292932e-13,   4.608151674239229e-15,
  -5.653842459440474e-16,   6.852990054215707e-01,  -9.764286880933495e-03,   1.359358328842479e-04,  -1.646322382836039e-06,   6.723713113588619e-09,   5.641230001524599e-10,
  -2.426616212578543e-11,   4.400291460905921e-13,   4.747245721230274e-15,  -5.657988901275553e-16,   6.853143170015700e-01,  -9.764841762017544e-03,   1.359402784250641e-04,
  -1.645684209999253e-06,   6.682786653720145e-09,   5.651532805303056e-10,  -2.425076996990158e-11,   4.377342382555138e-13,   4.827284617399166e-15,  -5.660250228430450e-16,
   6.853200666920714e-01,  -9.765050106674049e-03,   1.359419453937152e-04,  -1.645444470765021e-06,   6.667420642459515e-09,   5.655396937951257e-10,  -2.424496844523364e-11,
   4.368724065747008e-13,   4.857295558057934e-15,  -5.661074523735869e-16,   6.853210197876782e-01,  -9.765084641795955e-03,   1.359422215922862e-04,  -1.645404725335966e-06,
   6.664873626684219e-09,   5.656037226738742e-10,  -2.424400561979100e-11,   4.367295419443757e-13,   4.862267954478182e-15,  -5.661209851990405e-16,   1.058773845795540e+00,
  -1.506583936588425e-02,   2.074286820363694e-04,  -2.293759770820738e-06,  -7.525552965122544e-09,   1.841679199384069e-09,  -7.706443297802357e-11,   1.825538638835816e-12,
  -9.717328949815914e-15,  -1.243087806119315e-15,   1.058803349603321e+00,  -1.506680919517490e-02,   2.074213221799420e-04,  -2.291093862747264e-06,  -7.690409132828349e-09,
   1.847028183565306e-09,  -7.709517009262579e-11,   1.818904085771524e-12,  -9.332532277481560e-15,  -1.253072355951334e-15,   1.058851783972984e+00,  -1.506840049382532e-02,
   2.074091379377531e-04,  -2.286711885931500e-06,  -7.961090393246325e-09,   1.855794904612345e-09,  -7.714452254708409e-11,   1.807975996053722e-12,  -8.700948773234243e-15,
  -1.269387619763032e-15,   1.058903175346063e+00,  -1.507008785153657e-02,   2.073960710834949e-04,  -2.282054861230155e-06,  -8.248361880156457e-09,   1.865077320782411e-09,
  -7.719538436329952e-11,   1.796331137203833e-12,  -8.030966519353238e-15,  -1.286595822105844e-15,   1.058943619726959e+00,  -1.507141498977812e-02,   2.073856871620420e-04,
  -2.278384400773966e-06,  -8.474487125525454e-09,   1.872368296282391e-09,  -7.723432343700921e-11,   1.787130992096033e-12,  -7.503822841530751e-15,  -1.300063576825279e-15,
   1.058966960607883e+00,  -1.507218057781797e-02,   2.073796542140643e-04,  -2.276263960847102e-06,  -8.605004649107790e-09,   1.876570303710533e-09,  -7.725635929790161e-11,
   1.781807186638522e-12,  -7.199655004867026e-15,  -1.307805870693410e-15,   1.058975725272140e+00,  -1.507246800145352e-02,   2.073773811865491e-04,  -2.275467309317281e-06,
  -8.654018314473356e-09,   1.878147109823311e-09,  -7.726455146092054e-11,   1.779805361496736e-12,  -7.085448059722679e-15,  -1.310707460529643e-15,   1.058977178137072e+00,
  -1.507251564274866e-02,   2.073770039989937e-04,  -2.275335231550519e-06,  -8.662143190610960e-09,   1.878408430500738e-09,  -7.726590507599373e-11,   1.779473388889878e-12,
  -7.066517217129057e-15,  -1.311188138697918e-15,   4.601548091282696e-03,  -6.213263864031262e-05,   8.338957164786575e-07,  -1.078681496492645e-08,   1.164912512322053e-10,
  -2.823658228821211e-13,  -3.620292018754082e-14,   1.204157430968543e-15,  -1.269306614757017e-17,  -5.522336841031012e-19,   4.601666959895831e-03,  -6.213724507728798e-05,
   8.339947406393631e-07,  -1.078718685641406e-08,   1.164134268206270e-10,  -2.788149719199473e-13,  -3.624932889209796e-14,   1.201188817578036e-15,  -1.249211931310379e-17,
  -5.574653766184481e-19,   4.601862112082434e-03,  -6.214480739708756e-05,   8.341572566311902e-07,  -1.078779374422267e-08,   1.162855960668214e-10,  -2.729921774889405e-13,
  -3.632493808435451e-14,   1.196296276383403e-15,  -1.216232154582296e-17,  -5.660156041505450e-19,   4.602069197387891e-03,  -6.215283174906975e-05,   8.343296331371113e-07,
  -1.078843276626425e-08,   1.161498639433602e-10,  -2.668226018744653e-13,  -3.640437960328137e-14,   1.191079056673692e-15,  -1.181250606372498e-17,  -5.750357268358012e-19,
   4.602232184566772e-03,  -6.215914706162750e-05,   8.344652468957770e-07,  -1.078893211138773e-08,   1.160429745093725e-10,  -2.619735454000921e-13,  -3.646633176828844e-14,
   1.186954419091924e-15,  -1.153729379375907e-17,  -5.820966580938862e-19,   4.602326251644722e-03,  -6.216279179408268e-05,   8.345434932187119e-07,  -1.078921886372250e-08,
   1.159812595801402e-10,  -2.591776441058894e-13,  -3.650185764178282e-14,   1.184566551282051e-15,  -1.137850239325344e-17,  -5.861564251709164e-19,   4.602361575521937e-03,
  -6.216416043529852e-05,   8.345728718936709e-07,  -1.078932627200000e-08,   1.159580799323734e-10,  -2.581282444602159e-13,  -3.651515488401764e-14,   1.183668475806605e-15,
  -1.131888214945009e-17,  -5.876780261157776e-19,   4.602367430999981e-03,  -6.216438730758868e-05,   8.345777416397706e-07,  -1.078934406221453e-08,   1.159542373064399e-10,
  -2.579543172666142e-13,  -3.651735681989740e-14,   1.183519532755925e-15,  -1.130899963999572e-17,  -5.879301011551382e-19,   4.174363249033955e-02,  -5.636387441445180e-04,
   7.563739331363384e-06,  -9.774930038098249e-08,   1.049439574372056e-09,  -2.178738947713135e-12,  -3.435013608279714e-13,   1.135373182562768e-14,  -1.223774804783203e-16,
  -5.047379286081141e-18,   4.174471065946163e-02,  -5.636804853754474e-04,   7.564631202253798e-06,  -9.775211850622606e-08,   1.048701056977604e-09,  -2.145245712587144e-12,
  -3.439501976275486e-13,   1.132655834376086e-14,  -1.205075877801358e-16,  -5.096710410745640e-18,   4.174648073968324e-02,  -5.637490111671844e-04,   7.566094895286472e-06,
  -9.775671064827406e-08,   1.047487989274871e-09,  -2.090320689162836e-12,  -3.446816546125290e-13,   1.128176869034502e-14,  -1.174385434264566e-16,  -5.177340479742786e-18,
   4.174835905542055e-02,  -5.638217234180456e-04,   7.567647364894304e-06,  -9.776153672867634e-08,   1.046199922099376e-09,  -2.032122129125710e-12,  -3.454504746337951e-13,
   1.123399951643121e-14,  -1.141830262920176e-16,  -5.262411988142928e-18,   4.174983738940392e-02,  -5.638789491260265e-04,   7.568868716243732e-06,  -9.776530121184973e-08,
   1.045185552198178e-09,  -1.986378466197298e-12,  -3.460502466558450e-13,   1.119622891280801e-14,  -1.116216570803845e-16,  -5.329013210926452e-18,   4.175069060077456e-02,
  -5.639119755140952e-04,   7.569573401395427e-06,  -9.776746028194318e-08,   1.044599878408149e-09,  -1.960002572190338e-12,  -3.463942653040964e-13,   1.117436039219226e-14,
  -1.101437482961494e-16,  -5.367309374241472e-18,   4.175101099691713e-02,  -5.639243773102065e-04,   7.569837983536199e-06,  -9.776826848614705e-08,   1.044379902868555e-09,
  -1.950102641752575e-12,  -3.465230467795062e-13,   1.116613526759857e-14,  -1.095888382628753e-16,  -5.381663345292925e-18,   4.175106410752195e-02,  -5.639264330885356e-04,
   7.569881840011948e-06,  -9.776840232316509e-08,   1.044343436181688e-09,  -1.948461823077145e-12,  -3.465443730016081e-13,   1.116477113555625e-14,  -1.094968571478141e-16,
  -5.384041316584499e-18,   1.178878965751214e-01,  -1.591726504584838e-03,   2.135411608416182e-05,  -2.754057426669248e-07,   2.918331494293127e-09,  -3.771740735222048e-12,
  -1.064466940813213e-12,   3.478122471213941e-14,  -3.923492540857326e-16,  -1.444564010287990e-17,   1.178909404073133e-01,  -1.591844097098504e-03,   2.135659490541927e-05,
  -2.754102443043867e-07,   2.916042241183661e-09,  -3.669053847753682e-12,  -1.065914675823304e-12,   3.470318294939935e-14,  -3.867764115651867e-16,  -1.459694267726546e-17,
   1.178959376035016e-01,  -1.592037145433642e-03,   2.136066287368495e-05,  -2.754175293775114e-07,   2.912281889512692e-09,  -3.500647875648461e-12,  -1.068275323967854e-12,
   3.457451235842711e-14,  -3.776287945750241e-16,  -1.484429181877952e-17,   1.179012403587103e-01,  -1.592241986241700e-03,   2.136497737453616e-05,  -2.754251166702692e-07,
   2.908288927130554e-09,  -3.322189410688169e-12,  -1.070758352209293e-12,   3.443723427156707e-14,  -3.679240970797034e-16,  -1.510533426356202e-17,   1.179054139038089e-01,
  -1.592403198181843e-03,   2.136837151298195e-05,  -2.754309846440289e-07,   2.905144327771345e-09,  -3.181911076400815e-12,  -1.072696725085623e-12,   3.432865532597707e-14,
  -3.602877306219439e-16,  -1.530975009972089e-17,   1.179078226380416e-01,  -1.592496237200471e-03,   2.137032977672197e-05,  -2.754343297979044e-07,   2.903328672910384e-09,
  -3.101021783948674e-12,  -1.073809071818552e-12,   3.426577623664551e-14,  -3.558811809244099e-16,  -1.542731054753227e-17,   1.179087271605486e-01,  -1.592531174362705e-03,
   2.137106501837527e-05,  -2.754355781203934e-07,   2.902646717144500e-09,  -3.070659937486883e-12,  -1.074225573442811e-12,   3.424212374196401e-14,  -3.542265849579669e-16,
  -1.547137772525690e-17,   1.179088770990957e-01,  -1.592536965701928e-03,   2.137118688961860e-05,  -2.754357846354563e-07,   2.902533664820781e-09,  -3.065627707185796e-12,
  -1.074294551475514e-12,   3.423820085314319e-14,  -3.539523177474609e-16,  -1.547867837711705e-17,   2.373219656655633e-01,  -3.204183300047174e-03,   4.296509655464995e-05,
  -5.521299271011110e-07,   5.713059015419980e-09,   9.726510717804415e-13,  -2.486310218880336e-12,   8.008269780793049e-14,  -9.703367051682436e-16,  -2.945741442047773e-17,
   2.373280896625229e-01,  -3.204419004142527e-03,   4.296994428419573e-05,  -5.521265465030289e-07,   5.707709173840163e-09,   1.209394911848216e-12,  -2.489922077968275e-12,
   7.992244309198085e-14,  -9.580713441793125e-16,  -2.980747030740049e-17,   2.373381436886936e-01,  -3.204805949063606e-03,   4.297789930208969e-05,  -5.521207542807267e-07,
   5.698921105799880e-09,   1.597696061465405e-12,  -2.495816197535044e-12,   7.965807945896975e-14,  -9.379343692752934e-16,  -3.037994313938054e-17,   2.373488124588266e-01,
  -3.205216525456103e-03,   4.298633568415946e-05,  -5.521142790127177e-07,   5.689588926592156e-09,   2.009233446847103e-12,  -2.502022293892845e-12,   7.937583465681454e-14,
  -9.165658697819669e-16,  -3.098438342234556e-17,   2.373572093228934e-01,  -3.205539649700567e-03,   4.299297189677593e-05,  -5.521089446991494e-07,   5.682239147318022e-09,
   2.332766713006917e-12,  -2.506871755662112e-12,   7.915245419204238e-14,  -8.997478079951237e-16,  -3.145790535186487e-17,   2.373620555120717e-01,  -3.205726130395207e-03,
   4.299680047584926e-05,  -5.521057707150085e-07,   5.677995327129739e-09,   2.519343875790225e-12,  -2.509656537654199e-12,   7.902303613318632e-14,  -8.900414734538282e-16,
  -3.173031020928650e-17,   2.373638753410984e-01,  -3.205796155630945e-03,   4.299823789789390e-05,  -5.521045608180770e-07,   5.676401330885684e-09,   2.589378908146214e-12,
  -2.510699616682492e-12,   7.897434384333890e-14,  -8.863966000845180e-16,  -3.183243555582387e-17,   2.373641770057494e-01,  -3.205807763309763e-03,   4.299847615811634e-05,
  -5.521043593091037e-07,   5.676137082135861e-09,   2.600986815597510e-12,  -2.510872382990240e-12,   7.896626741627763e-14,  -8.857924078241737e-16,  -3.184935556387627e-17,
   4.083895207552678e-01,  -5.513412050118354e-03,   7.386724905294518e-05,  -9.433193001407624e-07,   9.345749282778451e-09,   2.773306923010335e-11,  -5.343864713205487e-12,
   1.699881530029068e-13,  -2.287260898556550e-15,  -5.001787084940065e-17,   4.084000485221990e-01,  -5.513814618639056e-03,   7.387516360990208e-05,  -9.432755866428079e-07,
   9.334240655410123e-09,   2.823661447410367e-11,  -5.352475314273621e-12,   1.697117986098325e-13,  -2.263026456168385e-15,  -5.077065691257933e-17,   4.084173323595264e-01,
  -5.514475485555828e-03,   7.388814950203728e-05,  -9.432033078049479e-07,   9.315334363729947e-09,   2.906265556894270e-11,  -5.366541118030230e-12,   1.692553608717311e-13,
  -2.223224707477619e-15,  -5.200248382390280e-17,   4.084356729392565e-01,  -5.515176696692464e-03,   7.390191883725575e-05,  -9.431259133571885e-07,   9.295255694615192e-09,
   2.993831683775492e-11,  -5.381371009527112e-12,   1.687673059747120e-13,  -2.180969480068231e-15,  -5.330410310259888e-17,   4.084501078625739e-01,  -5.515728539182477e-03,
   7.391274834999586e-05,  -9.430644962421666e-07,   9.279440956698347e-09,   3.062686179237234e-11,  -5.392973400481780e-12,   1.683805033870385e-13,  -2.147698572844199e-15,
  -5.432452912067869e-17,   4.084584388559333e-01,  -5.516047012496160e-03,   7.391899545591179e-05,  -9.430288479730753e-07,   9.270308878792238e-09,   3.102399117238407e-11,
  -5.399641777874320e-12,   1.681561915556442e-13,  -2.128491093198682e-15,  -5.491184710606145e-17,   4.084615672866574e-01,  -5.516166601297500e-03,   7.392134077360644e-05,
  -9.430154232878440e-07,   9.266878733737945e-09,   3.117307110315454e-11,  -5.402140604498627e-12,   1.680717562614151e-13,  -2.121277342163620e-15,  -5.513208983616464e-17,
   4.084620858719880e-01,  -5.516186424795268e-03,   7.392172951547929e-05,  -9.430131959283019e-07,   9.266310087550283e-09,   3.119778080114431e-11,  -5.402554545626152e-12,
   1.680577491486235e-13,  -2.120081499375848e-15,  -5.516858232869727e-17,   6.481992059263684e-01,  -8.749697455387850e-03,   1.170423418714417e-04,  -1.476918693119302e-06,
   1.335276238589946e-08,   1.255908971526598e-10,  -1.193448302185934e-11,   3.797733209684131e-13,  -5.986996286286770e-15,  -6.497715206642137e-17,   6.482158845425624e-01,
  -8.750327317566043e-03,   1.170535970446330e-04,  -1.476730443477115e-06,   1.332701669815496e-08,   1.267196806826937e-10,  -1.195735090701739e-11,   3.793941892605800e-13,
  -5.939478570119616e-15,  -6.670543655793243e-17,   6.482432663253017e-01,  -8.751361277981953e-03,   1.170720582595192e-04,  -1.476420242791165e-06,   1.328471622913739e-08,
   1.285719126587634e-10,  -1.199475484635448e-11,   3.787654290032353e-13,  -5.861375291204501e-15,  -6.953669717167234e-17,   6.482723220548047e-01,  -8.752458307769497e-03,
   1.170916253145270e-04,  -1.476089521972555e-06,   1.323978504255378e-08,   1.305361127526102e-10,  -1.203425643837478e-11,   3.780896422739863e-13,  -5.778373416717285e-15,
  -7.253268492355242e-17,   6.482951901821732e-01,  -8.753321616362518e-03,   1.171070089540884e-04,  -1.475828103780500e-06,   1.320438993838687e-08,   1.320811019286582e-10,
  -1.206520897909106e-11,   3.775515606921709e-13,  -5.712958588105006e-15,  -7.488457047143814e-17,   6.483083882725923e-01,  -8.753819824686190e-03,   1.171158808427228e-04,
  -1.475676777722857e-06,   1.318394912325597e-08,   1.329724040904604e-10,  -1.208301797517171e-11,   3.772385276745031e-13,  -5.675169877815891e-15,  -7.623948351346602e-17,
   6.483133443712341e-01,  -8.754006902333654e-03,   1.171192111320065e-04,  -1.475619867014182e-06,   1.317627082538371e-08,   1.333070321750488e-10,  -1.208969515872326e-11,
   3.771205093520415e-13,  -5.660972973197808e-15,  -7.674781063031616e-17,   6.483141659199789e-01,  -8.754037912892266e-03,   1.171197631121732e-04,  -1.475610428698899e-06,
   1.317499790219237e-08,   1.333624981489083e-10,  -1.209080145549353e-11,   3.771009212714433e-13,  -5.658619271626147e-15,  -7.683204902448284e-17,   1.001655100485817e+00,
  -1.351632855479811e-02,   1.801161944844311e-04,  -2.203633980874701e-06,   1.464724503282820e-08,   5.428497554490291e-10,  -3.436120323991331e-11,   1.154060286430276e-12,
  -2.422644914360885e-14,   1.288487385450745e-16,   1.001680756636079e+00,  -1.351726649652333e-02,   1.801282784642924e-04,  -2.202832272562530e-06,   1.457277639350893e-08,
   5.463066176887553e-10,  -3.445579847494282e-11,   1.154579166169930e-12,  -2.413373247035214e-14,   1.235964812142920e-16,   1.001722876534912e+00,  -1.351880602547448e-02,
   1.801480699604437e-04,  -2.201512579762795e-06,   1.445037915945812e-08,   5.519826453043156e-10,  -3.461082088415736e-11,   1.155411483406670e-12,  -2.398083332576451e-14,
   1.149661318343148e-16,   1.001767570598674e+00,  -1.352043923861702e-02,   1.801690072761474e-04,  -2.200107446370349e-06,   1.432030952008953e-08,   5.580067243295282e-10,
  -3.477494227253102e-11,   1.156268107975722e-12,  -2.381765967711885e-14,   1.057980371197190e-16,   1.001802746215009e+00,  -1.352172433491052e-02,   1.801854394078495e-04,
  -2.198998096222319e-06,   1.421780178645086e-08,   5.627486835228126e-10,  -3.490383838172223e-11,   1.156923056667581e-12,  -2.368856480792775e-14,   9.857511072120730e-17,
   1.001823047212646e+00,  -1.352246588832858e-02,   1.801949044026904e-04,  -2.198356464333570e-06,   1.415858561069736e-08,   5.654857466675883e-10,  -3.497811902429202e-11,
   1.157293332356478e-12,  -2.361379092427852e-14,   9.440361225073470e-17,   1.001830670526296e+00,  -1.352274432994350e-02,   1.801984551401514e-04,  -2.198115259749646e-06,
   1.413633858935090e-08,   5.665136132951336e-10,  -3.500599173129123e-11,   1.157430917199284e-12,  -2.358566146866805e-14,   9.283660903583896e-17,   1.001831934204249e+00,
  -1.352279048462037e-02,   1.801990435430258e-04,  -2.198075262634337e-06,   1.413265025973970e-08,   5.666840006927129e-10,  -3.501061095375388e-11,   1.157453646962735e-12,
  -2.358099591320035e-14,   9.257682616878492e-17,   4.365583915381076e-03,  -5.594823734337346e-05,   7.153267851975377e-07,  -9.004866129965113e-09,   1.045979415420879e-10,
  -8.036946590711355e-13,  -9.770101339749497e-15,   6.650195010826224e-16,  -1.686454173586829e-17,   1.550985182454539e-19,   4.365685890988384e-03,  -5.595208569680660e-05,
   7.154159725239947e-07,  -9.005992961426895e-09,   1.045763003973241e-10,  -8.016959687937543e-13,  -9.836365937016399e-15,   6.657370031003795e-16,  -1.681988761397987e-17,
   1.522308052454110e-19,   4.365853309610330e-03,  -5.595840373572714e-05,   7.155623743540392e-07,  -9.007840777268499e-09,   1.045406712195417e-10,  -7.984132956033373e-13,
  -9.945019268773740e-15,   6.669042559598655e-16,  -1.674620979928364e-17,   1.475197748001605e-19,   4.366030966155112e-03,  -5.596510813045141e-05,   7.157176994929151e-07,
  -9.009798651653860e-09,   1.045027277518644e-10,  -7.949281001434224e-13,  -1.006013059600012e-14,   6.681283307078749e-16,  -1.666752887665175e-17,   1.425167073506542e-19,
   4.366170791801258e-03,  -5.597038486227026e-05,   7.158399277591542e-07,  -9.011337480412326e-09,   1.044727661025666e-10,  -7.921837764198927e-13,  -1.015059429573508e-14,
   6.690812018965351e-16,  -1.660524308794616e-17,   1.385762086375159e-19,   4.366251491528076e-03,  -5.597343030276012e-05,   7.159104626877470e-07,  -9.012224755176817e-09,
   1.044554346167230e-10,  -7.905993929352697e-13,  -1.020275059738689e-14,   6.696269191825559e-16,  -1.656915128290871e-17,   1.363008619517706e-19,   4.366281795760690e-03,
  -5.597457392152402e-05,   7.159369482342594e-07,  -9.012557781907150e-09,   1.044489189084204e-10,  -7.900043318317988e-13,  -1.022232594791221e-14,   6.698310467944361e-16,
  -1.655557098742384e-17,   1.354462205105053e-19,   4.366286819157031e-03,  -5.597476349405265e-05,   7.159413385388370e-07,  -9.012612977742082e-09,   1.044478384376062e-10,
  -7.899056861771280e-13,  -1.022557032189586e-14,   6.698648419417918e-16,  -1.655331841094115e-17,   1.353045395814662e-19,   3.960306395853214e-02,  -5.075410712385147e-04,
   6.488877871789852e-06,  -8.165613383704062e-08,   9.464244277086890e-10,  -7.151390676933821e-12,  -9.482596425660789e-14,   6.247288864427431e-15,  -1.585185612797290e-16,
   1.494303124977267e-18,   3.960398899616525e-02,  -5.075759674037640e-04,   6.489684778277610e-06,  -8.166615214044440e-08,   9.462146219770517e-10,  -7.132611487792653e-12,
  -9.544906311012220e-14,   6.254228684522574e-15,  -1.581105676197236e-16,   1.467681324938686e-18,   3.960550767799810e-02,  -5.076332581625307e-04,   6.491009314083653e-06,
  -8.168257944676646e-08,   9.458692351359312e-10,  -7.101767885416350e-12,  -9.647078575332961e-14,   6.265522705170909e-15,  -1.574372993313485e-16,   1.423945254402237e-18,
   3.960711922939688e-02,  -5.076940522356446e-04,   6.492414569521753e-06,  -8.169998376846487e-08,   9.455014536838300e-10,  -7.069020817176896e-12,  -9.755328290395551e-14,
   6.277372170485704e-15,  -1.567181877428700e-16,   1.377494958191101e-18,   3.960838761033594e-02,  -5.077419004929661e-04,   6.493520382776789e-06,  -8.171366199849218e-08,
   9.452110678113538e-10,  -7.043234587538969e-12,  -9.840402971909688e-14,   6.286600430526786e-15,  -1.561488311542859e-16,   1.340907748741510e-18,   3.960911965045376e-02,
  -5.077695158605482e-04,   6.494158516972431e-06,  -8.172154832922647e-08,   9.450431039387221e-10,  -7.028347222616465e-12,  -9.889453627061586e-14,   6.291887208783961e-15,
  -1.558188788832359e-16,   1.319780464154672e-18,   3.960939454497311e-02,  -5.077798859328904e-04,   6.494398132821347e-06,  -8.172450827993438e-08,   9.449799607022443e-10,
  -7.022755808997787e-12,  -9.907863620770931e-14,   6.293865067444468e-15,  -1.556947207078761e-16,   1.311844693502216e-18,   3.960944011300027e-02,  -5.077816049327999e-04,
   6.494437852056283e-06,  -8.172499885790125e-08,   9.449694900552194e-10,  -7.021828896322041e-12,  -9.910914864750404e-14,   6.294192536499795e-15,  -1.556741261187063e-16,
   1.310529106915288e-18,   1.118428291617312e-01,  -1.433332491466100e-03,   1.832325530941987e-05,  -2.304025225196288e-07,   2.657675825679699e-09,  -1.933333407894297e-11,
  -3.063055282081271e-13,   1.898438556696637e-14,  -4.826061885293650e-16,   4.785420226007190e-18,   1.118454412511448e-01,  -1.433430950780639e-03,   1.832552070682144e-05,
  -2.304295529664175e-07,   2.656999465463732e-09,  -1.927624653679898e-11,  -3.082041058317116e-13,   1.900677996448164e-14,  -4.814395560209239e-16,   4.706504644785292e-18,
   1.118497296511805e-01,  -1.433592595912759e-03,   1.832923929884706e-05,  -2.304738689570957e-07,   2.655886194563824e-09,  -1.918248110677608e-11,  -3.113175078081155e-13,
   1.904325095523554e-14,  -4.795137725534604e-16,   4.576842127050031e-18,   1.118542802910696e-01,  -1.433764125070643e-03,   1.833318443456642e-05,  -2.305208116235672e-07,
   2.654700967738971e-09,  -1.908292522238824e-11,  -3.146164026010503e-13,   1.908155101755605e-14,  -4.774560299722656e-16,   4.439112851690871e-18,   1.118578618973599e-01,
  -1.433899127505816e-03,   1.833628885798034e-05,  -2.305576977883860e-07,   2.653765322900493e-09,  -1.900452850429049e-11,  -3.172092592537724e-13,   1.911140469159081e-14,
  -4.758262143378928e-16,   4.330614040031182e-18,   1.118599290040888e-01,  -1.433977043289983e-03,   1.833808031317674e-05,  -2.305789622753567e-07,   2.653224196256739e-09,
  -1.895926599095036e-11,  -3.187042840031467e-13,   1.912851806029565e-14,  -4.748814688817232e-16,   4.267955605260208e-18,   1.118607052405526e-01,  -1.434006302053611e-03,
   1.833875299058376e-05,  -2.305869429082677e-07,   2.653020780982542e-09,  -1.894226603135610e-11,  -3.192654224315207e-13,   1.913492241215563e-14,  -4.745259245071508e-16,
   4.244418927358739e-18,   1.118608339137717e-01,  -1.434011152144758e-03,   1.833886449481244e-05,  -2.305882655806150e-07,   2.652987050552221e-09,  -1.893944786373045e-11,
  -3.193584255227206e-13,   1.913598287028634e-14,  -4.744669466465184e-16,   4.240516975401880e-18,   2.251528856406118e-01,  -2.885426898885259e-03,   3.688004361643013e-05,
  -4.631163865881921e-07,   5.296743912291457e-09,  -3.584748360439770e-11,  -7.549354119882143e-13,   4.309240793655901e-14,  -1.100882542876371e-15,   1.182178360241081e-17,
   2.251581430173751e-01,  -2.885624789614452e-03,   3.688455676228726e-05,  -4.631663046385753e-07,   5.295080975449207e-09,  -3.571781935220808e-11,  -7.592722513968518e-13,
   4.314834729640335e-14,  -1.098508259164017e-15,   1.164983066665603e-17,   2.251667743151326e-01,  -2.885949674429240e-03,   3.689196477924894e-05,  -4.632481194668650e-07,
   5.292344331050432e-09,  -3.550483668015442e-11,  -7.663848996212241e-13,   4.323954185243276e-14,  -1.094586477658747e-15,   1.136724398516058e-17,   2.251759334183045e-01,
  -2.886294422904437e-03,   3.689982383890143e-05,  -4.633347495072917e-07,   5.289431488268871e-09,  -3.527868623946035e-11,  -7.739224509334819e-13,   4.333543733971465e-14,
  -1.090392581079241e-15,   1.106699672523137e-17,   2.251831421361175e-01,  -2.886565756646810e-03,   3.690600793106732e-05,  -4.634027961137440e-07,   5.287132516826715e-09,
  -3.510058986659405e-11,  -7.798476223196757e-13,   4.341027796418278e-14,  -1.087068409934887e-15,   1.083041355931679e-17,   2.251873026106971e-01,  -2.886722354614438e-03,
   3.690957647849665e-05,  -4.634420143360863e-07,   5.285803111899546e-09,  -3.499776115121000e-11,  -7.832643705074307e-13,   4.345321741604943e-14,  -1.085140537550496e-15,
   1.069376283472039e-17,   2.251888649447785e-01,  -2.886781159834120e-03,   3.691091642539501e-05,  -4.634567311859002e-07,   5.285303411436789e-09,  -3.495913930976501e-11,
  -7.845468660458211e-13,   4.346929385752131e-14,  -1.084414821796143e-15,   1.064242772006350e-17,   2.251891239258357e-01,  -2.886790907700373e-03,   3.691113853664883e-05,
  -4.634591701877322e-07,   5.285220552786997e-09,  -3.495273673168904e-11,  -7.847594301885873e-13,   4.347195623836861e-14,  -1.084294430129956e-15,   1.063391706376778e-17,
   3.874496526092754e-01,  -4.965207076611199e-03,   6.344437522494405e-05,  -7.948616716543964e-07,   8.956738829631830e-09,  -5.250039233542773e-11,  -1.718667608845790e-12,
   8.923829827521927e-14,  -2.307390033386025e-15,   2.784190720715578e-17,   3.874586965456203e-01,  -4.965546676048525e-03,   6.345200143086038e-05,  -7.949341121567655e-07,
   8.952962054390001e-09,  -5.223158993914048e-11,  -1.727777360213963e-12,   8.937196327363509e-14,  -2.303375796973191e-15,   2.750853601678520e-17,   3.874735444121965e-01,
  -4.966104205322572e-03,   6.346451871734470e-05,  -7.950527576132025e-07,   8.946747856816280e-09,  -5.179002443224317e-11,  -1.742720643690416e-12,   8.959015563861560e-14,
  -2.296735753964783e-15,   2.696046397145900e-17,   3.874893002080960e-01,  -4.966695816605715e-03,   6.347779730714735e-05,  -7.951782725103443e-07,   8.940135082602866e-09,
  -5.132110633113479e-11,  -1.758560441461757e-12,   8.981998727178352e-14,  -2.289622246550943e-15,   2.637785252406091e-17,   3.875017008710149e-01,  -4.967161439212995e-03,
   6.348824529304156e-05,  -7.952767802385481e-07,   8.934917024119148e-09,  -5.095178919969195e-11,  -1.771014668185141e-12,   8.999964307381378e-14,  -2.283974773284084e-15,
   2.591856975275623e-17,   3.875088578441938e-01,  -4.967430167698156e-03,   6.349427409317787e-05,  -7.953335214401077e-07,   8.931900063318040e-09,  -5.073853876003536e-11,
  -1.778197504648916e-12,   9.010283534899089e-14,  -2.280695842656224e-15,   2.565320432163949e-17,   3.875115454170246e-01,  -4.967531079535583e-03,   6.349653779036318e-05,
  -7.953548076175241e-07,   8.930766122042723e-09,  -5.065844029680017e-11,  -1.780893832585450e-12,   9.014149229802522e-14,  -2.279460857475360e-15,   2.555349968439675e-17,
   3.875119909237626e-01,  -4.967547807202442e-03,   6.349691302122123e-05,  -7.953583350135599e-07,   8.930578100056879e-09,  -5.064516173368776e-11,  -1.781340740072289e-12,
   9.014789534512294e-14,  -2.279255945127777e-15,   2.553696919796631e-17,   6.149661194837568e-01,  -7.880512754903233e-03,   1.006425752407446e-04,  -1.255528028459649e-06,
   1.374647857298970e-08,  -5.546649374493830e-11,  -4.033342456535559e-12,   1.902382200514537e-13,  -5.066545119318780e-15,   7.272333142791621e-17,   6.149804651630205e-01,
  -7.881049028236237e-03,   1.006542623399533e-04,  -1.255602108531200e-06,   1.373763060865984e-08,  -5.489232606797383e-11,  -4.053421228536797e-12,   1.905938929501331e-13,
  -5.061375299303040e-15,   7.209637360907722e-17,   6.150040171119270e-01,  -7.881929429448566e-03,   1.006734430691106e-04,  -1.255723130052062e-06,   1.372307432360957e-08,
  -5.394897967238189e-11,  -4.086368274091177e-12,   1.911754483117422e-13,  -5.052780199800219e-15,   7.106476709864216e-17,   6.150290091734495e-01,  -7.882863632635673e-03,
   1.006937877713806e-04,  -1.255850737006568e-06,   1.370758697114573e-08,  -5.294698988133166e-11,  -4.121306388227313e-12,   1.917893395099535e-13,  -5.043513423363332e-15,
   6.996696800527710e-17,   6.150486792323890e-01,  -7.883598876701656e-03,   1.007097936960857e-04,  -1.255950580283805e-06,   1.369536793834336e-08,  -5.215767773157298e-11,
  -4.148787349814634e-12,   1.922701661113906e-13,  -5.036114257337058e-15,   6.910069955449661e-17,   6.150600316790347e-01,  -7.884023208920883e-03,   1.007190288357194e-04,
  -1.256007967559681e-06,   1.368830391126175e-08,  -5.170185398053637e-11,  -4.164640885718045e-12,   1.925467337699215e-13,  -5.031801517681565e-15,   6.859984289440014e-17,
   6.150642947246511e-01,  -7.884182551490596e-03,   1.007224963077578e-04,  -1.256029472767208e-06,   1.368564899630726e-08,  -5.153063171635151e-11,  -4.170592856810442e-12,
   1.926504123613033e-13,  -5.030174003618565e-15,   6.841159350469215e-17,   6.150650013901779e-01,  -7.884208964886751e-03,   1.007230710689943e-04,  -1.256033035226617e-06,
   1.368520878469265e-08,  -5.150224622766536e-11,  -4.171579418346040e-12,   1.926675893197139e-13,  -5.029903795913926e-15,   6.838037937201822e-17,   9.503105741182555e-01,
  -1.217660693464597e-02,   1.553182625676004e-04,  -1.917736362393238e-06,   1.945023854901625e-08,   2.521481350967250e-11,  -1.172078497361073e-11,   5.138877615720030e-13,
  -1.492228635471124e-14,   2.887875852027193e-16,   9.503327101485085e-01,  -1.217742548257632e-02,   1.553347239122782e-04,  -1.917687297276414e-06,   1.942451040509406e-08,
   2.677367627884137e-11,  -1.178043512940816e-11,   5.153389575533899e-13,  -1.493174084685985e-14,   2.877438756896728e-16,   9.503690516952553e-01,  -1.217876924327604e-02,
   1.553617317707984e-04,  -1.917605135928131e-06,   1.938218136140009e-08,   2.933591783727790e-11,  -1.187838615563441e-11,   5.177173895748685e-13,  -1.494698516758760e-14,
   2.860203406620141e-16,   9.504076151547817e-01,  -1.218019505222570e-02,   1.553903672796533e-04,  -1.917515762401785e-06,   1.933714173875767e-08,   3.205888440020702e-11,
  -1.198235417492367e-11,   5.202357130015488e-13,  -1.496278395116127e-14,   2.841777938395082e-16,   9.504379664426633e-01,  -1.218131715303814e-02,   1.554128876829209e-04,
  -1.917443835083026e-06,   1.930160462863469e-08,   3.420493248153177e-11,  -1.206420212082250e-11,   5.222137376981550e-13,  -1.497494461803834e-14,   2.827177549927843e-16,
   9.504554834225930e-01,  -1.218196473194280e-02,   1.554258782693517e-04,  -1.917401686663664e-06,   1.928105910896079e-08,   3.544468379890115e-11,  -1.211144790530396e-11,
   5.233537221679984e-13,  -1.498185319774199e-14,   2.818711534725745e-16,   9.504620613471201e-01,  -1.218220790285071e-02,   1.554307551571345e-04,  -1.917385738916391e-06,
   1.927333718925486e-08,   3.591045413866955e-11,  -1.212919099353089e-11,   5.237814998662120e-13,  -1.498442671189139e-14,   2.815524932806157e-16,   9.504631517388261e-01,
  -1.218224821183479e-02,   1.554315635074141e-04,  -1.917383088985679e-06,   1.927205680794944e-08,   3.598767444280627e-11,  -1.213213226039206e-11,   5.238523944167773e-13,
  -1.498485221493999e-14,   2.814996310789748e-16,   4.152590308819253e-03,  -5.063068313973247e-05,   6.167529137168500e-07,  -7.467318137044953e-09,   8.739864901411436e-11,
  -8.693988259804682e-13,   2.346780891686770e-15,   2.407115281537655e-16,  -9.404772972456561e-18,   2.054576230626503e-19,   4.152678227410018e-03,  -5.063387545014300e-05,
   6.168275641551507e-07,  -7.468549126976574e-09,   8.740321042186876e-11,  -8.686629088254141e-13,   2.309088043181106e-15,   2.417497525486468e-16,  -9.415454271612396e-18,
   2.049286465750140e-19,   4.152822567692361e-03,  -5.063911652287069e-05,   6.169501176072086e-07,  -7.470569232404633e-09,   8.741064044172407e-11,  -8.674525485706637e-13,
   2.247179274828387e-15,   2.434521642148155e-16,  -9.432831519915017e-18,   2.040545471099381e-19,   4.152975734335476e-03,  -5.064467822047120e-05,   6.170801599095353e-07,
  -7.472711681115846e-09,   8.741844504941669e-11,  -8.661652301601439e-13,   2.181448958433795e-15,   2.452558225158502e-16,  -9.451055381040960e-18,   2.031193211747839e-19,
   4.153096284853217e-03,  -5.064905567802550e-05,   6.171825064887641e-07,  -7.474397046057735e-09,   8.742452994152373e-11,  -8.651499099879766e-13,   2.129689851988221e-15,
   2.466733239151064e-16,  -9.465241993143821e-18,   2.023776954713271e-19,   4.153165859946685e-03,  -5.065158214358881e-05,   6.172415737396548e-07,  -7.475369400776386e-09,
   8.742801864657954e-11,  -8.645630700964418e-13,   2.099807098923588e-15,   2.474905921511671e-16,  -9.473366907246280e-18,   2.019474465405248e-19,   4.153191986659289e-03,
  -5.065253088472908e-05,   6.172637542754385e-07,  -7.475734472457096e-09,   8.742932434104772e-11,  -8.643425398602621e-13,   2.088583650643597e-15,   2.477973330237617e-16,
  -9.476406081113000e-18,   2.017854601876920e-19,   4.153196317566112e-03,  -5.065268815364065e-05,   6.172674310270420e-07,  -7.475794985296014e-09,   8.742954054914915e-11,
  -8.643059750604441e-13,   2.086723088764700e-15,   2.478481717142597e-16,  -9.476909244365240e-18,   2.017585862892473e-19,   3.767086425014485e-02,  -4.593035327674844e-04,
   5.594879847761649e-06,  -6.773130834751522e-08,   7.920958874319039e-10,  -7.841181816063003e-12,   1.908430241369364e-14,   2.269397842770250e-15,  -8.798502238605641e-17,
   1.927414558120926e-18,   3.767166180313707e-02,  -4.593324879587717e-04,   5.595556379098998e-06,  -6.774240821064918e-08,   7.921324324275089e-10,  -7.834244385712539e-12,
   1.873160935846863e-14,   2.279141478445428e-15,  -8.808796883657502e-17,   1.922599806490631e-18,   3.767297118510875e-02,  -4.593800260041360e-04,   5.596667036031833e-06,
  -6.776062323266142e-08,   7.921918816919030e-10,  -7.822834510570849e-12,   1.815231852148487e-14,   2.295119003342451e-15,  -8.825551052046331e-17,   1.914642357901581e-18,
   3.767436063525874e-02,  -4.594304721815641e-04,   5.597845557581107e-06,  -6.777994098202556e-08,   7.922542206610607e-10,  -7.810699285989942e-12,   1.753725692706488e-14,
   2.312047507947177e-15,  -8.843129655312227e-17,   1.906126570068736e-18,   3.767545420838021e-02,  -4.594701769448121e-04,   5.598773080870725e-06,  -6.779513704987920e-08,
   7.923027448517527e-10,  -7.801128208117838e-12,   1.705292021942040e-14,   2.325352228330652e-15,  -8.856819950251641e-17,   1.899372284381051e-18,   3.767608535829237e-02,
  -4.594930926852368e-04,   5.599308380923088e-06,  -6.780390414774238e-08,   7.923305338312500e-10,  -7.795596303177518e-12,   1.677328839684044e-14,   2.333023358654889e-15,
  -8.864663044062410e-17,   1.895453298379415e-18,   3.767632236655447e-02,  -4.595016980278485e-04,   5.599509392964596e-06,  -6.780719574111788e-08,   7.923409281719535e-10,
  -7.793517459444376e-12,   1.666826283768155e-14,   2.335902564302547e-15,  -8.867597264019607e-17,   1.893977721143041e-18,   3.767636165434040e-02,  -4.595031244999711e-04,
   5.599542713669288e-06,  -6.780774134138879e-08,   7.923426490355584e-10,  -7.793172779142517e-12,   1.665085224030329e-14,   2.336379760965030e-15,  -8.868083075690224e-17,
   1.893732914283335e-18,   1.063861401754694e-01,  -1.297114086088880e-03,   1.579993142283702e-05,  -1.912207777531427e-07,   2.232321158293327e-09,  -2.186271876063211e-11,
   4.026555311443846e-14,   6.941477230653820e-15,  -2.651512992303835e-16,   5.844495067709562e-18,   1.063883924556303e-01,  -1.297195831699577e-03,   1.580183788606557e-05,
  -1.912517104498193e-07,   2.232394469428867e-09,  -2.184150267520207e-11,   3.920226830035942e-14,   6.971048483391437e-15,  -2.654812279349928e-16,   5.830849251272485e-18,
   1.063920901342950e-01,  -1.297330039856095e-03,   1.580496769531178e-05,  -1.913024694606237e-07,   2.232513177473132e-09,  -2.180660940683100e-11,   3.745578870089925e-14,
   7.019542744306977e-15,  -2.660185506601936e-16,   5.808287298527731e-18,   1.063960139239103e-01,  -1.297472458000193e-03,   1.580828872042131e-05,  -1.913562987355426e-07,
   2.232636900707682e-09,  -2.176949853500014e-11,   3.560138787115346e-14,   7.070928264043386e-15,  -2.665828287340959e-16,   5.784129835582195e-18,   1.063991021601077e-01,
  -1.297584551177681e-03,   1.581090242445595e-05,  -1.913986409387888e-07,   2.232732652611279e-09,  -2.174022956434065e-11,   3.414106429487138e-14,   7.111317538156932e-15,
  -2.670226681445261e-16,   5.764960439061775e-18,   1.064008845190316e-01,  -1.297649246089195e-03,   1.581241085998239e-05,  -1.914230687369577e-07,   2.232787263761154e-09,
  -2.172331282429149e-11,   3.329792385765517e-14,   7.134606290408727e-15,  -2.672748024879219e-16,   5.753834373378429e-18,   1.064015538271656e-01,  -1.297673540379871e-03,
   1.581297729549501e-05,  -1.914322399696925e-07,   2.232807648072095e-09,  -2.171695568839662e-11,   3.298124856807527e-14,   7.143347528286653e-15,  -2.673691588534056e-16,
   5.749644516153196e-18,   1.064016647753411e-01,  -1.297677567543646e-03,   1.581307119044546e-05,  -1.914337601458067e-07,   2.232811020588868e-09,  -2.171590165255163e-11,
   3.292875154119447e-14,   7.144796306534496e-15,  -2.673847827484021e-16,   5.748949359214086e-18,   2.141680181121266e-01,  -2.611234540852977e-03,   3.180524697884288e-05,
  -3.847442476963477e-07,   4.477656913254780e-09,  -4.301816680975294e-11,   3.260894088414429e-14,   1.588285867968293e-14,  -5.942516066774562e-16,   1.324843337113108e-17,
   2.141725519212509e-01,  -2.611399011395660e-03,   3.180907041921431e-05,  -3.848050549361901e-07,   4.477698170585334e-09,  -4.296963036343669e-11,   3.022433360763047e-14,
   1.594998958485159e-14,  -5.950675699741105e-16,   1.322115027721829e-17,   2.141799952962091e-01,  -2.611669035084432e-03,   3.181534723199422e-05,  -3.849048294955950e-07,
   4.477762213238775e-09,  -4.288980541655034e-11,   2.630731813763706e-14,   1.606009210658972e-14,  -5.963978122024397e-16,   1.317600293118575e-17,   2.141878938271908e-01,
  -2.611955576461176e-03,   3.182200743683906e-05,  -3.850106294818263e-07,   4.477825153309427e-09,  -4.280490869456340e-11,   2.214795531905188e-14,   1.617677769594765e-14,
  -5.977966542017258e-16,   1.312761217560222e-17,   2.141941103998458e-01,  -2.612181104394921e-03,   3.182724906753875e-05,  -3.850938449434882e-07,   4.477871055601452e-09,
  -4.273795251165726e-11,   1.887227720983882e-14,   1.626850670566280e-14,  -5.988883794907060e-16,   1.308917677214311e-17,   2.141976982607234e-01,  -2.612311268334774e-03,
   3.183027412059689e-05,  -3.851418502770065e-07,   4.477896090383869e-09,  -4.269925389442839e-11,   1.698092615408412e-14,   1.632140377057492e-14,  -5.995147550473780e-16,
   1.306685406857396e-17,   2.141990455675018e-01,  -2.612360147579233e-03,   3.183141005909911e-05,  -3.851598729863652e-07,   4.477905215873887e-09,  -4.268471142901395e-11,
   1.627053666306682e-14,   1.634125927055341e-14,  -5.997492691328488e-16,   1.305844505164645e-17,   2.141992689044333e-01,  -2.612368250087009e-03,   3.183159835721713e-05,
  -3.851628603094301e-07,   4.477906714028705e-09,  -4.268230024020715e-11,   1.615277056583297e-14,   1.634455018795340e-14,  -5.997881064608267e-16,   1.305704973261447e-17,
   3.685468451235563e-01,  -4.493459910900808e-03,   5.472595993039993e-05,  -6.614828186222781e-07,   7.657783312206683e-09,  -7.109782763470019e-11,  -8.826350408605653e-14,
   3.310199424083139e-14,  -1.209034502537048e-15,   2.751351158919504e-17,   3.685546461756312e-01,  -4.493742666748688e-03,   5.473249705964056e-05,  -6.615831399681452e-07,
   7.657537151214169e-09,  -7.099667317826988e-11,  -9.312060160778611e-14,   3.324173830724861e-14,  -1.210958268200061e-15,   2.746915543888739e-17,   3.685674535376812e-01,
  -4.494206887003268e-03,   5.474322864526922e-05,  -6.617477287253451e-07,   7.657125523386971e-09,  -7.083031071673923e-11,  -1.010997523410623e-13,   3.347098110491468e-14,
  -1.214098755979434e-15,   2.739561392218875e-17,   3.685810440527563e-01,  -4.494699502373570e-03,   5.475461545349631e-05,  -6.619222272874988e-07,   7.656678536739606e-09,
  -7.065337833825338e-11,  -1.095736120568870e-13,   3.371399331811897e-14,  -1.217406982072768e-15,   2.731659732245935e-17,   3.685917405213634e-01,  -4.495087223510416e-03,
   5.476357676031344e-05,  -6.620594550267281e-07,   7.656319354423455e-09,  -7.051383569777288e-11,  -1.162478939011504e-13,   3.390507599523732e-14,  -1.219993112580147e-15,
   2.725369904212610e-17,   3.685979139278520e-01,  -4.495310997081990e-03,   5.476874843646818e-05,  -6.621386102881361e-07,   7.656109095234721e-09,  -7.043318434175437e-11,
  -1.201018735835325e-13,   3.401528533598254e-14,  -1.221478609909357e-15,   2.721711395146356e-17,   3.686002321535189e-01,  -4.495395028573904e-03,   5.477069043912473e-05,
  -6.621683260172397e-07,   7.656029579686683e-09,  -7.040287655108246e-11,  -1.215494813239053e-13,   3.405665710190503e-14,  -1.222035102936016e-15,   2.720332197592895e-17,
   3.686006164352511e-01,  -4.495408958117323e-03,   5.477101235316595e-05,  -6.621732514099757e-07,   7.656016369240817e-09,  -7.039785141917826e-11,  -1.217894641106434e-13,
   3.406351438068047e-14,  -1.222127279639730e-15,   2.720103291475089e-17,   5.849640634858808e-01,  -7.132009172762500e-03,   8.684648036894796e-05,  -1.048205298778702e-06,
   1.201643670169311e-08,  -1.041922003351441e-10,  -5.751941967019774e-13,   7.037017388401993e-14,  -2.515054786566270e-15,   5.955881343940783e-17,   5.849764429952858e-01,
  -7.132457191742109e-03,   8.685673283291631e-05,  -1.048351750990592e-06,   1.201508846536040e-08,  -1.039770510854201e-10,  -5.853192148182172e-13,   7.067392713950530e-14,
  -2.520073603131216e-15,   5.950917994667901e-17,   5.849967670173770e-01,  -7.133192732189192e-03,   8.687356304184772e-05,  -1.048591952688345e-06,   1.201285944086653e-08,
  -1.036231935752831e-10,  -6.019553416896198e-13,   7.117239233800458e-14,  -2.528280835447629e-15,   5.942622136742025e-17,   5.850183338079848e-01,  -7.133973258282556e-03,
   8.689142000670539e-05,  -1.048846521387519e-06,   1.201047295607116e-08,  -1.032468331765413e-10,  -6.196269027622882e-13,   7.170103450512478e-14,  -2.536945801132525e-15,
   5.933618763826749e-17,   5.850353080225748e-01,  -7.134587580433189e-03,   8.690547266785453e-05,  -1.049046647992847e-06,   1.200857933609599e-08,  -1.029499912011494e-10,
  -6.335484802746782e-13,   7.211688231376913e-14,  -2.543733573829046e-15,   5.926387606679738e-17,   5.850451045894264e-01,  -7.134942135392056e-03,   8.691358238567027e-05,
  -1.049162056567857e-06,   1.200748029720556e-08,  -1.027784196621733e-10,  -6.415884799952807e-13,   7.235679672895732e-14,  -2.547638238313220e-15,   5.922156042152878e-17,
   5.850487833762638e-01,  -7.135075277636425e-03,   8.691662759946432e-05,  -1.049205376915038e-06,   1.200706642611758e-08,  -1.027139440424410e-10,  -6.446086339113229e-13,
   7.244687186104351e-14,  -2.549102076822032e-15,   5.920556022110350e-17,   5.850493931919842e-01,  -7.135097348044928e-03,   8.691713238375929e-05,  -1.049212557000310e-06,
   1.200699775927329e-08,  -1.027032537113061e-10,  -6.451093232213342e-13,   7.246180230377777e-14,  -2.549344602228912e-15,   5.920290214195111e-17,   9.039509103551868e-01,
  -1.102086193282850e-02,   1.341510682573300e-04,  -1.613744053565950e-06,   1.806651861916615e-08,  -1.284502361977876e-10,  -2.593813546119194e-12,   1.823485229536001e-13,
  -6.526352106266936e-15,   1.701276626127877e-16,   9.039700319912817e-01,  -1.102155150385415e-02,   1.341664609379229e-04,  -1.613922115699842e-06,   1.806066753113102e-08,
  -1.278912936937842e-10,  -2.620224036393647e-12,   1.832242336477733e-13,  -6.545938950781762e-15,   1.702847950720378e-16,   9.040014248303554e-01,  -1.102268360015644e-02,
   1.341917268037436e-04,  -1.614213852764148e-06,   1.805102105956552e-08,  -1.269718049158672e-10,  -2.663637278439245e-12,   1.846624117781111e-13,  -6.578048105614062e-15,
   1.705395015579771e-16,   9.040347372044892e-01,  -1.102388491493979e-02,   1.342185307833040e-04,  -1.614522617980704e-06,   1.804072968704460e-08,  -1.259935812288741e-10,
  -2.709778320233950e-12,   1.861891806984950e-13,  -6.612055820233035e-15,   1.708053368082212e-16,   9.040609557713034e-01,  -1.102483040884253e-02,   1.342396219838159e-04,
  -1.614765044745525e-06,   1.803258994219630e-08,  -1.252218491493137e-10,  -2.746146702233909e-12,   1.873912942088058e-13,  -6.638774519654432e-15,   1.710113379223249e-16,
   9.040760876414949e-01,  -1.102537609302375e-02,   1.342517926524186e-04,  -1.614904723974301e-06,   1.802787613746271e-08,  -1.247757197668742e-10,  -2.767157690250019e-12,
   1.880852714940535e-13,  -6.654176065300767e-15,   1.711289352392121e-16,   9.040817699268920e-01,  -1.102558100685667e-02,   1.342563625801606e-04,  -1.614957131408633e-06,
   1.802610299370627e-08,  -1.246080524031868e-10,  -2.775051696933072e-12,   1.883459071218134e-13,  -6.659956023278245e-15,   1.711728501275317e-16,   9.040827118532391e-01,
  -1.102561497446834e-02,   1.342571200963497e-04,  -1.614965816395130e-06,   1.802580890811486e-08,  -1.245802516806816e-10,  -2.776360461556676e-12,   1.883891133264772e-13,
  -6.660913950464073e-15,   1.711801167665792e-16,   3.959399961802336e-03,  -4.603261109362270e-05,   5.349764439400897e-07,  -6.203221856782068e-09,   7.097092688307174e-11,
  -7.599676000095556e-13,   5.864493241178915e-15,   4.084633185849455e-17,  -3.653404520268373e-18,   1.122130184824990e-19,   3.959476214883170e-03,  -4.603526320237785e-05,
   5.350371118819214e-07,  -6.204302229241937e-09,   7.098326847301569e-11,  -7.598362744905334e-13,   5.849643498259302e-15,   4.142518217770137e-17,  -3.667516275110295e-18,
   1.123629334861666e-19,   3.959601402911404e-03,  -4.603961740136017e-05,   5.351367156901286e-07,  -6.206075696596855e-09,   7.100350612429471e-11,  -7.596194295184593e-13,
   5.825224737126335e-15,   4.237599922403185e-17,  -3.690659042765069e-18,   1.126071145926089e-19,   3.959734245587209e-03,  -4.604423799590651e-05,   5.352424133003410e-07,
  -6.207957293067496e-09,   7.102494845355562e-11,  -7.593876368396344e-13,   5.799259533073701e-15,   4.338562033207298e-17,  -3.715182560704952e-18,   1.128635838553008e-19,
   3.959838799627515e-03,  -4.604787475599197e-05,   5.353256053057900e-07,  -6.209437981646695e-09,   7.104180093038094e-11,  -7.592039809760055e-13,   5.778784981673641e-15,
   4.418072342185333e-17,  -3.734458846042319e-18,   1.130635217941223e-19,   3.959899142276585e-03,  -4.604997373278391e-05,   5.353736200155132e-07,  -6.210292460587145e-09,
   7.105151769652351e-11,  -7.590974948522086e-13,   5.766952774141206e-15,   4.463980277675714e-17,  -3.745573959293167e-18,   1.131781452023642e-19,   3.959921802007829e-03,
  -4.605076194428263e-05,   5.353916505788367e-07,  -6.210613315434518e-09,   7.105516471253386e-11,  -7.590574147247171e-13,   5.762506650251327e-15,   4.481223117484388e-17,
  -3.749745973266870e-18,   1.132210427580054e-19,   3.959925558207238e-03,  -4.605089260293131e-05,   5.353946394324545e-07,  -6.210666501164102e-09,   7.105576916654446e-11,
  -7.590507659353384e-13,   5.761769482692504e-15,   4.484081573261824e-17,  -3.750437448067758e-18,   1.132281460062599e-19,   3.591830937822539e-02,  -4.175918169189511e-04,
   4.853097719127797e-06,  -5.627083033806735e-08,   6.436067942748447e-10,  -6.880362907129946e-12,   5.249325157200371e-14,   4.003129380722596e-16,  -3.417717179078967e-17,
   1.047375214284726e-18,   3.591900111605956e-02,  -4.176158747274648e-04,   4.853647883642600e-06,  -5.628061069048846e-08,   6.437171927385189e-10,  -6.879080158570630e-12,
   5.235432926788366e-14,   4.057168205259278e-16,  -3.430940508601718e-17,   1.048811645772501e-18,   3.592013677238925e-02,  -4.176553725302433e-04,   4.854551135364034e-06,
  -5.629666536687580e-08,   6.438982138939117e-10,  -6.876962622249237e-12,   5.212588623090374e-14,   4.145933526978450e-16,  -3.452627048032813e-17,   1.051151970298492e-18,
   3.592134186862857e-02,  -4.176972868514128e-04,   4.855509647098080e-06,  -5.631369877127423e-08,   6.440899977330756e-10,  -6.874699849293518e-12,   5.188297496257556e-14,
   4.240190492488199e-16,  -3.475608487065989e-17,   1.053610986626175e-18,   3.592229034152891e-02,  -4.177302766105915e-04,   4.856264067312507e-06,  -5.632710280678981e-08,
   6.442407197973732e-10,  -6.872907515929343e-12,   5.169142951956524e-14,   4.314421686708905e-16,  -3.493673396539425e-17,   1.055528654647550e-18,   3.592283774616612e-02,
  -4.177493168354428e-04,   4.856699484585199e-06,  -5.633483799763948e-08,   6.443276190541857e-10,  -6.871868506288012e-12,   5.158073547327235e-14,   4.357282095768651e-16,
  -3.504090305561577e-17,   1.056628315982361e-18,   3.592304330628084e-02,  -4.177564668540742e-04,   4.856862993129041e-06,  -5.633774253642275e-08,   6.443602344390400e-10,
  -6.871477474609709e-12,   5.153914052598833e-14,   4.373380400111464e-16,  -3.508000308242652e-17,   1.057039913561149e-18,   3.592307738103535e-02,  -4.177576520838686e-04,
   4.856890097275813e-06,  -5.633822399989931e-08,   6.443656400536927e-10,  -6.871412609440795e-12,   5.153224407898665e-14,   4.376049124388246e-16,  -3.508648359969632e-17,
   1.057108071229217e-18,   1.014367641090890e-01,  -1.179318664732980e-03,   1.370546973403522e-05,  -1.588980165877958e-07,   1.816279574015528e-09,  -1.934612306470534e-11,
   1.438926729962302e-13,   1.314360389154707e-15,  -1.029381205492078e-16,   3.141481192531717e-18,   1.014387176202392e-01,  -1.179386598929638e-03,   1.370702226313719e-05,
  -1.589255119513612e-07,   1.816581746103860e-09,  -1.934193579950835e-11,   1.434742159362231e-13,   1.330575233912891e-15,  -1.033381516277653e-16,   3.146031350853748e-18,
   1.014419247850115e-01,  -1.179498132387265e-03,   1.370957117589153e-05,  -1.589706456267734e-07,   1.817077160474538e-09,  -1.933502662395171e-11,   1.427861023305307e-13,
   1.357210980794130e-15,  -1.039942600026294e-16,   3.153448991298554e-18,   1.014453280522721e-01,  -1.179616489529812e-03,   1.371227602050485e-05,  -1.590185299263092e-07,
   1.817601949012782e-09,  -1.932764772863292e-11,   1.420544005137795e-13,   1.385495823964370e-15,  -1.046896111832027e-16,   3.161248630258384e-18,   1.014480065990223e-01,
  -1.179709645566020e-03,   1.371440492911907e-05,  -1.590562107486188e-07,   1.818014319257528e-09,  -1.932180592913361e-11,   1.414774185532550e-13,   1.407772175022666e-15,
  -1.052362509485281e-16,   3.167335440356468e-18,   1.014495525038792e-01,  -1.179763411080267e-03,   1.371563363668325e-05,  -1.590779553299268e-07,   1.818252048956540e-09,
  -1.931842065003854e-11,   1.411439787621628e-13,   1.420634691120592e-15,  -1.055514835239259e-16,   3.170827560836401e-18,   1.014501330184618e-01,  -1.179783601197561e-03,
   1.371609504233987e-05,  -1.590861203035276e-07,   1.818341270172868e-09,  -1.931714682335347e-11,   1.410186833611229e-13,   1.425465899868584e-15,  -1.056698102318248e-16,
   3.172134970856507e-18,   1.014502292476929e-01,  -1.179786948031842e-03,   1.371617152765702e-05,  -1.590874737471963e-07,   1.818356057299352e-09,  -1.931693553007800e-11,
   1.409979093481502e-13,   1.426266805415435e-15,  -1.056894221332218e-16,   3.172351486098652e-18,   2.042043576473469e-01,  -2.374106865544371e-03,   2.759024839400090e-05,
  -3.198243421471804e-07,   3.651754171360427e-09,  -3.864919292581277e-11,   2.743299777262575e-13,   3.298130306812440e-15,  -2.301855662123287e-16,   6.988374888573906e-18,
   2.042082902192383e-01,  -2.374243599585899e-03,   2.759336967175286e-05,  -3.198792541667505e-07,   3.652328614385864e-09,  -3.863875920240069e-11,   2.733940556882078e-13,
   3.334226242010081e-15,  -2.310889579030221e-16,   6.999432404206671e-18,   2.042147464942136e-01,  -2.374468087574427e-03,   2.759849410544506e-05,  -3.199693901638126e-07,
   3.653270201647763e-09,  -3.862155239947721e-11,   2.718549931871290e-13,   3.393523666358910e-15,  -2.325708373017294e-16,   7.017473809194760e-18,   2.042215975383091e-01,
  -2.374706309689183e-03,   2.760393200236735e-05,  -3.200650164699404e-07,   3.654267320291561e-09,  -3.860318838195377e-11,   2.702184039865614e-13,   3.456497095086151e-15,
  -2.341416052727527e-16,   7.036465566753848e-18,   2.042269896626923e-01,  -2.374893808403000e-03,   2.760821200059240e-05,  -3.201402640141224e-07,   3.655050623896222e-09,
  -3.858865882449527e-11,   2.689278490362712e-13,   3.506096634495298e-15,  -2.353766258511305e-16,   7.051302200652823e-18,   2.042301016900606e-01,  -2.375002024253944e-03,
   2.761068220933495e-05,  -3.201836864781210e-07,   3.655502108334277e-09,  -3.858024266358883e-11,   2.681820226086370e-13,   3.534737120818303e-15,  -2.360889036782826e-16,
   7.059820548244252e-18,   2.042312703112780e-01,  -2.375042661643987e-03,   2.761160982336349e-05,  -3.201999912187146e-07,   3.655671536408099e-09,  -3.857707647544182e-11,
   2.679017642725909e-13,   3.545494853962129e-15,  -2.363562806427596e-16,   7.063010915640454e-18,   2.042314640282381e-01,  -2.375049397939631e-03,   2.761176359004196e-05,
  -3.202026939192195e-07,   3.655699615793985e-09,  -3.857655132652421e-11,   2.678552972566082e-13,   3.547278257443220e-15,  -2.364005974222214e-16,   7.063539323613685e-18,
   3.514011468832594e-01,  -4.085428023157128e-03,   4.747671134539369e-05,  -5.502017561727882e-07,   6.270666271788472e-09,  -6.564468045901877e-11,   4.270136411220147e-13,
   7.612023547779215e-15,  -4.652404264702828e-16,   1.406416848975605e-17,   3.514079139453428e-01,  -4.085663245689177e-03,   4.748207054205743e-05,  -5.502949704212575e-07,
   6.271555243536456e-09,  -6.562076867650480e-11,   4.251211677972496e-13,   7.684753073180590e-15,  -4.671058132757649e-16,   1.408961386354890e-17,   3.514190237253164e-01,
  -4.086049430271251e-03,   4.749086907241267e-05,  -5.504479716199113e-07,   6.273011694165245e-09,  -6.558135608059496e-11,   4.220090045881424e-13,   7.804243015436303e-15,
  -4.701663321231158e-16,   1.413117907599077e-17,   3.514308128113280e-01,  -4.086459241000244e-03,   4.750020572838422e-05,  -5.506102835476021e-07,   6.274553100096429e-09,
  -6.553932205730436e-11,   4.186994744380238e-13,   7.931156581908484e-15,  -4.734112898703418e-16,   1.417500033520752e-17,   3.514400914276096e-01,  -4.086781792460473e-03,
   4.750755425725290e-05,  -5.507379990780949e-07,   6.275763294440373e-09,  -6.550608587845438e-11,   4.160895849883609e-13,   8.031128758858266e-15,  -4.759632691530427e-16,
   1.420928274358221e-17,   3.514454465164314e-01,  -4.086967954543640e-03,   4.751179544977473e-05,  -5.508116962401689e-07,   6.276460557533160e-09,  -6.548684239715154e-11,
   4.145812543083006e-13,   8.088860837104322e-15,  -4.774353312833741e-16,   1.422898538835931e-17,   3.514474574467263e-01,  -4.087037862398060e-03,   4.751338809993420e-05,
  -5.508393683705629e-07,   6.276722166661504e-09,  -6.547960451262180e-11,   4.140144619570168e-13,   8.110546631839173e-15,  -4.779879656510570e-16,   1.423636833228960e-17,
   3.514477907893798e-01,  -4.087049450738520e-03,   4.751365210661460e-05,  -5.508439553226639e-07,   6.276765520504655e-09,  -6.547840410887197e-11,   4.139204869554499e-13,
   8.114141722464974e-15,  -4.780795653267823e-16,   1.423759133772489e-17,   5.577503096097239e-01,  -6.484443215834940e-03,   7.535188566289372e-05,  -8.728336860777035e-07,
   9.914718973825260e-09,  -1.016939299904239e-10,   5.454114545480058e-13,   1.787879222192480e-14,  -9.504315561010984e-16,   2.878143716187037e-17,   5.577610497735418e-01,
  -6.484816357278827e-03,   7.536035759898301e-05,  -8.729779305569971e-07,   9.915837123444784e-09,  -1.016381129463624e-10,   5.415413819658335e-13,   1.802795389271584e-14,
  -9.544316671115283e-16,   2.884556161655046e-17,   5.577786823635917e-01,  -6.485428973765049e-03,   7.537426632893632e-05,  -8.732146728128059e-07,   9.917666731875297e-09,
  -1.015461569332936e-10,   5.351765199023297e-13,   1.827306165237363e-14,  -9.609969460338921e-16,   2.895047327214161e-17,   5.577973930909454e-01,  -6.486079067563350e-03,
   7.538902548281099e-05,  -8.734657950882687e-07,   9.919599902983505e-09,  -1.014481448237721e-10,   5.284072666377031e-13,   1.853345822092544e-14,  -9.679610642133561e-16,
   2.906130327288228e-17,   5.578121193908182e-01,  -6.486590738492687e-03,   7.540064167637553e-05,  -8.736633718944737e-07,   9.921115385080266e-09,  -1.013706902258841e-10,
   5.230685050463513e-13,   1.873862156134192e-14,  -9.734402714859965e-16,   2.914817161294472e-17,   5.578206185708308e-01,  -6.486886051303613e-03,   7.540734587362475e-05,
  -8.737773741386569e-07,   9.921987618377510e-09,  -1.013258618997085e-10,   5.199828629163772e-13,   1.885711729016318e-14,  -9.766017806129652e-16,   2.919816217498180e-17,
   5.578238101625356e-01,  -6.486996947510360e-03,   7.540986341634354e-05,  -8.738201787253814e-07,   9.922314700309134e-09,  -1.013090042603903e-10,   5.188233158864490e-13,
   1.890163097197552e-14,  -9.777888348320942e-16,   2.921690708257571e-17,   5.578243392179785e-01,  -6.487015330318566e-03,   7.541028073772015e-05,  -8.738272739666175e-07,
   9.922368895056039e-09,  -1.013062085907761e-10,   5.186310591218283e-13,   1.890901066701495e-14,  -9.779855994919562e-16,   2.922001289146441e-17,   8.618978963381025e-01,
  -1.002040910598742e-02,   1.164286552007684e-04,  -1.347238227521136e-06,   1.518768170601829e-08,  -1.481710122579226e-10,   3.519166708279532e-13,   4.998139214749472e-14,
  -2.327510450716386e-15,   7.242510886086171e-17,   8.619144910763579e-01,  -1.002098501169966e-02,   1.164416266702037e-04,  -1.347447768079973e-06,   1.518831965167975e-08,
  -1.480156025436669e-10,   3.424102771941799e-13,   5.035872525374510e-14,  -2.338689631695045e-15,   7.265995893733712e-17,   8.619417353604978e-01,  -1.002193051850685e-02,
   1.164629217947302e-04,  -1.347791600453679e-06,   1.518935215184983e-08,  -1.477596532024319e-10,   3.267717395606617e-13,   5.097904501102561e-14,  -2.357052066989961e-15,
   7.304507525428808e-17,   8.619706454669414e-01,  -1.002293386177346e-02,   1.164855180494708e-04,  -1.348156212042872e-06,   1.519042758483092e-08,  -1.474869568538848e-10,
   3.101341908622723e-13,   5.163842883908936e-14,  -2.376549538541140e-15,   7.345312785953409e-17,   8.619933991870096e-01,  -1.002372356150468e-02,   1.165033017655366e-04,
  -1.348443002807111e-06,   1.519125936037662e-08,  -1.472715357919396e-10,   2.970085905985470e-13,   5.215821858557624e-14,  -2.391903866313085e-15,   7.377384047936698e-17,
   8.620065313306738e-01,  -1.002417933803152e-02,   1.165135652327502e-04,  -1.348608450919376e-06,   1.519173353647091e-08,  -1.471468880919976e-10,   2.894208142275601e-13,
   5.245854038817695e-14,  -2.400769021908699e-15,   7.395875789784090e-17,   8.620114626807908e-01,  -1.002435049144386e-02,   1.165174192924714e-04,  -1.348670566135445e-06,
   1.519191048627211e-08,  -1.471000203715867e-10,   2.865691210740571e-13,   5.257137863181091e-14,  -2.404098705419446e-15,   7.402816358155526e-17,   8.620122801279124e-01,
  -1.002437886282470e-02,   1.165180581593895e-04,  -1.348680861977906e-06,   1.519193975975994e-08,  -1.470922481430584e-10,   2.860962850882113e-13,   5.259008658362347e-14,
  -2.404650686539696e-15,   7.403966684205067e-17,   3.783383489495742e-03,  -4.203235445193860e-05,   4.668747668649843e-07,  -5.181441206142715e-09,   5.721717694581186e-11,
  -6.155388918059417e-13,   5.867767174353242e-15,  -2.660511147970546e-17,  -9.662778071364033e-19,   4.416212695570597e-20,   3.783450027593401e-03,  -4.203456962043670e-05,
   4.669236920841146e-07,  -5.182317799883399e-09,   5.722965450933474e-11,  -6.156147027235816e-13,   5.863759589712149e-15,  -2.637432338710594e-17,  -9.738520841659058e-19,
   4.433153143642808e-20,   3.783559265696331e-03,  -4.203820644878382e-05,   4.670040184370270e-07,  -5.183756946853051e-09,   5.725013218276680e-11,  -6.157386571582252e-13,
   5.857158627077771e-15,  -2.599482178293560e-17,  -9.862951429663966e-19,   4.460941261890811e-20,   3.783675182626622e-03,  -4.204206577274877e-05,   4.670892613520672e-07,
  -5.185284096675029e-09,   5.727185204178504e-11,  -6.158695001298280e-13,   5.850124767077036e-15,  -2.559129146950170e-17,  -9.995099052648523e-19,   4.490395970004029e-20,
   3.783766414827388e-03,  -4.204510334744961e-05,   4.671563555359791e-07,  -5.186486046438968e-09,   5.728893949068233e-11,  -6.159719796753271e-13,   5.844567547413091e-15,
  -2.527309609373567e-17,  -1.009918434858691e-18,   4.513554618739507e-20,   3.783819068705795e-03,  -4.204685649802196e-05,   4.671950799321198e-07,  -5.187179745072862e-09,
   5.729879850379488e-11,  -6.160309241887414e-13,   5.841351731537486e-15,  -2.508921295958824e-17,  -1.015928771720245e-18,   4.526910904256739e-20,   3.783838841137124e-03,
  -4.204751484368455e-05,   4.672096219006957e-07,  -5.187440241454710e-09,   5.730250019046672e-11,  -6.160530209103179e-13,   5.840142528038605e-15,  -2.502011646393893e-17,
  -1.018186348544420e-18,   4.531924609596385e-20,   3.783842118720493e-03,  -4.204762397496664e-05,   4.672120324703514e-07,  -5.187483422756366e-09,   5.730311377316751e-11,
  -6.160566817778089e-13,   5.839941999110185e-15,  -2.500866027537307e-17,  -1.018560607708136e-18,   4.532755612495255e-20,   3.432154902186703e-02,  -3.813029761254477e-04,
   4.235320626464216e-06,  -4.700354760183710e-08,   5.189954996922499e-10,  -5.580054601325197e-12,   5.302075903458859e-14,  -2.320062541025604e-16,  -9.115855615601915e-18,
   4.116653865254712e-19,   3.432215263154628e-02,  -3.813230710507000e-04,   4.235764406164550e-06,  -4.701149396068765e-08,   5.191082273333047e-10,  -5.580713473929813e-12,
   5.298296923906019e-14,  -2.298547563318909e-16,  -9.186456569320245e-18,   4.132505586007109e-19,   3.432314360030260e-02,  -3.813560625770101e-04,   4.236493011811541e-06,
  -4.702453985847611e-08,   5.192932289187289e-10,  -5.581790445063196e-12,   5.292072736707880e-14,  -2.263168699458831e-16,  -9.302441973309696e-18,   4.158508696815871e-19,
   3.432419515696920e-02,  -3.813910724721777e-04,   4.237266213083217e-06,  -4.703838346373348e-08,   5.194894494302108e-10,  -5.582926834164818e-12,   5.285440680976964e-14,
  -2.225549463058057e-16,  -9.425623125627559e-18,   4.186072536549782e-19,   3.432502278264922e-02,  -3.814186278590569e-04,   4.237874794856819e-06,  -4.704927910294234e-08,
   5.196438176060699e-10,  -5.583816567720277e-12,   5.280201143817582e-14,  -2.195885379065720e-16,  -9.522647827572278e-18,   4.207745364740379e-19,   3.432550043967543e-02,
  -3.814345315799056e-04,   4.238226046675645e-06,  -4.705556744890376e-08,   5.197328830454173e-10,  -5.584328200385790e-12,   5.277169254303232e-14,  -2.178742599209028e-16,
  -9.578674822602526e-18,   4.220245081554371e-19,   3.432567980805270e-02,  -3.814405037682430e-04,   4.238357950400321e-06,  -4.705792883431251e-08,   5.197663235652541e-10,
  -5.584519973662439e-12,   5.276029227681103e-14,  -2.172300958207310e-16,  -9.599719577140030e-18,   4.224937312627372e-19,   3.432570954110878e-02,  -3.814414937535994e-04,
   4.238379815603658e-06,  -4.705832027032572e-08,   5.197718665758071e-10,  -5.584551744365261e-12,   5.275840171650528e-14,  -2.171232934203487e-16,  -9.603208365814735e-18,
   4.225715035851742e-19,   9.692736098223569e-02,  -1.076836131579104e-03,   1.196091640128907e-05,  -1.327382921803740e-07,   1.465333347764320e-09,  -1.573474975531965e-11,
   1.484507996989854e-13,  -5.977509439442011e-16,  -2.790379127522066e-17,   1.230988788580573e-18,   9.692906562819416e-02,  -1.076892879642008e-03,   1.196216935438968e-05,
  -1.327606980023644e-07,   1.465648853164839e-09,  -1.573643301959843e-11,   1.483352269811572e-13,  -5.913162757935681e-16,  -2.811495696669348e-17,   1.235770048131956e-18,
   9.693186420966510e-02,  -1.076986047691382e-03,   1.196422647401732e-05,  -1.327974824747295e-07,   1.466166625703732e-09,  -1.573918238803108e-11,   1.481448860117998e-13,
  -5.807350634849456e-16,  -2.846187820930049e-17,   1.243613777538519e-18,   9.693483389658626e-02,  -1.077084915598065e-03,   1.196640950099682e-05,  -1.328365159311496e-07,
   1.466715776366743e-09,  -1.574208065632398e-11,   1.479420905603374e-13,  -5.694835850476963e-16,  -2.883033853984933e-17,   1.251929066499129e-18,   9.693717118301005e-02,
  -1.077162731970347e-03,   1.196812774584431e-05,  -1.328672371170107e-07,   1.467147782293336e-09,  -1.574434781825802e-11,   1.477818889573709e-13,  -5.606112487933549e-16,
  -2.912057115285849e-17,   1.258467752049289e-18,   9.693852012770558e-02,  -1.077207644050395e-03,   1.196911945514906e-05,  -1.328849675736747e-07,   1.467397029663148e-09,
  -1.574565070843390e-11,   1.476891926582098e-13,  -5.554838928360209e-16,  -2.928817088924902e-17,   1.262239137954229e-18,   9.693902667949170e-02,  -1.077224509499054e-03,
   1.196949186633153e-05,  -1.328916256608829e-07,   1.467490610961359e-09,  -1.574613891015267e-11,   1.476543387459288e-13,  -5.535572050586433e-16,  -2.935112527082799e-17,
   1.263654909789386e-18,   9.693911064820944e-02,  -1.077227305215799e-03,   1.196955359957932e-05,  -1.328927293406978e-07,   1.467506122684896e-09,  -1.574621978135238e-11,
   1.476485588088539e-13,  -5.532377596374991e-16,  -2.936156186273381e-17,   1.263889571974577e-18,   1.951263953862450e-01,  -2.167799488028106e-03,   2.407863050428287e-05,
  -2.672033777871785e-07,   2.948642533934542e-09,  -3.159280605094391e-11,   2.943528006385372e-13,  -1.001227900555674e-15,  -6.381912062029060e-17,   2.722225930037261e-18,
   1.951298270224247e-01,  -2.167913721960943e-03,   2.408115172580374e-05,  -2.672483597987468e-07,   2.949267712285452e-09,  -3.159557012285068e-11,   2.940887901306324e-13,
  -9.869935459026788e-16,  -6.428676238437273e-17,   2.732970174809928e-18,   1.951354608686612e-01,  -2.168101269340735e-03,   2.408529110391074e-05,  -2.673222078006249e-07,
   2.950293631242471e-09,  -3.160007686043231e-11,   2.936540237814965e-13,  -9.635858407960669e-16,  -6.505509008519541e-17,   2.750598438997383e-18,   1.951414391684493e-01,
  -2.168300290486660e-03,   2.408968382705545e-05,  -2.674005699583564e-07,   2.951381648799901e-09,  -3.160481676850639e-11,   2.931908668365338e-13,  -9.386945107229824e-16,
  -6.587118228936931e-17,   2.769289453014818e-18,   1.951461443777663e-01,  -2.168456934845117e-03,   2.409314130184866e-05,  -2.674622440680373e-07,   2.952237516713070e-09,
  -3.160851659057824e-11,   2.928250296318121e-13,  -9.190658616169232e-16,  -6.651405499064405e-17,   2.783989179664548e-18,   1.951488599486825e-01,  -2.168547342847555e-03,
   2.409513682988459e-05,  -2.674978384723780e-07,   2.952731291129756e-09,  -3.161063958794576e-11,   2.926133643449094e-13,  -9.077221401559510e-16,  -6.688531070512099e-17,
   2.792468554944566e-18,   1.951498796919603e-01,  -2.168581292987289e-03,   2.409588619917852e-05,  -2.675112047267877e-07,   2.952916677358395e-09,  -3.161143447919567e-11,
   2.925337810614349e-13,  -9.034595036863770e-16,  -6.702476643850472e-17,   2.795651860845310e-18,   1.951500487300283e-01,  -2.168586920763549e-03,   2.409601041937782e-05,
  -2.675134203854015e-07,   2.952947406144443e-09,  -3.161156612161661e-11,   2.925205836713384e-13,  -9.027527547374314e-16,  -6.704788562171215e-17,   2.796179497908275e-18,
   3.357795280937928e-01,  -3.730414302316587e-03,   4.143488918158770e-05,  -4.597699611763496e-07,   5.070540874195714e-09,  -5.412645942672828e-11,   4.934847850911203e-13,
  -1.131336056293724e-15,  -1.324393384107290e-16,   5.416343175961939e-18,   3.357854333013504e-01,  -3.730610860462103e-03,   4.143922456096334e-05,  -4.598470113990335e-07,
   5.071587744407416e-09,  -5.412938631454677e-11,   4.929376403067657e-13,  -1.102997175479614e-15,  -1.333741529296164e-16,   5.438353142734966e-18,   3.357951281024361e-01,
  -3.730933566260135e-03,   4.144634243204866e-05,  -4.599735046339540e-07,   5.073305496801406e-09,  -5.413412967792264e-11,   4.920367133183462e-13,  -1.056392917740455e-15,
  -1.349101912202616e-16,   5.474472515308182e-18,   3.358054156435105e-01,  -3.731276014389095e-03,   4.145389591865643e-05,  -4.601077275368955e-07,   5.075127001244711e-09,
  -5.413907894122399e-11,   4.910770880564183e-13,  -1.006831599178321e-15,  -1.365419290526662e-16,   5.512779277525434e-18,   3.358135124325210e-01,  -3.731545546278942e-03,
   4.145984118579910e-05,  -4.602133643938351e-07,   5.076559690525206e-09,  -5.414291327941970e-11,   4.903191975173713e-13,  -9.677465268035019e-16,  -1.378274741509921e-16,
   5.542913162403106e-18,   3.358181854242222e-01,  -3.731701107788318e-03,   4.146327256958292e-05,  -4.602743305737129e-07,   5.077386184497780e-09,  -5.414510177115420e-11,
   4.898807370775063e-13,  -9.451576850741925e-16,  -1.385699306990662e-16,   5.560298440189912e-18,   3.358199402124232e-01,  -3.731759524455898e-03,   4.146456113628827e-05,
  -4.602972241843210e-07,   5.077696477052721e-09,  -5.414591896054769e-11,   4.897158890831399e-13,  -9.366692874193601e-16,  -1.388488330493026e-16,   5.566825722600294e-18,
   3.358202310954445e-01,  -3.731769207948296e-03,   4.146477473719452e-05,  -4.603010191386995e-07,   5.077747909099217e-09,  -5.414605417806250e-11,   4.896885525241992e-13,
  -9.352618941806938e-16,  -1.388950705111391e-16,   5.567907656848109e-18,   5.329554416106843e-01,  -5.920976666238828e-03,   6.576522010546745e-05,  -7.296389095738920e-07,
   8.038018918133859e-09,  -8.523076408580507e-11,   7.457516182395015e-13,  -6.870642366657306e-17,  -2.774479765894364e-16,   1.082321534363914e-17,   5.329648143044984e-01,
  -5.921288593649586e-03,   6.577209225539654e-05,  -7.297601924398468e-07,   8.039597150670624e-09,  -8.523006083348022e-11,   7.446067474832383e-13,  -1.200856380566649e-17,
  -2.793410045316504e-16,   1.086976713703399e-17,   5.329802018070376e-01,  -5.921800710415290e-03,   6.578337497167047e-05,  -7.299592967955090e-07,   8.042186287493626e-09,
  -8.522878304864322e-11,   7.427217854425954e-13,   8.124251041364036e-17,  -2.824520971287096e-16,   1.094618735904388e-17,   5.329965300998888e-01,  -5.922344156768167e-03,
   6.579534812336629e-05,  -7.301705603446083e-07,   8.044931128019557e-09,  -8.522725946397558e-11,   7.407142535760851e-13,   1.804233553711443e-16,  -2.857577930455125e-16,
   1.102727179124257e-17,   5.330093812497441e-01,  -5.922771888745385e-03,   6.580477201025686e-05,  -7.303368246830271e-07,   8.047089566175570e-09,  -8.522593877376363e-11,
   7.391289234400497e-13,   2.586487985057836e-16,  -2.883627068294455e-16,   1.109108286003212e-17,   5.330167981792635e-01,  -5.923018756001527e-03,   6.581021110174883e-05,
  -7.304327785908417e-07,   8.048334534032872e-09,  -8.522512777289748e-11,   7.382118356584679e-13,   3.038622124361962e-16,  -2.898673795648474e-16,   1.112790822101038e-17,
   5.330195833629084e-01,  -5.923111459902348e-03,   6.581225360688990e-05,  -7.304688101420223e-07,   8.048801897689401e-09,  -8.522481400309904e-11,   7.378670511291625e-13,
   3.208531478635827e-16,  -2.904326495084913e-16,   1.114173625761398e-17,   5.330200450497525e-01,  -5.923126827048106e-03,   6.581259218516141e-05,  -7.304747828822948e-07,
   8.048879362824498e-09,  -8.522476150413814e-11,   7.378098765804409e-13,   3.236703164461958e-16,  -2.905263642943265e-16,   1.114402843890665e-17,   8.235822694415983e-01,
  -9.149736646843357e-03,   1.016245019448250e-04,  -1.127132729754918e-06,   1.238726208263680e-08,  -1.293559326980794e-10,   1.019260717387924e-12,   6.211013916110007e-15,
  -6.838990589500349e-16,   2.557356267251878e-17,   8.235967526490056e-01,  -9.150218494333890e-03,   1.016350908547017e-04,  -1.127316635862311e-06,   1.238940414347695e-08,
  -1.293352167072958e-10,   1.016438605074060e-12,   6.345416450404540e-15,  -6.885644732839764e-16,   2.569958803159505e-17,   8.236205302697583e-01,  -9.151009581702441e-03,
   1.016524755756926e-04,  -1.127618525300483e-06,   1.239291627713876e-08,  -1.293009155333170e-10,   1.011792147584297e-12,   6.566527753412182e-15,  -6.962351371005878e-16,
   2.590662873142661e-17,   8.236457616471577e-01,  -9.151849063642888e-03,   1.016709238895842e-04,  -1.127938822988896e-06,   1.239663692293577e-08,  -1.292641212164210e-10,
   1.006843526363292e-12,   6.801780006254829e-15,  -7.043901037973866e-16,   2.612651746699295e-17,   8.236656199483390e-01,  -9.152509796162273e-03,   1.016854440980912e-04,
  -1.128190876856585e-06,   1.239956073790929e-08,  -1.292348752079602e-10,   1.002935620091597e-12,   6.987385535121699e-15,  -7.108195382691229e-16,   2.629971702304268e-17,
   8.236770809930367e-01,  -9.152891140194352e-03,   1.016938245104728e-04,  -1.128336333172023e-06,   1.240124638089936e-08,  -1.292178809001694e-10,   1.000674948748658e-12,
   7.094686892136668e-15,  -7.145346713251930e-16,   2.639973215727952e-17,   8.236813848107106e-01,  -9.153034342899427e-03,   1.016969715361613e-04,  -1.128390951777472e-06,
   1.240187902589581e-08,  -1.292114774518590e-10,   9.998250338783340e-13,   7.135014552671910e-15,  -7.159306062739759e-16,   2.643729982391235e-17,   8.236820982343894e-01,
  -9.153058081020659e-03,   1.016974932058577e-04,  -1.128400005503981e-06,   1.240198387840451e-08,  -1.292104148320190e-10,   9.996840950113666e-13,   7.141701282795041e-15,
  -7.161620481278371e-16,   2.644352778146046e-17,   3.622351077132253e-03,  -3.853138978633028e-05,   4.098080430960521e-07,  -4.357101184079097e-09,   4.624146198362380e-11,
  -4.859570107834071e-13,   4.874404850391243e-15,  -3.945002924142838e-17,  -1.872160995986888e-20,   1.317138200512362e-20,   3.622409475346183e-03,  -3.853325237572204e-05,
   4.098475850364782e-07,  -4.357793721503439e-09,   4.625186522352098e-11,  -4.860737851504630e-13,   4.874268083992697e-15,  -3.938022316782170e-17,  -2.170946106958429e-20,
   1.325798135131565e-20,   3.622505349545185e-03,  -3.853631033167476e-05,   4.099125059529154e-07,  -4.358930753443240e-09,   4.626894358176948e-11,  -4.862653368772965e-13,
   4.874034906582007e-15,  -3.926530361635142e-17,  -2.662289053649134e-20,   1.340026940481094e-20,   3.622607085025597e-03,  -3.853955535019385e-05,   4.099814007907476e-07,
  -4.360137394779864e-09,   4.628706470130075e-11,  -4.864683806993381e-13,   4.873775713553826e-15,  -3.914292778432948e-17,  -3.184781533441248e-20,   1.355141221969584e-20,
   3.622687155398663e-03,  -3.854210940746674e-05,   4.100356277093871e-07,  -4.361087145490439e-09,   4.630132586671913e-11,  -4.866280268157771e-13,   4.873563192308253e-15,
  -3.904630054768561e-17,  -3.596810668399607e-20,   1.367048086124998e-20,   3.622733367186363e-03,  -3.854358348830537e-05,   4.100669256575617e-07,  -4.361635312330193e-09,
   4.630955616168145e-11,  -4.867201013091515e-13,   4.873437117470093e-15,  -3.899040802220842e-17,  -3.834931256057876e-20,   1.373924504276658e-20,   3.622750720476429e-03,
  -3.854413703627975e-05,   4.100786788270966e-07,  -4.361841163335384e-09,   4.631264669968615e-11,  -4.867546647685507e-13,   4.873389127407326e-15,  -3.896939580036912e-17,
  -3.924410362912522e-20,   1.376507560764805e-20,   3.622753597048699e-03,  -3.854422879562191e-05,   4.100806271084366e-07,  -4.361875286555763e-09,   4.631315899955843e-11,
  -4.867603935534904e-13,   4.873381138188075e-15,  -3.896591145634577e-17,  -3.939246100300737e-20,   1.376935786424548e-20,   3.286071863983265e-02,  -3.495434599601243e-04,
   3.717635613544616e-06,  -3.952594196244576e-08,   4.194712928723916e-10,  -4.407389626081248e-12,   4.416064937739875e-14,  -3.551597218963007e-16,  -2.773884560326606e-19,
   1.231256912701481e-19,   3.286124840803091e-02,  -3.495603566475026e-04,   3.717994310587655e-06,  -3.953222286487343e-08,   4.195655378096807e-10,  -4.408440534262366e-12,
   4.415896571537321e-14,  -3.545072644094863e-16,  -3.051854382155019e-19,   1.239319403238957e-19,   3.286211814527383e-02,  -3.495880972354542e-04,   3.718583228009611e-06,
  -3.954253505958404e-08,   4.197202532249035e-10,  -4.410164346711189e-12,   4.415612120565846e-14,  -3.534331557130420e-16,  -3.508970804734416e-19,   1.252566775959592e-19,
   3.286304105401221e-02,  -3.496175347816422e-04,   3.719208193975614e-06,  -3.955347855797410e-08,   4.198844142260971e-10,  -4.411991506855021e-12,   4.415299342222932e-14,
  -3.522893717526331e-16,  -3.995071789191959e-19,   1.266638827799711e-19,   3.286376742446363e-02,  -3.496407041956003e-04,   3.719700102720099e-06,  -3.956209220719028e-08,
   4.200136068381249e-10,  -4.413428085456429e-12,   4.415045243362058e-14,  -3.513862579797110e-16,  -4.378406719075591e-19,   1.277724837095723e-19,   3.286418664165671e-02,
  -3.496540764833032e-04,   3.719984015822064e-06,  -3.956706373666971e-08,   4.200881652171464e-10,  -4.414256598529012e-12,   4.414895411721771e-14,  -3.508638703432376e-16,
  -4.599945724125661e-19,   1.284127278631634e-19,   3.286434406464137e-02,  -3.496590980550668e-04,   3.720090632352169e-06,  -3.956893067555669e-08,   4.201161624002516e-10,
  -4.414567606614584e-12,   4.414838545840307e-14,  -3.506674849172717e-16,  -4.683194201535113e-19,   1.286532305975210e-19,   3.286437015990000e-02,  -3.496599304601012e-04,
   3.720108305796921e-06,  -3.956924015162682e-08,   4.201208033219317e-10,  -4.414619155018986e-12,   4.414829087706765e-14,  -3.506349194203700e-16,  -4.696996907692928e-19,
   1.286931018321440e-19,   9.280183570659567e-02,  -9.871443609135557e-04,   1.049895208387121e-05,  -1.116239988543585e-07,   1.184534287853284e-09,  -1.244052296559917e-11,
   1.243578901603130e-13,  -9.863628899564202e-16,  -1.443880738332142e-18,   3.701431272882873e-19,   9.280333182156922e-02,  -9.871920782964230e-04,   1.049996499491678e-05,
  -1.116417272253266e-07,   1.184799652181225e-09,  -1.244343919841588e-11,   1.243504142765371e-13,  -9.844019468374279e-16,  -1.526666424238346e-18,   3.725485857795970e-19,
   9.280578804093373e-02,  -9.872704195816864e-04,   1.050162801611789e-05,  -1.116708342027231e-07,   1.185235278230778e-09,  -1.244822238882249e-11,   1.243379016245654e-13,
  -9.811738072805894e-16,  -1.662808381753505e-18,   3.765010957066561e-19,   9.280839442156458e-02,  -9.873535531870303e-04,   1.050339283275093e-05,  -1.117017230130218e-07,
   1.185697494026486e-09,  -1.245329189911042e-11,   1.243242984800193e-13,  -9.777363523343071e-16,  -1.807585976714300e-18,   3.806998388283533e-19,   9.281044575967447e-02,
  -9.874189851634945e-04,   1.050478191388707e-05,  -1.117260356050183e-07,   1.186061247737222e-09,  -1.245727740495384e-11,   1.243133562236510e-13,  -9.750222550918646e-16,
  -1.921758649920381e-18,   3.840077535085018e-19,   9.281162966824358e-02,  -9.874567493982052e-04,   1.050558364437835e-05,  -1.117400680535367e-07,   1.186271172033452e-09,
  -1.245957582181220e-11,   1.243069463320119e-13,  -9.734523663135812e-16,  -1.987742882801515e-18,   3.859182076733001e-19,   9.281207424547779e-02,  -9.874709306524469e-04,
   1.050588471436106e-05,  -1.117453375997431e-07,   1.186349999727075e-09,  -1.246043857921415e-11,   1.243045214050898e-13,  -9.728621900037749e-16,  -2.012538184082256e-18,
   3.866358648493381e-19,   9.281214794092910e-02,  -9.874732814198798e-04,   1.050593462166432e-05,  -1.117462111141768e-07,   1.186363066494444e-09,  -1.246058157666153e-11,
   1.243041184915790e-13,  -9.727643246157548e-16,  -2.016649286780710e-18,   3.867548406431460e-19,   1.868212200998949e-01,  -1.987239763359774e-03,   2.113561788754119e-05,
  -2.247088077527254e-07,   2.384288149818761e-09,  -2.502219267628539e-11,   2.491090429687546e-13,  -1.927534086724085e-15,  -5.225589849839019e-18,   8.243488807158909e-19,
   1.868242319536570e-01,  -1.987335822482630e-03,   2.113765670882085e-05,  -2.247444641499032e-07,   2.384819602747604e-09,  -2.502788296700626e-11,   2.490844355700141e-13,
  -1.923168241581866e-15,  -5.407507035873081e-18,   8.296539976032025e-19,   1.868291766093931e-01,  -1.987493530097771e-03,   2.114100409190555e-05,  -2.248030057218757e-07,
   2.385692028778677e-09,  -2.503721497703449e-11,   2.490435115864994e-13,  -1.915981292733717e-15,  -5.706681235390049e-18,   8.383715660756089e-19,   1.868344235572088e-01,
  -1.987660885043380e-03,   2.114455636983819e-05,  -2.248651307662796e-07,   2.386617685468097e-09,  -2.504710399477074e-11,   2.489993710623202e-13,  -1.908328583431516e-15,
  -6.024845217415110e-18,   8.476329125953403e-19,   1.868385531397437e-01,  -1.987792605109744e-03,   2.114735235397845e-05,  -2.249140292269744e-07,   2.387346142148747e-09,
  -2.505487729740664e-11,   2.489641124427002e-13,  -1.902286442973429e-15,  -6.275760974114518e-18,   8.549298224169851e-19,   1.868409364855706e-01,  -1.987868627683150e-03,
   2.114896610046708e-05,  -2.249422517780074e-07,   2.387766532594348e-09,  -2.505935964578340e-11,   2.489435554281414e-13,  -1.898791617497924e-15,  -6.420777376644514e-18,
   8.591442834767167e-19,   1.868418314713158e-01,  -1.987897175737162e-03,   2.114957210277192e-05,  -2.249528500598320e-07,   2.387924390320759e-09,  -2.506104209763534e-11,
   2.489357966160440e-13,  -1.897477803235189e-15,  -6.475271789557799e-18,   8.607274729692608e-19,   1.868419798288413e-01,  -1.987901908029096e-03,   2.114967255761805e-05,
  -2.249546068995987e-07,   2.387950557336357e-09,  -2.506132095039944e-11,   2.489345084001574e-13,  -1.897259942019552e-15,  -6.484307092269387e-18,   8.609899418398934e-19,
   3.214877303804166e-01,  -3.419703132817406e-03,   3.637073675065759e-05,  -3.866754615638291e-07,   4.102044714368034e-09,  -4.299597625073697e-11,   4.251184787424926e-13,
  -3.148810471113335e-15,  -1.575670682678249e-17,   1.651978164088904e-18,   3.214929132573131e-01,  -3.419868429551762e-03,   3.637424439354001e-05,  -3.867367261320200e-07,
   4.102951331362363e-09,  -4.300524597972816e-11,   4.250482307430371e-13,  -3.140063924161462e-15,  -1.611535665004014e-17,   1.662514294267440e-18,   3.215014221504151e-01,
  -3.420139809824185e-03,   3.638000331642923e-05,  -3.868373113147234e-07,   4.104439577558957e-09,  -4.302044466290267e-11,   4.249318681980781e-13,  -3.125665899245119e-15,
  -1.670521170636701e-17,   1.679829363239199e-18,   3.215104512355213e-01,  -3.420427790999646e-03,   3.638611473899430e-05,  -3.869440528398302e-07,   4.106018568255482e-09,
  -4.303654566632029e-11,   4.248069846372120e-13,  -3.110335233169705e-15,  -1.733255212964194e-17,   1.698226815669190e-18,   3.215175575291223e-01,  -3.420654452330267e-03,
   3.639092501111002e-05,  -3.870280682924135e-07,   4.107261130367910e-09,  -4.304919839801414e-11,   4.247076755744468e-13,  -3.098231335652198e-15,  -1.782732831885388e-17,
   1.712723639903097e-18,   3.215216588529017e-01,  -3.420785270485590e-03,   3.639370133384566e-05,  -3.870765589826509e-07,   4.107978192191209e-09,  -4.305649297177721e-11,
   4.246499510442183e-13,  -3.091230464263672e-15,  -1.811329658713221e-17,   1.721097214942894e-18,   3.215231989677526e-01,  -3.420834395415567e-03,   3.639474391234170e-05,
  -3.870947684236360e-07,   4.108247447490370e-09,  -4.305923072543901e-11,   4.246281971114348e-13,  -3.088598641282432e-15,  -1.822076051083306e-17,   1.724242929991157e-18,
   3.215234542652578e-01,  -3.420842538650355e-03,   3.639491673685056e-05,  -3.870977869362885e-07,   4.108292079958766e-09,  -4.305968447175229e-11,   4.246245869802424e-13,
  -3.088162224556262e-15,  -1.823857841440843e-17,   1.724764448695126e-18,   5.102712495908012e-01,  -5.427814527354694e-03,   5.772806416638761e-05,  -6.137098583229240e-07,
   6.508315667888804e-09,  -6.806796515184297e-11,   6.647107842660540e-13,  -4.517006140059472e-15,  -4.463353016472816e-17,   3.311073458033178e-18,   5.102794759098517e-01,
  -5.428076876252254e-03,   5.773362927814323e-05,  -6.138068353751013e-07,   6.509732257592204e-09,  -6.808118272228855e-11,   6.645182190898379e-13,  -4.499475559167310e-15,
  -4.534065234964786e-17,   3.332177954605553e-18,   5.102929813180469e-01,  -5.428507594390119e-03,   5.774276618353066e-05,  -6.139660523833974e-07,   6.512057513952341e-09,
  -6.810284326690091e-11,   6.642000427793649e-13,  -4.470617801754379e-15,  -4.650374963458272e-17,   3.366867260355066e-18,   5.103073123803360e-01,  -5.428964660351275e-03,
   5.775246233379526e-05,  -6.141350122372780e-07,   6.514524374541884e-09,  -6.812577471883861e-11,   6.638596442436721e-13,  -4.439890753816896e-15,  -4.774093292333321e-17,
   3.403733460199088e-18,   5.103185915667412e-01,  -5.429324403154655e-03,   5.776009411469754e-05,  -6.142679977647001e-07,   6.516465504132800e-09,  -6.814378412567092e-11,
   6.635897267889350e-13,  -4.415631056783153e-15,  -4.871680922557709e-17,   3.432789400469534e-18,   5.103251012322995e-01,  -5.429532029582829e-03,   5.776449890927293e-05,
  -6.143447516124783e-07,   6.517585646205656e-09,  -6.815416254369883e-11,   6.634331407033817e-13,  -4.401599283533786e-15,  -4.928089111909353e-17,   3.449574984573160e-18,
   5.103275457192656e-01,  -5.429609997605745e-03,   5.776615301856327e-05,  -6.143735744465325e-07,   6.518006247622583e-09,  -6.815805687405684e-11,   6.633741875902673e-13,
  -4.396324345915092e-15,  -4.949287668921546e-17,   3.455881317288671e-18,   5.103279509302290e-01,  -5.429622922039442e-03,   5.776642721429033e-05,  -6.143783522966305e-07,
   6.518075967109472e-09,  -6.815870226364317e-11,   6.633644071684519e-13,  -4.395449639912577e-15,  -4.952802515313645e-17,   3.456926849844940e-18,   7.885281613358698e-01,
  -8.387661507397377e-03,   8.920709158520089e-05,  -9.482805278532760e-07,   1.004906257489008e-08,  -1.045960102335253e-10,   9.927990478689023e-13,  -5.293933009844115e-15,
  -1.397851354398111e-16,   7.690243975535440e-18,   7.885408734394312e-01,  -8.388066875595420e-03,   8.921568388134850e-05,  -9.484295031078599e-07,   1.005117474444507e-08,
  -1.046111766934263e-10,   9.922080587721379e-13,  -5.253167847239154e-15,  -1.414179755985346e-16,   7.741046942957862e-18,   7.885617433011121e-01,  -8.388732399117461e-03,
   8.922979082773459e-05,  -9.486740854316886e-07,   1.005464128270627e-08,  -1.046359859454643e-10,   9.912331180148501e-13,  -5.186056077010973e-15,  -1.441044431337468e-16,
   7.824585832793754e-18,   7.885838890421341e-01,  -8.389438633561778e-03,   8.924476115697886e-05,  -9.489336269699435e-07,   1.005831827988317e-08,  -1.046621893679575e-10,
   9.901921838319654e-13,  -5.114587938862946e-15,  -1.469630110202985e-16,   7.913414005517651e-18,   7.886013187290720e-01,  -8.389994489071625e-03,   8.925654416520643e-05,
  -9.491379025368454e-07,   1.006121117485722e-08,  -1.046827237338513e-10,   9.893682882227514e-13,  -5.058155580493972e-15,  -1.492185281383986e-16,   7.983457562807442e-18,
   7.886113780919479e-01,  -8.390315302311465e-03,   8.926334488284979e-05,  -9.492557999656159e-07,   1.006288035083598e-08,  -1.046945392387725e-10,   9.888909255872936e-13,
  -5.025512508818882e-15,  -1.505225610138269e-16,   8.023935298005421e-18,   7.886151555488398e-01,  -8.390435774304861e-03,   8.926589871693828e-05,  -9.493000727558525e-07,
   1.006350707290269e-08,  -1.046989694032719e-10,   9.887113162290890e-13,  -5.013240553964381e-15,  -1.510126788372477e-16,   8.039145338204085e-18,   7.886157817198766e-01,
  -8.390455744443217e-03,   8.926632205660974e-05,  -9.493074116642973e-07,   1.006361095735427e-08,  -1.046997034141394e-10,   9.886815246752745e-13,  -5.011205554742199e-15,
  -1.510939461244563e-16,   8.041667160674044e-18,   3.474468139609306e-03,  -3.545018783277081e-05,   3.616608480609170e-07,  -3.689006929983315e-09,   3.760382438046306e-11,
  -3.819614054889390e-13,   3.812306756387541e-15,  -3.519260659681492e-17,   2.205724167046426e-19,   2.167573793301388e-21,   3.474519671266457e-03,  -3.545176467478595e-05,
   3.616930020336925e-07,  -3.689551375275087e-09,   3.761197234866958e-11,  -3.820663833203508e-13,   3.813166071743706e-15,  -3.518060201208807e-17,   2.196328229952259e-19,
   2.200998479594224e-21,   3.474604272138912e-03,  -3.545435348443996e-05,   3.617457930171690e-07,  -3.690445278258602e-09,   3.762534987289310e-11,  -3.822386949070949e-13,
   3.814574047494773e-15,  -3.516077002743072e-17,   2.180862414512283e-19,   2.255969535714958e-21,   3.474694044712399e-03,  -3.545710064031573e-05,   3.618018151721754e-07,
  -3.691393925078420e-09,   3.763954624594919e-11,  -3.824214946367768e-13,   3.816064302508786e-15,  -3.513955732916407e-17,   2.164396413687112e-19,   2.314432637122295e-21,
   3.474764699464563e-03,  -3.545926283206379e-05,   3.618459098563488e-07,  -3.692140621290192e-09,   3.765072015739264e-11,  -3.825653326717007e-13,   3.817234445396318e-15,
  -3.512273999385456e-17,   2.151397317023486e-19,   2.360540815845307e-21,   3.474805477012549e-03,  -3.546051074160316e-05,   3.618713597466843e-07,  -3.692571596833499e-09,
   3.765716935718156e-11,  -3.826483338283863e-13,   3.817908675513847e-15,  -3.511298509217888e-17,   2.143879133282695e-19,   2.387189789035704e-21,   3.474820789634711e-03,
  -3.546097935659542e-05,   3.618809168089383e-07,  -3.692733440479098e-09,   3.765959119347842e-11,  -3.826794995826467e-13,   3.818161650875830e-15,  -3.510931270732643e-17,
   2.141052926696426e-19,   2.397204122087975e-21,   3.474823327934069e-03,  -3.546105703690018e-05,   3.618825010486069e-07,  -3.692760268804270e-09,   3.765999265265975e-11,
  -3.826846656466079e-13,   3.818203574356669e-15,  -3.510870346502846e-17,   2.140584281369786e-19,   2.398864530373708e-21,   3.151917569369269e-02,  -3.215918658856849e-04,
   3.280862023923811e-06,  -3.346535478496046e-08,   3.411251107774903e-10,  -3.464754932851877e-12,   3.456856299677148e-14,  -3.185122203332105e-16,   1.970267381598228e-18,
   2.075740534694317e-20,   3.151964317104171e-02,  -3.216061704325009e-04,   3.281153710222758e-06,  -3.347029340500583e-08,   3.411989920132066e-10,  -3.465704942097096e-12,
   3.457623146241583e-14,  -3.183975176330248e-16,   1.961519981188354e-18,   2.106793529889632e-20,   3.152041064086019e-02,  -3.216296551876884e-04,   3.281632606128288e-06,
  -3.347840192570770e-08,   3.413202917562028e-10,  -3.467264282844840e-12,   3.458879507920755e-14,  -3.182080577460411e-16,   1.947121698512163e-18,   2.157864478606872e-20,
   3.152122502655901e-02,  -3.216545764029893e-04,   3.282140813730524e-06,  -3.348700702007579e-08,   3.414490160897605e-10,  -3.468918518432346e-12,   3.460209145211059e-14,
  -3.180054520325148e-16,   1.931792314533014e-18,   2.212180308447634e-20,   3.152186598200282e-02,  -3.216741910328719e-04,   3.282540820701737e-06,  -3.349378023539561e-08,
   3.415503343344312e-10,  -3.470220159324080e-12,   3.461253067192688e-14,  -3.178448590780737e-16,   1.919690553679363e-18,   2.255018081124195e-20,   3.152223590179669e-02,
  -3.216855116216475e-04,   3.282771690553097e-06,  -3.349768957551676e-08,   3.416088116859339e-10,  -3.470971260681829e-12,   3.461854527467183e-14,  -3.177517198102133e-16,
   1.912691367863431e-18,   2.279777041908588e-20,   3.152237481260209e-02,  -3.216897627291534e-04,   3.282858387881554e-06,  -3.349915764439257e-08,   3.416307713838300e-10,
  -3.471253287567807e-12,   3.462080191164407e-14,  -3.177166584767846e-16,   1.910060263404600e-18,   2.289081165743237e-20,   3.152239783917482e-02,  -3.216904674170782e-04,
   3.282872759384266e-06,  -3.349940100166204e-08,   3.416344115640107e-10,  -3.471300036550124e-12,   3.462117588091899e-14,  -3.177108419883150e-16,   1.909623970299466e-18,
   2.290623820798232e-20,   8.901318927311411e-02,  -9.082064054411147e-04,   9.265468332319173e-06,  -9.450912725542867e-08,   9.633470810846809e-10,  -9.783177307451339e-12,
   9.753132013986499e-14,  -8.949735928895691e-16,   5.376448148071732e-18,   6.533183071834013e-20,   8.901450947384339e-02,  -9.082468027403598e-04,   9.266292061618658e-06,
  -9.452307196276695e-08,   9.635555196736978e-10,  -9.785846099297008e-12,   9.755219971352686e-14,  -8.946140632663886e-16,   5.350367376789933e-18,   6.625399427361374e-20,
   8.901667688198646e-02,  -9.083131257552904e-04,   9.267644475333842e-06,  -9.454596720000539e-08,   9.638977372854211e-10,  -9.790226560340469e-12,   9.758640115065782e-14,
  -8.940204015809928e-16,   5.307438394073681e-18,   6.777064825525349e-20,   8.901897678505793e-02,  -9.083835054589228e-04,   9.269079665819882e-06,  -9.457026454430025e-08,
   9.642608999586755e-10,  -9.794873486651673e-12,   9.762258837191374e-14,  -8.933858056902323e-16,   5.261733501082796e-18,   6.938370412089141e-20,   8.902078690450646e-02,
  -9.084388988979046e-04,   9.270209294995447e-06,  -9.458938938082581e-08,   9.645467422182776e-10,  -9.798529855888402e-12,   9.765099308281398e-14,  -8.928829861505393e-16,
   5.225651979270605e-18,   7.065591598918892e-20,   8.902183159336766e-02,  -9.084708692354211e-04,   9.270861276881182e-06,  -9.460042777969428e-08,   9.647117199166565e-10,
  -9.800639701869393e-12,   9.766735595789965e-14,  -8.925914391262375e-16,   5.204783892362339e-18,   7.139122793237193e-20,   8.902222389076142e-02,  -9.084828747365331e-04,
   9.271106112164475e-06,  -9.460457301267969e-08,   9.647736730512881e-10,  -9.801431910123229e-12,   9.767349469698003e-14,  -8.924817030846437e-16,   5.196939259480512e-18,
   7.166755156897248e-20,   8.902228892000406e-02,  -9.084848648371455e-04,   9.271146697623753e-06,  -9.460526015516604e-08,   9.647839427950301e-10,  -9.801563226818133e-12,
   9.767451198090045e-14,  -8.924634991904805e-16,   5.195638452976544e-18,   7.171336707052373e-20,   1.791942210324037e-01,  -1.828328331401125e-03,   1.865249112306969e-05,
  -1.902573138852135e-07,   1.939253733750689e-09,  -1.968910716591313e-11,   1.960183211937904e-13,  -1.785940862139951e-15,   1.016871524665900e-17,   1.550338118921176e-19,
   1.791968787535433e-01,  -1.828409655598068e-03,   1.865414931696319e-05,  -1.902853778652323e-07,   1.939672621840700e-09,  -1.969443069795522e-11,   1.960576442864922e-13,
  -1.785092301255728e-15,   1.011135503706640e-17,   1.570507938504329e-19,   1.792012420039957e-01,  -1.828543171103365e-03,   1.865687176934915e-05,  -1.903314549016540e-07,
   1.940360354485206e-09,  -1.970316826921553e-11,   1.961220328816328e-13,  -1.783691735903519e-15,   1.001694019778212e-17,   1.603681724126188e-19,   1.792058719824913e-01,
  -1.828684853164473e-03,   1.865976085343477e-05,  -1.903803536336383e-07,   1.941090173450603e-09,  -1.971243695972783e-11,   1.961901273042406e-13,  -1.782195401246340e-15,
   9.916420401529748e-18,   1.638965613761413e-19,   1.792095159682778e-01,  -1.828796366228861e-03,   1.866203483244516e-05,  -1.904188425751243e-07,   1.941664603691353e-09,
  -1.971972961607626e-11,   1.962435534142163e-13,  -1.781010363799297e-15,   9.837065618021268e-18,   1.666794993287308e-19,   1.792116190512313e-01,  -1.828860726021526e-03,
   1.866334729228187e-05,  -1.904410574531732e-07,   1.941996142181202e-09,  -1.972393760604971e-11,   1.962743206016081e-13,  -1.780323480279602e-15,   9.791170077276671e-18,
   1.682880232728187e-19,   1.792124087925518e-01,  -1.828884894410603e-03,   1.866384015329706e-05,  -1.904493997685010e-07,   1.942120642630631e-09,  -1.972551760711334e-11,
   1.962858614871950e-13,  -1.780064985949462e-15,   9.773917249687880e-18,   1.688925004382109e-19,   1.792125397041530e-01,  -1.828888900701164e-03,   1.866392185308297e-05,
  -1.904507826481848e-07,   1.942141280596830e-09,  -1.972577950745948e-11,   1.962877738944876e-13,  -1.780022107117803e-15,   9.771056365369571e-18,   1.689927254702727e-19,
   3.083629556761610e-01,  -3.146243808025658e-03,   3.209776276156494e-05,  -3.273981737753569e-07,   3.336904011559241e-09,  -3.386576687378370e-11,   3.363924572477299e-13,
  -3.028206702316932e-15,   1.561074791024016e-17,   3.351388548184832e-19,   3.083675291615210e-01,  -3.146383752069074e-03,   3.210061603009294e-05,  -3.274464433810780e-07,
   3.337622785852472e-09,  -3.387478717863366e-11,   3.364523057746248e-13,  -3.026383431155334e-15,   1.549777133659550e-17,   3.390873383535202e-19,   3.083750375722832e-01,
  -3.146613507784628e-03,   3.210530057611359e-05,  -3.275256950190273e-07,   3.338802861296080e-09,  -3.388959146151944e-11,   3.365502286226379e-13,  -3.023375521449796e-15,
   1.531181057945166e-17,   3.455818804014675e-19,   3.083830049765404e-01,  -3.146857316635862e-03,   3.211027184492798e-05,  -3.276097997263931e-07,   3.340055136104613e-09,
  -3.390529448599214e-11,   3.366536855075555e-13,  -3.020163872377958e-15,   1.511382341143968e-17,   3.524900372978685e-19,   3.083892756552906e-01,  -3.147049210167505e-03,
   3.211418469653582e-05,  -3.276759996899582e-07,   3.341040772199283e-09,  -3.391764887899746e-11,   3.367347824926207e-13,  -3.017621769494917e-15,   1.495752208301591e-17,
   3.579390636215684e-19,   3.083928947027638e-01,  -3.147159961563729e-03,   3.211644305486342e-05,  -3.277142086373645e-07,   3.341609637762441e-09,  -3.392477724495940e-11,
   3.367814550203630e-13,  -3.016148846031478e-15,   1.486712322459910e-17,   3.610887223218437e-19,   3.083942537130314e-01,  -3.147201550927022e-03,   3.211729112397878e-05,
  -3.277285571676235e-07,   3.341823259177079e-09,  -3.392745371509305e-11,   3.367989563989994e-13,  -3.015594646632886e-15,   1.483314081203791e-17,   3.622723802851487e-19,
   3.083944789895940e-01,  -3.147208445017990e-03,   3.211743170532025e-05,  -3.277309356783241e-07,   3.341858670339582e-09,  -3.392789736237413e-11,   3.368018562036361e-13,
  -3.015502721995813e-15,   1.482750580201444e-17,   3.624686375875324e-19,   4.894393681681045e-01,  -4.993775878403430e-03,   5.094610513210088e-05,  -5.196456457204757e-07,
   5.295783604185581e-09,  -5.370865128156523e-11,   5.313635135664970e-13,  -4.679679549668634e-15,   1.940876959730652e-17,   7.290110025816376e-19,   4.894466272793444e-01,
  -4.993997997045863e-03,   5.095063333733123e-05,  -5.197221945586738e-07,   5.296918715393686e-09,  -5.372257287195253e-11,   5.314362400336904e-13,  -4.675737408378163e-15,
   1.918755454403223e-17,   7.367100164560079e-19,   4.894585447524273e-01,  -4.994362664404962e-03,   5.095806782009333e-05,  -5.198478761619340e-07,   5.298782293945527e-09,
  -5.374541876562427e-11,   5.315549895963281e-13,  -4.669237042661003e-15,   1.882341889416022e-17,   7.493748857876629e-19,   4.894711907474524e-01,  -4.994749636816992e-03,
   5.096595733372820e-05,  -5.199812534826456e-07,   5.300759843503504e-09,  -5.376964823423519e-11,   5.316801170219384e-13,  -4.662300590241887e-15,   1.843571603432784e-17,
   7.628482192432450e-19,   4.894811436717965e-01,  -4.995054209425516e-03,   5.097216711232839e-05,  -5.200862361961179e-07,   5.302316292617881e-09,  -5.378870838995609e-11,
   5.317779581937332e-13,  -4.656813242597206e-15,   1.812963025277650e-17,   7.734771007071708e-19,   4.894868878833849e-01,  -4.995229993568830e-03,   5.097575117354887e-05,
  -5.201468294081049e-07,   5.303214592674686e-09,  -5.379970493703200e-11,   5.318341693989923e-13,  -4.653635020097572e-15,   1.795259639310681e-17,   7.796213791091878e-19,
   4.894890449267972e-01,  -4.995296004027156e-03,   5.097709707645105e-05,  -5.201695838266937e-07,   5.303551921358434e-09,  -5.380383359827145e-11,   5.318552290487739e-13,
  -4.652439415873396e-15,   1.788604546632676e-17,   7.819305342108982e-19,   4.894894024894563e-01,  -4.995306946298571e-03,   5.097732018187978e-05,  -5.201733557534539e-07,
   5.303607838842046e-09,  -5.380451794857138e-11,   5.318587174423530e-13,  -4.652241113894349e-15,   1.787500984815450e-17,   7.823134108842481e-19,   7.563364189385077e-01,
  -7.716939747526792e-03,   7.872744185457659e-05,  -8.029930702020624e-07,   8.181670033144220e-09,  -8.285392771461172e-11,   8.126047812915264e-13,  -6.802222408861878e-15,
   1.138421800616522e-17,   1.828227387871630e-18,   7.563476365001813e-01,  -7.717282980156594e-03,   7.873443755544348e-05,  -8.031111475778723e-07,   8.183405028533676e-09,
  -8.287409772424565e-11,   8.126397947494111e-13,  -6.792387332471297e-15,   1.088773975918620e-17,   1.845630858732961e-18,   7.563660526648374e-01,  -7.717846488560168e-03,
   7.874592320182588e-05,  -8.033050113859400e-07,   8.186253352825264e-09,  -8.290718850957625e-11,   8.126958319219423e-13,  -6.776176524102642e-15,   1.007038959273651e-17,
   1.874267027930525e-18,   7.563855946198940e-01,  -7.718444464131572e-03,   7.875811181628675e-05,  -8.035107439721594e-07,   8.189275709825701e-09,  -8.294227102487912e-11,
   8.127533267582107e-13,  -6.758887212224214e-15,   9.199987250069555e-18,   1.904741376903697e-18,   7.564009749515583e-01,  -7.718915109965716e-03,   7.876770537408740e-05,
  -8.036726769361290e-07,   8.191654366607106e-09,  -8.296985982643986e-11,   8.127971499538536e-13,  -6.745216329959069e-15,   8.512706458496649e-18,   1.928789455136175e-18,
   7.564098515264759e-01,  -7.719186743278212e-03,   7.877324242646065e-05,  -8.037661397652689e-07,   8.193027154044887e-09,  -8.298577329617299e-11,   8.128218688017194e-13,
  -6.737300866189520e-15,   8.115152562083645e-18,   1.942693985146258e-18,   7.564131848224502e-01,  -7.719288747009717e-03,   7.877532172455755e-05,  -8.038012375268892e-07,
   8.193542652760933e-09,  -8.299174734062951e-11,   8.128310426771436e-13,  -6.734323663413686e-15,   7.965694872974335e-18,   1.947920174404445e-18,   7.564137373668096e-01,
  -7.719305655731850e-03,   7.877566640219328e-05,  -8.038070555644863e-07,   8.193628104229352e-09,  -8.299273753840055e-11,   8.128325576623629e-13,  -6.733829892559714e-15,
   7.940911032087789e-18,   1.948786748624608e-18,   3.338187310467213e-03,  -3.272429502702154e-05,   3.207658611702428e-07,  -3.143808399190902e-09,   3.080404361174370e-11,
  -3.014525639749596e-13,   2.931401439537687e-15,  -2.768897576836968e-17,   2.307100055541786e-19,  -8.897768597774850e-22,   3.338233010770088e-03,  -3.272563870630523e-05,
   3.207921985407559e-07,  -3.144238087605696e-09,   3.081031187226741e-11,  -3.015353789062301e-13,   2.932316305826800e-15,  -2.769324818327132e-17,   2.304983735712079e-19,
  -8.791694761874763e-22,   3.338308037930458e-03,  -3.272784470613394e-05,   3.208354394701349e-07,  -3.144943575910888e-09,   3.082060364583562e-11,  -3.016713420641078e-13,
   2.933817588598072e-15,  -2.770022242128402e-17,   2.301494058165827e-19,  -8.617100987557966e-22,   3.338387651239538e-03,  -3.273018562299100e-05,   3.208813267029269e-07,
  -3.145692269373306e-09,   3.083152592811504e-11,  -3.018156217296649e-13,   2.935409722878806e-15,  -2.770756868327823e-17,   2.297770289513455e-19,  -8.431222709725005e-22,
   3.338450310006392e-03,  -3.273202806758963e-05,   3.209174440084922e-07,  -3.146281578942202e-09,   3.084012320784041e-11,  -3.019291794145544e-13,   2.936662128812383e-15,
  -2.771331110019810e-17,   2.294824474038382e-19,  -8.284485671896754e-22,   3.338486472678044e-03,  -3.273309143080307e-05,   3.209382895400498e-07,  -3.146621714642626e-09,
   3.084508542159802e-11,  -3.019947193023018e-13,   2.937384670768446e-15,  -2.771660945198053e-17,   2.293118290574206e-19,  -8.199620405828217e-22,   3.338500052323483e-03,
  -3.273349074416977e-05,   3.209461175333090e-07,  -3.146749445335984e-09,   3.084694888718945e-11,  -3.020193308471010e-13,   2.937655945886103e-15,  -2.771784504377621e-17,
   2.292476448740764e-19,  -8.167718532019510e-22,   3.338502303354781e-03,  -3.273355693659859e-05,   3.209474151504796e-07,  -3.146770618862006e-09,   3.084725778882232e-11,
  -3.020234105979938e-13,   2.937700911161116e-15,  -2.771804970394079e-17,   2.292369993425111e-19,  -8.162428539314882e-22,   3.028288305544771e-02,  -2.968635087686543e-04,
   2.909877093100975e-06,  -2.851953460854304e-08,   2.794427376941999e-10,  -2.734607970517190e-12,   2.658878536361186e-14,  -2.509917540238864e-16,   2.084666915920895e-18,
  -7.765351062171743e-21,   3.028329763280787e-02,  -2.968756981586826e-04,   2.910116015806156e-06,  -2.852343249500250e-08,   2.794995925057973e-10,  -2.735358635784717e-12,
   2.659705044424585e-14,  -2.510288801171841e-16,   2.082680910610786e-18,  -7.666821801262254e-21,   3.028397825328794e-02,  -2.968957102200418e-04,   2.910508281225183e-06,
  -2.852983227901925e-08,   2.795929416129671e-10,  -2.736591052800673e-12,   2.661061311030810e-14,  -2.510894605629335e-16,   2.079406272380460e-18,  -7.504645924635151e-21,
   3.028470047772464e-02,  -2.969169462016033e-04,   2.910924552904384e-06,  -2.853662399453163e-08,   2.796920095304714e-10,  -2.737898848747813e-12,   2.662499623993733e-14,
  -2.511532400273539e-16,   2.075912183285221e-18,  -7.331987865241403e-21,   3.028526889641132e-02,  -2.969336602165987e-04,   2.911252195481142e-06,  -2.854196987063258e-08,
   2.797699890240433e-10,  -2.738928167608629e-12,   2.663631009559364e-14,  -2.512030713313016e-16,   2.073148218783998e-18,  -7.195686994391241e-21,   3.028559695167568e-02,
  -2.969433066768969e-04,   2.911441298280741e-06,  -2.854505538504594e-08,   2.798149975327621e-10,  -2.739522238233646e-12,   2.664283723499246e-14,  -2.512316840304053e-16,
   2.071547423246082e-18,  -7.116857393172347e-21,   3.028572014152783e-02,  -2.969469291085245e-04,   2.911512310882557e-06,  -2.854621408399831e-08,   2.798318996236746e-10,
  -2.739745323427628e-12,   2.664528780381724e-14,  -2.512424007761782e-16,   2.070945238501415e-18,  -7.087224382091999e-21,   3.028574056210611e-02,  -2.969475295831582e-04,
   2.911524082375994e-06,  -2.854640615797414e-08,   2.798347014372010e-10,  -2.739782303295622e-12,   2.664569399761001e-14,  -2.512441757731290e-16,   2.070845361289215e-18,
  -7.082310613050316e-21,   8.552177976183685e-02,  -8.383711514395303e-04,   8.217772804758219e-06,  -8.054185297667076e-08,   7.891676829172035e-10,  -7.722398126992104e-12,
   7.506573264533034e-14,  -7.076495238532910e-16,   5.836952786979730e-18,  -2.005720659637708e-20,   8.552295056816907e-02,  -8.384055754234210e-04,   8.218447540473505e-06,
  -8.055286038568160e-08,   7.893281935979883e-10,  -7.724514405279316e-12,   7.508886496065356e-14,  -7.077443948199933e-16,   5.830938619425072e-18,  -1.976479220294243e-20,
   8.552487270585495e-02,  -8.384620913667089e-04,   8.219555327529952e-06,  -8.057093300694983e-08,   7.895917334883959e-10,  -7.727988818454160e-12,   7.512682283693899e-14,
  -7.078990485704953e-16,   5.821023046611926e-18,  -1.928348607435530e-20,   8.552691233711433e-02,  -8.385220637754920e-04,   8.220730910026838e-06,  -8.059011241509974e-08,
   7.898714180919824e-10,  -7.731675709709806e-12,   7.516707514048778e-14,  -7.080616610554127e-16,   5.810444235112739e-18,  -1.877106842125032e-20,   8.552851760614492e-02,
  -8.385692657252979e-04,   8.221656197247367e-06,  -8.060520885346592e-08,   7.900915663843899e-10,  -7.734577507218979e-12,   7.519873653105672e-14,  -7.081885592128213e-16,
   5.802076876547251e-18,  -1.836655046841032e-20,   8.552944406575719e-02,  -8.385965082360691e-04,   8.222190237729280e-06,  -8.061392216244981e-08,   7.902186323106126e-10,
  -7.736252269019447e-12,   7.521700195294169e-14,  -7.082613615490898e-16,   5.797231144348924e-18,  -1.813259679972428e-20,   8.552979196574553e-02,  -8.386067383235256e-04,
   8.222390782637720e-06,  -8.061719425901929e-08,   7.902663494830288e-10,  -7.736881173377929e-12,   7.522385947803620e-14,  -7.082886176158386e-16,   5.795408352505283e-18,
  -1.804465061535829e-20,   8.552984963542223e-02,  -8.386084341203402e-04,   8.222424026217086e-06,  -8.061773666442925e-08,   7.902742594273473e-10,  -7.736985424049147e-12,
   7.522499614116171e-14,  -7.082931313746933e-16,   5.795106031314676e-18,  -1.803006730300544e-20,   1.721655952177573e-01,  -1.687741624798899e-03,   1.654336012613957e-05,
  -1.621401976729881e-07,   1.588670197970730e-09,  -1.554474573193008e-11,   1.510351999296165e-13,  -1.420523509197451e-15,   1.157596546573560e-17,  -3.385933178217387e-20,
   1.721679521909872e-01,  -1.687810924309258e-03,   1.654471843280421e-05,  -1.621623548532405e-07,   1.588993143401580e-09,  -1.554899336341635e-11,   1.510810430828261e-13,
  -1.420679759402149e-15,   1.156243968236568e-17,  -3.322085641355233e-20,   1.721718216841242e-01,  -1.687924697520035e-03,   1.654694851256998e-05,  -1.621987338217056e-07,
   1.589523381186594e-09,  -1.555596686438409e-11,   1.511562625555592e-13,  -1.420933884340705e-15,   1.154014262714391e-17,  -3.216993367451287e-20,   1.721759277058797e-01,
  -1.688045428999653e-03,   1.654931507079461e-05,  -1.622373406600153e-07,   1.590086100370187e-09,  -1.556336672872598e-11,   1.512360224230860e-13,  -1.421200283398668e-15,
   1.151635813024835e-17,  -3.105106626294336e-20,   1.721791593044978e-01,  -1.688140452049720e-03,   1.655117776095624e-05,  -1.622677287463529e-07,   1.590529032742173e-09,
  -1.556919077780219e-11,   1.512987547852025e-13,  -1.421407585402329e-15,   1.149754854086725e-17,  -3.016778889841193e-20,   1.721810243785411e-01,  -1.688195294412449e-03,
   1.655225283460705e-05,  -1.622852680295951e-07,   1.590784685492659e-09,  -1.557255207672427e-11,   1.513349431577901e-13,  -1.421526277799162e-15,   1.148665661309789e-17,
  -2.965693997736065e-20,   1.721817247428410e-01,  -1.688215888775810e-03,   1.655265655033583e-05,  -1.622918545307965e-07,   1.590880690899385e-09,  -1.557381430168085e-11,
   1.513485292795060e-13,  -1.421570669064070e-15,   1.148255967329814e-17,  -2.946490457549655e-20,   1.721818408387999e-01,  -1.688219302613268e-03,   1.655272347278171e-05,
  -1.622929463548431e-07,   1.590896605447040e-09,  -1.557402353478733e-11,   1.513507812167500e-13,  -1.421578018109068e-15,   1.148188018208908e-17,  -2.943306105990916e-20,
   2.962678793119982e-01,  -2.904317945057263e-03,   2.846832088442569e-05,  -2.790152855573752e-07,   2.733779743313945e-09,  -2.674603544131998e-11,   2.596769669242419e-13,
  -2.432956203863395e-15,   1.942195647702257e-17,  -3.952941178252300e-20,   2.962719352636378e-01,  -2.904437197529359e-03,   2.847065825230915e-05,  -2.790534085426323e-07,
   2.734334964080931e-09,  -2.675330885148622e-11,   2.597537838611639e-13,  -2.433125163083682e-15,   1.939456814747639e-17,  -3.828492774043996e-20,   2.962785940058004e-01,
  -2.904632981546395e-03,   2.847449576303184e-05,  -2.791160010770384e-07,   2.735246567066718e-09,  -2.676524967475350e-11,   2.598798113875348e-13,  -2.433397887806245e-15,
   1.934942606924840e-17,  -3.623647775748593e-20,   2.962856597736380e-01,  -2.904840739538085e-03,   2.847856812480849e-05,  -2.791824267659120e-07,   2.736214008923922e-09,
  -2.677792027225837e-11,   2.600134274467669e-13,  -2.433680940088736e-15,   1.930128227474862e-17,  -3.405553003925147e-20,   2.962912208073872e-01,  -2.905004257767880e-03,
   2.848177343258113e-05,  -2.792347114973016e-07,   2.736975506999580e-09,  -2.678789242859934e-11,   2.601185049260333e-13,  -2.433899112110104e-15,   1.926321552844480e-17,
  -3.233376118050429e-20,   2.962944302838471e-01,  -2.905098631985459e-03,   2.848362341373463e-05,  -2.792648889905789e-07,   2.737415029011035e-09,  -2.679364768567604e-11,
   2.601791154283008e-13,  -2.434023180033893e-15,   1.924117529825058e-17,  -3.133794778141314e-20,   2.962956354921558e-01,  -2.905134071321486e-03,   2.848431812563957e-05,
  -2.792762214974270e-07,   2.737580082699166e-09,  -2.679580886646154e-11,   2.602018692617333e-13,  -2.434069420006202e-15,   1.923288551129943e-17,  -3.096360394772721e-20,
   2.962958352736328e-01,  -2.905139945945069e-03,   2.848443328543156e-05,  -2.792781000520874e-07,   2.737607443174824e-09,  -2.679616711440093e-11,   2.602056407178969e-13,
  -2.434077066536128e-15,   1.923151065006068e-17,  -3.090152967559754e-20,   4.702418406244155e-01,  -4.609786925849124e-03,   4.518543121343232e-05,  -4.428566477007865e-07,
   4.338962113356000e-09,  -4.244133055223143e-11,   4.115351859614163e-13,  -3.829717571434108e-15,   2.943322780539450e-17,  -9.748711308595101e-21,   4.702482783035868e-01,
  -4.609976204850653e-03,   4.518914099627277e-05,  -4.429171414584107e-07,   4.339841958326772e-09,  -4.245277512032718e-11,   4.116513118990817e-13,  -3.829702795618367e-15,
   2.937795459741395e-17,  -7.348435124363133e-21,   4.702588471785331e-01,  -4.610286955663725e-03,   4.519523174881808e-05,  -4.430164635263653e-07,   4.341286544833304e-09,
  -4.247156315732129e-11,   4.118417902414962e-13,  -3.829669570116714e-15,   2.928686732822082e-17,  -3.397317599297006e-21,   4.702700620919084e-01,  -4.610616711710650e-03,
   4.520169524692334e-05,  -4.431218679197666e-07,   4.342819605356765e-09,  -4.249149860582188e-11,   4.120436828777940e-13,  -3.829622104363321e-15,   2.918974394335389e-17,
   8.096476567052105e-22,   4.702788886643497e-01,  -4.610876249856897e-03,   4.520678258894487e-05,  -4.432048333178726e-07,   4.344026307580443e-09,  -4.250718781989461e-11,
   4.122024140079764e-13,  -3.829575890367923e-15,   2.911296451720313e-17,   4.131079090286037e-21,   4.702839828029071e-01,  -4.611026041774231e-03,   4.520971880799623e-05,
  -4.432527189159558e-07,   4.344722789358052e-09,  -4.251624233381953e-11,   4.122939567943815e-13,  -3.829545662914974e-15,   2.906851601979805e-17,   6.052165997815873e-21,
   4.702858957311332e-01,  -4.611082291523297e-03,   4.521082142799047e-05,  -4.432707013120643e-07,   4.344984338479779e-09,  -4.251964238626407e-11,   4.123283198972882e-13,
  -3.829533639326305e-15,   2.905179914060744e-17,   6.774352052121669e-21,   4.702862128278737e-01,  -4.611091615797923e-03,   4.521100420517605e-05,  -4.432736821979262e-07,
   4.345027694691385e-09,  -4.252020599321684e-11,   4.123340154334662e-13,  -3.829531610730555e-15,   2.904902670508634e-17,   6.894106880250744e-21,   7.266702555530061e-01,
  -7.123557835710154e-03,   6.982554038119583e-05,  -6.843467497402093e-07,   6.704597694662095e-09,  -6.555170169955935e-11,   6.339149942273489e-13,  -5.813095171903804e-15,
   4.081055736217211e-17,   1.665152676457217e-19,   7.266802037681217e-01,  -7.123850328534269e-03,   6.983127274069731e-05,  -6.844401811493222e-07,   6.705952752401181e-09,
  -6.556905768356083e-11,   6.340749572376408e-13,  -5.812100400767119e-15,   4.068354437237770e-17,   1.717694324591041e-19,   7.266965359646167e-01,  -7.124330531721920e-03,
   6.984068417370920e-05,  -6.845935817781838e-07,   6.708177544431542e-09,  -6.559754809950982e-11,   6.343371921809412e-13,  -5.810447680827235e-15,   4.047426034038258e-17,
   1.804196752133555e-19,   7.267138664912040e-01,  -7.124840103673008e-03,   6.985067156942475e-05,  -6.847563759602287e-07,   6.710538554003685e-09,  -6.562777556415023e-11,
   6.346149393266186e-13,  -5.808667271417729e-15,   4.025114340088373e-17,   1.896318375357777e-19,   7.267275062887428e-01,  -7.125241167900908e-03,   6.985853252628195e-05,
  -6.848845134001520e-07,   6.712396921999724e-09,  -6.565156249744558e-11,   6.348331616272385e-13,  -5.807246675464438e-15,   4.007478736719975e-17,   1.969062086067784e-19,
   7.267353783159489e-01,  -7.125472641304304e-03,   6.986306956850289e-05,  -6.849584710622777e-07,   6.713469519055045e-09,  -6.566528949772094e-11,   6.349589548899419e-13,
  -5.806419030448274e-15,   3.997270304223959e-17,   2.011141625015335e-19,   7.267383343845466e-01,  -7.125559564022887e-03,   6.986477333540608e-05,  -6.849862442304098e-07,
   6.713872308153479e-09,  -6.567044395122120e-11,   6.350061636707164e-13,  -5.806106767317900e-15,   3.993431151068417e-17,   2.026961393780229e-19,   7.267388243975559e-01,
  -7.125573972821312e-03,   6.986505576245133e-05,  -6.849908481007595e-07,   6.713939077173894e-09,  -6.567129836659804e-11,   6.350139877322428e-13,  -5.806054927425891e-15,
   3.992794451157666e-17,   2.029584722299625e-19,   3.212194709100330e-03,  -3.030112686327814e-05,   2.858100870383128e-07,  -2.695602598584263e-09,   2.541989229820886e-11,
  -2.396040542931987e-13,   2.253466471607307e-15,  -2.097135519220921e-17,   1.864941812082407e-19,  -1.362069235124191e-21,   3.212235425678197e-03,  -3.030227888204727e-05,
   2.858318189714128e-07,  -2.695944102928383e-09,   2.542471139795263e-11,  -2.396668364519580e-13,   2.254209579248302e-15,  -2.097826169230378e-17,   1.864947351763229e-19,
  -1.359423309613219e-21,   3.212302270772117e-03,  -3.030417021286225e-05,   2.858674984347094e-07,  -2.696504802218042e-09,   2.543262387686344e-11,  -2.397699184006584e-13,
   2.255429509537299e-15,  -2.098958990665757e-17,   1.864951571619233e-19,  -1.355062909395309e-21,   3.212373201630287e-03,  -3.030617720452121e-05,   2.859053611507713e-07,
  -2.697099835361267e-09,   2.544102118709999e-11,  -2.398793165193987e-13,   2.256723947501156e-15,  -2.100159649692501e-17,   1.864949412847545e-19,  -1.350413480421487e-21,
   3.212429026794859e-03,  -3.030775682140266e-05,   2.859351622384224e-07,  -2.697568193193305e-09,   2.544763104284050e-11,  -2.399654280328896e-13,   2.257742674664472e-15,
  -2.101103593038733e-17,   1.864942899854166e-19,  -1.346737890606760e-21,   3.212461245473476e-03,  -3.030866849084470e-05,   2.859523622039065e-07,  -2.697838517161598e-09,
   2.545144617218323e-11,  -2.400151305282205e-13,   2.258330600901809e-15,  -2.101647966837866e-17,   1.864937208374662e-19,  -1.344610028038005e-21,   3.212473344074866e-03,
  -3.030901083965863e-05,   2.859588211840915e-07,  -2.697940031320743e-09,   2.545287887668635e-11,  -2.400337954161302e-13,   2.258551372812847e-15,  -2.101852309968409e-17,
   1.864934705508666e-19,  -1.343809744596255e-21,   3.212475349600043e-03,  -3.030906758929018e-05,   2.859598918642273e-07,  -2.697956859000007e-09,   2.545311637247555e-11,
  -2.400368894468395e-13,   2.258587968904075e-15,  -2.101886178826832e-17,   1.864934271323934e-19,  -1.343677020200537e-21,   2.913992166502042e-02,  -2.748813639298170e-04,
   2.592770439582595e-06,  -2.445357405007795e-08,   2.306002763447235e-10,  -2.173589695133049e-12,   2.044172887185772e-14,  -1.901968308625282e-16,   1.689696534745079e-18,
  -1.227513097652677e-20,   2.914029103175788e-02,  -2.748918146453904e-04,   2.592967583985078e-06,  -2.445667203615947e-08,   2.306439914400912e-10,  -2.174159082604701e-12,
   2.044846128212244e-14,  -1.902590508308844e-16,   1.689683290456433e-18,  -1.225046151244321e-20,   2.914089742737239e-02,  -2.749089721439691e-04,   2.593291255441808e-06,
  -2.446175846792179e-08,   2.307157672331933e-10,  -2.175093958276822e-12,   2.045951355936016e-14,  -1.903611024643161e-16,   1.689657026782555e-18,  -1.220980786968276e-20,
   2.914154088762957e-02,  -2.749271788776850e-04,   2.593634732592735e-06,  -2.446715636197653e-08,   2.307919410171259e-10,  -2.176086115613510e-12,   2.047124078587609e-14,
  -1.904692610838138e-16,   1.689623003753202e-18,  -1.216646064304601e-20,   2.914204731424948e-02,  -2.749415086153251e-04,   2.593905077504468e-06,  -2.447140510995898e-08,
   2.308519004087029e-10,  -2.176867080333863e-12,   2.048047010118047e-14,  -1.905542909727036e-16,   1.689591762419108e-18,  -1.213219346576181e-20,   2.914233959097872e-02,
  -2.749497789649698e-04,   2.594061109498654e-06,  -2.447385737681091e-08,   2.308865082440736e-10,  -2.177317843101783e-12,   2.048579648815670e-14,  -1.906033266194137e-16,
   1.689571939840421e-18,  -1.211235593141361e-20,   2.914244934531359e-02,  -2.749528846349205e-04,   2.594119703078851e-06,  -2.447477827112127e-08,   2.308995046049605e-10,
  -2.177487118971607e-12,   2.048779659328208e-14,  -1.906217330336509e-16,   1.689564157113905e-18,  -1.210489514937338e-20,   2.914246753874561e-02,  -2.749533994479365e-04,
   2.594129415909757e-06,  -2.447493092484129e-08,   2.309016589786664e-10,  -2.177515179395788e-12,   2.048812813900585e-14,  -1.906247837929347e-16,   1.689562849115742e-18,
  -1.210365780628654e-20,   8.229394666694759e-02,  -7.762914583625371e-04,   7.322233445728238e-06,  -6.905923555308490e-08,   6.512361154312115e-10,  -6.138332390211326e-12,
   5.772370562107145e-14,  -5.368423065906549e-16,   4.759005497222365e-18,  -3.417199885476120e-20,   8.229498979418762e-02,  -7.763209721839050e-04,   7.322790199347012e-06,
  -6.906798442226373e-08,   6.513595582520738e-10,  -6.139939480614559e-12,   5.774266502529043e-14,  -5.370153800849675e-16,   4.758856502432902e-18,  -3.409824864854526e-20,
   8.229670231380440e-02,  -7.763694266025664e-04,   7.323704276799827e-06,  -6.908234876155314e-08,   6.515622388767204e-10,  -6.142578152218925e-12,   5.777378945068273e-14,
  -5.372992316975821e-16,   4.758598526812101e-18,  -3.397671806945454e-20,   8.229851950754156e-02,  -7.764208441616482e-04,   7.324674287312594e-06,  -6.909759268476230e-08,
   6.517773384463069e-10,  -6.145378492825601e-12,   5.780681416403005e-14,  -5.376000434222907e-16,   4.758306582880950e-18,  -3.384714185463303e-20,   8.229994970508943e-02,
  -7.764613127125935e-04,   7.325437765765361e-06,  -6.910959136097709e-08,   6.519466517266046e-10,  -6.147582741769615e-12,   5.783280425799356e-14,  -5.378365102995670e-16,
   4.758063610462770e-18,  -3.374471304353572e-20,   8.230077512272148e-02,  -7.764846689717295e-04,   7.325878414209173e-06,  -6.911651668450702e-08,   6.520443772713571e-10,
  -6.148855003632413e-12,   5.784780343188982e-14,  -5.379728700713562e-16,   4.757918082428567e-18,  -3.368541811030827e-20,   8.230108507953343e-02,  -7.764934396809799e-04,
   7.326043887771005e-06,  -6.911911733576127e-08,   6.520810763663311e-10,  -6.149332778329755e-12,   5.785343572906202e-14,  -5.380240537229301e-16,   4.757862431726478e-18,
  -3.366311798637470e-20,   8.230113645953763e-02,  -7.764948935622206e-04,   7.326071317682581e-06,  -6.911954843744209e-08,   6.520871598816906e-10,  -6.149411977786526e-12,
   5.785436936071785e-14,  -5.380325370478815e-16,   4.757853153864024e-18,  -3.365941961220784e-20,   1.656675802567933e-01,  -1.562767767572037e-03,   1.474053335558428e-05,
  -1.390244729135455e-07,   1.311011986426956e-09,  -1.235687627999029e-11,   1.161851735831931e-13,  -1.079724411317903e-15,   9.536096956682344e-18,  -6.708230834073113e-20,
   1.656696801969183e-01,  -1.562827182410747e-03,   1.474165416336888e-05,  -1.390420849501165e-07,   1.311260447651327e-09,  -1.236010839976777e-11,   1.162231563228117e-13,
  -1.080063684021777e-15,   9.535409187721935e-18,  -6.691959191322062e-20,   1.656731277041060e-01,  -1.562924726928251e-03,   1.474349430427699e-05,  -1.390710012861213e-07,
   1.311668395568881e-09,  -1.236541517758383e-11,   1.162855089911146e-13,  -1.080620045053650e-15,   9.534251038040641e-18,  -6.665147196824200e-20,   1.656767859328398e-01,
  -1.563028236600233e-03,   1.474544704469996e-05,  -1.391016882765863e-07,   1.312101339490272e-09,  -1.237104707057741e-11,   1.163516670288035e-13,  -1.081209556007421e-15,
   9.532982579194213e-18,  -6.636562236360327e-20,   1.656796650918731e-01,  -1.563109704614289e-03,   1.474698401279562e-05,  -1.391258423745313e-07,   1.312442126300284e-09,
  -1.237548011732250e-11,   1.164037315708844e-13,  -1.081672900886982e-15,   9.531955588925092e-18,  -6.613967568726749e-20,   1.656813267564697e-01,  -1.563156723546292e-03,
   1.474787108772067e-05,  -1.391397834897480e-07,   1.312638824148350e-09,  -1.237803880265196e-11,   1.164337781498921e-13,  -1.081940063902550e-15,   9.531351367697156e-18,
  -6.600888350801069e-20,   1.656819507366718e-01,  -1.563174380028830e-03,   1.474820420462739e-05,  -1.391450187653200e-07,   1.312712690515382e-09,  -1.237899966872947e-11,
   1.164450607701389e-13,  -1.082040340397391e-15,   9.531122296107230e-18,  -6.595969522857089e-20,   1.656820541707767e-01,  -1.563177306864961e-03,   1.474825942412696e-05,
  -1.391458866002755e-07,   1.312724935153515e-09,  -1.237915894889909e-11,   1.164469310169940e-13,  -1.082056960240148e-15,   9.531084209128080e-18,  -6.595153763474304e-20,
   2.850858943136558e-01,  -2.689259087534495e-03,   2.536596450613101e-05,  -2.392374803941442e-07,   2.256017758018563e-09,  -2.126319351278597e-11,   1.998801693790091e-13,
  -1.855196171222049e-15,   1.628443733485684e-17,  -1.105683472908717e-19,   2.850895079553786e-01,  -2.689361330365217e-03,   2.536789321569899e-05,  -2.392677863734237e-07,
   2.256445194397379e-09,  -2.126874657750513e-11,   1.999450076904273e-13,  -1.855753947326634e-15,   1.628214166278727e-17,  -1.102471725518203e-19,   2.850954405320562e-01,
  -2.689529187886701e-03,   2.537105976873224e-05,  -2.393175442601430e-07,   2.257147000421646e-09,  -2.127786403134652e-11,   2.000514433404835e-13,  -1.856668423261493e-15,
   1.627831669720209e-17,  -1.097179848055817e-19,   2.851017357248665e-01,  -2.689707310423731e-03,   2.537442008526566e-05,  -2.393703489944255e-07,   2.257891806803606e-09,
  -2.128753998322160e-11,   2.001643702816679e-13,  -1.857637112883940e-15,   1.627418153012320e-17,  -1.091538524160821e-19,   2.851066902705118e-01,  -2.689847503016641e-03,
   2.537706493201252e-05,  -2.394119122246440e-07,   2.258478071767033e-09,  -2.129515618628072e-11,   2.002532374222097e-13,  -1.858398286186740e-15,   1.627087157633776e-17,
  -1.087079749856987e-19,   2.851095497141875e-01,  -2.689928414599618e-03,   2.537859142900977e-05,  -2.394359014332579e-07,   2.258816456194499e-09,  -2.129955211786125e-11,
   2.003045215754405e-13,  -1.858837095943497e-15,   1.626893903249657e-17,  -1.084498869076010e-19,   2.851106234785598e-01,  -2.689958798402261e-03,   2.537916466351158e-05,
  -2.394449100460136e-07,   2.258943530368733e-09,  -2.130120292302552e-11,   2.003237787508115e-13,  -1.859001782856509e-15,   1.626820912301635e-17,  -1.083528278442283e-19,
   2.851108014711569e-01,  -2.689963834989314e-03,   2.537925968637470e-05,  -2.394464033750188e-07,   2.258964595125402e-09,  -2.130147657231236e-11,   2.003269708750269e-13,
  -1.859029077291638e-15,   1.626808790734287e-17,  -1.083367312933866e-19,   4.524935880046096e-01,  -4.268441595134150e-03,   4.026132379553768e-05,  -3.797217910738013e-07,
   3.580760298770274e-09,  -3.374690387917906e-11,   3.171046028581281e-13,  -2.936872725001367e-15,   2.550075921441435e-17,  -1.619456929464152e-19,   4.524993236429266e-01,
  -4.268603876678305e-03,   4.026438504911191e-05,  -3.797698896204335e-07,   3.581438398597672e-09,  -3.375569354214507e-11,   3.172060705945988e-13,  -2.937685448925768e-15,
   2.549398320494549e-17,  -1.613185014178422e-19,   4.525087399372660e-01,  -4.268870302964363e-03,   4.026941101131500e-05,  -3.798488602176992e-07,   3.582551765716633e-09,
  -3.377012494125576e-11,   3.173726261787897e-13,  -2.939017316466053e-15,   2.548275196064699e-17,  -1.602851686930586e-19,   4.525187317825670e-01,  -4.269153022054447e-03,
   4.027474451522648e-05,  -3.799326664241358e-07,   3.583733346975458e-09,  -3.378544013970947e-11,   3.175493270021255e-13,  -2.940427329028349e-15,   2.547068860771110e-17,
  -1.591836916541606e-19,   4.525265957281353e-01,  -4.269375538097392e-03,   4.027894242326190e-05,  -3.799986312548641e-07,   3.584663411620439e-09,  -3.379749499412668e-11,
   3.176883714161386e-13,  -2.941534692162191e-15,   2.546108867050577e-17,  -1.583131748278700e-19,   4.525311342894939e-01,  -4.269503962323192e-03,   4.028136528341416e-05,
  -3.800367044187696e-07,   3.585200231834587e-09,  -3.380445277216791e-11,   3.177686085801129e-13,  -2.942172839482455e-15,   2.545550579393666e-17,  -1.578093180547448e-19,
   4.525328385879660e-01,  -4.269552188005852e-03,   4.028227512274626e-05,  -3.800510019452468e-07,   3.585401824828423e-09,  -3.380706561655259e-11,   3.177987368993896e-13,
  -2.942412293453680e-15,   2.545340131480284e-17,  -1.576198377902692e-19,   4.525331211010751e-01,  -4.269560182161541e-03,   4.028242594328753e-05,  -3.800533720005134e-07,
   3.585435242368094e-09,  -3.380749873974086e-11,   3.178037310185233e-13,  -2.942451977049846e-15,   2.545305204220635e-17,  -1.575884141037140e-19,   6.992436721462996e-01,
  -6.596073037984972e-03,   6.221628954733606e-05,  -5.867874902860254e-07,   5.533290112548378e-09,  -5.214189846299121e-11,   4.895543005051000e-13,  -4.513576852944432e-15,
   3.827768962143870e-17,  -2.052717673788426e-19,   6.992525354943767e-01,  -6.596323813070851e-03,   6.222102004629633e-05,  -5.868618060738361e-07,   5.534336926023385e-09,
  -5.215540321601577e-11,   4.897063793624847e-13,  -4.514591272344556e-15,   3.825657867593513e-17,  -2.038939212764103e-19,   6.992670866026675e-01,  -6.596735523931271e-03,
   6.222878657277836e-05,  -5.869838213679797e-07,   5.536055674211321e-09,  -5.217757562115579e-11,   4.899559793017761e-13,  -4.516251442944684e-15,   3.822169106881655e-17,
  -2.016238849815685e-19,   6.992825271164859e-01,  -6.597172412198690e-03,   6.223702833687624e-05,  -5.871133079199904e-07,   5.537879717471688e-09,  -5.220110519631794e-11,
   4.902207393390710e-13,  -4.518005978743921e-15,   3.818435864686823e-17,  -1.992042028709830e-19,   6.992946793622877e-01,  -6.597516268170442e-03,   6.224351528519718e-05,
  -5.872152281981795e-07,   5.539315479733856e-09,  -5.221962521916873e-11,   4.904290452013222e-13,  -4.519381702173168e-15,   3.815475003273487e-17,  -1.972919230670915e-19,
   6.993016928535061e-01,  -6.597714723239351e-03,   6.224725928515155e-05,  -5.872740538682096e-07,   5.540144178645774e-09,  -5.223031433613283e-11,   4.905492377688498e-13,
  -4.520173608257937e-15,   3.813757085154281e-17,  -1.961851066056174e-19,   6.993043265255927e-01,  -6.597789246804361e-03,   6.224866524260812e-05,  -5.872961445289298e-07,
   5.540455380797250e-09,  -5.223432836624262e-11,   4.905943665707736e-13,  -4.520470588732734e-15,   3.813110259053072e-17,  -1.957688801715439e-19,   6.993047630963588e-01,
  -6.597801600242356e-03,   6.224889830272624e-05,  -5.872998064268347e-07,   5.540506967929893e-09,  -5.223499375764632e-11,   4.906018470673084e-13,  -4.520519797009041e-15,
   3.813002947017119e-17,  -1.956998527075097e-19,   3.095367601211207e-03,  -2.813746693170548e-05,   2.557540279280051e-07,  -2.324470538899107e-09,   2.112437553472750e-11,
  -1.919374521781615e-13,   1.742605870916325e-15,  -1.576274501319802e-17,   1.402534000525165e-19,  -1.166027856185935e-21,   3.095404033202852e-03,  -2.813846026587958e-05,
   2.557720859676215e-07,  -2.324744078605640e-09,   2.112810196983498e-11,  -1.919846537329966e-13,   1.743165649865410e-15,  -1.576871040594798e-17,   1.402980700477848e-19,
  -1.165725814406681e-21,   3.095463844075968e-03,  -2.814009106923921e-05,   2.558017334649671e-07,  -2.325193186907811e-09,   2.113422038049672e-11,  -1.920621556066259e-13,
   1.744084745550555e-15,  -1.577850240602739e-17,   1.403712755041924e-19,  -1.165224746978138e-21,   3.095527310566902e-03,  -2.814182159257278e-05,   2.558331948811618e-07,
  -2.325669791593498e-09,   2.114071366194276e-11,  -1.921444085915364e-13,   1.745060150797033e-15,  -1.578889089105178e-17,   1.404487783610295e-19,  -1.164685972698622e-21,
   3.095577260862105e-03,  -2.814318360674895e-05,   2.558579574475879e-07,  -2.326044929825810e-09,   2.114582475928195e-11,  -1.922091547974584e-13,   1.745827925448893e-15,
  -1.579706552820809e-17,   1.405096473640438e-19,  -1.164256801746408e-21,   3.095606088889150e-03,  -2.814396968512418e-05,   2.558722493175204e-07,  -2.326261448613997e-09,
   2.114877481454116e-11,  -1.922465261792219e-13,   1.746271073506998e-15,  -1.580178280535546e-17,   1.405447253811182e-19,  -1.164007050025970e-21,   3.095616914238884e-03,
  -2.814426487167658e-05,   2.558776162285473e-07,  -2.326342757197215e-09,   2.114988265408970e-11,  -1.922605604648706e-13,   1.746437489509105e-15,  -1.580355410146069e-17,
   1.405578879345668e-19,  -1.163912874360151e-21,   3.095618708702882e-03,  -2.814431380340555e-05,   2.558785058799316e-07,  -2.326356235449968e-09,   2.115006629775308e-11,
  -1.922628868992533e-13,   1.746465075844492e-15,  -1.580384771447401e-17,   1.405600693099404e-19,  -1.163897242737273e-21,   2.808010646704264e-02,  -2.552533879274370e-04,
   2.320112260081106e-06,  -2.108679389254133e-08,   1.916329953804125e-10,  -1.741186727987246e-12,   1.580809801123008e-14,  -1.429826516302927e-16,   1.271810865639302e-18,
  -1.055732600119674e-20,   2.808043696549514e-02,  -2.552623991119631e-04,   2.320276076339622e-06,  -2.108927534492910e-08,   1.916667998158814e-10,  -1.741614887978083e-12,
   1.581317396269404e-14,  -1.430366578331063e-16,   1.272211320305943e-18,  -1.055440518626675e-20,   2.808097954909036e-02,  -2.552771931967544e-04,   2.320545028129909e-06,
  -2.109334949150469e-08,   1.917223031052655e-10,  -1.742317898519609e-12,   1.582150810527523e-14,  -1.431253065773185e-16,   1.272867546039604e-18,  -1.054956186095371e-20,
   2.808155529518856e-02,  -2.552928919067032e-04,   2.320830435161045e-06,  -2.109767307518385e-08,   1.917812070382775e-10,  -1.743064005528693e-12,   1.583035283137454e-14,
  -1.432193544558460e-16,   1.273562237373078e-18,  -1.054435690927009e-20,   2.808200842702464e-02,  -2.553052476288596e-04,   2.321055072555420e-06,  -2.110107619221121e-08,
   1.918275724571618e-10,  -1.743651310407134e-12,   1.583731480290505e-14,  -1.432933594819575e-16,   1.274107790880623e-18,  -1.054021284459914e-20,   2.808226994493505e-02,
  -2.553123786603617e-04,   2.321184723431023e-06,  -2.110304037156121e-08,   1.918543339394960e-10,  -1.743990301527677e-12,   1.584133314352620e-14,  -1.433360647351601e-16,
   1.274422169604997e-18,  -1.053780205662748e-20,   2.808236814877110e-02,  -2.553150564908052e-04,   2.321233410182083e-06,  -2.110377797332255e-08,   1.918643837267621e-10,
  -1.744117604756675e-12,   1.584284215551884e-14,  -1.433521001298349e-16,   1.274540132824544e-18,  -1.053689315533170e-20,   2.808238442752908e-02,  -2.553155003825489e-04,
   2.321241480790159e-06,  -2.110390024310718e-08,   1.918660496536896e-10,  -1.744138707547621e-12,   1.584309230034592e-14,  -1.433547581809785e-16,   1.274559682212457e-18,
  -1.053674230053246e-20,   7.930092642670486e-02,  -7.208601632760331e-04,   6.552220561115158e-06,  -5.955113476474952e-08,   5.411897541954655e-10,  -4.917257413406948e-12,
   4.464225501008767e-14,  -4.037269242211744e-16,   3.588563822945749e-18,  -2.969046188843435e-20,   7.930185978617713e-02,  -7.208856117280083e-04,   6.552683193749346e-06,
  -5.955814259267969e-08,   5.412852181672504e-10,  -4.918466358975205e-12,   4.465657681726624e-14,  -4.038787756277856e-16,   3.589665660951237e-18,  -2.968110999867953e-20,
   7.930339209452605e-02,  -7.209273916466355e-04,   6.553442739084040e-06,  -5.956964832123921e-08,   5.414419598404660e-10,  -4.920451366675324e-12,   4.468009153540079e-14,
  -4.041280285875051e-16,   3.591470986525409e-18,  -2.966561467029068e-20,   7.930501805697850e-02,  -7.209717263137173e-04,   6.554248755575208e-06,  -5.958185848060573e-08,
   5.416083049276376e-10,  -4.922558058863639e-12,   4.470504674953098e-14,  -4.043924564316905e-16,   3.593381781472324e-18,  -2.964897865491533e-20,   7.930629774494122e-02,
  -7.210066200616740e-04,   6.554883152853893e-06,  -5.959146916548438e-08,   5.417392411502209e-10,  -4.924216359282486e-12,   4.472468972921187e-14,  -4.046005269651434e-16,
   3.594882106554532e-18,  -2.963574508886950e-20,   7.930703629671650e-02,  -7.210267587806177e-04,   6.555249299205986e-06,  -5.959701617086871e-08,   5.418148157298188e-10,
  -4.925173526183184e-12,   4.473602731608343e-14,  -4.047205942050567e-16,   3.595746575389557e-18,  -2.962805115517467e-20,   7.930731363381109e-02,  -7.210343212313876e-04,
   6.555386795202021e-06,  -5.959909921939913e-08,   5.418431963851972e-10,  -4.925532976310492e-12,   4.474028492674078e-14,  -4.047656779293575e-16,   3.596070927428578e-18,
  -2.962515130083464e-20,   7.930735960659202e-02,  -7.210355748243725e-04,   6.555409587363571e-06,  -5.959944451940773e-08,   5.418479009720671e-10,  -4.925592561603370e-12,
   4.474099069899254e-14,  -4.047731510583601e-16,   3.596124679454178e-18,  -2.962467004343189e-20,   1.596422717062637e-01,  -1.451177926909628e-03,   1.319040540455465e-05,
  -1.198835629607471e-07,   1.089478867227927e-09,  -9.898954761477167e-12,   8.986564418841295e-14,  -8.125114839830711e-16,   7.213385396829098e-18,  -5.934194802398091e-20,
   1.596441506707614e-01,  -1.451229157689417e-03,   1.319133673860738e-05,  -1.198976704469326e-07,   1.089671037358607e-09,  -9.901387762013602e-12,   8.989443047693538e-14,
  -8.128148804673439e-16,   7.215503011651204e-18,  -5.931929439225824e-20,   1.596472353911427e-01,  -1.451313265666279e-03,   1.319286579293593e-05,  -1.199208326739359e-07,
   1.089986560175439e-09,  -9.905382581208221e-12,   8.994169388437310e-14,  -8.133128686944362e-16,   7.218971733490005e-18,  -5.928179587699622e-20,   1.596505086484602e-01,
  -1.451402516657511e-03,   1.319448839917386e-05,  -1.199454129922943e-07,   1.090321414683241e-09,  -9.909622283316744e-12,   8.999185223120065e-14,  -8.138411549033508e-16,
   7.222641845639460e-18,  -5.924158645428697e-20,   1.596530848137227e-01,  -1.451472761948530e-03,   1.319576551569429e-05,  -1.199647602978925e-07,   1.090584990685615e-09,
  -9.912959595601844e-12,   9.003133305468012e-14,  -8.142568331469108e-16,   7.225522643554111e-18,  -5.920963630320248e-20,   1.596545716069749e-01,  -1.451513303600123e-03,
   1.319650261146890e-05,  -1.199759269948286e-07,   1.090737123087277e-09,  -9.914885882080955e-12,   9.005412058819852e-14,  -8.144966946413888e-16,   7.227182155727656e-18,
  -5.919107474035592e-20,   1.596551299197902e-01,  -1.451528527718654e-03,   1.319677940711890e-05,  -1.199801203874269e-07,   1.090794253631659e-09,  -9.915609270626981e-12,
   9.006267798277106e-14,  -8.145867584682274e-16,   7.227804741317091e-18,  -5.918408151056751e-20,   1.596552224685088e-01,  -1.451531051351372e-03,   1.319682529042714e-05,
  -1.199808155121313e-07,   1.090803724012017e-09,  -9.915729185208215e-12,   9.006409651709500e-14,  -8.146016874906877e-16,   7.227907913293652e-18,  -5.918292105929524e-20,
   2.747173570776224e-01,  -2.497231843929350e-03,   2.269845722186927e-05,  -2.062993128928285e-07,   1.874806187795981e-09,  -1.703422219756220e-11,   1.546308512040480e-13,
  -1.397525545169566e-15,   1.238259786634411e-17,  -1.009073403179537e-19,   2.747205904577877e-01,  -2.497320003425767e-03,   2.270005988780667e-05,  -2.063235891813339e-07,
   1.875136851410275e-09,  -1.703840687543112e-11,   1.546802603722371e-13,  -1.398041144331684e-15,   1.238595634285570e-17,  -1.008574161454080e-19,   2.747258987399334e-01,
  -2.497464739010706e-03,   2.270269112765552e-05,  -2.063634469467347e-07,   1.875679765533261e-09,  -1.704527781442105e-11,   1.547613831072322e-13,  -1.398887394469459e-15,
   1.239145487264455e-17,  -1.007748630228424e-19,   2.747315314622642e-01,  -2.497618324852300e-03,   2.270548335424635e-05,  -2.064057449733659e-07,   1.876255943067366e-09,
  -1.705256992422014e-11,   1.548474736076917e-13,  -1.399785072738896e-15,   1.239726886826641e-17,  -1.006864583020977e-19,   2.747359646070472e-01,  -2.497739205102272e-03,
   2.270768105236673e-05,  -2.064390379837788e-07,   1.876709472895104e-09,  -1.705830994786498e-11,   1.549152366840494e-13,  -1.400491362113714e-15,   1.240182972826511e-17,
  -1.006162960733868e-19,   2.747385231268151e-01,  -2.497808970418993e-03,   2.270894946755313e-05,  -2.064582537313627e-07,   1.876971243925484e-09,  -1.706162306659158e-11,
   1.549543478423516e-13,  -1.400898899791731e-15,   1.240445595094118e-17,  -1.005755682970488e-19,   2.747394838887585e-01,  -2.497835168548794e-03,   2.270942578530870e-05,
  -2.064654697570451e-07,   1.877069547239569e-09,  -1.706286725855690e-11,   1.549690351815096e-13,  -1.401051919890762e-15,   1.240544099971801e-17,  -1.005602300010352e-19,
   2.747396431494531e-01,  -2.497839511293327e-03,   2.270950474259860e-05,  -2.064666659335456e-07,   1.877085842721105e-09,  -1.706307350555943e-11,   1.549714698556598e-13,
  -1.401077284404445e-15,   1.240560422632347e-17,  -1.005576851043762e-19,   4.360364545544649e-01,  -3.963652425038709e-03,   3.602740923074082e-05,  -3.274419969850728e-07,
   2.975719696773891e-09,  -2.703648373966432e-11,   2.453987574093523e-13,  -2.216368945519454e-15,   1.957106133681098e-17,  -1.568404351506120e-19,   4.360415866349836e-01,
  -3.963792353381446e-03,   3.602995300503543e-05,  -3.274805279298816e-07,   2.976244455056106e-09,  -2.704312004348075e-11,   2.454768339940696e-13,  -2.217169469877766e-15,
   1.957560017761126e-17,  -1.567305436723495e-19,   4.360500120381197e-01,  -3.964022080312016e-03,   3.603412934650326e-05,  -3.275437895448925e-07,   2.977106051241468e-09,
  -2.705401633773345e-11,   2.456050222551183e-13,  -2.218483244792053e-15,   1.958302278663108e-17,  -1.565490143667279e-19,   4.360589523986891e-01,  -3.964265854529194e-03,
   3.603856120836167e-05,  -3.276109242959971e-07,   2.978020435221337e-09,  -2.706558049547961e-11,   2.457410574099791e-13,  -2.219876694684253e-15,   1.959085974438644e-17,
  -1.563548663660929e-19,   4.360659887676923e-01,  -3.964457717841353e-03,   3.604204942610702e-05,  -3.276637664236698e-07,   2.978740178850003e-09,  -2.707468324759138e-11,
   2.458481304282441e-13,  -2.220972934860802e-15,   1.959699916068700e-17,  -1.562009598550458e-19,   4.360700496973637e-01,  -3.964568450609779e-03,   3.604406267273021e-05,
  -3.276942653451365e-07,   2.979155604528702e-09,  -2.707993730482984e-11,   2.459099294143880e-13,  -2.221605430671816e-15,   1.960053096632146e-17,  -1.561116913056751e-19,
   4.360715746364054e-01,  -3.964610032753677e-03,   3.604481869104240e-05,  -3.277057185030841e-07,   2.979311609991024e-09,  -2.708191038426884e-11,   2.459331365019752e-13,
  -2.221842907723385e-15,   1.960185504234073e-17,  -1.560780856731175e-19,   4.360718274179115e-01,  -3.964616925636085e-03,   3.604494401317507e-05,  -3.277076170548393e-07,
   2.979337470603651e-09,  -2.708223745721721e-11,   2.459369834592049e-13,  -2.221882271284862e-15,   1.960207441329202e-17,  -1.560725106036181e-19,   6.738122700449665e-01,
  -6.125078777949114e-03,   5.567357812375484e-05,  -5.059997457208196e-07,   4.598392664795854e-09,  -4.177811541800623e-11,   3.791115130833005e-13,  -3.419296952809823e-15,
   2.997965531125112e-17,  -2.316303296920423e-19,   6.738202007091563e-01,  -6.125295010758506e-03,   5.567750902795765e-05,  -5.060592854988562e-07,   4.599203340307426e-09,
  -4.178835266068435e-11,   3.792310603944058e-13,  -3.420476224277176e-15,   2.998406044766574e-17,  -2.313575198096427e-19,   6.738332205833929e-01,  -6.125650010314028e-03,
   5.568396274434377e-05,  -5.061570402211181e-07,   4.600534379893876e-09,  -4.180516129424018e-11,   3.794273289948125e-13,  -3.422411161143262e-15,   2.999123109062733e-17,
  -2.309072803072408e-19,   6.738470362273847e-01,  -6.126026717295124e-03,   5.569081131715938e-05,  -5.062607798642434e-07,   4.601946966582345e-09,  -4.182300000840815e-11,
   3.796356018258491e-13,  -3.424462876563827e-15,   2.999875646152147e-17,  -2.304263031869384e-19,   6.738579096108873e-01,  -6.126323205782493e-03,   5.569620167302624e-05,
  -5.063424338833040e-07,   4.603058861335047e-09,  -4.183704167066283e-11,   3.797995256364113e-13,  -3.426076568362696e-15,   3.000461855103009e-17,  -2.300454220809583e-19,
   6.738641850131110e-01,  -6.126494322347621e-03,   5.569931275046789e-05,  -5.063895621735232e-07,   4.603700630338926e-09,  -4.184514639052063e-11,   3.798941340571425e-13,
  -3.427007451719173e-15,   3.000797740928591e-17,  -2.298246646593341e-19,   6.738665415192873e-01,  -6.126558579691936e-03,   5.570048102834642e-05,  -5.064072601013038e-07,
   4.603941634741811e-09,  -4.184818998276936e-11,   3.799296613611658e-13,  -3.427356930081404e-15,   3.000923410103811e-17,  -2.297415895258471e-19,   6.738669321455117e-01,
  -6.126569231338931e-03,   5.570067468909836e-05,  -5.064101938276325e-07,   4.603981585397194e-09,  -4.184869451173800e-11,   3.799355505678098e-13,  -3.427414857025156e-15,
   3.000944217324096e-17,  -2.297278092104619e-19,   2.986740883018688e-03,  -2.619754115519184e-05,   2.297686144611202e-07,  -2.015059578748364e-09,   1.767056574193835e-11,
  -1.549408226310346e-13,   1.358171373912202e-15,  -1.189024113206362e-17,   1.034921410837649e-19,  -8.790556167678193e-22,   2.986773611155256e-03,  -2.619840220863837e-05,
   2.297837188254904e-07,  -2.015280371606235e-09,   1.767346981887342e-11,  -1.549764281544096e-13,   1.358584645330854e-15,  -1.189475095721454e-17,   1.035353411851029e-19,
  -8.792940624344903e-22,   2.986827341246083e-03,  -2.619981583546935e-05,   2.298085168786754e-07,  -2.015642875479987e-09,   1.767823796940710e-11,  -1.550348901306560e-13,
   1.359263221562305e-15,  -1.190215543772288e-17,   1.036062395329239e-19,  -8.796841192592374e-22,   2.986884355142808e-03,  -2.620131589555669e-05,   2.298348319689996e-07,
  -2.016027569944315e-09,   1.768329821320405e-11,  -1.550969360544542e-13,   1.359983412311141e-15,  -1.191001334701045e-17,   1.036814386631744e-19,  -8.800961057538202e-22,
   2.986929226912515e-03,  -2.620249651789768e-05,   2.298555438496889e-07,  -2.016330362597460e-09,   1.768728127988949e-11,  -1.551457761157602e-13,   1.360550328492483e-15,
  -1.191619841734298e-17,   1.037405993180460e-19,  -8.804189665869257e-22,   2.986955123902948e-03,  -2.620317790506387e-05,   2.298674977891345e-07,  -2.016505124625978e-09,
   1.768958023741297e-11,  -1.551739665159044e-13,   1.360877555912537e-15,  -1.191976828413867e-17,   1.037747334554433e-19,  -8.806047437059156e-22,   2.986964848596560e-03,
  -2.620343377781009e-05,   2.298719867461089e-07,  -2.016570752240181e-09,   1.769044356642982e-11,  -1.551845530183967e-13,   1.361000442324294e-15,  -1.192110886912743e-17,
   1.037875495277498e-19,  -8.806744003585440e-22,   2.986966460609853e-03,  -2.620347619264879e-05,   2.298727308620424e-07,  -2.016581631100885e-09,   1.769058667808338e-11,
  -1.551863079210665e-13,   1.361020812994577e-15,  -1.192133109367912e-17,   1.037896738887943e-19,  -8.806859414294785e-22,   2.709468237373679e-02,  -2.376550508934863e-04,
   2.084381561544348e-06,  -1.827992486005741e-08,   1.603012625491372e-10,  -1.405568858716571e-12,   1.232081154226171e-14,  -1.078614854421969e-16,   9.387217853914062e-19,
  -7.969520874724963e-21,   2.709497927209500e-02,  -2.376628620730963e-04,   2.084518583114718e-06,  -1.828192781543825e-08,   1.603276072190258e-10,  -1.405891851302344e-12,
   1.232456008213077e-14,  -1.079023703100329e-16,   9.391124888508133e-19,  -7.971637438099965e-21,   2.709546669293303e-02,  -2.376756860076876e-04,   2.084743542477798e-06,
  -1.828521632345248e-08,   1.603708620474344e-10,  -1.406422184269985e-12,   1.233071504124331e-14,  -1.079694971793694e-16,   9.397536882643867e-19,  -7.975099226334642e-21,
   2.709598390332468e-02,  -2.376892940349412e-04,   2.084982263877101e-06,  -1.828870613671048e-08,   1.604167666325563e-10,  -1.406985028643936e-12,   1.233724745622331e-14,
  -1.080407344716939e-16,   9.404337725910185e-19,  -7.978754887927837e-21,   2.709639096453113e-02,  -2.377000042332375e-04,   2.085170154896194e-06,  -1.829145296545398e-08,
   1.604528994805215e-10,  -1.407428077092515e-12,   1.234238960695744e-14,  -1.080968061736873e-16,   9.409688004669532e-19,  -7.981619164694360e-21,   2.709662589308949e-02,
  -2.377061855423768e-04,   2.085278596900940e-06,  -1.829303834527471e-08,   1.604737547380385e-10,  -1.407683803879576e-12,   1.234535768588158e-14,  -1.081291692803978e-16,
   9.412774942155383e-19,  -7.983267074264977e-21,   2.709671411215328e-02,  -2.377085067315965e-04,   2.085319319166238e-06,  -1.829363369596965e-08,   1.604815865264247e-10,
  -1.407779838420964e-12,   1.234647231278831e-14,  -1.081413225208666e-16,   9.413933963848278e-19,  -7.983884911606717e-21,   2.709672873578146e-02,  -2.377088915043705e-04,
   2.085326069528655e-06,  -1.829373238517780e-08,   1.604828847802326e-10,  -1.407795757868471e-12,   1.234665708257090e-14,  -1.081433371245931e-16,   9.414126080149277e-19,
  -7.983987275835438e-21,   7.651799383325292e-02,  -6.711607638407902e-04,   5.886494372967958e-06,  -5.162426856568802e-08,   4.527061479293976e-10,  -3.969457044713220e-12,
   3.479485480513991e-14,  -3.045950349998860e-16,   2.650294874900899e-18,  -2.247657190118274e-20,   7.651883230282439e-02,  -6.711828233643724e-04,   5.886881335027407e-06,
  -5.162992509734924e-08,   4.527805471290148e-10,  -3.970369155901823e-12,   3.480543791955282e-14,  -3.047103358388789e-16,   2.651391013639827e-18,  -2.248226616288887e-20,
   7.652020882623681e-02,  -6.712190393908422e-04,   5.887516641849069e-06,  -5.163921214876030e-08,   4.529027018002130e-10,  -3.971866783230320e-12,   3.482281496850342e-14,
  -3.048996416291433e-16,   2.653189882172861e-18,  -2.249157608963405e-20,   7.652166947821908e-02,  -6.712574697705096e-04,   5.888190813980632e-06,  -5.164906770476543e-08,
   4.530323395638666e-10,  -3.973456220284389e-12,   3.484125764593717e-14,  -3.051005378990520e-16,   2.655097773809232e-18,  -2.250140270641149e-20,   7.652281905828877e-02,
  -6.712877164020852e-04,   5.888721436242026e-06,  -5.165682500360516e-08,   4.531343812526539e-10,  -3.974707360854827e-12,   3.485577523202467e-14,  -3.052586646721617e-16,
   2.656598678650508e-18,  -2.250909860919539e-20,   7.652348251917433e-02,  -6.713051730144658e-04,   5.889027686865577e-06,  -5.166130226306879e-08,   4.531932779560349e-10,
  -3.975429516861098e-12,   3.486415485803432e-14,  -3.053499308632826e-16,   2.657464632403806e-18,  -2.251352492373127e-20,   7.652373165831089e-02,  -6.713117282763948e-04,
   5.889142690448973e-06,  -5.166298358857325e-08,   4.532153954729101e-10,  -3.975700712206376e-12,   3.486730172587380e-14,  -3.053842037614006e-16,   2.657789759709369e-18,
  -2.251518418327747e-20,   7.652377295684593e-02,  -6.713128149117690e-04,   5.889161754119952e-06,  -5.166326229603753e-08,   4.532190618322321e-10,  -3.975745667697088e-12,
   3.486782337665551e-14,  -3.053898850658003e-16,   2.657843651735177e-18,  -2.251545907803558e-20,   1.540398947710839e-01,  -1.351127078094468e-03,   1.185021884398672e-05,
  -1.039258392125270e-07,   9.113515306095751e-10,  -7.990976419588720e-12,   7.004517846952549e-14,  -6.131310776828758e-16,   5.332810645017892e-18,  -4.514476011960500e-20,
   1.540415827108464e-01,  -1.351171486558938e-03,   1.185099784480402e-05,  -1.039372264639506e-07,   9.115013027794125e-10,  -7.992812434735011e-12,   7.006647286393386e-14,
  -6.133626366363435e-16,   5.334992384263997e-18,  -4.515524650543412e-20,   1.540443538174922e-01,  -1.351244393760155e-03,   1.185227679327108e-05,  -1.039559223706873e-07,
   9.117472109215205e-10,  -7.995827051183304e-12,   7.010143733507912e-14,  -6.137428163501854e-16,   5.338572654460698e-18,  -4.517237889296531e-20,   1.540472942850342e-01,
  -1.351321758719704e-03,   1.185363398224424e-05,  -1.039757627425658e-07,   9.120081831675224e-10,  -7.999026472433715e-12,   7.013854586941081e-14,  -6.141462681810326e-16,
   5.342369676985532e-18,  -4.519044500954884e-20,   1.540496085275252e-01,  -1.351382648813642e-03,   1.185470218819252e-05,  -1.039913790803889e-07,   9.122136020661036e-10,
  -8.001544926296975e-12,   7.016775665379451e-14,  -6.144638242428656e-16,   5.345356557038912e-18,  -4.520458135855869e-20,   1.540509441538230e-01,  -1.351417791066258e-03,
   1.185531870725181e-05,  -1.040003923203322e-07,   9.123321663061037e-10,  -8.002998572709887e-12,   7.018461724247710e-14,  -6.146471069839943e-16,   5.347079782153434e-18,
  -4.521270687378019e-20,   1.540514457007714e-01,  -1.351430987594063e-03,   1.185555022319191e-05,  -1.040037770225719e-07,   9.123766908101326e-10,  -8.003544468712831e-12,
   7.019094902869556e-14,  -6.147159342921936e-16,   5.347726763908438e-18,  -4.521575186891954e-20,   1.540515288396733e-01,  -1.351433175121287e-03,   1.185558860063701e-05,
  -1.040043380928554e-07,   9.123840715133956e-10,  -8.003634960757983e-12,   7.019199863755450e-14,  -6.147273435521541e-16,   5.347834004775795e-18,  -4.521625629229993e-20,
   2.650766136320775e-01,  -2.325061250800907e-03,   2.039222293131238e-05,  -1.788387911393297e-07,   1.568281294575664e-09,  -1.375107376935559e-11,   1.205330389739856e-13,
  -1.054941275397210e-15,   9.169744221669734e-18,  -7.739694816946315e-20,   2.650795182910015e-01,  -2.325137670256716e-03,   2.039356345945773e-05,  -1.788583866047631e-07,
   1.568539020673674e-09,  -1.375423275678755e-11,   1.205696531846483e-13,  -1.055338191068463e-15,   9.173428393213115e-18,  -7.741222582224335e-20,   2.650842868969833e-01,
  -2.325263131217976e-03,   2.039576431262159e-05,  -1.788905589855173e-07,   1.568962176318697e-09,  -1.375941960367412e-11,   1.206297719329141e-13,  -1.055989847765600e-15,
   9.179473682471725e-18,  -7.743714711903831e-20,   2.650893469444310e-01,  -2.325396263227280e-03,   2.039809980440676e-05,  -1.789247007896405e-07,   1.569411254022782e-09,
  -1.376492441496647e-11,   1.206935769675626e-13,  -1.056681380836565e-15,   9.185884280526441e-18,  -7.746337334830347e-20,   2.650933293644517e-01,  -2.325501044779526e-03,
   2.039993800546864e-05,  -1.789515737706805e-07,   1.569764736192010e-09,  -1.376925757455679e-11,   1.207438022848878e-13,  -1.057225675007010e-15,   9.190926604672240e-18,
  -7.748385588471414e-20,   2.650956277514742e-01,  -2.325561518652037e-03,   2.040099893008675e-05,  -1.789670839770914e-07,   1.569968759976233e-09,  -1.377175866409461e-11,
   1.207727924732266e-13,  -1.057539819381314e-15,   9.193835482325302e-18,  -7.749561343694649e-20,   2.650964908289679e-01,  -2.325584227644221e-03,   2.040139732970870e-05,
  -1.789729084564540e-07,   1.570045377153532e-09,  -1.377269791205102e-11,   1.207836793663117e-13,  -1.057657787783647e-15,   9.194927577722046e-18,  -7.750001653125009e-20,
   2.650966338969604e-01,  -2.325587992008557e-03,   2.040146337077528e-05,  -1.789738739600785e-07,   1.570058077769851e-09,  -1.377285360921844e-11,   1.207854840662976e-13,
  -1.057677342949159e-15,   9.195108596702943e-18,  -7.750074577459982e-20,   4.207344888025409e-01,  -3.690380087536450e-03,   3.236691211425054e-05,  -2.838562105110631e-07,
   2.489203415241346e-09,  -2.182583735556673e-11,   1.913046260613598e-13,  -1.674011071125258e-15,   1.453520809394509e-17,  -1.220605990625331e-19,   4.207390991307223e-01,
  -3.690501381898162e-03,   3.236903982379942e-05,  -2.838873126126460e-07,   2.489612465595366e-09,  -2.183085006188923e-11,   1.913626603790511e-13,  -1.674636833748777e-15,
   1.454086355493958e-17,  -1.220772108337318e-19,   4.207466679500285e-01,  -3.690700515836638e-03,   3.237253305614533e-05,  -2.839383769076828e-07,   2.490284077574813e-09,
  -2.183908058276602e-11,   1.914579493611267e-13,  -1.675664183633604e-15,   1.455014208715951e-17,  -1.221041804297077e-19,   4.207546993506009e-01,  -3.690911825403166e-03,
   3.237623998923345e-05,  -2.839925670875687e-07,   2.490996831613877e-09,  -2.184781563938463e-11,   1.915590804219756e-13,  -1.676754361195758e-15,   1.455997938714721e-17,
  -1.221323868033224e-19,   4.207610203210589e-01,  -3.691078136604306e-03,   3.237915761384564e-05,  -2.840352201244836e-07,   2.491557861001744e-09,  -2.185469150556262e-11,
   1.916386870821001e-13,  -1.677612394054726e-15,   1.456771562416321e-17,  -1.221542874502549e-19,   4.207646683633032e-01,  -3.691174121843661e-03,   3.238084153179877e-05,
  -2.840598380629020e-07,   2.491881677396243e-09,  -2.185866023582500e-11,   1.916846360470328e-13,  -1.678107604440355e-15,   1.457217803805169e-17,  -1.221668070784519e-19,
   4.207660382558087e-01,  -3.691210165972465e-03,   3.238147387858722e-05,  -2.840690827285701e-07,   2.492003280357014e-09,  -2.186015063433078e-11,   1.917018915505494e-13,
  -1.678293565163244e-15,   1.457385327954984e-17,  -1.221714856766979e-19,   4.207662653359633e-01,  -3.691216140840566e-03,   3.238157870011325e-05,  -2.840706151845414e-07,
   2.492023438141014e-09,  -2.186039769453551e-11,   1.917047519610890e-13,  -1.678324391041177e-15,   1.457413095161237e-17,  -1.221722600259062e-19,   6.501659621197792e-01,
  -5.702787822875255e-03,   5.001697022372547e-05,  -4.386462976696710e-07,   3.846590654438563e-09,  -3.372735963369017e-11,   2.956020002171355e-13,  -2.585601402241665e-15,
   2.240160580701997e-17,  -1.861405662151947e-19,   6.501730865141691e-01,  -5.702975260458696e-03,   5.002025819403738e-05,  -4.386943595617152e-07,   3.847222712046578e-09,
  -3.373510182431679e-11,   2.956914300779666e-13,  -2.586555016204335e-15,   2.240972833894615e-17,  -1.861413095144215e-19,   6.501847826997075e-01,  -5.703282984442407e-03,
   5.002565632000896e-05,  -4.387732689081074e-07,   3.848260475002648e-09,  -3.374781394343178e-11,   2.958382669896131e-13,  -2.588120525896592e-15,   2.242304960105420e-17,
  -1.861419001122890e-19,   6.501971937175191e-01,  -5.703609523565059e-03,   5.003138467977413e-05,  -4.388570086598468e-07,   3.849361809419789e-09,  -3.376130528434952e-11,
   2.959941039774204e-13,  -2.589781648726114e-15,   2.243716650927524e-17,  -1.861416690396293e-19,   6.502069615875474e-01,  -5.703866526191883e-03,   5.003589331343975e-05,
  -4.389229201314242e-07,   3.850228701320506e-09,  -3.377192506786728e-11,   2.961167714235171e-13,  -2.591088957249103e-15,   2.244826352780954e-17,  -1.861408645846480e-19,
   6.502125989501545e-01,  -5.704014853294746e-03,   5.003849548820329e-05,  -4.389609620762859e-07,   3.850729056079654e-09,  -3.377805476525123e-11,   2.961875743865095e-13,
  -2.591843428674571e-15,   2.245466258360831e-17,  -1.861401502317622e-19,   6.502147158611629e-01,  -5.704070552704732e-03,   5.003947265983299e-05,  -4.389752477994850e-07,
   3.850916954567324e-09,  -3.378035668117189e-11,   2.962141633378581e-13,  -2.592126739800729e-15,   2.245706449854366e-17,  -1.861398346545840e-19,   6.502150667707978e-01,
  -5.704079785737655e-03,   5.003963464155442e-05,  -4.389776158939576e-07,   3.850948101974586e-09,  -3.378073826478793e-11,   2.962185709286292e-13,  -2.592173702653252e-15,
   2.245746259783659e-17,  -1.861397798447452e-19,   2.885480360537423e-03,  -2.445153324490563e-05,   2.071874559377139e-07,  -1.755456822055224e-09,   1.487255989681599e-11,
  -1.259930492169453e-13,   1.067206980106000e-15,  -9.035563675390525e-18,   7.634792042099193e-20,  -6.395448421957207e-22,   2.885509870397753e-03,  -2.445228332240673e-05,
   2.072001677144045e-07,  -1.755636347893483e-09,   1.487484159062311e-11,  -1.260201040813498e-13,   1.067511884955851e-15,  -9.038847714068353e-18,   7.638109422135280e-20,
  -6.398285066106197e-22,   2.885558316920461e-03,  -2.445351475150638e-05,   2.072210375630625e-07,  -1.755931096470590e-09,   1.487858783118840e-11,  -1.260645261197373e-13,
   1.068012531193213e-15,  -9.044240043517659e-18,   7.643555853144910e-20,  -6.402939137324602e-22,   2.885609724207551e-03,  -2.445482146837963e-05,   2.072431840019568e-07,
  -1.756243885359579e-09,   1.488256352207314e-11,  -1.261116709865691e-13,   1.068543885455715e-15,  -9.049963146246982e-18,   7.649335497756382e-20,  -6.407873730544518e-22,
   2.885650183303078e-03,  -2.445584991603952e-05,   2.072606147534769e-07,  -1.756490079279981e-09,   1.488569287521379e-11,  -1.261487812329978e-13,   1.068962158117222e-15,
  -9.054468289053737e-18,   7.653884511491669e-20,  -6.411754565955555e-22,   2.885673533555566e-03,  -2.445644347518821e-05,   2.072706749373457e-07,  -1.756632173598470e-09,
   1.488749907192873e-11,  -1.261702010835492e-13,   1.069203589156868e-15,  -9.057068708147956e-18,   7.656509996956212e-20,  -6.413993180076058e-22,   2.885682301905348e-03,
  -2.445666636668910e-05,   2.072744527415813e-07,  -1.756685533505929e-09,   1.488817735188126e-11,  -1.261782449800122e-13,   1.069294256040368e-15,  -9.058045269436248e-18,
   7.657495923121891e-20,  -6.414833595153729e-22,   2.885683755389990e-03,  -2.445670331436411e-05,   2.072750789722555e-07,  -1.756694378783993e-09,   1.488828978834522e-11,
  -1.261795783989284e-13,   1.069309285750098e-15,  -9.058207152565660e-18,   7.657659356090294e-20,  -6.414972895063567e-22,   2.617608186533678e-02,  -2.218158697949881e-04,
   1.879533086323685e-06,  -1.592489834457319e-08,   1.349187276155177e-10,  -1.142965278295547e-12,   9.681322177722858e-15,  -8.196691043481635e-17,   6.925736685782811e-19,
  -5.800565407715865e-21,   2.617634956860391e-02,  -2.218226742391669e-04,   1.879648403172070e-06,  -1.592652694074546e-08,   1.349394263288831e-10,  -1.143210708779678e-12,
   9.684088050476630e-15,  -8.199669582387465e-17,   6.928743231976337e-19,  -5.803127248705712e-21,   2.617678905873585e-02,  -2.218338453388951e-04,   1.879837727232103e-06,
  -1.592920079766075e-08,   1.349734108885131e-10,  -1.143613687034005e-12,   9.688629544467854e-15,  -8.204560282883765e-17,   6.933679321370708e-19,  -5.807330366782305e-21,
   2.617725540790031e-02,  -2.218456994233175e-04,   1.880038632077894e-06,  -1.593203831002900e-08,   1.350094769394413e-10,  -1.144041365637314e-12,   9.693449597960772e-15,
  -8.209750980428193e-17,   6.938917376108947e-19,  -5.811786710464963e-21,   2.617762243884984e-02,  -2.218550291454889e-04,   1.880196757836284e-06,  -1.593427169592636e-08,
   1.350378653157768e-10,  -1.144378014329082e-12,   9.697243857883391e-15,  -8.213837017600076e-17,   6.943040099508107e-19,  -5.815291340299743e-21,   2.617783426428071e-02,
  -2.218604137092013e-04,   1.880288020350231e-06,  -1.593556072632280e-08,   1.350542504885424e-10,  -1.144572326282364e-12,   9.699433941217140e-15,  -8.216195522578981e-17,
   6.945419541997072e-19,  -5.817312910963547e-21,   2.617791380772339e-02,  -2.218624357039598e-04,   1.880322291285655e-06,  -1.593604478890444e-08,   1.350604036024801e-10,
  -1.144645297156209e-12,   9.700256403880797e-15,  -8.217081235141148e-17,   6.946313072336320e-19,  -5.818071837730335e-21,   2.617792699323438e-02,  -2.218627708805139e-04,
   1.880327972234073e-06,  -1.593612503020055e-08,   1.350614235859993e-10,  -1.144657393376435e-12,   9.700392742247504e-15,  -8.217228058394479e-17,   6.946461189150338e-19,
  -5.818197630507894e-21,   7.392377748238854e-02,  -6.264293901966584e-04,   5.307982544145832e-06,  -4.497344728602245e-08,   3.810234736166443e-10,  -3.227843021313218e-12,
   2.734091928004196e-14,  -2.314788048766151e-16,   1.955723689679109e-18,  -1.637430922159574e-20,   7.392453350221029e-02,  -6.264486066026205e-04,   5.308308210024833e-06,
  -4.497804659693718e-08,   3.810819286251722e-10,  -3.228536129135893e-12,   2.734872965323162e-14,  -2.315628837065900e-16,   1.956571030362687e-18,  -1.638147453250854e-20,
   7.392577466469130e-02,  -6.264801548645765e-04,   5.308842879392574e-06,  -4.498559782386814e-08,   3.811779040447663e-10,  -3.229674159571417e-12,   2.736155408612115e-14,
  -2.317009391918440e-16,   1.957962166535145e-18,  -1.639322987637328e-20,   7.392709167966824e-02,  -6.265136319411130e-04,   5.309410254013799e-06,  -4.499361122938968e-08,
   3.812797577794589e-10,  -3.230881944899513e-12,   2.737516511867688e-14,  -2.318474627031333e-16,   1.959438389985456e-18,  -1.640569273972407e-20,   7.392812821043611e-02,
  -6.265399799754327e-04,   5.309856816374704e-06,  -4.499991852413439e-08,   3.813599290773442e-10,  -3.231832657218374e-12,   2.738587947533438e-14,  -2.319628035085476e-16,
   1.960600272081540e-18,  -1.641549347343305e-20,   7.392872642586397e-02,  -6.265551865021528e-04,   5.310114550497841e-06,  -4.500355886888822e-08,   3.814062022610866e-10,
  -3.232381403616215e-12,   2.739206390315965e-14,  -2.320293793736625e-16,   1.961270851385674e-18,  -1.642114661063154e-20,   7.392895106421075e-02,  -6.265608968101675e-04,
   5.310211334917950e-06,  -4.500492590777521e-08,   3.814235792014795e-10,  -3.232587476903626e-12,   2.739438639934316e-14,  -2.320543812440997e-16,   1.961522667060886e-18,
  -1.642326884078358e-20,   7.392898830136431e-02,  -6.265618433810501e-04,   5.310227378463057e-06,  -4.500515251684655e-08,   3.814264597255474e-10,  -3.232621637215988e-12,
   2.739477139593269e-14,  -2.320585257659663e-16,   1.961564409454547e-18,  -1.642362060023222e-20,   1.488174262552910e-01,  -1.261077460503896e-03,   1.068560519301672e-05,
  -9.053694044486908e-08,   7.670458839538439e-10,  -6.498031376281995e-12,   5.504031939182208e-14,  -4.659821794664132e-16,   3.936523304634163e-18,  -3.293938334790604e-20,
   1.488189482138252e-01,  -1.261116145432588e-03,   1.068626079743015e-05,  -9.054619940367951e-08,   7.671635603760607e-10,  -6.499426646262331e-12,   5.505604016236803e-14,
  -4.661513104939931e-16,   3.938223154648413e-18,  -3.295356904904793e-20,   1.488214468226924e-01,  -1.261179655865627e-03,   1.068733715089459e-05,  -9.056140091978324e-08,
   7.673567695477756e-10,  -6.501717573389969e-12,   5.508185324867272e-14,  -4.664290188559441e-16,   3.941013873439437e-18,  -3.297684017613005e-20,   1.488240981317273e-01,
  -1.261247049233622e-03,   1.068847934395033e-05,  -9.057753285619307e-08,   7.675618124151120e-10,  -6.504148921147344e-12,   5.510924958432837e-14,  -4.667237600847154e-16,
   3.943975229893958e-18,  -3.300150946260730e-20,   1.488261847924242e-01,  -1.261300090985069e-03,   1.068937832745844e-05,  -9.059023018907441e-08,   7.677232061280627e-10,
  -6.506062764512447e-12,   5.513081546381845e-14,  -4.669557744993375e-16,   3.946305967622379e-18,  -3.302090747836664e-20,   1.488273890717957e-01,  -1.261330703546175e-03,
   1.068989717711171e-05,  -9.059755863509000e-08,   7.678163591767488e-10,  -6.507167425226468e-12,   5.514326348648344e-14,  -4.670896951972046e-16,   3.947651135392000e-18,
  -3.303209568127449e-20,   1.488278412957179e-01,  -1.261342199080707e-03,   1.069009201573920e-05,  -9.060031064660289e-08,   7.678513408838739e-10,  -6.507582263582368e-12,
   5.514793820793324e-14,  -4.671399876514818e-16,   3.948156269306509e-18,  -3.303629568048241e-20,   1.488279162585720e-01,  -1.261344104641360e-03,   1.069012431331669e-05,
  -9.060076683755620e-08,   7.678571396980939e-10,  -6.507651030416590e-12,   5.514871312919031e-14,  -4.671483245513976e-16,   3.948240003011399e-18,  -3.303699182276679e-20,
   2.560896283388023e-01,  -2.170101084836971e-03,   1.838811979084089e-05,  -1.557987650853295e-07,   1.319956145493945e-09,  -1.118200343855188e-11,   9.471445247220078e-14,
  -8.018422298916341e-16,   6.772473069847228e-18,  -5.661607042714115e-20,   2.560922473721033e-01,  -2.170167655057737e-03,   1.838924797506881e-05,  -1.558146981729674e-07,
   1.320158645291730e-09,  -1.118440435391845e-11,   9.474149846566472e-14,  -8.021329142010869e-16,   6.775381577147145e-18,  -5.663980991581295e-20,   2.560965470554929e-01,
  -2.170276945773554e-03,   1.839110019719664e-05,  -1.558408573872199e-07,   1.320491123253282e-09,  -1.118834647347607e-11,   9.478590721972667e-14,  -8.026102072041723e-16,
   6.780156490570837e-18,  -5.667874847610787e-20,   2.561011095100520e-01,  -2.170392918363833e-03,   1.839306571811583e-05,  -1.558686176958404e-07,   1.320843964845768e-09,
  -1.119253022120118e-11,   9.483303972775564e-14,  -8.031167710462637e-16,   6.785223212871316e-18,  -5.672001941397614e-20,   2.561047003002939e-01,  -2.170484194248846e-03,
   1.839461271656876e-05,  -1.558904676380115e-07,   1.321121694148567e-09,  -1.119582347119433e-11,   9.487014150447381e-14,  -8.035155256130569e-16,   6.789210870101524e-18,
  -5.675246652141976e-20,   2.561067726614697e-01,  -2.170536873290002e-03,   1.839550556899970e-05,  -1.559030786424308e-07,   1.321281993643052e-09,  -1.119772431813581e-11,
   9.489155697047727e-14,  -8.037456891908131e-16,   6.791512272235462e-18,  -5.677117897997901e-20,   2.561075508623766e-01,  -2.170556655161065e-03,   1.839584085329847e-05,
  -1.559078143843898e-07,   1.321342190812922e-09,  -1.119843815193694e-11,   9.489959931563087e-14,  -8.038321244254701e-16,   6.792376480418807e-18,  -5.677820315663016e-20,
   2.561076798607737e-01,  -2.170559934308723e-03,   1.839589643196251e-05,  -1.559085994111338e-07,   1.321352169519848e-09,  -1.119855648257997e-11,   9.490093248241313e-14,
  -8.038464526468675e-16,   6.792519735756474e-18,  -5.677936738047072e-20,   4.064701800388576e-01,  -3.444424455391398e-03,   2.918596275730790e-05,  -2.472866692338359e-07,
   2.095058398545206e-09,  -1.774825613474220e-11,   1.503308606583151e-13,  -1.272607768281392e-15,   1.074507885050051e-17,  -8.968217653930545e-20,   4.064743370168000e-01,
  -3.444530116871659e-03,   2.918775343181017e-05,  -2.473119584850136e-07,   2.095379806187774e-09,  -1.775206662430211e-11,   1.503737704230125e-13,  -1.273068176728552e-15,
   1.074965027830977e-17,  -8.971802662606966e-20,   4.064811615535490e-01,  -3.444703585108334e-03,   2.919069331241841e-05,  -2.473534788073866e-07,   2.095907515120757e-09,
  -1.775832315491298e-11,   1.504442269136470e-13,  -1.273824143982759e-15,   1.075715491025914e-17,  -8.977681471967347e-20,   4.064884031655430e-01,  -3.444887658939178e-03,
   2.919381302292323e-05,  -2.473975404118909e-07,   2.096467545165629e-09,  -1.776496317033836e-11,   1.505190045913384e-13,  -1.274626463309034e-15,   1.076511775269030e-17,
  -8.983910396383660e-20,   4.064941025340180e-01,  -3.445032533704642e-03,   2.919626844696518e-05,  -2.474322209882273e-07,   2.096908356984710e-09,  -1.777018987703368e-11,
   1.505778679735459e-13,  -1.275258022795899e-15,   1.077138443577276e-17,  -8.988806093299162e-20,   4.064973918238842e-01,  -3.445116146848799e-03,   2.919768559855912e-05,
  -2.474522373752478e-07,   2.097162784256117e-09,  -1.777320670441255e-11,   1.506118443762005e-13,  -1.275622560185591e-15,   1.077500101286019e-17,  -8.991628883317412e-20,
   4.064986269987113e-01,  -3.445147544998816e-03,   2.919821776788722e-05,  -2.474597540202703e-07,   2.097258329169662e-09,  -1.777433962732928e-11,   1.506246038349231e-13,
  -1.275759457436087e-15,   1.077635906417577e-17,  -8.992688374414942e-20,   4.064988317473455e-01,  -3.445152749722361e-03,   2.919830598335215e-05,  -2.474610000272136e-07,
   2.097274167367471e-09,  -1.777452742943558e-11,   1.506267189496296e-13,  -1.275782150633652e-15,   1.077658418012184e-17,  -8.992863974115250e-20,   6.281231577468117e-01,
  -5.322709688513936e-03,   4.510141200550834e-05,  -3.821349931535064e-07,   3.237517438612503e-09,  -2.742651214932102e-11,   2.323030493827608e-13,  -1.966299840797998e-15,
   1.659127823619599e-17,  -1.380296856221923e-19,   6.281295815737857e-01,  -5.322872968439456e-03,   4.510417915500570e-05,  -3.821740728140805e-07,   3.238014102289602e-09,
  -2.743239967064870e-11,   2.323693027229337e-13,  -1.967008303153157e-15,   1.659820114976784e-17,  -1.380792584486220e-19,   6.281401276108015e-01,  -5.323141030941420e-03,
   4.510872218564825e-05,  -3.822382344640675e-07,   3.238829558417703e-09,  -2.744206652119673e-11,   2.324780882380470e-13,  -1.968171541293797e-15,   1.660956506557460e-17,
  -1.381604986306285e-19,   6.281513181591051e-01,  -5.323425482392474e-03,   4.511354310944734e-05,  -3.823063231742111e-07,   3.239694959479304e-09,  -2.745232587839067e-11,
   2.325935451690333e-13,  -1.969406074649323e-15,   1.662162145745478e-17,  -1.382465076795786e-19,   6.281601254603347e-01,  -5.323649359067725e-03,   4.511733750388248e-05,
  -3.823599153140587e-07,   3.240376135377857e-09,  -2.746040155375486e-11,   2.326844299941800e-13,  -1.970377838062582e-15,   1.663110873038472e-17,  -1.383140570229438e-19,
   6.281652084387050e-01,  -5.323778567440618e-03,   4.511952744420359e-05,  -3.823908467781040e-07,   3.240769295685260e-09,  -2.746506278819813e-11,   2.327368892656716e-13,
  -1.970938733477773e-15,   1.663658354795482e-17,  -1.383529847113182e-19,   6.281671171689128e-01,  -5.323827087370304e-03,   4.512034981146017e-05,  -3.824024623026069e-07,
   3.240916938922332e-09,  -2.746681324230373e-11,   2.327565897296540e-13,  -1.971149368835657e-15,   1.663863930650574e-17,  -1.383675917754696e-19,   6.281674335693888e-01,
  -5.323835130290677e-03,   4.512048613181168e-05,  -3.824043877659102e-07,   3.240941413304849e-09,  -2.746710341115320e-11,   2.327598554419330e-13,  -1.971184285375923e-15,
   1.663898007315810e-17,  -1.383700125421196e-19,   2.790861281598732e-03,  -2.287443306441743e-05,   1.874708686491029e-07,  -1.536344424393907e-09,   1.258967739654825e-11,
  -1.031598791999708e-13,   8.452208898646549e-16,  -6.923897790173271e-18,   5.668052411711784e-20,  -4.625959933436407e-22,   2.790887981718548e-03,  -2.287508948301163e-05,
   1.874816285095608e-07,  -1.536491403537222e-09,   1.259148430312669e-11,  -1.031806089324756e-13,   8.454472363745044e-16,  -6.926273728093800e-18,   5.670446522663575e-20,
  -4.628205316489925e-22,   2.790931815396128e-03,  -2.287616714579746e-05,   1.874992936784140e-07,  -1.536732714933607e-09,   1.259445098228514e-11,  -1.032146452803322e-13,
   8.458188898096018e-16,  -6.930175046299412e-18,   5.674377624019581e-20,  -4.631891513346166e-22,   2.790978327824337e-03,  -2.287731069105282e-05,   1.875180393055277e-07,
  -1.536988793989913e-09,   1.259759933334093e-11,  -1.032507674588291e-13,   8.462133366292857e-16,  -6.934315776661864e-18,   5.678549886805635e-20,  -4.635802900125859e-22,
   2.791014934442031e-03,  -2.287821071189010e-05,   1.875327933115095e-07,  -1.537190350562591e-09,   1.260007744625922e-11,  -1.032792008596997e-13,   8.465238362736566e-16,
  -6.937575371537781e-18,   5.681834246752568e-20,  -4.638881213343991e-22,   2.791036061274787e-03,  -2.287873014943869e-05,   1.875413085774108e-07,  -1.537306681224545e-09,
   1.260150775162794e-11,  -1.032956123585319e-13,   8.467030589208746e-16,  -6.939456875506674e-18,   5.683730022450621e-20,  -4.640657779716286e-22,   2.791043994693333e-03,
  -2.287892520679137e-05,   1.875445062277030e-07,  -1.537350366136933e-09,   1.260204487159174e-11,  -1.033017754227294e-13,   8.467703639543767e-16,  -6.940163460957213e-18,
   5.684441963146524e-20,  -4.641324900142254e-22,   2.791045309775381e-03,  -2.287895754051832e-05,   1.875450362884024e-07,  -1.537357607620447e-09,   1.260213390828957e-11,
  -1.033027970590528e-13,   8.467815209986213e-16,  -6.940280590880370e-18,   5.684559980570331e-20,  -4.641435485009315e-22,   2.531773024035642e-02,  -2.075089613173916e-04,
   1.700671012053524e-06,  -1.393718632156047e-08,   1.142092073479482e-10,  -9.358307793431812e-13,   7.667549747302971e-15,  -6.281107786002444e-17,   5.141798211686647e-19,
  -4.196246276425564e-21,   2.531797245462745e-02,  -2.075149161203035e-04,   1.700768621793232e-06,  -1.393851966555951e-08,   1.142255989752526e-10,  -9.360188319007937e-13,
   7.669603058101519e-15,  -6.283263011809336e-17,   5.143969400421348e-19,  -4.198280489025243e-21,   2.531837009862061e-02,  -2.075246923051217e-04,   1.700928874106946e-06,
  -1.394070875916117e-08,   1.142525116555226e-10,  -9.363275972069477e-13,   7.672974525900700e-15,  -6.286801917138739e-17,   5.147534461763321e-19,  -4.201619993558986e-21,
   2.531879204331487e-02,  -2.075350661529629e-04,   1.701098927965014e-06,  -1.394303181987000e-08,   1.142810723999281e-10,  -9.366552844020837e-13,   7.676552764472080e-15,
  -6.290557993113579e-17,   5.151318223044510e-19,  -4.205163483560865e-21,   2.531912412591528e-02,  -2.075432308313403e-04,   1.701232771214102e-06,  -1.394486027144757e-08,
   1.143035529773116e-10,  -9.369132218150153e-13,   7.679369473026159e-15,  -6.293514785985640e-17,   5.154296754456158e-19,  -4.207952238982129e-21,   2.531931578124980e-02,
  -2.075479429894878e-04,   1.701310018766833e-06,  -1.394591558301349e-08,   1.143165282094918e-10,  -9.370621009285646e-13,   7.680995297562982e-15,  -6.295221506138570e-17,
   5.156016000151055e-19,  -4.209561687498482e-21,   2.531938775048451e-02,  -2.075497124824638e-04,   1.701339026746433e-06,  -1.394631187744284e-08,   1.143214007747404e-10,
  -9.371180099920882e-13,   7.681605857523477e-15,  -6.295862452695476e-17,   5.156661646335713e-19,  -4.210166051930251e-21,   2.531939968045493e-02,  -2.075500058028741e-04,
   1.701343835274117e-06,  -1.394637756967890e-08,   1.143222084846541e-10,  -9.371272779030157e-13,   7.681707069039005e-15,  -6.295968701724766e-17,   5.156768674192601e-19,
  -4.210266234009979e-21,   7.149970978376133e-02,  -5.860253020645745e-04,   4.802858812355129e-06,  -3.935995711231339e-08,   3.225378037021600e-10,  -2.642876070045538e-12,
   2.165388472220414e-14,  -1.773837348105041e-16,   1.452055181506992e-18,  -1.184900416289046e-20,   7.150039382020214e-02,  -5.860421190017810e-04,   4.803134471662950e-06,
  -3.936372260390248e-08,   3.225840952040604e-10,  -2.643407146054622e-12,   2.165968330921085e-14,  -1.774445918235603e-16,   1.452667943352506e-18,  -1.185473249738252e-20,
   7.150151680515525e-02,  -5.860697278897058e-04,   4.803587039634188e-06,  -3.936990481460519e-08,   3.226600991518503e-10,  -2.644279124852311e-12,   2.166920439441294e-14,
  -1.775445196735017e-16,   1.453674086997837e-18,  -1.186413641710183e-20,   7.150270841762985e-02,  -5.860990246355962e-04,   4.804067288110850e-06,  -3.937646536128921e-08,
   3.227407573878876e-10,  -2.645204540606688e-12,   2.167930940242768e-14,  -1.776505796772850e-16,   1.454741949226203e-18,  -1.187411460016879e-20,   7.150364625089241e-02,
  -5.861220824740528e-04,   4.804445274339524e-06,  -3.938162908425286e-08,   3.228042446585332e-10,  -2.645932977186355e-12,   2.168726383530152e-14,  -1.777340703325923e-16,
   1.455582554888512e-18,  -1.188196740086889e-20,   7.150418750402474e-02,  -5.861353900627076e-04,   4.804663428869757e-06,  -3.938460938552619e-08,   3.228408879377898e-10,
  -2.646353424104639e-12,   2.169185519100339e-14,  -1.777822627900958e-16,   1.456067761956487e-18,  -1.188649937042778e-20,   7.150439075207843e-02,  -5.861403872813737e-04,
   4.804745350198510e-06,  -3.938572855907676e-08,   3.228546485215218e-10,  -2.646511315918318e-12,   2.169357942246535e-14,  -1.778003611186920e-16,   1.456249976602414e-18,
  -1.188820116309712e-20,   7.150442444346443e-02,  -5.861412156464757e-04,   4.804758929943900e-06,  -3.938591408026411e-08,   3.228569295704822e-10,  -2.646537489264267e-12,
   2.169386524546054e-14,  -1.778033612591477e-16,   1.456280182056483e-18,  -1.188848325921643e-20,   1.439374873741741e-01,  -1.179739187357496e-03,   9.668730568269117e-06,
  -7.923631214560886e-08,   6.493072557600885e-10,  -5.320425599645721e-12,   4.359181646990566e-14,  -3.570920066376204e-16,   2.923031492117989e-18,  -2.384802197708726e-20,
   1.439388644215335e-01,  -1.179773041868106e-03,   9.669285503493539e-06,  -7.924389253043410e-08,   6.494004459909901e-10,  -5.321494710726743e-12,   4.360348917533276e-14,
  -3.572144896883110e-16,   2.924263681063559e-18,  -2.385949744843396e-20,   1.439411251248704e-01,  -1.179828621869250e-03,   9.670196577059866e-06,  -7.925633805980395e-08,
   6.495534508647690e-10,  -5.323250094411823e-12,   4.362265536193573e-14,  -3.574156079332463e-16,   2.926286903379868e-18,  -2.387833576980330e-20,   1.439435239836352e-01,
  -1.179887599730818e-03,   9.671163374801016e-06,  -7.926954522473086e-08,   6.497158253663111e-10,  -5.325113052143470e-12,   4.364299699476539e-14,  -3.576290676886245e-16,
   2.928434221100029e-18,  -2.389832395465100e-20,   1.439454119544226e-01,  -1.179934017923802e-03,   9.671924306380801e-06,  -7.927994041648008e-08,   6.498436326971564e-10,
  -5.326579470339320e-12,   4.365900946246286e-14,  -3.577971034522992e-16,   2.930124549371980e-18,  -2.391405421630139e-20,   1.439465015618648e-01,  -1.179960807695076e-03,
   9.672363477595844e-06,  -7.928594011929267e-08,   6.499173999208297e-10,  -5.327425873458674e-12,   4.366825197212540e-14,  -3.578940969384331e-16,   2.931100222256087e-18,
  -2.392313223413038e-20,   1.439469107245627e-01,  -1.179970867695317e-03,   9.672528395048841e-06,  -7.928819314946693e-08,   6.499451015915407e-10,  -5.327743726000412e-12,
   4.367172289131635e-14,  -3.579305221249582e-16,   2.931466625725920e-18,  -2.392654107716320e-20,   1.439469785493618e-01,  -1.179972535293571e-03,   9.672555732703835e-06,
  -7.928856662579934e-08,   6.499496936109171e-10,  -5.327796415651019e-12,   4.367229825982965e-14,  -3.579365602881315e-16,   2.931527363854103e-18,  -2.392710613940880e-20,
   2.476920786310058e-01,  -2.030131669576168e-03,   1.663825050421312e-05,  -1.363522955499905e-07,   1.117347974679157e-09,  -9.155550779869906e-12,   7.501401000271652e-14,
  -6.144874885156508e-16,   5.029684995320527e-18,  -4.102333439076923e-20,   2.476944482966779e-01,  -2.030189927464635e-03,   1.663920545388058e-05,  -1.363653401073945e-07,
   1.117508339002392e-09,  -9.157390515616858e-12,   7.503409524890097e-14,  -6.146981796322626e-16,   5.031801562528129e-18,  -4.104292438869478e-20,   2.476983385848775e-01,
  -2.030285571248853e-03,   1.664077325740213e-05,  -1.363867567538901e-07,   1.117771634012855e-09,  -9.160411195121029e-12,   7.506707453153616e-14,  -6.150441357335638e-16,
   5.035276885190666e-18,  -4.107508255928961e-20,   2.477024666152090e-01,  -2.030387062176332e-03,   1.664243695280389e-05,  -1.364094840460469e-07,   1.118051052534274e-09,
  -9.163616988743855e-12,   7.510207639146063e-14,  -6.154113204740429e-16,   5.038965333380949e-18,  -4.110920213149654e-20,   2.477057154937130e-01,  -2.030466940037831e-03,
   1.664374638735910e-05,  -1.364273724089846e-07,   1.118270986912525e-09,  -9.166140413565470e-12,   7.512962904372818e-14,  -6.157003681652207e-16,   5.041868785112345e-18,
  -4.113605240494466e-20,   2.477075905238884e-01,  -2.030513040704441e-03,   1.664450212674468e-05,  -1.364376968805209e-07,   1.118397927583684e-09,  -9.167596911135951e-12,
   7.514553262532877e-14,  -6.158672118479615e-16,   5.043544673640887e-18,  -4.115154740720630e-20,   2.477082946237097e-01,  -2.030530352263859e-03,   1.664478592178935e-05,
  -1.364415739635398e-07,   1.118445597381791e-09,  -9.168143874436538e-12,   7.515150503338145e-14,  -6.159298687169982e-16,   5.044174033629033e-18,  -4.115736577926458e-20,
   2.477084113387210e-01,  -2.030533221918489e-03,   1.664483296527006e-05,  -1.364422166529999e-07,   1.118453499455230e-09,  -9.168234543225363e-12,   7.515249506950891e-14,
  -6.159402552751426e-16,   5.044278361543944e-18,  -4.115833024948984e-20,   3.931414343036895e-01,  -3.222262418754523e-03,   2.640853798133611e-05,  -2.164208769401337e-07,
   1.773475238279099e-09,  -1.453185355744288e-11,   1.190632647933723e-13,  -9.753062006696742e-16,   7.982262293995299e-18,  -6.507290828147228e-20,   3.931451954807368e-01,
  -3.222354886748962e-03,   2.641005369499233e-05,  -2.164415814938755e-07,   1.773729770684321e-09,  -1.453477355766746e-11,   1.190951404814826e-13,  -9.756403966851847e-16,
   7.985611522134056e-18,  -6.510357810128903e-20,   3.931513702178972e-01,  -3.222506694326267e-03,   2.641254214154442e-05,  -2.164755743764062e-07,   1.774147676051079e-09,
  -1.453956793316303e-11,   1.191474792351135e-13,  -9.761891470683822e-16,   7.991110756766950e-18,  -6.515392146679084e-20,   3.931579223037531e-01,  -3.222667782597133e-03,
   2.641518278944976e-05,  -2.165116475389719e-07,   1.774591172862034e-09,  -1.454465611827908e-11,   1.192030278186013e-13,  -9.767715679335057e-16,   7.996947138342817e-18,
  -6.520733129514942e-20,   3.931630789836181e-01,  -3.222794566211281e-03,   2.641726114803084e-05,  -2.165400402669039e-07,   1.774940255640042e-09,  -1.454866125793193e-11,
   1.192467543467081e-13,  -9.772300479207367e-16,   8.001541318547226e-18,  -6.524935899066302e-20,   3.931660550660848e-01,  -3.222867738039090e-03,   2.641846067146679e-05,
  -2.165564274517981e-07,   1.775141737563643e-09,  -1.455097298747571e-11,   1.192719935899941e-13,  -9.774946904607517e-16,   8.004193077032899e-18,  -6.527361152337888e-20,
   3.931671726263036e-01,  -3.222895215265299e-03,   2.641891111617505e-05,  -2.165625812269340e-07,   1.775217399701508e-09,  -1.455184111880421e-11,   1.192814718967875e-13,
  -9.775940748284946e-16,   8.005188908077683e-18,  -6.528271812104720e-20,   3.931673578785215e-01,  -3.222899770034023e-03,   2.641898578445184e-05,  -2.165636013150773e-07,
   1.775229941977593e-09,  -1.455198502684156e-11,   1.192830430997913e-13,  -9.776105496564330e-16,   8.005353984985527e-18,  -6.528422764513544e-20,   6.075260899401419e-01,
  -4.979400076372031e-03,   4.080942484014883e-05,  -3.344377286961674e-07,   2.740571975776750e-09,  -2.245622845724031e-11,   1.839888138255386e-13,  -1.507093392504390e-15,
   1.233223076998857e-17,  -1.004359091812931e-19,   6.075319021313402e-01,  -4.979542968252223e-03,   4.081176709013126e-05,  -3.344697236625695e-07,   2.740965305311868e-09,
  -2.246074058172443e-11,   1.840380596746102e-13,  -1.507609168694287e-15,   1.233737486267167e-17,  -1.004819822832888e-19,   6.075414440254131e-01,  -4.979777558288261e-03,
   4.081561251559583e-05,  -3.345222532241363e-07,   2.741611095457100e-09,  -2.246814907942776e-11,   1.841189195303706e-13,  -1.508456069269344e-15,   1.234582093574059e-17,
  -1.005575997966770e-19,   6.075515690408703e-01,  -4.980026489889284e-03,   4.081969313958374e-05,  -3.345779974642217e-07,   2.742296432096035e-09,  -2.247601158385614e-11,
   1.842047382369286e-13,  -1.509354927904391e-15,   1.235478451645194e-17,  -1.006378099334224e-19,   6.075595377190118e-01,  -4.980222410100496e-03,   4.082290485132325e-05,
  -3.346218730471501e-07,   2.742835870495093e-09,  -2.248220051379118e-11,   1.842722926007969e-13,  -1.510062502079121e-15,   1.236184008950629e-17,  -1.007009168712614e-19,
   6.075641366943061e-01,  -4.980335483387256e-03,   4.082475848886917e-05,  -3.346471963373014e-07,   2.743147220955758e-09,  -2.248577270631789e-11,   1.843112853944204e-13,
  -1.510470924186315e-15,   1.236591247398615e-17,  -1.007373295200861e-19,   6.075658636732771e-01,  -4.980377944268326e-03,   4.082545456632664e-05,  -3.346567058310956e-07,
   2.743264141822794e-09,  -2.248711418331185e-11,   1.843259286817968e-13,  -1.510624303451975e-15,   1.236744178458598e-17,  -1.007510013909205e-19,   6.075661499457117e-01,
  -4.980384982806047e-03,   4.082556995208500e-05,  -3.346582821840903e-07,   2.743283523429370e-09,  -2.248733655671341e-11,   1.843283560746086e-13,  -1.510649728930810e-15,
   1.236769529443932e-17,  -1.007532676230824e-19,   2.702250957405156e-03,  -2.144513621057866e-05,   1.701786576408188e-07,  -1.350375414215675e-09,   1.071462693001494e-11,
  -8.501046826900373e-14,   6.744326510795627e-16,  -5.350114202449433e-18,   4.243042485090279e-20,  -3.361453822506149e-22,   2.702275193492544e-03,  -2.144571314350735e-05,
   1.701878144307996e-07,  -1.350496525607622e-09,   1.071606859387439e-11,  -8.502648443841376e-14,   6.746020731051543e-16,  -5.351840631948650e-18,   4.244745410831914e-20,
  -3.363067902213228e-22,   2.702314981896765e-03,  -2.144666030971378e-05,   1.702028476743176e-07,  -1.350695366049775e-09,   1.071843558007665e-11,  -8.505278130531602e-14,
   6.748802558700780e-16,  -5.354675443529308e-18,   4.247541690194186e-20,  -3.365718191208654e-22,   2.702357201752539e-03,  -2.144766537714464e-05,   1.702188003184402e-07,
  -1.350906373543281e-09,   1.072094749104382e-11,  -8.508068938748951e-14,   6.751754960137382e-16,  -5.357684210770501e-18,   4.250509643653364e-20,  -3.368531053095003e-22,
   2.702390429930431e-03,  -2.144845640733688e-05,   1.702313560099773e-07,  -1.351072453781477e-09,   1.072292463572314e-11,  -8.510265686909225e-14,   6.754078998810172e-16,
  -5.360052715162259e-18,   4.252846079303992e-20,  -3.370745296697024e-22,   2.702409606934275e-03,  -2.144891294109824e-05,   1.702386024965671e-07,  -1.351168308441722e-09,
   1.072406578782903e-11,  -8.511533620531059e-14,   6.755420440702557e-16,  -5.361419861394501e-18,   4.254194738810047e-20,  -3.372023382812514e-22,   2.702416808160345e-03,
  -2.144908437685701e-05,   1.702413236907772e-07,  -1.351204304049807e-09,   1.072449432130887e-11,  -8.512009770058220e-14,   6.755924202092396e-16,  -5.361933283015499e-18,
   4.254701222402700e-20,  -3.372503355171752e-22,   2.702418001870358e-03,  -2.144911279493520e-05,   1.702417747711730e-07,  -1.351210270901969e-09,   1.072456535789671e-11,
  -8.512088700126794e-14,   6.756007709685442e-16,  -5.362018392351956e-18,   4.254785181868391e-20,  -3.372582919481143e-22,   2.451388796441312e-02,  -1.945428736020908e-04,
   1.543802042474383e-06,  -1.225013965506161e-08,   9.719939709971678e-11,  -7.711856176469201e-13,   6.118219705529039e-15,  -4.853436076965751e-17,   3.849127882256042e-19,
  -3.049336216949965e-21,   2.451410782583246e-02,  -1.945481073384827e-04,   1.543885109712398e-06,  -1.225123833579399e-08,   9.721247537547000e-11,  -7.713309107170011e-13,
   6.119756637851756e-15,  -4.855002202471856e-17,   3.850672567407843e-19,  -3.050799828857632e-21,   2.451446877250200e-02,  -1.945566997033784e-04,   1.544021486108498e-06,
  -1.225304214763274e-08,   9.723394785536976e-11,  -7.715694666673725e-13,   6.122280206286181e-15,  -4.857573793340083e-17,   3.853209007694512e-19,  -3.053203048294444e-21,
   2.451485177646079e-02,  -1.945658173281967e-04,   1.544166202989529e-06,  -1.225495633476040e-08,   9.725673504258374e-11,  -7.718226389964741e-13,   6.124958512727308e-15,
  -4.860303187261582e-17,   3.855901168176575e-19,  -3.055753679239662e-21,   2.451515321102143e-02,  -1.945729932810645e-04,   1.544280103889246e-06,  -1.225646295733958e-08,
   9.727467101504594e-11,  -7.720219202809644e-13,   6.127066792294642e-15,  -4.862451768492641e-17,   3.858020492750773e-19,  -3.057761494319416e-21,   2.451532717818108e-02,
  -1.945771347977679e-04,   1.544345841514284e-06,  -1.225733251772200e-08,   9.728502315212190e-11,  -7.721369427695619e-13,   6.128283697386006e-15,  -4.863691970762901e-17,
   3.859243828936138e-19,  -3.058920425911619e-21,   2.451539250521838e-02,  -1.945786900037978e-04,   1.544370527248870e-06,  -1.225765905745049e-08,   9.728891065958158e-11,
  -7.721801373836578e-13,   6.128740690565764e-15,  -4.864157719504255e-17,   3.859703247787833e-19,  -3.059355650673182e-21,   2.451540333414360e-02,  -1.945789478027941e-04,
   1.544374619294519e-06,  -1.225771318667316e-08,   9.728955507892825e-11,  -7.721872976424773e-13,   6.128816445479033e-15,  -4.864234926159088e-17,   3.859779405357008e-19,
  -3.059427797222615e-21,   6.922958173925801e-02,  -5.494078209614136e-04,   4.359845726746229e-06,  -3.459557478802572e-08,   2.745004628208487e-10,  -2.177902447323784e-12,
   1.727843889769625e-14,  -1.370655394219472e-16,   1.087022489861323e-18,  -8.611265660513971e-21,   6.923020264909178e-02,  -5.494226015372978e-04,   4.360080316630084e-06,
  -3.459867756820939e-08,   2.745373971247573e-10,  -2.178312768408839e-12,   1.728277930764973e-14,  -1.371097664014186e-16,   1.087458633116701e-18,  -8.615395261925885e-21,
   6.923122199726695e-02,  -5.494468672037082e-04,   4.360465456712818e-06,  -3.460377170653619e-08,   2.745980374654681e-10,  -2.178986472500549e-12,   1.728990605031590e-14,
  -1.371823874492825e-16,   1.088174798711359e-18,  -8.622175953516082e-21,   6.923230363735233e-02,  -5.494726162547529e-04,   4.360874151128613e-06,  -3.460917755530642e-08,
   2.746623906655351e-10,  -2.179701454593569e-12,   1.729746978413421e-14,  -1.372594647953039e-16,   1.088934931156381e-18,  -8.629372532318935e-21,   6.923315491759743e-02,
  -5.494928818371136e-04,   4.361195818243989e-06,  -3.461343240254582e-08,   2.747130435702663e-10,  -2.180264243383990e-12,   1.730342372000250e-14,  -1.373201401346660e-16,
   1.089533322567169e-18,  -8.635037536476061e-21,   6.923364621761954e-02,  -5.495045778793532e-04,   4.361381467631045e-06,  -3.461588812479730e-08,   2.747422789972159e-10,
  -2.180589077535234e-12,   1.730686034898202e-14,  -1.373551630981795e-16,   1.089878731358837e-18,  -8.638307425193911e-21,   6.923383070746771e-02,  -5.495089699310385e-04,
   4.361451182524035e-06,  -3.461681030443364e-08,   2.747532576907434e-10,  -2.180711063122086e-12,   1.730815093112585e-14,  -1.373683157107028e-16,   1.090008448156979e-18,
  -8.639535396126034e-21,   6.923386128939597e-02,  -5.495096979802451e-04,   4.361462738855225e-06,  -3.461696317057064e-08,   2.747550775927199e-10,  -2.180731284355490e-12,
   1.730836486853726e-14,  -1.373704960047112e-16,   1.090029951225155e-18,  -8.639738954905708e-21,   1.393674474714795e-01,  -1.106023808096851e-03,   8.776892117936513e-06,
  -6.964503943933248e-08,   5.526023374947060e-10,  -4.384378559603242e-12,   3.478355844277739e-14,  -2.759287808841439e-16,   2.188278435619593e-18,  -1.733431042118151e-20,
   1.393686974374112e-01,  -1.106053563168031e-03,   8.777364375494122e-06,  -6.965128570756897e-08,   5.526766906525455e-10,  -4.385204583294805e-12,   3.479229608973571e-14,
  -2.760178086016337e-16,   2.189156135851157e-18,  -1.734261092567993e-20,   1.393707495074900e-01,  -1.106102412863534e-03,   8.778139708649227e-06,  -6.966154081831917e-08,
   5.527987668890094e-10,  -4.386560827356960e-12,   3.480664288146381e-14,  -2.761639927672721e-16,   2.190597354466862e-18,  -1.735624003740770e-20,   1.393729269786518e-01,
  -1.106154248790136e-03,   8.778962459500339e-06,  -6.967242343953358e-08,   5.529283175538216e-10,  -4.388000168779164e-12,   3.482186937559177e-14,  -2.763191472752727e-16,
   2.192127049495992e-18,  -1.737070495816375e-20,   1.393746407078389e-01,  -1.106195045836908e-03,   8.779610013963318e-06,  -6.968098895677046e-08,   5.530302878904042e-10,
  -4.389133127514951e-12,   3.483385519704245e-14,  -2.764412849641434e-16,   2.193331253802102e-18,  -1.738209137026362e-20,   1.393756297536818e-01,  -1.106218591372082e-03,
   8.779983748434107e-06,  -6.968593261986510e-08,   5.530891422905286e-10,  -4.389787056115700e-12,   3.484077344745677e-14,  -2.765117851500964e-16,   2.194026354433157e-18,
  -1.738866366959290e-20,   1.393760011538633e-01,  -1.106227433098652e-03,   8.780124092870740e-06,  -6.968778907795260e-08,   5.531112437095509e-10,  -4.390032627166275e-12,
   3.484337150802139e-14,  -2.765382609652192e-16,   2.194287396349350e-18,  -1.739113181810135e-20,   1.393760627189511e-01,  -1.106228898748985e-03,   8.780147357150737e-06,
  -6.968809681580016e-08,   5.531149073892095e-10,  -4.390073334840455e-12,   3.484380218370530e-14,  -2.765426498315806e-16,   2.194330669087368e-18,  -1.739154095878834e-20,
   2.398278126668563e-01,  -1.903279965770529e-03,   1.510354732607105e-05,  -1.198473371445642e-07,   9.509351825898473e-10,  -7.544773749161695e-12,   5.985659428830562e-14,
  -4.748251835750439e-16,   3.765579845423749e-18,  -2.982611140857785e-20,   2.398299636468789e-01,  -1.903331169216979e-03,   1.510436000147269e-05,  -1.198580859154094e-07,
   9.510631317379347e-10,  -7.546195191218268e-12,   5.987162997533266e-14,  -4.749783673212905e-16,   3.767089366123788e-18,  -2.984035943219933e-20,   2.398334949125177e-01,
  -1.903415231283325e-03,   1.510569421872991e-05,  -1.198757332259699e-07,   9.512732041931462e-10,  -7.548529049601649e-12,   5.989631784042261e-14,  -4.752298960289929e-16,
   3.769568053082727e-18,  -2.986375389768252e-20,   2.398372419722173e-01,  -1.903504432148475e-03,   1.510711003382394e-05,  -1.198944603758650e-07,   9.514961388685290e-10,
  -7.551005903928987e-12,   5.992251948836244e-14,  -4.754968591928829e-16,   3.772198898539880e-18,  -2.988858270029342e-20,   2.398401910103887e-01,  -1.903574636967914e-03,
   1.510822436555829e-05,  -1.199092001818370e-07,   9.516716124861550e-10,  -7.552955527312157e-12,   5.994314460633983e-14,  -4.757070125722450e-16,   3.774269943010861e-18,
  -2.990812704937807e-20,   2.398418929910550e-01,  -1.903615154852817e-03,   1.510886749938691e-05,  -1.199177073896066e-07,   9.517728909052408e-10,  -7.554080823788969e-12,
   5.995504948245907e-14,  -4.758283170298470e-16,   3.775465405828919e-18,  -2.991940805683141e-20,   2.398425321079705e-01,  -1.903630369969266e-03,   1.510910900843119e-05,
  -1.199209020398815e-07,   9.518109236907449e-10,  -7.554503408511253e-12,   5.995952020642397e-14,  -4.758738719978194e-16,   3.775914356067091e-18,  -2.992364448593503e-20,
   2.398426380510772e-01,  -1.903632892105674e-03,   1.510914904232325e-05,  -1.199214316046510e-07,   9.518172282607105e-10,  -7.554573459281124e-12,   5.996026131003895e-14,
  -4.758814235935728e-16,   3.775988778214151e-18,  -2.992434675044543e-20,   3.806591263592222e-01,  -3.020921055525534e-03,   2.397262880346451e-05,  -1.902239031927469e-07,
   1.509341841525912e-09,  -1.197520288196747e-11,   9.500541590089805e-14,  -7.536471239334171e-16,   5.976594867066034e-18,  -4.733183992786122e-20,   3.806625404343749e-01,
  -3.021002326579792e-03,   2.397391869683352e-05,  -1.902409638383076e-07,   1.509544924604284e-09,  -1.197745900780963e-11,   9.502927996485956e-14,  -7.538902127806309e-16,
   5.978988544483902e-18,  -4.735435934711506e-20,   3.806681453243081e-01,  -3.021135751441374e-03,   2.397603639104370e-05,  -1.902689739721882e-07,   1.509878355200383e-09,
  -1.198116332909613e-11,   9.506846358811876e-14,  -7.542893659070193e-16,   5.982919032416291e-18,  -4.739133431989290e-20,   3.806740927265537e-01,  -3.021277332699163e-03,
   2.397828359884354e-05,  -1.902986980467794e-07,   1.510232200930670e-09,  -1.198509461471034e-11,   9.511004982021261e-14,  -7.547130116421990e-16,   5.987090778405150e-18,
  -4.743057535589829e-20,   3.806787734943152e-01,  -3.021388763082964e-03,   2.398005228670078e-05,  -1.903220933362055e-07,   1.510510715656915e-09,  -1.198818907449672e-11,
   9.514278519548730e-14,  -7.550465051896338e-16,   5.990374829113763e-18,  -4.746146384253105e-20,   3.806814749094108e-01,  -3.021453073816922e-03,   2.398107308056147e-05,
  -1.903355961318511e-07,   1.510671466494881e-09,  -1.198997515515581e-11,   9.516168014365579e-14,  -7.552390037610626e-16,   5.992270465551513e-18,  -4.747929242659091e-20,
   3.806824893275635e-01,  -3.021477223530275e-03,   2.398145640816567e-05,  -1.903406667391503e-07,   1.510731832782044e-09,  -1.199064588540896e-11,   9.516877589929754e-14,
  -7.553112951121552e-16,   5.992982361379949e-18,  -4.748598765899896e-20,   3.806826574824159e-01,  -3.021481226711683e-03,   2.398151995069666e-05,  -1.903415072740303e-07,
   1.510741839503238e-09,  -1.199075707061743e-11,   9.516995214951682e-14,  -7.553232787666787e-16,   5.993100371758476e-18,  -4.748709751184420e-20,   5.882370324224606e-01,
  -4.668264895879974e-03,   3.704518570307178e-05,  -2.939552381787698e-07,   2.332403687882044e-09,  -1.850541881278911e-11,   1.468127712219894e-13,  -1.164607507569876e-15,
   9.235099496544207e-18,  -7.311632925534667e-20,   5.882423082330140e-01,  -4.668390484997364e-03,   3.704717899045299e-05,  -2.939816021903468e-07,   2.332717514061426e-09,
  -1.850890519167820e-11,   1.468496460953893e-13,  -1.164983013923316e-15,   9.238791622583910e-18,  -7.315083704877739e-20,   5.882509695354570e-01,  -4.668596668007496e-03,
   3.705045148820159e-05,  -2.940248865719713e-07,   2.333232767474497e-09,  -1.851462945874189e-11,   1.469101928106871e-13,  -1.165599596221941e-15,   9.244854151356137e-18,
  -7.320749381342223e-20,   5.882601601262112e-01,  -4.668815455192755e-03,   3.705392412482182e-05,  -2.940708195258081e-07,   2.333779568579686e-09,  -1.852070445210583e-11,
   1.469744520219274e-13,  -1.166254011466916e-15,   9.251288737857862e-18,  -7.326762000556784e-20,   5.882673933717755e-01,  -4.668987649877309e-03,   3.705665729895131e-05,
  -2.941069725352053e-07,   2.334209959978295e-09,  -1.852548630296468e-11,   1.470250348349002e-13,  -1.166769165530485e-15,   9.256354075912752e-18,  -7.331494611376274e-20,
   5.882715679003471e-01,  -4.669087030011969e-03,   3.705823474369938e-05,  -2.941278385603525e-07,   2.334458369742757e-09,  -1.852824632298467e-11,   1.470542313652576e-13,
  -1.167066521455402e-15,   9.259277896371261e-18,  -7.334226152441343e-20,   5.882731354926688e-01,  -4.669124348848458e-03,   3.705882710435051e-05,  -2.941356742280283e-07,
   2.334551654327261e-09,  -1.852928279850811e-11,   1.470651957466196e-13,  -1.167178191096447e-15,   9.260375917316707e-18,  -7.335251922086131e-20,   5.882733953443431e-01,
  -4.669130535011839e-03,   3.705892529737032e-05,  -2.941369731162286e-07,   2.334567117806493e-09,  -1.852945461235696e-11,   1.470670132916546e-13,  -1.167196702440855e-15,
   9.260557935137267e-18,  -7.335421960659875e-20,   2.619094593511388e-03,  -2.014573433506110e-05,   1.549493659290857e-07,  -1.191711907167387e-09,   9.164895361040319e-12,
  -7.047878641651023e-14,   5.419552651026043e-16,  -4.167148343599117e-18,   3.203791789199638e-20,  -2.462122443708235e-22,   2.619116659694451e-03,  -2.014624345787076e-05,
   1.549571978846769e-07,  -1.191812308991227e-09,   9.166053744064293e-12,  -7.049125996053422e-14,   5.420831754612140e-16,  -4.168412744403809e-18,   3.205005169024834e-20,
  -2.463254093270228e-22,   2.619152885712906e-03,  -2.014707929639146e-05,   1.549700560230821e-07,  -1.191977147677687e-09,   9.167955614813259e-12,  -7.051174003551266e-14,
   5.422931959949503e-16,  -4.170488882406747e-18,   3.206997597544505e-20,  -2.465112342994448e-22,   2.619191325416326e-03,  -2.014796622784301e-05,   1.549837004746310e-07,
  -1.192152071721817e-09,   9.169973915184054e-12,  -7.053347469390424e-14,   5.425160915611700e-16,  -4.172692395462109e-18,   3.209112355912883e-20,  -2.467084719862903e-22,
   2.619221578459967e-03,  -2.014866427809877e-05,   1.549944394341888e-07,  -1.192289750505047e-09,   9.171562522619265e-12,  -7.055058267515839e-14,   5.426915459751636e-16,
  -4.174426984714530e-18,   3.210777143650215e-20,  -2.468637447101582e-22,   2.619239038401746e-03,  -2.014906714879509e-05,   1.550006373801578e-07,  -1.192369212690774e-09,
   9.172479416982752e-12,  -7.056045710445213e-14,   5.427928179524599e-16,  -4.175428215626295e-18,   3.211738110335550e-20,  -2.469533739229579e-22,   2.619245594843747e-03,
  -2.014921843306194e-05,   1.550029648238826e-07,  -1.192399052489578e-09,   9.172823734667760e-12,  -7.056416525475800e-14,   5.428308491963223e-16,  -4.175804219080681e-18,
   3.212098997875227e-20,  -2.469870340398954e-22,   2.619246681671034e-03,  -2.014924351071671e-05,   1.550033506338106e-07,  -1.192403998913884e-09,   9.172880811029846e-12,
  -7.056477994450669e-14,   5.428371535570238e-16,  -4.175866548686081e-18,   3.212158821996718e-20,  -2.469926138684079e-22,   2.375952213379573e-02,  -1.827551482948573e-04,
   1.405647164682936e-06,  -1.081079908494393e-08,   8.314076729817070e-11,  -6.393592219686025e-13,   4.916430994087454e-15,  -3.780292539534790e-17,   2.906366382514215e-19,
  -2.233539811443903e-21,   2.375972231059201e-02,  -1.827597668812553e-04,   1.405718213480727e-06,  -1.081170989563218e-08,   8.315127574888780e-11,  -6.394723776354483e-13,
   4.917591351468065e-15,  -3.781439553425334e-17,   2.907467085764958e-19,  -2.234566265115043e-21,   2.376005094052750e-02,  -1.827673493198131e-04,   1.405834858074134e-06,
  -1.081320525529520e-08,   8.316852886346211e-11,  -6.396581657751257e-13,   4.919496583208930e-15,  -3.783322942818706e-17,   2.909274493649977e-19,  -2.236251774675762e-21,
   2.376039965224890e-02,  -1.827753952558042e-04,   1.405958635828972e-06,  -1.081479210584161e-08,   8.318683818735108e-11,  -6.398553350603578e-13,   4.921518612662132e-15,
  -3.785321881698770e-17,   2.911192871285418e-19,  -2.238040800970202e-21,   2.376067409741853e-02,  -1.827817277267821e-04,   1.406056055963346e-06,  -1.081604108023779e-08,
   8.320124948533266e-11,  -6.400105327345844e-13,   4.923110272813788e-15,  -3.786895431616970e-17,   2.912703063238972e-19,  -2.239449186970649e-21,   2.376083248798380e-02,
  -1.827853824306823e-04,   1.406112281589852e-06,  -1.081676193375718e-08,   8.320956723432198e-11,  -6.401001101333984e-13,   4.924028976233226e-15,  -3.787803708191634e-17,
   2.913574792389685e-19,  -2.240262159562644e-21,   2.376089196576258e-02,  -1.827867548293333e-04,   1.406133395355966e-06,  -1.081703263011154e-08,   8.321269076544006e-11,
  -6.401337491872435e-13,   4.924373982173107e-15,  -3.788144803459280e-17,   2.913902167080484e-19,  -2.240567470131937e-21,   2.376090182508459e-02,  -1.827869823251614e-04,
   1.406136895290464e-06,  -1.081707750236539e-08,   8.321320854248387e-11,  -6.401393254395111e-13,   4.924431173094751e-15,  -3.788201346379599e-17,   2.913956435795210e-19,
  -2.240618081378875e-21,   6.709917994384178e-02,  -5.161181488434250e-04,   3.969683039467944e-06,  -3.053073832980788e-08,   2.347975380684520e-10,  -1.805612040950102e-12,
   1.388447422499631e-14,  -1.067590677553931e-16,   8.207841008683800e-19,  -6.307655297701305e-21,   6.709974526240325e-02,  -5.161311921764535e-04,   3.969883688118966e-06,
  -3.053331054694124e-08,   2.348272149443953e-10,  -1.805931603341958e-12,   1.388775117857712e-14,  -1.067914601189686e-16,   8.210949301619556e-19,  -6.310553258843577e-21,
   6.710067334500745e-02,  -5.161526057135743e-04,   3.970213103690291e-06,  -3.053753358669611e-08,   2.348759394000284e-10,  -1.806456286761259e-12,   1.389313172427336e-14,
  -1.068446481675274e-16,   8.216053267285475e-19,  -6.315311910248104e-21,   6.710165814051013e-02,  -5.161753282121083e-04,   3.970562663996825e-06,  -3.054201500551995e-08,
   2.349276466923777e-10,  -1.807013111619467e-12,   1.389884211713155e-14,  -1.069010993989153e-16,   8.221470600126365e-19,  -6.320362809538264e-21,   6.710243320011434e-02,
  -5.161932117203383e-04,   3.970837787843423e-06,  -3.054554222954369e-08,   2.349683455844928e-10,  -1.807451404646048e-12,   1.390333710835725e-14,  -1.069455373882011e-16,
   8.225735250434224e-19,  -6.324339053772039e-21,   6.710288051033299e-02,  -5.162035329563147e-04,   3.970996574430414e-06,  -3.054757798933099e-08,   2.349918357079447e-10,
  -1.807704379759111e-12,   1.390593160930617e-14,  -1.069711876598127e-16,   8.228196936930777e-19,  -6.326634286969709e-21,   6.710304848131146e-02,  -5.162074087423473e-04,
   3.971056201740382e-06,  -3.054834246191513e-08,   2.350006568603571e-10,  -1.807799379653689e-12,   1.390690593705502e-14,  -1.069808203931643e-16,   8.229121414174579e-19,
  -6.327496257721239e-21,   6.710307632498685e-02,  -5.162080512124873e-04,   3.971066085892649e-06,  -3.054846918548310e-08,   2.350021191125474e-10,  -1.807815127521625e-12,
   1.390706744935211e-14,  -1.069824171988720e-16,   8.229274664231408e-19,  -6.327639146346286e-21,   1.350786932589527e-01,  -1.039007707267631e-03,   7.991447854806417e-06,
  -6.146203636164773e-08,   4.726755918872369e-10,  -3.634913467334434e-12,   2.795110895699885e-14,  -2.149186798915178e-16,   1.652330812536332e-18,  -1.269780803192756e-20,
   1.350798313129889e-01,  -1.039033965060686e-03,   7.991851784594852e-06,  -6.146721454305162e-08,   4.727353349913291e-10,  -3.635556784351918e-12,   2.795770583216734e-14,
  -2.149838882021926e-16,   1.652956481682612e-18,  -1.270363911259949e-20,   1.350816996545322e-01,  -1.039077073078020e-03,   7.992514937630536e-06,  -6.147571602826527e-08,
   4.728334231536117e-10,  -3.636613034336502e-12,   2.796853747405584e-14,  -2.150909598103833e-16,   1.653983859862964e-18,  -1.271321412792154e-20,   1.350836821659391e-01,
  -1.039122816191600e-03,   7.993218644433160e-06,  -6.148473766151437e-08,   4.729375161232439e-10,  -3.637733988847593e-12,   2.798003313501259e-14,  -2.152046004410596e-16,
   1.655074315121218e-18,  -1.272337715614810e-20,   1.350852424538386e-01,  -1.039158817837588e-03,   7.993772501718426e-06,  -6.149183838625770e-08,   4.730194478652968e-10,
  -3.638616324713947e-12,   2.798908205604851e-14,  -2.152940574897185e-16,   1.655932746364234e-18,  -1.273137782696177e-20,   1.350861429429335e-01,  -1.039179595722945e-03,
   7.994092158153501e-06,  -6.149593661472162e-08,   4.730667362958856e-10,  -3.639125593631071e-12,   2.799430507711687e-14,  -2.153456934311857e-16,   1.656428258921613e-18,
  -1.273599609802148e-20,   1.350864810886500e-01,  -1.039187398144868e-03,   7.994212195076634e-06,  -6.149747558966536e-08,   4.730844943316980e-10,  -3.639316839690004e-12,
   2.799626650801347e-14,  -2.153650848529670e-16,   1.656614346790434e-18,  -1.273773048001331e-20,   1.350865371413065e-01,  -1.039188691514280e-03,   7.994232093060067e-06,
  -6.149773069939713e-08,   4.730874380204074e-10,  -3.639348542016534e-12,   2.799659165035838e-14,  -2.153682993437513e-16,   1.656645194466664e-18,  -1.273801798790063e-20,
   2.324475918153126e-01,  -1.787956587415738e-03,   1.375193055351097e-05,  -1.057657724852076e-07,   8.133947719114862e-10,  -6.255071392310363e-12,   4.809912660769777e-14,
  -3.698383763046377e-16,   2.843365591788191e-18,  -2.185007232577230e-20,   2.324495502138852e-01,  -1.788001772637878e-03,   1.375262564837885e-05,  -1.057746832597343e-07,
   8.134975796787723e-10,  -6.256178431067403e-12,   4.811047864539160e-14,  -3.699505849393043e-16,   2.844442076904334e-18,  -2.186009872834892e-20,   2.324527653137796e-01,
  -1.788075954246941e-03,   1.375376682262478e-05,  -1.057893128781209e-07,   8.136663727990552e-10,  -6.257996056954791e-12,   4.812911795573275e-14,  -3.701348307354076e-16,
   2.846209714783496e-18,  -2.187656268067071e-20,   2.324561768807051e-01,  -1.788154670411098e-03,   1.375497778304661e-05,  -1.058048375833139e-07,   8.138454991759865e-10,
  -6.259925028273949e-12,   4.814889992291906e-14,  -3.703303802809261e-16,   2.848085877022131e-18,  -2.189403762782896e-20,   2.324588618723646e-01,  -1.788216623156629e-03,
   1.375593087778620e-05,  -1.058170567298081e-07,   8.139864898322287e-10,  -6.261443377639701e-12,   4.816447148976614e-14,  -3.704843153823620e-16,   2.849562833391039e-18,
  -2.190779442722805e-20,   2.324604114618410e-01,  -1.788252378384172e-03,   1.375648095246220e-05,  -1.058241090879510e-07,   8.140678652148444e-10,  -6.262319742484331e-12,
   4.817345937014434e-14,  -3.705731690053566e-16,   2.850415376884405e-18,  -2.191573531783137e-20,   2.324609933534449e-01,  -1.788265805033056e-03,   1.375668751571060e-05,
  -1.058267574035760e-07,   8.140984237878475e-10,  -6.262648844294341e-12,   4.817683464009480e-14,  -3.706065371965965e-16,   2.850735546271608e-18,  -2.191871749842648e-20,
   2.324610898105894e-01,  -1.788268030703130e-03,   1.375672175677566e-05,  -1.058271964042833e-07,   8.141034893777173e-10,  -6.262703398584739e-12,   4.817739415161479e-14,
  -3.706120685981744e-16,   2.850788620556720e-18,  -2.191921185322458e-20,   3.689451037425605e-01,  -2.837877663001002e-03,   2.182731774096998e-05,  -1.678733842351305e-07,
   1.291035176995411e-09,  -9.928164419552474e-12,   7.634380539424190e-14,  -5.870134262220977e-16,   4.512999688731841e-18,  -3.467898478300149e-20,   3.689482121488850e-01,
  -2.837949381818722e-03,   2.182842100835824e-05,  -1.678875275804122e-07,   1.291198355344599e-09,  -9.929921529136143e-12,   7.636182337780872e-14,  -5.871915157787753e-16,
   4.514707817438822e-18,  -3.469487799097140e-20,   3.689533152147193e-01,  -2.838067124236411e-03,   2.183023230115870e-05,  -1.679107479798887e-07,   1.291466266840205e-09,
  -9.932806493932680e-12,   7.639140773797646e-14,  -5.874839375144884e-16,   4.517512639473982e-18,  -3.472097543956338e-20,   3.689587301166480e-01,  -2.838192063983554e-03,
   2.183215435986402e-05,  -1.679353890776094e-07,   1.291750579467413e-09,  -9.935868187944992e-12,   7.642280572407803e-14,  -5.877942996494476e-16,   4.520489659075702e-18,
  -3.474867524007747e-20,   3.689629917849175e-01,  -2.838290396523567e-03,   2.183366712940477e-05,  -1.679547835317417e-07,   1.291974362388307e-09,  -9.938278136229079e-12,
   7.644752095122573e-14,  -5.880386142656949e-16,   4.522833231162274e-18,  -3.477048120155071e-20,   3.689654513219067e-01,  -2.838347147879990e-03,   2.183454021807100e-05,
  -1.679659771643393e-07,   1.292103522868018e-09,  -9.939669116452868e-12,   7.646178653533563e-14,  -5.881796362548105e-16,   4.524186009812377e-18,  -3.478306828195452e-20,
   3.689663749109898e-01,  -2.838368458904663e-03,   2.183486807906679e-05,  -1.679701806196244e-07,   1.292152025988001e-09,  -9.940191472079889e-12,   7.646714377134813e-14,
  -5.882325958082878e-16,   4.524694040295685e-18,  -3.478779531571095e-20,   3.689665280095480e-01,  -2.838371991529242e-03,   2.183492242711648e-05,  -1.679708774096238e-07,
   1.292160066183896e-09,  -9.940278061517177e-12,   7.646803182927825e-14,  -5.882413748441542e-16,   4.524778256186601e-18,  -3.478857891347756e-20,   5.701352152726992e-01,
  -4.385405785031228e-03,   3.373001124724202e-05,  -2.594167182561254e-07,   1.995051860226673e-09,  -1.534210877989377e-11,   1.179749377706452e-13,  -9.071162463888663e-16,
   6.973866585159004e-18,  -5.358436567792272e-20,   5.701400187296118e-01,  -4.385516612965115e-03,   3.373171613932688e-05,  -2.594385741332028e-07,   1.995304021551593e-09,
  -1.534482405403357e-11,   1.180027806443707e-13,  -9.073914205134002e-16,   6.976504719187674e-18,  -5.360886274663980e-20,   5.701479045573634e-01,  -4.385698561710204e-03,
   3.373451515141740e-05,  -2.594744568884083e-07,   1.995718028176226e-09,  -1.534928221092214e-11,   1.180484968327077e-13,  -9.078432541652341e-16,   6.980836639789945e-18,
  -5.364908770929306e-20,   5.701562722691054e-01,  -4.385891632573285e-03,   3.373748533136475e-05,  -2.595125350652347e-07,   1.996157379651486e-09,  -1.535401346865453e-11,
   1.180970155794975e-13,  -9.083228080059233e-16,   6.985434496957256e-18,  -5.369178181063150e-20,   5.701628578752879e-01,  -4.386043587005747e-03,   3.373982303194712e-05,
  -2.595425055422835e-07,   1.996503193895365e-09,  -1.535773757897217e-11,   1.181352075742292e-13,  -9.087003087693672e-16,   6.989054015537628e-18,  -5.372539119864836e-20,
   5.701666586267725e-01,  -4.386131285545371e-03,   3.374117222614260e-05,  -2.595598031937929e-07,   1.996702787025079e-09,  -1.535988707063395e-11,   1.181572519224117e-13,
  -9.089182076709171e-16,   6.991143303671124e-18,  -5.374479140204533e-20,   5.701680858598631e-01,  -4.386164217722846e-03,   3.374167887359956e-05,  -2.595662988424587e-07,
   1.996777739437241e-09,  -1.536069427050559e-11,   1.181655303616693e-13,  -9.090000376478810e-16,   6.991927926458834e-18,  -5.375207704560447e-20,   5.701683224448687e-01,
  -4.386169676729224e-03,   3.374176285828062e-05,  -2.595673756002029e-07,   1.996790164041609e-09,  -1.536082807777963e-11,   1.181669026614012e-13,  -9.090136024951614e-16,
   6.992057992837465e-18,  -5.375328478087564e-20,   2.540903659554661e-03,  -1.896095145278501e-05,   1.414843226202489e-07,  -1.055681164549869e-09,   7.876503577311197e-12,
  -5.876387083305634e-14,   4.383927636543951e-16,  -3.270328643120062e-18,   2.439430186512412e-20,  -1.819274533493502e-22,   2.540923807348354e-03,  -1.896140244209014e-05,
   1.414910532353893e-07,  -1.055764872510582e-09,   7.877440532025096e-12,  -5.877365899309380e-14,   4.384901460963924e-16,  -3.271262796622911e-18,   2.440300979767899e-20,
  -1.820066567990545e-22,   2.540956883906605e-03,  -1.896214283989525e-05,   1.415021032083778e-07,  -1.055902302753799e-09,   7.878978845217329e-12,  -5.878972986158475e-14,
   4.386500402379793e-16,  -3.272796654364306e-18,   2.441730852960076e-20,  -1.821367157429348e-22,   2.540991981634945e-03,  -1.896292849435797e-05,   1.415138288706890e-07,
  -1.056048140562666e-09,   7.880611318831324e-12,  -5.880678504046269e-14,   4.388197344026020e-16,  -3.274424595056348e-18,   2.443248500897431e-20,  -1.822747640905228e-22,
   2.541019604414846e-03,  -1.896354683401313e-05,   1.415230575983636e-07,  -1.056162925604192e-09,   7.881896232171140e-12,  -5.882020954384737e-14,   4.389533093117781e-16,
  -3.275706081936336e-18,   2.444443217859212e-20,  -1.823834419981659e-22,   2.541035546335175e-03,  -1.896390370012741e-05,   1.415283839059942e-07,  -1.056229174272800e-09,
   7.882637840127789e-12,  -5.882795788423641e-14,   4.390304079101723e-16,  -3.276445768937526e-18,   2.445132840696171e-20,  -1.824461754262929e-22,   2.541041532736555e-03,
  -1.896403770883145e-05,   1.415303840306506e-07,  -1.056254052058288e-09,   7.882916332507034e-12,  -5.883086761374944e-14,   4.390593610730933e-16,  -3.276723550663518e-18,
   2.445391825184537e-20,  -1.824697349630510e-22,   2.541042525071003e-03,  -1.896405992279411e-05,   1.415307155822196e-07,  -1.056258175946982e-09,   7.882962497196937e-12,
  -5.883134995101307e-14,   4.390641605730665e-16,  -3.276769598116171e-18,   2.445434756850178e-20,  -1.824736404259480e-22,   2.305020096967684e-02,  -1.720072069318749e-04,
   1.283496939441675e-06,  -9.576775141068625e-09,   7.145292175965555e-11,  -5.330855526648217e-13,   3.976947812316737e-15,  -2.966729140317894e-17,   2.212966248924813e-19,
  -1.650380376995592e-21,   2.305038374350692e-02,  -1.720112981511855e-04,   1.283557997259056e-06,  -9.577534510794686e-09,   7.146142148936659e-11,  -5.331743474701983e-13,
   3.977831231957360e-15,  -2.967576570674182e-17,   2.213756195411220e-19,  -1.651098852903521e-21,   2.305068380262652e-02,  -1.720180147845144e-04,   1.283658238799943e-06,
  -9.578781230524277e-09,   7.147537653559302e-11,  -5.333201368355255e-13,   3.979281735990796e-15,  -2.968968031069132e-17,   2.215053315309229e-19,  -1.652278652531936e-21,
   2.305100219710353e-02,  -1.720251419706201e-04,   1.283764609961141e-06,  -9.580104220787398e-09,   7.149018577265928e-11,  -5.334748555244919e-13,   3.980821142421544e-15,
  -2.970444840107017e-17,   2.216430060636592e-19,  -1.653530925891260e-21,   2.305125278142839e-02,  -1.720307513345427e-04,   1.283848329793169e-06,  -9.581145511063696e-09,
   7.150184206290196e-11,  -5.335966379800171e-13,   3.982032887529526e-15,  -2.971607358740425e-17,   2.217513856736992e-19,  -1.654516771945150e-21,   2.305139740102703e-02,
  -1.720339887007540e-04,   1.283896648217538e-06,  -9.581746496118220e-09,   7.150856967426758e-11,  -5.336669282463767e-13,   3.982732299192285e-15,  -2.972278376079420e-17,
   2.218139453041858e-19,  -1.655085843382841e-21,   2.305145170759405e-02,  -1.720352043814619e-04,   1.283914792658048e-06,  -9.581972178801085e-09,   7.151109606099123e-11,
  -5.336933243069804e-13,   3.982994952213621e-15,  -2.972530369630321e-17,   2.218374392674869e-19,  -1.655299558125132e-21,   2.305146070970964e-02,  -1.720354058988637e-04,
   1.283917800379442e-06,  -9.582009589295870e-09,   7.151151485112111e-11,  -5.336976999039508e-13,   3.983038491607644e-15,  -2.972572142216513e-17,   2.218413338442548e-19,
  -1.655334985603385e-21,   6.509598862706495e-02,  -4.857649267761377e-04,   3.624719033150253e-06,  -2.704573580427564e-08,   2.017899361393872e-10,  -1.505484966214290e-12,
   1.123128370426613e-14,  -8.378328215109611e-17,   6.249626227836539e-19,  -4.660817077428819e-21,   6.509650479797295e-02,  -4.857764807736956e-04,   3.624891466309968e-06,
  -2.704788033755095e-08,   2.018139401948153e-10,  -1.505735731277082e-12,   1.123377856489377e-14,  -8.380721431330754e-17,   6.251857070129677e-19,  -4.662845939266677e-21,
   6.509735219384002e-02,  -4.857954491934226e-04,   3.625174558080545e-06,  -2.705140119419472e-08,   2.018533505895558e-10,  -1.506147454453668e-12,   1.123787492547505e-14,
  -8.384651035111719e-17,   6.255520191276648e-19,  -4.666177504697162e-21,   6.509825137052321e-02,  -4.858155770537519e-04,   3.625474960489522e-06,  -2.705513744617417e-08,
   2.018951733015032e-10,  -1.506584394897975e-12,   1.124222235481839e-14,  -8.388821670707632e-17,   6.259408177556402e-19,  -4.669713722558357e-21,   6.509895904480259e-02,
  -4.858314184379805e-04,   3.625711393362279e-06,  -2.705807815024767e-08,   2.019280917879167e-10,  -1.506928320254069e-12,   1.124564443758707e-14,  -8.392104723135015e-17,
   6.262468862678083e-19,  -4.672497591406202e-21,   6.509936746448451e-02,  -4.858405610721094e-04,   3.625847849248581e-06,  -2.705977538994939e-08,   2.019470912104356e-10,
  -1.507126826720163e-12,   1.124761964225491e-14,  -8.393999733683386e-17,   6.264235572455123e-19,  -4.674104556028777e-21,   6.509952083146270e-02,  -4.858439942715703e-04,
   3.625899090896951e-06,  -2.706041273959139e-08,   2.019542259698916e-10,  -1.507201371731580e-12,   1.124836139922115e-14,  -8.394711385090853e-17,   6.264899051648669e-19,
  -4.674708051391729e-21,   6.509954625430457e-02,  -4.858445633761308e-04,   3.625907584991986e-06,  -2.706051839043334e-08,   2.019554086735574e-10,  -1.507213728837854e-12,
   1.124848435858651e-14,  -8.394829354457865e-17,   6.265009036098321e-19,  -4.674808092771656e-21,   1.310460289902636e-01,  -9.779030324195764e-04,   7.296993954891407e-06,
  -5.444630848948157e-08,   4.062273324921182e-10,  -3.030721712001722e-12,   2.260992009189882e-14,  -1.686657659950078e-16,   1.258123436282845e-18,  -9.382729092651959e-21,
   1.310470681041814e-01,  -9.779262920017848e-04,   7.297341083513593e-06,  -5.445062569204715e-08,   4.062756555323606e-10,  -3.031226532055623e-12,   2.261494254016800e-14,
  -1.687139440109258e-16,   1.258572517147822e-18,  -9.386812813972098e-21,   1.310487740136499e-01,  -9.779644777046803e-04,   7.297910981185451e-06,  -5.445771359854425e-08,
   4.063549933799393e-10,  -3.032055380036771e-12,   2.262318899641550e-14,  -1.687930511582340e-16,   1.259309923543708e-18,  -9.393518630726797e-21,   1.310505841641089e-01,
  -9.780049975005049e-04,   7.298515727247643e-06,  -5.446523512167314e-08,   4.064391875111380e-10,  -3.032934993392019e-12,   2.263194088359179e-14,  -1.688770105319614e-16,
   1.260092596379802e-18,  -9.400636368370320e-21,   1.310520087972712e-01,  -9.780368881060651e-04,   7.298991694964612e-06,  -5.447115511149862e-08,   4.065054563692434e-10,
  -3.033627356253128e-12,   2.263882993911364e-14,  -1.689431019010398e-16,   1.260708728876556e-18,  -9.406239765338059e-21,   1.310528309950534e-01,  -9.780552933246101e-04,
   7.299266397022379e-06,  -5.447457185847971e-08,   4.065437044836635e-10,  -3.034026973502311e-12,   2.264280625864999e-14,  -1.689812504964099e-16,   1.261064377083665e-18,
  -9.409474276816174e-21,   1.310531397411666e-01,  -9.780622047667058e-04,   7.299369552603512e-06,  -5.447585491971320e-08,   4.065580676094770e-10,  -3.034177041522660e-12,
   2.264429950274669e-14,  -1.689955768025571e-16,   1.261197939015855e-18,  -9.410688996860400e-21,   1.310531909203950e-01,  -9.780633504424118e-04,   7.299386652235109e-06,
  -5.447606760752324e-08,   4.065604485336912e-10,  -3.034201917854965e-12,   2.264454703442442e-14,  -1.689979516524397e-16,   1.261220079477030e-18,  -9.410890360890984e-21,
   2.255080584570848e-01,  -1.682805773661468e-03,   1.255689281100429e-05,  -9.369289105465512e-08,   6.990485535443365e-10,  -5.215359610030464e-12,   3.890784836542654e-14,
  -2.902451967090842e-16,   2.165014315300030e-18,  -1.614594166310600e-20,   2.255098465964425e-01,  -1.682845799469687e-03,   1.255749016066991e-05,  -9.370032023028487e-08,
   6.991317093233423e-10,  -5.216228319770360e-12,   3.891649113534792e-14,  -2.903281021207589e-16,   2.165787068006062e-18,  -1.615296735188476e-20,   2.255127821782004e-01,
  -1.682911510607880e-03,   1.255847085820379e-05,  -9.371251731888872e-08,   6.992682363399761e-10,  -5.217654626644818e-12,   3.893068186855847e-14,  -2.904642308133232e-16,
   2.167055954525700e-18,  -1.616450411635149e-20,   2.255158971410777e-01,  -1.682981238325352e-03,   1.255951152392520e-05,  -9.372546058839634e-08,   6.994131201993075e-10,
  -5.219168292120314e-12,   3.894574236133522e-14,  -2.906087092770115e-16,   2.168402732531621e-18,  -1.617674953740747e-20,   2.255183486938712e-01,  -1.683036116665413e-03,
   1.256033058388857e-05,  -9.373564788988819e-08,   6.995271576954755e-10,  -5.220359731235713e-12,   3.895759724107320e-14,  -2.907224402224858e-16,   2.169462937293074e-18,
  -1.618638966064740e-20,   2.255197635572360e-01,  -1.683067788934550e-03,   1.256080329968283e-05,  -9.374152753371248e-08,   6.995929762311456e-10,  -5.221047404778204e-12,
   3.896443980308286e-14,  -2.907880868525750e-16,   2.170074915808204e-18,  -1.619195433184286e-20,   2.255202948570936e-01,  -1.683079682357801e-03,   1.256098081299622e-05,
  -9.374373546514531e-08,   6.996176927413047e-10,  -5.221305646401475e-12,   3.896700941933234e-14,  -2.908127397577045e-16,   2.170304741302691e-18,  -1.619404414190353e-20,
   2.255203829278923e-01,  -1.683081653871978e-03,   1.256101023857096e-05,  -9.374410146490347e-08,   6.996217899091699e-10,  -5.221348454352292e-12,   3.896743537877333e-14,
  -2.908168264320991e-16,   2.170342839301110e-18,  -1.619439056947691e-20,   3.579305484409505e-01,  -2.670980352574971e-03,   1.993053180138550e-05,  -1.487110842441533e-07,
   1.109542753110254e-09,  -8.277914891229751e-12,   6.175525125563820e-14,  -4.606823517526580e-16,   3.436341860324810e-18,  -2.562675012959078e-20,   3.579333866087099e-01,
  -2.671043882275794e-03,   1.993147992578854e-05,  -1.487228759686266e-07,   1.109674739488957e-09,  -8.279293722786406e-12,   6.176896918227285e-14,  -4.608139386513427e-16,
   3.437568284485617e-18,  -2.563789696157769e-20,   3.579380460182042e-01,  -2.671148180205952e-03,   1.993303650699616e-05,  -1.487422354124406e-07,   1.109891437675557e-09,
  -8.281557582432212e-12,   6.179149291440027e-14,  -4.610300011589052e-16,   3.439582114361162e-18,  -2.565620095266549e-20,   3.579429901447186e-01,  -2.671258853324802e-03,
   1.993468827081670e-05,  -1.487627792083358e-07,   1.110121399996189e-09,  -8.283960099197602e-12,   6.181539714079386e-14,  -4.612593163426977e-16,   3.441719563534833e-18,
  -2.567562923889361e-20,   3.579468812945157e-01,  -2.671345957238025e-03,   1.993598829789216e-05,  -1.487789486810057e-07,   1.110302402403018e-09,  -8.285851172548539e-12,
   6.183421337270385e-14,  -4.614398292695859e-16,   3.443402196268209e-18,  -2.569092399071966e-20,   3.579491269917365e-01,  -2.671396228047589e-03,   1.993673860111663e-05,
  -1.487882809600396e-07,   1.110406870790767e-09,  -8.286942660222066e-12,   6.184507398327929e-14,  -4.615440231154822e-16,   3.444373456530392e-18,  -2.569975273046183e-20,
   3.579499702806668e-01,  -2.671415105508271e-03,   1.993702035352057e-05,  -1.487917854294997e-07,   1.110446101289297e-09,  -8.287352545917736e-12,   6.184915251427744e-14,
  -4.615831520230063e-16,   3.444738208443682e-18,  -2.570306835770120e-20,   3.579501100682624e-01,  -2.671418234731925e-03,   1.993706705833534e-05,  -1.487923663510608e-07,
   1.110452604389325e-09,  -8.287420491458326e-12,   6.184982860308308e-14,  -4.615896383621231e-16,   3.444798673089427e-18,  -2.570361798871692e-20,   5.531142932051277e-01,
  -4.127497405052622e-03,   3.079888558967918e-05,  -2.298049903985461e-07,   1.714589486047796e-09,  -1.279195927108830e-11,   9.543110847751661e-14,  -7.118973577134862e-16,
   5.310194095421002e-18,  -3.960019120178674e-20,   5.531186790592021e-01,  -4.127595578247724e-03,   3.080035073748736e-05,  -2.298232122890907e-07,   1.714793446133607e-09,
  -1.279408999412064e-11,   9.545230684333495e-14,  -7.121006943620410e-16,   5.312088999276947e-18,  -3.961740326103460e-20,   5.531258792995850e-01,  -4.127756751067895e-03,
   3.080275614076277e-05,  -2.298531286653565e-07,   1.715128312361063e-09,  -1.279758836043513e-11,   9.548711285404867e-14,  -7.124345681768952e-16,   5.315200493054707e-18,
  -3.964566674186061e-20,   5.531335195165333e-01,  -4.127927775542256e-03,   3.080530863085109e-05,  -2.298848752348233e-07,   1.715483675808843e-09,  -1.280130099504876e-11,
   9.552405214673789e-14,  -7.127889208220568e-16,   5.318502983251508e-18,  -3.967566612914702e-20,   5.531395325561556e-01,  -4.128062378245502e-03,   3.080731757800405e-05,
  -2.299098621111506e-07,   1.715763380932415e-09,  -1.280422329072196e-11,   9.555312894119228e-14,  -7.130678610176758e-16,   5.321102751823692e-18,  -3.969928279136185e-20,
   5.531430028585269e-01,  -4.128140062319744e-03,   3.080847703041477e-05,  -2.299242833917216e-07,   1.715924817146467e-09,  -1.280590997817605e-11,   9.556991188351620e-14,
  -7.132288680369951e-16,   5.322603406302939e-18,  -3.971291522961871e-20,   5.531443060028455e-01,  -4.128169233882124e-03,   3.080891242572340e-05,  -2.299296988896029e-07,
   1.715985440491894e-09,  -1.280654337887877e-11,   9.557621445272516e-14,  -7.132893325331322e-16,   5.323166969380397e-18,  -3.971803487510612e-20,   5.531445220182637e-01,
  -4.128174069508302e-03,   3.080898459922380e-05,  -2.299305965945250e-07,   1.715995489807964e-09,  -1.280664837584155e-11,   9.557725921528228e-14,  -7.132993556399300e-16,
   5.323260390791550e-18,  -3.971888355755345e-20,   2.467246282448947e-03,  -1.787769291415036e-05,   1.295352791958708e-07,  -9.385172830085542e-10,   6.799454814975231e-12,
  -4.925876316198160e-14,   3.568374745457100e-16,  -2.584845960182900e-18,   1.872295526661520e-20,  -1.355992759205830e-22,   2.467264727954620e-03,  -1.787809383575974e-05,
   1.295410891912876e-07,  -9.385874471713210e-10,   6.800217411833880e-12,  -4.926649898421873e-14,   3.569122090041233e-16,  -2.585542142148050e-18,   1.872925935482873e-20,
  -1.356550514032251e-22,   2.467295009836648e-03,  -1.787875203515343e-05,   1.295506277102693e-07,  -9.387026409650115e-10,   6.801469453410266e-12,  -4.927920009352275e-14,
   3.570349158852166e-16,  -2.586685244254146e-18,   1.873961077491126e-20,  -1.357466389953050e-22,   2.467327142068474e-03,  -1.787945046505902e-05,   1.295607494566199e-07,
  -9.388248813098243e-10,   6.802798123168838e-12,  -4.929267899804393e-14,   3.571651420719779e-16,  -2.587898444966359e-18,   1.875059747530015e-20,  -1.358438519245222e-22,
   2.467352430893594e-03,  -1.788000015440950e-05,   1.295687157879659e-07,  -9.389210929431156e-10,   6.803843906848630e-12,  -4.930328844823379e-14,   3.572676486532724e-16,
  -2.588853443813856e-18,   1.875924627038102e-20,  -1.359203817608805e-22,   2.467367025805521e-03,  -1.788031739943899e-05,   1.295733134994807e-07,  -9.389766217007833e-10,
   6.804447494599850e-12,  -4.930941196332615e-14,   3.573268143771392e-16,  -2.589404673913317e-18,   1.876423854282341e-20,  -1.359645577468566e-22,   2.467372506384771e-03,
  -1.788043652971953e-05,   1.295750400210155e-07,  -9.389974738954980e-10,   6.804674156410476e-12,  -4.931171151640111e-14,   3.573490330503612e-16,  -2.589611681719914e-18,
   1.876611335781060e-20,  -1.359811479929991e-22,   2.467373414871587e-03,  -1.788045627735406e-05,   1.295753262185268e-07,  -9.390009304765844e-10,   6.804711729304098e-12,
  -4.931209270616131e-14,   3.573527161849961e-16,  -2.589645997040583e-18,   1.876642414404307e-20,  -1.359838981547260e-22,   2.238200666848734e-02,  -1.621802593718008e-04,
   1.175099341881852e-06,  -8.513904848574033e-09,   6.168230715005745e-11,  -4.468584969622994e-13,   3.237106397028783e-15,  -2.344883010050216e-17,   1.698481750358346e-19,
  -1.230109269794466e-21,   2.238217399974807e-02,  -1.621838963942572e-04,   1.175152048154868e-06,  -8.514541353640375e-09,   6.168922516552766e-11,  -4.469286736706979e-13,
   3.237784362186326e-15,  -2.345514561996215e-17,   1.699053633988451e-19,  -1.230615239234296e-21,   2.238244870652960e-02,  -1.621898673519696e-04,   1.175238578306710e-06,
  -8.515586351975757e-09,   6.170058325453172e-11,  -4.470438937490029e-13,   3.238897516569277e-15,  -2.346551544271082e-17,   1.699992676625814e-19,  -1.231446079556795e-21,
   2.238274019904582e-02,  -1.621962032669999e-04,   1.175330399295934e-06,  -8.516695274190693e-09,   6.171263648795408e-11,  -4.471661697169605e-13,   3.240078883491865e-15,
  -2.347652117548002e-17,   1.700989349533223e-19,  -1.232327950273587e-21,   2.238296961053850e-02,  -1.622011898590543e-04,   1.175402667104209e-06,  -8.517568072918928e-09,
   6.172212347651569e-11,  -4.472624149859537e-13,   3.241008787741124e-15,  -2.348518459116747e-17,   1.701773936289086e-19,  -1.233022193493855e-21,   2.238310201054185e-02,
  -1.622040677964600e-04,   1.175444375956103e-06,  -8.518071810641851e-09,   6.172759901624956e-11,  -4.473179654006005e-13,   3.241545518722903e-15,  -2.349018515791647e-17,
   1.702226816807631e-19,  -1.233422937553455e-21,   2.238315172846511e-02,  -1.622051485052455e-04,   1.175460038363533e-06,  -8.518260974554835e-09,   6.172965521395687e-11,
  -4.473388261521274e-13,   3.241747078841009e-15,  -2.349206306036499e-17,   1.702396893098362e-19,  -1.233573436569664e-21,   2.238315996994393e-02,  -1.622053276489698e-04,
   1.175462634648571e-06,  -8.518292331465356e-09,   6.172999606227847e-11,  -4.473422841740181e-13,   3.241780490964431e-15,  -2.349237435695687e-17,   1.702425086477392e-19,
  -1.233598384760764e-21,   6.320894353413402e-02,  -4.580126799540509e-04,   3.318593772585094e-06,  -2.404408768160761e-08,   1.741967790173141e-10,  -1.261971453757687e-12,
   9.141900362329156e-15,  -6.622175418683444e-17,   4.796675368379905e-19,  -3.473943764919316e-21,   6.320941609373815e-02,  -4.580229512559267e-04,   3.318742620178796e-06,
  -2.404588523324719e-08,   1.742163161595531e-10,  -1.262169639539518e-12,   9.143815000941059e-15,  -6.623958980415448e-17,   4.798290413887465e-19,  -3.475372632368658e-21,
   6.321019189215960e-02,  -4.580398138158607e-04,   3.318986989665529e-06,  -2.404883640924007e-08,   1.742483924972525e-10,  -1.262495032135152e-12,   9.146958655651292e-15,
  -6.626887515281050e-17,   4.800942345983614e-19,  -3.477718941162856e-21,   6.321101509511325e-02,  -4.580577070504270e-04,   3.319246300986846e-06,  -2.405196811242835e-08,
   1.742824319897657e-10,  -1.262840351242519e-12,   9.150294949110420e-15,  -6.629995637060703e-17,   4.803757030514628e-19,  -3.480209360362546e-21,   6.321166297527438e-02,
  -4.580717896668903e-04,   3.319450392241045e-06,  -2.405443298013785e-08,   1.743092241595340e-10,  -1.263112157149498e-12,   9.152921087867247e-15,  -6.632442266594144e-17,
   4.805972766611541e-19,  -3.482169915759044e-21,   6.321203688564175e-02,  -4.580799172394387e-04,   3.319568182057803e-06,  -2.405585558400644e-08,   1.743246876113099e-10,
  -1.263269036869328e-12,   9.154436867619215e-15,  -6.633854473359319e-17,   4.807251737590556e-19,  -3.483301624108432e-21,   6.321217729384779e-02,  -4.580829692651847e-04,
   3.319612414205593e-06,  -2.405638980112412e-08,   1.743304945117497e-10,  -1.263327949640288e-12,   9.155006092717257e-15,  -6.634384810553066e-17,   4.807732046698216e-19,
  -3.483726635984264e-21,   6.321220056857811e-02,  -4.580834751843240e-04,   3.319619746364714e-06,  -2.405647835606092e-08,   1.743314571002506e-10,  -1.263337715427074e-12,
   9.155100451757169e-15,  -6.634472723618510e-17,   4.807811667065169e-19,  -3.483797090114744e-21,   1.272471809941009e-01,  -9.220344325519887e-04,   6.680727106250666e-06,
  -4.840363097347529e-08,   3.506789993287934e-10,  -2.540499823665556e-12,   1.840374129663842e-14,  -1.333123249301548e-16,   9.656280006878887e-19,  -6.993454008217059e-21,
   1.272481323132357e-01,  -9.220551099140162e-04,   6.681026754301029e-06,  -4.840724966041914e-08,   3.507183299380842e-10,  -2.540898795387230e-12,   1.840759569261771e-14,
  -1.333482301047729e-16,   9.659531256864281e-19,  -6.996330358001490e-21,   1.272496940884629e-01,  -9.220890562686927e-04,   6.681518699373476e-06,  -4.841319073148448e-08,
   3.507829034509383e-10,  -2.541553849664454e-12,   1.841392424463979e-14,  -1.334071849214113e-16,   9.664869864214022e-19,  -7.001053541666086e-21,   1.272513512946964e-01,
  -9.221250774949641e-04,   6.682040724150206e-06,  -4.841949522543603e-08,   3.508514290297582e-10,  -2.542249018396829e-12,   1.842064060143672e-14,  -1.334697550310781e-16,
   9.670536108351086e-19,  -7.006066822177201e-21,   1.272526555551304e-01,  -9.221534274901670e-04,   6.682451584311900e-06,  -4.842445729962749e-08,   3.509053648791381e-10,
  -2.542796196249806e-12,   1.842592733207861e-14,  -1.335190085312963e-16,   9.674996608591183e-19,  -7.010013471700202e-21,   1.272534082815253e-01,  -9.221697892680622e-04,
   6.682688709333986e-06,  -4.842732117175895e-08,   3.509364946612002e-10,  -2.543112013919892e-12,   1.842897877756346e-14,  -1.335474378970017e-16,   9.677571306076053e-19,
  -7.012291629951504e-21,   1.272536909400766e-01,  -9.221759333617742e-04,   6.682777753950152e-06,  -4.842839661485964e-08,   3.509481846478711e-10,  -2.543230612385529e-12,
   1.843012469559809e-14,  -1.335581142018809e-16,   9.678538216701506e-19,  -7.013147189803919e-21,   1.272537377948990e-01,  -9.221769518376525e-04,   6.682792514465462e-06,
  -4.842857488656352e-08,   3.509501224539109e-10,  -2.543250272084263e-12,   1.843031465160304e-14,  -1.335598839941934e-16,   9.678698500521115e-19,  -7.013289015779261e-21,
   2.189708833699109e-01,  -1.586665359625856e-03,   1.149640176371712e-05,  -8.329446475525292e-08,   6.034592645341492e-10,  -4.371770641923993e-12,   3.166972680325501e-14,
  -2.294079567906876e-16,   1.661681827925624e-18,  -1.203452126604891e-20,   2.189725204292916e-01,  -1.586700941869750e-03,   1.149691740734687e-05,  -8.330069190362552e-08,
   6.035269458621213e-10,  -4.372457204754434e-12,   3.167635956410077e-14,  -2.294697433587034e-16,   1.662241304828155e-18,  -1.203947061759338e-20,   2.189752079803906e-01,
  -1.586759357806453e-03,   1.149776396163776e-05,  -8.331091548239588e-08,   6.036380659586672e-10,  -4.373584442335671e-12,   3.168724992725959e-14,  -2.295711943551113e-16,
   1.663159975281628e-18,  -1.204759782407738e-20,   2.189780597521159e-01,  -1.586821344246350e-03,   1.149866227801381e-05,  -8.332176445050482e-08,   6.037559868924586e-10,
  -4.374780710106693e-12,   3.169880763653737e-14,  -2.296788666409072e-16,   1.664135025565348e-18,  -1.205622419802956e-20,   2.189803041637967e-01,  -1.586870129794639e-03,
   1.149936929888325e-05,  -8.333030334118672e-08,   6.038488013689350e-10,  -4.375722310612875e-12,   3.170790520200040e-14,  -2.297636233546047e-16,   1.664902590739901e-18,
  -1.206301521265557e-20,   2.189815994786504e-01,  -1.586898285647925e-03,   1.149977735095282e-05,  -8.333523158089330e-08,   6.039023704599577e-10,  -4.376265779388740e-12,
   3.171315622137068e-14,  -2.298125453514867e-16,   1.665345645981656e-18,  -1.206693524702533e-20,   2.189820858862248e-01,  -1.586908858594352e-03,   1.149993058168145e-05,
  -8.333708223663059e-08,   6.039224869502937e-10,  -4.376469867281964e-12,   3.171512815166439e-14,  -2.298309174163659e-16,   1.665512032444989e-18,  -1.206840741146463e-20,
   2.189821665154519e-01,  -1.586910611219134e-03,   1.149995598203257e-05,  -8.333738901209028e-08,   6.039258215868139e-10,  -4.376503698297180e-12,   3.171545503368319e-14,
  -2.298339629212948e-16,   1.665539614164466e-18,  -1.206865145184090e-20,   3.475546236060876e-01,  -2.518384514721054e-03,   1.824730085717122e-05,  -1.322065102936065e-07,
   9.578216715149425e-10,  -6.938954963247219e-12,   5.026677371635661e-14,  -3.641205036314245e-16,   2.637450257463573e-18,  -1.910133501307496e-20,   3.475572219769218e-01,
  -2.518440991514649e-03,   1.824811929624801e-05,  -1.322163941383097e-07,   9.579290965652540e-10,  -6.940044688318388e-12,   5.027730134913448e-14,  -3.642185719811503e-16,
   2.638338248137742e-18,  -1.910918977774111e-20,   3.475614877075809e-01,  -2.518533710366493e-03,   1.824946296282764e-05,  -1.322326211910199e-07,   9.581054684290891e-10,
  -6.941833860406271e-12,   5.029458672191012e-14,  -3.643795961633509e-16,   2.639796343546417e-18,  -1.912208788342421e-20,   3.475660140922460e-01,  -2.518632096386841e-03,
   1.825088878714323e-05,  -1.322498408732181e-07,   9.582926347070414e-10,  -6.943732598471565e-12,   5.031293131790600e-14,  -3.645504948426107e-16,   2.641343923671083e-18,
  -1.913577817229262e-20,   3.475695764638496e-01,  -2.518709529708623e-03,   1.825201098370356e-05,  -1.322633939579345e-07,   9.584399515535269e-10,  -6.945227123999715e-12,
   5.032737113104361e-14,  -3.646850216612781e-16,   2.642562187455786e-18,  -1.914655568924034e-20,   3.475716324114692e-01,  -2.518754219198114e-03,   1.825265865147221e-05,
  -1.322712161508555e-07,   9.585249774014092e-10,  -6.946089727570552e-12,   5.033570563971814e-14,  -3.647626712090433e-16,   2.643265395630222e-18,  -1.915277688298675e-20,
   3.475724044465401e-01,  -2.518771000773633e-03,   1.825290186211002e-05,  -1.322741535457611e-07,   9.585569066653658e-10,  -6.946413659603521e-12,   5.033883552154786e-14,
  -3.647918315583292e-16,   2.643529480792940e-18,  -1.915511324467361e-20,   3.475725324227359e-01,  -2.518773782572002e-03,   1.825294217801566e-05,  -1.322746404654265e-07,
   9.585621994618662e-10,  -6.946467356808988e-12,   5.033935435433515e-14,  -3.647966654182038e-16,   2.643573257928538e-18,  -1.915550054280994e-20,   5.370802543213773e-01,
  -3.891689259120170e-03,   2.819776898191379e-05,  -2.043002778488461e-07,   1.480133112562127e-09,  -1.072284882545586e-11,   7.767783586942296e-14,  -5.626796030279135e-16,
   4.075677849348636e-18,  -2.951728980159896e-20,   5.370842696144383e-01,  -3.891776533374651e-03,   2.819903372546071e-05,  -2.043155514704662e-07,   1.480299117753959e-09,
  -1.072453279012471e-11,   7.769410432273697e-14,  -5.628311479605465e-16,   4.077050009590912e-18,  -2.952942511515567e-20,   5.370908614982793e-01,  -3.891919812908704e-03,
   2.820111010925518e-05,  -2.043406273261221e-07,   1.480571667266398e-09,  -1.072729761829955e-11,   7.772081557721246e-14,  -5.630799784745127e-16,   4.079303118968688e-18,
  -2.954935217822944e-20,   5.370978561738267e-01,  -3.892071849985007e-03,   2.820331345236687e-05,  -2.043672371038153e-07,   1.480860897513692e-09,  -1.073023176003392e-11,
   7.774916365937930e-14,  -5.633440680256986e-16,   4.081694503167348e-18,  -2.957050310420910e-20,   5.371033611486332e-01,  -3.892191508609380e-03,   2.820504759593148e-05,
  -2.043881808452389e-07,   1.481088547966539e-09,  -1.073254126749066e-11,   7.777147764253689e-14,  -5.635519521686917e-16,   4.083577013784539e-18,  -2.958715389800890e-20,
   5.371065382287105e-01,  -3.892260567803966e-03,   2.820604844456417e-05,  -2.044002685720797e-07,   1.481219939407734e-09,  -1.073387425869085e-11,   7.778435703947930e-14,
  -5.636719439243643e-16,   4.084663639385770e-18,  -2.959676536270984e-20,   5.371077312636006e-01,  -3.892286500570315e-03,   2.820642428082791e-05,  -2.044048077630202e-07,
   1.481269280074271e-09,  -1.073437483457973e-11,   7.778919367615828e-14,  -5.637170053773821e-16,   4.085071714381555e-18,  -2.960037493490791e-20,   5.371079290267237e-01,
  -3.892290799316107e-03,   2.820648658147182e-05,  -2.044055602057135e-07,   1.481277459094856e-09,  -1.073445781348771e-11,   7.778999543348447e-14,  -5.637244751352488e-16,
   4.085139360567078e-18,  -2.960097329277214e-20  };
  static constexpr double xi[24780] = {  -8.790091838979900e-04,   4.577564360540388e-05,  -1.561510964354330e-06,   4.333130146099100e-08,  -1.048785095137675e-09,
   2.271534375165594e-11,  -4.418302106747885e-13,   7.570810100955985e-15,  -1.070576126048745e-16,   9.484683811314347e-19,   8.501775485252973e-21,  -7.287259769142657e-22,
   2.428435771068934e-23,  -6.004987978759334e-25,  -8.363005874069275e-04,   4.355297892849154e-05,  -1.485746120794584e-06,   4.123042048491225e-08,  -9.979692170313487e-10,
   2.161519335264617e-11,  -4.204284945850358e-13,   7.203570219186990e-15,  -1.018385285313368e-16,   9.011295724819136e-19,   8.136229196678841e-21,  -6.946784210654072e-22,
   2.313296762294945e-23,  -5.716869592993092e-25,  -7.550450361833387e-04,   3.932364423736000e-05,  -1.341556638613100e-06,   3.723155860689797e-08,  -9.012315060333018e-10,
   1.952066074694259e-11,  -3.796838031644366e-13,   6.504627433280614e-15,  -9.191593361034374e-17,   8.115723909189089e-19,   7.421497708798838e-21,  -6.293492237053942e-22,
   2.093078973898011e-23,  -5.167226216229912e-25,  -6.431695689486929e-04,   3.349940931020587e-05,  -1.142949074518551e-06,   3.172226575631692e-08,  -7.679279766639334e-10,
   1.663405606910112e-11,  -3.235333544150312e-13,   5.541820042345122e-15,  -7.826784036833206e-17,   6.892540799157149e-19,   6.400018086274526e-21,  -5.383308634713241e-22,
   1.787627166737302e-23,  -4.407583643874963e-25,  -5.116054772236619e-04,   2.664874169076661e-05,  -9.092847433296519e-07,   2.523895114503423e-08,  -6.110233537385854e-10,
   1.323592824092471e-11,  -2.574357061619960e-13,   4.408968165562558e-15,  -6.223530993682718e-17,   5.466633830919573e-19,   5.151302762752694e-21,  -4.299373633065204e-22,
   1.425572799029836e-23,  -3.510612655582832e-25,  -3.732273496685134e-04,   1.944191488530430e-05,  -6.634209652532720e-07,   1.841569183382863e-08,  -4.458603734133743e-10,
   9.658522431428219e-12,  -1.878537107335602e-13,   3.216883636874908e-15,  -4.538880439893278e-17,   3.978608712323528e-19,   3.793555200518639e-21,  -3.146631749897485e-22,
   1.042111372645815e-23,  -2.563788038758630e-25,  -2.415914596278920e-04,   1.258528483747614e-05,  -4.294682032396171e-07,   1.192196923321334e-08,  -2.886522215156790e-10,
   6.253120104500511e-12,  -1.216192547189357e-13,   2.082490844645767e-15,  -2.937467483514244e-17,   2.571333400431081e-19,   2.470809588499733e-21,  -2.041167650752240e-22,
   6.754715771059600e-24,  -1.660713105941125e-25,  -1.295998296029624e-04,   6.751403503031069e-06,  -2.303940067568063e-07,   6.395838235981759e-09,  -1.548576377137919e-10,
   3.354746074184038e-12,  -6.524742966128113e-14,   1.117188043320943e-15,  -1.575624785645213e-17,   1.378258956481798e-19,   1.329643490373237e-21,  -1.096164507415726e-22,
   3.626018218903277e-24,  -8.911970068767788e-26,  -4.822812711408843e-05,   2.512423646124955e-06,  -8.573796447793070e-08,   2.380141095944317e-09,  -5.762895357272598e-11,
   1.248445394519486e-12,  -2.428134133760224e-14,   4.157471832154204e-16,  -5.863187050704346e-18,   5.127488655532006e-20,   4.953454690830827e-22,  -4.080718646728916e-23,
   1.349678524834962e-24,  -3.316836481299214e-26,  -5.447750955274818e-06,   2.837985496393599e-07,  -9.684807062513315e-09,   2.688567979580626e-10,  -6.509678023223420e-12,
   1.410225654373672e-13,  -2.742784163116214e-15,   4.696207586482440e-17,  -6.622900247997963e-19,   5.791648265202139e-21,   5.596296255684744e-23,  -4.609774398490786e-24,
   1.524627501457187e-25,  -3.746705331982597e-27,  -6.818608902095773e-03,   2.817773197093668e-04,  -6.058330519284258e-06,   5.116303261622748e-08,   1.531918306282537e-09,
  -7.650671365693142e-11,   1.641023796619853e-12,  -1.152635472020750e-14,  -5.224742109750794e-16,   2.322280191516969e-17,  -4.646815289556255e-19,   2.214173681159409e-21,
   1.848520486422960e-22,  -7.060601375955134e-24,  -6.487129224818216e-03,   2.680760973876367e-04,  -5.763376275675903e-06,   4.865167867682270e-08,   1.458135426746964e-09,
  -7.279248085167202e-11,   1.560765389696596e-12,  -1.094083056030369e-14,  -4.976795701695394e-16,   2.209670082811235e-17,  -4.417131503120488e-19,   2.090120740811004e-21,
   1.761666990355254e-22,  -6.715854048509958e-24,  -5.856544357340538e-03,   2.420129841178855e-04,  -5.202451577072136e-06,   4.388405035604376e-08,   1.317495017669650e-09,
  -6.572469142371650e-11,   1.408282328639845e-12,  -9.837204169209182e-15,  -4.502652181784831e-16,   1.995328437503673e-17,  -3.981726759097543e-19,   1.860809813039982e-21,
   1.595209597117526e-22,  -6.060613515285361e-24,  -4.988477111998959e-03,   2.061366218730123e-04,  -4.430621549298295e-06,   3.733991236435128e-08,   1.123344442023931e-09,
  -5.599111441737095e-11,   1.198752263233587e-12,  -8.337794054767218e-15,  -3.845167426220766e-16,   1.700035958019140e-17,  -3.385320888658124e-19,   1.558083500827675e-21,
   1.363681334869516e-22,  -5.159764070927557e-24,  -3.967823581430718e-03,   1.639569206797359e-04,  -3.523555388441523e-06,   2.966953107569032e-08,   8.943784240184580e-10,
  -4.454155257694282e-11,   9.528725467186297e-13,  -6.599953066566035e-15,  -3.066077602959108e-16,   1.352554394281447e-17,  -2.687858765038608e-19,   1.218522341357478e-21,
   1.088454247295833e-22,  -4.102074570556217e-24,  -2.894477798340616e-03,   1.196023588089468e-04,  -2.570065745567924e-06,   2.162559847750124e-08,   6.529505664337432e-10,
  -3.249622161570975e-11,   6.947483767489982e-13,  -4.795830012900441e-15,  -2.241150321268557e-16,   9.868746284095409e-18,  -1.957923193627278e-19,   8.766929755343966e-22,
   7.962323594807444e-23,  -2.991225327814115e-24,  -1.873548125701023e-03,   7.741572197591155e-05,  -1.663422930565320e-06,   1.399021685399940e-08,   4.228634218508336e-10,
  -2.103585703761646e-11,   4.495450412135202e-13,  -3.096240867932222e-15,  -1.452576694614294e-16,   6.388739099571593e-18,  -1.266117000274547e-19,   5.622505950899238e-22,
   5.163352395469655e-23,  -1.935658097680880e-24,  -1.005034059243734e-03,   4.152813425887272e-05,  -8.922776756351276e-07,   7.502706089129934e-09,   2.268984986087455e-10,
  -1.128477507169362e-11,   2.411085332944930e-13,  -1.658717619862711e-15,  -7.797386464080883e-17,   3.427369923231070e-18,  -6.788527536114668e-20,   3.001727070082642e-22,
   2.772401347534698e-23,  -1.038209667523794e-24,  -3.740023535236214e-04,   1.545379134995378e-05,  -3.320374839191724e-07,   2.791700762499457e-09,   8.444333832747926e-11,
  -4.199448841436045e-12,   8.971797879342459e-14,  -6.169707571651563e-16,  -2.902317342727101e-17,   1.275454348631301e-18,  -2.525774301734108e-20,   1.115168200851907e-22,
   1.032028380404075e-23,  -3.863294803924677e-25,  -4.224650646308844e-05,   1.745626646113830e-06,  -3.750615583941105e-08,   3.153396396425897e-10,   9.538679163702027e-12,
  -4.743617759027634e-13,   1.013425240676424e-14,  -6.968656739980275e-17,  -3.278518135878224e-18,   1.440731432091418e-19,  -2.852982882759287e-21,   1.259336483185240e-23,
   1.165817658876672e-24,  -4.363862082335867e-26,  -1.400429623743635e-02,   3.171963499516589e-04,   2.240448178112069e-06,  -2.248971730092636e-07,   2.673331091285787e-09,
   8.616930107262992e-11,  -3.127733148967379e-12,   3.108433856949179e-15,   1.855424590539691e-15,  -3.489667282502021e-17,  -5.286684816558037e-19,   3.118709284461922e-20,
  -2.307611738087420e-22,  -1.511685726982494e-23,  -1.332305534310256e-02,   3.017478056280773e-04,   2.131945509677039e-06,  -2.139324768616192e-07,   2.541910474979131e-09,
   8.197976438338634e-11,  -2.974058725969022e-12,   2.920237522704147e-15,   1.764465267750865e-15,  -3.314862673380094e-17,  -5.033948630091171e-19,   2.963519168192211e-20,
  -2.184756259909581e-22,  -1.437394399088360e-23,  -1.202728549716020e-02,   2.723710639812856e-04,   1.925368388147066e-06,  -1.930867993143837e-07,   2.292499076058176e-09,
   7.401004220004847e-11,  -2.682379537222754e-12,   2.577380715604052e-15,   1.591738473989901e-15,  -2.984431540657244e-17,  -4.551394744455329e-19,   2.669753071447914e-20,
  -1.955419557573091e-22,  -1.296389013898499e-23,  -1.024386433256580e-02,   2.319532196820842e-04,   1.640665916820917e-06,  -1.644153781674764e-07,   1.950309209063784e-09,
   6.303923807487804e-11,  -2.282132352969038e-12,   2.134710043734315e-15,   1.354559878761993e-15,  -2.533632094357299e-17,  -3.883713560851825e-19,   2.268175491824969e-20,
  -1.648161436198253e-22,  -1.102908066374319e-23,  -8.147394168005905e-03,   1.844591551564197e-04,   1.305505839059525e-06,  -1.307356643785021e-07,   1.549426241936708e-09,
   5.014053158019917e-11,  -1.813150138782603e-12,   1.651210651778650e-15,   1.076449146150841e-15,  -2.008737269366860e-17,  -3.094416450934605e-19,   1.799578823108181e-20,
  -1.297534748053187e-22,  -8.762196741033693e-24,  -5.943097628609035e-03,   1.345395484480830e-04,   9.526578093779784e-07,  -9.534655454004375e-08,   1.129203374878550e-09,
   3.657643862655732e-11,  -1.321464665398775e-12,   1.177124318496264e-15,   7.846888207041073e-16,  -1.461529617990460e-17,  -2.260445828865184e-19,   1.310114210973821e-20,
  -9.386780839465940e-23,  -6.385825604174631e-24,  -3.846730971550342e-03,   8.707622370375721e-05,   6.167712963988613e-07,  -6.170622226413810e-08,   7.304515688261697e-10,
   2.367513002784557e-11,  -8.548469543118830e-13,   7.502241618321737e-16,   5.076734114097276e-16,  -9.443924169832951e-18,  -1.464472975091428e-19,   8.468800451434252e-21,
  -6.042374965321128e-23,  -4.130827516186990e-24,  -2.063477262865563e-03,   4.670812120435916e-05,   3.308930200595975e-07,  -3.309852097203093e-08,   3.917111282977300e-10,
   1.270007765650369e-11,  -4.584266013007595e-13,   3.992223481780497e-16,   2.722661292740130e-16,  -5.061545203793711e-18,  -7.859560324789058e-20,   4.539821632326688e-21,
  -3.232106283248792e-23,  -2.215193102139925e-24,  -7.678748447116182e-04,   1.738112604054599e-05,   1.231395889198545e-07,  -1.231656231954052e-08,   1.457505595235155e-10,
   4.726060284350580e-12,  -1.705754607316284e-13,   1.481449227663356e-16,   1.013094629327768e-16,  -1.882966213282468e-18,  -2.925240973784057e-20,   1.688994478661371e-21,
  -1.201566275750393e-23,  -8.242441494150475e-25,  -8.673741237795556e-05,   1.963329075839451e-06,   1.390966881255461e-08,  -1.391246131561896e-09,   1.646337549475545e-11,
   5.338455362761559e-13,  -1.926750987398316e-14,   1.672665455239614e-17,   1.144354500154607e-17,  -2.126854125779193e-19,  -3.304373964977822e-21,   1.907779477326199e-22,
  -1.357049541929266e-24,  -9.310318057502752e-26,  -1.712245185420437e-02,   7.945221652433959e-06,   1.017803882980551e-05,  -4.012718282675463e-09,  -6.062510801924469e-09,
   1.158907857945564e-12,   3.690553211145089e-12,   1.321786951355439e-16,  -2.290544869725975e-15,  -7.151250328582604e-19,   1.440066851398393e-18,   8.616418651440059e-22,
  -9.204459104282483e-22,  -4.330630317780066e-25,  -1.628930914583590e-02,   7.558406220556420e-06,   9.681898244904575e-06,  -3.817193557071469e-09,  -5.765989736384932e-09,
   1.102617164886218e-12,   3.509147687085326e-12,   1.249937105810795e-16,  -2.177220004055613e-15,  -6.789417856516042e-19,   1.368232480671847e-18,   8.187315747736969e-22,
  -8.741443402783884e-22,  -4.116673611207558e-25,  -1.470469992761702e-02,   6.822784783835716e-06,   8.738621088265779e-06,  -3.445423533503342e-09,  -5.202640298819347e-09,
   9.955131592556186e-13,   3.164866612865272e-12,   1.116363072610296e-16,  -1.962443731328853e-15,  -6.106881752304152e-19,   1.232326681253178e-18,   7.375187563569942e-22,
  -7.867000899833682e-22,  -3.711057185028232e-25,  -1.252390970320989e-02,   5.810570302515541e-06,   7.441160935011345e-06,  -2.933997680529343e-09,  -4.428548724718379e-09,
   8.480342903899069e-13,   2.692500496065011e-12,   9.384899983149335e-17,  -1.668339511703033e-15,  -5.178500797432729e-19,   1.046682252078352e-18,   6.265277889752405e-22,
  -6.675539624550271e-22,  -3.155391643642978e-25,  -9.960537318692099e-03,   4.620997188731423e-06,   5.916979804195512e-06,  -2.333124513553230e-09,  -3.520183825557538e-09,
   6.745838973292886e-13,   2.139091484721781e-12,   7.369212787413556e-17,  -1.324505764311272e-15,  -4.101076998589466e-19,   8.302277057752583e-19,   4.970471480669650e-22,
  -5.290151232720113e-22,  -2.505471161463019e-25,  -7.265528020363096e-03,   3.370538233559982e-06,   4.315362503844167e-06,  -1.701649859439216e-09,  -2.566594732596312e-09,
   4.921349818418949e-13,   1.558962696206332e-12,   5.319753791229709e-17,  -9.647506889392809e-16,  -2.981185961691676e-19,   6.042912672571953e-19,   3.618313776334181e-22,
  -3.847634480671116e-22,  -1.825175475447773e-25,  -4.702618074414427e-03,   2.181513974494534e-06,   2.792835765265071e-06,  -1.101306681820983e-09,  -1.660743871170622e-09,
   3.185655252630644e-13,   1.008459439361247e-12,   3.419482949409324e-17,  -6.238436939624693e-16,  -1.925187405553026e-19,   3.905715274376785e-19,   2.338834264094212e-22,
  -2.485616292272923e-22,  -1.180323592222353e-25,  -2.522576143727265e-03,   1.170187609792617e-06,   1.498052956259865e-06,  -5.907383327407615e-10,  -8.907214885226183e-10,
   1.708932347333601e-13,   5.407975526039993e-13,   1.827746604188132e-17,  -3.344789962194525e-16,  -1.031500225420095e-19,   2.093570442563843e-19,   1.253736685909078e-22,
  -1.332021088790612e-22,  -6.328671490495911e-26,  -9.387152840025926e-04,   4.354543527633721e-07,   5.574537390195246e-07,  -2.198257673331840e-10,  -3.314429648091337e-10,
   6.359485133125447e-14,   2.012239492868639e-13,   6.793059029940170e-18,  -1.244471152849294e-16,  -3.836912855263731e-20,   7.788729770656937e-20,   4.664362502937035e-23,
  -4.955093602854473e-23,  -2.354696543350200e-26,  -1.060351190101728e-04,   4.918787765908379e-08,   6.296850932701988e-08,  -2.483095708911741e-11,  -3.743872390520057e-11,
   7.183547739105054e-15,   2.272942354714287e-14,   7.671767897517822e-19,  -1.405688170954368e-17,  -4.333808164147048e-21,   8.797614597412731e-21,   5.268557039788951e-24,
  -5.596855332752216e-24,  -2.659745727866525e-27,  -1.422422015345673e-02,  -2.955140259501511e-04,   2.699568082885930e-06,   2.102889840995534e-07,   2.090218175636075e-09,
  -8.305055726253147e-11,  -2.621432069668110e-12,   2.640536917183695e-15,   1.567161906175083e-15,   2.558555178960723e-17,  -4.789130350377457e-19,  -2.349437340792414e-20,
  -1.293696424893813e-22,   1.204639435829210e-23,  -1.353226859033146e-02,  -2.811214181148963e-04,   2.568630205548892e-06,   2.000357731737232e-07,   1.987385230806960e-09,
  -7.900917455787097e-11,  -2.492623867129293e-12,   2.539221897409563e-15,   1.490291930031839e-15,   2.430291194749732e-17,  -4.558641639230615e-19,  -2.232378366656389e-20,
  -1.223370516097973e-22,   1.145171709119537e-23,  -1.221613133167683e-02,  -2.537526580799777e-04,   2.319420889197558e-06,   1.805430410976311e-07,   1.792259270072184e-09,
  -7.132270643925342e-11,  -2.248145588591481e-12,   2.335429397756465e-15,   1.344337323895587e-15,   2.187875495797945e-17,  -4.119207750943596e-19,  -2.010852351876105e-20,
  -1.092636023022790e-22,   1.032410250979028e-23,  -1.040468746907959e-02,  -2.160975378942833e-04,   1.976121826905996e-06,   1.537330517280911e-07,   1.524609545428984e-09,
  -6.074456816080119e-11,  -1.912676009027764e-12,   2.033505347575424e-15,   1.143954115306089e-15,   1.857231448975548e-17,  -3.512424147433426e-19,  -1.708142742508285e-20,
  -9.185517014997282e-23,   8.778938252757923e-24,  -8.275288111171229e-03,  -1.718499523557444e-04,   1.572180529688989e-06,   1.222406459146497e-07,   1.211129479129187e-09,
  -4.831099987129483e-11,  -1.519605456145823e-12,   1.651531777685788e-15,   9.090308509814707e-16,   1.472340179795961e-17,  -2.796662932946908e-19,  -1.355060416474673e-20,
  -7.212781958924322e-23,   6.971211653274328e-24,  -6.036380317280435e-03,  -1.253426855351190e-04,   1.147107800859852e-06,   8.915053273713542e-08,   8.825985280129821e-10,
  -3.523926360306366e-11,  -1.107515505000944e-12,   1.224765443528556e-15,   6.626165207559399e-16,   1.071179930268844e-17,  -2.041815502892158e-19,  -9.863904877562503e-21,
  -5.206938059859766e-23,   5.078619401629360e-24,  -3.907105194729543e-03,  -8.112384061799516e-05,   7.425988817936458e-07,   5.769606162448963e-08,   5.709045631655272e-10,
  -2.280850771053264e-11,  -7.164415604422952e-13,   8.013102550020094e-16,   4.286825677566792e-16,   6.921294097563208e-18,  -1.322350346971669e-19,  -6.375729411769184e-21,
  -3.347024221499045e-23,   3.284397887228587e-24,  -2.095862331421280e-03,  -4.351522738167727e-05,   3.983810460109877e-07,   3.094745283750759e-08,   3.061457700353460e-10,
  -1.223489217292533e-11,  -3.842034499772821e-13,   4.322002543814528e-16,   2.298995682209214e-16,   3.709434069730994e-18,  -7.095498195460061e-20,  -3.417672733318517e-21,
  -1.789034565810145e-23,   1.761059031510041e-24,  -7.799260501200042e-04,  -1.619297880421203e-05,   1.482525332852032e-07,   1.151610251055068e-08,   1.139119259890551e-10,
  -4.552912394008700e-12,  -1.429577391323616e-13,   1.611385968596917e-16,   8.554451396279647e-17,   1.379950430482958e-18,  -2.640695313821257e-20,  -1.271493789764991e-21,
  -6.649204916722302e-24,   6.552372572770317e-25,  -8.809868685961345e-05,  -1.829118884593915e-06,   1.674634985931659e-08,   1.300828173076778e-09,   1.286700026645132e-11,
  -5.142864240994269e-13,  -1.614792247937241e-14,   1.820732599564362e-17,   9.662785811826015e-18,   1.558684063768583e-19,  -2.982918568548314e-21,  -1.436194589709312e-22,
  -7.509310094477219e-25,   7.401233677764018e-26,  -7.572815950575035e-03,  -2.843389882047330e-04,  -5.250815694761490e-06,  -2.140675835315808e-08,   1.910054587942762e-09,
   6.743365429063655e-11,   1.066422209339422e-12,  -1.803558695280929e-15,  -5.914896745344982e-16,  -1.688730069116170e-17,  -2.081409935874478e-19,   2.351820338148364e-21,
   1.759168854083491e-22,   4.236488306670340e-24,  -7.204627287767549e-03,  -2.705105167608693e-04,  -4.995072414132011e-06,  -2.034548232805284e-08,   1.817622580159182e-09,
   6.415244806500157e-11,   1.014057126737408e-12,  -1.733879887974266e-15,  -5.629950543947953e-16,  -1.606195773862641e-17,  -1.976708319524878e-19,   2.247188618344658e-21,
   1.674447254257209e-22,   4.025835995134006e-24,  -6.504227575589818e-03,  -2.442064381815331e-04,  -4.508758623296840e-06,  -1.833496279617025e-08,   1.641613622792479e-09,
   5.791169953551141e-11,   9.146532699849570e-13,  -1.594001901584262e-15,  -5.086823923353838e-16,  -1.449364108713257e-17,  -1.778958519864218e-19,   2.044184852742304e-21,
   1.512946748614006e-22,   3.627006255507078e-24,  -5.540087434917657e-03,  -2.080005033550306e-04,  -3.839674423422627e-06,  -1.558351689687752e-08,   1.398984490049972e-09,
   4.932298551845815e-11,   7.782245685654072e-13,  -1.387248397693152e-15,  -4.337095905985859e-16,  -1.233812156036415e-17,  -1.509504759964607e-19,   1.757067047506147e-21,
   1.289987770997038e-22,   3.081670393251781e-24,  -4.406517492197294e-03,  -1.654360087254520e-04,  -3.053459874982044e-06,  -1.236899504424322e-08,   1.113284370151835e-09,
   3.922755952335349e-11,   6.183358959534269e-13,  -1.126192526123530e-15,  -3.452989866032525e-16,  -9.808092821083063e-18,  -1.196196547591701e-19,   1.409805681514341e-21,
   1.027042923124399e-22,   2.445169993066618e-24,  -3.214466795869459e-03,  -1.206793144536891e-04,  -2.227103193869348e-06,  -9.007691695104775e-09,   8.124413660082668e-10,
   2.861375300020579e-11,   4.506790162060994e-13,  -8.349242074804400e-16,  -2.520832448118594e-16,  -7.151564169773045e-18,  -8.699882320502916e-20,   1.035617614644720e-21,
   7.497920182971467e-23,   1.780198608024960e-24,  -2.080657767561146e-03,  -7.811195363093745e-05,  -1.441414464289383e-06,  -5.823972732771182e-09,   5.260143673023902e-10,
   1.852024357398049e-11,   2.915505931535256e-13,  -5.461542888389648e-16,  -1.632513212658049e-16,  -4.627667394615827e-18,  -5.620072315866665e-20,   6.734069352494979e-22,
   4.855734839962652e-23,   1.150784982522261e-24,  -1.116130761238713e-03,  -4.190137824486759e-05,  -7.731809179647345e-07,  -3.122367601976279e-09,   2.822087537162058e-10,
   9.934611984279608e-12,   1.563516244718697e-13,  -2.945513927554957e-16,  -8.759604118089745e-17,  -2.482043264771900e-18,  -3.011704006565836e-20,   3.620828828001220e-22,
   2.605452661364679e-23,   6.169037996892729e-25,  -4.153441623468724e-04,  -1.559265544519601e-05,  -2.877176085354814e-07,  -1.161689632952569e-09,   1.050228629133246e-10,
   3.696922831729861e-12,   5.817703425506263e-14,  -1.098152258149201e-16,  -3.259995043307942e-17,  -9.235894497174693e-19,  -1.120342073559433e-20,   1.348509444962623e-22,
   9.696516909237326e-24,   2.295139324488075e-25,  -4.691637986943397e-05,  -1.761311884912345e-06,  -3.249986823235283e-08,  -1.312177834511381e-10,   1.186324401197822e-11,
   4.175958786255443e-13,   6.571446881392606e-15,  -1.240815157648689e-17,  -3.682473059920900e-18,  -1.043257773379047e-19,  -1.265442681982589e-21,   1.523443511053940e-23,
   1.095313431471994e-24,   2.592443731173859e-26,  -1.653363335796450e-03,  -7.862896067115003e-05,  -2.407592984038478e-06,  -5.850049166841022e-08,  -1.192350368931498e-09,
  -2.029903684382609e-11,  -2.657448604052645e-13,  -1.617398555597787e-15,   4.593768286006519e-17,   2.278820242102871e-18,   6.347248990703478e-20,   1.373150406710004e-21,
   2.359023016010746e-23,   3.218826068595361e-25,  -1.573015089439358e-03,  -7.480965135185106e-05,  -2.290699847821786e-06,  -5.566104642055233e-08,  -1.134472413882116e-09,
  -1.931268320899161e-11,  -2.527802135740523e-13,  -1.536273283961244e-15,   4.378855359297908e-17,   2.170230062296715e-18,   6.043148523340626e-20,   1.307100046790651e-21,
   2.244553940648662e-23,   3.057641286381981e-25,  -1.420154431731103e-03,  -6.754276865994385e-05,  -2.068269354298218e-06,  -5.025764691490244e-08,  -1.024333870097407e-09,
  -1.743611924847964e-11,  -2.281356322707172e-13,  -1.382958102377949e-15,   3.966608520991691e-17,   1.962765465561169e-18,   5.462833191791277e-20,   1.181162480042877e-21,
   2.026703204200947e-23,   2.752918650414292e-25,  -1.209703138796708e-03,  -5.753664238543175e-05,  -1.761952228340844e-06,  -4.281574756436600e-08,  -8.726478700435264e-10,
  -1.485246182754189e-11,  -1.942457027560986e-13,  -1.173868947134489e-15,   3.392485821358421e-17,   1.675441498729758e-18,   4.660448121915533e-20,   1.007239581784652e-21,
   1.726635237769594e-23,   2.337136446378542e-25,  -9.622310815874594e-04,  -4.576851832681913e-05,  -1.401642363218152e-06,  -3.406124635319421e-08,  -6.942122087752048e-10,
  -1.181419515147723e-11,  -1.544443685805311e-13,  -9.305195882215658e-16,   2.709052176612788e-17,   1.335424339333282e-18,   3.712566783032714e-20,   8.020430154813473e-22,
   1.373612053008387e-23,   1.852966877984635e-25,  -7.019566711770275e-04,  -3.338991474716772e-05,  -1.022591980507271e-06,  -2.485060164234962e-08,  -5.064837891900985e-10,
  -8.618647501675094e-12,  -1.126309610021347e-13,  -6.769357459041030e-16,   1.982498781886693e-17,   9.758111102241399e-19,   2.711595508130807e-20,   5.856005710982594e-22,
   1.002176089256372e-23,   1.348193126789257e-25,  -4.543740967754535e-04,  -2.161375149718221e-05,  -6.619546944873310e-07,  -1.608681960701827e-08,  -3.278663133443421e-10,
  -5.578854319131544e-12,  -7.288949821223114e-14,  -4.373704163523960e-16,   1.285926169892824e-17,   6.323264659828277e-19,   1.756593312632421e-20,   3.792718477132645e-22,
   6.487522401871271e-24,   8.711548368266318e-26,  -2.437439938108767e-04,  -1.159461843111952e-05,  -3.551078253167023e-07,  -8.629904052744878e-09,  -1.758861021352244e-10,
  -2.992724404462840e-12,  -3.909632451635947e-14,  -2.343999438919498e-16,   6.905544491082944e-18,   3.393939840792648e-19,   9.426872904551731e-21,   2.035152950473436e-22,
   3.480288056752291e-24,   4.669008298334313e-26,  -9.070453910417811e-05,  -4.314730051859359e-06,  -1.321476317549741e-07,  -3.211488943501402e-09,  -6.545331139069703e-11,
  -1.113684794187470e-12,  -1.454835307524405e-14,  -8.719849535649786e-17,   2.570712889660559e-18,   1.263233376383346e-19,   3.508520471388482e-21,   7.574186785451565e-23,
   1.295137281129980e-24,   1.736934769987854e-26,  -1.024579664055558e-05,  -4.873833278167883e-07,  -1.492714449980457e-08,  -3.627638425362659e-10,  -7.393483830848046e-12,
  -1.257995463062461e-13,  -1.643341467073174e-15,  -9.849244241668444e-18,   2.903994293146239e-19,   1.426966203426350e-20,   3.963240678025223e-22,   8.555781409788150e-24,
   1.462963157147466e-25,   1.961907807253280e-27,  -7.179591288114324e-04,   3.510930393785667e-05,  -1.128911805133260e-06,   2.967457467452875e-08,  -6.852091943615839e-10,
   1.430075479451115e-11,  -2.724877198301229e-13,   4.710819850817714e-15,  -7.208398992732748e-17,   8.996611617676956e-19,  -6.467340547439556e-21,  -9.702040026730522e-23,
   5.714247777540946e-24,  -1.720970012859437e-25,  -6.830711030967236e-04,   3.340423067812761e-05,  -1.074123687804038e-06,   2.823545424611269e-08,  -6.520021388386590e-10,
   1.360810699603620e-11,  -2.592938816704322e-13,   4.482645783913698e-15,  -6.858636023307989e-17,   8.557388323553900e-19,  -6.141412980429362e-21,  -9.270408633920148e-23,
   5.448992398170416e-24,  -1.639988229630825e-25,  -6.166964250784994e-04,   3.015991008212352e-05,  -9.698607262258902e-07,   2.549635401157431e-08,  -5.887891199927587e-10,
   1.228941618618187e-11,  -2.341733111364784e-13,   4.048241767519619e-15,  -6.192997304416611e-17,   7.722587308845546e-19,  -5.526042069656538e-21,  -8.433113466258301e-23,
   4.939297420557351e-24,  -1.484842853080321e-25,  -5.253129311577717e-04,   2.569239415235941e-05,  -8.262585411461888e-07,   2.172294941925029e-08,  -5.016879549227131e-10,
   1.047207342305588e-11,  -1.995504941754270e-13,   3.449577757137769e-15,  -5.276147627060810e-17,   6.574854194189369e-19,  -4.687971281168656e-21,  -7.249016750004731e-23,
   4.227770993552489e-24,  -1.269154112152768e-25,  -4.178515260982234e-04,   2.043786543930442e-05,  -6.573218028293257e-07,   1.728279529636144e-08,  -3.991729247818827e-10,
   8.332719943026654e-12,  -1.587890161000646e-13,   2.744846581613671e-15,  -4.197472905123040e-17,   5.227237038623827e-19,  -3.714097542644531e-21,  -5.816817243990596e-23,
   3.378661687476105e-24,  -1.012876640419858e-25,  -3.048285206475642e-04,   1.491045646546840e-05,  -4.795771767699821e-07,   1.261017551791298e-08,  -2.912689292480241e-10,
   6.080529061322855e-12,  -1.158739807061698e-13,   2.002954114622796e-15,  -3.062494500802305e-17,   3.811795565359719e-19,  -2.700725559524007e-21,  -4.273298633158604e-23,
   2.474040447661983e-24,  -7.408750073804391e-26,  -1.973152397549023e-04,   9.651845773353071e-06,  -3.104520295879579e-07,   8.163469105239421e-09,  -1.885666634700884e-10,
   3.936645662896157e-12,  -7.502017382978377e-14,   1.296745732885043e-15,  -1.982511890708410e-17,   2.466708614267799e-19,  -1.744423847598973e-21,  -2.778885587721697e-23,
   1.605405765398811e-24,  -4.804090100535720e-26,  -1.058478150612476e-04,   5.177725695080652e-06,  -1.665450286467760e-07,   4.379464139226718e-09,  -1.011625891947382e-10,
   2.111974331858297e-12,  -4.024797742756245e-14,   6.956912587469782e-16,  -1.063543463773363e-17,   1.323058468887482e-19,  -9.347438664472111e-22,  -1.494229972379185e-23,
   8.622956015136957e-25,  -2.579423936027211e-26,  -3.938921379500415e-05,   1.926801732129808e-06,  -6.197729580783062e-08,   1.629765327945577e-09,  -3.764671604621449e-11,
   7.859561828691716e-13,  -1.497804192209272e-14,   2.588964159521454e-16,  -3.957828560573580e-18,   4.923268512109441e-20,  -3.477126870258396e-22,  -5.565053580292864e-24,
   3.210279880611744e-25,  -9.601827512030833e-27,  -4.449324422738150e-06,   2.176477579335623e-07,  -7.000841778868896e-09,   1.840955172643604e-10,  -4.252513720588453e-12,
   8.878045419975547e-14,  -1.691898373766904e-15,   2.924455606314617e-17,  -4.470691907056410e-19,   5.561180120954759e-21,  -3.927450393397314e-23,  -6.286988418963994e-25,
   3.626519436451146e-26,  -1.084656441802820e-27,  -5.784092863541296e-03,   2.360801432793500e-04,  -5.341235216889017e-06,   6.543751164940030e-08,   3.625566576162512e-10,
  -4.223312292993565e-11,   1.185992926300126e-12,  -1.815594602121344e-14,   1.809637398632770e-17,   8.126015915259276e-18,  -2.725697399946203e-19,   4.858672930185718e-21,
  -2.628926150359515e-23,  -1.534459733296876e-24,  -5.502911376571315e-03,   2.246029394004154e-04,  -5.081369807727887e-06,   6.224201887416829e-08,   3.454507234732279e-10,
  -4.019018390298566e-11,   1.128318812007087e-12,  -1.726408336331502e-14,   1.685110262411911e-17,   7.738673714849284e-18,  -2.593614081057469e-19,   4.618734300575540e-21,
  -2.482824226146408e-23,  -1.463716749277217e-24,  -4.968007900912663e-03,   2.027696364363598e-04,  -4.587103107085922e-06,   5.616894317979341e-08,   3.126983243220883e-10,
  -3.629968493600445e-11,   1.018610432533154e-12,  -1.557120504622026e-14,   1.463074209753914e-17,   6.998681860481286e-18,  -2.342170316744025e-19,   4.163799175946931e-21,
  -2.212330615623387e-23,  -1.327564907390278e-24,  -4.231651359908876e-03,   1.727140910770733e-04,  -3.906855217532720e-06,   4.781998947681253e-08,   2.672016765459713e-10,
  -3.093596469570322e-11,   8.675991745620932e-13,  -1.324804350545465e-14,   1.186228485531704e-17,   5.973928942944999e-18,  -1.995692417441343e-19,   3.540468638149403e-21,
  -1.854394064781373e-23,  -1.137091695137402e-24,  -3.365854007298236e-03,   1.373758804891290e-04,  -3.107241713138913e-06,   3.801776807657711e-08,   2.131894637907913e-10,
  -2.461926830959232e-11,   6.900619782043154e-13,  -1.052573765480648e-14,   8.971992397947437e-18,   4.761370859639307e-18,  -1.587890375515931e-19,   2.811306065169098e-21,
  -1.451801809118155e-23,  -9.092949705514101e-25,  -2.455353176184257e-03,   1.002136829316088e-04,  -2.266539901778932e-06,   2.772282252261009e-08,   1.559056116585482e-10,
  -1.796700729457725e-11,   5.033769576779204e-13,  -7.671496291429855e-15,   6.272697316202125e-18,   3.479067545556007e-18,  -1.158649264828028e-19,   2.047999150716029e-21,
  -1.045450774519189e-23,  -6.661668594765698e-25,  -1.589311941185415e-03,   6.486654555634337e-05,  -1.467028242255597e-06,   1.793996737275239e-08,   1.010804764723619e-10,
  -1.163298087318592e-11,   3.258213215208781e-13,  -4.962681565450672e-15,   3.943756812206730e-18,   2.254382573248315e-18,  -7.501033267941141e-20,   1.324430559201579e-21,
  -6.708778330812798e-24,  -4.324151023975999e-25,  -8.525607867150910e-04,   3.479655448088797e-05,  -7.869449847815064e-07,   9.622343380180319e-09,   5.426850059549521e-11,
  -6.241210940248942e-12,   1.747797232441470e-13,  -2.661335143796783e-15,   2.083479800385525e-18,   1.209998048341082e-18,  -4.024158495332257e-20,   7.101364056259732e-22,
  -3.582766373522965e-24,  -2.322967199987871e-25,  -3.172626932993049e-04,   1.294880348839863e-05,  -2.928427229193444e-07,   3.580590545788305e-09,   2.020078338030785e-11,
  -2.322651028990578e-12,   6.504038042925475e-14,  -9.902546609695968e-16,   7.711676751456484e-19,   4.503623763288140e-19,  -1.497551789794873e-20,   2.642192754119747e-22,
  -1.331172922896702e-24,  -8.648769534430189e-26,  -3.583731699879292e-05,   1.462669080819849e-06,  -3.307884586383532e-08,   4.044529367122208e-10,   2.281943046000481e-12,
  -2.623637612224681e-13,   7.346818244727146e-15,  -1.118551602768208e-16,   8.703496241153788e-20,   5.087353028239376e-20,  -1.691610657392924e-21,   2.984487193713072e-23,
  -1.503291920964110e-25,  -9.770242003792671e-27,  -1.271558929005756e-02,   3.251570787911311e-04,  -1.576808827087510e-07,  -1.722808564278181e-07,   3.682527892305729e-09,
   1.761213288128104e-11,  -2.413232916277506e-12,   4.070007132039549e-14,   5.041630094673814e-16,  -3.381809991707778e-17,   4.249865877543700e-19,   1.034938780553667e-20,
  -4.691347647027734e-22,   3.945423464187888e-24,  -1.209710255639569e-02,   3.093259757627991e-04,  -1.493569735911320e-07,  -1.638957450319884e-07,   3.502333963410734e-09,
   1.678071320376153e-11,  -2.295429579919043e-12,   3.868432877278769e-14,   4.802014633674654e-16,  -3.215616881007281e-17,   4.034005863973919e-19,   9.854885636938703e-21,
  -4.457770804277012e-22,   3.734816606778920e-24,  -1.092066934002465e-02,   2.792196702145525e-04,  -1.337901438414673e-07,  -1.479484647566005e-07,   3.160021755619767e-09,
   1.518896900421203e-11,  -2.071525558289901e-12,   3.486484756189079e-14,   4.343941419655076e-16,  -2.900188076530449e-17,   3.627147397602219e-19,   8.910611281799994e-21,
  -4.015671534074104e-22,   3.341872525322250e-24,  -9.301444970967283e-03,   2.377939974495782e-04,  -1.128800987533961e-07,  -1.260030942055120e-07,   2.689716503959494e-09,
   1.297820003803516e-11,  -1.763680766396785e-12,   2.963623879628675e-14,   3.709019602136001e-16,  -2.467376000229871e-17,   3.074375847066008e-19,   7.603861715858193e-21,
  -3.411420662317727e-22,   2.815819540177210e-24,  -7.397928856296631e-03,   1.891105174652291e-04,  -8.895150208212640e-08,  -1.002100681739829e-07,   2.137911465698872e-09,
   1.035411390390057e-11,  -1.402209597264502e-12,   2.352562550867368e-14,   2.957031490032355e-16,  -1.960272242854832e-17,   2.433673072188193e-19,   6.058829088905398e-21,
  -2.706456545731096e-22,   2.216047144969529e-24,  -5.396450149648399e-03,   1.379359603914927e-04,  -6.439965895117359e-08,  -7.309463587126449e-08,   1.558708464826894e-09,
   7.571558982458303e-12,  -1.022530774268869e-12,   1.713406495390834e-14,   2.161152907472201e-16,  -1.428657203689638e-17,   1.768481008318926e-19,   4.426110219343373e-21,
  -1.970225134735835e-22,   1.602715894633898e-24,  -3.492928407914109e-03,   8.927607693994197e-05,  -4.147561250856574e-08,  -4.730981284548158e-08,   1.008553915462788e-09,
   4.908793129028114e-12,  -6.617117962122808e-13,   1.107880732567683e-14,   1.400601377465506e-16,  -9.241742610210635e-18,   1.141780813424172e-19,   2.867618389049927e-21,
  -1.273540597273866e-22,   1.031493572541777e-24,  -1.873694902293367e-03,   4.788858497443024e-05,  -2.219128081548217e-08,  -2.537770269718189e-08,   5.409195258498599e-10,
   2.635401845882671e-12,  -3.549215063872699e-13,   5.939796186439809e-15,   7.518034875256308e-17,  -4.956003908509406e-18,   6.116834313984211e-20,   1.539020134542785e-21,
  -6.826867594751162e-23,   5.516992232488251e-25,  -6.972525100678438e-04,   1.782046122304232e-05,  -8.250556301855816e-09,  -9.443667566464176e-09,   2.012785691818079e-10,
   9.809893171690976e-13,  -1.320710400203551e-13,   2.209950026593994e-15,   2.798292556237261e-17,  -1.844068677746051e-18,   2.275207876305332e-20,   5.728089546084439e-22,
  -2.539849893437019e-23,   2.050924764189611e-25,  -7.876008576797638e-05,   2.012956341329498e-06,  -9.318314250324281e-10,  -1.066734488225565e-09,   2.273575872076882e-11,
   1.108154710589505e-13,  -1.491836277334885e-14,   2.496236927691432e-16,   3.161001411680566e-18,  -2.082983946625700e-19,   2.569839109718309e-21,   6.470497524472363e-23,
  -2.868847989493124e-24,   2.316302939425258e-26,  -1.693041430916837e-02,   8.756035853075888e-05,   9.563890739830173e-06,  -9.615922118880398e-08,  -5.194794205222920e-09,
   8.185550695043601e-11,   2.740206842799597e-12,  -6.313222043318746e-14,  -1.382113399620106e-15,   4.570515678074292e-17,   6.356362696011253e-19,  -3.189038619103948e-20,
  -2.501098736476533e-22,   2.131593972045877e-23,  -1.610663040208514e-02,   8.329286397662715e-05,   9.097776273704291e-06,  -9.145778992870891e-08,  -4.940900096073124e-09,
   7.783484147889539e-11,   2.605776598706283e-12,  -6.001288607492345e-14,  -1.314040551652466e-15,   4.343036523254729e-17,   6.042299906472810e-19,  -3.029034355579077e-20,
  -2.377618735165117e-22,   2.023883222441997e-23,  -1.453981534662868e-02,   7.517907685504906e-05,   8.211549593283133e-06,  -8.252499442780763e-08,  -4.458460399427273e-09,
   7.020305037611392e-11,   2.350541710905777e-12,  -5.409937383446221e-14,  -1.184903219971647e-15,   3.912456903860196e-17,   5.446908348953040e-19,  -2.726687897815683e-20,
  -2.143486604102310e-22,   1.820655472418345e-23,  -1.238350246986202e-02,   6.401813193119489e-05,   6.992491416526709e-06,  -7.024915478883391e-08,  -3.795399361496041e-09,
   5.972971302157741e-11,   2.000144837565228e-12,  -4.599846613465961e-14,  -1.007828819686996e-15,   3.323898014716779e-17,   4.631278424878512e-19,  -2.314408394972239e-20,
  -1.822668986567522e-22,   1.544123868687326e-23,  -9.848886945906849e-03,   5.090616309550913e-05,   5.560323977512407e-06,  -5.584219284728807e-08,  -3.017138882993514e-09,
   4.745664808688372e-11,   1.589371291379055e-12,  -3.652370268887195e-14,  -8.005095045522514e-16,   2.637157781000277e-17,   3.677322133372278e-19,  -1.834617710982571e-20,
  -1.447347093382981e-22,   1.223057466142156e-23,  -7.184097636697890e-03,   3.712735298602816e-05,   4.055312743628301e-06,  -4.071631550802602e-08,  -2.199958872410145e-09,
   3.458836705169423e-11,   1.158522553579735e-12,  -2.660639423960724e-14,  -5.833069172421498e-16,   1.919865259953014e-17,   2.678811092605828e-19,  -1.334661852101695e-20,
  -1.054410768663544e-22,   8.891955804301826e-24,  -4.649916861346969e-03,   2.402848262204922e-05,   2.624563768938882e-06,  -2.634651123309433e-08,  -1.423567155373796e-09,
   2.237537741678102e-11,   7.495062793910977e-13,  -1.720599300584138e-14,  -3.772851699474430e-16,   1.241028008258876e-17,   1.732347998345649e-19,  -8.623382363113404e-21,
  -6.818991945316371e-23,   5.742771102006444e-24,  -2.494307467596509e-03,   1.288873501570924e-05,   1.407801073801305e-06,  -1.413081313934654e-08,  -7.635306801132601e-10,
   1.199929384861621e-11,   4.019538947990094e-13,  -9.225496878861311e-15,  -2.023113585346670e-16,   6.652695530295688e-18,   9.288482709835429e-20,  -4.621560413300914e-21,
  -3.656272740558821e-23,   3.077080364837683e-24,  -9.281959507823693e-04,   4.796149594520077e-06,   5.238703177509725e-07,  -5.258182896475249e-09,  -2.841165885446313e-10,
   4.464818253828047e-12,   1.495649336848213e-13,  -3.432508751215478e-15,  -7.527595110866688e-17,   2.475066233028139e-18,   3.455942618606547e-20,  -1.719258683437644e-21,
  -1.360389792445689e-23,   1.144613375465679e-24,  -1.048468823083453e-04,   5.417606037355495e-07,   5.917503233772790e-08,  -5.939476711185425e-10,  -3.209292751023219e-11,
   5.043279497561440e-13,   1.689428822142089e-14,  -3.877186985271521e-16,  -8.502831676026986e-18,   2.795675287185916e-19,   3.903656483989743e-21,  -1.941937831852696e-22,
  -1.536628612482698e-24,   1.292848799254017e-25,  -1.534649228738922e-02,  -2.634029446563617e-04,   5.358145063006241e-06,   2.271623295862067e-07,  -1.616938222128826e-10,
  -1.387425295332049e-10,  -1.745095239718022e-12,   6.180510177324548e-14,   1.897183938225004e-15,  -1.335743014038317e-17,  -1.371960124126125e-18,  -1.008001781016921e-20,
   7.276272792400112e-22,   1.602816276513568e-23,  -1.459987458920671e-02,  -2.505707571116291e-04,   5.097492388018428e-06,   2.160719494265605e-07,  -1.546011993182680e-10,
  -1.319555284102050e-10,  -1.658644379603642e-12,   5.878447456929593e-14,   1.803080401366896e-15,  -1.272385220658371e-17,  -1.303807017544074e-18,  -9.553078756250951e-21,
   6.915883490685159e-22,   1.520987322001370e-23,  -1.317978806400409e-02,  -2.261706936722555e-04,   4.601713839486350e-06,   1.949935255748833e-07,  -1.407953984521243e-10,
  -1.190615534495575e-10,  -1.494844823731174e-12,   5.304473208709867e-14,   1.624828777836806e-15,  -1.151207609070674e-17,  -1.174751230095091e-18,  -8.565798400916342e-21,
   6.233010307077373e-22,   1.366923228197867e-23,  -1.122533214899122e-02,  -1.926027967946760e-04,   3.919357246684311e-06,   1.660139923289516e-07,  -1.211838559838158e-10,
  -1.013448870346075e-10,  -1.270632453413724e-12,   4.515598527014440e-14,   1.380926335872405e-15,  -9.831417441374825e-18,  -9.982423342907470e-19,  -7.235919529083644e-21,
   5.298212861417169e-22,   1.157931411177694e-23,  -8.927890298794039e-03,  -1.531614996354056e-04,   3.117229679134407e-06,   1.319875355342011e-07,  -9.735900002824117e-11,
  -8.055612065807702e-11,  -1.008619522377780e-12,   3.589658707732156e-14,   1.096020608241088e-15,  -7.839615910787049e-18,  -7.921603162018608e-19,  -5.709072921266208e-21,
   4.205746742449580e-22,   9.161015060816563e-24,  -6.512365120256986e-03,  -1.117092306478505e-04,   2.273851745791118e-06,   9.624823529430186e-08,  -7.159132666295266e-11,
  -5.873332866880680e-11,  -7.345787327929266e-13,   2.617412052071408e-14,   7.981452630915345e-16,  -5.730442638702531e-18,  -5.767913362600181e-19,  -4.137533047393007e-21,
   3.063079687859298e-22,   6.654043017610141e-24,  -4.215168009873726e-03,  -7.229893120155837e-05,   1.471772079374485e-06,   6.228493177911910e-08,  -4.658311648586279e-11,
  -3.800371487087032e-11,  -4.749694425381048e-13,   1.693694665102892e-14,   5.160332355283158e-16,  -3.714141078049628e-18,  -3.728861695360331e-19,  -2.666564349805405e-21,
   1.980559814567160e-22,   4.294758363451650e-24,  -2.261108094034714e-03,  -3.878119572281241e-05,   7.894927664362637e-07,   3.340760162526197e-08,  -2.505571497998264e-11,
  -2.038277434873098e-11,  -2.546487471349327e-13,   9.084131435966360e-15,   2.766542321104670e-16,  -1.993742269518771e-18,  -1.999015980106273e-19,  -1.427245067652597e-21,
   1.061854254342384e-22,   2.300469505576019e-24,  -8.414175702726076e-04,  -1.443130115601744e-05,   2.937912185578446e-07,   1.243140427823338e-08,  -9.332630920916301e-12,
  -7.584543825166520e-12,  -9.474396074450013e-14,   3.380285756007421e-15,   1.029299260279042e-16,  -7.421043883171886e-19,  -7.437273634549835e-20,  -5.307064656002097e-22,
   3.950710958057049e-23,   8.556335685890832e-25,  -9.504461557153272e-05,  -1.630123417036851e-06,   3.318599293176114e-08,   1.404215280495133e-09,  -1.054349472935128e-12,
  -8.567252860188248e-13,  -1.070174852723223e-14,   3.818265681540639e-16,   1.162636543148375e-17,  -8.382966156720733e-20,  -8.400690450796236e-21,  -5.994006886202525e-23,
   4.462502960838149e-24,   9.664269061641411e-26,  -8.794932210154713e-03,  -3.267422375329038e-04,  -5.275477047256908e-06,   2.127076716099989e-08,   3.496957238426046e-09,
   8.967201604537670e-11,   6.501310606811186e-13,  -3.168079483899081e-14,  -1.295753254611302e-15,  -1.984824709688406e-17,   1.606282810477100e-19,   1.605459724130240e-20,
   3.728998592864300e-22,   1.451178392619520e-24,  -8.367299725880881e-03,  -3.108474390474763e-04,  -5.018251618897505e-06,   2.026274827158252e-08,   3.327149884144435e-09,
   8.529046124377775e-11,   6.174311074604813e-13,  -3.016089284774992e-14,  -1.232506569081853e-15,  -1.885654052349018e-17,   1.535417511544176e-19,   1.527683756179103e-20,
   3.542952607954752e-22,   1.364105372559137e-24,  -7.553831005967315e-03,  -2.806145242935369e-04,  -4.529233528935764e-06,   1.833456342161835e-08,   3.004040274321346e-09,
   7.696431008635182e-11,   5.556702500749536e-13,  -2.726126768986094e-14,  -1.112292631857500e-15,  -1.698087758730496e-17,   1.397658196986712e-19,   1.379612110345985e-20,
   3.190962837953485e-22,   1.205209158547117e-24,  -6.434064466795775e-03,  -2.390040192812388e-04,  -3.856649944278518e-06,   1.565967540485491e-08,   2.559092180560021e-09,
   6.551999442178191e-11,   4.715130139100279e-13,  -2.325363997397679e-14,  -9.470050794258819e-16,  -1.441995413165224e-17,   1.202311335214656e-19,   1.175556363813475e-20,
   2.710162263814747e-22,   9.995247702777796e-25,  -5.117544408050497e-03,  -1.900898815910637e-04,  -3.066603552828345e-06,   1.248862293201733e-08,   2.035739400731435e-09,
   5.208623141953487e-11,   3.736549948827326e-13,  -1.852139012658555e-14,  -7.529186120725705e-16,  -1.143562950085839e-17,   9.654234486148188e-20,   9.353626596127016e-21,
   2.149604347054359e-22,   7.741690900574172e-25,  -3.733128300736235e-03,  -1.386603314067256e-04,  -2.236480649777868e-06,   9.129652170445583e-09,   1.485188971309443e-09,
   3.797965880041378e-11,   2.717627525470635e-13,  -1.352608031019918e-14,  -5.490516721213494e-16,  -8.322184001673999e-18,   7.096080074510526e-20,   6.825246427400494e-21,
   1.564549323036244e-22,   5.525108771614573e-25,  -2.416368711205976e-03,  -8.974919956304373e-05,  -1.447394238234380e-06,   5.917751694103213e-09,   9.613993262038983e-10,
   2.457650992413631e-11,   1.755595456089714e-13,  -8.761599621181002e-15,  -3.553093285864631e-16,  -5.378273581671785e-18,   4.616004674677240e-20,   4.418669194896581e-21,
   1.011183389887647e-22,   3.524033583224569e-25,  -1.296214572196380e-03,  -4.814355419856169e-05,  -7.763638509216926e-07,   3.176760369142301e-09,   5.157435743176687e-10,
   1.318170733585069e-11,   9.408016328804585e-14,  -4.701774650912481e-15,  -1.905769785891847e-16,  -2.882733617595347e-18,   2.482463993450855e-20,   2.370540680456211e-21,
   5.420127372148349e-23,   1.876016980960112e-25,  -4.823582142680212e-04,  -1.791549425402591e-05,  -2.888988559159734e-07,   1.182460038921861e-09,   1.919253233010850e-10,
   4.905042515293830e-12,   3.499754424416134e-14,  -1.749894571746945e-15,  -7.091626302487871e-17,  -1.072444136685077e-18,   9.246106130450857e-21,   8.821751849991274e-22,
   2.016442728476395e-23,   6.962567286347978e-26,  -5.448613743795376e-05,  -2.023693786375863e-06,  -3.263324179512029e-08,   1.335734511955069e-10,   2.167951310416662e-11,
   5.540585743822008e-13,   3.953025242853323e-15,  -1.976684318959316e-16,  -8.010496353862585e-18,  -1.211355349973639e-19,   1.044566223428323e-21,   9.964912775528664e-23,
   2.277633083957802e-24,   7.861426900625398e-27,  -2.011348155573453e-03,  -1.010552137043571e-04,  -3.238616753268805e-06,  -8.118371526436307e-08,  -1.664523582372851e-09,
  -2.695759736378956e-11,  -2.738324810893699e-13,   1.795758927820595e-15,   1.917021975110442e-16,   6.417141212311514e-18,   1.543585486568433e-19,   2.857602855757429e-21,
   3.517441490267787e-23,  -5.893589912622453e-26,  -1.913612239995881e-03,  -9.614711094867538e-05,  -3.081386580595395e-06,  -7.724292350007077e-08,  -1.583682105466326e-09,
  -2.564521725651031e-11,  -2.603524121430650e-13,   1.715312871049694e-15,   1.825848054209695e-16,   6.109680348008680e-18,   1.469189371569458e-19,   2.718446792990190e-21,
   3.341173553863372e-23,  -5.787908073927611e-26,  -1.727668181301382e-03,  -8.680839648720300e-05,  -2.782196248533467e-06,  -6.974383563412084e-08,  -1.429862995716005e-09,
  -2.314938485551167e-11,  -2.347769004349701e-13,   1.559497743174659e-15,   1.651584605320699e-16,   5.522956126319578e-18,   1.327399964507308e-19,   2.453815954157334e-21,
   3.007983466760799e-23,  -5.513553820785615e-26,  -1.471661928495118e-03,  -7.394904130514758e-05,  -2.370161886869452e-06,  -5.941591301726716e-08,  -1.218053307868917e-09,
  -1.971506969344010e-11,  -1.997016946643249e-13,   1.339605365328214e-15,   1.410100923214374e-16,   4.711718036501472e-18,   1.131702875804298e-19,   2.089704379488103e-21,
   2.553454886187085e-23,  -4.993524165884063e-26,  -1.170612031192282e-03,  -5.882472330230335e-05,  -1.885489922419002e-06,  -4.726671994127884e-08,  -9.689349037380683e-10,
  -1.567894283910301e-11,  -1.586287765290456e-13,   1.074220320924582e-15,   1.124153672799343e-16,   3.753390592751896e-18,   9.009647951881200e-20,   1.661828234520379e-21,
   2.024294669329621e-23,  -4.201568068600394e-26,  -8.539794419189695e-04,  -4.291532267031969e-05,  -1.375599131972551e-06,  -3.448485114953253e-08,  -7.068834565301643e-10,
  -1.143619110290681e-11,  -1.155921044280638e-13,   7.887475762917992e-16,   8.215626382955170e-17,   2.741401027345435e-18,   6.577181364473349e-20,   1.212092420309510e-21,
   1.472741958460365e-23,  -3.200124273163134e-26,  -5.527808546104592e-04,  -2.777984958208400e-05,  -8.904702905939599e-07,  -2.232334830813617e-08,  -4.575786831438618e-10,
  -7.401858567418057e-12,  -7.476710959605998e-14,   5.127333441902497e-16,   5.324286343317078e-17,   1.775896434241734e-18,   4.259332915694301e-20,   7.844849289797475e-22,
   9.515873098551253e-24,  -2.129226881264608e-26,  -2.965340310158317e-04,  -1.490244627576923e-05,  -4.776967221911280e-07,  -1.197550748545397e-08,  -2.454673238039451e-10,
  -3.970439504152626e-12,  -4.009276583808666e-14,   2.756508619252756e-16,   2.857901839117421e-17,   9.530449873100492e-19,   2.285408061464901e-20,   4.208010633309262e-22,
   5.099961319382075e-24,  -1.158129147824652e-26,  -1.103494196959485e-04,  -5.545685152399089e-06,  -1.777672274795556e-07,  -4.456500689238855e-09,  -9.134639466788289e-11,
  -1.477494342013891e-12,  -1.491776230005710e-14,   1.026558677136267e-16,   1.063738309758019e-17,   3.547068144687322e-19,   8.505390695562096e-21,   1.565893069866549e-22,
   1.897238271752694e-24,  -4.330385315327027e-27,  -1.246484350102195e-05,  -6.264296774766722e-07,  -2.008024921578181e-08,  -5.033979873752104e-10,  -1.031830921014044e-11,
  -1.668942178888672e-13,  -1.685044127678148e-15,   1.159718880839395e-17,   1.201617297283790e-18,   4.006783963629645e-20,   9.607637252081918e-22,   1.768793983546782e-23,
   2.142971268542366e-25,  -4.895212482858954e-28,  -5.935663535702783e-04,   2.733564569250357e-05,  -8.301974338970908e-07,   2.068454644606981e-08,  -4.551340749528797e-10,
   9.111237195484363e-12,  -1.683946183941913e-13,   2.867840936728048e-15,  -4.482955785590973e-17,   6.125114701506750e-19,  -6.905831694201276e-21,   4.359459311262528e-23,
   1.313047146116652e-24,  -3.413139930888321e-26,  -5.647198920443091e-04,   2.600788094104949e-05,  -7.898977276163420e-07,   1.968115756991931e-08,  -4.330714420174362e-10,
   8.669857180399706e-12,  -1.602412192286083e-13,   2.729004248989437e-15,  -4.265825106449865e-17,   5.827892141517956e-19,  -6.567331253605644e-21,   4.139323536708852e-23,
   1.251148325753357e-24,  -3.260019059801041e-26,  -5.098405844924517e-04,   2.348157068788075e-05,  -7.132100770207228e-07,   1.777149604488325e-08,  -3.910752631709185e-10,
   7.829574083284236e-12,  -1.447173539385252e-13,   2.464654634868534e-15,  -3.852442877844228e-17,   5.262252817443140e-19,  -5.924515874196927e-21,   3.723847147343152e-23,
   1.132621245178544e-24,  -2.963521731421953e-26,  -4.342861554987579e-04,   2.000294526343762e-05,  -6.075944730906727e-07,   1.514093410458816e-08,  -3.332132106095131e-10,
   6.671610704272056e-12,  -1.233211458444740e-13,   2.100291696552076e-15,  -3.282744165950586e-17,   4.483159668771276e-19,  -5.041798996553484e-21,   3.158328916433093e-23,
   9.679425621360446e-25,  -2.545262957146995e-26,  -3.454418531222966e-04,   1.591173001192187e-05,  -4.833546999832211e-07,   1.204581497450645e-08,  -2.651172202929999e-10,
   5.308553604849259e-12,  -9.813110906919214e-14,   1.671302848517551e-15,  -2.612103714435931e-17,   3.566577915764106e-19,  -4.006697049033099e-21,   2.501605965699679e-23,
   7.723841323703151e-25,  -2.040706202523886e-26,  -2.520023483402992e-04,   1.160825016347445e-05,  -3.526455469075831e-07,   8.788887974678684e-09,  -1.934468307969700e-10,
   3.873681170882949e-12,  -7.160995585120292e-14,   1.219626835105318e-15,  -1.906093960269155e-17,   2.602174071356158e-19,  -2.920752723304105e-21,   1.818681446856494e-23,
   5.649118781289395e-25,  -1.498192848162542e-26,  -1.631199177540053e-04,   7.514190452627034e-06,  -2.282806537615181e-07,   5.689594791578673e-09,  -1.252351286321162e-10,
   2.507865627242467e-12,  -4.636244870331149e-14,   7.896293880016000e-16,  -1.234038619405085e-17,   1.684515394187220e-19,  -1.889663587447666e-21,   1.174539013616382e-23,
   3.662880367447636e-25,  -9.738280214601807e-27,  -8.750380006178990e-05,   4.030962999077112e-06,  -1.224626236579153e-07,   3.052279977078911e-09,  -6.718587802528120e-11,
   1.345439670972868e-12,  -2.487326428400594e-14,   4.236346260215529e-16,  -6.620499884327307e-18,   9.036775189707462e-20,  -1.013433066448081e-21,   6.293269633123448e-24,
   1.966630662702775e-25,  -5.235157265276778e-27,  -3.256280880590300e-05,   1.500051214612220e-06,  -4.557257445239804e-08,   1.135866672206580e-09,  -2.500253531759614e-11,
   5.006948361493110e-13,  -9.256438358157346e-15,   1.576533415277718e-16,  -2.463771242697324e-18,   3.362907203803739e-20,  -3.770960123660972e-22,   2.340955349984266e-24,
   7.320657990439187e-26,  -1.949606802430899e-27,  -3.678227151358951e-06,   1.694428093010089e-07,  -5.147792731966514e-09,   1.283055137630359e-10,  -2.824245845109825e-12,
   5.655773526630850e-14,  -1.045594206090545e-15,   1.780830274948218e-17,  -2.783039649213337e-19,   3.798678991951783e-21,  -4.259538849197845e-23,   2.644122261488675e-25,
   8.269662993409030e-27,  -2.202494578612338e-28,  -4.920192588429239e-03,   1.965348875417877e-04,  -4.544507090117516e-06,   6.585878760769060e-08,  -2.374021293480631e-10,
  -1.959936269159575e-11,   7.169862660615607e-13,  -1.461257570450985e-14,   1.611675416613994e-16,   9.586658536605830e-19,  -1.010925166077927e-19,   2.833775641890850e-21,
  -4.203650209623334e-23,   3.622068137692389e-25,  -4.681007967556993e-03,   1.869812284706105e-04,  -4.323502330745245e-06,   6.264953952287479e-08,  -2.255345615770954e-10,
  -1.865516126923223e-11,   6.822452004888838e-13,  -1.390075722862008e-14,   1.531923815538871e-16,   9.166774129713463e-19,  -9.625760688502450e-20,   2.696752999290031e-21,
  -3.997234022834117e-23,   3.426193123196894e-25,  -4.225996845668795e-03,   1.688067054534002e-04,  -3.903109324596340e-06,   5.654756286614265e-08,  -2.030911882086909e-10,
  -1.685547651244673e-11,   6.161093963743672e-13,  -1.254722113220766e-14,   1.380778161519525e-16,   8.349259961012029e-19,  -8.702757221578759e-20,   2.435783605404428e-21,
  -3.605381502887863e-23,   3.061621785329171e-25,  -3.599621242223078e-03,   1.437869996452685e-04,  -3.324455159680574e-06,   4.815352302964634e-08,  -1.724528364560691e-10,
  -1.437123636714995e-11,   5.249760048074623e-13,  -1.068506566688085e-14,   1.173813686298373e-16,   7.187488015604454e-19,  -7.425863739115936e-20,   2.075943163514323e-21,
  -3.067561847826549e-23,   2.575354225836347e-25,  -2.863137707198062e-03,   1.143687228411582e-04,  -2.644164948709487e-06,   3.829157963372087e-08,  -1.367548128613173e-10,
  -1.144174067249069e-11,   4.177092566493813e-13,  -8.497028173370517e-15,   9.318687826251611e-17,   5.775433295706323e-19,  -5.916580049496775e-20,   1.652116034898394e-21,
  -2.437266965166293e-23,   2.023362572285480e-25,  -2.088627349574425e-03,   8.343106363504166e-05,  -1.928826958121731e-06,   2.792757141679513e-08,  -9.951773373924411e-11,
  -8.353006259472490e-12,   3.047985080388704e-13,  -6.197385056611072e-15,   6.787397473721083e-17,   4.247505257464802e-19,  -4.321981850246447e-20,   1.205731961104919e-21,
  -1.776378681062772e-23,   1.461287210952177e-25,  -1.351936075244023e-03,   5.400377942873318e-05,  -1.248473151389841e-06,   1.807463946092598e-08,  -6.431217437315507e-11,
  -5.409500924294522e-12,   1.973273309009866e-13,  -4.010997986757982e-15,   4.388890894982478e-17,   2.764055902274810e-19,  -2.800074855877851e-20,   7.806776528927672e-22,
  -1.149142773082611e-23,   9.395672791972710e-26,  -7.252243444539875e-04,   2.896949846429551e-05,  -6.697159914881006e-07,   9.695175951190009e-09,  -3.447054848871670e-11,
  -2.902591579351791e-12,   1.058629779943713e-13,  -2.151504719446889e-15,   2.353113551486278e-17,   1.486786520584769e-19,  -1.502749929061348e-20,   4.188440227909566e-22,
  -6.162513449541225e-24,   5.022799176504187e-26,  -2.698770975870837e-04,   1.078039921141180e-05,  -2.492198730800679e-07,   3.607770071660710e-09,  -1.282377981876916e-11,
  -1.080236234945952e-12,   3.939597986663883e-14,  -8.006206326686123e-16,   8.755019187336939e-18,   5.538015697080957e-20,  -5.593069954408224e-21,   1.558720838162328e-22,
  -2.293007125979177e-24,   1.866881594325256e-26,  -3.048474123709522e-05,   1.217730991583397e-06,  -2.815132819504836e-08,   4.075244475286944e-10,  -1.448480219733553e-12,
  -1.220229262738970e-13,   4.450108840525074e-15,  -9.043609528939782e-17,   9.889195815339234e-19,   6.256565477519812e-21,  -6.317973799445866e-22,   1.760712187446290e-23,
  -2.590088253927200e-25,   2.108386631716313e-27,  -1.142915113271094e-02,   3.166361344312931e-04,  -1.868989191765763e-06,  -1.132821867535750e-07,   3.553028960690068e-09,
  -2.579952177992098e-11,  -1.204022467612868e-12,   4.116848855389161e-14,  -3.506077589933236e-16,  -1.331500306187008e-17,   4.906416372286854e-19,  -4.605825625539065e-21,
  -1.356171928361804e-22,   6.302698319683234e-24,  -1.087328808463675e-02,   3.012247302067191e-04,  -1.777448469523268e-06,  -1.077796951317575e-07,   3.379670425489018e-09,
  -2.451898929575410e-11,  -1.145746531857053e-12,   3.915173827741383e-14,  -3.328998732462760e-16,  -1.267474903507706e-17,   4.665083740155582e-19,  -4.367276670129837e-21,
  -1.292177962578326e-22,   5.989120030223705e-24,  -9.815951505605934e-03,   2.719146089641715e-04,  -1.603584867580920e-06,  -9.731023810138266e-08,   3.050141401790178e-09,
  -2.209370352764719e-11,  -1.034781257825394e-12,   3.532145318749655e-14,  -2.994838740897302e-16,  -1.145387616672672e-17,   4.207126951434770e-19,  -3.919453835695340e-21,
  -1.169642626497799e-22,   5.395503842608004e-24,  -8.360609475378155e-03,   2.315806610114036e-04,  -1.364780710787314e-06,  -8.289427412819232e-08,   2.597007453267990e-09,
  -1.877579838509263e-11,  -8.818228840053282e-13,   3.006077824128745e-14,  -2.540067414019687e-16,  -9.767631887005120e-18,   3.578912786413556e-19,  -3.314543133590581e-21,
  -9.994240268587195e-23,   4.583983036550701e-24,  -6.649697814995977e-03,   1.841753560915771e-04,  -1.084680526970409e-06,  -6.593972186582754e-08,   2.064853367442565e-09,
  -1.490093799526165e-11,  -7.017223237354267e-13,   2.389075491373443e-14,  -2.011976814710838e-16,  -7.777968075045265e-18,   2.843080953278334e-19,  -2.617907005359315e-21,
  -7.973572289056695e-23,   3.636981170797257e-24,  -4.850688057424570e-03,   1.343398825927708e-04,  -7.907538892358326e-07,  -4.810560649935204e-08,   1.505814240521532e-09,
  -1.085049476637968e-11,  -5.120866291993866e-13,   1.741653016808100e-14,  -1.462786837305787e-16,  -5.679089966944334e-18,   2.071886139528737e-19,  -1.898889870846204e-21,
  -5.830760584679641e-23,   2.647776849038432e-24,  -3.139692527878252e-03,   8.695013103617933e-05,  -5.116252397129760e-07,  -3.113942502268375e-08,   9.744876529429342e-10,
  -7.014987560930729e-12,  -3.315459568119899e-13,   1.126852421672038e-14,  -9.447326080277921e-17,  -3.678182005956963e-18,   1.340196282861934e-19,  -1.224488562425377e-21,
  -3.780181814524648e-23,   1.711571168078810e-24,  -1.684214763557869e-03,   4.664134785409320e-05,  -2.743932179355055e-07,  -1.670463199352210e-08,   5.226924145735238e-10,
  -3.760772053248368e-12,  -1.778745667251427e-13,   6.043461223197338e-15,  -5.062064552145365e-17,  -1.973705150950766e-18,   7.186776688892378e-20,  -6.555815664416062e-22,
  -2.029472779234237e-23,   9.175127849475212e-25,  -6.267424121948472e-04,   1.735639002236309e-05,  -1.021019481513000e-07,  -6.216330340290120e-09,   1.945018410712989e-10,
  -1.399194265154672e-12,  -6.619516382042215e-14,   2.248772105607943e-15,  -1.882990326255465e-17,  -7.345512793518926e-19,   2.674086213215936e-20,  -2.437958191725478e-22,
  -7.554400815911512e-24,   3.413513572683473e-25,  -7.079543308354396e-05,   1.960536960717436e-06,  -1.153307918531633e-08,  -7.021843164189669e-10,   2.197038349915122e-11,
  -1.580446484295450e-13,  -7.477315712389994e-15,   2.540133485562966e-16,  -2.126851040254544e-18,  -8.297474544146043e-20,   3.020532897968645e-21,  -2.753569522663264e-23,
  -8.533673776385529e-25,   3.855685361460106e-26,  -1.643626423241075e-02,   1.581872155729730e-04,   7.975065389911160e-06,  -1.632761093963942e-07,  -3.062180805425314e-09,
   1.230365658930793e-10,   6.194118542036182e-13,  -7.892324369220044e-14,   3.790651154601314e-16,   4.335592402434818e-17,  -6.616497137247148e-19,  -1.994411116273921e-20,
   6.212523265579471e-22,   7.326680507130364e-24,  -1.563656262592547e-02,   1.504784447494675e-04,   7.586610027366410e-06,  -1.552978778339849e-07,  -2.912957907407734e-09,
   1.170029702008253e-10,   5.895940008262760e-13,  -7.503821121414247e-14,   3.597519022693094e-16,   4.121462838407948e-17,  -6.282610125001020e-19,  -1.895708722406128e-20,
   5.898512151065370e-22,   6.966335174270700e-24,  -1.411553584098266e-02,   1.358213861853900e-04,   6.847945825887258e-06,  -1.401372056593471e-07,  -2.629231652277776e-09,
   1.055463679030783e-10,   5.327498503675795e-13,  -6.766725797795238e-14,   3.233739994466877e-16,   3.715486925568895e-17,  -5.652452409036835e-19,  -1.708655254743783e-20,
   5.306070208611609e-22,   6.282512773733056e-24,  -1.202220831171396e-02,   1.156591011908018e-04,   5.831691774392300e-06,  -1.192990575854389e-07,  -2.238934405461773e-09,
   8.981640591928171e-11,   4.542648992142972e-13,  -5.755845028998500e-14,   2.739960858631364e-16,   3.159269924801369e-17,  -4.794648229208266e-19,  -1.452534151520391e-20,
   4.500000399930615e-22,   5.344424401802073e-24,  -9.561589941325723e-03,   9.197137059659693e-05,   4.637557730305507e-06,  -9.483868108450362e-08,  -1.780389290757354e-09,
   7.137365537822680e-11,   3.616907982765747e-13,  -4.572089058587049e-14,   2.168214898170840e-16,   2.508633734285701e-17,  -3.798259202265834e-19,  -1.153134938342822e-20,
   3.564202335927943e-22,   4.245605288531517e-24,  -6.974562447831387e-03,   6.707809066410433e-05,   3.382478268470989e-06,  -6.915337202305999e-08,  -1.298504799615926e-09,
   5.202736762633326e-11,   2.640654191816098e-13,  -3.331702189602704e-14,   1.575151531645124e-16,   1.827526509798096e-17,  -2.761757666707794e-19,  -8.399012463795889e-21,
   2.591196544050046e-22,   3.093967233610756e-24,  -4.514307143727387e-03,   4.341261684941210e-05,   2.189182405701144e-06,  -4.474890773976691e-08,  -8.403866967331399e-10,
   3.365986786582797e-11,   1.710176165313375e-13,  -2.155026300720580e-14,   1.016779704292024e-16,   1.181863641925412e-17,  -1.783787101561804e-19,  -5.431001947988630e-21,
   1.673463167181637e-22,   2.001323812634688e-24,  -2.421567094808486e-03,   2.328634942215034e-05,   1.174284642562198e-06,  -2.400125158109323e-08,  -4.507801437667653e-10,
   1.805171177156024e-11,   9.176500389188687e-14,  -1.155607076529560e-14,   5.446668770521313e-17,   6.336982248352348e-18,  -9.558227749394873e-20,  -2.911845552595671e-21,
   8.966627149550350e-23,   1.073204545140613e-24,  -9.011278232960971e-04,   8.665315029106057e-06,   4.369768313892650e-07,  -8.931101052558179e-09,  -1.677443031105679e-10,
   6.716974180795606e-12,   3.415171241979360e-14,  -4.299803853277646e-15,   2.025869485953239e-17,   2.357795564955465e-18,  -3.555521174361987e-20,  -1.083384642107983e-21,
   3.335397161929405e-23,   3.993222635009887e-25,  -1.017893366206528e-04,   9.788116701351793e-07,   4.935981512035138e-08,  -1.008829813347256e-09,  -1.894796487489486e-11,
   7.587244377326233e-13,   3.857763404237184e-15,  -4.856868737141021e-16,   2.288200703622385e-18,   2.663247451342307e-19,  -4.015994670619675e-21,  -1.223732712174626e-22,
   3.767352266392783e-24,   4.510572328150374e-26,  -1.629746404045062e-02,  -2.099002551507878e-04,   7.971513754944479e-06,   2.008031333870483e-07,  -3.183035294940378e-09,
  -1.538296785995335e-10,   6.860243066803396e-13,   1.040774615230851e-13,   4.325166314223332e-16,  -6.462192470092401e-17,  -8.523308915209350e-19,   3.517456724201708e-20,
   8.896219229090980e-22,  -1.423971232258552e-23,  -1.550451385835329e-02,  -1.996728155192218e-04,   7.583209660196270e-06,   1.909904682154650e-07,  -3.027904124513494e-09,
  -1.462826976052835e-10,   6.530094636963437e-13,   9.894632912484200e-14,   4.103526452896872e-16,  -6.142149283927407e-17,  -8.091480770984364e-19,   3.343075682052486e-20,
   8.445133865721741e-22,  -1.353880567718277e-23,  -1.399632899080869e-02,  -1.802263185713665e-04,   6.844841927055418e-06,   1.723442037722667e-07,  -2.732951782134222e-09,
  -1.319538246688170e-10,   5.900664886767003e-13,   8.921437142217336e-14,   3.686551730297128e-16,  -5.535723299876028e-17,  -7.277156371249356e-19,   3.012723446982910e-20,
   7.594641766197101e-22,  -1.220893494630679e-23,  -1.192067673712669e-02,  -1.534745621398432e-04,   5.829012868022142e-06,   1.467157324440330e-07,  -2.327226666999094e-09,
  -1.122828323993280e-10,   5.031530160625231e-13,   7.587375784373100e-14,   3.121541202205749e-16,  -4.705564461707965e-17,  -6.169977976560310e-19,   2.560628568631337e-20,
   6.438571124102837e-22,  -1.038502031320500e-23,  -9.480836762163254e-03,  -1.220437646006715e-04,   4.635399864517146e-06,   1.166330765922209e-07,  -1.850574812989294e-09,
  -8.922267836979461e-11,   4.006277204298344e-13,   6.025950858984039e-14,   2.468557635429327e-16,  -3.735358492602016e-17,  -4.885607543653757e-19,   2.032441389782617e-20,
   5.097838368726902e-22,  -8.249153223912455e-24,  -6.915656837381347e-03,  -8.901203764132487e-05,   3.380888230769213e-06,   8.504461399047408e-08,  -1.349679598764652e-09,
  -6.503584282573098e-11,   2.924994546052361e-13,   4.390554700944777e-14,   1.792393806540897e-16,  -2.720532115624337e-17,  -3.551105928382177e-19,   1.480129245143444e-20,
   3.705102955838631e-22,  -6.011129600436359e-24,  -4.476179714623815e-03,  -5.760860984738399e-05,   2.188146401025842e-06,   5.503184338210327e-08,  -8.735007537762337e-10,
  -4.207484247218351e-11,   1.894352916352113e-13,   2.839668674609779e-14,   1.156606054067746e-16,  -1.759090469646230e-17,  -2.293072501901085e-19,   9.569899177498530e-21,
   2.392401784848134e-22,  -3.888108821505493e-24,  -2.401114595951461e-03,  -3.090114526800456e-05,   1.173727022142196e-06,   2.951648042473085e-08,  -4.685407267583769e-10,
  -2.256435500161006e-11,   1.016483762271674e-13,   1.522669713627543e-14,   6.194568325913617e-17,  -9.431214993945570e-18,  -1.228567477781286e-19,   5.130658564796152e-21,
   1.281754720635697e-22,  -2.084940412865241e-24,  -8.935168977900706e-04,  -1.149894842341991e-05,   4.367690820953770e-07,   1.098336351188409e-08,  -1.743531550127036e-10,
  -8.396074387794396e-12,   3.783005674611129e-14,   5.665488295660522e-15,   2.303902990206992e-17,  -3.508963811576229e-18,  -4.569896931002264e-20,   1.908884160778475e-21,
   4.767697490529245e-23,  -7.757668630306755e-25,  -1.009296235162385e-04,  -1.298891887688539e-06,   4.933634385666548e-08,   1.240646945129659e-09,  -1.969447990772107e-11,
  -9.483886859132610e-13,   4.273269461556648e-15,   6.399469697831290e-16,   2.602210935040138e-18,  -3.963531309220748e-19,  -5.161706739125692e-21,   2.156166124838374e-22,
   5.385115694009284e-24,  -8.762717393729811e-26,  -1.018316500708764e-02,  -3.668339422750232e-04,  -4.623634259896931e-06,   9.202376858558728e-08,   5.347848917965461e-09,
   8.936910977884358e-11,  -9.064582603557892e-13,  -8.164310392233810e-14,  -1.677349111667479e-15,   5.758665796257249e-18,   1.225300978367242e-18,   2.977934588353838e-20,
   3.600010495184592e-23,  -1.726955109016904e-23,  -9.687988558016758e-03,  -3.489827599511127e-04,  -4.397786219492064e-06,   8.757411474726723e-08,   5.087318239910800e-09,
   8.497122549949698e-11,  -8.637547286672968e-13,  -7.766546125485675e-14,  -1.594122591982546e-15,   5.526871160791540e-18,   1.165758757773408e-18,   2.829076317392414e-20,
   3.300789993959562e-23,  -1.643396069166043e-23,  -8.746051642593818e-03,  -3.150311467567340e-04,  -3.968585141864738e-06,   7.909961388565822e-08,   4.591925044921439e-09,
   7.662666321232818e-11,  -7.819621907116133e-13,  -7.010210380547597e-14,  -1.436482705442994e-15,   5.066245547279930e-18,   1.052476264932962e-18,   2.547559794852315e-20,
   2.782385585891049e-23,  -1.484267232552315e-23,  -7.449479443081313e-03,  -2.683072653029857e-04,  -3.378591627337932e-06,   6.741462893269958e-08,   3.910396740847705e-09,
   6.518150964815898e-11,  -6.682896292931005e-13,  -5.969708573149865e-14,  -1.220802141732958e-15,   4.394090673724668e-18,   8.965082947498940e-19,   2.163244896474158e-20,
   2.166962958355599e-23,  -1.264887418199213e-23,  -5.925131685857737e-03,  -2.133882882872682e-04,  -2.685963319804119e-06,   5.365176128450136e-08,   3.109621002400285e-09,
   5.177774411591317e-11,  -5.332764625271651e-13,  -4.747175477302186e-14,  -9.688903024258769e-16,   3.555757743100389e-18,   7.131012767473113e-19,   1.715457159411514e-20,
   1.567222272821045e-23,  -1.006554723956642e-23,  -4.322211104522084e-03,  -1.556507461852989e-04,  -1.958577109777461e-06,   3.915609089346922e-08,   2.268017954263891e-09,
   3.773156859912745e-11,  -3.900282321538147e-13,  -3.462344189090984e-14,  -7.055399775830315e-16,   2.629495471548512e-18,   5.202084595188866e-19,   1.248358231439277e-20,
   1.051572803293497e-23,  -7.345360693817708e-24,  -2.797654391102928e-03,  -1.007444724704526e-04,  -1.267412961153827e-06,   2.535270576582290e-08,   1.467874642654273e-09,
   2.440607087936285e-11,  -2.528903461512608e-13,  -2.240834591347511e-14,  -4.561484113229038e-16,   1.717242790372215e-18,   3.367260218488459e-19,   8.067387393239837e-21,
   6.415095568378551e-24,  -4.755651632927978e-24,  -1.500744046587743e-03,  -5.404114152983980e-05,  -6.797886287736296e-07,   1.360213707342909e-08,   7.873686087387557e-10,
   1.308756433110795e-11,  -1.357776542717513e-13,  -1.201980325934445e-14,  -2.445456330843809e-16,   9.253744594403081e-19,   1.806320127059298e-19,   4.324027064535101e-21,
   3.333508192835118e-24,  -2.551395906423620e-24,  -5.584689283416389e-04,  -2.011007407687145e-05,  -2.529568855608870e-07,   5.062021469958803e-09,   2.929964251009163e-10,
   4.869657727479056e-12,  -5.054218926735197e-14,  -4.472815944512597e-15,  -9.098340311105267e-17,   3.449009318722542e-19,   6.721852375673632e-20,   1.608630994602497e-21,
   1.226543478791202e-24,  -9.494877633462735e-25,  -6.308342951966680e-05,  -2.271587333018473e-06,  -2.857325044094169e-08,   5.717999892126623e-10,   3.309613709203990e-11,
   5.500552851209591e-13,  -5.709413368596341e-15,  -5.052379028850466e-16,  -1.027694789921200e-17,   3.896899041426922e-20,   7.592862660396697e-21,   1.816991833836258e-22,
   1.382976808860755e-25,  -1.072528110613846e-25,  -2.474252786744875e-03,  -1.313568654795751e-04,  -4.391480641755511e-06,  -1.124536149498770e-07,  -2.260657876232895e-09,
  -3.197032808774461e-11,  -9.288025872450842e-14,   1.309184648119610e-14,   5.682770399118946e-16,   1.553738268004220e-17,   3.090323267722957e-19,   3.772956119652496e-21,
  -1.794924172218640e-23,  -2.537377528540786e-24,  -2.354035468324126e-03,  -1.249776721704980e-04,  -4.178280927166289e-06,  -1.069933133816875e-07,  -2.150738329545633e-09,
  -3.040702858279126e-11,  -8.788711086291597e-14,   1.247172603048268e-14,   5.410489837513426e-16,   1.478775137568909e-17,   2.939632575858906e-19,   3.583487220212951e-21,
  -1.729239384516516e-23,  -2.418885387419929e-24,  -2.125315250287006e-03,  -1.128396426649027e-04,  -3.772587040083248e-06,  -9.660334632801461e-08,  -1.941642537159111e-09,
  -2.743679581007279e-11,  -7.858233485062151e-14,   1.128541990111315e-14,   4.890901571917440e-16,   1.335937006354864e-17,   2.653148903361128e-19,   3.225498856637370e-21,
  -1.595541138348643e-23,  -2.191500295541818e-24,  -1.810405535109940e-03,  -9.612516090829880e-05,  -3.213879446670304e-06,  -8.229530980639370e-08,  -1.653815379449657e-09,
  -2.335511058563549e-11,  -6.614961906209810e-14,   9.639480041811664e-15,   4.172493235738979e-16,   1.138854201266469e-17,   2.259128882204245e-19,   2.737444802274694e-21,
  -1.394510529189271e-23,  -1.874651598032414e-24,  -1.440076113679156e-03,  -7.646608456445107e-05,  -2.556676875917875e-06,  -6.546574813567756e-08,  -1.315414846282275e-09,
  -1.856503889447125e-11,  -5.200852801597247e-14,   7.687927019330461e-15,   3.323832275641973e-16,   9.065601037129646e-18,   1.796307792333707e-19,   2.169644634823757e-21,
  -1.136606129618101e-23,  -1.497257627622906e-24,  -1.050566685655783e-03,  -5.578595953480481e-05,  -1.865277971769755e-06,  -4.776128749629294e-08,  -9.595631255936180e-10,
  -1.353616003635136e-11,  -3.758275234634666e-14,   5.620419526975959e-15,   2.427655503068855e-16,   6.617453286009414e-18,   1.310028824936475e-19,   1.578186527652214e-21,
  -8.452680321214632e-24,  -1.095854447393036e-24,  -6.800356437066776e-04,  -3.611143695477258e-05,  -1.207455480545953e-06,  -3.091716978299453e-08,  -6.211027854434484e-10,
  -8.758822018306815e-12,  -2.417400018640856e-14,   3.643213436489234e-15,   1.572648044880044e-16,   4.285167237866452e-18,   8.478070858837512e-20,   1.019588539058861e-21,
  -5.540316876301383e-24,  -7.108789845742610e-25,  -3.647997195669780e-04,  -1.937196405686358e-05,  -6.477448456849726e-07,  -1.658557697905590e-08,  -3.331785048755709e-10,
  -4.697723020765465e-12,  -1.292566405772894e-14,   1.955776798934747e-15,   8.439699824026035e-17,   2.299202283987511e-18,   4.547497761186739e-20,   5.464049564799903e-22,
  -2.991038772008562e-24,  -3.817664942792666e-25,  -1.357533171510536e-04,  -7.208945133043381e-06,  -2.410479307164167e-07,  -6.172048564734386e-09,  -1.239851532763732e-10,
  -1.748055108112109e-12,  -4.804563663853273e-15,   7.279871978615395e-16,   3.141109119166580e-17,   8.556639895393356e-19,   1.692200937605927e-20,   2.032636250216992e-22,
  -1.115517320176600e-24,  -1.421217281224884e-25,  -1.533441798945384e-05,  -8.143083757841353e-07,  -2.722831760043997e-08,  -6.971827370503643e-10,  -1.400509357031491e-11,
  -1.974547040207496e-13,  -5.426155255532956e-16,   8.223520958914399e-17,   3.548210702177088e-18,   9.665512356691208e-20,   1.911464143249980e-21,   2.295897826769920e-23,
  -1.260506388996703e-25,  -1.605475846856952e-26,  -4.960930617153338e-04,   2.157567497606993e-05,  -6.203055191580720e-07,   1.466524109886732e-08,  -3.075776832058780e-10,
   5.889835741952172e-12,  -1.052177133788271e-13,   1.737419467219098e-15,  -2.716142398718327e-17,   3.876413491536771e-19,  -4.144968589153839e-21,   6.992123582005531e-23,
  -2.338679078972981e-25,  -3.343179380632384e-26,  -4.719814542772603e-04,   2.052753839336475e-05,  -5.901886347190828e-07,   1.395367332393042e-08,  -2.926640117283124e-10,
   5.604438868953336e-12,  -1.001225310917451e-13,   1.653326475569891e-15,  -2.584583249727196e-17,   3.688999378639841e-19,  -3.943819878679535e-21,   6.644306064074490e-23,
  -2.229510986885797e-25,  -3.178028379251700e-26,  -4.261109253546732e-04,   1.853333135969456e-05,  -5.328805813882708e-07,   1.259947837178246e-08,  -2.642774305048441e-10,
   5.061140442099326e-12,  -9.042172214230593e-14,   1.493203323461739e-15,  -2.334117422721290e-17,   3.332053115108920e-19,  -3.561024938377030e-21,   5.985862942768334e-23,
  -2.019923551476693e-25,  -2.864941860286592e-26,  -3.629609636265400e-04,   1.578750761190926e-05,  -4.539594953702116e-07,   1.073420676766048e-08,  -2.251696206800884e-10,
   4.312498272900805e-12,  -7.705186670162155e-14,   1.272485299008203e-15,  -1.988943558168677e-17,   2.839861873064049e-19,  -3.033788432356510e-21,   5.085683982904375e-23,
  -1.727766853382610e-25,  -2.436032243310264e-26,  -2.887052515807880e-04,   1.255828986838598e-05,  -3.611273401001557e-07,   8.539698102973812e-09,  -1.791487311889072e-10,
   3.431332396270505e-12,  -6.131206850230849e-14,   1.012600965485160e-15,  -1.582613714477715e-17,   2.260123654621912e-19,  -2.413521532491258e-21,   4.035157794516272e-23,
  -1.379762958873601e-25,  -1.934345009844892e-26,  -2.106109411828294e-04,   9.161669158910863e-06,  -2.634666713881641e-07,   6.230622400872696e-09,  -1.307157521103888e-10,
   2.503808296232315e-12,  -4.474119224186562e-14,   7.389554613733844e-16,  -1.154856889642484e-17,   1.649497055839058e-19,  -1.760900757892736e-21,   2.937735691573939e-23,
  -1.009706018465111e-25,  -1.409170622232123e-26,  -1.363267546071257e-04,   5.930435285377044e-06,  -1.705499783348834e-07,   4.033415926802165e-09,  -8.462256831526016e-11,
   1.620971086072434e-12,  -2.896657415585088e-14,   4.784317227054426e-16,  -7.476739250574791e-18,   1.068019306947141e-19,  -1.139916639229605e-21,   1.899042955255095e-23,
  -6.549141843289366e-26,  -9.113198315852409e-27,  -7.313072285046644e-05,   3.181349630978258e-06,  -9.149212124296833e-08,   2.163779711924970e-09,  -4.539780060682721e-11,
   8.696250732317865e-13,  -1.554038661487222e-14,   2.566793194034558e-16,  -4.011197856151401e-18,   5.730113605856853e-20,  -6.115210704057617e-22,   1.018020465217279e-23,
  -3.516868405197267e-26,  -4.886390903616103e-27,  -2.721412727205036e-05,   1.183881012379505e-06,  -3.404731405851218e-08,   8.052208121323501e-10,  -1.689428221102492e-11,
   3.236233351861078e-13,  -5.783255032801069e-15,   9.552203628430526e-17,  -1.492738118164587e-18,   2.132458148026686e-20,  -2.275688336292421e-22,   3.787456349152213e-24,
  -1.309205207811469e-26,  -1.818078883527242e-27,  -3.074050761163611e-06,   1.337288201609412e-07,  -3.845919699186103e-09,   9.095630074700422e-11,  -1.908349941169386e-12,
   3.655599018061764e-14,  -6.532681780167378e-16,   1.079004049963353e-17,  -1.686174919633111e-19,   2.408800026806675e-21,  -2.570576233923879e-23,   4.278069612545090e-25,
  -1.478935530003041e-27,  -2.053611255971060e-28,  -4.201883462307277e-03,   1.632511151595754e-04,  -3.787253713216889e-06,   5.973095698220671e-08,  -4.873907422315365e-10,
  -6.709324420672154e-12,   3.809117696178713e-13,  -9.472202689918589e-15,   1.480581144998720e-16,  -1.114481609661951e-18,  -1.389823969718135e-20,   1.266591608668850e-21,
  -2.547303456517055e-23,   1.453425701061919e-25,  -3.997615187374717e-03,   1.553158506018931e-04,  -3.603126967444405e-06,   5.682361064150722e-08,  -4.635135569508261e-10,
  -6.388899979748314e-12,   3.625072354989565e-13,  -9.012650159121353e-15,   1.408375149203091e-16,  -1.058198522391349e-18,  -1.327242714314423e-20,   1.205324557480686e-21,
  -2.425381439675239e-23,   1.385211533097857e-25,  -3.609028027476343e-03,   1.402199164945823e-04,  -3.252861875093339e-06,   5.129432496239827e-08,  -4.181656089052825e-10,
  -5.777011609399497e-12,   3.274496593027631e-13,  -8.138047206041187e-15,   1.271107489570427e-16,  -9.519840553449987e-19,  -1.206170974074336e-20,   1.088650133556001e-21,
  -2.192657693971022e-23,   1.254426492648370e-25,  -3.074094855973641e-03,   1.194379501513219e-04,  -2.770695106976549e-06,   4.368550008510575e-08,  -3.558836795209635e-10,
  -4.930155638605901e-12,   2.790999805635325e-13,  -6.933327789119409e-15,   1.082323634212458e-16,  -8.074263639483525e-19,  -1.035578793842041e-20,   9.277940598992015e-22,
  -1.870771571445524e-23,   1.072436667945458e-25,  -2.445130740122179e-03,   9.500197260478011e-05,  -2.203787769075889e-06,   3.474279886300129e-08,  -2.828368401689586e-10,
  -3.928711086264199e-12,   2.221386814790437e-13,  -5.515920349350672e-15,   8.605847738225305e-17,  -6.395582770670902e-19,  -8.300256375468930e-21,   7.383565833878239e-22,
  -1.490399651252275e-23,   8.560274303729913e-26,  -1.783693867786674e-03,   6.930351360011895e-05,  -1.607625701623544e-06,   2.534176287827247e-08,  -2.061894297993293e-10,
  -2.870221939328488e-12,   1.621315153354072e-13,  -4.024478793367012e-15,   6.276130767971916e-17,  -4.649822354314014e-19,  -6.092153906790580e-21,   5.388523036394595e-22,
  -1.088627467908510e-23,   6.262160404623893e-26,  -1.154556503090088e-03,   4.485935554679601e-05,  -1.040585540515208e-06,   1.640216382634298e-08,  -1.334046442038922e-10,
  -1.859676764778320e-12,   1.049810489859407e-13,  -2.605271080344282e-15,   4.061695955558678e-17,  -3.003048277304443e-19,  -3.959280591624905e-21,   3.488889659226564e-22,
  -7.052473645633592e-24,   4.060847392202551e-26,  -6.193430132584288e-04,   2.406415256280295e-05,  -5.582038093824000e-07,   8.798355446264352e-09,  -7.154663578097379e-11,
  -9.980968837068665e-13,   5.632526447701020e-14,  -1.397635076060523e-15,   2.178625568368052e-17,  -1.609088349016499e-19,  -2.128280662570200e-21,   1.871829543795489e-22,
  -3.784823723729980e-24,   2.180419476677545e-26,  -2.304755402122275e-04,   8.954981440721569e-06,  -2.077236915388628e-07,   3.274082655773757e-09,  -2.662249630263945e-11,
  -3.714860947263077e-13,   2.096154955106616e-14,  -5.201109824160342e-16,   8.107033377485234e-18,  -5.985491917018768e-20,  -7.925636912671053e-22,   6.965973774714174e-23,
  -1.408655057792762e-24,   8.116617239072350e-27,  -2.603402481778813e-05,   1.011535771052045e-06,  -2.346402146967568e-08,   3.698326464190601e-10,  -3.007182920878381e-12,
  -4.196344512806683e-14,   2.367794836685693e-15,  -5.875081112854046e-17,   9.157484130810451e-19,  -6.760654786481711e-21,  -8.953649426240089e-23,   7.868678291982165e-24,
  -1.591224681980360e-25,   9.168830885407953e-28,  -1.019981781305501e-02,   2.971655213305488e-04,  -2.908392023073534e-06,  -6.176700813929989e-08,   2.833468713790739e-09,
  -4.245003989072227e-11,  -2.561082851891354e-13,   2.559848809572138e-14,  -5.355403787590013e-16,   1.319329763787130e-18,   2.366754885828541e-19,  -5.442136269325602e-21,
   5.226910130243735e-23,   8.756561180939048e-25,  -9.703781032294171e-03,   2.827057592021488e-04,  -2.766421726497104e-06,  -5.877521165823957e-08,   2.695531949916913e-09,
  -4.036926775512400e-11,  -2.440950789128242e-13,   2.435472019607732e-14,  -5.091740696250827e-16,   1.246278564965676e-18,   2.252635793227913e-19,  -5.175342743171613e-21,
   4.950261890783554e-23,   8.371684631681816e-25,  -8.760228145047179e-03,   2.552039045952071e-04,  -2.496583520097003e-06,  -5.307936048420039e-08,   2.433207471297402e-09,
  -3.641790115770730e-11,  -2.210637793085310e-13,   2.198837077954289e-14,  -4.591512118666479e-16,   1.110940386945689e-18,   2.035155586703658e-19,  -4.668706139793691e-21,
   4.433188127780702e-23,   7.622763540685695e-25,  -7.461471435358294e-03,   2.173552081941991e-04,  -2.125581213867177e-06,  -4.522978059192025e-08,   2.072239885914696e-09,
  -3.099191039815167e-11,  -1.890136701882946e-13,   1.873029292549385e-14,  -3.905506529168672e-16,   9.316649447412789e-19,   1.735025361226242e-19,  -3.973012273500108e-21,
   3.739190296219521e-23,   6.559462579888950e-25,  -5.934605841845767e-03,   1.728669176459570e-04,  -1.689945794373159e-06,  -3.598950647253338e-08,   1.648012759494380e-09,
  -2.462922652564006e-11,  -1.508936796430938e-13,   1.489884884053529e-14,  -3.102226146767750e-16,   7.297702250912926e-19,   1.381204669615053e-19,  -3.157260360916330e-21,
   2.945693431663576e-23,   5.268576780727068e-25,  -4.329084642340943e-03,   1.260943104287947e-04,  -1.232361465933469e-06,  -2.626202414840492e-08,   1.202062241808729e-09,
  -1.795397943622958e-11,  -1.103995508873450e-13,   1.086899528695106e-14,  -2.260563225667980e-16,   5.257366937215027e-19,   1.008254863259311e-19,  -2.301490486108742e-21,
   2.132150779792171e-23,   3.873342710111280e-25,  -2.802087382371714e-03,   8.161452895762210e-05,  -7.975022767871751e-07,  -1.700245356010886e-08,   7.780142231770924e-10,
  -1.161587085997572e-11,  -7.159852941623718e-14,   7.035521619646680e-15,  -1.462167988573750e-16,   3.374698160533139e-19,   6.529178937187619e-20,  -1.488991095879975e-21,
   1.372972699287530e-23,   2.519942076242000e-25,  -1.503117607041805e-03,   4.377959868839713e-05,  -4.277559726134327e-07,  -9.121643444417567e-09,   4.173361135197988e-10,
  -6.229642425309808e-12,  -3.844605022005342e-14,   3.774144113884972e-15,  -7.840645550974296e-17,   1.802504467888228e-19,   3.503270243206088e-20,  -7.985443344076161e-22,
   7.345446395653388e-24,   1.355299646607695e-25,  -5.593516234506301e-04,   1.629150793339535e-05,  -1.591738114642571e-07,  -3.394552305900678e-09,   1.553007066182747e-10,
  -2.318036491547932e-12,  -1.431183813703403e-14,   1.404475613199208e-15,  -2.917354397653242e-17,   6.697544966815829e-20,   1.303772023075826e-20,  -2.971355458765722e-22,
   2.730910808236115e-24,   5.048017117361440e-26,  -6.318312655433027e-05,   1.840251193201219e-06,  -1.797981512627002e-08,  -3.834435945545858e-10,   1.754239683538677e-11,
  -2.618369642725867e-13,  -1.616723308745233e-15,   1.586466888651594e-16,  -3.295313512181797e-18,   7.563593742924844e-21,   1.472731547599941e-21,  -3.356333024013890e-23,
   3.084322677342918e-25,   5.702948299356091e-27,  -1.568925037126634e-02,   2.135062633577749e-04,   5.803645834917633e-06,  -1.924877202682618e-07,  -6.193570742003833e-10,
   1.139821836985823e-10,  -1.229620815864155e-12,  -4.809143381617405e-14,   1.336209368446387e-15,   8.562373031052581e-18,  -8.591122092837926e-19,   9.297194576051181e-21,
   4.261835920634936e-22,  -1.196796837216084e-23,  -1.492594768174975e-02,   2.031041453588351e-04,   5.521242775719424e-06,  -1.830912595053149e-07,  -5.897754568523085e-10,
   1.084080715695844e-10,  -1.168705880411415e-12,  -4.574298407107027e-14,   1.270073127817183e-15,   8.160836431315136e-18,  -8.164929997934754e-19,   8.817566168596434e-21,
   4.050469585720508e-22,  -1.136055342178128e-23,  -1.347412975498713e-02,   1.833250967227832e-04,   4.984125548350204e-06,  -1.652318770367514e-07,  -5.332860426323679e-10,
   9.781767403814335e-11,  -1.053289539719684e-12,  -4.127971159857287e-14,   1.144740457505405e-15,   7.390934311450553e-18,  -7.357655980937760e-19,   7.916480220423207e-21,
   3.650082064571149e-22,  -1.021552966970105e-23,  -1.147600965921381e-02,   1.561150541197237e-04,   4.244935095617836e-06,  -1.406771903033200e-07,  -4.551055803506290e-10,
   8.326487742141012e-11,  -8.953052629518867e-13,  -3.514382582285831e-14,   9.731367421346228e-16,   6.319422069711205e-18,  -6.253103691858868e-19,   6.697920024886552e-21,
   3.102203960067744e-22,  -8.659535714760002e-24,  -9.127250579153718e-03,   1.241447919406006e-04,   3.376076190273600e-06,  -1.118451359537485e-07,  -3.626563087077350e-10,
   6.618694693350196e-11,  -7.106863753694634e-13,  -2.793991083500517e-14,   7.725438925987727e-16,   5.044897791572066e-18,  -4.962918733734219e-19,   5.292737253455014e-21,
   2.462193914379585e-22,  -6.855563459063697e-24,  -6.657779475942298e-03,   9.054517177392419e-05,   2.462608106206818e-06,  -8.156073627180082e-08,  -2.649443704043208e-10,
   4.825802414777428e-11,  -5.175930303493481e-13,  -2.037392290290337e-14,   5.626883916362153e-16,   3.690988664903418e-18,  -3.614056394060841e-19,   3.840603670890588e-21,
   1.793030827945339e-22,  -4.982163885778260e-24,  -4.309285295293355e-03,   5.860117932379662e-05,   1.593921510479213e-06,  -5.278057498537310e-08,  -1.716612941766409e-10,
   3.122614111539407e-11,  -3.346688811157913e-13,  -1.318432676157724e-14,   3.638460446452002e-16,   2.393722666345641e-18,  -2.336614194928752e-19,   2.477258993991979e-21,
   1.159270159635170e-22,  -3.216810656234091e-24,  -2.311593821506983e-03,   3.143364700406685e-05,   8.550097014646563e-07,  -2.830986773846163e-08,  -9.213089538657999e-11,
   1.674786053122593e-11,  -1.794283168174375e-13,  -7.071583245056310e-15,   1.950765379904771e-16,   1.285339939864126e-18,  -1.252693343634014e-19,   1.326490630088085e-21,
   6.215052414164870e-23,  -1.723386439449415e-24,  -8.602045238190997e-04,   1.169711479399088e-05,   3.181709210800393e-07,  -1.053448298573396e-08,  -3.429054016680555e-11,
   6.231990994335178e-12,  -6.675762783363302e-14,  -2.631420702358095e-15,   7.258034688330297e-17,   4.784762667515286e-19,  -4.660671075861799e-20,   4.933157389286052e-22,
   2.312327228444540e-23,  -6.410349005570602e-25,  -9.716674518195656e-05,   1.321276463056950e-06,   3.593985317743279e-08,  -1.189944781583353e-09,  -3.873492932485634e-12,
   7.039456757602160e-13,  -7.540568483651404e-15,  -2.972374937095127e-16,   8.198282526600047e-18,   5.405059463385191e-20,  -5.264421546794580e-21,   5.571833675123388e-23,
   2.611870411952625e-24,  -7.240478442267036e-26,  -1.699577702580011e-02,  -1.375784569371714e-04,   9.979661674998100e-06,   1.271461872230798e-07,  -5.860554484465021e-09,
  -1.031291300356544e-10,   3.417923980081884e-12,   7.774676426288478e-14,  -2.047804408924007e-15,  -5.913671557427616e-17,   1.218419550654126e-18,   4.691827035349180e-20,
  -5.793321591583974e-22,  -3.388170373858488e-23,  -1.616880166788559e-02,  -1.308753139727211e-04,   9.493205949656469e-06,   1.209312429452384e-07,  -5.573977452513719e-09,
  -9.806465109956901e-11,   3.249979635292604e-12,   7.390236495440547e-14,  -1.946577696074398e-15,  -5.618431118972207e-17,   1.158024083576740e-18,   4.455848090721435e-20,
  -5.506498721641062e-22,  -3.216731157592898e-23,  -1.459592107022439e-02,  -1.181297674194689e-04,   8.568335938899345e-06,   1.091221376134561e-07,  -5.029493464246214e-09,
  -8.845110235825900e-11,   2.931221460195522e-12,   6.661550813778310e-14,  -1.754693920778822e-15,  -5.059955926861675e-17,   1.043606194416552e-18,   4.010167506083189e-20,
  -4.962978088537676e-22,  -2.893354125830696e-23,  -1.243126929942933e-02,  -1.005959217616050e-04,   7.296182862740792e-06,   9.289236298810360e-08,  -4.281272627253556e-09,
  -7.525725919141358e-11,   2.493826350635467e-12,   5.663558554495515e-14,  -1.491867898340383e-15,  -4.297284895885324e-17,   8.870162105976180e-19,   3.402881965441992e-20,
  -4.218855930447093e-22,  -2.453515607134786e-23,  -9.886862974165174e-03,  -7.999490367810101e-05,   5.801716349219096e-06,   7.384355249584042e-08,  -3.403200114051342e-09,
  -5.979508022779872e-11,   1.981328394148885e-12,   4.496607196756211e-14,  -1.184513754725453e-15,  -3.408285605190556e-17,   7.040617022603641e-19,   2.696717174727672e-20,
  -3.349108937422417e-22,  -1.943069579286916e-23,  -7.211790335825474e-03,  -5.834419954322669e-05,   4.231309659175006e-06,   5.384279805595357e-08,  -2.481350142300910e-09,
  -4.358197149075762e-11,   1.444030164359751e-12,   3.275422450502134e-14,  -8.628467519177688e-16,  -2.480574760141062e-17,   5.127418933650009e-19,   1.961401383611204e-20,
  -2.439280572370930e-22,  -1.412492791112860e-23,  -4.667837471338928e-03,  -3.776050597364406e-05,   2.738442732769060e-06,   3.484080921723455e-08,  -1.605606434900870e-09,
  -2.819374442352123e-11,   9.341311493290780e-13,   2.118078278567534e-14,  -5.579761455196564e-16,  -1.603189595423263e-17,   3.315209099763842e-19,   1.267098079483092e-20,
  -1.577259319202532e-22,  -9.121698631162483e-24,  -2.503919466182175e-03,  -2.025469643608421e-05,   1.468878288913871e-06,   1.868681722125999e-08,  -8.611549309187129e-10,
  -1.511962239138574e-11,   5.009434404830782e-13,   1.135644141019707e-14,  -2.991710688221704e-16,  -8.593314871184458e-18,   1.777374625518867e-19,   6.790300786072052e-21,
  -8.456411784307142e-23,  -4.887369934040631e-24,  -9.317726968194853e-04,  -7.537191526921565e-06,   5.465974618419910e-07,   6.953523703335312e-09,  -3.204418164153480e-10,
  -5.625874497169194e-12,   1.863954175860862e-13,   4.225331174215743e-15,  -1.113113282685175e-16,  -3.196950389605815e-18,   6.612813002267291e-20,   2.525982782749544e-21,
  -3.146288868913600e-23,  -1.817979495915326e-24,  -1.052509010689062e-04,  -8.513820140655272e-07,   6.174221577074280e-08,   7.854483005199634e-10,  -3.619608325804727e-11,
  -6.354764348186416e-13,   2.105446625077923e-14,   4.772712872428306e-16,  -1.257315074435932e-17,  -3.611050620014522e-19,   7.469456704988476e-21,   2.853137497583638e-22,
  -3.553875356789261e-24,  -2.053415874489022e-25,  -1.171526733098251e-02,  -3.978273809094216e-04,  -2.953174202698849e-06,   1.898262908026676e-07,   6.703412950972569e-09,
   3.470825964286867e-11,  -3.830992219727033e-12,  -1.201086317493968e-13,  -2.969354608173407e-16,   7.733149816921417e-17,   2.141681416040236e-18,  -4.623001041019353e-23,
  -1.435398073883532e-21,  -3.396366733433303e-23,  -1.114551890473047e-02,  -3.784599759083712e-04,  -2.808339265197157e-06,   1.806031666534468e-07,   6.375647428657650e-09,
   3.294544119711962e-11,  -3.644882416571773e-12,  -1.141837487157951e-13,  -2.796501370324603e-16,   7.356924961298233e-17,   2.034697247369109e-18,  -1.217013106292256e-22,
  -1.365189151804969e-21,  -3.223516939400743e-23,  -1.006175797856227e-02,  -3.416278704993876e-04,  -2.533331575072624e-06,   1.630556106511829e-07,   5.752894962342037e-09,
   2.962275271730479e-11,  -3.290783410416650e-12,  -1.029475906720071e-13,  -2.479319503805987e-16,   6.641318531438885e-17,   1.832345324559726e-18,  -2.334216138715281e-22,
  -1.231796420170795e-21,  -2.897854081543489e-23,  -8.570021181132842e-03,  -2.909461832046072e-04,  -2.155755412123426e-06,   1.388954914605358e-07,   4.897096656825699e-09,
   2.510832111542612e-11,  -2.803222833537609e-12,  -8.754756849530159e-14,  -2.065205346586692e-16,   5.656418591711954e-17,   1.556048986741114e-18,  -3.257073715835661e-22,
  -1.048499036196648e-21,  -2.455653540414559e-23,  -6.816293578758965e-03,  -2.313831968627077e-04,  -1.713076643642990e-06,   1.104835117325644e-07,   3.892750725838233e-09,
   1.987568820759389e-11,  -2.229831608526767e-12,  -6.952632062992009e-14,  -1.606725076775250e-16,   4.498686282937657e-17,   1.234048290374425e-18,  -3.567331467085027e-22,
  -8.334116988847969e-22,  -1.943444672305008e-23,  -4.972235296443821e-03,  -1.687707362209484e-04,  -1.248724376107471e-06,   8.060005392210073e-08,   2.838309197033880e-09,
   1.444304595662031e-11,  -1.626723016905653e-12,  -5.065464176763176e-14,  -1.151003493727377e-16,   3.281479798644143e-17,   8.980907749387093e-19,  -3.174664848366930e-22,
  -6.076292525329098e-22,  -1.411978917694872e-23,  -3.218375636079997e-03,  -1.092338035587694e-04,  -8.078753594839420e-07,   5.217267717460564e-08,   1.836590668756062e-09,
   9.324802812123789e-12,  -1.052988471754375e-12,  -3.276057483771752e-14,  -7.360196418091552e-17,   2.123935343254776e-17,   5.804078560477680e-19,  -2.299196755560451e-22,
  -3.931643205439759e-22,  -9.114977099365477e-24,  -1.726425106346810e-03,  -5.859427057701930e-05,  -4.332603028784293e-07,   2.798760855109836e-08,   9.850434315571287e-10,
   4.995543354872006e-12,  -5.648684973527527e-13,  -1.756633826178131e-14,  -3.923464355858901e-17,   1.139318498896204e-17,   3.110991582929898e-19,  -1.300579261902898e-22,
  -2.108666155411426e-22,  -4.882824452383877e-24,  -6.424503761902657e-04,  -2.180431771635848e-05,  -1.612143440995573e-07,   1.041505794643639e-08,   3.665418366357844e-10,
   1.858132852355362e-12,  -2.102052778295901e-13,  -6.535968820594331e-15,  -1.456824977251601e-17,   4.239693572286665e-18,   1.157365110084197e-19,  -4.926839207931109e-23,
  -7.846440821381792e-23,  -1.816165996930995e-24,  -7.256977596020323e-05,  -2.462963539671744e-06,  -1.821016972918826e-08,   1.176463691844350e-09,   4.140339840201347e-11,
   2.098754107907753e-13,  -2.374436233214198e-14,  -7.382715794866383e-16,  -1.645023022818300e-18,   4.789059809881235e-19,   1.307276604024372e-20,  -5.580845309145563e-24,
  -8.863078896876288e-24,  -2.051345503522709e-25,  -3.079422602944866e-03,  -1.725499701862392e-04,  -5.978994129056487e-06,  -1.536913888547832e-07,  -2.879515426196354e-09,
  -2.713616073161772e-11,   6.310779952917764e-13,   4.289634182606102e-14,   1.383116344636842e-15,   3.028835074695317e-17,   3.831447859310685e-19,  -2.774446061635741e-21,
  -3.225098901529622e-22,  -1.045259858757000e-23,  -2.929816983435400e-03,  -1.641708057986698e-04,  -5.688686830264297e-06,  -1.462237736668516e-07,  -2.739168995363952e-09,
  -2.578931492548424e-11,   6.015364132987309e-13,   4.084223343642035e-14,   1.316348466416324e-15,   2.881034492372780e-17,   3.638691652300012e-19,  -2.663848786417819e-21,
  -3.074065920132002e-22,  -9.952575092846684e-24,  -2.645177650714524e-03,  -1.482271113058853e-04,  -5.136280976365288e-06,  -1.320162689856065e-07,  -2.472329686652016e-09,
  -2.323838111420137e-11,   5.448764237010232e-13,   3.692191752167134e-14,   1.189141006960398e-15,   2.600089427573484e-17,   3.274630197485878e-19,  -2.443609022667407e-21,
  -2.784410635700913e-22,  -8.998031417115463e-24,  -2.253264559477340e-03,  -1.262716846137548e-04,  -4.375555237127197e-06,  -1.124550132033609e-07,  -2.105281471527107e-09,
  -1.974852102777900e-11,   4.659815542107182e-13,   3.150053769777457e-14,   1.013653978781438e-15,   2.213772353080023e-17,   2.778565773895130e-19,  -2.121308883107244e-21,
  -2.381133344493799e-22,  -7.677569933471400e-24,  -1.792364992459142e-03,  -1.004478415977190e-04,  -3.480756780292012e-06,  -8.945141540303980e-08,  -1.674075806946791e-09,
  -1.567282331325596e-11,   3.720833603389795e-13,   2.509501818173963e-14,   8.068508002411263e-16,   1.760106971354563e-17,   2.201790074163772e-19,  -1.718118976731330e-21,
  -1.901229613040704e-22,  -6.116908821503217e-24,  -1.307580416001386e-03,  -7.328227889829646e-05,  -2.539432963437161e-06,  -6.525659230521039e-08,  -1.220946439867950e-09,
  -1.141248272760244e-11,   2.722782562365338e-13,   1.832974403592666e-14,   5.889350985105887e-16,   1.283547948579055e-17,   1.601305944707109e-19,  -1.271481757229831e-21,
  -1.391201143366451e-22,  -4.468174915163082e-24,  -8.464064305940953e-04,  -4.743734227728327e-05,  -1.643846444446954e-06,  -4.224076303656343e-08,  -7.901826226607144e-10,
  -7.378277714990324e-12,   1.766040875427786e-13,   1.187448183758943e-14,   3.813564357810154e-16,   8.306353742654628e-18,   1.034412108602276e-19,  -8.307708237106466e-22,
  -9.023310531736674e-23,  -2.894721951992579e-24,  -4.540493462262449e-04,  -2.544778657183125e-05,  -8.818455075104042e-07,  -2.265970296566846e-08,  -4.238484763947512e-10,
  -3.955520756496494e-12,   9.483632411071722e-14,   6.372607861615080e-15,   2.046132189751825e-16,   4.455297464323939e-18,   5.543179065254098e-20,  -4.477922863726687e-22,
  -4.845445261607960e-23,  -1.553526111793046e-24,  -1.689660514633187e-04,  -9.469964495853063e-06,  -3.281643492645304e-07,  -8.432377490710001e-09,  -1.577221796097293e-10,
  -1.471648693948071e-12,   3.530429864764043e-14,   2.371786953466009e-15,   7.614780608836679e-17,   1.657879466661214e-18,   2.062032239093387e-20,  -1.669136003106733e-22,
  -1.803783468563670e-23,  -5.782027944979314e-25,  -1.908606386719668e-05,  -1.069708817301391e-06,  -3.706881575656954e-08,  -9.525041286983343e-10,  -1.781588599849722e-11,
  -1.662286367864285e-13,   3.988130229177240e-15,   2.679183398905443e-16,   8.601588165736715e-18,   1.872693360535629e-19,   2.329093874225691e-21,  -1.885917056683411e-23,
  -2.037632228445352e-24,  -6.531417588956350e-26,  -4.187080290577827e-04,   1.724163789490772e-05,  -4.703659516548687e-07,   1.056409624600997e-08,  -2.115493341731967e-10,
   3.862059909048207e-12,  -6.683574063706389e-14,   1.065097282754034e-15,  -1.552586637373669e-17,   2.737674944101258e-19,  -1.934223283789171e-21,   1.763903200324040e-23,
  -1.805646614105598e-24,  -1.682590922051059e-26,  -3.983559721232796e-04,   1.640394336310314e-05,  -4.475250057654107e-07,   1.005140535926929e-08,  -2.012893596897654e-10,
   3.674874393895513e-12,  -6.359776750583053e-14,   1.013583802269328e-15,  -1.477329948554187e-17,   2.604798297961467e-19,  -1.843659104032185e-21,   1.674277478262444e-23,
  -1.715492913077069e-24,  -1.595369735355999e-26,  -3.596383545928302e-04,   1.481016996387963e-05,  -4.040635849765672e-07,   9.075742108297072e-09,  -1.817616021431349e-10,
   3.318555804369640e-12,  -5.743352052687482e-14,   9.154802107771666e-16,  -1.334077529113970e-17,   2.351935295529778e-19,  -1.669959980050051e-21,   1.505372632357011e-23,
  -1.544959658000266e-24,  -1.431671285279793e-26,  -3.063370630332088e-04,   1.261578493595011e-05,  -3.442142819277454e-07,   7.731950641644635e-09,  -1.548604295615633e-10,
   2.827600449184805e-12,  -4.893896821929644e-14,   7.802211762437969e-16,  -1.136701921678288e-17,   2.003673993613901e-19,  -1.428105892008141e-21,   1.275928894353074e-23,
  -1.312077717483510e-24,  -1.210617863780059e-26,  -2.436636297895198e-04,   1.003518838535641e-05,  -2.738194844100073e-07,   6.151081421874625e-09,  -1.232064176754406e-10,
   2.249782958052630e-12,  -3.894011336445683e-14,   6.209221212455815e-16,  -9.044117631646483e-18,   1.593984446712860e-19,  -1.140282482970532e-21,   1.010016248469372e-23,
  -1.040628424704456e-24,  -9.561147587998239e-27,  -1.777518194581392e-04,   7.320909825193918e-06,  -1.997668303609334e-07,   4.487786705608936e-09,  -8.989563453351106e-11,
   1.641609406486080e-12,  -2.841465351136398e-14,   4.531523656157510e-16,  -6.599229708169838e-18,   1.162947895044159e-19,  -8.343858378896272e-22,   7.339523630404189e-24,
  -7.573677472022154e-25,  -6.934857642916482e-27,  -1.150568038847172e-04,   4.738861342410200e-06,  -1.293138999704269e-07,   2.905148774829394e-09,  -5.819571198723130e-11,
   1.062766936057333e-12,  -1.839590214160958e-14,   2.934025563687088e-16,  -4.272284139425026e-18,   7.528237503381222e-20,  -5.411796126582640e-22,   4.738633481583975e-24,
  -4.894807528963441e-25,  -4.471803101326796e-27,  -6.172059325749398e-05,   2.542127209449230e-06,  -6.937054480392594e-08,   1.558495802745544e-09,  -3.122026397117573e-11,
   5.701534330849963e-13,  -9.869160239985363e-15,   1.574142361235461e-16,  -2.291992514911566e-18,   4.038582310080099e-20,  -2.906084149528245e-22,   2.538628860081370e-24,
  -2.623671377365976e-25,  -2.394144036846173e-27,  -2.296805897750083e-05,   9.460049160534185e-07,  -2.581508283114920e-08,   5.799714530816217e-10,  -1.161824282342286e-11,
   2.121770709661363e-13,  -3.672728166973075e-15,   5.858142076053823e-17,  -8.529423586686936e-19,   1.502897444000003e-20,  -1.081828689819148e-22,   9.442661376583576e-25,
  -9.760765755200883e-26,  -8.903245896188756e-28,  -2.594423463961312e-06,   1.068587932361061e-07,  -2.916021760095201e-09,   6.551251345008978e-11,  -1.312376826616015e-12,
   2.396718359434136e-14,  -4.148658019598436e-16,   6.617286087784701e-18,  -9.634700108743034e-20,   1.697645079042928e-21,  -1.222080537122680e-23,   1.066545542811570e-25,
  -1.102507252941438e-26,  -1.005583038081975e-28,  -3.605132548108995e-03,   1.356802197318469e-04,  -3.120315203610223e-06,   5.127488522949726e-08,  -5.490381702537220e-10,
  -2.533196136334992e-13,   1.757522393856050e-13,  -5.395416936493061e-15,   1.082003127058387e-16,  -9.014878267873243e-19,   1.612655071255055e-20,   1.053275464646932e-22,
  -2.394930139059406e-23,   3.218859127028355e-26,  -3.429870622926637e-03,   1.290852621307437e-04,  -2.968639787671748e-06,   4.878077220933891e-08,  -5.222540505467526e-10,
  -2.443711174325308e-13,   1.672937835899157e-13,  -5.133945728079714e-15,   1.029586062907863e-16,  -8.574661153653852e-19,   1.529529760347926e-20,   1.002879939228437e-22,
  -2.277178279382175e-23,   3.128436257925988e-26,  -3.096464871713629e-03,   1.165390486268121e-04,  -2.680096254822756e-06,   4.403672076387078e-08,  -4.713395676869393e-10,
  -2.259799385069664e-13,   1.511682110112009e-13,  -4.636206005396838e-15,   9.297958773693342e-17,  -7.738019770644660e-19,   1.373323731480820e-20,   9.067032455791582e-23,
  -2.053717465057830e-23,   2.929344662098726e-26,  -2.637498006862955e-03,   9.926706329502209e-05,  -2.282873104292777e-06,   3.750716032106688e-08,  -4.013237791221987e-10,
  -1.980092402222489e-13,   1.289022104075802e-13,  -3.950366375893055e-15,   7.922786265922061e-17,  -6.587843464396928e-19,   1.162020146534784e-20,   7.736886309786169e-23,
  -1.747147891707949e-23,   2.602988697296654e-26,  -2.097857405081514e-03,   7.895806454414805e-05,  -1.815811776665382e-06,   2.983128756486371e-08,  -3.190938362824511e-10,
  -1.617623669659237e-13,   1.026369712045092e-13,  -3.143152236569912e-15,   6.304062390650280e-17,  -5.237457060731983e-19,   9.182910327958830e-21,   6.164800021257330e-23,
  -1.388011303672496e-23,   2.153411136628905e-26,  -1.530359262060601e-03,   5.759966557461113e-05,  -1.324623541482407e-06,   2.176047935774190e-08,  -2.327054806610986e-10,
  -1.205110301647431e-13,   7.493612531006614e-14,  -2.293501070408619e-15,   4.600078437857582e-17,  -3.819189866956279e-19,   6.663717673033535e-21,   4.503681208103115e-23,
  -1.011560188481889e-23,   1.619523143777606e-26,  -9.905758568264562e-04,   3.728363884727893e-05,  -8.574120654983897e-07,   1.408474324149584e-08,  -1.505967193072464e-10,
  -7.907735277022461e-14,   4.853219121299679e-14,  -1.484806868665665e-15,   2.978128403859536e-17,  -2.471470129085479e-19,   4.298310281008947e-21,   2.917996737390231e-23,
  -6.543493712727019e-24,   1.069049192974887e-26,  -5.313779359180958e-04,   2.000028199508231e-05,  -4.599459464084037e-07,   7.555402222304223e-09,  -8.077693976046675e-11,
  -4.271522501647951e-14,   2.604180633986561e-14,  -7.965721396782451e-16,   1.597725498134351e-17,  -1.325606138412247e-19,   2.301625447770921e-21,   1.566099963515658e-23,
  -3.509002059619244e-24,   5.791851255102023e-27,  -1.977411345592747e-04,   7.442696951509939e-06,  -1.711594160624431e-07,   2.811568143192446e-09,  -3.005838342399230e-11,
  -1.593384774899001e-14,   9.691885115386084e-15,  -2.964369367197829e-16,   5.945804319342542e-18,  -4.932740764673204e-20,   8.559664963036801e-22,   5.828938229304324e-24,
  -1.305653000534053e-24,   2.162709091418917e-27,  -2.233641548982405e-05,   8.407113428267927e-07,  -1.933380494635897e-08,   3.175884342812187e-10,  -3.395311723818741e-12,
  -1.800539415311516e-15,   1.094792066133256e-15,  -3.348504975197850e-17,   6.716290005743875e-19,  -5.571878283005735e-21,   9.667855367080745e-23,   6.584428087288925e-25,
  -1.474811099864372e-25,   2.444274930422517e-28,  -9.061382732699276e-03,   2.716386505010835e-04,  -3.406097596855802e-06,  -2.334750564971850e-08,   1.971440390938400e-09,
  -4.183359028267921e-11,   2.384094240304736e-13,   1.062619852996821e-14,  -3.683443463015675e-16,   6.754902949140537e-18,   5.171129719980402e-20,  -3.244023087300183e-21,
   2.187982526838612e-23,  -1.151884256647195e-24,  -8.620734832428442e-03,   2.584239507159765e-04,  -3.240071964490050e-06,  -2.222429184723178e-08,   1.875654025791158e-09,
  -3.979212254207755e-11,   2.265068857754790e-13,   1.011652965882252e-14,  -3.503584205804648e-16,   6.421012798286804e-18,   4.923926341354592e-20,  -3.088849647383100e-21,
   2.084171881415731e-23,  -1.091863368536044e-24,  -7.782531756947569e-03,   2.332889525719598e-04,  -2.924415456847360e-06,  -2.008276280816595e-08,   1.693414606914803e-09,
  -3.591172416006157e-11,   2.039914571778620e-13,   9.144150377998923e-15,  -3.161753385279460e-16,   5.788076245681137e-18,   4.451967841040630e-20,  -2.792615786137637e-21,
   1.885622801836392e-23,  -9.793264908581999e-25,  -6.628764790472393e-03,   1.986952539586239e-04,  -2.490228862181141e-06,  -1.712541314390035e-08,   1.442500521844212e-09,
  -3.057606299802774e-11,   1.732430333835371e-13,   7.800108950620758e-15,  -2.691810839334287e-16,   4.921108204941399e-18,   3.798973187825504e-20,  -2.382810291944492e-21,
   1.610257753375490e-23,  -8.275858975141166e-25,  -5.272329873381575e-03,   1.580300239557702e-04,  -1.980163007369298e-06,  -1.363645365809455e-08,   1.147428483550072e-09,
  -2.431027136262382e-11,   1.374015719376225e-13,   6.212919907168879e-15,  -2.140054195785395e-16,   3.907244805961463e-18,   3.027017898847648e-20,  -1.898448162694905e-21,
   1.283947581165862e-23,  -6.531855408326223e-25,  -3.845996106923452e-03,   1.152740326160217e-04,  -1.444175441774959e-06,  -9.956398837925013e-09,   8.370738868534189e-10,
  -1.772824139207013e-11,   1.000003562145268e-13,   4.537372693552847e-15,  -1.560551110459469e-16,   2.846173134691650e-18,   2.211303982170715e-20,  -1.386746634974890e-21,
   9.384588306497715e-24,  -4.735132086267983e-25,  -2.489406413673633e-03,   7.461204500436687e-05,  -9.346505258628511e-07,  -6.448366873193663e-09,   5.418409278683911e-10,
  -1.147271959072549e-11,   6.462922804884686e-14,   2.939157443614631e-15,  -1.009865973194223e-16,   1.840521008862423e-18,   1.432681829845438e-20,  -8.984080851783433e-22,
   6.082284591960198e-24,  -3.052252898362461e-25,  -1.335388996729685e-03,   4.002359086077768e-05,  -5.013391581265059e-07,  -3.460153985188354e-09,   2.906662416341833e-10,
  -6.153667962027345e-12,   3.464191583681324e-14,   1.577265750546635e-15,  -5.416561976249928e-17,   9.868321015600894e-19,   7.689082055170046e-21,  -4.821533418609645e-22,
   3.264879545443491e-24,  -1.633828908007829e-25,  -4.969354492940987e-04,   1.489383492506425e-05,  -1.865578395738224e-07,  -1.287757638855767e-09,   1.081659421997599e-10,
  -2.289869954340594e-12,   1.288771787234120e-14,   5.870244791598033e-16,  -2.015569574643503e-17,   3.671660344103021e-19,   2.861809536399797e-21,  -1.794513522983270e-22,
   1.215232862561956e-24,  -6.075417356539655e-26,  -5.613273809927994e-05,   1.682373872063405e-06,  -2.107308488161439e-08,  -1.454647501580439e-10,   1.221820429191369e-11,
  -2.586572282147957e-13,   1.455705525915890e-15,   6.631043028612109e-17,  -2.276728105873027e-18,   4.147316397691108e-20,   3.232724725585858e-22,  -2.027094465812847e-23,
   1.372750581156557e-25,  -6.861848886496213e-27,  -1.475702093071751e-02,   2.506884760387866e-04,   3.503331167313000e-06,  -1.861330987983065e-07,   1.281501866620666e-09,
   7.321707072280474e-11,  -1.972511742955440e-12,  -5.968788548815056e-15,   1.161957157171284e-15,  -1.396176199621382e-17,  -2.336956405381904e-19,   1.404739206596112e-20,
  -1.945634467702338e-22,  -8.378035902214142e-24,  -1.403913007799322e-02,   2.384783465588708e-04,   3.333154434814119e-06,  -1.770577677956360e-07,   1.218293250961426e-09,
   6.965197218732703e-11,  -1.875602674976653e-12,  -5.693251178973913e-15,   1.105123476261120e-15,  -1.325987273398105e-17,  -2.227037764247775e-19,   1.334481223742417e-20,
  -1.845067578580869e-22,  -7.961846187928642e-24,  -1.267366299065126e-02,   2.152600333026808e-04,   3.009366798368436e-06,  -1.598043065199633e-07,   1.098419939002216e-09,
   6.287228198051511e-11,  -1.691663442484701e-12,  -5.163104377314440e-15,   9.971470171441596e-16,  -1.193410439671127e-17,  -2.016419170761240e-19,   1.201630242044053e-20,
  -1.656205427772854e-22,  -7.173733732010995e-24,  -1.079434111406298e-02,   1.833158192463274e-04,   2.563532683258812e-06,  -1.360741009536921e-07,   9.341193571692510e-10,
   5.354381837896467e-11,  -1.439254002645825e-12,  -4.421734884963757e-15,   8.487783088766132e-16,  -1.012733850293796e-17,  -1.723555603747095e-19,   1.020301000989708e-20,
  -1.400948940050144e-22,  -6.095829745078382e-24,  -8.585169991446552e-03,   1.457796628623980e-04,   2.039197395895953e-06,  -1.081992751097090e-07,   7.418461355995693e-10,
   4.258134266899796e-11,  -1.143491969062736e-12,  -3.535461352813335e-15,   6.746755979051786e-16,  -8.026075442113741e-18,  -1.375535853784741e-19,   8.090613040097347e-21,
  -1.106788408131753e-22,  -4.837336567210089e-24,  -6.262407222459149e-03,   1.063272119637347e-04,   1.487668354948204e-06,  -7.891018396437595e-08,   5.404919451796337e-10,
   3.105826595267826e-11,  -8.334068433444309e-13,  -2.589879338793615e-15,   4.919079965992361e-16,  -5.837799018705100e-18,  -1.006142977956096e-19,   5.887423797302168e-21,
  -8.029783245935193e-23,  -3.522152659961966e-24,  -4.053396713207012e-03,   6.881649509141598e-05,   9.629858134121404e-07,  -5.106878748448137e-08,   3.495627917855626e-10,
   2.010166921722916e-11,  -5.391272430103734e-13,  -1.681000639483143e-15,   3.182929071811502e-16,  -3.771397404197241e-18,  -6.524143127353299e-20,   3.804604207552793e-21,
  -5.178720411440098e-23,  -2.276998827563874e-24,  -2.174334703711312e-03,   3.691344624181985e-05,   5.165895718377302e-07,  -2.739267367516870e-08,   1.874376700931039e-10,
   1.078270284561893e-11,  -2.891168696726066e-13,  -9.030150726408639e-16,   1.707123668135259e-16,  -2.021090611517754e-18,  -3.502944027670209e-20,   2.039202360326555e-21,
  -2.772858668590978e-23,  -1.220678146910386e-24,  -8.091274701208771e-04,   1.373630216312026e-05,   1.922394906836819e-07,  -1.019330651452125e-08,   6.974069864420770e-11,
   4.012491128203854e-12,  -1.075772460998913e-13,  -3.362025439921556e-16,   6.352306023138218e-17,  -7.518457986906609e-19,  -1.303958065940112e-20,   7.586243381381785e-22,
  -1.031190548368086e-23,  -4.541487017974356e-25,  -9.139720917461664e-05,   1.551618619596140e-06,   2.171498908266433e-08,  -1.151408691370755e-09,   7.877575628824899e-12,
   4.532412444049622e-13,  -1.215148902093930e-14,  -3.797966755770770e-17,   7.175357978912881e-18,  -8.492222194236103e-20,  -1.472996794548900e-21,   8.568860357187586e-23,
  -1.164690604896266e-24,  -5.129785486735993e-26,  -1.737917005579667e-02,  -5.335695888216031e-05,   1.089082946397481e-05,   2.191937632504927e-08,  -6.971611385817172e-09,
  -3.924272276770567e-12,   4.444389542575167e-12,  -9.125922783960950e-15,  -2.917812863588989e-15,   1.725937339149735e-17,   2.160594678628731e-18,  -1.195197180845610e-20,
  -1.528952205517360e-21,   4.704128374760513e-24,  -1.653351953621248e-02,  -5.075970609613143e-05,   1.035985716015674e-05,   2.085202669375642e-08,  -6.630537172719851e-09,
  -3.739005615042862e-12,   4.225800466121749e-12,  -8.663696154121075e-15,  -2.773023161605984e-15,   1.640043213951464e-17,   2.052530648142261e-18,  -1.135980616140794e-20,
  -1.452059888537671e-21,   4.468616766980923e-24,  -1.492512757016192e-02,  -4.582023154332711e-05,   9.350391798094113e-06,   1.882228597593972e-08,  -5.982578761781279e-09,
  -3.384311011618278e-12,   3.811003179916020e-12,  -7.791971345628093e-15,  -2.498787275432576e-15,   1.477455439244363e-17,   1.848195433373672e-18,  -1.023785835663370e-20,
  -1.306834844552372e-21,   4.023401680551250e-24,  -1.271161972055140e-02,  -3.902316709343850e-05,   7.961958627625677e-06,   1.602951839963258e-08,  -5.092296599702718e-09,
  -2.891678590950388e-12,   3.241988071534496e-12,  -6.606624877147859e-15,  -2.123598076254928e-15,   1.255206887793049e-17,   1.569300812169256e-18,  -8.702175255351280e-21,
  -1.108945296918941e-21,   3.415926196720035e-24,  -1.010980636268787e-02,  -3.103468666563561e-05,   6.330993243064467e-06,   1.274760504526448e-08,  -4.047674783530124e-09,
  -2.306961215370265e-12,   2.575476511045768e-12,  -5.231453330336681e-15,  -1.685394621189002e-15,   9.958766854989558e-18,   1.244403434856935e-18,  -6.907657275842223e-21,
  -8.788276403770747e-22,   2.708471899184481e-24,  -7.374397313547887e-03,  -2.263691749383621e-05,   4.617246288028984e-06,   9.297902260701462e-09,  -2.951127042370153e-09,
  -1.686959510228318e-12,   1.876903499770984e-12,  -3.802523837562259e-15,  -1.227297465816082e-15,   7.250050507241264e-18,   9.055394056873515e-19,  -5.030817021543578e-21,
  -6.392032711113779e-22,   1.970792805578025e-24,  -4.773078572825812e-03,  -1.465143753529796e-05,   2.988182969872063e-06,   6.017816501205323e-09,  -1.909531746278790e-09,
  -1.093674558508954e-12,   1.214087908194165e-12,  -2.455434008968757e-15,  -7.934796554688011e-16,   4.686537530085070e-18,   5.851853217312423e-19,  -3.252848789297038e-21,
  -4.129386965378627e-22,   1.273528070601584e-24,  -2.560371090768734e-03,  -7.859228126497587e-06,   1.602827986853280e-06,   3.228003319773377e-09,  -1.024148367323499e-09,
  -5.871606608673011e-13,   6.510569287776017e-13,  -1.315559045723154e-15,  -4.253931190914531e-16,   2.512280842592727e-18,   3.136500421140598e-19,  -1.743969133703419e-21,
  -2.212920635152537e-22,   6.825763630389953e-25,  -9.527795667007148e-04,  -2.924608836946107e-06,   5.964415285339128e-07,   1.201213637017412e-09,  -3.810909292215999e-10,
  -2.185612721806662e-13,   2.422486267926488e-13,  -4.893481941274762e-16,  -1.582679861130644e-16,   9.346679617034024e-19,   1.166842375605778e-19,  -6.488562061442458e-22,
  -8.232044870318173e-23,   2.539305382086369e-25,  -1.076237846867880e-04,  -3.303568796517202e-07,   6.737245010755781e-08,   1.356861643020362e-10,  -4.304677923640556e-11,
  -2.468932070957465e-14,   2.736337522075875e-14,  -5.527197074171869e-17,  -1.787701938403083e-17,   1.055740681031711e-19,   1.317979181569616e-20,  -7.329116366924712e-23,
  -9.298226616674800e-24,   2.868208988287693e-26,  -1.333680492350912e-02,  -4.105031072541932e-04,  -2.809319368563780e-08,   2.965144310160136e-07,   6.213178120165995e-09,
  -9.552829668805527e-11,  -6.797677602913783e-12,  -6.998633230131271e-14,   3.802633138674577e-15,   1.372889504932585e-16,   1.269355822138644e-19,  -9.775797594810408e-20,
  -2.123920426595620e-21,   2.542560552193085e-23,  -1.268809754480547e-02,  -3.905097095379177e-04,  -2.562581380205162e-08,   2.820633385610650e-07,   5.907947797952873e-09,
  -9.092477669795241e-11,  -6.463870115806545e-12,  -6.643633155828570e-14,   3.617808178288338e-15,   1.304518978873596e-16,   1.166529651597424e-19,  -9.294315250950543e-20,
  -2.015305317815741e-21,   2.425433310839426e-23,  -1.145418306166064e-02,  -3.524907373235969e-04,  -2.138078540095076e-08,   2.545873068065642e-07,   5.328594361761925e-09,
  -8.215075526557349e-11,  -5.830217303976362e-12,  -5.974334204320476e-14,   3.266187220486334e-15,   1.175119237060908e-16,   9.877850169201798e-20,  -8.380893072869034e-20,
  -1.810876585770539e-21,   2.199927164999906e-23,  -9.755846054843122e-03,  -3.001829129296282e-04,  -1.640632022126364e-08,   2.167922626439184e-07,   4.533564063903921e-09,
  -7.004033725861072e-11,  -4.960564112421156e-12,  -5.064639270337042e-14,   2.782107798822419e-15,   9.982722723404439e-17,   7.742790062911577e-20,  -7.128371762413700e-20,
  -1.533698790756607e-21,   1.884333057698420e-23,  -7.759331963143418e-03,  -2.387177052778894e-04,  -1.165658226405508e-08,   1.723899942148244e-07,   3.601961473116393e-09,
  -5.576081855005205e-11,  -3.941384254906146e-12,  -4.009771472410069e-14,   2.212904554837364e-15,   7.919647602737425e-17,   5.642315299527938e-20,  -5.661921221436252e-20,
  -1.213147397867569e-21,   1.506819046313402e-23,  -5.660073623269150e-03,  -1.741139054014835e-04,  -7.685286269391549e-09,   1.257292574685213e-07,   2.625221925611744e-09,
  -4.070664570460210e-11,  -2.872700664023458e-12,  -2.914145321266548e-14,   1.614294566076159e-15,   5.765195346998412e-17,   3.813533890356738e-20,  -4.125604970661511e-20,
  -8.810155870256038e-22,   1.103885204079330e-23,  -3.663560901324080e-03,  -1.126892441831505e-04,  -4.624846840631439e-09,   8.137090113807407e-08,   1.698252549601039e-09,
  -2.636147601659277e-11,  -1.858387208681581e-12,  -1.881607508264342e-14,   1.044908511898848e-15,   3.726549267511706e-17,   2.339366374686805e-20,  -2.668424202664035e-20,
  -5.685757378656189e-22,   7.165168325555793e-24,  -1.965226057840408e-03,  -6.044702955103193e-05,  -2.384611611614175e-09,   4.364688744247546e-08,   9.107212911794450e-10,
  -1.414468263620259e-11,  -9.966078725212777e-13,  -1.008071415218663e-14,   5.605242908118397e-16,   1.997623025710679e-17,   1.219406507144172e-20,  -1.430877221267689e-20,
  -3.045376254386010e-22,   3.849099739822521e-24,  -7.313136725340693e-04,  -2.249367235643023e-05,  -8.749104120680987e-10,   1.624186041987304e-08,   3.388697873519967e-10,
  -5.264100503013358e-12,  -3.708287282768022e-13,  -3.749661295732449e-15,   2.085873889676130e-16,   7.431892465741182e-18,   4.491803646696482e-21,  -5.323990310788516e-21,
  -1.132670289510878e-22,   1.433068239208666e-24,  -8.260755761134294e-05,  -2.540829580970834e-06,  -9.860444615603287e-11,   1.834638423221930e-09,   3.827736076980398e-11,
  -5.946296674468186e-13,  -4.188733945958899e-14,  -4.235238810428638e-16,   2.356158601359459e-17,   8.394576577604391e-19,   5.065608327650699e-22,  -6.013736711956395e-22,
  -1.279332142008516e-23,   1.618889826330293e-25,  -3.878117352647841e-03,  -2.285757978470553e-04,  -8.113605949177069e-06,  -2.027702891578487e-07,  -3.143020046565044e-09,
   8.525221365900320e-12,   2.633699397050782e-12,   1.069542929399051e-13,   2.661074748971019e-15,   3.616972505913058e-17,  -3.348760118329120e-19,  -3.714491052687434e-20,
  -1.239857240229328e-21,  -2.511190857573674e-23,  -3.689726485303716e-03,  -2.174758754472933e-04,  -7.719515236589876e-06,  -1.929047348057444e-07,  -2.988959545845635e-09,
   8.177506579727409e-12,   2.507807870804745e-12,   1.017902901790686e-13,   2.531171252154457e-15,   3.434912513249794e-17,  -3.210267710942570e-19,  -3.539611366256255e-20,
  -1.180130873398392e-21,  -2.386940088832528e-23,  -3.331287407994480e-03,  -1.963552195546527e-04,  -6.969683162769498e-06,  -1.741404214922360e-07,  -2.696398503471124e-09,
   7.488933191812146e-12,   2.267448147999723e-12,   9.195211907328534e-14,   2.284265772546125e-15,   3.091091917742430e-17,  -2.936940816223237e-19,  -3.204608398884870e-20,
  -1.066283151415820e-21,  -2.151436429364459e-23,  -2.837747619203487e-03,  -1.672708820749613e-04,  -5.937188016824582e-06,  -1.483156931510837e-07,  -2.294653729522393e-09,
   6.488459440762398e-12,   1.934877237829982e-12,   7.838077557552990e-14,   1.944793959524834e-15,   2.622681216012410e-17,  -2.541530367916931e-19,  -2.738943284262619e-20,
  -9.091223895796503e-22,  -1.828933220175920e-23,  -2.257315325290126e-03,  -1.330621557693689e-04,  -4.722860824899742e-06,  -1.179596466723158e-07,  -1.823555011612249e-09,
   5.245525245650289e-12,   1.541709586387663e-12,   6.238853276377817e-14,   1.546189106659776e-15,   2.078150155948369e-17,  -2.052357883197197e-19,  -2.185742415329299e-20,
  -7.237911076836510e-22,  -1.451914738635411e-23,  -1.646787503273539e-03,  -9.707615452039606e-05,  -3.445523302438872e-06,  -8.604400605148904e-08,  -1.329315221085052e-09,
   3.876288513846510e-12,   1.126251455592637e-12,   4.553782802028249e-14,   1.127514010020630e-15,   1.511319782196052e-17,  -1.515295126820159e-19,  -1.598694024020521e-20,
  -5.283910677009247e-22,  -1.057486823613884e-23,  -1.065983152824693e-03,  -6.283964383412177e-05,  -2.230339976558961e-06,  -5.569226974718862e-08,  -8.600393893550420e-10,
   2.530338944731326e-12,   7.296855581850104e-13,   2.948706582809582e-14,   7.296444072263380e-16,   9.762548931793283e-18,  -9.885807754330961e-20,  -1.036612822633385e-20,
  -3.421865179159270e-22,  -6.837769303540452e-24,  -5.718413908909989e-04,  -3.371034981822767e-05,  -1.196459223546019e-06,  -2.987448232449445e-08,  -4.612424741451185e-10,
   1.363222029327238e-12,   3.916155012955409e-13,   1.582092646455500e-14,   3.913568346463612e-16,   5.231451337236923e-18,  -5.324446801404230e-20,  -5.565706961077602e-21,
  -1.836063209653573e-22,  -3.666026899181165e-24,  -2.128003737908324e-04,  -1.254473681755118e-05,  -4.452411061966278e-07,  -1.111706903370463e-08,  -1.716272717751818e-10,
   5.080539825451671e-13,   1.457558069450034e-13,   5.887824208903095e-15,   1.456288983233831e-16,   1.946061358499977e-18,  -1.984149118179253e-20,  -2.071804479420876e-21,
  -6.833118936567901e-23,  -1.363977946762985e-24,  -2.403750387551828e-05,  -1.417029111861941e-06,  -5.029355344565425e-08,  -1.255758685373006e-09,  -1.938639085545833e-11,
   5.740230588871862e-14,   1.646470013735062e-14,   6.650831733980783e-16,   1.644981535291255e-17,   2.198101395493390e-19,  -2.241748584971922e-21,  -2.340381364116057e-22,
  -7.718651632340749e-24,  -1.540674228624993e-25,  -3.565386130835895e-04,   1.393359620928955e-05,  -3.616133694167568e-07,   7.719323841578998e-09,  -1.481864850152205e-10,
   2.568314305961311e-12,  -4.259245678445047e-14,   7.109535095056049e-16,  -7.118023821079214e-18,   1.854224340937529e-19,  -3.107384735820255e-21,  -6.544318427192516e-23,
  -1.103291289938527e-24,   4.536891816312066e-26,  -3.392072471375420e-04,   1.325655145039708e-05,  -3.440508558394282e-07,   7.344618311213641e-09,  -1.409976623724300e-10,
   2.443835451026139e-12,  -4.052669488123570e-14,   6.765702219133031e-16,  -6.775975382087899e-18,   1.762974180593365e-19,  -2.958375254185496e-21,  -6.215546036376464e-23,
  -1.046920832033257e-24,   4.311340259206626e-26,  -3.062366457424037e-04,   1.196845545644684e-05,  -3.106342119333031e-07,   6.631575321396438e-09,  -1.273159835150951e-10,
   2.206881982789524e-12,  -3.659496904020716e-14,   6.110888012293866e-16,  -6.123667777889137e-18,   1.589839290359585e-19,  -2.674067393490028e-21,  -5.594448613618198e-23,
  -9.408048971135172e-25,   3.884309570630629e-26,  -2.608480039997329e-04,   1.019499977419255e-05,  -2.646192837975693e-07,   5.649553199859473e-09,  -1.084697849698865e-10,
   1.880393142036751e-12,  -3.117872887943924e-14,   5.208053858887518e-16,  -5.222557260995899e-18,   1.352377237597972e-19,  -2.281061863216877e-21,  -4.747835236979063e-23,
  -7.968882450657526e-25,   3.300406296659825e-26,  -2.074796908746990e-04,   8.109489226476851e-06,  -2.104990726067262e-07,   4.494353781560542e-09,  -8.629577674098341e-11,
   1.496138688948426e-12,  -2.480562004924022e-14,   4.144736539910527e-16,  -4.159072386689024e-18,   1.074280715459981e-19,  -1.816928670125465e-21,  -3.763006722349930e-23,
  -6.304015039874323e-25,   2.618847336936357e-26,  -1.513548868002547e-04,   5.916011688439130e-06,  -1.535690745449311e-07,   3.278993364110398e-09,  -6.296294843995341e-11,
   1.091695594515153e-12,  -1.809899462164382e-14,   3.024861838821152e-16,  -3.036968334923392e-18,   7.828549138832084e-20,  -1.326936531381614e-21,  -2.737196005262981e-23,
  -4.578522316090360e-25,   1.906729051075189e-26,  -9.796998760707610e-05,   3.829440451427580e-06,  -9.940815113505966e-08,   2.122617722279631e-09,  -4.075970121642351e-11,
   7.067569490949946e-13,  -1.171672559000885e-14,   1.958511336925406e-16,  -1.967053873573388e-18,   5.063791820087210e-20,  -8.595485346155205e-22,  -1.768379265620783e-23,
  -2.954987134845728e-25,   1.232619941097525e-26,  -5.255451035510115e-05,   2.054268651295190e-06,  -5.332735487644597e-08,   1.138692650771105e-09,  -2.186619739882511e-11,
   3.791612657848150e-13,  -6.285669691533512e-15,   1.050767524674547e-16,  -1.055544747026750e-18,   2.715424431207595e-20,  -4.612678902254511e-22,  -9.476920794168570e-24,
  -1.582783271389765e-25,   6.607853375068224e-27,  -1.955707507314752e-05,   7.644566796933268e-07,  -1.984484980764569e-08,   4.237469824911649e-10,  -8.137218724608349e-12,
   1.411012070749431e-13,  -2.339135254659626e-15,   3.910413511437945e-17,  -3.928443250699274e-19,   1.010363542616223e-20,  -1.716741141846742e-22,  -3.525438489229980e-24,
  -5.886926642275670e-26,   2.458413065106928e-27,  -2.209125684197511e-06,   8.635145839621520e-08,  -2.241635273136503e-09,   4.786566790447439e-11,  -9.191659143884110e-13,
   1.593856768867580e-14,  -2.642247057837756e-16,   4.417155812676429e-18,  -4.437567052070312e-20,   1.141262707652265e-21,  -1.939235211643308e-23,  -3.982045083198296e-25,
  -6.649196391408161e-27,   2.776870302509447e-28,  -3.108649562161548e-03,   1.130304305170305e-04,  -2.557273210175939e-06,   4.263425800200702e-08,  -5.222501685957995e-10,
   2.517448959103518e-12,   6.911856773766814e-14,  -2.338315247097009e-15,   8.552122218412917e-17,  -4.822820607868078e-19,  -2.171865954268246e-21,  -8.365290394713033e-22,
  -1.112620148984258e-23,   4.958736709363177e-25,  -2.957519987063555e-03,   1.075363970722323e-04,  -2.432979680565150e-06,   4.056125756763554e-08,  -4.968166521953648e-10,
   2.393537052319707e-12,   6.582779111669830e-14,  -2.225104317212012e-15,   8.135836024714997e-17,  -4.601805819881934e-19,  -2.087811436955136e-21,  -7.946954719043901e-22,
  -1.056291721362697e-23,   4.713576485844340e-25,  -2.670023499648848e-03,   9.708457843927873e-05,  -2.196521497193495e-06,   3.661787345095345e-08,  -4.484518239361487e-10,
   2.158436507046773e-12,   5.953943024409700e-14,  -2.009552753025119e-15,   7.344133893856136e-17,  -4.175869814890618e-19,  -1.919097039225016e-21,  -7.155897504014055e-22,
  -9.500544920182407e-24,   4.248877848118963e-25,  -2.274258512437941e-03,   8.269588651775536e-05,  -1.870991365257223e-06,   3.118968399302414e-08,  -3.819078124233127e-10,
   1.836000368837055e-12,   5.082815070872793e-14,  -1.712459266850865e-15,   6.254688433482247e-17,  -3.578901203174195e-19,  -1.669813369348904e-21,  -6.076132408888109e-22,
  -8.055804342156106e-24,   3.612411761500784e-25,  -1.808932880473590e-03,   6.577716967117655e-05,  -1.488214883050827e-06,   2.480772257420021e-08,  -3.037116710457183e-10,
   1.458413000817493e-12,   4.051642311678867e-14,  -1.362680067202886e-15,   4.974277110025625e-17,  -2.863593528339892e-19,  -1.355246126030198e-21,  -4.818206760313377e-22,
  -6.379437236543603e-24,   2.868153698771644e-25,  -1.319589698990661e-03,   4.798423928717464e-05,  -1.085653295916114e-06,   1.809664019774566e-08,  -2.215203821483537e-10,
   1.062755252663614e-12,   2.960782940094002e-14,  -9.944082827352778e-16,   3.628266243062450e-17,  -2.098895476328877e-19,  -1.004510097921543e-21,  -3.506171093123023e-22,
  -4.637236515883319e-24,   2.089263455018318e-25,  -8.541470002652211e-04,   3.105967601888313e-05,  -7.027337880694992e-07,   1.171353761334579e-08,  -1.433721865249474e-10,
   6.874169380794269e-13,   1.918673298840939e-14,  -6.438143771022737e-16,   2.348342590770515e-17,  -1.362826554564496e-19,  -6.569804856391192e-22,  -2.265790008122789e-22,
  -2.994572550696102e-24,   1.351057351278588e-25,  -4.581925996288402e-04,   1.666152449699355e-05,  -3.769722264801435e-07,   6.283500988794070e-09,  -7.690570028528205e-11,
   3.686192922180137e-13,   1.029848652542807e-14,  -3.454050597947932e-16,   1.259681455677147e-17,  -7.322346296667278e-20,  -3.542914188513284e-22,  -1.214427712398611e-22,
  -1.604453737772570e-24,   7.243978816786327e-26,  -1.705067044412565e-04,   6.200246398041070e-06,  -1.402826019576204e-07,   2.338268813219286e-09,  -2.861833229737862e-11,
   1.371565570935613e-13,   3.833153235063003e-15,  -1.285406214786746e-16,   4.687577820728706e-18,  -2.726370915009260e-20,  -1.320835683985240e-22,  -4.517919781862049e-23,
  -5.968132881366475e-25,   2.695235797564813e-26,  -1.926007172826664e-05,   7.003667489408989e-07,  -1.584602810280791e-08,   2.641257695481689e-10,  -3.232656475917223e-12,
   1.549259992278005e-14,   4.329989102560004e-16,  -1.451977014183225e-17,   5.294976487245814e-19,  -3.079921533260246e-21,  -1.492420478606602e-23,  -5.103109325433914e-24,
  -6.741026347253730e-26,   3.044398479850686e-27,  -8.030423851201415e-03,   2.437442691837707e-04,  -3.523387330247234e-06,   1.893214991090925e-09,   1.210187338362422e-09,
  -3.364101143781064e-11,   4.087692440710561e-13,   2.860997457445085e-15,  -1.208308146490871e-16,   6.108731707351619e-18,  -8.319526037976769e-20,  -3.050860892301881e-21,
   2.760996848105316e-24,   6.768555669842945e-25,  -7.639925817900580e-03,   2.318886171769279e-04,  -3.351792290795036e-06,   1.791132535769403e-09,   1.151505329393359e-09,
  -3.200288471649001e-11,   3.887853519167857e-13,   2.728341442746428e-15,  -1.150648111356495e-16,   5.806627243607859e-18,  -7.914207029963102e-20,  -2.900912876965243e-21,
   2.728069225477831e-24,   6.427186016702752e-25,  -6.897111964983567e-03,   2.093377649313966e-04,  -3.025487006358773e-06,   1.601023699846124e-09,   1.039811518967984e-09,
  -2.888771535759932e-11,   3.508147426069901e-13,   2.473363872037503e-15,  -1.040519913542460e-16,   5.234015465619797e-18,  -7.143483058811753e-20,  -2.616329934962839e-21,
   2.623921413959334e-24,   5.782855999859329e-25,  -5.874634099584004e-03,   1.782990605054122e-04,  -2.576536743384501e-06,   1.347239526704051e-09,   8.859347650468000e-10,
  -2.460147899488094e-11,   2.986323291189467e-13,   2.117284790549554e-15,  -8.880646120327469e-17,   4.449805984978597e-18,  -6.083162127995467e-20,  -2.225862791094747e-21,
   2.400387774880746e-24,   4.905637857497114e-25,  -4.672535097345113e-03,   1.418107261749320e-04,  -2.048979877038736e-06,   1.058870380919084e-09,   7.048603375272018e-10,
  -1.956452018503518e-11,   2.373892440168380e-13,   1.692202442449677e-15,  -7.077328450001323e-17,   3.532873394267890e-18,  -4.837341396165489e-20,  -1.768389427349854e-21,
   2.036574629765415e-24,   3.886505106897154e-25,  -3.408476276179080e-03,   1.034444838666797e-04,  -1.494475061885749e-06,   7.649583349769002e-10,   5.142983103226690e-10,
  -1.427004768969089e-11,   1.730888269288847e-13,   1.239206581763854e-15,  -5.170861701066311e-17,   2.573374326926734e-18,  -3.528062414537460e-20,  -1.288811819657559e-21,
   1.560266558615674e-24,   2.826127568115517e-25,  -2.206216811740645e-03,   6.695592396159324e-05,  -9.672508006925406e-07,   4.919485149861865e-10,   3.329445515569818e-10,
  -9.235900954947733e-12,   1.120017585372180e-13,   8.041550040111121e-16,  -3.350451976648220e-17,   1.664073168517569e-18,  -2.283344648495954e-20,  -8.337117029986833e-22,
   1.041781925530125e-24,   1.825455949994071e-25,  -1.183479302313885e-03,   3.591685307236409e-05,  -5.188386505483158e-07,   2.630171655475322e-10,   1.786157549018610e-10,
  -4.954207928536816e-12,   6.007163198918068e-14,   4.319365695638635e-16,  -1.798241790239102e-17,   8.922157815765526e-19,  -1.224775689685163e-20,  -4.470891535538688e-22,
   5.676093003626842e-25,   9.781770961783078e-26,  -4.404057921020336e-04,   1.336563253927389e-05,  -1.930714126672736e-07,   9.776228021274102e-11,   6.646980872330702e-11,
  -1.843573625343700e-12,   2.235311999847737e-14,   1.608087654543515e-16,  -6.693006283940164e-18,   3.319612641588603e-19,  -4.557632762751437e-21,  -1.663565003338692e-22,
   2.123582102268636e-25,   3.638710871211066e-26,  -4.974727513416384e-05,   1.509752006022400e-06,  -2.180887113270971e-08,   1.104097402369138e-11,   7.508317999859966e-12,
  -2.082455808172122e-13,   2.524937741592520e-15,   1.816591617840579e-17,  -7.560496684590431e-19,   3.749659289019756e-20,  -5.148184238447722e-22,  -1.879094574949431e-23,
   2.400785844661790e-26,   4.109964499055705e-27,  -1.371174207468709e-02,   2.702238868591944e-04,   1.432762396695924e-06,  -1.564740918269530e-07,   2.278497775486132e-09,
   2.757014012903198e-11,  -1.701526520837667e-12,   2.236366773177182e-14,   6.066849058240317e-16,  -1.474673312803267e-17,   8.708966574315211e-20,  -1.498139358766798e-22,
  -2.832257617094010e-22,   4.456328069378390e-24,  -1.304475522550219e-02,   2.570661678349024e-04,   1.363476947108014e-06,  -1.488549010863427e-07,   2.166914035363853e-09,
   2.624300731482703e-11,  -1.618258044619610e-12,   2.126010757075417e-14,   5.772875768885403e-16,  -1.402959477204666e-17,   8.230299682293488e-20,  -1.323448066360216e-22,
  -2.689882149523548e-22,   4.228383060891665e-24,  -1.177608838612692e-02,   2.320443659003570e-04,   1.231523561507403e-06,  -1.343656822095273e-07,   1.954977083602512e-09,
   2.371299233643900e-11,  -1.460077390231725e-12,   1.916742661127102e-14,   5.213239853385352e-16,  -1.266543363629995e-17,   7.342325270793032e-20,  -1.032908226381365e-22,
  -2.420950115582129e-22,   3.799383799701742e-24,  -1.002995230853714e-02,   1.976157968595328e-04,   1.049586285273480e-06,  -1.144294710257060e-07,   1.663867653372286e-09,
   2.021976768854716e-11,  -1.242758778581284e-12,   1.629953720814202e-14,   4.442074538724610e-16,  -1.078768869503375e-17,   6.163644347697568e-20,  -7.135990014082676e-23,
  -2.054439463267131e-22,   3.217763115767946e-24,  -7.977289334431691e-03,   1.571564934315589e-04,   8.353026144453453e-07,  -9.100127077043209e-08,   1.322402970807622e-09,
   1.609938480344297e-11,  -9.877899395015315e-13,   1.294387783127754e-14,   3.534400805882267e-16,  -8.580126820867256e-18,   4.832914047402533e-20,  -4.397012832862950e-23,
  -1.628180864229562e-22,   2.545179121461001e-24,  -5.819031964728854e-03,   1.146280300591847e-04,   6.096153803711375e-07,  -6.637507719407393e-08,   9.640692890365411e-10,
   1.175406161759710e-11,  -7.201704329408117e-13,   9.430211765069467e-15,   2.578990979670737e-16,  -6.258859708881247e-18,   3.484711666345808e-20,  -2.458307552297739e-23,
  -1.184265978408713e-22,   1.848338609919538e-24,  -3.766435429154106e-03,   7.419014661488480e-05,   3.947105877201700e-07,  -4.295955964938561e-08,   6.237666635459932e-10,
   7.612383763514053e-12,  -4.659791645676893e-13,   6.098810243074437e-15,   1.669631611064467e-16,  -4.051152115790241e-18,   2.238155885003129e-20,  -1.271491401557232e-23,
  -7.650726459072890e-23,   1.192839572788386e-24,  -2.020406831749288e-03,   3.979623706563266e-05,   2.117680923308291e-07,  -2.304386272216370e-08,   3.345378553339793e-10,
   4.084686800360770e-12,  -2.499185395051773e-13,   3.270170752083159e-15,   8.957267623245281e-17,  -2.173144099947367e-18,   1.195821548066263e-20,  -5.941119598544765e-24,
  -4.100022437907439e-23,   6.388995623170758e-25,  -7.518474483089412e-04,   1.480909614264018e-05,   7.880921197644095e-08,  -8.575149693852397e-09,   1.244819880625361e-10,
   1.520179319677788e-12,  -9.299568669343890e-14,   1.216739539000580e-15,   3.333363232867086e-17,  -8.086861123232336e-19,   4.443784217018230e-21,  -2.097008774367300e-24,
  -1.525208584485353e-23,   2.376262598359324e-25,  -8.492699841735447e-05,   1.672799561402965e-06,   8.902194638187723e-09,  -9.686280592437109e-10,   1.406105330924573e-11,
   1.717188731890243e-13,  -1.050448182653357e-14,   1.374369646783761e-16,   3.765314471275367e-18,  -9.134738458146966e-20,   5.018489786837469e-22,  -2.348331942944128e-25,
  -1.722748237884689e-24,   2.683948157031311e-26,  -1.741931767355311e-02,   3.295605686065079e-05,   1.050010323822564e-05,  -8.472265213306978e-08,  -6.054209426299168e-09,
   9.024627028012281e-11,   3.082071250879835e-12,  -7.810388755419988e-14,  -1.046264521909088e-15,   7.427468258037190e-17,   3.266707118038808e-19,  -6.045080668267632e-20,
  -1.970101599202767e-22,   3.782233077116737e-23,  -1.657172573757797e-02,   3.134555831890431e-05,   9.988298160853549e-06,  -8.057503310027427e-08,  -5.758359562329006e-09,
   8.580827047180605e-11,   2.931289820682446e-12,  -7.422606731322094e-14,  -9.949399778314308e-16,   7.056392275125342e-17,   3.103962035948149e-19,  -5.742362759754849e-20,
  -1.872999665003461e-22,   3.591810184734384e-23,  -1.495963634749815e-02,   2.828526172550757e-05,   9.015224967993965e-06,  -7.269665719622566e-08,  -5.196177502749773e-09,
   7.738642957611861e-11,   2.644839981199164e-12,  -6.688219636345386e-14,  -8.974919612216586e-16,   6.354567184243537e-17,   2.795971389807974e-19,  -5.170108966663842e-20,
  -1.688811345932367e-22,   3.232245983673441e-23,  -1.274103045820751e-02,   2.407904249182017e-05,   7.676753375679013e-06,  -6.187404879471117e-08,  -4.423481336257812e-09,
   6.583296092537080e-11,   2.251260494187872e-12,  -5.683648064042469e-14,  -7.637088949599877e-16,   5.396330831698529e-17,   2.375097182628114e-19,  -4.389331897217256e-20,
  -1.436295583169014e-22,   2.742452111194013e-23,  -1.013321264708233e-02,   1.914182160154697e-05,   6.104359601769417e-06,  -4.917792194491284e-08,  -3.516490238559899e-09,
   5.229930076173790e-11,   1.789446326659201e-12,  -4.510562524190778e-14,  -6.068701225115699e-16,   4.279628867261423e-17,   1.884171125720684e-19,  -3.480129861343882e-20,
  -1.140720473539832e-22,   2.173097874632461e-23,  -7.391479569697796e-03,   1.395749637444232e-05,   4.452047867629148e-06,  -3.585321106132341e-08,  -2.564097933125663e-09,
   3.811407085549234e-11,   1.304673223996385e-12,  -3.284415541065713e-14,  -4.423625126249075e-16,   3.114544008301099e-17,   1.371557731259470e-19,  -2.532181351462556e-20,
  -8.311340872237158e-23,   1.580416160226490e-23,  -4.784138914106420e-03,   9.031797986283423e-06,   2.881307445742170e-06,  -2.319801889322685e-08,  -1.659212128548832e-09,
   2.465454023063362e-11,   8.441919861711061e-13,  -2.123392292369210e-14,  -2.861880347791141e-16,   2.012835938001157e-17,   8.865380871530931e-20,  -1.636250933735062e-20,
  -5.375471607240811e-23,   1.020914822070115e-23,  -2.566305131154771e-03,   4.844226454345261e-06,   1.545511437144821e-06,  -1.244166783046828e-08,  -8.899230378755921e-10,
   1.322109660875688e-11,   4.527698195810255e-13,  -1.138355182153603e-14,  -1.534806711418925e-16,   1.078883575438423e-17,   4.752248791662134e-20,  -8.769723788969890e-21,
  -2.882389755253905e-23,   5.470853507416999e-24,  -9.549879122734978e-04,   1.802582386560098e-06,   5.751143273727030e-07,  -4.629578489213837e-09,  -3.311488453301456e-10,
   4.919380816319447e-12,   1.684780361793767e-13,  -4.235239032900294e-15,  -5.710940982161576e-17,   4.013713700333426e-18,   1.768004418087302e-20,  -3.262475168295051e-21,
  -1.072466178065297e-23,   2.035128630215875e-24,  -1.078732367771402e-04,   2.036141521012762e-07,   6.496341002063470e-08,  -5.229414236096546e-10,  -3.740555469395794e-11,
   5.556724705351571e-13,   1.903072600898271e-14,  -4.783872189016256e-16,  -6.450863594221982e-18,   4.533603515714630e-19,   1.997020180291689e-21,  -3.685044126381933e-22,
  -1.211407127587614e-24,   2.298706110301214e-25,  -1.495461247501248e-02,  -3.950100724439197e-04,   4.033682901705335e-06,   3.714146779520246e-07,   2.602254550479835e-09,
  -2.640729564538519e-10,  -6.359942428722063e-12,   1.218717185659417e-13,   7.588559429097549e-15,   3.544332905213175e-17,  -5.412268539874628e-18,  -1.199957566364990e-19,
   2.078880875424942e-21,   1.214131427589177e-22,  -1.422709459614149e-02,  -3.757636764116578e-04,   3.837940544357815e-06,   3.532706715243994e-07,   2.472867844580222e-09,
  -2.511521010837323e-10,  -6.044316976826080e-12,   1.159804442431634e-13,   7.212242005651875e-15,   3.352580218850560e-17,  -5.144926228763688e-18,  -1.138811640610762e-19,
   1.978558399038079e-21,   1.152430441232545e-22,  -1.284332235516527e-02,  -3.391682682101597e-04,   3.465429895205012e-06,   3.187905661052213e-07,   2.227906569659960e-09,
  -2.266061382399137e-10,  -5.446520747879503e-12,   1.047594110311923e-13,   6.499380745135307e-15,   2.995774416533671e-17,  -4.638070352640542e-18,  -1.023643397795363e-19,
   1.787390327960617e-21,   1.036150202003887e-22,  -1.093881828207159e-02,  -2.888250065746622e-04,   2.952351920661857e-06,   2.713944882164733e-07,   1.892966202950326e-09,
  -1.928815875736965e-10,  -4.628678521849975e-12,   8.928586312076602e-14,   5.523898625166509e-15,   2.519986491097325e-17,  -3.943662644853537e-18,  -8.673265220726517e-20,
   1.523624260791085e-21,   8.781953954337901e-23,  -8.700059784941760e-03,  -2.296758482306793e-04,   2.348736564446085e-06,   2.157551368884992e-07,   1.502024574695789e-09,
  -1.533120897656957e-10,  -3.673505772558841e-12,   7.105918307425754e-14,   4.384338725414793e-15,   1.979954765472903e-17,  -3.131416229697446e-18,  -6.863354896692960e-20,
   1.212761771444244e-21,   6.951453165451138e-23,  -6.346202008552429e-03,  -1.675134018602666e-04,   1.713633560314200e-06,   1.573252214644474e-07,   1.093573786947154e-09,
  -1.117772482157481e-10,  -2.675001820789923e-12,   5.186093907977162e-14,   3.192826450899314e-15,   1.430032471737187e-17,  -2.281175786354902e-18,  -4.986018542294585e-20,
   8.851957589981533e-22,   5.051243355431149e-23,  -4.107628912034171e-03,  -1.084148879565722e-04,   1.109317833058552e-06,   1.018060529273078e-07,   7.069403524626348e-10,
  -7.232505830670253e-11,  -1.729444484661795e-12,   3.357900995467681e-14,   2.064316199609923e-15,   9.195247766328930e-18,  -1.475218785883588e-18,  -3.218526448163398e-20,
   5.731830865061556e-22,   3.261152118765718e-23,  -2.203424802072845e-03,  -5.815358224950257e-05,   5.951058129712438e-07,   5.460447254728978e-08,   3.789753970383116e-10,
  -3.879027918839605e-11,  -9.271702272647257e-13,   1.801572768619075e-14,   1.106721864024785e-15,   4.915823595536354e-18,  -7.909851715055098e-19,  -1.724092680822014e-20,
   3.075319200473691e-22,   1.747070047695188e-23,  -8.199524978157064e-04,  -2.164014419635080e-05,   2.214601025374410e-07,   2.031891119179822e-08,   1.409952307308168e-10,
  -1.443404251572119e-11,  -3.449542121576893e-13,   6.704540082561357e-15,   4.117596067691519e-16,   1.827143930462734e-18,  -2.943004054292856e-19,  -6.412700040230576e-21,
   1.144489369561557e-22,   6.498349641962113e-24,  -9.261997681872796e-05,  -2.444415612688998e-06,   2.501573065324443e-08,   2.295162882505106e-09,   1.592593707094879e-11,
  -1.630421623368118e-12,  -3.896398658578160e-14,   7.573370524240238e-16,   4.650998430579051e-17,   2.063512618359475e-19,  -3.324268180297358e-20,  -7.243084468092046e-22,
   1.292803938286026e-23,   7.339858249583468e-25,  -4.938803452469161e-03,  -3.040314428642939e-04,  -1.082859876141610e-05,  -2.470551781172108e-07,  -2.043675399584680e-09,
   1.183024251621767e-10,   6.973376629991076e-12,   2.059126430797761e-13,   3.132794571151194e-15,  -3.230596048276544e-17,  -3.758254323387335e-18,  -1.283550409679389e-19,
  -2.402347337097367e-21,  -3.554765648363759e-24,  -4.698900884426327e-03,  -2.892652196541173e-04,  -1.030224906450803e-05,  -2.350027664810008e-07,  -1.941150716955116e-09,
   1.126765426817704e-10,   6.636768096257447e-12,   1.958609638379300e-13,   2.975348430896429e-15,  -3.094451319190930e-17,  -3.580116378130802e-18,  -1.221172138038419e-19,
  -2.281119917069969e-21,  -3.173376029654553e-24,  -4.242448034171674e-03,  -2.611692613899093e-04,  -9.300926602713941e-06,  -2.120921200653511e-07,  -1.747403563225438e-09,
   1.019232639907916e-10,   5.995446586833508e-12,   1.767558620404960e-13,   2.677918510417537e-15,  -2.826957204431539e-17,  -3.239369842563357e-18,  -1.102492918729974e-19,
  -2.052290155034608e-21,  -2.532447768091962e-24,  -3.613940474152097e-03,  -2.224811769391929e-04,  -7.922442449175391e-06,  -1.805862987078397e-07,  -1.483190473256650e-09,
   8.702143669360201e-11,   5.110705325740135e-12,   1.504880332246065e-13,   2.272525478398770e-15,  -2.442240216036155e-17,  -2.766684704007821e-18,  -9.390959471068898e-20,
  -1.740762575193874e-21,  -1.814379365138755e-24,  -2.874763820728344e-03,  -1.769786927124125e-04,  -6.301581293634430e-06,  -1.435844826616382e-07,  -1.175702112052014e-09,
   6.937521387816810e-11,   4.068058629966695e-12,   1.196443773935638e-13,   1.801014016720207e-15,  -1.969034868031444e-17,  -2.206359779001051e-18,  -7.469593822137089e-20,
  -1.378912202231573e-21,  -1.178301719799954e-24,  -2.097247505906103e-03,  -1.291141229811523e-04,  -4.596976291257699e-06,  -1.047116438994233e-07,  -8.552943390432152e-10,
   5.070150129205154e-11,   2.969365918694907e-12,   8.724746489971453e-14,   1.309964389534518e-15,  -1.451947956133287e-17,  -1.612880004042036e-18,  -5.448959671915304e-20,
  -1.002545078572824e-21,  -7.037939333258697e-25,  -1.357575233488124e-03,  -8.357789578466939e-05,  -2.975569360839434e-06,  -6.776467519314805e-08,  -5.526059618205797e-10,
   3.285808352168354e-11,   1.922776897190811e-12,   5.646027281484501e-14,   8.462690091414021e-16,  -9.464776516237063e-18,  -1.045428861675201e-18,  -3.527002171449349e-20,
  -6.474924726385852e-22,  -3.888955185109411e-25,  -7.282657613554785e-04,  -4.483520869274019e-05,  -1.596201198707577e-06,  -3.634753553986558e-08,  -2.961575250421362e-10,
   1.763714943956619e-11,   1.031649785398162e-12,   3.028343186327983e-14,   4.535124061009908e-16,  -5.095557745644705e-18,  -5.611988372276163e-19,  -1.891994442558187e-20,
  -3.469397302388993e-22,  -1.902470521837107e-25,  -2.710110191073949e-04,  -1.668464115342843e-05,  -5.939935835372755e-07,  -1.352549275704946e-08,  -1.101726940237415e-10,
   6.564716319242362e-12,   3.839337357118275e-13,   1.126885762720932e-14,   1.687062269068209e-16,  -1.898579631327828e-18,  -2.088896119900092e-19,  -7.040649172425247e-21,
  -1.290548938100765e-22,  -6.841681428348964e-26,  -3.061286462459100e-05,  -1.884664239688198e-06,  -6.709625945429754e-08,  -1.527802138599708e-09,  -1.244422458213450e-11,
   7.415617936153281e-13,   4.336881624030403e-14,   1.272897345808135e-15,   1.905563882278070e-17,  -2.145020621788580e-19,  -2.359664226175845e-20,  -7.952964691703023e-22,
  -1.457684247192862e-23,  -7.685560520048205e-27,  -3.060555457800289e-04,   1.137448503604898e-05,  -2.816746772410252e-07,   5.710104395874648e-09,  -1.055404020981727e-10,
   1.764396143042036e-12,  -2.507767412472203e-14,   5.598239577480041e-16,  -3.443238067414179e-18,  -1.947843290190373e-21,  -6.122694026380077e-21,  -4.569347117562375e-23,
   2.082858076605835e-24,   6.335084706019680e-26,  -2.911773050626112e-04,   1.082173662653115e-05,  -2.679927816866463e-07,   5.432888664234029e-09,  -1.004180766716525e-10,
   1.678924834346759e-12,  -2.386080076343059e-14,   5.325913485964403e-16,  -3.283915796635918e-18,  -1.926414092216552e-21,  -5.820808681092494e-21,  -4.332472577007361e-23,
   1.980512619599256e-24,   6.021716658858371e-26,  -2.628737953340427e-04,   9.770139331760489e-06,  -2.419606096415864e-07,   4.905379512858891e-09,  -9.067028658030809e-11,
   1.516206688245834e-12,  -2.154499552020075e-14,   4.807927917775056e-16,  -2.977543502708831e-18,  -1.855523888849515e-21,  -5.248247858298646e-21,  -3.887869217003911e-23,
   1.786269741800711e-24,   5.427815800842515e-26,  -2.239107356491083e-04,   8.322337741585090e-06,  -2.061155433086540e-07,   4.178911358083557e-09,  -7.724478418063385e-11,
   1.291968938638073e-12,  -1.835527641057341e-14,   4.095001309268532e-16,  -2.549421914106895e-18,  -1.699857972884455e-21,  -4.463399900839854e-21,  -3.287462575674488e-23,
   1.519741501287998e-24,   4.614535136416278e-26,  -1.780985295410464e-04,   6.619835786278919e-06,  -1.639583306042759e-07,   3.324372390417612e-09,  -6.145099088241426e-11,
   1.028012977910482e-12,  -1.460262777389402e-14,   3.256931954893307e-16,  -2.037998357178217e-18,  -1.443819782207311e-21,  -3.544820811933922e-21,  -2.596222658055698e-23,
   1.207448066942316e-24,   3.663670391156672e-26,  -1.299209083122373e-04,   4.829244491974042e-06,  -1.196140710417853e-07,   2.425367748265566e-09,  -4.483399726267049e-11,
   7.501481422457106e-13,  -1.065413409890178e-14,   2.375759543104134e-16,  -1.492679558981249e-18,  -1.106956222752922e-21,  -2.582756172296326e-21,  -1.882982502631066e-23,
   8.800303011835722e-25,   2.668675131957051e-26,  -8.409578695144464e-05,   3.125958064655541e-06,  -7.742787345182267e-08,   1.570020460594215e-09,  -2.902299324824454e-11,
   4.856550625618398e-13,  -6.896975360030352e-15,   1.537733755539726e-16,  -9.687452955131617e-19,  -7.394182432317996e-22,  -1.670430713433663e-21,  -1.214152684504884e-23,
   5.692940452819700e-25,   1.725717419502911e-26,  -4.511183088226045e-05,   1.676887250100213e-06,  -4.153591190288524e-08,   8.422445887673221e-10,  -1.556964551243187e-11,
   2.605482330763006e-13,  -3.699969966712585e-15,   8.248763595030155e-17,  -5.203719422066602e-19,  -4.029470649023416e-22,  -8.957046182970840e-22,  -6.500260161411496e-24,
   3.052963964653174e-25,   9.252731936236486e-27,  -1.678742592343397e-05,   6.240208273538072e-07,  -1.545684873797545e-08,   3.134279331809446e-10,  -5.794012786378599e-12,
   9.696100324556743e-14,  -1.376892306229310e-15,   3.069584192294728e-17,  -1.937367364978440e-19,  -1.507634113192376e-22,  -3.332697191344652e-22,  -2.417269952036968e-24,
   1.135977519914777e-25,   3.442615718987465e-27,  -1.896271820483645e-06,   7.048810180889456e-08,  -1.745974925730373e-09,   3.540422591778862e-11,  -6.544810146565642e-13,
   1.095256936131704e-14,  -1.555312791124565e-16,   3.467333066214715e-18,  -2.188572282825528e-20,  -1.704451984338181e-23,  -3.764457523044920e-23,  -2.730197937025023e-25,
   1.283154603450879e-26,   3.888598612166493e-28,  -2.694398878080207e-03,   9.448096057398399e-05,  -2.093892576631988e-06,   3.475425437988682e-08,  -4.590941612980273e-10,
   3.681326878932839e-12,   3.878425109334463e-14,   2.659858018409785e-17,   5.705813349866322e-17,  -1.356916410597203e-18,  -4.004997296589269e-20,  -6.242600868599886e-22,
   2.101149273654942e-23,   6.136719886514903e-25,  -2.563404800032182e-03,   8.988847732248861e-05,  -1.992126801432001e-06,   3.306489047003729e-08,  -4.367461934363105e-10,
   3.502275651016060e-12,   3.694496502767104e-14,   2.384562887593547e-17,   5.422956171897857e-17,  -1.291922732387468e-18,  -3.806083316207847e-20,  -5.924794740579831e-22,
   1.997754415897514e-23,   5.833292290722848e-25,  -2.314213909552430e-03,   8.115179448870991e-05,  -1.798523522091260e-06,   2.985108451299743e-08,  -3.942449066787090e-10,
   3.161694754340459e-12,   3.342719249448179e-14,   1.920080078148439e-17,   4.887101600279182e-17,  -1.167884837065160e-18,  -3.429399968102305e-20,  -5.326064065004926e-22,
   1.801579783730855e-23,   5.258180405730514e-25,  -1.971182922736169e-03,   6.912433785398131e-05,  -1.531986960494092e-06,   2.542679756490453e-08,  -3.357606489048286e-10,
   2.692916484553990e-12,   2.854814409641640e-14,   1.395627214549730e-17,   4.153764467957231e-17,  -9.963645178582601e-19,  -2.914181521955280e-20,  -4.513159092909214e-22,
   1.532518012972388e-23,   4.470530273552922e-25,  -1.567863586658661e-03,   5.498212003719533e-05,  -1.218572784442687e-06,   2.022464442163399e-08,  -2.670257244503270e-10,
   2.141825254307991e-12,   2.276541581708610e-14,   9.247153165390981e-18,   3.296984646928648e-17,  -7.937264477412717e-19,  -2.312604825637015e-20,  -3.571657736490372e-22,
   1.217405748478485e-23,   3.549504881970235e-25,  -1.143730514303694e-03,   4.010922658152681e-05,  -8.889534851401669e-07,   1.475375877768019e-08,  -1.947698534286458e-10,
   1.562366709096985e-12,   1.664129711219532e-14,   5.655545696445333e-18,   2.401053422744375e-17,  -5.797285900717478e-19,  -1.683887219657243e-20,  -2.594854480726630e-22,
   8.871736373128391e-24,   2.585613412647121e-25,  -7.403153104892545e-04,   2.596224126599863e-05,  -5.754135338217266e-07,   9.549923582746278e-09,  -1.260618904457236e-10,
   1.011265035584333e-12,   1.078625823612360e-14,   3.194216551448478e-18,   1.552429562778641e-17,  -3.755540042969732e-19,  -1.088615005029329e-20,  -1.675065708123265e-22,
   5.738660855588609e-24,   1.672047231985727e-25,  -3.971292104415053e-04,   1.392707081804157e-05,  -3.086734583264212e-07,   5.122915018752187e-09,  -6.762122259843443e-11,
   5.424683519286015e-13,   5.790135777241936e-15,   1.584921460729551e-18,   8.322981414365077e-18,  -2.015437251892554e-19,  -5.836012258332724e-21,  -8.973109857366554e-23,
   3.077347242970768e-24,   8.965086765902574e-26,  -1.477832117058864e-04,   5.182674371003035e-06,  -1.148666586124166e-07,   1.906387447116681e-09,  -2.516348291936469e-11,
   2.018671677072688e-13,   2.155198838856886e-15,   5.731408373124690e-19,   3.096605178267467e-18,  -7.501113997487968e-20,  -2.171272541121856e-21,  -3.337535422697149e-23,
   1.145032754413294e-24,   3.335608234660517e-26,  -1.669327397165405e-05,   5.854239443214761e-07,  -1.297509766842048e-08,   2.153414877161782e-10,  -2.842407199607795e-12,
   2.280246485182282e-14,   2.434559961619487e-16,   6.444222160308248e-20,   3.497748281819572e-19,  -8.473292819546836e-21,  -2.452537544849540e-22,  -3.769718441548391e-24,
   1.293379887661163e-25,   3.767731273837333e-27,  -7.111275293183904e-03,   2.159296560808153e-04,  -3.404906566707650e-06,   1.642838779594438e-08,   6.404604842836962e-10,
  -2.313229849231318e-11,   4.617473785005784e-13,   1.617793560754893e-15,   8.539552382250031e-18,   3.278674700472220e-19,  -1.941983073209587e-19,  -1.413671251800075e-21,
   7.337782330475504e-23,   1.577702059925908e-24,  -6.765481576206946e-03,   2.054282184213935e-04,  -3.239176039511150e-06,   1.562243149247883e-08,   6.095142118990862e-10,
  -2.200612425970505e-11,   4.392934620733497e-13,   1.539438841445702e-15,   7.865551456240140e-18,   3.096431033461740e-19,  -1.846087094008593e-19,  -1.341278768522198e-21,
   6.978585517691245e-23,   1.498925857531698e-24,  -6.107701760971532e-03,   1.854527059692588e-04,  -2.923984431983676e-06,   1.409220587048779e-08,   5.505672044954413e-10,
  -1.986442445690963e-11,   3.965809893715656e-13,   1.390259680172495e-15,   6.688912981927496e-18,   2.759118971285840e-19,  -1.664266884718368e-19,  -1.205062367067995e-21,
   6.296308938452317e-23,   1.349924864904993e-24,  -5.202265869572928e-03,   1.579576266631909e-04,  -2.490250783509420e-06,   1.199144868354490e-08,   4.692713185181644e-10,
  -1.691742452140607e-11,   3.377875934981013e-13,   1.184664745875662e-15,   5.273486987774974e-18,   2.312869970470110e-19,  -1.415146092779812e-19,  -1.020444260362965e-21,
   5.359062785047832e-23,   1.146459320213538e-24,  -4.137761323219654e-03,   1.256337740669841e-04,  -1.980480792959570e-06,   9.528718256153543e-09,   3.734968209421952e-10,
  -1.345402762533652e-11,   2.686662860380206e-13,   9.426399194621764e-16,   3.867497904655156e-18,   1.810962179505555e-19,  -1.123720739816117e-19,  -8.070331639859481e-22,
   4.259534702758928e-23,   9.092987992440948e-25,  -3.018381005089224e-03,   9.164511481271716e-05,  -1.444583733082194e-06,   6.945644074973430e-09,   2.726019807889928e-10,
  -9.813338116897743e-12,   1.959831023346910e-13,   6.878536250763956e-16,   2.629300334357272e-18,   1.304268002848010e-19,  -8.186339942224550e-20,  -5.860064477409730e-22,
   3.105501565540000e-23,   6.618066987774150e-25,  -1.953721164949957e-03,   5.931903370267714e-05,  -9.349902741493870e-07,   4.493476566133850e-09,   1.765109819880486e-10,
  -6.351496885131242e-12,   1.268542009034620e-13,   4.453253601066531e-16,   1.619845582677725e-18,   8.370599880234346e-20,  -5.294153818862335e-20,  -3.781528621950184e-22,
   2.009386379545690e-23,   4.277310128284453e-25,  -1.048033997186888e-03,   3.182034757031136e-05,  -5.015421989458767e-07,   2.409811039709445e-09,   9.470298932732569e-11,
  -3.407013735179864e-12,   6.804816231739413e-14,   2.389118570212071e-16,   8.463438507831436e-19,   4.470542675152147e-20,  -2.838658878804171e-20,  -2.025346749557077e-22,
   1.077695470196487e-23,   2.292718192158133e-25,  -3.900028984923415e-04,   1.184122703703418e-05,  -1.866360894304166e-07,   8.966776953320738e-10,   3.524387910197779e-11,
  -1.267830306039894e-12,   2.532260745195168e-14,   8.890919183217660e-17,   3.120230509136047e-19,   1.661065177184567e-20,  -1.056178657318911e-20,  -7.532770197081966e-23,
   4.010150455279514e-24,   8.529574238360270e-26,  -4.405387624997995e-05,   1.337558833397938e-06,  -2.108197207977746e-08,   1.012853088992273e-10,   3.981111740833362e-12,
  -1.432110712713922e-13,   2.860386006825539e-15,   1.004304876215112e-17,   3.519301069688691e-20,   1.875846089631764e-21,  -1.193006592992416e-21,  -8.508115429738051e-24,
   4.529732360107652e-25,   9.634413359206236e-27,  -1.261890087010795e-02,   2.748236684136489e-04,  -2.145184244064251e-07,  -1.175793996132327e-07,   2.481586369518532e-09,
  -4.029171313878317e-12,  -8.796366057757925e-13,   3.374606963516127e-14,   1.083431590468892e-16,  -1.429502232637263e-17,  -1.050176119134322e-19,  -5.601508803625349e-21,
   7.972592480956114e-23,   7.245868078543873e-24,  -1.200511909644571e-02,   2.614456654795638e-04,  -2.036424719741606e-07,  -1.118614321073556e-07,   2.360489259180583e-09,
  -3.812194885864761e-12,  -8.367613985607338e-13,   3.208928834087381e-14,   1.029340739163437e-16,  -1.360870715633605e-17,  -9.975492989619335e-20,  -5.312360481269023e-21,
   7.568156655531857e-23,   6.885046742199276e-24,  -1.083763444008786e-02,   2.360034548574066e-04,  -1.831348073044478e-07,  -1.009847423455872e-07,   2.130308220884684e-09,
  -3.408028366521964e-12,  -7.552444013039378e-13,   2.894413337502684e-14,   9.270226041397300e-17,  -1.229956259728543e-17,  -8.980799343524728e-20,  -4.769177645190381e-21,
   6.805750257861480e-23,   6.202160504506098e-24,  -9.230725136619995e-03,   2.009935221686873e-04,  -1.552566173172694e-07,  -8.601336183927004e-08,   1.813800123907413e-09,
  -2.868300212931177e-12,  -6.431164808374256e-13,   2.462729217764011e-14,   7.872937943545094e-17,  -1.049055138781594e-17,  -7.623946425992167e-20,  -4.034728363955617e-21,
   5.769611909533810e-23,   5.268881504651929e-24,  -7.341684248611678e-03,   1.598473422911125e-04,  -1.229244737064592e-07,  -6.841232050437077e-08,   1.442113530262415e-09,
  -2.254754387667750e-12,  -5.113913382258648e-13,   1.956787010468381e-14,   6.244209604490542e-17,  -8.354964348328908e-18,  -6.044279070901428e-20,  -3.187973047039259e-21,
   4.568131869200604e-23,   4.180096976247457e-24,  -5.355423818182626e-03,   1.165934459796109e-04,  -8.933917445053802e-08,  -4.990445059523511e-08,   1.051663614089609e-09,
  -1.629143297908777e-12,  -3.729702169276270e-13,   1.426239053829904e-14,   4.544568294222794e-17,  -6.101166450592936e-18,  -4.397624844170386e-20,  -2.313122111742776e-21,
   3.320122318410395e-23,   3.043025388906858e-24,  -3.466374193996683e-03,   7.546338657292651e-05,  -5.768551812084361e-08,  -3.230169821701409e-08,   6.805791612992541e-10,
  -1.047817919748754e-12,  -2.413818901674087e-13,   9.226623156091233e-15,   2.937137725844326e-17,  -3.951882436544025e-18,  -2.841557770652458e-20,  -1.491920611568164e-21,
   2.143833983985219e-23,   1.967010859504854e-24,  -1.859450733498743e-03,   4.047953720484229e-05,  -3.090525933651934e-08,  -1.732753888099388e-08,   3.650454141642751e-10,
  -5.602394967803213e-13,  -1.294755329999794e-13,   4.948040321092489e-15,   1.574344101624381e-17,  -2.120664052679303e-18,  -1.522943993533504e-20,  -7.988501196280398e-22,
   1.148588250480535e-23,   1.054430675160508e-24,  -6.919518934127212e-04,   1.506340971843690e-05,  -1.149566891493028e-08,  -6.448057551218011e-09,   1.358388066853849e-10,
  -2.082424207182536e-13,  -4.818033478862167e-14,   1.841124247123512e-15,   5.856992355473247e-18,  -7.892566635326478e-19,  -5.665552390904806e-21,  -2.970854806774729e-22,
   4.272372338358637e-24,   3.922884920738516e-25,  -7.816134037440745e-05,   1.701526956094927e-06,  -1.298435215890630e-09,  -7.283583910097348e-10,   1.534396822193337e-11,
  -2.351833555708314e-14,  -5.442324870565218e-15,   2.079661396333874e-16,   6.615646765684210e-19,  -8.915446610818699e-20,  -6.399370671284512e-22,  -3.355473830793901e-23,
   4.825647546010875e-25,   4.431035313973033e-26,  -1.712804648849115e-02,   1.114028780505096e-04,   8.972681934025797e-06,  -1.639116851251165e-07,  -3.695879447640870e-09,
   1.366228117079935e-10,   8.166461849603471e-13,  -7.136997152801333e-14,   1.246318396284727e-15,   3.804310427861993e-17,  -1.895793972847157e-18,  -2.824111824609047e-20,
   1.314566949366766e-21,   1.294157044848230e-23,  -1.629466687222015e-02,   1.059696639407920e-04,   8.535589356711773e-06,  -1.558984853443434e-07,  -3.515742556308630e-09,
   1.299330649737122e-10,   7.779473396514644e-13,  -6.785811118825861e-14,   1.183181627921668e-15,   3.614678424122705e-17,  -1.801024111910016e-18,  -2.683748566135914e-20,
   1.248684985803655e-21,   1.230948880867850e-23,  -1.470959269775514e-02,   9.564099183577827e-05,   7.704457552464952e-06,  -1.406729453115480e-07,  -3.173250812833702e-09,
   1.172264785631628e-10,   7.039190386449363e-13,  -6.119464475475989e-14,   1.064115470629088e-15,   3.255848935107295e-17,  -1.621805991124854e-18,  -2.417980952596415e-20,
   1.124164741903099e-21,   1.110825338690830e-23,  -1.252813474631878e-02,   8.143625872298696e-05,   6.561021694751398e-06,  -1.197487069854520e-07,  -2.702140857815785e-09,
   9.977236134921412e-11,   6.012187868477996e-13,  -5.205507422034234e-14,   9.022218254636401e-16,   2.765585561672376e-17,  -1.377154173877402e-18,  -2.054546286824166e-20,
   9.543125072423702e-22,   9.456941991436176e-24,  -9.963942272806685e-03,   6.475209902622706e-05,   5.217489014535469e-06,  -9.519116994335560e-08,  -2.148685307273081e-09,
   7.929806890558286e-11,   4.794675915166888e-13,  -4.135115027461863e-14,   7.144125001562116e-16,   2.193822621285900e-17,  -1.092098905205514e-18,  -1.630293418029983e-20,
   7.565738957524732e-22,   7.518302597954611e-24,  -7.268037949906650e-03,   4.722285396782573e-05,   3.805427437930348e-06,  -6.940747424624905e-08,  -1.567091159288235e-09,
   5.781133868412722e-11,   3.505038983910066e-13,  -3.013384839481903e-14,   5.192701687450376e-16,   1.596893103437424e-17,  -7.947446934282546e-19,  -1.186994562623756e-20,
   5.504551679060378e-22,   5.482316564101161e-24,  -4.704253851877544e-03,   3.056102439853456e-05,   2.462906237980950e-06,  -4.491208598366062e-08,  -1.014203529103594e-09,
   3.740510965278738e-11,   2.271906077367843e-13,  -1.949177434074473e-14,   3.353099197570528e-16,   1.032158754455817e-17,  -5.136017873514339e-19,  -7.673454454515076e-21,
   3.556790548584856e-22,   3.547676356078233e-24,  -2.523456698133387e-03,   1.639242813580013e-05,   1.321107100143283e-06,  -2.408842824759672e-08,  -5.440117431128498e-10,
   2.006116285593154e-11,   1.219593870751068e-13,  -1.045236001380282e-14,   1.796498444686051e-16,   5.532759967079789e-18,  -2.752865625638340e-19,  -4.113608066756646e-21,
   1.906271420982691e-22,   1.902834309346320e-24,  -9.390433612633739e-04,   6.099900230093401e-06,   4.916121521964125e-07,  -8.963495698848422e-09,  -2.024372464663857e-10,
   7.464798189404686e-12,   4.539585579216570e-14,  -3.889149931586240e-15,   6.682422497489535e-17,   2.058371560574154e-18,  -1.024127752813847e-19,  -1.530444565045861e-21,
   7.091575326807063e-23,   7.080664371660703e-25,  -1.060721850394411e-04,   6.890281391811857e-07,   5.553127588767162e-08,  -1.012488213014712e-09,  -2.286678334319600e-11,
   8.431979161359231e-13,   5.128020050395627e-15,  -4.393015195649217e-16,   7.547807267067891e-18,   2.324997693657642e-19,  -1.156780221141887e-20,  -1.728695014592219e-22,
   8.010095103864891e-24,   7.998107161883197e-26,  -1.644147471982143e-02,  -3.446523959734220e-04,   8.543681515395561e-06,   3.641583101927653e-07,  -3.788502148604180e-09,
  -3.488474324210078e-10,   2.987596768110147e-13,   3.356615838735929e-13,   4.121268061078103e-15,  -2.361781112009899e-16,  -6.490548728402440e-18,   1.044109587413450e-19,
   6.006485060640377e-21,  -2.238102466342347e-23,  -1.564150296005130e-02,  -3.278561088559990e-04,   8.127438594972320e-06,   3.463424588626299e-07,  -3.604081988130684e-09,
  -3.316710001133074e-10,   2.876095027272750e-13,   3.190832877889832e-13,   3.912219674261952e-15,  -2.245201136742498e-16,  -6.163206177752694e-18,   9.927934961717389e-20,
   5.701224903364737e-21,  -2.137621146743602e-23,  -1.411996911153748e-02,  -2.959208052837708e-04,   7.335972078685226e-06,   3.124966741409980e-07,  -3.253351338398334e-09,
  -2.990843960801141e-10,   2.650163257107071e-13,   2.876520113321149e-13,   3.518098249237816e-15,  -2.024145900886684e-16,  -5.545330119874711e-18,   8.953973988722875e-20,
   5.125961041535780e-21,  -1.942972992810011e-23,  -1.202595684573109e-02,  -2.519910826052100e-04,   6.247144204983466e-06,   2.659932572498123e-07,  -2.770725227721648e-09,
  -2.543972085170968e-10,   2.312451284887639e-13,   2.445890960667814e-13,   2.982425543542980e-15,  -1.721232069686539e-16,  -4.704103737275053e-18,   7.617585793805141e-20,
   4.344551827151013e-21,  -1.668348773104952e-23,  -9.564550191670769e-03,  -2.003807973050762e-04,   4.967824100732984e-06,   2.114280140973244e-07,  -2.203510654742546e-09,
  -2.020720899970874e-10,   1.881740661185335e-13,   1.942165394578015e-13,   2.361266298962793e-15,  -1.366833291542622e-16,  -3.726784726619211e-18,   6.051865482610771e-20,
   3.439006890941779e-21,  -1.337183088036167e-23,  -6.976709386120382e-03,  -1.461445397567779e-04,   3.623295583051309e-06,   1.541504601408616e-07,  -1.607245365133228e-09,
  -1.472476835260308e-10,   1.397571747494883e-13,   1.414853316171101e-13,   1.716094506850724e-15,  -9.957777467316486e-17,  -2.709939903811703e-18,   4.410545675009927e-20,
   2.498966254322243e-21,  -9.813698600786617e-24,  -4.515691465113895e-03,  -9.458382035875526e-05,   2.345013369248951e-06,   9.974331771686370e-08,  -1.040262745664285e-09,
  -9.524203892087677e-11,   9.152401633730023e-14,   9.149855857087181e-14,   1.108058545861444e-15,  -6.439905936193981e-17,  -1.750384667506346e-18,   2.853066459318483e-20,
   1.613381557757418e-21,  -6.377302817557261e-24,  -2.422308215811334e-03,  -5.073431204790711e-05,   1.257864886095737e-06,   5.349581517324587e-08,  -5.580094809464455e-10,
  -5.107203022589796e-11,   4.938863567630508e-14,   4.906015538941400e-14,   5.936453144347908e-16,  -3.453039188366818e-17,  -9.379428099622582e-19,   1.529981771988409e-20,
   8.643281029549680e-22,  -3.427864055359360e-24,  -9.014034248524691e-04,  -1.887924145522331e-05,   4.680778201099161e-07,   1.990607091313595e-08,  -2.076486303314874e-10,
  -1.900292556855992e-11,   1.841675670758648e-14,   1.825376336306345e-14,   2.208149818037317e-16,  -1.284776393570586e-17,  -3.489034201172116e-19,   5.692859876497754e-21,
   3.214935233400064e-22,  -1.276494672961026e-24,  -1.018204645582728e-04,  -2.132550354488334e-06,   5.287288681667196e-08,   2.248524368158902e-09,  -2.345549347440380e-11,
  -2.146485768263607e-12,   2.080995130690109e-15,   2.061853310678078e-15,   2.494103779103424e-17,  -1.451220151188984e-18,  -3.940901295099619e-20,   6.430416925746298e-22,
   3.631256784654220e-23,  -1.442059960955464e-25,  -6.347423519163832e-03,  -4.028253887842641e-04,  -1.387612690323322e-05,  -2.495945754500478e-07,   2.512213436561431e-09,
   3.637565276848502e-10,   1.368717239225563e-11,   2.455757426659196e-13,  -2.380928476360388e-15,  -3.250630435353419e-16,  -1.133141075176701e-17,  -1.802592113679338e-19,
   2.401408574502620e-21,   2.510018327102097e-22,  -6.039094601253030e-03,  -3.832538814780888e-04,  -1.320072447388669e-05,  -2.373456019336521e-07,   2.396114372183089e-09,
   3.462149600882309e-10,   1.301935527979694e-11,   2.332809685523142e-13,  -2.280238125483269e-15,  -3.095409800121833e-16,  -1.077529021741491e-17,  -1.709043915556672e-19,
   2.306590181453750e-21,   2.391558585477065e-22,  -5.452450730184512e-03,  -3.460176856871616e-04,  -1.191621940419428e-05,  -2.140907523318529e-07,   2.172801880300788e-09,
   3.127869655612619e-10,   1.174991495013671e-11,   2.100367050934348e-13,  -2.082559241367180e-15,  -2.798974143369343e-16,  -9.719441112066282e-18,  -1.533478867216673e-19,
   2.117269181562561e-21,   2.164728249789211e-22,  -4.644680119953878e-03,  -2.947490670919760e-04,  -1.014861331607036e-05,  -1.821687319920033e-07,   1.860633370766579e-09,
   2.666574593813732e-10,   1.000429369261044e-11,   1.783190544318729e-13,  -1.798553718438166e-15,  -2.388674227421378e-16,  -8.270038820536444e-18,  -1.296449041888864e-19,
   1.839335566382742e-21,   1.849633157860567e-22,  -3.694677938764734e-03,  -2.344571948975881e-04,  -8.071130135515919e-06,  -1.447505199121320e-07,   1.487576223291695e-09,
   2.122777515128062e-10,   7.954261724047654e-12,   1.413819124065481e-13,  -1.449604818727068e-15,  -1.903457458681824e-16,  -6.571127508967308e-18,  -1.023662974350039e-19,
   1.490678294783172e-21,   1.475606295717075e-22,  -2.695403445563126e-03,  -1.710420774602005e-04,  -5.887168293344555e-06,  -1.055078201068152e-07,   1.089652390276198e-09,
   1.549589613043491e-10,   5.800683784460655e-12,   1.028700866874343e-13,  -1.068650030891716e-15,  -1.390603234734150e-16,  -4.789496931633995e-18,  -7.423177627684706e-20,
   1.103674119897334e-21,   1.079008832012435e-22,  -1.744768383611320e-03,  -1.107163622319564e-04,  -3.810402075249837e-06,  -6.825674515835286e-08,   7.072316563969728e-10,
   1.003472416833759e-10,   3.753892635613528e-12,   6.647216831241789e-14,  -6.964997995268150e-16,  -9.009908148071851e-17,  -3.098415298171892e-18,  -4.785925878148802e-20,
   7.213309105279483e-22,   6.995185470699881e-23,  -9.359737254165513e-04,  -5.939296827256924e-05,  -2.043954258131979e-06,  -3.660508459357702e-08,   3.799109524561731e-10,
   5.384196871660177e-11,   2.013494327104438e-12,   3.562649525960248e-14,  -3.749423165192015e-16,  -4.835625861658069e-17,  -1.661610474670357e-18,  -2.562100239098059e-20,
   3.888570520145935e-22,   3.755454552135596e-23,  -3.483057750416344e-04,  -2.210197711492952e-05,  -7.606052360666547e-07,  -1.362050350645144e-08,   1.414443016196956e-10,
   2.003775778167076e-11,   7.492512219030209e-13,   1.325358479306807e-14,  -1.396974110202031e-16,  -1.799788517892431e-17,  -6.182707707166722e-19,  -9.527541555262221e-21,
   1.449524463260798e-22,   1.397901918771739e-23,  -3.934392565532110e-05,  -2.496594410156203e-06,  -8.591617167720911e-08,  -1.538519459042420e-09,   1.597847213258518e-11,
   2.263450930543243e-12,   8.463330595623200e-14,   1.497023679381074e-15,  -1.578297682820554e-17,  -2.033058505166664e-18,  -6.983741972438742e-20,  -1.076089236611772e-21,
   1.637795362156493e-23,   1.579109686749052e-24,  -2.646676607155941e-04,   9.368960558267655e-06,  -2.222127431333323e-07,   4.276147640248015e-09,  -7.507241823677371e-11,
   1.336369110744653e-12,  -1.130488251059672e-14,   3.995294955334490e-16,  -8.058287441315216e-18,  -2.469340027033523e-19,  -4.898194501508827e-21,   1.220123699058869e-22,
   4.713175069803201e-24,   4.399403725242214e-26,  -2.518007645443100e-04,   8.913633381140422e-06,  -2.114176458075090e-07,   4.068552474028279e-09,  -7.142593830570155e-11,
   1.271615876063578e-12,  -1.076175435313100e-14,   3.798333416208219e-16,  -7.672807140190307e-18,  -2.347225540049697e-19,  -4.650691201039168e-21,   1.161805944649579e-22,
   4.484421052394564e-24,   4.192373746994758e-26,  -2.273237810420720e-04,   8.047394348047822e-06,  -1.908787038519628e-07,   3.673521312981926e-09,  -6.448786594155519e-11,
   1.148346797862969e-12,  -9.725929135111696e-15,   3.424761870837820e-16,  -6.936930105142587e-18,  -2.115762546602901e-19,  -4.183671703016916e-21,   1.050462687427602e-22,
   4.049093025513281e-24,   3.795598049601819e-26,  -1.936288821409881e-04,   6.854817486180471e-06,  -1.625987135337507e-07,   3.129493958106736e-09,  -5.493443923737871e-11,
   9.784856507969046e-13,  -8.294929533551379e-15,   2.912659517066056e-16,  -5.918961082682866e-18,  -1.798758879512272e-19,  -3.548165730537751e-21,   8.964025449379576e-23,
   3.449514241577947e-24,   3.243853000701577e-26,  -1.540115421746432e-04,   5.452478035542527e-06,  -1.293402185093391e-07,   2.489554289343713e-09,  -4.369865603783674e-11,
   7.785543507709833e-13,  -6.605957222481642e-15,   2.313269073350479e-16,  -4.715809705294794e-18,  -1.428099661672382e-19,  -2.810315739724359e-21,   7.142662657633604e-23,
   2.744174820744372e-24,   2.588341841883620e-26,  -1.123492409966574e-04,   3.977615502312765e-06,  -9.435769659249977e-08,   1.816311438299234e-09,  -3.187993373012168e-11,
   5.681036350915767e-13,  -4.823779808828178e-15,   1.685473345982774e-16,  -3.444744536339822e-18,  -1.040234500573837e-19,  -2.043104412065644e-21,   5.217956869375326e-23,
   2.002092484285822e-24,   1.892878126290183e-26,  -7.272171575481601e-05,   2.574688566105113e-06,  -6.107859760640499e-08,   1.175759645465345e-09,  -2.063634808799607e-11,
   3.677916960884110e-13,  -3.124415132215489e-15,   1.090112767222237e-16,  -2.231699306464789e-18,  -6.726649432780512e-20,  -1.319480101676767e-21,   3.380698452111207e-23,
   1.296026999618552e-24,   1.227215021430302e-26,  -3.901033739434690e-05,   1.381161191672280e-06,  -3.276527088666452e-08,   6.307419746235321e-10,  -1.107030177892732e-11,
   1.973143915171679e-13,  -1.676609176263826e-15,   5.845344425828984e-17,  -1.197701168931701e-18,  -3.606576449186474e-20,  -7.069902481552461e-22,   1.814402313167600e-23,
   6.952610020996191e-25,   6.588613159527084e-27,  -1.451687525165931e-05,   5.139717190034966e-07,  -1.219299439406193e-08,   2.347206479410485e-10,  -4.119616003471979e-12,
   7.342882108548908e-14,  -6.239885475690280e-16,   2.174913383241631e-17,  -4.457696489927064e-19,  -1.341875526427715e-20,  -2.629849827177925e-22,   6.753060900582735e-24,
   2.587304941315772e-25,   2.452513266638588e-27,  -1.639795129944563e-06,   5.805717440571677e-08,  -1.377296123334588e-09,   2.651360089030002e-11,  -4.653436512439166e-13,
   8.294405829314331e-15,  -7.048573186443003e-17,   2.456680288561487e-18,  -5.035444615572381e-20,  -1.515711557787424e-21,  -2.970431047998858e-23,   7.628318172545686e-25,
   2.922570961982425e-26,   2.770431702154259e-28,  -2.347504477834781e-03,   7.927908872467554e-05,  -1.718312931467154e-06,   2.805160538447212e-08,  -3.752677302058539e-10,
   4.770278871121216e-12,   5.533791128554357e-14,   7.300421202991967e-16,  -2.377749223268355e-17,  -3.109149445353012e-18,  -3.547391232971751e-20,   1.024646197232096e-21,
   4.552330057631409e-23,   3.903578356491789e-25,  -2.233372269789730e-03,   7.542543235051974e-05,  -1.634800503716681e-06,   2.668858560019573e-08,  -3.569899830985716e-10,
   4.538691100121152e-12,   5.262619677097484e-14,   6.912165746624499e-16,  -2.266767599330424e-17,  -2.956235150278051e-18,  -3.365908629254240e-20,   9.757219098161942e-22,
   4.331257134512164e-23,   3.720918123500401e-25,  -2.016259108699379e-03,   6.809432451178644e-05,  -1.475923237398694e-06,   2.409539110912626e-08,  -3.222336536302089e-10,
   4.098003211887573e-12,   4.747630923014381e-14,   6.187163061187054e-16,  -2.053752128045326e-17,  -2.666057339758646e-18,  -3.024339421895466e-20,   8.822927650639595e-22,
   3.910598755663100e-23,   3.370403074702411e-25,  -1.717388145048924e-03,   5.800194655042735e-05,  -1.257194728419905e-06,   2.052504655137843e-08,  -2.744150695214742e-10,
   3.491098743079841e-12,   4.040385506124378e-14,   5.215439479404993e-16,  -1.756863011650759e-17,  -2.267987147652627e-18,  -2.561251360590942e-20,   7.529797014346259e-22,
   3.331324659093020e-23,   2.882140153881997e-25,  -1.365993191502905e-03,   4.613514590779415e-05,  -9.999972244548822e-07,   1.632643854101661e-08,  -2.182254916417797e-10,
   2.777201484322536e-12,   3.210971567692435e-14,   4.106184717719448e-16,  -1.403192044073598e-17,  -1.801708459719170e-18,  -2.025774231147935e-20,   6.000496872928208e-22,
   2.649996529225686e-23,   2.301001849944045e-25,  -9.964670544172418e-04,   3.365532310770859e-05,  -7.295015609573790e-07,   1.191044001594513e-08,  -1.591671368431601e-10,
   2.026160795574023e-12,   2.340749098479387e-14,   2.970650541501252e-16,  -1.027001130785660e-17,  -1.313004248914201e-18,  -1.471054640490704e-20,   4.383948711921404e-22,
   1.933291288198009e-23,   1.683487874726859e-25,  -6.449934295496261e-04,   2.178467259742433e-05,  -4.722012947184683e-07,   7.709649760567553e-09,  -1.030153220995867e-10,
   1.311597230961910e-12,   1.514437005035177e-14,   1.912269180436314e-16,  -6.662075587285896e-18,  -8.493213854114946e-19,  -9.493143981945298e-21,   2.840511329686725e-22,
   1.251450929721297e-23,   1.091776374712295e-25,  -3.459951763117257e-04,   1.168606562954885e-05,  -2.533065056475994e-07,   4.135774464210762e-09,  -5.525785505173709e-11,
   7.036112367033131e-13,   8.122041189107403e-15,   1.022890491823451e-16,  -3.577740066587232e-18,  -4.554488282868899e-19,  -5.084520212844597e-21,   1.524532185577868e-22,
   6.713373315408586e-24,   5.862343006920975e-26,  -1.287547296943242e-04,   4.348729044105647e-06,  -9.426295028673815e-08,   1.539049492172822e-09,  -2.056266119888344e-11,
   2.618375947506937e-13,   3.022200255855542e-15,   3.802697695821522e-17,  -1.331896021421014e-18,  -1.694655683011702e-19,  -1.891071694545858e-21,   5.674246146837580e-23,
   2.498263058460631e-24,   2.182281972798657e-26,  -1.454385689753240e-05,   4.912232226745101e-07,  -1.064774577968872e-08,   1.738478797517976e-10,  -2.322707249729015e-12,
   2.957667641432808e-14,   3.413768517663286e-16,   4.294769440217824e-18,  -1.504573584785369e-19,  -1.914210692063653e-20,  -2.135930275618333e-22,   6.409689886782419e-24,
   2.821988474508956e-25,   2.465190476971485e-27,  -6.300582014413633e-03,   1.896219997888183e-04,  -3.159555970459234e-06,   2.359226142597610e-08,   2.923077735063280e-10,
  -1.152030059297211e-11,   5.016057039147114e-13,   5.322405436450143e-16,  -1.230487225566417e-16,  -7.382819439211189e-18,  -1.534341234517477e-19,   3.760074175989301e-21,
   1.361757396512046e-22,   9.797564171660061e-25,  -5.994213483126386e-03,   1.804008207872169e-04,  -3.005821438054128e-06,   2.244130197521846e-08,   2.783131203368272e-10,
  -1.095965408975808e-11,   4.771038454080212e-13,   4.984929951341975e-16,  -1.172666800699214e-16,  -7.017546226897309e-18,  -1.457037000844626e-19,   3.579487377225014e-21,
   1.295645139901012e-22,   9.345278144440288e-25,  -5.411427757484580e-03,   1.628602430469901e-04,  -2.713422340029525e-06,   2.025343880985966e-08,   2.516028868140618e-10,
  -9.893367871033726e-12,   4.305404123878226e-13,   4.375048691519407e-16,  -1.061855407085362e-16,  -6.325257964506220e-18,  -1.311081863699410e-19,   3.235061722791694e-21,
   1.169839753969606e-22,   8.474674175416372e-25,  -4.609218053881579e-03,   1.387160555007606e-04,  -2.311010977101590e-06,   1.724480202372508e-08,   2.146633707960860e-10,
  -8.425989992995975e-12,   3.665327601145466e-13,   3.597643383194954e-16,  -9.077313701071293e-17,  -5.377262610447086e-18,  -1.112298353736159e-19,   2.759191461102491e-21,
   9.965837860900079e-23,   7.256842479198436e-25,  -3.666070354188943e-03,   1.103307682368958e-04,  -1.838000628393658e-06,   1.371135332005983e-08,   1.710156181086463e-10,
  -6.701276384668854e-12,   2.913906696718154e-13,   2.762127641605051e-16,  -7.245230994661438e-17,  -4.268984680397706e-18,  -8.812814881706957e-20,   2.197471027070173e-21,
   7.927859397749462e-23,   5.801114423205400e-25,  -2.674298871967146e-03,   8.048276039680976e-05,  -1.340697219048871e-06,   9.999250503102967e-09,   1.249140476330673e-10,
  -4.888068575615756e-12,   2.124783520278066e-13,   1.956570378590786e-16,  -5.300055942978033e-17,  -3.109421035159487e-18,  -6.408633822212999e-20,   1.604687133053805e-21,
   5.783880865856794e-23,   4.248625855852998e-25,  -1.731006938903725e-03,   5.209425095302109e-05,  -8.677680390129610e-07,   6.471063685104723e-09,   8.092335855093644e-11,
  -3.163784731749118e-12,   1.374962903008272e-13,   1.241511896307945e-16,  -3.436937981883341e-17,  -2.010644810063163e-18,  -4.139562055690611e-20,   1.039398871512301e-21,
   3.744066579257441e-23,   2.757156800267281e-25,  -9.285638581146309e-04,   2.794484930427098e-05,  -4.654879439120871e-07,   3.470940933318714e-09,   4.342888236889551e-11,
  -1.697110318306749e-12,   7.374729234992422e-14,   6.591202974917446e-17,  -1.845422219597463e-17,  -1.078017231621248e-18,  -2.218219275258343e-20,   5.577645551693165e-22,
   2.008512474420676e-23,   1.480970119483990e-25,  -3.455447519629290e-04,   1.039905683621040e-05,  -1.732200323205413e-07,   1.291591957468544e-09,   1.616359304941119e-11,
  -6.315375689765692e-13,   2.744217028250568e-14,   2.443883939431932e-17,  -6.869596002926561e-18,  -4.010889578352447e-19,  -8.251554457004762e-21,   2.075858025573759e-22,
   7.474347759923239e-24,   5.513622205226614e-26,  -3.903198192686837e-05,   1.174654642907031e-06,  -1.956653688919208e-08,   1.458946434323085e-10,   1.825848748351597e-12,
  -7.133701832720276e-14,   3.099784907898312e-15,   2.758964923084982e-18,  -7.760151015743353e-19,  -4.530485083924958e-20,  -9.320226833167371e-22,   2.344890424049031e-23,
   8.442879527888881e-25,   6.228517882014226e-27,  -1.153103710558427e-02,   2.681267260391742e-04,  -1.392733017515189e-06,  -7.934387660334775e-08,   2.266294726057458e-09,
  -1.392445070793526e-11,   2.840236195268532e-14,   2.780361086586804e-14,  -5.222056246161311e-16,  -2.112861803124463e-17,  -1.559175036287242e-19,   5.281213063866159e-21,
   3.318979884354901e-22,   2.746286383811326e-24,  -1.097020446772176e-02,   2.550778691303152e-04,  -1.324585736613055e-06,  -7.548865093261005e-08,   2.156072399256539e-09,
  -1.322990849127187e-11,   2.658499843467490e-14,   2.642868049030471e-14,  -4.970086569199708e-16,  -2.009221709539004e-17,  -1.476834627193322e-19,   5.030817497618547e-21,
   3.156576500587690e-22,   2.621328342677606e-24,  -9.903420794497870e-03,   2.302603473241893e-04,  -1.195126224167717e-06,  -6.815390786110297e-08,   1.946412335130440e-09,
  -1.191584233899456e-11,   2.330509157580933e-14,   2.382258729061605e-14,  -4.489973449413221e-16,  -1.812438575872285e-17,  -1.322859057188443e-19,   4.551928226541599e-21,
   2.848059122301937e-22,   2.380031431590334e-24,  -8.435086856564293e-03,   1.961075416502894e-04,  -1.017259097785793e-06,  -5.805527275505877e-08,   1.657831088566778e-09,
  -1.012080021957707e-11,   1.913395918319756e-14,   2.025339403621624e-14,  -3.827540839341204e-16,  -1.542273864828735e-17,  -1.116056147097449e-19,   3.887709063698486e-21,
   2.424182599954556e-22,   2.041016304852119e-24,  -6.708916079765360e-03,   1.559655786135264e-04,  -8.085670847286147e-07,  -4.617954030579523e-08,   1.318572597785337e-09,
  -8.027807424016042e-12,   1.466540435074806e-14,   1.608005220801852e-14,  -3.046780159838364e-16,  -1.225544385718997e-17,  -8.794302378745337e-20,   3.100395116544586e-21,
   1.926850815398423e-22,   1.633910726381919e-24,  -4.893874780487756e-03,   1.137644119680538e-04,  -5.895114023872046e-07,  -3.368886647473275e-08,   9.618453316295917e-10,
  -5.843120830098145e-12,   1.037272605952933e-14,   1.171289942436162e-14,  -2.223968832676932e-16,  -8.933268950545134e-18,  -6.366706713572181e-20,   2.266487542218927e-21,
   1.404826348557022e-22,   1.198013733632038e-24,  -3.167641344742352e-03,   7.363333847363220e-05,  -3.814407226307042e-07,  -2.180687856365385e-08,   6.225709009259562e-10,
  -3.776572983729484e-12,   6.574838788654694e-15,   7.574172760981069e-15,  -1.440126735128179e-16,  -5.779394396948753e-18,  -4.100273515138990e-20,   1.469113273917197e-21,
   9.089841718563091e-23,   7.780403115354076e-25,  -1.699206002580728e-03,   3.949815186033334e-05,  -2.045789320931107e-07,  -1.169811346794622e-08,   3.339635400499497e-10,
  -2.024342969055092e-12,   3.488595155974457e-15,   4.061003538854287e-15,  -7.726938897690470e-17,  -3.099443893971916e-18,  -2.193797641114317e-20,   7.886480375889804e-22,
   4.875167415291769e-23,   4.180755996351688e-25,  -6.323209005026577e-04,   1.469824838633284e-05,  -7.612475230373955e-08,  -4.353229970889848e-09,   1.242769624547534e-10,
  -7.531177000418089e-13,   1.293237550643344e-15,   1.510953543865945e-15,  -2.875627378170933e-17,  -1.153287198964437e-18,  -8.156341376919533e-21,   2.935522435049839e-22,
   1.814071045376980e-23,   1.556696447456808e-25,  -7.142556384776293e-05,   1.660279841116532e-06,  -8.598799543402023e-09,  -4.917319527184985e-10,   1.403804988248949e-11,
  -8.506699719487533e-14,   1.459922612911002e-16,   1.706693547629042e-16,  -3.248284685579411e-18,  -1.302709592387320e-19,  -9.211899509149957e-22,   3.316035013923467e-23,
   2.049114315063977e-24,   1.758575067557424e-26,  -1.655246973833576e-02,   1.745228744035659e-04,   6.742920914702417e-06,  -2.007088274782160e-07,  -9.026713021410507e-10,
   1.374521370601998e-10,  -5.301832739561899e-13,  -2.547611992318146e-14,   1.129000986107815e-15,  -4.313248296946548e-17,  -1.688762952261687e-18,   3.567247839749218e-20,
   1.098875193400447e-21,  -1.490419017810894e-23,  -1.574715192302132e-02,   1.660162015580144e-04,   6.414781429774357e-06,  -1.909054691351924e-07,  -8.589979609023838e-10,
   1.307502988936491e-10,  -5.034679849005697e-13,  -2.428271818560970e-14,   1.071844286094412e-15,  -4.097649805984904e-17,  -1.604466976516214e-18,   3.390352908110015e-20,
   1.045229372600703e-21,  -1.412503847818931e-23,  -1.421542779981521e-02,   1.498427972655330e-04,   5.790688659092440e-06,  -1.722749691985299e-07,  -7.758311056701263e-10,
   1.180091580263817e-10,  -4.530318373589754e-13,  -2.199404625328805e-14,   9.640409180884970e-16,  -3.689922352382582e-17,  -1.445002520847125e-18,   3.055270915821217e-20,
   9.432679014362852e-22,  -1.266533280217889e-23,  -1.210734821047835e-02,   1.275960663995305e-04,   4.931825941773024e-06,  -1.466644574031819e-07,  -6.611776747525235e-10,
   1.004851488424693e-10,  -3.843454429863039e-13,  -1.880781116346601e-14,   8.174327779353483e-16,  -3.133312244324386e-17,  -1.227216544998004e-18,   2.596752453243493e-20,
   8.030837952991702e-22,  -1.069922344127216e-23,  -9.629351777888470e-03,   1.014612448841214e-04,   3.922333487528349e-06,  -1.165982116048056e-07,  -5.261623155902956e-10,
   7.990053526569991e-11,  -3.045237791127547e-13,  -1.501653587745949e-14,   6.473198030544876e-16,  -2.484762491263785e-17,  -9.733425225657099e-19,   2.061101253800213e-20,
   6.384834111345738e-22,  -8.441913312726262e-24,  -7.024018385347511e-03,   7.399803820319213e-05,   2.861040714901579e-06,  -8.502264601203957e-08,  -3.839830677181696e-10,
   5.827165343299965e-11,  -2.214523565100989e-13,  -1.098772368553246e-14,   4.705311087108415e-16,  -1.808220297988391e-17,  -7.084063949022177e-19,   1.501002436719308e-20,
   4.655961289068011e-22,  -6.118368546007652e-24,  -4.546329647978515e-03,   4.789058942783373e-05,   1.851796795751322e-06,  -5.501910208721263e-08,  -2.486118035063756e-10,
   3.771195466866982e-11,  -1.430462166260665e-13,  -7.126418980061798e-15,   3.038491249651203e-16,  -1.168558422501250e-17,  -4.578407938844854e-19,   9.704891915069914e-21,
   3.013000719798791e-22,  -3.943314028098887e-24,  -2.438747928024953e-03,   2.568815460410343e-05,   9.933361492742011e-07,  -2.951005211906630e-08,  -1.333818305640823e-10,
   2.022821152505615e-11,  -7.665325989537758e-14,  -3.826771485821221e-15,   1.627972169264314e-16,  -6.263382272844909e-18,  -2.454086018746421e-19,   5.203045975199953e-21,
   1.616074138466511e-22,  -2.110651149899175e-24,  -9.075216841610831e-04,   9.559053793570238e-06,   3.696453660754986e-07,  -1.098102397065995e-08,  -4.963759754510429e-11,
   7.527278602196659e-12,  -2.851434896144706e-14,  -1.424560495468742e-15,   6.055597981919260e-17,  -2.330118596201939e-18,  -9.129872694736829e-20,   1.935818372293741e-21,
   6.013621203558616e-23,  -7.848296808711185e-25,  -1.025115801814108e-04,   1.079765725717825e-06,   4.175428136401253e-08,  -1.240383618508933e-09,  -5.606998965365444e-12,
   8.502612469551460e-13,  -3.220730750992996e-15,  -1.609244085563696e-16,   6.839815374081933e-18,  -2.631932469227173e-19,  -1.031246203538734e-20,   2.186589867729798e-22,
   6.792811385511276e-24,  -8.864184384873474e-26,  -1.765783987849721e-02,  -2.603649781689691e-04,   1.233003367025101e-05,   2.514640339015365e-07,  -9.894337853578898e-09,
  -2.233299626479402e-10,   9.983258713813447e-12,   2.949818297424455e-13,  -7.268601769988473e-15,  -3.333310999297498e-16,   2.818356480742654e-18,   2.594181171819282e-19,
  -1.141019953594106e-21,  -1.935408245189416e-22,  -1.679859273994149e-02,  -2.476784384084887e-04,   1.172854265338542e-05,   2.391669058822966e-07,  -9.408645059523041e-09,
  -2.122846198726437e-10,   9.491640534252116e-12,   2.802799429013400e-13,  -6.911301973012060e-15,  -3.166977902983992e-16,   2.679068667560325e-18,   2.463591778261620e-19,
  -1.082217966568626e-21,  -1.835322383570646e-22,  -1.516435556981821e-02,  -2.235562781048126e-04,   1.058515279215490e-05,   2.158032111814060e-07,  -8.486606310012110e-09,
  -1.913496105066721e-10,   8.558982045666479e-12,   2.524597426902966e-13,  -6.233206652598475e-15,  -2.852310429107835e-16,   2.415031511196083e-18,   2.217006348951648e-19,
  -9.717109417409138e-22,  -1.647394908731125e-22,  -1.291530798838131e-02,  -1.903725555491277e-04,   9.012795070178032e-06,   1.836977979282917e-07,  -7.221022732003159e-09,
  -1.626791566883616e-10,   7.280043334845753e-12,   2.144479926815411e-13,  -5.302849706228107e-15,  -2.422526968710315e-16,   2.053359523235438e-18,   1.881102149723416e-19,
  -8.222125324641873e-22,  -1.393450225724584e-22,  -1.027175709162576e-02,  -1.513849964027193e-04,   7.166127356058586e-06,   1.460212777182921e-07,  -5.737657376015495e-09,
  -1.291569940427347e-10,   5.782574366331149e-12,   1.701153516287798e-13,  -4.212892047123857e-15,  -1.921473039118793e-16,   1.630382732928976e-18,   1.490614481708703e-19,
  -6.497617447652034e-22,  -1.100844153403272e-22,  -7.492501657892189e-03,  -1.104117828844253e-04,   5.226055937700333e-06,   1.064669573534853e-07,  -4.182068499061496e-09,
  -9.407896689465340e-11,   4.213643677441494e-12,   1.238294083537199e-13,  -3.070326820044120e-15,  -1.398524045907023e-16,   1.187672033371362e-18,   1.084100072956226e-19,
  -4.715102791618608e-22,  -7.986620838104722e-23,  -4.849509894535553e-03,  -7.145846893067693e-05,   3.382080154365933e-06,   6.889134988789646e-08,  -2.705496525202676e-09,
  -6.083619748862302e-11,   2.725425285542281e-12,   8.003841871387049e-14,  -1.986122003651804e-15,  -9.038894235986021e-17,   7.680474744762277e-19,   7.003192314792198e-20,
  -3.041388662178704e-22,  -5.150893428262373e-23,  -2.601367094512417e-03,  -3.833016583325613e-05,   1.814079367598733e-06,   3.694930585954467e-08,  -1.450909310225147e-09,
  -3.261817483734746e-11,   1.461459477957420e-12,   4.290381795902681e-14,  -1.065078170164120e-15,  -4.845044083161252e-17,   4.118102606482791e-19,   3.752894087287493e-20,
  -1.628577051156651e-22,  -2.757966267703621e-23,  -9.680348103572962e-04,  -1.426343682436015e-05,   6.750480485208041e-07,   1.374909041903163e-08,  -5.398724129223257e-10,
  -1.213604608160346e-11,   5.437802677218831e-13,   1.596168094954839e-14,  -3.963019254845286e-16,  -1.802499695523282e-17,   1.532211645770059e-19,   1.396062153878355e-20,
  -6.056618332840700e-23,  -1.025653429055463e-23,  -1.093469743730799e-04,  -1.611161408425704e-06,   7.625156252856514e-08,   1.553053185577971e-09,  -6.098188266990064e-11,
  -1.370823760324442e-12,   6.142297992836670e-14,   1.802924320018299e-15,  -4.476461931592703e-17,  -2.035978764372344e-18,   1.730708024457265e-20,   1.576872599134976e-21,
  -6.840747310159218e-24,  -1.158436862750274e-24,  -8.197859839891601e-03,  -5.244523590179632e-04,  -1.632654952099838e-05,  -1.313388423832276e-07,   1.352642342904484e-08,
   7.518998126489793e-10,   1.704418134315231e-11,  -1.163435517633586e-13,  -2.338467830759832e-14,  -8.374774334412308e-16,  -9.772557883468765e-18,   4.596681150311283e-19,
   2.829952294590450e-20,   6.767570624928422e-22,  -7.799595038466708e-03,  -4.989541079200528e-04,  -1.552998951841391e-05,  -1.247271755690881e-07,   1.287601970407413e-08,
   7.152503254950645e-10,   1.619560857706212e-11,  -1.115756061834339e-13,  -2.225986102655282e-14,  -7.959759250457902e-16,  -9.241734876870873e-18,   4.388491509884022e-19,
   2.691923019512873e-20,   6.416464027996290e-22,  -7.041854438933175e-03,  -4.504489380218316e-04,  -1.401582868652740e-05,  -1.122418316229837e-07,   1.163580726790510e-08,
   6.455693175443643e-10,   1.458945423636780e-11,  -1.021431211843856e-13,  -2.011509857864821e-14,  -7.173433788977513e-16,  -8.254612628079250e-18,   3.986163192044795e-19,
   2.429494783317825e-20,   5.757470677392557e-22,  -5.998534181534195e-03,  -3.836783796121005e-04,  -1.193367933446921e-05,  -9.523324062306227e-08,   9.922858652410996e-09,
   5.497214519303867e-10,   1.239415640719306e-11,  -8.845710457272506e-14,  -1.715304129183978e-14,  -6.097155894608254e-16,  -6.939692381990652e-18,   3.420205609537545e-19,
   2.068558731463726e-20,   4.867667578109702e-22,  -4.771557022923115e-03,  -3.051736308727127e-04,  -9.488392037899312e-06,  -7.546120831739539e-08,   7.901662200970926e-09,
   4.371224107423541e-10,   9.832925474169029e-12,  -7.147962724509253e-14,  -1.365837362303887e-14,  -4.839571086885508e-16,  -5.449259756077116e-18,   2.739545574849938e-19,
   1.644642163727343e-20,   3.843538831671937e-22,  -3.480988870532474e-03,  -2.226184017347490e-04,  -6.919529510369562e-06,  -5.487933083463786e-08,   5.769469760142853e-09,
   3.188015233124114e-10,   7.158086593355366e-12,  -5.280149207435984e-14,  -9.972293283333585e-15,  -3.524454293730953e-16,  -3.933716882835633e-18,   2.009655136392323e-19,
   1.199321392991628e-20,   2.787209013148132e-22,  -2.253271619833238e-03,  -1.440964081906646e-04,  -4.477985174723935e-06,  -3.545035912189892e-08,   3.736750132152790e-09,
   2.063232851064148e-10,   4.626932899579412e-12,  -3.445872074234073e-14,  -6.458594004479507e-15,  -2.278769015763445e-16,  -2.528506113888705e-18,   1.305588658764241e-19,
   7.761125439052717e-21,   1.797001317847082e-22,  -1.208753745360492e-03,  -7.729791416563894e-05,  -2.401889867070543e-06,  -1.899689205543986e-08,   2.005142133192505e-09,
   1.106699659864331e-10,   2.480284191620156e-12,  -1.856223163542858e-14,  -3.465620005571169e-15,  -1.221703837194067e-16,  -1.351493406392743e-18,   7.016736564132847e-20,
   4.162796946871166e-21,   9.620102424903739e-23,  -4.498153768482383e-04,  -2.876476793988982e-05,  -8.937803667788675e-07,  -7.066721630075669e-09,   7.462524041946032e-10,
   4.118237079350916e-11,   9.227580599783527e-13,  -6.917570217292553e-15,  -1.289788895926250e-15,  -4.545401805036522e-17,  -5.022976368889636e-19,   2.612829430885794e-20,
   1.549028134687945e-21,   3.577377660103894e-23,  -5.081023754781877e-05,  -3.249206163506999e-06,  -1.009589357000326e-07,  -7.981956427448801e-10,   8.429652471981281e-11,
   4.651852198099327e-12,   1.042286965442105e-13,  -7.815736274390061e-16,  -1.456941452282243e-16,  -5.134225058072722e-18,  -5.672713382242617e-20,   2.951700570859603e-21,
   1.749736582647219e-22,   4.040473675280778e-24,  -2.304484854974337e-04,   7.778045863102965e-06,  -1.772627927770325e-07,   3.277229831140516e-09,  -5.034138257114229e-11,
   1.160927776407036e-12,  -5.252257174448035e-15,  -2.354447398564732e-17,  -1.851054372943019e-17,  -2.601364746906852e-19,   6.322750721330086e-21,   4.074930453716468e-22,
   6.964575284854266e-24,   2.707168246125843e-27,  -2.192446784217807e-04,   7.400012106346181e-06,  -1.686496578259268e-07,   3.118169384992616e-09,  -4.789516217450763e-11,
   1.104443879425178e-12,  -5.012145350757481e-15,  -2.267309860377547e-17,  -1.760161573821011e-17,  -2.468171108566319e-19,   6.028730957328488e-21,   3.876674662976835e-22,
   6.612927236440288e-24,   1.747142772724382e-27,  -1.979316239837234e-04,   6.680830141663004e-06,  -1.522628499803026e-07,   2.815478168510484e-09,  -4.324120806497646e-11,
   9.970113863735020e-13,  -4.549172647464955e-15,  -2.090335481460190e-17,  -1.587618985680134e-17,  -2.217529910805091e-19,   5.463940923633370e-21,   3.499563364798278e-22,
   5.949196472491090e-24,   2.583431118546578e-28,  -1.685925579495145e-04,   5.690730255759924e-06,  -1.297012630933870e-07,   2.398587484885177e-09,  -3.683370664244212e-11,
   8.491556205096452e-13,  -3.899831239297833e-15,  -1.825076112579831e-17,  -1.350807405459909e-17,  -1.877802643418722e-19,   4.675884293782483e-21,   2.980527980579578e-22,
   5.045716365867487e-24,  -1.137416098827587e-27,  -1.340971463830297e-04,   4.526505752553928e-06,  -1.031695622828709e-07,   1.908158816216351e-09,  -2.929883872332332e-11,
   6.753567636700540e-13,  -3.121164144715390e-15,  -1.485955765972870e-17,  -1.073274333368381e-17,  -1.485075948928642e-19,   3.735989608917396e-21,   2.370423009123514e-22,
   3.996499425896333e-24,  -1.951983689124156e-27,  -9.782160892360861e-05,   3.302095075128047e-06,  -7.526412126096676e-08,   1.392170591348660e-09,  -2.137396042241974e-11,
   4.926290923681396e-13,  -2.288153625405995e-15,  -1.104075101706310e-17,  -7.822600621363606e-18,  -1.078335813163673e-19,   2.735207694167879e-21,   1.729011321498287e-22,
   2.905434886360041e-24,  -2.038920778727543e-27,  -6.331807651204906e-05,   2.137420188905132e-06,  -4.871860860588225e-08,   9.012115942231426e-10,  -1.383536885373586e-11,
   3.188556342495635e-13,  -1.485916606877412e-15,  -7.232215572576080e-18,  -5.060527474372695e-18,  -6.958471450332120e-20,   1.774660531201183e-21,   1.119077286140240e-22,
   1.876361415183201e-24,  -1.582636526733375e-27,  -3.396587111826173e-05,   1.146591618965749e-06,  -2.613467441920697e-08,   4.834628125285189e-10,  -7.421853754131369e-12,
   1.710406854176228e-13,  -7.984263091555024e-16,  -3.903183013488730e-18,  -2.713833155594250e-18,  -3.726857074264698e-20,   9.531446789654610e-22,   6.002867210453491e-23,
   1.005361354951580e-24,  -9.213714130002211e-28,  -1.263967786914291e-05,   4.266810332775926e-07,  -9.725520180271967e-09,   1.799134873889884e-10,  -2.761899955870675e-12,
   6.364866418866122e-14,  -2.972899565826105e-16,  -1.455539859467198e-18,  -1.009791988708484e-18,  -1.386107507640444e-20,   3.548426231084415e-22,   2.233809733067214e-23,
   3.739708939863703e-25,  -3.522439212167247e-28,  -1.427750835934050e-06,   4.819699549071225e-08,  -1.098574851262909e-09,   2.032269565253373e-11,  -3.119785432806783e-13,
   7.189607367594489e-15,  -3.358432721195905e-17,  -1.644693697552466e-19,  -1.140620781038038e-19,  -1.565580430921028e-21,   4.008494926977166e-23,   2.523258065059365e-24,
   4.224020481141632e-26,  -3.995675517788938e-29,  -2.055883131481720e-03,   6.678473253972350e-05,  -1.414325014357212e-06,   2.288673174288194e-08,  -2.658349812700718e-10,
   6.147428759800578e-12,   4.706088592798533e-14,  -1.965758654744043e-15,  -1.439596415870531e-16,  -2.905468964673218e-18,   6.546232239412785e-20,   3.737939785528938e-21,
   6.573702593604499e-23,   3.172514234262900e-26,  -1.955926415589516e-03,   6.353834589486749e-05,  -1.345579148537800e-06,   2.177533736601644e-08,  -2.528841502430128e-10,
   5.847174088389701e-12,   4.465249998642834e-14,  -1.873211126041048e-15,  -1.368687782215383e-16,  -2.758034431820261e-18,   6.240588642730506e-20,   3.556093912692349e-21,
   6.242258855391482e-23,   2.247246797431461e-26,  -1.765780327022445e-03,   5.736252068597596e-05,  -1.214797483244303e-06,   1.966059784225229e-08,  -2.282586236558586e-10,
   5.276557820454557e-12,   4.012008168487028e-14,  -1.695919362716618e-15,  -1.234169376985524e-16,  -2.480081506629271e-18,   5.653998342557274e-20,   3.210190418679419e-21,
   5.616478456945881e-23,   8.010939975135939e-27,  -1.504033498580590e-03,   4.886061531186458e-05,  -1.034754628431517e-06,   1.674847080850431e-08,  -1.943807435509347e-10,
   4.492147949165017e-12,   3.397588204831742e-14,  -1.449471980901623e-15,  -1.049716805695661e-16,  -2.102328720445048e-18,   4.836533267580272e-20,   2.734096004895491e-21,
   4.764296870286614e-23,  -5.813315740321658e-27,  -1.196289628551483e-03,   3.886398610741621e-05,  -8.230543027056785e-07,   1.332324081674469e-08,  -1.545753662342717e-10,
   3.571258416982871e-12,   2.687195885192292e-14,  -1.156698049053643e-15,  -8.337646142105896e-17,  -1.664350823996077e-18,   3.862817750772219e-20,   2.174452079515687e-21,
   3.774194381904045e-23,  -1.437441315817676e-26,  -8.726693919599479e-04,   2.835100563867152e-05,  -6.004153509930086e-07,   9.720045169997734e-09,  -1.127404908077388e-10,
   2.604137316696294e-12,   1.951328394856859e-14,  -8.460188217001427e-16,  -6.075273246863048e-17,  -1.209518441053382e-18,   2.827170102599965e-20,   1.586077936069335e-21,
   2.744170819400179e-23,  -1.621213758611557e-26,  -5.648607869296932e-04,   1.835123314964618e-05,  -3.886422436594437e-07,   6.292014124465099e-09,  -7.296640376755524e-11,
   1.685165407330651e-12,   1.259238367015844e-14,  -5.485626416220980e-16,  -3.929454076562831e-17,  -7.809322176411434e-19,   1.833948676938413e-20,   1.026569886045137e-21,
   1.772365522495708e-23,  -1.294176055339766e-26,  -3.030092173811864e-04,   9.844242102728074e-06,  -2.084816198519651e-07,   3.375354270583552e-09,  -3.913924020030126e-11,
   9.038551810270198e-13,   6.744444818575960e-15,  -2.945283842737321e-16,  -2.107071795745350e-17,  -4.183757672670482e-19,   9.848834821218821e-21,   5.506657510244548e-22,
   9.496813990303919e-24,  -7.616542769226723e-27,  -1.127583905819812e-04,   3.663331552913521e-06,  -7.758217828784086e-08,   1.256081160907797e-09,  -1.456453871557132e-11,
   3.363346807459236e-13,   2.508439811193766e-15,  -1.096363477696580e-16,  -7.839964457924821e-18,  -1.556195101148531e-19,   3.666450960242953e-21,   2.049159750814106e-22,
   3.532646229027266e-24,  -2.921641661113089e-27,  -1.273694433969539e-05,   4.138021604796529e-07,  -8.763519087992690e-09,   1.418844912145337e-10,  -1.645173626446685e-12,
   3.799135849678981e-14,   2.833235526655664e-16,  -1.238489299349244e-17,  -8.855665992048436e-19,  -1.757718785407156e-20,   4.141797982481711e-22,   2.314682120420034e-23,
   3.990151711350185e-25,  -3.315872578734750e-28,  -5.590759408273816e-03,   1.655442076844622e-04,  -2.853884884996550e-06,   2.707361082619886e-08,   1.800306687755958e-10,
  -2.555289697163409e-14,   4.154562147531704e-13,  -8.395546117976606e-15,  -4.404513794411985e-16,  -8.085544947335546e-18,   1.761997857971270e-19,   1.170413372047813e-20,
   1.919164167526454e-22,   1.892082488625894e-25,  -5.318907824721359e-03,   1.574944974732956e-04,  -2.715038419375882e-06,   2.575671761033378e-08,   1.714577913043392e-10,
  -2.959165315071981e-14,   3.948830093883868e-13,  -7.995706118361028e-15,  -4.187889118408278e-16,  -7.673122848546269e-18,   1.680022721181179e-19,   1.113496565638795e-20,
   1.822551768747970e-22,   1.569233334892509e-25,  -4.801780917606931e-03,   1.421820573436213e-04,  -2.450949937831750e-06,   2.325184536101578e-08,   1.550762492724107e-10,
  -3.513441848696113e-14,   3.558991914243419e-13,  -7.231673018258135e-15,  -3.776808072640980e-16,  -6.896428280698652e-18,   1.522572034650692e-19,   1.005221864307075e-20,
   1.640081687207537e-22,   1.049021493404066e-25,  -4.089949963853353e-03,   1.211043886681445e-04,  -2.087488945796252e-06,   1.980420117846260e-08,   1.323838694581822e-10,
  -3.860802202001237e-14,   3.025307020888677e-13,  -6.173328377966810e-15,  -3.212878633302730e-16,  -5.842482707388165e-18,   1.302912275725410e-19,   8.561775734190325e-21,
   1.391477664760323e-22,   5.149861233201408e-26,  -3.253057893020978e-03,   9.632369412128881e-05,  -1.660247424367787e-06,   1.575127682358553e-08,   1.055240050475441e-10,
  -3.742007945141481e-14,   2.401566136263347e-13,  -4.920676139921329e-15,  -2.552323937589441e-16,  -4.622588874663337e-18,   1.040969165230363e-19,   6.809552744816611e-21,
   1.102490888936120e-22,   1.174517949344745e-26,  -2.373018615242451e-03,   7.026548373966751e-05,  -1.211049470776131e-06,   1.148980581534698e-08,   7.711120168517970e-11,
  -3.124568665822250e-14,   1.749119465867031e-13,  -3.595679367077988e-15,  -1.860008171041021e-16,  -3.357719662759494e-18,   7.620921262865271e-20,   4.967163859595397e-21,
   8.017160851579160e-23,  -8.594410006579479e-27,  -1.535996228624239e-03,   4.548107829151579e-05,  -7.838581542331181e-07,   7.436925919514102e-09,   4.996955171716608e-11,
  -2.191484420873805e-14,   1.130982436911295e-13,  -2.330030800647398e-15,  -1.203147322885799e-16,  -2.167237974663785e-18,   4.944503957371356e-20,   3.215012223086810e-21,
   5.178468861796933e-23,  -1.290118770853121e-26,  -8.239544178187252e-04,   2.439740524342460e-05,  -4.204783416320961e-07,   3.989351048370474e-09,   2.682096436824822e-11,
  -1.222165108530094e-14,   6.063681023097693e-14,  -1.250623714221938e-15,  -6.451864517564714e-17,  -1.160882526809988e-18,   2.655591900824808e-20,   1.724596148868666e-21,
   2.774890101784661e-23,  -8.941767581394290e-27,  -3.066166515751235e-04,   9.078960731140910e-06,  -1.564709730254715e-07,   1.484544867346556e-09,   9.982882311872314e-12,
  -4.608375112336877e-15,   2.256045936692326e-14,  -4.654862092685090e-16,  -2.400638272891351e-17,  -4.317783480481177e-19,   9.886363691928261e-21,   6.417664215996756e-22,
   1.032226204459264e-23,  -3.589250195198222e-27,  -3.463474887579073e-05,   1.025539602506304e-06,  -1.767460469589939e-08,   1.676908630551005e-10,   1.127681303533622e-12,
  -5.216339280470180e-16,   2.548304944497195e-15,  -5.258199065036027e-17,  -2.711658080668600e-18,  -4.876882044557502e-20,   1.116816624274761e-21,   7.249245714520370e-23,
   1.165910547930362e-24,  -4.101258867694733e-28,  -1.048600000816582e-02,   2.537730073368729e-04,  -2.135744225491821e-06,  -4.505261670020330e-08,   2.044834854015545e-09,
  -6.518208832232797e-12,   4.541228177644444e-13,  -1.525729865517303e-15,  -1.292838546358641e-15,  -1.754573746290099e-17,   4.746429328795252e-19,   2.441728859446544e-20,
   4.556215787571859e-22,   5.761095594538742e-25,  -9.976020466660908e-03,   2.414253826017261e-04,  -2.031495679822418e-06,  -4.286318363750336e-08,   1.945571821161483e-09,
  -6.202200590866310e-12,   4.309616113756971e-13,  -1.470022001225541e-15,  -1.229312225971632e-15,  -1.665237627618395e-17,   4.524427535627189e-19,   2.323027893686444e-20,
   4.328035642552865e-22,   4.980647163158670e-25,  -9.005956130645700e-03,   2.179404391404100e-04,  -1.833351565686789e-06,  -3.869784600095642e-08,   1.756681008175210e-09,
  -5.600710520555597e-12,   3.873430491259789e-13,  -1.356479073991859e-15,  -1.108737375863573e-15,  -1.496933135922322e-17,   4.098533124594910e-19,   2.097202487007071e-20,
   3.896607050635102e-22,   3.699324090527058e-25,  -7.670727487608333e-03,   1.856193569277764e-04,  -1.560917381056594e-06,  -3.296322133089385e-08,   1.496538113984708e-09,
  -4.772026339130610e-12,   3.281531924273428e-13,  -1.185561207329864e-15,  -9.432848875027507e-16,  -1.268428676316361e-17,   3.505334935995090e-19,   1.786313400984189e-20,
   3.307900931620679e-22,   2.329836871839489e-25,  -6.101009273986453e-03,   1.476276585514718e-04,  -1.241016184094298e-06,  -2.621982908868503e-08,   1.190524058919412e-09,
  -3.796807720300195e-12,   2.596411123835541e-13,  -9.661925206081512e-16,  -7.494250287533044e-16,  -1.003789278771007e-17,   2.799148775341637e-19,   1.420780815022302e-20,
   2.622406315139452e-22,   1.219018828756378e-25,  -4.450451330022305e-03,   1.076845646470977e-04,  -9.049920003883540e-07,  -1.912760045420344e-08,   8.685783746084740e-10,
  -2.770408758969841e-12,   1.885997006079493e-13,  -7.184201732946347e-16,  -5.461888568364615e-16,  -7.292455351722136e-18,   2.048403703562750e-19,   1.036402963573793e-20,
   1.907860903708977e-22,   5.165833959980304e-26,  -2.880636415103118e-03,   6.969904824765950e-05,  -5.856522917590403e-07,  -1.238122343093616e-08,   5.622617433279614e-10,
  -1.793536339286192e-12,   1.217332611791328e-13,  -4.708239619257865e-16,  -3.533218008421486e-16,  -4.707430075261564e-18,   1.328657090046072e-19,   6.708268103045482e-21,
   1.232709597078058e-22,   1.749736957063975e-26,  -1.545251288003036e-03,   3.738796839581623e-05,  -3.141265573859390e-07,  -6.641769844902689e-09,   3.016284806657546e-10,
  -9.621951357326074e-13,   6.520700145834609e-14,  -2.541621725174555e-16,  -1.894737485089024e-16,  -2.521681677325085e-18,   7.134955984952331e-20,   3.598479925230688e-21,
   6.606535482229180e-23,   4.994857751586646e-27,  -5.750304455816150e-04,   1.391302693946111e-05,  -1.168908230386029e-07,  -2.471603983149765e-09,   1.122463226590088e-10,
  -3.580714086078023e-13,   2.425314102196422e-14,  -9.478777371908554e-17,  -7.050091932677111e-17,  -9.379322435414260e-19,   2.656107441045691e-20,   1.339090756393311e-21,
   2.457688018248060e-23,   1.289954085386206e-27,  -6.495416662685389e-05,   1.571583605436640e-06,  -1.320365168126213e-08,  -2.791872570714873e-10,   1.267913350068776e-11,
  -4.044717226115819e-14,   2.739362909367376e-15,  -1.071072784206509e-17,  -7.963493980036902e-18,  -1.059385990131269e-19,   3.000458403440084e-21,   1.512606827513952e-22,
   2.776009162292271e-24,   1.355151968273368e-28,  -1.576182340849680e-02,   2.187901451812036e-04,   4.335703575350685e-06,  -1.940419133184280e-07,   1.674950990133653e-09,
   1.184409254749583e-10,  -1.042229490240751e-12,  -2.333950210276701e-14,  -1.139416873138934e-15,  -6.633823876042495e-17,   7.968585305475596e-19,   7.313828406197421e-20,
   5.826890847320549e-22,  -3.721637173967261e-24,  -1.499503378067591e-02,   2.081308814435548e-04,   4.125111154763813e-06,  -1.845684841645928e-07,   1.593012433243674e-09,
   1.126650180781587e-10,  -9.924774298185314e-13,  -2.227443954911400e-14,  -1.082919873134760e-15,  -6.299203259117051e-17,   7.592400284799299e-19,   6.957075360656031e-20,
   5.541521562436679e-22,  -3.645641814570244e-24,  -1.353656579352785e-02,   1.878627679970251e-04,   3.724419478971187e-06,  -1.665632506630718e-07,   1.437345830440785e-09,
   1.016845857873267e-10,  -8.974591326102283e-13,  -2.021986894861477e-14,  -9.758911629842876e-16,  -5.667576201289757e-17,   6.872209990853441e-19,   6.278865741511623e-20,
   4.999313713673415e-22,  -3.458501950294863e-24,  -1.152925874146409e-02,   1.599796927694541e-04,   3.172680033413788e-06,  -1.418088925955840e-07,   1.223457701812560e-09,
   8.658300332747917e-11,  -7.659338456779786e-13,  -1.733651941845068e-14,  -8.294242392784960e-16,  -4.807635424690827e-17,   5.871954886213338e-19,   5.346150623329792e-20,
   4.254377688344608e-22,  -3.118248477425544e-24,  -9.169656815022352e-03,   1.272183688983662e-04,   2.523774521048542e-06,  -1.127434810525589e-07,   9.724845844569414e-10,
   6.884491320269459e-11,  -6.103768680882218e-13,  -1.387697907126391e-14,  -6.583155301173634e-16,  -3.808634788702804e-17,   4.684703255460348e-19,   4.250692023803575e-20,
   3.380655073459432e-22,  -2.613442868528866e-24,  -6.688744861015897e-03,   9.278710344274937e-05,   1.841198215878370e-06,  -8.221500139630745e-08,   7.090325081610746e-10,
   5.020794384947303e-11,  -4.459400799158197e-13,  -1.017441584986191e-14,  -4.794050692375011e-16,  -2.769334821432337e-17,   3.425750379588217e-19,   3.099850916506355e-20,
   2.464103849685040e-22,  -1.984796358220873e-24,  -4.329341751193664e-03,   6.005225764659025e-05,   1.191835707431692e-06,  -5.320361280880550e-08,   4.587812844394615e-10,
   3.249296874715011e-11,  -2.889393360031106e-13,  -6.607651421163592e-15,  -3.099565599818641e-16,  -1.788689371329909e-17,   2.220987998345124e-19,   2.006058618486432e-20,
   1.594062339754013e-22,  -1.318240466603780e-24,  -2.322356376712875e-03,   3.221203002881056e-05,   6.393566867247078e-07,  -2.853667324802951e-08,   2.460605124601145e-10,
   1.742871535063778e-11,  -1.550764914896481e-13,  -3.550597890762833e-15,  -1.661733713111368e-16,  -9.584509159558783e-18,   1.192391727122881e-19,   1.075999157933653e-20,
   8.548509662833416e-23,  -7.163834279929278e-25,  -8.642100492658653e-04,   1.198677060096514e-05,   2.379252628512272e-07,  -1.061886754769236e-08,   9.156041085283665e-11,
   6.485523267567603e-12,  -5.771879039386029e-14,  -1.322061483020022e-15,  -6.182527469604657e-17,  -3.565298603959758e-18,   4.438504004503956e-20,   4.003951801979377e-21,
   3.180811299682179e-23,  -2.677833585706532e-25,  -9.761920913092983e-05,   1.353995308051485e-06,   2.687556637426083e-08,  -1.199476388148822e-09,   1.034236344447131e-11,
   7.325871218900970e-13,  -6.519976262469003e-15,  -1.493512352738108e-16,  -6.983423909372877e-18,  -4.027038541097289e-19,   5.013866566398371e-21,   4.522750830366988e-22,
   3.592915787575749e-24,  -3.026967981041980e-26,  -1.848703424532119e-02,  -1.525890154900772e-04,   1.429876530107976e-05,   7.264515232186309e-08,  -1.147431381337872e-08,
   7.930444474836746e-11,   1.345644706866255e-11,  -8.778816459486352e-14,  -1.486159768433116e-14,  -3.779955129902469e-17,   1.034796477158150e-17,   5.126803568821005e-20,
  -4.864306435275613e-21,   9.565006065348069e-23,  -1.758739669953435e-02,  -1.451605112132473e-04,   1.360123642353461e-05,   6.913507603940568e-08,  -1.091024557303886e-08,
   7.539205426779867e-11,   1.278962847280742e-11,  -8.355798196738576e-14,  -1.412495706235236e-14,  -3.587508706170268e-17,   9.835250372301189e-18,   4.898954938683632e-20,
  -4.613377054371939e-21,   9.051213328059288e-23,  -1.587635604290613e-02,  -1.310333053034073e-04,   1.227528510044830e-05,   6.244897738467444e-08,  -9.839751500090569e-09,
   6.797256411825045e-11,   1.152627624523037e-11,  -7.549536486113389e-14,  -1.272939637529034e-14,  -3.224896442363924e-17,   8.863862867038914e-18,   4.456658080548274e-20,
  -4.142019156776194e-21,   8.093699101555718e-23,  -1.352164334430240e-02,  -1.115940133414375e-04,   1.045187260350532e-05,   5.322788313757155e-08,  -8.371042105594037e-09,
   5.780382034715284e-11,   9.797123685276453e-12,  -6.436658513718871e-14,  -1.081943822403613e-14,  -2.732525852083129e-17,   7.534295980850269e-18,   3.830779496891653e-20,
  -3.504651422010040e-21,   6.814097385444927e-23,  -1.075393363178053e-02,  -8.874826478895272e-05,   8.310349637750696e-06,   4.236449088431576e-08,  -6.650408167104982e-09,
   4.590462182767383e-11,   7.776641734556806e-12,  -5.124418953931389e-14,  -8.587877640650474e-15,  -2.162292145055085e-17,   5.980648406829322e-18,   3.073592003681865e-20,
  -2.769639891548514e-21,   5.358255724384694e-23,  -7.844183940240942e-03,  -6.473289703306376e-05,   6.060507148092515e-06,   3.092030738835475e-08,  -4.846752449436099e-09,
   3.344428017045291e-11,   5.663589897489926e-12,  -3.740962050690044e-14,  -6.254254405948723e-15,  -1.570781728916922e-17,   4.355714149261739e-18,   2.257678013088627e-20,
  -2.009940849606212e-21,   3.872577688506805e-23,  -5.077122643107044e-03,  -4.189718533524372e-05,   3.922102205853777e-06,   2.002102173962448e-08,  -3.135241785817208e-09,
   2.162972282619369e-11,   3.661943510356637e-12,  -2.422642314858228e-14,  -4.043791399721811e-15,  -1.013916260023736e-17,   2.816355979747119e-18,   1.467969171581724e-20,
  -1.296543760668678e-21,   2.491182453484111e-23,  -2.723459200281918e-03,  -2.247412993369374e-05,   2.103736517532773e-06,   1.074182355654103e-08,  -1.681303186254792e-09,
   1.159789068197736e-11,   1.963286435816270e-12,  -1.299910884736361e-14,  -2.167990382612671e-15,  -5.431189047632377e-18,   1.509955341266620e-18,   7.892839116855235e-21,
  -6.942852504521312e-22,   1.332092861478371e-23,  -1.013467920150923e-03,  -8.363156366040892e-06,   7.828341554141762e-07,   3.997587348506617e-09,  -6.255910695997462e-10,
   4.315261834368035e-12,   7.304530685169360e-13,  -4.837765571671589e-15,  -8.066122473073469e-16,  -2.020092226278852e-18,   5.617904738009811e-19,   2.939503629675369e-21,
  -2.582053487185372e-22,   4.951586436198412e-24,  -1.144789850789128e-04,  -9.446821186317807e-07,   8.842678395357187e-08,   4.515632766063957e-10,  -7.066416358903927e-11,
   4.874311015801155e-13,   8.250785757665308e-14,  -5.464711813602606e-16,  -9.111032907386118e-17,  -2.281671749346656e-19,   6.345672018132300e-20,   3.320821365426438e-22,
  -2.916348709906110e-23,   5.592217192299051e-25,  -1.056000853397453e-02,  -6.564155153780565e-04,  -1.604333042822635e-05,   2.246124627180545e-07,   3.183073465265520e-08,
   1.008245193213416e-09,  -1.393100744620994e-12,  -1.354383386610950e-12,  -5.125413871375224e-14,  -3.215285772506479e-16,   4.933887794847650e-17,   2.264681477981066e-18,
   2.851743305581903e-20,  -1.529349622090162e-21,  -1.004683483440733e-02,  -6.244666433666286e-04,  -1.525730150749815e-05,   2.139843821037726e-07,   3.028169414303160e-08,
   9.583567469232483e-10,  -1.367624827238918e-12,  -1.288824669707577e-12,  -4.869468226853986e-14,  -3.022210337553232e-16,   4.699227909222005e-17,   2.150912934620380e-18,
   2.688818179831702e-20,  -1.459956819897134e-21,  -9.070529758891010e-03,  -5.637046160818080e-04,  -1.376449289889348e-05,   1.936474484543199e-07,   2.733553630114611e-08,
   8.638073100994138e-10,  -1.301903079507433e-12,  -1.163989531199045e-12,  -4.385321446114524e-14,  -2.669951512949354e-16,   4.250647892722111e-17,   1.935965421219599e-18,
   2.388813893822740e-20,  -1.325876366417290e-21,  -7.726391590677474e-03,  -4.800890637677550e-04,  -1.171429148949813e-05,   1.654215543711747e-07,   2.328109019652883e-08,
   7.343384803330710e-10,  -1.178047283681404e-12,  -9.919121791927134e-13,  -3.724177299707951e-14,  -2.214097241506958e-16,   3.628970421363483e-17,   1.642948553598498e-18,
   1.995030515493648e-20,  -1.137339129778232e-21,  -6.145794983732516e-03,  -3.818136538902300e-04,  -9.309797762139123e-06,   1.319436882119560e-07,   1.851559201041254e-08,
   5.829838941210320e-10,  -9.902838985842494e-13,  -7.893065709547733e-13,  -2.953586880141356e-14,  -1.714780206041135e-16,   2.892851076089373e-17,   1.302096598243921e-18,
   1.556252606762228e-20,  -9.107340799786540e-22,  -4.483421842915112e-03,  -2.785000004077589e-04,  -6.786843074688171e-06,   9.646714611689265e-08,   1.350562233607235e-08,
   4.246286662536815e-10,  -7.536512261645334e-13,  -5.759867493464607e-13,  -2.149536384200957e-14,  -1.223752875123168e-16,   2.114004071050366e-17,   9.470911976185537e-19,
   1.117327691940838e-20,  -6.679157750735046e-22,  -2.902105904793832e-03,  -1.802563852045733e-04,  -4.391071630817142e-06,   6.253385952373471e-08,   8.741419623197005e-09,
   2.745768000193357e-10,  -5.011762579742487e-13,  -3.729101676980629e-13,  -1.389190218659202e-14,  -7.805170793637283e-17,   1.369931859727918e-17,   6.118480469121717e-19,
   7.155671081199934e-21,  -4.338363666561249e-22,  -1.556803555045039e-03,  -9.669223457686064e-05,  -2.354983470877443e-06,   3.357066155100631e-08,   4.689038673631407e-09,
   1.472155093315306e-10,  -2.725227688463936e-13,  -2.000643091199195e-13,  -7.446102833594754e-15,  -4.155033715542193e-17,   7.353081673940947e-18,   3.278878889263863e-19,
   3.817457589055374e-21,  -2.331371858202208e-22,  -5.793339528217635e-04,  -3.598155558822355e-05,  -8.762884775531224e-07,   1.249590719723415e-08,   1.744907690349159e-09,
   5.477323105806094e-11,  -1.018894705556442e-13,  -7.445267880717517e-14,  -2.770136409329663e-15,  -1.542075828943256e-17,   2.736851825129134e-18,   1.219741004453385e-19,
   1.417857077056377e-21,  -8.681047047287262e-23,  -6.544036357872063e-05,  -4.064391864047295e-06,  -9.898243222912688e-08,   1.411569925293843e-09,   1.971006890143178e-10,
   6.186889037557656e-12,  -1.151774523397498e-14,  -8.410068118323578e-15,  -3.128948016414697e-16,  -1.741155181319445e-18,   3.091589032777811e-19,   1.377717166645054e-20,
   1.601091812897771e-22,  -9.806880965719490e-24,  -2.019405054474427e-04,   6.505271494369575e-06,  -1.420284850541470e-07,   2.649152741329034e-09,  -2.880995408887104e-11,
   9.540928242501855e-13,  -1.503360885102250e-14,  -6.763831776228506e-16,  -1.820073586676428e-17,   4.334110808325602e-19,   2.940614667144131e-20,   5.168686858699079e-22,
  -9.795779084901476e-24,  -8.451230175384353e-25,  -1.921222827611247e-04,   6.189089764059337e-06,  -1.351253283502396e-07,   2.520579437106403e-09,  -2.741538973641271e-11,
   9.072653654395775e-13,  -1.431729590223410e-14,  -6.430141466471678e-16,  -1.727626893773298e-17,   4.131562029025899e-19,   2.795590853304681e-20,   4.897701228473314e-22,
  -9.381743021659577e-24,  -8.038937170228821e-25,  -1.734451943440902e-04,   5.587580154202294e-06,  -1.219926502204506e-07,   2.275903543572257e-09,  -2.476003172341657e-11,
   8.183653917876164e-13,  -1.294867564712470e-14,  -5.797321063808207e-16,  -1.553378949429431e-17,   3.742888144431654e-19,   2.520531765777647e-20,   4.390218989837485e-22,
  -8.568433392335866e-24,  -7.255030417104047e-25,  -1.477350541024124e-04,   4.759486603591856e-06,  -1.039130080721158e-07,   1.938913383081126e-09,  -2.109992526789661e-11,
   6.963365145225167e-13,  -1.105312491299869e-14,  -4.930007206314364e-16,  -1.316638313334127e-17,   3.201369432046827e-19,   2.143498755715129e-20,   3.707164755559482e-22,
  -7.399432468003399e-24,  -6.176871367312123e-25,  -1.175067513850485e-04,   3.785767978248672e-06,  -8.265397003920412e-08,   1.542476049379072e-09,  -1.679046395020934e-11,
   5.533019215672639e-13,  -8.809893436669929e-15,  -3.915106531624094e-16,  -1.042240370560725e-17,   2.556545039942639e-19,   1.702261649636780e-20,   2.923718099347544e-22,
  -5.963019776736932e-24,  -4.910692724031119e-25,  -8.571889763523595e-05,   2.761719270345884e-06,  -6.029609584491353e-08,   1.125374795709147e-09,  -1.225292339223710e-11,
   4.032965294095148e-13,  -6.437410004996210e-15,  -2.852364648248897e-16,  -7.573593959419979e-18,   1.870923181439331e-19,   1.240197790043963e-20,   2.118157645349043e-22,
  -4.395257264796671e-24,  -3.580782667690110e-25,  -5.548409317007123e-05,   1.787636566642062e-06,  -3.902912839553003e-08,   7.285041326399332e-10,  -7.933038721356128e-12,
   2.609060576203599e-13,  -4.171398481740063e-15,  -1.844722673055062e-16,  -4.889689030183607e-18,   1.213556114871132e-19,   8.020803329949683e-21,   1.364781065845042e-22,
  -2.864277530523745e-24,  -2.317103149982897e-25,  -2.976343313636354e-05,   9.589539662389221e-07,  -2.093665820406713e-08,   3.908126248092721e-10,  -4.256077790474139e-12,
   1.399198814257665e-13,  -2.238935008281484e-15,  -9.891392526882087e-17,  -2.619530595449501e-18,   6.516899188894053e-20,   4.300750896983778e-21,   7.303879876883735e-23,
  -1.541797997586082e-24,  -1.242779107479018e-25,  -1.107582524480950e-05,   3.568553577342078e-07,  -7.791154529756254e-09,   1.454351296037860e-10,  -1.583878743999787e-12,
   5.206321544182885e-14,  -8.333354322718884e-16,  -3.680314756151682e-17,  -9.743549873977772e-19,   2.426030203941670e-20,   1.600190836191642e-21,   2.715749919832534e-23,
  -5.744339342806228e-25,  -4.624488852854475e-26,  -1.251101324433109e-06,   4.030963181772856e-08,  -8.800724522062899e-10,   1.642808449650118e-11,  -1.789127877739917e-13,
   5.880859292449606e-15,  -9.413470533331224e-17,  -4.157104568215637e-18,  -1.100530197050377e-19,   2.740553643072722e-21,   1.807497712744498e-22,   3.067252301382387e-24,
  -6.489912409128209e-26,  -5.223678227276707e-27,  -1.809723431608945e-03,   5.650599671238209e-05,  -1.161024193832497e-06,   1.964925797186196e-08,  -1.390562251437567e-10,
   6.026206702808505e-12,  -8.247356550584488e-14,  -7.367285006309926e-15,  -1.541892380232367e-16,   3.782113405352786e-18,   2.792019912373389e-19,   4.823792774677647e-21,
  -8.941818572963812e-23,  -7.887608503464248e-24,  -1.721732440931816e-03,   5.375928233032284e-05,  -1.104576490099373e-06,   1.869528907899110e-08,  -1.323297462020710e-10,
   5.728509772197902e-12,  -7.858824758392658e-14,  -7.004837100338034e-15,  -1.463173905993565e-16,   3.605862457086623e-18,   2.654394975407122e-19,   4.570882251565517e-21,
  -8.566052448138821e-23,  -7.503285425772026e-24,  -1.554349587592294e-03,   4.853400763324567e-05,  -9.971964677052233e-07,   1.688000807769476e-08,  -1.195201551093726e-10,
   5.164121772464018e-12,  -7.114620193650204e-14,  -6.317075647291293e-15,  -1.314958033665671e-16,   3.267437116622101e-18,   2.393340687245749e-19,   4.097250946715119e-21,
  -7.826890831088990e-23,  -6.772363225809272e-24,  -1.323939624498965e-03,   4.134065041533431e-05,  -8.493809354435895e-07,   1.438008553016408e-08,  -1.018599741314516e-10,
   4.390921347745453e-12,  -6.080322126973295e-14,  -5.373674128601614e-15,  -1.113891601126749e-16,   2.795517029892710e-18,   2.035449559868166e-19,   3.459762755772330e-21,
  -6.762545762592739e-23,  -5.766701458817491e-24,  -1.053041995274137e-03,   3.288259998557917e-05,  -6.755885155923728e-07,   1.143947758435391e-08,  -8.106198912883202e-11,
   3.486538109402833e-12,  -4.851852155420471e-14,  -4.268733632258496e-15,  -8.812343675876094e-17,   2.233060046905148e-18,   1.616544042401669e-19,   2.728586446676158e-21,
  -5.452414714078459e-23,  -4.585192057861492e-24,  -7.681712265807972e-04,   2.398764567763139e-05,  -4.928291765751982e-07,   8.345889057273509e-09,  -5.915890339805155e-11,
   2.539868028167326e-12,  -3.548491963276986e-14,  -3.110763848164392e-15,  -6.400590865106231e-17,   1.634552546245219e-18,   1.177800316244859e-19,   1.976780678967736e-21,
  -4.020427716061865e-23,  -3.343778379034152e-24,  -4.972204898780827e-04,   1.552689588962511e-05,  -3.189984623180473e-07,   5.402556055907920e-09,  -3.830338055088482e-11,
   1.642511158119090e-12,  -2.300775389255101e-14,  -2.012165440402514e-15,  -4.131070860577723e-17,   1.060390048061650e-18,   7.617482875882806e-20,   1.273684167858076e-21,
  -2.620656916497352e-23,  -2.163885818380392e-24,  -2.667245983230564e-04,   8.329171277051762e-06,  -1.711209796193471e-07,   2.898222030304686e-09,  -2.055019308213434e-11,
   8.806839286938503e-13,  -1.235284522776401e-14,  -1.079012211428623e-15,  -2.212760633969828e-17,   5.694805354917994e-19,   4.084553079859046e-20,   6.816345647338864e-22,
  -1.410837246006731e-23,  -1.160641256622407e-24,  -9.925581805756049e-05,   3.099529505233822e-06,  -6.367902064002171e-08,   1.078526774579973e-09,  -7.647708963971714e-12,
   3.276744257481956e-13,  -4.598239235599749e-15,  -4.014824254355691e-16,  -8.230071578679002e-18,   2.120045740159373e-19,   1.519757677329072e-20,   2.534471904477754e-22,
  -5.256641370133633e-24,  -4.318898949591855e-25,  -1.121172238739848e-05,   3.501162825668625e-07,  -7.193044913790429e-09,   1.218283339158040e-10,  -8.638757685683013e-13,
   3.701244142840678e-14,  -5.194321306599937e-16,  -4.534971201188672e-17,  -9.295750609853218e-19,   2.394909474414950e-20,   1.716645779944480e-21,   2.862510989500257e-23,
  -5.938955599371044e-25,  -4.878502760580920e-26,  -4.972114260849953e-03,   1.440645880770320e-04,  -2.510274096352488e-06,   3.038043841123128e-08,   2.510814561321215e-10,
   5.339321877585594e-12,  -4.440844097222331e-14,  -2.462793228265545e-14,  -4.582074501907434e-16,   1.156086586470289e-17,   8.370812120215023e-19,   1.497800429347594e-20,
  -2.621298952310109e-22,  -2.361944287024447e-23,  -4.730343547759218e-03,   1.370599515937553e-04,  -2.388128800589600e-06,   2.890426411840652e-08,   2.388475331707611e-10,
   5.064298763255809e-12,  -4.262344403436855e-14,  -2.341748402979326e-14,  -4.348046033989828e-16,   1.102250729106313e-17,   7.958305745042944e-19,   1.419468752942044e-20,
  -2.512174356280824e-22,  -2.247179244426538e-23,  -4.270438015323180e-03,   1.237352389097130e-04,  -2.155812830050229e-06,   2.609578143162512e-08,   2.155856321947742e-10,
   4.547410110192150e-12,  -3.907445721883798e-14,  -2.112013533633316e-14,  -3.907441440576881e-16,   9.988623273268676e-18,   7.175795974945693e-19,   1.272699637372736e-20,
  -2.297028998040712e-22,  -2.028781448582359e-23,  -3.637373591496814e-03,   1.053932077282616e-04,  -1.836092588980630e-06,   2.222901678105123e-08,   1.835848909598084e-10,
   3.848055150203176e-12,  -3.389290349614362e-14,  -1.796795311885910e-14,  -3.309801882659147e-16,   8.546598149049204e-18,   6.102930664246120e-19,   1.075006614160484e-20,
  -1.986320447958478e-22,  -1.728037388336839e-23,  -2.893087339513592e-03,   8.382815063070910e-05,  -1.460283532500639e-06,   1.768182758600896e-08,   1.459870208279690e-10,
   3.041191422285133e-12,  -2.742784909526707e-14,  -1.427485930597652e-14,  -2.618360018064974e-16,   6.827524042446151e-18,   4.847051645693999e-19,   8.480699279883775e-21,
  -1.602760361093756e-22,  -1.374387229317379e-23,  -2.110429102300862e-03,   6.115078408332019e-05,  -1.065176111390361e-06,   1.289920760223803e-08,   1.064744174863359e-10,
   2.207034576514702e-12,  -2.028334811173184e-14,  -1.040343183215053e-14,  -1.901694704234011e-16,   4.997895706364586e-18,   3.531598648086264e-19,   6.145504845766990e-21,
  -1.182548725512861e-22,  -1.002512636822563e-23,  -1.366028263366342e-03,   3.958155752711676e-05,  -6.894357864246449e-07,   8.349673605333400e-09,   6.890999662577143e-11,
   1.423671259967096e-12,  -1.324646637442546e-14,  -6.729730277586814e-15,  -1.227359862840065e-16,   3.242430987895938e-18,   2.284112190564372e-19,   3.960325210013054e-21,
  -7.711342302262958e-23,  -6.488629864718957e-24,  -7.327784317636770e-04,   2.123278023415340e-05,  -3.698267621479681e-07,   4.479107473117252e-09,   3.696310503441294e-11,
   7.623538909478635e-13,  -7.138143038448975e-15,  -3.608883647114578e-15,  -6.574122576352942e-17,   1.741376175190562e-18,   1.224767609955064e-19,   2.119614284478877e-21,
  -4.152260065275113e-23,  -3.480571923241304e-24,  -2.726874888387326e-04,   7.901321703842486e-06,  -1.376220168639303e-07,   1.666814016589809e-09,   1.375471661585030e-11,
   2.835190405016683e-13,  -2.660490491940040e-15,  -1.342818854965934e-15,  -2.445146648731833e-17,   6.482789823111810e-19,   4.557058529868682e-20,   7.881435366283747e-22,
  -1.547199730541909e-23,  -1.295201838238751e-24,  -3.080218440760699e-05,   8.925161910877575e-07,  -1.554546630777765e-08,   1.882798934356388e-10,   1.553697508827548e-12,
   3.202256853180261e-14,  -3.005982352667488e-16,  -1.516792312181355e-16,  -2.761756820465984e-18,   7.323290943090486e-20,   5.147438034382139e-21,   8.901577989523295e-23,
  -1.748046284437029e-24,  -1.463028668204583e-25,  -9.507727403511104e-03,   2.350742281818202e-04,  -2.482710291729003e-06,  -1.289035783053309e-08,   1.994027514766619e-09,
  -1.200510891777894e-12,  -2.226305612198477e-13,  -4.687250062068168e-14,  -1.269866658411149e-15,   2.852679037537453e-17,   1.912561454393365e-18,   3.371218684143099e-20,
  -5.305917094796275e-22,  -5.299237329491942e-23,  -9.045341693760905e-03,   2.236389896595560e-04,  -2.361595003193260e-06,  -1.226381306966555e-08,   1.896934089167294e-09,
  -1.171235637724210e-12,  -2.128442269406823e-13,  -4.456170562693499e-14,  -1.205550190191522e-15,   2.719318124892005e-17,   1.818444301943873e-18,   3.194933109377767e-20,
  -5.091465263911197e-22,  -5.043055600279840e-23,  -8.165802007470788e-03,   2.018883409911500e-04,  -2.131364528732891e-06,  -1.107188459739073e-08,   1.712292754731554e-09,
  -1.103688884534820e-12,  -1.938028577973119e-13,  -4.017879294328055e-14,  -1.084251405279819e-15,   2.463430122087514e-17,   1.639853935125582e-18,   2.864616606381993e-20,
  -4.665576758605934e-22,  -4.555000736821529e-23,  -6.955161715655145e-03,   1.719520480397748e-04,  -1.814759605442471e-06,  -9.430995369294050e-09,   1.458236535009491e-09,
  -9.877457230980644e-13,  -1.667702907733825e-13,  -3.417050813366609e-14,  -9.193093347773163e-16,   2.106952584990342e-17,   1.394892823562664e-18,   2.419671232911357e-20,
  -4.044774381168159e-22,  -3.881887573456974e-23,  -5.531895587527196e-03,   1.367609728744812e-04,  -1.442922790647447e-06,  -7.501565353097731e-09,   1.159678755564321e-09,
  -8.224051147121870e-13,  -1.339524562780300e-13,  -2.713819801781492e-14,  -7.279514180730149e-16,   1.682514877488219e-17,   1.108014311838713e-18,   1.908887539858443e-20,
  -3.271523339859833e-22,  -3.089063523896313e-23,  -4.035316869286531e-03,   9.975995710437804e-05,  -1.052281025220888e-06,  -5.472407341551023e-09,   8.458536539819931e-10,
  -6.215141472810171e-13,  -9.848087313183801e-14,  -1.977286617650738e-14,  -5.291141828617333e-16,   1.231263194088871e-17,   8.074054223353620e-19,   1.383274152486799e-20,
  -2.418298880822528e-22,  -2.254186849098284e-23,  -2.611938163040549e-03,   6.457065040376645e-05,  -6.809903714259399e-07,  -3.542248760763428e-09,   5.474568408485710e-10,
  -4.115197888746759e-13,  -6.407131561916036e-14,  -1.278832549681851e-14,  -3.416673916050641e-16,   7.986344157556622e-18,   5.222428415818658e-19,   8.914202569047927e-21,
  -1.578860876799829e-22,  -1.459395228017903e-23,  -1.401115698536610e-03,   3.463721879698278e-05,  -3.652691873653807e-07,  -1.900194953057829e-09,   2.936603105273600e-10,
  -2.232930221060146e-13,  -3.445978005317128e-14,  -6.857239292858556e-15,  -1.830561543080805e-16,   4.288700617311752e-18,   2.800442089351325e-19,   4.770993843989111e-21,
  -8.506744619811799e-23,  -7.829461652906383e-24,  -5.213938179672758e-04,   1.288943136089696e-05,  -1.359224918262972e-07,  -7.071195359691236e-10,   1.092777257896219e-10,
  -8.342274472724122e-14,  -1.283510684609066e-14,  -2.551408876314671e-15,  -6.809128200184218e-17,   1.596539783764704e-18,   1.041990403123976e-19,   1.774015649463653e-21,
  -3.170420668749079e-23,  -2.913668044568155e-24,  -5.889549516420549e-05,   1.455961121655987e-06,  -1.535342851268445e-08,  -7.987474420675342e-11,   1.234374603082036e-11,
  -9.429150601902782e-15,  -1.450034529377188e-15,  -2.881950790167391e-16,  -7.690921797786139e-18,   1.803522899915283e-19,   1.176985804526936e-20,   2.003637475232494e-22,
  -3.582102063578432e-24,  -3.291234587665467e-25,  -1.483117114804485e-02,   2.447870568486178e-04,   2.240924119236857e-06,  -1.499723433596760e-07,   3.711370907136625e-09,
   7.964277068466492e-11,  -2.482688537628591e-12,  -8.512633484300591e-14,  -2.114366846517127e-15,   3.632325798014189e-17,   4.395789237913947e-18,   7.729764751458831e-20,
  -1.266391031416911e-21,  -1.042843162594678e-22,  -1.410971049729453e-02,   2.328672029125993e-04,   2.132584139153584e-06,  -1.426541243232874e-07,   3.529734848782489e-09,
   7.571596098612353e-11,  -2.363656286226101e-12,  -8.094603555848078e-14,  -2.005663819119853e-15,   3.468054152565743e-17,   4.179382756837964e-18,   7.329477745217191e-20,
  -1.214608432349615e-21,  -9.930728077850510e-23,  -1.273743823782665e-02,   2.101997144981778e-04,   1.926241000306013e-06,  -1.287436237847211e-07,   3.184694163949081e-09,
   6.826828506033866e-11,  -2.136534990315325e-12,  -7.301059826812787e-14,  -1.801284894916868e-15,   3.150493254951146e-17,   3.768780992006813e-18,   6.577938396162241e-20,
  -1.112071516043096e-21,  -8.979853865307189e-23,  -1.084872075396845e-02,   1.790111016229808e-04,   1.641714185521632e-06,  -1.096160145533055e-07,   2.710663118899370e-09,
   5.805920779722389e-11,  -1.822562243300332e-12,  -6.211953930712650e-14,  -1.524603941707935e-15,   2.703578400095453e-17,   3.205655080944035e-18,   5.562663829756632e-20,
  -9.631573615709519e-22,  -7.663276023598252e-23,  -8.628467631956002e-03,   1.423599866927318e-04,   1.306575184886912e-06,  -8.715361408621814e-08,   2.154517648878316e-09,
   4.611054145369966e-11,  -1.451744709809734e-12,  -4.935601957491150e-14,  -1.205190239670454e-15,   2.165838409020215e-17,   2.546256652322101e-18,   4.393397788455838e-20,
  -7.783215864430476e-22,  -6.106123726119233e-23,  -6.294018269679037e-03,   1.038351198193211e-04,   9.535763372284899e-07,  -6.355708657081991e-08,   1.570789494980952e-09,
   3.359617622905152e-11,  -1.060249232651579e-12,  -3.597291815564655e-14,  -8.747812929730882e-16,   1.588976836779786e-17,   1.855380920333291e-18,   3.186618382849304e-20,
  -5.749287595101648e-22,  -4.460476768129715e-23,  -4.073869125406199e-03,   6.720448195900336e-05,   6.174250709312065e-07,  -4.113074740628582e-08,   1.016359404969135e-09,
   2.172877515091810e-11,  -6.868022234742828e-13,  -2.327109541670755e-14,  -5.643551363010350e-16,   1.032367302777302e-17,   1.200062253308354e-18,   2.054809680039620e-20,
  -3.751907876128912e-22,  -2.889756620098987e-23,  -2.185319849053675e-03,   3.604900510843778e-05,   3.312600439497357e-07,  -2.206151257245622e-08,   5.451026521013993e-10,
   1.165122975434509e-11,  -3.685668377932953e-13,  -1.247964763698260e-14,  -3.022222762556823e-16,   5.548547830013640e-18,   6.435061062771374e-19,   1.100109313551636e-20,
  -2.021030665181145e-22,  -1.550858287349103e-23,  -8.132157575181452e-04,   1.341465695895929e-05,   1.232782827089593e-07,  -8.209418556691949e-09,   2.028347112465563e-10,
   4.335137421106272e-12,  -1.371729407604129e-13,  -4.643553355030597e-15,  -1.123987642732350e-16,   2.066145405430783e-18,   2.394351929676258e-19,   4.091028639240819e-21,
  -7.531687356562399e-23,  -5.772089308336765e-24,  -9.185902047647044e-05,   1.515286953840396e-06,   1.392537325191555e-08,  -9.273128025449493e-10,   2.291152785574421e-11,
   4.896766823549719e-13,  -1.549509408125481e-14,  -5.245171509949721e-16,  -1.269512471200198e-17,   2.334119138024211e-19,   2.704551174370930e-20,   4.620637034028402e-22,
  -8.509576532383631e-24,  -6.520188877691931e-25,  -1.886720233007017e-02,  -3.760643797836958e-05,   1.417356529039582e-05,  -8.249815408150709e-08,  -7.130281914351026e-09,
   3.206684285745342e-10,   4.714770053478613e-12,  -5.039861437045013e-13,  -8.678366918877955e-15,   3.767194589440873e-16,   9.872824233510397e-18,  -2.528201558876033e-20,
   1.170189406298740e-22,  -9.359117932099582e-23,  -1.794907587580821e-02,  -3.578442483381111e-05,   1.348289158046433e-05,  -7.839104432566100e-08,  -6.781387457661919e-09,
   3.047582559479821e-10,   4.478293518896800e-12,  -4.790691994797644e-13,  -8.243042046123502e-15,   3.583521624634420e-16,   9.392434776660204e-18,  -2.427934985042593e-20,
   7.516353915587508e-23,  -8.978570118352314e-23,  -1.620286614141960e-02,  -3.231582159915869e-05,   1.216966751410614e-05,  -7.061734285582729e-08,  -6.118598603430392e-09,
   2.746227759911961e-10,   4.031409185276051e-12,  -4.318381756448331e-13,  -7.420373327049031e-15,   3.234326562244150e-16,   8.478652160794538e-18,  -2.228220519632679e-20,
   1.042087363252318e-23,  -8.223333366290184e-23,  -1.379974528796530e-02,  -2.753603232044895e-05,   1.036316848082946e-05,  -5.999225570783077e-08,  -5.207987602668234e-09,
   2.333916537083211e-10,   3.421973869762935e-12,  -3.671478211659700e-13,  -6.298475336945355e-15,   2.754038805845566e-16,   7.220980874216483e-18,  -1.935663379883250e-20,
  -5.002477664702485e-23,  -7.123993683390655e-23,  -1.097512579910525e-02,  -2.190989701210694e-05,   8.240765179135273e-06,  -4.759582770468790e-08,  -4.139569141438072e-09,
   1.852334743338324e-10,   2.712666808060885e-12,  -2.915016706131568e-13,  -4.992780173229826e-15,   2.189862570271970e-16,   5.742700912634120e-18,  -1.569016508671279e-20,
  -8.505606005542225e-23,  -5.757450902231574e-23,  -8.005535266216116e-03,  -1.598757160866692e-05,   6.010315882050487e-06,  -3.464902693592386e-08,  -3.018090612536130e-09,
   1.348873222539261e-10,   1.973481678066997e-12,  -2.123372733864249e-13,  -3.632174582867137e-15,   1.597066374214857e-16,   4.188667424504814e-18,  -1.161993405342799e-20,
  -8.853665955734805e-23,  -4.252834518424721e-23,  -5.181560315633011e-03,  -1.035044795042560e-05,   3.889857691382594e-06,  -2.239717957928310e-08,  -1.952845861514517e-09,
   8.720855933612380e-11,   1.275106716295708e-12,  -1.373100650491372e-13,  -2.346772219957839e-15,   1.033578058191302e-16,   2.710996557303109e-18,  -7.596326306227632e-21,
  -6.860257604286806e-23,  -2.775185548479846e-23,  -2.779482408573448e-03,  -5.552865471226706e-06,   2.086506516045154e-06,  -1.200618184491600e-08,  -1.047375258333142e-09,
   4.675356573760267e-11,   6.833781242824567e-13,  -7.362126058803336e-14,  -1.257709747599543e-15,   5.543970351159031e-17,   1.454194850175846e-18,  -4.095640533379045e-21,
  -3.990620100304738e-23,  -1.494837800100066e-23,  -1.034315696675372e-03,  -2.066452123364367e-06,   7.764310524602157e-07,  -4.466758989750608e-09,  -3.897332664362203e-10,
   1.739472939236249e-11,   2.542230288256029e-13,  -2.739188587846799e-14,  -4.678777943358199e-16,   2.063008882654791e-17,   5.411382683127032e-19,  -1.526794326044083e-21,
  -1.525213642725888e-23,  -5.570651582672557e-24,  -1.168339038159449e-04,  -2.334232635486956e-07,   8.770365872188585e-08,  -5.045360141194600e-10,  -4.402298014713585e-11,
   1.964806392161987e-12,   2.871502365648136e-14,  -3.094044229088640e-15,  -5.284774175843444e-17,   2.330319360531765e-18,   6.112564447404510e-20,  -1.725116212536124e-22,
  -1.730050501631486e-24,  -6.293908615478236e-25,  -1.341115879859331e-02,  -7.638795818836013e-04,  -9.675883662130475e-06,   8.772153183179181e-07,   4.765213546061367e-08,
   3.423544113982014e-10,  -6.012881238559801e-11,  -2.597715916488420e-12,  -3.018720513146226e-15,   3.552470957733329e-15,   1.250223705188185e-16,  -5.894615441143292e-19,
  -1.873238715520278e-19,  -5.537123149561189e-21,  -1.275911083130146e-02,  -7.266458017019499e-04,  -9.196810934406405e-06,   8.346441244780324e-07,   4.530749979970360e-08,
   3.240982283388702e-10,  -5.720570184815766e-11,  -2.467567625693763e-12,  -2.707610490547163e-15,   3.378595037479238e-15,   1.185756271606549e-16,  -5.732464451454550e-19,
  -1.780404652672588e-19,  -5.239517575253381e-21,  -1.151872969416996e-02,  -6.558548079297203e-04,  -8.288995286958968e-06,   7.536288836051922e-07,   4.085863817778419e-08,
   2.900281079078067e-10,  -5.164478767378693e-11,  -2.221554858738705e-12,  -2.183291246158785e-15,   3.048275585021560e-15,   1.064622805393312e-16,  -5.372501169700520e-19,
  -1.604493761287171e-19,  -4.685006883825212e-21,  -9.811274305206091e-03,  -5.584811585196312e-04,  -7.046147647489875e-06,   6.420440213340256e-07,   3.475644127829474e-08,
   2.444017842081753e-10,  -4.398942602101854e-11,  -1.885939381849797e-12,  -1.591738563158407e-15,   2.594456536956408e-15,   9.007829071741133e-17,  -4.778023372071927e-19,
  -1.363700727487171e-19,  -3.944146393668224e-21,  -7.803765643756895e-03,  -4.440898120484357e-04,  -5.593505283005707e-06,   5.107717260338244e-07,   2.760963563793607e-08,
   1.923640046277210e-10,  -3.498849461050741e-11,  -1.495184827441870e-12,  -1.060013658393908e-15,   2.062048787735650e-15,   7.118236855413870e-17,  -3.955175364252810e-19,
  -1.082355543527994e-19,  -3.101402386058991e-21,  -5.692690666441041e-03,  -3.238846045447178e-04,  -4.073941772127780e-06,   3.726548630886578e-07,   2.011998919265777e-08,
   1.391348330126227e-10,  -2.552320200887035e-11,  -1.087848099276614e-12,  -6.526166819890602e-16,   1.503295365804933e-15,   5.165331627790123e-17,  -2.975611521440145e-19,
  -7.881785773642253e-20,  -2.241468616415009e-21,  -3.684760237386319e-03,  -2.096138238610586e-04,  -2.634238421137612e-06,   2.412360450294573e-07,   1.301440320249588e-08,
   8.955043132113377e-11,  -1.652051365404836e-11,  -7.029189519402597e-13,  -3.709635901262941e-16,   9.726495076219713e-16,   3.331754806425302e-17,  -1.964529952328539e-19,
  -5.095766147776689e-20,  -1.441914864178992e-21,  -1.976622009839293e-03,  -1.124352410669757e-04,  -1.412334474977029e-06,   1.294133238520915e-07,   6.978900627576446e-09,
   4.789767482947090e-11,  -8.862086104062542e-12,  -3.767312715937754e-13,  -1.848427189082520e-16,   5.216482511948347e-16,   1.784049251711677e-17,  -1.064406007362335e-19,
  -2.731881995268822e-20,  -7.710283145186468e-22,  -7.355575343035658e-04,  -4.183929789703545e-05,  -5.254723225182521e-07,   4.815925919402230e-08,   2.596732696275319e-09,
   1.780596573850652e-11,  -3.297829906237201e-12,  -1.401488657710405e-13,  -6.695336439861368e-17,   1.941056965418898e-16,   6.634801156234649e-18,  -3.974631536928660e-20,
  -1.016397330805978e-20,  -2.866031434047301e-22,  -8.308699067874078e-05,  -4.726057592174388e-06,  -5.935446773851228e-08,   5.439981388038246e-09,   2.933156597839018e-10,
   2.010998536933932e-12,  -3.725156427974121e-13,  -1.583013162730055e-14,  -7.530078318294054e-18,   2.192549968670755e-17,   7.493783225594447e-19,  -4.492107791198984e-21,
  -1.148062083364459e-21,  -3.236836350644110e-23,  -1.779998947287190e-04,   5.489653623139517e-06,  -1.124580755028819e-07,   2.313892681367309e-09,  -1.511678560090833e-11,
   3.235800274471350e-13,  -3.797801884731867e-14,  -7.537037230272466e-16,   2.137161742464922e-17,   1.727730911961601e-18,   2.155704473267864e-20,  -1.371046946139049e-21,
  -6.813178589584829e-23,  -5.825854870156554e-25,  -1.693452685490195e-04,   5.222841618510419e-06,  -1.069908154137839e-07,   2.201438958169349e-09,  -1.439836761702344e-11,
   3.073790607309084e-13,  -3.611280688559515e-14,  -7.152096886715371e-16,   2.035986244269138e-17,   1.641440056715709e-18,   2.037676624525446e-20,  -1.305592001697450e-21,
  -6.464316496133428e-23,  -5.455412687322522e-25,  -1.528818308825770e-04,   4.715251084093009e-06,  -9.659036013891036e-08,   1.987500555778298e-09,  -1.302498850833532e-11,
   2.767523184503167e-13,  -3.257222679871801e-14,  -6.427383175926430e-16,   1.842386161311400e-17,   1.478218349736116e-18,   1.818576348098214e-20,  -1.180560437842776e-21,
  -5.807830422656003e-23,  -4.786731345706513e-25,  -1.302192150471561e-04,   4.016449877696671e-06,  -8.227320793299057e-08,   1.692964734546836e-09,  -1.112139081721533e-11,
   2.349637664982625e-13,  -2.771315148694535e-14,  -5.444382918173903e-16,   1.573707071402894e-17,   1.255336336213711e-18,   1.527438147845160e-20,  -1.007471067781418e-21,
  -4.918010860077696e-23,  -3.935516571790804e-25,  -1.035743727742448e-04,   3.194753716767197e-06,  -6.543965350987551e-08,   1.346622610973800e-09,  -8.866753203495902e-12,
   1.862987386220585e-13,  -2.201888175283631e-14,  -4.307079873205501e-16,   1.255093011980595e-17,   9.955718066269572e-19,   1.198312989880671e-20,  -8.027704392776947e-22,
  -3.889394774894057e-23,  -3.021552634168320e-25,  -7.555521358658999e-05,   2.330579077355863e-06,  -4.773725323425074e-08,   9.823690947882345e-10,  -6.480414872541015e-12,
   1.355563747557769e-13,  -1.604832050359986e-14,  -3.128249897211683e-16,   9.175396436085647e-18,   7.245398491093066e-19,   8.644256416585131e-21,  -5.864341536804955e-22,
  -2.824108837175771e-23,  -2.140632044921443e-25,  -4.890522646759341e-05,   1.508565429182137e-06,  -3.089947653498968e-08,   6.358819714796677e-10,  -4.199894403971246e-12,
   8.759566266421877e-14,  -1.038174510695930e-14,  -2.019007745422571e-16,   5.947439555272422e-18,   4.682478061217210e-19,   5.553773430129350e-21,  -3.799358219366968e-22,
  -1.822371186893889e-23,  -1.358526035824482e-25,  -2.623428623830420e-05,   8.092505312460455e-07,  -1.657549750027824e-08,   3.411113130413445e-10,  -2.254403993818631e-12,
   4.694859996728731e-14,  -5.567443130672746e-15,  -1.081451097085203e-16,   3.192699810080268e-18,   2.509812797105547e-19,   2.967810751774690e-21,  -2.039048922674796e-22,
  -9.760303448954900e-24,  -7.213201876494640e-26,  -9.762524353394381e-06,   3.011463221249354e-07,  -6.168221525734096e-09,   1.269377978670029e-10,  -8.391156359036338e-13,
   1.746567502625916e-14,  -2.071590463169614e-15,  -4.022305824603809e-17,   1.188392908789584e-18,   9.337118197493553e-20,   1.102930418000273e-21,  -7.589112633353889e-23,
  -3.630083688050360e-24,  -2.674617997469081e-26,  -1.102753611414282e-06,   3.401685749289131e-08,  -6.967490776161263e-10,   1.433862904142575e-11,  -9.478805076032487e-14,
   1.972791014285616e-15,  -2.339985450362753e-16,  -4.543136508461878e-18,   1.342436370885898e-19,   1.054653878820206e-20,   1.245581725577489e-22,  -8.572717741168872e-24,
  -4.100104899393065e-25,  -3.019466853337778e-27,  -1.600825153098547e-03,   4.813122453177863e-05,  -9.351641819267614e-07,   1.820327260766767e-08,  -5.707538090009036e-11,
   1.224614418498192e-12,  -3.202727260695683e-13,  -7.700548835689327e-15,   2.092940379084754e-16,   1.607035567018364e-17,   2.067780835647138e-19,  -1.282049562927443e-20,
  -6.416837273904383e-22,  -5.724860969783046e-24,  -1.522988307564363e-03,   4.579173011716013e-05,  -8.896880165557496e-07,   1.731820896616798e-08,  -5.444136715396086e-11,
   1.160321375676362e-12,  -3.045188134378123e-13,  -7.308936986386999e-15,   1.993804416940117e-16,   1.526761054353092e-17,   1.954794317495767e-19,  -1.220905849761354e-20,
  -6.088419694437744e-22,  -5.363618316993523e-24,  -1.374922523302281e-03,   4.134108718465748e-05,  -8.031829653236475e-07,   1.563457389168685e-08,  -4.937328876865830e-11,
   1.039964857456155e-12,  -2.746242203340855e-13,  -6.571010188502804e-15,   1.804130448188056e-16,   1.374923932343697e-17,   1.744969246426249e-19,  -1.104083255889585e-20,
  -5.470345718282716e-22,  -4.710659080160147e-24,  -1.171105532781205e-03,   3.521402275280985e-05,  -6.841107127696686e-07,   1.331697171875810e-08,  -4.228554639962187e-11,
   8.780478952409810e-13,  -2.336160548209271e-13,  -5.568811487545708e-15,   1.540944328198363e-16,   1.167596677454138e-17,   1.465991605211163e-19,  -9.423077469915673e-21,
  -4.632475129074883e-22,  -3.877672945940826e-24,  -9.314765380328719e-04,   2.800960612723014e-05,  -5.441223702293690e-07,   1.059211882700616e-08,  -3.381162202217473e-11,
   6.924148994077670e-13,  -1.855834843971637e-13,  -4.407661239820732e-15,   1.228898357862735e-16,   9.259725131256605e-18,   1.150400104507149e-19,  -7.509245325738823e-21,
  -3.663765591267088e-22,  -2.980871340475431e-24,  -6.794898242963369e-04,   2.043292322600003e-05,  -3.969200637143909e-07,   7.726716977548901e-09,  -2.476955876630212e-11,
   5.016019753757251e-13,  -1.352430300764867e-13,  -3.202568104630250e-15,   8.983523838372244e-17,   6.738788931936371e-18,   8.300368079000236e-20,  -5.486051554380569e-21,
  -2.660386867963441e-22,  -2.114064660323990e-24,  -4.398180762280774e-04,   1.322601029177236e-05,  -2.569154160118191e-07,   5.001333683551386e-09,  -1.607755900372257e-11,
   3.231822110591615e-13,  -8.748160492556424e-14,  -2.067516581320471e-15,   5.822910251793713e-17,   4.355032161099702e-18,   5.333581729965678e-20,  -3.554465511399320e-21,
  -1.716769105411830e-22,  -1.342652376800734e-24,  -2.359319099605496e-04,   7.094906795281994e-06,  -1.378168228916811e-07,   2.682871018010912e-09,  -8.636832260728805e-12,
   1.729540097427807e-13,  -4.691180587845183e-14,  -1.107584048141586e-15,   3.125806759134633e-17,   2.334290463830177e-18,   2.850353060108290e-20,  -1.907671942684356e-21,
  -9.194843943517245e-23,  -7.131683511952179e-25,  -8.779695066621529e-05,   2.640224857073006e-06,  -5.128548270021598e-08,   9.983726252926019e-10,  -3.215607673089381e-12,
   6.430790495877345e-14,  -1.745513824580128e-14,  -4.119698086395174e-16,   1.163488257334210e-17,   8.684117832699071e-19,   1.059306489511680e-20,  -7.100210235339948e-22,
  -3.419792575325091e-23,  -2.644752568573799e-25,  -9.917352967703502e-06,   2.982342291677092e-07,  -5.793095668479736e-09,   1.127740095887756e-10,  -3.632566980847210e-13,
   7.263128193609560e-15,  -1.971657341585228e-15,  -4.653174528522035e-17,   1.314302494357072e-18,   9.808953861948499e-20,   1.196320388697106e-21,  -8.020462171939800e-23,
  -3.862588353079338e-24,  -2.985815700016286e-26,  -4.433606274059335e-03,   1.255154296324640e-04,  -2.118965298815440e-06,   3.493725916625879e-08,   2.853467751581064e-10,
  -5.018007428950831e-12,  -8.251785601884461e-13,  -2.532153560109214e-14,   6.453909734934772e-16,   4.887597931840121e-17,   6.405791738679030e-19,  -3.843184189705181e-20,
  -1.969770919372617e-21,  -1.905297318308639e-23,  -4.218017125587132e-03,   1.194134308318530e-04,  -2.015848122996790e-06,   3.323635964716786e-08,   2.711015039038629e-10,
  -4.789494660271915e-12,  -7.844996526380120e-13,  -2.403801226841488e-14,   6.148249170864153e-16,   4.643541074681325e-17,   6.056108391583315e-19,  -3.660318461202447e-20,
  -1.869063999282495e-21,  -1.786729535100972e-23,  -3.807916619942362e-03,   1.078054738853511e-04,  -1.819728013209885e-06,   3.000167599076423e-08,   2.441544483662028e-10,
  -4.348466632547278e-12,  -7.073431158918722e-13,  -2.161778469461632e-14,   5.563420936301034e-16,   4.181878291945977e-17,   5.406591870509851e-19,  -3.310751562389482e-20,
  -1.679493145871195e-21,  -1.571882183689777e-23,  -3.243412108758643e-03,   9.182603827562274e-05,  -1.549831333411327e-06,   2.555072325187303e-08,   2.073536961539985e-10,
  -3.729134738957651e-12,  -6.015724657374299e-13,  -1.832759929053417e-14,   4.751897667725126e-16,   3.551428276968026e-17,   4.542765563923266e-19,  -2.826329803763077e-20,
  -1.422425451515106e-21,  -1.296727042598624e-23,  -2.579734481894507e-03,   7.303797940722744e-05,  -1.232598617183810e-06,   2.031985248649767e-08,   1.644567631244741e-10,
  -2.985551865405236e-12,  -4.777725671769631e-13,  -1.451147930274074e-14,   3.789675879254796e-16,   2.816600213102253e-17,   3.565250479519713e-19,  -2.252824580385375e-20,
  -1.125111106876257e-21,  -9.990478021027750e-24,  -1.881843998388132e-03,   5.328014967164821e-05,  -8.990867663956705e-07,   1.482123228121099e-08,   1.196920779817888e-10,
  -2.189297983782599e-12,  -3.481073352753440e-13,  -1.054707270412757e-14,   2.770369159034107e-16,   2.049852227037082e-17,   2.572653005069429e-19,  -1.646157840582994e-20,
  -8.170597179450630e-22,  -7.098740652497978e-24,  -1.218069675979534e-03,   3.448730719451131e-05,  -5.819305809130148e-07,   9.592750186353838e-09,   7.735629074200850e-11,
  -1.421952787032279e-12,  -2.251436087843672e-13,  -6.810342459869618e-15,   1.795701724103119e-16,   1.324771651549242e-17,   1.653222670902557e-19,  -1.066691111778141e-20,
  -5.272882987066091e-22,  -4.514301915176521e-24,  -6.534087058077265e-04,   1.850013130224913e-05,  -3.121578377607013e-07,   5.145654867007187e-09,   4.146389544963167e-11,
  -7.641193892731413e-13,  -1.207248105263519e-13,  -3.648725035454805e-15,   9.639574516087162e-17,   7.100830578170709e-18,   8.835391645160758e-20,  -5.725257734730924e-21,
  -2.824194395757069e-22,  -2.399473170467839e-24,  -2.431517383171730e-04,   6.884433775665331e-06,  -1.161617972888115e-07,   1.914819313506769e-09,   1.542569589706185e-11,
  -2.845239897791504e-13,  -4.491875868990520e-14,  -1.357204659295337e-15,   3.588048566140831e-17,   2.641688229200460e-18,   3.283627845642365e-20,  -2.130943465350868e-21,
  -1.050400339558465e-22,  -8.900478857646861e-25,  -2.746588967666156e-05,   7.776508848698015e-07,  -1.312136687759345e-08,   2.162933902900977e-10,   1.742377936887869e-12,
  -3.214232189192961e-14,  -5.073811376605971e-15,  -1.532963294351379e-16,   4.053141174246934e-18,   2.983862447410462e-19,   3.708349167225304e-21,  -2.407141389324156e-22,
  -1.186408601899878e-23,  -1.004865556272304e-25,  -8.607375629074189e-03,   2.151299818299486e-04,  -2.449080899198974e-06,   1.802066168122571e-08,   1.792685824181230e-09,
  -2.535131002774363e-11,  -1.831818249589892e-12,  -5.435967381854199e-14,   1.331111402504070e-15,   1.142637225670035e-16,   1.502707390822663e-18,  -8.660385757844899e-20,
  -4.571726473531179e-21,  -5.039005941785109e-23,  -8.188782382064065e-03,   2.046675811427521e-04,  -2.329639005998480e-06,   1.713649123124777e-08,   1.704676387483534e-09,
  -2.415158118009360e-11,  -1.741598902374079e-12,  -5.159428984764319e-14,   1.268304055408993e-15,   1.085632645598568e-16,   1.420767706215986e-18,  -8.249983227879718e-20,
  -4.338345655108197e-21,  -4.731552230571251e-23,  -7.392541295563711e-03,   1.847662641786819e-04,  -2.102576388755506e-06,   1.545779061058896e-08,   1.537603470255882e-09,
  -2.185589482742202e-11,  -1.570444178234760e-12,  -4.638373641983964e-14,   1.148033252706352e-15,   9.777808597609847e-17,   1.268535298609759e-18,  -7.464746713555998e-20,
  -3.898886377138494e-21,  -4.172447471248871e-23,  -6.296552436556016e-03,   1.573731953203422e-04,  -1.790302140914944e-06,   1.315326499886983e-08,   1.308288391129703e-09,
  -1.866975789907200e-11,  -1.335749769658868e-12,  -3.930783133295485e-14,   9.809515730157474e-16,   8.304574405203041e-17,   1.066006702787630e-18,  -6.375228761700435e-20,
  -3.302683196933975e-21,  -3.452393666235219e-23,  -5.008068092880447e-03,   1.251691230102675e-04,  -1.423518726479240e-06,   1.045175825964145e-08,   1.039522829252752e-09,
  -1.489097231373798e-11,  -1.060967080586398e-12,  -3.111056776769414e-14,   7.826064412058468e-16,   6.586920863106152e-17,   8.367377005452683e-19,  -5.083668182379878e-20,
  -2.612794864900220e-21,  -2.668018508853559e-23,  -3.653208205118441e-03,   9.130627765249443e-05,  -1.038155108985255e-06,   7.618355022475812e-09,   7.576807457818809e-10,
  -1.088685646902477e-11,  -7.730881161919882e-13,  -2.260394857267136e-14,   5.722779964643722e-16,   4.794180291618277e-17,   6.038501561003890e-19,  -3.715884947423503e-20,
  -1.897675040565856e-21,  -1.900678140039726e-23,  -2.364612728482771e-03,   5.909976124415227e-05,  -6.718593797300308e-07,   4.928636911265539e-09,   4.901615515062822e-10,
  -7.057160916539296e-12,  -5.000330127062393e-13,  -1.459236593772504e-14,   3.710115899981203e-16,   3.098529826085788e-17,   3.880715380984321e-19,  -2.408362563107752e-20,
  -1.224769811059871e-21,  -1.210844952420968e-23,  -1.268444037251125e-03,   3.170273659382855e-05,  -3.603744615108324e-07,   2.643169583628602e-09,   2.628639726495470e-10,
  -3.788525353836103e-12,  -2.681313071465426e-13,  -7.817153327219663e-15,   1.991837877529432e-16,   1.660869613295270e-17,   2.074068118170910e-19,  -1.292782495011112e-20,
  -6.560252456770903e-22,  -6.441967070852296e-24,  -4.720230995900068e-04,   1.179746240724954e-05,  -1.341014686773071e-07,   9.835073060694814e-10,   9.780958736519801e-11,
  -1.410186296046429e-12,  -9.976607705297592e-14,  -2.907606701541126e-15,   7.414285600767782e-17,   6.178912341843478e-18,   7.708271325738486e-20,  -4.811923911347585e-21,
  -2.439987739490097e-22,  -2.390332280349845e-24,  -5.331868897936834e-05,   1.332615307147708e-06,  -1.514773763442124e-08,   1.110932189185593e-10,   1.104818755168064e-11,
  -1.592981895238625e-13,  -1.126912319757517e-14,  -3.284122503866507e-16,   8.375390946487043e-18,   6.979268716774132e-19,   8.705317433274890e-21,  -5.435644245850686e-22,
  -2.755929859001893e-23,  -2.698829910934843e-25,  -1.382601321957389e-02,   2.566208052382464e-04,   8.371394342685916e-07,  -8.200446668274806e-08,   4.485782570956453e-09,
  -1.363753051543741e-11,  -5.345967720908537e-12,  -9.336989492221949e-14,   2.825427351491212e-15,   2.355101023909544e-16,   3.671077089737093e-18,  -1.853182409624144e-19,
  -1.014906403081287e-20,  -1.280447473176837e-22,  -1.315348531688320e-02,   2.441313625610470e-04,   7.972150581281101e-07,  -7.801997239668149e-08,   4.265217720769414e-09,
  -1.303131343267275e-11,  -5.083559029037555e-12,  -8.857839691534189e-14,   2.692748884788367e-15,   2.237491727433360e-16,   3.472857556919200e-18,  -1.765814241725529e-19,
  -9.632422048896922e-21,  -1.203533289446871e-22,  -1.187427178839055e-02,   2.203780063380786e-04,   7.209509317611139e-07,  -7.043931769894113e-08,   3.846645202367919e-09,
  -1.185478982181842e-11,  -4.585389631017513e-12,  -7.956647612865546e-14,   2.438412096481218e-15,   2.015021770131364e-16,   3.103874155311399e-18,  -1.598457243597597e-19,
  -8.658993213375458e-21,  -1.063261512488966e-22,  -1.011360592192984e-02,   1.876900860716750e-04,   6.153557918690852e-07,  -6.000213010194812e-08,   3.272402581492590e-09,
  -1.019022588626805e-11,  -3.901588046136410e-12,  -6.736005239723078e-14,   2.084568613813115e-15,   1.711221106060391e-16,   2.611563769495103e-18,  -1.365881825507510e-19,
  -7.337242807099560e-21,  -8.818026267140045e-23,  -8.043845069019553e-03,   1.492704361199609e-04,   4.904289480735409e-07,  -4.772825316915516e-08,   2.599708754065360e-09,
  -8.176496421103206e-12,  -3.100106165351090e-12,  -5.325977033489260e-14,   1.663871585017628e-15,   1.357133112655456e-16,   2.052410211434351e-18,  -1.089722520640456e-19,
  -5.806385834071389e-21,  -6.830592303654499e-23,  -5.867594014078354e-03,   1.088804377153132e-04,   3.583351216948632e-07,  -3.481876195040361e-08,   1.894603350197947e-09,
  -6.006361861223320e-12,  -2.259600234537180e-12,  -3.866561357154907e-14,   1.217164992125738e-15,   9.876761570439831e-17,   1.482662248868075e-18,  -7.968508306020709e-20,
  -4.218232525316110e-21,  -4.875664292619101e-23,  -3.797873324557967e-03,   7.047204263440315e-05,   2.321895442878014e-07,  -2.253830248897208e-08,   1.225554096216639e-09,
  -3.905615275660533e-12,  -1.461793521983449e-12,  -2.494785261971694e-14,   7.892942347080735e-16,   6.383066015391018e-17,   9.534949298858227e-19,  -5.165969700244407e-20,
  -2.722917009234255e-21,  -3.110265575749516e-23,  -2.037272405685363e-03,   3.780233245727794e-05,   1.246217537500173e-07,  -1.209049161245885e-08,   6.572102970943715e-10,
  -2.099998077093243e-12,  -7.839321182981197e-13,  -1.336090683746141e-14,   4.238002834137674e-16,   3.421334042520757e-17,   5.097786199628164e-19,  -2.773411292040150e-20,
  -1.458602756629054e-21,  -1.655896181406233e-23,  -7.581237776240821e-04,   1.406718549144987e-05,   4.638411349481698e-08,  -4.499247637217686e-09,   2.445387967467315e-10,
  -7.821038401149818e-13,  -2.916950137177659e-13,  -4.969138236427983e-15,   1.577596586778486e-16,   1.272820573791568e-17,   1.894823241880726e-19,  -1.032352444587803e-20,
  -5.425213497917325e-22,  -6.145825588883461e-24,  -8.563596202206032e-05,   1.588996338627734e-06,   5.239606987231347e-09,  -5.082258389434174e-10,   2.762207369374384e-11,
  -8.835613269269180e-14,  -3.294872741450753e-14,  -5.612522768750885e-16,   1.782111244791471e-17,   1.437686889208217e-18,   2.139955582990969e-20,  -1.166174397111471e-21,
  -6.127726407375075e-23,  -6.939282223661949e-25,  -1.879919701779478e-02,   7.038462084053806e-05,   1.271657118976262e-05,  -1.443034769916178e-07,  -8.277131451833041e-10,
   2.482854602178079e-10,  -1.072126959934046e-11,  -4.921976474939122e-13,   1.142065910575203e-14,   7.032027683121333e-16,   3.489815963518736e-18,  -4.533408145686568e-19,
  -2.210772043809493e-20,  -4.706814631875172e-22,  -1.788442004568055e-02,   6.694835953055567e-05,   1.209787371879753e-05,  -1.372116274692023e-07,  -7.921975269507363e-10,
   2.359049995704978e-10,  -1.019025209596359e-11,  -4.675095477410158e-13,   1.086947484243566e-14,   6.682477252290598e-16,   3.277275091039353e-18,  -4.323196854066139e-19,
  -2.098026501012634e-20,  -4.432098740328437e-22,  -1.614456442035860e-02,   6.041738503407263e-05,   1.092110476077982e-05,  -1.237518740689307e-07,  -7.227084613240327e-10,
   2.124800761179327e-10,  -9.184066069501129e-12,  -4.208549120762750e-13,   9.819225250263854e-15,   6.020622744421440e-16,   2.890535699225778e-18,  -3.919021226030520e-19,
  -1.885666045395624e-20,  -3.928405452408265e-22,  -1.375015635832979e-02,   5.143831052017595e-05,   9.301545633515122e-06,  -1.052836666684644e-07,  -6.233201947836960e-10,
   1.804784473600778e-10,  -7.806676817663742e-12,  -3.572304352620198e-13,   8.370200665095330e-15,   5.115555428563972e-16,   2.392098125726957e-18,  -3.354469074380404e-19,
  -1.597462108453209e-20,  -3.271437636546842e-22,  -1.093573780016814e-02,   4.089547280954001e-05,   7.397798922111240e-06,  -8.364565821943411e-08,  -5.017506237066961e-10,
   1.431611395356511e-10,  -6.196969064815087e-12,  -2.831807228854422e-13,   6.662483828335490e-15,   4.059084640907097e-16,   1.848801292097861e-18,  -2.680571727951299e-19,
  -1.263866489524930e-20,  -2.544720430935876e-22,  -7.976834459308449e-03,   2.982190457389554e-05,   5.396231249653626e-06,  -6.096169990661517e-08,  -3.695210419410452e-10,
   1.042049092051714e-10,  -4.513296430613533e-12,  -2.060136723233969e-13,   4.862996181304751e-15,   2.955269327149792e-16,   1.317115698039018e-18,  -1.962659083955355e-19,
  -9.179929351120428e-21,  -1.822782648962062e-22,  -5.162996535550449e-03,   1.929859983442461e-05,   3.492733409004518e-06,  -3.943525884366190e-08,  -2.406807164593734e-10,
   6.735217060068328e-11,  -2.918253480497057e-12,  -1.331086662495861e-13,   3.148918580449110e-15,   1.910420147371452e-16,   8.390781284825375e-19,  -1.273454231127240e-19,
  -5.924941963921501e-21,  -1.165553636737590e-22,  -2.769527969549012e-03,   1.035114084129951e-05,   1.873575575698496e-06,  -2.114771894129442e-08,  -1.295210606731538e-10,
   3.610299901599396e-11,  -1.564586828366521e-12,  -7.133770899920455e-14,   1.689508207851182e-15,   1.024130290094363e-16,   4.464040663480843e-19,  -6.839609459451375e-20,
  -3.173626009686513e-21,  -6.213099013087155e-23,  -1.030611852380463e-03,   3.851794862916854e-06,   6.972061960682161e-07,  -7.868815696995490e-09,  -4.825187856163569e-11,
   1.343148296348941e-11,  -5.821165005455512e-13,  -2.653825497419823e-14,   6.287566941120907e-16,   3.810200900473342e-17,   1.656402518064876e-19,  -2.546299016362725e-20,
  -1.180387684754588e-21,  -2.306986392745881e-23,  -1.164155342902123e-04,   4.350875542207745e-07,   7.875482000531864e-08,  -8.888291073244310e-10,  -5.451384957790626e-12,
   1.517129035401412e-12,  -6.575263372782402e-14,  -2.997550817021972e-15,   7.102375777271124e-17,   4.303762795751577e-18,   1.870177251943717e-20,  -2.876438695145390e-21,
  -1.333231209386270e-22,  -2.605010741501070e-24,  -1.653662350718501e-02,  -7.863253284997294e-04,   5.333157942722764e-06,   1.592911319852139e-06,   3.473343976343845e-08,
  -1.836500745587618e-09,  -1.093297434720522e-10,   7.507291839751892e-14,   1.790076073707053e-13,   4.718858421535112e-15,  -1.510256461070413e-16,  -1.129437053270809e-17,
  -7.667080336575422e-20,   1.476558467366936e-20,  -1.573210915639237e-02,  -7.479371834182920e-04,   5.079829225246144e-06,   1.514885816433368e-06,   3.299580419734945e-08,
  -1.747102735977140e-09,  -1.038640603929339e-10,   7.634745152693634e-14,   1.700974856569865e-13,   4.471188076194441e-15,  -1.438154073956084e-16,  -1.071111188950416e-17,
  -7.160851212475329e-20,   1.402232220306286e-20,  -1.420189978210780e-02,  -6.749759775609939e-04,   4.595487301688222e-06,   1.366694354439197e-06,   2.971030231452002e-08,
  -1.577081882724177e-09,  -9.352804130047320e-11,   7.674291274106727e-14,   1.532317539371920e-13,   4.007541960053596e-15,  -1.300420061084015e-16,  -9.615547564220965e-18,
  -6.253346659721616e-20,   1.261851628659047e-20,  -1.209587906629693e-02,  -5.746646929922219e-04,   3.924046812347043e-06,   1.163156451204680e-06,   2.522626078374464e-08,
  -1.343119432381648e-09,  -7.941847253310745e-11,   7.337965704443153e-14,   1.301779285731233e-13,   3.383759366536610e-15,  -1.109742235290635e-16,  -8.134425120917198e-18,
  -5.110487045120180e-20,   1.070588338260234e-20,  -9.620270435994753e-03,  -4.568823743690902e-04,   3.128661220473675e-06,   9.244277694192919e-07,   2.000300231535489e-08,
  -1.068151196730550e-09,  -6.297910869989875e-11,   6.451953051698742e-14,   1.032792616083321e-13,   2.668536527460278e-15,  -8.842442067604017e-17,  -6.427053972615164e-18,
  -3.899586403542812e-20,   8.482520534577696e-21,  -7.017417711095160e-03,  -3.331697866337006e-04,   2.286709046898636e-06,   6.739212093986948e-07,   1.455561976478271e-08,
  -7.791045674743348e-10,  -4.583088012517083e-11,   5.066530802691938e-14,   7.518567986955491e-14,   1.933257214218255e-15,  -6.459383145383533e-17,  -4.663212365395648e-18,
  -2.748341131611189e-20,   6.168417336792421e-21,  -4.542067377700447e-03,  -2.156039566378272e-04,   1.482024411671394e-06,   4.360311515566018e-07,   9.406098977251324e-09,
  -5.042587272174792e-10,  -2.961789972254427e-11,   3.432881034296145e-14,   4.860001778950951e-14,   1.245647143916726e-15,  -4.184803320032614e-17,  -3.007641815444880e-18,
  -1.737986534753467e-20,   3.984344252501198e-21,  -2.436464315627788e-03,  -1.156430386146923e-04,   7.955237422209898e-07,   2.338502177976170e-07,   5.041475914009021e-09,
  -2.704893372218763e-10,  -1.587490848495728e-11,   1.883681899666271e-14,   2.605236940732968e-14,   6.666341194480785e-16,  -2.245890436705178e-17,  -1.610433374489509e-18,
  -9.210681588751579e-21,   2.135022913323421e-21,  -9.066722494694903e-04,  -4.303229891937964e-05,   2.961043086910908e-07,   8.701578313556145e-08,   1.875526547753485e-09,
  -1.006553787728933e-10,  -5.905814689835491e-12,   7.064293256410630e-15,   9.692471075323009e-15,   2.478703522280497e-16,  -8.358926698182346e-18,  -5.989049497899384e-19,
  -3.413019643955367e-21,   7.942040274750913e-22,  -1.024156363724214e-04,  -4.860803647828600e-06,   3.344850755192295e-08,   9.828997273566271e-09,   2.118455584201858e-10,
  -1.136978849401044e-11,  -6.670777406822282e-13,   7.989452707838767e-16,   1.094798296546832e-15,   2.799525725668598e-17,  -9.442300515328667e-19,  -6.764413963698308e-20,
  -3.852668617003866e-22,   8.970621005012452e-23,  -1.571229704425661e-04,   4.680788411054518e-06,  -8.580525058353757e-08,   2.062050606289644e-09,  -1.875289242777534e-11,
  -7.019324462257215e-13,  -3.979172006231739e-14,   9.140834013949761e-16,   7.587916192567238e-17,   5.069757840452170e-19,  -1.452824885914835e-04,   4.328211687728876e-06,
  -7.934207312192244e-08,   1.906303759001658e-09,  -1.736508197423098e-11,  -6.481738581718557e-13,  -3.670005356130014e-14,   8.459241707064534e-16,   6.997046556095150e-17,
   4.616617906251028e-19,  -1.234018534509119e-04,   3.676571268068553e-06,  -6.739666684999596e-08,   1.618705929406641e-09,  -1.478507378948381e-11,  -5.493508672241186e-13,
  -3.104329791587295e-14,   7.195184253664393e-16,   5.916703982433762e-17,   3.822725464582410e-19,  -9.480962402753141e-05,   2.824889041258677e-06,  -5.178420382141447e-08,
   1.243249156085797e-09,  -1.138807304529269e-11,  -4.210846351759037e-13,  -2.374532510988879e-14,   5.536047730128025e-16,   4.524214258068407e-17,   2.857181805157379e-19,
  -6.385785087010949e-05,   1.902764453283595e-06,  -3.488039323203700e-08,   8.371620752967705e-10,  -7.685473246726176e-12,  -2.830957099058302e-13,  -1.593773173003210e-14,
   3.732904615057101e-16,   3.035806252815254e-17,   1.882381901300294e-19,  -3.525974827435369e-05,   1.050660715064216e-06,  -1.926012535156124e-08,   4.621795445787073e-10,
  -4.248438727413446e-12,  -1.561481298565559e-13,  -8.782479291847768e-15,   2.062473970646900e-16,   1.672615477787515e-17,   1.026040105934164e-19,  -1.337080752635952e-05,
   3.984241342428146e-07,  -7.303690469029812e-09,   1.752529043832734e-10,  -1.611732351559731e-12,  -5.918910682006367e-14,  -3.327875757761778e-15,   7.822943097222523e-17,
   6.337532414440828e-18,   3.871887745362545e-20,  -1.524452944899115e-06,   4.542582311055214e-08,  -8.327210538847301e-10,   1.998101955331395e-11,  -1.837722710979382e-13,
  -6.747912080580310e-15,  -3.793752855224119e-16,   8.919564334946700e-18,   7.224666864087190e-19,   4.410897584397944e-21,  -1.416966171875233e-03,   4.136297355377053e-05,
  -7.203918294891632e-07,   1.695652917693109e-08,  -1.202361536177578e-10,  -7.710984706785110e-12,  -3.515504082465730e-13,   8.183551499356241e-15,   7.187017147409857e-16,
   4.756653074091403e-18,  -1.310183991629664e-03,   3.824717217835421e-05,  -6.661194161262018e-07,   1.567495269967778e-08,  -1.114004004794760e-10,  -7.122143989979936e-12,
  -3.241775243051355e-13,   7.573654962137478e-15,   6.627528644987348e-16,   4.330809161919171e-18,  -1.112857137478651e-03,   3.248857763516765e-05,  -5.658176897651569e-07,
   1.330894078436150e-08,  -9.493571917059051e-11,  -6.038674045319205e-12,  -2.741285214661673e-13,   6.442362429903770e-15,   5.604467077946245e-16,   3.585093930015287e-18,
  -8.550052727925805e-04,   2.496236806942101e-05,  -4.347347205651131e-07,   1.022098473755367e-08,  -7.319357917404269e-11,  -4.630683528637630e-12,  -2.096166814820976e-13,
   4.957163808877080e-15,   4.285647572263776e-16,   2.678763794482256e-18,  -5.758768138209208e-04,   1.681383588473563e-05,  -2.928192884233747e-07,   6.881955529427920e-09,
  -4.943317046432840e-11,  -3.114256477803911e-12,  -1.406580096405254e-13,   3.342747684608705e-15,   2.875823439472628e-16,   1.764398312718841e-18,  -3.179756637209755e-04,
   9.284163061433054e-06,  -1.616859898728958e-07,   3.799219805060034e-09,  -2.733781147591658e-11,  -1.718074651652102e-12,  -7.749817592642923e-14,   1.846963863033383e-15,
   1.584502379693835e-16,   9.615882353990366e-19,  -1.205791115138272e-04,   3.520670136368259e-06,  -6.131316741516205e-08,   1.440595100009493e-09,  -1.037282734161187e-11,
  -6.512964008789912e-13,  -2.936415547136196e-14,   7.005594863163247e-16,   6.003717096110830e-17,   3.628466443942571e-19,  -1.374764874506761e-05,   4.014046602717889e-07,
  -6.990538388375444e-09,   1.642453924101366e-10,  -1.182757673495759e-12,  -7.425258131431912e-14,  -3.347460613539838e-15,   7.987655090942900e-17,   6.844132198760234e-18,
   4.133550557231841e-20,  -3.948944941814237e-03,   1.099199237736822e-04,  -1.673800153163299e-06,   3.731580795161100e-08,  -5.109074996144694e-11,  -2.920403767818732e-11,
  -9.691315563455887e-13,   2.338707115500011e-14,   2.204455408622069e-15,   1.488527701718964e-17,  -3.651338785552263e-03,   1.016388192086441e-04,  -1.547640649692675e-06,
   3.449012419716267e-08,  -4.786661828396487e-11,  -2.698093210832822e-11,  -8.934007075807863e-13,   2.164601458740885e-14,   2.032872924946970e-15,   1.355458006278427e-17,
  -3.101389955496047e-03,   8.633438021572506e-05,  -1.314519419287089e-06,   2.927664923261175e-08,  -4.152826265036538e-11,  -2.288622042279961e-11,  -7.550924994890085e-13,
   1.841534138684229e-14,   1.719106384305323e-15,   1.122334513756453e-17,  -2.382773139681102e-03,   6.633324063491295e-05,  -1.009916796497323e-06,   2.247776639026755e-08,
  -3.261375507868465e-11,  -1.755803886459688e-11,  -5.770844929429751e-13,   1.417205102499463e-14,   1.314605029416792e-15,   8.388274875689376e-18,  -1.604874546409502e-03,
   4.467928530527995e-05,  -6.802020979213500e-07,   1.513142348087692e-08,  -2.234058654291385e-11,  -1.181250431307191e-11,  -3.870739680548353e-13,   9.557695847332597e-15,
   8.821638109044822e-16,   5.526251031018574e-18,  -8.861433635379703e-04,   2.467054243979105e-05,  -3.755756410783636e-07,   8.352355078101694e-09,  -1.245451516842649e-11,
  -6.518089010179592e-12,  -2.132132886310007e-13,   5.281248833683835e-15,   4.860541272821874e-16,   3.012174333947065e-18,  -3.360327952510694e-04,   9.355348509731320e-06,
  -1.424209248613012e-07,   3.166915004012894e-09,  -4.739781150794785e-12,  -2.471103963268018e-12,  -8.077931044363405e-14,   2.003244393876273e-15,   1.841678132049570e-16,
   1.136673700706333e-18,  -3.831227364409424e-05,   1.066637450973193e-06,  -1.623789950827474e-08,   3.610641296354503e-10,  -5.407188313102863e-13,  -2.817276981683935e-13,
  -9.208554025171140e-15,   2.284073049475589e-16,   2.099482192140249e-17,   1.294909974480511e-19,  -7.757027311507091e-03,   1.961505254346580e-04,  -2.079043526930298e-06,
   3.973834734119657e-08,   7.617175831166834e-10,  -7.853195848137356e-11,  -2.111234805765106e-12,   5.412486068871069e-14,   5.009730473763471e-15,   3.709494937156665e-17,
  -7.172377534776576e-03,   1.813694578306605e-04,  -1.922123869510210e-06,   3.670850111921906e-08,   7.029323869491165e-10,  -7.256194483003832e-11,  -1.946006230639029e-12,
   5.009961627723170e-14,   4.619570728285998e-15,   3.380501359364925e-17,  -6.092030695349833e-03,   1.540544824930409e-04,  -1.632293615922528e-06,   3.113081318422093e-08,
   5.951409786812369e-10,  -6.156101121252810e-11,  -1.644394127814847e-12,   4.262791972708359e-14,   3.906234393028047e-15,   2.802788978903910e-17,  -4.680397875740204e-03,
   1.183605405108651e-04,  -1.253810985210374e-06,   2.387779267791276e-08,   4.556828786529707e-10,  -4.723810853557297e-11,  -1.256454410241145e-12,   3.281013635240715e-14,
   2.986843042561271e-15,   2.097861469848074e-17,  -3.152366736029400e-03,   7.972054528747610e-05,  -8.443407334383198e-07,   1.606140106604958e-08,   3.060930830311051e-10,
  -3.178523417836403e-11,  -8.426037202713913e-13,   2.212973258928690e-14,   2.004175772802942e-15,   1.383747863243420e-17,  -1.740592384510399e-03,   4.401857695318163e-05,
  -4.661639790102630e-07,   8.861713065434774e-09,   1.687495178100627e-10,  -1.754051859496665e-11,  -4.640860570249540e-13,   1.222888731839579e-14,   1.104214539292257e-15,
   7.547740450249592e-18,  -6.600453776034118e-04,   1.669224452545569e-05,  -1.767667796369238e-07,   3.359478889208359e-09,   6.395391892604901e-11,  -6.650092844081362e-12,
  -1.758196462383734e-13,   4.638680863704415e-15,   4.183847746216978e-16,   2.848990785609594e-18,  -7.525405321220142e-05,   1.903141921722461e-06,  -2.015367742361141e-08,
   3.830078837980637e-10,   7.290905610020551e-12,  -7.581735873811492e-13,  -2.004268413615405e-14,   5.288983899788184e-16,   4.769504098708393e-17,   3.245745977892732e-19,
  -1.274631233475349e-02,   2.596275716738768e-04,   2.495520316801559e-07,  -1.991820589638527e-08,   2.796296335585827e-09,  -1.542634966655026e-10,  -5.334440365042169e-12,
   1.358494158395391e-13,   1.062997015143444e-14,   8.038441665948007e-17,  -1.178545707540063e-02,   2.400535603312587e-04,   2.314676135069581e-07,  -1.848399869051122e-08,
   2.582046349514260e-09,  -1.425091084049903e-10,  -4.919423187650206e-12,   1.257271539611213e-13,   9.801508829405251e-15,   7.320247585925243e-17,  -1.001003528475045e-02,
   2.038871547269881e-04,   1.976115581982204e-07,  -1.579323005226390e-08,   2.188263678242335e-09,  -1.208656290320809e-10,  -4.160400940543297e-12,   1.069500891351261e-13,
   8.287165737558871e-15,   6.061845717128100e-17,  -7.690347035377921e-03,   1.566362390357118e-04,   1.526428058892669e-07,  -1.220972559595213e-08,   1.677253058132169e-09,
  -9.271375031773838e-11,  -3.181706030853612e-12,   8.229668890401812e-14,   6.335975141642636e-15,   4.531102473376120e-17,  -5.179546617006817e-03,   1.054949762844663e-04,
   1.032436375530556e-07,  -8.263847153293964e-09,   1.127583549435202e-09,  -6.236806886517848e-11,  -2.135211865456732e-12,   5.549615931922556e-14,   4.251085610691679e-15,
   2.985400623884694e-17,  -2.859877181164642e-03,   5.824837111817930e-05,   5.714484359443893e-08,  -4.575747564548963e-09,   6.219354213690320e-10,  -3.441224037646686e-11,
  -1.176501689070323e-12,   3.066363336559928e-14,   2.342049230165588e-15,   1.627334001656791e-17,  -1.084481954990847e-03,   2.208804955048088e-05,   2.168944765759140e-08,
  -1.736983369745874e-09,   2.357479229349568e-10,  -1.304587710030491e-11,  -4.457874569583837e-13,   1.163087633403678e-14,   8.873814379083140e-16,   6.141038843372090e-18,
  -1.236454499381213e-04,   2.518331807413070e-06,   2.473261189798987e-09,  -1.980739874904939e-10,   2.687664862769171e-11,  -1.487339421165034e-12,  -5.081914352190085e-14,
   1.326133019333774e-15,   1.011594250287414e-16,   6.995957849671112e-19,  -1.826145217742907e-02,   1.646580781583365e-04,   1.097544977268327e-05,  -1.349776825953183e-07,
   7.574130349821370e-10,  -1.096984530287355e-10,  -1.565779564485078e-11,   2.451137151473655e-13,   3.127170952373315e-14,   1.180197211811117e-16,  -1.688438471241042e-02,
   1.522279614321876e-04,   1.014827203493151e-05,  -1.248501948064479e-07,   6.901639377005128e-10,  -1.012026086414554e-10,  -1.443951665064400e-11,   2.268023826375226e-13,
   2.883860002337503e-14,   1.064382697011502e-16,  -1.434018675134833e-02,   1.292708768621407e-04,   8.619738489321786e-06,  -1.061082819290517e-07,   5.720666951547746e-10,
  -8.564101465482024e-11,  -1.221147221939833e-11,   1.928623207445785e-13,   2.438872162236308e-14,   8.668355009677091e-17,  -1.101651754615951e-02,   9.929399788900516e-05,
   6.622436487925069e-06,  -8.157295472744406e-08,   4.280123783169860e-10,  -6.553718513640252e-11,  -9.338703453181349e-12,   1.483487128248225e-13,   1.865113306479984e-14,
   6.358722113623493e-17,  -7.419485051764485e-03,   6.686509897348580e-05,   4.460401856049860e-06,  -5.496888553467795e-08,   2.821986638226818e-10,  -4.400345027125878e-11,
  -6.267037640195381e-12,   1.000074421776630e-13,   1.251635118961925e-14,   4.124379430586568e-17,  -4.096565950495093e-03,   3.691604035484564e-05,   2.462836334448175e-06,
  -3.036002576395772e-08,   1.538835514087542e-10,  -2.425285339447294e-11,  -3.453112936722902e-12,   5.524791416809609e-14,   6.896422197731374e-15,   2.227083835219249e-17,
  -1.553428791201548e-03,   1.399829141870571e-05,   9.339265332322943e-07,  -1.151398583946041e-08,   5.807867161141272e-11,  -9.190616571826445e-12,  -1.308413115908154e-12,
   2.095441680911328e-14,   2.613105557894942e-15,   8.373954870498126e-18,  -1.771114224754449e-04,   1.595983320537254e-06,   1.064802077313419e-07,  -1.312772755961616e-09,
   6.616552221427932e-12,  -1.047735942325356e-12,  -1.491571884912861e-13,   2.389160855819188e-15,   2.978901089339693e-16,   9.533969201664505e-19,  -1.939930977524947e-02,
  -6.591058406938082e-04,   2.605067528736075e-05,   1.719936225762979e-06,  -2.419792008337733e-08,  -3.682804625659833e-09,  -1.511430073022178e-11,   6.432030124773123e-12,
   1.349527549975313e-13,  -8.876125856580085e-15,  -1.793581677122816e-02,  -6.091978700074487e-04,   2.408053086405895e-05,   1.588686868043926e-06,  -2.238314816775790e-08,
  -3.399329351908734e-09,  -1.381350119889554e-11,   5.933308339534358e-12,   1.240438676122975e-13,  -8.187099185708206e-15,  -1.523231911300074e-02,  -5.171150442115278e-04,
   2.044403639517816e-05,   1.347137392532914e-06,  -1.902413490044935e-08,  -2.879088924587293e-09,  -1.150852347581317e-11,   5.020201593661640e-12,   1.043364582600228e-13,
  -6.925984578702847e-15,  -1.170117181543347e-02,  -3.970281762613236e-04,   1.569917036880581e-05,   1.033149001065340e-06,  -1.462593909046340e-08,  -2.205273226278170e-09,
  -8.660049299402982e-12,   3.841158980346588e-12,   7.933105470882183e-14,  -5.298351856805042e-15,  -7.880217056512160e-03,  -2.672697865771802e-04,   1.056975146470046e-05,
   6.948823064433483e-07,  -9.856198848752683e-09,  -1.481774907399252e-09,  -5.736966806677306e-12,   2.578777362172202e-12,   5.299475529021272e-14,  -3.556514595239260e-15,
  -4.350833612981465e-03,  -1.475299328493313e-04,   5.834845116422308e-06,   3.833734770429881e-07,  -5.443802680329105e-09,  -8.170442133003530e-10,  -3.137282819505355e-12,
   1.421229102745753e-12,   2.912267807988408e-14,  -1.959902136447899e-15,  -1.649830808563966e-03,  -5.593814044278907e-05,   2.212432704430710e-06,   1.453341007332079e-07,
  -2.064565445404610e-09,  -3.096692254311196e-10,  -1.185359262046116e-12,   5.385629392728170e-13,   1.102383795169000e-14,  -7.426621921818965e-16,  -1.881022065789462e-04,
  -6.377581723416271e-06,   2.522436299334460e-07,   1.656921271026778e-08,  -2.353926840363494e-10,  -3.530343625073959e-11,  -1.350652838441782e-13,   6.139628736065826e-14,
   1.256493864829695e-15,  -8.466314307939174e-17,  -1.396249410551928e-04,   4.086883075758264e-06,  -6.345675413509758e-08,   1.611357415047787e-09,  -3.889251963752718e-11,
  -1.090161798140391e-12,   1.613877408982988e-14,   2.719755972969445e-15,   7.511586691180136e-18,  -4.211451434921495e-18,  -1.291025241539005e-04,   3.779016535647784e-06,
  -5.868346214788024e-08,   1.489419540473610e-09,  -3.595007149004738e-11,  -1.005509482041521e-12,   1.493058175459643e-14,   2.508181342875674e-15,   6.800237470196086e-18,
  -3.881465071524745e-18,  -1.096579431604122e-04,   3.210025752480479e-06,  -4.985739874681505e-08,   1.264393174410839e-09,  -3.051956334586870e-11,  -8.505937556774519e-13,
   1.269286218053492e-14,   2.121224623574604e-15,   5.574768206813445e-18,  -3.279337584904179e-18,  -8.424955248396412e-05,   2.466390587510087e-06,  -3.831529701620554e-08,
   9.708567970907374e-10,  -2.343499880757246e-11,  -6.506830209958261e-13,   9.760623896608358e-15,   1.622256807438602e-15,   4.120330138022888e-18,  -2.505256890433373e-18,
  -5.674491270715780e-05,   1.661274882269550e-06,  -2.581202227079759e-08,   6.536038032522371e-10,  -1.577736674855166e-11,  -4.367641777643909e-13,   6.578653921756720e-15,
   1.088698372943828e-15,   2.689571800819309e-18,  -1.679851175489532e-18,  -3.133216273481991e-05,   9.173111206888252e-07,  -1.425403041837170e-08,   3.607968700296123e-10,
  -8.709403092110041e-12,  -2.406880107139555e-13,   3.633882048816653e-15,   5.998787762871168e-16,   1.457931751341816e-18,  -9.251511738814760e-19,  -1.188141737253797e-05,
   3.478555496844837e-07,  -5.405491146254490e-09,   1.368035564360191e-10,  -3.302365301287068e-12,  -9.120334044336899e-14,   1.378199638101459e-15,   2.273005409494468e-16,
   5.490058943071295e-19,  -3.504847706827328e-19,  -1.354642033226495e-06,   3.966029687511261e-08,  -6.163035995713727e-10,   1.559719545511704e-11,  -3.765083259193067e-13,
  -1.039713597567869e-14,   1.571371644616243e-16,   2.591195899653431e-17,   6.252130968794717e-20,  -3.995356839417692e-20,  -1.261816530161447e-03,   3.636692410313346e-05,
  -5.347062291695974e-07,   1.346440528714277e-08,  -3.272341995185149e-10,  -1.093868460543214e-11,   1.650902861053511e-13,   2.531553104306860e-14,   7.424087609766221e-17,
  -3.972583485490129e-17,  -1.166721784222490e-03,   3.362727306551798e-05,  -4.944848197782671e-07,   1.244470473606073e-08,  -3.024576786118951e-10,  -1.009108294371161e-11,
   1.527286406938658e-13,   2.334537409273208e-14,   6.727212506141745e-17,  -3.661301631783365e-17,  -9.909953669198928e-04,   2.856399267429800e-05,  -4.201134566732432e-07,
   1.056341042877920e-08,  -2.567423786587075e-10,  -8.538892481069279e-12,   1.298350717638622e-13,   1.974256195195495e-14,   5.523665970416873e-17,  -3.093311255924678e-17,
  -7.613739653704267e-04,   2.194672073171341e-05,  -3.228560210355355e-07,   8.110149844601781e-09,  -1.971222774285017e-10,  -6.534090927741147e-12,   9.983867237034589e-14,
   1.509766299000353e-14,   4.089907943901730e-17,  -2.363128088860000e-17,  -5.128099925809954e-04,   1.478247741409166e-05,  -2.174996166659132e-07,   5.459467218097277e-09,
  -1.326988290912065e-10,  -4.387029881481737e-12,   6.728991072640003e-14,   1.013156549352658e-14,   2.673734798023070e-17,  -1.584542240400148e-17,  -2.831518586958713e-04,
   8.162462442434712e-06,  -1.201085741842340e-07,   3.013536941470018e-09,  -7.324852636191152e-11,  -2.417912230623260e-12,   3.716885292692872e-14,   5.582390812754720e-15,
   1.450662985197742e-17,  -8.726589874462053e-18,  -1.073734991169003e-04,   3.095301996095833e-06,  -4.554822314077600e-08,   1.142622864821850e-09,  -2.777328953699720e-11,
  -9.162633827991822e-13,   1.409674306222774e-14,   2.115205684303332e-15,   5.464591545512840e-18,  -3.305982721550744e-18,  -1.224202804232507e-05,   3.529067605486811e-07,
  -5.193151291637987e-09,   1.302718774154689e-10,  -3.166470301419311e-12,  -1.044545131303191e-13,   1.607256860771230e-15,   2.411302073692942e-16,   6.223490592722105e-19,
  -3.768659751604824e-19,  -3.533296498074698e-03,   9.825586735191535e-05,  -1.253333552287211e-06,   3.092562217508378e-08,  -7.746956177299353e-10,  -3.704877127903711e-11,
   5.693713339519103e-13,   7.611791710814085e-14,   2.366918632811750e-16,  -1.219095631485921e-16,  -3.267004612813738e-03,   9.085317614144283e-05,  -1.159057632526573e-06,
   2.857835116208936e-08,  -7.159218526272722e-10,  -3.418675782442045e-11,   5.267169742227485e-13,   7.019029479764373e-14,   2.146062966372938e-16,  -1.123550925203834e-16,
  -2.774927991889464e-03,   7.717234466364552e-05,  -9.847357427640478e-07,   2.425088095680953e-08,  -6.075487925476152e-10,  -2.894045376769226e-11,   4.477352146803337e-13,
   5.935274459894204e-14,   1.763985957604279e-16,  -9.492235487041380e-17,  -2.131943177981552e-03,   5.929340459524016e-05,  -7.567685599191011e-07,   1.861294671959447e-08,
  -4.663312298943004e-10,  -2.215566636915342e-11,   3.442704274059710e-13,   4.538428648121435e-14,   1.307681685470355e-16,  -7.251350805024626e-17,  -1.435926207000206e-03,
   3.993734829460716e-05,  -5.098160703794671e-07,   1.252646713340975e-08,  -3.138538698661689e-10,  -1.488075915586661e-11,   2.320220674171877e-13,   3.045366206128192e-14,
   8.557406873666545e-17,  -4.862112345054285e-17,  -7.928552896138719e-04,   2.205212553519773e-05,  -2.815331318383543e-07,   6.913414193025896e-09,  -1.732217551440274e-10,
  -8.203226136734835e-12,   1.281581771156461e-13,   1.677892784998484e-14,   4.645715520751526e-17,  -2.677686034144866e-17,  -3.006569119573532e-04,   8.362406178277345e-06,
  -1.067645605165573e-07,   2.621172355401455e-09,  -6.567642465946645e-11,  -3.108838805423499e-12,   4.860505364064335e-14,   6.357544791709326e-15,   1.750428731530589e-17,
  -1.014409664202994e-17,  -3.427894015425794e-05,   9.534282983144954e-07,  -1.217269334541290e-08,   2.988405063094864e-10,  -7.487796932754767e-12,  -3.544138418666008e-13,
   5.541753247373062e-15,   7.247483884379610e-16,   1.993597890182061e-18,  -1.156376742523181e-18,  -7.002552514104424e-03,   1.814994251955860e-04,  -1.587621197792280e-06,
   3.744433564889328e-08,  -1.101613707483092e-09,  -9.378366002102927e-11,   1.419904991982578e-12,   1.743192007885762e-13,   5.025717800357803e-16,  -2.828943764433827e-16,
  -6.474755762668101e-03,   1.678224734869785e-04,  -1.468230634599598e-06,   3.458106472306721e-08,  -1.017635488429177e-09,  -8.655560356039655e-11,   1.313428902380685e-12,
   1.607385682051050e-13,   4.547157005880565e-16,  -2.607093055008146e-16,  -5.499472226777081e-03,   1.425478271742551e-04,  -1.247451627381279e-06,   2.931506025712107e-08,
  -8.630291485024731e-10,  -7.329608811420416e-11,   1.116334613852994e-12,   1.359122751779484e-13,   3.724031701369518e-16,  -2.202392440098766e-16,  -4.225132245277387e-03,
   1.095200200174048e-04,  -9.586998916993578e-07,   2.247569605762931e-08,  -6.619701653246977e-10,  -5.613161108551979e-11,   8.582501065110232e-13,   1.039194055593716e-13,
   2.749390259356866e-16,  -1.682306022393781e-16,  -2.845726589357102e-03,   7.376614318492351e-05,  -6.458703195738072e-07,   1.511332548972272e-08,  -4.452812447944531e-10,
  -3.771065612378805e-11,   5.783588832865621e-13,   6.972838286411385e-14,   1.793027055486666e-16,  -1.127922631422136e-16,  -1.571277464997928e-03,   4.073080120996469e-05,
  -3.566714447767752e-07,   8.337047500836631e-09,  -2.456814312466144e-10,  -2.079174721019473e-11,   3.194390703015563e-13,   3.841688088102651e-14,   9.714052787630749e-17,
  -6.211486823910323e-17,  -5.958395945581844e-04,   1.544549190969629e-05,  -1.352597496033936e-07,   3.160354042488552e-09,  -9.313821382201934e-11,  -7.880065230539869e-12,
   1.211471640602855e-13,   1.455602352838931e-14,   3.657195331959384e-17,  -2.353110744158467e-17,  -6.793372397310374e-05,   1.760995274625853e-06,  -1.542156966455799e-08,
   3.603018032114430e-10,  -1.061851835005125e-11,  -8.983518780407566e-13,   1.381266161827356e-14,   1.659356955939711e-15,   4.164701202106510e-18,  -2.682422531040571e-18,
  -1.170460414002447e-02,   2.611580464098095e-04,   1.598155783329775e-07,  -4.841086594167337e-09,  -1.067783161388108e-09,  -2.001690628618322e-10,   2.725130505589508e-12,
   3.873407899674877e-13,   6.759536722219709e-16,  -6.243915513890875e-16,  -1.082228040825386e-02,   2.414706109117379e-04,   1.474917888008451e-07,  -4.562852748229926e-09,
  -9.854959088633950e-10,  -1.847277915304210e-10,   2.520408672516048e-12,   3.571713463070575e-13,   6.033024522786366e-16,  -5.753662174946556e-16,  -9.191962735077254e-03,
   2.050934463556719e-04,   1.248880174119939e-07,  -3.996192345171072e-09,  -8.345330264127547e-10,  -1.564097940927678e-10,   2.141675648765597e-12,   3.020156088452206e-13,
   4.823745789225110e-16,  -4.859690726049697e-16,  -7.061856701416041e-03,   1.575651976407180e-04,   9.563379866139059e-08,  -3.168342375791979e-09,  -6.391007923826564e-10,
  -1.197659126816945e-10,   1.646117371487468e-12,   2.309312598881048e-13,   3.463163461619864e-16,  -3.711420785162509e-16,  -4.756253122371107e-03,   1.061218109240469e-04,
   6.424488858560254e-08,  -2.185885157303404e-09,  -4.293606224255873e-10,  -8.045340781168608e-11,   1.109060598662471e-12,   1.549558514614217e-13,   2.204864438376267e-16,
  -2.488011143017305e-16,  -2.626157333219190e-03,   5.859484896958996e-05,   3.541996259881382e-08,  -1.223471435852485e-09,  -2.367258805336393e-10,  -4.435525624545544e-11,
   6.124832940460125e-13,   8.537440442737526e-14,   1.176976029659529e-16,  -1.370037955751461e-16,  -9.958541636315473e-04,   2.221948893855102e-05,   1.342394985379492e-08,
  -4.663010524380337e-10,  -8.971872042706315e-11,  -1.681024522531108e-11,   2.322736922431843e-13,   3.234826969267894e-14,   4.405747411446020e-17,  -5.189982215327045e-17,
  -1.135406985309448e-04,   2.533318657147153e-06,   1.530368049140920e-09,  -5.320903065256380e-11,  -1.022820628406532e-11,  -1.916412873796029e-12,   2.648261815476161e-14,
   3.687640519892695e-15,   5.012300502942081e-18,  -5.916276295876318e-18,  -1.743754332316227e-02,   2.459090244877703e-04,   9.301030292531847e-06,  -1.565312397854520e-07,
  -4.082632711996112e-09,  -2.986683288834456e-10,   3.317573558618509e-12,   9.526812555133335e-13,   1.549906736977382e-15,  -1.697471970740386e-15,  -1.612265908358983e-02,
   2.273510515740086e-04,   8.598830522175449e-06,  -1.448598948947839e-07,  -3.772686575779619e-09,  -2.752892435490512e-10,   3.069118102387886e-12,   8.782291500936373e-13,
   1.385966881092066e-15,  -1.563869718225511e-15,  -1.369331532724135e-02,   1.930729607847313e-04,   7.301980934865832e-06,  -1.232161145726694e-07,  -3.201301883556711e-09,
  -2.326156078014879e-10,   2.608980440641543e-12,   7.422630199290149e-13,   1.112029546075584e-15,  -1.320438203054574e-15,  -1.051963448711769e-02,   1.483074879927178e-04,
   5.608643335508734e-06,  -9.480764713858548e-08,  -2.456958474822407e-09,  -1.777327363157054e-10,   2.006116944315483e-12,   5.672769087231206e-13,   8.017744804629983e-16,
  -1.008077408666354e-15,  -7.084872961509304e-03,   9.987453368670136e-05,   3.776854974711745e-06,  -6.393088252037322e-08,  -1.653474741778381e-09,  -1.191886355535004e-10,
   1.352029552015331e-12,   3.804956477482366e-13,   5.124134703016597e-16,  -6.755902816807349e-16,  -3.911824835426242e-03,   5.514157242229563e-05,   2.085180431993035e-06,
  -3.532371875064453e-08,  -9.125429287237958e-10,  -6.564548253529837e-11,   7.467949864805875e-13,   2.095900440551969e-13,   2.741945688398271e-16,  -3.719571379210226e-16,
  -1.483375934823758e-03,   2.090943769264825e-05,   7.906835519219988e-07,  -1.339842902980050e-08,  -3.459817207615993e-10,  -2.486977312336793e-11,   2.832275098069534e-13,
   7.940665226260576e-14,   1.027367339866763e-16,  -1.408963002333507e-16,  -1.691244983517723e-04,   2.383944917940136e-06,   9.014795535085382e-08,  -1.527665712759987e-09,
  -3.944541352325374e-11,  -2.835045217143236e-12,   3.229244994230309e-14,   9.052077269935435e-15,   1.168996271848915e-17,  -1.606119154247733e-17,  -2.150464605332887e-02,
  -3.801273101530536e-04,   4.205092718388770e-05,   7.892262202580670e-07,  -8.591781020603478e-08,  -1.768082798706413e-09,   1.634461816330535e-10,   3.977892322176855e-12,
  -2.888914634604823e-13,  -8.636055125852386e-15,  -1.988177032436407e-02,  -3.513701654579989e-04,   3.885869397032902e-05,   7.289684570272269e-07,  -7.933497509672847e-08,
  -1.631200899844678e-09,   1.507758700733907e-10,   3.664714754916224e-12,  -2.661902195342601e-13,  -7.943155480492983e-15,  -1.688418221017138e-02,  -2.982958417326966e-04,
   3.297374810665360e-05,   6.180901357827650e-07,  -6.723588694647717e-08,  -1.380465222806448e-09,   1.275765809457622e-10,   3.094158940483549e-12,  -2.248067775798996e-13,
  -6.688479848261373e-15,  -1.296947122180828e-02,  -2.290541463850466e-04,   2.530723897875184e-05,   4.739918075800509e-07,  -5.153480497332516e-08,  -1.056497811243366e-09,
   9.761796686231264e-11,   2.362142359539637e-12,  -1.716698942429702e-13,  -5.091513317499439e-15,  -8.734026646161309e-03,  -1.542095996778035e-04,   1.703135608597518e-05,
   3.187822592714539e-07,  -3.464583070461985e-08,  -7.094180915893836e-10,   6.553851597319312e-11,   1.583027640958043e-12,  -1.150725131812999e-13,  -3.404449981223451e-15,
  -4.822133664060554e-03,  -8.512703300634516e-05,   9.399568495611425e-06,   1.758695408985606e-07,  -1.910942246825946e-08,  -3.910214717363363e-10,   3.612070452323014e-11,
   8.715553552304750e-13,  -6.336256455939725e-14,  -1.871910814650476e-15,  -1.828532099093739e-03,  -3.227788496687611e-05,   3.563763844747272e-06,   6.667004261076398e-08,
  -7.243527863710343e-09,  -1.481805420967050e-10,   1.368775446093608e-11,   3.301419651822894e-13,  -2.400263936875199e-14,  -7.087241941496396e-16,  -2.084761962311352e-04,
  -3.680058170971532e-06,   4.063052831176991e-07,   7.600885502962980e-09,  -8.258047394049277e-10,  -1.689273032813739e-11,   1.560409038555126e-12,   3.763385955650369e-14,
  -2.736153284621661e-15,  -8.078297768136366e-17,  -1.241870494065072e-04,   3.644599075480728e-06,  -4.843768912839259e-08,   8.601842995238423e-10,  -5.114069214702967e-11,
   9.080050799165370e-14,   7.191696670167924e-14,   5.133301079249014e-16,  -1.281468667029245e-16,  -1.357758596517597e-18,  -1.148277184353620e-04,   3.369974964414624e-06,
  -4.479969929222522e-08,   7.953831043328216e-10,  -4.723888989978391e-11,   8.441860086177745e-14,   6.634064070201231e-14,   4.725460665099813e-16,  -1.180923006402366e-16,
  -1.248119029503826e-18,  -9.753263526353412e-05,   2.862467364632022e-06,  -3.806949647444914e-08,   6.756214190141967e-10,  -4.005763586563619e-11,   7.234455174498895e-14,
   5.613117945189514e-14,   3.984617995533479e-16,  -9.975425751972872e-17,  -1.049993717947720e-18,  -7.493335838346114e-05,   2.199262533051904e-06,  -2.926260495772167e-08,
   5.191037041861286e-10,  -3.072201176141869e-11,   5.610168048211489e-14,   4.294841719139637e-14,   3.037757330419785e-16,  -7.619294568382396e-17,  -7.984984392656105e-19,
  -5.046993468884884e-05,   1.481301647815741e-06,  -1.971678212605157e-08,   3.496486615254598e-10,  -2.066373093990184e-11,   3.806073943703935e-14,   2.883376469044616e-14,
   2.033590266876067e-16,  -5.108225791426650e-17,  -5.334961936669592e-19,  -2.786731679738236e-05,   8.179204082420543e-07,  -1.088914720122603e-08,   1.930660874802408e-10,
  -1.140055303040101e-11,   2.110271977573859e-14,   1.589108553131177e-14,   1.118913798777766e-16,  -2.813042419796276e-17,  -2.932044480337628e-19,  -1.056750949842844e-05,
   3.101633377782657e-07,  -4.129592259593959e-09,   7.321294844369873e-11,  -4.321890924137470e-12,   8.014722363617785e-15,   6.021806072507683e-15,   4.237401275443789e-17,
  -1.065661979199957e-17,  -1.109909921183503e-19,  -1.204838614192659e-06,   3.536282987654237e-08,  -4.708356510668186e-10,   8.347277656289151e-12,  -4.927294834371331e-13,
   9.140207333199792e-16,   6.864873718444661e-16,   4.830149495117050e-18,  -1.214796979902616e-18,  -1.265079739924162e-20,  -1.124025245951426e-03,   3.263248400337137e-05,
  -4.104388516919111e-07,   6.921724107724187e-09,  -4.534988235542429e-10,   4.076261399915082e-13,   6.832171987685015e-13,   4.610160443446726e-15,  -1.204907657474075e-15,
  -1.271618660124934e-17,  -1.039312088031058e-03,   3.017349137714421e-05,  -3.796173732680767e-07,   6.400142025571895e-09,  -4.188693252076394e-10,   3.810511697086405e-13,
   6.302568965669676e-13,   4.243083249584493e-15,  -1.110345599936488e-15,  -1.168895201438701e-17,  -8.827716089352103e-04,   2.562931512995088e-05,  -3.225951434657071e-07,
   5.436270326968645e-09,  -3.551515781515419e-10,   3.294174605939584e-13,   5.332851192213458e-13,   3.576751303191482e-15,  -9.378922054464794e-16,  -9.832908554465757e-18,
  -6.782232912401661e-04,   1.969114408450661e-05,  -2.479727415556444e-07,   4.176718637250995e-09,  -2.723481859360996e-10,   2.577609919070869e-13,   4.080571510154367e-13,
   2.725902322152849e-15,  -7.163416001000577e-16,  -7.477278585535428e-18,  -4.568036236450489e-04,   1.326280387561130e-05,  -1.670840714100982e-07,   2.813195808953007e-09,
  -1.831645126241221e-10,   1.760761131860940e-13,   2.739617001835983e-13,   1.824339998086881e-15,  -4.802449486536853e-16,  -4.995517245429001e-18,  -2.522269831573732e-04,
   7.323213789132592e-06,  -9.227786060364593e-08,   1.553340235795241e-09,  -1.010494875598005e-10,   9.800508602853559e-14,   1.509908296037862e-13,   1.003626890502854e-15,
  -2.644610172694754e-16,  -2.745414540050405e-18,  -9.564645645054273e-05,   2.777030753592526e-06,  -3.499552882533923e-08,   5.890412107901589e-10,  -3.830653162594378e-11,
   3.727570473778418e-14,   5.721724874171526e-14,   3.800582370316037e-16,  -1.001848601503828e-16,  -1.039251567984493e-18,  -1.090498544981200e-05,   3.166191410275501e-07,
  -3.990019473054319e-09,   6.715868385635389e-11,  -4.367229951500140e-12,   4.252037315492862e-15,   6.522788386631586e-15,   4.332184700325752e-17,  -1.142051980520822e-17,
  -1.184541069249696e-19,  -3.158337431921398e-03,   8.945489102892369e-05,  -9.767465527294923e-07,   1.403037064151602e-08,  -1.220124699569429e-09,  -1.220662628622349e-12,
   2.119200328417526e-12,   1.286307488343784e-14,  -3.683702018742684e-15,  -3.821974591800018e-17,  -2.920298771036696e-03,   8.271344251623414e-05,  -9.034350753328560e-07,
   1.297223308162156e-08,  -1.126772282129639e-09,  -1.117079814675994e-12,   1.954994028256641e-12,   1.183468496794311e-14,  -3.394464515800363e-15,  -3.512886588461096e-17,
  -2.480434532259170e-03,   7.025575529283939e-05,  -7.677808047161934e-07,   1.101735736883369e-08,  -9.551146824676053e-10,  -9.327340395523483e-13,   1.654289093757672e-12,
   9.970340265757270e-15,  -2.867061642119562e-15,  -2.954614187375113e-17,  -1.905680545060377e-03,   5.397714211000323e-05,  -5.902195082672687e-07,   8.463694538000408e-09,
  -7.322226201938747e-10,  -7.035572268421982e-13,   1.265897968631838e-12,   7.593809771843861e-15,  -2.189643657607634e-15,  -2.246404495940274e-17,  -1.283528030720017e-03,
   3.635545509043889e-05,  -3.977116812991796e-07,   5.700121979599519e-09,  -4.923375228336020e-10,  -4.669809167613750e-13,   8.499394272175966e-13,   5.079717195251681e-15,
  -1.467884080485880e-15,  -1.500603896612262e-17,  -7.087065539307097e-04,   2.007396852378742e-05,  -2.196566975445755e-07,   3.147222073372408e-09,  -2.715811621210539e-10,
  -2.556593402977343e-13,   4.684470721861125e-13,   2.793707067891735e-15,  -8.083074202674996e-16,  -8.246307114980999e-18,  -2.687468888141597e-04,   7.612217644034865e-06,
  -8.330376062814235e-08,   1.193432053339222e-09,  -1.029478520950159e-10,  -9.663711002385074e-14,   1.775175857875097e-13,   1.057819544580366e-15,  -3.062046042665679e-16,
  -3.121472156451939e-18,  -3.064076430208137e-05,   8.678956370175957e-07,  -9.497906927271523e-09,   1.360669779765920e-10,  -1.173672760003985e-11,  -1.101206013376018e-14,
   2.023710755816463e-14,   1.205759189206491e-16,  -3.490556049705310e-17,  -3.557842978857585e-19,  -6.299697103854075e-03,   1.701735530456299e-04,  -1.295608107592798e-06,
   8.229642406676985e-09,  -2.273918706316379e-09,  -9.223337756537956e-12,   4.931044312021390e-12,   2.625310203813950e-14,  -8.551420913475239e-15,  -8.385546718375387e-17,
  -5.824870679509350e-03,   1.573465958019962e-04,  -1.198532993424834e-06,   7.605303054161871e-09,  -2.099302084789419e-09,  -8.504498495792246e-12,   4.548988988662816e-12,
   2.414533971167457e-14,  -7.879525866280263e-15,  -7.705572366604328e-17,  -4.947471026127044e-03,   1.336448192258748e-04,  -1.018803896254609e-06,   6.454085647873726e-09,
  -1.778596002616665e-09,  -7.190630102152419e-12,   3.849329995197230e-12,   2.032935663072257e-14,  -6.654643850414915e-15,  -6.478461487002842e-17,  -3.801034966583576e-03,
   1.026758715014034e-04,  -7.833808235464322e-07,   4.953956276907370e-09,  -1.362806325770823e-09,  -5.497782371392450e-12,   2.945622637240536e-12,   1.547362793390226e-14,
  -5.081801234867191e-15,  -4.923543782140769e-17,  -2.560083847307361e-03,   6.915425070970026e-05,  -5.279719885469718e-07,   3.334182111904253e-09,  -9.159502918007622e-10,
  -3.688840509919962e-12,   1.977744306084787e-12,   1.034544178171116e-14,  -3.406447453732391e-15,  -3.287852797491974e-17,  -1.413557855415901e-03,   3.818363008044641e-05,
  -2.916317892217288e-07,   1.840208519048823e-09,  -5.051302751270123e-10,  -2.032345321153157e-12,   1.090046190752745e-12,   5.688019336422392e-15,  -1.875714338068186e-15,
  -1.806436047684711e-17,  -5.360310522812487e-04,   1.447948696935539e-05,  -1.106045458492418e-07,   6.977104310722549e-10,  -1.914615223889687e-10,  -7.700457887695420e-13,
   4.130727923235117e-13,   2.153491210251464e-15,  -7.105496213584809e-16,  -6.837403910607546e-18,  -6.111474339185099e-05,   1.650855844231134e-06,  -1.261070174584993e-08,
   7.954629554722427e-11,  -2.182753470076362e-11,  -8.778359623314075e-14,   4.709055252791055e-14,   2.454618600262383e-16,  -8.099833262530375e-17,  -7.793155699895356e-19,
  -1.065854351358102e-02,   2.616501055012566e-04,  -1.118148049306750e-07,  -4.694760838700275e-08,  -3.618703302762869e-09,  -2.393390427569880e-11,   1.037640831839763e-11,
   5.039469181598599e-14,  -1.889269518085826e-14,  -1.562037752743006e-16,  -9.855086872685900e-03,   2.419201850239938e-04,  -1.043216279758905e-07,  -4.341895755503546e-08,
  -3.339180102320539e-09,  -2.208444444236124e-11,   9.571371023863399e-12,   4.635658774551505e-14,  -1.740677620552950e-14,  -1.434608055789533e-16,  -8.370488828139016e-03,
   2.054677875517815e-04,  -8.990878036496842e-08,  -3.689258208783224e-08,  -2.826776302205249e-09,  -1.869469297558967e-11,   8.097743271677427e-12,   3.904144559702402e-14,
  -1.469879614732060e-14,  -1.205084298715329e-16,  -6.430761678713319e-03,   1.578466832050205e-04,  -7.013342949762592e-08,  -2.835501215620958e-08,  -2.164087756861047e-09,
  -1.431149823836774e-11,   6.195415466947642e-12,   2.972554233177378e-14,  -1.122301720621076e-14,  -9.149849967299978e-17,  -4.331209806954913e-03,   1.063081638148729e-04,
  -4.779644388754964e-08,  -1.910369380488411e-08,  -1.453509548342848e-09,  -9.612096463568129e-12,   4.159067771003800e-12,   1.987906401984423e-14,  -7.522159547344189e-15,
  -6.105539035848904e-17,  -2.391472747385285e-03,   5.869671504670489e-05,  -2.656915145018298e-08,  -1.055005291738312e-08,  -8.012700847814037e-10,  -5.298764748078573e-12,
   2.292090454992668e-12,   1.093130739291521e-14,  -4.141694555590927e-15,  -3.353096102133030e-17,  -9.068607404958658e-04,   2.225797080827482e-05,  -1.010056705672683e-08,
  -4.000923275889086e-09,  -3.036637591918025e-10,  -2.008108675160549e-12,   8.685579171072818e-13,   4.138838166017944e-15,  -1.568898021817439e-15,  -1.268947866453711e-17,
  -1.033942640346999e-04,   2.537703339988296e-06,  -1.152079537474580e-09,  -4.561641066533349e-10,  -3.461828259947092e-11,  -2.289283285518915e-13,   9.901558293612720e-14,
   4.717624840857108e-16,  -1.788440712951989e-16,  -1.446285860413267e-18,  -1.631906560593001e-02,   3.113102701301573e-04,   6.871014479652219e-06,  -2.568868819565870e-07,
  -7.315406029458922e-09,   4.935508164438167e-11,   2.154855973795438e-11,   7.870813624241458e-14,  -4.705366510271727e-14,  -2.099543181416912e-16,  -1.508860231557446e-02,
   2.878093028661877e-04,   6.351172632035295e-06,  -2.375003523658515e-07,  -6.749999564994064e-09,   4.570555804013822e-11,   1.986737006510804e-11,   7.245455692790263e-14,
  -4.333986515141099e-14,  -1.926707077389961e-16,  -1.281518305598249e-02,   2.444055730061246e-04,   5.391776485363509e-06,  -2.016918895507711e-07,  -5.713738809326859e-09,
   3.891890788000540e-11,   1.679549670906392e-11,   6.109565623748110e-14,  -3.657939762820094e-14,  -1.616307526774225e-16,  -9.845118710437110e-03,   1.877299062613667e-04,
   4.140172668078003e-06,  -1.549279156274255e-07,  -4.373884455992465e-09,   2.998006236372211e-11,   1.283926221474478e-11,   4.657842587388625e-14,  -2.791491062950201e-14,
  -1.225489843509615e-16,  -6.630642365224723e-03,   1.264183251625458e-04,   2.787330226174845e-06,  -1.043328404920084e-07,  -2.937528094292498e-09,   2.023422573888795e-11,
   8.613547075854594e-12,   3.118213411925733e-14,  -1.870204556402182e-14,  -8.168441640743791e-17,  -3.661042757573086e-03,   6.979522434804290e-05,   1.538660077309759e-06,
  -5.760301397378835e-08,  -1.619298488223392e-09,   1.118572273063642e-11,   4.745191642660279e-12,   1.715721867124153e-14,  -1.029486224674600e-14,  -4.483156984986868e-17,
  -1.388280842988949e-03,   2.646583794516757e-05,   5.834176792150470e-07,  -2.184280131505038e-08,  -6.136700257935057e-10,   4.243600635063479e-12,   1.797873471767586e-12,
   6.497602444275856e-15,  -3.899402467966603e-15,  -1.696202233572353e-17,  -1.582824410141222e-04,   3.017442275076432e-06,   6.651645396384501e-08,  -2.490360303045982e-09,
  -6.995946300774430e-11,   4.838633189024728e-13,   2.049527096494059e-13,   7.406528138455548e-16,  -4.444996332866570e-16,  -1.933173071289265e-18,  -2.232702187973060e-02,
  -3.040596556318093e-05,   4.285022266261598e-05,  -6.383144355275323e-07,  -7.908545775007867e-08,   2.315158546554848e-09,   1.300301625893423e-10,  -5.813063634341763e-12,
  -1.900833621722808e-13,   1.245421671021376e-14,  -2.064211612673561e-02,  -2.819595585355291e-05,   3.959948174135958e-05,  -5.891979422676538e-07,  -7.303918287766376e-08,
   2.135374947254245e-09,   1.199975369260011e-10,  -5.355634110313078e-12,  -1.752820616424405e-13,   1.145836505725013e-14,  -1.752993412923233e-02,  -2.406267311902954e-05,
   3.360536718575814e-05,  -4.990486723457861e-07,  -6.191843601412431e-08,   1.806377613927165e-09,   1.015996935140055e-10,  -4.522135278556178e-12,  -1.482198656044118e-13,
   9.653133826842855e-15,  -1.346553694503353e-02,  -1.857949704130977e-05,   2.579446092859494e-05,  -3.822711404471063e-07,  -4.747388794202886e-08,   1.381834216487868e-09,
   7.779456457256071e-11,  -3.452537903398970e-12,  -1.133382705918174e-13,   7.352115565001680e-15,  -9.068110893386279e-03,  -1.256275553273086e-05,   1.736054817144060e-05,
  -2.568669632269620e-07,  -3.192357896365689e-08,   9.275448235484148e-10,   5.225774128378327e-11,  -2.313903302719313e-12,  -7.605273746034004e-14,   4.918009261436609e-15,
  -5.006590544411020e-03,  -6.952172107833507e-06,   9.581662574313374e-06,  -1.416385248843608e-07,  -1.761041351154730e-08,   5.111445246540165e-10,   2.881015427172534e-11,
  -1.273988606336625e-12,  -4.190269680218741e-14,   2.704766315371248e-15,  -1.898478198922579e-03,  -2.638533906841396e-06,   3.632862090657936e-06,  -5.368309970967697e-08,
  -6.675674870683037e-09,   1.936870629935999e-10,   1.091873676951728e-11,  -4.825879480242728e-13,  -1.587698777726921e-14,   1.024142181413051e-15,  -2.164509680868015e-04,
  -3.008703003737532e-07,   4.141842976758076e-07,  -6.120080433959060e-09,  -7.610728567596895e-10,   2.208023540558100e-11,   1.244764148011812e-12,  -5.501173661677937e-14,
  -1.809947973885483e-15,   1.167371855398267e-16,  -1.103369817180903e-04,   3.285213586356858e-06,  -4.266810241928522e-08,   1.467841521235270e-10,  -3.327539634999029e-11,
   1.538521320543714e-12,   3.293740006939844e-14,  -2.805379055930402e-15,  -3.908423352632073e-17,   5.061641528590041e-18,  -1.020214374135699e-04,   3.037588034945770e-06,
  -3.946039678648091e-08,   1.363861240773229e-10,  -3.074554439972378e-11,   1.419998026038893e-12,   3.040682754029904e-14,  -2.586062176372176e-15,  -3.608407742905718e-17,
   4.660407352206148e-18,  -8.665517728833851e-05,   2.580023333795067e-06,  -3.352806551304863e-08,   1.167689419352470e-10,  -2.608400223051730e-11,   1.202542192106090e-12,
   2.575982173848831e-14,  -2.185590680351554e-15,  -3.057299229091820e-17,   3.931031510076466e-18,  -6.657629116197526e-05,   1.982165498563228e-06,  -2.576832336645987e-08,
   9.046505956231528e-11,  -2.001507764881467e-11,   9.209926195076938e-13,   1.973631960809998e-14,  -1.670267550239993e-15,  -2.342674038917913e-17,   2.997934714058818e-18,
  -4.484117866159918e-05,   1.335028142514561e-06,  -1.736055221304416e-08,   6.132927755210867e-11,  -1.346754005999939e-11,   6.187796228110418e-13,   1.326407073190595e-14,
  -1.120277876766200e-15,  -1.574563294484426e-17,   2.007476415830626e-18,  -2.475935689272739e-05,   7.371379612955395e-07,  -9.587272011689299e-09,   3.399013432007284e-11,
  -7.431980838073833e-12,   3.411744305049304e-13,   7.314630412532013e-15,  -6.170757825126777e-16,  -8.683533647984517e-18,   1.104719059647108e-18,  -9.388945653015745e-06,
   2.795276333224774e-07,  -3.635787398711425e-09,   1.290736980546931e-11,  -2.817667026490656e-12,   1.293065206476616e-13,   2.772454689832223e-15,  -2.337877368032275e-16,
  -3.291366224248052e-18,   4.183891954749298e-19,  -1.070466428686440e-06,   3.186990187509081e-08,  -4.145329053629937e-10,   1.471955106905979e-12,  -3.212407152122249e-13,
   1.474137330795643e-14,   3.160724426260625e-16,  -2.665094399179406e-17,  -3.752318048914579e-19,   4.769201743234873e-20,  -9.997024318956747e-04,   2.956416938537523e-05,
  -3.678287910154990e-07,   5.873664369933762e-10,  -2.932312438244357e-10,   1.412017776831200e-11,   3.114900366285652e-13,  -2.649259820518778e-14,  -3.602239641605616e-16,
   4.777490782611713e-17,  -9.243590529601158e-04,   2.733565062798592e-05,  -3.401777649727773e-07,   5.492077483094397e-10,  -2.709236491370213e-10,   1.303172265109820e-11,
   2.875697287382612e-13,  -2.442152288257237e-14,  -3.325843895850025e-16,   4.398709736755312e-17,  -7.851328319092206e-04,   2.321783199334173e-05,  -2.890389586438223e-07,
   4.749915873351128e-10,  -2.298276871973347e-10,   1.103512578227631e-11,   2.436369862301866e-13,  -2.063972564861485e-14,  -2.818052404807465e-16,   3.710191750530807e-17,
  -6.032086282630901e-04,   1.783755310067687e-05,  -2.221455691616526e-07,   3.718507300221389e-10,  -1.763382367251580e-10,   8.450717822553685e-12,   1.866795064021620e-13,
  -1.577330025211929e-14,  -2.159479696952573e-16,   2.829434612377876e-17,  -4.062790559267956e-04,   1.201389109708866e-05,  -1.496641752166741e-07,   2.541142360308030e-10,
  -1.186442875089633e-10,   5.677305515081940e-12,   1.254674443046045e-13,  -1.057945877619608e-14,  -1.451502490231285e-16,   1.894602933016143e-17,  -2.243295410335422e-04,
   6.633471041794521e-06,  -8.265154926721585e-08,   1.414761613924655e-10,  -6.547046541268670e-11,   3.130146772261618e-12,   6.919270937705300e-14,  -5.827427502342065e-15,
  -8.005083365728397e-17,   1.042590996411020e-17,  -8.506752896739468e-05,   2.515453848624032e-06,  -3.134404483079158e-08,   5.381471844715922e-11,  -2.482126226904048e-11,
   1.186320057791683e-12,   2.622633262018846e-14,  -2.207803225366293e-15,  -3.034240202502068e-17,   3.948575692875174e-18,  -9.698845140531093e-06,   2.867954501518526e-07,
  -3.573680078377749e-09,   6.138737128337413e-12,  -2.829851688428134e-12,   1.352440811225655e-13,   2.989927073658416e-15,  -2.516814900879273e-16,  -3.459187622470774e-18,
   4.500962038656077e-19,  -2.815528286278713e-03,   8.199823030925756e-05,  -9.176123170299481e-07,  -3.040273706865288e-09,  -7.748169014967923e-10,   4.105722909201995e-11,
   9.549245515825192e-13,  -8.146222612020622e-14,  -1.050819112462617e-15,   1.470587819226715e-16,  -2.603328519469444e-03,   7.581666945628203e-05,  -8.486431745582003e-07,
  -2.793314254876521e-09,  -7.157863523390490e-10,   3.788830921753395e-11,   8.816575971930153e-13,  -7.509365879676236e-14,  -9.702874974836508e-16,   1.353948804238874e-16,
  -2.211209995522319e-03,   6.439485793366579e-05,  -7.210823867138788e-07,  -2.347769234095838e-09,  -6.070896001987581e-10,   3.207782028605632e-11,   7.470547261688114e-13,
  -6.346474258747559e-14,  -8.222769967559657e-16,   1.141957619467116e-16,  -1.698841576429349e-03,   4.947191151926454e-05,  -5.542120884754618e-07,  -1.783573205946759e-09,
  -4.656991835579014e-10,   2.456068247504678e-11,   5.724816176184661e-13,  -4.850083328638081e-14,  -6.302203423225326e-16,   8.708202035492909e-17,  -1.144217482212809e-03,
   3.331979286436045e-05,  -3.733910544809932e-07,  -1.190607069494041e-09,  -3.132807564136673e-10,   1.649777460593224e-11,   3.848042482660294e-13,  -3.253033792309583e-14,
  -4.236615596464614e-16,   5.830791022801382e-17,  -6.317858928962519e-04,   1.839740902083179e-05,  -2.062060921203201e-07,  -6.540014072870218e-10,  -1.728584681988924e-10,
   9.095172593976000e-12,   2.122240055498605e-13,  -1.791847946387028e-14,  -2.336686387398449e-16,   3.208573050903701e-17,  -2.395780445797108e-04,   6.976396214637119e-06,
  -7.820008021510167e-08,  -2.475186831238976e-10,  -6.553200341104665e-11,   3.446944264123536e-12,   8.044170463765167e-14,  -6.788664121105528e-15,  -8.857211151058348e-17,
   1.215161995615203e-17,  -2.731512426166466e-05,   7.954023477643527e-07,  -8.915959886047995e-09,  -2.821132514605952e-11,  -7.471205152289885e-12,   3.929600115140832e-13,
   9.170771567932582e-15,  -7.738827794934780e-16,  -1.009771766705397e-17,   1.385154942550041e-18,  -5.639947394281206e-03,   1.596119393965873e-04,  -1.401062204442350e-06,
  -2.350156896972484e-08,  -1.372522221927833e-09,   8.819336033811627e-11,   2.161854370828580e-12,  -1.889902705203250e-13,  -2.218646327127937e-15,   3.439392278166185e-16,
  -5.214858540424718e-03,   1.475770446850423e-04,  -1.295804959552677e-06,  -2.169182506107659e-08,  -1.267646933046783e-09,   8.137364094496969e-11,   1.996177830237659e-12,
  -1.742111908043312e-13,  -2.049153890737109e-15,   3.166443552498692e-16,  -4.429359336706167e-03,   1.253412880267696e-04,  -1.101098420489777e-06,  -1.837098567044976e-08,
  -1.074717548059435e-09,   6.887662854859500e-11,   1.691688732987287e-12,  -1.472272697204942e-13,  -1.737314421793123e-15,   2.670450682202088e-16,  -3.402992681543533e-03,
   9.629191718122670e-05,  -8.463412624891713e-07,  -1.407059100706438e-08,  -8.240672570354783e-10,   5.272162026261872e-11,   1.296589584416304e-12,  -1.125088933278222e-13,
  -1.332136732554696e-15,   2.036225724503796e-16,  -2.291999485988279e-03,   6.485211338475812e-05,  -5.702372765510821e-07,  -9.453883907492636e-09,  -5.541731680152315e-10,
   3.540625219299068e-11,   8.716421677758639e-13,  -7.545916609515241e-14,  -8.958365333594474e-16,   1.363313069683303e-16,  -1.265536260686129e-03,   3.580742875798661e-05,
  -3.149241416792675e-07,  -5.212677074803483e-09,  -3.057161588281286e-10,   1.951692199723701e-11,   4.807574215464565e-13,  -4.156390774051002e-14,  -4.941948559619324e-16,
   7.501759159835020e-17,  -4.799005068991794e-04,   1.357830609791279e-05,  -1.194308298467762e-07,  -1.975643105894601e-09,  -1.158909698534063e-10,   7.396295656469324e-12,
   1.822322298929539e-13,  -1.574695037974200e-14,  -1.873388244043823e-16,   2.841050802803027e-17,  -5.471511222880158e-05,   1.548107061020734e-06,  -1.361689694950349e-08,
  -2.252302013666383e-10,  -1.321239587287110e-11,   8.431890937745305e-13,   2.077551801718635e-14,  -1.795092403663644e-15,  -2.135794591446188e-17,   3.238486731571923e-18,
  -9.618629948885441e-03,   2.575667734819399e-04,  -9.961632476128636e-07,  -9.587337021149033e-08,  -1.835378911915479e-09,   1.773708610284686e-10,   4.217018584410303e-12,
  -4.075483405805490e-13,  -3.962874589729192e-15,   7.621062354975450e-16,  -8.893602238246742e-03,   2.381383938020248e-04,  -9.215466048726351e-07,  -8.856959523991051e-08,
  -1.694268803013213e-09,   1.636305502795650e-10,   3.894270427573251e-12,  -3.756466958408736e-13,  -3.663132870139390e-15,   7.015810311328463e-16,  -7.553898919715600e-03,
   2.022469712598856e-04,  -7.833845258155426e-07,  -7.512046570353358e-08,  -1.435199571573591e-09,   1.384663818322021e-10,   3.300847348995712e-12,  -3.174185132101214e-13,
  -3.109832089981444e-15,   5.916230071025213e-16,  -5.803447423685941e-03,   1.553651412604151e-04,  -6.023866647277283e-07,  -5.762566911724863e-08,  -1.099488796763321e-09,
   1.059610074899537e-10,   2.530404160668158e-12,  -2.425311085285934e-13,  -2.387911024433054e-15,   4.510637232938591e-16,  -3.908728002039138e-03,   1.046330540852763e-04,
  -4.060012797391636e-07,  -3.876578358148513e-08,  -7.388662800572587e-10,   7.114533456540420e-11,   1.701335930182358e-12,  -1.626456824972445e-13,  -1.607589705986624e-15,
   3.019738274063708e-16,  -2.158207305336609e-03,   5.777060973614275e-05,  -2.242639643027992e-07,  -2.138987124927760e-08,  -4.074372216930964e-10,   3.921256520128303e-11,
   9.384581439556402e-13,  -8.958142172720121e-14,  -8.873982858658363e-16,   1.661554895676505e-16,  -8.184061494326148e-04,   2.190661604706678e-05,  -8.505515684041012e-08,
  -8.109087460969699e-09,  -1.544276169064602e-10,   1.485964526881018e-11,   3.557361432893344e-13,  -3.393807071673224e-14,  -3.364734069279727e-16,   6.292486031831466e-17,
  -9.330927653750613e-05,   2.497640979702959e-06,  -9.697670657233147e-09,  -9.245052322128008e-10,  -1.760539811359322e-11,   1.694009668722573e-12,   4.055617288040045e-14,
  -3.868794795860834e-15,  -3.836183994415480e-17,   7.172722077571006e-18,  -1.498590174394987e-02,   3.522072884886315e-04,   3.204635797027479e-06,  -3.401095520241100e-07,
  -1.802857503684310e-09,   4.386640596009097e-10,   5.982738904549238e-12,  -9.513703975257047e-13,  -4.142035264861915e-15,   1.890199160963779e-15,  -1.385609378363231e-02,
   3.256127945223487e-04,   2.962598992590780e-06,  -3.142816823377008e-07,  -1.663038700374193e-09,   4.047343895713566e-10,   5.526527512447308e-12,  -8.767289179503133e-13,
  -3.852851886040631e-15,   1.739954113298938e-15,  -1.176856539209919e-02,   2.764994164401725e-04,   2.515655257609415e-06,  -2.666730416328023e-07,  -1.407056696660118e-09,
   3.425645610866950e-10,   4.686679485967894e-12,  -7.405908177415183e-13,  -3.304234626622484e-15,   1.467073377846653e-15,  -9.041219138737754e-03,   2.123744561910462e-04,
   1.932164129725017e-06,  -2.046607780321255e-07,  -1.076549537124652e-09,   2.622061789475029e-10,   3.594618414010805e-12,  -5.656718041312026e-13,  -2.564078908904762e-15,
   1.118375368292907e-15,  -6.089300517333270e-03,   1.430104030268120e-04,   1.301060774382117e-06,  -1.377281950450146e-07,  -7.227179266707957e-10,   1.760846620603925e-10,
   2.417831288372590e-12,  -3.792466932186440e-13,  -1.740309193841193e-15,   7.486409545744975e-16,  -3.362172030582119e-03,   7.895449229649429e-05,   7.182903988589753e-07,
  -7.601027097403847e-08,  -3.982984133592825e-10,   9.706121828239362e-11,   1.333981044060968e-12,  -2.088473620420988e-13,  -9.651299821868652e-16,   4.119007349540371e-16,
  -1.274951633425788e-03,   2.993879821271182e-05,   2.723673601240510e-07,  -2.881839715767385e-08,  -1.509304448792823e-10,   3.678290359632369e-11,   5.057078122925077e-13,
  -7.911749592783967e-14,  -3.665812131924248e-16,   1.559876372797142e-16,  -1.453614763375383e-04,   3.413400778982705e-06,   3.105328612407947e-08,  -3.285585716267230e-09,
  -1.720607495188771e-11,   4.193303393112761e-12,   5.765470387839881e-14,  -9.018967506935688e-15,  -4.180645377585509e-17,   1.778075801374873e-17,  -2.183626787185587e-02,
   2.645604474761367e-04,   2.950662799902995e-05,  -1.425858859585236e-06,  -1.647801573968734e-08,   3.224922320025987e-09,  -4.901766097874472e-11,  -4.847455823066851e-12,
   1.976034125339829e-13,   4.375073733581760e-15,  -2.018891744715740e-02,   2.444324341560695e-04,   2.727794395505378e-05,  -1.316974044175780e-06,  -1.526719457616655e-08,
   2.977389483660543e-09,  -4.508486581451938e-11,  -4.475115647001609e-12,   1.818607309025122e-13,   4.048083843656303e-15,  -1.714578880890234e-02,   2.073526213227402e-04,
   2.316252943278290e-05,  -1.116629498160008e-06,  -1.301078308793506e-08,   2.522692952922379e-09,  -3.796284156268839e-11,  -3.791301566418903e-12,   1.532884018001561e-13,
   3.442035979335742e-15,  -1.317104800663555e-02,   1.590920124918235e-04,   1.778992847190511e-05,  -8.562796993554354e-07,  -1.003099636086454e-08,   1.933073976618933e-09,
  -2.889756739849617e-11,  -2.904840407433947e-12,   1.168123041614513e-13,   2.647313805033654e-15,  -8.870105544961177e-03,   1.070395658993952e-04,   1.197908675368854e-05,
  -5.758756467426817e-07,  -6.774613271580480e-09,   1.299293182188330e-09,  -1.932149284219462e-11,  -1.952268451771997e-12,   7.817151184465437e-14,   1.784473223596846e-15,
  -4.897369455574733e-03,   5.906637633124675e-05,   6.613383254033657e-06,  -3.177013900473559e-07,  -3.746499853867450e-09,   7.165566257446695e-10,  -1.062340999861705e-11,
  -1.076609471834479e-12,   4.300248537648683e-14,   9.857466625698815e-16,  -1.857076189459365e-03,   2.239328302535296e-05,   2.507712385700261e-06,  -1.204361602583736e-07,
  -1.421534422229885e-09,   2.716020477631966e-10,  -4.022072283061417e-12,  -4.080668331235894e-13,   1.628407822499400e-14,   3.738641610253740e-16,  -2.117308735148128e-04,
   2.553038798942773e-06,   2.859104747099683e-07,  -1.373061446398874e-08,  -1.620898070668765e-10,   3.096399218886064e-11,  -4.584494074356990e-13,  -4.652149225700358e-14,
   1.856173721430738e-15,   4.262670532414236e-17,  -9.787716984328203e-05,   2.944345516156291e-06,  -4.302107726400295e-08,  -1.236635296464409e-10,  -1.005411000632602e-12,
   1.404437209577005e-12,  -3.799803016223243e-14,  -1.556008650271935e-15,   9.047228522671121e-17,   8.697387438275022e-19,  -9.050087486423023e-05,   2.722379608006465e-06,
  -3.977838527339514e-08,  -1.137299777262410e-10,  -9.541953234240400e-13,   1.297141390576874e-12,  -3.502434462599945e-14,  -1.437314213830497e-15,   8.334471520862644e-17,
   8.075984211453564e-19,  -7.687011891380818e-05,   2.312249297755034e-06,  -3.378648282122064e-08,  -9.574531049574347e-11,  -8.446323375176315e-13,   1.099747773188775e-12,
  -2.959616840100465e-14,  -1.218834550450308e-15,   7.036190066906057e-17,   6.906549573457140e-19,  -5.905877502636747e-05,   1.776403466633736e-06,  -2.595735941845546e-08,
  -7.286404783648077e-11,  -6.766768599970334e-13,   8.432793405442893e-13,  -2.261427650244942e-14,  -9.347860667805455e-16,   5.370961609139750e-17,   5.343927235392009e-19,
  -3.977802995253277e-05,   1.196423083273597e-06,  -1.748284386759349e-08,  -4.870759200504574e-11,  -4.704307304954527e-13,   5.671030714079864e-13,  -1.516582705071653e-14,
  -6.287389680388611e-16,   3.599096349514513e-17,   3.618998858323424e-19,  -2.196374667115903e-05,   6.606005120989255e-07,  -9.653194986809870e-09,  -2.677685807164086e-11,
  -2.644159364383086e-13,   3.128522352119053e-13,  -8.353064802854480e-15,  -3.468851057546794e-16,   1.981414289528312e-17,   2.004469925720341e-19,  -8.328833821723648e-06,
   2.505032048815070e-07,  -3.660558033512497e-09,  -1.013729219889077e-11,  -1.009321424203481e-13,   1.185965588690417e-13,  -3.164583746402499e-15,  -1.315020619997500e-16,
   7.505361210431117e-18,   7.609916221145854e-20,  -9.495994935570372e-07,   2.856071015084780e-08,  -4.173527856659112e-10,  -1.155472332814446e-12,  -1.152016121632255e-14,
   1.352086063692782e-14,  -3.607492103085961e-16,  -1.499226105641100e-17,   8.555552288491795e-19,   8.677992492359277e-21,  -8.873689140462508e-04,   2.659279720598855e-05,
  -3.789977719821512e-07,  -1.694830359622748e-09,   3.589532594113213e-12,   1.289233219060562e-11,  -3.552500583915990e-13,  -1.451977817413635e-14,   8.541648799671818e-16,
   7.840314421755937e-18,  -8.204938425581942e-04,   2.458796532223421e-05,  -3.504277633250800e-07,  -1.561457473300055e-09,   3.089236354751402e-12,   1.190716881965311e-11,
  -3.274384850515127e-13,  -1.341261049014397e-14,   7.868761509929116e-16,   7.283141067736450e-18,  -6.969147824784116e-04,   2.088364804848668e-05,  -2.976375693084200e-07,
  -1.318414027700037e-09,   2.304365082095459e-12,   1.009487996341110e-11,  -2.766770387395581e-13,  -1.137440341195264e-14,   6.643079350784472e-16,   6.232635701176265e-18,
  -5.354341996734858e-04,   1.604393846198729e-05,  -2.286642597126996e-07,  -1.006524205057856e-09,   1.510746205419580e-12,   7.740438001797528e-12,  -2.113959825123329e-13,
  -8.724079920844881e-15,   5.070931168278331e-16,   4.825789266196625e-18,  -3.606322719705027e-04,   1.080568548537787e-05,  -1.540083846499902e-07,  -6.745363174648241e-10,
   8.803013329123688e-13,   5.205291031820031e-12,  -1.417625225758121e-13,  -5.868082754727934e-15,   3.398068512196854e-16,   3.269827114416617e-18,  -1.991258022121728e-04,
   5.966304100018303e-06,  -8.503548595199394e-08,  -3.713707288625978e-10,   4.424249399257747e-13,   2.871546662135509e-12,  -7.807829879894353e-14,  -3.237592021678743e-15,
   1.870749671034612e-16,   1.811614061790533e-18,  -7.551013254367607e-05,   2.262451968439786e-06,  -3.224595374862697e-08,  -1.406731544863472e-10,   1.615635189217947e-13,
   1.088544772129306e-12,  -2.957992058532006e-14,  -1.227362957766257e-15,   7.086187426605662e-17,   6.878509857468710e-19,  -8.609174231350337e-06,   2.579496941661984e-07,
  -3.676470197633311e-09,  -1.603573443215006e-11,   1.830314064151957e-14,   1.241018185665263e-13,  -3.371981029092294e-15,  -1.399291656818548e-16,   8.077727426710159e-18,
   7.844075278156607e-20,  -2.502658059968753e-03,   7.436722978952888e-05,  -9.994974210584129e-07,  -8.406355547798789e-09,   9.095662584716093e-11,   3.739709771137998e-11,
  -1.074107338215460e-12,  -4.344455194850510e-14,   2.627621442188516e-15,   2.158689737351157e-17,  -2.314046353341534e-03,   6.876020046901044e-05,  -9.241310289756285e-07,
  -7.756388992966288e-09,   8.340580674656649e-11,   3.453818062549946e-11,  -9.899638040336379e-13,  -4.013465300749201e-14,   2.420649043822778e-15,   2.007455728467502e-17,
  -1.965510901586119e-03,   5.840041284505428e-05,  -7.848857307306131e-07,  -6.565260982729846e-09,   6.987557658859669e-11,   2.927969922946376e-11,  -8.364176530641065e-13,
  -3.403966581990531e-14,   2.043628939399468e-15,   1.720895832230773e-17,  -1.510083220895982e-03,   4.486578230471011e-05,  -6.029754538120847e-07,  -5.025396732248263e-09,
   5.289832791494864e-11,   2.244935142588399e-11,  -6.390054249133427e-13,  -2.611136470063596e-14,   1.560011927455549e-15,   1.334845084060066e-17,  -1.017088094842693e-03,
   3.021707437170644e-05,  -4.060991457432412e-07,  -3.374896920556668e-09,   3.521308984527443e-11,   1.509599622351699e-11,  -4.284851342706151e-13,  -1.756498972079046e-14,
   1.045389943450627e-15,   9.057024563364996e-18,  -5.615921963685878e-04,   1.668411105346427e-05,  -2.242229415959609e-07,  -1.860331670110053e-09,   1.931100139803973e-11,
   8.327606424269906e-12,  -2.359854611731437e-13,  -9.691651761836150e-15,   5.755264916636966e-16,   5.021873009043467e-18,  -2.129602691116611e-04,   6.326684123784818e-06,
  -8.502607339597130e-08,  -7.050056262730438e-10,   7.304089365294339e-12,   3.156791712828656e-12,  -8.940145727556665e-14,  -3.674156854942980e-15,   2.180035542103355e-16,
   1.907307459528492e-18,  -2.428034330331994e-05,   7.213261077963712e-07,  -9.694099148325161e-09,  -8.037170281732604e-11,   8.324095747786039e-13,   3.598959839985226e-13,
  -1.019134500958490e-14,  -4.188846221277035e-16,   2.485079853394117e-17,   2.175148811994646e-19,  -5.026041002129037e-03,   1.470453833126618e-04,  -1.752459196697607e-06,
  -3.033516920142918e-08,   4.860609162588171e-10,   7.917612894018864e-11,  -2.457058023828500e-12,  -9.558040595672949e-14,   6.117089469658136e-15,   3.949023603547106e-17,
  -4.647244373926981e-03,   1.359568751033670e-04,  -1.620231229002074e-06,  -2.801398850407240e-08,   4.478328611754715e-10,   7.311994597540136e-11,  -2.264447747175315e-12,
  -8.831060112507593e-14,   5.635352182029574e-15,   3.682908895518654e-17,  -3.947273146810431e-03,   1.154703596472813e-04,  -1.375981186329991e-06,  -2.374586302478555e-08,
   3.781614527115931e-10,   6.198264122303270e-11,  -1.913045513387800e-12,  -7.491629532938880e-14,   4.757765805056929e-15,   3.171682332323334e-17,  -3.032639349830276e-03,
   8.870739625020782e-05,  -1.056978296931445e-06,  -1.820404126449057e-08,   2.887341137779993e-10,   4.751952427009084e-11,  -1.461379228413032e-12,  -5.748090473308287e-14,
   3.631962775304966e-15,   2.471762148971734e-17,  -2.042570272016609e-03,   5.974328797712245e-05,  -7.118153643134542e-07,  -1.223998119343954e-08,   1.935182830317955e-10,
   3.195230608218582e-11,  -9.798497167112215e-13,  -3.867430819930257e-14,   2.433893402885569e-15,   1.683133046062348e-17,  -1.127817072717191e-03,   3.298642356138670e-05,
  -3.930043521255996e-07,  -6.751701009035825e-09,   1.065493792129548e-10,   1.762562301200747e-11,  -5.396210026058159e-13,  -2.134119869757874e-14,   1.339967228188819e-15,
   9.351437529215903e-18,  -4.276769785789000e-04,   1.250853947250279e-05,  -1.490262222478629e-07,  -2.559347135894865e-09,   4.036127016384769e-11,   6.681348700146181e-12,
  -2.044281139852675e-13,  -8.090885863273429e-15,   5.075683583039100e-16,   3.554350319209399e-18,  -4.876093865821035e-05,   1.426138880126045e-06,  -1.699092052205261e-08,
  -2.917821050687403e-10,   4.600914766443226e-12,   7.617179732771072e-13,  -2.330377463039922e-14,  -9.224347956207903e-16,   5.785909870809138e-17,   4.053988375271138e-19,
  -8.611915649774409e-03,   2.447824177214792e-04,  -2.198512657013117e-06,  -9.519339369157860e-08,   1.825581996348239e-09,   1.503059485098180e-10,  -5.381798884761774e-12,
  -1.840920752658838e-13,   1.334197613746755e-14,   4.201325757323490e-17,  -7.962827465063167e-03,   2.263178167158515e-04,  -2.032312423539077e-06,  -8.795212307851963e-08,
   1.684487825864819e-09,   1.388063714278838e-10,  -4.959982249124556e-12,  -1.701416745260798e-13,   1.229168794253447e-14,   3.974168450925142e-17,  -6.763411040236638e-03,
   1.922071825010526e-04,  -1.725500510589907e-06,  -7.461159090529775e-08,   1.425893199363921e-09,   1.176602174141626e-10,  -4.190372003139356e-12,  -1.444072519039885e-13,
   1.037810888755532e-14,   3.499237766138474e-17,  -5.196201432697566e-03,   1.476519958711527e-04,  -1.325107499486544e-06,  -5.724731177043023e-08,   1.091533835622365e-09,
   9.020206942344450e-11,  -3.201107301027183e-12,  -1.108568618873546e-13,   7.922870444793786e-15,   2.788074191025210e-17,  -3.499770378460355e-03,   9.943818355444307e-05,
  -8.921953439110542e-07,  -3.851757824478314e-08,   7.330860951139893e-10,   6.065051111495212e-11,  -2.146370323350353e-12,  -7.461710613283281e-14,   5.309615054979500e-15,
   1.930112773812713e-17,  -1.932411745830666e-03,   5.490228120302606e-05,  -4.925344685164908e-07,  -2.125492422029289e-08,   4.041120669218345e-10,   3.345566154595791e-11,
  -1.182057420820910e-12,  -4.118473197403922e-14,   2.923259201066445e-15,   1.082254277406955e-17,  -7.327845411458407e-04,   2.081893066159085e-05,  -1.867591730121749e-07,
  -8.058212852903871e-09,   1.531477391512222e-10,   1.268196629541294e-11,  -4.478082162396178e-13,  -1.561534432494611e-14,   1.107317231766428e-15,   4.127444011669432e-18,
  -8.354729377886254e-05,   2.373630321671081e-06,  -2.129280319288024e-08,  -9.187104750568939e-10,   1.745911701662405e-11,   1.445826608224047e-12,  -5.104791284130209e-14,
  -1.780317540232301e-15,   1.262263155876831e-16,   4.710269330841508e-19,  -1.355144924516180e-02,   3.617026929159789e-04,  -7.587626781237693e-07,  -2.995706597252051e-07,
   6.406322281080030e-09,   3.012869302239890e-10,  -1.425769573096532e-11,  -2.999924324265636e-13,   3.189233221522331e-14,  -1.477668505326791e-16,  -1.252994394923307e-02,
   3.343976366840912e-04,  -6.999025018330459e-07,  -2.768571273167404e-07,   5.914170242814890e-09,   2.782980045800369e-10,  -1.314434795132713e-11,  -2.775866587989373e-13,
   2.938645083481384e-14,  -1.333454923844571e-16,  -1.064242958003798e-02,   2.839681484176540e-04,  -5.921505020782734e-07,  -2.349674370269780e-07,   5.010397308282164e-09,
   2.359872990726849e-10,  -1.111059759095673e-11,  -2.360543499903467e-13,   2.481804365768249e-14,  -1.087147147079001e-16,  -8.176242110088792e-03,   2.181183405512542e-04,
  -4.530434784647818e-07,  -1.803683318312512e-07,   3.838877240962361e-09,   1.809852254522998e-10,  -8.492314277113495e-12,  -1.815778786409244e-13,   1.895186820448122e-14,
  -7.985322273506198e-17,  -5.506829337011477e-03,   1.468821203260596e-04,  -3.041332145527415e-07,  -1.214016606332798e-07,   2.580019723076881e-09,   1.217286452994981e-10,
  -5.696670112086185e-12,  -1.224117114127227e-13,   1.270359693874594e-14,  -5.185468584329582e-17,  -3.040594080349381e-03,   8.109325291329900e-05,  -1.676091094948191e-07,
  -6.700664080370592e-08,   1.422799779176521e-09,   6.715894445542545e-11,  -3.138089740757995e-12,  -6.762592141488065e-14,   6.994959632932277e-15,  -2.802100520174444e-17,
  -1.153012035441080e-03,   3.074997078297468e-05,  -6.351315686808079e-08,  -2.540573764357016e-08,   5.392844641885849e-10,   2.545946799265343e-11,  -1.188941152033689e-12,
  -2.564929268621742e-14,   2.649782803526170e-15,  -1.053906665073040e-17,  -1.314588182813531e-04,   3.505887989783646e-06,  -7.240495644765588e-09,  -2.896526520931224e-09,
   6.148093018932802e-11,   2.902576430394662e-12,  -1.355355359564062e-13,  -2.924459567433864e-15,   3.020588005976420e-16,  -1.199958356078111e-18,  -2.041488683437422e-02,
   4.320029954599166e-04,   1.264251551733087e-05,  -1.269967819028698e-06,   2.916888144134363e-08,   1.170951438289566e-09,  -9.362717487597716e-11,   1.185466172560247e-12,
   1.182582525252305e-13,  -5.733078928773608e-15,  -1.887540503617259e-02,   3.992716187142412e-04,   1.169702201170825e-05,  -1.173718188634062e-06,   2.690903797420116e-08,
   1.083732108868667e-09,  -8.642431960498147e-11,   1.087224920400653e-12,   1.093130679885292e-13,  -5.278207233627578e-15,  -1.603115489549430e-02,   3.388923364993985e-04,
   9.945413205058777e-06,  -9.961837322569434e-07,   2.277037254288922e-08,   9.219282772063491e-10,  -7.320284446914101e-11,   9.111042114796134e-13,   9.280130283809624e-14,
  -4.451495243220738e-15,  -1.231553320359712e-02,   2.601705053511937e-04,   7.649232380995029e-06,  -7.647447396088301e-07,   1.742452013930889e-08,   7.094602378568754e-10,
  -5.607441865481786e-11,   6.899567935635275e-13,   7.125798757597632e-14,  -3.394254568560598e-15,  -8.294338712691455e-03,   1.751284403187532e-04,   5.156368303366085e-06,
  -5.147538601658851e-07,   1.169905046021283e-08,   4.784490689598428e-10,  -3.767957663074781e-11,   4.594095381942372e-13,   4.797221301452087e-14,  -2.272503646548167e-15,
  -4.579598850424375e-03,   9.666508493117454e-05,   2.848515264130450e-06,  -2.841210958406924e-07,   6.447963884479672e-09,   2.643708109251873e-10,  -2.077691018507940e-11,
   2.519827559910487e-13,   2.648090356474162e-14,  -1.250442422155740e-15,  -1.736595384737617e-03,   3.665143665281594e-05,   1.080377770652383e-06,  -1.077262167062351e-07,
   2.443447833324184e-09,   1.002787766110284e-10,  -7.874766405452488e-12,   9.531452210681829e-14,   1.004072036729843e-14,  -4.735609341104779e-16,  -1.979948213620422e-04,
   4.178668600471423e-06,   1.231813786274648e-07,  -1.228196240027585e-08,   2.785544218478510e-10,   1.143364760137293e-11,  -8.977539095318951e-13,   1.086261951351663e-14,
   1.144757619421561e-15,  -5.398067937100929e-17,  -8.679556164909321e-05,   2.595730852556073e-06,  -4.386141661485184e-08,   2.646791886671949e-11,   1.610721415019309e-11,
   2.878302815265988e-13,  -4.363209051788309e-14,   8.743922774424516e-16,   4.156311990983810e-17,  -2.434288869174092e-18,  -8.025465129898543e-05,   2.400063053958374e-06,
  -4.055088446998929e-08,   2.460140642602036e-11,   1.486451239776881e-11,   2.669203022102835e-13,  -4.029192703508026e-14,   8.046961548598963e-16,   3.843786767760877e-17,
  -2.242826267268822e-18,  -6.816746638573820e-05,   2.038513872336297e-06,  -3.443634545680915e-08,   2.107520715738145e-11,   1.258555862201537e-11,   2.278040399744106e-13,
  -3.415095919795148e-14,   6.782143218604393e-16,   3.265778694643194e-17,  -1.893879271975883e-18,  -5.237286471130701e-05,   1.566123346112876e-06,  -2.645152091393154e-08,
   1.633837571408417e-11,   9.636717544769846e-12,   1.759010973451515e-13,  -2.617890493110677e-14,   5.167765320093946e-16,   2.509762594686330e-17,  -1.445991597991940e-18,
  -3.527499576135765e-05,   1.054807774104437e-06,  -1.781296297416177e-08,   1.108225777903203e-11,   6.473345843661046e-12,   1.189399787098924e-13,  -1.760105778184068e-14,
   3.457992972880723e-16,   1.690741068556207e-17,  -9.691301704505489e-19,  -1.947740822492472e-05,   5.824113843487203e-07,  -9.834607849935892e-09,   6.143997554240461e-12,
   3.568799630044117e-12,   6.582127356675740e-14,  -9.708586576651062e-15,   1.902151469293428e-16,   9.336550880447383e-18,  -5.335878910003441e-19,  -7.386000429629455e-06,
   2.208539343905860e-07,  -3.729228134373097e-09,   2.333395262687639e-12,   1.352534222178161e-12,   2.498096028141666e-14,  -3.680155852763789e-15,   7.202866218819533e-17,
   3.540633616276202e-18,  -2.021239741963896e-19,  -8.421038843521938e-07,   2.518030611791587e-08,  -4.251797767765099e-10,   2.661054969296722e-13,   1.541923448715085e-13,
   2.848563220170926e-15,  -4.195606072590273e-16,   8.210303606729368e-18,   4.036825813534599e-19,  -2.304076247688868e-20,  -7.871676409500401e-04,   2.349656595380651e-05,
  -3.922267875453608e-07,  -1.208152285310923e-10,   1.589887274611532e-10,   2.480957380277614e-12,  -4.052862087291549e-13,   8.271995970619069e-15,   3.854066760511947e-16,
  -2.293961737252781e-17,  -7.278464673862378e-04,   2.172533274064960e-05,  -3.626187402868918e-07,  -1.105965875703993e-10,   1.467390357465289e-10,   2.301386048604506e-12,
  -3.742610494700703e-13,   7.612786220971637e-15,   3.564498374040406e-16,  -2.113587070110991e-17,  -6.182248745145721e-04,   1.845252900092032e-05,  -3.079351629937695e-07,
  -9.238248924119149e-11,   1.242648780166779e-10,   1.965043544338663e-12,  -3.172201394554969e-13,   6.416399186881013e-15,   3.028807093732804e-16,  -1.784818112191615e-17,
  -4.749800765807812e-04,   1.417641876427861e-05,  -2.365291785710094e-07,  -6.970394349086676e-11,   9.516808033106384e-11,   1.518068571294640e-12,  -2.431703365497601e-13,
   4.889233379159848e-15,   2.327906955605015e-16,  -1.362779715139779e-17,  -3.199159032513345e-04,   9.548003926627880e-06,  -1.592809460926474e-07,  -4.627129638717962e-11,
   6.393802301257168e-11,   1.026869698076908e-12,  -1.634928827053414e-13,   3.271695124574553e-15,   1.568366838642487e-16,  -9.133901976113268e-18,  -1.766444140229311e-04,
   5.271914648074439e-06,  -8.793889578635967e-08,  -2.533302997255350e-11,   3.525267299275806e-11,   5.683919076183553e-13,  -9.018132876674255e-14,   1.799699670155713e-15,
   8.661210346882747e-17,  -5.029079215833575e-18,  -6.698507162496667e-05,   1.999140755051695e-06,  -3.334582934483700e-08,  -9.575702998466176e-12,   1.336081664333536e-11,
   2.157376334948572e-13,  -3.418432691105126e-14,   6.814949290256509e-16,   3.284590131130746e-17,  -1.905037149275540e-18,  -7.637203462721934e-06,   2.279287932885726e-07,
  -3.801849671663324e-09,  -1.091177305970204e-12,   1.523175754180845e-12,   2.460075672805787e-14,  -3.897225720476636e-15,   7.768137161548218e-17,   3.744911366098018e-18,
  -2.171615748765625e-19,  -2.221723254173651e-03,   6.603886780738809e-05,  -1.072217796076190e-06,  -2.612649358273838e-09,   5.306945382758873e-10,   6.156906749005852e-12,
  -1.204929907073481e-12,   2.561548479566570e-14,   1.137780795968423e-15,  -7.027415451820603e-17,  -2.054292009724583e-03,   6.106038372202184e-05,  -9.912541007053988e-07,
  -2.412930219349207e-09,   4.899024148807682e-10,   5.715856884021540e-12,  -1.112700001760542e-12,   2.357529910692110e-14,   1.052455281718766e-15,  -6.475203870454397e-17,
  -1.744891119484332e-03,   5.186154949792700e-05,  -8.417361290342868e-07,  -2.045560127819844e-09,   4.150050539614376e-10,   4.886848456780254e-12,  -9.431263283464682e-13,
   1.987193364419619e-14,   8.945079980620559e-16,  -5.468477272059899e-17,  -1.340592161869524e-03,   3.984303474249777e-05,  -6.465204151243250e-07,  -1.568359402910637e-09,
   3.179410797505990e-10,   3.780397588681635e-12,  -7.229788657602065e-13,   1.514352948304680e-14,   6.876875697909251e-16,  -4.175799563633199e-17,  -9.029353581487706e-04,
   2.683462564955454e-05,  -4.353577372732622e-07,  -1.054623624390217e-09,   2.136649802939315e-10,   2.559872046713389e-12,  -4.860919271312573e-13,   1.013418759976881e-14,
   4.634057083031948e-16,  -2.799000806292222e-17,  -4.985634964974628e-04,   1.481663678647728e-05,  -2.403558782855151e-07,  -5.817698033851931e-10,   1.178243240422222e-10,
   1.417789275082631e-12,  -2.681259078145955e-13,   5.574852880775649e-15,   2.559427998671594e-16,  -1.541182336799937e-17,  -1.890594965213917e-04,   5.618546808673695e-06,
  -9.114062370020125e-08,  -2.205336686943621e-10,   4.465825670281752e-11,   5.382538662358359e-13,  -1.016366051031118e-13,   2.111069344120792e-15,   9.706540316323895e-17,
  -5.838161190713859e-18,  -2.155533691907044e-05,   6.405893537355146e-07,  -1.039118009801128e-08,  -2.514233620748452e-11,   5.091234113713005e-12,   6.137985243292213e-14,
  -1.158720891325890e-14,   2.406344672430635e-16,   1.106695032574775e-17,  -6.655133775823377e-19,  -4.467888801775149e-03,   1.317984401991745e-04,  -2.029484790655077e-06,
  -1.361443816192096e-08,   1.373775758961394e-09,   9.052413819726461e-12,  -2.653194400041366e-12,   6.072021772830625e-14,   2.446219414129544e-15,  -1.623175476533542e-16,
  -4.131178639794162e-03,   1.218614193298933e-04,  -1.876140813487207e-06,  -1.258401303510638e-08,   1.268483905704461e-09,   8.424742631880153e-12,  -2.450177499195704e-12,
   5.589056787488778e-14,   2.263470269108710e-15,  -1.495784764007211e-16,  -3.508965918941887e-03,   1.035012768905470e-04,  -1.593014419775882e-06,  -1.068250885019489e-08,
   1.074979608391420e-09,   7.231630132240311e-12,  -2.076869310724539e-12,   4.711996569717770e-14,   1.924749673641342e-15,  -1.263447686232918e-16,  -2.695916599434362e-03,
   7.951439311931286e-05,  -1.223452327206184e-06,  -8.202240016048611e-09,   8.239029760956535e-10,   5.617494900615759e-12,  -1.592156550480094e-12,   3.591544673803065e-14,
   1.480509665708164e-15,  -9.649621131505876e-17,  -1.815789988638534e-03,   5.355295789920441e-05,  -8.237974472925358e-07,  -5.521784243177189e-09,   5.538688575824289e-10,
   3.816017428755840e-12,  -1.070520183800481e-12,   2.403886298452741e-14,   9.980698216541199e-16,  -6.468988847761486e-17,  -1.002602911842596e-03,   2.956884975930650e-05,
  -4.547903544151985e-07,  -3.048034109441669e-09,   3.054864510826464e-10,   2.117352693619163e-12,  -5.905063549484910e-13,   1.322511548411516e-14,   5.513728970128915e-16,
  -3.562243623883137e-17,  -3.801953522231514e-04,   1.121263345617113e-05,  -1.724494667808690e-07,  -1.155716734652771e-09,   1.157950820234273e-10,   8.043833517294696e-13,
  -2.238409006794506e-13,   5.008227251692175e-15,   2.091247829489305e-16,  -1.349457697775063e-17,  -4.334740389707819e-05,   1.278389349635742e-06,  -1.966136344622003e-08,
  -1.317649851105225e-10,   1.320129742889968e-11,   9.173824950764411e-14,  -2.551929727674157e-14,   5.708761864596265e-16,   2.384379525627847e-17,  -1.538304240587673e-18,
  -7.674258610609323e-03,   2.232991827113005e-04,  -3.091876966234604e-06,  -4.987287559866772e-08,   3.358434130722032e-09,   3.756189631665831e-12,  -5.318476392193986e-12,
   1.387574949760860e-13,   4.525753364249125e-15,  -3.483266049592111e-16,  -7.095891528478263e-03,   2.064598727167321e-04,  -2.857929706133994e-06,  -4.611131828795979e-08,
   3.101791199818245e-09,   3.598247961052846e-12,  -4.911965726940539e-12,   1.277554286098253e-13,   4.190645711649968e-15,  -3.210581653504697e-16,  -6.027127332795743e-03,
   1.753488470167247e-04,  -2.426181291662299e-06,  -3.916203308924998e-08,   2.629681746096778e-09,   3.230187621455165e-12,  -4.164201897990791e-12,   1.077557006807226e-13,
   3.567680919403556e-15,  -2.712846300337565e-16,  -4.630584176594420e-03,   1.347069457959365e-04,  -1.862957605611442e-06,  -3.008438820220613e-08,   2.016348462785043e-09,
   2.622861863206583e-12,  -3.192837983030284e-12,   8.217213170507374e-14,   2.747600278118358e-15,  -2.072720523840310e-16,  -3.118842636906920e-03,   9.072301972324255e-05,
  -1.254201732596354e-06,  -2.026092366182454e-08,   1.355949839237761e-09,   1.841089397483127e-12,  -2.147037759652341e-12,   5.502019418963192e-14,   1.854029141822628e-15,
  -1.389935819281048e-16,  -1.722090415241021e-03,   5.009133115592533e-05,  -6.923383603692425e-07,  -1.118661216297868e-08,   7.480208401822526e-10,   1.040246491282577e-12,
  -1.184405220735237e-12,   3.027633793584809e-14,   1.024797167296921e-15,  -7.655185566859539e-17,  -6.530305056296039e-04,   1.899474882371036e-05,  -2.625149603828015e-07,
  -4.241967700098957e-09,   2.835592564827236e-10,   3.978364313347620e-13,  -4.489797722657222e-13,   1.146631635055975e-14,   3.887645347115496e-16,  -2.900140727802044e-17,
  -7.445428630122745e-05,   2.165652180001279e-06,  -2.992976838411522e-08,  -4.836399200573679e-10,   3.232776131997359e-11,   4.542231751010690e-14,  -5.118679796360750e-14,
   1.307036741100109e-15,   4.432729152252212e-17,  -3.306028739968495e-18,  -1.213664232678007e-02,   3.433265565085670e-04,  -3.603157775894589e-06,  -1.684133277543543e-07,
   8.863843035744414e-09,  -4.216673471566343e-11,  -1.121404320527318e-11,   3.760121670062798e-13,   6.668598221415343e-15,  -7.938295777074963e-16,  -1.122191187873606e-02,
   3.174237009393786e-04,  -3.329229868520637e-06,  -1.557354188841272e-07,   8.188323104154457e-09,  -3.864772387193599e-11,  -1.036036182950832e-11,   3.464286163937047e-13,
   6.192472470619779e-15,  -7.321081592872161e-16,  -9.531616891121255e-03,   2.695748683189266e-04,  -2.824477436189530e-06,  -1.322989915369203e-07,   6.944568544314779e-09,
  -3.235240727657932e-11,  -8.787966428881861e-12,   2.925173031115752e-13,   5.296361104017593e-15,  -6.191961255950115e-16,  -7.322984133228356e-03,   2.070797321684678e-04,
  -2.167320945883394e-06,  -1.016601893431618e-07,   5.326933025512195e-09,  -2.447082292660629e-11,  -6.741933669832304e-12,   2.233291503953638e-13,   4.098653972313846e-15,
  -4.735653756527258e-16,  -4.932222951661022e-03,   1.394576567244553e-04,  -1.458329271523224e-06,  -6.847977069557047e-08,   3.583346759815860e-09,  -1.627836436080882e-11,
  -4.535701186723360e-12,   1.496740755931817e-13,   2.776062262510153e-15,  -3.178167987746954e-16,  -2.723349704640299e-03,   7.699709016852195e-05,  -8.047714919048427e-07,
  -3.781425508170096e-08,   1.977133698188220e-09,  -8.923518790625147e-12,  -2.502757115378231e-12,   8.240656020193003e-14,   1.537724876390208e-15,  -1.751199354072770e-16,
  -1.032714479003655e-03,   2.919714355190383e-05,  -3.051110312272950e-07,  -1.433984902033602e-08,   7.495405624096164e-10,  -3.374669075989500e-12,  -9.488286987532526e-13,
   3.121550906839815e-14,   5.838133927772652e-16,  -6.635492691120941e-17,  -1.177433508346411e-04,   3.328853631532016e-06,  -3.478554904678807e-08,  -1.634943390821734e-09,
   8.545387185708280e-11,  -3.845839711820626e-13,  -1.081747915744936e-13,   3.558351989326023e-15,   6.657573719174367e-17,  -7.564374676332253e-18,  -1.856846800919872e-02,
   4.811843043499480e-04,   6.246785566919333e-07,  -7.213656635527320e-07,   3.424771431654249e-08,  -4.282527561472287e-10,  -3.558215339132300e-11,   2.150009440392901e-12,
  -3.301768103431801e-14,  -1.861505662855935e-15,  -1.716869805981463e-02,   4.448163724173553e-04,   5.865434293666823e-07,  -6.671693420211324e-07,   3.164248968006434e-08,
  -3.940041639627502e-10,  -3.293909089179357e-11,   1.984965264465342e-12,  -3.029629526402254e-14,  -1.725489328120442e-15,  -1.458228453832128e-02,   3.776747169102459e-04,
   5.106625378963823e-07,  -5.669168159661608e-07,   2.684286459406973e-08,  -3.319118810386924e-10,  -2.803133484770617e-11,   1.681790805174886e-12,  -2.540891361214037e-14,
  -1.471502215354172e-15,  -1.120301325149154e-02,   2.900459653976883e-04,   4.024884782606167e-07,  -4.357470422274770e-07,   2.059559915657340e-08,  -2.527677475280504e-10,
  -2.157941682891366e-11,   1.288668459605945e-12,  -1.925782804401733e-14,  -1.135289674156357e-15,  -7.545357483509042e-03,   1.952924852008515e-04,   2.764653484090331e-07,
  -2.935895430724423e-07,   1.385717752261588e-08,  -1.690629468383604e-10,  -1.455714100555578e-11,   8.661335656966801e-13,  -1.283137546852648e-14,  -7.671397478794205e-16,
  -4.166150639921845e-03,   1.078121694976173e-04,   1.543647126493735e-07,  -1.621393446970584e-07,   7.646680385611919e-09,  -9.297236297315838e-11,  -8.045031014736106e-12,
   4.776592865179949e-13,  -7.040598565218975e-15,  -4.243672406899535e-16,  -1.579827730192526e-03,   4.088040328618000e-05,   5.878012175490335e-08,  -6.148906902835234e-08,
   2.899019420000706e-09,  -3.520222398762528e-11,  -3.051763618753322e-12,   1.810492548462785e-13,  -2.663544158215304e-15,  -1.610348726004397e-16,  -1.801214818555771e-04,
   4.660863795225721e-06,   6.706333726802008e-09,  -7.010668821184372e-09,   3.305147840241514e-10,  -4.012514738200902e-12,  -3.479615406119874e-13,   2.064048858015017e-14,
  -3.035607918379944e-16,  -1.836225034514483e-17,  -7.710605355279064e-05,   2.250607874246808e-06,  -4.196473389868826e-08,   2.833919609890931e-10,   1.383216516711282e-11,
  -3.892088450670412e-13,  -1.216982391724766e-14,   1.043749215080301e-15,  -2.003977580676625e-17,  -7.104120916808521e-19,  -7.129547587850070e-05,   2.080989387937148e-06,
  -3.879772588853220e-08,   2.618615638994888e-10,   1.278136826208058e-11,  -3.589135755792893e-13,  -1.127647821669726e-14,   9.639343277894531e-16,  -1.843139797536459e-17,
  -6.585932948932797e-19,  -6.055781956382988e-05,   1.767552938846897e-06,  -3.294804740219786e-08,   2.221803913662695e-10,   1.084462292746841e-11,  -3.035138882856525e-13,
  -9.611126432980700e-15,   8.171380242344019e-16,  -1.551880722084566e-17,  -5.617765990346998e-19,  -4.652654503571850e-05,   1.357991204897080e-06,  -2.530872497658625e-08,
   1.705037160677206e-10,   8.322304168093688e-12,  -2.320949279682943e-13,  -7.410954451450797e-15,   6.264827285427731e-16,  -1.181195637004454e-17,  -4.335249700789124e-19,
  -3.133736989612712e-05,   9.146478832736416e-07,  -1.704359522276406e-08,   1.147362728403774e-10,   5.600277968311858e-12,  -1.557450619287829e-13,  -5.005651026537283e-15,
   4.212561937543167e-16,  -7.897024349748717e-18,  -2.929982798021352e-19,  -1.730323773901747e-05,   5.050286471344043e-07,  -9.409904072467716e-09,   6.331956557912936e-11,
   3.090619806724381e-12,  -8.581164012617238e-14,  -2.768395121818548e-15,   2.323762835345611e-16,  -4.341723002406490e-18,  -1.620991466399620e-19,  -6.561539913813456e-06,
   1.915108484957071e-07,  -3.568192369835397e-09,   2.400661286913131e-11,   1.171758120425481e-12,  -3.251426288331324e-14,  -1.050435917593897e-15,   8.808714138310087e-17,
  -1.643759403587113e-18,  -6.151442983834362e-20,  -7.481043094792613e-07,   2.183481872239819e-08,  -4.068198165851286e-10,   2.736989368444728e-12,   1.335918891596729e-13,
  -3.706569457063027e-15,  -1.197759197749888e-16,   1.004252097732006e-17,  -1.873605459196235e-19,  -7.014326729190387e-21,  -6.994039291974095e-04,   2.039699550467998e-05,
  -3.782327791364204e-07,   2.386113777108623e-09,   1.342981395707252e-10,  -3.767354035744418e-12,  -1.102382611869581e-13,   9.727944573508097e-15,  -1.903243223687030e-16,
  -6.523143620535416e-18,  -6.466979599062723e-04,   1.885973885346465e-05,  -3.496856538183093e-07,   2.204619016736122e-09,   1.241010572851709e-10,  -3.474453193032218e-12,
  -1.021566627570072e-13,   8.984204209525359e-15,  -1.750604520543785e-16,  -6.048221215279434e-18,  -5.493000362648904e-04,   1.601907094456648e-05,  -2.969587062987477e-07,
   1.870246403996743e-09,   1.053034745980139e-10,  -2.938636607703608e-12,  -8.708452193969897e-14,   7.616219391501007e-15,  -1.474127484063984e-16,  -5.160330325843882e-18,
  -4.220268417313359e-04,   1.230724599110506e-05,  -2.281030883636166e-07,   1.435007053243901e-09,   8.081721292147157e-11,  -2.247545883277878e-12,  -6.716111641155459e-14,
   5.839365586242728e-15,  -1.122144856393341e-16,  -3.983237589124852e-18,  -2.842508112474736e-04,   8.289285408062718e-06,  -1.536094008525510e-07,   9.655249962680245e-10,
   5.438700545313770e-11,  -1.508401997502381e-12,  -4.536953939138262e-14,   3.926564166463316e-15,  -7.502925742477343e-17,  -2.692596202177117e-18,  -1.569518667505811e-04,
   4.576977017511682e-06,  -8.480848189205702e-08,   5.328041195316544e-10,   3.001551241102650e-11,  -8.311582963039148e-13,  -2.509379110674583e-14,   2.166026995914511e-15,
  -4.125272018851506e-17,  -1.489823982545558e-18,  -5.951752509180559e-05,   1.735625142403235e-06,  -3.215891723128292e-08,   2.019984756305038e-10,   1.138003618726675e-11,
  -3.149376087188607e-13,  -9.521834708497473e-15,   8.210823268152872e-16,  -1.561843500574802e-17,  -5.653914095155342e-19,  -6.785802909584746e-06,   1.978846538155357e-07,
  -3.666528814199634e-09,   2.302969840486540e-11,   1.297438178322539e-12,  -3.590251927224838e-14,  -1.085732206907285e-15,   9.360893140186841e-17,  -1.780241273541741e-18,
  -6.447051933496718e-20,  -1.974716843785878e-03,   5.748063066515253e-05,  -1.052865881628072e-06,   5.582291517282012e-09,   4.348676234822968e-10,  -1.215102946626533e-11,
  -3.094026643578920e-13,   2.911378652450311e-14,  -5.935024950390929e-16,  -1.882627168699027e-17,  -1.825904637100008e-03,   5.314834686869777e-05,  -9.733847560515464e-07,
   5.156240572160814e-09,   4.018800850378348e-10,  -1.120838909435353e-11,  -2.867919171076913e-13,   2.688898688901468e-14,  -5.459833412885270e-16,  -1.746173691241296e-17,
  -1.550907735021293e-03,   4.514289186445255e-05,  -8.265916708891858e-07,   4.372184007853977e-09,   3.410511410551632e-10,  -9.482760700521683e-12,  -2.445781686546472e-13,
   2.279620054818603e-14,  -4.598655458352711e-16,  -1.490680143187069e-17,  -1.191560574667895e-03,   3.468253023421074e-05,  -6.349121560798842e-07,   3.353058916229689e-09,
   2.617821504120892e-10,  -7.255020755327064e-12,  -1.887033963341035e-13,   1.747907786762450e-14,  -3.501522157153237e-16,  -1.151334429427346e-17,  -8.025600571380308e-04,
   2.335959371869222e-05,  -4.275534773606748e-07,   2.255190900844076e-09,   1.761887316142417e-10,  -4.870336774212555e-12,  -1.275176459847963e-13,   1.175408853203485e-14,
  -2.341681267322461e-16,  -7.786405140800797e-18,  -4.431412570891967e-04,   1.289810600623367e-05,  -2.360512275564431e-07,   1.244201480203592e-09,   9.724243097935532e-11,
  -2.684048991458040e-12,  -7.054313299074840e-14,   6.484158253758926e-15,  -1.287661087271002e-16,  -4.309385342863289e-18,  -1.680430344580589e-04,   4.891057565422175e-06,
  -8.950890849572537e-08,   4.716663864076085e-10,   3.686921231538571e-11,  -1.017081151504135e-12,  -2.676948311762079e-14,   2.457997872752608e-15,  -4.875352672798330e-17,
  -1.635582300592185e-18,  -1.915917856736431e-05,   5.576463910684705e-07,  -1.020515469628169e-08,   5.377359437515785e-11,   4.203476036682124e-12,  -1.159471423859872e-13,
  -3.052440318227939e-15,   2.802289012608760e-16,  -5.557130956519073e-18,  -1.865054184605440e-19,  -3.973680133073479e-03,   1.152773094204233e-04,  -2.064385849053951e-06,
   7.028017120460141e-09,   1.080638143470919e-09,  -3.018134037218113e-11,  -6.093052975403678e-13,   6.469917353280874e-14,  -1.417514401145077e-15,  -3.870400023030546e-17,
  -3.674226077276691e-03,   1.065883682276743e-04,  -1.908484823991830e-06,   6.485177973145215e-09,   9.987699396235923e-10,  -2.784691573791928e-11,  -5.650787169810150e-13,
   5.975984421886522e-14,  -1.304362730724140e-15,  -3.592539038772500e-17,  -3.120852676800787e-03,   9.053275305149031e-05,  -1.620588593767199e-06,   5.490057417982484e-09,
   8.477420447980322e-10,  -2.356934653055515e-11,  -4.823201037514254e-13,   5.067045337187337e-14,  -1.099103707585622e-15,  -3.070583985070349e-17,  -2.397744610950084e-03,
   6.955417333521718e-05,  -1.244719801950047e-06,   4.203040388247042e-09,   6.508250214820056e-10,  -1.804023898599400e-11,  -3.724696263882096e-13,   3.885719826864535e-14,
  -8.372731998671888e-16,  -2.374559543340541e-17,  -1.614968069302331e-03,   4.684622602732955e-05,  -8.381652749381973e-07,   2.822987102987811e-09,   4.380920899247870e-10,
  -1.211472744541056e-11,  -2.518763948410085e-13,   2.613301619051656e-14,  -5.601432051837073e-16,  -1.607462918115910e-17,  -8.917196833136308e-04,   2.586625051139996e-05,
  -4.627374712499046e-07,   1.556220628820871e-09,   2.418129397632547e-10,  -6.677787279678664e-12,  -1.393949727023139e-13,   1.441722310290917e-14,  -3.080820668584259e-16,
  -8.901444516504272e-18,  -3.381478234183560e-04,   9.808659090539329e-06,  -1.754650421305984e-07,   5.897740341249999e-10,   9.168563219642993e-11,  -2.530641710804564e-12,
  -5.290514007408143e-14,   5.465373024409934e-15,  -1.166557475609513e-16,  -3.379151400675357e-18,  -3.855342375535352e-05,   1.118318864280950e-06,  -2.000521682762015e-08,
   6.723544376219240e-11,   1.045317620362232e-11,  -2.884965105918162e-13,  -6.032758084442466e-15,   6.230930913179556e-16,  -1.329708932216061e-17,  -3.853377971674164e-19,
  -6.833072976048139e-03,   1.970516956745641e-04,  -3.383905080933380e-06,  -9.908202078897533e-10,   2.512707110767066e-09,  -7.093343952234098e-11,  -9.675981111881634e-13,
   1.308348249042481e-13,  -3.241434481107569e-15,  -6.479990086987184e-17,  -6.318129324914388e-03,   1.821973437117625e-04,  -3.128159722646673e-06,  -9.468675767371995e-10,
   2.322642334898467e-09,  -6.546632892154748e-11,  -8.985634465749410e-13,   1.208672706999521e-13,  -2.984080207806012e-15,  -6.026077271460557e-17,  -5.366548429005247e-03,
   1.547501901917984e-04,  -2.656002579433892e-06,  -8.470242231483924e-10,   1.971839088934893e-09,  -5.543703015718400e-11,  -7.686262907601870e-13,   1.025123926271387e-13,
  -2.516433561869491e-15,  -5.166181435492974e-17,  -4.123099399121558e-03,   1.188889458584691e-04,  -2.039764700952277e-06,  -6.855608476583053e-10,   1.514148736664755e-09,
  -4.245415261609331e-11,  -5.949119659759394e-13,   7.863621142923145e-14,  -1.918547603384528e-15,  -4.007730499221690e-17,  -2.777052622597758e-03,   8.007320970083720e-05,
  -1.373412313315710e-06,  -4.801603052891262e-10,   1.019402709655546e-09,  -2.852132774810130e-11,  -4.030056531650289e-13,   5.289837988909167e-14,  -1.284367284902820e-15,
  -2.719641660899894e-17,  -1.533374057242239e-03,   4.421227290538376e-05,  -7.582011937719560e-07,  -2.709842584319097e-10,   5.627348988206550e-10,  -1.572504214264643e-11,
  -2.232575340330961e-13,   2.918724394962911e-14,  -7.066786521218399e-16,  -1.508107396428056e-17,  -5.814685099510820e-04,   1.676554890642639e-05,  -2.874963486210236e-07,
  -1.035933894638175e-10,   2.133742970892442e-10,  -5.959758878311430e-12,  -8.476558206316147e-14,   1.106504746448542e-14,  -2.676233473623682e-16,  -5.728008499255195e-18,
  -6.629526789874479e-05,   1.911496837865222e-06,  -3.277809079254383e-08,  -1.182680238981685e-11,   2.432718329117073e-11,  -6.794304786276243e-13,  -9.666394433529085e-15,
   1.261508133230833e-15,  -3.050596599813190e-17,  -6.532429089623462e-19,  -1.083056394357170e-02,   3.086878223437539e-04,  -4.838205500445730e-06,  -4.423929424201602e-08,
   6.212124120808773e-09,  -1.823543416391328e-10,  -1.001260623854129e-12,   2.739204971507629e-13,  -8.509675652458729e-15,  -6.235189248030597e-17,  -1.001434354861581e-02,
   2.854123251211067e-04,  -4.471858563278040e-06,  -4.098364113783667e-08,   5.743142716889255e-09,  -1.683563115891122e-10,  -9.360762264223298e-13,   2.531657605442555e-13,
  -7.841146487305601e-15,  -5.864484361310922e-17,  -8.506038107018915e-03,   2.424084106807707e-04,  -3.795924367573265e-06,  -3.492000888058357e-08,   4.876992145918567e-09,
  -1.426435370087144e-10,  -8.093742715581941e-13,   2.148782209576863e-13,  -6.622227682013674e-15,  -5.118892392971018e-17,  -6.535130525522864e-03,   1.862271085610519e-04,
  -2.914420422088490e-06,  -2.691759835510389e-08,   3.746013834039572e-09,  -1.093020859283287e-10,  -6.334396638603739e-13,   1.649594781524187e-13,  -5.056916747580940e-15,
  -4.044390656175105e-17,  -4.401626064758454e-03,   1.254228869921225e-04,  -1.961918457798715e-06,  -1.817688926167580e-08,   2.522558673996262e-09,  -7.346493497040453e-11,
  -4.327724028195472e-13,   1.110358270565743e-13,  -3.389635806141504e-15,  -2.782854060091856e-17,  -2.430391979364025e-03,   6.925091961968749e-05,  -1.082957176974535e-06,
  -1.005147154800727e-08,   1.392688454011409e-09,  -4.051529546448240e-11,  -2.409074486957855e-13,   6.128683850932704e-14,  -1.866401722826969e-15,  -1.555247846428198e-17,
  -9.216246940027704e-04,   2.626019252476251e-05,  -4.106191225206617e-07,  -3.813730258388065e-09,   5.280958388045907e-10,  -1.535676691779012e-11,  -9.163127023937100e-14,
   2.323726280012243e-14,  -7.070129647886154e-16,  -5.924167283788033e-18,  -1.050776572262897e-04,   2.994010272667947e-06,  -4.681523183743589e-08,  -4.348569713711569e-10,
   6.020961777448823e-11,  -1.750747074661111e-12,  -1.045243837238350e-14,   2.649300872301905e-15,  -8.059500122913285e-17,  -6.759363127381087e-19,  -1.667653523475288e-02,
   4.600101830724052e-04,  -5.127272760066874e-06,  -2.705111296287042e-07,   2.124311719631744e-08,  -7.132442755564715e-10,   5.132642297670917e-12,   7.359249897244526e-13,
  -3.976408508966176e-14,   7.822058079179061e-16,  -1.541964031886318e-02,   4.252974741582063e-04,  -4.735170182990439e-06,  -2.504301417636569e-07,   1.964495500368243e-08,
  -6.587948647882626e-10,   4.697099785481694e-12,   6.816538284048278e-13,  -3.673248995898875e-14,   7.192422002918500e-16,  -1.309707020875623e-02,   3.611785669823823e-04,
  -4.014039747997456e-06,  -2.131372772205190e-07,   1.668997272261892e-08,  -5.585970911432961e-10,   3.921750217588344e-12,   5.806387526463689e-13,  -3.115110683874398e-14,
   6.053168316910041e-16,  -1.006226762634250e-02,   2.774396567156693e-04,  -3.077481655860721e-06,  -1.640984177969228e-07,   1.282587606861851e-08,  -4.283712226168464e-10,
   2.957759556456858e-12,   4.474394345120776e-13,  -2.389295485678066e-14,   4.604987809921534e-16,  -6.777204939871309e-03,   1.868375238953210e-04,  -2.069351701263696e-06,
  -1.107091828040660e-07,   8.640266615705608e-09,  -2.881000769511390e-10,   1.962866963972852e-12,   3.020709387350524e-13,  -1.607120963340299e-14,   3.077433945632459e-16,
  -3.742065759708525e-03,   1.031551032635182e-04,  -1.141514345592492e-06,  -6.118735987894883e-08,   4.771300856787724e-09,  -1.589420544648594e-10,   1.074487570555673e-12,
   1.670148364579058e-13,  -8.866961443628343e-15,   1.691525735461131e-16,  -1.419019291376201e-03,   3.911602933648351e-05,  -4.327158387546090e-07,  -2.321106829399153e-08,
   1.809389059593025e-09,  -6.025295674133326e-11,   4.061272076112038e-13,   6.336524283586692e-14,  -3.361442485496699e-15,   6.403436757125177e-17,  -1.617873009804012e-04,
   4.459732036795042e-06,  -4.933250242952613e-08,  -2.646532297598109e-09,   2.062961464011335e-10,  -6.869287909840565e-12,   4.627890118514109e-14,   7.225094486277765e-15,
  -3.832312402429370e-16,   7.298709467062642e-18,  -6.874906525811018e-05,   1.931603823462346e-06,  -3.752083064319439e-08,   4.350137285416394e-10,   5.063539091487721e-12,
  -4.148782502024170e-13,   6.512124629762290e-15,   2.965802239516941e-16,  -1.996749781257474e-17,   4.202408240133315e-19,  -6.356826300901618e-05,   1.786052443275703e-06,
  -3.469109039501306e-08,   4.020403950381499e-10,   4.686028412783894e-12,  -3.833275973345475e-13,   5.996791958384475e-15,   2.748732158594846e-16,  -1.844758536173233e-17,
   3.867733977224901e-19,  -5.399439575789656e-05,   1.517074169528808e-06,  -2.946322207659129e-08,   3.412231609306794e-10,   3.985929940411279e-12,  -3.251957721427394e-13,
   5.059363497462249e-15,   2.343680039078677e-16,  -1.564791785134739e-17,   3.260153757280955e-19,  -4.148387807929256e-05,   1.165579750547650e-06,  -2.263403651623356e-08,
   2.619442644582560e-10,   3.066977102910402e-12,  -2.495212205902508e-13,   3.859198824842972e-15,   1.807891196030323e-16,  -1.200477854334477e-17,   2.484352064601295e-19,
  -2.794094949681547e-05,   7.850681375390857e-07,  -1.524352219243656e-08,   1.763141493085329e-10,   2.068146469360743e-12,  -1.678884484981153e-13,   2.584534112805619e-15,
   1.221504251769903e-16,  -8.076322455179541e-18,   1.662485768911979e-19,  -1.542787220004107e-05,   4.334851932189385e-07,  -8.416431157136375e-09,   9.731693038185613e-11,
   1.142717248358205e-12,  -9.264591934614320e-14,   1.422368702806182e-15,   6.756796345978954e-17,  -4.456428974209946e-18,   9.145121215963123e-20,  -5.850385019610309e-06,
   1.643816934571195e-07,  -3.191523483287516e-09,   3.689821610762301e-11,   4.334378870794611e-13,  -3.512426131904157e-14,   5.387046182732424e-16,   2.563962550597823e-17,
  -1.689489984408215e-18,   3.463004869663957e-20,  -6.670230355740648e-07,   1.874174227519481e-08,  -3.638756923330778e-10,   4.206797125264282e-12,   4.941985006345513e-14,
  -4.004491850239178e-15,   6.140695034810335e-17,   2.923590169033285e-18,  -1.926166348505092e-19,   3.947366957771040e-21,  -6.236429892431774e-04,   1.751593883088251e-05,
  -3.394394387417477e-07,   3.866926894639553e-09,   5.048945879649966e-11,  -3.939373865095946e-12,   6.287100684637818e-14,   2.711346025864502e-15,  -1.861012521926416e-16,
   3.981253091145291e-18,  -5.766463661630049e-04,   1.619605681972706e-05,  -3.138384089701478e-07,   3.573710063451336e-09,   4.672393671278674e-11,  -3.639888984163907e-12,
   5.790389090500217e-14,   2.513117571089268e-15,  -1.719401276793216e-16,   3.664474415273518e-18,  -4.897989481360204e-04,   1.375692726640442e-05,  -2.665419480126138e-07,
   3.032956263610173e-09,   3.974153049698688e-11,  -3.088032692452212e-12,   4.886364003711041e-14,   2.143087796403214e-15,  -1.458525604124349e-16,   3.089219161444898e-18,
  -3.763123369074029e-04,   1.056954117740723e-05,  -2.047596373370307e-07,   2.328161963461015e-09,   3.057770794080798e-11,  -2.369543253216509e-12,   3.728170206771229e-14,
   1.653401205327361e-15,  -1.119006503996492e-16,   2.354416789063595e-18,  -2.534604628863425e-04,   7.119034700961648e-06,  -1.379003324278705e-07,   1.567014678061346e-09,
   2.061862521538799e-11,  -1.594387458462119e-12,   2.497280387993507e-14,   1.117251831504498e-15,  -7.528502132694440e-17,   1.575707103629431e-18,  -1.399506985925757e-04,
   3.930862066752331e-06,  -7.613890070082094e-08,   8.648955726608535e-10,   1.139221153926122e-11,  -8.798498002018669e-13,   1.374508760904651e-14,   6.180529182592852e-16,
  -4.154238362918535e-17,   8.668312157822364e-19,  -5.307053636423961e-05,   1.490619863862260e-06,  -2.887195290209820e-08,   3.279266032737853e-10,   4.321083956359335e-12,
  -3.335745417176079e-13,   5.206009793282030e-15,   2.345347858556246e-16,  -1.574938530566053e-17,   3.282528829331470e-19,  -6.050759055712054e-06,   1.699508737591841e-07,
  -3.291782078147173e-09,   3.738713507934061e-11,   4.926819940247987e-13,  -3.803064449135840e-14,   5.934374611211423e-16,   2.674323016549944e-17,  -1.795570114217277e-18,
   3.741662999060145e-20,  -1.761075113770460e-03,   4.942404861912239e-05,  -9.528039573937267e-07,   1.042645537579315e-08,   1.711062354790759e-10,  -1.223503931922532e-11,
   2.019801063137713e-13,   7.767147973161480e-15,  -5.567167084560856e-16,   1.233947670032998e-17,  -1.628363372838111e-03,   4.569972375888088e-05,  -8.809342855488045e-07,
   9.635144035558110e-09,   1.583381279797863e-10,  -1.130549148239299e-11,   1.860728730795273e-13,   7.200746260678226e-15,  -5.143866176176583e-16,   1.135956336507330e-17,
  -1.383118845440381e-03,   3.881724545151188e-05,  -7.481638015403232e-07,   8.176223019794554e-09,   1.346665407062349e-10,  -9.592266876622450e-12,   1.570923788025624e-13,
   6.142540174540304e-15,  -4.363866847225661e-16,   9.578984156010168e-18,  -1.062649359755900e-03,   2.982348108930240e-05,  -5.747365167214712e-07,   6.275439984472622e-09,
   1.036066405112362e-10,  -7.361129802657888e-12,   1.199149122166921e-13,   4.740637342246452e-15,  -3.348403089675656e-16,   7.302702155183942e-18,  -7.157340127824682e-04,
   2.008734152848463e-05,  -3.870655223186532e-07,   4.223380857204648e-09,   6.985815592772000e-11,  -4.953425363965244e-12,   8.035451965542018e-14,   3.204252835980920e-15,
  -2.252948056403284e-16,   4.888534083790855e-18,  -3.951995555441467e-04,   1.109145879726575e-05,  -2.137089634009894e-07,   2.330910244715444e-09,   3.859677303010152e-11,
  -2.733623768662911e-12,   4.423711021889581e-14,   1.772835936333259e-15,  -1.243241849183888e-16,   2.689660676157722e-18,  -1.498631417103824e-04,   4.205983710308016e-06,
  -8.103845535234577e-08,   8.837491725070593e-10,   1.46396