INCLUDE(CheckCXXCompilerFlag)

FUNCTION(BtAddCxxCompilerFlags target)
    SET(REQUIRED FALSE)
    SET(VISIBILITY "")
    FOREACH(arg IN LISTS ARGN)
        IF ("${arg}" MATCHES "^-")
            IF("${VISIBILITY}" STREQUAL "")
                MESSAGE(FATAL_ERROR "Visibility not specified!")
            ENDIF()
            STRING(SUBSTRING "${arg}" 1 -1 FlagName)
            STRING(REPLACE "+" "--plus--" FlagName "${FlagName}")
            CHECK_CXX_COMPILER_FLAG("${arg}"
                                    "cxx_compiler_has_flag_${FlagName}")
            IF("${cxx_compiler_has_flag_${FlagName}}")
                TARGET_COMPILE_OPTIONS("${target}" "${VISIBILITY}" "${arg}")
            ELSEIF("${REQUIRED}")
                MESSAGE(FATAL_ERROR "The compiler does not support \"${arg}\"!")
            ENDIF()
        ELSEIF("${arg}" MATCHES "^(INTERFACE|PUBLIC|PRIVATE)$")
            SET(VISIBILITY "${arg}")
        ELSEIF("${arg}" STREQUAL "REQUIRED")
            SET(REQUIRED TRUE)
        ELSEIF("${arg}" STREQUAL "OPTIONAL")
            SET(REQUIRED FALSE)
        ELSE()
            MESSAGE(FATAL_ERROR "Unsupported argument: ${arg}")
        ENDIF()
    ENDFOREACH()
ENDFUNCTION()
