;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; NOTE: This test was ported using port_passes_tests_to_lit.py and could be cleaned up.

;; RUN: foreach %s %t wasm-opt --simplify-globals -all -S -o - | filecheck %s

;; Apply constant globals to segment offsets. The non-imported global.gets will
;; be applied in the segments named $use-defined.

(module
  ;; CHECK:      (type $0 (func))

  ;; CHECK:      (import "env" "memory" (memory $memory 256))
  (import "env" "memory" (memory $memory 256))

  ;; CHECK:      (import "env" "table" (table $table 0 funcref))
  (import "env" "table" (table $table 0 funcref))

  ;; CHECK:      (import "env" "imported" (global $imported i32))
  (import "env" "imported" (global $imported i32))

  ;; CHECK:      (global $defined i32 (i32.const 42))
  (global $defined i32 (i32.const 42))

  ;; CHECK:      (global $use-defined i32 (i32.const 42))
  (global $use-defined i32 (global.get $defined))

  ;; CHECK:      (data $use-imported (global.get $imported) "hello, world!")
  (data $use-imported (global.get $imported) "hello, world!")

  ;; CHECK:      (data $use-defined (i32.const 42) "hello, world!")
  (data $use-defined (global.get $defined) "hello, world!")

  ;; A passive segment has no offset to test, which we should not error on.
  ;; CHECK:      (data $dropped "hello, world!")
  (data $dropped "hello, world!")

  ;; CHECK:      (elem $use-imported (global.get $imported) $func)
  (elem $use-imported (global.get $imported) $func)

  ;; CHECK:      (elem $use-defined (i32.const 42) $func $func)
  (elem $use-defined (global.get $defined) $func $func)

  ;; CHECK:      (export "func" (func $func))
  (export "func" (func $func))

  ;; CHECK:      (func $func (type $0)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.load
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (table.get $table
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (global.get $imported)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.const 42)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (data.drop $dropped)
  ;; CHECK-NEXT: )
  (func $func
    ;; Use things to avoid DCE.
    (drop
      (i32.load
        (i32.const 0)
      )
    )
    (drop
      (table.get $table
        (i32.const 0)
      )
    )
    (drop
      (global.get $imported)
    )
    (drop
      (global.get $use-defined)
    )
    (data.drop $dropped)
  )
)
