//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Support/Util/String.h
//! @brief     Defines functions from namespace GUI::Util::String
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_SUPPORT_UTIL_STRING_H
#define BORNAGAIN_GUI_SUPPORT_UTIL_STRING_H

#include <QString>
#include <vector>

namespace GUI::Util::String {

//! Returns a name suggestion based on the given name.
//!
//! Tries to add a reasonable numbering in brackets if necessary (e.g. "GISAS" -> "GISAS (2)")
QString suggestName(const QStringList& existingNames, const QString& name);

QStringList fromStdStrings(const std::vector<std::string>& container);

QString readTextFile(const QString& fileName);

} // namespace GUI::Util::String

#endif // BORNAGAIN_GUI_SUPPORT_UTIL_STRING_H
