+++
title = "Detector resolution function"
weight = 20
+++

### Detector resolution function

By default, the detector has perfect resolution.
Here we show how to set a finite blur.

* The detector resolution function is a two-dimensional Gaussian with the same width for the $x$ and $y$ axes: $\sigma\_x = \sigma\_y = 0.0025^{\circ}$.
* The wavelength is equal to 0.1 nm.
* The incident angles are $\sigma_{\alpha\_i} = \sigma\_{\varphi\_i} = 0.1^{\circ}$.

Besides this, the example is a DWBA simulation for our standard sample model,
 [Cylinders in DWBA](/ex/sim/gisas)

* The sample is composed of monodisperse cylinders deposited on a substrate.
* The cylinders are dilute, and positioned at random,
  hence there is no interference between scattered waves.

{{< galleryscg >}}
{{< figscg src="/img/auto/scatter2d/DetectorResolutionFunction.png" width="350px" caption="Intensity image">}}
{{< /galleryscg >}}

{{< show-ex file="scatter2d/DetectorResolutionFunction.py" >}}
