;;;-*- Mode:LISP; Package:CHAOS; Base:10; Syntax:Common-lisp -*-
;;;
;;; Copyright (c) 2000-2015, Toshimi Sawada. All rights reserved.
;;;
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;;
;;;   * Redistributions of source code must retain the above copyright
;;;     notice, this list of conditions and the following disclaimer.
;;;
;;;   * Redistributions in binary form must reproduce the above
;;;     copyright notice, this list of conditions and the following
;;;     disclaimer in the documentation and/or other materials
;;;     provided with the distribution.
;;;
;;; THIS SOFTWARE IS PROVIDED BY THE AUTHOR 'AS IS' AND ANY EXPRESSED
;;; OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
;;; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
;;; DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
;;; GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
;;; INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
;;; WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
;;; NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
;;; SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;;;
(in-package :chaos)
#|==============================================================================
                               System: CHAOS
                              Module: cafeobj
                           File: trans-form.lisp
==============================================================================|#
#-:chaos-debug
(declaim (optimize (speed 3) (safety 0) #-GCL (debug 0)))
#+:chaos-debug
(declaim (optimize (speed 1) (safety 3) #-GCL (debug 3)))

;;; ****************************
;;; CafeOBJ => Chaos translation________________________________________________
;;; ****************************

(defun cafeobj-2-chaos-proc (inp)
  (let* ((args (cadr inp))
         (from (car args))
         (to (cadr args)))
    (if to
        (cafeobj2chaos from to)
      (cafeobj2chaos from *standard-output*))
    ))


(defun cafeobj2chaos (in-file o-file)
  (if (streamp o-file)
      (chaos-input-file :file in-file
                        :proc 'cafeobj->chaos
                        :args `(,in-file ,o-file))
    (with-open-file (port o-file :direction :output
                     :if-does-not-exist :create
                     :if-exists :supersede)
      (chaos-input-file :file in-file :proc 'cafeobj->chaos :args `(,in-file ,port)))
    ))

(defun cafeobj->chaos (in-file &optional (port *standard-output*))
  (let ((*print-case* :downcase)
        (*chaos-quiet* t)
        (*eval-ast* nil)
        (*dribble-ast* t)
        (*dribble-stream* port)
        (quit-flag nil))
    (princ *chaos-binary-magic* port)
    (format port "~&;;; this file is generated by CafeOBJ to Chaos converter version 1.2")
    (format port "~&;;; creation date = ~a" (get-time-string))
    (format port "~%;;; source file   = ~a" in-file)
    ;; (format port "~%;;; target file   = ~a" o-file)
    (format port "~&(in-package :chaos)~%")
    (loop (catch *top-level-tag*
            (process-cafeobj-input)
            (setq quit-flag t))
      (when quit-flag (return)))
    (force-output port)))


;;; EOF
