# Chef Infra Development Documentation

This directory contains a collection of useful how-to guides for both new and seasoned Chef contributors. There are many guides explaining how to build, test, and contribute to Chef Infra, as well as documents describing how the many subsystems function.

A good first start is our [How Chef Infra Is Built](./design_documents/how_chef_is_tested_and_built.md) and [Chef Infra Release and Support Schedule](./policy/release_and_support_schedule.md)

## How-To Guides

- [Building and Installing Locally](./how_to/building_and_installing.md)
- [Branching and Backporting Changes](./how_to/branching_and_backporting.md)
- [Updating Dependencies](./how_to/updating_dependencies.md)
- [Bumping Major and Minor Versions](./how_to/bumping_minor_or_major_versions.md)

## Design Documents

- [Client Release Cadence](./design_documents/client_release_cadence.md)
- [Data Collection](./design_documents/data_collector.md)
- [Action Collection](./design_documents/action_collection.md)
- [Deprecations Within Resources](./design_documents/deprecations_in_resources.md)
- [Resource Guard Interpreters](./design_documents/resource_guard_interpreters.md)
- [Resource Load and Converge Methods](./design_documents/resource_load_and_converge_methods.md)
- [Resource Property Validation Messaging](./design_documents/resource_property_validation_messaging.md)
- [Self Documenting Resources](./design_documents/self_documenting_resources.md)
- [Resource Before Notifications](./design_documents/resource_before_notifications.md)
- [Resource File Content Verification](./design_documents/resource_file_content_verification.md)
- [Ohai Cookbook Segment](./design_documents/ohai_cookbook_segment.md)
- [Cookbook Root Aliases](./design_documents/cookbook_root_aliases.md)
- [Event Handler Recipe DSL](./design_documents/event_handler_recipe_dsl.md)
- [Gem Installation via Metadata](./design_documents/gem_installation_via_metadata.md)
- [Client Exit Codes](./design_documents/client_exit_codes.md)
- [Server Enforced Recipes](./design_documents/server_enforced_recipes.md)
