CREATE OR REPLACE TRIGGER bubs_tak_ard
/* ***************************************************************************
 *
 * Trigger: bubs_tak_ard
 *
 * After row delete trigger to maintain history for the table bubs_taken.
 *
 * Generated by Invantive Producer.
 *
 * (C) Copyright 2004-2017 Invantive Software BV, the Netherlands. All rights reserved.
 *
 * ***************************************************************************/
after delete
on bubs_taken
for each row
declare
  l_effective date;
  l_anti_date boolean;
  l_dummy     pls_integer;
begin
  if true /* History is enabled. */ 
  then
    l_effective := itgen_history.get_effective_date('bubs_taken', 'D', l_anti_date);
    if l_anti_date
    then
      --
      -- Check that there are no more recent mutations.
      --
      begin
        select 1
        into   l_dummy
        from   bubshtaken
        where  h_datum_start  > l_effective
        and    id =:old.id
        ;
        bubs_error_handler.handle_error
        ( '{res:bubs_anti_date_not_possible_before_later_history'
          || '?bubshtaken'
          || '&' || to_char(:old.id)
          || '}'
        , p_are_code  => 'takitg025'
        , p_top_error => null
        );
      exception
        when no_data_found
        then
          null;
        when too_many_rows
        then
          bubs_error_handler.handle_error
          ( '{res:bubs_anti_date_not_possible_before_later_history'
            || '?bubshtaken'
            || '&' || to_char(:old.id)
            || '}'
          , p_are_code  => 'takitg026'
          , p_top_error => null
          );
      end;
    end if;
    --
    update bubshtaken
    set    h_datum_einde = l_effective-1/86400
    ,      h_actief_als_gevuld = null
    where  /* Allow use of index. */ case when h_actief_als_gevuld is not null then id else null end = :old.id
    and    h_datum_einde = to_date('99991231', 'YYYYMMDD')
    and    h_actief_als_gevuld = 'J' /* For performance. */
    ;
    if sql%rowcount <> 1
    then
      bubs_error_handler.handle_error
      ( '{res:bubs_could_not_finish_history'
        || '?bubshtaken'
        || '&' || to_char(:old.id)
        || '&' || sql%rowcount
        || '}'
      , p_are_code  => 'takitg027'
      , p_top_error => null
      );
    end if;
  end if;
end;
/