% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbDisconnect.R
\name{dbDisconnect}
\alias{dbDisconnect}
\title{Disconnect (close) a connection}
\usage{
dbDisconnect(conn, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbDisconnect()} returns \code{TRUE}, invisibly.
}
\description{
This closes the connection, discards all pending work, and frees
resources (e.g., memory, sockets).

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbDisconnect")}
}
\section{Failure modes}{


A warning is issued on garbage collection when a connection has been
released without calling \code{dbDisconnect()},
but this cannot be tested automatically.
A warning is issued immediately when calling \code{dbDisconnect()} on an
already disconnected
or invalid connection.

}

\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
con <- dbConnect(RSQLite::SQLite(), ":memory:")
dbDisconnect(con)
\dontshow{\}) # examplesIf}
}
\seealso{
Other DBIConnection generics: 
\code{\link{DBIConnection-class}},
\code{\link{dbAppendTable}()},
\code{\link{dbAppendTableArrow}()},
\code{\link{dbCreateTable}()},
\code{\link{dbCreateTableArrow}()},
\code{\link{dbDataType}()},
\code{\link{dbExecute}()},
\code{\link{dbExistsTable}()},
\code{\link{dbGetException}()},
\code{\link{dbGetInfo}()},
\code{\link{dbGetQuery}()},
\code{\link{dbGetQueryArrow}()},
\code{\link{dbIsReadOnly}()},
\code{\link{dbIsValid}()},
\code{\link{dbListFields}()},
\code{\link{dbListObjects}()},
\code{\link{dbListResults}()},
\code{\link{dbListTables}()},
\code{\link{dbQuoteIdentifier}()},
\code{\link{dbReadTable}()},
\code{\link{dbReadTableArrow}()},
\code{\link{dbRemoveTable}()},
\code{\link{dbSendQuery}()},
\code{\link{dbSendQueryArrow}()},
\code{\link{dbSendStatement}()},
\code{\link{dbUnquoteIdentifier}()},
\code{\link{dbWriteTable}()},
\code{\link{dbWriteTableArrow}()}
}
\concept{DBIConnection generics}
