#include "mainwindow.h"
#include "filelog.h"

#include "rpcdriver/rpcdriver.h"

#include <QApplication>
#include <QMessageBox>

#include <string>
#include <iostream>
#include <boost/program_options.hpp>
namespace opt = boost::program_options;

using std::string;

Log* logger = new FileLog;

int main(int argc, char *argv[])
{
	opt::options_description desc("Allowed options");
	desc.add_options()
		("help", 
		 "Display help message")
		("addr", 
		 opt::value<string>()->default_value("localhost"),
		 "Address to connect to")
		("port", 
		 opt::value<int>()->default_value(6161), 
		 "Specify port");
	
	opt::variables_map vm;
	
	try {
		opt::store(opt::parse_command_line(argc, argv, desc), vm);
	}
	catch( const opt::unknown_option& e ) {
		std::cerr << "Invalid option " << e.what() << std::endl;
	}
	
	if(vm.count("help")) {
		std::cout << desc << std::endl;
		return 1;
	}
	
	QApplication app(argc, argv);
	MainWindow *mw = new MainWindow;
	
	mw->show();
	//mw->connectToBackend(vm["addr"].as<string>().c_str(), port);
	// TODO use the above function instead if parameters was actually given -> overrides settings.
	mw->connectToBackend();
	return app.exec();
}

