/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

#ifndef _FONT
#define _FONT

#include "dingl.h"
#include "glyph.h"

#include <string>
#include <fstream>
#include <map>

struct font {

  std::string fname;
  std::string name;

  int nchars;
  
  int max_char_width, max_char_height;
  
  int avg_char_width, avg_char_height;

  int xsize, ysize; // x and y size of cell
  
  int lift;
    
  int charspc, wordspc;

  int headroom; // space above char

  std::map <char, glyph> characters; // vector desc of chars

  std::map < char, std::map<char, int> > kern; // char-char kerning

  int modified; // if modified will save

  font (const std::string& fn);
  ~font ();
  void load (const std::string& fn);
  void load (std::ifstream& file);
  void save ();

  int char_width (char c);
  int char_height (char c);

  void draw_char (char c, int x, int y, int z = 0);
  const std::string& filename () const { return fname;}

  const std::map<char, glyph>& get_chars ();
  void set_chars (const std::map<char, glyph>& chars);

};

extern font fnt;

inline int get_line_height () {
  return (fnt.max_char_height + fnt.headroom);
}

inline void draw_char (char c, int x, int y, int z = 0) {
  fnt.draw_char (c, x, y, z);
}

void write_buffer (char* format, ...);
int draw_string (const std::string& s, int x, int y, int z = 0);

int get_char_width (const std::string& s);
int get_max_char_height (const std::string& s);

#endif
