/* doscan - Denial Of Service Capable Auditing of Networks
 * Copyright (C) 2003 Florian Weimer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SUBNETS_H
#define SUBNETS_H

#include "ipv4.h"

#include <vector>

class subnets {
  typedef std::vector<ipv4_prefix_t> prefix_vector;
  prefix_vector prefixes;

  ipv4_t current_address;
  prefix_vector::iterator next_prefix;
  ipv4_t next_address;

  unsigned processed;
  unsigned total;

  void compute_next_address (void);
  void show_progress (void);

  // update_next_prefix() is called after prefixes has been changed.

  void update_next_prefix();

 public:
  subnets();


  // Registers the given subnet.  On error, a message is printed to
  // standard error, and false is returned.

  bool add(const char *s);

  // Registers the listed subnets.  List is terminated by a null
  // pointer.  Prints a message and bails out if an error is
  // encountered.

  void add(char **, unsigned count);

  // Registers the subnets listed in the named file. Prints a message
  // to standard error and bails out if an error is encountered.

  void add_file(const char *);

  // Randomizes the list of subnets.

  void shuffle();

  // Returns true if no more addresses are to be processed.

  bool finished();

  //  Returns the next address to be processed.  Aborts is if
  //  subnets_finished() is true.

  ipv4_t next();

  // Returns the total number of hosts which have been processed so
  // far.

  unsigned hosts_processed();

  // Returns the total number of hosts which has to be processed.

  unsigned hosts_total (void);
};

inline unsigned
subnets::hosts_processed (void)
{
  return processed;
}

inline unsigned
subnets::hosts_total (void)
{
  return total;
}

#endif

// arch-tag: b8ead25a-3e40-498b-84d6-427849d4df66
