/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.DAS;
import dods.dap.DList;
import dods.dap.PrimitiveVector;
import java.rmi.RemoteException;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealType;
import visad.SimpleSet;
import visad.VisADException;
import visad.data.FileFlatField;
import visad.data.dods.VariableAdapter;
import visad.data.dods.VariableAdapterFactory;
import visad.data.dods.VectorAccessor;
import visad.data.dods.VectorAdapter;

public class ListVariableAdapter
extends VariableAdapter {
    private final FunctionType funcType;
    private final VectorAdapter vectorAdapter;

    private ListVariableAdapter(DList list, DAS das, VariableAdapterFactory factory) throws VisADException, RemoteException {
        this.vectorAdapter = factory.vectorAdapter(list.getPrimitiveVector(), das);
        this.funcType = new FunctionType(RealType.Generic, this.vectorAdapter.getMathType());
    }

    public static ListVariableAdapter listVariableAdapter(DList list, DAS das, VariableAdapterFactory factory) throws VisADException, RemoteException {
        return new ListVariableAdapter(list, das, factory);
    }

    public MathType getMathType() {
        return this.funcType;
    }

    public SimpleSet[] getRepresentationalSets(boolean copy) {
        return this.vectorAdapter.getRepresentationalSets(copy);
    }

    public DataImpl data(DList list, boolean copy) throws VisADException, RemoteException {
        FieldImpl field;
        Integer1DSet domain = new Integer1DSet(list.getLength());
        PrimitiveVector vector = list.getPrimitiveVector();
        if (this.funcType.getFlat()) {
            field = new FileFlatField(new VectorAccessor(this.funcType, this.vectorAdapter, domain, vector), this.getCacheStrategy());
        } else {
            field = new FieldImpl(this.funcType, domain);
            this.vectorAdapter.setField(vector, field, copy);
        }
        return field;
    }
}

