#include <ffgtk.h>
#include <osdep.h>

/**
 * \brief Execute URI
 * \param pnUri uri name
 */
void osExecute( const gchar *pnUri ) {
	gchar *pnExec = NULL;

	/* create execution command line for g_spawn */
	pnExec = g_strdup_printf( "%s %s", OS_OPEN, pnUri );

#ifdef G_OS_WIN32
#include <shellapi.h>
	ShellExecute(0, "open", pnUri, 0, 0, SW_SHOW);
#else
	g_spawn_command_line_async( pnExec, NULL );
#endif

	/* free command line */
	g_free( pnExec );
}
