# Copyright 2010 Mackenzie Morgan <maco.m@ubuntu.com>
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

class Lesson():

    def __init__(self, lessonNum, subject, dir):
        self.lessonNum = lessonNum
        self.subject = subject
        self.dir = dir
        self._signs = []
        self._intro = ""
        self.current = 0

    @property
    def intro(self):
        return self._intro

    @intro.setter
    def intro(self,string):
        self._intro = string

    @property
    def signs(self):
        """ Return a list of signs found in given lesson. """
        return self._signs
    @signs.setter
    def signs(self, signs):
        """ Set lesson's list of signs to given dictionary. """
        self._signs = signs
        self.current = 0

    @property
    def quiz(self, quiz):
        self._quiz = quiz

    def numSigns(self):
        """ Returns number of signs in lesson """
        return len(self.__signs)

class Sign():
    def __init__(self, name, displayType, hasContext, context, filename, text):
        self.name = name
        self._type = displayType
        self.hasContext = hasContext
        self.context = context
        self.filename = filename
        self._text = text

    @property
    def displayType(self, dis):
        self._type = dis
    @displayType.getter
    def displayType(self):
        return self._type
    
    @property
    def text(self):
        return self._text
