-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/contents_manager-gui.ads,v $
--  Description     : Representation of the base document                    --
--  Author          : Michael Erdmann                                        --
--  Created         : 8.8.2001                                               --
--  Last Modified By: $Author: me $
--  Last Modified On: $Date: 2001/09/21 20:47:30 $
--  Status          : $State: Exp $
--                                                                           --
--  Copyright (C) 2000 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --

--                                                                           --
--                                                                           --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--                                                                           --
--                                                                           --
--                                                                           --
-------------------------------------------------------------------------------
with Gtk.Box;                  use Gtk.Box;
with Contents_Handler;         use Contents_Handler;
with Contents_Manager;         use Contents_Manager;
with Ada.Strings.Unbounded;    use Ada.Strings.Unbounded;

package Contents_Manager.GUI is

   Last_Selected : Element_ID := Null_Element_ID;

   -- add the component tree to the GUI
   procedure Show_Table_Of_Contents(
      Hbox : in out Gtk_Box );

   -- add a section
   function Add_Element(
      Title   : in String;
      Parent  : in Element_ID := Null_Element_ID;
      Content : in Contents_Handler.Handle := null ) return Element_ID;

   procedure Delete_Element(
      Id      : in Element_ID );

end Contents_Manager.GUI;
